/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.sender;

import com.cloudbees.syslog.SyslogMessage;
import com.cloudbees.syslog.sender.AbstractSyslogMessageSender;
import com.cloudbees.syslog.util.CachingReference;
import com.cloudbees.syslog.util.IoUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@ThreadSafe
public class TcpSyslogMessageSender
extends AbstractSyslogMessageSender
implements Closeable {
    public static final int SETTING_SOCKET_CONNECT_TIMEOUT_IN_MILLIS_DEFAULT_VALUE = 500;
    public static final int SETTING_MAX_RETRY = 2;
    protected CachingReference<InetAddress> syslogServerHostnameReference;
    protected int syslogServerPort = 514;
    private Socket socket;
    private Writer writer;
    private int socketConnectTimeoutInMillis = 500;
    private boolean ssl;
    private SSLContext sslContext;
    private int maxRetryCount = 2;
    protected final AtomicInteger trySendErrorCounter = new AtomicInteger();
    private String postfix = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendMessage(@Nonnull SyslogMessage message) throws IOException {
        block11: {
            this.sendCounter.incrementAndGet();
            long nanosBefore = System.nanoTime();
            Exception lastException = null;
            for (int i2 = 0; i2 <= this.maxRetryCount; ++i2) {
                try {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("Send syslog message " + message.toSyslogMessage(this.messageFormat));
                    }
                    this.ensureSyslogServerConnection();
                    message.toSyslogMessage(this.messageFormat, this.writer);
                    this.writer.write(this.postfix);
                    this.writer.flush();
                    return;
                }
                catch (IOException e2) {
                    lastException = e2;
                    IoUtils.closeQuietly(this.socket, this.writer);
                    this.trySendErrorCounter.incrementAndGet();
                    continue;
                }
                catch (RuntimeException e3) {
                    lastException = e3;
                    IoUtils.closeQuietly(this.socket, this.writer);
                    this.trySendErrorCounter.incrementAndGet();
                }
                {
                    continue;
                }
            }
            if (lastException == null) break block11;
            this.sendErrorCounter.incrementAndGet();
            if (lastException instanceof IOException) {
                throw (IOException)lastException;
            }
            if (lastException instanceof RuntimeException) {
                throw lastException;
            }
            break block11;
            finally {
                this.sendDurationInNanosCounter.addAndGet(System.nanoTime() - nanosBefore);
            }
        }
    }

    private synchronized void ensureSyslogServerConnection() throws IOException {
        boolean socketIsValid;
        InetAddress inetAddress = this.syslogServerHostnameReference.get();
        if (this.socket != null && !Objects.equals(this.socket.getInetAddress(), inetAddress)) {
            this.logger.info("InetAddress of the Syslog Server have changed, create a new connection. Before=" + this.socket.getInetAddress() + ", new=" + inetAddress);
            IoUtils.closeQuietly(this.socket, this.writer);
            this.writer = null;
            this.socket = null;
        }
        try {
            socketIsValid = this.socket != null && this.socket.isConnected() && this.socket.isBound() && !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
        }
        catch (Exception e2) {
            socketIsValid = false;
        }
        if (!socketIsValid) {
            this.writer = null;
            try {
                this.socket = this.ssl ? (this.sslContext == null ? SSLSocketFactory.getDefault().createSocket() : this.sslContext.getSocketFactory().createSocket()) : SocketFactory.getDefault().createSocket();
                this.socket.setKeepAlive(true);
                this.socket.connect(new InetSocketAddress(inetAddress, this.syslogServerPort), this.socketConnectTimeoutInMillis);
                if (this.socket instanceof SSLSocket && this.logger.isLoggable(Level.FINER)) {
                    try {
                        SSLSocket sslSocket = (SSLSocket)this.socket;
                        SSLSession session = sslSocket.getSession();
                        this.logger.finer("The Certificates used by peer");
                        for (Certificate certificate : session.getPeerCertificates()) {
                            if (certificate instanceof X509Certificate) {
                                X509Certificate x509Certificate = (X509Certificate)certificate;
                                this.logger.finer("" + x509Certificate.getSubjectDN());
                                continue;
                            }
                            this.logger.finer("" + certificate);
                        }
                        this.logger.finer("Peer host is " + session.getPeerHost());
                        this.logger.finer("Cipher is " + session.getCipherSuite());
                        this.logger.finer("Protocol is " + session.getProtocol());
                        this.logger.finer("ID is " + new BigInteger(session.getId()));
                        this.logger.finer("Session created in " + session.getCreationTime());
                        this.logger.finer("Session accessed in " + session.getLastAccessedTime());
                    }
                    catch (Exception e3) {
                        this.logger.warn("Exception dumping debug info for " + this.socket, e3);
                    }
                }
            }
            catch (IOException e4) {
                ConnectException ce2 = new ConnectException("Exception connecting to " + inetAddress + ":" + this.syslogServerPort);
                ce2.initCause(e4);
                throw ce2;
            }
        }
        if (this.writer == null) {
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), UTF_8));
        }
    }

    @Override
    public void setSyslogServerHostname(final String syslogServerHostname) {
        this.syslogServerHostnameReference = new CachingReference<InetAddress>(DEFAULT_INET_ADDRESS_TTL_IN_NANOS){

            @Override
            @Nullable
            protected InetAddress newObject() {
                try {
                    return InetAddress.getByName(syslogServerHostname);
                }
                catch (UnknownHostException e2) {
                    throw new IllegalStateException(e2);
                }
            }
        };
    }

    @Override
    public void setSyslogServerPort(int syslogServerPort) {
        this.syslogServerPort = syslogServerPort;
    }

    @Nullable
    public String getSyslogServerHostname() {
        if (this.syslogServerHostnameReference == null) {
            return null;
        }
        InetAddress inetAddress = this.syslogServerHostnameReference.get();
        return inetAddress == null ? null : inetAddress.getHostName();
    }

    public int getSyslogServerPort() {
        return this.syslogServerPort;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public synchronized void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public synchronized SSLContext getSSLContext() {
        return this.sslContext;
    }

    public int getSocketConnectTimeoutInMillis() {
        return this.socketConnectTimeoutInMillis;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public int getTrySendErrorCounter() {
        return this.trySendErrorCounter.get();
    }

    public void setSocketConnectTimeoutInMillis(int socketConnectTimeoutInMillis) {
        this.socketConnectTimeoutInMillis = socketConnectTimeoutInMillis;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public synchronized void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{syslogServerHostname='" + this.getSyslogServerHostname() + '\'' + ", syslogServerPort='" + this.getSyslogServerPort() + '\'' + ", ssl=" + this.ssl + ", maxRetryCount=" + this.maxRetryCount + ", socketConnectTimeoutInMillis=" + this.socketConnectTimeoutInMillis + ", defaultAppName='" + this.defaultAppName + '\'' + ", defaultFacility=" + this.defaultFacility + ", defaultMessageHostname='" + this.defaultMessageHostname + '\'' + ", defaultSeverity=" + (Object)((Object)this.defaultSeverity) + ", messageFormat=" + (Object)((Object)this.messageFormat) + ", sendCounter=" + this.sendCounter + ", sendDurationInNanosCounter=" + this.sendDurationInNanosCounter + ", sendErrorCounter=" + this.sendErrorCounter + ", trySendErrorCounter=" + this.trySendErrorCounter + '}';
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

