/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.integration.jul.util;

import com.cloudbees.syslog.integration.jul.util.LevelHelper;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LogManagerHelper {
    @Nullable
    public static Level getLevelProperty(@Nonnull LogManager manager, @Nonnull String name, @Nullable Level defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        Level l2 = LevelHelper.findLevel(val.trim());
        return l2 != null ? l2 : defaultValue;
    }

    @Nullable
    public static Filter getFilterProperty(@Nonnull LogManager manager, @Nullable String name, @Nullable Filter defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static Formatter getFormatterProperty(@Nonnull LogManager manager, @Nullable String name, @Nullable Formatter defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static String getStringProperty(@Nonnull LogManager manager, @Nullable String name, String defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    public static int getIntProperty(@Nonnull LogManager manager, @Nullable String name, int defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex2) {
            return defaultValue;
        }
    }

    public static boolean getBooleanProperty(@Nonnull LogManager manager, @Nullable String name, boolean defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }
}

