/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google$.common.base;

import autovalue.shaded.com.google$.common.annotations.$GwtCompatible;
import autovalue.shaded.com.google$.common.annotations.$VisibleForTesting;
import autovalue.shaded.com.google$.common.base.$Platform;
import autovalue.shaded.com.google$.common.base.$Preconditions;
import autovalue.shaded.org.checkerframework;
import java.util.logging.Level;
import java.util.logging.Logger;

@$GwtCompatible
public final class $Strings {
    private $Strings() {
    }

    public static String nullToEmpty(@checkerframework..Nullable String string) {
        return $Platform.nullToEmpty(string);
    }

    public static @checkerframework..Nullable String emptyToNull(@checkerframework..Nullable String string) {
        return $Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(@checkerframework..Nullable String string) {
        return $Platform.stringIsNullOrEmpty(string);
    }

    public static String padStart(String string, int minLength, char padChar) {
        $Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i2 = string.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        $Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i2 = string.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string, int count) {
        int n2;
        $Preconditions.checkNotNull(string);
        if (count <= 1) {
            $Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
            return count == 0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(51).append("Required array size too large: ").append(longSize).toString());
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n2 = len; n2 < size - n2; n2 <<= 1) {
            System.arraycopy(array, 0, array, n2, n2);
        }
        System.arraycopy(array, 0, array, n2, size - n2);
        return new String(array);
    }

    public static String commonPrefix(CharSequence a2, CharSequence b2) {
        int p2;
        $Preconditions.checkNotNull(a2);
        $Preconditions.checkNotNull(b2);
        int maxPrefixLength = Math.min(a2.length(), b2.length());
        for (p2 = 0; p2 < maxPrefixLength && a2.charAt(p2) == b2.charAt(p2); ++p2) {
        }
        if ($Strings.validSurrogatePairAt(a2, p2 - 1) || $Strings.validSurrogatePairAt(b2, p2 - 1)) {
            --p2;
        }
        return a2.subSequence(0, p2).toString();
    }

    public static String commonSuffix(CharSequence a2, CharSequence b2) {
        int s2;
        $Preconditions.checkNotNull(a2);
        $Preconditions.checkNotNull(b2);
        int maxSuffixLength = Math.min(a2.length(), b2.length());
        for (s2 = 0; s2 < maxSuffixLength && a2.charAt(a2.length() - s2 - 1) == b2.charAt(b2.length() - s2 - 1); ++s2) {
        }
        if ($Strings.validSurrogatePairAt(a2, a2.length() - s2 - 1) || $Strings.validSurrogatePairAt(b2, b2.length() - s2 - 1)) {
            --s2;
        }
        return a2.subSequence(a2.length() - s2, a2.length()).toString();
    }

    @$VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    public static String lenientFormat(@checkerframework..Nullable String template, Object ... args2) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args2 == null) {
            args2 = new Object[]{"(Object[])null"};
        } else {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                args2[i2] = $Strings.lenientToString(args2[i2]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i3 = 0;
        while (i3 < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args2[i3++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i3 < args2.length) {
            builder.append(" [");
            builder.append(args2[i3++]);
            while (i3 < args2.length) {
                builder.append(", ");
                builder.append(args2[i3++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@checkerframework..Nullable Object o2) {
        if (o2 == null) {
            return "null";
        }
        try {
            return o2.toString();
        }
        catch (Exception e2) {
            String string = o2.getClass().getName();
            String string2 = Integer.toHexString(System.identityHashCode(o2));
            String objectToString = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append('@').append(string2).toString();
            String string3 = String.valueOf(objectToString);
            Logger.getLogger("autovalue.shaded.com.google$.common.base.$Strings").log(Level.WARNING, string3.length() != 0 ? "Exception during lenientFormat for ".concat(string3) : new String("Exception during lenientFormat for "), e2);
            string = e2.getClass().getName();
            return new StringBuilder(9 + String.valueOf(objectToString).length() + String.valueOf(string).length()).append("<").append(objectToString).append(" threw ").append(string).append(">").toString();
        }
    }
}

