/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google$.auto.common;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.base.$Objects;
import autovalue.shaded.com.google$.common.base.$Optional;
import autovalue.shaded.com.google$.common.base.$Preconditions;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

public final class $MoreTypes {
    private static final int HASH_SEED = 17;
    private static final int HASH_MULTIPLIER = 31;

    public static $Equivalence<TypeMirror> equivalence() {
        return TypeEquivalence.INSTANCE;
    }

    private static boolean equal(TypeMirror a2, TypeMirror b2, Set<ComparedElements> visiting) {
        if ($Objects.equal(a2, b2) && !(a2 instanceof ExecutableType)) {
            return true;
        }
        EqualVisitorParam p2 = new EqualVisitorParam();
        p2.type = b2;
        p2.visiting = visiting;
        return a2 == b2 || a2 != null && b2 != null && a2.accept(EqualVisitor.INSTANCE, p2) != false;
    }

    private static TypeMirror enclosingType(DeclaredType t2) {
        TypeMirror enclosing = t2.getEnclosingType();
        if (enclosing.getKind().equals((Object)TypeKind.NONE) || t2.asElement().getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        return enclosing;
    }

    private static boolean equalLists(List<? extends TypeMirror> a2, List<? extends TypeMirror> b2, Set<ComparedElements> visiting) {
        int size = a2.size();
        if (size != b2.size()) {
            return false;
        }
        Iterator<? extends TypeMirror> aIterator = a2.iterator();
        Iterator<? extends TypeMirror> bIterator = b2.iterator();
        while (aIterator.hasNext()) {
            TypeMirror nextMirrorB;
            TypeMirror nextMirrorA = aIterator.next();
            if ($MoreTypes.equal(nextMirrorA, nextMirrorB = bIterator.next(), visiting)) continue;
            return false;
        }
        return true;
    }

    private static int hashList(List<? extends TypeMirror> mirrors, Set<Element> visiting) {
        int result = 17;
        for (TypeMirror typeMirror : mirrors) {
            result *= 31;
            result += $MoreTypes.hash(typeMirror, visiting);
        }
        return result;
    }

    private static int hash(TypeMirror mirror, Set<Element> visiting) {
        return mirror == null ? 0 : mirror.accept(HashVisitor.INSTANCE, visiting);
    }

    public static $ImmutableSet<TypeElement> referencedTypes(TypeMirror type) {
        $Preconditions.checkNotNull(type);
        $ImmutableSet.Builder elements = $ImmutableSet.builder();
        type.accept(ReferencedTypes.INSTANCE, elements);
        return elements.build();
    }

    public static Element asElement(TypeMirror typeMirror) {
        return typeMirror.accept(AsElementVisitor.INSTANCE, null);
    }

    public static TypeElement asTypeElement(TypeMirror mirror) {
        return $MoreElements.asType($MoreTypes.asElement(mirror));
    }

    public static $ImmutableSet<TypeElement> asTypeElements(Iterable<? extends TypeMirror> mirrors) {
        $Preconditions.checkNotNull(mirrors);
        $ImmutableSet.Builder builder = $ImmutableSet.builder();
        for (TypeMirror typeMirror : mirrors) {
            builder.add($MoreTypes.asTypeElement(typeMirror));
        }
        return builder.build();
    }

    public static ArrayType asArray(TypeMirror maybeArrayType) {
        return maybeArrayType.accept(ArrayTypeVisitor.INSTANCE, null);
    }

    public static DeclaredType asDeclared(TypeMirror maybeDeclaredType) {
        return maybeDeclaredType.accept(DeclaredTypeVisitor.INSTANCE, null);
    }

    public static ErrorType asError(TypeMirror maybeErrorType) {
        return maybeErrorType.accept(ErrorTypeVisitor.INSTANCE, null);
    }

    public static ExecutableType asExecutable(TypeMirror maybeExecutableType) {
        return maybeExecutableType.accept(ExecutableTypeVisitor.INSTANCE, null);
    }

    public static IntersectionType asIntersection(TypeMirror maybeIntersectionType) {
        return maybeIntersectionType.accept(IntersectionTypeVisitor.INSTANCE, null);
    }

    public static NoType asNoType(TypeMirror maybeNoType) {
        return maybeNoType.accept(NoTypeVisitor.INSTANCE, null);
    }

    public static NullType asNullType(TypeMirror maybeNullType) {
        return maybeNullType.accept(NullTypeVisitor.INSTANCE, null);
    }

    public static PrimitiveType asPrimitiveType(TypeMirror maybePrimitiveType) {
        return maybePrimitiveType.accept(PrimitiveTypeVisitor.INSTANCE, null);
    }

    public static TypeVariable asTypeVariable(TypeMirror maybeTypeVariable) {
        return maybeTypeVariable.accept(TypeVariableVisitor.INSTANCE, null);
    }

    public static WildcardType asWildcard(TypeMirror maybeWildcardType) {
        return maybeWildcardType.accept(WildcardTypeVisitor.INSTANCE, null);
    }

    public static boolean isType(TypeMirror type) {
        return type.accept(IsTypeVisitor.INSTANCE, null);
    }

    public static boolean isTypeOf(Class<?> clazz, TypeMirror type) {
        $Preconditions.checkNotNull(clazz);
        return type.accept(new IsTypeOf(clazz), null);
    }

    public static $Optional<DeclaredType> nonObjectSuperclass(Types types, Elements elements, DeclaredType type) {
        $Preconditions.checkNotNull(types);
        $Preconditions.checkNotNull(elements);
        $Preconditions.checkNotNull(type);
        TypeMirror superclassType = $MoreTypes.asTypeElement(type).getSuperclass();
        if (!$MoreTypes.isType(superclassType)) {
            return $Optional.absent();
        }
        DeclaredType superclass = $MoreTypes.asDeclared(superclassType);
        if ($MoreTypes.isObjectType(superclass)) {
            return $Optional.absent();
        }
        if (superclass.getTypeArguments().isEmpty()) {
            return $Optional.of(superclass);
        }
        return $Optional.of($MoreTypes.asDeclared(types.directSupertypes(type).get(0)));
    }

    private static boolean isObjectType(DeclaredType type) {
        return $MoreTypes.asTypeElement(type).getQualifiedName().contentEquals("java.lang.Object");
    }

    public static TypeMirror asMemberOf(Types types, DeclaredType container, VariableElement variable) {
        if (variable.getKind().equals((Object)ElementKind.PARAMETER)) {
            ExecutableElement methodOrConstructor = $MoreElements.asExecutable(variable.getEnclosingElement());
            ExecutableType resolvedMethodOrConstructor = $MoreTypes.asExecutable(types.asMemberOf(container, methodOrConstructor));
            List<? extends VariableElement> parameters = methodOrConstructor.getParameters();
            List<? extends TypeMirror> parameterTypes = resolvedMethodOrConstructor.getParameterTypes();
            $Preconditions.checkState(parameters.size() == parameterTypes.size());
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                if (!parameters.get(i2).equals(variable)) continue;
                return parameterTypes.get(i2);
            }
            throw new IllegalStateException("Could not find variable: " + variable);
        }
        return types.asMemberOf(container, variable);
    }

    public static boolean isConversionFromObjectUnchecked(TypeMirror type) {
        return (Boolean)new CastingUncheckedVisitor().visit(type, null);
    }

    private $MoreTypes() {
    }

    private static class CastingUncheckedVisitor
    extends SimpleTypeVisitor8<Boolean, Void> {
        CastingUncheckedVisitor() {
            super(false);
        }

        @Override
        public Boolean visitUnknown(TypeMirror t2, Void p2) {
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType t2, Void p2) {
            return (Boolean)this.visit(t2.getComponentType(), p2);
        }

        @Override
        public Boolean visitDeclared(DeclaredType t2, Void p2) {
            return t2.getTypeArguments().stream().anyMatch(CastingUncheckedVisitor::uncheckedTypeArgument);
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable t2, Void p2) {
            return true;
        }

        private static boolean uncheckedTypeArgument(TypeMirror arg) {
            WildcardType wildcard;
            if (arg.getKind().equals((Object)TypeKind.WILDCARD) && ((wildcard = $MoreTypes.asWildcard(arg)).getExtendsBound() == null || CastingUncheckedVisitor.isJavaLangObject(wildcard.getExtendsBound()))) {
                return wildcard.getSuperBound() != null;
            }
            return true;
        }

        private static boolean isJavaLangObject(TypeMirror type) {
            if (type.getKind() != TypeKind.DECLARED) {
                return false;
            }
            TypeElement typeElement = $MoreTypes.asTypeElement(type);
            return typeElement.getQualifiedName().contentEquals("java.lang.Object");
        }
    }

    private static abstract class CastingTypeVisitor<T>
    extends SimpleTypeVisitor8<T, Void> {
        private final String label;

        CastingTypeVisitor(String label) {
            this.label = label;
        }

        @Override
        protected T defaultAction(TypeMirror e2, Void v2) {
            throw new IllegalArgumentException(e2 + " does not represent a " + this.label);
        }
    }

    private static final class IsTypeOf
    extends SimpleTypeVisitor8<Boolean, Void> {
        private final Class<?> clazz;

        IsTypeOf(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void ignored) {
            throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitNoType(NoType noType, Void p2) {
            if (noType.getKind().equals((Object)TypeKind.VOID)) {
                return this.clazz.equals(Void.TYPE);
            }
            throw new IllegalArgumentException(noType + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p2) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    return this.clazz.equals(Boolean.TYPE);
                }
                case BYTE: {
                    return this.clazz.equals(Byte.TYPE);
                }
                case CHAR: {
                    return this.clazz.equals(Character.TYPE);
                }
                case DOUBLE: {
                    return this.clazz.equals(Double.TYPE);
                }
                case FLOAT: {
                    return this.clazz.equals(Float.TYPE);
                }
                case INT: {
                    return this.clazz.equals(Integer.TYPE);
                }
                case LONG: {
                    return this.clazz.equals(Long.TYPE);
                }
                case SHORT: {
                    return this.clazz.equals(Short.TYPE);
                }
            }
            throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitArray(ArrayType array, Void p2) {
            return this.clazz.isArray() && $MoreTypes.isTypeOf(this.clazz.getComponentType(), array.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void ignored) {
            TypeElement typeElement = $MoreElements.asType(type.asElement());
            return typeElement.getQualifiedName().contentEquals(this.clazz.getCanonicalName());
        }
    }

    private static final class IsTypeVisitor
    extends SimpleTypeVisitor8<Boolean, Void> {
        private static final IsTypeVisitor INSTANCE = new IsTypeVisitor();

        private IsTypeVisitor() {
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitNoType(NoType noType, Void p2) {
            return noType.getKind().equals((Object)TypeKind.VOID);
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p2) {
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType array, Void p2) {
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void ignored) {
            return $MoreElements.isType(type.asElement());
        }
    }

    private static final class WildcardTypeVisitor
    extends CastingTypeVisitor<WildcardType> {
        private static final WildcardTypeVisitor INSTANCE = new WildcardTypeVisitor();

        WildcardTypeVisitor() {
            super("wildcard type");
        }

        @Override
        public WildcardType visitWildcard(WildcardType type, Void ignore) {
            return type;
        }
    }

    private static final class TypeVariableVisitor
    extends CastingTypeVisitor<TypeVariable> {
        private static final TypeVariableVisitor INSTANCE = new TypeVariableVisitor();

        TypeVariableVisitor() {
            super("type variable");
        }

        @Override
        public TypeVariable visitTypeVariable(TypeVariable type, Void ignore) {
            return type;
        }
    }

    private static final class PrimitiveTypeVisitor
    extends CastingTypeVisitor<PrimitiveType> {
        private static final PrimitiveTypeVisitor INSTANCE = new PrimitiveTypeVisitor();

        PrimitiveTypeVisitor() {
            super("primitive type");
        }

        @Override
        public PrimitiveType visitPrimitive(PrimitiveType type, Void ignore) {
            return type;
        }
    }

    private static final class NullTypeVisitor
    extends CastingTypeVisitor<NullType> {
        private static final NullTypeVisitor INSTANCE = new NullTypeVisitor();

        NullTypeVisitor() {
            super("null");
        }

        @Override
        public NullType visitNull(NullType type, Void ignore) {
            return type;
        }
    }

    private static final class NoTypeVisitor
    extends CastingTypeVisitor<NoType> {
        private static final NoTypeVisitor INSTANCE = new NoTypeVisitor();

        NoTypeVisitor() {
            super("non-type");
        }

        @Override
        public NoType visitNoType(NoType type, Void ignore) {
            return type;
        }
    }

    private static final class IntersectionTypeVisitor
    extends CastingTypeVisitor<IntersectionType> {
        private static final IntersectionTypeVisitor INSTANCE = new IntersectionTypeVisitor();

        IntersectionTypeVisitor() {
            super("intersection type");
        }

        @Override
        public IntersectionType visitIntersection(IntersectionType type, Void ignore) {
            return type;
        }
    }

    private static final class ExecutableTypeVisitor
    extends CastingTypeVisitor<ExecutableType> {
        private static final ExecutableTypeVisitor INSTANCE = new ExecutableTypeVisitor();

        ExecutableTypeVisitor() {
            super("executable type");
        }

        @Override
        public ExecutableType visitExecutable(ExecutableType type, Void ignore) {
            return type;
        }
    }

    private static final class ErrorTypeVisitor
    extends CastingTypeVisitor<ErrorType> {
        private static final ErrorTypeVisitor INSTANCE = new ErrorTypeVisitor();

        ErrorTypeVisitor() {
            super("error type");
        }

        @Override
        public ErrorType visitError(ErrorType type, Void ignore) {
            return type;
        }
    }

    private static final class DeclaredTypeVisitor
    extends CastingTypeVisitor<DeclaredType> {
        private static final DeclaredTypeVisitor INSTANCE = new DeclaredTypeVisitor();

        DeclaredTypeVisitor() {
            super("declared type");
        }

        @Override
        public DeclaredType visitDeclared(DeclaredType type, Void ignore) {
            return type;
        }
    }

    private static final class ArrayTypeVisitor
    extends CastingTypeVisitor<ArrayType> {
        private static final ArrayTypeVisitor INSTANCE = new ArrayTypeVisitor();

        ArrayTypeVisitor() {
            super("array");
        }

        @Override
        public ArrayType visitArray(ArrayType type, Void ignore) {
            return type;
        }
    }

    private static final class AsElementVisitor
    extends SimpleTypeVisitor8<Element, Void> {
        private static final AsElementVisitor INSTANCE = new AsElementVisitor();

        private AsElementVisitor() {
        }

        @Override
        protected Element defaultAction(TypeMirror e2, Void p2) {
            throw new IllegalArgumentException(e2 + " cannot be converted to an Element");
        }

        @Override
        public Element visitDeclared(DeclaredType t2, Void p2) {
            return t2.asElement();
        }

        @Override
        public Element visitError(ErrorType t2, Void p2) {
            return t2.asElement();
        }

        @Override
        public Element visitTypeVariable(TypeVariable t2, Void p2) {
            return t2.asElement();
        }
    }

    private static final class ReferencedTypes
    extends SimpleTypeVisitor8<Void, $ImmutableSet.Builder<TypeElement>> {
        private static final ReferencedTypes INSTANCE = new ReferencedTypes();

        private ReferencedTypes() {
        }

        @Override
        public Void visitArray(ArrayType t2, $ImmutableSet.Builder<TypeElement> p2) {
            t2.getComponentType().accept(this, p2);
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType t2, $ImmutableSet.Builder<TypeElement> p2) {
            p2.add((Object)$MoreElements.asType(t2.asElement()));
            for (TypeMirror typeMirror : t2.getTypeArguments()) {
                typeMirror.accept(this, p2);
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t2, $ImmutableSet.Builder<TypeElement> p2) {
            t2.getLowerBound().accept(this, p2);
            t2.getUpperBound().accept(this, p2);
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t2, $ImmutableSet.Builder<TypeElement> p2) {
            TypeMirror superBound;
            TypeMirror extendsBound = t2.getExtendsBound();
            if (extendsBound != null) {
                extendsBound.accept(this, p2);
            }
            if ((superBound = t2.getSuperBound()) != null) {
                superBound.accept(this, p2);
            }
            return null;
        }
    }

    private static final class HashVisitor
    extends SimpleTypeVisitor8<Integer, Set<Element>> {
        private static final HashVisitor INSTANCE = new HashVisitor();

        private HashVisitor() {
        }

        int hashKind(int seed, TypeMirror t2) {
            int result = seed * 31;
            return result += t2.getKind().hashCode();
        }

        @Override
        protected Integer defaultAction(TypeMirror e2, Set<Element> visiting) {
            return this.hashKind(17, e2);
        }

        @Override
        public Integer visitArray(ArrayType t2, Set<Element> visiting) {
            int result = this.hashKind(17, t2);
            result *= 31;
            return result += t2.getComponentType().accept(this, visiting).intValue();
        }

        @Override
        public Integer visitDeclared(DeclaredType t2, Set<Element> visiting) {
            Element element = t2.asElement();
            if (visiting.contains(element)) {
                return 0;
            }
            HashSet<Element> newVisiting = new HashSet<Element>(visiting);
            newVisiting.add(element);
            int result = this.hashKind(17, t2);
            result *= 31;
            result += t2.asElement().hashCode();
            result *= 31;
            result += t2.getEnclosingType().accept(this, newVisiting).intValue();
            result *= 31;
            return result += $MoreTypes.hashList(t2.getTypeArguments(), newVisiting);
        }

        @Override
        public Integer visitExecutable(ExecutableType t2, Set<Element> visiting) {
            int result = this.hashKind(17, t2);
            result *= 31;
            result += $MoreTypes.hashList(t2.getParameterTypes(), visiting);
            result *= 31;
            result += t2.getReturnType().accept(this, visiting).intValue();
            result *= 31;
            result += $MoreTypes.hashList(t2.getThrownTypes(), visiting);
            result *= 31;
            return result += $MoreTypes.hashList(t2.getTypeVariables(), visiting);
        }

        @Override
        public Integer visitTypeVariable(TypeVariable t2, Set<Element> visiting) {
            int result = this.hashKind(17, t2);
            result *= 31;
            result += t2.getLowerBound().accept(this, visiting).intValue();
            TypeParameterElement element = (TypeParameterElement)t2.asElement();
            for (TypeMirror typeMirror : element.getBounds()) {
                result *= 31;
                result += typeMirror.accept(this, visiting).intValue();
            }
            return result;
        }

        @Override
        public Integer visitWildcard(WildcardType t2, Set<Element> visiting) {
            int result = this.hashKind(17, t2);
            result *= 31;
            result += t2.getExtendsBound() == null ? 0 : t2.getExtendsBound().accept(this, visiting);
            result *= 31;
            return result += t2.getSuperBound() == null ? 0 : t2.getSuperBound().accept(this, visiting);
        }

        @Override
        public Integer visitUnknown(TypeMirror t2, Set<Element> visiting) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class EqualVisitor
    extends SimpleTypeVisitor8<Boolean, EqualVisitorParam> {
        private static final EqualVisitor INSTANCE = new EqualVisitor();

        private EqualVisitor() {
        }

        @Override
        protected Boolean defaultAction(TypeMirror a2, EqualVisitorParam p2) {
            return a2.getKind().equals((Object)p2.type.getKind());
        }

        @Override
        public Boolean visitArray(ArrayType a2, EqualVisitorParam p2) {
            if (p2.type.getKind().equals((Object)TypeKind.ARRAY)) {
                ArrayType b2 = (ArrayType)p2.type;
                return $MoreTypes.equal(a2.getComponentType(), b2.getComponentType(), p2.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitDeclared(DeclaredType a2, EqualVisitorParam p2) {
            if (p2.type.getKind().equals((Object)TypeKind.DECLARED)) {
                DeclaredType b2 = (DeclaredType)p2.type;
                Element aElement = a2.asElement();
                Element bElement = b2.asElement();
                Set<ComparedElements> newVisiting = this.visitingSetPlus(p2.visiting, aElement, a2.getTypeArguments(), bElement, b2.getTypeArguments());
                if (newVisiting.equals(p2.visiting)) {
                    return true;
                }
                return aElement.equals(bElement) && $MoreTypes.equal($MoreTypes.enclosingType(a2), $MoreTypes.enclosingType(b2), newVisiting) && $MoreTypes.equalLists(a2.getTypeArguments(), b2.getTypeArguments(), newVisiting);
            }
            return false;
        }

        @Override
        public Boolean visitError(ErrorType a2, EqualVisitorParam p2) {
            return a2.equals(p2.type);
        }

        @Override
        public Boolean visitExecutable(ExecutableType a2, EqualVisitorParam p2) {
            if (p2.type.getKind().equals((Object)TypeKind.EXECUTABLE)) {
                ExecutableType b2 = (ExecutableType)p2.type;
                return $MoreTypes.equalLists(a2.getParameterTypes(), b2.getParameterTypes(), p2.visiting) && $MoreTypes.equal(a2.getReturnType(), b2.getReturnType(), p2.visiting) && $MoreTypes.equalLists(a2.getThrownTypes(), b2.getThrownTypes(), p2.visiting) && $MoreTypes.equalLists(a2.getTypeVariables(), b2.getTypeVariables(), p2.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitIntersection(IntersectionType a2, EqualVisitorParam p2) {
            if (p2.type.getKind().equals((Object)TypeKind.INTERSECTION)) {
                IntersectionType b2 = (IntersectionType)p2.type;
                return $MoreTypes.equalLists(a2.getBounds(), b2.getBounds(), p2.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable a2, EqualVisitorParam p2) {
            if (p2.type.getKind().equals((Object)TypeKind.TYPEVAR)) {
                TypeParameterElement bElement;
                TypeVariable b2 = (TypeVariable)p2.type;
                TypeParameterElement aElement = (TypeParameterElement)a2.asElement();
                Set<ComparedElements> newVisiting = this.visitingSetPlus(p2.visiting, aElement, bElement = (TypeParameterElement)b2.asElement());
                if (newVisiting.equals(p2.visiting)) {
                    return true;
                }
                return $MoreTypes.equalLists(aElement.getBounds(), bElement.getBounds(), newVisiting) && $MoreTypes.equal(a2.getLowerBound(), b2.getLowerBound(), newVisiting) && a2.asElement().getSimpleName().equals(b2.asElement().getSimpleName());
            }
            return false;
        }

        @Override
        public Boolean visitWildcard(WildcardType a2, EqualVisitorParam p2) {
            if (p2.type.getKind().equals((Object)TypeKind.WILDCARD)) {
                WildcardType b2 = (WildcardType)p2.type;
                return $MoreTypes.equal(a2.getExtendsBound(), b2.getExtendsBound(), p2.visiting) && $MoreTypes.equal(a2.getSuperBound(), b2.getSuperBound(), p2.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitUnknown(TypeMirror a2, EqualVisitorParam p2) {
            throw new UnsupportedOperationException();
        }

        private Set<ComparedElements> visitingSetPlus(Set<ComparedElements> visiting, Element a2, Element b2) {
            $ImmutableList noArguments = $ImmutableList.of();
            return this.visitingSetPlus(visiting, a2, noArguments, b2, noArguments);
        }

        private Set<ComparedElements> visitingSetPlus(Set<ComparedElements> visiting, Element a2, List<? extends TypeMirror> aArguments, Element b2, List<? extends TypeMirror> bArguments) {
            ComparedElements comparedElements = new ComparedElements(a2, $ImmutableList.copyOf(aArguments), b2, $ImmutableList.copyOf(bArguments));
            HashSet<ComparedElements> newVisiting = new HashSet<ComparedElements>(visiting);
            newVisiting.add(comparedElements);
            return newVisiting;
        }
    }

    private static class ComparedElements {
        final Element a;
        final $ImmutableList<TypeMirror> aArguments;
        final Element b;
        final $ImmutableList<TypeMirror> bArguments;

        ComparedElements(Element a2, $ImmutableList<TypeMirror> aArguments, Element b2, $ImmutableList<TypeMirror> bArguments) {
            this.a = a2;
            this.aArguments = aArguments;
            this.b = b2;
            this.bArguments = bArguments;
        }

        public boolean equals(Object o2) {
            if (o2 instanceof ComparedElements) {
                ComparedElements that = (ComparedElements)o2;
                int nArguments = this.aArguments.size();
                if (!this.a.equals(that.a) || !this.b.equals(that.b) || nArguments != this.bArguments.size()) {
                    return false;
                }
                for (int i2 = 0; i2 < nArguments; ++i2) {
                    if (this.aArguments.get(i2) == this.bArguments.get(i2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode() * 31 + this.b.hashCode();
        }
    }

    private static final class EqualVisitorParam {
        TypeMirror type;
        Set<ComparedElements> visiting;

        private EqualVisitorParam() {
        }
    }

    private static final class TypeEquivalence
    extends $Equivalence<TypeMirror> {
        private static final TypeEquivalence INSTANCE = new TypeEquivalence();

        private TypeEquivalence() {
        }

        @Override
        protected boolean doEquivalent(TypeMirror a2, TypeMirror b2) {
            return $MoreTypes.equal(a2, b2, $ImmutableSet.of());
        }

        @Override
        protected int doHash(TypeMirror t2) {
            return $MoreTypes.hash(t2, $ImmutableSet.of());
        }

        public String toString() {
            return "MoreTypes.equivalence()";
        }
    }
}

