/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.net.MalformedURLException;
import java.net.URL;
import rcm.awt.PopupDialog;
import websphinx.Crawler;
import websphinx.Tagexp;
import websphinx.workbench.ConcatAction;
import websphinx.workbench.Context;
import websphinx.workbench.ExtractAction;
import websphinx.workbench.MirrorAction;
import websphinx.workbench.Workbench;

public class WorkbenchApplet
extends Applet {
    Workbench workbench;

    public Workbench makeWorkbench() {
        String openURL = this.getParameter("open");
        String newClassname = this.getParameter("new");
        try {
            if (openURL != null) {
                return new Workbench(new URL(this.getDocumentBase(), openURL));
            }
            if (newClassname != null) {
                return new Workbench((Crawler)Class.forName(newClassname).newInstance());
            }
            return new Workbench();
        }
        catch (Exception e) {
            PopupDialog.warn(null, "Error", e.toString());
            throw new Error(e.toString());
        }
    }

    public void init() {
        String dfs;
        String depth;
        String type;
        String domain;
        String urls;
        super.init();
        String targetName = this.getParameter("target");
        if (targetName != null) {
            Context.setApplet(this, targetName);
        } else {
            Context.setApplet(this);
        }
        this.workbench = this.makeWorkbench();
        String param = this.getParameter("advanced");
        if (param != null) {
            this.workbench.setAdvancedMode(WorkbenchApplet.isTrue(param));
        }
        Crawler crawler = this.workbench.getCrawler();
        String action = this.getParameter("action");
        if (action != null) {
            String filename = this.getParameter("filename");
            String pattern = this.getParameter("pattern");
            if (action.equalsIgnoreCase("concatenate")) {
                crawler.setAction(new ConcatAction(filename, true));
            } else if (action.equalsIgnoreCase("save")) {
                crawler.setAction(new MirrorAction(filename, true));
            } else if (action.equalsIgnoreCase("visualize")) {
                crawler.setAction(null);
            } else if (action.equalsIgnoreCase("extract")) {
                crawler.setAction(new ExtractAction(new Tagexp(pattern), true, filename, false));
            } else if (action.equalsIgnoreCase("none")) {
                crawler.setAction(null);
            } else {
                throw new RuntimeException("unknown action: " + action);
            }
        }
        if ((urls = this.getParameter("urls")) != null) {
            try {
                crawler.setRootHrefs(urls);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e.toString());
            }
        }
        if ((domain = this.getParameter("domain")) != null) {
            if (domain.equalsIgnoreCase("server")) {
                crawler.setDomain(Crawler.SERVER);
            } else if (domain.equalsIgnoreCase("subtree")) {
                crawler.setDomain(Crawler.SUBTREE);
            } else {
                crawler.setDomain(Crawler.WEB);
            }
        }
        if ((type = this.getParameter("type")) != null) {
            if (type.equalsIgnoreCase("images+hyperlinks")) {
                crawler.setLinkType(Crawler.HYPERLINKS_AND_IMAGES);
            } else if (type.equalsIgnoreCase("all")) {
                crawler.setLinkType(Crawler.ALL_LINKS);
            } else {
                crawler.setLinkType(Crawler.WEB);
            }
        }
        if ((depth = this.getParameter("depth")) != null) {
            crawler.setMaxDepth(Integer.parseInt(depth));
        }
        if ((dfs = this.getParameter("depthfirst")) != null) {
            crawler.setDepthFirst(WorkbenchApplet.isTrue(dfs));
        }
        this.workbench.setCrawler(crawler);
        this.setLayout(new BorderLayout());
        this.add("Center", this.workbench);
    }

    private static boolean isTrue(String s) {
        return s != null && (s.equalsIgnoreCase("on") || s.equalsIgnoreCase("1") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("true"));
    }
}

