/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import graph.Graph;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;
import java.util.Vector;
import rcm.awt.ClosableFrame;
import rcm.awt.Colors;
import websphinx.CrawlEvent;
import websphinx.CrawlListener;
import websphinx.Crawler;
import websphinx.Link;
import websphinx.LinkEvent;
import websphinx.LinkListener;
import websphinx.Page;
import websphinx.workbench.GraphLayout;
import websphinx.workbench.LinkViewEvent;
import websphinx.workbench.LinkViewListener;
import websphinx.workbench.WebEdge;
import websphinx.workbench.WebNode;
import websphinx.workbench.WorkbenchControlPanel;

public class WebGraph
extends GraphLayout
implements CrawlListener,
LinkListener {
    Hashtable links = new Hashtable();
    static final int NO_LINKS = 0;
    static final int RETRIEVED_LINKS = 1;
    static final int WALKED_LINKS = 2;
    static final int TREE_LINKS = 3;
    static final int ALL_LINKS = 4;
    int defaultFilter = 1;
    static final int ICON = 0;
    static final int TITLE = 1;
    static final int ABSOLUTE_URL = 2;
    static final int RELATIVE_URL = 3;
    int defaultRendering = 0;
    private Vector listeners = new Vector();
    Hashtable icons = new Hashtable();
    Image pageIcon;
    Image linkIcon;
    Image retrievingIcon;
    Image errorIcon;
    public static Image defaultPageIcon;
    public static Image defaultLinkIcon;
    public static Image defaultRetrievingIcon;
    public static Image defaultErrorIcon;
    static int linkWidth;
    static int linkHeight;
    static int[] linkData;
    static int pageWidth;
    static int pageHeight;
    static int[] pageData;
    static int retrieveWidth;
    static int retrieveHeight;
    static int[] retrieveData;
    static int errorWidth;
    static int errorHeight;
    static int[] errorData;

    public WebGraph() {
        this.setPageIcon(defaultPageIcon);
        this.setLinkIcon(defaultLinkIcon);
        this.setRetrievingIcon(defaultRetrievingIcon);
        this.setErrorIcon(defaultErrorIcon);
    }

    synchronized void setLinkFilter(WebNode node, int filter) {
        if (filter == node.filter) {
            return;
        }
        Page page = node.link.getPage();
        if (page != null) {
            Link[] linkarray = page.getLinks();
            if (filter < node.filter) {
                int j = 0;
                while (j < linkarray.length) {
                    WebEdge edge;
                    if (!this.shouldDisplay(filter, linkarray[j].getStatus()) && (edge = (WebEdge)this.links.get(linkarray[j])) != null) {
                        this.removeNode((WebNode)edge.to);
                        this.removeEdge(edge);
                        this.links.remove(linkarray[j]);
                    }
                    ++j;
                }
            } else if (filter > node.filter) {
                int j = 0;
                while (j < linkarray.length) {
                    this.update(linkarray[j]);
                    ++j;
                }
            }
        }
        node.filter = filter;
    }

    synchronized void setLinkFilter(int filter) {
        this.defaultFilter = filter;
        Graph graph = this.getGraph();
        int i = 0;
        while (i < graph.sizeNodes) {
            WebNode n = (WebNode)graph.nodes[i];
            this.setLinkFilter(n, filter);
            ++i;
        }
    }

    void setNodeRendering(WebNode n, int r) {
        n.rendering = r;
        this.update(n);
        this.repaint();
    }

    synchronized void setNodeRendering(int r) {
        this.defaultRendering = r;
        Graph graph = this.getGraph();
        int i = 0;
        while (i < graph.sizeNodes) {
            WebNode n = (WebNode)graph.nodes[i];
            n.rendering = r;
            this.update(n);
            ++i;
        }
        this.changedGraph();
    }

    public void showControlPanel() {
        new WorkbenchControlPanel(this, null).show();
    }

    public synchronized void clear() {
        this.links.clear();
        super.clear();
    }

    public void started(CrawlEvent event) {
    }

    public void stopped(CrawlEvent event) {
    }

    public void cleared(CrawlEvent event) {
        this.clear();
    }

    public void timedOut(CrawlEvent event) {
    }

    public void paused(CrawlEvent event) {
    }

    public void crawled(LinkEvent event) {
        this.update(event.getLink());
    }

    boolean shouldDisplay(int filter, int status) {
        switch (status) {
            case 3: 
            case 4: {
                return filter > 1;
            }
            case 1: {
                return filter > 2;
            }
            case 2: {
                return filter > 3;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void updateClosure(Link[] links) {
        if (links == null) {
            return;
        }
        int i = 0;
        while (i < links.length) {
            Link link = links[i];
            int status = link.getStatus();
            if (status != 0) {
                Page page;
                this.update(link);
                if ((status == 7 || status == 8) && (page = link.getPage()) != null) {
                    this.updateClosure(page.getLinks());
                }
            }
            ++i;
        }
    }

    public synchronized void update(Link link) {
        Object obj = this.links.get(link);
        if (obj == null) {
            this.add(link);
        } else if (obj instanceof WebEdge) {
            WebEdge e = (WebEdge)obj;
            this.update(e);
            this.update((WebNode)e.to);
        } else {
            this.update((WebNode)obj);
        }
        this.repaint();
    }

    synchronized void add(Link link) {
        WebNode n = new WebNode(link, this.defaultFilter, this.defaultRendering);
        WebNode parent = this.findParent(link);
        if (parent == null) {
            this.links.put(link, n);
            this.update(n);
            this.addNode(n);
            if (this.getGraph().sizeNodes == 1) {
                n.fixed = true;
                this.placeNodeOnGraph(n, 0.0, 0.0);
            } else {
                Dimension d = this.size();
                int x = (int)(Math.random() * (double)d.width);
                int y = (int)(Math.random() * (double)d.height);
                this.placeNodeOnScreen(n, x, y);
            }
        } else {
            if (!this.shouldDisplay(parent.filter, link.getStatus())) {
                return;
            }
            double len = this.getRestLength();
            double angle = Math.random() * 2.0 * Math.PI;
            double x = parent.x + len * Math.cos(angle);
            double y = parent.y + len * Math.sin(angle);
            this.update(n);
            this.addNode(n);
            this.placeNodeOnGraph(n, x, y);
            WebEdge e = new WebEdge(link, parent, n);
            this.links.put(link, e);
            this.update(e);
            this.addEdge(e);
        }
    }

    void update(WebEdge e) {
        e.color = Colors.parseColor(e.link.getLabel("Workbench.color"));
        e.thick = e.link.hasLabel("Workbench.thick");
    }

    void update(WebNode n) {
        Link origin;
        Page page = n.link.getPage();
        int status = n.link.getStatus();
        if (page == null) {
            switch (n.rendering) {
                case 0: {
                    n.name = null;
                    n.icon = this.getIcon(LinkEvent.eventName[status]);
                    break;
                }
                case 1: 
                case 2: {
                    n.name = n.link.getURL().toString();
                    n.icon = null;
                    break;
                }
                case 3: {
                    origin = n.link.getSource().getOrigin();
                    n.name = origin != null ? Link.relativeTo(origin.getURL(), n.link.getURL()) : n.link.getURL().toString();
                    n.icon = null;
                    break;
                }
            }
        } else {
            switch (n.rendering) {
                case 0: {
                    n.name = null;
                    n.icon = this.getIcon(page.getLabel("Workbench.icon", LinkEvent.eventName[status]));
                    break;
                }
                case 1: {
                    n.name = page.getTitle();
                    if (n.name == null) {
                        n.name = "[" + n.link.getURL().toString() + "]";
                    }
                    n.icon = null;
                    break;
                }
                case 2: {
                    n.name = n.link.getURL().toString();
                    n.icon = null;
                    break;
                }
                case 3: {
                    origin = n.link.getSource().getOrigin();
                    n.name = origin != null ? Link.relativeTo(origin.getURL(), n.link.getURL()) : n.link.getURL().toString();
                    n.icon = null;
                    break;
                }
            }
            n.color = Colors.parseColor(page.getLabel("Workbench.color"));
            n.scale = page.getNumericLabel("Workbench.size", new Integer(1)).doubleValue();
        }
        if (n.icon == null) {
            FontMetrics fm = this.getFontMetrics();
            n.width = fm.stringWidth(n.name) + 10;
            n.height = fm.getHeight() + 4;
        } else {
            n.width = (int)((double)n.icon.getWidth(this) * n.scale);
            n.height = (int)((double)n.icon.getHeight(this) * n.scale);
        }
    }

    WebEdge findEdge(Link l) {
        if (l == null) {
            return null;
        }
        Object obj = this.links.get(l);
        if (obj instanceof WebEdge) {
            return (WebEdge)obj;
        }
        return null;
    }

    WebNode findNode(Link l) {
        if (l == null) {
            return null;
        }
        Object obj = this.links.get(l);
        if (obj instanceof WebEdge) {
            return (WebNode)((WebEdge)obj).to;
        }
        return (WebNode)obj;
    }

    WebNode findParent(Link l) {
        if (l == null) {
            return null;
        }
        Page source = l.getSource();
        Link origin = source.getOrigin();
        return this.findNode(origin);
    }

    public void addLinkViewListener(LinkViewListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeLinkViewListener(CrawlListener listener) {
        this.listeners.removeElement(listener);
    }

    void fireEvent(Link link) {
        LinkViewEvent event = new LinkViewEvent(this, link);
        int j = 0;
        int len = this.listeners.size();
        while (j < len) {
            LinkViewListener listen = (LinkViewListener)this.listeners.elementAt(j);
            listen.viewLink(event);
            ++j;
        }
    }

    void doubleClick(int x, int y) {
        Object over = this.pick(x, y);
        if (over != null) {
            Link link = over instanceof WebNode ? ((WebNode)over).link : ((WebEdge)over).link;
            this.fireEvent(link);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id != 501 || event.clickCount != 2) {
            return super.handleEvent(event);
        }
        this.doubleClick(event.x, event.y);
        return true;
    }

    public Link getSelectedLink() {
        WebNode n = (WebNode)this.getSelectedNode();
        if (n != null) {
            return n.link;
        }
        WebEdge e = (WebEdge)this.getSelectedEdge();
        if (e != null) {
            return e.link;
        }
        return null;
    }

    public static Frame monitor(Crawler crawler) {
        ClosableFrame win = new ClosableFrame("Graph: " + crawler.getName());
        WebGraph g = new WebGraph();
        crawler.addCrawlListener(g);
        crawler.addLinkListener(g);
        g.setNodeCharge(1000.0);
        g.setRestLength(50.0);
        win.add("Center", g);
        win.pack();
        win.show();
        return win;
    }

    static String[] getTip(Link link) {
        String labels;
        String url;
        String anchor;
        Vector<String> result = new Vector<String>();
        String exception = link.getLabel("exception");
        if (exception != null && exception.length() > 0) {
            result.addElement("*** " + exception);
        }
        if ((anchor = link.toText()) != null && anchor.length() > 0) {
            result.addElement(anchor);
        }
        if ((url = link.getURL().toString()) != null && url.length() > 0) {
            result.addElement(url);
        }
        if ((labels = link.getObjectLabels()) != null && labels.length() > 0) {
            result.addElement(labels);
        }
        Object[] tip = new String[result.size()];
        result.copyInto(tip);
        return tip;
    }

    static String[] getTip(Page page) {
        String labels;
        String url;
        Vector<String> result = new Vector<String>();
        String title = page.getTitle();
        if (title != null && title.length() > 0) {
            result.addElement(title);
        }
        if ((url = page.getURL().toString()) != null && url.length() > 0) {
            result.addElement(url);
        }
        if ((labels = page.getObjectLabels()) != null && labels.length() > 0) {
            result.addElement(labels);
        }
        Object[] tip = new String[result.size()];
        result.copyInto(tip);
        return tip;
    }

    public synchronized Image getIcon(String name) {
        return (Image)this.icons.get(name);
    }

    public synchronized void setIcon(String name, Image icon) {
        if (icon != null) {
            this.icons.put(name, icon);
        } else {
            this.icons.remove(name);
        }
    }

    public synchronized void setPageIcon(Image icon) {
        this.pageIcon = icon;
        this.setIcon(LinkEvent.eventName[8], icon);
    }

    public synchronized void setLinkIcon(Image icon) {
        this.linkIcon = icon;
        this.setIcon(LinkEvent.eventName[4], icon);
        this.setIcon(LinkEvent.eventName[3], icon);
        this.setIcon(LinkEvent.eventName[2], icon);
        this.setIcon(LinkEvent.eventName[1], icon);
    }

    public synchronized void setRetrievingIcon(Image icon) {
        this.retrievingIcon = icon;
        this.setIcon(LinkEvent.eventName[5], icon);
        this.setIcon(LinkEvent.eventName[7], icon);
    }

    public synchronized void setErrorIcon(Image icon) {
        this.errorIcon = icon;
        this.setIcon(LinkEvent.eventName[6], icon);
    }

    static {
        NO_LINKS = 0;
        RETRIEVED_LINKS = 1;
        WALKED_LINKS = 2;
        TREE_LINKS = 3;
        ALL_LINKS = 4;
        ICON = 0;
        TITLE = 1;
        ABSOLUTE_URL = 2;
        RELATIVE_URL = 3;
        linkWidth = 17;
        linkHeight = 17;
        linkData = new int[]{-197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -13355932, -2829060, -3881788, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -13355932, -13355932, -13355932, -2829060, -2829060, -3881788, -10197812, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -3355396, -8092540, -13355932, -2829060, -8092540, -8092540, -10197812, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -13355932, -2829060, -3881788, -13355932, -2829060, -3881788, -10197812, -10197812, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -13355932, -2829060, -3881788, -13355932, -2829060, -3881788, -10197812, -10197812, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -3355396, -2829060, -3881788, -13355932, -13355932, -10197812, -10197812, -13355932, -13355932, -13355932, -197380, -197380, -197380, -197380, -197380, -13355932, -2829060, -3881788, -3881788, -13355932, -197380, -197380, -13355932, -13355932, -2829060, -3355396, -13355932, -197380, -197380, -197380, -197380, -13355932, -3355396, -3881788, -13355932, -13355932, -197380, -197380, -16514044, -13355932, -3355396, -3881788, -3881788, -13355932, -197380, -197380, -197380, -197380, -13355932, -16514044, -13355932, -13355932, -13355932, -197380, -16514044, -13355932, -3355396, -3881788, -13355932, -13355932, -197380, -197380, -197380, -197380, -197380, -13355932, -13355932, -2829060, -3881788, -3881788, -13355932, -13355932, -3355396, -3881788, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -3355396, -16514044, -10197812, -10197812, -13355932, -3355396, -16514044, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -3355396, -16514044, -10197812, -10197812, -13355932, -3355396, -16514044, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -3355396, -3881788, -10197812, -13355932, -13355932, -3355396, -3881788, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -16514044, -10197812, -13355932, -13355932, -13355932, -13355932, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355932, -13355932, -13355932, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380};
        pageWidth = 22;
        pageHeight = 26;
        pageData = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355980, -197380, -13355980, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355980, -197380, -197380, -13355980, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -13355980, -13355980, -13355980, -13355980, -13355980, -13355980, -197380, -197380, -13355980, -197380, -197380, -197380, -13355980, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -13355980, -209868, -209868, -10171140, -10171140, -10171140, -197380, -197380, -13355980, -197380, -197380, -197380, -197380, -13355980, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -13355980, -209868, -10171140, -10171140, -10171140, -10171140, -197380, -197380, -16514044, -13355980, -16514044, -13355980, -16514044, -13355980, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -13355980, -10171140, -10171140, -10171140, -10171140, -10171140, -197380, -197380, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -13355980, -6527948, -6527948, -6527948, -6527948, -6527948, -197380, -197380, -197380, -197380, -6513508, -6513508, -6513508, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -13355980, -6527948, -6527948, -6527948, -6527948, -6527948, -197380, -197380, -197380, -197380, -197380, -6513508, -6513508, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -248780, -197380, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -248780, -197380, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -6513508, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -13355980, -13355980, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -13355980, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
        retrieveWidth = 8;
        retrieveHeight = 8;
        retrieveData = new int[]{0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF};
        errorWidth = 8;
        errorHeight = 8;
        errorData = new int[]{-261116, -261116, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -261116, -261116, -261116, -261116, -261116, 0xFCFCFC, 0xFCFCFC, -261116, -261116, -261116, 0xFCFCFC, -261116, -261116, -261116, -261116, -261116, -261116, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -261116, -261116, -261116, -261116, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -261116, -261116, -261116, -261116, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -261116, -261116, -261116, -261116, -261116, -261116, 0xFCFCFC, -261116, -261116, -261116, 0xFCFCFC, 0xFCFCFC, -261116, -261116, -261116, -261116, -261116, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -261116, -261116};
        Toolkit tkit = Toolkit.getDefaultToolkit();
        defaultPageIcon = tkit.createImage(new MemoryImageSource(pageWidth, pageHeight, pageData, 0, pageWidth));
        defaultLinkIcon = tkit.createImage(new MemoryImageSource(linkWidth, linkHeight, linkData, 0, linkWidth));
        defaultRetrievingIcon = tkit.createImage(new MemoryImageSource(retrieveWidth, retrieveHeight, retrieveData, 0, retrieveWidth));
        defaultErrorIcon = tkit.createImage(new MemoryImageSource(errorWidth, errorHeight, errorData, 0, errorWidth));
    }
}

