/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import websphinx.Access;
import websphinx.Action;
import websphinx.CrawlEvent;
import websphinx.CrawlListener;
import websphinx.Crawler;
import websphinx.Link;
import websphinx.Mirror;
import websphinx.Page;
import websphinx.workbench.Browser;
import websphinx.workbench.Context;

public class MirrorAction
implements Action,
CrawlListener {
    String directory;
    boolean useBrowser;
    transient File dir;
    transient Mirror mirror;

    public MirrorAction(String directory, boolean useBrowser) {
        this.directory = directory;
        this.useBrowser = useBrowser;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MirrorAction)) {
            return false;
        }
        MirrorAction a = (MirrorAction)object;
        return this.same(a.directory, this.directory) && a.useBrowser == this.useBrowser;
    }

    private boolean same(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean getUseBrowser() {
        return this.useBrowser;
    }

    private void showit() {
        Browser browser = Context.getBrowser();
        if (browser != null) {
            try {
                browser.show(Link.FileToURL(this.dir));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public synchronized void visit(Page page) {
        try {
            this.mirror.writePage(page);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void connected(Crawler crawler) {
        crawler.addCrawlListener(this);
    }

    public void disconnected(Crawler crawler) {
        crawler.removeCrawlListener(this);
    }

    public void started(CrawlEvent event) {
        if (this.mirror == null) {
            try {
                this.dir = this.directory != null ? new File(this.directory) : Access.getAccess().makeTemporaryFile("mirror", "");
                this.mirror = new Mirror(this.dir.toString());
                Crawler crawler = event.getCrawler();
                Link[] roots = crawler.getRoots();
                int i = 0;
                while (i < roots.length) {
                    this.mirror.mapDir(roots[i].getURL(), this.dir.toString());
                    ++i;
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public void stopped(CrawlEvent event) {
        try {
            if (this.mirror != null) {
                this.mirror.close();
                this.mirror = null;
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void cleared(CrawlEvent event) {
        try {
            if (this.mirror != null) {
                this.mirror.close();
                this.mirror = null;
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void timedOut(CrawlEvent event) {
        try {
            if (this.mirror != null) {
                this.mirror.close();
                this.mirror = null;
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void paused(CrawlEvent event) {
        try {
            if (this.mirror != null) {
                this.mirror.rewrite();
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

