/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import rcm.awt.Constrain;
import websphinx.DownloadParameters;

public class DownloadParametersEditor
extends Panel {
    DownloadParameters dp;
    TextField maxThreads;
    TextField maxPageSize;
    TextField downloadTimeout;
    TextField crawlTimeout;
    Checkbox obeyRobotExclusion;
    TextField maxRequestsPerServer;
    TextField delay;
    Checkbox interactive;
    Checkbox useCaches;

    public DownloadParametersEditor() {
        this.setLayout(new GridBagLayout());
        Constrain.add(this, new Label("Threads:"), Constrain.labelLike(0, 0));
        this.maxThreads = new TextField();
        Constrain.add(this, this.maxThreads, Constrain.fieldLike(1, 0));
        Constrain.add(this, new Label("Page size:"), Constrain.labelLike(0, 1));
        this.maxPageSize = new TextField();
        Constrain.add(this, this.maxPageSize, Constrain.fieldLike(1, 1));
        Constrain.add(this, new Label("KB"), Constrain.labelLike(2, 1));
        Constrain.add(this, new Label("Page timeout:"), Constrain.labelLike(0, 2));
        this.downloadTimeout = new TextField();
        Constrain.add(this, this.downloadTimeout, Constrain.fieldLike(1, 2));
        Constrain.add(this, new Label("sec"), Constrain.labelLike(2, 2));
        Constrain.add(this, new Label("Crawl timeout:"), Constrain.labelLike(0, 3));
        this.crawlTimeout = new TextField();
        Constrain.add(this, this.crawlTimeout, Constrain.fieldLike(1, 3));
        Constrain.add(this, new Label("sec"), Constrain.labelLike(2, 3));
        this.obeyRobotExclusion = new Checkbox("Obey robot exclusion");
        Constrain.add(this, this.obeyRobotExclusion, Constrain.labelLike(3, 0));
        this.interactive = new Checkbox("Ask user for passwords");
        Constrain.add(this, this.interactive, Constrain.labelLike(3, 2));
        this.useCaches = new Checkbox("Use browser cache");
        Constrain.add(this, this.useCaches, Constrain.labelLike(3, 3));
        this.setDownloadParameters(new DownloadParameters());
    }

    public void setDownloadParameters(DownloadParameters dp) {
        this.dp = dp;
        this.maxThreads.setText(String.valueOf(dp.getMaxThreads()));
        this.maxPageSize.setText(String.valueOf(dp.getMaxPageSize()));
        this.downloadTimeout.setText(String.valueOf(dp.getDownloadTimeout()));
        this.crawlTimeout.setText(String.valueOf(dp.getCrawlTimeout()));
        this.obeyRobotExclusion.setState(dp.getObeyRobotExclusion());
        this.interactive.setState(dp.getInteractive());
        this.useCaches.setState(dp.getUseCaches());
    }

    public DownloadParameters getDownloadParameters() {
        this.dp = this.dp.changeMaxThreads(Integer.parseInt(this.maxThreads.getText())).changeMaxPageSize(Integer.parseInt(this.maxPageSize.getText())).changeDownloadTimeout(Integer.parseInt(this.downloadTimeout.getText())).changeCrawlTimeout(Integer.parseInt(this.crawlTimeout.getText())).changeObeyRobotExclusion(this.obeyRobotExclusion.getState()).changeInteractive(this.interactive.getState()).changeUseCaches(this.useCaches.getState());
        return this.dp;
    }
}

