/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import rcm.awt.Constrain;
import rcm.awt.PopupDialog;
import websphinx.Concatenator;
import websphinx.workbench.ConcatOptions;
import websphinx.workbench.Context;
import websphinx.workbench.ScriptInterpreter;

class ActionFeatureArgs
extends Panel {
    static final String TEMPORARY_DIR = "(temporary directory)";
    static final String TEMPORARY_FILE = "(temporary file)";
    Choice color;
    Choice scale;
    TextField mirrorDirectory;
    Checkbox mirrorUseBrowser;
    TextField concatFilename;
    Checkbox concatUseBrowser;
    Button optionsButton;
    String prolog = Concatenator.defaultProlog;
    String header = Concatenator.defaultHeader;
    String footer = Concatenator.defaultFooter;
    String divider = Concatenator.defaultDivider;
    String epilog = Concatenator.defaultEpilog;
    TextField extractFilename;
    TextArea extractPattern;
    Choice extractMedium;
    Checkbox extractUseBrowser;
    TextArea script;
    Button browseMirrorDirectory;
    Button browseConcatFilename;
    Button browseExtractFilename;

    public ActionFeatureArgs() {
        this.setLayout(new CardLayout());
        Panel panel = new Panel();
        this.add("none", panel);
        panel = Constrain.makeConstrainedPanel(4, 1);
        this.add("highlight", panel);
        Constrain.add(panel, new Label(" with color "), Constrain.labelLike(0, 0));
        this.color = new Choice();
        Constrain.add(panel, this.color, Constrain.fieldLike(1, 0));
        this.color.addItem("black");
        this.color.addItem("blue");
        this.color.addItem("cyan");
        this.color.addItem("green");
        this.color.addItem("magenta");
        this.color.addItem("orange");
        this.color.addItem("pink");
        this.color.addItem("red");
        this.color.addItem("white");
        this.color.addItem("yellow");
        this.color.select("blue");
        this.scale = new Choice();
        panel = Constrain.makeConstrainedPanel(3, 2);
        this.add("save", panel);
        Constrain.add(panel, new Label("to directory: "), Constrain.labelLike(0, 0));
        this.mirrorDirectory = new TextField();
        Constrain.add(panel, this.mirrorDirectory, Constrain.fieldLike(1, 0));
        this.browseMirrorDirectory = new Button("...");
        Constrain.add(panel, this.browseMirrorDirectory, Constrain.labelLike(2, 0));
        this.mirrorUseBrowser = new Checkbox("Display directory in browser");
        this.mirrorUseBrowser.setState(true);
        if (Context.getBrowser() != null) {
            this.mirrorDirectory.setText(TEMPORARY_DIR);
            Constrain.add(panel, this.mirrorUseBrowser, Constrain.labelLike(1, 1));
        }
        panel = Constrain.makeConstrainedPanel(4, 2);
        this.add("concatenate", panel);
        Constrain.add(panel, new Label("to file: "), Constrain.labelLike(0, 0));
        this.concatFilename = new TextField();
        Constrain.add(panel, this.concatFilename, Constrain.fieldLike(1, 0, 2));
        this.browseConcatFilename = new Button("...");
        Constrain.add(panel, this.browseConcatFilename, Constrain.labelLike(3, 0));
        this.concatUseBrowser = new Checkbox("Display in browser");
        this.concatUseBrowser.setState(true);
        if (Context.getBrowser() != null) {
            this.concatFilename.setText(TEMPORARY_FILE);
            Constrain.add(panel, this.concatUseBrowser, Constrain.labelLike(1, 1));
        }
        this.optionsButton = new Button("Options...");
        Constrain.add(panel, this.optionsButton, Constrain.labelLike(2, 1));
        panel = Constrain.makeConstrainedPanel(5, 4);
        this.add("extract", panel);
        Constrain.add(panel, new Label("regions matching the HTML tag expression:"), Constrain.labelLike(0, 0, 5));
        this.extractPattern = new TextArea(3, 40);
        Constrain.add(panel, this.extractPattern, Constrain.fieldLike(0, 1, 5));
        Constrain.add(panel, new Label("as"), Constrain.labelLike(0, 2));
        this.extractMedium = new Choice();
        Constrain.add(panel, this.extractMedium, Constrain.labelLike(1, 2));
        this.extractMedium.addItem("HTML");
        this.extractMedium.addItem("text");
        Constrain.add(panel, new Label("to file: "), Constrain.labelLike(2, 2));
        this.extractFilename = new TextField();
        Constrain.add(panel, this.extractFilename, Constrain.fieldLike(3, 2));
        this.browseExtractFilename = new Button("...");
        Constrain.add(panel, this.browseExtractFilename, Constrain.labelLike(4, 2));
        this.extractUseBrowser = new Checkbox("Display in browser");
        this.extractUseBrowser.setState(true);
        if (Context.getBrowser() != null) {
            this.extractFilename.setText(TEMPORARY_FILE);
            Constrain.add(panel, this.extractUseBrowser, Constrain.labelLike(3, 3));
        }
        ScriptInterpreter interp = Context.getScriptInterpreter();
        this.script = new TextArea(4, 40);
        if (interp != null) {
            panel = Constrain.makeConstrainedPanel(1, 2);
            this.add("script", panel);
            Constrain.add(panel, new Label(interp.getLanguage() + " Function (crawler, page)"), Constrain.labelLike(0, 0));
            Constrain.add(panel, this.script, Constrain.areaLike(0, 1));
        } else {
            panel = Constrain.makeConstrainedPanel(1, 1);
            this.add("script", panel);
            Constrain.add(panel, new Label("No scripting language is available."), Constrain.labelLike(0, 0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Event event) {
        if (event.id != 1001) return super.handleEvent(event);
        if (event.target == this.browseMirrorDirectory) {
            this.browse("Save Pages in Directory", this.mirrorDirectory);
            return true;
        } else if (event.target == this.browseConcatFilename) {
            this.browse("Save Concatenation As", this.concatFilename);
            return true;
        } else if (event.target == this.browseExtractFilename) {
            this.browse("Save Extracts As", this.extractFilename);
            return true;
        } else {
            if (event.target != this.optionsButton) return super.handleEvent(event);
            new ConcatOptions(this).show();
        }
        return true;
    }

    void browse(String title, TextField target) {
        String fn = PopupDialog.askFilename(this, title, target.getText(), false);
        if (fn != null) {
            target.setText(fn);
        }
    }

    public void setColor(String color) {
        this.color.select(color);
    }

    public String getColor() {
        return this.color.getSelectedItem();
    }

    public void setScale(String scale) {
        try {
            double d = Double.valueOf(scale);
            if (d < 1.0) {
                this.scale.select("small");
            } else if (d > 1.0) {
                this.scale.select("large");
            } else {
                this.scale.select("normal");
            }
        }
        catch (NumberFormatException e) {
            this.scale.select("normal");
        }
    }

    public String getScale() {
        switch (this.scale.getSelectedIndex()) {
            case 0: {
                return "0.5";
            }
            case 2: {
                return "2.0";
            }
        }
        return "1.0";
    }

    public void setIcon(String icon) {
    }

    public String getIcon() {
        return null;
    }

    public void setMirrorDirectory(String directory) {
        this.mirrorDirectory.setText(directory != null ? directory : TEMPORARY_DIR);
    }

    public String getMirrorDirectory() {
        String f = this.mirrorDirectory.getText();
        return f.equals(TEMPORARY_DIR) ? null : f;
    }

    public void setMirrorUseBrowser(boolean use) {
        this.mirrorUseBrowser.setState(use);
    }

    public boolean getMirrorUseBrowser() {
        return this.mirrorUseBrowser.getState();
    }

    public void setConcatFilename(String filename) {
        this.concatFilename.setText(filename != null ? filename : TEMPORARY_FILE);
    }

    public String getConcatFilename() {
        String f = this.concatFilename.getText();
        return f.equals(TEMPORARY_FILE) ? null : f;
    }

    public void setConcatUseBrowser(boolean use) {
        this.concatUseBrowser.setState(use);
    }

    public boolean getConcatUseBrowser() {
        return this.concatUseBrowser.getState();
    }

    public void setExtractFilename(String filename) {
        this.extractFilename.setText(filename != null ? filename : TEMPORARY_FILE);
    }

    public String getExtractFilename() {
        String f = this.extractFilename.getText();
        return f.equals(TEMPORARY_FILE) ? null : f;
    }

    public void setExtractUseBrowser(boolean use) {
        this.extractUseBrowser.setState(use);
    }

    public boolean getExtractUseBrowser() {
        return this.extractUseBrowser.getState();
    }

    public void setExtractPattern(String pattern) {
        this.extractPattern.setText(pattern);
    }

    public String getExtractPattern() {
        return this.extractPattern.getText();
    }

    public void setTextOnly(boolean f) {
        this.extractMedium.select(f ? "text" : "HTML");
    }

    public boolean getTextOnly() {
        return this.extractMedium.getSelectedItem().equals("text");
    }

    public void setScript(String script) {
        this.script.setText(script);
    }

    public String getScript() {
        return this.script.getText();
    }

    static {
        TEMPORARY_DIR = TEMPORARY_DIR;
        TEMPORARY_FILE = TEMPORARY_FILE;
    }
}

