/*
 * Decompiled with CFR 0.152.
 */
package websphinx.searchengine;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import websphinx.Crawler;
import websphinx.EventLog;
import websphinx.Link;
import websphinx.Page;
import websphinx.Region;
import websphinx.searchengine.SearchEngine;
import websphinx.searchengine.SearchEngineResult;

public class Search
extends Crawler
implements Enumeration {
    int maxResults;
    int walkedResults;
    Vector results = new Vector();
    int nextResult = 0;
    int approxCount = -1;
    boolean crawling = false;

    public Search() {
        this(Integer.MAX_VALUE);
    }

    public Search(int maxResults) {
        this.maxResults = maxResults;
        this.setDepthFirst(false);
        this.setMaxDepth(Integer.MAX_VALUE);
        EventLog.monitor(this);
    }

    public Search(SearchEngine engine, String keywords, int maxResults) {
        this(maxResults);
        this.addQuery(engine, keywords);
        this.search();
    }

    public Search(SearchEngine engine, String keywords) {
        this(engine, keywords, Integer.MAX_VALUE);
    }

    public void addQuery(SearchEngine engine, String keywords) {
        this.addRoot(new Link(engine.makeQuery(keywords)));
        this.addClassifier(engine);
        this.walkedResults += engine.getResultsPerPage();
    }

    public void search() {
        this.crawling = true;
        Thread thread = new Thread((Runnable)this, "Search");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Vector vector = this.results;
        synchronized (vector) {
            try {
                while (this.approxCount == -1 && this.crawling) {
                    this.results.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n = this.approxCount;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreElements() {
        Vector vector = this.results;
        synchronized (vector) {
            try {
                while (this.nextResult >= this.results.size() && this.crawling) {
                    this.results.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = this.nextResult < this.results.size();
            return bl;
        }
    }

    public Object nextElement() {
        return this.nextResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchEngineResult nextResult() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        Vector vector = this.results;
        synchronized (vector) {
            SearchEngineResult result = (SearchEngineResult)this.results.elementAt(this.nextResult++);
            if (result.rank == 0) {
                result.rank = this.nextResult;
            }
            SearchEngineResult searchEngineResult = result;
            return searchEngineResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.run();
        Vector vector = this.results;
        synchronized (vector) {
            if (this.approxCount == -1) {
                this.approxCount = 0;
            }
            this.crawling = false;
            this.results.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Page page) {
        Vector vector = this.results;
        synchronized (vector) {
            if (this.approxCount == -1) {
                this.approxCount = page.getNumericLabel("searchengine.count", new Integer(0)).intValue();
            }
            Region[] ser = page.getFields("searchengine.results");
            int i = 0;
            while (i < ser.length) {
                if (this.results.size() == this.maxResults) {
                    this.stop();
                    return;
                }
                this.results.addElement(ser[i]);
                ++i;
            }
            this.results.notify();
        }
    }

    public boolean shouldVisit(Link link) {
        if (this.walkedResults >= this.maxResults || !link.hasLabel("searchengine.more-results")) {
            return false;
        }
        SearchEngine engine = (SearchEngine)link.getSource().getObjectLabel("searchengine.source");
        this.walkedResults += engine.getResultsPerPage();
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Search <search engine classname> [-max n]  <keywords>*");
            return;
        }
        SearchEngine engine = (SearchEngine)Class.forName(args[0]).newInstance();
        int max = Integer.MAX_VALUE;
        int firstKeyword = 1;
        if (args[1].equals("-max")) {
            max = Integer.parseInt(args[2]);
            firstKeyword = 3;
        }
        Search ms = new Search(max);
        ms.addQuery(engine, Search.concat(args, firstKeyword));
        ms.search();
        while (ms.hasMoreElements()) {
            System.out.println(ms.nextResult());
        }
    }

    static String concat(String[] args, int start) {
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i < args.length) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(args[i]);
            ++i;
        }
        return buf.toString();
    }
}

