/*
 * Decompiled with CFR 0.152.
 */
package websphinx.searchengine;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import websphinx.Link;
import websphinx.Page;
import websphinx.Pattern;
import websphinx.Regexp;
import websphinx.Region;
import websphinx.Tagexp;
import websphinx.searchengine.Search;
import websphinx.searchengine.SearchEngine;
import websphinx.searchengine.SearchEngineResult;

public class NewsIndex
implements SearchEngine {
    static Pattern patCount = new Regexp("<center>Headlines\\s+\\d+\\s+to\\s+\\d+\\s+of\\s+(\\d+)</center>");
    static Pattern patNoHits = new Regexp("No articles were found matching your search criteria");
    static Pattern patResult = new Tagexp("<dd>(?{link}(?{title}<a>.*?</a>))<blockquote><b></b>(?{description})</blockquote>");
    public static final float priority = 0.0f;

    public void classify(Page page) {
        String title = page.getTitle();
        if (title != null && title.equals("News Index - Results")) {
            page.setObjectLabel("searchengine.source", this);
            Region count = patCount.oneMatch(page);
            if (count != null) {
                page.setField("searchengine.count", count.getField("0"));
            }
            Region[] results = patResult.allMatches(page);
            Region[] ser = new SearchEngineResult[results.length];
            int i = 0;
            while (i < results.length) {
                ser[i] = new SearchEngineResult(results[i]);
                ++i;
            }
            page.setFields("searchengine.results", ser);
            Link[] links = page.getLinks();
            int i2 = 0;
            while (i2 < links.length) {
                if (links[i2].toText().equals("Next 10 Headlines")) {
                    links[i2].setLabel("searchengine.more-results");
                    links[i2].setLabel("hyperlink");
                    break;
                }
                ++i2;
            }
        }
    }

    public float getPriority() {
        return 0.0f;
    }

    public URL makeQuery(String keywords) {
        try {
            return new URL("http://www.newsindex.com/cgi-bin/process.cgi?mode=any&query=" + URLEncoder.encode(keywords));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("internal error");
        }
    }

    public int getResultsPerPage() {
        return 10;
    }

    public static Search search(String keywords) {
        return new Search(new NewsIndex(), keywords);
    }

    public static Search search(String keywords, int maxResults) {
        return new Search(new NewsIndex(), keywords, maxResults);
    }

    static {
        priority = 0.0f;
    }
}

