/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import rcm.util.Str;
import websphinx.Regexp;
import websphinx.Region;

public class Wildcard
extends Regexp {
    String stringRep;

    public Wildcard(String pattern) {
        super("^" + Wildcard.toRegexp(pattern) + "$");
        this.stringRep = pattern;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Wildcard)) {
            return false;
        }
        Wildcard p = (Wildcard)object;
        return p.stringRep.equals(this.stringRep);
    }

    public static String toRegexp(String wildcard) {
        String s = wildcard;
        int inAlternative = 0;
        int inSet = 0;
        boolean inEscape = false;
        StringBuffer output = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (inEscape) {
                output.append(c);
                inEscape = false;
            } else {
                switch (c) {
                    case '\\': {
                        output.append(c);
                        inEscape = true;
                        break;
                    }
                    case '?': {
                        output.append('.');
                        break;
                    }
                    case '*': {
                        output.append(".*");
                        break;
                    }
                    case '[': {
                        output.append(c);
                        ++inSet;
                        break;
                    }
                    case ']': {
                        output.append(c);
                        --inSet;
                        break;
                    }
                    case '{': {
                        output.append("(?:");
                        ++inAlternative;
                        break;
                    }
                    case ',': {
                        if (inAlternative > 0) {
                            output.append("|");
                            break;
                        }
                        output.append(c);
                        break;
                    }
                    case '}': {
                        output.append(")");
                        --inAlternative;
                        break;
                    }
                    case '^': {
                        if (inSet > 0) {
                            output.append(c);
                            break;
                        }
                        output.append('\\');
                        output.append(c);
                        break;
                    }
                    case '$': 
                    case '+': 
                    case '.': 
                    case '|': {
                        output.append('\\');
                        output.append(c);
                        break;
                    }
                    default: {
                        output.append(c);
                    }
                }
            }
            ++i;
        }
        if (inEscape) {
            output.append('\\');
        }
        return output.toString();
    }

    public static String escape(String s) {
        return Str.escape(s, '\\', "\\?*{}()[]");
    }

    public String toString() {
        return this.stringRep;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("usage: Wildcard <pattern> <string>*");
            return;
        }
        Wildcard p = new Wildcard(args[0].replace('_', ' '));
        int i = 1;
        while (i < args.length) {
            Region r = p.oneMatch(args[i]);
            System.out.println(args[i] + ": " + (r != null));
            if (r != null) {
                System.out.println("  [" + r.getStart() + "," + r.getEnd() + "]" + r);
                Region[] groups = r.getFields("websphinx.groups");
                if (groups != null) {
                    int j = 0;
                    while (j < groups.length) {
                        Region s = groups[j];
                        System.out.println("    [" + s.getStart() + "," + s.getEnd() + "]" + s);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }
}

