/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import websphinx.Access;
import websphinx.Link;
import websphinx.LinkTransformer;
import websphinx.RewriteRegion;
import websphinx.Tag;

public class RewritableLinkTransformer
extends LinkTransformer {
    private RewriteRegion head;
    private RewriteRegion tail;
    private File file;
    private boolean closed = false;
    static final String PLACEHOLDER = "@WEBSPHINX@";
    static final int BUFFER_SIZE = 8;

    public RewritableLinkTransformer(String filename) throws IOException {
        super(filename, true);
        this.file = new File(filename);
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    protected void handleLink(Link link) throws IOException {
        URL url = link.getURL();
        Tag t = link.replaceHref(PLACEHOLDER);
        String s = t.toString();
        int prefix = s.indexOf(PLACEHOLDER);
        if (prefix != -1) {
            int postfix = prefix + PLACEHOLDER.length();
            this.emit(s.substring(0, prefix));
            String href = this.lookup(this.base, url);
            RewriteRegion node = this.addURL(url, this.getFilePointer(), href.length());
            this.emit(href);
            this.emit(s.substring(postfix));
        } else {
            this.emit(s);
        }
        this.transformContents(link);
        if (link.getEndTag() != null) {
            this.emit(link.getEndTag());
        }
    }

    private RewriteRegion addURL(URL url, long offset, int len) {
        RewriteRegion node = new RewriteRegion();
        node.url = url;
        node.offset = offset;
        node.len = len;
        if (this.tail == null) {
            this.head = this.tail = node;
        } else {
            node.next = this.tail.next;
            this.tail.next = node;
            node.prev = this.tail;
            if (node.next != null) {
                node.next.prev = node;
            }
            this.tail = node;
        }
        return node;
    }

    public void rewrite() throws IOException {
        int n;
        long left;
        this.flush();
        if (this.head == null) {
            return;
        }
        RandomAccessFile raf = this.closed ? Access.getAccess().readWriteFile(this.file) : this.getRandomAccessFile();
        byte[] buf = new byte[8];
        long end = raf.length();
        long src = 0L;
        long dest = 0L;
        int growth = 0;
        int shrinkage = 0;
        raf.seek(dest);
        RewriteRegion loc = this.head;
        while (loc != null) {
            String href;
            long diff = dest - src;
            loc.newHref = href = this.lookup(this.base, loc.url);
            loc.newLen = href.length();
            if (loc.newLen > loc.len) {
                growth += loc.newLen - loc.len;
                loc.offset += diff;
            } else {
                shrinkage += loc.len - loc.newLen;
                left = loc.offset - src;
                while (left > 8L) {
                    raf.seek(src);
                    raf.read(buf);
                    raf.seek(dest);
                    raf.write(buf);
                    src += 8L;
                    dest += 8L;
                    left -= 8L;
                }
                if (left > 0L) {
                    n = (int)left;
                    raf.seek(src);
                    raf.read(buf, 0, n);
                    raf.seek(dest);
                    raf.write(buf, 0, n);
                    src += (long)n;
                    dest += (long)n;
                    left -= (long)n;
                }
                raf.writeBytes(href);
                dest += (long)loc.newLen;
                src += (long)loc.len;
                loc.offset += diff;
                loc.len = loc.newLen;
            }
            loc = loc.next;
        }
        if (src > dest) {
            while (true) {
                raf.seek(src);
                n = raf.read(buf);
                if (n != -1) {
                    raf.seek(dest);
                    raf.write(buf, 0, n);
                    src += (long)n;
                    dest += (long)n;
                    continue;
                }
                break;
            }
        } else {
            src = dest = end;
        }
        src = dest;
        dest += (long)growth;
        RewriteRegion loc2 = this.tail;
        while (loc2 != null) {
            long diff = dest - src;
            if (loc2.newLen <= loc2.len) {
                loc2.offset += diff;
            } else {
                left = src - (loc2.offset + (long)loc2.len);
                while (left > 8L) {
                    left -= 8L;
                    raf.seek(src -= 8L);
                    raf.read(buf);
                    raf.seek(dest -= 8L);
                    raf.write(buf);
                }
                if (left > 0L) {
                    n = (int)left;
                    raf.seek(src -= (long)n);
                    raf.read(buf, 0, n);
                    raf.seek(dest -= (long)n);
                    raf.write(buf, 0, n);
                }
                src -= (long)loc2.len;
                raf.seek(dest -= (long)loc2.newLen);
                raf.writeBytes(loc2.newHref);
                loc2.offset = dest;
                loc2.len = loc2.newLen;
            }
            loc2 = loc2.prev;
        }
        if (src != dest) {
            System.err.println("ASSERTION FAILURE: src=" + src + "!=dest=" + dest);
        }
        if (shrinkage > growth) {
            int i = 0;
            while (i < 8) {
                buf[i] = 32;
                ++i;
            }
            left = shrinkage - growth;
            raf.seek(end - left);
            while (left > 8L) {
                raf.write(buf);
                left -= 8L;
            }
            if (left > 0L) {
                raf.write(buf, 0, (int)left);
            }
        } else {
            raf.seek(end + (long)(growth - shrinkage));
        }
        if (this.closed) {
            raf.close();
        }
    }

    static {
        PLACEHOLDER = PLACEHOLDER;
        BUFFER_SIZE = 8;
    }
}

