/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;

public abstract class Win {
    public static void center(Window window, Component ref) {
        Win.position(window, ref, 0.5, 0.5);
    }

    public static void position(Window frame, Component ref, double xfrac, double yfrac) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = frame.getSize();
        Dimension refSize = ref != null ? ref.getSize() : screenSize;
        Point origin = ref != null ? ref.getLocationOnScreen() : new Point(0, 0);
        int x = origin.x + Win.relativePoint(xfrac, refSize.width, size.width);
        int y = origin.y + Win.relativePoint(yfrac, refSize.height, size.height);
        x = Math.max(0, Math.min(screenSize.width - size.width, x));
        y = Math.max(0, Math.min(screenSize.height - size.height, y));
        frame.setLocation(x, y);
    }

    static int relativePoint(double frac, int parentLength, int childLength) {
        if (frac < 0.0) {
            return (int)(frac * (double)childLength);
        }
        if (frac > 1.0) {
            return (int)((double)parentLength + (frac - 2.0) * (double)childLength);
        }
        return (int)(frac * (double)(parentLength - childLength));
    }

    public static Frame findFrame(Component comp) {
        while (comp != null) {
            if (comp instanceof Frame) {
                return (Frame)comp;
            }
            comp = comp.getParent();
        }
        return null;
    }

    public static Frame findFrameOrMakeFrame(Component parent) {
        return parent != null ? Win.findFrame(parent) : new Frame();
    }
}

