/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

import java.util.Enumeration;
import java.util.Vector;
import rcm.util.PQItem;
import rcm.util.Prioritized;

public class PriorityQueue {
    private Vector q;

    public PriorityQueue() {
        this.q = new Vector();
    }

    public PriorityQueue(int initialCapacity) {
        this.q = new Vector(initialCapacity);
    }

    public synchronized void put(Prioritized x) {
        int newSize = this.q.size() + 1;
        this.q.setSize(newSize);
        float priorityX = x.getPriority();
        int i = newSize - 1;
        int p = (i + 1) / 2 - 1;
        while (i > 0 && this.getPriority(p) > priorityX) {
            this.q.setElementAt(this.q.elementAt(p), i);
            i = p;
            p = (i + 1) / 2 - 1;
        }
        this.q.setElementAt(x, i);
    }

    public synchronized Object getMin() {
        return !this.empty() ? this.q.elementAt(0) : null;
    }

    public synchronized Object deleteMin() {
        if (this.empty()) {
            return null;
        }
        Object obj = this.q.elementAt(0);
        this.deleteElement(0);
        return obj;
    }

    public synchronized boolean delete(Prioritized x) {
        int i = this.q.indexOf(x);
        if (i == -1) {
            return false;
        }
        this.deleteElement(i);
        return true;
    }

    public synchronized void clear() {
        this.q.removeAllElements();
    }

    public synchronized Enumeration elements() {
        return this.q.elements();
    }

    public synchronized int size() {
        return this.q.size();
    }

    public synchronized boolean empty() {
        return this.q.isEmpty();
    }

    public synchronized void update() {
        int i = this.q.size() / 2 - 1;
        while (i >= 0) {
            this.heapify(i);
            --i;
        }
    }

    final void deleteElement(int i) {
        int last = this.q.size() - 1;
        this.q.setElementAt(this.q.elementAt(last), i);
        this.q.setElementAt(null, last);
        this.q.setSize(last);
        this.heapify(i);
    }

    final void heapify(int i) {
        int max = this.q.size();
        while (i < max) {
            int r = 2 * (i + 1);
            int l = r - 1;
            int smallest = i;
            float prioritySmallest = this.getPriority(i);
            if (r < max) {
                float f;
                float priorityR = this.getPriority(r);
                if (f < prioritySmallest) {
                    smallest = r;
                    prioritySmallest = priorityR;
                }
            }
            if (l < max && this.getPriority(l) < prioritySmallest) {
                smallest = l;
            }
            if (smallest == i) break;
            this.swap(i, smallest);
            i = smallest;
        }
    }

    final void swap(int i, int j) {
        Object tmp = this.q.elementAt(i);
        this.q.setElementAt(this.q.elementAt(j), i);
        this.q.setElementAt(tmp, j);
    }

    final float getPriority(int i) {
        return ((Prioritized)this.q.elementAt(i)).getPriority();
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        PQItem item;
        PriorityQueue q = new PriorityQueue();
        int i = 0;
        while (i < args.length) {
            float f = Float.valueOf(args[i]).floatValue();
            q.put(new PQItem(f));
            System.out.println("put (" + f + ")");
            ++i;
        }
        System.out.println("getMin() = " + q.getMin());
        System.out.println("empty() = " + q.empty());
        PriorityQueue.dump(q);
        if (q.size() > 0) {
            Enumeration enumeration = q.elements();
            int j = 0;
            while (j < q.size() / 2) {
                enumeration.nextElement();
                ++j;
            }
            PQItem deletable = (PQItem)enumeration.nextElement();
            q.delete(deletable);
            System.out.println("delete (" + deletable + ")");
            PriorityQueue.dump(q);
        }
        float last = Float.NEGATIVE_INFINITY;
        while ((item = (PQItem)q.deleteMin()) != null) {
            void j;
            System.out.println("deleteMin() = " + j);
            if (j.getPriority() < last) {
                System.out.println("ERROR! greater than last == " + last);
            }
            last = j.getPriority();
            PriorityQueue.dump(q);
        }
    }

    public static void dump(PriorityQueue q) {
        Enumeration enumeration = q.elements();
        int j = 0;
        while (enumeration.hasMoreElements()) {
            System.out.println("elements()[" + (j + 1) + "] = " + enumeration.nextElement());
            ++j;
        }
    }
}

