/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Edge;
import graph.Node;

public class Barycenter {
    public double x;
    public double y;
    public double width;
    public double height;
    public double degree;
    public Barycenter NW;
    public Barycenter NE;
    public Barycenter SW;
    public Barycenter SE;
    public Barycenter parent;
    public Node[] nodes = new Node[1];
    public int sizeNodes;
    public Edge[] edges = new Edge[1];
    public int sizeEdges;
    private int allocatedNodes = 1;
    private int allocatedEdges = 1;

    private void doubleNodeArray() {
        Node[] nodeArray = new Node[this.allocatedNodes * 2];
        int n = 0;
        while (n < this.allocatedNodes) {
            nodeArray[n] = this.nodes[n];
            ++n;
        }
        this.nodes = nodeArray;
        this.allocatedNodes *= 2;
    }

    private void doubleEdgeArray() {
        Edge[] edgeArray = new Edge[this.allocatedEdges * 2];
        int n = 0;
        while (n < this.allocatedEdges) {
            edgeArray[n] = this.edges[n];
            ++n;
        }
        this.edges = edgeArray;
        this.allocatedEdges *= 2;
    }

    public Barycenter() {
    }

    public Barycenter(Barycenter barycenter) {
        this.parent = barycenter;
    }

    public synchronized void addNode(Node node) {
        if (this.sizeNodes == this.allocatedNodes) {
            this.doubleNodeArray();
        }
        this.nodes[this.sizeNodes++] = node;
        this.x = (this.x * (double)(this.sizeNodes - 1) + node.x) / (double)this.sizeNodes;
        this.y = (this.y * (double)(this.sizeNodes - 1) + node.y) / (double)this.sizeNodes;
        this.width = (this.width * (double)(this.sizeNodes - 1) + (double)node.width) / (double)this.sizeNodes;
        this.height = (this.height * (double)(this.sizeNodes - 1) + (double)node.height) / (double)this.sizeNodes;
        this.degree = (this.degree * (double)(this.sizeNodes - 1) + (double)node.degree) / (double)this.sizeNodes;
        node.barycenter = this;
    }

    public synchronized void addEdge(Edge edge) {
        if (this.sizeEdges == this.allocatedEdges) {
            this.doubleEdgeArray();
        }
        this.edges[this.sizeEdges++] = edge;
    }

    public synchronized void moveNode(Node node, double d, double d2) {
        this.x += (d - node.x) / (double)this.sizeNodes;
        this.y += (d2 - node.y) / (double)this.sizeNodes;
        if (this.parent != null) {
            this.parent.moveNode(node, d, d2);
        }
    }

    public synchronized void removeNode(Node node) {
        if (this.sizeNodes == 1) {
            this.x = 0.0;
            this.y = 0.0;
        } else {
            this.x = (this.x * (double)this.sizeNodes - node.x) / (double)(this.sizeNodes - 1);
            this.y = (this.y * (double)this.sizeNodes - node.y) / (double)(this.sizeNodes - 1);
            this.width = (this.width * (double)this.sizeNodes - (double)node.width) / (double)(this.sizeNodes - 1);
            this.height = (this.height * (double)this.sizeNodes - (double)node.height) / (double)(this.sizeNodes - 1);
            this.degree = (this.degree * (double)this.sizeNodes - (double)node.degree) / (double)(this.sizeNodes - 1);
        }
        int n = 0;
        while (n < this.sizeNodes) {
            if (this.nodes[n] == node) {
                this.nodes[n] = this.nodes[--this.sizeNodes];
                break;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.sizeEdges) {
            Edge edge = this.edges[n2];
            if (edge.from == node || edge.to == node) {
                this.edges[n2] = this.edges[--this.sizeEdges];
            }
            ++n2;
        }
        if (this.parent != null) {
            this.parent.removeNode(node);
        }
    }

    public synchronized void translate(double d, double d2) {
        Object object;
        int n = 0;
        while (n < this.sizeNodes) {
            object = this.nodes[n];
            ((Node)object).x += d;
            ((Node)object).y += d2;
            ++n;
        }
        object = this;
        while (object != null) {
            ((Barycenter)object).x += d * (double)this.sizeNodes / (double)((Barycenter)object).sizeNodes;
            ((Barycenter)object).y += d2 * (double)this.sizeNodes / (double)((Barycenter)object).sizeNodes;
            object = ((Barycenter)object).parent;
        }
        this.translateDescendants(this, d, d2);
    }

    private synchronized void translateDescendants(Barycenter barycenter, double d, double d2) {
        if (barycenter.NW != null) {
            barycenter.NW.x += d;
            barycenter.NW.y += d2;
            this.translateDescendants(barycenter.NW, d, d2);
        }
        if (barycenter.NE != null) {
            barycenter.NE.x += d;
            barycenter.NE.y += d2;
            this.translateDescendants(barycenter.NE, d, d2);
        }
        if (barycenter.SW != null) {
            barycenter.SW.x += d;
            barycenter.SW.y += d2;
            this.translateDescendants(barycenter.SW, d, d2);
        }
        if (barycenter.SE != null) {
            barycenter.SE.x += d;
            barycenter.SE.y += d2;
            this.translateDescendants(barycenter.SE, d, d2);
        }
    }
}

