/*
 * Decompiled with CFR 0.152.
 */
package gd;

import gd.GDAlgorithm;
import graph.Coords;
import graph.Edge;
import graph.Graph;
import graph.My;
import graph.Node;

public class AllPairsAlgorithm
extends GDAlgorithm {
    public AllPairsAlgorithm(double d, double d2) {
        this.springConstant = d;
        this.nodeCharge = d2;
    }

    public synchronized double energy(Graph graph) {
        double d = 0.0;
        int n = 0;
        while (n < graph.sizeNodes) {
            d += this.energy(graph, graph.nodes[n], 0.0, 0.0) / 2.0;
            ++n;
        }
        return d;
    }

    public synchronized double improveGraph(Graph graph) {
        if (graph.sizeNodes == 0) {
            return 0.0;
        }
        double d = graph.barycenter.x;
        double d2 = graph.barycenter.y;
        boolean bl = false;
        int n = 0;
        while (n < graph.sizeNodes) {
            bl |= graph.nodes[n].fixed;
            ++n;
        }
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < graph.sizeNodes) {
            d3 += this.improveNode(graph, graph.nodes[n2]);
            ++n2;
        }
        if (!bl) {
            graph.center(d, d2);
        }
        return d3;
    }

    private synchronized Coords repulsionForce(Node node, Node node2, double d, double d2) {
        double d3 = node.x + d - node2.x;
        double d4 = node.y + d2 - node2.y;
        double d5 = My.square((double)(node.width + node2.width + 1) * d3) + My.square((double)(node.height + node2.height + 1) * d4);
        if (d5 == 0.0) {
            return new Coords(Math.random() - 0.5, Math.random() - 0.5);
        }
        double d6 = My.square(this.nodeCharge) * (double)node.degree * (double)node2.degree / Math.pow(d5, 1.5);
        return new Coords(d6 * d3, d6 * d4);
    }

    private synchronized double repulsionEnergy(Node node, Node node2, double d, double d2) {
        double d3 = node.x + d - node2.x;
        double d4 = node.y + d2 - node2.y;
        double d5 = My.square((double)(node.width + node2.width + 1) * d3) + My.square((double)(node.height + node2.height + 1) * d4);
        if (d5 == 0.0) {
            return 1.7976931348623156E306;
        }
        return My.square(this.nodeCharge) * (double)node.degree * (double)node2.degree / Math.sqrt(d5);
    }

    private synchronized Coords springForce(Node node, Edge edge, double d, double d2) {
        double d3 = edge.to.x - edge.from.x;
        double d4 = edge.to.y - edge.from.y;
        if (node == edge.to) {
            d3 += d;
            d4 += d2;
        } else {
            d3 -= d;
            d4 -= d2;
        }
        double d5 = Math.sqrt(My.square(d3) + My.square(d4));
        double d6 = d5 - edge.restLength;
        double d7 = 2.0 * this.springConstant * d6 / d5;
        if (node == edge.to) {
            d7 = -d7;
        }
        Coords coords = new Coords(d7 * d3, d7 * d4);
        if (edge.directed && d4 > edge.restLength) {
            coords.y -= 2.0 * this.springConstant * (d4 - edge.restLength) / 2.0;
        }
        return coords;
    }

    private synchronized double springEnergy(Edge edge, Node node, double d, double d2) {
        double d3 = edge.to.x - edge.from.x;
        double d4 = edge.to.y - edge.from.y;
        if (node == edge.to) {
            d3 += d;
            d4 += d2;
        } else {
            d3 -= d;
            d4 -= d2;
        }
        double d5 = Math.sqrt(My.square(d3) + My.square(d4));
        double d6 = this.springConstant * My.square(d5 - edge.restLength);
        if (edge.directed && d4 > edge.restLength) {
            d6 -= this.springConstant * My.square(d4 - edge.restLength) / 2.0;
        }
        return d6;
    }

    private synchronized Coords force(Graph graph, Node node, double d, double d2) {
        Coords coords = new Coords(0.0, 0.0);
        int n = 0;
        while (n < graph.sizeNodes) {
            if (graph.nodes[n] != node) {
                coords.add(this.repulsionForce(node, graph.nodes[n], d, d2));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < node.degree) {
            coords.add(this.springForce(node, node.incidentEdges[n2], d, d2));
            ++n2;
        }
        return coords;
    }

    private synchronized double energy(Graph graph, Node node, double d, double d2) {
        double d3 = 0.0;
        int n = 0;
        while (n < graph.sizeNodes) {
            if (graph.nodes[n] != node) {
                d3 += this.repulsionEnergy(node, graph.nodes[n], d, d2);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < node.degree) {
            d3 += this.springEnergy(node.incidentEdges[n2], node, d, d2);
            ++n2;
        }
        return d3;
    }

    private synchronized double improveNode(Graph graph, Node node) {
        if (node.degree == 0 || node.fixed || !node.placed) {
            return 0.0;
        }
        Coords coords = this.force(graph, node, 0.0, 0.0);
        double d = Math.sqrt(My.square(coords.x) + My.square(coords.y));
        if (d == 0.0) {
            return 0.0;
        }
        coords.x /= d;
        coords.y /= d;
        double d2 = this.energy(graph, node, 0.0, 0.0);
        double d3 = this.quadApprox(graph, node, d2, coords);
        double d4 = coords.x;
        coords.x = coords.y;
        coords.y = -d4;
        d3 += this.quadApprox(graph, node, d2 + d3, coords);
        coords.x = Math.random();
        coords.y = Math.random();
        d3 += this.quadApprox(graph, node, d2 + d3, coords);
        graph.placeNode(node, node.x, node.y);
        return d3;
    }

    private synchronized double quadApprox(Graph graph, Node node, double d, Coords coords) {
        double d2;
        double d3;
        double d4 = this.energy(graph, node, coords.x, coords.y);
        double d5 = (d4 - (d3 = this.energy(graph, node, -coords.x, -coords.y))) / 2.0;
        double d6 = -d5 / (2.0 * (d2 = d4 + d3 - 2.0 * d));
        double d7 = this.energy(graph, node, d6 * coords.x, d6 * coords.y);
        if (d7 < d) {
            graph.placeNode(node, node.x + d6 * coords.x, node.y + d6 * coords.y);
            return d - d7;
        }
        return 0.0;
    }
}

