// tls_parameters.hpp
//
// this file was autogenerated at 2025-01-28T08:50:29Z
// you should edit the source file(s) instead of this one
//
// source files:
//     tls-parameters-4.csv
//     tls-parameters-8.csv
//

#ifndef TLS_PARAMETERS_HPP
#define TLS_PARAMETERS_HPP

#include <unordered_set>

#include "datum.h"

namespace tls {

static constexpr char UNKNOWN[] = "UNKNOWN";

class cipher_suites : public encoded<uint16_t> {
public:

    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == UNKNOWN) {
            o.print_key_unknown_code("cipher_suites", encoded<uint16_t>::value());
        } else {
            o.print_key_string("cipher_suites", name);
        }
    }
    enum code {
        TLS_NULL_WITH_NULL_NULL                       = 0x0000,
        TLS_RSA_WITH_NULL_MD5                         = 0x0001,
        TLS_RSA_WITH_NULL_SHA                         = 0x0002,
        TLS_RSA_EXPORT_WITH_RC4_40_MD5                = 0x0003,
        TLS_RSA_WITH_RC4_128_MD5                      = 0x0004,
        TLS_RSA_WITH_RC4_128_SHA                      = 0x0005,
        TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5            = 0x0006,
        TLS_RSA_WITH_IDEA_CBC_SHA                     = 0x0007,
        TLS_RSA_EXPORT_WITH_DES40_CBC_SHA             = 0x0008,
        TLS_RSA_WITH_DES_CBC_SHA                      = 0x0009,
        TLS_RSA_WITH_3DES_EDE_CBC_SHA                 = 0x000A,
        TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA          = 0x000B,
        TLS_DH_DSS_WITH_DES_CBC_SHA                   = 0x000C,
        TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA              = 0x000D,
        TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA          = 0x000E,
        TLS_DH_RSA_WITH_DES_CBC_SHA                   = 0x000F,
        TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA              = 0x0010,
        TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA         = 0x0011,
        TLS_DHE_DSS_WITH_DES_CBC_SHA                  = 0x0012,
        TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA             = 0x0013,
        TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA         = 0x0014,
        TLS_DHE_RSA_WITH_DES_CBC_SHA                  = 0x0015,
        TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA             = 0x0016,
        TLS_DH_anon_EXPORT_WITH_RC4_40_MD5            = 0x0017,
        TLS_DH_anon_WITH_RC4_128_MD5                  = 0x0018,
        TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA         = 0x0019,
        TLS_DH_anon_WITH_DES_CBC_SHA                  = 0x001A,
        TLS_DH_anon_WITH_3DES_EDE_CBC_SHA             = 0x001B,
        TLS_KRB5_WITH_DES_CBC_SHA                     = 0x001E,
        TLS_KRB5_WITH_3DES_EDE_CBC_SHA                = 0x001F,
        TLS_KRB5_WITH_RC4_128_SHA                     = 0x0020,
        TLS_KRB5_WITH_IDEA_CBC_SHA                    = 0x0021,
        TLS_KRB5_WITH_DES_CBC_MD5                     = 0x0022,
        TLS_KRB5_WITH_3DES_EDE_CBC_MD5                = 0x0023,
        TLS_KRB5_WITH_RC4_128_MD5                     = 0x0024,
        TLS_KRB5_WITH_IDEA_CBC_MD5                    = 0x0025,
        TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA           = 0x0026,
        TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA           = 0x0027,
        TLS_KRB5_EXPORT_WITH_RC4_40_SHA               = 0x0028,
        TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5           = 0x0029,
        TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5           = 0x002A,
        TLS_KRB5_EXPORT_WITH_RC4_40_MD5               = 0x002B,
        TLS_PSK_WITH_NULL_SHA                         = 0x002C,
        TLS_DHE_PSK_WITH_NULL_SHA                     = 0x002D,
        TLS_RSA_PSK_WITH_NULL_SHA                     = 0x002E,
        TLS_RSA_WITH_AES_128_CBC_SHA                  = 0x002F,
        TLS_DH_DSS_WITH_AES_128_CBC_SHA               = 0x0030,
        TLS_DH_RSA_WITH_AES_128_CBC_SHA               = 0x0031,
        TLS_DHE_DSS_WITH_AES_128_CBC_SHA              = 0x0032,
        TLS_DHE_RSA_WITH_AES_128_CBC_SHA              = 0x0033,
        TLS_DH_anon_WITH_AES_128_CBC_SHA              = 0x0034,
        TLS_RSA_WITH_AES_256_CBC_SHA                  = 0x0035,
        TLS_DH_DSS_WITH_AES_256_CBC_SHA               = 0x0036,
        TLS_DH_RSA_WITH_AES_256_CBC_SHA               = 0x0037,
        TLS_DHE_DSS_WITH_AES_256_CBC_SHA              = 0x0038,
        TLS_DHE_RSA_WITH_AES_256_CBC_SHA              = 0x0039,
        TLS_DH_anon_WITH_AES_256_CBC_SHA              = 0x003A,
        TLS_RSA_WITH_NULL_SHA256                      = 0x003B,
        TLS_RSA_WITH_AES_128_CBC_SHA256               = 0x003C,
        TLS_RSA_WITH_AES_256_CBC_SHA256               = 0x003D,
        TLS_DH_DSS_WITH_AES_128_CBC_SHA256            = 0x003E,
        TLS_DH_RSA_WITH_AES_128_CBC_SHA256            = 0x003F,
        TLS_DHE_DSS_WITH_AES_128_CBC_SHA256           = 0x0040,
        TLS_RSA_WITH_CAMELLIA_128_CBC_SHA             = 0x0041,
        TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA          = 0x0042,
        TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA          = 0x0043,
        TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA         = 0x0044,
        TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA         = 0x0045,
        TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA         = 0x0046,
        TLS_DHE_RSA_WITH_AES_128_CBC_SHA256           = 0x0067,
        TLS_DH_DSS_WITH_AES_256_CBC_SHA256            = 0x0068,
        TLS_DH_RSA_WITH_AES_256_CBC_SHA256            = 0x0069,
        TLS_DHE_DSS_WITH_AES_256_CBC_SHA256           = 0x006A,
        TLS_DHE_RSA_WITH_AES_256_CBC_SHA256           = 0x006B,
        TLS_DH_anon_WITH_AES_128_CBC_SHA256           = 0x006C,
        TLS_DH_anon_WITH_AES_256_CBC_SHA256           = 0x006D,
        TLS_RSA_WITH_CAMELLIA_256_CBC_SHA             = 0x0084,
        TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA          = 0x0085,
        TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA          = 0x0086,
        TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA         = 0x0087,
        TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA         = 0x0088,
        TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA         = 0x0089,
        TLS_PSK_WITH_RC4_128_SHA                      = 0x008A,
        TLS_PSK_WITH_3DES_EDE_CBC_SHA                 = 0x008B,
        TLS_PSK_WITH_AES_128_CBC_SHA                  = 0x008C,
        TLS_PSK_WITH_AES_256_CBC_SHA                  = 0x008D,
        TLS_DHE_PSK_WITH_RC4_128_SHA                  = 0x008E,
        TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA             = 0x008F,
        TLS_DHE_PSK_WITH_AES_128_CBC_SHA              = 0x0090,
        TLS_DHE_PSK_WITH_AES_256_CBC_SHA              = 0x0091,
        TLS_RSA_PSK_WITH_RC4_128_SHA                  = 0x0092,
        TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA             = 0x0093,
        TLS_RSA_PSK_WITH_AES_128_CBC_SHA              = 0x0094,
        TLS_RSA_PSK_WITH_AES_256_CBC_SHA              = 0x0095,
        TLS_RSA_WITH_SEED_CBC_SHA                     = 0x0096,
        TLS_DH_DSS_WITH_SEED_CBC_SHA                  = 0x0097,
        TLS_DH_RSA_WITH_SEED_CBC_SHA                  = 0x0098,
        TLS_DHE_DSS_WITH_SEED_CBC_SHA                 = 0x0099,
        TLS_DHE_RSA_WITH_SEED_CBC_SHA                 = 0x009A,
        TLS_DH_anon_WITH_SEED_CBC_SHA                 = 0x009B,
        TLS_RSA_WITH_AES_128_GCM_SHA256               = 0x009C,
        TLS_RSA_WITH_AES_256_GCM_SHA384               = 0x009D,
        TLS_DHE_RSA_WITH_AES_128_GCM_SHA256           = 0x009E,
        TLS_DHE_RSA_WITH_AES_256_GCM_SHA384           = 0x009F,
        TLS_DH_RSA_WITH_AES_128_GCM_SHA256            = 0x00A0,
        TLS_DH_RSA_WITH_AES_256_GCM_SHA384            = 0x00A1,
        TLS_DHE_DSS_WITH_AES_128_GCM_SHA256           = 0x00A2,
        TLS_DHE_DSS_WITH_AES_256_GCM_SHA384           = 0x00A3,
        TLS_DH_DSS_WITH_AES_128_GCM_SHA256            = 0x00A4,
        TLS_DH_DSS_WITH_AES_256_GCM_SHA384            = 0x00A5,
        TLS_DH_anon_WITH_AES_128_GCM_SHA256           = 0x00A6,
        TLS_DH_anon_WITH_AES_256_GCM_SHA384           = 0x00A7,
        TLS_PSK_WITH_AES_128_GCM_SHA256               = 0x00A8,
        TLS_PSK_WITH_AES_256_GCM_SHA384               = 0x00A9,
        TLS_DHE_PSK_WITH_AES_128_GCM_SHA256           = 0x00AA,
        TLS_DHE_PSK_WITH_AES_256_GCM_SHA384           = 0x00AB,
        TLS_RSA_PSK_WITH_AES_128_GCM_SHA256           = 0x00AC,
        TLS_RSA_PSK_WITH_AES_256_GCM_SHA384           = 0x00AD,
        TLS_PSK_WITH_AES_128_CBC_SHA256               = 0x00AE,
        TLS_PSK_WITH_AES_256_CBC_SHA384               = 0x00AF,
        TLS_PSK_WITH_NULL_SHA256                      = 0x00B0,
        TLS_PSK_WITH_NULL_SHA384                      = 0x00B1,
        TLS_DHE_PSK_WITH_AES_128_CBC_SHA256           = 0x00B2,
        TLS_DHE_PSK_WITH_AES_256_CBC_SHA384           = 0x00B3,
        TLS_DHE_PSK_WITH_NULL_SHA256                  = 0x00B4,
        TLS_DHE_PSK_WITH_NULL_SHA384                  = 0x00B5,
        TLS_RSA_PSK_WITH_AES_128_CBC_SHA256           = 0x00B6,
        TLS_RSA_PSK_WITH_AES_256_CBC_SHA384           = 0x00B7,
        TLS_RSA_PSK_WITH_NULL_SHA256                  = 0x00B8,
        TLS_RSA_PSK_WITH_NULL_SHA384                  = 0x00B9,
        TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256          = 0x00BA,
        TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256       = 0x00BB,
        TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256       = 0x00BC,
        TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256      = 0x00BD,
        TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256      = 0x00BE,
        TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256      = 0x00BF,
        TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256          = 0x00C0,
        TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256       = 0x00C1,
        TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256       = 0x00C2,
        TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256      = 0x00C3,
        TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256      = 0x00C4,
        TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256      = 0x00C5,
        TLS_SM4_GCM_SM3                               = 0x00C6,
        TLS_SM4_CCM_SM3                               = 0x00C7,
        TLS_EMPTY_RENEGOTIATION_INFO_SCSV             = 0x00FF,
        TLS_AES_128_GCM_SHA256                        = 0x1301,
        TLS_AES_256_GCM_SHA384                        = 0x1302,
        TLS_CHACHA20_POLY1305_SHA256                  = 0x1303,
        TLS_AES_128_CCM_SHA256                        = 0x1304,
        TLS_AES_128_CCM_8_SHA256                      = 0x1305,
        TLS_AEGIS_256_SHA512                          = 0x1306,
        TLS_AEGIS_128L_SHA256                         = 0x1307,
        TLS_FALLBACK_SCSV                             = 0x5600,
        TLS_ECDH_ECDSA_WITH_NULL_SHA                  = 0xC001,
        TLS_ECDH_ECDSA_WITH_RC4_128_SHA               = 0xC002,
        TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA          = 0xC003,
        TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA           = 0xC004,
        TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA           = 0xC005,
        TLS_ECDHE_ECDSA_WITH_NULL_SHA                 = 0xC006,
        TLS_ECDHE_ECDSA_WITH_RC4_128_SHA              = 0xC007,
        TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA         = 0xC008,
        TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA          = 0xC009,
        TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA          = 0xC00A,
        TLS_ECDH_RSA_WITH_NULL_SHA                    = 0xC00B,
        TLS_ECDH_RSA_WITH_RC4_128_SHA                 = 0xC00C,
        TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA            = 0xC00D,
        TLS_ECDH_RSA_WITH_AES_128_CBC_SHA             = 0xC00E,
        TLS_ECDH_RSA_WITH_AES_256_CBC_SHA             = 0xC00F,
        TLS_ECDHE_RSA_WITH_NULL_SHA                   = 0xC010,
        TLS_ECDHE_RSA_WITH_RC4_128_SHA                = 0xC011,
        TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA           = 0xC012,
        TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA            = 0xC013,
        TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA            = 0xC014,
        TLS_ECDH_anon_WITH_NULL_SHA                   = 0xC015,
        TLS_ECDH_anon_WITH_RC4_128_SHA                = 0xC016,
        TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA           = 0xC017,
        TLS_ECDH_anon_WITH_AES_128_CBC_SHA            = 0xC018,
        TLS_ECDH_anon_WITH_AES_256_CBC_SHA            = 0xC019,
        TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA             = 0xC01A,
        TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA         = 0xC01B,
        TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA         = 0xC01C,
        TLS_SRP_SHA_WITH_AES_128_CBC_SHA              = 0xC01D,
        TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA          = 0xC01E,
        TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA          = 0xC01F,
        TLS_SRP_SHA_WITH_AES_256_CBC_SHA              = 0xC020,
        TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA          = 0xC021,
        TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA          = 0xC022,
        TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256       = 0xC023,
        TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384       = 0xC024,
        TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256        = 0xC025,
        TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384        = 0xC026,
        TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256         = 0xC027,
        TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384         = 0xC028,
        TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256          = 0xC029,
        TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384          = 0xC02A,
        TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256       = 0xC02B,
        TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384       = 0xC02C,
        TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256        = 0xC02D,
        TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384        = 0xC02E,
        TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256         = 0xC02F,
        TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384         = 0xC030,
        TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256          = 0xC031,
        TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384          = 0xC032,
        TLS_ECDHE_PSK_WITH_RC4_128_SHA                = 0xC033,
        TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA           = 0xC034,
        TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA            = 0xC035,
        TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA            = 0xC036,
        TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256         = 0xC037,
        TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384         = 0xC038,
        TLS_ECDHE_PSK_WITH_NULL_SHA                   = 0xC039,
        TLS_ECDHE_PSK_WITH_NULL_SHA256                = 0xC03A,
        TLS_ECDHE_PSK_WITH_NULL_SHA384                = 0xC03B,
        TLS_RSA_WITH_ARIA_128_CBC_SHA256              = 0xC03C,
        TLS_RSA_WITH_ARIA_256_CBC_SHA384              = 0xC03D,
        TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256           = 0xC03E,
        TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384           = 0xC03F,
        TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256           = 0xC040,
        TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384           = 0xC041,
        TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256          = 0xC042,
        TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384          = 0xC043,
        TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256          = 0xC044,
        TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384          = 0xC045,
        TLS_DH_anon_WITH_ARIA_128_CBC_SHA256          = 0xC046,
        TLS_DH_anon_WITH_ARIA_256_CBC_SHA384          = 0xC047,
        TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256      = 0xC048,
        TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384      = 0xC049,
        TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256       = 0xC04A,
        TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384       = 0xC04B,
        TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256        = 0xC04C,
        TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384        = 0xC04D,
        TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256         = 0xC04E,
        TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384         = 0xC04F,
        TLS_RSA_WITH_ARIA_128_GCM_SHA256              = 0xC050,
        TLS_RSA_WITH_ARIA_256_GCM_SHA384              = 0xC051,
        TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256          = 0xC052,
        TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384          = 0xC053,
        TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256           = 0xC054,
        TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384           = 0xC055,
        TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256          = 0xC056,
        TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384          = 0xC057,
        TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256           = 0xC058,
        TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384           = 0xC059,
        TLS_DH_anon_WITH_ARIA_128_GCM_SHA256          = 0xC05A,
        TLS_DH_anon_WITH_ARIA_256_GCM_SHA384          = 0xC05B,
        TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256      = 0xC05C,
        TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384      = 0xC05D,
        TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256       = 0xC05E,
        TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384       = 0xC05F,
        TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256        = 0xC060,
        TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384        = 0xC061,
        TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256         = 0xC062,
        TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384         = 0xC063,
        TLS_PSK_WITH_ARIA_128_CBC_SHA256              = 0xC064,
        TLS_PSK_WITH_ARIA_256_CBC_SHA384              = 0xC065,
        TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256          = 0xC066,
        TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384          = 0xC067,
        TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256          = 0xC068,
        TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384          = 0xC069,
        TLS_PSK_WITH_ARIA_128_GCM_SHA256              = 0xC06A,
        TLS_PSK_WITH_ARIA_256_GCM_SHA384              = 0xC06B,
        TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256          = 0xC06C,
        TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384          = 0xC06D,
        TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256          = 0xC06E,
        TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384          = 0xC06F,
        TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256        = 0xC070,
        TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384        = 0xC071,
        TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256  = 0xC072,
        TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384  = 0xC073,
        TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256   = 0xC074,
        TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384   = 0xC075,
        TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256    = 0xC076,
        TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384    = 0xC077,
        TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256     = 0xC078,
        TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384     = 0xC079,
        TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256          = 0xC07A,
        TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384          = 0xC07B,
        TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256      = 0xC07C,
        TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384      = 0xC07D,
        TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256       = 0xC07E,
        TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384       = 0xC07F,
        TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256      = 0xC080,
        TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384      = 0xC081,
        TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256       = 0xC082,
        TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384       = 0xC083,
        TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256      = 0xC084,
        TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384      = 0xC085,
        TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256  = 0xC086,
        TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384  = 0xC087,
        TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256   = 0xC088,
        TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384   = 0xC089,
        TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256    = 0xC08A,
        TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384    = 0xC08B,
        TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256     = 0xC08C,
        TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384     = 0xC08D,
        TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256          = 0xC08E,
        TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384          = 0xC08F,
        TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256      = 0xC090,
        TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384      = 0xC091,
        TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256      = 0xC092,
        TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384      = 0xC093,
        TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256          = 0xC094,
        TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384          = 0xC095,
        TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256      = 0xC096,
        TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384      = 0xC097,
        TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256      = 0xC098,
        TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384      = 0xC099,
        TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256    = 0xC09A,
        TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384    = 0xC09B,
        TLS_RSA_WITH_AES_128_CCM                      = 0xC09C,
        TLS_RSA_WITH_AES_256_CCM                      = 0xC09D,
        TLS_DHE_RSA_WITH_AES_128_CCM                  = 0xC09E,
        TLS_DHE_RSA_WITH_AES_256_CCM                  = 0xC09F,
        TLS_RSA_WITH_AES_128_CCM_8                    = 0xC0A0,
        TLS_RSA_WITH_AES_256_CCM_8                    = 0xC0A1,
        TLS_DHE_RSA_WITH_AES_128_CCM_8                = 0xC0A2,
        TLS_DHE_RSA_WITH_AES_256_CCM_8                = 0xC0A3,
        TLS_PSK_WITH_AES_128_CCM                      = 0xC0A4,
        TLS_PSK_WITH_AES_256_CCM                      = 0xC0A5,
        TLS_DHE_PSK_WITH_AES_128_CCM                  = 0xC0A6,
        TLS_DHE_PSK_WITH_AES_256_CCM                  = 0xC0A7,
        TLS_PSK_WITH_AES_128_CCM_8                    = 0xC0A8,
        TLS_PSK_WITH_AES_256_CCM_8                    = 0xC0A9,
        TLS_PSK_DHE_WITH_AES_128_CCM_8                = 0xC0AA,
        TLS_PSK_DHE_WITH_AES_256_CCM_8                = 0xC0AB,
        TLS_ECDHE_ECDSA_WITH_AES_128_CCM              = 0xC0AC,
        TLS_ECDHE_ECDSA_WITH_AES_256_CCM              = 0xC0AD,
        TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8            = 0xC0AE,
        TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8            = 0xC0AF,
        TLS_ECCPWD_WITH_AES_128_GCM_SHA256            = 0xC0B0,
        TLS_ECCPWD_WITH_AES_256_GCM_SHA384            = 0xC0B1,
        TLS_ECCPWD_WITH_AES_128_CCM_SHA256            = 0xC0B2,
        TLS_ECCPWD_WITH_AES_256_CCM_SHA384            = 0xC0B3,
        TLS_SHA256_SHA256                             = 0xC0B4,
        TLS_SHA384_SHA384                             = 0xC0B5,
        TLS_GOSTR341112_256_WITH_KUZNYECHIK_CTR_OMAC  = 0xC100,
        TLS_GOSTR341112_256_WITH_MAGMA_CTR_OMAC       = 0xC101,
        TLS_GOSTR341112_256_WITH_28147_CNT_IMIT       = 0xC102,
        TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_L     = 0xC103,
        TLS_GOSTR341112_256_WITH_MAGMA_MGM_L          = 0xC104,
        TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_S     = 0xC105,
        TLS_GOSTR341112_256_WITH_MAGMA_MGM_S          = 0xC106,
        TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256   = 0xCCA8,
        TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 0xCCA9,
        TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256     = 0xCCAA,
        TLS_PSK_WITH_CHACHA20_POLY1305_SHA256         = 0xCCAB,
        TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256   = 0xCCAC,
        TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256     = 0xCCAD,
        TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256     = 0xCCAE,
        TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256         = 0xD001,
        TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384         = 0xD002,
        TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256       = 0xD003,
        TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256         = 0xD005,
    };
    const char *get_name() const {
        switch(encoded<uint16_t>::value()) {
        case TLS_NULL_WITH_NULL_NULL:                       return "TLS_NULL_WITH_NULL_NULL";
        case TLS_RSA_WITH_NULL_MD5:                         return "TLS_RSA_WITH_NULL_MD5";
        case TLS_RSA_WITH_NULL_SHA:                         return "TLS_RSA_WITH_NULL_SHA";
        case TLS_RSA_EXPORT_WITH_RC4_40_MD5:                return "TLS_RSA_EXPORT_WITH_RC4_40_MD5";
        case TLS_RSA_WITH_RC4_128_MD5:                      return "TLS_RSA_WITH_RC4_128_MD5";
        case TLS_RSA_WITH_RC4_128_SHA:                      return "TLS_RSA_WITH_RC4_128_SHA";
        case TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5:            return "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5";
        case TLS_RSA_WITH_IDEA_CBC_SHA:                     return "TLS_RSA_WITH_IDEA_CBC_SHA";
        case TLS_RSA_EXPORT_WITH_DES40_CBC_SHA:             return "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA";
        case TLS_RSA_WITH_DES_CBC_SHA:                      return "TLS_RSA_WITH_DES_CBC_SHA";
        case TLS_RSA_WITH_3DES_EDE_CBC_SHA:                 return "TLS_RSA_WITH_3DES_EDE_CBC_SHA";
        case TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA:          return "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA";
        case TLS_DH_DSS_WITH_DES_CBC_SHA:                   return "TLS_DH_DSS_WITH_DES_CBC_SHA";
        case TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA:              return "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA";
        case TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA:          return "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA";
        case TLS_DH_RSA_WITH_DES_CBC_SHA:                   return "TLS_DH_RSA_WITH_DES_CBC_SHA";
        case TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA:              return "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA";
        case TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA:         return "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA";
        case TLS_DHE_DSS_WITH_DES_CBC_SHA:                  return "TLS_DHE_DSS_WITH_DES_CBC_SHA";
        case TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA:             return "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA";
        case TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA:         return "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA";
        case TLS_DHE_RSA_WITH_DES_CBC_SHA:                  return "TLS_DHE_RSA_WITH_DES_CBC_SHA";
        case TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA:             return "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA";
        case TLS_DH_anon_EXPORT_WITH_RC4_40_MD5:            return "TLS_DH_anon_EXPORT_WITH_RC4_40_MD5";
        case TLS_DH_anon_WITH_RC4_128_MD5:                  return "TLS_DH_anon_WITH_RC4_128_MD5";
        case TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA:         return "TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA";
        case TLS_DH_anon_WITH_DES_CBC_SHA:                  return "TLS_DH_anon_WITH_DES_CBC_SHA";
        case TLS_DH_anon_WITH_3DES_EDE_CBC_SHA:             return "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA";
        case TLS_KRB5_WITH_DES_CBC_SHA:                     return "TLS_KRB5_WITH_DES_CBC_SHA";
        case TLS_KRB5_WITH_3DES_EDE_CBC_SHA:                return "TLS_KRB5_WITH_3DES_EDE_CBC_SHA";
        case TLS_KRB5_WITH_RC4_128_SHA:                     return "TLS_KRB5_WITH_RC4_128_SHA";
        case TLS_KRB5_WITH_IDEA_CBC_SHA:                    return "TLS_KRB5_WITH_IDEA_CBC_SHA";
        case TLS_KRB5_WITH_DES_CBC_MD5:                     return "TLS_KRB5_WITH_DES_CBC_MD5";
        case TLS_KRB5_WITH_3DES_EDE_CBC_MD5:                return "TLS_KRB5_WITH_3DES_EDE_CBC_MD5";
        case TLS_KRB5_WITH_RC4_128_MD5:                     return "TLS_KRB5_WITH_RC4_128_MD5";
        case TLS_KRB5_WITH_IDEA_CBC_MD5:                    return "TLS_KRB5_WITH_IDEA_CBC_MD5";
        case TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA:           return "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA";
        case TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA:           return "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA";
        case TLS_KRB5_EXPORT_WITH_RC4_40_SHA:               return "TLS_KRB5_EXPORT_WITH_RC4_40_SHA";
        case TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5:           return "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5";
        case TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5:           return "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5";
        case TLS_KRB5_EXPORT_WITH_RC4_40_MD5:               return "TLS_KRB5_EXPORT_WITH_RC4_40_MD5";
        case TLS_PSK_WITH_NULL_SHA:                         return "TLS_PSK_WITH_NULL_SHA";
        case TLS_DHE_PSK_WITH_NULL_SHA:                     return "TLS_DHE_PSK_WITH_NULL_SHA";
        case TLS_RSA_PSK_WITH_NULL_SHA:                     return "TLS_RSA_PSK_WITH_NULL_SHA";
        case TLS_RSA_WITH_AES_128_CBC_SHA:                  return "TLS_RSA_WITH_AES_128_CBC_SHA";
        case TLS_DH_DSS_WITH_AES_128_CBC_SHA:               return "TLS_DH_DSS_WITH_AES_128_CBC_SHA";
        case TLS_DH_RSA_WITH_AES_128_CBC_SHA:               return "TLS_DH_RSA_WITH_AES_128_CBC_SHA";
        case TLS_DHE_DSS_WITH_AES_128_CBC_SHA:              return "TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
        case TLS_DHE_RSA_WITH_AES_128_CBC_SHA:              return "TLS_DHE_RSA_WITH_AES_128_CBC_SHA";
        case TLS_DH_anon_WITH_AES_128_CBC_SHA:              return "TLS_DH_anon_WITH_AES_128_CBC_SHA";
        case TLS_RSA_WITH_AES_256_CBC_SHA:                  return "TLS_RSA_WITH_AES_256_CBC_SHA";
        case TLS_DH_DSS_WITH_AES_256_CBC_SHA:               return "TLS_DH_DSS_WITH_AES_256_CBC_SHA";
        case TLS_DH_RSA_WITH_AES_256_CBC_SHA:               return "TLS_DH_RSA_WITH_AES_256_CBC_SHA";
        case TLS_DHE_DSS_WITH_AES_256_CBC_SHA:              return "TLS_DHE_DSS_WITH_AES_256_CBC_SHA";
        case TLS_DHE_RSA_WITH_AES_256_CBC_SHA:              return "TLS_DHE_RSA_WITH_AES_256_CBC_SHA";
        case TLS_DH_anon_WITH_AES_256_CBC_SHA:              return "TLS_DH_anon_WITH_AES_256_CBC_SHA";
        case TLS_RSA_WITH_NULL_SHA256:                      return "TLS_RSA_WITH_NULL_SHA256";
        case TLS_RSA_WITH_AES_128_CBC_SHA256:               return "TLS_RSA_WITH_AES_128_CBC_SHA256";
        case TLS_RSA_WITH_AES_256_CBC_SHA256:               return "TLS_RSA_WITH_AES_256_CBC_SHA256";
        case TLS_DH_DSS_WITH_AES_128_CBC_SHA256:            return "TLS_DH_DSS_WITH_AES_128_CBC_SHA256";
        case TLS_DH_RSA_WITH_AES_128_CBC_SHA256:            return "TLS_DH_RSA_WITH_AES_128_CBC_SHA256";
        case TLS_DHE_DSS_WITH_AES_128_CBC_SHA256:           return "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256";
        case TLS_RSA_WITH_CAMELLIA_128_CBC_SHA:             return "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA";
        case TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA:          return "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA";
        case TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA:          return "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA";
        case TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA:         return "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA";
        case TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA:         return "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA";
        case TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA:         return "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA";
        case TLS_DHE_RSA_WITH_AES_128_CBC_SHA256:           return "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256";
        case TLS_DH_DSS_WITH_AES_256_CBC_SHA256:            return "TLS_DH_DSS_WITH_AES_256_CBC_SHA256";
        case TLS_DH_RSA_WITH_AES_256_CBC_SHA256:            return "TLS_DH_RSA_WITH_AES_256_CBC_SHA256";
        case TLS_DHE_DSS_WITH_AES_256_CBC_SHA256:           return "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256";
        case TLS_DHE_RSA_WITH_AES_256_CBC_SHA256:           return "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256";
        case TLS_DH_anon_WITH_AES_128_CBC_SHA256:           return "TLS_DH_anon_WITH_AES_128_CBC_SHA256";
        case TLS_DH_anon_WITH_AES_256_CBC_SHA256:           return "TLS_DH_anon_WITH_AES_256_CBC_SHA256";
        case TLS_RSA_WITH_CAMELLIA_256_CBC_SHA:             return "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA";
        case TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA:          return "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA";
        case TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA:          return "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA";
        case TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA:         return "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA";
        case TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA:         return "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA";
        case TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA:         return "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA";
        case TLS_PSK_WITH_RC4_128_SHA:                      return "TLS_PSK_WITH_RC4_128_SHA";
        case TLS_PSK_WITH_3DES_EDE_CBC_SHA:                 return "TLS_PSK_WITH_3DES_EDE_CBC_SHA";
        case TLS_PSK_WITH_AES_128_CBC_SHA:                  return "TLS_PSK_WITH_AES_128_CBC_SHA";
        case TLS_PSK_WITH_AES_256_CBC_SHA:                  return "TLS_PSK_WITH_AES_256_CBC_SHA";
        case TLS_DHE_PSK_WITH_RC4_128_SHA:                  return "TLS_DHE_PSK_WITH_RC4_128_SHA";
        case TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA:             return "TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA";
        case TLS_DHE_PSK_WITH_AES_128_CBC_SHA:              return "TLS_DHE_PSK_WITH_AES_128_CBC_SHA";
        case TLS_DHE_PSK_WITH_AES_256_CBC_SHA:              return "TLS_DHE_PSK_WITH_AES_256_CBC_SHA";
        case TLS_RSA_PSK_WITH_RC4_128_SHA:                  return "TLS_RSA_PSK_WITH_RC4_128_SHA";
        case TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA:             return "TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA";
        case TLS_RSA_PSK_WITH_AES_128_CBC_SHA:              return "TLS_RSA_PSK_WITH_AES_128_CBC_SHA";
        case TLS_RSA_PSK_WITH_AES_256_CBC_SHA:              return "TLS_RSA_PSK_WITH_AES_256_CBC_SHA";
        case TLS_RSA_WITH_SEED_CBC_SHA:                     return "TLS_RSA_WITH_SEED_CBC_SHA";
        case TLS_DH_DSS_WITH_SEED_CBC_SHA:                  return "TLS_DH_DSS_WITH_SEED_CBC_SHA";
        case TLS_DH_RSA_WITH_SEED_CBC_SHA:                  return "TLS_DH_RSA_WITH_SEED_CBC_SHA";
        case TLS_DHE_DSS_WITH_SEED_CBC_SHA:                 return "TLS_DHE_DSS_WITH_SEED_CBC_SHA";
        case TLS_DHE_RSA_WITH_SEED_CBC_SHA:                 return "TLS_DHE_RSA_WITH_SEED_CBC_SHA";
        case TLS_DH_anon_WITH_SEED_CBC_SHA:                 return "TLS_DH_anon_WITH_SEED_CBC_SHA";
        case TLS_RSA_WITH_AES_128_GCM_SHA256:               return "TLS_RSA_WITH_AES_128_GCM_SHA256";
        case TLS_RSA_WITH_AES_256_GCM_SHA384:               return "TLS_RSA_WITH_AES_256_GCM_SHA384";
        case TLS_DHE_RSA_WITH_AES_128_GCM_SHA256:           return "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256";
        case TLS_DHE_RSA_WITH_AES_256_GCM_SHA384:           return "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384";
        case TLS_DH_RSA_WITH_AES_128_GCM_SHA256:            return "TLS_DH_RSA_WITH_AES_128_GCM_SHA256";
        case TLS_DH_RSA_WITH_AES_256_GCM_SHA384:            return "TLS_DH_RSA_WITH_AES_256_GCM_SHA384";
        case TLS_DHE_DSS_WITH_AES_128_GCM_SHA256:           return "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256";
        case TLS_DHE_DSS_WITH_AES_256_GCM_SHA384:           return "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384";
        case TLS_DH_DSS_WITH_AES_128_GCM_SHA256:            return "TLS_DH_DSS_WITH_AES_128_GCM_SHA256";
        case TLS_DH_DSS_WITH_AES_256_GCM_SHA384:            return "TLS_DH_DSS_WITH_AES_256_GCM_SHA384";
        case TLS_DH_anon_WITH_AES_128_GCM_SHA256:           return "TLS_DH_anon_WITH_AES_128_GCM_SHA256";
        case TLS_DH_anon_WITH_AES_256_GCM_SHA384:           return "TLS_DH_anon_WITH_AES_256_GCM_SHA384";
        case TLS_PSK_WITH_AES_128_GCM_SHA256:               return "TLS_PSK_WITH_AES_128_GCM_SHA256";
        case TLS_PSK_WITH_AES_256_GCM_SHA384:               return "TLS_PSK_WITH_AES_256_GCM_SHA384";
        case TLS_DHE_PSK_WITH_AES_128_GCM_SHA256:           return "TLS_DHE_PSK_WITH_AES_128_GCM_SHA256";
        case TLS_DHE_PSK_WITH_AES_256_GCM_SHA384:           return "TLS_DHE_PSK_WITH_AES_256_GCM_SHA384";
        case TLS_RSA_PSK_WITH_AES_128_GCM_SHA256:           return "TLS_RSA_PSK_WITH_AES_128_GCM_SHA256";
        case TLS_RSA_PSK_WITH_AES_256_GCM_SHA384:           return "TLS_RSA_PSK_WITH_AES_256_GCM_SHA384";
        case TLS_PSK_WITH_AES_128_CBC_SHA256:               return "TLS_PSK_WITH_AES_128_CBC_SHA256";
        case TLS_PSK_WITH_AES_256_CBC_SHA384:               return "TLS_PSK_WITH_AES_256_CBC_SHA384";
        case TLS_PSK_WITH_NULL_SHA256:                      return "TLS_PSK_WITH_NULL_SHA256";
        case TLS_PSK_WITH_NULL_SHA384:                      return "TLS_PSK_WITH_NULL_SHA384";
        case TLS_DHE_PSK_WITH_AES_128_CBC_SHA256:           return "TLS_DHE_PSK_WITH_AES_128_CBC_SHA256";
        case TLS_DHE_PSK_WITH_AES_256_CBC_SHA384:           return "TLS_DHE_PSK_WITH_AES_256_CBC_SHA384";
        case TLS_DHE_PSK_WITH_NULL_SHA256:                  return "TLS_DHE_PSK_WITH_NULL_SHA256";
        case TLS_DHE_PSK_WITH_NULL_SHA384:                  return "TLS_DHE_PSK_WITH_NULL_SHA384";
        case TLS_RSA_PSK_WITH_AES_128_CBC_SHA256:           return "TLS_RSA_PSK_WITH_AES_128_CBC_SHA256";
        case TLS_RSA_PSK_WITH_AES_256_CBC_SHA384:           return "TLS_RSA_PSK_WITH_AES_256_CBC_SHA384";
        case TLS_RSA_PSK_WITH_NULL_SHA256:                  return "TLS_RSA_PSK_WITH_NULL_SHA256";
        case TLS_RSA_PSK_WITH_NULL_SHA384:                  return "TLS_RSA_PSK_WITH_NULL_SHA384";
        case TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256:          return "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256:       return "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256:       return "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256:      return "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256:      return "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256:      return "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256:          return "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256";
        case TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256:       return "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256";
        case TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256:       return "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256";
        case TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256:      return "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256";
        case TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256:      return "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256";
        case TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256:      return "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256";
        case TLS_SM4_GCM_SM3:                               return "TLS_SM4_GCM_SM3";
        case TLS_SM4_CCM_SM3:                               return "TLS_SM4_CCM_SM3";
        case TLS_EMPTY_RENEGOTIATION_INFO_SCSV:             return "TLS_EMPTY_RENEGOTIATION_INFO_SCSV";
        case TLS_AES_128_GCM_SHA256:                        return "TLS_AES_128_GCM_SHA256";
        case TLS_AES_256_GCM_SHA384:                        return "TLS_AES_256_GCM_SHA384";
        case TLS_CHACHA20_POLY1305_SHA256:                  return "TLS_CHACHA20_POLY1305_SHA256";
        case TLS_AES_128_CCM_SHA256:                        return "TLS_AES_128_CCM_SHA256";
        case TLS_AES_128_CCM_8_SHA256:                      return "TLS_AES_128_CCM_8_SHA256";
        case TLS_AEGIS_256_SHA512:                          return "TLS_AEGIS_256_SHA512";
        case TLS_AEGIS_128L_SHA256:                         return "TLS_AEGIS_128L_SHA256";
        case TLS_FALLBACK_SCSV:                             return "TLS_FALLBACK_SCSV";
        case TLS_ECDH_ECDSA_WITH_NULL_SHA:                  return "TLS_ECDH_ECDSA_WITH_NULL_SHA";
        case TLS_ECDH_ECDSA_WITH_RC4_128_SHA:               return "TLS_ECDH_ECDSA_WITH_RC4_128_SHA";
        case TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA:          return "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA";
        case TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA:           return "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA";
        case TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA:           return "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA";
        case TLS_ECDHE_ECDSA_WITH_NULL_SHA:                 return "TLS_ECDHE_ECDSA_WITH_NULL_SHA";
        case TLS_ECDHE_ECDSA_WITH_RC4_128_SHA:              return "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA";
        case TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA:         return "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA";
        case TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA:          return "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA";
        case TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA:          return "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA";
        case TLS_ECDH_RSA_WITH_NULL_SHA:                    return "TLS_ECDH_RSA_WITH_NULL_SHA";
        case TLS_ECDH_RSA_WITH_RC4_128_SHA:                 return "TLS_ECDH_RSA_WITH_RC4_128_SHA";
        case TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA:            return "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA";
        case TLS_ECDH_RSA_WITH_AES_128_CBC_SHA:             return "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA";
        case TLS_ECDH_RSA_WITH_AES_256_CBC_SHA:             return "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA";
        case TLS_ECDHE_RSA_WITH_NULL_SHA:                   return "TLS_ECDHE_RSA_WITH_NULL_SHA";
        case TLS_ECDHE_RSA_WITH_RC4_128_SHA:                return "TLS_ECDHE_RSA_WITH_RC4_128_SHA";
        case TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA:           return "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA";
        case TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA:            return "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";
        case TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA:            return "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA";
        case TLS_ECDH_anon_WITH_NULL_SHA:                   return "TLS_ECDH_anon_WITH_NULL_SHA";
        case TLS_ECDH_anon_WITH_RC4_128_SHA:                return "TLS_ECDH_anon_WITH_RC4_128_SHA";
        case TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA:           return "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA";
        case TLS_ECDH_anon_WITH_AES_128_CBC_SHA:            return "TLS_ECDH_anon_WITH_AES_128_CBC_SHA";
        case TLS_ECDH_anon_WITH_AES_256_CBC_SHA:            return "TLS_ECDH_anon_WITH_AES_256_CBC_SHA";
        case TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA:             return "TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA";
        case TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA:         return "TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA";
        case TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA:         return "TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA";
        case TLS_SRP_SHA_WITH_AES_128_CBC_SHA:              return "TLS_SRP_SHA_WITH_AES_128_CBC_SHA";
        case TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA:          return "TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA";
        case TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA:          return "TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA";
        case TLS_SRP_SHA_WITH_AES_256_CBC_SHA:              return "TLS_SRP_SHA_WITH_AES_256_CBC_SHA";
        case TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA:          return "TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA";
        case TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA:          return "TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA";
        case TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256:       return "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256";
        case TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384:       return "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384";
        case TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256:        return "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256";
        case TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384:        return "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384";
        case TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256:         return "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";
        case TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384:         return "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384";
        case TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256:          return "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256";
        case TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384:          return "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384";
        case TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256:       return "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";
        case TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384:       return "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";
        case TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256:        return "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256";
        case TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384:        return "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384";
        case TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256:         return "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
        case TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384:         return "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";
        case TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256:          return "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256";
        case TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384:          return "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384";
        case TLS_ECDHE_PSK_WITH_RC4_128_SHA:                return "TLS_ECDHE_PSK_WITH_RC4_128_SHA";
        case TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA:           return "TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA";
        case TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA:            return "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA";
        case TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA:            return "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA";
        case TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256:         return "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256";
        case TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384:         return "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384";
        case TLS_ECDHE_PSK_WITH_NULL_SHA:                   return "TLS_ECDHE_PSK_WITH_NULL_SHA";
        case TLS_ECDHE_PSK_WITH_NULL_SHA256:                return "TLS_ECDHE_PSK_WITH_NULL_SHA256";
        case TLS_ECDHE_PSK_WITH_NULL_SHA384:                return "TLS_ECDHE_PSK_WITH_NULL_SHA384";
        case TLS_RSA_WITH_ARIA_128_CBC_SHA256:              return "TLS_RSA_WITH_ARIA_128_CBC_SHA256";
        case TLS_RSA_WITH_ARIA_256_CBC_SHA384:              return "TLS_RSA_WITH_ARIA_256_CBC_SHA384";
        case TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256:           return "TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256";
        case TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384:           return "TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384";
        case TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256:           return "TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256";
        case TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384:           return "TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384";
        case TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256:          return "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256";
        case TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384:          return "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384";
        case TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256:          return "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256";
        case TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384:          return "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384";
        case TLS_DH_anon_WITH_ARIA_128_CBC_SHA256:          return "TLS_DH_anon_WITH_ARIA_128_CBC_SHA256";
        case TLS_DH_anon_WITH_ARIA_256_CBC_SHA384:          return "TLS_DH_anon_WITH_ARIA_256_CBC_SHA384";
        case TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256:      return "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256";
        case TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384:      return "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384";
        case TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256:       return "TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256";
        case TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384:       return "TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384";
        case TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256:        return "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256";
        case TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384:        return "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384";
        case TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256:         return "TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256";
        case TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384:         return "TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384";
        case TLS_RSA_WITH_ARIA_128_GCM_SHA256:              return "TLS_RSA_WITH_ARIA_128_GCM_SHA256";
        case TLS_RSA_WITH_ARIA_256_GCM_SHA384:              return "TLS_RSA_WITH_ARIA_256_GCM_SHA384";
        case TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256:          return "TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256";
        case TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384:          return "TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384";
        case TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256:           return "TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256";
        case TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384:           return "TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384";
        case TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256:          return "TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256";
        case TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384:          return "TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384";
        case TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256:           return "TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256";
        case TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384:           return "TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384";
        case TLS_DH_anon_WITH_ARIA_128_GCM_SHA256:          return "TLS_DH_anon_WITH_ARIA_128_GCM_SHA256";
        case TLS_DH_anon_WITH_ARIA_256_GCM_SHA384:          return "TLS_DH_anon_WITH_ARIA_256_GCM_SHA384";
        case TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256:      return "TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256";
        case TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384:      return "TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384";
        case TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256:       return "TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256";
        case TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384:       return "TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384";
        case TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256:        return "TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256";
        case TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384:        return "TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384";
        case TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256:         return "TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256";
        case TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384:         return "TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384";
        case TLS_PSK_WITH_ARIA_128_CBC_SHA256:              return "TLS_PSK_WITH_ARIA_128_CBC_SHA256";
        case TLS_PSK_WITH_ARIA_256_CBC_SHA384:              return "TLS_PSK_WITH_ARIA_256_CBC_SHA384";
        case TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256:          return "TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256";
        case TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384:          return "TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384";
        case TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256:          return "TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256";
        case TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384:          return "TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384";
        case TLS_PSK_WITH_ARIA_128_GCM_SHA256:              return "TLS_PSK_WITH_ARIA_128_GCM_SHA256";
        case TLS_PSK_WITH_ARIA_256_GCM_SHA384:              return "TLS_PSK_WITH_ARIA_256_GCM_SHA384";
        case TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256:          return "TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256";
        case TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384:          return "TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384";
        case TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256:          return "TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256";
        case TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384:          return "TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384";
        case TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256:        return "TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256";
        case TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384:        return "TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384";
        case TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256:  return "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384:  return "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384";
        case TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256:   return "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384:   return "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384";
        case TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256:    return "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384:    return "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384";
        case TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256:     return "TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384:     return "TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384";
        case TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256:          return "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384:          return "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256:      return "TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384:      return "TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256:       return "TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384:       return "TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256:      return "TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384:      return "TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256:       return "TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384:       return "TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256:      return "TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384:      return "TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256:  return "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384:  return "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256:   return "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384:   return "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256:    return "TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384:    return "TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256:     return "TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384:     return "TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256:          return "TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384:          return "TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256:      return "TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384:      return "TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256:      return "TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256";
        case TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384:      return "TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384";
        case TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256:          return "TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384:          return "TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384";
        case TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256:      return "TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384:      return "TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384";
        case TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256:      return "TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384:      return "TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384";
        case TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256:    return "TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256";
        case TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384:    return "TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384";
        case TLS_RSA_WITH_AES_128_CCM:                      return "TLS_RSA_WITH_AES_128_CCM";
        case TLS_RSA_WITH_AES_256_CCM:                      return "TLS_RSA_WITH_AES_256_CCM";
        case TLS_DHE_RSA_WITH_AES_128_CCM:                  return "TLS_DHE_RSA_WITH_AES_128_CCM";
        case TLS_DHE_RSA_WITH_AES_256_CCM:                  return "TLS_DHE_RSA_WITH_AES_256_CCM";
        case TLS_RSA_WITH_AES_128_CCM_8:                    return "TLS_RSA_WITH_AES_128_CCM_8";
        case TLS_RSA_WITH_AES_256_CCM_8:                    return "TLS_RSA_WITH_AES_256_CCM_8";
        case TLS_DHE_RSA_WITH_AES_128_CCM_8:                return "TLS_DHE_RSA_WITH_AES_128_CCM_8";
        case TLS_DHE_RSA_WITH_AES_256_CCM_8:                return "TLS_DHE_RSA_WITH_AES_256_CCM_8";
        case TLS_PSK_WITH_AES_128_CCM:                      return "TLS_PSK_WITH_AES_128_CCM";
        case TLS_PSK_WITH_AES_256_CCM:                      return "TLS_PSK_WITH_AES_256_CCM";
        case TLS_DHE_PSK_WITH_AES_128_CCM:                  return "TLS_DHE_PSK_WITH_AES_128_CCM";
        case TLS_DHE_PSK_WITH_AES_256_CCM:                  return "TLS_DHE_PSK_WITH_AES_256_CCM";
        case TLS_PSK_WITH_AES_128_CCM_8:                    return "TLS_PSK_WITH_AES_128_CCM_8";
        case TLS_PSK_WITH_AES_256_CCM_8:                    return "TLS_PSK_WITH_AES_256_CCM_8";
        case TLS_PSK_DHE_WITH_AES_128_CCM_8:                return "TLS_PSK_DHE_WITH_AES_128_CCM_8";
        case TLS_PSK_DHE_WITH_AES_256_CCM_8:                return "TLS_PSK_DHE_WITH_AES_256_CCM_8";
        case TLS_ECDHE_ECDSA_WITH_AES_128_CCM:              return "TLS_ECDHE_ECDSA_WITH_AES_128_CCM";
        case TLS_ECDHE_ECDSA_WITH_AES_256_CCM:              return "TLS_ECDHE_ECDSA_WITH_AES_256_CCM";
        case TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8:            return "TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8";
        case TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8:            return "TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8";
        case TLS_ECCPWD_WITH_AES_128_GCM_SHA256:            return "TLS_ECCPWD_WITH_AES_128_GCM_SHA256";
        case TLS_ECCPWD_WITH_AES_256_GCM_SHA384:            return "TLS_ECCPWD_WITH_AES_256_GCM_SHA384";
        case TLS_ECCPWD_WITH_AES_128_CCM_SHA256:            return "TLS_ECCPWD_WITH_AES_128_CCM_SHA256";
        case TLS_ECCPWD_WITH_AES_256_CCM_SHA384:            return "TLS_ECCPWD_WITH_AES_256_CCM_SHA384";
        case TLS_SHA256_SHA256:                             return "TLS_SHA256_SHA256";
        case TLS_SHA384_SHA384:                             return "TLS_SHA384_SHA384";
        case TLS_GOSTR341112_256_WITH_KUZNYECHIK_CTR_OMAC:  return "TLS_GOSTR341112_256_WITH_KUZNYECHIK_CTR_OMAC";
        case TLS_GOSTR341112_256_WITH_MAGMA_CTR_OMAC:       return "TLS_GOSTR341112_256_WITH_MAGMA_CTR_OMAC";
        case TLS_GOSTR341112_256_WITH_28147_CNT_IMIT:       return "TLS_GOSTR341112_256_WITH_28147_CNT_IMIT";
        case TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_L:     return "TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_L";
        case TLS_GOSTR341112_256_WITH_MAGMA_MGM_L:          return "TLS_GOSTR341112_256_WITH_MAGMA_MGM_L";
        case TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_S:     return "TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_S";
        case TLS_GOSTR341112_256_WITH_MAGMA_MGM_S:          return "TLS_GOSTR341112_256_WITH_MAGMA_MGM_S";
        case TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256:   return "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256";
        case TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256: return "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256";
        case TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256:     return "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256";
        case TLS_PSK_WITH_CHACHA20_POLY1305_SHA256:         return "TLS_PSK_WITH_CHACHA20_POLY1305_SHA256";
        case TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256:   return "TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256";
        case TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256:     return "TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256";
        case TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256:     return "TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256";
        case TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256:         return "TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256";
        case TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384:         return "TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384";
        case TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256:       return "TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256";
        case TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256:         return "TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256";
        default:
            ;
        }
        return UNKNOWN;
    }
};

const static inline std::unordered_set<uint16_t> cipher_suites_list = {
    0x0000,
    0x0001,
    0x0002,
    0x0003,
    0x0004,
    0x0005,
    0x0006,
    0x0007,
    0x0008,
    0x0009,
    0x000A,
    0x000B,
    0x000C,
    0x000D,
    0x000E,
    0x000F,
    0x0010,
    0x0011,
    0x0012,
    0x0013,
    0x0014,
    0x0015,
    0x0016,
    0x0017,
    0x0018,
    0x0019,
    0x001A,
    0x001B,
    0x001E,
    0x001F,
    0x0020,
    0x0021,
    0x0022,
    0x0023,
    0x0024,
    0x0025,
    0x0026,
    0x0027,
    0x0028,
    0x0029,
    0x002A,
    0x002B,
    0x002C,
    0x002D,
    0x002E,
    0x002F,
    0x0030,
    0x0031,
    0x0032,
    0x0033,
    0x0034,
    0x0035,
    0x0036,
    0x0037,
    0x0038,
    0x0039,
    0x003A,
    0x003B,
    0x003C,
    0x003D,
    0x003E,
    0x003F,
    0x0040,
    0x0041,
    0x0042,
    0x0043,
    0x0044,
    0x0045,
    0x0046,
    0x0067,
    0x0068,
    0x0069,
    0x006A,
    0x006B,
    0x006C,
    0x006D,
    0x0084,
    0x0085,
    0x0086,
    0x0087,
    0x0088,
    0x0089,
    0x008A,
    0x008B,
    0x008C,
    0x008D,
    0x008E,
    0x008F,
    0x0090,
    0x0091,
    0x0092,
    0x0093,
    0x0094,
    0x0095,
    0x0096,
    0x0097,
    0x0098,
    0x0099,
    0x009A,
    0x009B,
    0x009C,
    0x009D,
    0x009E,
    0x009F,
    0x00A0,
    0x00A1,
    0x00A2,
    0x00A3,
    0x00A4,
    0x00A5,
    0x00A6,
    0x00A7,
    0x00A8,
    0x00A9,
    0x00AA,
    0x00AB,
    0x00AC,
    0x00AD,
    0x00AE,
    0x00AF,
    0x00B0,
    0x00B1,
    0x00B2,
    0x00B3,
    0x00B4,
    0x00B5,
    0x00B6,
    0x00B7,
    0x00B8,
    0x00B9,
    0x00BA,
    0x00BB,
    0x00BC,
    0x00BD,
    0x00BE,
    0x00BF,
    0x00C0,
    0x00C1,
    0x00C2,
    0x00C3,
    0x00C4,
    0x00C5,
    0x00C6,
    0x00C7,
    0x00FF,
    0x1301,
    0x1302,
    0x1303,
    0x1304,
    0x1305,
    0x1306,
    0x1307,
    0x5600,
    0xC001,
    0xC002,
    0xC003,
    0xC004,
    0xC005,
    0xC006,
    0xC007,
    0xC008,
    0xC009,
    0xC00A,
    0xC00B,
    0xC00C,
    0xC00D,
    0xC00E,
    0xC00F,
    0xC010,
    0xC011,
    0xC012,
    0xC013,
    0xC014,
    0xC015,
    0xC016,
    0xC017,
    0xC018,
    0xC019,
    0xC01A,
    0xC01B,
    0xC01C,
    0xC01D,
    0xC01E,
    0xC01F,
    0xC020,
    0xC021,
    0xC022,
    0xC023,
    0xC024,
    0xC025,
    0xC026,
    0xC027,
    0xC028,
    0xC029,
    0xC02A,
    0xC02B,
    0xC02C,
    0xC02D,
    0xC02E,
    0xC02F,
    0xC030,
    0xC031,
    0xC032,
    0xC033,
    0xC034,
    0xC035,
    0xC036,
    0xC037,
    0xC038,
    0xC039,
    0xC03A,
    0xC03B,
    0xC03C,
    0xC03D,
    0xC03E,
    0xC03F,
    0xC040,
    0xC041,
    0xC042,
    0xC043,
    0xC044,
    0xC045,
    0xC046,
    0xC047,
    0xC048,
    0xC049,
    0xC04A,
    0xC04B,
    0xC04C,
    0xC04D,
    0xC04E,
    0xC04F,
    0xC050,
    0xC051,
    0xC052,
    0xC053,
    0xC054,
    0xC055,
    0xC056,
    0xC057,
    0xC058,
    0xC059,
    0xC05A,
    0xC05B,
    0xC05C,
    0xC05D,
    0xC05E,
    0xC05F,
    0xC060,
    0xC061,
    0xC062,
    0xC063,
    0xC064,
    0xC065,
    0xC066,
    0xC067,
    0xC068,
    0xC069,
    0xC06A,
    0xC06B,
    0xC06C,
    0xC06D,
    0xC06E,
    0xC06F,
    0xC070,
    0xC071,
    0xC072,
    0xC073,
    0xC074,
    0xC075,
    0xC076,
    0xC077,
    0xC078,
    0xC079,
    0xC07A,
    0xC07B,
    0xC07C,
    0xC07D,
    0xC07E,
    0xC07F,
    0xC080,
    0xC081,
    0xC082,
    0xC083,
    0xC084,
    0xC085,
    0xC086,
    0xC087,
    0xC088,
    0xC089,
    0xC08A,
    0xC08B,
    0xC08C,
    0xC08D,
    0xC08E,
    0xC08F,
    0xC090,
    0xC091,
    0xC092,
    0xC093,
    0xC094,
    0xC095,
    0xC096,
    0xC097,
    0xC098,
    0xC099,
    0xC09A,
    0xC09B,
    0xC09C,
    0xC09D,
    0xC09E,
    0xC09F,
    0xC0A0,
    0xC0A1,
    0xC0A2,
    0xC0A3,
    0xC0A4,
    0xC0A5,
    0xC0A6,
    0xC0A7,
    0xC0A8,
    0xC0A9,
    0xC0AA,
    0xC0AB,
    0xC0AC,
    0xC0AD,
    0xC0AE,
    0xC0AF,
    0xC0B0,
    0xC0B1,
    0xC0B2,
    0xC0B3,
    0xC0B4,
    0xC0B5,
    0xC100,
    0xC101,
    0xC102,
    0xC103,
    0xC104,
    0xC105,
    0xC106,
    0xCCA8,
    0xCCA9,
    0xCCAA,
    0xCCAB,
    0xCCAC,
    0xCCAD,
    0xCCAE,
    0xD001,
    0xD002,
    0xD003,
    0xD005,
};

const static inline std::unordered_set<uint16_t> faketls_cipher_suite_exceptions = {
    0x0a0a,
    0xffa8,
    0xffa7,
    0x0081,
    0x0080,
    0x0064,
    0x0060,
    0x0061,
    0xcc13,
    0xcc14,
    0xff85,
    0xcc15,
    0x0066,
    0x0062,
    0x0063,
    0xfeff,
    0x0065,
    0xfefe,
    0x0082,
    0x0083,
    0x001d,
    0x001c,
    0xffe1,
    0xffe0,
    0x007e,
    0x007d,
    0x007c,
    0x0079,
    0x0078,
    0x0072,
    0x0077,
    0x0074,
    0x0073,
    0x004a,
    0x004b,
    0x004c,
    0x0049,
    0x0047,
    0x004e,
    0x004d,
    0x0048,
    0x005b,
    0x0057,
    0x005c,
    0x005a,
    0x0052,
    0x0059,
    0x0050,
    0x0056,
    0x0055,
    0x0053,
    0x0051,
    0x0058,
    0x0054,
    0x004f,
    0xe013,
    0xe003,
    0xe011,
    0xe001,
    0xff00,
    0xff01,
    0xff03,
    0xff02,
    0xff87,
    0x16ba,
    0x16b8,
    0x16b9,
    0x16b7,
    0x00fc,
    0x00fb,
    0xcafe
};

class supported_groups : public encoded<uint16_t> {

public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == UNKNOWN) {
            o.print_key_unknown_code("supported_groups", encoded<uint16_t>::value());
        } else {
            o.print_key_string("supported_groups", name);
        }
    }
    enum code {
        sect163k1                       = 1,
        sect163r1                       = 2,
        sect163r2                       = 3,
        sect193r1                       = 4,
        sect193r2                       = 5,
        sect233k1                       = 6,
        sect233r1                       = 7,
        sect239k1                       = 8,
        sect283k1                       = 9,
        sect283r1                       = 10,
        sect409k1                       = 11,
        sect409r1                       = 12,
        sect571k1                       = 13,
        sect571r1                       = 14,
        secp160k1                       = 15,
        secp160r1                       = 16,
        secp160r2                       = 17,
        secp192k1                       = 18,
        secp192r1                       = 19,
        secp224k1                       = 20,
        secp224r1                       = 21,
        secp256k1                       = 22,
        secp256r1                       = 23,
        secp384r1                       = 24,
        secp521r1                       = 25,
        brainpoolP256r1                 = 26,
        brainpoolP384r1                 = 27,
        brainpoolP512r1                 = 28,
        x25519                          = 29,
        x448                            = 30,
        brainpoolP256r1tls13            = 31,
        brainpoolP384r1tls13            = 32,
        brainpoolP512r1tls13            = 33,
        GC256A                          = 34,
        GC256B                          = 35,
        GC256C                          = 36,
        GC256D                          = 37,
        GC512A                          = 38,
        GC512B                          = 39,
        GC512C                          = 40,
        curveSM2                        = 41,
        ffdhe2048                       = 256,
        ffdhe3072                       = 257,
        ffdhe4096                       = 258,
        ffdhe6144                       = 259,
        ffdhe8192                       = 260,
        MLKEM512                        = 512,
        MLKEM768                        = 513,
        MLKEM1024                       = 514,
        SecP256r1MLKEM768               = 4587,
        X25519MLKEM768                  = 4588,
        SecP384r1MLKEM1024              = 4589,
        X25519Kyber768Draft00           = 25497,
        SecP256r1Kyber768Draft00        = 25498,
        arbitrary_explicit_prime_curves = 65281,
        arbitrary_explicit_char2_curves = 65282,
    };
    const char *get_name() const {
        switch(encoded<uint16_t>::value()) {
        case sect163k1:                       return "sect163k1";
        case sect163r1:                       return "sect163r1";
        case sect163r2:                       return "sect163r2";
        case sect193r1:                       return "sect193r1";
        case sect193r2:                       return "sect193r2";
        case sect233k1:                       return "sect233k1";
        case sect233r1:                       return "sect233r1";
        case sect239k1:                       return "sect239k1";
        case sect283k1:                       return "sect283k1";
        case sect283r1:                       return "sect283r1";
        case sect409k1:                       return "sect409k1";
        case sect409r1:                       return "sect409r1";
        case sect571k1:                       return "sect571k1";
        case sect571r1:                       return "sect571r1";
        case secp160k1:                       return "secp160k1";
        case secp160r1:                       return "secp160r1";
        case secp160r2:                       return "secp160r2";
        case secp192k1:                       return "secp192k1";
        case secp192r1:                       return "secp192r1";
        case secp224k1:                       return "secp224k1";
        case secp224r1:                       return "secp224r1";
        case secp256k1:                       return "secp256k1";
        case secp256r1:                       return "secp256r1";
        case secp384r1:                       return "secp384r1";
        case secp521r1:                       return "secp521r1";
        case brainpoolP256r1:                 return "brainpoolP256r1";
        case brainpoolP384r1:                 return "brainpoolP384r1";
        case brainpoolP512r1:                 return "brainpoolP512r1";
        case x25519:                          return "x25519";
        case x448:                            return "x448";
        case brainpoolP256r1tls13:            return "brainpoolP256r1tls13";
        case brainpoolP384r1tls13:            return "brainpoolP384r1tls13";
        case brainpoolP512r1tls13:            return "brainpoolP512r1tls13";
        case GC256A:                          return "GC256A";
        case GC256B:                          return "GC256B";
        case GC256C:                          return "GC256C";
        case GC256D:                          return "GC256D";
        case GC512A:                          return "GC512A";
        case GC512B:                          return "GC512B";
        case GC512C:                          return "GC512C";
        case curveSM2:                        return "curveSM2";
        case ffdhe2048:                       return "ffdhe2048";
        case ffdhe3072:                       return "ffdhe3072";
        case ffdhe4096:                       return "ffdhe4096";
        case ffdhe6144:                       return "ffdhe6144";
        case ffdhe8192:                       return "ffdhe8192";
        case MLKEM512:                        return "MLKEM512";
        case MLKEM768:                        return "MLKEM768";
        case MLKEM1024:                       return "MLKEM1024";
        case SecP256r1MLKEM768:               return "SecP256r1MLKEM768";
        case X25519MLKEM768:                  return "X25519MLKEM768";
        case SecP384r1MLKEM1024:              return "SecP384r1MLKEM1024";
        case X25519Kyber768Draft00:           return "X25519Kyber768Draft00";
        case SecP256r1Kyber768Draft00:        return "SecP256r1Kyber768Draft00";
        case arbitrary_explicit_prime_curves: return "arbitrary_explicit_prime_curves";
        case arbitrary_explicit_char2_curves: return "arbitrary_explicit_char2_curves";
        default:
            ;
        }
        return UNKNOWN;
    }
};

}    // namespace tls

#endif // TLS_PARAMETERS_HPP
