#include <stdint.h>
#include <unordered_map>


class oui {

    //    static std::unordered_map<uint32_t, const char *> &get_oui_dict();

static std::unordered_map<uint32_t, const char *> & get_oui_dict() {

#ifndef USE_OUI_DICT

    // create an empty dictionary - this compile-time option reduces code
    // size, and can significantly reduce build time.
    //
    static std::unordered_map<uint32_t, const char *> oui_dict = { };

#else

    static std::unordered_map<uint32_t, const char *> oui_dict = {
	    { 0x000000, "XEROX CORPORATION" },
	    { 0x000001, "XEROX CORPORATION" },
	    { 0x000002, "XEROX CORPORATION" },
        { 0x000003, "XEROX CORPORATION" },
        { 0x000004, "XEROX CORPORATION" },
        { 0x000005, "XEROX CORPORATION" },
        { 0x000006, "XEROX CORPORATION" },
        { 0x000007, "XEROX CORPORATION" },
        { 0x000008, "XEROX CORPORATION" },
        { 0x000009, "XEROX CORPORATION" },
        { 0x00000A, "OMRON TATEISI ELECTRONICS CO." },
        { 0x00000B, "MATRIX CORPORATION" },
        { 0x00000C, "Cisco Systems, Inc" },
        { 0x00000D, "FIBRONICS LTD." },
        { 0x00000E, "FUJITSU LIMITED" },
        { 0x00000F, "NEXT, INC." },
        { 0x000010, "SYTEK INC." },
        { 0x000011, "NORMEREL SYSTEMES" },
        { 0x000012, "INFORMATION TECHNOLOGY LIMITED" },
        { 0x000013, "CAMEX" },
        { 0x000014, "NETRONIX" },
        { 0x000015, "DATAPOINT CORPORATION" },
        { 0x000016, "DU PONT PIXEL SYSTEMS ." },
        { 0x000017, "Oracle" },
        { 0x000018, "WEBSTER COMPUTER CORPORATION" },
        { 0x000019, "APPLIED DYNAMICS INTERNATIONAL" },
        { 0x00001A, "ADVANCED MICRO DEVICES" },
        { 0x00001B, "Novell, Inc." },
        { 0x00001C, "BELL TECHNOLOGIES" },
        { 0x00001D, "Cabletron Systems, Inc." },
        { 0x00001E, "TELSIST INDUSTRIA ELECTRONICA" },
        { 0x00001F, "Telco Systems, Inc." },
        { 0x000020, "DATAINDUSTRIER DIAB AB" },
        { 0x000021, "SUREMAN COMP. & COMMUN. CORP." },
        { 0x000022, "VISUAL TECHNOLOGY INC." },
        { 0x000023, "ABB INDUSTRIAL SYSTEMS AB" },
        { 0x000024, "CONNECT AS" },
        { 0x000025, "RAMTEK CORP." },
        { 0x000026, "SHA-KEN CO., LTD." },
        { 0x000027, "JAPAN RADIO COMPANY" },
        { 0x000028, "PRODIGY SYSTEMS CORPORATION" },
        { 0x000029, "IMC NETWORKS CORP." },
        { 0x00002A, "TRW - SEDD/INP" },
        { 0x00002B, "CRISP AUTOMATION, INC" },
        { 0x00002C, "AUTOTOTE LIMITED" },
        { 0x00002D, "CHROMATICS INC" },
        { 0x00002E, "SOCIETE EVIRA" },
        { 0x00002F, "TIMEPLEX INC." },
        { 0x000030, "VG LABORATORY SYSTEMS LTD" },
        { 0x000031, "QPSX COMMUNICATIONS, LTD." },
        { 0x000032, "Marconi plc" },
        { 0x000033, "EGAN MACHINERY COMPANY" },
        { 0x000034, "NETWORK RESOURCES CORPORATION" },
        { 0x000035, "SPECTRAGRAPHICS CORPORATION" },
        { 0x000036, "ATARI CORPORATION" },
        { 0x000037, "OXFORD METRICS LIMITED" },
        { 0x000038, "CSS LABS" },
        { 0x000039, "TOSHIBA CORPORATION" },
        { 0x00003A, "CHYRON CORPORATION" },
        { 0x00003B, "i Controls, Inc." },
        { 0x00003C, "AUSPEX SYSTEMS INC." },
        { 0x00003D, "UNISYS" },
        { 0x00003E, "SIMPACT" },
        { 0x00003F, "SYNTREX, INC." },
        { 0x000040, "APPLICON, INC." },
        { 0x000041, "ICE CORPORATION" },
        { 0x000042, "METIER MANAGEMENT SYSTEMS LTD." },
        { 0x000043, "MICRO TECHNOLOGY" },
        { 0x000044, "CASTELLE CORPORATION" },
        { 0x000045, "FORD AEROSPACE & COMM. CORP." },
        { 0x000046, "OLIVETTI NORTH AMERICA" },
        { 0x000047, "NICOLET INSTRUMENTS CORP." },
        { 0x000048, "Seiko Epson Corporation" },
        { 0x000049, "APRICOT COMPUTERS, LTD" },
        { 0x00004A, "ADC CODENOLL TECHNOLOGY CORP." },
        { 0x00004B, "ICL DATA OY" },
        { 0x00004C, "NEC Corporation" },
        { 0x00004D, "DCI CORPORATION" },
        { 0x00004E, "AMPEX CORPORATION" },
        { 0x00004F, "LOGICRAFT, INC." },
        { 0x000050, "RADISYS CORPORATION" },
        { 0x000051, "HOB ELECTRONIC GMBH & CO. KG" },
        { 0x000052, "Intrusion.com, Inc." },
        { 0x000053, "COMPUCORP" },
        { 0x000054, "Schneider Electric" },
        { 0x000055, "COMMISSARIAT A L`ENERGIE ATOM." },
        { 0x000056, "DR. B. STRUCK" },
        { 0x000057, "SCITEX CORPORATION LTD." },
        { 0x000058, "RACORE COMPUTER PRODUCTS INC." },
        { 0x000059, "Hellige GMBH" },
        { 0x00005A, "SysKonnect GmbH" },
        { 0x00005B, "ELTEC ELEKTRONIK AG" },
        { 0x00005C, "TELEMATICS INTERNATIONAL INC." },
        { 0x00005D, "CS TELECOM" },
        { 0x00005E, "ICANN, IANA Department" },
        { 0x00005F, "Sumitomo Electric Industries, Ltd" },
        { 0x000060, "KONTRON ELEKTRONIK GMBH" },
        { 0x000061, "GATEWAY COMMUNICATIONS" },
        { 0x000062, "BULL HN INFORMATION SYSTEMS" },
        { 0x000063, "BARCO CONTROL ROOMS GMBH" },
        { 0x000064, "Yokogawa Digital Computer Corporation" },
        { 0x000065, "Network General Corporation" },
        { 0x000066, "TALARIS SYSTEMS, INC." },
        { 0x000067, "SOFT * RITE, INC." },
        { 0x000068, "ROSEMOUNT CONTROLS" },
        { 0x000069, "CONCORD COMMUNICATIONS INC" },
        { 0x00006A, "COMPUTER CONSOLES INC." },
        { 0x00006B, "Silicon Graphics" },
        { 0x00006C, "Private" },
        { 0x00006D, "CRAY COMMUNICATIONS, LTD." },
        { 0x00006E, "Artisoft Inc." },
        { 0x00006F, "Madge Ltd." },
        { 0x000070, "HCL LIMITED" },
        { 0x000071, "ADRA SYSTEMS INC." },
        { 0x000072, "MINIWARE TECHNOLOGY" },
        { 0x000073, "SIECOR CORPORATION" },
        { 0x000074, "RICOH COMPANY LTD." },
        { 0x000075, "Nortel Networks" },
        { 0x000076, "ABEKAS VIDEO SYSTEM" },
        { 0x000077, "INTERPHASE CORPORATION" },
        { 0x000078, "LABTAM LIMITED" },
        { 0x000079, "NETWORTH INCORPORATED" },
        { 0x00007A, "DANA COMPUTER INC." },
        { 0x00007B, "RESEARCH MACHINES" },
        { 0x00007C, "AMPERE INCORPORATED" },
        { 0x00007D, "Oracle Corporation" },
        { 0x00007E, "CLUSTRIX CORPORATION" },
        { 0x00007F, "LINOTYPE-HELL AG" },
        { 0x000080, "CRAY COMMUNICATIONS A/S" },
        { 0x000081, "Bay Networks" },
        { 0x000082, "LECTRA SYSTEMES SA" },
        { 0x000083, "TADPOLE TECHNOLOGY PLC" },
        { 0x000084, "SUPERNET" },
        { 0x000085, "CANON INC." },
        { 0x000086, "MEGAHERTZ CORPORATION" },
        { 0x000087, "HITACHI, LTD." },
        { 0x000088, "Brocade Communications Systems LLC" },
        { 0x000089, "CAYMAN SYSTEMS INC." },
        { 0x00008A, "DATAHOUSE INFORMATION SYSTEMS" },
        { 0x00008B, "INFOTRON" },
        { 0x00008C, "Alloy Computer Products (Australia) Pty Ltd" },
        { 0x00008D, "Cryptek Inc." },
        { 0x00008E, "SOLBOURNE COMPUTER, INC." },
        { 0x00008F, "Raytheon" },
        { 0x000090, "MICROCOM" },
        { 0x000091, "ANRITSU CORPORATION" },
        { 0x000092, "COGENT DATA TECHNOLOGIES" },
        { 0x000093, "PROTEON INC." },
        { 0x000094, "ASANTE TECHNOLOGIES" },
        { 0x000095, "SONY TEKTRONIX CORP." },
        { 0x000096, "MARCONI ELECTRONICS LTD." },
        { 0x000097, "Dell EMC" },
        { 0x000098, "CROSSCOMM CORPORATION" },
        { 0x000099, "MTX, INC." },
        { 0x00009A, "RC COMPUTER A/S" },
        { 0x00009B, "INFORMATION INTERNATIONAL, INC" },
        { 0x00009C, "ROLM MIL-SPEC COMPUTERS" },
        { 0x00009D, "LOCUS COMPUTING CORPORATION" },
        { 0x00009E, "MARLI S.A." },
        { 0x00009F, "AMERISTAR TECHNOLOGIES INC." },
        { 0x0000A0, "SANYO Electric Co., Ltd." },
        { 0x0000A1, "MARQUETTE ELECTRIC CO." },
        { 0x0000A2, "Bay Networks" },
        { 0x0000A3, "NETWORK APPLICATION TECHNOLOGY" },
        { 0x0000A4, "ACORN COMPUTERS LIMITED" },
        { 0x0000A5, "Tattile SRL" },
        { 0x0000A6, "NETWORK GENERAL CORPORATION" },
        { 0x0000A7, "NETWORK COMPUTING DEVICES INC." },
        { 0x0000A8, "Stratus Technologies" },
        { 0x0000A9, "NETWORK SYSTEMS CORP." },
        { 0x0000AA, "XEROX CORPORATION" },
        { 0x0000AB, "LOGIC MODELING CORPORATION" },
        { 0x0000AC, "CONWARE COMPUTER CONSULTING" },
        { 0x0000AD, "BRUKER INSTRUMENTS INC." },
        { 0x0000AE, "DASSAULT ELECTRONIQUE" },
        { 0x0000AF, "Canberra Industries, Inc." },
        { 0x0000B0, "RND-RAD NETWORK DEVICES" },
        { 0x0000B1, "Alpha Micro" },
        { 0x0000B2, "TELEVIDEO SYSTEMS, INC." },
        { 0x0000B3, "CIMLINC INCORPORATED" },
        { 0x0000B4, "Edimax Technology Co. Ltd." },
        { 0x0000B5, "DATABILITY SOFTWARE SYS. INC." },
        { 0x0000B6, "MICRO-MATIC RESEARCH" },
        { 0x0000B7, "DOVE COMPUTER CORPORATION" },
        { 0x0000B8, "SEIKOSHA CO., LTD." },
        { 0x0000B9, "MCDONNELL DOUGLAS COMPUTER SYS" },
        { 0x0000BA, "SIIG, INC." },
        { 0x0000BB, "TRI-DATA" },
        { 0x0000BC, "Rockwell Automation" },
        { 0x0000BD, "Mitsubishi Cable Industries, Ltd. / Ryosei Systems" },
        { 0x0000BE, "THE NTI GROUP" },
        { 0x0000BF, "SYMMETRIC COMPUTER SYSTEMS" },
        { 0x0000C0, "WESTERN DIGITAL CORPORATION" },
        { 0x0000C1, "Madge Ltd." },
        { 0x0000C2, "INFORMATION PRESENTATION TECH." },
        { 0x0000C3, "Harris Corporation" },
        { 0x0000C4, "WATERS DIV. OF MILLIPORE" },
        { 0x0000C5, "ARRIS Group, Inc." },
        { 0x0000C6, "EON SYSTEMS" },
        { 0x0000C7, "ARIX CORPORATION" },
        { 0x0000C8, "ALTOS COMPUTER SYSTEMS" },
        { 0x0000C9, "Emulex Corporation" },
        { 0x0000CA, "ARRIS Group, Inc." },
        { 0x0000CB, "COMPU-SHACK ELECTRONIC GMBH" },
        { 0x0000CC, "DENSAN CO., LTD." },
        { 0x0000CD, "Allied Telesis Labs Ltd" },
        { 0x0000CE, "MEGADATA CORP." },
        { 0x0000CF, "HAYES MICROCOMPUTER PRODUCTS" },
        { 0x0000D0, "DEVELCON ELECTRONICS LTD." },
        { 0x0000D1, "ADAPTEC INCORPORATED" },
        { 0x0000D2, "SBE, INC." },
        { 0x0000D3, "WANG LABORATORIES INC." },
        { 0x0000D4, "PURE DATA LTD." },
        { 0x0000D5, "MICROGNOSIS INTERNATIONAL" },
        { 0x0000D6, "PUNCH LINE HOLDING" },
        { 0x0000D7, "DARTMOUTH COLLEGE" },
        { 0x0000D8, "Novell, Inc." },
        { 0x0000D9, "NIPPON TELEGRAPH & TELEPHONE" },
        { 0x0000DA, "ATEX" },
        { 0x0000DB, "British Telecommunications plc" },
        { 0x0000DC, "HAYES MICROCOMPUTER PRODUCTS" },
        { 0x0000DD, "TCL INCORPORATED" },
        { 0x0000DE, "CETIA" },
        { 0x0000DF, "BELL & HOWELL PUB SYS DIV" },
        { 0x0000E0, "QUADRAM CORP." },
        { 0x0000E1, "GRID SYSTEMS" },
        { 0x0000E2, "ACER TECHNOLOGIES CORP." },
        { 0x0000E3, "INTEGRATED MICRO PRODUCTS LTD" },
        { 0x0000E4, "IN2 GROUPE INTERTECHNIQUE" },
        { 0x0000E5, "SIGMEX LTD." },
        { 0x0000E6, "APTOR PRODUITS DE COMM INDUST" },
        { 0x0000E7, "Star Gate Technologies" },
        { 0x0000E8, "ACCTON TECHNOLOGY CORP." },
        { 0x0000E9, "ISICAD, INC." },
        { 0x0000EA, "UPNOD AB" },
        { 0x0000EB, "MATSUSHITA COMM. IND. CO. LTD." },
        { 0x0000EC, "MICROPROCESS" },
        { 0x0000ED, "APRIL" },
        { 0x0000EE, "NETWORK DESIGNERS, LTD." },
        { 0x0000EF, "KTI" },
        { 0x0000F0, "Samsung Electronics Co.,Ltd" },
        { 0x0000F1, "MAGNA COMPUTER CORPORATION" },
        { 0x0000F2, "SPIDER COMMUNICATIONS" },
        { 0x0000F3, "GANDALF DATA LIMITED" },
        { 0x0000F4, "Allied Telesis, Inc." },
        { 0x0000F5, "DIAMOND SALES LIMITED" },
        { 0x0000F6, "APPLIED MICROSYSTEMS CORP." },
        { 0x0000F7, "YOUTH KEEP ENTERPRISE CO LTD" },
        { 0x0000F8, "DIGITAL EQUIPMENT CORPORATION" },
        { 0x0000F9, "QUOTRON SYSTEMS INC." },
        { 0x0000FA, "MICROSAGE COMPUTER SYSTEMS INC" },
        { 0x0000FB, "RECHNER ZUR KOMMUNIKATION" },
        { 0x0000FC, "MEIKO" },
        { 0x0000FD, "HIGH LEVEL HARDWARE" },
        { 0x0000FE, "Annapolis Micro Systems, Inc." },
        { 0x0000FF, "CAMTEC ELECTRONICS LTD." },
        { 0x000100, "EQUIP'TRANS" },
        { 0x000101, "Private" },
        { 0x000102, "3COM" },
        { 0x000103, "3COM" },
        { 0x000104, "DVICO Co., Ltd." },
        { 0x000105, "Beckhoff Automation GmbH" },
        { 0x000106, "Tews Datentechnik GmbH" },
        { 0x000107, "Leiser GmbH" },
        { 0x000108, "AVLAB Technology, Inc." },
        { 0x000109, "Nagano Japan Radio Co., Ltd." },
        { 0x00010A, "CIS TECHNOLOGY INC." },
        { 0x00010B, "Space CyberLink, Inc." },
        { 0x00010C, "System Talks Inc." },
        { 0x00010D, "Teledyne DALSA Inc." },
        { 0x00010E, "Bri-Link Technologies Co., Ltd" },
        { 0x00010F, "Brocade Communications Systems LLC" },
        { 0x000110, "Gotham Networks" },
        { 0x000111, "iDigm Inc." },
        { 0x000112, "Shark Multimedia Inc." },
        { 0x000113, "OLYMPUS CORPORATION" },
        { 0x000114, "KANDA TSUSHIN KOGYO CO., LTD." },
        { 0x000115, "EXTRATECH CORPORATION" },
        { 0x000116, "Netspect Technologies, Inc." },
        { 0x000117, "Canal +" },
        { 0x000118, "EZ Digital Co., Ltd." },
        { 0x000119, "RTUnet (Australia)" },
        { 0x00011A, "Hoffmann und Burmeister GbR" },
        { 0x00011B, "Unizone Technologies, Inc." },
        { 0x00011C, "Universal Talkware Corporation" },
        { 0x00011D, "Centillium Communications" },
        { 0x00011E, "Precidia Technologies, Inc." },
        { 0x00011F, "RC Networks, Inc." },
        { 0x000120, "OSCILLOQUARTZ S.A." },
        { 0x000121, "WatchGuard Technologies, Inc." },
        { 0x000122, "Trend Communications, Ltd." },
        { 0x000123, "Schneider Electric Japan Holdings Ltd." },
        { 0x000124, "Acer Incorporated" },
        { 0x000125, "YAESU MUSEN CO., LTD." },
        { 0x000126, "PAC Labs" },
        { 0x000127, "OPEN Networks Pty Ltd" },
        { 0x000128, "EnjoyWeb, Inc." },
        { 0x000129, "DFI Inc." },
        { 0x00012A, "Telematica Sistems Inteligente" },
        { 0x00012B, "TELENET Co., Ltd." },
        { 0x00012C, "Aravox Technologies, Inc." },
        { 0x00012D, "Komodo Technology" },
        { 0x00012E, "PC Partner Ltd." },
        { 0x00012F, "Twinhead International Corp" },
        { 0x000130, "Extreme Networks, Inc." },
        { 0x000131, "Bosch Security Systems, Inc." },
        { 0x000132, "Dranetz - BMI" },
        { 0x000133, "KYOWA Electronic Instruments C" },
        { 0x000134, "Selectron Systems AG" },
        { 0x000135, "KDC Corp." },
        { 0x000136, "CyberTAN Technology Inc." },
        { 0x000137, "IT Farm Corporation" },
        { 0x000138, "XAVi Technologies Corp." },
        { 0x000139, "Point Multimedia Systems" },
        { 0x00013A, "SHELCAD COMMUNICATIONS, LTD." },
        { 0x00013B, "BNA SYSTEMS" },
        { 0x00013C, "TIW SYSTEMS" },
        { 0x00013D, "RiscStation Ltd." },
        { 0x00013E, "Ascom Tateco AB" },
        { 0x00013F, "Neighbor World Co., Ltd." },
        { 0x000140, "Sendtek Corporation" },
        { 0x000141, "CABLE PRINT" },
        { 0x000142, "Cisco Systems, Inc" },
        { 0x000143, "Cisco Systems, Inc" },
        { 0x000144, "Dell EMC" },
        { 0x000145, "WINSYSTEMS, INC." },
        { 0x000146, "Tesco Controls, Inc." },
        { 0x000147, "Zhone Technologies" },
        { 0x000148, "X-traWeb Inc." },
        { 0x000149, "TDT AG" },
        { 0x00014A, "Sony Corporation" },
        { 0x00014B, "Ennovate Networks, Inc." },
        { 0x00014C, "Berkeley Process Control" },
        { 0x00014D, "Shin Kin Enterprises Co., Ltd" },
        { 0x00014E, "WIN Enterprises, Inc." },
        { 0x00014F, "Adtran Inc" },
        { 0x000150, "GILAT COMMUNICATIONS, LTD." },
        { 0x000151, "Ensemble Communications" },
        { 0x000152, "CHROMATEK INC." },
        { 0x000153, "ARCHTEK TELECOM CORPORATION" },
        { 0x000154, "G3M Corporation" },
        { 0x000155, "Promise Technology, Inc." },
        { 0x000156, "FIREWIREDIRECT.COM, INC." },
        { 0x000157, "SYSWAVE CO., LTD" },
        { 0x000158, "Electro Industries/Gauge Tech" },
        { 0x000159, "S1 Corporation" },
        { 0x00015A, "Digital Video Broadcasting" },
        { 0x00015B, "ITALTEL S.p.A/RF-UP-I" },
        { 0x00015C, "CADANT INC." },
        { 0x00015D, "Oracle Corporation" },
        { 0x00015E, "BEST TECHNOLOGY CO., LTD." },
        { 0x00015F, "DIGITAL DESIGN GmbH" },
        { 0x000160, "ELMEX Co., LTD." },
        { 0x000161, "Meta Machine Technology" },
        { 0x000162, "Cygnet Technologies, Inc." },
        { 0x000163, "Cisco Systems, Inc" },
        { 0x000164, "Cisco Systems, Inc" },
        { 0x000165, "AirSwitch Corporation" },
        { 0x000166, "TC GROUP A/S" },
        { 0x000167, "HIOKI E.E. CORPORATION" },
        { 0x000168, "VITANA CORPORATION" },
        { 0x000169, "Celestix Networks Pte Ltd." },
        { 0x00016A, "ALITEC" },
        { 0x00016B, "LightChip, Inc." },
        { 0x00016C, "FOXCONN" },
        { 0x00016D, "CarrierComm Inc." },
        { 0x00016E, "Conklin Corporation" },
        { 0x00016F, "Inkel Corp." },
        { 0x000170, "ESE Embedded System Engineer'g" },
        { 0x000171, "Allied Data Technologies" },
        { 0x000172, "TechnoLand Co., LTD." },
        { 0x000173, "AMCC" },
        { 0x000174, "CyberOptics Corporation" },
        { 0x000175, "Radiant Communications Corp." },
        { 0x000176, "Orient Silver Enterprises" },
        { 0x000177, "EDSL" },
        { 0x000178, "MARGI Systems, Inc." },
        { 0x000179, "WIRELESS TECHNOLOGY, INC." },
        { 0x00017A, "Chengdu Maipu Electric Industrial Co., Ltd." },
        { 0x00017B, "Heidelberger Druckmaschinen AG" },
        { 0x00017C, "AG-E GmbH" },
        { 0x00017D, "ThermoQuest" },
        { 0x00017E, "ADTEK System Science Co., Ltd." },
        { 0x00017F, "Experience Music Project" },
        { 0x000180, "AOpen, Inc." },
        { 0x000181, "Nortel Networks" },
        { 0x000182, "DICA TECHNOLOGIES AG" },
        { 0x000183, "ANITE TELECOMS" },
        { 0x000184, "SIEB & MEYER AG" },
        { 0x000185, "Hitachi Aloka Medical, Ltd." },
        { 0x000186, "Uwe Disch" },
        { 0x000187, "I2SE GmbH" },
        { 0x000188, "LXCO Technologies ag" },
        { 0x000189, "Refraction Technology, Inc." },
        { 0x00018A, "ROI COMPUTER AG" },
        { 0x00018B, "NetLinks Co., Ltd." },
        { 0x00018C, "Mega Vision" },
        { 0x00018D, "AudeSi Technologies" },
        { 0x00018E, "Logitec Corporation" },
        { 0x00018F, "Kenetec, Inc." },
        { 0x000190, "SMK-M" },
        { 0x000191, "SYRED Data Systems" },
        { 0x000192, "Texas Digital Systems" },
        { 0x000193, "Hanbyul Telecom Co., Ltd." },
        { 0x000194, "Capital Equipment Corporation" },
        { 0x000195, "Sena Technologies, Inc." },
        { 0x000196, "Cisco Systems, Inc" },
        { 0x000197, "Cisco Systems, Inc" },
        { 0x000198, "Darim Vision" },
        { 0x000199, "HeiSei Electronics" },
        { 0x00019A, "LEUNIG GmbH" },
        { 0x00019B, "Kyoto Microcomputer Co., Ltd." },
        { 0x00019C, "JDS Uniphase Inc." },
        { 0x00019D, "E-Control Systems, Inc." },
        { 0x00019E, "ESS Technology, Inc." },
        { 0x00019F, "ReadyNet" },
        { 0x0001A0, "Infinilink Corporation" },
        { 0x0001A1, "Mag-Tek, Inc." },
        { 0x0001A2, "Logical Co., Ltd." },
        { 0x0001A3, "GENESYS LOGIC, INC." },
        { 0x0001A4, "Microlink Corporation" },
        { 0x0001A5, "Nextcomm, Inc." },
        { 0x0001A6, "Scientific-Atlanta Arcodan A/S" },
        { 0x0001A7, "UNEX TECHNOLOGY CORPORATION" },
        { 0x0001A8, "Welltech Computer Co., Ltd." },
        { 0x0001A9, "BMW AG" },
        { 0x0001AA, "Airspan Communications, Ltd." },
        { 0x0001AB, "Main Street Networks" },
        { 0x0001AC, "Sitara Networks, Inc." },
        { 0x0001AD, "Coach Master International d.b.a. CMI Worldwide, Inc." },
        { 0x0001AE, "Trex Enterprises" },
        { 0x0001AF, "Artesyn Embedded Technologies" },
        { 0x0001B0, "Fulltek Technology Co., Ltd." },
        { 0x0001B1, "General Bandwidth" },
        { 0x0001B2, "Digital Processing Systems, Inc." },
        { 0x0001B3, "Precision Electronic Manufacturing" },
        { 0x0001B4, "Wayport, Inc." },
        { 0x0001B5, "Turin Networks, Inc." },
        { 0x0001B6, "SAEJIN T&M Co., Ltd." },
        { 0x0001B7, "Centos, Inc." },
        { 0x0001B8, "Netsensity, Inc." },
        { 0x0001B9, "SKF (U.K.) Limited" },
        { 0x0001BA, "IC-Net, Inc." },
        { 0x0001BB, "Frequentis" },
        { 0x0001BC, "Brains Corporation" },
        { 0x0001BD, "Peterson Electro-Musical Products, Inc." },
        { 0x0001BE, "Gigalink Co., Ltd." },
        { 0x0001BF, "Teleforce Co., Ltd." },
        { 0x0001C0, "CompuLab, Ltd." },
        { 0x0001C1, "Vitesse Semiconductor Corporation" },
        { 0x0001C2, "ARK Research Corp." },
        { 0x0001C3, "Acromag, Inc." },
        { 0x0001C4, "NeoWave, Inc." },
        { 0x0001C5, "Simpler Networks" },
        { 0x0001C6, "Quarry Technologies" },
        { 0x0001C7, "Cisco Systems, Inc" },
        { 0x0001C8, "CONRAD CORP." },
        { 0x0001C8, "THOMAS CONRAD CORP." },
        { 0x0001C9, "Cisco Systems, Inc" },
        { 0x0001CA, "Geocast Network Systems, Inc." },
        { 0x0001CB, "EVR" },
        { 0x0001CC, "Japan Total Design Communication Co., Ltd." },
        { 0x0001CD, "ARtem" },
        { 0x0001CE, "Custom Micro Products, Ltd." },
        { 0x0001CF, "Alpha Data Parallel Systems, Ltd." },
        { 0x0001D0, "VitalPoint, Inc." },
        { 0x0001D1, "CoNet Communications, Inc." },
        { 0x0001D2, "inXtron, Inc." },
        { 0x0001D3, "PAXCOMM, Inc." },
        { 0x0001D4, "Leisure Time, Inc." },
        { 0x0001D5, "HAEDONG INFO & COMM CO., LTD" },
        { 0x0001D6, "manroland AG" },
        { 0x0001D7, "F5 Networks, Inc." },
        { 0x0001D8, "Teltronics, Inc." },
        { 0x0001D9, "Sigma, Inc." },
        { 0x0001DA, "WINCOMM Corporation" },
        { 0x0001DB, "Freecom Technologies GmbH" },
        { 0x0001DC, "Activetelco" },
        { 0x0001DD, "Avail Networks" },
        { 0x0001DE, "Trango Systems, Inc." },
        { 0x0001DF, "ISDN Communications, Ltd." },
        { 0x0001E0, "Fast Systems, Inc." },
        { 0x0001E1, "Kinpo Electronics, Inc." },
        { 0x0001E2, "Ando Electric Corporation" },
        { 0x0001E3, "Siemens AG" },
        { 0x0001E4, "Sitera, Inc." },
        { 0x0001E5, "Supernet, Inc." },
        { 0x0001E6, "Hewlett Packard" },
        { 0x0001E7, "Hewlett Packard" },
        { 0x0001E8, "Force10 Networks, Inc." },
        { 0x0001E9, "Litton Marine Systems B.V." },
        { 0x0001EA, "Cirilium Corp." },
        { 0x0001EB, "C-COM Corporation" },
        { 0x0001EC, "Ericsson Group" },
        { 0x0001ED, "SETA Corp." },
        { 0x0001EE, "Comtrol Europe, Ltd." },
        { 0x0001EF, "Camtel Technology Corp." },
        { 0x0001F0, "Tridium, Inc." },
        { 0x0001F1, "Innovative Concepts, Inc." },
        { 0x0001F2, "Mark of the Unicorn, Inc." },
        { 0x0001F3, "QPS, Inc." },
        { 0x0001F4, "Enterasys" },
        { 0x0001F5, "ERIM S.A." },
        { 0x0001F6, "Association of Musical Electronics Industry" },
        { 0x0001F7, "Image Display Systems, Inc." },
        { 0x0001F8, "TEXIO TECHNOLOGY CORPORATION" },
        { 0x0001F9, "TeraGlobal Communications Corp." },
        { 0x0001FA, "HOROSCAS" },
        { 0x0001FB, "DoTop Technology, Inc." },
        { 0x0001FC, "Keyence Corporation" },
        { 0x0001FD, "Digital Voice Systems, Inc." },
        { 0x0001FE, "DIGITAL EQUIPMENT CORPORATION" },
        { 0x0001FF, "Data Direct Networks, Inc." },
        { 0x000200, "Net & Sys Co., Ltd." },
        { 0x000201, "IFM Electronic gmbh" },
        { 0x000202, "Amino Communications, Ltd." },
        { 0x000203, "Woonsang Telecom, Inc." },
        { 0x000204, "Bodmann Industries Elektronik GmbH" },
        { 0x000205, "Hitachi Denshi, Ltd." },
        { 0x000206, "Telital R&D Denmark A/S" },
        { 0x000207, "VisionGlobal Network Corp." },
        { 0x000208, "Unify Networks, Inc." },
        { 0x000209, "Shenzhen SED Information Technology Co., Ltd." },
        { 0x00020A, "Gefran Spa" },
        { 0x00020B, "Native Networks, Inc." },
        { 0x00020C, "Metro-Optix" },
        { 0x00020D, "Micronpc.com" },
        { 0x00020E, "ECI Telecom Ltd." },
        { 0x00020F, "AATR" },
        { 0x000210, "Fenecom" },
        { 0x000211, "Nature Worldwide Technology Corp." },
        { 0x000212, "SierraCom" },
        { 0x000213, "S.D.E.L." },
        { 0x000214, "DTVRO" },
        { 0x000215, "Cotas Computer Technology A/B" },
        { 0x000216, "Cisco Systems, Inc" },
        { 0x000217, "Cisco Systems, Inc" },
        { 0x000218, "Advanced Scientific Corp" },
        { 0x000219, "Paralon Technologies" },
        { 0x00021A, "Zuma Networks" },
        { 0x00021B, "Kollmorgen-Servotronix" },
        { 0x00021C, "Network Elements, Inc." },
        { 0x00021D, "Data General Communication Ltd." },
        { 0x00021E, "SIMTEL S.R.L." },
        { 0x00021F, "Aculab PLC" },
        { 0x000220, "CANON FINETECH INC." },
        { 0x000221, "DSP Application, Ltd." },
        { 0x000222, "Chromisys, Inc." },
        { 0x000223, "ClickTV" },
        { 0x000224, "C-COR" },
        { 0x000225, "One Stop Systems" },
        { 0x000226, "XESystems, Inc." },
        { 0x000227, "ESD Electronic System Design GmbH" },
        { 0x000228, "Necsom, Ltd." },
        { 0x000229, "Adtec Corporation" },
        { 0x00022A, "Asound Electronic" },
        { 0x00022B, "SAXA, Inc." },
        { 0x00022C, "ABB Bomem, Inc." },
        { 0x00022D, "Agere Systems" },
        { 0x00022E, "TEAC Corp. R& D" },
        { 0x00022F, "P-Cube, Ltd." },
        { 0x000230, "Intersoft Electronics" },
        { 0x000231, "Ingersoll-Rand" },
        { 0x000232, "Avision, Inc." },
        { 0x000233, "Mantra Communications, Inc." },
        { 0x000234, "Imperial Technology, Inc." },
        { 0x000235, "Paragon Networks International" },
        { 0x000236, "INIT GmbH" },
        { 0x000237, "Cosmo Research Corp." },
        { 0x000238, "Serome Technology, Inc." },
        { 0x000239, "Visicom" },
        { 0x00023A, "ZSK Stickmaschinen GmbH" },
        { 0x00023B, "Ericsson" },
        { 0x00023C, "Creative Technology, Ltd." },
        { 0x00023D, "Cisco Systems, Inc" },
        { 0x00023E, "Selta Telematica S.p.a" },
        { 0x00023F, "Compal Electronics INC." },
        { 0x000240, "Seedek Co., Ltd." },
        { 0x000241, "Amer.com" },
        { 0x000242, "Videoframe Systems" },
        { 0x000243, "Raysis Co., Ltd." },
        { 0x000244, "SURECOM Technology Co." },
        { 0x000245, "Lampus Co, Ltd." },
        { 0x000246, "All-Win Tech Co., Ltd." },
        { 0x000247, "Great Dragon Information Technology (Group) Co., Ltd." },
        { 0x000248, "Pilz GmbH & Co." },
        { 0x000249, "Aviv Infocom Co, Ltd." },
        { 0x00024A, "Cisco Systems, Inc" },
        { 0x00024B, "Cisco Systems, Inc" },
        { 0x00024C, "SiByte, Inc." },
        { 0x00024D, "Mannesman Dematic Colby Pty. Ltd." },
        { 0x00024E, "Datacard Group" },
        { 0x00024F, "IPM Datacom S.R.L." },
        { 0x000250, "Geyser Networks, Inc." },
        { 0x000251, "Soma Networks, Inc." },
        { 0x000252, "Carrier Corporation" },
        { 0x000253, "Televideo, Inc." },
        { 0x000254, "WorldGate" },
        { 0x000255, "IBM Corp" },
        { 0x000256, "Alpha Processor, Inc." },
        { 0x000257, "Microcom Corp." },
        { 0x000258, "Flying Packets Communications" },
        { 0x000259, "Tsann Kuen China (Shanghai)Enterprise Co., Ltd. IT Group" },
        { 0x00025A, "Catena Networks" },
        { 0x00025B, "Cambridge Silicon Radio" },
        { 0x00025C, "SCI Systems (Kunshan) Co., Ltd." },
        { 0x00025D, "Calix Networks" },
        { 0x00025E, "High Technology Ltd" },
        { 0x00025F, "Nortel Networks" },
        { 0x000260, "Accordion Networks, Inc." },
        { 0x000261, "Tilgin AB" },
        { 0x000262, "Soyo Group Soyo Com Tech Co., Ltd" },
        { 0x000263, "UPS Manufacturing SRL" },
        { 0x000264, "AudioRamp.com" },
        { 0x000265, "Virditech Co. Ltd." },
        { 0x000266, "Thermalogic Corporation" },
        { 0x000267, "NODE RUNNER, INC." },
        { 0x000268, "Harris Government Communications" },
        { 0x000269, "Nadatel Co., Ltd" },
        { 0x00026A, "Cocess Telecom Co., Ltd." },
        { 0x00026B, "BCM Computers Co., Ltd." },
        { 0x00026C, "Philips CFT" },
        { 0x00026D, "Adept Telecom" },
        { 0x00026E, "NeGeN Access, Inc." },
        { 0x00026F, "Senao International Co., Ltd." },
        { 0x000270, "Crewave Co., Ltd." },
        { 0x000271, "Zhone Technologies" },
        { 0x000272, "CC&C Technologies, Inc." },
        { 0x000273, "Coriolis Networks" },
        { 0x000274, "Tommy Technologies Corp." },
        { 0x000275, "SMART Technologies, Inc." },
        { 0x000276, "Primax Electronics Ltd." },
        { 0x000277, "Cash Systemes Industrie" },
        { 0x000278, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x000279, "Control Applications, Ltd." },
        { 0x00027A, "IOI Technology Corporation" },
        { 0x00027B, "Amplify Net, Inc." },
        { 0x00027C, "Trilithic, Inc." },
        { 0x00027D, "Cisco Systems, Inc" },
        { 0x00027E, "Cisco Systems, Inc" },
        { 0x00027F, "ask-technologies.com" },
        { 0x000280, "Mu Net, Inc." },
        { 0x000281, "Madge Ltd." },
        { 0x000282, "ViaClix, Inc." },
        { 0x000283, "Spectrum Controls, Inc." },
        { 0x000284, "UK Grid Solutions Limited" },
        { 0x000285, "Riverstone Networks" },
        { 0x000286, "Occam Networks" },
        { 0x000287, "Adapcom" },
        { 0x000288, "GLOBAL VILLAGE COMMUNICATION" },
        { 0x000289, "DNE Technologies" },
        { 0x00028A, "Ambit Microsystems Corporation" },
        { 0x00028B, "VDSL Systems OY" },
        { 0x00028C, "Micrel-Synergy Semiconductor" },
        { 0x00028D, "Movita Technologies, Inc." },
        { 0x00028E, "Rapid 5 Networks, Inc." },
        { 0x00028F, "Globetek, Inc." },
        { 0x000290, "Woorigisool, Inc." },
        { 0x000291, "Open Network Co., Ltd." },
        { 0x000292, "Logic Innovations, Inc." },
        { 0x000293, "Solid Data Systems" },
        { 0x000294, "Tokyo Sokushin Co., Ltd." },
        { 0x000295, "IP.Access Limited" },
        { 0x000296, "Lectron Co,. Ltd." },
        { 0x000297, "C-COR.net" },
        { 0x000298, "Broadframe Corporation" },
        { 0x000299, "Apex, Inc." },
        { 0x00029A, "Storage Apps" },
        { 0x00029B, "Kreatel Communications AB" },
        { 0x00029C, "3COM" },
        { 0x00029D, "Merix Corp." },
        { 0x00029E, "Information Equipment Co., Ltd." },
        { 0x00029F, "L-3 Communication Aviation Recorders" },
        { 0x0002A0, "Flatstack Ltd." },
        { 0x0002A1, "World Wide Packets" },
        { 0x0002A2, "Hilscher GmbH" },
        { 0x0002A3, "ABB Switzerland Ltd, Power Systems" },
        { 0x0002A4, "AddPac Technology Co., Ltd." },
        { 0x0002A5, "Hewlett Packard" },
        { 0x0002A6, "Effinet Systems Co., Ltd." },
        { 0x0002A7, "Vivace Networks" },
        { 0x0002A8, "Air Link Technology" },
        { 0x0002A9, "RACOM, s.r.o." },
        { 0x0002AA, "PLcom Co., Ltd." },
        { 0x0002AB, "CTC Union Technologies Co., Ltd." },
        { 0x0002AC, "3PAR data" },
        { 0x0002AD, "HOYA Corporation" },
        { 0x0002AE, "Scannex Electronics Ltd." },
        { 0x0002AF, "TeleCruz Technology, Inc." },
        { 0x0002B0, "Hokubu Communication & Industrial Co., Ltd." },
        { 0x0002B1, "Anritsu, Ltd." },
        { 0x0002B2, "Cablevision" },
        { 0x0002B3, "Intel Corporation" },
        { 0x0002B4, "DAPHNE" },
        { 0x0002B5, "Avnet, Inc." },
        { 0x0002B6, "Acrosser Technology Co., Ltd." },
        { 0x0002B7, "Watanabe Electric Industry Co., Ltd." },
        { 0x0002B8, "WHI KONSULT AB" },
        { 0x0002B9, "Cisco Systems, Inc" },
        { 0x0002BA, "Cisco Systems, Inc" },
        { 0x0002BB, "Continuous Computing Corp" },
        { 0x0002BC, "LVL 7 Systems, Inc." },
        { 0x0002BD, "Bionet Co., Ltd." },
        { 0x0002BE, "Totsu Engineering, Inc." },
        { 0x0002BF, "dotRocket, Inc." },
        { 0x0002C0, "Bencent Tzeng Industry Co., Ltd." },
        { 0x0002C1, "Innovative Electronic Designs, Inc." },
        { 0x0002C2, "Net Vision Telecom" },
        { 0x0002C3, "Arelnet Ltd." },
        { 0x0002C4, "OPT Machine Vision Tech Co., Ltd" },
        { 0x0002C5, "Evertz Microsystems Ltd." },
        { 0x0002C6, "Data Track Technology PLC" },
        { 0x0002C7, "ALPS ELECTRIC CO., LTD." },
        { 0x0002C8, "Technocom Communications Technology (pte) Ltd" },
        { 0x0002C9, "Mellanox Technologies, Inc." },
        { 0x0002CA, "EndPoints, Inc." },
        { 0x0002CB, "TriState Ltd." },
        { 0x0002CC, "M.C.C.I" },
        { 0x0002CD, "TeleDream, Inc." },
        { 0x0002CE, "FoxJet, Inc." },
        { 0x0002CF, "ZyGate Communications, Inc." },
        { 0x0002D0, "Comdial Corporation" },
        { 0x0002D1, "Vivotek, Inc." },
        { 0x0002D2, "Workstation AG" },
        { 0x0002D3, "NetBotz, Inc." },
        { 0x0002D4, "PDA Peripherals, Inc." },
        { 0x0002D5, "ACR" },
        { 0x0002D6, "NICE Systems" },
        { 0x0002D7, "EMPEG Ltd" },
        { 0x0002D8, "BRECIS Communications Corporation" },
        { 0x0002D9, "Reliable Controls" },
        { 0x0002DA, "ExiO Communications, Inc." },
        { 0x0002DB, "NETSEC" },
        { 0x0002DC, "Fujitsu General Limited" },
        { 0x0002DD, "Bromax Communications, Ltd." },
        { 0x0002DE, "Astrodesign, Inc." },
        { 0x0002DF, "Net Com Systems, Inc." },
        { 0x0002E0, "ETAS GmbH" },
        { 0x0002E1, "Integrated Network Corporation" },
        { 0x0002E2, "NDC Infared Engineering" },
        { 0x0002E3, "LITE-ON Communications, Inc." },
        { 0x0002E4, "JC HYUN Systems, Inc." },
        { 0x0002E5, "Timeware Ltd." },
        { 0x0002E6, "Gould Instrument Systems, Inc." },
        { 0x0002E7, "CAB GmbH & Co KG" },
        { 0x0002E8, "E.D.&A." },
        { 0x0002E9, "CS Systemes De Securite - C3S" },
        { 0x0002EA, "Focus Enhancements" },
        { 0x0002EB, "Pico Communications" },
        { 0x0002EC, "Maschoff Design Engineering" },
        { 0x0002ED, "DXO Telecom Co., Ltd." },
        { 0x0002EE, "Nokia Danmark A/S" },
        { 0x0002EF, "CCC Network Systems Group Ltd." },
        { 0x0002F0, "AME Optimedia Technology Co., Ltd." },
        { 0x0002F1, "Pinetron Co., Ltd." },
        { 0x0002F2, "eDevice, Inc." },
        { 0x0002F3, "Media Serve Co., Ltd." },
        { 0x0002F4, "PCTEL, Inc." },
        { 0x0002F5, "VIVE Synergies, Inc." },
        { 0x0002F6, "Equipe Communications" },
        { 0x0002F7, "ARM" },
        { 0x0002F8, "SEAKR Engineering, Inc." },
        { 0x0002F9, "MIMOS Berhad" },
        { 0x0002FA, "DX Antenna Co., Ltd." },
        { 0x0002FB, "Baumuller Aulugen-Systemtechnik GmbH" },
        { 0x0002FC, "Cisco Systems, Inc" },
        { 0x0002FD, "Cisco Systems, Inc" },
        { 0x0002FE, "Viditec, Inc." },
        { 0x0002FF, "Handan BroadInfoCom" },
        { 0x000300, "Barracuda Networks, Inc." },
        { 0x000301, "EXFO" },
        { 0x000302, "Charles Industries, Ltd." },
        { 0x000303, "JAMA Electronics Co., Ltd." },
        { 0x000304, "Pacific Broadband Communications" },
        { 0x000305, "MSC Vertriebs GmbH" },
        { 0x000306, "Fusion In Tech Co., Ltd." },
        { 0x000307, "Secure Works, Inc." },
        { 0x000308, "AM Communications, Inc." },
        { 0x000309, "Texcel Technology PLC" },
        { 0x00030A, "Argus Technologies" },
        { 0x00030B, "Hunter Technology, Inc." },
        { 0x00030C, "Telesoft Technologies Ltd." },
        { 0x00030D, "Uniwill Computer Corp." },
        { 0x00030E, "Core Communications Co., Ltd." },
        { 0x00030F, "Digital China (Shanghai) Networks Ltd." },
        { 0x000310, "E-Globaledge Corporation" },
        { 0x000311, "Micro Technology Co., Ltd." },
        { 0x000312, "TRsystems GmbH" },
        { 0x000313, "Access Media SPA" },
        { 0x000314, "Teleware Network Systems" },
        { 0x000315, "Cidco Incorporated" },
        { 0x000316, "Nobell Communications, Inc." },
        { 0x000317, "Merlin Systems, Inc." },
        { 0x000318, "Cyras Systems, Inc." },
        { 0x000319, "Infineon AG" },
        { 0x00031A, "Beijing Broad Telecom Ltd., China" },
        { 0x00031B, "Cellvision Systems, Inc." },
        { 0x00031C, "Svenska Hardvarufabriken AB" },
        { 0x00031D, "Taiwan Commate Computer, Inc." },
        { 0x00031E, "Optranet, Inc." },
        { 0x00031F, "Condev Ltd." },
        { 0x000320, "Xpeed, Inc." },
        { 0x000321, "Reco Research Co., Ltd." },
        { 0x000322, "IDIS Co., Ltd." },
        { 0x000323, "Cornet Technology, Inc." },
        { 0x000324, "SANYO Consumer Electronics Co., Ltd." },
        { 0x000325, "Arima Computer Corp." },
        { 0x000326, "Iwasaki Information Systems Co., Ltd." },
        { 0x000327, "ACT'L" },
        { 0x000328, "Mace Group, Inc." },
        { 0x000329, "F3, Inc." },
        { 0x00032A, "UniData Communication Systems, Inc." },
        { 0x00032B, "GAI Datenfunksysteme GmbH" },
        { 0x00032C, "ABB Switzerland Ltd" },
        { 0x00032D, "IBASE Technology, Inc." },
        { 0x00032E, "Scope Information Management, Ltd." },
        { 0x00032F, "Global Sun Technology, Inc." },
        { 0x000330, "Imagenics, Co., Ltd." },
        { 0x000331, "Cisco Systems, Inc" },
        { 0x000332, "Cisco Systems, Inc" },
        { 0x000333, "Digitel Co., Ltd." },
        { 0x000334, "Omega Engineering Inc." },
        { 0x000335, "Mirae Technology" },
        { 0x000336, "Zetes Technologies" },
        { 0x000337, "Vaone, Inc." },
        { 0x000338, "Oak Technology" },
        { 0x000339, "Eurologic Systems, Ltd." },
        { 0x00033A, "Silicon Wave, Inc." },
        { 0x00033B, "TAMI Tech Co., Ltd." },
        { 0x00033C, "Daiden Co., Ltd." },
        { 0x00033D, "ILSHin Lab" },
        { 0x00033E, "Tateyama System Laboratory Co., Ltd." },
        { 0x00033F, "BigBand Networks, Ltd." },
        { 0x000340, "Floware Wireless Systems, Ltd." },
        { 0x000341, "Axon Digital Design" },
        { 0x000342, "Nortel Networks" },
        { 0x000343, "Martin Professional A/S" },
        { 0x000344, "Tietech.Co., Ltd." },
        { 0x000345, "Routrek Networks Corporation" },
        { 0x000346, "Hitachi Kokusai Electric, Inc." },
        { 0x000347, "Intel Corporation" },
        { 0x000348, "Norscan Instruments, Ltd." },
        { 0x000349, "Vidicode Datacommunicatie B.V." },
        { 0x00034A, "RIAS Corporation" },
        { 0x00034B, "Nortel Networks" },
        { 0x00034C, "Shanghai DigiVision Technology Co., Ltd." },
        { 0x00034D, "Chiaro Networks, Ltd." },
        { 0x00034E, "Pos Data Company, Ltd." },
        { 0x00034F, "Sur-Gard Security" },
        { 0x000350, "BTICINO SPA" },
        { 0x000351, "Diebold, Inc." },
        { 0x000352, "Colubris Networks" },
        { 0x000353, "Mitac, Inc." },
        { 0x000354, "Fiber Logic Communications" },
        { 0x000355, "TeraBeam Internet Systems" },
        { 0x000356, "Wincor Nixdorf International GmbH" },
        { 0x000357, "Intervoice-Brite, Inc." },
        { 0x000358, "Hanyang Digitech Co.Ltd" },
        { 0x000359, "DigitalSis" },
        { 0x00035A, "Photron Limited" },
        { 0x00035B, "BridgeWave Communications" },
        { 0x00035C, "Saint Song Corp." },
        { 0x00035D, "Bosung Hi-Net Co., Ltd." },
        { 0x00035E, "Metropolitan Area Networks, Inc." },
        { 0x00035F, "Prüftechnik Condition Monitoring GmbH & Co. KG" },
        { 0x000360, "PAC Interactive Technology, Inc." },
        { 0x000361, "Widcomm, Inc." },
        { 0x000362, "Vodtel Communications, Inc." },
        { 0x000363, "Miraesys Co., Ltd." },
        { 0x000364, "Scenix Semiconductor, Inc." },
        { 0x000365, "Kira Information & Communications, Ltd." },
        { 0x000366, "ASM Pacific Technology" },
        { 0x000367, "Jasmine Networks, Inc." },
        { 0x000368, "Embedone Co., Ltd." },
        { 0x000369, "Nippon Antenna Co., Ltd." },
        { 0x00036A, "Mainnet, Ltd." },
        { 0x00036B, "Cisco Systems, Inc" },
        { 0x00036C, "Cisco Systems, Inc" },
        { 0x00036D, "Runtop, Inc." },
        { 0x00036E, "Nicon Systems (Pty) Limited" },
        { 0x00036F, "Telsey SPA" },
        { 0x000370, "NXTV, Inc." },
        { 0x000371, "Acomz Networks Corp." },
        { 0x000372, "ULAN" },
        { 0x000373, "Aselsan A.S" },
        { 0x000374, "Control Microsystems" },
        { 0x000375, "NetMedia, Inc." },
        { 0x000376, "Graphtec Technology, Inc." },
        { 0x000377, "Gigabit Wireless" },
        { 0x000378, "HUMAX Co., Ltd." },
        { 0x000379, "Proscend Communications, Inc." },
        { 0x00037A, "Taiyo Yuden Co., Ltd." },
        { 0x00037B, "IDEC IZUMI Corporation" },
        { 0x00037C, "Coax Media" },
        { 0x00037D, "Stellcom" },
        { 0x00037E, "PORTech Communications, Inc." },
        { 0x00037F, "Atheros Communications, Inc." },
        { 0x000380, "SSH Communications Security Corp." },
        { 0x000381, "Ingenico International" },
        { 0x000382, "A-One Co., Ltd." },
        { 0x000383, "Metera Networks, Inc." },
        { 0x000384, "AETA" },
        { 0x000385, "Actelis Networks, Inc." },
        { 0x000386, "Ho Net, Inc." },
        { 0x000387, "Blaze Network Products" },
        { 0x000388, "Fastfame Technology Co., Ltd." },
        { 0x000389, "PLANTRONICS, INC." },
        { 0x00038A, "America Online, Inc." },
        { 0x00038B, "PLUS-ONE I&T, Inc." },
        { 0x00038C, "Total Impact" },
        { 0x00038D, "PCS Revenue Control Systems, Inc." },
        { 0x00038E, "Atoga Systems, Inc." },
        { 0x00038F, "Weinschel Corporation" },
        { 0x000390, "Digital Video Communications, Inc." },
        { 0x000391, "Advanced Digital Broadcast, Ltd." },
        { 0x000392, "Hyundai Teletek Co., Ltd." },
        { 0x000393, "Apple, Inc." },
        { 0x000394, "Connect One" },
        { 0x000395, "California Amplifier" },
        { 0x000396, "EZ Cast Co., Ltd." },
        { 0x000397, "FireBrick Limited" },
        { 0x000398, "WISI" },
        { 0x000399, "Dongju Informations & Communications Co., Ltd." },
        { 0x00039A, "SiConnect" },
        { 0x00039B, "NetChip Technology, Inc." },
        { 0x00039C, "OptiMight Communications, Inc." },
        { 0x00039D, "Qisda Corporation" },
        { 0x00039E, "Tera System Co., Ltd." },
        { 0x00039F, "Cisco Systems, Inc" },
        { 0x0003A0, "Cisco Systems, Inc" },
        { 0x0003A1, "HIPER Information & Communication, Inc." },
        { 0x0003A2, "Catapult Communications" },
        { 0x0003A3, "MAVIX, Ltd." },
        { 0x0003A4, "Imation Corp." },
        { 0x0003A5, "Medea Corporation" },
        { 0x0003A6, "Traxit Technology, Inc." },
        { 0x0003A7, "Unixtar Technology, Inc." },
        { 0x0003A8, "IDOT Computers, Inc." },
        { 0x0003A9, "AXCENT Media AG" },
        { 0x0003AA, "Watlow" },
        { 0x0003AB, "Bridge Information Systems" },
        { 0x0003AC, "Fronius Schweissmaschinen" },
        { 0x0003AD, "Emerson Energy Systems AB" },
        { 0x0003AE, "Allied Advanced Manufacturing Pte, Ltd." },
        { 0x0003AF, "Paragea Communications" },
        { 0x0003B0, "Xsense Technology Corp." },
        { 0x0003B1, "Hospira Inc." },
        { 0x0003B2, "Radware" },
        { 0x0003B3, "IA Link Systems Co., Ltd." },
        { 0x0003B4, "Macrotek International Corp." },
        { 0x0003B5, "Entra Technology Co." },
        { 0x0003B6, "QSI Corporation" },
        { 0x0003B7, "ZACCESS Systems" },
        { 0x0003B8, "NetKit Solutions, LLC" },
        { 0x0003B9, "Hualong Telecom Co., Ltd." },
        { 0x0003BA, "Oracle Corporation" },
        { 0x0003BB, "Signal Communications Limited" },
        { 0x0003BC, "COT GmbH" },
        { 0x0003BD, "OmniCluster Technologies, Inc." },
        { 0x0003BE, "Netility" },
        { 0x0003BF, "Centerpoint Broadband Technologies, Inc." },
        { 0x0003C0, "RFTNC Co., Ltd." },
        { 0x0003C1, "Packet Dynamics Ltd" },
        { 0x0003C2, "Solphone K.K." },
        { 0x0003C3, "Micronik Multimedia" },
        { 0x0003C4, "Tomra Systems ASA" },
        { 0x0003C5, "Mobotix AG" },
        { 0x0003C6, "ICUE Systems, Inc." },
        { 0x0003C7, "hopf Elektronik GmbH" },
        { 0x0003C8, "CML Emergency Services" },
        { 0x0003C9, "TECOM Co., Ltd." },
        { 0x0003CA, "MTS Systems Corp." },
        { 0x0003CB, "SystemGear Co., Ltd." },
        { 0x0003CC, "Momentum Computer, Inc." },
        { 0x0003CD, "Clovertech, Inc." },
        { 0x0003CE, "ETEN Technologies, Inc." },
        { 0x0003CF, "Muxcom, Inc." },
        { 0x0003D0, "KOANKEISO Co., Ltd." },
        { 0x0003D1, "Takaya Corporation" },
        { 0x0003D2, "Crossbeam Systems, Inc." },
        { 0x0003D3, "Internet Energy Systems, Inc." },
        { 0x0003D4, "Alloptic, Inc." },
        { 0x0003D5, "Advanced Communications Co., Ltd." },
        { 0x0003D6, "RADVision, Ltd." },
        { 0x0003D7, "NextNet Wireless, Inc." },
        { 0x0003D8, "iMPath Networks, Inc." },
        { 0x0003D9, "Secheron SA" },
        { 0x0003DA, "Takamisawa Cybernetics Co., Ltd." },
        { 0x0003DB, "Apogee Electronics Corp." },
        { 0x0003DC, "Lexar Media, Inc." },
        { 0x0003DD, "Comark Interactive Solutions" },
        { 0x0003DE, "OTC Wireless" },
        { 0x0003DF, "Desana Systems" },
        { 0x0003E0, "ARRIS Group, Inc." },
        { 0x0003E1, "Winmate Communication, Inc." },
        { 0x0003E2, "Comspace Corporation" },
        { 0x0003E3, "Cisco Systems, Inc" },
        { 0x0003E4, "Cisco Systems, Inc" },
        { 0x0003E5, "Hermstedt SG" },
        { 0x0003E6, "Entone, Inc." },
        { 0x0003E7, "Logostek Co. Ltd." },
        { 0x0003E8, "Wavesight Limited" },
        { 0x0003E9, "Akara Canada, Inc." },
        { 0x0003EA, "Mega System Technologies, Inc." },
        { 0x0003EB, "Atrica" },
        { 0x0003EC, "ICG Research, Inc." },
        { 0x0003ED, "Shinkawa Electric Co., Ltd." },
        { 0x0003EE, "MKNet Corporation" },
        { 0x0003EF, "Oneline AG" },
        { 0x0003F0, "Redfern Broadband Networks" },
        { 0x0003F1, "Cicada Semiconductor, Inc." },
        { 0x0003F2, "Seneca Networks" },
        { 0x0003F3, "Dazzle Multimedia, Inc." },
        { 0x0003F4, "NetBurner" },
        { 0x0003F5, "Chip2Chip" },
        { 0x0003F6, "Allegro Networks, Inc." },
        { 0x0003F7, "Plast-Control GmbH" },
        { 0x0003F8, "SanCastle Technologies, Inc." },
        { 0x0003F9, "Pleiades Communications, Inc." },
        { 0x0003FA, "TiMetra Networks" },
        { 0x0003FB, "ENEGATE Co.,Ltd." },
        { 0x0003FC, "Intertex Data AB" },
        { 0x0003FD, "Cisco Systems, Inc" },
        { 0x0003FE, "Cisco Systems, Inc" },
        { 0x0003FF, "Microsoft Corporation" },
        { 0x000400, "LEXMARK INTERNATIONAL, INC." },
        { 0x000401, "Osaki Electric Co., Ltd." },
        { 0x000402, "Nexsan Technologies, Ltd." },
        { 0x000403, "Nexsi Corporation" },
        { 0x000404, "Makino Milling Machine Co., Ltd." },
        { 0x000405, "ACN Technologies" },
        { 0x000406, "Fa. Metabox AG" },
        { 0x000407, "Topcon Positioning Systems, Inc." },
        { 0x000408, "Sanko Electronics Co., Ltd." },
        { 0x000409, "Cratos Networks" },
        { 0x00040A, "Sage Systems" },
        { 0x00040B, "3COM EUROPE LTD" },
        { 0x00040C, "Kanno Works, Ltd." },
        { 0x00040D, "Avaya Inc" },
        { 0x00040E, "AVM GmbH" },
        { 0x00040F, "Asus Network Technologies, Inc." },
        { 0x000410, "Spinnaker Networks, Inc." },
        { 0x000411, "Inkra Networks, Inc." },
        { 0x000412, "WaveSmith Networks, Inc." },
        { 0x000413, "snom technology GmbH" },
        { 0x000414, "Umezawa Musen Denki Co., Ltd." },
        { 0x000415, "Rasteme Systems Co., Ltd." },
        { 0x000416, "Parks S/A Comunicacoes Digitais" },
        { 0x000417, "ELAU AG" },
        { 0x000418, "Teltronic S.A.U." },
        { 0x000419, "Fibercycle Networks, Inc." },
        { 0x00041A, "Ines Test and Measurement GmbH & CoKG" },
        { 0x00041B, "Bridgeworks Ltd." },
        { 0x00041C, "ipDialog, Inc." },
        { 0x00041D, "Corega of America" },
        { 0x00041E, "Shikoku Instrumentation Co., Ltd." },
        { 0x00041F, "Sony Interactive Entertainment Inc." },
        { 0x000420, "Slim Devices, Inc." },
        { 0x000421, "Ocular Networks" },
        { 0x000422, "Studio Technologies, Inc" },
        { 0x000423, "Intel Corporation" },
        { 0x000424, "TMC s.r.l." },
        { 0x000425, "Atmel Corporation" },
        { 0x000426, "Autosys" },
        { 0x000427, "Cisco Systems, Inc" },
        { 0x000428, "Cisco Systems, Inc" },
        { 0x000429, "Pixord Corporation" },
        { 0x00042A, "Wireless Networks, Inc." },
        { 0x00042B, "IT Access Co., Ltd." },
        { 0x00042C, "Minet, Inc." },
        { 0x00042D, "Sarian Systems, Ltd." },
        { 0x00042E, "Netous Technologies, Ltd." },
        { 0x00042F, "International Communications Products, Inc." },
        { 0x000430, "Netgem" },
        { 0x000431, "GlobalStreams, Inc." },
        { 0x000432, "Voyetra Turtle Beach, Inc." },
        { 0x000433, "Cyberboard A/S" },
        { 0x000434, "Accelent Systems, Inc." },
        { 0x000435, "InfiNet LLC" },
        { 0x000436, "ELANsat Technologies, Inc." },
        { 0x000437, "Powin Information Technology, Inc." },
        { 0x000438, "Nortel Networks" },
        { 0x000439, "Rosco Entertainment Technology, Inc." },
        { 0x00043A, "Intelligent Telecommunications, Inc." },
        { 0x00043B, "Lava Computer Mfg., Inc." },
        { 0x00043C, "SONOS Co., Ltd." },
        { 0x00043D, "INDEL AG" },
        { 0x00043E, "Telencomm" },
        { 0x00043F, "ESTeem Wireless Modems, Inc" },
        { 0x000440, "cyberPIXIE, Inc." },
        { 0x000441, "Half Dome Systems, Inc." },
        { 0x000442, "NACT" },
        { 0x000443, "Agilent Technologies, Inc." },
        { 0x000444, "Western Multiplex Corporation" },
        { 0x000445, "LMS Skalar Instruments GmbH" },
        { 0x000446, "CYZENTECH Co., Ltd." },
        { 0x000447, "Acrowave Systems Co., Ltd." },
        { 0x000448, "Polaroid Corporation" },
        { 0x000449, "Mapletree Networks" },
        { 0x00044A, "iPolicy Networks, Inc." },
        { 0x00044B, "NVIDIA" },
        { 0x00044C, "JENOPTIK" },
        { 0x00044D, "Cisco Systems, Inc" },
        { 0x00044E, "Cisco Systems, Inc" },
        { 0x00044F, "Schubert System Elektronik Gmbh" },
        { 0x000450, "DMD Computers SRL" },
        { 0x000451, "Medrad, Inc." },
        { 0x000452, "RocketLogix, Inc." },
        { 0x000453, "YottaYotta, Inc." },
        { 0x000454, "Quadriga UK" },
        { 0x000455, "ANTARA.net" },
        { 0x000456, "Cambium Networks Limited" },
        { 0x000457, "Universal Access Technology, Inc." },
        { 0x000458, "Fusion X Co., Ltd." },
        { 0x000459, "Veristar Corporation" },
        { 0x00045A, "The Linksys Group, Inc." },
        { 0x00045B, "Techsan Electronics Co., Ltd." },
        { 0x00045C, "Mobiwave Pte Ltd" },
        { 0x00045D, "BEKA Elektronik" },
        { 0x00045E, "PolyTrax Information Technology AG" },
        { 0x00045F, "Avalue Technology, Inc." },
        { 0x000460, "Knilink Technology, Inc." },
        { 0x000461, "EPOX Computer Co., Ltd." },
        { 0x000462, "DAKOS Data & Communication Co., Ltd." },
        { 0x000463, "Bosch Security Systems" },
        { 0x000464, "Pulse-Link Inc" },
        { 0x000465, "i.s.t isdn-support technik GmbH" },
        { 0x000466, "ARMITEL Co." },
        { 0x000467, "Wuhan Research Institute of MII" },
        { 0x000468, "Vivity, Inc." },
        { 0x000469, "Innocom, Inc." },
        { 0x00046A, "Navini Networks" },
        { 0x00046B, "Palm Wireless, Inc." },
        { 0x00046C, "Cyber Technology Co., Ltd." },
        { 0x00046D, "Cisco Systems, Inc" },
        { 0x00046E, "Cisco Systems, Inc" },
        { 0x00046F, "Digitel S/A Industria Eletronica" },
        { 0x000470, "ipUnplugged AB" },
        { 0x000471, "IPrad" },
        { 0x000472, "Telelynx, Inc." },
        { 0x000473, "Photonex Corporation" },
        { 0x000474, "LEGRAND" },
        { 0x000475, "3COM" },
        { 0x000476, "3COM" },
        { 0x000477, "Scalant Systems, Inc." },
        { 0x000478, "G. Star Technology Corporation" },
        { 0x000479, "Radius Co., Ltd." },
        { 0x00047A, "AXXESSIT ASA" },
        { 0x00047B, "Schlumberger" },
        { 0x00047C, "Skidata AG" },
        { 0x00047D, "Pelco" },
        { 0x00047E, "Siqura B.V." },
        { 0x00047F, "Chr. Mayr GmbH & Co. KG" },
        { 0x000480, "Brocade Communications Systems LLC" },
        { 0x000481, "Econolite Control Products, Inc." },
        { 0x000482, "Medialogic Corp." },
        { 0x000483, "Deltron Technology, Inc." },
        { 0x000484, "Amann GmbH" },
        { 0x000485, "PicoLight" },
        { 0x000486, "ITTC, University of Kansas" },
        { 0x000487, "Cogency Semiconductor, Inc." },
        { 0x000488, "Eurotherm Controls" },
        { 0x000489, "YAFO Networks, Inc." },
        { 0x00048A, "Temia Vertriebs GmbH" },
        { 0x00048B, "Poscon Corporation" },
        { 0x00048C, "Nayna Networks, Inc." },
        { 0x00048D, "Teo Technologies, Inc" },
        { 0x00048E, "Ohm Tech Labs, Inc." },
        { 0x00048F, "TD Systems Corporation" },
        { 0x000490, "Optical Access" },
        { 0x000491, "Technovision, Inc." },
        { 0x000492, "Hive Internet, Ltd." },
        { 0x000493, "Tsinghua Unisplendour Co., Ltd." },
        { 0x000494, "Breezecom, Ltd." },
        { 0x000495, "Tejas Networks India Limited" },
        { 0x000496, "Extreme Networks, Inc." },
        { 0x000497, "MacroSystem Digital Video AG" },
        { 0x000498, "Mahi Networks" },
        { 0x000499, "Chino Corporation" },
        { 0x00049A, "Cisco Systems, Inc" },
        { 0x00049B, "Cisco Systems, Inc" },
        { 0x00049C, "Surgient Networks, Inc." },
        { 0x00049D, "Ipanema Technologies" },
        { 0x00049E, "Wirelink Co., Ltd." },
        { 0x00049F, "Freescale Semiconductor" },
        { 0x0004A0, "Verity Instruments, Inc." },
        { 0x0004A1, "Pathway Connectivity" },
        { 0x0004A2, "L.S.I. Japan Co., Ltd." },
        { 0x0004A3, "Microchip Technology Inc." },
        { 0x0004A4, "NetEnabled, Inc." },
        { 0x0004A5, "Barco Projection Systems NV" },
        { 0x0004A6, "SAF Tehnika Ltd." },
        { 0x0004A7, "FabiaTech Corporation" },
        { 0x0004A8, "Broadmax Technologies, Inc." },
        { 0x0004A9, "SandStream Technologies, Inc." },
        { 0x0004AA, "Jetstream Communications" },
        { 0x0004AB, "Mavenir Inc." },
        { 0x0004AC, "IBM Corp" },
        { 0x0004AD, "Malibu Networks" },
        { 0x0004AE, "Sullair Corporation" },
        { 0x0004AF, "Digital Fountain, Inc." },
        { 0x0004B0, "ELESIGN Co., Ltd." },
        { 0x0004B1, "Signal Technology, Inc." },
        { 0x0004B2, "ESSEGI SRL" },
        { 0x0004B3, "Videotek, Inc." },
        { 0x0004B4, "CIAC" },
        { 0x0004B5, "Equitrac Corporation" },
        { 0x0004B6, "Stratex Networks, Inc." },
        { 0x0004B7, "AMB i.t. Holding" },
        { 0x0004B8, "Kumahira Co., Ltd." },
        { 0x0004B9, "S.I. Soubou, Inc." },
        { 0x0004BA, "KDD Media Will Corporation" },
        { 0x0004BB, "Bardac Corporation" },
        { 0x0004BC, "Giantec, Inc." },
        { 0x0004BD, "ARRIS Group, Inc." },
        { 0x0004BE, "OptXCon, Inc." },
        { 0x0004BF, "VersaLogic Corp." },
        { 0x0004C0, "Cisco Systems, Inc" },
        { 0x0004C1, "Cisco Systems, Inc" },
        { 0x0004C2, "Magnipix, Inc." },
        { 0x0004C3, "CASTOR Informatique" },
        { 0x0004C4, "Audiotonix Group Limited" },
        { 0x0004C5, "ASE Technologies, USA" },
        { 0x0004C6, "YAMAHA MOTOR CO.,LTD" },
        { 0x0004C7, "NetMount" },
        { 0x0004C8, "LIBA Maschinenfabrik GmbH" },
        { 0x0004C9, "Micro Electron Co., Ltd." },
        { 0x0004CA, "FreeMs Corp." },
        { 0x0004CB, "Tdsoft Communication, Ltd." },
        { 0x0004CC, "Peek Traffic B.V." },
        { 0x0004CD, "Extenway Solutions Inc" },
        { 0x0004CE, "Patria Ailon" },
        { 0x0004CF, "Seagate Technology" },
        { 0x0004D0, "Softlink s.r.o." },
        { 0x0004D1, "Drew Technologies, Inc." },
        { 0x0004D2, "Adcon Telemetry GmbH" },
        { 0x0004D3, "Toyokeiki Co., Ltd." },
        { 0x0004D4, "Proview Electronics Co., Ltd." },
        { 0x0004D5, "Hitachi Information & Communication Engineering, Ltd." },
        { 0x0004D6, "Takagi Industrial Co., Ltd." },
        { 0x0004D7, "Omitec Instrumentation Ltd." },
        { 0x0004D8, "IPWireless, Inc." },
        { 0x0004D9, "Titan Electronics, Inc." },
        { 0x0004DA, "Relax Technology, Inc." },
        { 0x0004DB, "Tellus Group Corp." },
        { 0x0004DC, "Nortel Networks" },
        { 0x0004DD, "Cisco Systems, Inc" },
        { 0x0004DE, "Cisco Systems, Inc" },
        { 0x0004DF, "TERACOM TELEMATICA S.A" },
        { 0x0004E0, "Procket Networks" },
        { 0x0004E1, "Infinior Microsystems" },
        { 0x0004E2, "SMC Networks, Inc." },
        { 0x0004E3, "Accton Technology Corp" },
        { 0x0004E4, "Daeryung Ind., Inc." },
        { 0x0004E5, "Glonet Systems, Inc." },
        { 0x0004E6, "Banyan Network Private Limited" },
        { 0x0004E7, "Lightpointe Communications, Inc" },
        { 0x0004E8, "IER, Inc." },
        { 0x0004E9, "Infiniswitch Corporation" },
        { 0x0004EA, "Hewlett Packard" },
        { 0x0004EB, "Paxonet Communications, Inc." },
        { 0x0004EC, "Memobox SA" },
        { 0x0004ED, "Billion Electric Co., Ltd." },
        { 0x0004EE, "Lincoln Electric Company" },
        { 0x0004EF, "Polestar Corp." },
        { 0x0004F0, "International Computers, Ltd" },
        { 0x0004F1, "WhereNet" },
        { 0x0004F2, "Polycom" },
        { 0x0004F3, "FS FORTH-SYSTEME GmbH" },
        { 0x0004F4, "Infinite Electronics Inc." },
        { 0x0004F5, "SnowShore Networks, Inc." },
        { 0x0004F6, "Amphus" },
        { 0x0004F7, "Omega Band, Inc." },
        { 0x0004F8, "QUALICABLE TV Industria E Com., Ltda" },
        { 0x0004F9, "Xtera Communications, Inc." },
        { 0x0004FA, "NBS Technologies Inc." },
        { 0x0004FB, "Commtech, Inc." },
        { 0x0004FC, "Stratus Technologies" },
        { 0x0004FD, "Japan Control Engineering Co., Ltd." },
        { 0x0004FE, "Pelago Networks" },
        { 0x0004FF, "Acronet Co., Ltd." },
        { 0x000500, "Cisco Systems, Inc" },
        { 0x000501, "Cisco Systems, Inc" },
        { 0x000502, "Apple, Inc." },
        { 0x000503, "ICONAG" },
        { 0x000504, "Naray Information & Communication Enterprise" },
        { 0x000505, "Systems Integration Solutions, Inc." },
        { 0x000506, "Reddo Networks AB" },
        { 0x000507, "Fine Appliance Corp." },
        { 0x000508, "Inetcam, Inc." },
        { 0x000509, "AVOC Nishimura Ltd." },
        { 0x00050A, "ICS Spa" },
        { 0x00050B, "SICOM Systems, Inc." },
        { 0x00050C, "Network Photonics, Inc." },
        { 0x00050D, "Midstream Technologies, Inc." },
        { 0x00050E, "3ware, Inc." },
        { 0x00050F, "Tanaka S/S Ltd." },
        { 0x000510, "Infinite Shanghai Communication Terminals Ltd." },
        { 0x000511, "Complementary Technologies Ltd" },
        { 0x000512, "Zebra Technologies Inc" },
        { 0x000513, "VTLinx Multimedia Systems, Inc." },
        { 0x000514, "KDT Systems Co., Ltd." },
        { 0x000515, "Nuark Co., Ltd." },
        { 0x000516, "SMART Modular Technologies" },
        { 0x000517, "Shellcomm, Inc." },
        { 0x000518, "Jupiters Technology" },
        { 0x000519, "Siemens Building Technologies AG," },
        { 0x00051A, "3COM EUROPE LTD" },
        { 0x00051B, "Magic Control Technology Corporation" },
        { 0x00051C, "Xnet Technology Corp." },
        { 0x00051D, "Airocon, Inc." },
        { 0x00051E, "Brocade Communications Systems LLC" },
        { 0x00051F, "Taijin Media Co., Ltd." },
        { 0x000520, "Smartronix, Inc." },
        { 0x000521, "Control Microsystems" },
        { 0x000522, "LEA*D Corporation, Inc." },
        { 0x000523, "AVL List GmbH" },
        { 0x000524, "BTL System (HK) Limited" },
        { 0x000525, "Puretek Industrial Co., Ltd." },
        { 0x000526, "IPAS GmbH" },
        { 0x000527, "SJ Tek Co. Ltd" },
        { 0x000528, "New Focus, Inc." },
        { 0x000529, "Shanghai Broadan Communication Technology Co., Ltd" },
        { 0x00052A, "Ikegami Tsushinki Co., Ltd." },
        { 0x00052B, "HORIBA, Ltd." },
        { 0x00052C, "Supreme Magic Corporation" },
        { 0x00052D, "Zoltrix International Limited" },
        { 0x00052E, "Cinta Networks" },
        { 0x00052F, "Leviton Network Solutions" },
        { 0x000530, "Andiamo Systems, Inc." },
        { 0x000531, "Cisco Systems, Inc" },
        { 0x000532, "Cisco Systems, Inc" },
        { 0x000533, "Brocade Communications Systems LLC" },
        { 0x000534, "Northstar Engineering Ltd." },
        { 0x000535, "Chip PC Ltd." },
        { 0x000536, "Danam Communications, Inc." },
        { 0x000537, "Nets Technology Co., Ltd." },
        { 0x000538, "Merilus, Inc." },
        { 0x000539, "A Brand New World in Sweden AB" },
        { 0x00053A, "Willowglen Services Pte Ltd" },
        { 0x00053B, "Harbour Networks Ltd., Co. Beijing" },
        { 0x00053C, "XIRCOM" },
        { 0x00053D, "Agere Systems" },
        { 0x00053E, "KID Systeme GmbH" },
        { 0x00053F, "VisionTek, Inc." },
        { 0x000540, "FAST Corporation" },
        { 0x000541, "Advanced Systems Co., Ltd." },
        { 0x000542, "Otari, Inc." },
        { 0x000543, "IQ Wireless GmbH" },
        { 0x000544, "Valley Technologies, Inc." },
        { 0x000545, "Internet Photonics" },
        { 0x000546, "KDDI Network & Solultions Inc." },
        { 0x000547, "Starent Networks" },
        { 0x000548, "Disco Corporation" },
        { 0x000549, "Salira Optical Network Systems" },
        { 0x00054A, "Ario Data Networks, Inc." },
        { 0x00054B, "Eaton Automation AG" },
        { 0x00054C, "RF Innovations Pty Ltd" },
        { 0x00054D, "Brans Technologies, Inc." },
        { 0x00054E, "Philips" },
        { 0x00054F, "Garmin International" },
        { 0x000550, "Vcomms Connect Limited" },
        { 0x000551, "F & S Elektronik Systeme GmbH" },
        { 0x000552, "Xycotec Computer GmbH" },
        { 0x000553, "DVC Company, Inc." },
        { 0x000554, "Rangestar Wireless" },
        { 0x000555, "Japan Cash Machine Co., Ltd." },
        { 0x000556, "360 Systems" },
        { 0x000557, "Agile TV Corporation" },
        { 0x000558, "Synchronous, Inc." },
        { 0x000559, "Intracom S.A." },
        { 0x00055A, "Power Dsine Ltd." },
        { 0x00055B, "Charles Industries, Ltd." },
        { 0x00055C, "Kowa Company, Ltd." },
        { 0x00055D, "D-LINK SYSTEMS, INC." },
        { 0x00055E, "Cisco Systems, Inc" },
        { 0x00055F, "Cisco Systems, Inc" },
        { 0x000560, "LEADER COMM.CO., LTD" },
        { 0x000561, "nac Image Technology, Inc." },
        { 0x000562, "Digital View Limited" },
        { 0x000563, "J-Works, Inc." },
        { 0x000564, "Tsinghua Bitway Co., Ltd." },
        { 0x000565, "Tailyn Communication Company Ltd." },
        { 0x000566, "Secui.com Corporation" },
        { 0x000567, "Etymonic Design, Inc." },
        { 0x000568, "Piltofish Networks AB" },
        { 0x000569, "VMware, Inc." },
        { 0x00056A, "Heuft Systemtechnik GmbH" },
        { 0x00056B, "C.P. Technology Co., Ltd." },
        { 0x00056C, "Hung Chang Co., Ltd." },
        { 0x00056D, "Pacific Corporation" },
        { 0x00056E, "National Enhance Technology, Inc." },
        { 0x00056F, "Innomedia Technologies Pvt. Ltd." },
        { 0x000570, "Baydel Ltd." },
        { 0x000571, "Seiwa Electronics Co." },
        { 0x000572, "Deonet Co., Ltd." },
        { 0x000573, "Cisco Systems, Inc" },
        { 0x000574, "Cisco Systems, Inc" },
        { 0x000575, "CDS-Electronics BV" },
        { 0x000576, "NSM Technology Ltd." },
        { 0x000577, "SM Information & Communication" },
        { 0x000578, "Private" },
        { 0x000579, "Universal Control Solution Corp." },
        { 0x00057A, "Overture Networks" },
        { 0x00057B, "Chung Nam Electronic Co., Ltd." },
        { 0x00057C, "RCO Security AB" },
        { 0x00057D, "Sun Communications, Inc." },
        { 0x00057E, "Eckelmann Steuerungstechnik GmbH" },
        { 0x00057F, "Acqis Technology" },
        { 0x000580, "FibroLAN Ltd." },
        { 0x000581, "Snell" },
        { 0x000582, "ClearCube Technology" },
        { 0x000583, "ImageCom Limited" },
        { 0x000584, "AbsoluteValue Systems, Inc." },
        { 0x000585, "Juniper Networks" },
        { 0x000586, "Lucent Technologies" },
        { 0x000587, "Locus, Incorporated" },
        { 0x000588, "Sensoria Corp." },
        { 0x000589, "National Datacomputer" },
        { 0x00058A, "Netcom Co., Ltd." },
        { 0x00058B, "IPmental, Inc." },
        { 0x00058C, "Opentech Inc." },
        { 0x00058D, "Lynx Photonic Networks, Inc." },
        { 0x00058E, "Flextronics International GmbH & Co. Nfg. KG" },
        { 0x00058F, "CLCsoft co." },
        { 0x000590, "Swissvoice Ltd." },
        { 0x000591, "Active Silicon Ltd" },
        { 0x000592, "Pultek Corp." },
        { 0x000593, "Grammar Engine Inc." },
        { 0x000594, "HMS Industrial Networks" },
        { 0x000595, "Alesis Corporation" },
        { 0x000596, "Genotech Co., Ltd." },
        { 0x000597, "Eagle Traffic Control Systems" },
        { 0x000598, "CRONOS S.r.l." },
        { 0x000599, "DRS Test and Energy Management or DRS-TEM" },
        { 0x00059A, "Cisco Systems, Inc" },
        { 0x00059B, "Cisco Systems, Inc" },
        { 0x00059C, "Kleinknecht GmbH, Ing. Büro" },
        { 0x00059D, "Daniel Computing Systems, Inc." },
        { 0x00059E, "Zinwell Corporation" },
        { 0x00059F, "Yotta Networks, Inc." },
        { 0x0005A0, "MOBILINE Kft." },
        { 0x0005A1, "Zenocom" },
        { 0x0005A2, "CELOX Networks" },
        { 0x0005A3, "QEI, Inc." },
        { 0x0005A4, "Lucid Voice Ltd." },
        { 0x0005A5, "KOTT" },
        { 0x0005A6, "Extron Electronics" },
        { 0x0005A7, "HYPERCHIP Inc." },
        { 0x0005A8, "WYLE ELECTRONICS" },
        { 0x0005A9, "Princeton Networks, Inc." },
        { 0x0005AA, "Moore Industries International Inc." },
        { 0x0005AB, "Cyber Fone, Inc." },
        { 0x0005AC, "Northern Digital, Inc." },
        { 0x0005AD, "Topspin Communications, Inc." },
        { 0x0005AE, "Mediaport USA" },
        { 0x0005AF, "InnoScan Computing A/S" },
        { 0x0005B0, "Korea Computer Technology Co., Ltd." },
        { 0x0005B1, "ASB Technology BV" },
        { 0x0005B2, "Medison Co., Ltd." },
        { 0x0005B3, "Asahi-Engineering Co., Ltd." },
        { 0x0005B4, "Aceex Corporation" },
        { 0x0005B5, "Broadcom Technologies" },
        { 0x0005B6, "INSYS Microelectronics GmbH" },
        { 0x0005B7, "Arbor Technology Corp." },
        { 0x0005B8, "Electronic Design Associates, Inc." },
        { 0x0005B9, "Airvana, Inc." },
        { 0x0005BA, "Area Netwoeks, Inc." },
        { 0x0005BB, "Myspace AB" },
        { 0x0005BC, "Resource Data Management Ltd" },
        { 0x0005BD, "ROAX BV" },
        { 0x0005BE, "Kongsberg Seatex AS" },
        { 0x0005BF, "JustEzy Technology, Inc." },
        { 0x0005C0, "Digital Network Alacarte Co., Ltd." },
        { 0x0005C1, "A-Kyung Motion, Inc." },
        { 0x0005C2, "Soronti, Inc." },
        { 0x0005C3, "Pacific Instruments, Inc." },
        { 0x0005C4, "Telect, Inc." },
        { 0x0005C5, "Flaga HF" },
        { 0x0005C6, "Triz Communications" },
        { 0x0005C7, "I/F-COM A/S" },
        { 0x0005C8, "VERYTECH" },
        { 0x0005C9, "LG Innotek" },
        { 0x0005CA, "Hitron Technology, Inc." },
        { 0x0005CB, "ROIS Technologies, Inc." },
        { 0x0005CC, "Sumtel Communications, Inc." },
        { 0x0005CD, "D&M Holdings Inc." },
        { 0x0005CE, "Prolink Microsystems Corporation" },
        { 0x0005CF, "Thunder River Technologies, Inc." },
        { 0x0005D0, "Solinet Systems" },
        { 0x0005D1, "Metavector Technologies" },
        { 0x0005D2, "DAP Technologies" },
        { 0x0005D3, "eProduction Solutions, Inc." },
        { 0x0005D4, "FutureSmart Networks, Inc." },
        { 0x0005D5, "Speedcom Wireless" },
        { 0x0005D6, "L-3 Linkabit" },
        { 0x0005D7, "Vista Imaging, Inc." },
        { 0x0005D8, "Arescom, Inc." },
        { 0x0005D9, "Techno Valley, Inc." },
        { 0x0005DA, "Apex Automationstechnik" },
        { 0x0005DB, "PSI Nentec GmbH" },
        { 0x0005DC, "Cisco Systems, Inc" },
        { 0x0005DD, "Cisco Systems, Inc" },
        { 0x0005DE, "Gi Fone Korea, Inc." },
        { 0x0005DF, "Electronic Innovation, Inc." },
        { 0x0005E0, "Empirix Corp." },
        { 0x0005E1, "Trellis Photonics, Ltd." },
        { 0x0005E2, "Creativ Network Technologies" },
        { 0x0005E3, "LightSand Communications, Inc." },
        { 0x0005E4, "Red Lion Controls Inc." },
        { 0x0005E5, "Renishaw PLC" },
        { 0x0005E6, "Egenera, Inc." },
        { 0x0005E7, "Netrake an AudioCodes Company" },
        { 0x0005E8, "TurboWave, Inc." },
        { 0x0005E9, "Unicess Network, Inc." },
        { 0x0005EA, "Rednix" },
        { 0x0005EB, "Blue Ridge Networks, Inc." },
        { 0x0005EC, "Mosaic Systems Inc." },
        { 0x0005ED, "Technikum Joanneum GmbH" },
        { 0x0005EE, "Vanderbilt International (SWE) AB" },
        { 0x0005EF, "ADOIR Digital Technology" },
        { 0x0005F0, "SATEC" },
        { 0x0005F1, "Vrcom, Inc." },
        { 0x0005F2, "Power R, Inc." },
        { 0x0005F3, "Webyn" },
        { 0x0005F4, "System Base Co., Ltd." },
        { 0x0005F5, "Geospace Technologies" },
        { 0x0005F6, "Young Chang Co. Ltd." },
        { 0x0005F7, "Analog Devices, Inc." },
        { 0x0005F8, "Real Time Access, Inc." },
        { 0x0005F9, "TOA Corporation" },
        { 0x0005FA, "IPOptical, Inc." },
        { 0x0005FB, "ShareGate, Inc." },
        { 0x0005FC, "Schenck Pegasus Corp." },
        { 0x0005FD, "PacketLight Networks Ltd." },
        { 0x0005FE, "Traficon N.V." },
        { 0x0005FF, "SNS Solutions, Inc." },
        { 0x000600, "Toshiba Teli Corporation" },
        { 0x000601, "Otanikeiki Co., Ltd." },
        { 0x000602, "Cirkitech Electronics Co." },
        { 0x000603, "Baker Hughes Inc." },
        { 0x000604, "@Track Communications, Inc." },
        { 0x000605, "Inncom International, Inc." },
        { 0x000606, "RapidWAN, Inc." },
        { 0x000607, "Omni Directional Control Technology Inc." },
        { 0x000608, "At-Sky SAS" },
        { 0x000609, "Crossport Systems" },
        { 0x00060A, "Blue2space" },
        { 0x00060B, "Artesyn Embedded Technologies" },
        { 0x00060C, "Melco Industries, Inc." },
        { 0x00060D, "Wave7 Optics" },
        { 0x00060E, "IGYS Systems, Inc." },
        { 0x00060F, "Narad Networks Inc" },
        { 0x000610, "Abeona Networks Inc" },
        { 0x000611, "Zeus Wireless, Inc." },
        { 0x000612, "Accusys, Inc." },
        { 0x000613, "Kawasaki Microelectronics Incorporated" },
        { 0x000614, "Prism Holdings" },
        { 0x000615, "Kimoto Electric Co., Ltd." },
        { 0x000616, "Tel Net Co., Ltd." },
        { 0x000617, "Redswitch Inc." },
        { 0x000618, "DigiPower Manufacturing Inc." },
        { 0x000619, "Connection Technology Systems" },
        { 0x00061A, "Zetari Inc." },
        { 0x00061B, "Notebook Development Lab. Lenovo Japan Ltd." },
        { 0x00061C, "Hoshino Metal Industries, Ltd." },
        { 0x00061D, "MIP Telecom, Inc." },
        { 0x00061E, "Maxan Systems" },
        { 0x00061F, "Vision Components GmbH" },
        { 0x000620, "Serial System Ltd." },
        { 0x000621, "Hinox, Co., Ltd." },
        { 0x000622, "Chung Fu Chen Yeh Enterprise Corp." },
        { 0x000623, "MGE UPS Systems France" },
        { 0x000624, "Gentner Communications Corp." },
        { 0x000625, "The Linksys Group, Inc." },
        { 0x000626, "MWE GmbH" },
        { 0x000627, "Uniwide Technologies, Inc." },
        { 0x000628, "Cisco Systems, Inc" },
        { 0x000629, "IBM Corp" },
        { 0x00062A, "Cisco Systems, Inc" },
        { 0x00062B, "INTRASERVER TECHNOLOGY" },
        { 0x00062C, "Bivio Networks" },
        { 0x00062D, "TouchStar Technologies, L.L.C." },
        { 0x00062E, "Aristos Logic Corp." },
        { 0x00062F, "Pivotech Systems Inc." },
        { 0x000630, "Adtranz Sweden" },
        { 0x000631, "Calix Inc." },
        { 0x000632, "Mesco Engineering GmbH" },
        { 0x000633, "Cross Match Technologies GmbH" },
        { 0x000634, "GTE Airfone Inc." },
        { 0x000635, "PacketAir Networks, Inc." },
        { 0x000636, "Jedai Broadband Networks" },
        { 0x000637, "Toptrend-Meta Information (ShenZhen) Inc." },
        { 0x000638, "Sungjin C&C Co., Ltd." },
        { 0x000639, "Newtec" },
        { 0x00063A, "Dura Micro, Inc." },
        { 0x00063B, "Arcturus Networks Inc." },
        { 0x00063C, "Intrinsyc Software International Inc." },
        { 0x00063D, "Microwave Data Systems Inc." },
        { 0x00063E, "Opthos Inc." },
        { 0x00063F, "Everex Communications Inc." },
        { 0x000640, "White Rock Networks" },
        { 0x000641, "ITCN" },
        { 0x000642, "Genetel Systems Inc." },
        { 0x000643, "SONO Computer Co., Ltd." },
        { 0x000644, "NextGen Business Solutions, Inc" },
        { 0x000645, "Meisei Electric Co. Ltd." },
        { 0x000646, "ShenZhen XunBao Network Technology Co Ltd" },
        { 0x000647, "Etrali S.A." },
        { 0x000648, "Seedsware, Inc." },
        { 0x000649, "3M Deutschland GmbH" },
        { 0x00064A, "Honeywell Co., Ltd. (KOREA)" },
        { 0x00064B, "Alexon Co., Ltd." },
        { 0x00064C, "Invicta Networks, Inc." },
        { 0x00064D, "Sencore" },
        { 0x00064E, "Broad Net Technology Inc." },
        { 0x00064F, "PRO-NETS Technology Corporation" },
        { 0x000650, "Tiburon Networks, Inc." },
        { 0x000651, "Aspen Networks Inc." },
        { 0x000652, "Cisco Systems, Inc" },
        { 0x000653, "Cisco Systems, Inc" },
        { 0x000654, "Winpresa Building Automation Technologies GmbH" },
        { 0x000655, "Yipee, Inc." },
        { 0x000656, "Tactel AB" },
        { 0x000657, "Market Central, Inc." },
        { 0x000658, "Helmut Fischer GmbH Institut für Elektronik und Messtechnik" },
        { 0x000659, "EAL (Apeldoorn) B.V." },
        { 0x00065A, "Strix Systems" },
        { 0x00065B, "Dell Inc." },
        { 0x00065C, "Malachite Technologies, Inc." },
        { 0x00065D, "Heidelberg Web Systems" },
        { 0x00065E, "Photuris, Inc." },
        { 0x00065F, "ECI Telecom Ltd." },
        { 0x000660, "NADEX Co., Ltd." },
        { 0x000661, "NIA Home Technologies Corp." },
        { 0x000662, "MBM Technology Ltd." },
        { 0x000663, "Human Technology Co., Ltd." },
        { 0x000664, "Fostex Corporation" },
        { 0x000665, "Sunny Giken, Inc." },
        { 0x000666, "Roving Networks" },
        { 0x000667, "Tripp Lite" },
        { 0x000668, "Vicon Industries Inc." },
        { 0x000669, "Datasound Laboratories Ltd" },
        { 0x00066A, "InfiniCon Systems, Inc." },
        { 0x00066B, "Sysmex Corporation" },
        { 0x00066C, "Robinson Corporation" },
        { 0x00066D, "Compuprint S.P.A." },
        { 0x00066E, "Delta Electronics, Inc." },
        { 0x00066F, "Korea Data Systems" },
        { 0x000670, "Upponetti Oy" },
        { 0x000671, "Softing AG" },
        { 0x000672, "Netezza" },
        { 0x000673, "TKH Security Solutions USA" },
        { 0x000674, "Spectrum Control, Inc." },
        { 0x000675, "Banderacom, Inc." },
        { 0x000676, "Novra Technologies Inc." },
        { 0x000677, "SICK AG" },
        { 0x000678, "D&M Holdings Inc." },
        { 0x000679, "Konami Corporation" },
        { 0x00067A, "JMP Systems" },
        { 0x00067B, "Toplink C&C Corporation" },
        { 0x00067C, "Cisco Systems, Inc" },
        { 0x00067D, "Takasago Ltd." },
        { 0x00067E, "WinCom Systems, Inc." },
        { 0x00067F, "Digeo, Inc." },
        { 0x000680, "Card Access, Inc." },
        { 0x000681, "Goepel Electronic GmbH" },
        { 0x000682, "Convedia" },
        { 0x000683, "Bravara Communications, Inc." },
        { 0x000684, "Biacore AB" },
        { 0x000685, "NetNearU Corporation" },
        { 0x000686, "ZARDCOM Co., Ltd." },
        { 0x000687, "Omnitron Systems Technology, Inc." },
        { 0x000688, "Telways Communication Co., Ltd." },
        { 0x000689, "yLez Technologies Pte Ltd" },
        { 0x00068A, "NeuronNet Co. Ltd. R&D Center" },
        { 0x00068B, "AirRunner Technologies, Inc." },
        { 0x00068C, "3COM" },
        { 0x00068D, "SEPATON, Inc." },
        { 0x00068E, "HID Corporation" },
        { 0x00068F, "Telemonitor, Inc." },
        { 0x000690, "Euracom Communication GmbH" },
        { 0x000691, "PT Inovacao" },
        { 0x000692, "Intruvert Networks, Inc." },
        { 0x000693, "Flexus Computer Technology, Inc." },
        { 0x000694, "Mobillian Corporation" },
        { 0x000695, "Ensure Technologies, Inc." },
        { 0x000696, "Advent Networks" },
        { 0x000697, "R & D Center" },
        { 0x000698, "egnite GmbH" },
        { 0x000699, "Vida Design Co." },
        { 0x00069A, "e & Tel" },
        { 0x00069B, "AVT Audio Video Technologies GmbH" },
        { 0x00069C, "Transmode Systems AB" },
        { 0x00069D, "Petards Ltd" },
        { 0x00069E, "UNIQA, Inc." },
        { 0x00069F, "Kuokoa Networks" },
        { 0x0006A0, "Mx Imaging" },
        { 0x0006A1, "Celsian Technologies, Inc." },
        { 0x0006A2, "Microtune, Inc." },
        { 0x0006A3, "Bitran Corporation" },
        { 0x0006A4, "INNOWELL Corp." },
        { 0x0006A5, "PINON Corp." },
        { 0x0006A6, "Artistic Licence Engineering Ltd" },
        { 0x0006A7, "Primarion" },
        { 0x0006A8, "KC Technology, Inc." },
        { 0x0006A9, "Universal Instruments Corp." },
        { 0x0006AA, "VT Miltope" },
        { 0x0006AB, "W-Link Systems, Inc." },
        { 0x0006AC, "Intersoft Co." },
        { 0x0006AD, "KB Electronics Ltd." },
        { 0x0006AE, "Himachal Futuristic Communications Ltd" },
        { 0x0006AF, "Xalted Networks" },
        { 0x0006B0, "Comtech EF Data Corp." },
        { 0x0006B1, "Sonicwall" },
        { 0x0006B2, "Linxtek Co." },
        { 0x0006B3, "Diagraph Corporation" },
        { 0x0006B4, "Vorne Industries, Inc." },
        { 0x0006B5, "Source Photonics, Inc." },
        { 0x0006B6, "Nir-Or Israel Ltd." },
        { 0x0006B7, "TELEM GmbH" },
        { 0x0006B8, "Bandspeed Pty Ltd" },
        { 0x0006B9, "A5TEK Corp." },
        { 0x0006BA, "Westwave Communications" },
        { 0x0006BB, "ATI Technologies Inc." },
        { 0x0006BC, "Macrolink, Inc." },
        { 0x0006BD, "BNTECHNOLOGY Co., Ltd." },
        { 0x0006BE, "Baumer Optronic GmbH" },
        { 0x0006BF, "Accella Technologies Co., Ltd." },
        { 0x0006C0, "United Internetworks, Inc." },
        { 0x0006C1, "Cisco Systems, Inc" },
        { 0x0006C2, "Smartmatic Corporation" },
        { 0x0006C3, "Schindler Elevator Ltd." },
        { 0x0006C4, "Piolink Inc." },
        { 0x0006C5, "INNOVI Technologies Limited" },
        { 0x0006C6, "lesswire AG" },
        { 0x0006C7, "RFNET Technologies Pte Ltd (S)" },
        { 0x0006C8, "Sumitomo Metal Micro Devices, Inc." },
        { 0x0006C9, "Technical Marketing Research, Inc." },
        { 0x0006CA, "American Computer & Digital Components, Inc. (ACDC)" },
        { 0x0006CB, "Jotron Electronics A/S" },
        { 0x0006CC, "JMI Electronics Co., Ltd." },
        { 0x0006CD, "Leaf Imaging Ltd." },
        { 0x0006CE, "DATENO" },
        { 0x0006CF, "Thales Avionics In-Flight Systems, LLC" },
        { 0x0006D0, "Elgar Electronics Corp." },
        { 0x0006D1, "Tahoe Networks, Inc." },
        { 0x0006D2, "Tundra Semiconductor Corp." },
        { 0x0006D3, "Alpha Telecom, Inc. U.S.A." },
        { 0x0006D4, "Interactive Objects, Inc." },
        { 0x0006D5, "Diamond Systems Corp." },
        { 0x0006D6, "Cisco Systems, Inc" },
        { 0x0006D7, "Cisco Systems, Inc" },
        { 0x0006D8, "Maple Optical Systems" },
        { 0x0006D9, "IPM-Net S.p.A." },
        { 0x0006DA, "ITRAN Communications Ltd." },
        { 0x0006DB, "ICHIPS Co., Ltd." },
        { 0x0006DC, "Syabas Technology (Amquest)" },
        { 0x0006DD, "AT & T Laboratories - Cambridge Ltd" },
        { 0x0006DE, "Flash Technology" },
        { 0x0006DF, "AIDONIC Corporation" },
        { 0x0006E0, "MAT Co., Ltd." },
        { 0x0006E1, "Techno Trade s.a" },
        { 0x0006E2, "Ceemax Technology Co., Ltd." },
        { 0x0006E3, "Quantitative Imaging Corporation" },
        { 0x0006E4, "Citel Technologies Ltd." },
        { 0x0006E5, "Fujian Newland Computer Ltd. Co." },
        { 0x0006E6, "DongYang Telecom Co., Ltd." },
        { 0x0006E7, "Bit Blitz Communications Inc." },
        { 0x0006E8, "Optical Network Testing, Inc." },
        { 0x0006E9, "Intime Corp." },
        { 0x0006EA, "ELZET80 Mikrocomputer GmbH&Co. KG" },
        { 0x0006EB, "Global Data" },
        { 0x0006EC, "Harris Corporation" },
        { 0x0006ED, "Inara Networks" },
        { 0x0006EE, "Shenyang Neu-era Information & Technology Stock Co., Ltd" },
        { 0x0006EF, "Maxxan Systems, Inc." },
        { 0x0006F0, "Digeo, Inc." },
        { 0x0006F1, "Optillion" },
        { 0x0006F2, "Platys Communications" },
        { 0x0006F3, "AcceLight Networks" },
        { 0x0006F4, "Prime Electronics & Satellitics Inc." },
        { 0x0006F5, "ALPS ELECTRIC CO., LTD." },
        { 0x0006F6, "Cisco Systems, Inc" },
        { 0x0006F7, "ALPS ELECTRIC CO., LTD." },
        { 0x0006F8, "The Boeing Company" },
        { 0x0006F9, "Mitsui Zosen Systems Research Inc." },
        { 0x0006FA, "IP SQUARE Co, Ltd." },
        { 0x0006FB, "Hitachi Printing Solutions, Ltd." },
        { 0x0006FC, "Fnet Co., Ltd." },
        { 0x0006FD, "Comjet Information Systems Corp." },
        { 0x0006FE, "Ambrado, Inc" },
        { 0x0006FF, "Sheba Systems Co., Ltd." },
        { 0x000700, "Zettamedia Korea" },
        { 0x000701, "RACAL-DATACOM" },
        { 0x000702, "Varex Imaging" },
        { 0x000703, "CSEE Transport" },
        { 0x000704, "ALPS ELECTRIC CO., LTD." },
        { 0x000705, "Endress & Hauser GmbH & Co" },
        { 0x000706, "Sanritz Corporation" },
        { 0x000707, "Interalia Inc." },
        { 0x000708, "Bitrage Inc." },
        { 0x000709, "Westerstrand Urfabrik AB" },
        { 0x00070A, "Unicom Automation Co., Ltd." },
        { 0x00070B, "Novabase SGPS, SA" },
        { 0x00070C, "SVA-Intrusion.com Co. Ltd." },
        { 0x00070D, "Cisco Systems, Inc" },
        { 0x00070E, "Cisco Systems, Inc" },
        { 0x00070F, "Fujant, Inc." },
        { 0x000710, "Adax, Inc." },
        { 0x000711, "Acterna" },
        { 0x000712, "JAL Information Technology" },
        { 0x000713, "IP One, Inc." },
        { 0x000714, "Brightcom" },
        { 0x000715, "General Research of Electronics, Inc." },
        { 0x000716, "J & S Marine Ltd." },
        { 0x000717, "Wieland Electric GmbH" },
        { 0x000718, "iCanTek Co., Ltd." },
        { 0x000719, "Mobiis Co., Ltd." },
        { 0x00071A, "Finedigital Inc." },
        { 0x00071B, "CDVI Americas Ltd" },
        { 0x00071C, "AT&T" },
        { 0x00071D, "Satelsa Sistemas Y Aplicaciones De Telecomunicaciones, S.A." },
        { 0x00071E, "Tri-M Engineering / Nupak Dev. Corp." },
        { 0x00071F, "European Systems Integration" },
        { 0x000720, "Trutzschler GmbH & Co. KG" },
        { 0x000721, "Formac Elektronik GmbH" },
        { 0x000722, "The Nielsen Company" },
        { 0x000723, "ELCON Systemtechnik GmbH" },
        { 0x000724, "Telemax Co., Ltd." },
        { 0x000725, "Bematech International Corp." },
        { 0x000726, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x000727, "Zi Corporation (HK) Ltd." },
        { 0x000728, "Neo Telecom" },
        { 0x000729, "Kistler Instrumente AG" },
        { 0x00072A, "Innovance Networks" },
        { 0x00072B, "Jung Myung Telecom Co., Ltd." },
        { 0x00072C, "Fabricom" },
        { 0x00072D, "CNSystems" },
        { 0x00072E, "North Node AB" },
        { 0x00072F, "Intransa, Inc." },
        { 0x000730, "Hutchison OPTEL Telecom Technology Co., Ltd." },
        { 0x000731, "Ophir-Spiricon LLC" },
        { 0x000732, "AAEON Technology Inc." },
        { 0x000733, "DANCONTROL Engineering" },
        { 0x000734, "ONStor, Inc." },
        { 0x000735, "Flarion Technologies, Inc." },
        { 0x000736, "Data Video Technologies Co., Ltd." },
        { 0x000737, "Soriya Co. Ltd." },
        { 0x000738, "Young Technology Co., Ltd." },
        { 0x000739, "Scotty Group Austria Gmbh" },
        { 0x00073A, "INVENTEL" },
        { 0x00073B, "Tenovis GmbH & Co KG" },
        { 0x00073C, "Telecom Design" },
        { 0x00073D, "Nanjing Postel Telecommunications Co., Ltd." },
        { 0x00073E, "China Great-Wall Computer Shenzhen Co., Ltd." },
        { 0x00073F, "Woojyun Systec Co., Ltd." },
        { 0x000740, "BUFFALO.INC" },
        { 0x000741, "Sierra Automated Systems" },
        { 0x000742, "Ormazabal" },
        { 0x000743, "Chelsio Communications" },
        { 0x000744, "Unico, Inc." },
        { 0x000745, "Radlan Computer Communications Ltd." },
        { 0x000746, "TURCK, Inc." },
        { 0x000747, "Mecalc" },
        { 0x000748, "The Imaging Source Europe" },
        { 0x000749, "CENiX Inc." },
        { 0x00074A, "Carl Valentin GmbH" },
        { 0x00074B, "Daihen Corporation" },
        { 0x00074C, "Beicom Inc." },
        { 0x00074D, "Zebra Technologies Corp." },
        { 0x00074E, "IPFRONT Inc" },
        { 0x00074F, "Cisco Systems, Inc" },
        { 0x000750, "Cisco Systems, Inc" },
        { 0x000751, "m-u-t AG" },
        { 0x000752, "Rhythm Watch Co., Ltd." },
        { 0x000753, "Beijing Qxcomm Technology Co., Ltd." },
        { 0x000754, "Xyterra Computing, Inc." },
        { 0x000755, "Lafon" },
        { 0x000756, "Juyoung Telecom" },
        { 0x000757, "Topcall International AG" },
        { 0x000758, "DragonWave Inc." },
        { 0x000759, "Boris Manufacturing Corp." },
        { 0x00075A, "Air Products and Chemicals, Inc." },
        { 0x00075B, "Gibson Guitars" },
        { 0x00075C, "Eastman Kodak Company" },
        { 0x00075D, "Celleritas Inc." },
        { 0x00075E, "Ametek Power Instruments" },
        { 0x00075F, "VCS Video Communication Systems AG" },
        { 0x000760, "TOMIS Information & Telecom Corp." },
        { 0x000761, "29530" },
        { 0x000762, "Group Sense Limited" },
        { 0x000763, "Sunniwell Cyber Tech. Co., Ltd." },
        { 0x000764, "YoungWoo Telecom Co. Ltd." },
        { 0x000765, "Jade Quantum Technologies, Inc." },
        { 0x000766, "Chou Chin Industrial Co., Ltd." },
        { 0x000767, "Yuxing Electronics Company Limited" },
        { 0x000768, "Danfoss A/S" },
        { 0x000769, "Italiana Macchi SpA" },
        { 0x00076A, "NEXTEYE Co., Ltd." },
        { 0x00076B, "Stralfors AB" },
        { 0x00076C, "Daehanet, Inc." },
        { 0x00076D, "Flexlight Networks" },
        { 0x00076E, "Sinetica Corporation Limited" },
        { 0x00076F, "Synoptics Limited" },
        { 0x000770, "Ubiquoss Inc" },
        { 0x000771, "Embedded System Corporation" },
        { 0x000772, "Alcatel-Lucent Shanghai Bell Co., Ltd" },
        { 0x000773, "Ascom Powerline Communications Ltd." },
        { 0x000774, "GuangZhou Thinker Technology Co. Ltd." },
        { 0x000775, "Valence Semiconductor, Inc." },
        { 0x000776, "Federal APD" },
        { 0x000777, "Motah Ltd." },
        { 0x000778, "GERSTEL GmbH & Co. KG" },
        { 0x000779, "Sungil Telecom Co., Ltd." },
        { 0x00077A, "Infoware System Co., Ltd." },
        { 0x00077B, "Millimetrix Broadband Networks" },
        { 0x00077C, "Westermo Network Technologies AB" },
        { 0x00077D, "Cisco Systems, Inc" },
        { 0x00077E, "Elrest GmbH" },
        { 0x00077F, "J Communications Co., Ltd." },
        { 0x000780, "Bluegiga Technologies OY" },
        { 0x000781, "Itron Inc." },
        { 0x000782, "Oracle Corporation" },
        { 0x000783, "SynCom Network, Inc." },
        { 0x000784, "Cisco Systems, Inc" },
        { 0x000785, "Cisco Systems, Inc" },
        { 0x000786, "Wireless Networks Inc." },
        { 0x000787, "Idea System Co., Ltd." },
        { 0x000788, "Clipcomm, Inc." },
        { 0x000789, "Allradio Co., Ltd" },
        { 0x00078A, "Mentor Data System Inc." },
        { 0x00078B, "Wegener Communications, Inc." },
        { 0x00078C, "Elektronikspecialisten i Borlange AB" },
        { 0x00078D, "NetEngines Ltd." },
        { 0x00078E, "Garz & Fricke GmbH" },
        { 0x00078F, "Emkay Innovative Products" },
        { 0x000790, "Tri-M Technologies (s) Limited" },
        { 0x000791, "International Data Communications, Inc." },
        { 0x000792, "Sütron Electronic GmbH" },
        { 0x000793, "Shin Satellite Public Company Limited" },
        { 0x000794, "Simple Devices, Inc." },
        { 0x000795, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x000796, "LSI Systems, Inc." },
        { 0x000797, "Netpower Co., Ltd." },
        { 0x000798, "Selea SRL" },
        { 0x000799, "Tipping Point Technologies, Inc." },
        { 0x00079A, "Verint Systems Inc" },
        { 0x00079B, "Aurora Networks" },
        { 0x00079C, "Golden Electronics Technology Co., Ltd." },
        { 0x00079D, "Musashi Co., Ltd." },
        { 0x00079E, "Ilinx Co., Ltd." },
        { 0x00079F, "Action Digital Inc." },
        { 0x0007A0, "e-Watch Inc." },
        { 0x0007A1, "VIASYS Healthcare GmbH" },
        { 0x0007A2, "Opteon Corporation" },
        { 0x0007A3, "Ositis Software, Inc." },
        { 0x0007A4, "GN Netcom Ltd." },
        { 0x0007A5, "Y.D.K Co. Ltd." },
        { 0x0007A6, "Leviton Manufacturing Co., Inc." },
        { 0x0007A7, "A-Z Inc." },
        { 0x0007A8, "Haier Group Technologies Ltd" },
        { 0x0007A9, "Novasonics" },
        { 0x0007AA, "Quantum Data Inc." },
        { 0x0007AB, "Samsung Electronics Co.,Ltd" },
        { 0x0007AC, "Eolring" },
        { 0x0007AD, "Pentacon GmbH Foto-und Feinwerktechnik" },
        { 0x0007AE, "Britestream Networks, Inc." },
        { 0x0007AF, "Red Lion Controls, LP" },
        { 0x0007B0, "Office Details, Inc." },
        { 0x0007B1, "Equator Technologies" },
        { 0x0007B2, "Transaccess S.A." },
        { 0x0007B3, "Cisco Systems, Inc" },
        { 0x0007B4, "Cisco Systems, Inc" },
        { 0x0007B5, "Any One Wireless Ltd." },
        { 0x0007B6, "Telecom Technology Ltd." },
        { 0x0007B7, "Samurai Ind. Prods Eletronicos Ltda" },
        { 0x0007B8, "Corvalent Corporation" },
        { 0x0007B9, "Ginganet Corporation" },
        { 0x0007BA, "UTStarcom Inc" },
        { 0x0007BB, "Candera Inc." },
        { 0x0007BC, "Identix Inc." },
        { 0x0007BD, "Radionet Ltd." },
        { 0x0007BE, "DataLogic SpA" },
        { 0x0007BF, "Armillaire Technologies, Inc." },
        { 0x0007C0, "NetZerver Inc." },
        { 0x0007C1, "Overture Networks, Inc." },
        { 0x0007C2, "Netsys Telecom" },
        { 0x0007C3, "Thomson" },
        { 0x0007C4, "JEAN Co. Ltd." },
        { 0x0007C5, "Gcom, Inc." },
        { 0x0007C6, "VDS Vosskuhler GmbH" },
        { 0x0007C7, "Synectics Systems Limited" },
        { 0x0007C8, "Brain21, Inc." },
        { 0x0007C9, "Technol Seven Co., Ltd." },
        { 0x0007CA, "Creatix Polymedia Ges Fur Kommunikaitonssysteme" },
        { 0x0007CB, "FREEBOX SAS" },
        { 0x0007CC, "Kaba Benzing GmbH" },
        { 0x0007CD, "Kumoh Electronic Co, Ltd" },
        { 0x0007CE, "Cabletime Limited" },
        { 0x0007CF, "Anoto AB" },
        { 0x0007D0, "Automat Engenharia de Automação Ltda." },
        { 0x0007D1, "Spectrum Signal Processing Inc." },
        { 0x0007D2, "Logopak Systeme GmbH & Co. KG" },
        { 0x0007D3, "SPGPrints B.V." },
        { 0x0007D4, "Zhejiang Yutong Network Communication Co Ltd." },
        { 0x0007D5, "3e Technologies Int;., Inc." },
        { 0x0007D6, "Commil Ltd." },
        { 0x0007D7, "Caporis Networks AG" },
        { 0x0007D8, "Hitron Technologies. Inc" },
        { 0x0007D9, "Splicecom" },
        { 0x0007DA, "Neuro Telecom Co., Ltd." },
        { 0x0007DB, "Kirana Networks, Inc." },
        { 0x0007DC, "Atek Co, Ltd." },
        { 0x0007DD, "Cradle Technologies" },
        { 0x0007DE, "eCopilt AB" },
        { 0x0007DF, "Vbrick Systems Inc." },
        { 0x0007E0, "Palm Inc." },
        { 0x0007E1, "WIS Communications Co. Ltd." },
        { 0x0007E2, "Bitworks, Inc." },
        { 0x0007E3, "Navcom Technology, Inc." },
        { 0x0007E4, "SoftRadio Co., Ltd." },
        { 0x0007E5, "Coup Corporation" },
        { 0x0007E6, "edgeflow Canada Inc." },
        { 0x0007E7, "FreeWave Technologies" },
        { 0x0007E8, "EdgeWave" },
        { 0x0007E9, "Intel Corporation" },
        { 0x0007EA, "Massana, Inc." },
        { 0x0007EB, "Cisco Systems, Inc" },
        { 0x0007EC, "Cisco Systems, Inc" },
        { 0x0007ED, "Altera Corporation" },
        { 0x0007EE, "telco Informationssysteme GmbH" },
        { 0x0007EF, "Lockheed Martin Tactical Systems" },
        { 0x0007F0, "LogiSync LLC" },
        { 0x0007F1, "TeraBurst Networks Inc." },
        { 0x0007F2, "IOA Corporation" },
        { 0x0007F3, "Thinkengine Networks" },
        { 0x0007F4, "Eletex Co., Ltd." },
        { 0x0007F5, "Bridgeco Co AG" },
        { 0x0007F6, "Qqest Software Systems" },
        { 0x0007F7, "Galtronics" },
        { 0x0007F8, "ITDevices, Inc." },
        { 0x0007F9, "Sensaphone" },
        { 0x0007FA, "ITT Co., Ltd." },
        { 0x0007FB, "Giga Stream UMTS Technologies GmbH" },
        { 0x0007FC, "Adept Systems Inc." },
        { 0x0007FD, "LANergy Ltd." },
        { 0x0007FE, "Rigaku Corporation" },
        { 0x0007FF, "Gluon Networks" },
        { 0x000800, "MULTITECH SYSTEMS, INC." },
        { 0x000801, "HighSpeed Surfing Inc." },
        { 0x000802, "Hewlett Packard" },
        { 0x000803, "Cos Tron" },
        { 0x000804, "ICA Inc." },
        { 0x000805, "Techno-Holon Corporation" },
        { 0x000806, "Raonet Systems, Inc." },
        { 0x000807, "Access Devices Limited" },
        { 0x000808, "PPT Vision, Inc." },
        { 0x000809, "Systemonic AG" },
        { 0x00080A, "Espera-Werke GmbH" },
        { 0x00080B, "Birka BPA Informationssystem AB" },
        { 0x00080C, "VDA Elettronica spa" },
        { 0x00080D, "Toshiba" },
        { 0x00080E, "ARRIS Group, Inc." },
        { 0x00080F, "Proximion Fiber Optics AB" },
        { 0x000810, "Key Technology, Inc." },
        { 0x000811, "VOIX Corporation" },
        { 0x000812, "GM-2 Corporation" },
        { 0x000813, "Diskbank, Inc." },
        { 0x000814, "TIL Technologies" },
        { 0x000815, "CATS Co., Ltd." },
        { 0x000816, "Bluelon ApS" },
        { 0x000817, "EmergeCore Networks LLC" },
        { 0x000818, "Pixelworks, Inc." },
        { 0x000819, "Banksys" },
        { 0x00081A, "Sanrad Intelligence Storage Communications (2000) Ltd." },
        { 0x00081B, "Windigo Systems" },
        { 0x00081C, "@pos.com" },
        { 0x00081D, "Ipsil, Incorporated" },
        { 0x00081E, "Repeatit AB" },
        { 0x00081F, "Pou Yuen Tech Corp. Ltd." },
        { 0x000820, "Cisco Systems, Inc" },
        { 0x000821, "Cisco Systems, Inc" },
        { 0x000822, "InPro Comm" },
        { 0x000823, "Texa Corp." },
        { 0x000824, "Nuance Document Imaging" },
        { 0x000825, "Acme Packet" },
        { 0x000826, "Colorado Med Tech" },
        { 0x000827, "ADB Broadband Italia" },
        { 0x000828, "Koei Engineering Ltd." },
        { 0x000829, "TOKYO ELECTRON DEVICE NAGASAKI LIMITED" },
        { 0x00082A, "Powerwallz Network Security" },
        { 0x00082B, "Wooksung Electronics, Inc." },
        { 0x00082C, "Homag AG" },
        { 0x00082D, "Indus Teqsite Private Limited" },
        { 0x00082E, "Multitone Electronics PLC" },
        { 0x00082F, "Cisco Systems, Inc" },
        { 0x000830, "Cisco Systems, Inc" },
        { 0x000831, "Cisco Systems, Inc" },
        { 0x000832, "Cisco Systems, Inc" },
        { 0x00084E, "DivergeNet, Inc." },
        { 0x00084F, "Qualstar Corporation" },
        { 0x000850, "Arizona Instrument Corp." },
        { 0x000851, "Canadian Bank Note Company, Ltd." },
        { 0x000852, "Davolink Co. Inc." },
        { 0x000853, "Schleicher GmbH & Co. Relaiswerke KG" },
        { 0x000854, "Netronix, Inc." },
        { 0x000855, "NASA-Goddard Space Flight Center" },
        { 0x000856, "Gamatronic Electronic Industries Ltd." },
        { 0x000857, "Polaris Networks, Inc." },
        { 0x000858, "Novatechnology Inc." },
        { 0x000859, "ShenZhen Unitone Electronics Co., Ltd." },
        { 0x00085A, "IntiGate Inc." },
        { 0x00085B, "Hanbit Electronics Co., Ltd." },
        { 0x00085C, "Shanghai Dare Technologies Co. Ltd." },
        { 0x00085D, "Mitel Corporation" },
        { 0x00085E, "PCO AG" },
        { 0x00085F, "Picanol N.V." },
        { 0x000860, "LodgeNet Entertainment Corp." },
        { 0x000861, "SoftEnergy Co., Ltd." },
        { 0x000862, "NEC Eluminant Technologies, Inc." },
        { 0x000863, "Entrisphere Inc." },
        { 0x000864, "Fasy S.p.A." },
        { 0x000865, "JASCOM CO., LTD" },
        { 0x000866, "DSX Access Systems, Inc." },
        { 0x000867, "Uptime Devices" },
        { 0x000868, "PurOptix" },
        { 0x000869, "Command-e Technology Co.,Ltd." },
        { 0x00086A, "Securiton Gmbh" },
        { 0x00086B, "MIPSYS" },
        { 0x00086C, "Plasmon LMS" },
        { 0x00086D, "Missouri FreeNet" },
        { 0x00086E, "Hyglo AB" },
        { 0x00086F, "Resources Computer Network Ltd." },
        { 0x000870, "Rasvia Systems, Inc." },
        { 0x000871, "NORTHDATA Co., Ltd." },
        { 0x000872, "Sorenson Communications" },
        { 0x000873, "DapTechnology B.V." },
        { 0x000874, "Dell Inc." },
        { 0x000875, "Acorp Electronics Corp." },
        { 0x000876, "SDSystem" },
        { 0x000877, "Liebert-Hiross Spa" },
        { 0x000878, "Benchmark Storage Innovations" },
        { 0x000879, "CEM Corporation" },
        { 0x00087A, "Wipotec GmbH" },
        { 0x00087B, "RTX Telecom A/S" },
        { 0x00087C, "Cisco Systems, Inc" },
        { 0x00087D, "Cisco Systems, Inc" },
        { 0x00087E, "Bon Electro-Telecom Inc." },
        { 0x00087F, "SPAUN electronic GmbH & Co. KG" },
        { 0x000880, "BroadTel Canada Communications inc." },
        { 0x000881, "DIGITAL HANDS CO.,LTD." },
        { 0x000882, "SIGMA CORPORATION" },
        { 0x000883, "Hewlett Packard" },
        { 0x000884, "Index Braille AB" },
        { 0x000885, "EMS Dr. Thomas Wünsche" },
        { 0x000886, "Hansung Teliann, Inc." },
        { 0x000887, "Maschinenfabrik Reinhausen GmbH" },
        { 0x000888, "OULLIM Information Technology Inc,." },
        { 0x000889, "Dish Technologies Corp" },
        { 0x00088A, "Minds@Work" },
        { 0x00088B, "Tropic Networks Inc." },
        { 0x00088C, "Quanta Network Systems Inc." },
        { 0x00088D, "Sigma-Links Inc." },
        { 0x00088E, "Nihon Computer Co., Ltd." },
        { 0x00088F, "ADVANCED DIGITAL TECHNOLOGY" },
        { 0x000890, "AVILINKS SA" },
        { 0x000891, "Lyan Inc." },
        { 0x000892, "EM Solutions" },
        { 0x000893, "LE INFORMATION COMMUNICATION INC." },
        { 0x000894, "InnoVISION Multimedia Ltd." },
        { 0x000895, "DIRC Technologie GmbH & Co.KG" },
        { 0x000896, "Printronix, Inc." },
        { 0x000897, "Quake Technologies" },
        { 0x000898, "Gigabit Optics Corporation" },
        { 0x000899, "Netbind, Inc." },
        { 0x00089A, "Alcatel Microelectronics" },
        { 0x00089B, "ICP Electronics Inc." },
        { 0x00089C, "Elecs Industry Co., Ltd." },
        { 0x00089D, "UHD-Elektronik" },
        { 0x00089E, "Beijing Enter-Net co.LTD" },
        { 0x00089F, "EFM Networks" },
        { 0x0008A0, "Stotz Feinmesstechnik GmbH" },
        { 0x0008A1, "CNet Technology Inc." },
        { 0x0008A2, "ADI Engineering, Inc." },
        { 0x0008A3, "Cisco Systems, Inc" },
        { 0x0008A4, "Cisco Systems, Inc" },
        { 0x0008A5, "Peninsula Systems Inc." },
        { 0x0008A6, "Multiware & Image Co., Ltd." },
        { 0x0008A7, "iLogic Inc." },
        { 0x0008A8, "Systec Co., Ltd." },
        { 0x0008A9, "SangSang Technology, Inc." },
        { 0x0008AA, "KARAM" },
        { 0x0008AB, "EnerLinx.com, Inc." },
        { 0x0008AC, "Eltromat GmbH" },
        { 0x0008AD, "Toyo-Linx Co., Ltd." },
        { 0x0008AE, "PacketFront Network Products AB" },
        { 0x0008AF, "Novatec Corporation" },
        { 0x0008B0, "BKtel communications GmbH" },
        { 0x0008B1, "ProQuent Systems" },
        { 0x0008B2, "SHENZHEN COMPASS TECHNOLOGY DEVELOPMENT CO.,LTD" },
        { 0x0008B3, "Fastwel" },
        { 0x0008B4, "SYSPOL" },
        { 0x0008B5, "TAI GUEN ENTERPRISE CO., LTD" },
        { 0x0008B6, "RouteFree, Inc." },
        { 0x0008B7, "HIT Incorporated" },
        { 0x0008B8, "E.F. Johnson" },
        { 0x0008B9, "Kaonmedia CO., LTD." },
        { 0x0008BA, "Erskine Systems Ltd" },
        { 0x0008BB, "NetExcell" },
        { 0x0008BC, "Ilevo AB" },
        { 0x0008BD, "TEPG-US" },
        { 0x0008BE, "XENPAK MSA Group" },
        { 0x0008BF, "Aptus Elektronik AB" },
        { 0x0008C0, "ASA SYSTEMS" },
        { 0x0008C1, "Avistar Communications Corporation" },
        { 0x0008C2, "Cisco Systems, Inc" },
        { 0x0008C3, "Contex A/S" },
        { 0x0008C4, "Hikari Co.,Ltd." },
        { 0x0008C5, "Liontech Co., Ltd." },
        { 0x0008C6, "Philips Consumer Communications" },
        { 0x0008C7, "Hewlett Packard" },
        { 0x0008C8, "Soneticom, Inc." },
        { 0x0008C9, "TechniSat Digital GmbH Daun" },
        { 0x0008CA, "TwinHan Technology Co.,Ltd" },
        { 0x0008CB, "Zeta Broadband Inc." },
        { 0x0008CC, "Remotec, Inc." },
        { 0x0008CD, "With-Net Inc" },
        { 0x0008CE, "IPMobileNet Inc." },
        { 0x0008CF, "Nippon Koei Power Systems Co., Ltd." },
        { 0x0008D0, "Musashi Engineering Co., LTD." },
        { 0x0008D1, "KAREL INC." },
        { 0x0008D2, "ZOOM Networks Inc." },
        { 0x0008D3, "Hercules Technologies S.A.S." },
        { 0x0008D4, "IneoQuest Technologies, Inc" },
        { 0x0008D5, "Vanguard Networks Solutions, LLC" },
        { 0x0008D6, "HASSNET Inc." },
        { 0x0008D7, "HOW CORPORATION" },
        { 0x0008D8, "Dowkey Microwave" },
        { 0x0008D9, "Mitadenshi Co.,LTD" },
        { 0x0008DA, "SofaWare Technologies Ltd." },
        { 0x0008DB, "Corrigent Systems" },
        { 0x0008DC, "Wiznet" },
        { 0x0008DD, "Telena Communications, Inc." },
        { 0x0008DE, "3UP Systems" },
        { 0x0008DF, "Alistel Inc." },
        { 0x0008E0, "ATO Technology Ltd." },
        { 0x0008E1, "Barix AG" },
        { 0x0008E2, "Cisco Systems, Inc" },
        { 0x0008E3, "Cisco Systems, Inc" },
        { 0x0008E4, "Envenergy Inc" },
        { 0x0008E5, "IDK Corporation" },
        { 0x0008E6, "Littlefeet" },
        { 0x0008E7, "SHI ControlSystems,Ltd." },
        { 0x0008E8, "Excel Master Ltd." },
        { 0x0008E9, "NextGig" },
        { 0x0008EA, "Motion Control Engineering, Inc" },
        { 0x0008EB, "ROMWin Co.,Ltd." },
        { 0x0008EC, "Optical Zonu Corporation" },
        { 0x0008ED, "ST&T Instrument Corp." },
        { 0x0008EE, "Logic Product Development" },
        { 0x0008EF, "DIBAL,S.A." },
        { 0x0008F0, "Next Generation Systems, Inc." },
        { 0x0008F1, "Voltaire" },
        { 0x0008F2, "C&S Technology" },
        { 0x0008F3, "WANY" },
        { 0x0008F4, "Bluetake Technology Co., Ltd." },
        { 0x0008F5, "YESTECHNOLOGY Co.,Ltd." },
        { 0x0008F6, "Sumitomo Electric Industries, Ltd" },
        { 0x0008F7, "Hitachi Ltd, Semiconductor & Integrated Circuits Gr" },
        { 0x0008F8, "UTC CCS" },
        { 0x0008F9, "Artesyn Embedded Technologies" },
        { 0x0008FA, "KEB Automation KG" },
        { 0x0008FB, "SonoSite, Inc." },
        { 0x0008FC, "Gigaphoton Inc." },
        { 0x0008FD, "BlueKorea Co., Ltd." },
        { 0x0008FE, "UNIK C&C Co.,Ltd." },
        { 0x0008FF, "Trilogy Communications Ltd" },
        { 0x000900, "TMT" },
        { 0x000901, "Shenzhen Shixuntong Information & Technoligy Co" },
        { 0x000902, "Redline Communications Inc." },
        { 0x000903, "Panasas, Inc" },
        { 0x000904, "MONDIAL electronic" },
        { 0x000905, "iTEC Technologies Ltd." },
        { 0x000906, "Esteem Networks" },
        { 0x000907, "Chrysalis Development" },
        { 0x000908, "VTech Technology Corp." },
        { 0x000909, "Telenor Connect A/S" },
        { 0x00090A, "SnedFar Technology Co., Ltd." },
        { 0x00090B, "MTL Instruments PLC" },
        { 0x00090C, "Mayekawa Mfg. Co. Ltd." },
        { 0x00090D, "LEADER ELECTRONICS CORP." },
        { 0x00090E, "Helix Technology Inc." },
        { 0x00090F, "Fortinet Inc." },
        { 0x000910, "Simple Access Inc." },
        { 0x000911, "Cisco Systems, Inc" },
        { 0x000912, "Cisco Systems, Inc" },
        { 0x000913, "SystemK Corporation" },
        { 0x000914, "COMPUTROLS INC." },
        { 0x000915, "CAS Corp." },
        { 0x000916, "Listman Home Technologies, Inc." },
        { 0x000917, "WEM Technology Inc" },
        { 0x000918, "SAMSUNG TECHWIN CO.,LTD" },
        { 0x000919, "MDS Gateways" },
        { 0x00091A, "Macat Optics & Electronics Co., Ltd." },
        { 0x00091B, "Digital Generation Inc." },
        { 0x00091C, "CacheVision, Inc" },
        { 0x00091D, "Proteam Computer Corporation" },
        { 0x00091E, "Firstech Technology Corp." },
        { 0x00091F, "A&D Co., Ltd." },
        { 0x000920, "EpoX COMPUTER CO.,LTD." },
        { 0x000921, "Planmeca Oy" },
        { 0x000922, "TST Biometrics GmbH" },
        { 0x000923, "Heaman System Co., Ltd" },
        { 0x000924, "Telebau GmbH" },
        { 0x000925, "VSN Systemen BV" },
        { 0x000926, "YODA COMMUNICATIONS, INC." },
        { 0x000927, "TOYOKEIKI CO.,LTD." },
        { 0x000928, "Telecore" },
        { 0x000929, "Sanyo Industries (UK) Limited" },
        { 0x00092A, "MYTECS Co.,Ltd." },
        { 0x00092B, "iQstor Networks, Inc." },
        { 0x00092C, "Hitpoint Inc." },
        { 0x00092D, "HTC Corporation" },
        { 0x00092E, "B&Tech System Inc." },
        { 0x00092F, "Akom Technology Corporation" },
        { 0x000930, "AeroConcierge Inc." },
        { 0x000931, "Future Internet, Inc." },
        { 0x000932, "Omnilux" },
        { 0x000933, "Ophit Co.Ltd." },
        { 0x000934, "Dream-Multimedia-Tv GmbH" },
        { 0x000935, "Sandvine Incorporated" },
        { 0x000936, "Ipetronik GmbH & Co. KG" },
        { 0x000937, "Inventec Appliance Corp" },
        { 0x000938, "Allot Communications" },
        { 0x000939, "ShibaSoku Co.,Ltd." },
        { 0x00093A, "Molex CMS" },
        { 0x00093B, "HYUNDAI NETWORKS INC." },
        { 0x00093C, "Jacques Technologies P/L" },
        { 0x00093D, "Newisys,Inc." },
        { 0x00093E, "C&I Technologies" },
        { 0x00093F, "Double-Win Enterpirse CO., LTD" },
        { 0x000940, "AGFEO GmbH & Co. KG" },
        { 0x000941, "Allied Telesis R&D Center K.K." },
        { 0x000942, "Wireless Technologies, Inc" },
        { 0x000943, "Cisco Systems, Inc" },
        { 0x000944, "Cisco Systems, Inc" },
        { 0x000945, "Palmmicro Communications Inc" },
        { 0x000946, "Cluster Labs GmbH" },
        { 0x000947, "Aztek, Inc." },
        { 0x000948, "Vista Control Systems, Corp." },
        { 0x000949, "Glyph Technologies Inc." },
        { 0x00094A, "Homenet Communications" },
        { 0x00094B, "FillFactory NV" },
        { 0x00094C, "Communication Weaver Co.,Ltd." },
        { 0x00094D, "Braintree Communications Pty Ltd" },
        { 0x00094E, "BARTECH SYSTEMS INTERNATIONAL, INC" },
        { 0x00094F, "elmegt GmbH & Co. KG" },
        { 0x000950, "Independent Storage Corporation" },
        { 0x000951, "Apogee Imaging Systems" },
        { 0x000952, "Auerswald GmbH & Co. KG" },
        { 0x000953, "Linkage System Integration Co.Ltd." },
        { 0x000954, "AMiT spol. s. r. o." },
        { 0x000955, "Young Generation International Corp." },
        { 0x000956, "Network Systems Group, Ltd. (NSG)" },
        { 0x000957, "Supercaller, Inc." },
        { 0x000958, "INTELNET S.A." },
        { 0x000959, "Sitecsoft" },
        { 0x00095A, "RACEWOOD TECHNOLOGY" },
        { 0x00095B, "NETGEAR" },
        { 0x00095C, "Philips Medical Systems - Cardiac and Monitoring Systems (CM" },
        { 0x00095D, "Dialogue Technology Corp." },
        { 0x00095E, "Masstech Group Inc." },
        { 0x00095F, "Telebyte, Inc." },
        { 0x000960, "YOZAN Inc." },
        { 0x000961, "Switchgear and Instrumentation Ltd" },
        { 0x000962, "Sonitor Technologies AS" },
        { 0x000963, "Dominion Lasercom Inc." },
        { 0x000964, "Hi-Techniques, Inc." },
        { 0x000965, "HyunJu Computer Co., Ltd." },
        { 0x000966, "TRIMBLE EUROPE BV" },
        { 0x000967, "Tachyon, Inc" },
        { 0x000968, "TECHNOVENTURE, INC." },
        { 0x000969, "Meret Optical Communications" },
        { 0x00096A, "Cloverleaf Communications Inc." },
        { 0x00096B, "IBM Corp" },
        { 0x00096C, "Imedia Semiconductor Corp." },
        { 0x00096D, "Powernet Technologies Corp." },
        { 0x00096E, "GIANT ELECTRONICS LTD." },
        { 0x00096F, "Beijing Zhongqing Elegant Tech. Corp.,Limited" },
        { 0x000970, "Vibration Research Corporation" },
        { 0x000971, "Time Management, Inc." },
        { 0x000972, "Securebase,Inc" },
        { 0x000973, "Lenten Technology Co., Ltd." },
        { 0x000974, "Innopia Technologies, Inc." },
        { 0x000975, "fSONA Communications Corporation" },
        { 0x000976, "Datasoft ISDN Systems GmbH" },
        { 0x000977, "Brunner Elektronik AG" },
        { 0x000978, "AIJI System Co., Ltd." },
        { 0x000979, "Advanced Television Systems Committee, Inc." },
        { 0x00097A, "Louis Design Labs." },
        { 0x00097B, "Cisco Systems, Inc" },
        { 0x00097C, "Cisco Systems, Inc" },
        { 0x00097D, "SecWell Networks Oy" },
        { 0x00097E, "IMI TECHNOLOGY CO., LTD" },
        { 0x00097F, "Vsecure 2000 LTD." },
        { 0x000980, "Power Zenith Inc." },
        { 0x000981, "Newport Networks" },
        { 0x000982, "Loewe Opta GmbH" },
        { 0x000983, "GlobalTop Technology, Inc." },
        { 0x000984, "MyCasa Network Inc." },
        { 0x000985, "Auto Telecom Company" },
        { 0x000986, "Metalink LTD." },
        { 0x000987, "NISHI NIPPON ELECTRIC WIRE & CABLE CO.,LTD." },
        { 0x000988, "Nudian Electron Co., Ltd." },
        { 0x000989, "VividLogic Inc." },
        { 0x00098A, "EqualLogic Inc" },
        { 0x00098B, "Entropic Communications, Inc." },
        { 0x00098C, "Option Wireless Sweden" },
        { 0x00098D, "Velocity Semiconductor" },
        { 0x00098E, "ipcas GmbH" },
        { 0x00098F, "Cetacean Networks" },
        { 0x000990, "ACKSYS Communications & systems" },
        { 0x000991, "Intelligent Platforms, LLC." },
        { 0x000992, "InterEpoch Technology,INC." },
        { 0x000993, "Visteon Corporation" },
        { 0x000994, "Cronyx Engineering" },
        { 0x000995, "Castle Technology Ltd" },
        { 0x000996, "RDI" },
        { 0x000997, "Nortel Networks" },
        { 0x000998, "Capinfo Company Limited" },
        { 0x000999, "CP GEORGES RENAULT" },
        { 0x00099A, "ELMO COMPANY, LIMITED" },
        { 0x00099B, "Western Telematic Inc." },
        { 0x00099C, "Naval Research Laboratory" },
        { 0x00099D, "Haliplex Communications" },
        { 0x00099E, "Testech, Inc." },
        { 0x00099F, "VIDEX INC." },
        { 0x0009A0, "Microtechno Corporation" },
        { 0x0009A1, "Telewise Communications, Inc." },
        { 0x0009A2, "Interface Co., Ltd." },
        { 0x0009A3, "Leadfly Techologies Corp. Ltd." },
        { 0x0009A4, "HARTEC Corporation" },
        { 0x0009A5, "HANSUNG ELETRONIC INDUSTRIES DEVELOPMENT CO., LTD" },
        { 0x0009A6, "Ignis Optics, Inc." },
        { 0x0009A7, "Bang & Olufsen A/S" },
        { 0x0009A8, "Eastmode Pte Ltd" },
        { 0x0009A9, "Ikanos Communications" },
        { 0x0009AA, "Data Comm for Business, Inc." },
        { 0x0009AB, "Netcontrol Oy" },
        { 0x0009AC, "LANVOICE" },
        { 0x0009AD, "HYUNDAI SYSCOMM, INC." },
        { 0x0009AE, "OKANO ELECTRIC CO.,LTD" },
        { 0x0009AF, "e-generis" },
        { 0x0009B0, "Onkyo Corporation" },
        { 0x0009B1, "Kanematsu Electronics, Ltd." },
        { 0x0009B2, "L&F Inc." },
        { 0x0009B3, "MCM Systems Ltd" },
        { 0x0009B4, "KISAN TELECOM CO., LTD." },
        { 0x0009B5, "3J Tech. Co., Ltd." },
        { 0x0009B6, "Cisco Systems, Inc" },
        { 0x0009B7, "Cisco Systems, Inc" },
        { 0x0009B8, "Entise Systems" },
        { 0x0009B9, "Action Imaging Solutions" },
        { 0x0009BA, "MAKU Informationstechik GmbH" },
        { 0x0009BB, "MathStar, Inc." },
        { 0x0009BC, "Utility, Inc" },
        { 0x0009BD, "Epygi Technologies, Ltd." },
        { 0x0009BE, "Mamiya-OP Co.,Ltd." },
        { 0x0009BF, "Nintendo Co., Ltd." },
        { 0x0009C0, "6WIND" },
        { 0x0009C1, "PROCES-DATA A/S" },
        { 0x0009C2, "Onity, Inc." },
        { 0x0009C3, "NETAS" },
        { 0x0009C4, "Medicore Co., Ltd" },
        { 0x0009C5, "KINGENE Technology Corporation" },
        { 0x0009C6, "Visionics Corporation" },
        { 0x0009C7, "Movistec" },
        { 0x0009C8, "SINAGAWA TSUSHIN KEISOU SERVICE" },
        { 0x0009C9, "BlueWINC Co., Ltd." },
        { 0x0009CA, "iMaxNetworks(Shenzhen)Limited." },
        { 0x0009CB, "HBrain" },
        { 0x0009CC, "Moog GmbH" },
        { 0x0009CD, "HUDSON SOFT CO.,LTD." },
        { 0x0009CE, "SpaceBridge Semiconductor Corp." },
        { 0x0009CF, "iAd GmbH" },
        { 0x0009D0, "Solacom Technologies Inc." },
        { 0x0009D1, "SERANOA NETWORKS INC" },
        { 0x0009D2, "Mai Logic Inc." },
        { 0x0009D3, "Western DataCom Co., Inc." },
        { 0x0009D4, "Transtech Networks" },
        { 0x0009D5, "Signal Communication, Inc." },
        { 0x0009D6, "KNC One GmbH" },
        { 0x0009D7, "DC Security Products" },
        { 0x0009D8, "Fält Communications AB" },
        { 0x0009D9, "Neoscale Systems, Inc" },
        { 0x0009DA, "Control Module Inc." },
        { 0x0009DB, "eSpace" },
        { 0x0009DC, "Galaxis Technology AG" },
        { 0x0009DD, "Mavin Technology Inc." },
        { 0x0009DE, "Samjin Information & Communications Co., Ltd." },
        { 0x0009DF, "Vestel Elektronik San ve Tic. A.Ş." },
        { 0x0009E0, "XEMICS S.A." },
        { 0x0009E1, "Gemtek Technology Co., Ltd." },
        { 0x0009E2, "Sinbon Electronics Co., Ltd." },
        { 0x0009E3, "Angel Iglesias S.A." },
        { 0x0009E4, "K Tech Infosystem Inc." },
        { 0x0009E5, "Hottinger Baldwin Messtechnik GmbH" },
        { 0x0009E6, "Cyber Switching Inc." },
        { 0x0009E7, "ADC Techonology" },
        { 0x0009E8, "Cisco Systems, Inc" },
        { 0x0009E9, "Cisco Systems, Inc" },
        { 0x0009EA, "YEM Inc." },
        { 0x0009EB, "HuMANDATA LTD." },
        { 0x0009EC, "Daktronics, Inc." },
        { 0x0009ED, "CipherOptics" },
        { 0x0009EE, "MEIKYO ELECTRIC CO.,LTD" },
        { 0x0009EF, "Vocera Communications" },
        { 0x0009F0, "Shimizu Technology Inc." },
        { 0x0009F1, "Yamaki Electric Corporation" },
        { 0x0009F2, "Cohu, Inc., Electronics Division" },
        { 0x0009F3, "WELL Communication Corp." },
        { 0x0009F4, "Alcon Laboratories, Inc." },
        { 0x0009F5, "Emerson Network Power Co.,Ltd" },
        { 0x0009F6, "Shenzhen Eastern Digital Tech Ltd." },
        { 0x0009F7, "SED, a division of Calian" },
        { 0x0009F8, "UNIMO TECHNOLOGY CO., LTD." },
        { 0x0009F9, "ART JAPAN CO., LTD." },
        { 0x0009FB, "Philips Patient Monitoring" },
        { 0x0009FC, "IPFLEX Inc." },
        { 0x0009FD, "Ubinetics Limited" },
        { 0x0009FE, "Daisy Technologies, Inc." },
        { 0x0009FF, "X.net 2000 GmbH" },
        { 0x000A00, "Mediatek Corp." },
        { 0x000A01, "SOHOware, Inc." },
        { 0x000A02, "ANNSO CO., LTD." },
        { 0x000A03, "ENDESA SERVICIOS, S.L." },
        { 0x000A04, "3Com Ltd" },
        { 0x000A05, "Widax Corp." },
        { 0x000A06, "Teledex LLC" },
        { 0x000A07, "WebWayOne Ltd" },
        { 0x000A08, "Alpine Electronics, Inc." },
        { 0x000A09, "TaraCom Integrated Products, Inc." },
        { 0x000A0A, "SUNIX Co., Ltd." },
        { 0x000A0B, "Sealevel Systems, Inc." },
        { 0x000A0C, "Scientific Research Corporation" },
        { 0x000A0D, "Amphenol" },
        { 0x000A0E, "Invivo Research Inc." },
        { 0x000A0F, "Ilryung Telesys, Inc" },
        { 0x000A10, "FAST media integrations AG" },
        { 0x000A11, "ExPet Technologies, Inc" },
        { 0x000A12, "Azylex Technology, Inc" },
        { 0x000A13, "Honeywell Video Systems" },
        { 0x000A14, "TECO a.s." },
        { 0x000A15, "Silicon Data, Inc" },
        { 0x000A16, "Lassen Research" },
        { 0x000A17, "NESTAR COMMUNICATIONS, INC" },
        { 0x000A18, "Vichel Inc." },
        { 0x000A19, "Valere Power, Inc." },
        { 0x000A1A, "Imerge Ltd" },
        { 0x000A1B, "Stream Labs" },
        { 0x000A1C, "Bridge Information Co., Ltd." },
        { 0x000A1D, "Optical Communications Products Inc." },
        { 0x000A1E, "Red-M Products Limited" },
        { 0x000A1F, "ART WARE Telecommunication Co., Ltd." },
        { 0x000A20, "SVA Networks, Inc." },
        { 0x000A21, "Integra Telecom Co. Ltd" },
        { 0x000A22, "Amperion Inc" },
        { 0x000A23, "Parama Networks Inc" },
        { 0x000A24, "Octave Communications" },
        { 0x000A25, "CERAGON NETWORKS" },
        { 0x000A26, "CEIA S.p.A." },
        { 0x000A27, "Apple, Inc." },
        { 0x000A28, "Motorola" },
        { 0x000A29, "Pan Dacom Networking AG" },
        { 0x000A2A, "QSI Systems Inc." },
        { 0x000A2B, "Etherstuff" },
        { 0x000A2C, "Active Tchnology Corporation" },
        { 0x000A2D, "Cabot Communications Limited" },
        { 0x000A2E, "MAPLE NETWORKS CO., LTD" },
        { 0x000A2F, "Artnix Inc." },
        { 0x000A30, "Visteon Corporation" },
        { 0x000A31, "HCV Consulting" },
        { 0x000A32, "Xsido Corporation" },
        { 0x000A33, "Emulex Corporation" },
        { 0x000A34, "Identicard Systems Incorporated" },
        { 0x000A35, "Xilinx" },
        { 0x000A36, "Synelec Telecom Multimedia" },
        { 0x000A37, "Procera Networks, Inc." },
        { 0x000A38, "Apani Networks" },
        { 0x000A39, "LoPA Information Technology" },
        { 0x000A3A, "J-THREE INTERNATIONAL Holding Co., Ltd." },
        { 0x000A3B, "GCT Semiconductor, Inc" },
        { 0x000A3C, "Enerpoint Ltd." },
        { 0x000A3D, "Elo Sistemas Eletronicos S.A." },
        { 0x000A3E, "EADS Telecom" },
        { 0x000A3F, "Data East Corporation" },
        { 0x000A40, "Crown Audio -- Harmanm International" },
        { 0x000A41, "Cisco Systems, Inc" },
        { 0x000A42, "Cisco Systems, Inc" },
        { 0x000A43, "Chunghwa Telecom Co., Ltd." },
        { 0x000A44, "Avery Dennison Deutschland GmbH" },
        { 0x000A45, "Audio-Technica Corp." },
        { 0x000A46, "ARO WELDING TECHNOLOGIES SAS" },
        { 0x000A47, "Allied Vision Technologies" },
        { 0x000A48, "Albatron Technology" },
        { 0x000A49, "F5 Networks, Inc." },
        { 0x000A4A, "Targa Systems Ltd." },
        { 0x000A4B, "DataPower Technology, Inc." },
        { 0x000A4C, "Molecular Devices Corporation" },
        { 0x000A4D, "Noritz Corporation" },
        { 0x000A4E, "UNITEK Electronics INC." },
        { 0x000A4F, "Brain Boxes Limited" },
        { 0x000A50, "REMOTEK CORPORATION" },
        { 0x000A51, "GyroSignal Technology Co., Ltd." },
        { 0x000A52, "AsiaRF Ltd." },
        { 0x000A53, "Intronics, Incorporated" },
        { 0x000A54, "Laguna Hills, Inc." },
        { 0x000A55, "MARKEM Corporation" },
        { 0x000A56, "HITACHI Maxell Ltd." },
        { 0x000A57, "Hewlett Packard" },
        { 0x000A58, "Freyer & Siegel Elektronik GmbH & Co. KG" },
        { 0x000A59, "HW server" },
        { 0x000A5A, "GreenNET Technologies Co.,Ltd." },
        { 0x000A5B, "Power-One as" },
        { 0x000A5C, "Carel s.p.a." },
        { 0x000A5D, "FingerTec Worldwide Sdn Bhd" },
        { 0x000A5E, "3COM" },
        { 0x000A5F, "almedio inc." },
        { 0x000A60, "Autostar Technology Pte Ltd" },
        { 0x000A61, "Cellinx Systems Inc." },
        { 0x000A62, "Crinis Networks, Inc." },
        { 0x000A63, "DHD GmbH" },
        { 0x000A64, "Eracom Technologies" },
        { 0x000A65, "GentechMedia.co.,ltd." },
        { 0x000A66, "MITSUBISHI ELECTRIC SYSTEM & SERVICE CO.,LTD." },
        { 0x000A67, "OngCorp" },
        { 0x000A68, "Solarflare Communications Inc." },
        { 0x000A69, "SUNNY bell Technology Co., Ltd." },
        { 0x000A6A, "SVM Microwaves s.r.o." },
        { 0x000A6B, "Tadiran Telecom Business Systems LTD" },
        { 0x000A6C, "Walchem Corporation" },
        { 0x000A6D, "EKS Elektronikservice GmbH" },
        { 0x000A6E, "Harmonic, Inc" },
        { 0x000A6F, "ZyFLEX Technologies Inc" },
        { 0x000A70, "MPLS Forum" },
        { 0x000A71, "Avrio Technologies, Inc" },
        { 0x000A72, "STEC, INC." },
        { 0x000A73, "Scientific Atlanta" },
        { 0x000A74, "Manticom Networks Inc." },
        { 0x000A75, "Caterpillar, Inc" },
        { 0x000A76, "Beida Jade Bird Huaguang Technology Co.,Ltd" },
        { 0x000A77, "Bluewire Technologies LLC" },
        { 0x000A78, "OLITEC" },
        { 0x000A79, "corega K.K" },
        { 0x000A7A, "Kyoritsu Electric Co., Ltd." },
        { 0x000A7B, "Cornelius Consult" },
        { 0x000A7C, "Tecton Ltd" },
        { 0x000A7D, "Valo, Inc." },
        { 0x000A7E, "The Advantage Group" },
        { 0x000A7F, "Teradon Industries, Inc" },
        { 0x000A80, "Telkonet Inc." },
        { 0x000A81, "TEIMA Audiotex S.L." },
        { 0x000A82, "TATSUTA SYSTEM ELECTRONICS CO.,LTD." },
        { 0x000A83, "SALTO SYSTEMS S.L." },
        { 0x000A84, "Rainsun Enterprise Co., Ltd." },
        { 0x000A85, "PLAT'C2,Inc" },
        { 0x000A86, "Lenze" },
        { 0x000A87, "Integrated Micromachines Inc." },
        { 0x000A88, "InCypher S.A." },
        { 0x000A89, "Creval Systems, Inc." },
        { 0x000A8A, "Cisco Systems, Inc" },
        { 0x000A8B, "Cisco Systems, Inc" },
        { 0x000A8C, "Guardware Systems Ltd." },
        { 0x000A8D, "EUROTHERM LIMITED" },
        { 0x000A8E, "Invacom Ltd" },
        { 0x000A8F, "Aska International Inc." },
        { 0x000A90, "Bayside Interactive, Inc." },
        { 0x000A91, "HemoCue AB" },
        { 0x000A92, "Presonus Corporation" },
        { 0x000A93, "W2 Networks, Inc." },
        { 0x000A94, "ShangHai cellink CO., LTD" },
        { 0x000A95, "Apple, Inc." },
        { 0x000A96, "MEWTEL TECHNOLOGY INC." },
        { 0x000A97, "SONICblue, Inc." },
        { 0x000A98, "M+F Gwinner GmbH & Co" },
        { 0x000A99, "Calamp Wireless Networks Inc" },
        { 0x000A9A, "Aiptek International Inc" },
        { 0x000A9B, "TB Group Inc" },
        { 0x000A9C, "Server Technology, Inc." },
        { 0x000A9D, "King Young Technology Co. Ltd." },
        { 0x000A9E, "BroadWeb Corportation" },
        { 0x000A9F, "Pannaway Technologies, Inc." },
        { 0x000AA0, "Cedar Point Communications" },
        { 0x000AA1, "V V S Limited" },
        { 0x000AA2, "SYSTEK INC." },
        { 0x000AA3, "SHIMAFUJI ELECTRIC CO.,LTD." },
        { 0x000AA4, "SHANGHAI SURVEILLANCE TECHNOLOGY CO,LTD" },
        { 0x000AA5, "MAXLINK INDUSTRIES LIMITED" },
        { 0x000AA6, "Hochiki Corporation" },
        { 0x000AA7, "FEI Electron Optics" },
        { 0x000AA8, "ePipe Pty. Ltd." },
        { 0x000AA9, "Brooks Automation GmbH" },
        { 0x000AAA, "AltiGen Communications Inc." },
        { 0x000AAB, "Toyota Technical Development Corporation" },
        { 0x000AAC, "TerraTec Electronic GmbH" },
        { 0x000AAD, "Stargames Corporation" },
        { 0x000AAE, "Rosemount Process Analytical" },
        { 0x000AAF, "Pipal Systems" },
        { 0x000AB0, "LOYTEC electronics GmbH" },
        { 0x000AB1, "GENETEC Corporation" },
        { 0x000AB2, "Fresnel Wireless Systems" },
        { 0x000AB3, "Fa. GIRA" },
        { 0x000AB4, "ETIC Telecommunications" },
        { 0x000AB5, "Digital Electronic Network" },
        { 0x000AB6, "COMPUNETIX, INC" },
        { 0x000AB7, "Cisco Systems, Inc" },
        { 0x000AB8, "Cisco Systems, Inc" },
        { 0x000AB9, "Astera Technologies Corp." },
        { 0x000ABA, "Arcon Technology Limited" },
        { 0x000ABB, "Taiwan Secom Co,. Ltd" },
        { 0x000ABC, "Seabridge Ltd." },
        { 0x000ABD, "Rupprecht & Patashnick Co." },
        { 0x000ABE, "OPNET Technologies CO., LTD." },
        { 0x000ABF, "HIROTA SS" },
        { 0x000AC0, "Fuyoh Video Industry CO., LTD." },
        { 0x000AC1, "Futuretel" },
        { 0x000AC2, "Wuhan FiberHome Digital Technology Co.,Ltd." },
        { 0x000AC3, "eM Technics Co., Ltd." },
        { 0x000AC4, "Daewoo Teletech Co., Ltd" },
        { 0x000AC5, "Color Kinetics" },
        { 0x000AC6, "Overture Networks." },
        { 0x000AC7, "Unication Group" },
        { 0x000AC8, "ZPSYS CO.,LTD. (Planning&Management)" },
        { 0x000AC9, "Zambeel Inc" },
        { 0x000ACA, "YOKOYAMA SHOKAI CO.,Ltd." },
        { 0x000ACB, "XPAK MSA Group" },
        { 0x000ACC, "Winnow Networks, Inc." },
        { 0x000ACD, "Sunrich Technology Limited" },
        { 0x000ACE, "RADIANTECH, INC." },
        { 0x000ACF, "PROVIDEO Multimedia Co. Ltd." },
        { 0x000AD0, "Niigata Develoment Center, F.I.T. Co., Ltd." },
        { 0x000AD1, "MWS" },
        { 0x000AD2, "JEPICO Corporation" },
        { 0x000AD3, "INITECH Co., Ltd" },
        { 0x000AD4, "CoreBell Systems Inc." },
        { 0x000AD5, "Brainchild Electronic Co., Ltd." },
        { 0x000AD6, "BeamReach Networks" },
        { 0x000AD7, "Origin ELECTRIC CO.,LTD." },
        { 0x000AD8, "IPCserv Technology Corp." },
        { 0x000AD9, "Sony Mobile Communications Inc" },
        { 0x000ADA, "Vindicator Technologies" },
        { 0x000ADB, "Trilliant" },
        { 0x000ADC, "RuggedCom Inc." },
        { 0x000ADD, "Allworx Corp." },
        { 0x000ADE, "Happy Communication Co., Ltd." },
        { 0x000ADF, "Gennum Corporation" },
        { 0x000AE0, "Fujitsu Softek" },
        { 0x000AE1, "EG Technology" },
        { 0x000AE2, "Binatone Electronics International, Ltd" },
        { 0x000AE3, "YANG MEI TECHNOLOGY CO., LTD" },
        { 0x000AE4, "Wistron Corporation" },
        { 0x000AE5, "ScottCare Corporation" },
        { 0x000AE6, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x000AE7, "ELIOP S.A." },
        { 0x000AE8, "Cathay Roxus Information Technology Co. LTD" },
        { 0x000AE9, "AirVast Technology Inc." },
        { 0x000AEA, "ADAM ELEKTRONIK LTD. ŞTI" },
        { 0x000AEB, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x000AEC, "Koatsu Gas Kogyo Co., Ltd." },
        { 0x000AED, "HARTING Electronics GmbH" },
        { 0x000AEE, "GCD Hard- & Software GmbH" },
        { 0x000AEF, "OTRUM ASA" },
        { 0x000AF0, "SHIN-OH ELECTRONICS CO., LTD. R&D" },
        { 0x000AF1, "Clarity Design, Inc." },
        { 0x000AF2, "NeoAxiom Corp." },
        { 0x000AF3, "Cisco Systems, Inc" },
        { 0x000AF4, "Cisco Systems, Inc" },
        { 0x000AF5, "Airgo Networks, Inc." },
        { 0x000AF6, "Emerson Climate Technologies Retail Solutions, Inc." },
        { 0x000AF7, "Broadcom" },
        { 0x000AF8, "American Telecare Inc." },
        { 0x000AF9, "HiConnect, Inc." },
        { 0x000AFA, "Traverse Technologies Australia" },
        { 0x000AFB, "Ambri Limited" },
        { 0x000AFC, "Core Tec Communications, LLC" },
        { 0x000AFD, "Kentec Electronics" },
        { 0x000AFE, "NovaPal Ltd" },
        { 0x000AFF, "Kilchherr Elektronik AG" },
        { 0x000B00, "FUJIAN START COMPUTER EQUIPMENT CO.,LTD" },
        { 0x000B01, "DAIICHI ELECTRONICS CO., LTD." },
        { 0x000B02, "Dallmeier electronic" },
        { 0x000B03, "Taekwang Industrial Co., Ltd" },
        { 0x000B04, "Volktek Corporation" },
        { 0x000B05, "Pacific Broadband Networks" },
        { 0x000B06, "ARRIS Group, Inc." },
        { 0x000B07, "Voxpath Networks" },
        { 0x000B08, "Pillar Data Systems" },
        { 0x000B09, "Ifoundry Systems Singapore" },
        { 0x000B0A, "dBm Optics" },
        { 0x000B0B, "Corrent Corporation" },
        { 0x000B0C, "Agile Systems Inc." },
        { 0x000B0D, "Air2U, Inc." },
        { 0x000B0E, "Trapeze Networks" },
        { 0x000B0F, "Bosch Rexroth" },
        { 0x000B10, "11wave Technonlogy Co.,Ltd" },
        { 0x000B11, "HIMEJI ABC TRADING CO.,LTD." },
        { 0x000B12, "NURI Telecom Co., Ltd." },
        { 0x000B13, "ZETRON INC" },
        { 0x000B14, "ViewSonic Corporation" },
        { 0x000B15, "Platypus Technology" },
        { 0x000B16, "Communication Machinery Corporation" },
        { 0x000B17, "MKS Instruments" },
        { 0x000B18, "Private" },
        { 0x000B19, "Vernier Networks, Inc." },
        { 0x000B1A, "Industrial Defender, Inc." },
        { 0x000B1B, "Systronix, Inc." },
        { 0x000B1C, "SIBCO bv" },
        { 0x000B1D, "LayerZero Power Systems, Inc." },
        { 0x000B1E, "KAPPA opto-electronics GmbH" },
        { 0x000B1F, "I CON Computer Co." },
        { 0x000B20, "Hirata corporation" },
        { 0x000B21, "G-Star Communications Inc." },
        { 0x000B22, "Environmental Systems and Services" },
        { 0x000B23, "Siemens Home & Office Comm. Devices" },
        { 0x000B24, "AirLogic" },
        { 0x000B25, "Aeluros" },
        { 0x000B26, "Wetek Corporation" },
        { 0x000B27, "Scion Corporation" },
        { 0x000B28, "Quatech Inc." },
        { 0x000B29, "LS(LG) Industrial Systems co.,Ltd" },
        { 0x000B2A, "HOWTEL Co., Ltd." },
        { 0x000B2B, "HOSTNET CORPORATION" },
        { 0x000B2C, "Eiki Industrial Co. Ltd." },
        { 0x000B2D, "Danfoss Inc." },
        { 0x000B2E, "Cal-Comp Electronics & Communications Company Ltd." },
        { 0x000B2F, "bplan GmbH" },
        { 0x000B30, "Beijing Gongye Science & Technology Co.,Ltd" },
        { 0x000B31, "Yantai ZhiYang Scientific and technology industry CO., LTD" },
        { 0x000B32, "VORMETRIC, INC." },
        { 0x000B33, "Vivato Technologies" },
        { 0x000B34, "ShangHai Broadband Technologies CO.LTD" },
        { 0x000B35, "Quad Bit System co., Ltd." },
        { 0x000B36, "Productivity Systems, Inc." },
        { 0x000B37, "MANUFACTURE DES MONTRES ROLEX SA" },
        { 0x000B38, "Knürr GmbH" },
        { 0x000B39, "Keisoku Giken Co.,Ltd." },
        { 0x000B3A, "QuStream Corporation" },
        { 0x000B3B, "devolo AG" },
        { 0x000B3C, "Cygnal Integrated Products, Inc." },
        { 0x000B3D, "CONTAL OK Ltd." },
        { 0x000B3E, "BittWare, Inc" },
        { 0x000B3F, "Anthology Solutions Inc." },
        { 0x000B40, "Cambridge Industries Group (CIG)" },
        { 0x000B41, "Ing. Büro Dr. Beutlhauser" },
        { 0x000B42, "commax Co., Ltd." },
        { 0x000B43, "Microscan Systems, Inc." },
        { 0x000B44, "Concord IDea Corp." },
        { 0x000B45, "Cisco Systems, Inc" },
        { 0x000B46, "Cisco Systems, Inc" },
        { 0x000B47, "Advanced Energy" },
        { 0x000B48, "sofrel" },
        { 0x000B49, "RF-Link System Inc." },
        { 0x000B4A, "Visimetrics (UK) Ltd" },
        { 0x000B4B, "VISIOWAVE SA" },
        { 0x000B4C, "Clarion (M) Sdn Bhd" },
        { 0x000B4D, "Emuzed" },
        { 0x000B4E, "Communications & Power Industries" },
        { 0x000B4F, "Verifone" },
        { 0x000B50, "Oxygnet" },
        { 0x000B51, "Micetek International Inc." },
        { 0x000B52, "JOYMAX ELECTRONICS CO. LTD." },
        { 0x000B53, "INITIUM Co., Ltd." },
        { 0x000B54, "BiTMICRO Networks, Inc." },
        { 0x000B55, "ADInstruments" },
        { 0x000B56, "Cybernetics" },
        { 0x000B57, "Silicon Laboratories" },
        { 0x000B58, "Astronautics C.A LTD" },
        { 0x000B59, "ScriptPro, LLC" },
        { 0x000B5A, "HyperEdge" },
        { 0x000B5B, "Rincon Research Corporation" },
        { 0x000B5C, "Newtech Co.,Ltd" },
        { 0x000B5D, "FUJITSU LIMITED" },
        { 0x000B5E, "Audio Engineering Society Inc." },
        { 0x000B5F, "Cisco Systems, Inc" },
        { 0x000B60, "Cisco Systems, Inc" },
        { 0x000B61, "Friedrich Lütze GmbH & Co. KG" },
        { 0x000B62, "ib-mohnen KG" },
        { 0x000B63, "Kaleidescape" },
        { 0x000B64, "Kieback & Peter GmbH & Co KG" },
        { 0x000B65, "Sy.A.C. srl" },
        { 0x000B66, "Teralink Communications" },
        { 0x000B67, "Topview Technology Corporation" },
        { 0x000B68, "Addvalue Communications Pte Ltd" },
        { 0x000B69, "Franke Finland Oy" },
        { 0x000B6A, "Asiarock Technology Limited" },
        { 0x000B6B, "Wistron Neweb Corporation" },
        { 0x000B6C, "Sychip Inc." },
        { 0x000B6D, "SOLECTRON JAPAN NAKANIIDA" },
        { 0x000B6E, "Neff Instrument Corp." },
        { 0x000B6F, "Media Streaming Networks Inc" },
        { 0x000B70, "Load Technology, Inc." },
        { 0x000B71, "Litchfield Communications Inc." },
        { 0x000B72, "Lawo AG" },
        { 0x000B73, "Kodeos Communications" },
        { 0x000B74, "Kingwave Technology Co., Ltd." },
        { 0x000B75, "Iosoft Ltd." },
        { 0x000B76, "ET&T Technology Co. Ltd." },
        { 0x000B77, "Cogent Systems, Inc." },
        { 0x000B78, "TAIFATECH INC." },
        { 0x000B79, "X-COM, Inc." },
        { 0x000B7A, "L-3 Linkabit" },
        { 0x000B7B, "Test-Um Inc." },
        { 0x000B7C, "Telex Communications" },
        { 0x000B7D, "SOLOMON EXTREME INTERNATIONAL LTD." },
        { 0x000B7E, "SAGINOMIYA Seisakusho Inc." },
        { 0x000B7F, "Align Engineering LLC" },
        { 0x000B80, "Lycium Networks" },
        { 0x000B81, "Kaparel Corporation" },
        { 0x000B82, "Grandstream Networks, Inc." },
        { 0x000B83, "DATAWATT B.V." },
        { 0x000B84, "BODET" },
        { 0x000B85, "Cisco Systems, Inc" },
        { 0x000B86, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x000B87, "American Reliance Inc." },
        { 0x000B88, "Vidisco ltd." },
        { 0x000B89, "Top Global Technology, Ltd." },
        { 0x000B8A, "MITEQ Inc." },
        { 0x000B8B, "KERAJET, S.A." },
        { 0x000B8C, "Flextronics" },
        { 0x000B8D, "Avvio Networks" },
        { 0x000B8E, "Ascent Corporation" },
        { 0x000B8F, "AKITA ELECTRONICS SYSTEMS CO.,LTD." },
        { 0x000B90, "ADVA Optical Networking Ltd." },
        { 0x000B91, "Aglaia Gesellschaft für Bildverarbeitung und Kommunikation mbH" },
        { 0x000B92, "Ascom Danmark A/S" },
        { 0x000B93, "Ritter Elektronik" },
        { 0x000B94, "Digital Monitoring Products, Inc." },
        { 0x000B95, "eBet Gaming Systems Pty Ltd" },
        { 0x000B96, "Innotrac Diagnostics Oy" },
        { 0x000B97, "Matsushita Electric Industrial Co.,Ltd." },
        { 0x000B98, "NiceTechVision" },
        { 0x000B99, "SensAble Technologies, Inc." },
        { 0x000B9A, "Shanghai Ulink Telecom Equipment Co. Ltd." },
        { 0x000B9B, "Sirius System Co, Ltd." },
        { 0x000B9C, "TriBeam Technologies, Inc." },
        { 0x000B9D, "TwinMOS Technologies Inc." },
        { 0x000B9E, "Yasing Technology Corp." },
        { 0x000B9F, "Neue ELSA GmbH" },
        { 0x000BA0, "T&L Information Inc." },
        { 0x000BA1, "Fujikura Solutions Ltd." },
        { 0x000BA2, "Sumitomo Electric Industries, Ltd" },
        { 0x000BA3, "Siemens AG" },
        { 0x000BA4, "Shiron Satellite Communications Ltd. (1996)" },
        { 0x000BA5, "Quasar Cipta Mandiri, PT" },
        { 0x000BA6, "Miyakawa Electric Works Ltd." },
        { 0x000BA7, "Maranti Networks" },
        { 0x000BA8, "HANBACK ELECTRONICS CO., LTD." },
        { 0x000BA9, "CloudShield Technologies, Inc." },
        { 0x000BAA, "Aiphone co.,Ltd" },
        { 0x000BAB, "Advantech Technology (CHINA) Co., Ltd." },
        { 0x000BAC, "3Com Ltd" },
        { 0x000BAD, "PC-PoS Inc." },
        { 0x000BAE, "Vitals System Inc." },
        { 0x000BAF, "WOOJU COMMUNICATIONS Co,.Ltd" },
        { 0x000BB0, "Sysnet Telematica srl" },
        { 0x000BB1, "Super Star Technology Co., Ltd." },
        { 0x000BB2, "SMALLBIG TECHNOLOGY" },
        { 0x000BB3, "RiT technologies Ltd." },
        { 0x000BB4, "RDC Semiconductor Inc.," },
        { 0x000BB5, "nStor Technologies, Inc." },
        { 0x000BB6, "Metalligence Technology Corp." },
        { 0x000BB7, "Micro Systems Co.,Ltd." },
        { 0x000BB8, "Kihoku Electronic Co." },
        { 0x000BB9, "Imsys AB" },
        { 0x000BBA, "Harmonic, Inc" },
        { 0x000BBB, "Etin Systems Co., Ltd" },
        { 0x000BBC, "En Garde Systems, Inc." },
        { 0x000BBD, "Connexionz Limited" },
        { 0x000BBE, "Cisco Systems, Inc" },
        { 0x000BBF, "Cisco Systems, Inc" },
        { 0x000BC0, "China IWNComm Co., Ltd." },
        { 0x000BC1, "Bay Microsystems, Inc." },
        { 0x000BC2, "Corinex Communication Corp." },
        { 0x000BC3, "Multiplex, Inc." },
        { 0x000BC4, "BIOTRONIK GmbH & Co" },
        { 0x000BC5, "SMC Networks, Inc." },
        { 0x000BC6, "ISAC, Inc." },
        { 0x000BC7, "ICET S.p.A." },
        { 0x000BC8, "AirFlow Networks" },
        { 0x000BC9, "Electroline Equipment" },
        { 0x000BCA, "DATAVAN TC" },
        { 0x000BCB, "Fagor Automation , S. Coop" },
        { 0x000BCC, "JUSAN, S.A." },
        { 0x000BCD, "Hewlett Packard" },
        { 0x000BCE, "Free2move AB" },
        { 0x000BCF, "AGFA NDT INC." },
        { 0x000BD0, "XiMeta Technology Americas Inc." },
        { 0x000BD1, "Aeronix, Inc." },
        { 0x000BD2, "Remopro Technology Inc." },
        { 0x000BD3, "cd3o" },
        { 0x000BD4, "Beijing Wise Technology & Science Development Co.Ltd" },
        { 0x000BD5, "Nvergence, Inc." },
        { 0x000BD6, "Paxton Access Ltd" },
        { 0x000BD7, "DORMA Time + Access GmbH" },
        { 0x000BD8, "Industrial Scientific Corp." },
        { 0x000BD9, "General Hydrogen" },
        { 0x000BDA, "EyeCross Co.,Inc." },
        { 0x000BDB, "Dell Inc." },
        { 0x000BDC, "AKCP" },
        { 0x000BDD, "TOHOKU RICOH Co., LTD." },
        { 0x000BDE, "TELDIX GmbH" },
        { 0x000BDF, "Shenzhen RouterD Networks Limited" },
        { 0x000BE0, "SercoNet Ltd." },
        { 0x000BE1, "Nokia NET Product Operations" },
        { 0x000BE2, "Lumenera Corporation" },
        { 0x000BE3, "Key Stream Co., Ltd." },
        { 0x000BE4, "Hosiden Corporation" },
        { 0x000BE5, "HIMS International Corporation" },
        { 0x000BE6, "Datel Electronics" },
        { 0x000BE7, "COMFLUX TECHNOLOGY INC." },
        { 0x000BE8, "AOIP" },
        { 0x000BE9, "Actel Corporation" },
        { 0x000BEA, "Zultys Technologies" },
        { 0x000BEB, "Systegra AG" },
        { 0x000BEC, "NIPPON ELECTRIC INSTRUMENT, INC." },
        { 0x000BED, "ELM Inc." },
        { 0x000BEE, "inc.jet, Incorporated" },
        { 0x000BEF, "Code Corporation" },
        { 0x000BF0, "MoTEX Products Co., Ltd." },
        { 0x000BF1, "LAP Laser Applikations" },
        { 0x000BF2, "Chih-Kan Technology Co., Ltd." },
        { 0x000BF3, "BAE SYSTEMS" },
        { 0x000BF4, "Private" },
        { 0x000BF5, "Shanghai Sibo Telecom Technology Co.,Ltd" },
        { 0x000BF6, "Nitgen Co., Ltd" },
        { 0x000BF7, "NIDEK CO.,LTD" },
        { 0x000BF8, "Infinera" },
        { 0x000BF9, "Gemstone Communications, Inc." },
        { 0x000BFA, "EXEMYS SRL" },
        { 0x000BFB, "D-NET International Corporation" },
        { 0x000BFC, "Cisco Systems, Inc" },
        { 0x000BFD, "Cisco Systems, Inc" },
        { 0x000BFE, "CASTEL Broadband Limited" },
        { 0x000BFF, "Berkeley Camera Engineering" },
        { 0x000C00, "BEB Industrie-Elektronik AG" },
        { 0x000C01, "Abatron AG" },
        { 0x000C02, "ABB Oy" },
        { 0x000C03, "HDMI Licensing, LLC" },
        { 0x000C04, "Tecnova" },
        { 0x000C05, "RPA Reserch Co., Ltd." },
        { 0x000C06, "Nixvue Systems Pte Ltd" },
        { 0x000C07, "Iftest AG" },
        { 0x000C08, "HUMEX Technologies Corp." },
        { 0x000C09, "Hitachi IE Systems Co., Ltd" },
        { 0x000C0A, "Guangdong Province Electronic Technology Research Institute" },
        { 0x000C0B, "Broadbus Technologies" },
        { 0x000C0C, "APPRO TECHNOLOGY INC." },
        { 0x000C0D, "Communications & Power Industries / Satcom Division" },
        { 0x000C0E, "XtremeSpectrum, Inc." },
        { 0x000C0F, "Techno-One Co., Ltd" },
        { 0x000C10, "PNI Corporation" },
        { 0x000C11, "NIPPON DEMPA CO.,LTD." },
        { 0x000C12, "Micro-Optronic-Messtechnik GmbH" },
        { 0x000C13, "MediaQ" },
        { 0x000C14, "Diagnostic Instruments, Inc." },
        { 0x000C15, "CyberPower Systems, Inc." },
        { 0x000C16, "Concorde Microsystems Inc." },
        { 0x000C17, "AJA Video Systems Inc" },
        { 0x000C18, "Zenisu Keisoku Inc." },
        { 0x000C19, "Telio Communications GmbH" },
        { 0x000C1A, "Quest Technical Solutions Inc." },
        { 0x000C1B, "ORACOM Co, Ltd." },
        { 0x000C1C, "MicroWeb Co., Ltd." },
        { 0x000C1D, "Mettler & Fuchs AG" },
        { 0x000C1E, "Global Cache" },
        { 0x000C1F, "Glimmerglass Networks" },
        { 0x000C20, "Fi WIn, Inc." },
        { 0x000C21, "Faculty of Science and Technology, Keio University" },
        { 0x000C22, "Double D Electronics Ltd" },
        { 0x000C23, "Beijing Lanchuan Tech. Co., Ltd." },
        { 0x000C24, "ANATOR" },
        { 0x000C25, "Allied Telesis Labs, Inc." },
        { 0x000C26, "Weintek Labs. Inc." },
        { 0x000C27, "Sammy Corporation" },
        { 0x000C28, "RIFATRON" },
        { 0x000C29, "VMware, Inc." },
        { 0x000C2A, "OCTTEL Communication Co., Ltd." },
        { 0x000C2B, "ELIAS Technology, Inc." },
        { 0x000C2C, "Enwiser Inc." },
        { 0x000C2D, "FullWave Technology Co., Ltd." },
        { 0x000C2E, "Openet information technology(shenzhen) Co., Ltd." },
        { 0x000C2F, "SeorimTechnology Co.,Ltd." },
        { 0x000C30, "Cisco Systems, Inc" },
        { 0x000C31, "Cisco Systems, Inc" },
        { 0x000C32, "Avionic Design GmbH" },
        { 0x000C33, "Compucase Enterprise Co. Ltd." },
        { 0x000C34, "Vixen Co., Ltd." },
        { 0x000C35, "KaVo Dental GmbH & Co. KG" },
        { 0x000C36, "SHARP TAKAYA ELECTRONICS INDUSTRY CO.,LTD." },
        { 0x000C37, "Geomation, Inc." },
        { 0x000C38, "TelcoBridges Inc." },
        { 0x000C39, "Sentinel Wireless Inc." },
        { 0x000C3A, "Oxance" },
        { 0x000C3B, "Orion Electric Co., Ltd." },
        { 0x000C3C, "MediaChorus, Inc." },
        { 0x000C3D, "Glsystech Co., Ltd." },
        { 0x000C3E, "Crest Audio" },
        { 0x000C3F, "Cogent Defence & Security Networks," },
        { 0x000C40, "Altech Controls" },
        { 0x000C41, "Cisco-Linksys, LLC" },
        { 0x000C42, "Routerboard.com" },
        { 0x000C43, "Ralink Technology, Corp." },
        { 0x000C44, "Automated Interfaces, Inc." },
        { 0x000C45, "Animation Technologies Inc." },
        { 0x000C46, "Allied Telesyn Inc." },
        { 0x000C47, "SK Teletech(R&D Planning Team)" },
        { 0x000C48, "QoStek Corporation" },
        { 0x000C49, "Dangaard Telecom Denmark A/S" },
        { 0x000C4A, "Cygnus Microsystems (P) Limited" },
        { 0x000C4B, "Cheops Elektronik" },
        { 0x000C4C, "Arcor AG&Co." },
        { 0x000C4D, "Curtiss-Wright Controls Avionics & Electronics" },
        { 0x000C4E, "Winbest Technology CO,LT" },
        { 0x000C4F, "UDTech Japan Corporation" },
        { 0x000C50, "Seagate Technology" },
        { 0x000C51, "Scientific Technologies Inc." },
        { 0x000C52, "Roll Systems Inc." },
        { 0x000C53, "Private" },
        { 0x000C54, "Pedestal Networks, Inc" },
        { 0x000C55, "Microlink Communications Inc." },
        { 0x000C56, "Megatel Computer (1986) Corp." },
        { 0x000C57, "MACKIE Engineering Services Belgium BVBA" },
        { 0x000C58, "M&S Systems" },
        { 0x000C59, "Indyme Electronics, Inc." },
        { 0x000C5A, "IBSmm Embedded Electronics Consulting" },
        { 0x000C5B, "HANWANG TECHNOLOGY CO.,LTD" },
        { 0x000C5C, "GTN Systems B.V." },
        { 0x000C5D, "CHIC TECHNOLOGY (CHINA) CORP." },
        { 0x000C5E, "Calypso Medical" },
        { 0x000C5F, "Avtec, Inc." },
        { 0x000C60, "ACM Systems" },
        { 0x000C61, "AC Tech corporation DBA Advanced Digital" },
        { 0x000C62, "ABB AB, Cewe-Control" },
        { 0x000C63, "Zenith Electronics Corporation" },
        { 0x000C64, "X2 MSA Group" },
        { 0x000C65, "Sunin Telecom" },
        { 0x000C66, "Pronto Networks Inc" },
        { 0x000C67, "OYO ELECTRIC CO.,LTD" },
        { 0x000C68, "SigmaTel, Inc." },
        { 0x000C69, "National Radio Astronomy Observatory" },
        { 0x000C6A, "MBARI" },
        { 0x000C6B, "Kurz Industrie-Elektronik GmbH" },
        { 0x000C6C, "Eve Systems GmbH" },
        { 0x000C6D, "Edwards Ltd." },
        { 0x000C6E, "ASUSTek COMPUTER INC." },
        { 0x000C6F, "Amtek system co.,LTD." },
        { 0x000C70, "ACC GmbH" },
        { 0x000C71, "Wybron, Inc" },
        { 0x000C72, "Tempearl Industrial Co., Ltd." },
        { 0x000C73, "TELSON ELECTRONICS CO., LTD" },
        { 0x000C74, "RIVERTEC CORPORATION" },
        { 0x000C75, "Oriental integrated electronics. LTD" },
        { 0x000C76, "MICRO-STAR INTERNATIONAL CO., LTD." },
        { 0x000C77, "Life Racing Ltd" },
        { 0x000C78, "In-Tech Electronics Limited" },
        { 0x000C79, "Extel Communications P/L" },
        { 0x000C7A, "DaTARIUS Technologies GmbH" },
        { 0x000C7B, "ALPHA PROJECT Co.,Ltd." },
        { 0x000C7C, "Internet Information Image Inc." },
        { 0x000C7D, "TEIKOKU ELECTRIC MFG. CO., LTD" },
        { 0x000C7E, "Tellium Incorporated" },
        { 0x000C7F, "synertronixx GmbH" },
        { 0x000C80, "Opelcomm Inc." },
        { 0x000C81, "Schneider Electric (Australia)" },
        { 0x000C82, "NETWORK TECHNOLOGIES INC" },
        { 0x000C83, "Logical Solutions" },
        { 0x000C84, "Eazix, Inc." },
        { 0x000C85, "Cisco Systems, Inc" },
        { 0x000C86, "Cisco Systems, Inc" },
        { 0x000C87, "AMD" },
        { 0x000C88, "Apache Micro Peripherals, Inc." },
        { 0x000C89, "AC Electric Vehicles, Ltd." },
        { 0x000C8A, "Bose Corporation" },
        { 0x000C8B, "Connect Tech Inc" },
        { 0x000C8C, "KODICOM CO.,LTD." },
        { 0x000C8D, "MATRIX VISION GmbH" },
        { 0x000C8E, "Mentor Engineering Inc" },
        { 0x000C8F, "Nergal s.r.l." },
        { 0x000C90, "Octasic Inc." },
        { 0x000C91, "Riverhead Networks Inc." },
        { 0x000C92, "WolfVision Gmbh" },
        { 0x000C93, "Xeline Co., Ltd." },
        { 0x000C94, "United Electronic Industries, Inc. (EUI)" },
        { 0x000C95, "PrimeNet" },
        { 0x000C96, "OQO, Inc." },
        { 0x000C97, "NV ADB TTV Technologies SA" },
        { 0x000C98, "LETEK Communications Inc." },
        { 0x000C99, "HITEL LINK Co.,Ltd" },
        { 0x000C9A, "Hitech Electronics Corp." },
        { 0x000C9B, "EE Solutions, Inc" },
        { 0x000C9C, "Chongho information & communications" },
        { 0x000C9D, "UbeeAirWalk, Inc." },
        { 0x000C9E, "MemoryLink Corp." },
        { 0x000C9F, "NKE Corporation" },
        { 0x000CA0, "StorCase Technology, Inc." },
        { 0x000CA1, "SIGMACOM Co., LTD." },
        { 0x000CA2, "Harmonic Video Network" },
        { 0x000CA3, "Rancho Technology, Inc." },
        { 0x000CA4, "Prompttec Product Management GmbH" },
        { 0x000CA5, "Naman NZ LTd" },
        { 0x000CA6, "Mintera Corporation" },
        { 0x000CA7, "Metro (Suzhou) Technologies Co., Ltd." },
        { 0x000CA8, "Garuda Networks Corporation" },
        { 0x000CA9, "Ebtron Inc." },
        { 0x000CAA, "Cubic Transportation Systems Inc" },
        { 0x000CAB, "Commend International GmbH" },
        { 0x000CAC, "Citizen Watch Co., Ltd." },
        { 0x000CAD, "BTU International" },
        { 0x000CAE, "Ailocom Oy" },
        { 0x000CAF, "TRI TERM CO.,LTD." },
        { 0x000CB0, "Star Semiconductor Corporation" },
        { 0x000CB1, "Salland Engineering (Europe) BV" },
        { 0x000CB2, "UNION co., ltd." },
        { 0x000CB3, "ROUND Co.,Ltd." },
        { 0x000CB4, "AutoCell Laboratories, Inc." },
        { 0x000CB5, "Premier Technolgies, Inc" },
        { 0x000CB6, "NANJING SEU MOBILE & INTERNET TECHNOLOGY CO.,LTD" },
        { 0x000CB7, "Nanjing Huazhuo Electronics Co., Ltd." },
        { 0x000CB8, "MEDION AG" },
        { 0x000CB9, "LEA" },
        { 0x000CBA, "Jamex, Inc." },
        { 0x000CBB, "ISKRAEMECO" },
        { 0x000CBC, "Iscutum" },
        { 0x000CBD, "Interface Masters, Inc" },
        { 0x000CBE, "Innominate Security Technologies AG" },
        { 0x000CBF, "Holy Stone Ent. Co., Ltd." },
        { 0x000CC0, "Genera Oy" },
        { 0x000CC1, "Eaton Corporation" },
        { 0x000CC2, "ControlNet (India) Private Limited" },
        { 0x000CC3, "BeWAN systems" },
        { 0x000CC4, "Tiptel AG" },
        { 0x000CC5, "Nextlink Co., Ltd." },
        { 0x000CC6, "Ka-Ro electronics GmbH" },
        { 0x000CC7, "Intelligent Computer Solutions Inc." },
        { 0x000CC8, "Xytronix Research & Design, Inc." },
        { 0x000CC9, "ILWOO DATA & TECHNOLOGY CO.,LTD" },
        { 0x000CCA, "HGST a Western Digital Company" },
        { 0x000CCB, "Design Combus Ltd" },
        { 0x000CCC, "Aeroscout Ltd." },
        { 0x000CCD, "IEC - TC57" },
        { 0x000CCE, "Cisco Systems, Inc" },
        { 0x000CCF, "Cisco Systems, Inc" },
        { 0x000CD0, "Symetrix" },
        { 0x000CD1, "SFOM Technology Corp." },
        { 0x000CD2, "Schaffner EMV AG" },
        { 0x000CD3, "Prettl Elektronik Radeberg GmbH" },
        { 0x000CD4, "Positron Public Safety Systems inc." },
        { 0x000CD5, "Passave Inc." },
        { 0x000CD6, "PARTNER TECH" },
        { 0x000CD7, "Nallatech Ltd" },
        { 0x000CD8, "M. K. Juchheim GmbH & Co" },
        { 0x000CD9, "Itcare Co., Ltd" },
        { 0x000CDA, "FreeHand Systems, Inc." },
        { 0x000CDB, "Brocade Communications Systems LLC" },
        { 0x000CDC, "BECS Technology, Inc" },
        { 0x000CDD, "AOS technologies AG" },
        { 0x000CDE, "ABB STOTZ-KONTAKT GmbH" },
        { 0x000CDF, "JAI Manufacturing" },
        { 0x000CE0, "Trek Diagnostics Inc." },
        { 0x000CE1, "The Open Group" },
        { 0x000CE2, "Rolls-Royce" },
        { 0x000CE3, "Option International N.V." },
        { 0x000CE4, "NeuroCom International, Inc." },
        { 0x000CE5, "ARRIS Group, Inc." },
        { 0x000CE6, "Fortinet Inc." },
        { 0x000CE7, "MediaTek Inc." },
        { 0x000CE8, "GuangZhou AnJuBao Co., Ltd" },
        { 0x000CE9, "BLOOMBERG L.P." },
        { 0x000CEA, "aphona Kommunikationssysteme" },
        { 0x000CEB, "CNMP Networks, Inc." },
        { 0x000CEC, "Spectracom Corp." },
        { 0x000CED, "Real Digital Media" },
        { 0x000CEE, "jp-embedded" },
        { 0x000CEF, "Open Networks Engineering Ltd" },
        { 0x000CF0, "M & N GmbH" },
        { 0x000CF1, "Intel Corporation" },
        { 0x000CF2, "GAMESA Eólica" },
        { 0x000CF3, "CALL IMAGE SA" },
        { 0x000CF4, "AKATSUKI ELECTRIC MFG.CO.,LTD." },
        { 0x000CF5, "InfoExpress" },
        { 0x000CF6, "Sitecom Europe BV" },
        { 0x000CF7, "Nortel Networks" },
        { 0x000CF8, "Nortel Networks" },
        { 0x000CF9, "Xylem Water Solutions" },
        { 0x000CFA, "Digital Systems Corp" },
        { 0x000CFB, "Korea Network Systems" },
        { 0x000CFC, "S2io Technologies Corp" },
        { 0x000CFD, "Hyundai ImageQuest Co.,Ltd." },
        { 0x000CFE, "Grand Electronic Co., Ltd" },
        { 0x000CFF, "MRO-TEK Realty Limited" },
        { 0x000D00, "Seaway Networks Inc." },
        { 0x000D01, "P&E Microcomputer Systems, Inc." },
        { 0x000D02, "NEC Platforms, Ltd." },
        { 0x000D03, "Matrics, Inc." },
        { 0x000D04, "Foxboro Eckardt Development GmbH" },
        { 0x000D05, "cybernet manufacturing inc." },
        { 0x000D06, "Compulogic Limited" },
        { 0x000D07, "Calrec Audio Ltd" },
        { 0x000D08, "AboveCable, Inc." },
        { 0x000D09, "Yuehua(Zhuhai) Electronic CO. LTD" },
        { 0x000D0A, "Barco Projection Systems NV" },
        { 0x000D0B, "BUFFALO.INC" },
        { 0x000D0C, "MDI Security Systems" },
        { 0x000D0D, "ITSupported, LLC" },
        { 0x000D0E, "Inqnet Systems, Inc." },
        { 0x000D0F, "Finlux Ltd" },
        { 0x000D10, "Embedtronics Oy" },
        { 0x000D11, "DENTSPLY - Gendex" },
        { 0x000D12, "AXELL Corporation" },
        { 0x000D13, "Wilhelm Rutenbeck GmbH&Co.KG" },
        { 0x000D14, "Vtech Innovation LP dba Advanced American Telephones" },
        { 0x000D15, "Voipac s.r.o." },
        { 0x000D16, "UHS Systems Pty Ltd" },
        { 0x000D17, "Turbo Networks Co.Ltd" },
        { 0x000D18, "Mega-Trend Electronics CO., LTD." },
        { 0x000D19, "ROBE Show lighting" },
        { 0x000D1A, "Mustek System Inc." },
        { 0x000D1B, "Kyoto Electronics Manufacturing Co., Ltd." },
        { 0x000D1C, "Amesys Defense" },
        { 0x000D1D, "HIGH-TEK HARNESS ENT. CO., LTD." },
        { 0x000D1E, "Control Techniques" },
        { 0x000D1F, "AV Digital" },
        { 0x000D20, "ASAHIKASEI TECHNOSYSTEM CO.,LTD." },
        { 0x000D21, "WISCORE Inc." },
        { 0x000D22, "Unitronics LTD" },
        { 0x000D23, "Smart Solution, Inc" },
        { 0x000D24, "SENTEC E&E CO., LTD." },
        { 0x000D25, "SANDEN CORPORATION" },
        { 0x000D26, "Primagraphics Limited" },
        { 0x000D27, "MICROPLEX Printware AG" },
        { 0x000D28, "Cisco Systems, Inc" },
        { 0x000D29, "Cisco Systems, Inc" },
        { 0x000D2A, "Scanmatic AS" },
        { 0x000D2B, "Racal Instruments" },
        { 0x000D2C, "Net2Edge Limited" },
        { 0x000D2D, "NCT Deutschland GmbH" },
        { 0x000D2E, "Matsushita Avionics Systems Corporation" },
        { 0x000D2F, "AIN Comm.Tech.Co., LTD" },
        { 0x000D30, "IceFyre Semiconductor" },
        { 0x000D31, "Compellent Technologies, Inc." },
        { 0x000D32, "DispenseSource, Inc." },
        { 0x000D33, "Prediwave Corp." },
        { 0x000D34, "Shell International Exploration and Production, Inc." },
        { 0x000D35, "PAC International Ltd" },
        { 0x000D36, "Wu Han Routon Electronic Co., Ltd" },
        { 0x000D37, "WIPLUG" },
        { 0x000D38, "NISSIN INC." },
        { 0x000D39, "Network Electronics" },
        { 0x000D3A, "Microsoft Corp." },
        { 0x000D3B, "Microelectronics Technology Inc." },
        { 0x000D3C, "i.Tech Dynamic Ltd" },
        { 0x000D3D, "Hammerhead Systems, Inc." },
        { 0x000D3E, "APLUX Communications Ltd." },
        { 0x000D3F, "VTI Instruments Corporation" },
        { 0x000D40, "Verint Loronix Video Solutions" },
        { 0x000D41, "Siemens AG ICM MP UC RD IT KLF1" },
        { 0x000D42, "Newbest Development Limited" },
        { 0x000D43, "DRS Tactical Systems Inc." },
        { 0x000D44, "Audio BU - Logitech" },
        { 0x000D45, "Tottori SANYO Electric Co., Ltd." },
        { 0x000D46, "Parker SSD Drives" },
        { 0x000D47, "Collex" },
        { 0x000D48, "AEWIN Technologies Co., Ltd." },
        { 0x000D49, "Triton Systems of Delaware, Inc." },
        { 0x000D4A, "Steag ETA-Optik" },
        { 0x000D4B, "Roku, Inc." },
        { 0x000D4C, "Outline Electronics Ltd." },
        { 0x000D4D, "Ninelanes" },
        { 0x000D4E, "NDR Co.,LTD." },
        { 0x000D4F, "Kenwood Corporation" },
        { 0x000D50, "Galazar Networks" },
        { 0x000D51, "DIVR Systems, Inc." },
        { 0x000D52, "Comart system" },
        { 0x000D53, "Beijing 5w Communication Corp." },
        { 0x000D54, "3Com Ltd" },
        { 0x000D55, "SANYCOM Technology Co.,Ltd" },
        { 0x000D56, "Dell Inc." },
        { 0x000D57, "Fujitsu I-Network Systems Limited." },
        { 0x000D58, "Private" },
        { 0x000D59, "Amity Systems, Inc." },
        { 0x000D5A, "Tiesse SpA" },
        { 0x000D5B, "Smart Empire Investments Limited" },
        { 0x000D5C, "Robert Bosch GmbH, VT-ATMO" },
        { 0x000D5D, "Raritan Computer, Inc" },
        { 0x000D5E, "NEC Personal Products" },
        { 0x000D5F, "Minds Inc" },
        { 0x000D60, "IBM Corp" },
        { 0x000D61, "Giga-Byte Technology Co., Ltd." },
        { 0x000D62, "Funkwerk Dabendorf GmbH" },
        { 0x000D63, "DENT Instruments, Inc." },
        { 0x000D64, "COMAG Handels AG" },
        { 0x000D65, "Cisco Systems, Inc" },
        { 0x000D66, "Cisco Systems, Inc" },
        { 0x000D67, "Ericsson" },
        { 0x000D68, "Vinci Systems, Inc." },
        { 0x000D69, "TMT&D Corporation" },
        { 0x000D6A, "Redwood Technologies LTD" },
        { 0x000D6B, "Mita-Teknik A/S" },
        { 0x000D6C, "M-Audio" },
        { 0x000D6D, "K-Tech Devices Corp." },
        { 0x000D6E, "K-Patents Oy" },
        { 0x000D6F, "Ember Corporation" },
        { 0x000D70, "Datamax Corporation" },
        { 0x000D71, "boca systems" },
        { 0x000D72, "2Wire Inc" },
        { 0x000D73, "Technical Support, Inc." },
        { 0x000D74, "Sand Network Systems, Inc." },
        { 0x000D75, "Kobian Pte Ltd - Taiwan Branch" },
        { 0x000D76, "Hokuto Denshi Co,. Ltd." },
        { 0x000D77, "FalconStor Software" },
        { 0x000D78, "Engineering & Security" },
        { 0x000D79, "Dynamic Solutions Co,.Ltd." },
        { 0x000D7A, "DiGATTO Asia Pacific Pte Ltd" },
        { 0x000D7B, "Consensys Computers Inc." },
        { 0x000D7C, "Codian Ltd" },
        { 0x000D7D, "Afco Systems" },
        { 0x000D7E, "Axiowave Networks, Inc." },
        { 0x000D7F, "MIDAS COMMUNICATION TECHNOLOGIES PTE LTD ( Foreign Branch)" },
        { 0x000D80, "Online Development Inc" },
        { 0x000D81, "Pepperl+Fuchs GmbH" },
        { 0x000D82, "PHSNET" },
        { 0x000D83, "Sanmina-SCI Hungary Ltd." },
        { 0x000D84, "Makus Inc." },
        { 0x000D85, "Tapwave, Inc." },
        { 0x000D86, "Huber + Suhner AG" },
        { 0x000D87, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x000D88, "D-Link Corporation" },
        { 0x000D89, "Bils Technology Inc" },
        { 0x000D8A, "Winners Electronics Co., Ltd." },
        { 0x000D8B, "T&D Corporation" },
        { 0x000D8C, "Shanghai Wedone Digital Ltd. CO." },
        { 0x000D8D, "Prosoft Technology, Inc" },
        { 0x000D8E, "Koden Electronics Co., Ltd." },
        { 0x000D8F, "King Tsushin Kogyo Co., LTD." },
        { 0x000D90, "Factum Electronics AB" },
        { 0x000D91, "Eclipse (HQ Espana) S.L." },
        { 0x000D92, "ARIMA Communications Corp." },
        { 0x000D93, "Apple, Inc." },
        { 0x000D94, "AFAR Communications,Inc" },
        { 0x000D95, "Opti-cell, Inc." },
        { 0x000D96, "Vtera Technology Inc." },
        { 0x000D97, "ABB Inc./Tropos" },
        { 0x000D98, "S.W.A.C. Schmitt-Walter Automation Consult GmbH" },
        { 0x000D99, "Orbital Sciences Corp.; Launch Systems Group" },
        { 0x000D9A, "INFOTEC LTD" },
        { 0x000D9B, "Heraeus Electro-Nite International N.V." },
        { 0x000D9C, "Elan GmbH & Co KG" },
        { 0x000D9D, "Hewlett Packard" },
        { 0x000D9E, "TOKUDEN OHIZUMI SEISAKUSYO Co.,Ltd." },
        { 0x000D9F, "RF Micro Devices" },
        { 0x000DA0, "NEDAP N.V." },
        { 0x000DA1, "MIRAE ITS Co.,LTD." },
        { 0x000DA2, "Infrant Technologies, Inc." },
        { 0x000DA3, "Emerging Technologies Limited" },
        { 0x000DA4, "DOSCH & AMAND SYSTEMS AG" },
        { 0x000DA5, "Fabric7 Systems, Inc" },
        { 0x000DA6, "Universal Switching Corporation" },
        { 0x000DA7, "Private" },
        { 0x000DA8, "Teletronics Technology Corporation" },
        { 0x000DA9, "T.E.A.M. S.L." },
        { 0x000DAA, "S.A.Tehnology co.,Ltd." },
        { 0x000DAB, "Parker Hannifin GmbH Electromechanical Division Europe" },
        { 0x000DAC, "Japan CBM Corporation" },
        { 0x000DAD, "Dataprobe, Inc." },
        { 0x000DAE, "SAMSUNG HEAVY INDUSTRIES CO., LTD." },
        { 0x000DAF, "Plexus Corp (UK) Ltd" },
        { 0x000DB0, "Olym-tech Co.,Ltd." },
        { 0x000DB1, "Japan Network Service Co., Ltd." },
        { 0x000DB2, "Ammasso, Inc." },
        { 0x000DB3, "SDO Communication Corperation" },
        { 0x000DB4, "Stormshield" },
        { 0x000DB5, "GLOBALSAT TECHNOLOGY CORPORATION" },
        { 0x000DB6, "Broadcom" },
        { 0x000DB7, "SANKO ELECTRIC CO,.LTD" },
        { 0x000DB8, "SCHILLER AG" },
        { 0x000DB9, "PC Engines GmbH" },
        { 0x000DBA, "Océ Document Technologies GmbH" },
        { 0x000DBB, "Nippon Dentsu Co.,Ltd." },
        { 0x000DBC, "Cisco Systems, Inc" },
        { 0x000DBD, "Cisco Systems, Inc" },
        { 0x000DBE, "Bel Fuse Europe Ltd.,UK" },
        { 0x000DBF, "TekTone Sound & Signal Mfg., Inc." },
        { 0x000DC0, "Spagat AS" },
        { 0x000DC1, "SafeWeb Inc" },
        { 0x000DC2, "Private" },
        { 0x000DC3, "First Communication, Inc." },
        { 0x000DC4, "Emcore Corporation" },
        { 0x000DC5, "EchoStar Global B.V." },
        { 0x000DC6, "DigiRose Technology Co., Ltd." },
        { 0x000DC7, "COSMIC ENGINEERING INC." },
        { 0x000DC8, "AirMagnet, Inc" },
        { 0x000DC9, "THALES Elektronik Systeme GmbH" },
        { 0x000DCA, "Tait Electronics" },
        { 0x000DCB, "Petcomkorea Co., Ltd." },
        { 0x000DCC, "NEOSMART Corp." },
        { 0x000DCD, "GROUPE TXCOM" },
        { 0x000DCE, "Dynavac Technology Pte Ltd" },
        { 0x000DCF, "Cidra Corp." },
        { 0x000DD0, "TetraTec Instruments GmbH" },
        { 0x000DD1, "Stryker Corporation" },
        { 0x000DD2, "Simrad Optronics ASA" },
        { 0x000DD3, "SAMWOO Telecommunication Co.,Ltd." },
        { 0x000DD4, "Symantec Corporation" },
        { 0x000DD5, "O'RITE TECHNOLOGY CO.,LTD" },
        { 0x000DD6, "ITI LTD" },
        { 0x000DD7, "Bright" },
        { 0x000DD8, "BBN" },
        { 0x000DD9, "Anton Paar GmbH" },
        { 0x000DDA, "ALLIED TELESIS K.K." },
        { 0x000DDB, "AIRWAVE TECHNOLOGIES INC." },
        { 0x000DDC, "VAC" },
        { 0x000DDD, "Profilo Telra Elektronik Sanayi ve Ticaret. A.Ş" },
        { 0x000DDE, "Joyteck Co., Ltd." },
        { 0x000DDF, "Japan Image & Network Inc." },
        { 0x000DE0, "ICPDAS Co.,LTD" },
        { 0x000DE1, "Control Products, Inc." },
        { 0x000DE2, "CMZ Sistemi Elettronici" },
        { 0x000DE3, "AT Sweden AB" },
        { 0x000DE4, "DIGINICS, Inc." },
        { 0x000DE5, "Samsung Thales" },
        { 0x000DE6, "YOUNGBO ENGINEERING CO.,LTD" },
        { 0x000DE7, "Snap-on OEM Group" },
        { 0x000DE8, "Nasaco Electronics Pte. Ltd" },
        { 0x000DE9, "Napatech Aps" },
        { 0x000DEA, "Kingtel Telecommunication Corp." },
        { 0x000DEB, "CompXs Limited" },
        { 0x000DEC, "Cisco Systems, Inc" },
        { 0x000DED, "Cisco Systems, Inc" },
        { 0x000DEE, "Andrew RF Power Amplifier Group" },
        { 0x000DEF, "Soc. Coop. Bilanciai" },
        { 0x000DF0, "QCOM TECHNOLOGY INC." },
        { 0x000DF1, "IONIX INC." },
        { 0x000DF2, "Private" },
        { 0x000DF3, "Asmax Solutions" },
        { 0x000DF4, "Watertek Co." },
        { 0x000DF5, "Teletronics International Inc." },
        { 0x000DF6, "Technology Thesaurus Corp." },
        { 0x000DF7, "Space Dynamics Lab" },
        { 0x000DF8, "ORGA Kartensysteme GmbH" },
        { 0x000DF9, "NDS Limited" },
        { 0x000DFA, "Micro Control Systems Ltd." },
        { 0x000DFB, "Komax AG" },
        { 0x000DFC, "ITFOR Inc." },
        { 0x000DFD, "Huges Hi-Tech Inc.," },
        { 0x000DFE, "Hauppauge Computer Works, Inc." },
        { 0x000DFF, "CHENMING MOLD INDUSTRY CORP." },
        { 0x000E00, "Atrie" },
        { 0x000E01, "ASIP Technologies Inc." },
        { 0x000E02, "Advantech AMT Inc." },
        { 0x000E03, "Emulex Corporation" },
        { 0x000E04, "CMA/Microdialysis AB" },
        { 0x000E05, "WIRELESS MATRIX CORP." },
        { 0x000E06, "Team Simoco Ltd" },
        { 0x000E07, "Sony Mobile Communications Inc" },
        { 0x000E08, "Cisco-Linksys, LLC" },
        { 0x000E09, "Shenzhen Coship Software Co.,LTD." },
        { 0x000E0A, "SAKUMA DESIGN OFFICE" },
        { 0x000E0B, "Netac Technology Co., Ltd." },
        { 0x000E0C, "Intel Corporation" },
        { 0x000E0D, "Hesch Schröder GmbH" },
        { 0x000E0E, "ESA elettronica S.P.A." },
        { 0x000E0F, "ERMME" },
        { 0x000E10, "C-guys, Inc." },
        { 0x000E11, "BDT Büro und Datentechnik GmbH & Co.KG" },
        { 0x000E12, "Adaptive Micro Systems Inc." },
        { 0x000E13, "Accu-Sort Systems inc." },
        { 0x000E14, "Visionary Solutions, Inc." },
        { 0x000E15, "Tadlys LTD" },
        { 0x000E16, "SouthWing S.L." },
        { 0x000E17, "Private" },
        { 0x000E18, "MyA Technology" },
        { 0x000E19, "LogicaCMG Pty Ltd" },
        { 0x000E1A, "JPS Communications" },
        { 0x000E1B, "IAV GmbH" },
        { 0x000E1C, "Hach Company" },
        { 0x000E1D, "ARION Technology Inc." },
        { 0x000E1E, "QLogic Corporation" },
        { 0x000E1F, "TCL Networks Equipment Co., Ltd." },
        { 0x000E20, "ACCESS Systems Americas, Inc." },
        { 0x000E21, "MTU Friedrichshafen GmbH" },
        { 0x000E22, "Private" },
        { 0x000E23, "Incipient, Inc." },
        { 0x000E24, "Huwell Technology Inc." },
        { 0x000E25, "Hannae Technology Co., Ltd" },
        { 0x000E26, "Gincom Technology Corp." },
        { 0x000E27, "Crere Networks, Inc." },
        { 0x000E28, "Dynamic Ratings P/L" },
        { 0x000E29, "Shester Communications Inc" },
        { 0x000E2A, "Private" },
        { 0x000E2B, "Safari Technologies" },
        { 0x000E2C, "Netcodec co." },
        { 0x000E2D, "Hyundai Digital Technology Co.,Ltd." },
        { 0x000E2E, "Edimax Technology Co. Ltd." },
        { 0x000E2F, "Roche Diagnostics GmbH" },
        { 0x000E30, "AERAS Networks, Inc." },
        { 0x000E31, "Olympus Soft Imaging Solutions GmbH" },
        { 0x000E32, "Kontron Medical" },
        { 0x000E33, "Shuko Electronics Co.,Ltd" },
        { 0x000E34, "NexGen City, LP" },
        { 0x000E35, "Intel Corporation" },
        { 0x000E36, "HEINESYS, Inc." },
        { 0x000E37, "Harms & Wende GmbH & Co.KG" },
        { 0x000E38, "Cisco Systems, Inc" },
        { 0x000E39, "Cisco Systems, Inc" },
        { 0x000E3A, "Cirrus Logic" },
        { 0x000E3B, "Hawking Technologies, Inc." },
        { 0x000E3C, "Transact Technologies Inc" },
        { 0x000E3D, "Televic N.V." },
        { 0x000E3E, "Sun Optronics Inc" },
        { 0x000E3F, "Soronti, Inc." },
        { 0x000E40, "Nortel Networks" },
        { 0x000E41, "NIHON MECHATRONICS CO.,LTD." },
        { 0x000E42, "Motic Incoporation Ltd." },
        { 0x000E43, "G-Tek Electronics Sdn. Bhd." },
        { 0x000E44, "Digital 5, Inc." },
        { 0x000E45, "Beijing Newtry Electronic Technology Ltd" },
        { 0x000E46, "Niigata Seimitsu Co.,Ltd." },
        { 0x000E47, "NCI System Co.,Ltd." },
        { 0x000E48, "Lipman TransAction Solutions" },
        { 0x000E49, "Forsway Scandinavia AB" },
        { 0x000E4A, "Changchun Huayu WEBPAD Co.,LTD" },
        { 0x000E4B, "atrium c and i" },
        { 0x000E4C, "Bermai Inc." },
        { 0x000E4D, "Numesa Inc." },
        { 0x000E4E, "Waveplus Technology Co., Ltd." },
        { 0x000E4F, "Trajet GmbH" },
        { 0x000E50, "Thomson Telecom Belgium" },
        { 0x000E51, "tecna elettronica srl" },
        { 0x000E52, "Optium Corporation" },
        { 0x000E53, "AV TECH CORPORATION" },
        { 0x000E54, "AlphaCell Wireless Ltd." },
        { 0x000E55, "AUVITRAN" },
        { 0x000E56, "4G Systems GmbH & Co. KG" },
        { 0x000E57, "Iworld Networking, Inc." },
        { 0x000E58, "Sonos, Inc." },
        { 0x000E59, "Sagemcom Broadband SAS" },
        { 0x000E5A, "TELEFIELD inc." },
        { 0x000E5B, "ParkerVision - Direct2Data" },
        { 0x000E5C, "ARRIS Group, Inc." },
        { 0x000E5D, "Triple Play Technologies A/S" },
        { 0x000E5E, "Raisecom Technology" },
        { 0x000E5F, "activ-net GmbH & Co. KG" },
        { 0x000E60, "360SUN Digital Broadband Corporation" },
        { 0x000E61, "MICROTROL LIMITED" },
        { 0x000E62, "Nortel Networks" },
        { 0x000E63, "Lemke Diagnostics GmbH" },
        { 0x000E64, "Elphel, Inc" },
        { 0x000E65, "TransCore" },
        { 0x000E66, "Hitachi Industry & Control Solutions, Ltd." },
        { 0x000E67, "Eltis Microelectronics Ltd." },
        { 0x000E68, "E-TOP Network Technology Inc." },
        { 0x000E69, "China Electric Power Research Institute" },
        { 0x000E6A, "3Com Ltd" },
        { 0x000E6B, "Janitza electronics GmbH" },
        { 0x000E6C, "Device Drivers Limited" },
        { 0x000E6D, "Murata Manufacturing Co., Ltd." },
        { 0x000E6E, "MAT S.A. (Mircrelec Advanced Technology)" },
        { 0x000E6F, "IRIS Corporation Berhad" },
        { 0x000E70, "in2 Networks" },
        { 0x000E71, "Gemstar Technology Development Ltd." },
        { 0x000E72, "CTS electronics" },
        { 0x000E73, "Tpack A/S" },
        { 0x000E74, "Solar Telecom. Tech" },
        { 0x000E75, "New York Air Brake Corp." },
        { 0x000E76, "GEMSOC INNOVISION INC." },
        { 0x000E77, "Decru, Inc." },
        { 0x000E78, "Amtelco" },
        { 0x000E79, "Ample Communications Inc." },
        { 0x000E7A, "GemWon Communications Co., Ltd." },
        { 0x000E7B, "Toshiba" },
        { 0x000E7C, "Televes S.A." },
        { 0x000E7D, "Electronics Line 3000 Ltd." },
        { 0x000E7E, "ionSign Oy" },
        { 0x000E7F, "Hewlett Packard" },
        { 0x000E80, "Thomson Technology Inc" },
        { 0x000E81, "Devicescape Software, Inc." },
        { 0x000E82, "Commtech Wireless" },
        { 0x000E83, "Cisco Systems, Inc" },
        { 0x000E84, "Cisco Systems, Inc" },
        { 0x000E85, "Catalyst Enterprises, Inc." },
        { 0x000E86, "Alcatel North America" },
        { 0x000E87, "adp Gauselmann GmbH" },
        { 0x000E88, "VIDEOTRON CORP." },
        { 0x000E89, "CLEMATIC" },
        { 0x000E8A, "Avara Technologies Pty. Ltd." },
        { 0x000E8B, "Astarte Technology Co, Ltd." },
        { 0x000E8C, "Siemens AG" },
        { 0x000E8D, "Systems in Progress Holding GmbH" },
        { 0x000E8E, "SparkLAN Communications, Inc." },
        { 0x000E8F, "Sercomm Corporation." },
        { 0x000E90, "PONICO CORP." },
        { 0x000E91, "Navico Auckland Ltd" },
        { 0x000E92, "Open Telecom" },
        { 0x000E93, "Milénio 3 Sistemas Electrónicos, Lda." },
        { 0x000E94, "Maas International BV" },
        { 0x000E95, "Fujiya Denki Seisakusho Co.,Ltd." },
        { 0x000E96, "Cubic Defense Applications, Inc." },
        { 0x000E97, "Ultracker Technology CO., Inc" },
        { 0x000E98, "HME Clear-Com LTD." },
        { 0x000E99, "Spectrum Digital, Inc" },
        { 0x000E9A, "BOE TECHNOLOGY GROUP CO.,LTD" },
        { 0x000E9B, "Ambit Microsystems Corporation" },
        { 0x000E9C, "Benchmark Electronics" },
        { 0x000E9D, "Tiscali UK Ltd" },
        { 0x000E9E, "Topfield Co., Ltd" },
        { 0x000E9F, "TEMIC SDS GmbH" },
        { 0x000EA0, "NetKlass Technology Inc." },
        { 0x000EA1, "Formosa Teletek Corporation" },
        { 0x000EA2, "McAfee, Inc" },
        { 0x000EA3, "CNCR-IT CO.,LTD,HangZhou P.R.CHINA" },
        { 0x000EA4, "Quantum Corp." },
        { 0x000EA5, "BLIP Systems" },
        { 0x000EA6, "ASUSTek COMPUTER INC." },
        { 0x000EA7, "Endace Technology" },
        { 0x000EA8, "United Technologists Europe Limited" },
        { 0x000EA9, "Shanghai Xun Shi Communications Equipment Ltd. Co." },
        { 0x000EAA, "Scalent Systems, Inc." },
        { 0x000EAB, "Cray Inc" },
        { 0x000EAC, "MINTRON ENTERPRISE CO., LTD." },
        { 0x000EAD, "Metanoia Technologies, Inc." },
        { 0x000EAE, "GAWELL TECHNOLOGIES CORP." },
        { 0x000EAF, "CASTEL" },
        { 0x000EB0, "Solutions Radio BV" },
        { 0x000EB1, "Newcotech,Ltd" },
        { 0x000EB2, "Micro-Research Finland Oy" },
        { 0x000EB3, "Hewlett Packard" },
        { 0x000EB4, "GUANGZHOU GAOKE COMMUNICATIONS TECHNOLOGY CO.LTD." },
        { 0x000EB5, "Ecastle Electronics Co., Ltd." },
        { 0x000EB6, "Riverbed Technology, Inc." },
        { 0x000EB7, "Knovative, Inc." },
        { 0x000EB8, "Iiga co.,Ltd" },
        { 0x000EB9, "HASHIMOTO Electronics Industry Co.,Ltd." },
        { 0x000EBA, "HANMI SEMICONDUCTOR CO., LTD." },
        { 0x000EBB, "Everbee Networks" },
        { 0x000EBC, "Paragon Fidelity GmbH" },
        { 0x000EBD, "Burdick, a Quinton Compny" },
        { 0x000EBE, "B&B Electronics Manufacturing Co." },
        { 0x000EBF, "Remsdaq Limited" },
        { 0x000EC0, "Nortel Networks" },
        { 0x000EC1, "MYNAH Technologies" },
        { 0x000EC2, "Lowrance Electronics, Inc." },
        { 0x000EC3, "Logic Controls, Inc." },
        { 0x000EC4, "Iskra Transmission d.d." },
        { 0x000EC5, "Digital Multitools Inc" },
        { 0x000EC6, "ASIX ELECTRONICS CORP." },
        { 0x000EC7, "Motorola Korea" },
        { 0x000EC8, "Zoran Corporation" },
        { 0x000EC9, "YOKO Technology Corp." },
        { 0x000ECA, "WTSS Inc" },
        { 0x000ECB, "VineSys Technology" },
        { 0x000ECC, "Tableau, LLC" },
        { 0x000ECD, "SKOV A/S" },
        { 0x000ECE, "S.I.T.T.I. S.p.A." },
        { 0x000ECF, "PROFIBUS Nutzerorganisation e.V." },
        { 0x000ED0, "Privaris, Inc." },
        { 0x000ED1, "Osaka Micro Computer." },
        { 0x000ED2, "Filtronic plc" },
        { 0x000ED3, "Epicenter, Inc." },
        { 0x000ED4, "CRESITT INDUSTRIE" },
        { 0x000ED5, "COPAN Systems Inc." },
        { 0x000ED6, "Cisco Systems, Inc" },
        { 0x000ED7, "Cisco Systems, Inc" },
        { 0x000ED8, "Positron Access Solutions Corp" },
        { 0x000ED9, "Aksys, Ltd." },
        { 0x000EDA, "C-TECH UNITED CORP." },
        { 0x000EDB, "XiNCOM Corp." },
        { 0x000EDC, "Tellion INC." },
        { 0x000EDD, "SHURE INCORPORATED" },
        { 0x000EDE, "REMEC, Inc." },
        { 0x000EDF, "PLX Technology" },
        { 0x000EE0, "Mcharge" },
        { 0x000EE1, "ExtremeSpeed Inc." },
        { 0x000EE2, "Custom Engineering" },
        { 0x000EE3, "Chiyu Technology Co.,Ltd" },
        { 0x000EE4, "BOE TECHNOLOGY GROUP CO.,LTD" },
        { 0x000EE5, "bitWallet, Inc." },
        { 0x000EE6, "Adimos Systems LTD" },
        { 0x000EE7, "AAC ELECTRONICS CORP." },
        { 0x000EE8, "Zioncom Electronics (Shenzhen) Ltd." },
        { 0x000EE9, "WayTech Development, Inc." },
        { 0x000EEA, "Shadong Luneng Jicheng Electronics,Co.,Ltd" },
        { 0x000EEB, "Sandmartin(zhong shan)Electronics Co.,Ltd" },
        { 0x000EEC, "Orban" },
        { 0x000EED, "Nokia Danmark A/S" },
        { 0x000EEE, "Muco Industrie BV" },
        { 0x000EEF, "Private" },
        { 0x000EF0, "Festo AG & Co. KG" },
        { 0x000EF1, "EZQUEST INC." },
        { 0x000EF2, "Infinico Corporation" },
        { 0x000EF3, "Smartlabs, Inc." },
        { 0x000EF4, "Kasda Networks Inc" },
        { 0x000EF5, "iPAC Technology Co., Ltd." },
        { 0x000EF6, "E-TEN Information Systems Co., Ltd." },
        { 0x000EF7, "Vulcan Portals Inc" },
        { 0x000EF8, "SBC ASI" },
        { 0x000EF9, "REA Elektronik GmbH" },
        { 0x000EFA, "Optoway Technology Incorporation" },
        { 0x000EFB, "Macey Enterprises" },
        { 0x000EFC, "JTAG Technologies B.V." },
        { 0x000EFD, "FUJINON CORPORATION" },
        { 0x000EFE, "EndRun Technologies LLC" },
        { 0x000EFF, "Megasolution,Inc." },
        { 0x000F00, "Legra Systems, Inc." },
        { 0x000F01, "DIGITALKS INC" },
        { 0x000F02, "Digicube Technology Co., Ltd" },
        { 0x000F03, "COM&C CO., LTD" },
        { 0x000F04, "cim-usa inc" },
        { 0x000F05, "3B SYSTEM INC." },
        { 0x000F06, "Nortel Networks" },
        { 0x000F07, "Mangrove Systems, Inc." },
        { 0x000F08, "Indagon Oy" },
        { 0x000F09, "Private" },
        { 0x000F0A, "Clear Edge Networks" },
        { 0x000F0B, "Kentima Technologies AB" },
        { 0x000F0C, "SYNCHRONIC ENGINEERING" },
        { 0x000F0D, "Hunt Electronic Co., Ltd." },
        { 0x000F0E, "WaveSplitter Technologies, Inc." },
        { 0x000F0F, "Real ID Technology Co., Ltd." },
        { 0x000F10, "RDM Corporation" },
        { 0x000F11, "Prodrive B.V." },
        { 0x000F12, "Panasonic Europe Ltd." },
        { 0x000F13, "Nisca corporation" },
        { 0x000F14, "Mindray Co., Ltd." },
        { 0x000F15, "Icotera A/S" },
        { 0x000F16, "JAY HOW TECHNOLOGY CO.," },
        { 0x000F17, "Insta Elektro GmbH" },
        { 0x000F18, "Industrial Control Systems" },
        { 0x000F19, "Boston Scientific" },
        { 0x000F1A, "Gaming Support B.V." },
        { 0x000F1B, "Ego Systems Inc." },
        { 0x000F1C, "DigitAll World Co., Ltd" },
        { 0x000F1D, "Cosmo Techs Co., Ltd." },
        { 0x000F1E, "Chengdu KT Electric Co.of High & New Technology" },
        { 0x000F1F, "Dell Inc." },
        { 0x000F20, "Hewlett Packard" },
        { 0x000F21, "Scientific Atlanta, Inc" },
        { 0x000F22, "Helius, Inc." },
        { 0x000F23, "Cisco Systems, Inc" },
        { 0x000F24, "Cisco Systems, Inc" },
        { 0x000F25, "AimValley B.V." },
        { 0x000F26, "WorldAccxx LLC" },
        { 0x000F27, "TEAL Electronics, Inc." },
        { 0x000F28, "Itronix Corporation" },
        { 0x000F29, "Augmentix Corporation" },
        { 0x000F2A, "Cableware Electronics" },
        { 0x000F2B, "GREENBELL SYSTEMS" },
        { 0x000F2C, "Uplogix, Inc." },
        { 0x000F2D, "CHUNG-HSIN ELECTRIC & MACHINERY MFG.CORP." },
        { 0x000F2E, "Megapower International Corp." },
        { 0x000F2F, "W-LINX TECHNOLOGY CO., LTD." },
        { 0x000F30, "Raza Microelectronics Inc" },
        { 0x000F31, "Allied Vision Technologies Canada Inc" },
        { 0x000F32, "Lootom Telcovideo Network Wuxi Co Ltd" },
        { 0x000F33, "DUALi Inc." },
        { 0x000F34, "Cisco Systems, Inc" },
        { 0x000F35, "Cisco Systems, Inc" },
        { 0x000F36, "Accurate Techhnologies, Inc." },
        { 0x000F37, "Xambala Incorporated" },
        { 0x000F38, "Netstar" },
        { 0x000F39, "IRIS SENSORS" },
        { 0x000F3A, "HISHARP" },
        { 0x000F3B, "Fuji System Machines Co., Ltd." },
        { 0x000F3C, "Endeleo Limited" },
        { 0x000F3D, "D-Link Corporation" },
        { 0x000F3E, "CardioNet, Inc" },
        { 0x000F3F, "Big Bear Networks" },
        { 0x000F40, "Optical Internetworking Forum" },
        { 0x000F41, "Zipher Ltd" },
        { 0x000F42, "Xalyo Systems" },
        { 0x000F43, "Wasabi Systems Inc." },
        { 0x000F44, "Tivella Inc." },
        { 0x000F45, "Stretch, Inc." },
        { 0x000F46, "SINAR AG" },
        { 0x000F47, "ROBOX SPA" },
        { 0x000F48, "Polypix Inc." },
        { 0x000F49, "Northover Solutions Limited" },
        { 0x000F4A, "Kyushu-kyohan co.,ltd" },
        { 0x000F4B, "Oracle Corporation" },
        { 0x000F4C, "Elextech INC" },
        { 0x000F4D, "TalkSwitch" },
        { 0x000F4E, "Cellink" },
        { 0x000F4F, "PCS Systemtechnik GmbH" },
        { 0x000F50, "StreamScale Limited" },
        { 0x000F51, "Azul Systems, Inc." },
        { 0x000F52, "YORK Refrigeration, Marine & Controls" },
        { 0x000F53, "Solarflare Communications Inc." },
        { 0x000F54, "Entrelogic Corporation" },
        { 0x000F55, "Datawire Communication Networks Inc." },
        { 0x000F56, "Continuum Photonics Inc" },
        { 0x000F57, "CABLELOGIC Co., Ltd." },
        { 0x000F58, "Adder Technology Limited" },
        { 0x000F59, "Phonak AG" },
        { 0x000F5A, "Peribit Networks" },
        { 0x000F5B, "Delta Information Systems, Inc." },
        { 0x000F5C, "Day One Digital Media Limited" },
        { 0x000F5D, "Genexis BV" },
        { 0x000F5E, "Veo" },
        { 0x000F5F, "Nicety Technologies Inc. (NTS)" },
        { 0x000F60, "Lifetron Co.,Ltd" },
        { 0x000F61, "Hewlett Packard" },
        { 0x000F62, "Alcatel Bell Space N.V." },
        { 0x000F63, "Obzerv Technologies" },
        { 0x000F64, "D&R Electronica Weesp BV" },
        { 0x000F65, "icube Corp." },
        { 0x000F66, "Cisco-Linksys, LLC" },
        { 0x000F67, "West Instruments" },
        { 0x000F68, "Vavic Network Technology, Inc." },
        { 0x000F69, "SEW Eurodrive GmbH & Co. KG" },
        { 0x000F6A, "Nortel Networks" },
        { 0x000F6B, "GateWare Communications GmbH" },
        { 0x000F6C, "ADDI-DATA GmbH" },
        { 0x000F6D, "Midas Engineering" },
        { 0x000F6E, "BBox" },
        { 0x000F6F, "FTA Communication Technologies" },
        { 0x000F70, "Wintec Industries, inc." },
        { 0x000F71, "Sanmei Electronics Co.,Ltd" },
        { 0x000F72, "Sandburst" },
        { 0x000F73, "RS Automation Co., Ltd" },
        { 0x000F74, "Qamcom Technology AB" },
        { 0x000F75, "First Silicon Solutions" },
        { 0x000F76, "Digital Keystone, Inc." },
        { 0x000F77, "DENTUM CO.,LTD" },
        { 0x000F78, "Datacap Systems Inc" },
        { 0x000F79, "Bluetooth Interest Group Inc." },
        { 0x000F7A, "BeiJing NuQX Technology CO.,LTD" },
        { 0x000F7B, "Arce Sistemas, S.A." },
        { 0x000F7C, "ACTi Corporation" },
        { 0x000F7D, "Xirrus" },
        { 0x000F7E, "Ablerex Electronics Co., LTD" },
        { 0x000F7F, "UBSTORAGE Co.,Ltd." },
        { 0x000F80, "Trinity Security Systems,Inc." },
        { 0x000F81, "PAL Pacific Inc." },
        { 0x000F82, "Mortara Instrument, Inc." },
        { 0x000F83, "Brainium Technologies Inc." },
        { 0x000F84, "Astute Networks, Inc." },
        { 0x000F85, "ADDO-Japan Corporation" },
        { 0x000F86, "BlackBerry RTS" },
        { 0x000F87, "Maxcess International" },
        { 0x000F88, "AMETEK, Inc." },
        { 0x000F89, "Winnertec System Co., Ltd." },
        { 0x000F8A, "WideView" },
        { 0x000F8B, "Orion MultiSystems Inc" },
        { 0x000F8C, "Gigawavetech Pte Ltd" },
        { 0x000F8D, "FAST TV-Server AG" },
        { 0x000F8E, "DONGYANG TELECOM CO.,LTD." },
        { 0x000F8F, "Cisco Systems, Inc" },
        { 0x000F90, "Cisco Systems, Inc" },
        { 0x000F91, "Aerotelecom Co.,Ltd." },
        { 0x000F92, "Microhard Systems Inc." },
        { 0x000F93, "Landis+Gyr Ltd." },
        { 0x000F94, "Genexis BV" },
        { 0x000F95, "ELECOM Co.,LTD Laneed Division" },
        { 0x000F96, "Telco Systems, Inc." },
        { 0x000F97, "Avanex Corporation" },
        { 0x000F98, "Avamax Co. Ltd." },
        { 0x000F99, "APAC opto Electronics Inc." },
        { 0x000F9A, "Synchrony, Inc." },
        { 0x000F9B, "Ross Video Limited" },
        { 0x000F9C, "Panduit Corp" },
        { 0x000F9D, "DisplayLink (UK) Ltd" },
        { 0x000F9E, "Murrelektronik GmbH" },
        { 0x000F9F, "ARRIS Group, Inc." },
        { 0x000FA0, "CANON KOREA BUSINESS SOLUTIONS INC." },
        { 0x000FA1, "Gigabit Systems Inc." },
        { 0x000FA2, "2xWireless" },
        { 0x000FA3, "Alpha Networks Inc." },
        { 0x000FA4, "Sprecher Automation GmbH" },
        { 0x000FA5, "BWA Technology GmbH" },
        { 0x000FA6, "S2 Security Corporation" },
        { 0x000FA7, "Raptor Networks Technology" },
        { 0x000FA8, "Photometrics, Inc." },
        { 0x000FA9, "PC Fabrik" },
        { 0x000FAA, "Nexus Technologies" },
        { 0x000FAB, "Kyushu Electronics Systems Inc." },
        { 0x000FAC, "IEEE 802.11" },
        { 0x000FAD, "FMN communications GmbH" },
        { 0x000FAE, "E2O Communications" },
        { 0x000FAF, "Dialog Inc." },
        { 0x000FB0, "Compal Electronics INC." },
        { 0x000FB1, "Cognio Inc." },
        { 0x000FB2, "Broadband Pacenet (India) Pvt. Ltd." },
        { 0x000FB3, "Actiontec Electronics, Inc" },
        { 0x000FB4, "Timespace Technology" },
        { 0x000FB5, "NETGEAR" },
        { 0x000FB6, "Europlex Technologies" },
        { 0x000FB7, "Cavium" },
        { 0x000FB8, "CallURL Inc." },
        { 0x000FB9, "Adaptive Instruments" },
        { 0x000FBA, "Tevebox AB" },
        { 0x000FBB, "Nokia Siemens Networks GmbH & Co. KG." },
        { 0x000FBC, "Onkey Technologies, Inc." },
        { 0x000FBD, "MRV Communications (Networks) LTD" },
        { 0x000FBE, "e-w/you Inc." },
        { 0x000FBF, "DGT Sp. z o.o." },
        { 0x000FC0, "DELCOMp" },
        { 0x000FC1, "WAVE Corporation" },
        { 0x000FC2, "Uniwell Corporation" },
        { 0x000FC3, "PalmPalm Technology, Inc." },
        { 0x000FC4, "NST co.,LTD." },
        { 0x000FC5, "KeyMed Ltd" },
        { 0x000FC6, "Eurocom Industries A/S" },
        { 0x000FC7, "Dionica R&D Ltd." },
        { 0x000FC8, "Chantry Networks" },
        { 0x000FC9, "Allnet GmbH" },
        { 0x000FCA, "A-JIN TECHLINE CO, LTD" },
        { 0x000FCB, "3Com Ltd" },
        { 0x000FCC, "ARRIS Group, Inc." },
        { 0x000FCD, "Nortel Networks" },
        { 0x000FCE, "Kikusui Electronics Corp." },
        { 0x000FCF, "DataWind Research" },
        { 0x000FD0, "ASTRI" },
        { 0x000FD1, "Applied Wireless Identifications Group, Inc." },
        { 0x000FD2, "EWA Technologies, Inc." },
        { 0x000FD3, "Digium" },
        { 0x000FD4, "Soundcraft" },
        { 0x000FD5, "Schwechat - RISE" },
        { 0x000FD6, "Sarotech Co., Ltd" },
        { 0x000FD7, "Harman Music Group" },
        { 0x000FD8, "Force, Inc." },
        { 0x000FD9, "FlexDSL Telecommunications AG" },
        { 0x000FDA, "YAZAKI CORPORATION" },
        { 0x000FDB, "Westell Technologies Inc." },
        { 0x000FDC, "Ueda Japan Radio Co., Ltd." },
        { 0x000FDD, "SORDIN AB" },
        { 0x000FDE, "Sony Mobile Communications Inc" },
        { 0x000FDF, "SOLOMON Technology Corp." },
        { 0x000FE0, "NComputing Co.,Ltd." },
        { 0x000FE1, "ID DIGITAL CORPORATION" },
        { 0x000FE2, "Hangzhou H3C Technologies Co., Limited" },
        { 0x000FE3, "Damm Cellular Systems A/S" },
        { 0x000FE4, "Pantech Co.,Ltd" },
        { 0x000FE5, "MERCURY SECURITY CORPORATION" },
        { 0x000FE6, "MBTech Systems, Inc." },
        { 0x000FE7, "Lutron Electronics Co., Inc." },
        { 0x000FE8, "Lobos, Inc." },
        { 0x000FE9, "GW TECHNOLOGIES CO.,LTD." },
        { 0x000FEA, "Giga-Byte Technology Co.,LTD." },
        { 0x000FEB, "Cylon Controls" },
        { 0x000FEC, "ARKUS Inc." },
        { 0x000FED, "Anam Electronics Co., Ltd" },
        { 0x000FEE, "XTec, Incorporated" },
        { 0x000FEF, "Thales e-Transactions GmbH" },
        { 0x000FF0, "Sunray Co. Ltd." },
        { 0x000FF1, "nex-G Systems Pte.Ltd" },
        { 0x000FF2, "Loud Technologies Inc." },
        { 0x000FF3, "Jung Myoung Communications&Technology" },
        { 0x000FF4, "Guntermann & Drunck GmbH" },
        { 0x000FF5, "GN&S company" },
        { 0x000FF6, "DARFON LIGHTING CORP" },
        { 0x000FF7, "Cisco Systems, Inc" },
        { 0x000FF8, "Cisco Systems, Inc" },
        { 0x000FF9, "Valcretec, Inc." },
        { 0x000FFA, "Optinel Systems, Inc." },
        { 0x000FFB, "Nippon Denso Industry Co., Ltd." },
        { 0x000FFC, "Merit Li-Lin Ent." },
        { 0x000FFD, "Glorytek Network Inc." },
        { 0x000FFE, "G-PRO COMPUTER" },
        { 0x000FFF, "Control4" },
        { 0x001000, "CABLE TELEVISION LABORATORIES, INC." },
        { 0x001001, "Citel" },
        { 0x001002, "ACTIA" },
        { 0x001003, "IMATRON, INC." },
        { 0x001004, "THE BRANTLEY COILE COMPANY,INC" },
        { 0x001005, "UEC COMMERCIAL" },
        { 0x001006, "Thales Contact Solutions Ltd." },
        { 0x001007, "Cisco Systems, Inc" },
        { 0x001008, "VIENNA SYSTEMS CORPORATION" },
        { 0x001009, "HORANET" },
        { 0x00100A, "WILLIAMS COMMUNICATIONS GROUP" },
        { 0x00100B, "Cisco Systems, Inc" },
        { 0x00100C, "ITO CO., LTD." },
        { 0x00100D, "Cisco Systems, Inc" },
        { 0x00100E, "MICRO LINEAR COPORATION" },
        { 0x00100F, "INDUSTRIAL CPU SYSTEMS" },
        { 0x001010, "INITIO CORPORATION" },
        { 0x001011, "Cisco Systems, Inc" },
        { 0x001012, "PROCESSOR SYSTEMS (I) PVT LTD" },
        { 0x001013, "Kontron America, Inc." },
        { 0x001014, "Cisco Systems, Inc" },
        { 0x001015, "OOmon Inc." },
        { 0x001016, "T.SQWARE" },
        { 0x001017, "Bosch Access Systems GmbH" },
        { 0x001018, "Broadcom" },
        { 0x001019, "SIRONA DENTAL SYSTEMS GmbH & Co. KG" },
        { 0x00101A, "PictureTel Corp." },
        { 0x00101B, "CORNET TECHNOLOGY, INC." },
        { 0x00101C, "OHM TECHNOLOGIES INTL, LLC" },
        { 0x00101D, "WINBOND ELECTRONICS CORP." },
        { 0x00101E, "MATSUSHITA ELECTRONIC INSTRUMENTS CORP." },
        { 0x00101F, "Cisco Systems, Inc" },
        { 0x001020, "Hand Held Products Inc" },
        { 0x001021, "ENCANTO NETWORKS, INC." },
        { 0x001022, "SatCom Media Corporation" },
        { 0x001023, "Network Equipment Technologies" },
        { 0x001024, "NAGOYA ELECTRIC WORKS CO., LTD" },
        { 0x001025, "Grayhill, Inc" },
        { 0x001026, "ACCELERATED NETWORKS, INC." },
        { 0x001027, "L-3 COMMUNICATIONS EAST" },
        { 0x001028, "COMPUTER TECHNICA, INC." },
        { 0x001029, "Cisco Systems, Inc" },
        { 0x00102A, "ZF MICROSYSTEMS, INC." },
        { 0x00102B, "UMAX DATA SYSTEMS, INC." },
        { 0x00102C, "Lasat Networks A/S" },
        { 0x00102D, "HITACHI SOFTWARE ENGINEERING" },
        { 0x00102E, "NETWORK SYSTEMS & TECHNOLOGIES PVT. LTD." },
        { 0x00102F, "Cisco Systems, Inc" },
        { 0x001030, "EION Inc." },
        { 0x001031, "OBJECTIVE COMMUNICATIONS, INC." },
        { 0x001032, "ALTA TECHNOLOGY" },
        { 0x001033, "ACCESSLAN COMMUNICATIONS, INC." },
        { 0x001034, "GNP Computers" },
        { 0x001035, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x001036, "INTER-TEL INTEGRATED SYSTEMS" },
        { 0x001037, "CYQ've Technology Co., Ltd." },
        { 0x001038, "Micro Research Ltd." },
        { 0x001039, "Vectron Systems AG" },
        { 0x00103A, "DIAMOND NETWORK TECH" },
        { 0x00103B, "HIPPI NETWORKING FORUM" },
        { 0x00103C, "IC ENSEMBLE, INC." },
        { 0x00103D, "PHASECOM, LTD." },
        { 0x00103E, "NETSCHOOLS CORPORATION" },
        { 0x00103F, "TOLLGRADE COMMUNICATIONS, INC." },
        { 0x001040, "INTERMEC CORPORATION" },
        { 0x001041, "BRISTOL BABCOCK, INC." },
        { 0x001042, "Alacritech, Inc." },
        { 0x001043, "A2 CORPORATION" },
        { 0x001044, "InnoLabs Corporation" },
        { 0x001045, "Nortel Networks" },
        { 0x001046, "ALCORN MCBRIDE INC." },
        { 0x001047, "ECHO ELETRIC CO. LTD." },
        { 0x001048, "HTRC AUTOMATION, INC." },
        { 0x001049, "ShoreTel, Inc" },
        { 0x00104A, "The Parvus Corporation" },
        { 0x00104B, "3COM" },
        { 0x00104C, "Teledyne LeCroy, Inc" },
        { 0x00104D, "SURTEC INDUSTRIES, INC." },
        { 0x00104E, "CEOLOGIC" },
        { 0x00104F, "Oracle Corporation" },
        { 0x001050, "RION CO., LTD." },
        { 0x001051, "CMICRO CORPORATION" },
        { 0x001052, "METTLER-TOLEDO (ALBSTADT) GMBH" },
        { 0x001053, "COMPUTER TECHNOLOGY CORP." },
        { 0x001054, "Cisco Systems, Inc" },
        { 0x001055, "FUJITSU MICROELECTRONICS, INC." },
        { 0x001056, "SODICK CO., LTD." },
        { 0x001057, "Rebel.com, Inc." },
        { 0x001058, "ArrowPoint Communications" },
        { 0x001059, "DIABLO RESEARCH CO. LLC" },
        { 0x00105A, "3COM" },
        { 0x00105B, "NET INSIGHT AB" },
        { 0x00105C, "QUANTUM DESIGNS (H.K.) LTD." },
        { 0x00105D, "Draeger Medical" },
        { 0x00105E, "Spirent plc, Service Assurance Broadband" },
        { 0x00105F, "ZODIAC DATA SYSTEMS" },
        { 0x001060, "BILLIONTON SYSTEMS, INC." },
        { 0x001061, "HOSTLINK CORP." },
        { 0x001062, "NX SERVER, ILNC." },
        { 0x001063, "STARGUIDE DIGITAL NETWORKS" },
        { 0x001064, "DNPG, LLC" },
        { 0x001065, "RADYNE CORPORATION" },
        { 0x001066, "ADVANCED CONTROL SYSTEMS, INC." },
        { 0x001067, "Ericsson" },
        { 0x001068, "COMOS TELECOM" },
        { 0x001069, "HELIOSS COMMUNICATIONS, INC." },
        { 0x00106A, "DIGITAL MICROWAVE CORPORATION" },
        { 0x00106B, "SONUS NETWORKS, INC." },
        { 0x00106C, "EDNT GmbH" },
        { 0x00106D, "Axxcelera Broadband Wireless" },
        { 0x00106E, "TADIRAN COM. LTD." },
        { 0x00106F, "TRENTON TECHNOLOGY INC." },
        { 0x001070, "CARADON TREND LTD." },
        { 0x001071, "ADVANET INC." },
        { 0x001072, "GVN TECHNOLOGIES, INC." },
        { 0x001073, "TECHNOBOX, INC." },
        { 0x001074, "ATEN INTERNATIONAL CO., LTD." },
        { 0x001075, "Segate Technology LLC" },
        { 0x001076, "EUREM GmbH" },
        { 0x001077, "SAF DRIVE SYSTEMS, LTD." },
        { 0x001078, "NUERA COMMUNICATIONS, INC." },
        { 0x001079, "Cisco Systems, Inc" },
        { 0x00107A, "AmbiCom, Inc." },
        { 0x00107B, "Cisco Systems, Inc" },
        { 0x00107C, "P-COM, INC." },
        { 0x00107D, "AURORA COMMUNICATIONS, LTD." },
        { 0x00107E, "BACHMANN ELECTRONIC GmbH" },
        { 0x00107F, "CRESTRON ELECTRONICS, INC." },
        { 0x001080, "METAWAVE COMMUNICATIONS" },
        { 0x001081, "DPS, INC." },
        { 0x001082, "JNA TELECOMMUNICATIONS LIMITED" },
        { 0x001083, "Hewlett Packard" },
        { 0x001084, "K-BOT COMMUNICATIONS" },
        { 0x001085, "POLARIS COMMUNICATIONS, INC." },
        { 0x001086, "ATTO Technology, Inc." },
        { 0x001087, "XSTREAMIS PLC" },
        { 0x001088, "AMERICAN NETWORKS INC." },
        { 0x001089, "WebSonic" },
        { 0x00108A, "TeraLogic, Inc." },
        { 0x00108B, "LASERANIMATION SOLLINGER GMBH" },
        { 0x00108C, "Fujitsu Services Ltd" },
        { 0x00108D, "Johnson Controls, Inc." },
        { 0x00108E, "HUGH SYMONS CONCEPT Technologies Ltd." },
        { 0x00108F, "RAPTOR SYSTEMS" },
        { 0x001090, "CIMETRICS, INC." },
        { 0x001091, "NO WIRES NEEDED BV" },
        { 0x001092, "NETCORE INC." },
        { 0x001093, "CMS COMPUTERS, LTD." },
        { 0x001094, "Performance Analysis Broadband, Spirent plc" },
        { 0x001095, "Thomson Inc." },
        { 0x001096, "TRACEWELL SYSTEMS, INC." },
        { 0x001097, "WinNet Metropolitan Communications Systems, Inc." },
        { 0x001098, "STARNET TECHNOLOGIES, INC." },
        { 0x001099, "InnoMedia, Inc." },
        { 0x00109A, "NETLINE" },
        { 0x00109B, "Emulex Corporation" },
        { 0x00109C, "M-SYSTEM CO., LTD." },
        { 0x00109D, "CLARINET SYSTEMS, INC." },
        { 0x00109E, "AWARE, INC." },
        { 0x00109F, "PAVO, INC." },
        { 0x0010A0, "INNOVEX TECHNOLOGIES, INC." },
        { 0x0010A1, "KENDIN SEMICONDUCTOR, INC." },
        { 0x0010A2, "TNS" },
        { 0x0010A3, "OMNITRONIX, INC." },
        { 0x0010A4, "XIRCOM" },
        { 0x0010A5, "OXFORD INSTRUMENTS" },
        { 0x0010A6, "Cisco Systems, Inc" },
        { 0x0010A7, "UNEX TECHNOLOGY CORPORATION" },
        { 0x0010A8, "RELIANCE COMPUTER CORP." },
        { 0x0010A9, "ADHOC TECHNOLOGIES" },
        { 0x0010AA, "MEDIA4, INC." },
        { 0x0010AB, "KOITO ELECTRIC INDUSTRIES, LTD." },
        { 0x0010AC, "IMCI TECHNOLOGIES" },
        { 0x0010AD, "SOFTRONICS USB, INC." },
        { 0x0010AE, "SHINKO ELECTRIC INDUSTRIES CO." },
        { 0x0010AF, "TAC SYSTEMS, INC." },
        { 0x0010B0, "MERIDIAN TECHNOLOGY CORP." },
        { 0x0010B1, "FOR-A CO., LTD." },
        { 0x0010B2, "COACTIVE AESTHETICS" },
        { 0x0010B3, "NOKIA MULTIMEDIA TERMINALS" },
        { 0x0010B4, "ATMOSPHERE NETWORKS" },
        { 0x0010B5, "Accton Technology Corp" },
        { 0x0010B6, "ENTRATA COMMUNICATIONS CORP." },
        { 0x0010B7, "COYOTE TECHNOLOGIES, LLC" },
        { 0x0010B8, "ISHIGAKI COMPUTER SYSTEM CO." },
        { 0x0010B9, "MAXTOR CORP." },
        { 0x0010BA, "MARTINHO-DAVIS SYSTEMS, INC." },
        { 0x0010BB, "DATA & INFORMATION TECHNOLOGY" },
        { 0x0010BC, "Aastra Telecom" },
        { 0x0010BD, "THE TELECOMMUNICATION TECHNOLOGY COMMITTEE (TTC)" },
        { 0x0010BE, "MARCH NETWORKS CORPORATION" },
        { 0x0010BF, "InterAir Wireless" },
        { 0x0010C0, "ARMA, Inc." },
        { 0x0010C1, "OI ELECTRIC CO.,LTD" },
        { 0x0010C2, "WILLNET, INC." },
        { 0x0010C3, "CSI-CONTROL SYSTEMS" },
        { 0x0010C4, "MEDIA GLOBAL LINKS CO., LTD." },
        { 0x0010C5, "PROTOCOL TECHNOLOGIES, INC." },
        { 0x0010C6, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x0010C7, "DATA TRANSMISSION NETWORK" },
        { 0x0010C8, "COMMUNICATIONS ELECTRONICS SECURITY GROUP" },
        { 0x0010C9, "MITSUBISHI ELECTRONICS LOGISTIC SUPPORT CO." },
        { 0x0010CA, "Telco Systems, Inc." },
        { 0x0010CB, "FACIT K.K." },
        { 0x0010CC, "CLP COMPUTER LOGISTIK PLANUNG GmbH" },
        { 0x0010CD, "INTERFACE CONCEPT" },
        { 0x0010CE, "VOLAMP, LTD." },
        { 0x0010CF, "FIBERLANE COMMUNICATIONS" },
        { 0x0010D0, "WITCOM, LTD." },
        { 0x0010D1, "Top Layer Networks, Inc." },
        { 0x0010D2, "NITTO TSUSHINKI CO., LTD" },
        { 0x0010D3, "GRIPS ELECTRONIC GMBH" },
        { 0x0010D4, "STORAGE COMPUTER CORPORATION" },
        { 0x0010D5, "IMASDE CANARIAS, S.A." },
        { 0x0010D6, "Exelis" },
        { 0x0010D7, "ARGOSY RESEARCH INC." },
        { 0x0010D8, "CALISTA" },
        { 0x0010D9, "IBM JAPAN, FUJISAWA MT+D" },
        { 0x0010DA, "Kollmorgen Corp" },
        { 0x0010DB, "Juniper Networks" },
        { 0x0010DC, "MICRO-STAR INTERNATIONAL CO., LTD." },
        { 0x0010DD, "ENABLE SEMICONDUCTOR, INC." },
        { 0x0010DE, "INTERNATIONAL DATACASTING CORPORATION" },
        { 0x0010DF, "RISE COMPUTER INC." },
        { 0x0010E0, "Oracle Corporation" },
        { 0x0010E1, "S.I. TECH, INC." },
        { 0x0010E2, "ArrayComm, Inc." },
        { 0x0010E3, "Hewlett Packard" },
        { 0x0010E4, "NSI CORPORATION" },
        { 0x0010E5, "SOLECTRON TEXAS" },
        { 0x0010E6, "APPLIED INTELLIGENT SYSTEMS, INC." },
        { 0x0010E7, "Breezecom, Ltd." },
        { 0x0010E8, "TELOCITY, INCORPORATED" },
        { 0x0010E9, "RAIDTEC LTD." },
        { 0x0010EA, "ADEPT TECHNOLOGY" },
        { 0x0010EB, "SELSIUS SYSTEMS, INC." },
        { 0x0010EC, "RPCG, LLC" },
        { 0x0010ED, "SUNDANCE TECHNOLOGY, INC." },
        { 0x0010EE, "CTI PRODUCTS, INC." },
        { 0x0010EF, "DBTEL INCORPORATED" },
        { 0x0010F0, "RITTAL-WERK RUDOLF LOH GmbH & Co." },
        { 0x0010F1, "I-O CORPORATION" },
        { 0x0010F2, "ANTEC" },
        { 0x0010F3, "Nexcom International Co., Ltd." },
        { 0x0010F4, "Vertical Communications" },
        { 0x0010F5, "AMHERST SYSTEMS, INC." },
        { 0x0010F6, "Cisco Systems, Inc" },
        { 0x0010F7, "IRIICHI TECHNOLOGIES Inc." },
        { 0x0010F8, "TEXIO TECHNOLOGY CORPORATION" },
        { 0x0010F9, "UNIQUE SYSTEMS, INC." },
        { 0x0010FA, "Apple, Inc." },
        { 0x0010FB, "ZIDA TECHNOLOGIES LIMITED" },
        { 0x0010FC, "BROADBAND NETWORKS, INC." },
        { 0x0010FD, "COCOM A/S" },
        { 0x0010FE, "DIGITAL EQUIPMENT CORPORATION" },
        { 0x0010FF, "Cisco Systems, Inc" },
        { 0x001100, "Schneider Electric" },
        { 0x001101, "CET Technologies Pte Ltd" },
        { 0x001102, "Aurora Multimedia Corp." },
        { 0x001103, "kawamura electric inc." },
        { 0x001104, "TELEXY" },
        { 0x001105, "Sunplus Technology Co., Ltd." },
        { 0x001106, "Siemens NV (Belgium)" },
        { 0x001107, "RGB Networks Inc." },
        { 0x001108, "Orbital Data Corporation" },
        { 0x001109, "Micro-Star International" },
        { 0x00110A, "Hewlett Packard" },
        { 0x00110B, "Franklin Technology Systems" },
        { 0x00110C, "Atmark Techno, Inc." },
        { 0x00110D, "SANBlaze Technology, Inc." },
        { 0x00110E, "Tsurusaki Sealand Transportation Co. Ltd." },
        { 0x00110F, "netplat,Inc." },
        { 0x001110, "Maxanna Technology Co., Ltd." },
        { 0x001111, "Intel Corporation" },
        { 0x001112, "Honeywell CMSS" },
        { 0x001113, "Fraunhofer FOKUS" },
        { 0x001114, "EverFocus Electronics Corp." },
        { 0x001115, "EPIN Technologies, Inc." },
        { 0x001116, "COTEAU VERT CO., LTD." },
        { 0x001117, "CESNET" },
        { 0x001118, "BLX IC Design Corp., Ltd." },
        { 0x001119, "Solteras, Inc." },
        { 0x00111A, "ARRIS Group, Inc." },
        { 0x00111B, "Targa Systems Div L-3 Communications" },
        { 0x00111C, "Pleora Technologies Inc." },
        { 0x00111D, "Hectrix Limited" },
        { 0x00111E, "ETHERNET Powerlink Standarization Group (EPSG)" },
        { 0x00111F, "Doremi Labs, Inc." },
        { 0x001120, "Cisco Systems, Inc" },
        { 0x001121, "Cisco Systems, Inc" },
        { 0x001122, "CIMSYS Inc" },
        { 0x001123, "Appointech, Inc." },
        { 0x001124, "Apple, Inc." },
        { 0x001125, "IBM Corp" },
        { 0x001126, "Venstar Inc." },
        { 0x001127, "TASI, Inc" },
        { 0x001128, "Streamit" },
        { 0x001129, "Paradise Datacom Ltd." },
        { 0x00112A, "Niko NV" },
        { 0x00112B, "NetModule AG" },
        { 0x00112C, "IZT GmbH" },
        { 0x00112D, "iPulse Systems" },
        { 0x00112E, "CEICOM" },
        { 0x00112F, "ASUSTek COMPUTER INC." },
        { 0x001130, "Allied Telesis (Hong Kong) Ltd." },
        { 0x001131, "UNATECH. CO.,LTD" },
        { 0x001132, "Synology Incorporated" },
        { 0x001133, "Siemens AG Austria" },
        { 0x001134, "MediaCell, Inc." },
        { 0x001135, "Grandeye Ltd" },
        { 0x001136, "Goodrich Sensor Systems" },
        { 0x001137, "AICHI ELECTRIC CO., LTD." },
        { 0x001138, "TAISHIN CO., LTD." },
        { 0x001139, "STOEBER ANTRIEBSTECHNIK GmbH + Co. KG." },
        { 0x00113A, "SHINBORAM" },
        { 0x00113B, "Micronet Communications Inc." },
        { 0x00113C, "Micronas GmbH" },
        { 0x00113D, "KN SOLTEC CO.,LTD." },
        { 0x00113E, "JL Corporation" },
        { 0x00113F, "Alcatel DI" },
        { 0x001140, "Nanometrics Inc." },
        { 0x001141, "GoodMan Corporation" },
        { 0x001142, "e-SMARTCOM INC." },
        { 0x001143, "Dell Inc." },
        { 0x001144, "Assurance Technology Corp" },
        { 0x001145, "ValuePoint Networks" },
        { 0x001146, "Telecard-Pribor Ltd" },
        { 0x001147, "Secom-Industry co.LTD." },
        { 0x001148, "Prolon Control Systems" },
        { 0x001149, "Proliphix Inc." },
        { 0x00114A, "KAYABA INDUSTRY Co,.Ltd." },
        { 0x00114B, "Francotyp-Postalia GmbH" },
        { 0x00114C, "caffeina applied research ltd." },
        { 0x00114D, "Atsumi Electric Co.,LTD." },
        { 0x00114E, "690885 Ontario Inc." },
        { 0x00114F, "US Digital Television, Inc" },
        { 0x001150, "Belkin Corporation" },
        { 0x001151, "Mykotronx" },
        { 0x001152, "Eidsvoll Electronics AS" },
        { 0x001153, "Trident Tek, Inc." },
        { 0x001154, "Webpro Technologies Inc." },
        { 0x001155, "Sevis Systems" },
        { 0x001156, "Pharos Systems NZ" },
        { 0x001157, "Oki Electric Industry Co., Ltd." },
        { 0x001158, "Nortel Networks" },
        { 0x001159, "MATISSE NETWORKS INC" },
        { 0x00115A, "Ivoclar Vivadent AG" },
        { 0x00115B, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x00115C, "Cisco Systems, Inc" },
        { 0x00115D, "Cisco Systems, Inc" },
        { 0x00115E, "ProMinent Dosiertechnik GmbH" },
        { 0x00115F, "ITX Security Co., Ltd." },
        { 0x001160, "ARTDIO Company Co., LTD" },
        { 0x001161, "NetStreams, LLC" },
        { 0x001162, "STAR MICRONICS CO.,LTD." },
        { 0x001163, "SYSTEM SPA DEPT. ELECTRONICS" },
        { 0x001164, "ACARD Technology Corp." },
        { 0x001165, "ZNYX Networks, Inc." },
        { 0x001166, "Taelim Electronics Co., Ltd." },
        { 0x001167, "Integrated System Solution Corp." },
        { 0x001168, "HomeLogic LLC" },
        { 0x001169, "EMS Satcom" },
        { 0x00116A, "Domo Ltd" },
        { 0x00116B, "Digital Data Communications Asia Co.,Ltd" },
        { 0x00116C, "Nanwang Multimedia Inc.,Ltd" },
        { 0x00116D, "American Time and Signal" },
        { 0x00116E, "Peplink International Ltd." },
        { 0x00116F, "Netforyou Co., LTD." },
        { 0x001170, "GSC SRL" },
        { 0x001171, "DEXTER Communications, Inc." },
        { 0x001172, "COTRON CORPORATION" },
        { 0x001173, "SMART Storage Systems" },
        { 0x001174, "Mojo Networks, Inc." },
        { 0x001175, "Intel Corporation" },
        { 0x001176, "Intellambda Systems, Inc." },
        { 0x001177, "Coaxial Networks, Inc." },
        { 0x001178, "Chiron Technology Ltd" },
        { 0x001179, "Singular Technology Co. Ltd." },
        { 0x00117A, "Singim International Corp." },
        { 0x00117B, "Büchi Labortechnik AG" },
        { 0x00117C, "e-zy.net" },
        { 0x00117D, "ZMD America, Inc." },
        { 0x00117E, "Midmark Corp" },
        { 0x00117F, "Neotune Information Technology Corporation,.LTD" },
        { 0x001180, "ARRIS Group, Inc." },
        { 0x001181, "InterEnergy Co.Ltd," },
        { 0x001182, "IMI Norgren Ltd" },
        { 0x001183, "Datalogic ADC, Inc." },
        { 0x001184, "Humo Laboratory,Ltd." },
        { 0x001185, "Hewlett Packard" },
        { 0x001186, "Prime Systems, Inc." },
        { 0x001187, "Category Solutions, Inc" },
        { 0x001188, "Enterasys" },
        { 0x001189, "Aerotech Inc" },
        { 0x00118A, "Viewtran Technology Limited" },
        { 0x00118B, "Alcatel-Lucent Enterprise" },
        { 0x00118C, "Missouri Department of Transportation" },
        { 0x00118D, "Hanchang System Corp." },
        { 0x00118E, "Halytech Mace" },
        { 0x00118F, "EUTECH INSTRUMENTS PTE. LTD." },
        { 0x001190, "Digital Design Corporation" },
        { 0x001191, "CTS-Clima Temperatur Systeme GmbH" },
        { 0x001192, "Cisco Systems, Inc" },
        { 0x001193, "Cisco Systems, Inc" },
        { 0x001194, "Chi Mei Communication Systems, Inc." },
        { 0x001195, "D-Link Corporation" },
        { 0x001196, "Actuality Systems, Inc." },
        { 0x001197, "Monitoring Technologies Limited" },
        { 0x001198, "Prism Media Products Limited" },
        { 0x001199, "2wcom Systems GmbH" },
        { 0x00119A, "Alkeria srl" },
        { 0x00119B, "Telesynergy Research Inc." },
        { 0x00119C, "EP&T Energy" },
        { 0x00119D, "Diginfo Technology Corporation" },
        { 0x00119E, "Solectron Brazil" },
        { 0x00119F, "Nokia Danmark A/S" },
        { 0x0011A0, "Vtech Engineering Canada Ltd" },
        { 0x0011A1, "VISION NETWARE CO.,LTD" },
        { 0x0011A2, "Manufacturing Technology Inc" },
        { 0x0011A3, "LanReady Technologies Inc." },
        { 0x0011A4, "JStream Technologies Inc." },
        { 0x0011A5, "Fortuna Electronic Corp." },
        { 0x0011A6, "Sypixx Networks" },
        { 0x0011A7, "Infilco Degremont Inc." },
        { 0x0011A8, "Quest Technologies" },
        { 0x0011A9, "MOIMSTONE Co., LTD" },
        { 0x0011AA, "Uniclass Technology, Co., LTD" },
        { 0x0011AB, "TRUSTABLE TECHNOLOGY CO.,LTD." },
        { 0x0011AC, "Simtec Electronics" },
        { 0x0011AD, "Shanghai Ruijie Technology" },
        { 0x0011AE, "ARRIS Group, Inc." },
        { 0x0011AF, "Medialink-i,Inc" },
        { 0x0011B0, "Fortelink Inc." },
        { 0x0011B1, "BlueExpert Technology Corp." },
        { 0x0011B2, "2001 Technology Inc." },
        { 0x0011B3, "YOSHIMIYA CO.,LTD." },
        { 0x0011B4, "Westermo Network Technologies AB" },
        { 0x0011B5, "Shenzhen Powercom Co.,Ltd" },
        { 0x0011B6, "Open Systems International" },
        { 0x0011B7, "Octalix B.V." },
        { 0x0011B8, "Liebherr - Elektronik GmbH" },
        { 0x0011B9, "Inner Range Pty. Ltd." },
        { 0x0011BA, "Elexol Pty Ltd" },
        { 0x0011BB, "Cisco Systems, Inc" },
        { 0x0011BC, "Cisco Systems, Inc" },
        { 0x0011BD, "Bombardier Transportation" },
        { 0x0011BE, "AGP Telecom Co. Ltd" },
        { 0x0011BF, "AESYS S.p.A." },
        { 0x0011C0, "Aday Technology Inc" },
        { 0x0011C1, "4P MOBILE DATA PROCESSING" },
        { 0x0011C2, "United Fiber Optic Communication" },
        { 0x0011C3, "Transceiving System Technology Corporation" },
        { 0x0011C4, "Terminales de Telecomunicacion Terrestre, S.L." },
        { 0x0011C5, "TEN Technology" },
        { 0x0011C6, "Seagate Technology" },
        { 0x0011C7, "Raymarine UK Ltd" },
        { 0x0011C8, "Powercom Co., Ltd." },
        { 0x0011C9, "MTT Corporation" },
        { 0x0011CA, "Long Range Systems, Inc." },
        { 0x0011CB, "Jacobsons AB" },
        { 0x0011CC, "Guangzhou Jinpeng Group Co.,Ltd." },
        { 0x0011CD, "Axsun Technologies" },
        { 0x0011CE, "Ubisense Limited" },
        { 0x0011CF, "Thrane & Thrane A/S" },
        { 0x0011D0, "Tandberg Data ASA" },
        { 0x0011D1, "Soft Imaging System GmbH" },
        { 0x0011D2, "Perception Digital Ltd" },
        { 0x0011D3, "NextGenTel Holding ASA" },
        { 0x0011D4, "NetEnrich, Inc" },
        { 0x0011D5, "Hangzhou Sunyard System Engineering Co.,Ltd." },
        { 0x0011D6, "HandEra, Inc." },
        { 0x0011D7, "eWerks Inc" },
        { 0x0011D8, "ASUSTek COMPUTER INC." },
        { 0x0011D9, "TiVo" },
        { 0x0011DA, "Vivaas Technology Inc." },
        { 0x0011DB, "Land-Cellular Corporation" },
        { 0x0011DC, "Glunz & Jensen" },
        { 0x0011DD, "FROMUS TEC. Co., Ltd." },
        { 0x0011DE, "EURILOGIC" },
        { 0x0011DF, "Current Energy" },
        { 0x0011E0, "U-MEDIA Communications, Inc." },
        { 0x0011E1, "Arcelik A.S" },
        { 0x0011E2, "Hua Jung Components Co., Ltd." },
        { 0x0011E3, "Thomson, Inc." },
        { 0x0011E4, "Danelec Electronics A/S" },
        { 0x0011E5, "KCodes Corporation" },
        { 0x0011E6, "Scientific Atlanta" },
        { 0x0011E7, "WORLDSAT - Texas de France" },
        { 0x0011E8, "Tixi.Com" },
        { 0x0011E9, "STARNEX CO., LTD." },
        { 0x0011EA, "IWICS Inc." },
        { 0x0011EB, "Innovative Integration" },
        { 0x0011EC, "AVIX INC." },
        { 0x0011ED, "802 Global" },
        { 0x0011EE, "Estari, Inc." },
        { 0x0011EF, "Conitec Datensysteme GmbH" },
        { 0x0011F0, "Wideful Limited" },
        { 0x0011F1, "QinetiQ Ltd" },
        { 0x0011F2, "Institute of Network Technologies" },
        { 0x0011F3, "NeoMedia Europe AG" },
        { 0x0011F4, "woori-net" },
        { 0x0011F5, "ASKEY COMPUTER CORP" },
        { 0x0011F6, "Asia Pacific Microsystems , Inc." },
        { 0x0011F7, "Shenzhen Forward Industry Co., Ltd" },
        { 0x0011F8, "AIRAYA Corp" },
        { 0x0011F9, "Nortel Networks" },
        { 0x0011FA, "Rane Corporation" },
        { 0x0011FB, "Heidelberg Engineering GmbH" },
        { 0x0011FC, "HARTING Electronics GmbH" },
        { 0x0011FD, "KORG INC." },
        { 0x0011FE, "Keiyo System Research, Inc." },
        { 0x0011FF, "Digitro Tecnologia Ltda" },
        { 0x001200, "Cisco Systems, Inc" },
        { 0x001201, "Cisco Systems, Inc" },
        { 0x001202, "Decrane Aerospace - Audio International Inc." },
        { 0x001203, "ActivNetworks" },
        { 0x001204, "u10 Networks, Inc." },
        { 0x001205, "Terrasat Communications, Inc." },
        { 0x001206, "iQuest (NZ) Ltd" },
        { 0x001207, "Head Strong International Limited" },
        { 0x001208, "Gantner Instruments GmbH" },
        { 0x001209, "Fastrax Ltd" },
        { 0x00120A, "Emerson Climate Technologies GmbH" },
        { 0x00120B, "Chinasys Technologies Limited" },
        { 0x00120C, "CE-Infosys Pte Ltd" },
        { 0x00120D, "Advanced Telecommunication Technologies, Inc." },
        { 0x00120E, "AboCom" },
        { 0x00120F, "IEEE 802.3" },
        { 0x001210, "WideRay Corp" },
        { 0x001211, "Protechna Herbst GmbH & Co. KG" },
        { 0x001212, "PLUS Corporation" },
        { 0x001213, "Metrohm AG" },
        { 0x001214, "Koenig & Bauer AG" },
        { 0x001215, "iStor Networks, Inc." },
        { 0x001216, "ICP Internet Communication Payment AG" },
        { 0x001217, "Cisco-Linksys, LLC" },
        { 0x001218, "ARUZE Corporation" },
        { 0x001219, "General Datacomm LLC" },
        { 0x00121A, "Techno Soft Systemnics Inc." },
        { 0x00121B, "Sound Devices, LLC" },
        { 0x00121C, "PARROT SA" },
        { 0x00121D, "Netfabric Corporation" },
        { 0x00121E, "Juniper Networks" },
        { 0x00121F, "Harding Instruments" },
        { 0x001220, "Cadco Systems" },
        { 0x001221, "B.Braun Melsungen AG" },
        { 0x001222, "Skardin (UK) Ltd" },
        { 0x001223, "Pixim" },
        { 0x001224, "NexQL Corporation" },
        { 0x001225, "ARRIS Group, Inc." },
        { 0x001226, "Japan Direx Corporation" },
        { 0x001227, "Franklin Electric Co., Inc." },
        { 0x001228, "Data Ltd." },
        { 0x001229, "BroadEasy Technologies Co.,Ltd" },
        { 0x00122A, "VTech Telecommunications Ltd." },
        { 0x00122B, "Virbiage Pty Ltd" },
        { 0x00122C, "Soenen Controls N.V." },
        { 0x00122D, "SiNett Corporation" },
        { 0x00122E, "Signal Technology - AISD" },
        { 0x00122F, "Sanei Electric Inc." },
        { 0x001230, "Picaso Infocommunication CO., LTD." },
        { 0x001231, "Motion Control Systems, Inc." },
        { 0x001232, "LeWiz Communications Inc." },
        { 0x001233, "JRC TOKKI Co.,Ltd." },
        { 0x001234, "Camille Bauer" },
        { 0x001235, "Andrew Corporation" },
        { 0x001236, "ConSentry Networks" },
        { 0x001237, "Texas Instruments" },
        { 0x001238, "SetaBox Technology Co., Ltd." },
        { 0x001239, "S Net Systems Inc." },
        { 0x00123A, "Posystech Inc., Co." },
        { 0x00123B, "KeRo Systems ApS" },
        { 0x00123C, "Second Rule LLC" },
        { 0x00123D, "GES Co, Ltd" },
        { 0x00123E, "ERUNE technology Co., Ltd." },
        { 0x00123F, "Dell Inc." },
        { 0x001240, "AMOI ELECTRONICS CO.,LTD" },
        { 0x001241, "a2i marketing center" },
        { 0x001242, "Millennial Net" },
        { 0x001243, "Cisco Systems, Inc" },
        { 0x001244, "Cisco Systems, Inc" },
        { 0x001245, "Zellweger Analytics, Inc." },
        { 0x001246, "T.O.M TECHNOLOGY INC.." },
        { 0x001247, "Samsung Electronics Co.,Ltd" },
        { 0x001248, "Dell EMC" },
        { 0x001249, "Delta Elettronica S.p.A." },
        { 0x00124A, "Dedicated Devices, Inc." },
        { 0x00124B, "Texas Instruments" },
        { 0x00124C, "BBWM Corporation" },
        { 0x00124D, "Inducon BV" },
        { 0x00124E, "XAC AUTOMATION CORP." },
        { 0x00124F, "nVent" },
        { 0x001250, "Tokyo Aircaft Instrument Co., Ltd." },
        { 0x001251, "SILINK" },
        { 0x001252, "Citronix, LLC" },
        { 0x001253, "AudioDev AB" },
        { 0x001254, "Spectra Technologies Holdings Company Ltd" },
        { 0x001255, "NetEffect Incorporated" },
        { 0x001256, "LG INFORMATION & COMM." },
        { 0x001257, "LeapComm Communication Technologies Inc." },
        { 0x001258, "TechVoIP Sp z o.o." },
        { 0x001259, "THERMO ELECTRON KARLSRUHE" },
        { 0x00125A, "Microsoft Corporation" },
        { 0x00125B, "KAIMEI ELECTRONI" },
        { 0x00125C, "Green Hills Software, Inc." },
        { 0x00125D, "CyberNet Inc." },
        { 0x00125E, "CAEN" },
        { 0x00125F, "AWIND Inc." },
        { 0x001260, "Stanton Magnetics,inc." },
        { 0x001261, "Adaptix, Inc" },
        { 0x001262, "Nokia Danmark A/S" },
        { 0x001263, "Data Voice Technologies GmbH" },
        { 0x001264, "daum electronic gmbh" },
        { 0x001265, "Enerdyne Technologies, Inc." },
        { 0x001266, "Swisscom Hospitality Services SA" },
        { 0x001267, "Panasonic Corporation" },
        { 0x001268, "IPS d.o.o." },
        { 0x001269, "Value Electronics" },
        { 0x00126A, "OPTOELECTRONICS Co., Ltd." },
        { 0x00126B, "Ascalade Communications Limited" },
        { 0x00126C, "Visonic Technologies 1993 Ltd." },
        { 0x00126D, "University of California, Berkeley" },
        { 0x00126E, "Seidel Elektronik GmbH Nfg.KG" },
        { 0x00126F, "Rayson Technology Co., Ltd." },
        { 0x001270, "NGES Denro Systems" },
        { 0x001271, "Measurement Computing Corp" },
        { 0x001272, "Redux Communications Ltd." },
        { 0x001273, "Stoke Inc" },
        { 0x001274, "NIT lab" },
        { 0x001275, "Sentilla Corporation" },
        { 0x001276, "CG Power Systems Ireland Limited" },
        { 0x001277, "Korenix Technologies Co., Ltd." },
        { 0x001278, "International Bar Code" },
        { 0x001279, "Hewlett Packard" },
        { 0x00127A, "Sanyu Industry Co.,Ltd." },
        { 0x00127B, "VIA Networking Technologies, Inc." },
        { 0x00127C, "SWEGON AB" },
        { 0x00127D, "MobileAria" },
        { 0x00127E, "Digital Lifestyles Group, Inc." },
        { 0x00127F, "Cisco Systems, Inc" },
        { 0x001280, "Cisco Systems, Inc" },
        { 0x001281, "March Networks S.p.A." },
        { 0x001282, "Qovia" },
        { 0x001283, "Nortel Networks" },
        { 0x001284, "Lab33 Srl" },
        { 0x001285, "Gizmondo Europe Ltd" },
        { 0x001286, "ENDEVCO CORP" },
        { 0x001287, "Digital Everywhere Unterhaltungselektronik GmbH" },
        { 0x001288, "2Wire Inc" },
        { 0x001289, "Advance Sterilization Products" },
        { 0x00128A, "ARRIS Group, Inc." },
        { 0x00128B, "Sensory Networks Inc" },
        { 0x00128C, "Woodward Governor" },
        { 0x00128D, "STB Datenservice GmbH" },
        { 0x00128E, "Q-Free ASA" },
        { 0x00128F, "Montilio" },
        { 0x001290, "KYOWA Electric & Machinery Corp." },
        { 0x001291, "KWS Computersysteme GmbH" },
        { 0x001292, "Griffin Technology" },
        { 0x001293, "GE Energy" },
        { 0x001294, "SUMITOMO ELECTRIC DEVICE INNOVATIONS, INC" },
        { 0x001295, "Aiware Inc." },
        { 0x001296, "Addlogix" },
        { 0x001297, "O2Micro, Inc." },
        { 0x001298, "MICO ELECTRIC(SHENZHEN) LIMITED" },
        { 0x001299, "Ktech Telecommunications Inc" },
        { 0x00129A, "IRT Electronics Pty Ltd" },
        { 0x00129B, "E2S Electronic Engineering Solutions, S.L." },
        { 0x00129C, "Yulinet" },
        { 0x00129D, "First International Computer do Brasil" },
        { 0x00129E, "Surf Communications Inc." },
        { 0x00129F, "RAE Systems" },
        { 0x0012A0, "NeoMeridian Sdn Bhd" },
        { 0x0012A1, "BluePacket Communications Co., Ltd." },
        { 0x0012A2, "VITA" },
        { 0x0012A3, "Trust International B.V." },
        { 0x0012A4, "ThingMagic, LLC" },
        { 0x0012A5, "Dolphin Interconnect Solutions AS" },
        { 0x0012A6, "Dolby Australia" },
        { 0x0012A7, "ISR TECHNOLOGIES Inc" },
        { 0x0012A8, "intec GmbH" },
        { 0x0012A9, "3Com Ltd" },
        { 0x0012AA, "IEE, Inc." },
        { 0x0012AB, "WiLife, Inc." },
        { 0x0012AC, "ONTIMETEK INC." },
        { 0x0012AD, "IDS GmbH" },
        { 0x0012AE, "HLS HARD-LINE Solutions Inc." },
        { 0x0012AF, "ELPRO Technologies" },
        { 0x0012B0, "Efore Oyj (Plc)" },
        { 0x0012B1, "Dai Nippon Printing Co., Ltd" },
        { 0x0012B2, "AVOLITES LTD." },
        { 0x0012B3, "Advance Wireless Technology Corp." },
        { 0x0012B4, "Work Microwave GmbH" },
        { 0x0012B5, "Vialta, Inc." },
        { 0x0012B6, "Santa Barbara Infrared, Inc." },
        { 0x0012B7, "PTW Freiburg" },
        { 0x0012B8, "G2 Microsystems" },
        { 0x0012B9, "Fusion Digital Technology" },
        { 0x0012BA, "FSI Systems, Inc." },
        { 0x0012BB, "Telecommunications Industry Association TR-41 Committee" },
        { 0x0012BC, "Echolab LLC" },
        { 0x0012BD, "Avantec Manufacturing Limited" },
        { 0x0012BE, "Astek Corporation" },
        { 0x0012BF, "Arcadyan Technology Corporation" },
        { 0x0012C0, "HotLava Systems, Inc." },
        { 0x0012C1, "Check Point Software Technologies" },
        { 0x0012C2, "Apex Electronics Factory" },
        { 0x0012C3, "WIT S.A." },
        { 0x0012C4, "Viseon, Inc." },
        { 0x0012C5, "V-Show Technology (China) Co.,Ltd" },
        { 0x0012C6, "TGC America, Inc" },
        { 0x0012C7, "SECURAY Technologies Ltd.Co." },
        { 0x0012C8, "Perfect tech" },
        { 0x0012C9, "ARRIS Group, Inc." },
        { 0x0012CA, "Mechatronic Brick Aps" },
        { 0x0012CB, "CSS Inc." },
        { 0x0012CC, "Bitatek CO., LTD" },
        { 0x0012CD, "ASEM SpA" },
        { 0x0012CE, "Advanced Cybernetics Group" },
        { 0x0012CF, "Accton Technology Corp" },
        { 0x0012D0, "Gossen-Metrawatt-GmbH" },
        { 0x0012D1, "Texas Instruments" },
        { 0x0012D2, "Texas Instruments" },
        { 0x0012D3, "Zetta Systems, Inc." },
        { 0x0012D4, "Princeton Technology, Ltd" },
        { 0x0012D5, "Motion Reality Inc." },
        { 0x0012D6, "Jiangsu Yitong High-Tech Co.,Ltd" },
        { 0x0012D7, "Invento Networks, Inc." },
        { 0x0012D8, "International Games System Co., Ltd." },
        { 0x0012D9, "Cisco Systems, Inc" },
        { 0x0012DA, "Cisco Systems, Inc" },
        { 0x0012DB, "ZIEHL industrie-elektronik GmbH + Co KG" },
        { 0x0012DC, "SunCorp Industrial Limited" },
        { 0x0012DD, "Shengqu Information Technology (Shanghai) Co., Ltd." },
        { 0x0012DE, "Radio Components Sweden AB" },
        { 0x0012DF, "Novomatic AG" },
        { 0x0012E0, "Codan Limited" },
        { 0x0012E1, "Alliant Networks, Inc" },
        { 0x0012E2, "ALAXALA Networks Corporation" },
        { 0x0012E3, "Agat Soft LLC" },
        { 0x0012E4, "ZIEHL industrie-electronik GmbH + Co KG" },
        { 0x0012E5, "Time America, Inc." },
        { 0x0012E6, "SPECTEC COMPUTER CO., LTD." },
        { 0x0012E7, "Projectek Networking Electronics Corp." },
        { 0x0012E8, "Fraunhofer IMS" },
        { 0x0012E9, "Abbey Systems Ltd" },
        { 0x0012EA, "Trane" },
        { 0x0012EB, "PDH Solutions, LLC" },
        { 0x0012EC, "Movacolor b.v." },
        { 0x0012ED, "AVG Advanced Technologies" },
        { 0x0012EE, "Sony Mobile Communications Inc" },
        { 0x0012EF, "OneAccess SA" },
        { 0x0012F0, "Intel Corporate" },
        { 0x0012F1, "IFOTEC" },
        { 0x0012F2, "Brocade Communications Systems LLC" },
        { 0x0012F3, "connectBlue AB" },
        { 0x0012F4, "Belco International Co.,Ltd." },
        { 0x0012F5, "Imarda New Zealand Limited" },
        { 0x0012F6, "MDK CO.,LTD." },
        { 0x0012F7, "Xiamen Xinglian Electronics Co., Ltd." },
        { 0x0012F8, "WNI Resources, LLC" },
        { 0x0012F9, "URYU SEISAKU, LTD." },
        { 0x0012FA, "THX LTD" },
        { 0x0012FB, "Samsung Electronics Co.,Ltd" },
        { 0x0012FC, "PLANET System Co.,LTD" },
        { 0x0012FD, "OPTIMUS IC S.A." },
        { 0x0012FE, "Lenovo Mobile Communication Technology Ltd." },
        { 0x0012FF, "Lely Industries N.V." },
        { 0x001300, "IT-FACTORY, INC." },
        { 0x001301, "IronGate S.L." },
        { 0x001302, "Intel Corporate" },
        { 0x001303, "GateConnect" },
        { 0x001304, "Flaircomm Technologies Co. LTD" },
        { 0x001305, "Epicom, Inc." },
        { 0x001306, "Always On Wireless" },
        { 0x001307, "Paravirtual Corporation" },
        { 0x001308, "Nuvera Fuel Cells" },
        { 0x001309, "Ocean Broadband Networks" },
        { 0x00130A, "Nortel Networks" },
        { 0x00130B, "Mextal B.V." },
        { 0x00130C, "HF System Corporation" },
        { 0x00130D, "GALILEO AVIONICA" },
        { 0x00130E, "Focusrite Audio Engineering Limited" },
        { 0x00130F, "EGEMEN Bilgisayar Muh San ve Tic LTD STI" },
        { 0x001310, "Cisco-Linksys, LLC" },
        { 0x001311, "ARRIS Group, Inc." },
        { 0x001312, "Amedia Networks Inc." },
        { 0x001313, "GuangZhou Post & Telecom Equipment ltd" },
        { 0x001314, "Asiamajor Inc." },
        { 0x001315, "Sony Interactive Entertainment Inc." },
        { 0x001316, "L-S-B Broadcast Technologies GmbH" },
        { 0x001317, "GN Netcom A/S" },
        { 0x001318, "DGSTATION Co., Ltd." },
        { 0x001319, "Cisco Systems, Inc" },
        { 0x00131A, "Cisco Systems, Inc" },
        { 0x00131B, "BeCell Innovations Corp." },
        { 0x00131C, "LiteTouch, Inc." },
        { 0x00131D, "Scanvaegt International A/S" },
        { 0x00131E, "peiker acustic GmbH" },
        { 0x00131F, "NxtPhase T&D, Corp." },
        { 0x001320, "Intel Corporate" },
        { 0x001321, "Hewlett Packard" },
        { 0x001322, "DAQ Electronics, Inc." },
        { 0x001323, "Cap Co., Ltd." },
        { 0x001324, "Schneider Electric Ultra Terminal" },
        { 0x001325, "Cortina Systems Inc" },
        { 0x001326, "ECM Systems Ltd" },
        { 0x001327, "Data Acquisitions limited" },
        { 0x001328, "Westech Korea Inc.," },
        { 0x001329, "VSST Co., LTD" },
        { 0x00132A, "Sitronics Telecom Solutions" },
        { 0x00132B, "Phoenix Digital" },
        { 0x00132C, "MAZ Brandenburg GmbH" },
        { 0x00132D, "iWise Communications" },
        { 0x00132E, "ITian Coporation" },
        { 0x00132F, "Interactek" },
        { 0x001330, "EURO PROTECTION SURVEILLANCE" },
        { 0x001331, "CellPoint Connect" },
        { 0x001332, "Beijing Topsec Network Security Technology Co., Ltd." },
        { 0x001333, "BaudTec Corporation" },
        { 0x001334, "Arkados, Inc." },
        { 0x001335, "VS Industry Berhad" },
        { 0x001336, "Tianjin 712 Communication Broadcasting co., ltd." },
        { 0x001337, "Orient Power Home Network Ltd." },
        { 0x001338, "FRESENIUS-VIAL" },
        { 0x001339, "CCV Deutschland GmbH" },
        { 0x00133A, "VadaTech Inc." },
        { 0x00133B, "Speed Dragon Multimedia Limited" },
        { 0x00133C, "QUINTRON SYSTEMS INC." },
        { 0x00133D, "Micro Memory Curtiss Wright Co" },
        { 0x00133E, "MetaSwitch" },
        { 0x00133F, "Eppendorf Instrumente GmbH" },
        { 0x001340, "AD.EL s.r.l." },
        { 0x001341, "Shandong New Beiyang Information Technology Co.,Ltd" },
        { 0x001342, "Vision Research, Inc." },
        { 0x001343, "Matsushita Electronic Components (Europe) GmbH" },
        { 0x001344, "Fargo Electronics Inc." },
        { 0x001345, "Eaton Corporation" },
        { 0x001346, "D-Link Corporation" },
        { 0x001347, "Red Lion Controls, LP" },
        { 0x001348, "Artila Electronics Co., Ltd." },
        { 0x001349, "Zyxel Communications Corporation" },
        { 0x00134A, "Engim, Inc." },
        { 0x00134B, "ToGoldenNet Technology Inc." },
        { 0x00134C, "YDT Technology International" },
        { 0x00134D, "Inepro BV" },
        { 0x00134E, "Valox Systems, Inc." },
        { 0x00134F, "Rapidus Wireless Networks Inc." },
        { 0x001350, "Silver Spring Networks, Inc" },
        { 0x001351, "Niles Audio Corporation" },
        { 0x001352, "Naztec, Inc." },
        { 0x001353, "HYDAC Filtertechnik GMBH" },
        { 0x001354, "Zcomax Technologies, Inc." },
        { 0x001355, "TOMEN Cyber-business Solutions, Inc." },
        { 0x001356, "FLIR Radiation Inc" },
        { 0x001357, "Soyal Technology Co., Ltd." },
        { 0x001358, "Realm Systems, Inc." },
        { 0x001359, "ProTelevision Technologies A/S" },
        { 0x00135A, "Project T&E Limited" },
        { 0x00135B, "PanelLink Cinema, LLC" },
        { 0x00135C, "OnSite Systems, Inc." },
        { 0x00135D, "NTTPC Communications, Inc." },
        { 0x00135E, "EAB/RWI/K" },
        { 0x00135F, "Cisco Systems, Inc" },
        { 0x001360, "Cisco Systems, Inc" },
        { 0x001361, "Biospace Co., Ltd." },
        { 0x001362, "ShinHeung Precision Co., Ltd." },
        { 0x001363, "Verascape, Inc." },
        { 0x001364, "Paradigm Technology Inc.." },
        { 0x001365, "Nortel Networks" },
        { 0x001366, "Neturity Technologies Inc." },
        { 0x001367, "Narayon. Co., Ltd." },
        { 0x001368, "Saab Danmark A/S" },
        { 0x001369, "Honda Electron Co., LED." },
        { 0x00136A, "Hach Lange Sarl" },
        { 0x00136B, "E-TEC" },
        { 0x00136C, "TomTom" },
        { 0x00136D, "Tentaculus AB" },
        { 0x00136E, "Techmetro Corp." },
        { 0x00136F, "PacketMotion, Inc." },
        { 0x001370, "Nokia Danmark A/S" },
        { 0x001371, "ARRIS Group, Inc." },
        { 0x001372, "Dell Inc." },
        { 0x001373, "BLwave Electronics Co., Ltd" },
        { 0x001374, "Atheros Communications, Inc." },
        { 0x001375, "American Security Products Co." },
        { 0x001376, "Tabor Electronics Ltd." },
        { 0x001377, "Samsung Electronics Co.,Ltd" },
        { 0x001378, "Qsan Technology, Inc." },
        { 0x001379, "PONDER INFORMATION INDUSTRIES LTD." },
        { 0x00137A, "Netvox Technology Co., Ltd." },
        { 0x00137B, "Movon Corporation" },
        { 0x00137C, "Kaicom co., Ltd." },
        { 0x00137D, "Dynalab, Inc." },
        { 0x00137E, "CorEdge Networks, Inc." },
        { 0x00137F, "Cisco Systems, Inc" },
        { 0x001380, "Cisco Systems, Inc" },
        { 0x001381, "CHIPS & Systems, Inc." },
        { 0x001382, "Cetacea Networks Corporation" },
        { 0x001383, "Application Technologies and Engineering Research Laboratory" },
        { 0x001384, "Advanced Motion Controls" },
        { 0x001385, "Add-On Technology Co., LTD." },
        { 0x001386, "ABB Inc/Totalflow" },
        { 0x001387, "27M Technologies AB" },
        { 0x001388, "WiMedia Alliance" },
        { 0x001389, "Redes de Telefonía Móvil S.A." },
        { 0x00138A, "Qingdao GoerTek Technology Co., Ltd." },
        { 0x00138B, "Phantom Technologies LLC" },
        { 0x00138C, "Kumyoung.Co.Ltd" },
        { 0x00138D, "Kinghold" },
        { 0x00138E, "FOAB Elektronik AB" },
        { 0x00138F, "Asiarock Technology Limited" },
        { 0x001390, "Termtek Computer Co., Ltd" },
        { 0x001391, "OUEN CO.,LTD." },
        { 0x001392, "Ruckus Wireless" },
        { 0x001393, "Panta Systems, Inc." },
        { 0x001394, "Infohand Co.,Ltd" },
        { 0x001395, "congatec AG" },
        { 0x001396, "Acbel Polytech Inc." },
        { 0x001397, "Oracle Corporation" },
        { 0x001398, "TrafficSim Co.,Ltd" },
        { 0x001399, "STAC Corporation." },
        { 0x00139A, "K-ubique ID Corp." },
        { 0x00139B, "ioIMAGE Ltd." },
        { 0x00139C, "Exavera Technologies, Inc." },
        { 0x00139D, "MaxLinear Hispania S.L.U." },
        { 0x00139E, "Ciara Technologies Inc." },
        { 0x00139F, "Electronics Design Services, Co., Ltd." },
        { 0x0013A0, "ALGOSYSTEM Co., Ltd." },
        { 0x0013A1, "Crow Electronic Engeneering" },
        { 0x0013A2, "MaxStream, Inc" },
        { 0x0013A3, "Siemens Home & Office Comm. Devices" },
        { 0x0013A4, "KeyEye Communications" },
        { 0x0013A5, "General Solutions, LTD." },
        { 0x0013A6, "Extricom Ltd" },
        { 0x0013A7, "BATTELLE MEMORIAL INSTITUTE" },
        { 0x0013A8, "Tanisys Technology" },
        { 0x0013A9, "Sony Corporation" },
        { 0x0013AA, "ALS & TEC Ltd." },
        { 0x0013AB, "Telemotive AG" },
        { 0x0013AC, "Sunmyung Electronics Co., LTD" },
        { 0x0013AD, "Sendo Ltd" },
        { 0x0013AE, "Radiance Technologies, Inc." },
        { 0x0013AF, "NUMA Technology,Inc." },
        { 0x0013B0, "Jablotron" },
        { 0x0013B1, "Intelligent Control Systems (Asia) Pte Ltd" },
        { 0x0013B2, "Carallon Limited" },
        { 0x0013B3, "Ecom Communications Technology Co., Ltd." },
        { 0x0013B4, "Appear TV" },
        { 0x0013B5, "Wavesat" },
        { 0x0013B6, "Sling Media, Inc." },
        { 0x0013B7, "Scantech ID" },
        { 0x0013B8, "RyCo Electronic Systems Limited" },
        { 0x0013B9, "BM SPA" },
        { 0x0013BA, "ReadyLinks Inc" },
        { 0x0013BB, "Smartvue Corporation" },
        { 0x0013BC, "Artimi Ltd" },
        { 0x0013BD, "HYMATOM SA" },
        { 0x0013BE, "Virtual Conexions" },
        { 0x0013BF, "Media System Planning Corp." },
        { 0x0013C0, "Trix Tecnologia Ltda." },
        { 0x0013C1, "Asoka USA Corporation" },
        { 0x0013C2, "WACOM Co.,Ltd" },
        { 0x0013C3, "Cisco Systems, Inc" },
        { 0x0013C4, "Cisco Systems, Inc" },
        { 0x0013C5, "LIGHTRON FIBER-OPTIC DEVICES INC." },
        { 0x0013C6, "OpenGear, Inc" },
        { 0x0013C7, "IONOS Co.,Ltd." },
        { 0x0013C8, "ADB Broadband Italia" },
        { 0x0013C9, "Beyond Achieve Enterprises Ltd." },
        { 0x0013CA, "Pico Digital" },
        { 0x0013CB, "Zenitel Norway AS" },
        { 0x0013CC, "Tall Maple Systems" },
        { 0x0013CD, "MTI co. LTD" },
        { 0x0013CE, "Intel Corporate" },
        { 0x0013CF, "4Access Communications" },
        { 0x0013D0, "t+ Medical Ltd" },
        { 0x0013D1, "KIRK telecom A/S" },
        { 0x0013D2, "PAGE IBERICA, S.A." },
        { 0x0013D3, "MICRO-STAR INTERNATIONAL CO., LTD." },
        { 0x0013D4, "ASUSTek COMPUTER INC." },
        { 0x0013D5, "RuggedCom" },
        { 0x0013D6, "TII NETWORK TECHNOLOGIES, INC." },
        { 0x0013D7, "SPIDCOM Technologies SA" },
        { 0x0013D8, "Princeton Instruments" },
        { 0x0013D9, "Matrix Product Development, Inc." },
        { 0x0013DA, "Diskware Co., Ltd" },
        { 0x0013DB, "SHOEI Electric Co.,Ltd" },
        { 0x0013DC, "IBTEK INC." },
        { 0x0013DD, "Abbott Diagnostics" },
        { 0x0013DE, "Adapt4, LLC" },
        { 0x0013DF, "Ryvor Corp." },
        { 0x0013E0, "Murata Manufacturing Co., Ltd." },
        { 0x0013E1, "Iprobe AB" },
        { 0x0013E2, "GeoVision Inc." },
        { 0x0013E3, "CoVi Technologies, Inc." },
        { 0x0013E4, "YANGJAE SYSTEMS CORP." },
        { 0x0013E5, "TENOSYS, INC." },
        { 0x0013E6, "Technolution" },
        { 0x0013E7, "Halcro" },
        { 0x0013E8, "Intel Corporate" },
        { 0x0013E9, "VeriWave, Inc." },
        { 0x0013EA, "Kamstrup A/S" },
        { 0x0013EB, "Sysmaster Corporation" },
        { 0x0013EC, "Netsnapper Technologies SARL" },
        { 0x0013ED, "PSIA" },
        { 0x0013EE, "JBX Designs Inc." },
        { 0x0013EF, "Kingjon Digital Technology Co.,Ltd" },
        { 0x0013F0, "Wavefront Semiconductor" },
        { 0x0013F1, "AMOD Technology Co., Ltd." },
        { 0x0013F2, "Klas Ltd" },
        { 0x0013F3, "Giga-byte Communications Inc." },
        { 0x0013F4, "Psitek (Pty) Ltd" },
        { 0x0013F5, "Akimbi Systems" },
        { 0x0013F6, "Cintech" },
        { 0x0013F7, "SMC Networks, Inc." },
        { 0x0013F8, "Dex Security Solutions" },
        { 0x0013F9, "Cavera Systems" },
        { 0x0013FA, "LifeSize Communications, Inc" },
        { 0x0013FB, "RKC INSTRUMENT INC." },
        { 0x0013FC, "SiCortex, Inc" },
        { 0x0013FD, "Nokia Danmark A/S" },
        { 0x0013FE, "GRANDTEC ELECTRONIC CORP." },
        { 0x0013FF, "Dage-MTI of MC, Inc." },
        { 0x001400, "MINERVA KOREA CO., LTD" },
        { 0x001401, "Rivertree Networks Corp." },
        { 0x001402, "kk-electronic a/s" },
        { 0x001403, "Renasis, LLC" },
        { 0x001404, "ARRIS Group, Inc." },
        { 0x001405, "OpenIB, Inc." },
        { 0x001406, "Go Networks" },
        { 0x001407, "Sperian Protection Instrumentation" },
        { 0x001408, "Eka Systems Inc." },
        { 0x001409, "MAGNETI MARELLI S.E. S.p.A." },
        { 0x00140A, "WEPIO Co., Ltd." },
        { 0x00140B, "FIRST INTERNATIONAL COMPUTER, INC." },
        { 0x00140C, "GKB CCTV CO., LTD." },
        { 0x00140D, "Nortel Networks" },
        { 0x00140E, "Nortel Networks" },
        { 0x00140F, "Federal State Unitary Enterprise Leningrad R&D Institute of" },
        { 0x001410, "Suzhou Keda Technology CO.,Ltd" },
        { 0x001411, "Deutschmann Automation GmbH & Co. KG" },
        { 0x001412, "S-TEC electronics AG" },
        { 0x001413, "Trebing & Himstedt Prozeßautomation GmbH & Co. KG" },
        { 0x001414, "Jumpnode Systems LLC." },
        { 0x001415, "Intec Automation inc." },
        { 0x001416, "Scosche Industries, Inc." },
        { 0x001417, "RSE Informations Technologie GmbH" },
        { 0x001418, "C4Line" },
        { 0x001419, "SIDSA" },
        { 0x00141A, "DEICY CORPORATION" },
        { 0x00141B, "Cisco Systems, Inc" },
        { 0x00141C, "Cisco Systems, Inc" },
        { 0x00141D, "LTI-Motion GmbH" },
        { 0x00141E, "P.A. Semi, Inc." },
        { 0x00141F, "SunKwang Electronics Co., Ltd" },
        { 0x001420, "G-Links networking company" },
        { 0x001421, "Total Wireless Technologies Pte. Ltd." },
        { 0x001422, "Dell Inc." },
        { 0x001423, "J-S Co. NEUROCOM" },
        { 0x001424, "Merry Electrics CO., LTD." },
        { 0x001425, "Galactic Computing Corp." },
        { 0x001426, "NL Technology" },
        { 0x001427, "JazzMutant" },
        { 0x001428, "Vocollect Inc" },
        { 0x001429, "V Center Technologies Co., Ltd." },
        { 0x00142A, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x00142B, "Edata Communication Inc." },
        { 0x00142C, "Koncept International, Inc." },
        { 0x00142D, "Toradex AG" },
        { 0x00142E, "77 Elektronika Kft." },
        { 0x00142F, "Savvius" },
        { 0x001430, "ViPowER, Inc" },
        { 0x001431, "PDL Electronics Ltd" },
        { 0x001432, "Tarallax Wireless, Inc." },
        { 0x001433, "Empower Technologies(Canada) Inc." },
        { 0x001434, "Keri Systems, Inc" },
        { 0x001435, "CityCom Corp." },
        { 0x001436, "Qwerty Elektronik AB" },
        { 0x001437, "GSTeletech Co.,Ltd." },
        { 0x001438, "Hewlett Packard Enterprise" },
        { 0x001439, "Blonder Tongue Laboratories, Inc" },
        { 0x00143A, "RAYTALK INTERNATIONAL SRL" },
        { 0x00143B, "Sensovation AG" },
        { 0x00143C, "Rheinmetall Canada Inc." },
        { 0x00143D, "Aevoe Inc." },
        { 0x00143E, "AirLink Communications, Inc." },
        { 0x00143F, "Hotway Technology Corporation" },
        { 0x001440, "ATOMIC Corporation" },
        { 0x001441, "Innovation Sound Technology Co., LTD." },
        { 0x001442, "ATTO CORPORATION" },
        { 0x001443, "Consultronics Europe Ltd" },
        { 0x001444, "Grundfos Holding" },
        { 0x001445, "Telefon-Gradnja d.o.o." },
        { 0x001446, "SuperVision Solutions LLC" },
        { 0x001447, "BOAZ Inc." },
        { 0x001448, "Inventec Multimedia & Telecom Corporation" },
        { 0x001449, "Sichuan Changhong Electric Ltd." },
        { 0x00144A, "Taiwan Thick-Film Ind. Corp." },
        { 0x00144B, "Hifn, Inc." },
        { 0x00144C, "General Meters Corp." },
        { 0x00144D, "Intelligent Systems" },
        { 0x00144E, "SRISA" },
        { 0x00144F, "Oracle Corporation" },
        { 0x001450, "Heim Systems GmbH" },
        { 0x001451, "Apple, Inc." },
        { 0x001452, "CALCULEX,INC." },
        { 0x001453, "ADVANTECH TECHNOLOGIES CO.,LTD" },
        { 0x001454, "Symwave" },
        { 0x001455, "Coder Electronics Corporation" },
        { 0x001456, "Edge Products" },
        { 0x001457, "T-VIPS AS" },
        { 0x001458, "HS Automatic ApS" },
        { 0x001459, "Moram Co., Ltd." },
        { 0x00145A, "Westermo Neratec AG" },
        { 0x00145B, "SeekerNet Inc." },
        { 0x00145C, "Intronics B.V." },
        { 0x00145D, "WJ Communications, Inc." },
        { 0x00145E, "IBM Corp" },
        { 0x00145F, "ADITEC CO. LTD" },
        { 0x001460, "Kyocera Wireless Corp." },
        { 0x001461, "CORONA CORPORATION" },
        { 0x001462, "Digiwell Technology, inc" },
        { 0x001463, "IDCS N.V." },
        { 0x001464, "Cryptosoft" },
        { 0x001465, "Novo Nordisk A/S" },
        { 0x001466, "Kleinhenz Elektronik GmbH" },
        { 0x001467, "ArrowSpan Inc." },
        { 0x001468, "CelPlan International, Inc." },
        { 0x001469, "Cisco Systems, Inc" },
        { 0x00146A, "Cisco Systems, Inc" },
        { 0x00146B, "Anagran, Inc." },
        { 0x00146C, "NETGEAR" },
        { 0x00146D, "RF Technologies" },
        { 0x00146E, "H. Stoll GmbH & Co. KG" },
        { 0x00146F, "Kohler Co" },
        { 0x001470, "Prokom Software SA" },
        { 0x001471, "Eastern Asia Technology Limited" },
        { 0x001472, "China Broadband Wireless IP Standard group(ChinaBWIPS)" },
        { 0x001473, "Bookham Inc" },
        { 0x001474, "K40 Electronics" },
        { 0x001475, "Wiline Networks, Inc." },
        { 0x001476, "MultiCom Industries Limited" },
        { 0x001477, "Trilliant" },
        { 0x001478, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x001479, "NEC Magnus Communications,Ltd." },
        { 0x00147A, "Eubus GmbH" },
        { 0x00147B, "Iteris, Inc." },
        { 0x00147C, "3Com Ltd" },
        { 0x00147D, "Aeon Digital International" },
        { 0x00147E, "InnerWireless" },
        { 0x00147F, "Thomson Telecom Belgium" },
        { 0x001480, "Hitachi-LG Data Storage Korea, Inc" },
        { 0x001481, "Multilink Inc" },
        { 0x001482, "Aurora Networks" },
        { 0x001483, "eXS Inc." },
        { 0x001484, "Cermate Technologies Inc." },
        { 0x001485, "Giga-Byte" },
        { 0x001486, "Echo Digital Audio Corporation" },
        { 0x001487, "American Technology Integrators" },
        { 0x001488, "Akorri" },
        { 0x001489, "B15402100 - JANDEI, S.L." },
        { 0x00148A, "Elin Ebg Traction Gmbh" },
        { 0x00148B, "Globo Electronic GmbH & Co. KG" },
        { 0x00148C, "General Dynamics Mission Systems" },
        { 0x00148D, "Cubic Defense Simulation Systems" },
        { 0x00148E, "Tele Power Inc." },
        { 0x00148F, "Protronic (Far East) Ltd." },
        { 0x001490, "ASP Corporation" },
        { 0x001491, "Daniels Electronics Ltd. dbo Codan Rado Communications" },
        { 0x001492, "Liteon, Mobile Media Solution SBU" },
        { 0x001493, "Systimax Solutions" },
        { 0x001494, "ESU AG" },
        { 0x001495, "2Wire Inc" },
        { 0x001496, "Phonic Corp." },
        { 0x001497, "ZHIYUAN Eletronics co.,ltd." },
        { 0x001498, "Viking Design Technology" },
        { 0x001499, "Helicomm Inc" },
        { 0x00149A, "ARRIS Group, Inc." },
        { 0x00149B, "Nokota Communications, LLC" },
        { 0x00149C, "HF Company" },
        { 0x00149D, "Sound ID Inc." },
        { 0x00149E, "UbONE Co., Ltd" },
        { 0x00149F, "System and Chips, Inc." },
        { 0x0014A0, "Accsense, Inc." },
        { 0x0014A1, "Synchronous Communication Corp" },
        { 0x0014A2, "Core Micro Systems Inc." },
        { 0x0014A3, "Vitelec BV" },
        { 0x0014A4, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x0014A5, "Gemtek Technology Co., Ltd." },
        { 0x0014A6, "Teranetics, Inc." },
        { 0x0014A7, "Nokia Danmark A/S" },
        { 0x0014A8, "Cisco Systems, Inc" },
        { 0x0014A9, "Cisco Systems, Inc" },
        { 0x0014AA, "Ashly Audio, Inc." },
        { 0x0014AB, "Senhai Electronic Technology Co., Ltd." },
        { 0x0014AC, "Bountiful WiFi" },
        { 0x0014AD, "Gassner Wiege- und Meßtechnik GmbH" },
        { 0x0014AE, "Wizlogics Co., Ltd." },
        { 0x0014AF, "Datasym POS Inc." },
        { 0x0014B0, "Naeil Community" },
        { 0x0014B1, "Axell Wireless Limited" },
        { 0x0014B2, "mCubelogics Corporation" },
        { 0x0014B3, "CoreStar International Corp" },
        { 0x0014B4, "General Dynamics United Kingdom Ltd" },
        { 0x0014B5, "PHYSIOMETRIX,INC" },
        { 0x0014B6, "Enswer Technology Inc." },
        { 0x0014B7, "AR Infotek Inc." },
        { 0x0014B8, "Hill-Rom" },
        { 0x0014B9, "MSTAR SEMICONDUCTOR" },
        { 0x0014BA, "Carvers SA de CV" },
        { 0x0014BB, "Open Interface North America" },
        { 0x0014BC, "SYNECTIC TELECOM EXPORTS PVT. LTD." },
        { 0x0014BD, "incNETWORKS, Inc" },
        { 0x0014BE, "Wink communication technology CO.LTD" },
        { 0x0014BF, "Cisco-Linksys, LLC" },
        { 0x0014C0, "Symstream Technology Group Ltd" },
        { 0x0014C1, "U.S. Robotics Corporation" },
        { 0x0014C2, "Hewlett Packard" },
        { 0x0014C3, "Seagate Technology" },
        { 0x0014C4, "Vitelcom Mobile Technology" },
        { 0x0014C5, "Alive Technologies Pty Ltd" },
        { 0x0014C6, "Quixant Ltd" },
        { 0x0014C7, "Nortel Networks" },
        { 0x0014C8, "Contemporary Research Corp" },
        { 0x0014C9, "Brocade Communications Systems LLC" },
        { 0x0014CA, "Key Radio Systems Limited" },
        { 0x0014CB, "LifeSync Corporation" },
        { 0x0014CC, "Zetec, Inc." },
        { 0x0014CD, "DigitalZone Co., Ltd." },
        { 0x0014CE, "NF CORPORATION" },
        { 0x0014CF, "INVISIO Communications" },
        { 0x0014D0, "BTI Systems Inc." },
        { 0x0014D1, "TRENDnet, Inc." },
        { 0x0014D2, "Kyuden Technosystems Corporation" },
        { 0x0014D3, "SEPSA" },
        { 0x0014D4, "K Technology Corporation" },
        { 0x0014D5, "Datang Telecom Technology CO. , LCD,Optical Communication Br" },
        { 0x0014D6, "Jeongmin Electronics Co.,Ltd." },
        { 0x0014D7, "Datastore Technology Corp" },
        { 0x0014D8, "bio-logic SA" },
        { 0x0014D9, "IP Fabrics, Inc." },
        { 0x0014DA, "Huntleigh Healthcare" },
        { 0x0014DB, "Elma Trenew Electronic GmbH" },
        { 0x0014DC, "Communication System Design & Manufacturing (CSDM)" },
        { 0x0014DD, "Covergence Inc." },
        { 0x0014DE, "Sage Instruments Inc." },
        { 0x0014DF, "HI-P Tech Corporation" },
        { 0x0014E0, "LET'S Corporation" },
        { 0x0014E1, "Data Display AG" },
        { 0x0014E2, "datacom systems inc." },
        { 0x0014E3, "mm-lab GmbH" },
        { 0x0014E4, "infinias, LLC" },
        { 0x0014E5, "Alticast" },
        { 0x0014E6, "AIM Infrarotmodule GmbH" },
        { 0x0014E7, "Stolinx,. Inc" },
        { 0x0014E8, "ARRIS Group, Inc." },
        { 0x0014E9, "Nortech International" },
        { 0x0014EA, "S Digm Inc. (Safe Paradigm Inc.)" },
        { 0x0014EB, "AwarePoint Corporation" },
        { 0x0014EC, "Acro Telecom" },
        { 0x0014ED, "Airak, Inc." },
        { 0x0014EE, "Western Digital Technologies, Inc." },
        { 0x0014EF, "TZero Technologies, Inc." },
        { 0x0014F0, "Business Security OL AB" },
        { 0x0014F1, "Cisco Systems, Inc" },
        { 0x0014F2, "Cisco Systems, Inc" },
        { 0x0014F3, "ViXS Systems Inc" },
        { 0x0014F4, "DekTec Digital Video B.V." },
        { 0x0014F5, "OSI Security Devices" },
        { 0x0014F6, "Juniper Networks" },
        { 0x0014F7, "CREVIS Co., LTD" },
        { 0x0014F8, "Scientific Atlanta" },
        { 0x0014F9, "Vantage Controls" },
        { 0x0014FA, "AsGa S.A." },
        { 0x0014FB, "Technical Solutions Inc." },
        { 0x0014FC, "Extandon, Inc." },
        { 0x0014FD, "Thecus Technology Corp." },
        { 0x0014FE, "Artech Electronics" },
        { 0x0014FF, "Precise Automation, Inc." },
        { 0x001500, "Intel Corporate" },
        { 0x001501, "LexBox" },
        { 0x001502, "BETA tech" },
        { 0x001503, "PROFIcomms s.r.o." },
        { 0x001504, "GAME PLUS CO., LTD." },
        { 0x001505, "Actiontec Electronics, Inc" },
        { 0x001506, "Neo Photonics" },
        { 0x001507, "Renaissance Learning Inc" },
        { 0x001508, "Global Target Enterprise Inc" },
        { 0x001509, "Plus Technology Co., Ltd" },
        { 0x00150A, "Sonoa Systems, Inc" },
        { 0x00150B, "SAGE INFOTECH LTD." },
        { 0x00150C, "AVM GmbH" },
        { 0x00150D, "Hoana Medical, Inc." },
        { 0x00150E, "OPENBRAIN TECHNOLOGIES CO., LTD." },
        { 0x00150F, "mingjong" },
        { 0x001510, "Techsphere Co., Ltd" },
        { 0x001511, "Data Center Systems" },
        { 0x001512, "Zurich University of Applied Sciences" },
        { 0x001513, "EFS sas" },
        { 0x001514, "Hu Zhou NAVA Networks&Electronics Ltd." },
        { 0x001515, "Leipold+Co.GmbH" },
        { 0x001516, "URIEL SYSTEMS INC." },
        { 0x001517, "Intel Corporate" },
        { 0x001518, "Shenzhen 10MOONS Technology Development CO.,Ltd" },
        { 0x001519, "StoreAge Networking Technologies" },
        { 0x00151A, "Hunter Engineering Company" },
        { 0x00151B, "Isilon Systems Inc." },
        { 0x00151C, "LENECO" },
        { 0x00151D, "M2I CORPORATION" },
        { 0x00151E, "ETHERNET Powerlink Standarization Group (EPSG)" },
        { 0x00151F, "Multivision Intelligent Surveillance (Hong Kong) Ltd" },
        { 0x001520, "Radiocrafts AS" },
        { 0x001521, "Horoquartz" },
        { 0x001522, "Dea Security" },
        { 0x001523, "Meteor Communications Corporation" },
        { 0x001524, "Numatics, Inc." },
        { 0x001525, "Chamberlain Access Solutions" },
        { 0x001526, "Remote Technologies Inc" },
        { 0x001527, "Balboa Instruments" },
        { 0x001528, "Beacon Medical Products LLC d.b.a. BeaconMedaes" },
        { 0x001529, "N3 Corporation" },
        { 0x00152A, "Nokia Corporation" },
        { 0x00152B, "Cisco Systems, Inc" },
        { 0x00152C, "Cisco Systems, Inc" },
        { 0x00152D, "TenX Networks, LLC" },
        { 0x00152E, "PacketHop, Inc." },
        { 0x00152F, "ARRIS Group, Inc." },
        { 0x001530, "Dell EMC" },
        { 0x001531, "KOCOM" },
        { 0x001532, "Consumer Technologies Group, LLC" },
        { 0x001533, "NADAM.CO.,LTD" },
        { 0x001534, "A Beltrónica-Companhia de Comunicações, Lda" },
        { 0x001535, "OTE Spa" },
        { 0x001536, "Powertech co.,Ltd" },
        { 0x001537, "Ventus Networks" },
        { 0x001538, "RFID, Inc." },
        { 0x001539, "Technodrive srl" },
        { 0x00153A, "Shenzhen Syscan Technology Co.,Ltd." },
        { 0x00153B, "EMH metering GmbH & Co. KG" },
        { 0x00153C, "Kprotech Co., Ltd." },
        { 0x00153D, "ELIM PRODUCT CO." },
        { 0x00153E, "Q-Matic Sweden AB" },
        { 0x00153F, "Alcatel Alenia Space Italia" },
        { 0x001540, "Nortel Networks" },
        { 0x001541, "StrataLight Communications, Inc." },
        { 0x001542, "MICROHARD S.R.L." },
        { 0x001543, "Aberdeen Test Center" },
        { 0x001544, "coM.s.a.t. AG" },
        { 0x001545, "SEECODE Co., Ltd." },
        { 0x001546, "ITG Worldwide Sdn Bhd" },
        { 0x001547, "AiZen Solutions Inc." },
        { 0x001548, "CUBE TECHNOLOGIES" },
        { 0x001549, "Dixtal Biomedica Ind. Com. Ltda" },
        { 0x00154A, "WANSHIH ELECTRONIC CO., LTD" },
        { 0x00154B, "Wonde Proud Technology Co., Ltd" },
        { 0x00154C, "Saunders Electronics" },
        { 0x00154D, "Netronome Systems, Inc." },
        { 0x00154E, "IEC" },
        { 0x00154F, "one RF Technology" },
        { 0x001550, "Nits Technology Inc" },
        { 0x001551, "RadioPulse Inc." },
        { 0x001552, "Wi-Gear Inc." },
        { 0x001553, "Cytyc Corporation" },
        { 0x001554, "Atalum Wireless S.A." },
        { 0x001555, "DFM GmbH" },
        { 0x001556, "Sagemcom Broadband SAS" },
        { 0x001557, "Olivetti" },
        { 0x001558, "FOXCONN" },
        { 0x001559, "Securaplane Technologies, Inc." },
        { 0x00155A, "DAINIPPON PHARMACEUTICAL CO., LTD." },
        { 0x00155B, "Sampo Corporation" },
        { 0x00155C, "Dresser Wayne" },
        { 0x00155D, "Microsoft Corporation" },
        { 0x00155E, "Morgan Stanley" },
        { 0x00155F, "GreenPeak Technologies" },
        { 0x001560, "Hewlett Packard" },
        { 0x001561, "JJPlus Corporation" },
        { 0x001562, "Cisco Systems, Inc" },
        { 0x001563, "Cisco Systems, Inc" },
        { 0x001564, "BEHRINGER Spezielle Studiotechnik GmbH" },
        { 0x001565, "XIAMEN YEALINK NETWORK TECHNOLOGY CO.,LTD" },
        { 0x001566, "A-First Technology Co., Ltd." },
        { 0x001567, "RADWIN Inc." },
        { 0x001568, "Dilithium Networks" },
        { 0x001569, "PECO II, Inc." },
        { 0x00156A, "DG2L Technologies Pvt. Ltd." },
        { 0x00156B, "Perfisans Networks Corp." },
        { 0x00156C, "SANE SYSTEM CO., LTD" },
        { 0x00156D, "Ubiquiti Networks Inc." },
        { 0x00156E, "A. W. Communication Systems Ltd" },
        { 0x00156F, "Xiranet Communications GmbH" },
        { 0x001570, "Zebra Technologies Inc" },
        { 0x001571, "Nolan Systems" },
        { 0x001572, "Red-Lemon" },
        { 0x001573, "NewSoft Technology Corporation" },
        { 0x001574, "Horizon Semiconductors Ltd." },
        { 0x001575, "Nevis Networks Inc." },
        { 0x001576, "LABiTec - Labor Biomedical Technologies GmbH" },
        { 0x001577, "Allied Telesis, Inc." },
        { 0x001578, "Audio / Video Innovations" },
        { 0x001579, "Lunatone Industrielle Elektronik GmbH" },
        { 0x00157A, "Telefin S.p.A." },
        { 0x00157B, "Leuze electronic GmbH + Co. KG" },
        { 0x00157C, "Dave Networks, Inc." },
        { 0x00157D, "POSDATA" },
        { 0x00157E, "Weidmüller Interface GmbH & Co. KG" },
        { 0x00157F, "ChuanG International Holding CO.,LTD." },
        { 0x001580, "U-WAY CORPORATION" },
        { 0x001581, "MAKUS Inc." },
        { 0x001582, "Pulse Eight Limited" },
        { 0x001583, "IVT corporation" },
        { 0x001584, "Schenck Process GmbH" },
        { 0x001585, "Aonvision Technolopy Corp." },
        { 0x001586, "Xiamen Overseas Chinese Electronic Co., Ltd." },
        { 0x001587, "Takenaka Seisakusho Co.,Ltd" },
        { 0x001588, "Salutica Allied Solutions Sdn Bhd" },
        { 0x001589, "D-MAX Technology Co.,Ltd" },
        { 0x00158A, "SURECOM Technology Corp." },
        { 0x00158B, "Park Air Systems Ltd" },
        { 0x00158C, "Liab ApS" },
        { 0x00158D, "Jennic Ltd" },
        { 0x00158E, "Plustek.INC" },
        { 0x00158F, "NTT Advanced Technology Corporation" },
        { 0x001590, "Hectronic GmbH" },
        { 0x001591, "RLW Inc." },
        { 0x001592, "Facom UK Ltd (Melksham)" },
        { 0x001593, "U4EA Technologies Inc." },
        { 0x001594, "BIXOLON CO.,LTD" },
        { 0x001595, "Quester Tangent Corporation" },
        { 0x001596, "ARRIS Group, Inc." },
        { 0x001597, "AETA AUDIO SYSTEMS" },
        { 0x001598, "Kolektor group" },
        { 0x001599, "Samsung Electronics Co.,Ltd" },
        { 0x00159A, "ARRIS Group, Inc." },
        { 0x00159B, "Nortel Networks" },
        { 0x00159C, "B-KYUNG SYSTEM Co.,Ltd." },
        { 0x00159D, "Tripp Lite" },
        { 0x00159E, "Mad Catz Interactive Inc" },
        { 0x00159F, "Terascala, Inc." },
        { 0x0015A0, "Nokia Danmark A/S" },
        { 0x0015A1, "ECA-SINTERS" },
        { 0x0015A2, "ARRIS Group, Inc." },
        { 0x0015A3, "ARRIS Group, Inc." },
        { 0x0015A4, "ARRIS Group, Inc." },
        { 0x0015A5, "DCI Co., Ltd." },
        { 0x0015A6, "Digital Electronics Products Ltd." },
        { 0x0015A7, "Robatech AG" },
        { 0x0015A8, "ARRIS Group, Inc." },
        { 0x0015A9, "KWANG WOO I&C CO.,LTD" },
        { 0x0015AA, "Rextechnik International Co.," },
        { 0x0015AB, "PRO CO SOUND INC" },
        { 0x0015AC, "Capelon AB" },
        { 0x0015AD, "Accedian Networks" },
        { 0x0015AE, "kyung il" },
        { 0x0015AF, "AzureWave Technology Inc." },
        { 0x0015B0, "AUTOTELENET CO.,LTD" },
        { 0x0015B1, "Ambient Corporation" },
        { 0x0015B2, "Advanced Industrial Computer, Inc." },
        { 0x0015B3, "Caretech AB" },
        { 0x0015B4, "Polymap Wireless LLC" },
        { 0x0015B5, "CI Network Corp." },
        { 0x0015B6, "ShinMaywa Industries, Ltd." },
        { 0x0015B7, "Toshiba" },
        { 0x0015B8, "Tahoe" },
        { 0x0015B9, "Samsung Electronics Co.,Ltd" },
        { 0x0015BA, "iba AG" },
        { 0x0015BB, "SMA Solar Technology AG" },
        { 0x0015BC, "Develco" },
        { 0x0015BD, "Group 4 Technology Ltd" },
        { 0x0015BE, "Iqua Ltd." },
        { 0x0015BF, "technicob" },
        { 0x0015C0, "DIGITAL TELEMEDIA CO.,LTD." },
        { 0x0015C1, "Sony Interactive Entertainment Inc." },
        { 0x0015C2, "3M Germany" },
        { 0x0015C3, "Ruf Telematik AG" },
        { 0x0015C4, "FLOVEL CO., LTD." },
        { 0x0015C5, "Dell Inc." },
        { 0x0015C6, "Cisco Systems, Inc" },
        { 0x0015C7, "Cisco Systems, Inc" },
        { 0x0015C8, "FlexiPanel Ltd" },
        { 0x0015C9, "Gumstix, Inc" },
        { 0x0015CA, "TeraRecon, Inc." },
        { 0x0015CB, "Surf Communication Solutions Ltd." },
        { 0x0015CC, "UQUEST, LTD." },
        { 0x0015CD, "Exartech International Corp." },
        { 0x0015CE, "ARRIS Group, Inc." },
        { 0x0015CF, "ARRIS Group, Inc." },
        { 0x0015D0, "ARRIS Group, Inc." },
        { 0x0015D1, "ARRIS Group, Inc." },
        { 0x0015D2, "Xantech Corporation" },
        { 0x0015D3, "Pantech&Curitel Communications, Inc." },
        { 0x0015D4, "Emitor AB" },
        { 0x0015D5, "NICEVT" },
        { 0x0015D6, "OSLiNK Sp. z o.o." },
        { 0x0015D7, "Reti Corporation" },
        { 0x0015D8, "Interlink Electronics" },
        { 0x0015D9, "PKC Electronics Oy" },
        { 0x0015DA, "IRITEL A.D." },
        { 0x0015DB, "Canesta Inc." },
        { 0x0015DC, "KT&C Co., Ltd." },
        { 0x0015DD, "IP Control Systems Ltd." },
        { 0x0015DE, "Nokia Danmark A/S" },
        { 0x0015DF, "Clivet S.p.A." },
        { 0x0015E0, "Ericsson" },
        { 0x0015E1, "Picochip Ltd" },
        { 0x0015E2, "Dr.Ing. Herbert Knauer GmbH" },
        { 0x0015E3, "Dream Technologies Corporation" },
        { 0x0015E4, "Zimmer Elektromedizin" },
        { 0x0015E5, "Cheertek Inc." },
        { 0x0015E6, "MOBILE TECHNIKA Inc." },
        { 0x0015E7, "Quantec Tontechnik" },
        { 0x0015E8, "Nortel Networks" },
        { 0x0015E9, "D-Link Corporation" },
        { 0x0015EA, "Tellumat (Pty) Ltd" },
        { 0x0015EB, "zte corporation" },
        { 0x0015EC, "Boca Devices LLC" },
        { 0x0015ED, "Fulcrum Microsystems, Inc." },
        { 0x0015EE, "Omnex Control Systems" },
        { 0x0015EF, "NEC TOKIN Corporation" },
        { 0x0015F0, "EGO BV" },
        { 0x0015F1, "KYLINK Communications Corp." },
        { 0x0015F2, "ASUSTek COMPUTER INC." },
        { 0x0015F3, "PELTOR AB" },
        { 0x0015F4, "Eventide" },
        { 0x0015F5, "Sustainable Energy Systems" },
        { 0x0015F6, "SCIENCE AND ENGINEERING SERVICES, INC." },
        { 0x0015F7, "Wintecronics Ltd." },
        { 0x0015F8, "Kingtronics Industrial Co. Ltd." },
        { 0x0015F9, "Cisco Systems, Inc" },
        { 0x0015FA, "Cisco Systems, Inc" },
        { 0x0015FB, "setex schermuly textile computer gmbh" },
        { 0x0015FC, "Littelfuse Startco" },
        { 0x0015FD, "Complete Media Systems" },
        { 0x0015FE, "SCHILLING ROBOTICS LLC" },
        { 0x0015FF, "Novatel Wireless Solutions, Inc." },
        { 0x001600, "CelleBrite Mobile Synchronization" },
        { 0x001601, "BUFFALO.INC" },
        { 0x001602, "CEYON TECHNOLOGY CO.,LTD." },
        { 0x001603, "COOLKSKY Co., LTD" },
        { 0x001604, "Sigpro" },
        { 0x001605, "YORKVILLE SOUND INC." },
        { 0x001606, "Ideal Industries" },
        { 0x001607, "Curves International Inc." },
        { 0x001608, "Sequans Communications" },
        { 0x001609, "Unitech electronics co., ltd." },
        { 0x00160A, "SWEEX Europe BV" },
        { 0x00160B, "TVWorks LLC" },
        { 0x00160C, "LPL DEVELOPMENT S.A. DE C.V" },
        { 0x00160D, "Be Here Corporation" },
        { 0x00160E, "Optica Technologies Inc." },
        { 0x00160F, "BADGER METER INC" },
        { 0x001610, "Carina Technology" },
        { 0x001611, "Altecon Srl" },
        { 0x001612, "Otsuka Electronics Co., Ltd." },
        { 0x001613, "LibreStream Technologies Inc." },
        { 0x001614, "Picosecond Pulse Labs" },
        { 0x001615, "Nittan Company, Limited" },
        { 0x001616, "BROWAN COMMUNICATION INC." },
        { 0x001617, "MSI" },
        { 0x001618, "HIVION Co., Ltd." },
        { 0x001619, "Lancelan Technologies S.L." },
        { 0x00161A, "Dametric AB" },
        { 0x00161B, "Micronet Corporation" },
        { 0x00161C, "e:cue" },
        { 0x00161D, "Innovative Wireless Technologies, Inc." },
        { 0x00161E, "Woojinnet" },
        { 0x00161F, "SUNWAVETEC Co., Ltd." },
        { 0x001620, "Sony Mobile Communications Inc" },
        { 0x001621, "Colorado Vnet" },
        { 0x001622, "BBH SYSTEMS GMBH" },
        { 0x001623, "Interval Media" },
        { 0x001624, "Teneros, Inc." },
        { 0x001625, "Impinj, Inc." },
        { 0x001626, "ARRIS Group, Inc." },
        { 0x001627, "embedded-logic DESIGN AND MORE GmbH" },
        { 0x001628, "Magicard Ltd" },
        { 0x001629, "Nivus GmbH" },
        { 0x00162A, "Antik computers & communications s.r.o." },
        { 0x00162B, "Togami Electric Mfg.co.,Ltd." },
        { 0x00162C, "Xanboo" },
        { 0x00162D, "STNet Co., Ltd." },
        { 0x00162E, "Space Shuttle Hi-Tech Co., Ltd." },
        { 0x00162F, "Geutebrück GmbH" },
        { 0x001630, "Vativ Technologies" },
        { 0x001631, "Xteam" },
        { 0x001632, "Samsung Electronics Co.,Ltd" },
        { 0x001633, "Oxford Diagnostics Ltd." },
        { 0x001634, "Mathtech, Inc." },
        { 0x001635, "Hewlett Packard" },
        { 0x001636, "Quanta Computer Inc." },
        { 0x001637, "CITEL SpA" },
        { 0x001638, "TECOM Co., Ltd." },
        { 0x001639, "Ubiquam Co., Ltd." },
        { 0x00163A, "YVES TECHNOLOGY CO., LTD." },
        { 0x00163B, "Communications & Power Industries" },
        { 0x00163C, "Rebox B.V." },
        { 0x00163D, "Tsinghua Tongfang Legend Silicon Tech. Co., Ltd." },
        { 0x00163E, "Xensource, Inc." },
        { 0x00163F, "CReTE SYSTEMS Inc." },
        { 0x001640, "Asmobile Communication Inc." },
        { 0x001641, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x001642, "Pangolin" },
        { 0x001643, "Sunhillo Corporation" },
        { 0x001644, "LITE-ON Technology Corp." },
        { 0x001645, "Power Distribution, Inc." },
        { 0x001646, "Cisco Systems, Inc" },
        { 0x001647, "Cisco Systems, Inc" },
        { 0x001648, "SSD Company Limited" },
        { 0x001649, "SetOne GmbH" },
        { 0x00164A, "Vibration Technology Limited" },
        { 0x00164B, "Quorion Data Systems GmbH" },
        { 0x00164C, "PLANET INT Co., Ltd" },
        { 0x00164D, "Alcatel-Lucent IPD" },
        { 0x00164E, "Nokia Danmark A/S" },
        { 0x00164F, "World Ethnic Broadcastin Inc." },
        { 0x001650, "Kratos EPD" },
        { 0x001651, "Exeo Systems" },
        { 0x001652, "Hoatech Technologies, Inc." },
        { 0x001653, "LEGO System A/S IE Electronics Division" },
        { 0x001654, "Flex-P Industries Sdn. Bhd." },
        { 0x001655, "FUHO TECHNOLOGY Co., LTD" },
        { 0x001656, "Nintendo Co., Ltd." },
        { 0x001657, "Aegate Ltd" },
        { 0x001658, "Fusiontech Technologies Inc." },
        { 0x001659, "Z.M.P. RADWAG" },
        { 0x00165A, "Harman Specialty Group" },
        { 0x00165B, "Grip Audio" },
        { 0x00165C, "Trackflow Ltd." },
        { 0x00165D, "AirDefense, Inc." },
        { 0x00165E, "Precision I/O" },
        { 0x00165F, "Fairmount Automation" },
        { 0x001660, "Nortel Networks" },
        { 0x001661, "Novatium Solutions (P) Ltd" },
        { 0x001662, "Liyuh Technology Ltd." },
        { 0x001663, "KBT Mobile" },
        { 0x001664, "Prod-El SpA" },
        { 0x001665, "Cellon France" },
        { 0x001666, "Quantier Communication Inc." },
        { 0x001667, "A-TEC Subsystem INC." },
        { 0x001668, "Eishin Electronics" },
        { 0x001669, "MRV Communication (Networks) LTD" },
        { 0x00166A, "TPS" },
        { 0x00166B, "Samsung Electronics Co.,Ltd" },
        { 0x00166C, "Samsung Electronics Co.,Ltd" },
        { 0x00166D, "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd" },
        { 0x00166E, "Arbitron Inc." },
        { 0x00166F, "Intel Corporate" },
        { 0x001670, "SKNET Corporation" },
        { 0x001671, "Symphox Information Co." },
        { 0x001672, "Zenway enterprise ltd" },
        { 0x001673, "Bury GmbH & Co. KG" },
        { 0x001674, "EuroCB (Phils.), Inc." },
        { 0x001675, "ARRIS Group, Inc." },
        { 0x001676, "Intel Corporate" },
        { 0x001677, "Bihl + Wiedemann GmbH" },
        { 0x001678, "SHENZHEN BAOAN GAOKE ELECTRONICS CO., LTD" },
        { 0x001679, "eOn Communications" },
        { 0x00167A, "Skyworth Overseas Development Ltd." },
        { 0x00167B, "Haver&Boecker" },
        { 0x00167C, "iRex Technologies BV" },
        { 0x00167D, "Sky-Line Information Co., Ltd." },
        { 0x00167E, "DIBOSS.CO.,LTD" },
        { 0x00167F, "Bluebird Soft Inc." },
        { 0x001680, "Bally Gaming + Systems" },
        { 0x001681, "Vector Informatik GmbH" },
        { 0x001682, "Pro Dex, Inc" },
        { 0x001683, "WEBIO International Co.,.Ltd." },
        { 0x001684, "Donjin Co.,Ltd." },
        { 0x001685, "Elisa Oyj" },
        { 0x001686, "Karl Storz Imaging" },
        { 0x001687, "Chubb CSC-Vendor AP" },
        { 0x001688, "ServerEngines LLC" },
        { 0x001689, "Pilkor Electronics Co., Ltd" },
        { 0x00168A, "id-Confirm Inc" },
        { 0x00168B, "Paralan Corporation" },
        { 0x00168C, "DSL Partner AS" },
        { 0x00168D, "KORWIN CO., Ltd." },
        { 0x00168E, "Vimicro corporation" },
        { 0x00168F, "GN Netcom A/S" },
        { 0x001690, "J-TEK INCORPORATION" },
        { 0x001691, "Moser-Baer AG" },
        { 0x001692, "Scientific-Atlanta, Inc." },
        { 0x001693, "PowerLink Technology Inc." },
        { 0x001694, "Sennheiser Communications A/S" },
        { 0x001695, "AVC Technology (International) Limited" },
        { 0x001696, "QDI Technology (H.K.) Limited" },
        { 0x001697, "NEC Corporation" },
        { 0x001698, "T&A Mobile Phones" },
        { 0x001699, "Tonic DVB Marketing Ltd" },
        { 0x00169A, "Quadrics Ltd" },
        { 0x00169B, "Alstom Transport" },
        { 0x00169C, "Cisco Systems, Inc" },
        { 0x00169D, "Cisco Systems, Inc" },
        { 0x00169E, "TV One Ltd" },
        { 0x00169F, "Vimtron Electronics Co., Ltd." },
        { 0x0016A0, "Auto-Maskin" },
        { 0x0016A1, "3Leaf Networks" },
        { 0x0016A2, "CentraLite Systems, Inc." },
        { 0x0016A3, "Ingeteam Transmission&Distribution, S.A." },
        { 0x0016A4, "Ezurio Ltd" },
        { 0x0016A5, "Tandberg Storage ASA" },
        { 0x0016A6, "Dovado FZ-LLC" },
        { 0x0016A7, "AWETA G&P" },
        { 0x0016A8, "CWT CO., LTD." },
        { 0x0016A9, "2EI" },
        { 0x0016AA, "Kei Communication Technology Inc." },
        { 0x0016AB, "Dansensor A/S" },
        { 0x0016AC, "Toho Technology Corp." },
        { 0x0016AD, "BT-Links Company Limited" },
        { 0x0016AE, "INVENTEL" },
        { 0x0016AF, "Shenzhen Union Networks Equipment Co.,Ltd." },
        { 0x0016B0, "VK Corporation" },
        { 0x0016B1, "KBS" },
        { 0x0016B2, "DriveCam Inc" },
        { 0x0016B3, "Photonicbridges (China) Co., Ltd." },
        { 0x0016B4, "Private" },
        { 0x0016B5, "ARRIS Group, Inc." },
        { 0x0016B6, "Cisco-Linksys, LLC" },
        { 0x0016B7, "Seoul Commtech" },
        { 0x0016B8, "Sony Mobile Communications Inc" },
        { 0x0016B9, "ProCurve Networking by HP" },
        { 0x0016BA, "WEATHERNEWS INC." },
        { 0x0016BB, "Law-Chain Computer Technology Co Ltd" },
        { 0x0016BC, "Nokia Danmark A/S" },
        { 0x0016BD, "ATI Industrial Automation" },
        { 0x0016BE, "INFRANET, Inc." },
        { 0x0016BF, "PaloDEx Group Oy" },
        { 0x0016C0, "Semtech Corporation" },
        { 0x0016C1, "Eleksen Ltd" },
        { 0x0016C2, "Avtec Systems Inc" },
        { 0x0016C3, "BA Systems Inc" },
        { 0x0016C4, "SiRF Technology, Inc." },
        { 0x0016C5, "Shenzhen Xing Feng Industry Co.,Ltd" },
        { 0x0016C6, "North Atlantic Industries" },
        { 0x0016C7, "Cisco Systems, Inc" },
        { 0x0016C8, "Cisco Systems, Inc" },
        { 0x0016C9, "NAT Seattle, Inc." },
        { 0x0016CA, "Nortel Networks" },
        { 0x0016CB, "Apple, Inc." },
        { 0x0016CC, "Xcute Mobile Corp." },
        { 0x0016CD, "HIJI HIGH-TECH CO., LTD." },
        { 0x0016CE, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x0016CF, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x0016D0, "ATech elektronika d.o.o." },
        { 0x0016D1, "ZAT a.s." },
        { 0x0016D2, "Caspian" },
        { 0x0016D3, "Wistron Corporation" },
        { 0x0016D4, "Compal Communications, Inc." },
        { 0x0016D5, "Synccom Co., Ltd" },
        { 0x0016D6, "TDA Tech Pty Ltd" },
        { 0x0016D7, "Sunways AG" },
        { 0x0016D8, "Senea AB" },
        { 0x0016D9, "NINGBO BIRD CO.,LTD." },
        { 0x0016DA, "Futronic Technology Co. Ltd." },
        { 0x0016DB, "Samsung Electronics Co.,Ltd" },
        { 0x0016DC, "ARCHOS" },
        { 0x0016DD, "Gigabeam Corporation" },
        { 0x0016DE, "FAST Inc" },
        { 0x0016DF, "Lundinova AB" },
        { 0x0016E0, "3Com Ltd" },
        { 0x0016E1, "SiliconStor, Inc." },
        { 0x0016E2, "American Fibertek, Inc." },
        { 0x0016E3, "ASKEY COMPUTER CORP" },
        { 0x0016E4, "VANGUARD SECURITY ENGINEERING CORP." },
        { 0x0016E5, "FORDLEY DEVELOPMENT LIMITED" },
        { 0x0016E6, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x0016E7, "Dynamix Promotions Limited" },
        { 0x0016E8, "Sigma Designs, Inc." },
        { 0x0016E9, "Tiba Medical Inc" },
        { 0x0016EA, "Intel Corporate" },
        { 0x0016EB, "Intel Corporate" },
        { 0x0016EC, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x0016ED, "Utility, Inc" },
        { 0x0016EE, "Royaldigital Inc." },
        { 0x0016EF, "Koko Fitness, Inc." },
        { 0x0016F0, "Dell" },
        { 0x0016F1, "OmniSense, LLC" },
        { 0x0016F2, "Dmobile System Co., Ltd." },
        { 0x0016F3, "CAST Information Co., Ltd" },
        { 0x0016F4, "Eidicom Co., Ltd." },
        { 0x0016F5, "Dalian Golden Hualu Digital Technology Co.,Ltd" },
        { 0x0016F6, "Video Products Group" },
        { 0x0016F7, "L-3 Communications, Aviation Recorders" },
        { 0x0016F8, "AVIQTECH TECHNOLOGY CO., LTD." },
        { 0x0016F9, "CETRTA POT, d.o.o., Kranj" },
        { 0x0016FA, "ECI Telecom Ltd." },
        { 0x0016FB, "SHENZHEN MTC CO LTD" },
        { 0x0016FC, "TOHKEN CO.,LTD." },
        { 0x0016FD, "Jaty Electronics" },
        { 0x0016FE, "ALPS ELECTRIC CO., LTD." },
        { 0x0016FF, "Wamin Optocomm Mfg Corp" },
        { 0x001700, "ARRIS Group, Inc." },
        { 0x001701, "KDE, Inc." },
        { 0x001702, "Osung Midicom Co., Ltd" },
        { 0x001703, "MOSDAN Internation Co.,Ltd" },
        { 0x001704, "Shinco Electronics Group Co.,Ltd" },
        { 0x001705, "Methode Electronics" },
        { 0x001706, "Techfaithwireless Communication Technology Limited." },
        { 0x001707, "InGrid, Inc" },
        { 0x001708, "Hewlett Packard" },
        { 0x001709, "Exalt Communications" },
        { 0x00170A, "INEW DIGITAL COMPANY" },
        { 0x00170B, "Contela, Inc." },
        { 0x00170C, "Twig Com Ltd." },
        { 0x00170D, "Dust Networks Inc." },
        { 0x00170E, "Cisco Systems, Inc" },
        { 0x00170F, "Cisco Systems, Inc" },
        { 0x001710, "Casa Systems Inc." },
        { 0x001711, "Cytiva Sweden AB" },
        { 0x001712, "ISCO International" },
        { 0x001713, "Tiger NetCom" },
        { 0x001714, "BR Controls Nederland bv" },
        { 0x001715, "Qstik" },
        { 0x001716, "Qno Technology Inc." },
        { 0x001717, "Leica Geosystems AG" },
        { 0x001718, "Vansco Electronics Oy" },
        { 0x001719, "Audiocodes USA, Inc" },
        { 0x00171A, "Winegard Company" },
        { 0x00171B, "Innovation Lab Corp." },
        { 0x00171C, "NT MicroSystems, Inc." },
        { 0x00171D, "DIGIT" },
        { 0x00171E, "Theo Benning GmbH & Co. KG" },
        { 0x00171F, "IMV Corporation" },
        { 0x001720, "Image Sensing Systems, Inc." },
        { 0x001721, "FITRE S.p.A." },
        { 0x001722, "Hanazeder Electronic GmbH" },
        { 0x001723, "Summit Data Communications" },
        { 0x001724, "Studer Professional Audio GmbH" },
        { 0x001725, "Liquid Computing" },
        { 0x001726, "m2c Electronic Technology Ltd." },
        { 0x001727, "Thermo Ramsey Italia s.r.l." },
        { 0x001728, "Selex Communications" },
        { 0x001729, "Ubicod Co.LTD" },
        { 0x00172A, "Proware Technology Corp.(By Unifosa)" },
        { 0x00172B, "Global Technologies Inc." },
        { 0x00172C, "TAEJIN INFOTECH" },
        { 0x00172D, "Axcen Photonics Corporation" },
        { 0x00172E, "FXC Inc." },
        { 0x00172F, "NeuLion Incorporated" },
        { 0x001730, "Automation Electronics" },
        { 0x001731, "ASUSTek COMPUTER INC." },
        { 0x001732, "Science-Technical Center RISSA" },
        { 0x001733, "SFR" },
        { 0x001734, "ADC Telecommunications" },
        { 0x001735, "Intel Wireless Network Group" },
        { 0x001736, "iiTron Inc." },
        { 0x001737, "Industrie Dial Face S.p.A." },
        { 0x001738, "International Business Machines" },
        { 0x001739, "Bright Headphone Electronics Company" },
        { 0x00173A, "Cloudastructure Inc" },
        { 0x00173B, "Cisco Systems, Inc" },
        { 0x00173C, "Extreme Engineering Solutions" },
        { 0x00173D, "Neology" },
        { 0x00173E, "LeucotronEquipamentos Ltda." },
        { 0x00173F, "Belkin International Inc." },
        { 0x001740, "Bluberi Gaming Technologies Inc" },
        { 0x001741, "DEFIDEV" },
        { 0x001742, "FUJITSU LIMITED" },
        { 0x001743, "Deck Srl" },
        { 0x001744, "Araneo Ltd." },
        { 0x001745, "INNOTZ CO., Ltd" },
        { 0x001746, "Freedom9 Inc." },
        { 0x001747, "Trimble" },
        { 0x001748, "Neokoros Brasil Ltda" },
        { 0x001749, "HYUNDAE YONG-O-SA CO.,LTD" },
        { 0x00174A, "SOCOMEC" },
        { 0x00174B, "Nokia Danmark A/S" },
        { 0x00174C, "Millipore" },
        { 0x00174D, "DYNAMIC NETWORK FACTORY, INC." },
        { 0x00174E, "Parama-tech Co.,Ltd." },
        { 0x00174F, "iCatch Inc." },
        { 0x001750, "GSI Group, MicroE Systems" },
        { 0x001751, "Online Corporation" },
        { 0x001752, "DAGS, Inc" },
        { 0x001753, "nFore Technology Inc." },
        { 0x001754, "Arkino HiTOP Corporation Limited" },
        { 0x001755, "GE Security" },
        { 0x001756, "Vinci Labs Oy" },
        { 0x001757, "RIX TECHNOLOGY LIMITED" },
        { 0x001758, "ThruVision Ltd" },
        { 0x001759, "Cisco Systems, Inc" },
        { 0x00175A, "Cisco Systems, Inc" },
        { 0x00175B, "ACS Solutions Switzerland Ltd." },
        { 0x00175C, "SHARP CORPORATION" },
        { 0x00175D, "Dongseo system." },
        { 0x00175E, "Zed-3" },
        { 0x00175F, "XENOLINK Communications Co., Ltd." },
        { 0x001760, "Naito Densei Machida MFG.CO.,LTD" },
        { 0x001761, "Private" },
        { 0x001762, "Solar Technology, Inc." },
        { 0x001763, "Essentia S.p.A." },
        { 0x001764, "ATMedia GmbH" },
        { 0x001765, "Nortel Networks" },
        { 0x001766, "Accense Technology, Inc." },
        { 0x001767, "Earforce AS" },
        { 0x001768, "Zinwave Ltd" },
        { 0x001769, "Cymphonix Corp" },
        { 0x00176A, "Avago Technologies" },
        { 0x00176B, "Kiyon, Inc." },
        { 0x00176C, "Pivot3, Inc." },
        { 0x00176D, "CORE CORPORATION" },
        { 0x00176E, "DUCATI SISTEMI" },
        { 0x00176F, "PAX Computer Technology(Shenzhen) Ltd." },
        { 0x001770, "Arti Industrial Electronics Ltd." },
        { 0x001771, "APD Communications Ltd" },
        { 0x001772, "ASTRO Strobel Kommunikationssysteme GmbH" },
        { 0x001773, "Laketune Technologies Co. Ltd" },
        { 0x001774, "Elesta GmbH" },
        { 0x001775, "TTE Germany GmbH" },
        { 0x001776, "Meso Scale Diagnostics, LLC" },
        { 0x001777, "Obsidian Research Corporation" },
        { 0x001778, "Central Music Co." },
        { 0x001779, "QuickTel" },
        { 0x00177A, "ASSA ABLOY AB" },
        { 0x00177B, "Azalea Networks inc" },
        { 0x00177C, "Smartlink Network Systems Limited" },
        { 0x00177D, "IDT Technology Limited" },
        { 0x00177E, "Meshcom Technologies Inc." },
        { 0x00177F, "Worldsmart Retech" },
        { 0x001780, "Applied Biosystems B.V." },
        { 0x001781, "Greystone Data System, Inc." },
        { 0x001782, "LoBenn Inc." },
        { 0x001783, "Texas Instruments" },
        { 0x001784, "ARRIS Group, Inc." },
        { 0x001785, "Sparr Electronics Ltd" },
        { 0x001786, "wisembed" },
        { 0x001787, "Brother, Brother & Sons ApS" },
        { 0x001788, "Philips Lighting BV" },
        { 0x001789, "Zenitron Corporation" },
        { 0x00178A, "DARTS TECHNOLOGIES CORP." },
        { 0x00178B, "Teledyne Technologies Incorporated" },
        { 0x00178C, "Independent Witness, Inc" },
        { 0x00178D, "Checkpoint Systems, Inc." },
        { 0x00178E, "Gunnebo Cash Automation AB" },
        { 0x00178F, "NINGBO YIDONG ELECTRONIC CO.,LTD." },
        { 0x001790, "HYUNDAI DIGITECH Co, Ltd." },
        { 0x001791, "LinTech GmbH" },
        { 0x001792, "Falcom Wireless Comunications Gmbh" },
        { 0x001793, "Tigi Corporation" },
        { 0x001794, "Cisco Systems, Inc" },
        { 0x001795, "Cisco Systems, Inc" },
        { 0x001796, "Rittmeyer AG" },
        { 0x001797, "Telsy Elettronica S.p.A." },
        { 0x001798, "Azonic Technology Co., LTD" },
        { 0x001799, "SmarTire Systems Inc." },
        { 0x00179A, "D-Link Corporation" },
        { 0x00179B, "CHANT SINCERE CO.,LTD" },
        { 0x00179C, "DEPRAG SCHULZ GMBH u. CO." },
        { 0x00179D, "Kelman Limited" },
        { 0x00179E, "Sirit Inc" },
        { 0x00179F, "Apricorn" },
        { 0x0017A0, "RoboTech srl" },
        { 0x0017A1, "3soft inc." },
        { 0x0017A2, "Camrivox Ltd." },
        { 0x0017A3, "MIX s.r.l." },
        { 0x0017A4, "Hewlett Packard" },
        { 0x0017A5, "Ralink Technology Corp" },
        { 0x0017A6, "YOSIN ELECTRONICS CO., LTD." },
        { 0x0017A7, "Mobile Computing Promotion Consortium" },
        { 0x0017A8, "EDM Corporation" },
        { 0x0017A9, "Sentivision" },
        { 0x0017AA, "elab-experience inc." },
        { 0x0017AB, "Nintendo Co., Ltd." },
        { 0x0017AC, "O'Neil Product Development Inc." },
        { 0x0017AD, "AceNet Corporation" },
        { 0x0017AE, "GAI-Tronics" },
        { 0x0017AF, "Enermet" },
        { 0x0017B0, "Nokia Danmark A/S" },
        { 0x0017B1, "ACIST Medical Systems, Inc." },
        { 0x0017B2, "SK Telesys" },
        { 0x0017B3, "Aftek Infosys Limited" },
        { 0x0017B4, "Remote Security Systems, LLC" },
        { 0x0017B5, "Peerless Systems Corporation" },
        { 0x0017B6, "Aquantia Corporation" },
        { 0x0017B7, "Tonze Technology Co." },
        { 0x0017B8, "NOVATRON CO., LTD." },
        { 0x0017B9, "Gambro Lundia AB" },
        { 0x0017BA, "SEDO CO., LTD." },
        { 0x0017BB, "Syrinx Industrial Electronics" },
        { 0x0017BC, "Touchtunes Music Corporation" },
        { 0x0017BD, "Tibetsystem" },
        { 0x0017BE, "Tratec Telecom B.V." },
        { 0x0017BF, "Coherent Research Limited" },
        { 0x0017C0, "PureTech Systems, Inc." },
        { 0x0017C1, "CM Precision Technology LTD." },
        { 0x0017C2, "ADB Broadband Italia" },
        { 0x0017C3, "KTF Technologies Inc." },
        { 0x0017C4, "Quanta Microsystems, INC." },
        { 0x0017C5, "SonicWALL" },
        { 0x0017C6, "Cross Match Technologies Inc" },
        { 0x0017C7, "MARA Systems Consulting AB" },
        { 0x0017C8, "KYOCERA Display Corporation" },
        { 0x0017C9, "Samsung Electronics Co.,Ltd" },
        { 0x0017CA, "Qisda Corporation" },
        { 0x0017CB, "Juniper Networks" },
        { 0x0017CC, "Alcatel-Lucent" },
        { 0x0017CD, "CEC Wireless R&D Ltd." },
        { 0x0017CE, "Screen Service Spa" },
        { 0x0017CF, "iMCA-GmbH" },
        { 0x0017D0, "Opticom Communications, LLC" },
        { 0x0017D1, "Nortel Networks" },
        { 0x0017D2, "THINLINX PTY LTD" },
        { 0x0017D3, "Etymotic Research, Inc." },
        { 0x0017D4, "Monsoon Multimedia, Inc" },
        { 0x0017D5, "Samsung Electronics Co.,Ltd" },
        { 0x0017D6, "Bluechips Microhouse Co.,Ltd." },
        { 0x0017D7, "ION Geophysical Corporation Inc." },
        { 0x0017D8, "Magnum Semiconductor, Inc." },
        { 0x0017D9, "AAI Corporation" },
        { 0x0017DA, "Spans Logic" },
        { 0x0017DB, "CANKO TECHNOLOGIES INC." },
        { 0x0017DC, "DAEMYUNG ZERO1" },
        { 0x0017DD, "Clipsal Australia" },
        { 0x0017DE, "Advantage Six Ltd" },
        { 0x0017DF, "Cisco Systems, Inc" },
        { 0x0017E0, "Cisco Systems, Inc" },
        { 0x0017E1, "DACOS Technologies Co., Ltd." },
        { 0x0017E2, "ARRIS Group, Inc." },
        { 0x0017E3, "Texas Instruments" },
        { 0x0017E4, "Texas Instruments" },
        { 0x0017E5, "Texas Instruments" },
        { 0x0017E6, "Texas Instruments" },
        { 0x0017E7, "Texas Instruments" },
        { 0x0017E8, "Texas Instruments" },
        { 0x0017E9, "Texas Instruments" },
        { 0x0017EA, "Texas Instruments" },
        { 0x0017EB, "Texas Instruments" },
        { 0x0017EC, "Texas Instruments" },
        { 0x0017ED, "WooJooIT Ltd." },
        { 0x0017EE, "ARRIS Group, Inc." },
        { 0x0017EF, "IBM Corp" },
        { 0x0017F0, "SZCOM Broadband Network Technology Co.,Ltd" },
        { 0x0017F1, "Renu Electronics Pvt Ltd" },
        { 0x0017F2, "Apple, Inc." },
        { 0x0017F3, "Harris Corporation" },
        { 0x0017F4, "ZERON ALLIANCE" },
        { 0x0017F5, "LIG NEOPTEK" },
        { 0x0017F6, "Pyramid Meriden Inc." },
        { 0x0017F7, "CEM Solutions Pvt Ltd" },
        { 0x0017F8, "Motech Industries Inc." },
        { 0x0017F9, "Forcom Sp. z o.o." },
        { 0x0017FA, "Microsoft Corporation" },
        { 0x0017FB, "FA" },
        { 0x0017FC, "Suprema Inc." },
        { 0x0017FD, "Amulet Hotkey" },
        { 0x0017FE, "TALOS SYSTEM INC." },
        { 0x0017FF, "PLAYLINE Co.,Ltd." },
        { 0x001800, "UNIGRAND LTD" },
        { 0x001801, "Actiontec Electronics, Inc" },
        { 0x001802, "Alpha Networks Inc." },
        { 0x001803, "ArcSoft Shanghai Co. LTD" },
        { 0x001804, "E-TEK DIGITAL TECHNOLOGY LIMITED" },
        { 0x001805, "Beijing InHand Networking Technology Co.,Ltd." },
        { 0x001806, "Hokkei Industries Co., Ltd." },
        { 0x001807, "Fanstel Corp." },
        { 0x001808, "SightLogix, Inc." },
        { 0x001809, "CRESYN" },
        { 0x00180A, "Cisco Meraki" },
        { 0x00180B, "Brilliant Telecommunications" },
        { 0x00180C, "Optelian Access Networks" },
        { 0x00180D, "Terabytes Server Storage Tech Corp" },
        { 0x00180E, "Avega Systems" },
        { 0x00180F, "Nokia Danmark A/S" },
        { 0x001810, "IPTrade S.A." },
        { 0x001811, "Neuros Technology International, LLC." },
        { 0x001812, "Beijing Xinwei Telecom Technology Co., Ltd." },
        { 0x001813, "Sony Mobile Communications Inc" },
        { 0x001814, "Mitutoyo Corporation" },
        { 0x001815, "GZ Technologies, Inc." },
        { 0x001816, "Ubixon Co., Ltd." },
        { 0x001817, "D. E. Shaw Research, LLC" },
        { 0x001818, "Cisco Systems, Inc" },
        { 0x001819, "Cisco Systems, Inc" },
        { 0x00181A, "AVerMedia Information Inc." },
        { 0x00181B, "TaiJin Metal Co., Ltd." },
        { 0x00181C, "Exterity Limited" },
        { 0x00181D, "ASIA ELECTRONICS CO.,LTD" },
        { 0x00181E, "GDX Technologies Ltd." },
        { 0x00181F, "Palmmicro Communications" },
        { 0x001820, "w5networks" },
        { 0x001821, "SINDORICOH" },
        { 0x001822, "CEC TELECOM CO.,LTD." },
        { 0x001823, "Delta Electronics, Inc." },
        { 0x001824, "Kimaldi Electronics, S.L." },
        { 0x001825, "Private" },
        { 0x001826, "Cale Access AB" },
        { 0x001827, "NEC UNIFIED SOLUTIONS NEDERLAND B.V." },
        { 0x001828, "e2v technologies (UK) ltd." },
        { 0x001829, "Gatsometer" },
        { 0x00182A, "Taiwan Video & Monitor" },
        { 0x00182B, "Softier" },
        { 0x00182C, "Ascend Networks, Inc." },
        { 0x00182D, "Artec Design" },
        { 0x00182E, "XStreamHD" },
        { 0x00182F, "Texas Instruments" },
        { 0x001830, "Texas Instruments" },
        { 0x001831, "Texas Instruments" },
        { 0x001832, "Texas Instruments" },
        { 0x001833, "Texas Instruments" },
        { 0x001834, "Texas Instruments" },
        { 0x001835, "Thoratec / ITC" },
        { 0x001836, "REJ Co.,Ltd" },
        { 0x001837, "Universal ABIT Co., Ltd." },
        { 0x001838, "PanAccess Communications,Inc." },
        { 0x001839, "Cisco-Linksys, LLC" },
        { 0x00183A, "Westell Technologies Inc." },
        { 0x00183B, "CENITS Co., Ltd." },
        { 0x00183C, "Encore Software Limited" },
        { 0x00183D, "Vertex Link Corporation" },
        { 0x00183E, "Digilent, Inc" },
        { 0x00183F, "2Wire Inc" },
        { 0x001840, "3 Phoenix, Inc." },
        { 0x001841, "High Tech Computer Corp" },
        { 0x001842, "Nokia Danmark A/S" },
        { 0x001843, "Dawevision Ltd" },
        { 0x001844, "Heads Up Technologies, Inc." },
        { 0x001845, "Pulsar-Telecom LLC." },
        { 0x001846, "Crypto S.A." },
        { 0x001847, "AceNet Technology Inc." },
        { 0x001848, "Vecima Networks Inc." },
        { 0x001849, "nVent, Schroff GmbH" },
        { 0x00184A, "Catcher, Inc." },
        { 0x00184B, "Las Vegas Gaming, Inc." },
        { 0x00184C, "Bogen Communications" },
        { 0x00184D, "NETGEAR" },
        { 0x00184E, "Lianhe Technologies, Inc." },
        { 0x00184F, "8 Ways Technology Corp." },
        { 0x001850, "Secfone Kft" },
        { 0x001851, "SWsoft" },
        { 0x001852, "StorLink Semiconductors, Inc." },
        { 0x001853, "Atera Networks LTD." },
        { 0x001854, "Argard Co., Ltd" },
        { 0x001855, "Aeromaritime Systembau GmbH" },
        { 0x001856, "EyeFi, Inc" },
        { 0x001857, "Unilever R&D" },
        { 0x001858, "TagMaster AB" },
        { 0x001859, "Strawberry Linux Co.,Ltd." },
        { 0x00185A, "uControl, Inc." },
        { 0x00185B, "Network Chemistry, Inc" },
        { 0x00185C, "EDSLAB Technologies" },
        { 0x00185D, "TAIGUEN TECHNOLOGY (SHEN-ZHEN) CO., LTD." },
        { 0x00185E, "Nexterm Inc." },
        { 0x00185F, "TAC Inc." },
        { 0x001860, "SIM Technology Group Shanghai Simcom Ltd.," },
        { 0x001861, "Ooma, Inc." },
        { 0x001862, "Seagate Technology" },
        { 0x001863, "Veritech Electronics Limited" },
        { 0x001864, "Eaton Corporation" },
        { 0x001865, "Siemens Healthcare Diagnostics Manufacturing Ltd" },
        { 0x001866, "Leutron Vision" },
        { 0x001867, "Datalogic ADC" },
        { 0x001868, "Cisco SPVTG" },
        { 0x001869, "KINGJIM" },
        { 0x00186A, "Global Link Digital Technology Co,.LTD" },
        { 0x00186B, "Sambu Communics CO., LTD." },
        { 0x00186C, "Neonode AB" },
        { 0x00186D, "Zhenjiang Sapphire Electronic Industry CO." },
        { 0x00186E, "3Com Ltd" },
        { 0x00186F, "Setha Industria Eletronica LTDA" },
        { 0x001870, "E28 Shanghai Limited" },
        { 0x001871, "Hewlett Packard" },
        { 0x001872, "Expertise Engineering" },
        { 0x001873, "Cisco Systems, Inc" },
        { 0x001874, "Cisco Systems, Inc" },
        { 0x001875, "AnaCise Testnology Pte Ltd" },
        { 0x001876, "WowWee Ltd." },
        { 0x001877, "Amplex A/S" },
        { 0x001878, "Mackware GmbH" },
        { 0x001879, "dSys" },
        { 0x00187A, "Wiremold" },
        { 0x00187B, "4NSYS Co. Ltd." },
        { 0x00187C, "INTERCROSS, LLC" },
        { 0x00187D, "Armorlink Co .Ltd" },
        { 0x00187E, "RGB Spectrum" },
        { 0x00187F, "ZODIANET" },
        { 0x001880, "Maxim Integrated Products" },
        { 0x001881, "Buyang Electronics Industrial Co., Ltd" },
        { 0x001882, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x001883, "FORMOSA21 INC." },
        { 0x001884, "Fon Technology S.L." },
        { 0x001885, "Avigilon Corporation" },
        { 0x001886, "EL-TECH, INC." },
        { 0x001887, "Metasystem SpA" },
        { 0x001888, "GOTIVE a.s." },
        { 0x001889, "WinNet Solutions Limited" },
        { 0x00188A, "Infinova LLC" },
        { 0x00188B, "Dell Inc." },
        { 0x00188C, "Mobile Action Technology Inc." },
        { 0x00188D, "Nokia Danmark A/S" },
        { 0x00188E, "Ekahau, Inc." },
        { 0x00188F, "Montgomery Technology, Inc." },
        { 0x001890, "RadioCOM, s.r.o." },
        { 0x001891, "Zhongshan General K-mate Electronics Co., Ltd" },
        { 0x001892, "ads-tec GmbH" },
        { 0x001893, "SHENZHEN PHOTON BROADBAND TECHNOLOGY CO.,LTD" },
        { 0x001894, "NPCore, Inc." },
        { 0x001895, "Hansun Technologies Inc." },
        { 0x001896, "Great Well Electronic LTD" },
        { 0x001897, "JESS-LINK PRODUCTS Co., LTD" },
        { 0x001898, "KINGSTATE ELECTRONICS CORPORATION" },
        { 0x001899, "ShenZhen jieshun Science&Technology Industry CO,LTD." },
        { 0x00189A, "HANA Micron Inc." },
        { 0x00189B, "Thomson Inc." },
        { 0x00189C, "Weldex Corporation" },
        { 0x00189D, "Navcast Inc." },
        { 0x00189E, "OMNIKEY GmbH." },
        { 0x00189F, "Lenntek Corporation" },
        { 0x0018A0, "Cierma Ascenseurs" },
        { 0x0018A1, "Tiqit Computers, Inc." },
        { 0x0018A2, "XIP Technology AB" },
        { 0x0018A3, "ZIPPY TECHNOLOGY CORP." },
        { 0x0018A4, "ARRIS Group, Inc." },
        { 0x0018A5, "ADigit Technologies Corp." },
        { 0x0018A6, "Persistent Systems, LLC" },
        { 0x0018A7, "Yoggie Security Systems LTD." },
        { 0x0018A8, "AnNeal Technology Inc." },
        { 0x0018A9, "Ethernet Direct Corporation" },
        { 0x0018AA, "Protec Fire Detection plc" },
        { 0x0018AB, "BEIJING LHWT MICROELECTRONICS INC." },
        { 0x0018AC, "Shanghai Jiao Da HISYS Technology Co. Ltd." },
        { 0x0018AD, "NIDEC SANKYO CORPORATION" },
        { 0x0018AE, "TVT CO.,LTD" },
        { 0x0018AF, "Samsung Electronics Co.,Ltd" },
        { 0x0018B0, "Nortel Networks" },
        { 0x0018B1, "IBM Corp" },
        { 0x0018B2, "ADEUNIS RF" },
        { 0x0018B3, "TEC WizHome Co., Ltd." },
        { 0x0018B4, "Dawon Media Inc." },
        { 0x0018B5, "Magna Carta" },
        { 0x0018B6, "S3C, Inc." },
        { 0x0018B7, "D3 LED, LLC" },
        { 0x0018B8, "New Voice International AG" },
        { 0x0018B9, "Cisco Systems, Inc" },
        { 0x0018BA, "Cisco Systems, Inc" },
        { 0x0018BB, "Eliwell Controls srl" },
        { 0x0018BC, "ZAO NVP Bolid" },
        { 0x0018BD, "SHENZHEN DVBWORLD TECHNOLOGY CO., LTD." },
        { 0x0018BE, "ANSA Corporation" },
        { 0x0018BF, "Essence Technology Solution, Inc." },
        { 0x0018C0, "ARRIS Group, Inc." },
        { 0x0018C1, "Almitec Informática e Comércio" },
        { 0x0018C2, "Firetide, Inc" },
        { 0x0018C3, "CS Corporation" },
        { 0x0018C4, "Raba Technologies LLC" },
        { 0x0018C5, "Nokia Danmark A/S" },
        { 0x0018C6, "OPW Fuel Management Systems" },
        { 0x0018C7, "Real Time Automation" },
        { 0x0018C8, "ISONAS Inc." },
        { 0x0018C9, "EOps Technology Limited" },
        { 0x0018CA, "Viprinet GmbH" },
        { 0x0018CB, "Tecobest Technology Limited" },
        { 0x0018CC, "AXIOHM SAS" },
        { 0x0018CD, "Erae Electronics Industry Co., Ltd" },
        { 0x0018CE, "Dreamtech Co., Ltd" },
        { 0x0018CF, "Baldor Electric Company" },
        { 0x0018D0, "AtRoad, A Trimble Company" },
        { 0x0018D1, "Siemens Home & Office Comm. Devices" },
        { 0x0018D2, "High-Gain Antennas LLC" },
        { 0x0018D3, "TEAMCAST" },
        { 0x0018D4, "Unified Display Interface SIG" },
        { 0x0018D5, "REIGNCOM" },
        { 0x0018D6, "Swirlnet A/S" },
        { 0x0018D7, "JAVAD GNSS, Inc." },
        { 0x0018D8, "ARCH METER Corporation" },
        { 0x0018D9, "Santosha Internatonal, Inc" },
        { 0x0018DA, "Würth Elektronik eiSos GmbH & Co. KG" },
        { 0x0018DB, "EPL Technology Ltd" },
        { 0x0018DC, "Prostar Co., Ltd." },
        { 0x0018DD, "Silicondust Engineering Ltd" },
        { 0x0018DE, "Intel Corporate" },
        { 0x0018DF, "The Morey Corporation" },
        { 0x0018E0, "ANAVEO" },
        { 0x0018E1, "Verkerk Service Systemen" },
        { 0x0018E2, "Topdata Sistemas de Automacao Ltda" },
        { 0x0018E3, "Visualgate Systems, Inc." },
        { 0x0018E4, "YIGUANG" },
        { 0x0018E5, "Adhoco AG" },
        { 0x0018E6, "Computer Hardware Design SIA" },
        { 0x0018E7, "Cameo Communications, INC." },
        { 0x0018E8, "Hacetron Corporation" },
        { 0x0018E9, "Numata Corporation" },
        { 0x0018EA, "Alltec GmbH" },
        { 0x0018EB, "Blue Zen Enterprises Private Limited" },
        { 0x0018EC, "Welding Technology Corporation" },
        { 0x0018ED, "Accutech Ultrasystems Co., Ltd." },
        { 0x0018EE, "Videology Imaging Solutions, Inc." },
        { 0x0018EF, "Escape Communications, Inc." },
        { 0x0018F0, "JOYTOTO Co., Ltd." },
        { 0x0018F1, "Chunichi Denshi Co.,LTD." },
        { 0x0018F2, "Beijing Tianyu Communication Equipment Co., Ltd" },
        { 0x0018F3, "ASUSTek COMPUTER INC." },
        { 0x0018F4, "EO TECHNICS Co., Ltd." },
        { 0x0018F5, "Shenzhen Streaming Video Technology Company Limited" },
        { 0x0018F6, "Thomson Telecom Belgium" },
        { 0x0018F7, "Kameleon Technologies" },
        { 0x0018F8, "Cisco-Linksys, LLC" },
        { 0x0018F9, "VVOND, Inc." },
        { 0x0018FA, "Yushin Precision Equipment Co.,Ltd." },
        { 0x0018FB, "Compro Technology" },
        { 0x0018FC, "Altec Electronic AG" },
        { 0x0018FD, "Optimal Technologies International Inc." },
        { 0x0018FE, "Hewlett Packard" },
        { 0x0018FF, "PowerQuattro Co." },
        { 0x001900, "Intelliverese - DBA Voicecom" },
        { 0x001901, "F1MEDIA" },
        { 0x001902, "Cambridge Consultants Ltd" },
        { 0x001903, "Bigfoot Networks Inc" },
        { 0x001904, "WB Electronics Sp. z o.o." },
        { 0x001905, "SCHRACK Seconet AG" },
        { 0x001906, "Cisco Systems, Inc" },
        { 0x001907, "Cisco Systems, Inc" },
        { 0x001908, "Duaxes Corporation" },
        { 0x001909, "DEVI - Danfoss A/S" },
        { 0x00190A, "HASWARE INC." },
        { 0x00190B, "Southern Vision Systems, Inc." },
        { 0x00190C, "Encore Electronics, Inc." },
        { 0x00190D, "IEEE 1394c" },
        { 0x00190E, "Atech Technology Co., Ltd." },
        { 0x00190F, "Advansus Corp." },
        { 0x001910, "Knick Elektronische Messgeraete GmbH & Co. KG" },
        { 0x001911, "Just In Mobile Information Technologies (Shanghai) Co., Ltd." },
        { 0x001912, "Welcat Inc" },
        { 0x001913, "Chuang-Yi Network Equipment Co.Ltd." },
        { 0x001914, "Winix Co., Ltd" },
        { 0x001915, "TECOM Co., Ltd." },
        { 0x001916, "PayTec AG" },
        { 0x001917, "Posiflex Inc." },
        { 0x001918, "Interactive Wear AG" },
        { 0x001919, "ASTEL Inc." },
        { 0x00191A, "IRLINK" },
        { 0x00191B, "Sputnik Engineering AG" },
        { 0x00191C, "Sensicast Systems" },
        { 0x00191D, "Nintendo Co., Ltd." },
        { 0x00191E, "Beyondwiz Co., Ltd." },
        { 0x00191F, "Microlink communications Inc." },
        { 0x001920, "KUME electric Co.,Ltd." },
        { 0x001921, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x001922, "CM Comandos Lineares" },
        { 0x001923, "Phonex Korea Co., LTD." },
        { 0x001924, "LBNL Engineering" },
        { 0x001925, "Intelicis Corporation" },
        { 0x001926, "BitsGen Co., Ltd." },
        { 0x001927, "ImCoSys Ltd" },
        { 0x001928, "Siemens AG, Transportation Systems" },
        { 0x001929, "2M2B Montadora de Maquinas Bahia Brasil LTDA" },
        { 0x00192A, "Antiope Associates" },
        { 0x00192B, "Aclara RF Systems Inc." },
        { 0x00192C, "ARRIS Group, Inc." },
        { 0x00192D, "Nokia Corporation" },
        { 0x00192E, "Spectral Instruments, Inc." },
        { 0x00192F, "Cisco Systems, Inc" },
        { 0x001930, "Cisco Systems, Inc" },
        { 0x001931, "Balluff GmbH" },
        { 0x001932, "Gude Systems GmbH" },
        { 0x001933, "Strix Systems, Inc." },
        { 0x001934, "TRENDON TOUCH TECHNOLOGY CORP." },
        { 0x001935, "DUERR DENTAL AG" },
        { 0x001936, "STERLITE OPTICAL TECHNOLOGIES LIMITED" },
        { 0x001937, "CommerceGuard AB" },
        { 0x001938, "UMB Communications Co., Ltd." },
        { 0x001939, "Gigamips" },
        { 0x00193A, "OESOLUTIONS" },
        { 0x00193B, "LigoWave" },
        { 0x00193C, "HighPoint Technologies Incorporated" },
        { 0x00193D, "GMC Guardian Mobility Corp." },
        { 0x00193E, "ADB Broadband Italia" },
        { 0x00193F, "RDI technology(Shenzhen) Co.,LTD" },
        { 0x001940, "Rackable Systems" },
        { 0x001941, "Pitney Bowes, Inc" },
        { 0x001942, "ON SOFTWARE INTERNATIONAL LIMITED" },
        { 0x001943, "Belden" },
        { 0x001944, "Fossil Partners, L.P." },
        { 0x001945, "RF COncepts, LLC" },
        { 0x001946, "Cianet Industria e Comercio S/A" },
        { 0x001947, "Cisco SPVTG" },
        { 0x001948, "AireSpider Networks" },
        { 0x001949, "TENTEL COMTECH CO., LTD." },
        { 0x00194A, "TESTO AG" },
        { 0x00194B, "Sagemcom Broadband SAS" },
        { 0x00194C, "Fujian Stelcom information & Technology CO.,Ltd" },
        { 0x00194D, "Avago Technologies Sdn Bhd" },
        { 0x00194E, "Ultra Electronics - TCS (Tactical Communication Systems)" },
        { 0x00194F, "Nokia Danmark A/S" },
        { 0x001950, "Harman Multimedia" },
        { 0x001951, "NETCONS, s.r.o." },
        { 0x001952, "ACOGITO Co., Ltd" },
        { 0x001953, "Chainleader Communications Corp." },
        { 0x001954, "Leaf Corporation." },
        { 0x001955, "Cisco Systems, Inc" },
        { 0x001956, "Cisco Systems, Inc" },
        { 0x001957, "Saafnet Canada Inc." },
        { 0x001958, "Bluetooth SIG, Inc." },
        { 0x001959, "Staccato Communications Inc." },
        { 0x00195A, "Jenaer Antriebstechnik GmbH" },
        { 0x00195B, "D-Link Corporation" },
        { 0x00195C, "Innotech Corporation" },
        { 0x00195D, "ShenZhen XinHuaTong Opto Electronics Co.,Ltd" },
        { 0x00195E, "ARRIS Group, Inc." },
        { 0x00195F, "Valemount Networks Corporation" },
        { 0x001960, "DoCoMo Systems, Inc." },
        { 0x001961, "Blaupunkt Embedded Systems GmbH" },
        { 0x001962, "Commerciant, LP" },
        { 0x001963, "Sony Mobile Communications Inc" },
        { 0x001964, "Doorking Inc." },
        { 0x001965, "YuHua TelTech (ShangHai) Co., Ltd." },
        { 0x001966, "Asiarock Technology Limited" },
        { 0x001967, "TELDAT Sp.J." },
        { 0x001968, "Digital Video Networks(Shanghai) CO. LTD." },
        { 0x001969, "Nortel Networks" },
        { 0x00196A, "MikroM GmbH" },
        { 0x00196B, "Danpex Corporation" },
        { 0x00196C, "ETROVISION TECHNOLOGY" },
        { 0x00196D, "Raybit Systems Korea, Inc" },
        { 0x00196E, "Metacom (Pty) Ltd." },
        { 0x00196F, "SensoPart GmbH" },
        { 0x001970, "Z-Com, Inc." },
        { 0x001971, "Guangzhou Unicomp Technology Co.,Ltd" },
        { 0x001972, "Plexus (Xiamen) Co.,ltd." },
        { 0x001973, "Zeugma Systems" },
        { 0x001974, "16063" },
        { 0x001975, "Beijing Huisen networks technology Inc" },
        { 0x001976, "Xipher Technologies, LLC" },
        { 0x001977, "Extreme Networks, Inc." },
        { 0x001978, "Datum Systems, Inc." },
        { 0x001979, "Nokia Danmark A/S" },
        { 0x00197A, "MAZeT GmbH" },
        { 0x00197B, "Picotest Corp." },
        { 0x00197C, "Riedel Communications GmbH" },
        { 0x00197D, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00197E, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00197F, "PLANTRONICS, INC." },
        { 0x001980, "Gridpoint Systems" },
        { 0x001981, "Vivox Inc" },
        { 0x001982, "SmarDTV" },
        { 0x001983, "CCT R&D Limited" },
        { 0x001984, "ESTIC Corporation" },
        { 0x001985, "IT Watchdogs, Inc" },
        { 0x001986, "Cheng Hongjian" },
        { 0x001987, "Panasonic Mobile Communications Co.,Ltd." },
        { 0x001988, "Wi2Wi, Inc" },
        { 0x001989, "Sonitrol Corporation" },
        { 0x00198A, "Northrop Grumman Systems Corp." },
        { 0x00198B, "Novera Optics Korea, Inc." },
        { 0x00198C, "iXSea" },
        { 0x00198D, "Ocean Optics, Inc." },
        { 0x00198E, "Oticon A/S" },
        { 0x00198F, "Nokia Bell N.V." },
        { 0x001990, "ELM DATA Co., Ltd." },
        { 0x001991, "avinfo" },
        { 0x001992, "Adtran Inc" },
        { 0x001993, "Changshu Switchgear MFG. Co.,Ltd. (Former Changshu Switchgea" },
        { 0x001994, "Jorjin Technologies Inc." },
        { 0x001995, "Jurong Hi-Tech (Suzhou)Co.ltd" },
        { 0x001996, "TurboChef Technologies Inc." },
        { 0x001997, "Soft Device Sdn Bhd" },
        { 0x001998, "SATO CORPORATION" },
        { 0x001999, "Fujitsu Technology Solutions GmbH" },
        { 0x00199A, "EDO-EVI" },
        { 0x00199B, "Diversified Technical Systems, Inc." },
        { 0x00199C, "CTRING" },
        { 0x00199D, "Vizio, Inc" },
        { 0x00199E, "Nifty" },
        { 0x00199F, "DKT A/S" },
        { 0x0019A0, "NIHON DATA SYSTENS, INC." },
        { 0x0019A1, "LG INFORMATION & COMM." },
        { 0x0019A2, "ORDYN TECHNOLOGIES" },
        { 0x0019A3, "asteel electronique atlantique" },
        { 0x0019A4, "Austar Technology (hang zhou) Co.,Ltd" },
        { 0x0019A5, "RadarFind Corporation" },
        { 0x0019A6, "ARRIS Group, Inc." },
        { 0x0019A7, "ITU-T" },
        { 0x0019A8, "WiQuest Communications" },
        { 0x0019A9, "Cisco Systems, Inc" },
        { 0x0019AA, "Cisco Systems, Inc" },
        { 0x0019AB, "Raycom CO ., LTD" },
        { 0x0019AC, "GSP SYSTEMS Inc." },
        { 0x0019AD, "BOBST SA" },
        { 0x0019AE, "Hopling Technologies b.v." },
        { 0x0019AF, "Rigol Technologies, Inc." },
        { 0x0019B0, "HanYang System" },
        { 0x0019B1, "Arrow7 Corporation" },
        { 0x0019B2, "XYnetsoft Co.,Ltd" },
        { 0x0019B3, "Stanford Research Systems" },
        { 0x0019B4, "Intellio Ltd" },
        { 0x0019B5, "Famar Fueguina S.A." },
        { 0x0019B6, "Euro Emme s.r.l." },
        { 0x0019B7, "Nokia Danmark A/S" },
        { 0x0019B8, "Boundary Devices" },
        { 0x0019B9, "Dell Inc." },
        { 0x0019BA, "Paradox Security Systems Ltd" },
        { 0x0019BB, "Hewlett Packard" },
        { 0x0019BC, "ELECTRO CHANCE SRL" },
        { 0x0019BD, "New Media Life" },
        { 0x0019BE, "Altai Technologies Limited" },
        { 0x0019BF, "Citiway technology Co.,ltd" },
        { 0x0019C0, "ARRIS Group, Inc." },
        { 0x0019C1, "ALPS ELECTRIC CO., LTD." },
        { 0x0019C2, "Equustek Solutions, Inc." },
        { 0x0019C3, "Qualitrol" },
        { 0x0019C4, "Infocrypt Inc." },
        { 0x0019C5, "Sony Interactive Entertainment Inc." },
        { 0x0019C6, "zte corporation" },
        { 0x0019C7, "Cambridge Industries(Group) Co.,Ltd." },
        { 0x0019C8, "AnyDATA Corporation" },
        { 0x0019C9, "S&C ELECTRIC COMPANY" },
        { 0x0019CA, "Broadata Communications, Inc" },
        { 0x0019CB, "Zyxel Communications Corporation" },
        { 0x0019CC, "RCG (HK) Ltd" },
        { 0x0019CD, "Chengdu ethercom information technology Ltd." },
        { 0x0019CE, "Progressive Gaming International" },
        { 0x0019CF, "SALICRU, S.A." },
        { 0x0019D0, "Cathexis" },
        { 0x0019D1, "Intel Corporate" },
        { 0x0019D2, "Intel Corporate" },
        { 0x0019D3, "TRAK Microwave" },
        { 0x0019D4, "ICX Technologies" },
        { 0x0019D5, "IP Innovations, Inc." },
        { 0x0019D6, "LS Cable and System Ltd." },
        { 0x0019D7, "FORTUNETEK CO., LTD" },
        { 0x0019D8, "MAXFOR" },
        { 0x0019D9, "Zeutschel GmbH" },
        { 0x0019DA, "Welltrans O&E Technology Co. , Ltd." },
        { 0x0019DB, "MICRO-STAR INTERNATIONAL CO., LTD." },
        { 0x0019DC, "ENENSYS Technologies" },
        { 0x0019DD, "FEI-Zyfer, Inc." },
        { 0x0019DE, "MOBITEK" },
        { 0x0019DF, "Thomson Inc." },
        { 0x0019E0, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x0019E1, "Nortel Networks" },
        { 0x0019E2, "Juniper Networks" },
        { 0x0019E3, "Apple, Inc." },
        { 0x0019E4, "2Wire Inc" },
        { 0x0019E5, "Lynx Studio Technology, Inc." },
        { 0x0019E6, "TOYO MEDIC CO.,LTD." },
        { 0x0019E7, "Cisco Systems, Inc" },
        { 0x0019E8, "Cisco Systems, Inc" },
        { 0x0019E9, "S-Information Technolgy, Co., Ltd." },
        { 0x0019EA, "TeraMage Technologies Co., Ltd." },
        { 0x0019EB, "Pyronix Ltd" },
        { 0x0019EC, "Sagamore Systems, Inc." },
        { 0x0019ED, "Axesstel Inc." },
        { 0x0019EE, "CARLO GAVAZZI CONTROLS SPA-Controls Division" },
        { 0x0019EF, "SHENZHEN LINNKING ELECTRONICS CO.,LTD" },
        { 0x0019F0, "UNIONMAN TECHNOLOGY CO.,LTD" },
        { 0x0019F1, "Star Communication Network Technology Co.,Ltd" },
        { 0x0019F2, "Teradyne K.K." },
        { 0x0019F3, "Cetis, Inc" },
        { 0x0019F4, "Convergens Oy Ltd" },
        { 0x0019F5, "Imagination Technologies Ltd" },
        { 0x0019F6, "Acconet (PTE) Ltd" },
        { 0x0019F7, "Onset Computer Corporation" },
        { 0x0019F8, "Embedded Systems Design, Inc." },
        { 0x0019F9, "TDK-Lambda" },
        { 0x0019FA, "Cable Vision Electronics CO., LTD." },
        { 0x0019FB, "BSkyB Ltd" },
        { 0x0019FC, "PT. Ufoakses Sukses Luarbiasa" },
        { 0x0019FD, "Nintendo Co., Ltd." },
        { 0x0019FE, "SHENZHEN SEECOMM TECHNOLOGY CO.,LTD." },
        { 0x0019FF, "Finnzymes" },
        { 0x001A00, "MATRIX INC." },
        { 0x001A01, "Smiths Medical" },
        { 0x001A02, "SECURE CARE PRODUCTS, INC" },
        { 0x001A03, "Angel Electronics Co., Ltd." },
        { 0x001A04, "Interay Solutions BV" },
        { 0x001A05, "OPTIBASE LTD" },
        { 0x001A06, "OpVista, Inc." },
        { 0x001A07, "Arecont Vision" },
        { 0x001A08, "Simoco Ltd." },
        { 0x001A09, "Wayfarer Transit Systems Ltd" },
        { 0x001A0A, "Adaptive Micro-Ware Inc." },
        { 0x001A0B, "BONA TECHNOLOGY INC." },
        { 0x001A0C, "Swe-Dish Satellite Systems AB" },
        { 0x001A0D, "HandHeld entertainment, Inc." },
        { 0x001A0E, "Cheng Uei Precision Industry Co.,Ltd" },
        { 0x001A0F, "Sistemas Avanzados de Control, S.A." },
        { 0x001A10, "LUCENT TRANS ELECTRONICS CO.,LTD" },
        { 0x001A11, "Google, Inc." },
        { 0x001A12, "Essilor" },
        { 0x001A13, "Wanlida Group Co., LTD" },
        { 0x001A14, "Xin Hua Control Engineering Co.,Ltd." },
        { 0x001A15, "gemalto e-Payment" },
        { 0x001A16, "Nokia Danmark A/S" },
        { 0x001A17, "Teak Technologies, Inc." },
        { 0x001A18, "Advanced Simulation Technology inc." },
        { 0x001A19, "Computer Engineering Limited" },
        { 0x001A1A, "Gentex Corporation/Electro-Acoustic Products" },
        { 0x001A1B, "ARRIS Group, Inc." },
        { 0x001A1C, "GT&T Engineering Pte Ltd" },
        { 0x001A1D, "PChome Online Inc." },
        { 0x001A1E, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x001A1F, "Coastal Environmental Systems" },
        { 0x001A20, "CMOTECH Co. Ltd." },
        { 0x001A21, "Brookhuis Applied Technologies BV" },
        { 0x001A22, "eQ-3 Entwicklung GmbH" },
        { 0x001A23, "Ice Qube, Inc" },
        { 0x001A24, "Galaxy Telecom Technologies Ltd" },
        { 0x001A25, "DELTA DORE" },
        { 0x001A26, "Deltanode Solutions AB" },
        { 0x001A27, "Ubistar" },
        { 0x001A28, "ASWT Co., LTD. Taiwan Branch H.K." },
        { 0x001A29, "Johnson Outdoors Marine Electronics d/b/a Minnkota" },
        { 0x001A2A, "Arcadyan Technology Corporation" },
        { 0x001A2B, "Ayecom Technology Co., Ltd." },
        { 0x001A2C, "SATEC Co.,LTD" },
        { 0x001A2D, "The Navvo Group" },
        { 0x001A2E, "Ziova Coporation" },
        { 0x001A2F, "Cisco Systems, Inc" },
        { 0x001A30, "Cisco Systems, Inc" },
        { 0x001A31, "SCAN COIN AB" },
        { 0x001A32, "ACTIVA MULTIMEDIA" },
        { 0x001A33, "ASI Communications, Inc." },
        { 0x001A34, "Konka Group Co., Ltd." },
        { 0x001A35, "BARTEC GmbH" },
        { 0x001A36, "Aipermon GmbH & Co. KG" },
        { 0x001A37, "Lear Corporation" },
        { 0x001A38, "Sanmina-SCI" },
        { 0x001A39, "Merten GmbH&CoKG" },
        { 0x001A3A, "Dongahelecomm" },
        { 0x001A3B, "Doah Elecom Inc." },
        { 0x001A3C, "Technowave Ltd." },
        { 0x001A3D, "Ajin Vision Co.,Ltd" },
        { 0x001A3E, "Faster Technology LLC" },
        { 0x001A3F, "Intelbras" },
        { 0x001A40, "A-FOUR TECH CO., LTD." },
        { 0x001A41, "INOCOVA Co.,Ltd" },
        { 0x001A42, "Techcity Technology co., Ltd." },
        { 0x001A43, "Logical Link Communications" },
        { 0x001A44, "JWTrading Co., Ltd" },
        { 0x001A45, "GN Netcom A/S" },
        { 0x001A46, "Digital Multimedia Technology Co., Ltd" },
        { 0x001A47, "Agami Systems, Inc." },
        { 0x001A48, "Takacom Corporation" },
        { 0x001A49, "Micro Vision Co.,LTD" },
        { 0x001A4A, "Qumranet Inc." },
        { 0x001A4B, "Hewlett Packard" },
        { 0x001A4C, "Crossbow Technology, Inc" },
        { 0x001A4D, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x001A4E, "NTI AG / LinMot" },
        { 0x001A4F, "AVM GmbH" },
        { 0x001A50, "PheeNet Technology Corp." },
        { 0x001A51, "Alfred Mann Foundation" },
        { 0x001A52, "Meshlinx Wireless Inc." },
        { 0x001A53, "Zylaya" },
        { 0x001A54, "Hip Shing Electronics Ltd." },
        { 0x001A55, "ACA-Digital Corporation" },
        { 0x001A56, "ViewTel Co,. Ltd." },
        { 0x001A57, "Matrix Design Group, LLC" },
        { 0x001A58, "CCV Deutschland GmbH - Celectronic eHealth Div." },
        { 0x001A59, "Ircona" },
        { 0x001A5A, "Korea Electric Power Data Network (KDN) Co., Ltd" },
        { 0x001A5B, "NetCare Service Co., Ltd." },
        { 0x001A5C, "Euchner GmbH+Co. KG" },
        { 0x001A5D, "Mobinnova Corp." },
        { 0x001A5E, "Thincom Technology Co.,Ltd" },
        { 0x001A5F, "KitWorks.fi Ltd." },
        { 0x001A60, "Wave Electronics Co.,Ltd." },
        { 0x001A61, "PacStar Corp." },
        { 0x001A62, "Data Robotics, Incorporated" },
        { 0x001A63, "Elster Solutions, LLC," },
        { 0x001A64, "IBM Corp" },
        { 0x001A65, "Seluxit" },
        { 0x001A66, "ARRIS Group, Inc." },
        { 0x001A67, "Infinite QL Sdn Bhd" },
        { 0x001A68, "Weltec Enterprise Co., Ltd." },
        { 0x001A69, "Wuhan Yangtze Optical Technology CO.,Ltd." },
        { 0x001A6A, "Tranzas, Inc." },
        { 0x001A6B, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x001A6C, "Cisco Systems, Inc" },
        { 0x001A6D, "Cisco Systems, Inc" },
        { 0x001A6E, "Impro Technologies" },
        { 0x001A6F, "MI.TEL s.r.l." },
        { 0x001A70, "Cisco-Linksys, LLC" },
        { 0x001A71, "Diostech Co., Ltd." },
        { 0x001A72, "Mosart Semiconductor Corp." },
        { 0x001A73, "Gemtek Technology Co., Ltd." },
        { 0x001A74, "Procare International Co" },
        { 0x001A75, "Sony Mobile Communications Inc" },
        { 0x001A76, "SDT information Technology Co.,LTD." },
        { 0x001A77, "ARRIS Group, Inc." },
        { 0x001A78, "ubtos" },
        { 0x001A79, "TELECOMUNICATION TECHNOLOGIES LTD." },
        { 0x001A7A, "Lismore Instruments Limited" },
        { 0x001A7B, "Teleco, Inc." },
        { 0x001A7C, "Hirschmann Multimedia B.V." },
        { 0x001A7D, "cyber-blue(HK)Ltd" },
        { 0x001A7E, "LN Srithai Comm Ltd." },
        { 0x001A7F, "GCI Science & Technology Co.,LTD" },
        { 0x001A80, "Sony Corporation" },
        { 0x001A81, "Zelax" },
        { 0x001A82, "PROBA Building Automation Co.,LTD" },
        { 0x001A83, "Pegasus Technologies Inc." },
        { 0x001A84, "V One Multimedia Pte Ltd" },
        { 0x001A85, "NV Michel Van de Wiele" },
        { 0x001A86, "AdvancedIO Systems Inc" },
        { 0x001A87, "Canhold International Limited" },
        { 0x001A88, "Venergy,Co,Ltd" },
        { 0x001A89, "Nokia Danmark A/S" },
        { 0x001A8A, "Samsung Electronics Co.,Ltd" },
        { 0x001A8B, "CHUNIL ELECTRIC IND., CO." },
        { 0x001A8C, "Sophos Ltd" },
        { 0x001A8D, "AVECS Bergen GmbH" },
        { 0x001A8E, "3Way Networks Ltd" },
        { 0x001A8F, "Nortel Networks" },
        { 0x001A90, "Trópico Sistemas e Telecomunicações da Amazônia LTDA." },
        { 0x001A91, "FusionDynamic Ltd." },
        { 0x001A92, "ASUSTek COMPUTER INC." },
        { 0x001A93, "ERCO Leuchten GmbH" },
        { 0x001A94, "Votronic GmbH" },
        { 0x001A95, "Hisense Mobile Communications Technoligy Co.,Ltd." },
        { 0x001A96, "ECLER S.A." },
        { 0x001A97, "fitivision technology Inc." },
        { 0x001A98, "Asotel Communication Limited Taiwan Branch" },
        { 0x001A99, "Smarty (HZ) Information Electronics Co., Ltd" },
        { 0x001A9A, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x001A9B, "ADEC & Parter AG" },
        { 0x001A9C, "RightHand Technologies, Inc." },
        { 0x001A9D, "Skipper Wireless, Inc." },
        { 0x001A9E, "ICON Digital International Limited" },
        { 0x001A9F, "A-Link Ltd" },
        { 0x001AA0, "Dell Inc." },
        { 0x001AA1, "Cisco Systems, Inc" },
        { 0x001AA2, "Cisco Systems, Inc" },
        { 0x001AA3, "DELORME" },
        { 0x001AA4, "Future University-Hakodate" },
        { 0x001AA5, "BRN Phoenix" },
        { 0x001AA6, "Telefunken Radio Communication Systems GmbH &CO.KG" },
        { 0x001AA7, "Torian Wireless" },
        { 0x001AA8, "Mamiya Digital Imaging Co., Ltd." },
        { 0x001AA9, "FUJIAN STAR-NET COMMUNICATION CO.,LTD" },
        { 0x001AAA, "Analogic Corp." },
        { 0x001AAB, "eWings s.r.l." },
        { 0x001AAC, "Corelatus AB" },
        { 0x001AAD, "ARRIS Group, Inc." },
        { 0x001AAE, "Savant Systems LLC" },
        { 0x001AAF, "BLUSENS TECHNOLOGY" },
        { 0x001AB0, "Signal Networks Pvt. Ltd.," },
        { 0x001AB1, "Asia Pacific Satellite Industries Co., Ltd." },
        { 0x001AB2, "Cyber Solutions Inc." },
        { 0x001AB3, "VISIONITE INC." },
        { 0x001AB4, "FFEI Ltd." },
        { 0x001AB5, "Home Network System" },
        { 0x001AB6, "Texas Instruments" },
        { 0x001AB7, "Ethos Networks LTD." },
        { 0x001AB8, "Anseri Corporation" },
        { 0x001AB9, "PMC" },
        { 0x001ABA, "Caton Overseas Limited" },
        { 0x001ABB, "Fontal Technology Incorporation" },
        { 0x001ABC, "U4EA Technologies Ltd" },
        { 0x001ABD, "Impatica Inc." },
        { 0x001ABE, "COMPUTER HI-TECH INC." },
        { 0x001ABF, "TRUMPF Laser Marking Systems AG" },
        { 0x001AC0, "JOYBIEN TECHNOLOGIES CO., LTD." },
        { 0x001AC1, "3Com Ltd" },
        { 0x001AC2, "YEC Co.,Ltd." },
        { 0x001AC3, "Scientific-Atlanta, Inc" },
        { 0x001AC4, "2Wire Inc" },
        { 0x001AC5, "Keysight Technologies, Inc." },
        { 0x001AC6, "Micro Control Designs" },
        { 0x001AC7, "UNIPOINT" },
        { 0x001AC8, "ISL (Instrumentation Scientifique de Laboratoire)" },
        { 0x001AC9, "SUZUKEN CO.,LTD" },
        { 0x001ACA, "Tilera Corporation" },
        { 0x001ACB, "Autocom Products Ltd" },
        { 0x001ACC, "Celestial Semiconductor, Ltd" },
        { 0x001ACD, "Tidel Engineering LP" },
        { 0x001ACE, "YUPITERU CORPORATION" },
        { 0x001ACF, "C.T. ELETTRONICA" },
        { 0x001AD0, "Albis Technologies AG" },
        { 0x001AD1, "FARGO CO., LTD." },
        { 0x001AD2, "Eletronica Nitron Ltda" },
        { 0x001AD3, "Vamp Ltd." },
        { 0x001AD4, "iPOX Technology Co., Ltd." },
        { 0x001AD5, "KMC CHAIN INDUSTRIAL CO., LTD." },
        { 0x001AD6, "JIAGNSU AETNA ELECTRIC CO.,LTD" },
        { 0x001AD7, "Christie Digital Systems, Inc." },
        { 0x001AD8, "AlsterAero GmbH" },
        { 0x001AD9, "International Broadband Electric Communications, Inc." },
        { 0x001ADA, "Biz-2-Me Inc." },
        { 0x001ADB, "ARRIS Group, Inc." },
        { 0x001ADC, "Nokia Danmark A/S" },
        { 0x001ADD, "PePWave Ltd" },
        { 0x001ADE, "ARRIS Group, Inc." },
        { 0x001ADF, "Interactivetv Pty Limited" },
        { 0x001AE0, "Mythology Tech Express Inc." },
        { 0x001AE1, "EDGE ACCESS INC" },
        { 0x001AE2, "Cisco Systems, Inc" },
        { 0x001AE3, "Cisco Systems, Inc" },
        { 0x001AE4, "Medicis Technologies Corporation" },
        { 0x001AE5, "Mvox Technologies Inc." },
        { 0x001AE6, "Atlanta Advanced Communications Holdings Limited" },
        { 0x001AE7, "Aztek Networks, Inc." },
        { 0x001AE8, "Unify Software and Solutions GmbH & Co. KG" },
        { 0x001AE9, "Nintendo Co., Ltd." },
        { 0x001AEA, "Radio Terminal Systems Pty Ltd" },
        { 0x001AEB, "Allied Telesis R&D Center K.K." },
        { 0x001AEC, "Keumbee Electronics Co.,Ltd." },
        { 0x001AED, "INCOTEC GmbH" },
        { 0x001AEE, "Shenztech Ltd" },
        { 0x001AEF, "Loopcomm Technology, Inc." },
        { 0x001AF0, "Alcatel-Lucent IPD" },
        { 0x001AF1, "Embedded Artists AB" },
        { 0x001AF2, "Dynavisions Schweiz AG" },
        { 0x001AF3, "Samyoung Electronics" },
        { 0x001AF4, "Handreamnet" },
        { 0x001AF5, "PENTAONE. CO., LTD." },
        { 0x001AF6, "Woven Systems, Inc." },
        { 0x001AF7, "dataschalt e+a GmbH" },
        { 0x001AF8, "Copley Controls Corporation" },
        { 0x001AF9, "AeroVIronment (AV Inc)" },
        { 0x001AFA, "Welch Allyn, Inc." },
        { 0x001AFB, "Joby Inc." },
        { 0x001AFC, "ModusLink Corporation" },
        { 0x001AFD, "EVOLIS" },
        { 0x001AFE, "SOFACREAL" },
        { 0x001AFF, "Wizyoung Tech." },
        { 0x001B00, "Neopost Technologies" },
        { 0x001B01, "Applied Radio Technologies" },
        { 0x001B02, "ED Co.Ltd" },
        { 0x001B03, "Action Technology (SZ) Co., Ltd" },
        { 0x001B04, "Affinity International S.p.a" },
        { 0x001B05, "YMC AG" },
        { 0x001B06, "Ateliers R. LAUMONIER" },
        { 0x001B07, "Mendocino Software" },
        { 0x001B08, "Danfoss Drives A/S" },
        { 0x001B09, "Matrix Telecom Pvt. Ltd." },
        { 0x001B0A, "Intelligent Distributed Controls Ltd" },
        { 0x001B0B, "Phidgets Inc." },
        { 0x001B0C, "Cisco Systems, Inc" },
        { 0x001B0D, "Cisco Systems, Inc" },
        { 0x001B0E, "InoTec GmbH Organisationssysteme" },
        { 0x001B0F, "Petratec" },
        { 0x001B10, "ShenZhen Kang Hui Technology Co.,ltd" },
        { 0x001B11, "D-Link Corporation" },
        { 0x001B12, "Apprion" },
        { 0x001B13, "Icron Technologies Corporation" },
        { 0x001B14, "Carex Lighting Equipment Factory" },
        { 0x001B15, "Voxtel, Inc." },
        { 0x001B16, "Celtro Ltd." },
        { 0x001B17, "Palo Alto Networks" },
        { 0x001B18, "Tsuken Electric Ind. Co.,Ltd" },
        { 0x001B19, "IEEE I&M Society TC9" },
        { 0x001B1A, "e-trees Japan, Inc." },
        { 0x001B1B, "Siemens AG," },
        { 0x001B1C, "Coherent" },
        { 0x001B1D, "Phoenix International Co., Ltd" },
        { 0x001B1E, "HART Communication Foundation" },
        { 0x001B1F, "DELTA - Danish Electronics, Light & Acoustics" },
        { 0x001B20, "TPine Technology" },
        { 0x001B21, "Intel Corporate" },
        { 0x001B22, "Palit Microsystems ( H.K.) Ltd." },
        { 0x001B23, "SimpleComTools" },
        { 0x001B24, "Quanta Computer Inc." },
        { 0x001B25, "Nortel Networks" },
        { 0x001B26, "RON-Telecom ZAO" },
        { 0x001B27, "Merlin CSI" },
        { 0x001B28, "POLYGON, JSC" },
        { 0x001B29, "Avantis.Co.,Ltd" },
        { 0x001B2A, "Cisco Systems, Inc" },
        { 0x001B2B, "Cisco Systems, Inc" },
        { 0x001B2C, "ATRON electronic GmbH" },
        { 0x001B2D, "Med-Eng Systems Inc." },
        { 0x001B2E, "Sinkyo Electron Inc" },
        { 0x001B2F, "NETGEAR" },
        { 0x001B30, "Solitech Inc." },
        { 0x001B31, "Neural Image. Co. Ltd." },
        { 0x001B32, "QLogic Corporation" },
        { 0x001B33, "Nokia Danmark A/S" },
        { 0x001B34, "Focus System Inc." },
        { 0x001B35, "ChongQing JINOU Science & Technology Development CO.,Ltd" },
        { 0x001B36, "Tsubata Engineering Co.,Ltd. (Head Office)" },
        { 0x001B37, "Computec Oy" },
        { 0x001B38, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x001B39, "Proxicast" },
        { 0x001B3A, "SIMS Corp." },
        { 0x001B3B, "Yi-Qing CO., LTD" },
        { 0x001B3C, "Software Technologies Group,Inc." },
        { 0x001B3D, "EuroTel Spa" },
        { 0x001B3E, "Curtis, Inc." },
        { 0x001B3F, "ProCurve Networking by HP" },
        { 0x001B40, "Network Automation mxc AB" },
        { 0x001B41, "General Infinity Co.,Ltd." },
        { 0x001B42, "Wise & Blue" },
        { 0x001B43, "Beijing DG Telecommunications equipment Co.,Ltd" },
        { 0x001B44, "SanDisk Corporation" },
        { 0x001B45, "ABB AS, Division Automation Products" },
        { 0x001B46, "Blueone Technology Co.,Ltd" },
        { 0x001B47, "Futarque A/S" },
        { 0x001B48, "Shenzhen Lantech Electronics Co., Ltd." },
        { 0x001B49, "Roberts Radio limited" },
        { 0x001B4A, "W&W Communications, Inc." },
        { 0x001B4B, "SANION Co., Ltd." },
        { 0x001B4C, "Signtech" },
        { 0x001B4D, "Areca Technology Corporation" },
        { 0x001B4E, "Navman New Zealand" },
        { 0x001B4F, "Avaya Inc" },
        { 0x001B50, "Nizhny Novgorod Factory named after M.Frunze, FSUE (NZiF)" },
        { 0x001B51, "Vector Technology Corp." },
        { 0x001B52, "ARRIS Group, Inc." },
        { 0x001B53, "Cisco Systems, Inc" },
        { 0x001B54, "Cisco Systems, Inc" },
        { 0x001B55, "Hurco Automation Ltd." },
        { 0x001B56, "Tehuti Networks Ltd." },
        { 0x001B57, "SEMINDIA SYSTEMS PRIVATE LIMITED" },
        { 0x001B58, "ACE CAD Enterprise Co., Ltd." },
        { 0x001B59, "Sony Mobile Communications Inc" },
        { 0x001B5A, "Apollo Imaging Technologies, Inc." },
        { 0x001B5B, "2Wire Inc" },
        { 0x001B5C, "Azuretec Co., Ltd." },
        { 0x001B5D, "Vololink Pty Ltd" },
        { 0x001B5E, "BPL Limited" },
        { 0x001B5F, "Alien Technology" },
        { 0x001B60, "NAVIGON AG" },
        { 0x001B61, "Digital Acoustics, LLC" },
        { 0x001B62, "JHT Optoelectronics Co.,Ltd." },
        { 0x001B63, "Apple, Inc." },
        { 0x001B64, "IsaacLandKorea Co., Ltd," },
        { 0x001B65, "China Gridcom Co., Ltd" },
        { 0x001B66, "Sennheiser electronic GmbH & Co. KG" },
        { 0x001B67, "Cisco Systems Inc" },
        { 0x001B68, "Modnnet Co., Ltd" },
        { 0x001B69, "Equaline Corporation" },
        { 0x001B6A, "Powerwave Technologies Sweden AB" },
        { 0x001B6B, "Swyx Solutions AG" },
        { 0x001B6C, "LookX Digital Media BV" },
        { 0x001B6D, "Midtronics, Inc." },
        { 0x001B6E, "Keysight Technologies, Inc." },
        { 0x001B6F, "Teletrak Ltd" },
        { 0x001B70, "IRI Ubiteq, INC." },
        { 0x001B71, "Telular Corp." },
        { 0x001B72, "Sicep s.p.a." },
        { 0x001B73, "DTL Broadcast Ltd" },
        { 0x001B74, "MiraLink Corporation" },
        { 0x001B75, "Hypermedia Systems" },
        { 0x001B76, "Ripcode, Inc." },
        { 0x001B77, "Intel Corporate" },
        { 0x001B78, "Hewlett Packard" },
        { 0x001B79, "FAIVELEY TRANSPORT" },
        { 0x001B7A, "Nintendo Co., Ltd." },
        { 0x001B7B, "The Tintometer Ltd" },
        { 0x001B7C, "A & R Cambridge" },
        { 0x001B7D, "CXR Anderson Jacobson" },
        { 0x001B7E, "Beckmann GmbH" },
        { 0x001B7F, "TMN Technologies Telecomunicacoes Ltda" },
        { 0x001B80, "LORD Corporation" },
        { 0x001B81, "DATAQ Instruments, Inc." },
        { 0x001B82, "Taiwan Semiconductor Co., Ltd." },
        { 0x001B83, "Finsoft Ltd" },
        { 0x001B84, "Scan Engineering Telecom" },
        { 0x001B85, "MAN Energy Solutions" },
        { 0x001B86, "Bosch Access Systems GmbH" },
        { 0x001B87, "Deepsound Tech. Co., Ltd" },
        { 0x001B88, "Divinet Access Technologies Ltd" },
        { 0x001B89, "EMZA Visual Sense Ltd." },
        { 0x001B8A, "2M Electronic A/S" },
        { 0x001B8B, "NEC Platforms, Ltd." },
        { 0x001B8C, "JMicron Technology Corp." },
        { 0x001B8D, "Electronic Computer Systems, Inc." },
        { 0x001B8E, "Hulu Sweden AB" },
        { 0x001B8F, "Cisco Systems, Inc" },
        { 0x001B90, "Cisco Systems, Inc" },
        { 0x001B91, "EFKON AG" },
        { 0x001B92, "l-acoustics" },
        { 0x001B93, "JC Decaux SA DNT" },
        { 0x001B94, "T.E.M.A. S.p.A." },
        { 0x001B95, "VIDEO SYSTEMS SRL" },
        { 0x001B96, "General Sensing" },
        { 0x001B97, "Violin Technologies" },
        { 0x001B98, "Samsung Electronics Co.,Ltd" },
        { 0x001B99, "KS System GmbH" },
        { 0x001B9A, "Apollo Fire Detectors Ltd" },
        { 0x001B9B, "Hose-McCann Communications" },
        { 0x001B9C, "SATEL sp. z o.o." },
        { 0x001B9D, "Novus Security Sp. z o.o." },
        { 0x001B9E, "ASKEY COMPUTER CORP" },
        { 0x001B9F, "Calyptech Pty Ltd" },
        { 0x001BA0, "Awox" },
        { 0x001BA1, "Åmic AB" },
        { 0x001BA2, "IDS Imaging Development Systems GmbH" },
        { 0x001BA3, "Flexit Group GmbH" },
        { 0x001BA4, "S.A.E Afikim" },
        { 0x001BA5, "MyungMin Systems, Inc." },
        { 0x001BA6, "intotech inc." },
        { 0x001BA7, "Lorica Solutions" },
        { 0x001BA8, "UBI&MOBI,.Inc" },
        { 0x001BA9, "Brother industries, LTD." },
        { 0x001BAA, "XenICs nv" },
        { 0x001BAB, "Telchemy, Incorporated" },
        { 0x001BAC, "Curtiss Wright Controls Embedded Computing" },
        { 0x001BAD, "iControl Incorporated" },
        { 0x001BAE, "Micro Control Systems, Inc" },
        { 0x001BAF, "Nokia Danmark A/S" },
        { 0x001BB0, "Bharat Electronics Limited" },
        { 0x001BB1, "Wistron Neweb Corporation" },
        { 0x001BB2, "Intellect International NV" },
        { 0x001BB3, "Condalo GmbH" },
        { 0x001BB4, "Airvod Limited" },
        { 0x001BB5, "Cherry GmbH" },
        { 0x001BB6, "Bird Electronic Corp." },
        { 0x001BB7, "Alta Heights Technology Corp." },
        { 0x001BB8, "BLUEWAY ELECTRONIC CO;LTD" },
        { 0x001BB9, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x001BBA, "Nortel Networks" },
        { 0x001BBB, "RFTech Co.,Ltd" },
        { 0x001BBC, "Silver Peak Systems, Inc." },
        { 0x001BBD, "FMC Kongsberg Subsea AS" },
        { 0x001BBE, "ICOP Digital" },
        { 0x001BBF, "Sagemcom Broadband SAS" },
        { 0x001BC0, "Juniper Networks" },
        { 0x001BC1, "HOLUX Technology, Inc." },
        { 0x001BC2, "Integrated Control Technology Limitied" },
        { 0x001BC3, "Mobisolution Co.,Ltd" },
        { 0x001BC4, "Ultratec, Inc." },
        { 0x001BC5, "IEEE Registration Authority" },
        { 0x001BC6, "Strato Rechenzentrum AG" },
        { 0x001BC7, "StarVedia Technology Inc." },
        { 0x001BC8, "MIURA CO.,LTD" },
        { 0x001BC9, "FSN DISPLAY INC" },
        { 0x001BCA, "Beijing Run Technology LTD. Company" },
        { 0x001BCB, "PEMPEK SYSTEMS PTY LTD" },
        { 0x001BCC, "KINGTEK CCTV ALLIANCE CO., LTD." },
        { 0x001BCD, "DAVISCOMMS (S) PTE LTD" },
        { 0x001BCE, "Measurement Devices Ltd" },
        { 0x001BCF, "Dataupia Corporation" },
        { 0x001BD0, "IDENTEC SOLUTIONS" },
        { 0x001BD1, "SOGESTMATIC" },
        { 0x001BD2, "ULTRA-X ASIA PACIFIC Inc." },
        { 0x001BD3, "Panasonic Corporation AVC Networks Company" },
        { 0x001BD4, "Cisco Systems, Inc" },
        { 0x001BD5, "Cisco Systems, Inc" },
        { 0x001BD6, "Kelvin Hughes Ltd" },
        { 0x001BD7, "Cisco SPVTG" },
        { 0x001BD8, "FLIR Systems Inc" },
        { 0x001BD9, "Edgewater Wireless Systems Inc" },
        { 0x001BDA, "UTStarcom Inc" },
        { 0x001BDB, "Valeo VECS" },
        { 0x001BDC, "Vencer Co., Ltd." },
        { 0x001BDD, "ARRIS Group, Inc." },
        { 0x001BDE, "Renkus-Heinz, Inc." },
        { 0x001BDF, "Iskra Sistemi d.d." },
        { 0x001BE0, "TELENOT ELECTRONIC GmbH" },
        { 0x001BE1, "ViaLogy" },
        { 0x001BE2, "AhnLab,Inc." },
        { 0x001BE3, "Health Hero Network, Inc." },
        { 0x001BE4, "TOWNET SRL" },
        { 0x001BE5, "802automation Limited" },
        { 0x001BE6, "VR AG" },
        { 0x001BE7, "Postek Electronics Co., Ltd." },
        { 0x001BE8, "Ultratronik GmbH" },
        { 0x001BE9, "Broadcom" },
        { 0x001BEA, "Nintendo Co., Ltd." },
        { 0x001BEB, "DMP Electronics INC." },
        { 0x001BEC, "Netio Technologies Co., Ltd" },
        { 0x001BED, "Brocade Communications Systems LLC" },
        { 0x001BEE, "Nokia Danmark A/S" },
        { 0x001BEF, "Blossoms Digital Technology Co.,Ltd." },
        { 0x001BF0, "Value Platforms Limited" },
        { 0x001BF1, "Nanjing SilverNet Software Co., Ltd." },
        { 0x001BF2, "KWORLD COMPUTER CO., LTD" },
        { 0x001BF3, "TRANSRADIO SenderSysteme Berlin AG" },
        { 0x001BF4, "KENWIN INDUSTRIAL(HK) LTD." },
        { 0x001BF5, "Tellink Sistemas de Telecomunicación S.L." },
        { 0x001BF6, "CONWISE Technology Corporation Ltd." },
        { 0x001BF7, "Lund IP Products AB" },
        { 0x001BF8, "Digitrax Inc." },
        { 0x001BF9, "Intellitect Water Ltd" },
        { 0x001BFA, "G.i.N. mbH" },
        { 0x001BFB, "ALPS ELECTRIC CO., LTD." },
        { 0x001BFC, "ASUSTek COMPUTER INC." },
        { 0x001BFD, "Dignsys Inc." },
        { 0x001BFE, "Zavio Inc." },
        { 0x001BFF, "Millennia Media inc." },
        { 0x001C00, "Entry Point, LLC" },
        { 0x001C01, "ABB Oy Drives" },
        { 0x001C02, "Pano Logic" },
        { 0x001C03, "Betty TV Technology AG" },
        { 0x001C04, "Airgain, Inc." },
        { 0x001C05, "Nonin Medical Inc." },
        { 0x001C06, "Siemens Numerical Control Ltd., Nanjing" },
        { 0x001C07, "Cwlinux Limited" },
        { 0x001C08, "Echo360, Inc." },
        { 0x001C09, "SAE Electronic Co.,Ltd." },
        { 0x001C0A, "Shenzhen AEE Technology Co.,Ltd." },
        { 0x001C0B, "SmartAnt Telecom" },
        { 0x001C0C, "TANITA Corporation" },
        { 0x001C0D, "G-Technology, Inc." },
        { 0x001C0E, "Cisco Systems, Inc" },
        { 0x001C0F, "Cisco Systems, Inc" },
        { 0x001C10, "Cisco-Linksys, LLC" },
        { 0x001C11, "ARRIS Group, Inc." },
        { 0x001C12, "ARRIS Group, Inc." },
        { 0x001C13, "OPTSYS TECHNOLOGY CO., LTD." },
        { 0x001C14, "VMware, Inc." },
        { 0x001C15, "iPhotonix LLC" },
        { 0x001C16, "ThyssenKrupp Elevator" },
        { 0x001C17, "Nortel Networks" },
        { 0x001C18, "Sicert S.r.L." },
        { 0x001C19, "secunet Security Networks AG" },
        { 0x001C1A, "Thomas Instrumentation, Inc" },
        { 0x001C1B, "Hyperstone GmbH" },
        { 0x001C1C, "Center Communication Systems GmbH" },
        { 0x001C1D, "CHENZHOU GOSPELL DIGITAL TECHNOLOGY CO.,LTD" },
        { 0x001C1E, "emtrion GmbH" },
        { 0x001C1F, "Quest Retail Technology Pty Ltd" },
        { 0x001C20, "CLB Benelux" },
        { 0x001C21, "Nucsafe Inc." },
        { 0x001C22, "Aeris Elettronica s.r.l." },
        { 0x001C23, "Dell Inc." },
        { 0x001C24, "Formosa Wireless Systems Corp." },
        { 0x001C25, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x001C26, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x001C27, "Sunell Electronics Co." },
        { 0x001C28, "Sphairon Technologies GmbH" },
        { 0x001C29, "CORE DIGITAL ELECTRONICS CO., LTD" },
        { 0x001C2A, "Envisacor Technologies Inc." },
        { 0x001C2B, "Alertme.com Limited" },
        { 0x001C2C, "Synapse" },
        { 0x001C2D, "FlexRadio Systems" },
        { 0x001C2E, "HPN Supply Chain" },
        { 0x001C2F, "Pfister GmbH" },
        { 0x001C30, "Mode Lighting (UK ) Ltd." },
        { 0x001C31, "Mobile XP Technology Co., LTD" },
        { 0x001C32, "Telian Corporation" },
        { 0x001C33, "Sutron" },
        { 0x001C34, "HUEY CHIAO INTERNATIONAL CO., LTD." },
        { 0x001C35, "Nokia Danmark A/S" },
        { 0x001C36, "iNEWiT NV" },
        { 0x001C37, "Callpod, Inc." },
        { 0x001C38, "Bio-Rad Laboratories, Inc." },
        { 0x001C39, "S Netsystems Inc." },
        { 0x001C3A, "Element Labs, Inc." },
        { 0x001C3B, "AmRoad Technology Inc." },
        { 0x001C3C, "Seon Design Inc." },
        { 0x001C3D, "WaveStorm" },
        { 0x001C3E, "ECKey Corporation" },
        { 0x001C3F, "International Police Technologies, Inc." },
        { 0x001C40, "VDG-Security bv" },
        { 0x001C41, "scemtec Transponder Technology GmbH" },
        { 0x001C42, "Parallels, Inc." },
        { 0x001C43, "Samsung Electronics Co.,Ltd" },
        { 0x001C44, "Bosch Security Systems BV" },
        { 0x001C45, "Chenbro Micom Co., Ltd." },
        { 0x001C46, "QTUM" },
        { 0x001C47, "Hangzhou Hollysys Automation Co., Ltd" },
        { 0x001C48, "WiDeFi, Inc." },
        { 0x001C49, "Zoltan Technology Inc." },
        { 0x001C4A, "AVM GmbH" },
        { 0x001C4B, "Gener8, Inc." },
        { 0x001C4C, "Petrotest Instruments" },
        { 0x001C4D, "Aplix IP Holdings Corporation" },
        { 0x001C4E, "TASA International Limited" },
        { 0x001C4F, "MACAB AB" },
        { 0x001C50, "TCL Technoly Electronics (Huizhou) Co., Ltd." },
        { 0x001C51, "Celeno Communications" },
        { 0x001C52, "VISIONEE SRL" },
        { 0x001C53, "Synergy Lighting Controls" },
        { 0x001C54, "Hillstone Networks Inc" },
        { 0x001C55, "Shenzhen Kaifa Technology Co." },
        { 0x001C56, "Pado Systems, Inc." },
        { 0x001C57, "Cisco Systems, Inc" },
        { 0x001C58, "Cisco Systems, Inc" },
        { 0x001C59, "DEVON IT" },
        { 0x001C5A, "Advanced Relay Corporation" },
        { 0x001C5B, "Chubb Electronic Security Systems Ltd" },
        { 0x001C5C, "Integrated Medical Systems, Inc." },
        { 0x001C5D, "Leica Microsystems" },
        { 0x001C5E, "ASTON France" },
        { 0x001C5F, "Winland Electronics, Inc." },
        { 0x001C60, "CSP Frontier Technologies,Inc." },
        { 0x001C61, "Galaxy Microsystems LImited" },
        { 0x001C62, "LG Electronics (Mobile Communications)" },
        { 0x001C63, "TRUEN" },
        { 0x001C64, "Landis+Gyr" },
        { 0x001C65, "JoeScan, Inc." },
        { 0x001C66, "UCAMP CO.,LTD" },
        { 0x001C67, "Pumpkin Networks, Inc." },
        { 0x001C68, "Anhui Sun Create Electronics Co., Ltd" },
        { 0x001C69, "Packet Vision Ltd" },
        { 0x001C6A, "Weiss Engineering Ltd." },
        { 0x001C6B, "COVAX Co. Ltd" },
        { 0x001C6C, "30805" },
        { 0x001C6D, "KYOHRITSU ELECTRONIC INDUSTRY CO., LTD." },
        { 0x001C6E, "Newbury Networks, Inc." },
        { 0x001C6F, "Emfit Ltd" },
        { 0x001C70, "NOVACOMM LTDA" },
        { 0x001C71, "Emergent Electronics" },
        { 0x001C72, "Mayer & Cie GmbH & Co KG" },
        { 0x001C73, "Arista Networks" },
        { 0x001C74, "Syswan Technologies Inc." },
        { 0x001C75, "Segnet Ltd." },
        { 0x001C76, "The Wandsworth Group Ltd" },
        { 0x001C77, "Prodys" },
        { 0x001C78, "WYPLAY SAS" },
        { 0x001C79, "Cohesive Financial Technologies LLC" },
        { 0x001C7A, "Perfectone Netware Company Ltd" },
        { 0x001C7B, "Castlenet Technology Inc." },
        { 0x001C7C, "PERQ SYSTEMS CORPORATION" },
        { 0x001C7D, "Excelpoint Manufacturing Pte Ltd" },
        { 0x001C7E, "Toshiba" },
        { 0x001C7F, "Check Point Software Technologies" },
        { 0x001C80, "New Business Division/Rhea-Information CO., LTD." },
        { 0x001C81, "NextGen Venturi LTD" },
        { 0x001C82, "Genew Technologies" },
        { 0x001C83, "New Level Telecom Co., Ltd." },
        { 0x001C84, "STL Solution Co.,Ltd." },
        { 0x001C85, "Eunicorn" },
        { 0x001C86, "Cranite Systems, Inc." },
        { 0x001C87, "Uriver Inc." },
        { 0x001C88, "TRANSYSTEM INC." },
        { 0x001C89, "Force Communications, Inc." },
        { 0x001C8A, "Cirrascale Corporation" },
        { 0x001C8B, "MJ Innovations Ltd." },
        { 0x001C8C, "DIAL TECHNOLOGY LTD." },
        { 0x001C8D, "Mesa Imaging" },
        { 0x001C8E, "Alcatel-Lucent IPD" },
        { 0x001C8F, "Advanced Electronic Design, Inc." },
        { 0x001C90, "Empacket Corporation" },
        { 0x001C91, "Gefen LLC" },
        { 0x001C92, "Tervela" },
        { 0x001C93, "ExaDigm Inc" },
        { 0x001C94, "LI-COR Biosciences" },
        { 0x001C95, "Opticomm Corporation" },
        { 0x001C96, "Linkwise Technology Pte Ltd" },
        { 0x001C97, "Enzytek Technology Inc.," },
        { 0x001C98, "LUCKY TECHNOLOGY (HK) COMPANY LIMITED" },
        { 0x001C99, "Shunra Software Ltd." },
        { 0x001C9A, "Nokia Danmark A/S" },
        { 0x001C9B, "FEIG ELECTRONIC GmbH" },
        { 0x001C9C, "Nortel Networks" },
        { 0x001C9D, "Liecthi AG" },
        { 0x001C9E, "Dualtech IT AB" },
        { 0x001C9F, "Razorstream, LLC" },
        { 0x001CA0, "Production Resource Group, LLC" },
        { 0x001CA1, "AKAMAI TECHNOLOGIES, INC." },
        { 0x001CA2, "ADB Broadband Italia" },
        { 0x001CA3, "Terra" },
        { 0x001CA4, "Sony Mobile Communications Inc" },
        { 0x001CA5, "Zygo Corporation" },
        { 0x001CA6, "Win4NET" },
        { 0x001CA7, "International Quartz Limited" },
        { 0x001CA8, "AirTies Wireless Networks" },
        { 0x001CA9, "Audiomatica Srl" },
        { 0x001CAA, "Bellon Pty Ltd" },
        { 0x001CAB, "Meyer Sound Laboratories, Inc." },
        { 0x001CAC, "Qniq Technology Corp." },
        { 0x001CAD, "Wuhan Telecommunication Devices Co.,Ltd" },
        { 0x001CAE, "WiChorus, Inc." },
        { 0x001CAF, "Plato Networks Inc." },
        { 0x001CB0, "Cisco Systems, Inc" },
        { 0x001CB1, "Cisco Systems, Inc" },
        { 0x001CB2, "BPT SPA" },
        { 0x001CB3, "Apple, Inc." },
        { 0x001CB4, "Iridium Satellite LLC" },
        { 0x001CB5, "Neihua Network Technology Co.,LTD.(NHN)" },
        { 0x001CB6, "Duzon CNT Co., Ltd." },
        { 0x001CB7, "USC DigiArk Corporation" },
        { 0x001CB8, "CBC Co., Ltd" },
        { 0x001CB9, "KWANG SUNG ELECTRONICS CO., LTD." },
        { 0x001CBA, "VerScient, Inc." },
        { 0x001CBB, "MusicianLink" },
        { 0x001CBC, "CastGrabber, LLC" },
        { 0x001CBD, "Ezze Mobile Tech., Inc." },
        { 0x001CBE, "Nintendo Co., Ltd." },
        { 0x001CBF, "Intel Corporate" },
        { 0x001CC0, "Intel Corporate" },
        { 0x001CC1, "ARRIS Group, Inc." },
        { 0x001CC2, "Part II Research, Inc." },
        { 0x001CC3, "ARRIS Group, Inc." },
        { 0x001CC4, "Hewlett Packard" },
        { 0x001CC5, "3Com Ltd" },
        { 0x001CC6, "ProStor Systems" },
        { 0x001CC7, "Rembrandt Technologies, LLC d/b/a REMSTREAM" },
        { 0x001CC8, "INDUSTRONIC Industrie-Electronic GmbH & Co. KG" },
        { 0x001CC9, "Kaise Electronic Technology Co., Ltd." },
        { 0x001CCA, "Shanghai Gaozhi Science & Technology Development Co." },
        { 0x001CCB, "Forth Corporation Public Company Limited" },
        { 0x001CCC, "BlackBerry RTS" },
        { 0x001CCD, "Alektrona Corporation" },
        { 0x001CCE, "By Techdesign" },
        { 0x001CCF, "LIMETEK" },
        { 0x001CD0, "Circleone Co.,Ltd." },
        { 0x001CD1, "Waves Audio LTD" },
        { 0x001CD2, "King Champion (Hong Kong) Limited" },
        { 0x001CD3, "ZP Engineering SEL" },
        { 0x001CD4, "Nokia Danmark A/S" },
        { 0x001CD5, "ZeeVee, Inc." },
        { 0x001CD6, "Nokia Danmark A/S" },
        { 0x001CD7, "Harman/Becker Automotive Systems GmbH" },
        { 0x001CD8, "BlueAnt Wireless" },
        { 0x001CD9, "GlobalTop Technology Inc." },
        { 0x001CDA, "Exegin Technologies Limited" },
        { 0x001CDB, "CARPOINT CO.,LTD" },
        { 0x001CDC, "Custom Computer Services, Inc." },
        { 0x001CDD, "COWBELL ENGINEERING CO., LTD." },
        { 0x001CDE, "Interactive Multimedia eXchange Inc." },
        { 0x001CDF, "Belkin International Inc." },
        { 0x001CE0, "DASAN TPS" },
        { 0x001CE1, "INDRA SISTEMAS, S.A." },
        { 0x001CE2, "Attero Tech, LLC." },
        { 0x001CE3, "Optimedical Systems" },
        { 0x001CE4, "EleSy JSC" },
        { 0x001CE5, "MBS Electronic Systems GmbH" },
        { 0x001CE6, "INNES" },
        { 0x001CE7, "Rocon PLC Research Centre" },
        { 0x001CE8, "Cummins Inc" },
        { 0x001CE9, "Galaxy Technology Limited" },
        { 0x001CEA, "Scientific-Atlanta, Inc" },
        { 0x001CEB, "Nortel Networks" },
        { 0x001CEC, "Mobilesoft (Aust.) Pty Ltd" },
        { 0x001CED, "ENVIRONNEMENT SA" },
        { 0x001CEE, "SHARP Corporation" },
        { 0x001CEF, "Primax Electronics Ltd." },
        { 0x001CF0, "D-Link Corporation" },
        { 0x001CF1, "SUPoX Technology Co. , LTD." },
        { 0x001CF2, "Tenlon Technology Co.,Ltd." },
        { 0x001CF3, "EVS BROADCAST EQUIPMENT" },
        { 0x001CF4, "Media Technology Systems Inc" },
        { 0x001CF5, "Wiseblue Technology Limited" },
        { 0x001CF6, "Cisco Systems, Inc" },
        { 0x001CF7, "AudioScience" },
        { 0x001CF8, "Parade Technologies, Ltd." },
        { 0x001CF9, "Cisco Systems, Inc" },
        { 0x001CFA, "Alarm.com" },
        { 0x001CFB, "ARRIS Group, Inc." },
        { 0x001CFC, "Sumitomo Electric Industries, Ltd" },
        { 0x001CFD, "Universal Electronics, Inc." },
        { 0x001CFE, "Quartics Inc" },
        { 0x001CFF, "Napera Networks Inc" },
        { 0x001D00, "Brivo Systems, LLC" },
        { 0x001D01, "Neptune Digital" },
        { 0x001D02, "Cybertech Telecom Development" },
        { 0x001D03, "Design Solutions Inc." },
        { 0x001D04, "Zipit Wireless, Inc." },
        { 0x001D05, "Cooper Lighting Solutions" },
        { 0x001D06, "HM Electronics, Inc." },
        { 0x001D07, "Shenzhen Sang Fei Consumer Communications Co.,Ltd" },
        { 0x001D08, "Jiangsu Yinhe Electronics Co.,Ltd." },
        { 0x001D09, "Dell Inc." },
        { 0x001D0A, "Davis Instruments, Inc." },
        { 0x001D0B, "Power Standards Lab" },
        { 0x001D0C, "MobileCompia" },
        { 0x001D0D, "Sony Interactive Entertainment Inc." },
        { 0x001D0E, "Agapha Technology co., Ltd." },
        { 0x001D0F, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x001D10, "LightHaus Logic, Inc." },
        { 0x001D11, "Analogue & Micro Ltd" },
        { 0x001D12, "ROHM CO., LTD." },
        { 0x001D13, "NextGTV" },
        { 0x001D14, "SPERADTONE INFORMATION TECHNOLOGY LIMITED" },
        { 0x001D15, "Shenzhen Dolphin Electronic Co., Ltd" },
        { 0x001D16, "SFR" },
        { 0x001D17, "Digital Sky Corporation" },
        { 0x001D18, "Power Innovation GmbH" },
        { 0x001D19, "Arcadyan Technology Corporation" },
        { 0x001D1A, "OvisLink S.A." },
        { 0x001D1B, "Sangean Electronics Inc." },
        { 0x001D1C, "Gennet s.a." },
        { 0x001D1D, "Inter-M Corporation" },
        { 0x001D1E, "KYUSHU TEN CO.,LTD" },
        { 0x001D1F, "Siauliu Tauro Televizoriai, JSC" },
        { 0x001D20, "Comtrend Corporation" },
        { 0x001D21, "Alcad SL" },
        { 0x001D22, "Foss Analytical A/S" },
        { 0x001D23, "SENSUS" },
        { 0x001D24, "Aclara Power-Line Systems Inc." },
        { 0x001D25, "Samsung Electronics Co.,Ltd" },
        { 0x001D26, "Rockridgesound Technology Co." },
        { 0x001D27, "NAC-INTERCOM" },
        { 0x001D28, "Sony Mobile Communications Inc" },
        { 0x001D29, "Doro AB" },
        { 0x001D2A, "SHENZHEN BUL-TECH CO.,LTD." },
        { 0x001D2B, "Wuhan Pont Technology CO. , LTD" },
        { 0x001D2C, "Wavetrend Technologies (Pty) Limited" },
        { 0x001D2D, "Pylone, Inc." },
        { 0x001D2E, "Ruckus Wireless" },
        { 0x001D2F, "QuantumVision Corporation" },
        { 0x001D30, "YX Wireless S.A." },
        { 0x001D31, "HIGHPRO INTERNATIONAL R&D CO,.LTD." },
        { 0x001D32, "Longkay Communication & Technology (Shanghai) Co. Ltd" },
        { 0x001D33, "Maverick Systems Inc." },
        { 0x001D34, "SYRIS Technology Corp" },
        { 0x001D35, "Viconics Electronics Inc." },
        { 0x001D36, "ELECTRONICS CORPORATION OF INDIA LIMITED" },
        { 0x001D37, "Thales-Panda Transportation System" },
        { 0x001D38, "Seagate Technology" },
        { 0x001D39, "MOOHADIGITAL CO., LTD" },
        { 0x001D3A, "mh acoustics LLC" },
        { 0x001D3B, "Nokia Danmark A/S" },
        { 0x001D3C, "Muscle Corporation" },
        { 0x001D3D, "Avidyne Corporation" },
        { 0x001D3E, "SAKA TECHNO SCIENCE CO.,LTD" },
        { 0x001D3F, "Mitron Pty Ltd" },
        { 0x001D40, "Intel – GE Care Innovations LLC" },
        { 0x001D41, "Hardy Instruments" },
        { 0x001D42, "Nortel Networks" },
        { 0x001D43, "Shenzhen G-link Digital Technology Co., Ltd." },
        { 0x001D44, "Krohne" },
        { 0x001D45, "Cisco Systems, Inc" },
        { 0x001D46, "Cisco Systems, Inc" },
        { 0x001D47, "Covote GmbH & Co KG" },
        { 0x001D48, "Sensor-Technik Wiedemann GmbH" },
        { 0x001D49, "Innovation Wireless Inc." },
        { 0x001D4A, "Carestream Health, Inc." },
        { 0x001D4B, "Grid Connect Inc." },
        { 0x001D4C, "Alcatel-Lucent" },
        { 0x001D4D, "Adaptive Recognition Hungary, Inc" },
        { 0x001D4E, "TCM Mobile LLC" },
        { 0x001D4F, "Apple, Inc." },
        { 0x001D50, "SPINETIX SA" },
        { 0x001D51, "Babcock & Wilcox Power Generation Group, Inc" },
        { 0x001D52, "Defzone B.V." },
        { 0x001D53, "S&O Electronics (Malaysia) Sdn. Bhd." },
        { 0x001D54, "Sunnic Technology & Merchandise INC." },
        { 0x001D55, "ZANTAZ, Inc" },
        { 0x001D56, "Kramer Electronics Ltd." },
        { 0x001D57, "CAETEC Messtechnik" },
        { 0x001D58, "CQ Inc" },
        { 0x001D59, "Mitra Energy & Infrastructure" },
        { 0x001D5A, "2Wire Inc" },
        { 0x001D5B, "Tecvan Informática Ltda" },
        { 0x001D5C, "Tom Communication Industrial Co.,Ltd." },
        { 0x001D5D, "Control Dynamics Pty. Ltd." },
        { 0x001D5E, "COMING MEDIA CORP." },
        { 0x001D5F, "OverSpeed SARL" },
        { 0x001D60, "ASUSTek COMPUTER INC." },
        { 0x001D61, "BIJ Corporation" },
        { 0x001D62, "InPhase Technologies" },
        { 0x001D63, "Miele & Cie. KG" },
        { 0x001D64, "Adam Communications Systems Int Ltd" },
        { 0x001D65, "Microwave Radio Communications" },
        { 0x001D66, "Hyundai Telecom" },
        { 0x001D67, "AMEC" },
        { 0x001D68, "Thomson Telecom Belgium" },
        { 0x001D69, "Knorr-Bremse IT-Services GmbH" },
        { 0x001D6A, "Alpha Networks Inc." },
        { 0x001D6B, "ARRIS Group, Inc." },
        { 0x001D6C, "ClariPhy Communications, Inc." },
        { 0x001D6D, "Confidant International LLC" },
        { 0x001D6E, "Nokia Danmark A/S" },
        { 0x001D6F, "Chainzone Technology Co., Ltd" },
        { 0x001D70, "Cisco Systems, Inc" },
        { 0x001D71, "Cisco Systems, Inc" },
        { 0x001D72, "Wistron Corporation" },
        { 0x001D73, "BUFFALO.INC" },
        { 0x001D74, "Tianjin China-Silicon Microelectronics Co., Ltd." },
        { 0x001D75, "Radioscape PLC" },
        { 0x001D76, "Eyeheight Ltd." },
        { 0x001D77, "NSGate" },
        { 0x001D78, "Invengo Information Technology Co.,Ltd" },
        { 0x001D79, "SIGNAMAX LLC" },
        { 0x001D7A, "Wideband Semiconductor, Inc." },
        { 0x001D7B, "Ice Energy, Inc." },
        { 0x001D7C, "ABE Elettronica S.p.A." },
        { 0x001D7D, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x001D7E, "Cisco-Linksys, LLC" },
        { 0x001D7F, "Tekron International Ltd" },
        { 0x001D80, "Beijing Huahuan Eletronics Co.,Ltd" },
        { 0x001D81, "GUANGZHOU GATEWAY ELECTRONICS CO., LTD" },
        { 0x001D82, "GN Netcom A/S" },
        { 0x001D83, "Emitech Corporation" },
        { 0x001D84, "Gateway, Inc." },
        { 0x001D85, "Call Direct Cellular Solutions" },
        { 0x001D86, "Shinwa Industries(China) Ltd." },
        { 0x001D87, "VigTech Labs Sdn Bhd" },
        { 0x001D88, "Clearwire" },
        { 0x001D89, "VaultStor Corporation" },
        { 0x001D8A, "TechTrex Inc" },
        { 0x001D8B, "ADB Broadband Italia" },
        { 0x001D8C, "La Crosse Technology LTD" },
        { 0x001D8D, "Fluke Process Instruments GmbH" },
        { 0x001D8E, "Alereon, Inc." },
        { 0x001D8F, "PureWave Networks" },
        { 0x001D90, "EMCO Flow Systems" },
        { 0x001D91, "Digitize, Inc" },
        { 0x001D92, "MICRO-STAR INT'L CO.,LTD." },
        { 0x001D93, "Modacom" },
        { 0x001D94, "Climax Technology Co., Ltd" },
        { 0x001D95, "Flash, Inc." },
        { 0x001D96, "WatchGuard Video" },
        { 0x001D97, "Alertus Technologies LLC" },
        { 0x001D98, "Nokia Danmark A/S" },
        { 0x001D99, "Cyan Optic, Inc." },
        { 0x001D9A, "GODEX INTERNATIONAL CO., LTD" },
        { 0x001D9B, "Hokuyo Automatic Co., Ltd." },
        { 0x001D9C, "Rockwell Automation" },
        { 0x001D9D, "ARTJOY INTERNATIONAL LIMITED" },
        { 0x001D9E, "AXION TECHNOLOGIES" },
        { 0x001D9F, "MATT R.P.Traczynscy Sp.J." },
        { 0x001DA0, "Heng Yu Electronic Manufacturing Company Limited" },
        { 0x001DA1, "Cisco Systems, Inc" },
        { 0x001DA2, "Cisco Systems, Inc" },
        { 0x001DA3, "SabiOso" },
        { 0x001DA4, "Hangzhou System Technology CO., LTD" },
        { 0x001DA5, "WB Electronics" },
        { 0x001DA6, "Media Numerics Limited" },
        { 0x001DA7, "Seamless Internet" },
        { 0x001DA8, "Takahata Electronics Co.,Ltd" },
        { 0x001DA9, "Castles Technology, Co., LTD" },
        { 0x001DAA, "DrayTek Corp." },
        { 0x001DAB, "SwissQual License AG" },
        { 0x001DAC, "Gigamon Systems LLC" },
        { 0x001DAD, "Sinotech Engineering Consultants, Inc. Geotechnical Enginee" },
        { 0x001DAE, "CHANG TSENG TECHNOLOGY CO., LTD" },
        { 0x001DAF, "Nortel Networks" },
        { 0x001DB0, "FuJian HengTong Information Technology Co.,Ltd" },
        { 0x001DB1, "Crescendo Networks" },
        { 0x001DB2, "HOKKAIDO ELECTRIC ENGINEERING CO.,LTD." },
        { 0x001DB3, "HPN Supply Chain" },
        { 0x001DB4, "KUMHO ENG CO.,LTD" },
        { 0x001DB5, "Juniper Networks" },
        { 0x001DB6, "BestComm Networks, Inc." },
        { 0x001DB7, "Tendril Networks, Inc." },
        { 0x001DB8, "Intoto Inc." },
        { 0x001DB9, "Wellspring Wireless" },
        { 0x001DBA, "Sony Corporation" },
        { 0x001DBB, "Dynamic System Electronics Corp." },
        { 0x001DBC, "Nintendo Co., Ltd." },
        { 0x001DBD, "Versamed Inc." },
        { 0x001DBE, "ARRIS Group, Inc." },
        { 0x001DBF, "Radiient Technologies, Inc." },
        { 0x001DC0, "Enphase Energy" },
        { 0x001DC1, "Audinate Pty L" },
        { 0x001DC2, "XORTEC OY" },
        { 0x001DC3, "RIKOR TV, Ltd" },
        { 0x001DC4, "AIOI Systems Co., Ltd." },
        { 0x001DC5, "Beijing Jiaxun Feihong Electricial Co., Ltd." },
        { 0x001DC6, "SNR Inc." },
        { 0x001DC7, "L-3 Communications Geneva Aerospace" },
        { 0x001DC8, "Navionics Research Inc., dba SCADAmetrics" },
        { 0x001DC9, "GainSpan Corp." },
        { 0x001DCA, "PAV Electronics Limited" },
        { 0x001DCB, "Exéns Development Oy" },
        { 0x001DCC, "Ayon Cyber Security, Inc" },
        { 0x001DCD, "ARRIS Group, Inc." },
        { 0x001DCE, "ARRIS Group, Inc." },
        { 0x001DCF, "ARRIS Group, Inc." },
        { 0x001DD0, "ARRIS Group, Inc." },
        { 0x001DD1, "ARRIS Group, Inc." },
        { 0x001DD2, "ARRIS Group, Inc." },
        { 0x001DD3, "ARRIS Group, Inc." },
        { 0x001DD4, "ARRIS Group, Inc." },
        { 0x001DD5, "ARRIS Group, Inc." },
        { 0x001DD6, "ARRIS Group, Inc." },
        { 0x001DD7, "Algolith" },
        { 0x001DD8, "Microsoft Corporation" },
        { 0x001DD9, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x001DDA, "Mikroelektronika spol. s r. o." },
        { 0x001DDB, "C-BEL Corporation" },
        { 0x001DDC, "HangZhou DeChangLong Tech&Info Co.,Ltd" },
        { 0x001DDD, "DAT H.K. LIMITED" },
        { 0x001DDE, "Zhejiang Broadcast&Television Technology Co.,Ltd." },
        { 0x001DDF, "Sunitec Enterprise Co.,Ltd" },
        { 0x001DE0, "Intel Corporate" },
        { 0x001DE1, "Intel Corporate" },
        { 0x001DE2, "Radionor Communications" },
        { 0x001DE3, "Intuicom" },
        { 0x001DE4, "Visioneered Image Systems" },
        { 0x001DE5, "Cisco Systems, Inc" },
        { 0x001DE6, "Cisco Systems, Inc" },
        { 0x001DE7, "Marine Sonic Technology, Ltd." },
        { 0x001DE8, "Nikko Denki Tsushin Corporation(NDTC)" },
        { 0x001DE9, "Nokia Danmark A/S" },
        { 0x001DEA, "Commtest Instruments Ltd" },
        { 0x001DEB, "DINEC International" },
        { 0x001DEC, "Marusys" },
        { 0x001DED, "Grid Net, Inc." },
        { 0x001DEE, "NEXTVISION SISTEMAS DIGITAIS DE TELEVISÃO LTDA." },
        { 0x001DEF, "TRIMM, INC." },
        { 0x001DF0, "Vidient Systems, Inc." },
        { 0x001DF1, "Intego Systems, Inc." },
        { 0x001DF2, "Netflix, Inc." },
        { 0x001DF3, "SBS Science & Technology Co., Ltd" },
        { 0x001DF4, "Magellan Technology Pty Limited" },
        { 0x001DF5, "Sunshine Co,LTD" },
        { 0x001DF6, "Samsung Electronics Co.,Ltd" },
        { 0x001DF7, "R. STAHL Schaltgeräte GmbH" },
        { 0x001DF8, "Webpro Vision Technology Corporation" },
        { 0x001DF9, "Cybiotronics (Far East) Limited" },
        { 0x001DFA, "Fujian LANDI Commercial Equipment Co.,Ltd" },
        { 0x001DFB, "NETCLEUS Systems Corporation" },
        { 0x001DFC, "KSIC" },
        { 0x001DFD, "Nokia Danmark A/S" },
        { 0x001DFE, "Palm, Inc" },
        { 0x001DFF, "Network Critical Solutions Ltd" },
        { 0x001E00, "Shantou Institute of Ultrasonic Instruments" },
        { 0x001E01, "Renesas Technology Sales Co., Ltd." },
        { 0x001E02, "Sougou Keikaku Kougyou Co.,Ltd." },
        { 0x001E03, "LiComm Co., Ltd." },
        { 0x001E04, "Hanson Research Corporation" },
        { 0x001E05, "Xseed Technologies & Computing" },
        { 0x001E06, "WIBRAIN" },
        { 0x001E07, "Winy Technology Co., Ltd." },
        { 0x001E08, "Centec Networks Inc" },
        { 0x001E09, "ZEFATEK Co.,LTD" },
        { 0x001E0A, "Syba Tech Limited" },
        { 0x001E0B, "Hewlett Packard" },
        { 0x001E0C, "Sherwood Information Partners, Inc." },
        { 0x001E0D, "Micran Ltd." },
        { 0x001E0E, "MAXI VIEW HOLDINGS LIMITED" },
        { 0x001E0F, "Briot International" },
        { 0x001E10, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x001E11, "ELELUX INTERNATIONAL LTD" },
        { 0x001E12, "Ecolab" },
        { 0x001E13, "Cisco Systems, Inc" },
        { 0x001E14, "Cisco Systems, Inc" },
        { 0x001E15, "Beech Hill Electronics" },
        { 0x001E16, "Keytronix" },
        { 0x001E17, "STN BV" },
        { 0x001E18, "Radio Activity srl" },
        { 0x001E19, "GTRI" },
        { 0x001E1A, "Best Source Taiwan Inc." },
        { 0x001E1B, "Digital Stream Technology, Inc." },
        { 0x001E1C, "SWS Australia Pty Limited" },
        { 0x001E1D, "East Coast Datacom, Inc." },
        { 0x001E1E, "Honeywell Life Safety" },
        { 0x001E1F, "Nortel Networks" },
        { 0x001E20, "Intertain Inc." },
        { 0x001E21, "Qisda Corporation" },
        { 0x001E22, "ARVOO Imaging Products BV" },
        { 0x001E23, "Electronic Educational Devices, Inc" },
        { 0x001E24, "Zhejiang Bell Technology Co.,ltd" },
        { 0x001E25, "INTEK DIGITAL" },
        { 0x001E26, "Digifriends Co. Ltd" },
        { 0x001E27, "SBN TECH Co.,Ltd." },
        { 0x001E28, "Lumexis Corporation" },
        { 0x001E29, "Hypertherm Inc" },
        { 0x001E2A, "NETGEAR" },
        { 0x001E2B, "Radio Systems Design, Inc." },
        { 0x001E2C, "CyVerse Corporation" },
        { 0x001E2D, "STIM" },
        { 0x001E2E, "SIRTI S.p.A." },
        { 0x001E2F, "DiMoto Pty Ltd" },
        { 0x001E30, "Shireen Inc" },
        { 0x001E31, "infomark" },
        { 0x001E32, "Zensys" },
        { 0x001E33, "INVENTEC CORPORATION" },
        { 0x001E34, "CryptoMetrics" },
        { 0x001E35, "Nintendo Co., Ltd." },
        { 0x001E36, "IPTE" },
        { 0x001E37, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x001E38, "Bluecard Software Technology Co., Ltd." },
        { 0x001E39, "Comsys Communication Ltd." },
        { 0x001E3A, "Nokia Danmark A/S" },
        { 0x001E3B, "Nokia Danmark A/S" },
        { 0x001E3C, "Lyngbox Media AB" },
        { 0x001E3D, "ALPS ELECTRIC CO., LTD." },
        { 0x001E3E, "KMW Inc." },
        { 0x001E3F, "TrellisWare Technologies, Inc." },
        { 0x001E40, "Shanghai DareGlobal Technologies Co.,Ltd" },
        { 0x001E41, "Microwave Communication & Component, Inc." },
        { 0x001E42, "Teltonika" },
        { 0x001E43, "AISIN AW CO.,LTD." },
        { 0x001E44, "SANTEC" },
        { 0x001E45, "Sony Mobile Communications Inc" },
        { 0x001E46, "ARRIS Group, Inc." },
        { 0x001E47, "PT. Hariff Daya Tunggal Engineering" },
        { 0x001E48, "Wi-Links" },
        { 0x001E49, "Cisco Systems, Inc" },
        { 0x001E4A, "Cisco Systems, Inc" },
        { 0x001E4B, "City Theatrical" },
        { 0x001E4C, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x001E4D, "Welkin Sciences, LLC" },
        { 0x001E4E, "DAKO EDV-Ingenieur- und Systemhaus GmbH" },
        { 0x001E4F, "Dell Inc." },
        { 0x001E50, "BATTISTONI RESEARCH" },
        { 0x001E51, "Converter Industry Srl" },
        { 0x001E52, "Apple, Inc." },
        { 0x001E53, "Further Tech Co., LTD" },
        { 0x001E54, "TOYO ELECTRIC Corporation" },
        { 0x001E55, "COWON SYSTEMS,Inc." },
        { 0x001E56, "Bally Wulff Entertainment GmbH" },
        { 0x001E57, "ALCOMA, spol. s r.o." },
        { 0x001E58, "D-Link Corporation" },
        { 0x001E59, "Silicon Turnkey Express, LLC" },
        { 0x001E5A, "ARRIS Group, Inc." },
        { 0x001E5B, "Unitron Company, Inc." },
        { 0x001E5C, "RB GeneralEkonomik" },
        { 0x001E5D, "Holosys d.o.o." },
        { 0x001E5E, "COmputime Ltd." },
        { 0x001E5F, "KwikByte, LLC" },
        { 0x001E60, "Digital Lighting Systems, Inc" },
        { 0x001E61, "ITEC GmbH" },
        { 0x001E62, "Siemon" },
        { 0x001E63, "Vibro-Meter SA" },
        { 0x001E64, "Intel Corporate" },
        { 0x001E65, "Intel Corporate" },
        { 0x001E66, "RESOL Elektronische Regelungen GmbH" },
        { 0x001E67, "Intel Corporate" },
        { 0x001E68, "Quanta Computer Inc." },
        { 0x001E69, "Thomson Inc." },
        { 0x001E6A, "Beijing Bluexon Technology Co.,Ltd" },
        { 0x001E6B, "Cisco SPVTG" },
        { 0x001E6C, "Opaque Systems" },
        { 0x001E6D, "IT R&D Center" },
        { 0x001E6E, "Shenzhen First Mile Communications Ltd" },
        { 0x001E6F, "Magna-Power Electronics, Inc." },
        { 0x001E70, "Cobham Antenna Systems" },
        { 0x001E71, "MIrcom Group of Companies" },
        { 0x001E72, "PCS" },
        { 0x001E73, "zte corporation" },
        { 0x001E74, "Sagemcom Broadband SAS" },
        { 0x001E75, "LG Electronics (Mobile Communications)" },
        { 0x001E76, "Thermo Fisher Scientific" },
        { 0x001E77, "Air2App" },
        { 0x001E78, "Owitek Technology Ltd.," },
        { 0x001E79, "Cisco Systems, Inc" },
        { 0x001E7A, "Cisco Systems, Inc" },
        { 0x001E7B, "R.I.CO. S.r.l." },
        { 0x001E7C, "Taiwick Limited" },
        { 0x001E7D, "Samsung Electronics Co.,Ltd" },
        { 0x001E7E, "Nortel Networks" },
        { 0x001E7F, "CBM of America" },
        { 0x001E80, "Icotera A/S" },
        { 0x001E81, "CNB Technology Inc." },
        { 0x001E82, "SanDisk Corporation" },
        { 0x001E83, "LAN/MAN Standards Association (LMSC)" },
        { 0x001E84, "Pika Technologies Inc." },
        { 0x001E85, "Lagotek Corporation" },
        { 0x001E86, "MEL Co.,Ltd." },
        { 0x001E87, "Realease Limited" },
        { 0x001E88, "ANDOR SYSTEM SUPPORT CO., LTD." },
        { 0x001E89, "CRFS Limited" },
        { 0x001E8A, "eCopy, Inc" },
        { 0x001E8B, "Infra Access Korea Co., Ltd." },
        { 0x001E8C, "ASUSTek COMPUTER INC." },
        { 0x001E8D, "ARRIS Group, Inc." },
        { 0x001E8E, "Hunkeler AG" },
        { 0x001E8F, "CANON INC." },
        { 0x001E90, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x001E91, "KIMIN Electronic Co., Ltd." },
        { 0x001E92, "JEULIN S.A." },
        { 0x001E93, "CiriTech Systems Inc" },
        { 0x001E94, "SUPERCOM TECHNOLOGY CORPORATION" },
        { 0x001E95, "SIGMALINK" },
        { 0x001E96, "Sepura Plc" },
        { 0x001E97, "Medium Link System Technology CO., LTD," },
        { 0x001E98, "GreenLine Communications" },
        { 0x001E99, "Vantanol Industrial Corporation" },
        { 0x001E9A, "HAMILTON Bonaduz AG" },
        { 0x001E9B, "San-Eisha, Ltd." },
        { 0x001E9C, "Fidustron INC" },
        { 0x001E9D, "Recall Technologies, Inc." },
        { 0x001E9E, "ddm hopt + schuler Gmbh + Co. KG" },
        { 0x001E9F, "Visioneering Systems, Inc." },
        { 0x001EA0, "XLN-t" },
        { 0x001EA1, "Brunata a/s" },
        { 0x001EA2, "Symx Systems, Inc." },
        { 0x001EA3, "Nokia Danmark A/S" },
        { 0x001EA4, "Nokia Danmark A/S" },
        { 0x001EA5, "ROBOTOUS, Inc." },
        { 0x001EA6, "Best IT World (India) Pvt. Ltd." },
        { 0x001EA7, "Actiontec Electronics, Inc" },
        { 0x001EA8, "Datang Mobile Communications Equipment CO.,LTD" },
        { 0x001EA9, "Nintendo Co., Ltd." },
        { 0x001EAA, "E-Senza Technologies GmbH" },
        { 0x001EAB, "TeleWell Oy" },
        { 0x001EAC, "Armadeus Systems" },
        { 0x001EAD, "Wingtech Group Limited" },
        { 0x001EAE, "Continental Automotive Systems Inc." },
        { 0x001EAF, "Ophir Optronics Ltd" },
        { 0x001EB0, "ImesD Electronica S.L." },
        { 0x001EB1, "Cryptsoft Pty Ltd" },
        { 0x001EB2, "LG Innotek" },
        { 0x001EB3, "Primex Wireless" },
        { 0x001EB4, "UNIFAT TECHNOLOGY LTD." },
        { 0x001EB5, "Ever Sparkle Technologies Ltd" },
        { 0x001EB6, "TAG Heuer SA" },
        { 0x001EB7, "TBTech, Co., Ltd." },
        { 0x001EB8, "Aloys, Inc" },
        { 0x001EB9, "Sing Fai Technology Limited" },
        { 0x001EBA, "High Density Devices AS" },
        { 0x001EBB, "BLUELIGHT TECHNOLOGY INC." },
        { 0x001EBC, "WINTECH AUTOMATION CO.,LTD." },
        { 0x001EBD, "Cisco Systems, Inc" },
        { 0x001EBE, "Cisco Systems, Inc" },
        { 0x001EBF, "Haas Automation Inc." },
        { 0x001EC0, "Microchip Technology Inc." },
        { 0x001EC1, "3COM EUROPE LTD" },
        { 0x001EC2, "Apple, Inc." },
        { 0x001EC3, "Kozio, Inc." },
        { 0x001EC4, "Celio Corp" },
        { 0x001EC5, "Middle Atlantic Products Inc" },
        { 0x001EC6, "Obvius Holdings LLC" },
        { 0x001EC7, "2Wire Inc" },
        { 0x001EC8, "Rapid Mobile (Pty) Ltd" },
        { 0x001EC9, "Dell Inc." },
        { 0x001ECA, "Nortel Networks" },
        { 0x001ECB, "RPC Energoautomatika Ltd" },
        { 0x001ECC, "CDVI" },
        { 0x001ECD, "KYLAND Technology Co. LTD" },
        { 0x001ECE, "BISA Technologies (Hong Kong) Limited" },
        { 0x001ECF, "PHILIPS ELECTRONICS UK LTD" },
        { 0x001ED0, "Ingespace" },
        { 0x001ED1, "Keyprocessor B.V." },
        { 0x001ED2, "Ray Shine Video Technology Inc" },
        { 0x001ED3, "Dot Technology Int'l Co., Ltd." },
        { 0x001ED4, "Doble Engineering" },
        { 0x001ED5, "Tekon-Automatics" },
        { 0x001ED6, "Alentec & Orion AB" },
        { 0x001ED7, "H-Stream Wireless, Inc." },
        { 0x001ED8, "Digital United Inc." },
        { 0x001ED9, "Mitsubishi Precision Co.,LTd." },
        { 0x001EDA, "Wesemann Elektrotechniek B.V." },
        { 0x001EDB, "Giken Trastem Co., Ltd." },
        { 0x001EDC, "Sony Mobile Communications Inc" },
        { 0x001EDD, "WASKO S.A." },
        { 0x001EDE, "BYD COMPANY LIMITED" },
        { 0x001EDF, "Master Industrialization Center Kista" },
        { 0x001EE0, "Urmet SpA" },
        { 0x001EE1, "Samsung Electronics Co.,Ltd" },
        { 0x001EE2, "Samsung Electronics Co.,Ltd" },
        { 0x001EE3, "T&W Electronics (ShenZhen) Co.,Ltd" },
        { 0x001EE4, "ACS Solutions France" },
        { 0x001EE5, "Cisco-Linksys, LLC" },
        { 0x001EE6, "Shenzhen Advanced Video Info-Tech Co., Ltd." },
        { 0x001EE7, "Epic Systems Inc" },
        { 0x001EE8, "Mytek" },
        { 0x001EE9, "Stoneridge Electronics AB" },
        { 0x001EEA, "Sensor Switch, Inc." },
        { 0x001EEB, "Talk-A-Phone Co." },
        { 0x001EEC, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x001EED, "Adventiq Ltd." },
        { 0x001EEE, "ETL Systems Ltd" },
        { 0x001EEF, "Cantronic International Limited" },
        { 0x001EF0, "Gigafin Networks" },
        { 0x001EF1, "Servimat" },
        { 0x001EF2, "Micro Motion Inc" },
        { 0x001EF3, "From2" },
        { 0x001EF4, "L-3 Communications Display Systems" },
        { 0x001EF5, "Hitek Automated Inc." },
        { 0x001EF6, "Cisco Systems, Inc" },
        { 0x001EF7, "Cisco Systems, Inc" },
        { 0x001EF8, "Emfinity Inc." },
        { 0x001EF9, "Pascom Kommunikations systeme GmbH." },
        { 0x001EFA, "PROTEI Ltd." },
        { 0x001EFB, "Trio Motion Technology Ltd" },
        { 0x001EFC, "JSC MASSA-K" },
        { 0x001EFD, "Microbit 2.0 AB" },
        { 0x001EFE, "LEVEL s.r.o." },
        { 0x001EFF, "Mueller-Elektronik GmbH & Co. KG" },
        { 0x001F00, "Nokia Danmark A/S" },
        { 0x001F01, "Nokia Danmark A/S" },
        { 0x001F02, "Pixelmetrix Corporation Pte Ltd" },
        { 0x001F03, "NUM AG" },
        { 0x001F04, "Granch Ltd." },
        { 0x001F05, "iTAS Technology Corp." },
        { 0x001F06, "Integrated Dispatch Solutions" },
        { 0x001F07, "AZTEQ Mobile" },
        { 0x001F08, "RISCO LTD" },
        { 0x001F09, "Jastec" },
        { 0x001F0A, "Nortel Networks" },
        { 0x001F0B, "Federal State Unitary Enterprise Industrial UnionElectropribor" },
        { 0x001F0C, "Intelligent Digital Services GmbH" },
        { 0x001F0D, "L3 Communications - Telemetry West" },
        { 0x001F0E, "Japan Kyastem Co., Ltd" },
        { 0x001F0F, "Select Engineered Systems" },
        { 0x001F10, "TOLEDO DO BRASIL INDUSTRIA DE BALANCAS LTDA" },
        { 0x001F11, "OPENMOKO, INC." },
        { 0x001F12, "Juniper Networks" },
        { 0x001F13, "S.& A.S. Ltd." },
        { 0x001F14, "NexG" },
        { 0x001F15, "Bioscrypt Inc" },
        { 0x001F16, "Wistron Corporation" },
        { 0x001F17, "IDX Company, Ltd." },
        { 0x001F18, "Hakusan.Mfg.Co,.Ltd" },
        { 0x001F19, "BEN-RI ELECTRONICA S.A." },
        { 0x001F1A, "Prominvest" },
        { 0x001F1B, "RoyalTek Company Ltd." },
        { 0x001F1C, "KOBISHI ELECTRIC Co.,Ltd." },
        { 0x001F1D, "Atlas Material Testing Technology LLC" },
        { 0x001F1E, "Astec Technology Co., Ltd" },
        { 0x001F1F, "Edimax Technology Co. Ltd." },
        { 0x001F20, "Logitech Europe SA" },
        { 0x001F21, "Inner Mongolia Yin An Science & Technology Development Co.,L" },
        { 0x001F22, "Source Photonics, Inc." },
        { 0x001F23, "Interacoustics" },
        { 0x001F24, "DIGITVIEW TECHNOLOGY CO., LTD." },
        { 0x001F25, "MBS GmbH" },
        { 0x001F26, "Cisco Systems, Inc" },
        { 0x001F27, "Cisco Systems, Inc" },
        { 0x001F28, "HPN Supply Chain" },
        { 0x001F29, "Hewlett Packard" },
        { 0x001F2A, "ACCM" },
        { 0x001F2B, "Orange Logic" },
        { 0x001F2C, "Starbridge Networks" },
        { 0x001F2D, "Electro-Optical Imaging, Inc." },
        { 0x001F2E, "Triangle Research Int'l Pte Ltd" },
        { 0x001F2F, "Berker GmbH & Co. KG" },
        { 0x001F30, "Travelping" },
        { 0x001F31, "Radiocomp" },
        { 0x001F32, "Nintendo Co., Ltd." },
        { 0x001F33, "NETGEAR" },
        { 0x001F34, "Lung Hwa Electronics Co., Ltd." },
        { 0x001F35, "AIR802 LLC" },
        { 0x001F36, "Bellwin Information Co. Ltd.," },
        { 0x001F37, "Genesis I&C" },
        { 0x001F38, "POSITRON" },
        { 0x001F39, "Construcciones y Auxiliar de Ferrocarriles, S.A." },
        { 0x001F3A, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x001F3B, "Intel Corporate" },
        { 0x001F3C, "Intel Corporate" },
        { 0x001F3D, "Qbit GmbH" },
        { 0x001F3E, "RP-Technik e.K." },
        { 0x001F3F, "AVM GmbH" },
        { 0x001F40, "Speakercraft Inc." },
        { 0x001F41, "Ruckus Wireless" },
        { 0x001F42, "Etherstack plc" },
        { 0x001F43, "ENTES ELEKTRONIK" },
        { 0x001F44, "GE Transportation Systems" },
        { 0x001F45, "Enterasys" },
        { 0x001F46, "Nortel Networks" },
        { 0x001F47, "MCS Logic Inc." },
        { 0x001F48, "Mojix Inc." },
        { 0x001F49, "Manhattan TV Ltd" },
        { 0x001F4A, "Albentia Systems S.A." },
        { 0x001F4B, "Lineage Power" },
        { 0x001F4C, "Roseman Engineering Ltd" },
        { 0x001F4D, "Segnetics LLC" },
        { 0x001F4E, "ConMed Linvatec" },
        { 0x001F4F, "Thinkware Co. Ltd." },
        { 0x001F50, "Swissdis AG" },
        { 0x001F51, "HD Communications Corp" },
        { 0x001F52, "UVT Unternehmensberatung fur Verkehr und Technik GmbH" },
        { 0x001F53, "GEMAC Chemnitz GmbH" },
        { 0x001F54, "Lorex Technology Inc." },
        { 0x001F55, "Honeywell Security (China) Co., Ltd." },
        { 0x001F56, "DIGITAL FORECAST" },
        { 0x001F57, "Phonik Innovation Co.,LTD" },
        { 0x001F58, "EMH Energiemesstechnik GmbH" },
        { 0x001F59, "Kronback Tracers" },
        { 0x001F5A, "Beckwith Electric Co." },
        { 0x001F5B, "Apple, Inc." },
        { 0x001F5C, "Nokia Danmark A/S" },
        { 0x001F5D, "Nokia Danmark A/S" },
        { 0x001F5E, "Dyna Technology Co.,Ltd." },
        { 0x001F5F, "Blatand GmbH" },
        { 0x001F60, "COMPASS SYSTEMS CORP." },
        { 0x001F61, "Talent Communication Networks Inc." },
        { 0x001F62, "JSC Stilsoft" },
        { 0x001F63, "JSC Goodwin-Europa" },
        { 0x001F64, "Beijing Autelan Technology Inc." },
        { 0x001F65, "KOREA ELECTRIC TERMINAL CO., LTD." },
        { 0x001F66, "PLANAR LLC" },
        { 0x001F67, "Hitachi,Ltd." },
        { 0x001F68, "Martinsson Elektronik AB" },
        { 0x001F69, "Pingood Technology Co., Ltd." },
        { 0x001F6A, "PacketFlux Technologies, Inc." },
        { 0x001F6B, "LG Electronics (Mobile Communications)" },
        { 0x001F6C, "Cisco Systems, Inc" },
        { 0x001F6D, "Cisco Systems, Inc" },
        { 0x001F6E, "Vtech Engineering Corporation" },
        { 0x001F6F, "Fujian Sunnada Communication Co.,Ltd." },
        { 0x001F70, "Botik Technologies LTD" },
        { 0x001F71, "xG Technology, Inc." },
        { 0x001F72, "QingDao Hiphone Technology Co,.Ltd" },
        { 0x001F73, "Teraview Technology Co., Ltd." },
        { 0x001F74, "Eigen Development" },
        { 0x001F75, "GiBahn Media" },
        { 0x001F76, "AirLogic Systems Inc." },
        { 0x001F77, "HEOL DESIGN" },
        { 0x001F78, "Blue Fox Porini Textile" },
        { 0x001F79, "Lodam Electronics A/S" },
        { 0x001F7A, "WiWide Inc." },
        { 0x001F7B, "TechNexion Ltd." },
        { 0x001F7C, "Witelcom AS" },
        { 0x001F7D, "Embedded Wireless GmbH" },
        { 0x001F7E, "ARRIS Group, Inc." },
        { 0x001F7F, "Phabrix Limited" },
        { 0x001F80, "Lucas Holding bv" },
        { 0x001F81, "Accel Semiconductor Corp" },
        { 0x001F82, "Cal-Comp Electronics & Communications Company Ltd." },
        { 0x001F83, "Teleplan Technology Services Sdn Bhd" },
        { 0x001F84, "Gigle Semiconductor" },
        { 0x001F85, "Apriva ISS, LLC" },
        { 0x001F86, "digEcor" },
        { 0x001F87, "Skydigital Inc." },
        { 0x001F88, "FMS Force Measuring Systems AG" },
        { 0x001F89, "Signalion GmbH" },
        { 0x001F8A, "Ellion Digital Inc." },
        { 0x001F8B, "Cache IQ" },
        { 0x001F8C, "CCS Inc." },
        { 0x001F8D, "Ingenieurbuero Stark GmbH und Ko. KG" },
        { 0x001F8E, "Metris USA Inc." },
        { 0x001F8F, "Shanghai Bellmann Digital Source Co.,Ltd." },
        { 0x001F90, "Actiontec Electronics, Inc" },
        { 0x001F91, "DBS Lodging Technologies, LLC" },
        { 0x001F92, "Avigilon Corporation" },
        { 0x001F93, "Xiotech Corporation" },
        { 0x001F94, "Lascar Electronics Ltd" },
        { 0x001F95, "Sagemcom Broadband SAS" },
        { 0x001F96, "APROTECH CO.LTD" },
        { 0x001F97, "BERTANA srl" },
        { 0x001F98, "DAIICHI-DENTSU LTD." },
        { 0x001F99, "SERONICS co.ltd" },
        { 0x001F9A, "Nortel Networks" },
        { 0x001F9B, "POSBRO" },
        { 0x001F9C, "LEDCO" },
        { 0x001F9D, "Cisco Systems, Inc" },
        { 0x001F9E, "Cisco Systems, Inc" },
        { 0x001F9F, "Thomson Telecom Belgium" },
        { 0x001FA0, "A10 Networks" },
        { 0x001FA1, "Gtran Inc" },
        { 0x001FA2, "Datron World Communications, Inc." },
        { 0x001FA3, "T&W Electronics(Shenzhen)Co.,Ltd." },
        { 0x001FA4, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x001FA5, "Blue-White Industries" },
        { 0x001FA6, "Stilo srl" },
        { 0x001FA7, "Sony Interactive Entertainment Inc." },
        { 0x001FA8, "Smart Energy Instruments Inc." },
        { 0x001FA9, "Atlanta DTH, Inc." },
        { 0x001FAA, "Taseon, Inc." },
        { 0x001FAB, "I.S HIGH TECH.INC" },
        { 0x001FAC, "Goodmill Systems Ltd" },
        { 0x001FAD, "Brown Innovations, Inc" },
        { 0x001FAE, "Blick South Africa (Pty) Ltd" },
        { 0x001FAF, "NextIO, Inc." },
        { 0x001FB0, "TimeIPS, Inc." },
        { 0x001FB1, "Cybertech Inc." },
        { 0x001FB2, "Sontheim Industrie Elektronik GmbH" },
        { 0x001FB3, "2Wire Inc" },
        { 0x001FB4, "SmartShare Systems" },
        { 0x001FB5, "I/O Interconnect Inc." },
        { 0x001FB6, "Chi Lin Technology Co., Ltd." },
        { 0x001FB7, "WiMate Technologies Corp." },
        { 0x001FB8, "Universal Remote Control, Inc." },
        { 0x001FB9, "Paltronics" },
        { 0x001FBA, "Boyoung Tech" },
        { 0x001FBB, "Xenatech Co.,LTD" },
        { 0x001FBC, "EVGA Corporation" },
        { 0x001FBD, "Kyocera Wireless Corp." },
        { 0x001FBE, "Shenzhen Mopnet Industrial Co.,Ltd" },
        { 0x001FBF, "Fulhua Microelectronics Corp. Taiwan Branch" },
        { 0x001FC0, "Control Express Finland Oy" },
        { 0x001FC1, "Hanlong Technology Co.,LTD" },
        { 0x001FC2, "Jow Tong Technology Co Ltd" },
        { 0x001FC3, "SmartSynch, Inc" },
        { 0x001FC4, "ARRIS Group, Inc." },
        { 0x001FC5, "Nintendo Co., Ltd." },
        { 0x001FC6, "ASUSTek COMPUTER INC." },
        { 0x001FC7, "Casio Hitachi Mobile Communications Co., Ltd." },
        { 0x001FC8, "Up-Today Industrial Co., Ltd." },
        { 0x001FC9, "Cisco Systems, Inc" },
        { 0x001FCA, "Cisco Systems, Inc" },
        { 0x001FCB, "NIW Solutions" },
        { 0x001FCC, "Samsung Electronics Co.,Ltd" },
        { 0x001FCD, "Samsung Electronics Co.,Ltd" },
        { 0x001FCE, "QTECH LLC" },
        { 0x001FCF, "MSI Technology GmbH" },
        { 0x001FD0, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x001FD1, "OPTEX CO.,LTD." },
        { 0x001FD2, "COMMTECH TECHNOLOGY MACAO COMMERCIAL OFFSHORE LTD." },
        { 0x001FD3, "RIVA Networks Inc." },
        { 0x001FD4, "4IPNET, INC." },
        { 0x001FD5, "MICRORISC s.r.o." },
        { 0x001FD6, "Shenzhen Allywll" },
        { 0x001FD7, "TELERAD SA" },
        { 0x001FD8, "A-TRUST COMPUTER CORPORATION" },
        { 0x001FD9, "RSD Communications Ltd" },
        { 0x001FDA, "Nortel Networks" },
        { 0x001FDB, "Network Supply Corp.," },
        { 0x001FDC, "Mobile Safe Track Ltd" },
        { 0x001FDD, "GDI LLC" },
        { 0x001FDE, "Nokia Danmark A/S" },
        { 0x001FDF, "Nokia Danmark A/S" },
        { 0x001FE0, "EdgeVelocity Corp" },
        { 0x001FE1, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x001FE2, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x001FE3, "LG Electronics (Mobile Communications)" },
        { 0x001FE4, "Sony Mobile Communications Inc" },
        { 0x001FE5, "In-Circuit GmbH" },
        { 0x001FE6, "Alphion Corporation" },
        { 0x001FE7, "Simet" },
        { 0x001FE8, "KURUSUGAWA Electronics Industry Inc,." },
        { 0x001FE9, "Printrex, Inc." },
        { 0x001FEA, "Applied Media Technologies Corporation" },
        { 0x001FEB, "Trio Datacom Pty Ltd" },
        { 0x001FEC, "Synapse Électronique" },
        { 0x001FED, "Tecan Systems Inc." },
        { 0x001FEE, "ubisys technologies GmbH" },
        { 0x001FEF, "SHINSEI INDUSTRIES CO.,LTD" },
        { 0x001FF0, "Audio Partnership" },
        { 0x001FF1, "Paradox Hellas S.A." },
        { 0x001FF2, "VIA Technologies, Inc." },
        { 0x001FF3, "Apple, Inc." },
        { 0x001FF4, "Power Monitors, Inc." },
        { 0x001FF5, "Kongsberg Defence & Aerospace" },
        { 0x001FF6, "PS Audio International" },
        { 0x001FF7, "Nakajima All Precision Co., Ltd." },
        { 0x001FF8, "Siemens AG, Sector Industry, Drive Technologies, Motion Control Systems" },
        { 0x001FF9, "Advanced Knowledge Associates" },
        { 0x001FFA, "Coretree, Co, Ltd" },
        { 0x001FFB, "Green Packet Bhd" },
        { 0x001FFC, "Riccius+Sohn GmbH" },
        { 0x001FFD, "Indigo Mobile Technologies Corp." },
        { 0x001FFE, "HPN Supply Chain" },
        { 0x001FFF, "Respironics, Inc." },
        { 0x002000, "LEXMARK INTERNATIONAL, INC." },
        { 0x002001, "DSP SOLUTIONS, INC." },
        { 0x002002, "SERITECH ENTERPRISE CO., LTD." },
        { 0x002003, "PIXEL POWER LTD." },
        { 0x002004, "YAMATAKE-HONEYWELL CO., LTD." },
        { 0x002005, "SIMPLE TECHNOLOGY" },
        { 0x002006, "GARRETT COMMUNICATIONS, INC." },
        { 0x002007, "SFA, INC." },
        { 0x002008, "CABLE & COMPUTER TECHNOLOGY" },
        { 0x002009, "PACKARD BELL ELEC., INC." },
        { 0x00200A, "SOURCE-COMM CORP." },
        { 0x00200B, "OCTAGON SYSTEMS CORP." },
        { 0x00200C, "ADASTRA SYSTEMS CORP." },
        { 0x00200D, "CARL ZEISS" },
        { 0x00200E, "NSSLGlobal Technologies AS" },
        { 0x00200F, "EBRAINS Inc" },
        { 0x002010, "JEOL SYSTEM TECHNOLOGY CO. LTD" },
        { 0x002011, "CANOPUS CO., LTD." },
        { 0x002012, "CAMTRONICS MEDICAL SYSTEMS" },
        { 0x002013, "DIVERSIFIED TECHNOLOGY, INC." },
        { 0x002014, "GLOBAL VIEW CO., LTD." },
        { 0x002015, "ACTIS COMPUTER SA" },
        { 0x002016, "SHOWA ELECTRIC WIRE & CABLE CO" },
        { 0x002017, "ORBOTECH" },
        { 0x002018, "CIS TECHNOLOGY INC." },
        { 0x002019, "OHLER GMBH" },
        { 0x00201A, "MRV Communications, Inc." },
        { 0x00201B, "NORTHERN TELECOM/NETWORK" },
        { 0x00201C, "EXCEL, INC." },
        { 0x00201D, "KATANA PRODUCTS" },
        { 0x00201E, "NETQUEST CORPORATION" },
        { 0x00201F, "BEST POWER TECHNOLOGY, INC." },
        { 0x002020, "MEGATRON COMPUTER INDUSTRIES PTY, LTD." },
        { 0x002021, "ALGORITHMS SOFTWARE PVT. LTD." },
        { 0x002022, "NMS Communications" },
        { 0x002023, "T.C. TECHNOLOGIES PTY. LTD" },
        { 0x002024, "PACIFIC COMMUNICATION SCIENCES" },
        { 0x002025, "CONTROL TECHNOLOGY, INC." },
        { 0x002026, "AMKLY SYSTEMS, INC." },
        { 0x002027, "MING FORTUNE INDUSTRY CO., LTD" },
        { 0x002028, "WEST EGG SYSTEMS, INC." },
        { 0x002029, "TELEPROCESSING PRODUCTS, INC." },
        { 0x00202A, "N.V. DZINE" },
        { 0x00202B, "ADVANCED TELECOMMUNICATIONS MODULES, LTD." },
        { 0x00202C, "WELLTRONIX CO., LTD." },
        { 0x00202D, "TAIYO CORPORATION" },
        { 0x00202E, "DAYSTAR DIGITAL" },
        { 0x00202F, "ZETA COMMUNICATIONS, LTD." },
        { 0x002030, "ANALOG & DIGITAL SYSTEMS" },
        { 0x002031, "Tattile SRL" },
        { 0x002032, "ALCATEL TAISEL" },
        { 0x002033, "SYNAPSE TECHNOLOGIES, INC." },
        { 0x002034, "ROTEC INDUSTRIEAUTOMATION GMBH" },
        { 0x002035, "IBM Corp" },
        { 0x002036, "BMC SOFTWARE" },
        { 0x002037, "Seagate Technology" },
        { 0x002038, "VME MICROSYSTEMS INTERNATIONAL CORPORATION" },
        { 0x002039, "SCINETS" },
        { 0x00203A, "DIGITAL BI0METRICS INC." },
        { 0x00203B, "WISDM LTD." },
        { 0x00203C, "EUROTIME AB" },
        { 0x00203D, "Honeywell Environmental & Combustion Controls" },
        { 0x00203E, "LogiCan Technologies, Inc." },
        { 0x00203F, "JUKI CORPORATION" },
        { 0x002040, "ARRIS Group, Inc." },
        { 0x002041, "DATA NET" },
        { 0x002042, "DATAMETRICS CORP." },
        { 0x002043, "NEURON COMPANY LIMITED" },
        { 0x002044, "GENITECH PTY LTD" },
        { 0x002045, "ION Networks, Inc." },
        { 0x002046, "CIPRICO, INC." },
        { 0x002047, "STEINBRECHER CORP." },
        { 0x002048, "Marconi Communications" },
        { 0x002049, "COMTRON, INC." },
        { 0x00204A, "PRONET GMBH" },
        { 0x00204B, "AUTOCOMPUTER CO., LTD." },
        { 0x00204C, "MITRON COMPUTER PTE LTD." },
        { 0x00204D, "INOVIS GMBH" },
        { 0x00204E, "NETWORK SECURITY SYSTEMS, INC." },
        { 0x00204F, "DEUTSCHE AEROSPACE AG" },
        { 0x002050, "KOREA COMPUTER INC." },
        { 0x002051, "Verilink Corporation" },
        { 0x002052, "RAGULA SYSTEMS" },
        { 0x002053, "HUNTSVILLE MICROSYSTEMS, INC." },
        { 0x002054, "Sycamore Networks" },
        { 0x002055, "ALTECH CO., LTD." },
        { 0x002056, "NEOPRODUCTS" },
        { 0x002057, "TITZE DATENTECHNIK GmbH" },
        { 0x002058, "ALLIED SIGNAL INC." },
        { 0x002059, "MIRO COMPUTER PRODUCTS AG" },
        { 0x00205A, "COMPUTER IDENTICS" },
        { 0x00205B, "Kentrox, LLC" },
        { 0x00205C, "InterNet Systems of Florida, Inc." },
        { 0x00205D, "NANOMATIC OY" },
        { 0x00205E, "CASTLE ROCK, INC." },
        { 0x00205F, "GAMMADATA COMPUTER GMBH" },
        { 0x002060, "ALCATEL ITALIA S.p.A." },
        { 0x002061, "GarrettCom, Inc." },
        { 0x002062, "SCORPION LOGIC, LTD." },
        { 0x002063, "WIPRO INFOTECH LTD." },
        { 0x002064, "PROTEC MICROSYSTEMS, INC." },
        { 0x002065, "SUPERNET NETWORKING INC." },
        { 0x002066, "GENERAL MAGIC, INC." },
        { 0x002067, "Private" },
        { 0x002068, "ISDYNE" },
        { 0x002069, "ISDN SYSTEMS CORPORATION" },
        { 0x00206A, "OSAKA COMPUTER CORP." },
        { 0x00206B, "KONICA MINOLTA HOLDINGS, INC." },
        { 0x00206C, "EVERGREEN TECHNOLOGY CORP." },
        { 0x00206D, "DATA RACE, INC." },
        { 0x00206E, "XACT, INC." },
        { 0x00206F, "FLOWPOINT CORPORATION" },
        { 0x002070, "HYNET, LTD." },
        { 0x002071, "IBR GMBH" },
        { 0x002072, "WORKLINK INNOVATIONS" },
        { 0x002073, "FUSION SYSTEMS CORPORATION" },
        { 0x002074, "SUNGWOON SYSTEMS" },
        { 0x002075, "MOTOROLA COMMUNICATION ISRAEL" },
        { 0x002076, "REUDO CORPORATION" },
        { 0x002077, "KARDIOS SYSTEMS CORP." },
        { 0x002078, "RUNTOP, INC." },
        { 0x002079, "MIKRON GMBH" },
        { 0x00207A, "WiSE Communications, Inc." },
        { 0x00207B, "Intel Corporation" },
        { 0x00207C, "AUTEC GMBH" },
        { 0x00207D, "ADVANCED COMPUTER APPLICATIONS" },
        { 0x00207E, "FINECOM CO., LTD." },
        { 0x00207F, "KYOEI SANGYO CO., LTD." },
        { 0x002080, "SYNERGY (UK) LTD." },
        { 0x002081, "TITAN ELECTRONICS" },
        { 0x002082, "ONEAC CORPORATION" },
        { 0x002083, "PRESTICOM INCORPORATED" },
        { 0x002084, "OCE PRINTING SYSTEMS, GMBH" },
        { 0x002085, "Eaton Corporation" },
        { 0x002086, "MICROTECH ELECTRONICS LIMITED" },
        { 0x002087, "MEMOTEC, INC." },
        { 0x002088, "GLOBAL VILLAGE COMMUNICATION" },
        { 0x002089, "T3PLUS NETWORKING, INC." },
        { 0x00208A, "SONIX COMMUNICATIONS, LTD." },
        { 0x00208B, "LAPIS TECHNOLOGIES, INC." },
        { 0x00208C, "GALAXY NETWORKS, INC." },
        { 0x00208D, "CMD TECHNOLOGY" },
        { 0x00208E, "CHEVIN SOFTWARE ENG. LTD." },
        { 0x00208F, "ECI Telecom Ltd." },
        { 0x002090, "ADVANCED COMPRESSION TECHNOLOGY, INC." },
        { 0x002091, "J125, NATIONAL SECURITY AGENCY" },
        { 0x002092, "CHESS ENGINEERING B.V." },
        { 0x002093, "LANDINGS TECHNOLOGY CORP." },
        { 0x002094, "CUBIX CORPORATION" },
        { 0x002095, "RIVA ELECTRONICS" },
        { 0x002096, "Invensys" },
        { 0x002097, "APPLIED SIGNAL TECHNOLOGY" },
        { 0x002098, "HECTRONIC AB" },
        { 0x002099, "BON ELECTRIC CO., LTD." },
        { 0x00209A, "THE 3DO COMPANY" },
        { 0x00209B, "ERSAT ELECTRONIC GMBH" },
        { 0x00209C, "PRIMARY ACCESS CORP." },
        { 0x00209D, "LIPPERT AUTOMATIONSTECHNIK" },
        { 0x00209E, "BROWN'S OPERATING SYSTEM SERVICES, LTD." },
        { 0x00209F, "MERCURY COMPUTER SYSTEMS, INC." },
        { 0x0020A0, "OA LABORATORY CO., LTD." },
        { 0x0020A1, "DOVATRON" },
        { 0x0020A2, "GALCOM NETWORKING LTD." },
        { 0x0020A3, "Harmonic, Inc" },
        { 0x0020A4, "MULTIPOINT NETWORKS" },
        { 0x0020A5, "API ENGINEERING" },
        { 0x0020A6, "Proxim Wireless" },
        { 0x0020A7, "PAIRGAIN TECHNOLOGIES, INC." },
        { 0x0020A8, "SAST TECHNOLOGY CORP." },
        { 0x0020A9, "WHITE HORSE INDUSTRIAL" },
        { 0x0020AA, "Ericsson Television Limited" },
        { 0x0020AB, "MICRO INDUSTRIES CORP." },
        { 0x0020AC, "INTERFLEX DATENSYSTEME GMBH" },
        { 0x0020AD, "LINQ SYSTEMS" },
        { 0x0020AE, "ORNET DATA COMMUNICATION TECH." },
        { 0x0020AF, "3COM" },
        { 0x0020B0, "GATEWAY DEVICES, INC." },
        { 0x0020B1, "COMTECH RESEARCH INC." },
        { 0x0020B2, "GKD Gesellschaft Fur Kommunikation Und Datentechnik" },
        { 0x0020B3, "Tattile SRL" },
        { 0x0020B4, "TERMA ELEKTRONIK AS" },
        { 0x0020B5, "YASKAWA ELECTRIC CORPORATION" },
        { 0x0020B6, "AGILE NETWORKS, INC." },
        { 0x0020B7, "NAMAQUA COMPUTERWARE" },
        { 0x0020B8, "PRIME OPTION, INC." },
        { 0x0020B9, "METRICOM, INC." },
        { 0x0020BA, "CENTER FOR HIGH PERFORMANCE" },
        { 0x0020BB, "ZAX CORPORATION" },
        { 0x0020BC, "Long Reach Networks Pty Ltd" },
        { 0x0020BD, "NIOBRARA R & D CORPORATION" },
        { 0x0020BE, "LAN ACCESS CORP." },
        { 0x0020BF, "AEHR TEST SYSTEMS" },
        { 0x0020C0, "PULSE ELECTRONICS, INC." },
        { 0x0020C1, "SAXA, Inc." },
        { 0x0020C2, "TEXAS MEMORY SYSTEMS, INC." },
        { 0x0020C3, "COUNTER SOLUTIONS LTD." },
        { 0x0020C4, "INET,INC." },
        { 0x0020C5, "EAGLE TECHNOLOGY" },
        { 0x0020C6, "NECTEC" },
        { 0x0020C7, "AKAI Professional M.I. Corp." },
        { 0x0020C8, "LARSCOM INCORPORATED" },
        { 0x0020C9, "VICTRON BV" },
        { 0x0020CA, "DIGITAL OCEAN" },
        { 0x0020CB, "PRETEC ELECTRONICS CORP." },
        { 0x0020CC, "DIGITAL SERVICES, LTD." },
        { 0x0020CD, "HYBRID NETWORKS, INC." },
        { 0x0020CE, "LOGICAL DESIGN GROUP, INC." },
        { 0x0020CF, "TEST & MEASUREMENT SYSTEMS INC" },
        { 0x0020D0, "VERSALYNX CORPORATION" },
        { 0x0020D1, "MICROCOMPUTER SYSTEMS (M) SDN." },
        { 0x0020D2, "RAD DATA COMMUNICATIONS, LTD." },
        { 0x0020D3, "OST (OUEST STANDARD TELEMATIQU" },
        { 0x0020D4, "Cabletron Systems, Inc." },
        { 0x0020D5, "VIPA GMBH" },
        { 0x0020D6, "Breezecom, Ltd." },
        { 0x0020D7, "JAPAN MINICOMPUTER SYSTEMS CO., Ltd." },
        { 0x0020D8, "Nortel Networks" },
        { 0x0020D9, "PANASONIC TECHNOLOGIES, INC./MIECO-US" },
        { 0x0020DA, "Alcatel-Lucent Enterprise" },
        { 0x0020DB, "XNET TECHNOLOGY, INC." },
        { 0x0020DC, "DENSITRON TAIWAN LTD." },
        { 0x0020DD, "Cybertec Pty Ltd" },
        { 0x0020DE, "JAPAN DIGITAL LABORAT'Y CO.LTD" },
        { 0x0020DF, "KYOSAN ELECTRIC MFG. CO., LTD." },
        { 0x0020E0, "Actiontec Electronics, Inc" },
        { 0x0020E1, "ALAMAR ELECTRONICS" },
        { 0x0020E2, "INFORMATION RESOURCE ENGINEERING" },
        { 0x0020E3, "MCD KENCOM CORPORATION" },
        { 0x0020E4, "HSING TECH ENTERPRISE CO., LTD" },
        { 0x0020E5, "APEX DATA, INC." },
        { 0x0020E6, "LIDKOPING MACHINE TOOLS AB" },
        { 0x0020E7, "B&W NUCLEAR SERVICE COMPANY" },
        { 0x0020E8, "DATATREK CORPORATION" },
        { 0x0020E9, "DANTEL" },
        { 0x0020EA, "EFFICIENT NETWORKS, INC." },
        { 0x0020EB, "CINCINNATI MICROWAVE, INC." },
        { 0x0020EC, "TECHWARE SYSTEMS CORP." },
        { 0x0020ED, "GIGA-BYTE TECHNOLOGY CO., LTD." },
        { 0x0020EE, "GTECH CORPORATION" },
        { 0x0020EF, "USC CORPORATION" },
        { 0x0020F0, "UNIVERSAL MICROELECTRONICS CO." },
        { 0x0020F1, "ALTOS INDIA LIMITED" },
        { 0x0020F2, "Oracle Corporation" },
        { 0x0020F3, "RAYNET CORPORATION" },
        { 0x0020F4, "SPECTRIX CORPORATION" },
        { 0x0020F5, "PANDATEL AG" },
        { 0x0020F6, "NET TEK AND KARLNET, INC." },
        { 0x0020F7, "CYBERDATA CORPORATION" },
        { 0x0020F8, "CARRERA COMPUTERS, INC." },
        { 0x0020F9, "PARALINK NETWORKS, INC." },
        { 0x0020FA, "GDE SYSTEMS, INC." },
        { 0x0020FB, "OCTEL COMMUNICATIONS CORP." },
        { 0x0020FC, "MATROX" },
        { 0x0020FD, "ITV TECHNOLOGIES, INC." },
        { 0x0020FE, "TOPWARE INC. / GRAND COMPUTER" },
        { 0x0020FF, "SYMMETRICAL TECHNOLOGIES" },
        { 0x002100, "Gemtek Technology Co., Ltd." },
        { 0x002101, "Aplicaciones Electronicas Quasar (AEQ)" },
        { 0x002102, "UpdateLogic Inc." },
        { 0x002103, "GHI Electronics, LLC" },
        { 0x002104, "Gigaset Communications GmbH" },
        { 0x002105, "Alcatel-Lucent IPD" },
        { 0x002106, "RIM Testing Services" },
        { 0x002107, "Seowonintech Co Ltd." },
        { 0x002108, "Nokia Danmark A/S" },
        { 0x002109, "Nokia Danmark A/S" },
        { 0x00210A, "byd:sign Corporation" },
        { 0x00210B, "GEMINI TRAZE RFID PVT. LTD." },
        { 0x00210C, "Cymtec Systems, Inc." },
        { 0x00210D, "SAMSIN INNOTEC" },
        { 0x00210E, "Orpak Systems L.T.D." },
        { 0x00210F, "Cernium Corp" },
        { 0x002110, "Clearbox Systems" },
        { 0x002111, "Uniphone Inc." },
        { 0x002112, "WISCOM SYSTEM CO.,LTD" },
        { 0x002113, "Padtec S/A" },
        { 0x002114, "Hylab Technology Inc." },
        { 0x002115, "PHYWE Systeme GmbH & Co. KG" },
        { 0x002116, "Transcon Electronic Systems, spol. s r. o." },
        { 0x002117, "Tellord" },
        { 0x002118, "Athena Tech, Inc." },
        { 0x002119, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x00211A, "LInTech Corporation" },
        { 0x00211B, "Cisco Systems, Inc" },
        { 0x00211C, "Cisco Systems, Inc" },
        { 0x00211D, "Dataline AB" },
        { 0x00211E, "ARRIS Group, Inc." },
        { 0x00211F, "SHINSUNG DELTATECH CO.,LTD." },
        { 0x002120, "Sequel Technologies" },
        { 0x002121, "VRmagic GmbH" },
        { 0x002122, "Chip-pro Ltd." },
        { 0x002123, "Aerosat Avionics" },
        { 0x002124, "Optos Plc" },
        { 0x002125, "KUK JE TONG SHIN Co.,LTD" },
        { 0x002126, "Shenzhen Torch Equipment Co., Ltd." },
        { 0x002127, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x002128, "Oracle Corporation" },
        { 0x002129, "Cisco-Linksys, LLC" },
        { 0x00212A, "Audiovox Corporation" },
        { 0x00212B, "MSA Auer" },
        { 0x00212C, "SemIndia System Private Limited" },
        { 0x00212D, "SCIMOLEX CORPORATION" },
        { 0x00212E, "dresden-elektronik" },
        { 0x00212F, "Phoebe Micro Inc." },
        { 0x002130, "Keico Hightech Inc." },
        { 0x002131, "Blynke Inc." },
        { 0x002132, "Masterclock, Inc." },
        { 0x002133, "Building B, Inc" },
        { 0x002134, "Brandywine Communications" },
        { 0x002135, "ALCATEL-LUCENT" },
        { 0x002136, "ARRIS Group, Inc." },
        { 0x002137, "Bay Controls, LLC" },
        { 0x002138, "Cepheid" },
        { 0x002139, "Escherlogic Inc." },
        { 0x00213A, "Winchester Systems Inc." },
        { 0x00213B, "Berkshire Products, Inc" },
        { 0x00213C, "AliphCom" },
        { 0x00213D, "Cermetek Microelectronics, Inc." },
        { 0x00213E, "TomTom" },
        { 0x00213F, "A-Team Technology Ltd." },
        { 0x002140, "EN Technologies Inc." },
        { 0x002141, "RADLIVE" },
        { 0x002142, "Advanced Control Systems doo" },
        { 0x002143, "ARRIS Group, Inc." },
        { 0x002144, "SS Telecoms" },
        { 0x002145, "Semptian Technologies Ltd." },
        { 0x002146, "Sanmina-SCI" },
        { 0x002147, "Nintendo Co., Ltd." },
        { 0x002148, "Kaco Solar Korea" },
        { 0x002149, "China Daheng Group ,Inc." },
        { 0x00214A, "Pixel Velocity, Inc" },
        { 0x00214B, "Shenzhen HAMP Science & Technology Co.,Ltd" },
        { 0x00214C, "Samsung Electronics Co.,Ltd" },
        { 0x00214D, "Guangzhou Skytone Transmission Technology Com. Ltd." },
        { 0x00214E, "GS Yuasa Power Supply Ltd." },
        { 0x00214F, "ALPS ELECTRIC CO., LTD." },
        { 0x002150, "EYEVIEW ELECTRONICS" },
        { 0x002151, "Millinet Co., Ltd." },
        { 0x002152, "General Satellite Research & Development Limited" },
        { 0x002153, "SeaMicro Inc." },
        { 0x002154, "D-TACQ Solutions Ltd" },
        { 0x002155, "Cisco Systems, Inc" },
        { 0x002156, "Cisco Systems, Inc" },
        { 0x002157, "National Datacast, Inc." },
        { 0x002158, "Style Flying Technology Co." },
        { 0x002159, "Juniper Networks" },
        { 0x00215A, "Hewlett Packard" },
        { 0x00215B, "SenseAnywhere" },
        { 0x00215C, "Intel Corporate" },
        { 0x00215D, "Intel Corporate" },
        { 0x00215E, "IBM Corp" },
        { 0x00215F, "IHSE GmbH" },
        { 0x002160, "Hidea Solutions Co. Ltd." },
        { 0x002161, "Yournet Inc." },
        { 0x002162, "Nortel Networks" },
        { 0x002163, "ASKEY COMPUTER CORP" },
        { 0x002164, "Special Design Bureau for Seismic Instrumentation" },
        { 0x002165, "Presstek Inc." },
        { 0x002166, "NovAtel Inc." },
        { 0x002167, "HWA JIN T&I Corp." },
        { 0x002168, "iVeia, LLC" },
        { 0x002169, "Prologix, LLC." },
        { 0x00216A, "Intel Corporate" },
        { 0x00216B, "Intel Corporate" },
        { 0x00216C, "ODVA" },
        { 0x00216D, "Soltech Co., Ltd." },
        { 0x00216E, "Function ATI (Huizhou) Telecommunications Co., Ltd." },
        { 0x00216F, "SymCom, Inc." },
        { 0x002170, "Dell Inc." },
        { 0x002171, "Wesung TNC Co., Ltd." },
        { 0x002172, "Seoultek Valley" },
        { 0x002173, "Ion Torrent Systems, Inc." },
        { 0x002174, "AvaLAN Wireless" },
        { 0x002175, "Pacific Satellite International Ltd." },
        { 0x002176, "YMax Telecom Ltd." },
        { 0x002177, "W. L. Gore & Associates" },
        { 0x002178, "Matuschek Messtechnik GmbH" },
        { 0x002179, "IOGEAR, Inc." },
        { 0x00217A, "Sejin Electron, Inc." },
        { 0x00217B, "Bastec AB" },
        { 0x00217C, "2Wire Inc" },
        { 0x00217D, "PYXIS S.R.L." },
        { 0x00217E, "Telit Communication s.p.a" },
        { 0x00217F, "Intraco Technology Pte Ltd" },
        { 0x002180, "ARRIS Group, Inc." },
        { 0x002181, "Si2 Microsystems Limited" },
        { 0x002182, "SandLinks Systems, Ltd." },
        { 0x002183, "ANDRITZ HYDRO GmbH" },
        { 0x002184, "POWERSOFT SRL" },
        { 0x002185, "MICRO-STAR INT'L CO.,LTD." },
        { 0x002186, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x002187, "Imacs GmbH" },
        { 0x002188, "EMC Corporation" },
        { 0x002189, "AppTech, Inc." },
        { 0x00218A, "Electronic Design and Manufacturing Company" },
        { 0x00218B, "Wescon Technology, Inc." },
        { 0x00218C, "TopControl GMBH" },
        { 0x00218D, "AP Router Ind. Eletronica LTDA" },
        { 0x00218E, "MEKICS CO., LTD." },
        { 0x00218F, "Avantgarde Acoustic Lautsprechersysteme GmbH" },
        { 0x002190, "Goliath Solutions" },
        { 0x002191, "D-Link Corporation" },
        { 0x002192, "Baoding Galaxy Electronic Technology Co.,Ltd" },
        { 0x002193, "Videofon MV" },
        { 0x002194, "Ping Communication" },
        { 0x002195, "GWD Media Limited" },
        { 0x002196, "Telsey S.p.A." },
        { 0x002197, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x002198, "Thai Radio Co, LTD" },
        { 0x002199, "Vacon Plc" },
        { 0x00219A, "Cambridge Visual Networks Ltd" },
        { 0x00219B, "Dell Inc." },
        { 0x00219C, "Honeywld Technology Corp." },
        { 0x00219D, "Adesys BV" },
        { 0x00219E, "Sony Mobile Communications Inc" },
        { 0x00219F, "SATEL OY" },
        { 0x0021A0, "Cisco Systems, Inc" },
        { 0x0021A1, "Cisco Systems, Inc" },
        { 0x0021A2, "EKE-Electronics Ltd." },
        { 0x0021A3, "Micromint" },
        { 0x0021A4, "Dbii Networks" },
        { 0x0021A5, "ERLPhase Power Technologies Ltd." },
        { 0x0021A6, "Videotec Spa" },
        { 0x0021A7, "Hantle System Co., Ltd." },
        { 0x0021A8, "Telephonics Corporation" },
        { 0x0021A9, "Mobilink Telecom Co.,Ltd" },
        { 0x0021AA, "Nokia Danmark A/S" },
        { 0x0021AB, "Nokia Danmark A/S" },
        { 0x0021AC, "Infrared Integrated Systems Ltd" },
        { 0x0021AD, "Nordic ID Oy" },
        { 0x0021AE, "ALCATEL-LUCENT FRANCE - WTD" },
        { 0x0021AF, "Radio Frequency Systems" },
        { 0x0021B0, "Tyco Telecommunications" },
        { 0x0021B1, "DIGITAL SOLUTIONS LTD" },
        { 0x0021B2, "Fiberblaze A/S" },
        { 0x0021B3, "Ross Controls" },
        { 0x0021B4, "APRO MEDIA CO., LTD" },
        { 0x0021B5, "Galvanic Ltd" },
        { 0x0021B6, "Triacta Power Technologies Inc." },
        { 0x0021B7, "LEXMARK INTERNATIONAL, INC." },
        { 0x0021B8, "Inphi Corporation" },
        { 0x0021B9, "Universal Devices Inc." },
        { 0x0021BA, "Texas Instruments" },
        { 0x0021BB, "Riken Keiki Co., Ltd." },
        { 0x0021BC, "ZALA COMPUTER" },
        { 0x0021BD, "Nintendo Co., Ltd." },
        { 0x0021BE, "Cisco SPVTG" },
        { 0x0021BF, "Hitachi High-Tech Control Systems Corporation" },
        { 0x0021C0, "Mobile Appliance, Inc." },
        { 0x0021C1, "ABB Oy / Medium Voltage Products" },
        { 0x0021C2, "GL Communications Inc" },
        { 0x0021C3, "CORNELL Communications, Inc." },
        { 0x0021C4, "Consilium AB" },
        { 0x0021C5, "3DSP Corp" },
        { 0x0021C6, "CSJ Global, Inc." },
        { 0x0021C7, "Russound" },
        { 0x0021C8, "LOHUIS Networks" },
        { 0x0021C9, "Wavecom Asia Pacific Limited" },
        { 0x0021CA, "ART System Co., Ltd." },
        { 0x0021CB, "SMS TECNOLOGIA ELETRONICA LTDA" },
        { 0x0021CC, "Flextronics International" },
        { 0x0021CD, "LiveTV" },
        { 0x0021CE, "NTC-Metrotek" },
        { 0x0021CF, "The Crypto Group" },
        { 0x0021D0, "Global Display Solutions Spa" },
        { 0x0021D1, "Samsung Electronics Co.,Ltd" },
        { 0x0021D2, "Samsung Electronics Co.,Ltd" },
        { 0x0021D3, "BOCOM SECURITY(ASIA PACIFIC) LIMITED" },
        { 0x0021D4, "Vollmer Werke GmbH" },
        { 0x0021D5, "X2E GmbH" },
        { 0x0021D6, "LXI Consortium" },
        { 0x0021D7, "Cisco Systems, Inc" },
        { 0x0021D8, "Cisco Systems, Inc" },
        { 0x0021D9, "SEKONIC CORPORATION" },
        { 0x0021DA, "Automation Products Group Inc." },
        { 0x0021DB, "Santachi Video Technology (Shenzhen) Co., Ltd." },
        { 0x0021DC, "TECNOALARM S.r.l." },
        { 0x0021DD, "Northstar Systems Corp" },
        { 0x0021DE, "Firepro Wireless" },
        { 0x0021DF, "Martin Christ GmbH" },
        { 0x0021E0, "CommAgility Ltd" },
        { 0x0021E1, "Nortel Networks" },
        { 0x0021E2, "visago Systems & Controls GmbH & Co. KG" },
        { 0x0021E3, "SerialTek LLC" },
        { 0x0021E4, "I-WIN" },
        { 0x0021E5, "Display Solution AG" },
        { 0x0021E6, "Starlight Video Limited" },
        { 0x0021E7, "Informatics Services Corporation" },
        { 0x0021E8, "Murata Manufacturing Co., Ltd." },
        { 0x0021E9, "Apple, Inc." },
        { 0x0021EA, "Bystronic Laser AG" },
        { 0x0021EB, "ESP SYSTEMS, LLC" },
        { 0x0021EC, "Solutronic GmbH" },
        { 0x0021ED, "Telegesis" },
        { 0x0021EE, "Full Spectrum Inc." },
        { 0x0021EF, "Kapsys" },
        { 0x0021F0, "EW3 Technologies LLC" },
        { 0x0021F1, "Tutus Data AB" },
        { 0x0021F2, "EASY3CALL Technology Limited" },
        { 0x0021F3, "Si14 SpA" },
        { 0x0021F4, "INRange Systems, Inc" },
        { 0x0021F5, "Western Engravers Supply, Inc." },
        { 0x0021F6, "Oracle Corporation" },
        { 0x0021F7, "HPN Supply Chain" },
        { 0x0021F8, "Enseo, Inc." },
        { 0x0021F9, "WIRECOM Technologies" },
        { 0x0021FA, "A4SP Technologies Ltd." },
        { 0x0021FB, "LG Electronics (Mobile Communications)" },
        { 0x0021FC, "Nokia Danmark A/S" },
        { 0x0021FD, "LACROIX TRAFFIC S.A.U" },
        { 0x0021FE, "Nokia Danmark A/S" },
        { 0x0021FF, "Cyfrowy Polsat SA" },
        { 0x002200, "IBM Corp" },
        { 0x002201, "Aksys Networks Inc" },
        { 0x002202, "Excito Elektronik i Skåne AB" },
        { 0x002203, "Glensound Electronics Ltd" },
        { 0x002204, "KORATEK" },
        { 0x002205, "WeLink Solutions, Inc." },
        { 0x002206, "Cyberdyne Inc." },
        { 0x002207, "Inteno Broadband Technology AB" },
        { 0x002208, "Certicom Corp" },
        { 0x002209, "Omron Healthcare Co., Ltd" },
        { 0x00220A, "OnLive, Inc" },
        { 0x00220B, "National Source Coding Center" },
        { 0x00220C, "Cisco Systems, Inc" },
        { 0x00220D, "Cisco Systems, Inc" },
        { 0x00220E, "Indigo Security Co., Ltd." },
        { 0x00220F, "MoCA (Multimedia over Coax Alliance)" },
        { 0x002210, "ARRIS Group, Inc." },
        { 0x002211, "Rohati Systems" },
        { 0x002212, "CAI Networks, Inc." },
        { 0x002213, "PCI CORPORATION" },
        { 0x002214, "RINNAI KOREA" },
        { 0x002215, "ASUSTek COMPUTER INC." },
        { 0x002216, "SHIBAURA VENDING MACHINE CORPORATION" },
        { 0x002217, "Neat Electronics" },
        { 0x002218, "AKAMAI TECHNOLOGIES INC" },
        { 0x002219, "Dell Inc." },
        { 0x00221A, "Audio Precision" },
        { 0x00221B, "Morega Systems" },
        { 0x00221C, "Private" },
        { 0x00221D, "Freegene Technology LTD" },
        { 0x00221E, "Media Devices Co., Ltd." },
        { 0x00221F, "eSang Technologies Co., Ltd." },
        { 0x002220, "Mitac Technology Corp" },
        { 0x002221, "ITOH DENKI CO,LTD." },
        { 0x002222, "Schaffner Deutschland GmbH" },
        { 0x002223, "TimeKeeping Systems, Inc." },
        { 0x002224, "Good Will Instrument Co., Ltd." },
        { 0x002225, "Thales Avionics Ltd" },
        { 0x002226, "Avaak, Inc." },
        { 0x002227, "uv-electronic GmbH" },
        { 0x002228, "Breeze Innovations Ltd." },
        { 0x002229, "Compumedics Ltd" },
        { 0x00222A, "SoundEar A/S" },
        { 0x00222B, "Nucomm, Inc." },
        { 0x00222C, "Ceton Corp" },
        { 0x00222D, "SMC Networks Inc." },
        { 0x00222E, "maintech GmbH" },
        { 0x00222F, "Open Grid Computing, Inc." },
        { 0x002230, "FutureLogic Inc." },
        { 0x002231, "SMT&C Co., Ltd." },
        { 0x002232, "Design Design Technology Ltd" },
        { 0x002233, "ADB Broadband Italia" },
        { 0x002234, "Corventis Inc." },
        { 0x002235, "Strukton Systems bv" },
        { 0x002236, "VECTOR SP. Z O.O." },
        { 0x002237, "Shinhint Group" },
        { 0x002238, "LOGIPLUS" },
        { 0x002239, "Indiana Life Sciences Incorporated" },
        { 0x00223A, "Cisco SPVTG" },
        { 0x00223B, "Communication Networks, LLC" },
        { 0x00223C, "RATIO Entwicklungen GmbH" },
        { 0x00223D, "JumpGen Systems, LLC" },
        { 0x00223E, "IRTrans GmbH" },
        { 0x00223F, "NETGEAR" },
        { 0x002240, "Universal Telecom S/A" },
        { 0x002241, "Apple, Inc." },
        { 0x002242, "Alacron Inc." },
        { 0x002243, "AzureWave Technology Inc." },
        { 0x002244, "Chengdu Linkon Communications Device Co., Ltd" },
        { 0x002245, "Leine & Linde AB" },
        { 0x002246, "Evoc Intelligent Technology Co.,Ltd." },
        { 0x002247, "DAC ENGINEERING CO., LTD." },
        { 0x002248, "Microsoft Corporation" },
        { 0x002249, "HOME MULTIENERGY SL" },
        { 0x00224A, "RAYLASE AG" },
        { 0x00224B, "AIRTECH TECHNOLOGIES, INC." },
        { 0x00224C, "Nintendo Co., Ltd." },
        { 0x00224D, "MITAC INTERNATIONAL CORP." },
        { 0x00224E, "SEEnergy Corp." },
        { 0x00224F, "Byzoro Networks Ltd." },
        { 0x002250, "Point Six Wireless, LLC" },
        { 0x002251, "Lumasense Technologies" },
        { 0x002252, "ZOLL Lifecor Corporation" },
        { 0x002253, "Entorian Technologies" },
        { 0x002254, "Bigelow Aerospace" },
        { 0x002255, "Cisco Systems, Inc" },
        { 0x002256, "Cisco Systems, Inc" },
        { 0x002257, "3COM EUROPE LTD" },
        { 0x002258, "Taiyo Yuden Co., Ltd." },
        { 0x002259, "Guangzhou New Postcom Equipment Co.,Ltd." },
        { 0x00225A, "Garde Security AB" },
        { 0x00225B, "Teradici Corporation" },
        { 0x00225C, "Multimedia & Communication Technology" },
        { 0x00225D, "Digicable Network India Pvt. Ltd." },
        { 0x00225E, "Uwin Technologies Co.,LTD" },
        { 0x00225F, "Liteon Technology Corporation" },
        { 0x002260, "AFREEY Inc." },
        { 0x002261, "Frontier Silicon Ltd" },
        { 0x002262, "BEP Marine" },
        { 0x002263, "Koos Technical Services, Inc." },
        { 0x002264, "Hewlett Packard" },
        { 0x002265, "Nokia Danmark A/S" },
        { 0x002266, "Nokia Danmark A/S" },
        { 0x002267, "Nortel Networks" },
        { 0x002268, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x002269, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00226A, "Honeywell" },
        { 0x00226B, "Cisco-Linksys, LLC" },
        { 0x00226C, "LinkSprite Technologies, Inc." },
        { 0x00226D, "Shenzhen GIEC Electronics Co., Ltd." },
        { 0x00226E, "Gowell Electronic Limited" },
        { 0x00226F, "3onedata Technology Co. Ltd." },
        { 0x002270, "ABK North America, LLC" },
        { 0x002271, "Jäger Computergesteuerte Meßtechnik GmbH." },
        { 0x002272, "American Micro-Fuel Device Corp." },
        { 0x002273, "Techway" },
        { 0x002274, "FamilyPhone AB" },
        { 0x002275, "Belkin International Inc." },
        { 0x002276, "Triple EYE B.V." },
        { 0x002277, "NEC Australia Pty Ltd" },
        { 0x002278, "Shenzhen Tongfang Multimedia Technology Co.,Ltd." },
        { 0x002279, "Nippon Conlux Co., Ltd." },
        { 0x00227A, "Telecom Design" },
        { 0x00227B, "Apogee Labs, Inc." },
        { 0x00227C, "Woori SMT Co.,ltd" },
        { 0x00227D, "YE DATA INC." },
        { 0x00227E, "Chengdu 30Kaitian Communication Industry Co.Ltd" },
        { 0x00227F, "Ruckus Wireless" },
        { 0x002280, "A2B Electronics AB" },
        { 0x002281, "Daintree Networks Pty" },
        { 0x002282, "8086 Consultancy" },
        { 0x002283, "Juniper Networks" },
        { 0x002284, "DESAY A&V SCIENCE AND TECHNOLOGY CO.,LTD" },
        { 0x002285, "NOMUS COMM SYSTEMS" },
        { 0x002286, "ASTRON" },
        { 0x002287, "Titan Wireless LLC" },
        { 0x002288, "Sagrad, Inc." },
        { 0x002289, "Vandelrande APC inc." },
        { 0x00228A, "Teratronik elektronische systeme gmbh" },
        { 0x00228B, "Kensington Computer Products Group" },
        { 0x00228C, "Photon Europe GmbH" },
        { 0x00228D, "GBS Laboratories LLC" },
        { 0x00228E, "TV-NUMERIC" },
        { 0x00228F, "CNRS" },
        { 0x002290, "Cisco Systems, Inc" },
        { 0x002291, "Cisco Systems, Inc" },
        { 0x002292, "Cinetal" },
        { 0x002293, "zte corporation" },
        { 0x002294, "KYOCERA CORPORATION" },
        { 0x002295, "SGM Technology for lighting spa" },
        { 0x002296, "LinoWave Corporation" },
        { 0x002297, "XMOS Semiconductor" },
        { 0x002298, "Sony Mobile Communications Inc" },
        { 0x002299, "SeaMicro Inc." },
        { 0x00229A, "Lastar, Inc." },
        { 0x00229B, "AverLogic Technologies, Inc." },
        { 0x00229C, "Verismo Networks Inc" },
        { 0x00229D, "PYUNG-HWA IND.CO.,LTD" },
        { 0x00229E, "Social Aid Research Co., Ltd." },
        { 0x00229F, "Sensys Traffic AB" },
        { 0x0022A0, "APTIV SERVICES US, LLC" },
        { 0x0022A1, "Huawei Symantec Technologies Co.,Ltd." },
        { 0x0022A2, "Xtramus Technologies" },
        { 0x0022A3, "California Eastern Laboratories" },
        { 0x0022A4, "2Wire Inc" },
        { 0x0022A5, "Texas Instruments" },
        { 0x0022A6, "Sony Computer Entertainment America" },
        { 0x0022A7, "Tyco Electronics AMP GmbH" },
        { 0x0022A8, "Ouman Oy" },
        { 0x0022A9, "LG Electronics (Mobile Communications)" },
        { 0x0022AA, "Nintendo Co., Ltd." },
        { 0x0022AB, "Shenzhen Turbosight Technology Ltd" },
        { 0x0022AC, "Hangzhou Siyuan Tech. Co., Ltd" },
        { 0x0022AD, "TELESIS TECHNOLOGIES, INC." },
        { 0x0022AE, "Mattel Inc." },
        { 0x0022AF, "Safety Vision, LLC" },
        { 0x0022B0, "D-Link Corporation" },
        { 0x0022B1, "Elbit Systems Ltd." },
        { 0x0022B2, "4RF Communications Ltd" },
        { 0x0022B3, "Sei S.p.A." },
        { 0x0022B4, "ARRIS Group, Inc." },
        { 0x0022B5, "NOVITA" },
        { 0x0022B6, "Superflow Technologies Group" },
        { 0x0022B7, "GSS Grundig SAT-Systems GmbH" },
        { 0x0022B8, "Norcott" },
        { 0x0022B9, "Analogix Seminconductor, Inc" },
        { 0x0022BA, "HUTH Elektronik Systeme GmbH" },
        { 0x0022BB, "beyerdynamic GmbH & Co. KG" },
        { 0x0022BC, "JDSU France SAS" },
        { 0x0022BD, "Cisco Systems, Inc" },
        { 0x0022BE, "Cisco Systems, Inc" },
        { 0x0022BF, "SieAmp Group of Companies" },
        { 0x0022C0, "Shenzhen Forcelink Electronic Co, Ltd" },
        { 0x0022C1, "Active Storage Inc." },
        { 0x0022C2, "Proview Eletrônica do Brasil LTDA" },
        { 0x0022C3, "Zeeport Technology Inc." },
        { 0x0022C4, "epro GmbH" },
        { 0x0022C5, "INFORSON Co,Ltd." },
        { 0x0022C6, "Sutus Inc" },
        { 0x0022C7, "SEGGER Microcontroller GmbH & Co. KG" },
        { 0x0022C8, "Applied Instruments B.V." },
        { 0x0022C9, "Lenord, Bauer & Co GmbH" },
        { 0x0022CA, "Anviz Biometric Tech. Co., Ltd." },
        { 0x0022CB, "IONODES Inc." },
        { 0x0022CC, "SciLog, Inc." },
        { 0x0022CD, "Ared Technology Co., Ltd." },
        { 0x0022CE, "Cisco SPVTG" },
        { 0x0022CF, "PLANEX COMMUNICATIONS INC." },
        { 0x0022D0, "Polar Electro Oy" },
        { 0x0022D1, "Albrecht Jung GmbH & Co. KG" },
        { 0x0022D2, "All Earth Comércio de Eletrônicos LTDA." },
        { 0x0022D3, "Hub-Tech" },
        { 0x0022D4, "ComWorth Co., Ltd." },
        { 0x0022D5, "Eaton Corp. Electrical Group Data Center Solutions - Pulizzi" },
        { 0x0022D6, "Cypak AB" },
        { 0x0022D7, "Nintendo Co., Ltd." },
        { 0x0022D8, "Shenzhen GST Security and Safety Technology Limited" },
        { 0x0022D9, "Fortex Industrial Ltd." },
        { 0x0022DA, "ANATEK, LLC" },
        { 0x0022DB, "Translogic Corporation" },
        { 0x0022DC, "Vigil Health Solutions Inc." },
        { 0x0022DD, "Protecta Electronics Ltd" },
        { 0x0022DE, "OPPO Digital, Inc." },
        { 0x0022DF, "TAMUZ Monitors" },
        { 0x0022E0, "Atlantic Software Technologies S.r.L." },
        { 0x0022E1, "ZORT Labs, LLC." },
        { 0x0022E2, "WABTEC Transit Division" },
        { 0x0022E3, "Amerigon" },
        { 0x0022E4, "APASS TECHNOLOGY CO., LTD." },
        { 0x0022E5, "Fisher-Rosemount Systems Inc." },
        { 0x0022E6, "Intelligent Data" },
        { 0x0022E7, "WPS Parking Systems" },
        { 0x0022E8, "Applition Co., Ltd." },
        { 0x0022E9, "ProVision Communications" },
        { 0x0022EA, "Rustelcom Inc." },
        { 0x0022EB, "Data Respons A/S" },
        { 0x0022EC, "IDEALBT TECHNOLOGY CORPORATION" },
        { 0x0022ED, "TSI Power Corporation" },
        { 0x0022EE, "Algo Communication Products Ltd" },
        { 0x0022EF, "iWDL Technologies" },
        { 0x0022F0, "3 Greens Aviation Limited" },
        { 0x0022F1, "Private" },
        { 0x0022F2, "SunPower Corp" },
        { 0x0022F3, "SHARP Corporation" },
        { 0x0022F4, "AMPAK Technology, Inc." },
        { 0x0022F5, "Advanced Realtime Tracking GmbH" },
        { 0x0022F6, "Syracuse Research Corporation" },
        { 0x0022F7, "Conceptronic" },
        { 0x0022F8, "PIMA Electronic Systems Ltd." },
        { 0x0022F9, "Pollin Electronic GmbH" },
        { 0x0022FA, "Intel Corporate" },
        { 0x0022FB, "Intel Corporate" },
        { 0x0022FC, "Nokia Danmark A/S" },
        { 0x0022FD, "Nokia Danmark A/S" },
        { 0x0022FE, "Advanced Illumination" },
        { 0x0022FF, "NIVIS LLC" },
        { 0x002300, "Cayee Computer Ltd." },
        { 0x002301, "Witron Technology Limited" },
        { 0x002302, "Cobalt Digital, Inc." },
        { 0x002303, "LITE-ON IT Corporation" },
        { 0x002304, "Cisco Systems, Inc" },
        { 0x002305, "Cisco Systems, Inc" },
        { 0x002306, "ALPS ELECTRIC CO., LTD." },
        { 0x002307, "FUTURE INNOVATION TECH CO.,LTD" },
        { 0x002308, "Arcadyan Technology Corporation" },
        { 0x002309, "Janam Technologies LLC" },
        { 0x00230A, "ARBURG GmbH & Co KG" },
        { 0x00230B, "ARRIS Group, Inc." },
        { 0x00230C, "CLOVER ELECTRONICS CO.,LTD." },
        { 0x00230D, "Nortel Networks" },
        { 0x00230E, "Gorba AG" },
        { 0x00230F, "Hirsch Electronics Corporation" },
        { 0x002310, "LNC Technology Co., Ltd." },
        { 0x002311, "Gloscom Co., Ltd." },
        { 0x002312, "Apple, Inc." },
        { 0x002313, "Qool Technologies Ltd." },
        { 0x002314, "Intel Corporate" },
        { 0x002315, "Intel Corporate" },
        { 0x002316, "KISAN ELECTRONICS CO" },
        { 0x002317, "Lasercraft Inc" },
        { 0x002318, "Toshiba" },
        { 0x002319, "Sielox LLC" },
        { 0x00231A, "ITF Co., Ltd." },
        { 0x00231B, "Danaher Motion - Kollmorgen" },
        { 0x00231C, "Fourier Systems Ltd." },
        { 0x00231D, "Deltacom Electronics Ltd" },
        { 0x00231E, "Cezzer Multimedia Technologies" },
        { 0x00231F, "Guangda Electronic & Telecommunication Technology Development Co., Ltd." },
        { 0x002320, "Nicira Networks" },
        { 0x002321, "Avitech International Corp" },
        { 0x002322, "KISS Teknical Solutions, Inc." },
        { 0x002323, "Zylin AS" },
        { 0x002324, "G-PRO COMPUTER" },
        { 0x002325, "IOLAN Holding" },
        { 0x002326, "FUJITSU LIMITED" },
        { 0x002327, "Shouyo Electronics CO., LTD" },
        { 0x002328, "ALCON TELECOMMUNICATIONS CO., LTD." },
        { 0x002329, "DDRdrive LLC" },
        { 0x00232A, "eonas IT-Beratung und -Entwicklung GmbH" },
        { 0x00232B, "IRD A/S" },
        { 0x00232C, "Senticare" },
        { 0x00232D, "SandForce" },
        { 0x00232E, "Kedah Electronics Engineering, LLC" },
        { 0x00232F, "Advanced Card Systems Ltd." },
        { 0x002330, "DIZIPIA, INC." },
        { 0x002331, "Nintendo Co., Ltd." },
        { 0x002332, "Apple, Inc." },
        { 0x002333, "Cisco Systems, Inc" },
        { 0x002334, "Cisco Systems, Inc" },
        { 0x002335, "Linkflex Co.,Ltd" },
        { 0x002336, "METEL s.r.o." },
        { 0x002337, "Global Star Solutions ULC" },
        { 0x002338, "OJ-Electronics A/S" },
        { 0x002339, "Samsung Electronics Co.,Ltd" },
        { 0x00233A, "Samsung Electronics Co.,Ltd" },
        { 0x00233B, "C-Matic Systems Ltd" },
        { 0x00233C, "Alflex" },
        { 0x00233D, "Laird Technologies" },
        { 0x00233E, "Alcatel-Lucent IPD" },
        { 0x00233F, "Purechoice Inc" },
        { 0x002340, "MiXTelematics" },
        { 0x002341, "Vanderbilt International (SWE) AB" },
        { 0x002342, "Coffee Equipment Company" },
        { 0x002343, "TEM AG" },
        { 0x002344, "Objective Interface Systems, Inc." },
        { 0x002345, "Sony Mobile Communications Inc" },
        { 0x002346, "Vestac" },
        { 0x002347, "ProCurve Networking by HP" },
        { 0x002348, "Sagemcom Broadband SAS" },
        { 0x002349, "Helmholtz Centre Berlin for Material and Energy" },
        { 0x00234A, "Private" },
        { 0x00234B, "Inyuan Technology Inc." },
        { 0x00234C, "KTC AB" },
        { 0x00234D, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00234E, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00234F, "Luminous Power Technologies Pvt. Ltd." },
        { 0x002350, "RDC, Inc. dba LynTec" },
        { 0x002351, "2Wire Inc" },
        { 0x002352, "DATASENSOR S.p.A." },
        { 0x002353, "F E T Elettronica snc" },
        { 0x002354, "ASUSTek COMPUTER INC." },
        { 0x002355, "Kinco Automation(Shanghai) Ltd." },
        { 0x002356, "Packet Forensics LLC" },
        { 0x002357, "Pitronot Technologies and Engineering P.T.E. Ltd." },
        { 0x002358, "SYSTEL SA" },
        { 0x002359, "Benchmark Electronics ( Thailand ) Public Company Limited" },
        { 0x00235A, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x00235B, "Gulfstream" },
        { 0x00235C, "Aprius, Inc." },
        { 0x00235D, "Cisco Systems, Inc" },
        { 0x00235E, "Cisco Systems, Inc" },
        { 0x00235F, "Silicon Micro Sensors GmbH" },
        { 0x002360, "Lookit Technology Co., Ltd" },
        { 0x002361, "Unigen Corporation" },
        { 0x002362, "Goldline Controls" },
        { 0x002363, "Zhuhai Raysharp Technology Co.,Ltd" },
        { 0x002364, "Power Instruments Pte Ltd" },
        { 0x002365, "Insta Elektro GmbH" },
        { 0x002366, "Beijing Siasun Electronic System Co.,Ltd." },
        { 0x002367, "UniControls a.s." },
        { 0x002368, "Zebra Technologies Inc" },
        { 0x002369, "Cisco-Linksys, LLC" },
        { 0x00236A, "SmartRG Inc" },
        { 0x00236B, "Xembedded, Inc." },
        { 0x00236C, "Apple, Inc." },
        { 0x00236D, "ResMed Ltd" },
        { 0x00236E, "Burster GmbH & Co KG" },
        { 0x00236F, "DAQ System" },
        { 0x002370, "Snell" },
        { 0x002371, "SOAM Systel" },
        { 0x002372, "MORE STAR INDUSTRIAL GROUP LIMITED" },
        { 0x002373, "GridIron Systems, Inc." },
        { 0x002374, "ARRIS Group, Inc." },
        { 0x002375, "ARRIS Group, Inc." },
        { 0x002376, "HTC Corporation" },
        { 0x002377, "Isotek Electronics Ltd" },
        { 0x002378, "GN Netcom A/S" },
        { 0x002379, "Union Business Machines Co. Ltd." },
        { 0x00237A, "RIM" },
        { 0x00237B, "WHDI LLC" },
        { 0x00237C, "NEOTION" },
        { 0x00237D, "Hewlett Packard" },
        { 0x00237E, "ELSTER GMBH" },
        { 0x00237F, "PLANTRONICS, INC." },
        { 0x002380, "Nanoteq" },
        { 0x002381, "Lengda Technology(Xiamen) Co.,Ltd." },
        { 0x002382, "Lih Rong electronic Enterprise Co., Ltd." },
        { 0x002383, "InMage Systems Inc" },
        { 0x002384, "GGH Engineering s.r.l." },
        { 0x002385, "ANTIPODE" },
        { 0x002386, "IMI Hydronic Engineering international SA" },
        { 0x002387, "ThinkFlood, Inc." },
        { 0x002388, "V.T. Telematica S.p.a." },
        { 0x002389, "Hangzhou H3C Technologies Co., Limited" },
        { 0x00238A, "Ciena Corporation" },
        { 0x00238B, "Quanta Computer Inc." },
        { 0x00238C, "Private" },
        { 0x00238D, "Techno Design Co., Ltd." },
        { 0x00238E, "ADB Broadband Italia" },
        { 0x00238F, "NIDEC COPAL CORPORATION" },
        { 0x002390, "Algolware Corporation" },
        { 0x002391, "Maxian" },
        { 0x002392, "Proteus Industries Inc." },
        { 0x002393, "AJINEXTEK" },
        { 0x002394, "Samjeon" },
        { 0x002395, "ARRIS Group, Inc." },
        { 0x002396, "ANDES TECHNOLOGY CORPORATION" },
        { 0x002397, "Westell Technologies Inc." },
        { 0x002398, "Vutlan sro" },
        { 0x002399, "Samsung Electronics Co.,Ltd" },
        { 0x00239A, "EasyData Hardware GmbH" },
        { 0x00239B, "Elster Solutions, LLC" },
        { 0x00239C, "Juniper Networks" },
        { 0x00239D, "Mapower Electronics Co., Ltd" },
        { 0x00239E, "Jiangsu Lemote Technology Corporation Limited" },
        { 0x00239F, "Institut für Prüftechnik" },
        { 0x0023A0, "Hana CNS Co., LTD." },
        { 0x0023A1, "Trend Electronics Ltd" },
        { 0x0023A2, "ARRIS Group, Inc." },
        { 0x0023A3, "ARRIS Group, Inc." },
        { 0x0023A4, "New Concepts Development Corp." },
        { 0x0023A5, "SageTV, LLC" },
        { 0x0023A6, "E-Mon" },
        { 0x0023A7, "Redpine Signals, Inc." },
        { 0x0023A8, "Marshall Electronics" },
        { 0x0023A9, "Beijing Detianquan Electromechanical Equipment Co., Ltd" },
        { 0x0023AA, "HFR, Inc." },
        { 0x0023AB, "Cisco Systems, Inc" },
        { 0x0023AC, "Cisco Systems, Inc" },
        { 0x0023AD, "Xmark Corporation" },
        { 0x0023AE, "Dell Inc." },
        { 0x0023AF, "ARRIS Group, Inc." },
        { 0x0023B0, "COMXION Technology Inc." },
        { 0x0023B1, "Longcheer Technology (Singapore) Pte Ltd" },
        { 0x0023B2, "Intelligent Mechatronic Systems Inc" },
        { 0x0023B3, "Lyyn AB" },
        { 0x0023B4, "Nokia Danmark A/S" },
        { 0x0023B5, "ORTANA LTD" },
        { 0x0023B6, "SECURITE COMMUNICATIONS / HONEYWELL" },
        { 0x0023B7, "Q-Light Co., Ltd." },
        { 0x0023B8, "Sichuan Jiuzhou Electronic Technology Co.,Ltd" },
        { 0x0023B9, "Airbus Defence and Space Deutschland GmbH" },
        { 0x0023BA, "Chroma" },
        { 0x0023BB, "Schmitt Industries" },
        { 0x0023BC, "EQ-SYS GmbH" },
        { 0x0023BD, "Digital Ally, Inc." },
        { 0x0023BE, "Cisco SPVTG" },
        { 0x0023BF, "Mainpine, Inc." },
        { 0x0023C0, "Broadway Networks" },
        { 0x0023C1, "Securitas Direct AB" },
        { 0x0023C2, "SAMSUNG Electronics. Co. LTD" },
        { 0x0023C3, "LogMeIn, Inc." },
        { 0x0023C4, "Lux Lumen" },
        { 0x0023C5, "Radiation Safety and Control Services Inc" },
        { 0x0023C6, "SMC Corporation" },
        { 0x0023C7, "AVSystem" },
        { 0x0023C8, "TEAM-R" },
        { 0x0023C9, "Sichuan Tianyi Information Science & Technology Stock CO.,LTD" },
        { 0x0023CA, "Behind The Set, LLC" },
        { 0x0023CB, "Shenzhen Full-join Technology Co.,Ltd" },
        { 0x0023CC, "Nintendo Co., Ltd." },
        { 0x0023CD, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x0023CE, "KITA DENSHI CORPORATION" },
        { 0x0023CF, "CUMMINS-ALLISON CORP." },
        { 0x0023D0, "Uniloc USA Inc." },
        { 0x0023D1, "TRG" },
        { 0x0023D2, "Inhand Electronics, Inc." },
        { 0x0023D3, "AirLink WiFi Networking Corp." },
        { 0x0023D4, "Texas Instruments" },
        { 0x0023D5, "WAREMA electronic GmbH" },
        { 0x0023D6, "Samsung Electronics Co.,Ltd" },
        { 0x0023D7, "Samsung Electronics Co.,Ltd" },
        { 0x0023D8, "Ball-It Oy" },
        { 0x0023D9, "Banner Engineering" },
        { 0x0023DA, "Industrial Computer Source (Deutschland)GmbH" },
        { 0x0023DB, "saxnet gmbh" },
        { 0x0023DC, "Benein, Inc" },
        { 0x0023DD, "ELGIN S.A." },
        { 0x0023DE, "Ansync Inc." },
        { 0x0023DF, "Apple, Inc." },
        { 0x0023E0, "INO Therapeutics LLC" },
        { 0x0023E1, "Cavena Image Products AB" },
        { 0x0023E2, "SEA Signalisation" },
        { 0x0023E3, "Microtronic AG" },
        { 0x0023E4, "IPnect co. ltd." },
        { 0x0023E5, "IPaXiom Networks" },
        { 0x0023E6, "Innovation Farm, Inc." },
        { 0x0023E7, "Hinke A/S" },
        { 0x0023E8, "Demco Corp." },
        { 0x0023E9, "F5 Networks, Inc." },
        { 0x0023EA, "Cisco Systems, Inc" },
        { 0x0023EB, "Cisco Systems, Inc" },
        { 0x0023EC, "Algorithmix GmbH" },
        { 0x0023ED, "ARRIS Group, Inc." },
        { 0x0023EE, "ARRIS Group, Inc." },
        { 0x0023EF, "Zuend Systemtechnik AG" },
        { 0x0023F0, "Shanghai Jinghan Weighing Apparatus Co. Ltd." },
        { 0x0023F1, "Sony Mobile Communications Inc" },
        { 0x0023F2, "TVLogic" },
        { 0x0023F3, "Glocom, Inc." },
        { 0x0023F4, "Masternaut" },
        { 0x0023F5, "WILO SE" },
        { 0x0023F6, "Softwell Technology Co., Ltd." },
        { 0x0023F7, "Private" },
        { 0x0023F8, "Zyxel Communications Corporation" },
        { 0x0023F9, "Double-Take Software, INC." },
        { 0x0023FA, "RG Nets, Inc." },
        { 0x0023FB, "IP Datatel, LLC." },
        { 0x0023FC, "Ultra Stereo Labs, Inc" },
        { 0x0023FD, "AFT Atlas Fahrzeugtechnik GmbH" },
        { 0x0023FE, "Biodevices, SA" },
        { 0x0023FF, "Beijing HTTC Technology Ltd." },
        { 0x002400, "Nortel Networks" },
        { 0x002401, "D-Link Corporation" },
        { 0x002402, "Op-Tection GmbH" },
        { 0x002403, "Nokia Danmark A/S" },
        { 0x002404, "Nokia Danmark A/S" },
        { 0x002405, "Dilog Nordic AB" },
        { 0x002406, "Pointmobile" },
        { 0x002407, "TELEM SAS" },
        { 0x002408, "Pacific Biosciences" },
        { 0x002409, "The Toro Company" },
        { 0x00240A, "US Beverage Net" },
        { 0x00240B, "Virtual Computer Inc." },
        { 0x00240C, "DELEC GmbH" },
        { 0x00240D, "OnePath Networks LTD." },
        { 0x00240E, "Inventec Besta Co., Ltd." },
        { 0x00240F, "Ishii Tool & Engineering Corporation" },
        { 0x002410, "NUETEQ Technology,Inc." },
        { 0x002411, "PharmaSmart LLC" },
        { 0x002412, "Benign Technologies Co, Ltd." },
        { 0x002413, "Cisco Systems, Inc" },
        { 0x002414, "Cisco Systems, Inc" },
        { 0x002415, "Magnetic Autocontrol GmbH" },
        { 0x002416, "Any Use" },
        { 0x002417, "Thomson Telecom Belgium" },
        { 0x002418, "Nextwave Semiconductor" },
        { 0x002419, "Private" },
        { 0x00241A, "Red Beetle Inc." },
        { 0x00241B, "iWOW Communications Pte Ltd" },
        { 0x00241C, "FuGang Electronic (DG) Co.,Ltd" },
        { 0x00241D, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x00241E, "Nintendo Co., Ltd." },
        { 0x00241F, "DCT-Delta GmbH" },
        { 0x002420, "NetUP Inc." },
        { 0x002421, "MICRO-STAR INT'L CO., LTD." },
        { 0x002422, "Knapp Logistik Automation GmbH" },
        { 0x002423, "AzureWave Technologies (Shanghai) Inc." },
        { 0x002424, "Ace Axis Limited" },
        { 0x002425, "Shenzhenshi chuangzhicheng Technology Co.,Ltd" },
        { 0x002426, "NOHMI BOSAI LTD." },
        { 0x002427, "SSI COMPUTER CORP" },
        { 0x002428, "EnergyICT" },
        { 0x002429, "MK MASTER INC." },
        { 0x00242A, "Hittite Microwave Corporation" },
        { 0x00242B, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00242C, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00242E, "Datastrip Inc." },
        { 0x00242F, "Micron" },
        { 0x002430, "Ruby Tech Corp." },
        { 0x002431, "Uni-v co.,ltd" },
        { 0x002432, "Neostar Technology Co.,LTD" },
        { 0x002433, "ALPS ELECTRIC CO., LTD." },
        { 0x002434, "Lectrosonics, Inc." },
        { 0x002435, "WIDE CORPORATION" },
        { 0x002436, "Apple, Inc." },
        { 0x002437, "Motorola - BSG" },
        { 0x002438, "Brocade Communications Systems LLC" },
        { 0x002439, "Digital Barriers Advanced Technologies" },
        { 0x00243A, "Ludl Electronic Products" },
        { 0x00243B, "CSSI (S) Pte Ltd" },
        { 0x00243C, "S.A.A.A." },
        { 0x00243D, "Emerson Appliance Motors and Controls" },
        { 0x00243F, "Storwize, Inc." },
        { 0x002440, "Halo Monitoring, Inc." },
        { 0x002441, "Wanzl Metallwarenfabrik GmbH" },
        { 0x002442, "Axona Limited" },
        { 0x002443, "Nortel Networks" },
        { 0x002444, "Nintendo Co., Ltd." },
        { 0x002445, "Adtran Inc" },
        { 0x002446, "MMB Research Inc." },
        { 0x002447, "Kaztek Systems" },
        { 0x002448, "SpiderCloud Wireless, Inc" },
        { 0x002449, "Shen Zhen Lite Star Electronics Technology Co., Ltd" },
        { 0x00244A, "Voyant International" },
        { 0x00244B, "PERCEPTRON INC" },
        { 0x00244C, "Solartron Metrology Ltd" },
        { 0x00244D, "Hokkaido Electronics Corporation" },
        { 0x00244E, "RadChips, Inc." },
        { 0x00244F, "Asantron Technologies Ltd." },
        { 0x002450, "Cisco Systems, Inc" },
        { 0x002451, "Cisco Systems, Inc" },
        { 0x002452, "Silicon Software GmbH" },
        { 0x002453, "Initra d.o.o." },
        { 0x002454, "Samsung Electronics Co.,Ltd" },
        { 0x002455, "MuLogic BV" },
        { 0x002456, "2Wire Inc" },
        { 0x002458, "PA Bastion CC" },
        { 0x002459, "ABB Automation products GmbH" },
        { 0x00245A, "Nanjing Panda Electronics Company Limited" },
        { 0x00245B, "RAIDON TECHNOLOGY, INC." },
        { 0x00245C, "Design-Com Technologies Pty. Ltd." },
        { 0x00245D, "Terberg besturingstechniek B.V." },
        { 0x00245E, "Hivision Co.,ltd" },
        { 0x00245F, "Vine Telecom CO.,Ltd." },
        { 0x002460, "Giaval Science Development Co. Ltd." },
        { 0x002461, "Shin Wang Tech." },
        { 0x002462, "Rayzone Corporation" },
        { 0x002463, "Phybridge Inc" },
        { 0x002464, "Bridge Technologies Co AS" },
        { 0x002465, "Elentec" },
        { 0x002466, "Unitron nv" },
        { 0x002467, "AOC International (Europe) GmbH" },
        { 0x002468, "Sumavision Technologies Co.,Ltd" },
        { 0x002469, "Smart Doorphones" },
        { 0x00246A, "Solid Year Co., Ltd." },
        { 0x00246B, "Covia, Inc." },
        { 0x00246C, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x00246D, "Weinzierl Engineering GmbH" },
        { 0x00246E, "Phihong USA Corp." },
        { 0x00246F, "Onda Communication spa" },
        { 0x002470, "AUROTECH ultrasound AS." },
        { 0x002471, "Fusion MultiSystems dba Fusion-io" },
        { 0x002472, "ReDriven Power Inc." },
        { 0x002473, "3COM EUROPE LTD" },
        { 0x002474, "Autronica Fire And Securirty" },
        { 0x002475, "Compass System(Embedded Dept.)" },
        { 0x002476, "TAP.tv" },
        { 0x002477, "Tibbo Technology" },
        { 0x002478, "Mag Tech Electronics Co Limited" },
        { 0x002479, "Optec Displays, Inc." },
        { 0x00247A, "FU YI CHENG Technology Co., Ltd." },
        { 0x00247B, "Actiontec Electronics, Inc" },
        { 0x00247C, "Nokia Danmark A/S" },
        { 0x00247D, "Nokia Danmark A/S" },
        { 0x00247E, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x00247F, "Nortel Networks" },
        { 0x002480, "Meteocontrol GmbH" },
        { 0x002481, "Hewlett Packard" },
        { 0x002482, "Ruckus Wireless" },
        { 0x002483, "LG Electronics (Mobile Communications)" },
        { 0x002484, "Bang and Olufsen Medicom a/s" },
        { 0x002485, "ConteXtream Ltd" },
        { 0x002486, "DesignArt Networks" },
        { 0x002487, "Transact Campus, Inc." },
        { 0x002488, "Centre For Development Of Telematics" },
        { 0x002489, "Vodafone Omnitel N.V." },
        { 0x00248A, "Kaga Electronics Co., Ltd." },
        { 0x00248B, "HYBUS CO., LTD." },
        { 0x00248C, "ASUSTek COMPUTER INC." },
        { 0x00248D, "Sony Interactive Entertainment Inc." },
        { 0x00248E, "Infoware ZRt." },
        { 0x00248F, "DO-MONIX" },
        { 0x002490, "Samsung Electronics Co.,Ltd" },
        { 0x002491, "Samsung Electronics Co.,Ltd" },
        { 0x002492, "Motorola, Broadband Solutions Group" },
        { 0x002493, "ARRIS Group, Inc." },
        { 0x002494, "Shenzhen Baoxin Tech CO., Ltd." },
        { 0x002495, "ARRIS Group, Inc." },
        { 0x002496, "Ginzinger electronic systems" },
        { 0x002497, "Cisco Systems, Inc" },
        { 0x002498, "Cisco Systems, Inc" },
        { 0x002499, "Aquila Technologies" },
        { 0x00249A, "Beijing Zhongchuang Telecommunication Test Co., Ltd." },
        { 0x00249B, "Action Star Enterprise Co., Ltd." },
        { 0x00249C, "Bimeng Comunication System Co. Ltd" },
        { 0x00249D, "NES Technology Inc." },
        { 0x00249E, "ADC-Elektronik GmbH" },
        { 0x00249F, "RIM Testing Services" },
        { 0x0024A0, "ARRIS Group, Inc." },
        { 0x0024A1, "ARRIS Group, Inc." },
        { 0x0024A2, "Hong Kong Middleware Technology Limited" },
        { 0x0024A3, "Sonim Technologies Inc" },
        { 0x0024A4, "Siklu Communication" },
        { 0x0024A5, "BUFFALO.INC" },
        { 0x0024A6, "TELESTAR DIGITAL GmbH" },
        { 0x0024A7, "Advanced Video Communications Inc." },
        { 0x0024A8, "ProCurve Networking by HP" },
        { 0x0024A9, "Ag Leader Technology" },
        { 0x0024AA, "Dycor Technologies Ltd." },
        { 0x0024AB, "A7 Engineering, Inc." },
        { 0x0024AC, "Hangzhou DPtech Technologies Co., Ltd." },
        { 0x0024AD, "Adolf Thies Gmbh & Co. KG" },
        { 0x0024AE, "IDEMIA" },
        { 0x0024AF, "Dish Technologies Corp" },
        { 0x0024B0, "ESAB AB" },
        { 0x0024B1, "Coulomb Technologies" },
        { 0x0024B2, "NETGEAR" },
        { 0x0024B3, "Graf-Syteco GmbH & Co. KG" },
        { 0x0024B4, "ESCATRONIC GmbH" },
        { 0x0024B5, "Nortel Networks" },
        { 0x0024B6, "Seagate Technology" },
        { 0x0024B7, "GridPoint, Inc." },
        { 0x0024B8, "free alliance sdn bhd" },
        { 0x0024B9, "Wuhan Higheasy Electronic Technology Development Co.Ltd" },
        { 0x0024BA, "Texas Instruments" },
        { 0x0024BB, "CENTRAL Corporation" },
        { 0x0024BC, "HuRob Co.,Ltd" },
        { 0x0024BD, "Hainzl Industriesysteme GmbH" },
        { 0x0024BE, "Sony Corporation" },
        { 0x0024BF, "CIAT" },
        { 0x0024C0, "NTI COMODO INC" },
        { 0x0024C1, "ARRIS Group, Inc." },
        { 0x0024C2, "Asumo Co.,Ltd." },
        { 0x0024C3, "Cisco Systems, Inc" },
        { 0x0024C4, "Cisco Systems, Inc" },
        { 0x0024C5, "Meridian Audio Limited" },
        { 0x0024C6, "Hager Electro SAS" },
        { 0x0024C7, "Mobilarm Ltd" },
        { 0x0024C8, "Broadband Solutions Group" },
        { 0x0024C9, "Broadband Solutions Group" },
        { 0x0024CA, "Tobii Technology AB" },
        { 0x0024CB, "Autonet Mobile" },
        { 0x0024CC, "Fascinations Toys and Gifts, Inc." },
        { 0x0024CD, "Willow Garage, Inc." },
        { 0x0024CE, "Exeltech Inc" },
        { 0x0024CF, "Inscape Data Corporation" },
        { 0x0024D0, "Shenzhen SOGOOD Industry CO.,LTD." },
        { 0x0024D1, "Thomson Inc." },
        { 0x0024D2, "ASKEY COMPUTER CORP" },
        { 0x0024D3, "QUALICA Inc." },
        { 0x0024D4, "FREEBOX SAS" },
        { 0x0024D5, "Winward Industrial Limited" },
        { 0x0024D6, "Intel Corporate" },
        { 0x0024D7, "Intel Corporate" },
        { 0x0024D8, "IlSung Precision" },
        { 0x0024D9, "BICOM, Inc." },
        { 0x0024DA, "Innovar Systems Limited" },
        { 0x0024DB, "Alcohol Monitoring Systems" },
        { 0x0024DC, "Juniper Networks" },
        { 0x0024DD, "Centrak, Inc." },
        { 0x0024DE, "GLOBAL Technology Inc." },
        { 0x0024DF, "Digitalbox Europe GmbH" },
        { 0x0024E0, "DS Tech, LLC" },
        { 0x0024E1, "Convey Computer Corp." },
        { 0x0024E2, "HASEGAWA ELECTRIC CO.,LTD." },
        { 0x0024E3, "CAO Group" },
        { 0x0024E4, "Withings" },
        { 0x0024E5, "Seer Technology, Inc" },
        { 0x0024E6, "In Motion Technology Inc." },
        { 0x0024E7, "Plaster Networks" },
        { 0x0024E8, "Dell Inc." },
        { 0x0024E9, "Samsung Electronics Co.,Ltd" },
        { 0x0024EA, "iris-GmbH infrared & intelligent sensors" },
        { 0x0024EB, "ClearPath Networks, Inc." },
        { 0x0024EC, "United Information Technology Co.,Ltd." },
        { 0x0024ED, "YT Elec. Co,.Ltd." },
        { 0x0024EE, "Wynmax Inc." },
        { 0x0024EF, "Sony Mobile Communications Inc" },
        { 0x0024F0, "Seanodes" },
        { 0x0024F1, "Shenzhen Fanhai Sanjiang Electronics Co., Ltd." },
        { 0x0024F2, "Uniphone Telecommunication Co., Ltd." },
        { 0x0024F3, "Nintendo Co., Ltd." },
        { 0x0024F4, "Kaminario, Ltd." },
        { 0x0024F5, "NDS Surgical Imaging" },
        { 0x0024F6, "MIYOSHI ELECTRONICS CORPORATION" },
        { 0x0024F7, "Cisco Systems, Inc" },
        { 0x0024F8, "Technical Solutions Company Ltd." },
        { 0x0024F9, "Cisco Systems, Inc" },
        { 0x0024FA, "Hilger u. Kern GMBH" },
        { 0x0024FB, "Private" },
        { 0x0024FC, "QuoPin Co., Ltd." },
        { 0x0024FD, "Accedian Networks Inc" },
        { 0x0024FE, "AVM GmbH" },
        { 0x0024FF, "QLogic Corporation" },
        { 0x002500, "Apple, Inc." },
        { 0x002501, "JSC Supertel" },
        { 0x002502, "NaturalPoint" },
        { 0x002503, "IBM Corp" },
        { 0x002504, "Valiant Communications Limited" },
        { 0x002505, "eks Engel GmbH & Co. KG" },
        { 0x002506, "A.I. ANTITACCHEGGIO ITALIA SRL" },
        { 0x002507, "ASTAK Inc." },
        { 0x002508, "Maquet Cardiopulmonary AG" },
        { 0x002509, "SHARETRONIC Group LTD" },
        { 0x00250A, "Security Expert Co. Ltd" },
        { 0x00250B, "CENTROFACTOR INC" },
        { 0x00250C, "Senet Inc" },
        { 0x00250D, "GZT Telkom-Telmor sp. z o.o." },
        { 0x00250E, "gt german telematics gmbh" },
        { 0x00250F, "On-Ramp Wireless, Inc." },
        { 0x002510, "Pico-Tesla Magnetic Therapies" },
        { 0x002511, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x002512, "zte corporation" },
        { 0x002513, "CXP DIGITAL BV" },
        { 0x002514, "PC Worth Int'l Co., Ltd." },
        { 0x002515, "SFR" },
        { 0x002516, "Integrated Design Tools, Inc." },
        { 0x002517, "Venntis, LLC" },
        { 0x002518, "Power PLUS Communications AG" },
        { 0x002519, "Viaas Inc" },
        { 0x00251A, "Psiber Data Systems Inc." },
        { 0x00251B, "Philips CareServant" },
        { 0x00251C, "EDT" },
        { 0x00251D, "DSA Encore, LLC" },
        { 0x00251E, "ROTEL TECHNOLOGIES" },
        { 0x00251F, "ZYNUS VISION INC." },
        { 0x002520, "SMA Railway Technology GmbH" },
        { 0x002521, "Logitek Electronic Systems, Inc." },
        { 0x002522, "ASRock Incorporation" },
        { 0x002523, "OCP Inc." },
        { 0x002524, "Lightcomm Technology Co., Ltd" },
        { 0x002525, "CTERA Networks Ltd." },
        { 0x002526, "Genuine Technologies Co., Ltd." },
        { 0x002527, "Bitrode Corp." },
        { 0x002528, "Daido Signal Co., Ltd." },
        { 0x002529, "COMELIT GROUP S.P.A" },
        { 0x00252A, "Chengdu GeeYa Technology Co.,LTD" },
        { 0x00252B, "Stirling Energy Systems" },
        { 0x00252C, "Entourage Systems, Inc." },
        { 0x00252D, "Kiryung Electronics" },
        { 0x00252E, "Cisco SPVTG" },
        { 0x00252F, "Energy, Inc." },
        { 0x002530, "Aetas Systems Inc." },
        { 0x002531, "Cloud Engines, Inc." },
        { 0x002532, "Digital Recorders" },
        { 0x002533, "WITTENSTEIN AG" },
        { 0x002535, "Minimax GmbH & Co KG" },
        { 0x002536, "Oki Electric Industry Co., Ltd." },
        { 0x002537, "Runcom Technologies Ltd." },
        { 0x002538, "Samsung Electronics Co., Ltd., Memory Division" },
        { 0x002539, "IfTA GmbH" },
        { 0x00253A, "CEVA, Ltd." },
        { 0x00253B, "din Dietmar Nocker Facilitymanagement GmbH" },
        { 0x00253C, "2Wire Inc" },
        { 0x00253D, "DRS Consolidated Controls" },
        { 0x00253E, "Sensus Metering Systems" },
        { 0x002540, "Quasar Technologies, Inc." },
        { 0x002541, "Maquet Critical Care AB" },
        { 0x002542, "Pittasoft" },
        { 0x002543, "MONEYTECH" },
        { 0x002544, "LoJack Corporation" },
        { 0x002545, "Cisco Systems, Inc" },
        { 0x002546, "Cisco Systems, Inc" },
        { 0x002547, "Nokia Danmark A/S" },
        { 0x002548, "Nokia Danmark A/S" },
        { 0x002549, "Jeorich Tech. Co.,Ltd." },
        { 0x00254A, "RingCube Technologies, Inc." },
        { 0x00254B, "Apple, Inc." },
        { 0x00254C, "Videon Central, Inc." },
        { 0x00254D, "Singapore Technologies Electronics Limited" },
        { 0x00254E, "Vertex Wireless Co., Ltd." },
        { 0x00254F, "ELETTROLAB Srl" },
        { 0x002550, "Riverbed Technology, Inc." },
        { 0x002551, "SE-Elektronic GmbH" },
        { 0x002552, "VXi Corporation" },
        { 0x002553, "ADB Broadband Italia" },
        { 0x002554, "Pixel8 Networks" },
        { 0x002555, "Visonic Technologies 1993 Ltd." },
        { 0x002556, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x002557, "BlackBerry RTS" },
        { 0x002558, "MPEDIA" },
        { 0x002559, "Syphan Technologies Ltd" },
        { 0x00255A, "Tantalus Systems Corp." },
        { 0x00255B, "CoachComm, LLC" },
        { 0x00255C, "NEC Corporation" },
        { 0x00255D, "Morningstar Corporation" },
        { 0x00255E, "Shanghai Dare Technologies Co.,Ltd." },
        { 0x00255F, "SenTec AG" },
        { 0x002560, "Ibridge Networks & Communications Ltd." },
        { 0x002561, "ProCurve Networking by HP" },
        { 0x002562, "interbro Co. Ltd." },
        { 0x002563, "Luxtera Inc" },
        { 0x002564, "Dell Inc." },
        { 0x002565, "Vizimax Inc." },
        { 0x002566, "Samsung Electronics Co.,Ltd" },
        { 0x002567, "Samsung Electronics Co.,Ltd" },
        { 0x002568, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x002569, "Sagemcom Broadband SAS" },
        { 0x00256A, "inIT - Institut Industrial IT" },
        { 0x00256B, "ATENIX E.E. s.r.l." },
        { 0x00256C, "Azimut Production Association JSC" },
        { 0x00256D, "Broadband Forum" },
        { 0x00256E, "Van Breda B.V." },
        { 0x00256F, "Dantherm Power" },
        { 0x002570, "Eastern Communications Company Limited" },
        { 0x002571, "Zhejiang Tianle Digital Electric Co.,Ltd" },
        { 0x002572, "Nemo-Q International AB" },
        { 0x002573, "ST Electronics (Info-Security) Pte Ltd" },
        { 0x002574, "KUNIMI MEDIA DEVICE Co., Ltd." },
        { 0x002575, "FiberPlex Technologies, LLC" },
        { 0x002576, "NELI TECHNOLOGIES" },
        { 0x002577, "D-BOX Technologies" },
        { 0x002578, "JSC Concern Sozvezdie" },
        { 0x002579, "J & F Labs" },
        { 0x00257A, "CAMCO Produktions- und Vertriebs-GmbH für Beschallungs- und Beleuchtungsanlagen" },
        { 0x00257B, "STJ ELECTRONICS PVT LTD" },
        { 0x00257C, "Huachentel Technology Development Co., Ltd" },
        { 0x00257D, "PointRed Telecom Private Ltd." },
        { 0x00257E, "NEW POS TECHNOLOGY LIMITED" },
        { 0x00257F, "CallTechSolution Co.,Ltd" },
        { 0x002580, "Equipson S.A." },
        { 0x002581, "x-star networks Inc." },
        { 0x002582, "Maksat Technologies (P) Ltd" },
        { 0x002583, "Cisco Systems, Inc" },
        { 0x002584, "Cisco Systems, Inc" },
        { 0x002585, "KOKUYO S&T Co., Ltd." },
        { 0x002586, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x002587, "Vitality, Inc." },
        { 0x002588, "Genie Industries, Inc." },
        { 0x002589, "Hills Industries Limited" },
        { 0x00258A, "Pole/Zero Corporation" },
        { 0x00258B, "Mellanox Technologies, Inc." },
        { 0x00258C, "ESUS ELEKTRONIK SAN. VE DIS. TIC. LTD. STI." },
        { 0x00258D, "Haier" },
        { 0x00258E, "The Weather Channel" },
        { 0x00258F, "Trident Microsystems, Inc." },
        { 0x002590, "Super Micro Computer, Inc." },
        { 0x002591, "NEXTEK, Inc." },
        { 0x002592, "Guangzhou Shirui Electronic Co., Ltd" },
        { 0x002593, "DatNet Informatikai Kft." },
        { 0x002594, "Eurodesign BG LTD" },
        { 0x002595, "Northwest Signal Supply, Inc" },
        { 0x002596, "GIGAVISION srl" },
        { 0x002597, "Kalki Communication Technologies" },
        { 0x002598, "Zhong Shan City Litai Electronic Industrial Co. Ltd" },
        { 0x002599, "Hedon e.d. B.V." },
        { 0x00259A, "CEStronics GmbH" },
        { 0x00259B, "Beijing PKUNITY Microsystems Technology Co., Ltd" },
        { 0x00259C, "Cisco-Linksys, LLC" },
        { 0x00259D, "Private" },
        { 0x00259E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x00259F, "TechnoDigital Technologies GmbH" },
        { 0x0025A0, "Nintendo Co., Ltd." },
        { 0x0025A1, "Enalasys" },
        { 0x0025A2, "Alta Definicion LINCEO S.L." },
        { 0x0025A3, "Trimax Wireless, Inc." },
        { 0x0025A4, "EuroDesign embedded technologies GmbH" },
        { 0x0025A5, "Walnut Media Network" },
        { 0x0025A6, "Central Network Solution Co., Ltd." },
        { 0x0025A7, "itron" },
        { 0x0025A8, "Kontron (BeiJing) Technology Co.,Ltd" },
        { 0x0025A9, "Shanghai Embedway Information Technologies Co.,Ltd" },
        { 0x0025AA, "Beijing Soul Technology Co.,Ltd." },
        { 0x0025AB, "AIO LCD PC BU / TPV" },
        { 0x0025AC, "I-Tech corporation" },
        { 0x0025AD, "Manufacturing Resources International" },
        { 0x0025AE, "Microsoft Corporation" },
        { 0x0025AF, "COMFILE Technology" },
        { 0x0025B0, "Schmartz Inc" },
        { 0x0025B1, "Maya-Creation Corporation" },
        { 0x0025B2, "MBDA Deutschland GmbH" },
        { 0x0025B3, "Hewlett Packard" },
        { 0x0025B4, "Cisco Systems, Inc" },
        { 0x0025B5, "Cisco Systems, Inc" },
        { 0x0025B6, "Telecom FM" },
        { 0x0025B7, "Costar electronics, inc.," },
        { 0x0025B8, "Agile Communications, Inc." },
        { 0x0025B9, "Cypress Solutions Inc" },
        { 0x0025BA, "Alcatel-Lucent IPD" },
        { 0x0025BB, "INNERINT Co., Ltd." },
        { 0x0025BC, "Apple, Inc." },
        { 0x0025BD, "Italdata Ingegneria dell'Idea S.p.A." },
        { 0x0025BE, "Tektrap Systems Inc." },
        { 0x0025BF, "Wireless Cables Inc." },
        { 0x0025C0, "ZillionTV Corporation" },
        { 0x0025C1, "Nawoo Korea Corp." },
        { 0x0025C2, "RingBell Co.,Ltd." },
        { 0x0025C3, "21168" },
        { 0x0025C4, "Ruckus Wireless" },
        { 0x0025C5, "Star Link Communication Pvt. Ltd." },
        { 0x0025C6, "kasercorp, ltd" },
        { 0x0025C7, "altek Corporation" },
        { 0x0025C8, "S-Access GmbH" },
        { 0x0025C9, "SHENZHEN HUAPU DIGITAL CO., LTD" },
        { 0x0025CA, "LS Research, LLC" },
        { 0x0025CB, "Reiner SCT" },
        { 0x0025CC, "Mobile Communications Korea Incorporated" },
        { 0x0025CD, "Skylane Optics" },
        { 0x0025CE, "InnerSpace" },
        { 0x0025CF, "Nokia Danmark A/S" },
        { 0x0025D0, "Nokia Danmark A/S" },
        { 0x0025D1, "Eastern Asia Technology Limited" },
        { 0x0025D2, "InpegVision Co., Ltd" },
        { 0x0025D3, "AzureWave Technology Inc." },
        { 0x0025D4, "General Dynamics Mission Systems" },
        { 0x0025D5, "Robonica (Pty) Ltd" },
        { 0x0025D6, "The Kroger Co." },
        { 0x0025D7, "CEDO" },
        { 0x0025D8, "KOREA MAINTENANCE" },
        { 0x0025D9, "DataFab Systems Inc." },
        { 0x0025DA, "Secura Key" },
        { 0x0025DB, "ATI Electronics(Shenzhen) Co., LTD" },
        { 0x0025DC, "Sumitomo Electric Industries, Ltd" },
        { 0x0025DD, "SUNNYTEK INFORMATION CO., LTD." },
        { 0x0025DE, "Probits Co., LTD." },
        { 0x0025DF, "Private" },
        { 0x0025E0, "CeedTec Sdn Bhd" },
        { 0x0025E1, "SHANGHAI SEEYOO ELECTRONIC & TECHNOLOGY CO., LTD" },
        { 0x0025E2, "Everspring Industry Co., Ltd." },
        { 0x0025E3, "Hanshinit Inc." },
        { 0x0025E4, "OMNI-WiFi, LLC" },
        { 0x0025E5, "LG Electronics (Mobile Communications)" },
        { 0x0025E6, "Belgian Monitoring Systems bvba" },
        { 0x0025E7, "Sony Mobile Communications Inc" },
        { 0x0025E8, "Idaho Technology" },
        { 0x0025E9, "i-mate Development, Inc." },
        { 0x0025EA, "Iphion BV" },
        { 0x0025EB, "Reutech Radar Systems (PTY) Ltd" },
        { 0x0025EC, "Humanware" },
        { 0x0025ED, "NuVo Technologies LLC" },
        { 0x0025EE, "Avtex Ltd" },
        { 0x0025EF, "I-TEC Co., Ltd." },
        { 0x0025F0, "Suga Electronics Limited" },
        { 0x0025F1, "ARRIS Group, Inc." },
        { 0x0025F2, "ARRIS Group, Inc." },
        { 0x0025F3, "Nordwestdeutsche Zählerrevision" },
        { 0x0025F4, "KoCo Connector AG" },
        { 0x0025F5, "DVS Korea, Co., Ltd" },
        { 0x0025F6, "netTALK.com, Inc." },
        { 0x0025F7, "Ansaldo STS USA" },
        { 0x0025F9, "GMK electronic design GmbH" },
        { 0x0025FA, "J&M Analytik AG" },
        { 0x0025FB, "Tunstall Healthcare A/S" },
        { 0x0025FC, "ENDA ENDUSTRIYEL ELEKTRONIK LTD. STI." },
        { 0x0025FD, "OBR Centrum Techniki Morskiej S.A." },
        { 0x0025FE, "Pilot Electronics Corporation" },
        { 0x0025FF, "CreNova Multimedia Co., Ltd" },
        { 0x002600, "TEAC Australia Pty Ltd." },
        { 0x002601, "Cutera Inc" },
        { 0x002602, "SMART Temps LLC" },
        { 0x002603, "Shenzhen Wistar Technology Co., Ltd" },
        { 0x002604, "Audio Processing Technology Ltd" },
        { 0x002605, "CC Systems AB" },
        { 0x002606, "RAUMFELD GmbH" },
        { 0x002607, "Enabling Technology Pty Ltd" },
        { 0x002608, "Apple, Inc." },
        { 0x002609, "Phyllis Co., Ltd." },
        { 0x00260A, "Cisco Systems, Inc" },
        { 0x00260B, "Cisco Systems, Inc" },
        { 0x00260C, "Dataram" },
        { 0x00260D, "Mercury Systems, Inc." },
        { 0x00260E, "Ablaze Systems, LLC" },
        { 0x00260F, "Linn Products Ltd" },
        { 0x002610, "Apacewave Technologies" },
        { 0x002611, "Licera AB" },
        { 0x002612, "Space Exploration Technologies" },
        { 0x002613, "Engel Axil S.L." },
        { 0x002614, "KTNF" },
        { 0x002615, "Teracom Limited" },
        { 0x002616, "Rosemount Inc." },
        { 0x002617, "OEM Worldwide" },
        { 0x002618, "ASUSTek COMPUTER INC." },
        { 0x002619, "FRC" },
        { 0x00261A, "Femtocomm System Technology Corp." },
        { 0x00261B, "LAUREL BANK MACHINES CO., LTD." },
        { 0x00261C, "NEOVIA INC." },
        { 0x00261D, "COP SECURITY SYSTEM CORP." },
        { 0x00261E, "QINGBANG ELEC(SZ) CO., LTD" },
        { 0x00261F, "SAE Magnetics (H.K.) Ltd." },
        { 0x002620, "ISGUS GmbH" },
        { 0x002621, "InteliCloud Technology Inc." },
        { 0x002622, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x002623, "JRD Communication Inc" },
        { 0x002624, "Thomson Inc." },
        { 0x002625, "MediaSputnik" },
        { 0x002626, "Geophysical Survey Systems, Inc." },
        { 0x002627, "Truesell" },
        { 0x002628, "companytec automação e controle ltda." },
        { 0x002629, "Juphoon System Software Inc." },
        { 0x00262A, "Proxense, LLC" },
        { 0x00262B, "Wongs Electronics Co. Ltd." },
        { 0x00262C, "IKT Advanced Technologies s.r.o." },
        { 0x00262D, "Wistron Corporation" },
        { 0x00262E, "Chengdu Jiuzhou Electronic Technology Inc" },
        { 0x00262F, "HAMAMATSU TOA ELECTRONICS" },
        { 0x002630, "ACOREL S.A.S" },
        { 0x002631, "COMMTACT LTD" },
        { 0x002632, "Instrumentation Technologies d.d." },
        { 0x002633, "MIR - Medical International Research" },
        { 0x002634, "Infineta Systems, Inc" },
        { 0x002635, "Bluetechnix GmbH" },
        { 0x002636, "ARRIS Group, Inc." },
        { 0x002637, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x002638, "Xia Men Joyatech Co., Ltd." },
        { 0x002639, "T.M. Electronics, Inc." },
        { 0x00263A, "Digitec Systems" },
        { 0x00263B, "Onbnetech" },
        { 0x00263C, "Bachmann Technology GmbH & Co. KG" },
        { 0x00263D, "MIA Corporation" },
        { 0x00263E, "Trapeze Networks" },
        { 0x00263F, "LIOS Technology GmbH" },
        { 0x002640, "Baustem Broadband Technologies, Ltd." },
        { 0x002641, "ARRIS Group, Inc." },
        { 0x002642, "ARRIS Group, Inc." },
        { 0x002643, "ALPS ELECTRIC CO., LTD." },
        { 0x002644, "Thomson Telecom Belgium" },
        { 0x002645, "Circontrol S.A." },
        { 0x002646, "SHENYANG TONGFANG MULTIMEDIA TECHNOLOGY COMPANY LIMITED" },
        { 0x002647, "WFE TECHNOLOGY CORP." },
        { 0x002648, "Emitech Corp." },
        { 0x00264A, "Apple, Inc." },
        { 0x00264C, "Shanghai DigiVision Technology Co., Ltd." },
        { 0x00264D, "Arcadyan Technology Corporation" },
        { 0x00264E, "r2p GmbH" },
        { 0x00264F, "Krüger &Gothe GmbH" },
        { 0x002650, "2Wire Inc" },
        { 0x002651, "Cisco Systems, Inc" },
        { 0x002652, "Cisco Systems, Inc" },
        { 0x002653, "DaySequerra Corporation" },
        { 0x002654, "3COM" },
        { 0x002655, "Hewlett Packard" },
        { 0x002656, "Sansonic Electronics USA" },
        { 0x002657, "OOO NPP EKRA" },
        { 0x002658, "T-Platforms (Cyprus) Limited" },
        { 0x002659, "Nintendo Co., Ltd." },
        { 0x00265A, "D-Link Corporation" },
        { 0x00265B, "Hitron Technologies. Inc" },
        { 0x00265C, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00265D, "Samsung Electronics Co.,Ltd" },
        { 0x00265E, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x00265F, "Samsung Electronics Co.,Ltd" },
        { 0x002660, "Logiways" },
        { 0x002661, "Irumtek Co., Ltd." },
        { 0x002662, "Actiontec Electronics, Inc" },
        { 0x002663, "Shenzhen Huitaiwei Tech. Ltd, co." },
        { 0x002664, "Core System Japan" },
        { 0x002665, "ProtectedLogic Corporation" },
        { 0x002666, "EFM Networks" },
        { 0x002667, "CARECOM CO.,LTD." },
        { 0x002668, "Nokia Danmark A/S" },
        { 0x002669, "Nokia Danmark A/S" },
        { 0x00266A, "ESSENSIUM NV" },
        { 0x00266B, "SHINE UNION ENTERPRISE LIMITED" },
        { 0x00266C, "INVENTEC CORPORATION" },
        { 0x00266D, "MobileAccess Networks" },
        { 0x00266E, "Nissho-denki Co.,LTD." },
        { 0x00266F, "Coordiwise Technology Corp." },
        { 0x002670, "Cinch Connectors" },
        { 0x002671, "AUTOVISION Co., Ltd" },
        { 0x002672, "AAMP of America" },
        { 0x002673, "RICOH COMPANY,LTD." },
        { 0x002674, "Hunter Douglas" },
        { 0x002675, "Aztech Electronics Pte Ltd" },
        { 0x002676, "COMMidt AS" },
        { 0x002677, "DEIF A/S" },
        { 0x002678, "Logic Instrument SA" },
        { 0x002679, "Euphonic Technologies, Inc." },
        { 0x00267A, "wuhan hongxin telecommunication technologies co.,ltd" },
        { 0x00267B, "GSI Helmholtzzentrum für Schwerionenforschung GmbH" },
        { 0x00267C, "Metz-Werke GmbH & Co KG" },
        { 0x00267D, "A-Max Technology Macao Commercial Offshore Company Limited" },
        { 0x00267E, "PARROT SA" },
        { 0x00267F, "Zenterio AB" },
        { 0x002680, "SIL3 Pty.Ltd" },
        { 0x002681, "Interspiro AB" },
        { 0x002682, "Gemtek Technology Co., Ltd." },
        { 0x002683, "Ajoho Enterprise Co., Ltd." },
        { 0x002684, "KISAN SYSTEM" },
        { 0x002685, "Digital Innovation" },
        { 0x002686, "Quantenna Communcations, Inc." },
        { 0x002687, "corega K.K" },
        { 0x002688, "Juniper Networks" },
        { 0x002689, "General Dynamics Robotic Systems" },
        { 0x00268A, "Terrier SC Ltd" },
        { 0x00268B, "Guangzhou Escene Computer Technology Limited" },
        { 0x00268C, "StarLeaf Ltd." },
        { 0x00268D, "CellTel S.p.A." },
        { 0x00268E, "Alta Solutions, Inc." },
        { 0x00268F, "MTA SpA" },
        { 0x002690, "I DO IT" },
        { 0x002691, "Sagemcom Broadband SAS" },
        { 0x002692, "Mitsubishi Electric Corporation" },
        { 0x002693, "QVidium Technologies, Inc." },
        { 0x002694, "Senscient Ltd" },
        { 0x002695, "ZT Group Int'l Inc" },
        { 0x002696, "NOOLIX Co., Ltd" },
        { 0x002697, "Alpha Technologies Inc." },
        { 0x002698, "Cisco Systems, Inc" },
        { 0x002699, "Cisco Systems, Inc" },
        { 0x00269A, "Carina System Co., Ltd." },
        { 0x00269B, "SOKRAT Ltd." },
        { 0x00269C, "ITUS JAPAN CO. LTD" },
        { 0x00269D, "M2Mnet Co., Ltd." },
        { 0x00269E, "Quanta Computer Inc." },
        { 0x00269F, "Private" },
        { 0x0026A0, "moblic" },
        { 0x0026A1, "Megger" },
        { 0x0026A2, "Instrumentation Technology Systems" },
        { 0x0026A3, "FQ Ingenieria Electronica S.A." },
        { 0x0026A4, "Novus Produtos Eletronicos Ltda" },
        { 0x0026A5, "MICROROBOT.CO.,LTD" },
        { 0x0026A6, "TRIXELL" },
        { 0x0026A7, "CONNECT SRL" },
        { 0x0026A8, "DAEHAP HYPER-TECH" },
        { 0x0026A9, "Strong Technologies Pty Ltd" },
        { 0x0026AA, "Kenmec Mechanical Engineering Co., Ltd." },
        { 0x0026AB, "Seiko Epson Corporation" },
        { 0x0026AC, "Shanghai LUSTER Teraband photonic Co., Ltd." },
        { 0x0026AD, "Arada Systems, Inc." },
        { 0x0026AE, "Wireless Measurement Ltd" },
        { 0x0026AF, "Duelco A/S" },
        { 0x0026B0, "Apple, Inc." },
        { 0x0026B1, "Navis Auto Motive Systems, Inc." },
        { 0x0026B2, "Setrix GmbH" },
        { 0x0026B3, "Thales Communications Inc" },
        { 0x0026B4, "Ford Motor Company" },
        { 0x0026B5, "ICOMM Tele Ltd" },
        { 0x0026B6, "ASKEY COMPUTER CORP" },
        { 0x0026B7, "Kingston Technology Company, Inc." },
        { 0x0026B8, "Actiontec Electronics, Inc" },
        { 0x0026B9, "Dell Inc." },
        { 0x0026BA, "ARRIS Group, Inc." },
        { 0x0026BB, "Apple, Inc." },
        { 0x0026BC, "General Jack Technology Ltd." },
        { 0x0026BD, "JTEC Card &amp; Communication Co., Ltd" },
        { 0x0026BE, "Schoonderbeek Elektronica Systemen B.V." },
        { 0x0026BF, "ShenZhen Temobi Science&Tech Development Co.,Ltd" },
        { 0x0026C0, "EnergyHub" },
        { 0x0026C1, "ARTRAY CO., LTD." },
        { 0x0026C2, "SCDI Co. LTD" },
        { 0x0026C3, "Insightek Corp." },
        { 0x0026C4, "Cadmos microsystems S.r.l." },
        { 0x0026C5, "Guangdong Gosun Telecommunications Co.,Ltd" },
        { 0x0026C6, "Intel Corporate" },
        { 0x0026C7, "Intel Corporate" },
        { 0x0026C8, "System Sensor" },
        { 0x0026C9, "Proventix Systems, Inc." },
        { 0x0026CA, "Cisco Systems, Inc" },
        { 0x0026CB, "Cisco Systems, Inc" },
        { 0x0026CC, "Nokia Danmark A/S" },
        { 0x0026CD, "PurpleComm, Inc." },
        { 0x0026CE, "Kozumi USA Corp." },
        { 0x0026CF, "DEKA R&D" },
        { 0x0026D0, "Semihalf" },
        { 0x0026D1, "S Squared Innovations Inc." },
        { 0x0026D2, "Pcube Systems, Inc." },
        { 0x0026D3, "Zeno Information System" },
        { 0x0026D4, "IRCA SpA" },
        { 0x0026D5, "Ory Solucoes em Comercio de Informatica Ltda." },
        { 0x0026D6, "Ningbo Andy Optoelectronic Co., Ltd." },
        { 0x0026D7, "KM Electornic Technology Co., Ltd." },
        { 0x0026D8, "Magic Point Inc." },
        { 0x0026D9, "ARRIS Group, Inc." },
        { 0x0026DA, "Universal Media Corporation /Slovakia/ s.r.o." },
        { 0x0026DB, "Ionics EMS Inc." },
        { 0x0026DC, "Optical Systems Design" },
        { 0x0026DD, "Fival Science & Technology Co.,Ltd." },
        { 0x0026DE, "FDI MATELEC" },
        { 0x0026DF, "TaiDoc Technology Corp." },
        { 0x0026E0, "ASITEQ" },
        { 0x0026E1, "Stanford University, OpenFlow Group" },
        { 0x0026E2, "LG Electronics (Mobile Communications)" },
        { 0x0026E3, "DTI" },
        { 0x0026E4, "Canal +" },
        { 0x0026E5, "AEG Power Solutions" },
        { 0x0026E6, "Visionhitech Co., Ltd." },
        { 0x0026E7, "Shanghai ONLAN Communication Tech. Co., Ltd." },
        { 0x0026E8, "Murata Manufacturing Co., Ltd." },
        { 0x0026E9, "SP Corp" },
        { 0x0026EA, "Cheerchip Electronic Technology (ShangHai) Co., Ltd." },
        { 0x0026EB, "Advanced Spectrum Technology Co., Ltd." },
        { 0x0026EC, "Legrand Home Systems, Inc" },
        { 0x0026ED, "zte corporation" },
        { 0x0026EE, "TKM GmbH" },
        { 0x0026EF, "Technology Advancement Group, Inc." },
        { 0x0026F0, "cTrixs International GmbH." },
        { 0x0026F1, "ProCurve Networking by HP" },
        { 0x0026F2, "NETGEAR" },
        { 0x0026F3, "SMC Networks" },
        { 0x0026F4, "Nesslab" },
        { 0x0026F5, "XRPLUS Inc." },
        { 0x0026F6, "Military Communication Institute" },
        { 0x0026F7, "Nivetti Systems Pvt. Ltd." },
        { 0x0026F8, "Golden Highway Industry Development Co., Ltd." },
        { 0x0026F9, "S.E.M. srl" },
        { 0x0026FA, "BandRich Inc." },
        { 0x0026FB, "AirDio Wireless, Inc." },
        { 0x0026FC, "AcSiP Technology Corp." },
        { 0x0026FD, "Interactive Intelligence" },
        { 0x0026FE, "MKD Technology Inc." },
        { 0x0026FF, "BlackBerry RTS" },
        { 0x002700, "Shenzhen Siglent Technology Co., Ltd." },
        { 0x002701, "INCOstartec GmbH" },
        { 0x002702, "SolarEdge Technologies" },
        { 0x002703, "Testech Electronics Pte Ltd" },
        { 0x002704, "Accelerated Concepts, Inc" },
        { 0x002705, "Sectronic" },
        { 0x002706, "YOISYS" },
        { 0x002707, "Lift Complex DS, JSC" },
        { 0x002708, "Nordiag ASA" },
        { 0x002709, "Nintendo Co., Ltd." },
        { 0x00270A, "IEE S.A." },
        { 0x00270B, "Adura Technologies" },
        { 0x00270C, "Cisco Systems, Inc" },
        { 0x00270D, "Cisco Systems, Inc" },
        { 0x00270E, "Intel Corporate" },
        { 0x00270F, "Envisionnovation Inc" },
        { 0x002710, "Intel Corporate" },
        { 0x002711, "LanPro Inc" },
        { 0x002712, "MaxVision LLC" },
        { 0x002713, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x002714, "Grainmustards, Co,ltd." },
        { 0x002715, "Rebound Telecom. Co., Ltd" },
        { 0x002716, "Adachi-Syokai Co., Ltd." },
        { 0x002717, "CE Digital(Zhenjiang)Co.,Ltd" },
        { 0x002718, "Suzhou NEW SEAUNION Video Technology Co.,Ltd" },
        { 0x002719, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x00271A, "Geenovo Technology Ltd." },
        { 0x00271B, "Alec Sicherheitssysteme GmbH" },
        { 0x00271C, "MERCURY CORPORATION" },
        { 0x00271D, "Comba Telecom Systems (China) Ltd." },
        { 0x00271E, "Xagyl Communications" },
        { 0x00271F, "MIPRO Electronics Co., Ltd" },
        { 0x002720, "NEW-SOL COM" },
        { 0x002721, "Shenzhen Baoan Fenda Industrial Co., Ltd" },
        { 0x002722, "Ubiquiti Networks Inc." },
        { 0x002790, "Cisco Systems, Inc" },
        { 0x0027E3, "Cisco Systems, Inc" },
        { 0x0027F8, "Brocade Communications Systems LLC" },
        { 0x00289F, "Semptian Co., Ltd." },
        { 0x0028F8, "Intel Corporate" },
        { 0x002926, "Applied Optoelectronics, Inc Taiwan Branch" },
        { 0x0029C2, "Cisco Systems, Inc" },
        { 0x002A10, "Cisco Systems, Inc" },
        { 0x002A6A, "Cisco Systems, Inc" },
        { 0x002AAF, "LARsys-Automation GmbH" },
        { 0x002B67, "LCFC(HeFei) Electronics Technology co., ltd" },
        { 0x002CC8, "Cisco Systems, Inc" },
        { 0x002D76, "TITECH GmbH" },
        { 0x002EC7, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x002F5C, "Cisco Systems, Inc" },
        { 0x002FD9, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x003000, "ALLWELL TECHNOLOGY CORP." },
        { 0x003001, "SMP" },
        { 0x003002, "Expand Networks" },
        { 0x003003, "Phasys Ltd." },
        { 0x003004, "LEADTEK RESEARCH INC." },
        { 0x003005, "Fujitsu Siemens Computers" },
        { 0x003006, "SUPERPOWER COMPUTER" },
        { 0x003007, "OPTI, INC." },
        { 0x003008, "AVIO DIGITAL, INC." },
        { 0x003009, "Tachion Networks, Inc." },
        { 0x00300A, "Aztech Electronics Pte Ltd" },
        { 0x00300B, "mPHASE Technologies, Inc." },
        { 0x00300C, "CONGRUENCY, LTD." },
        { 0x00300D, "MMC Technology, Inc." },
        { 0x00300E, "Klotz Digital AG" },
        { 0x00300F, "IMT - Information Management T" },
        { 0x003010, "VISIONETICS INTERNATIONAL" },
        { 0x003011, "HMS Industrial Networks" },
        { 0x003012, "DIGITAL ENGINEERING LTD." },
        { 0x003013, "NEC Corporation" },
        { 0x003014, "DIVIO, INC." },
        { 0x003015, "CP CLARE CORP." },
        { 0x003016, "ISHIDA CO., LTD." },
        { 0x003017, "BlueArc UK Ltd" },
        { 0x003018, "Jetway Information Co., Ltd." },
        { 0x003019, "Cisco Systems, Inc" },
        { 0x00301A, "SMARTBRIDGES PTE. LTD." },
        { 0x00301B, "SHUTTLE, INC." },
        { 0x00301C, "ALTVATER AIRDATA SYSTEMS" },
        { 0x00301D, "SKYSTREAM, INC." },
        { 0x00301E, "3COM EUROPE LTD" },
        { 0x00301F, "OPTICAL NETWORKS, INC." },
        { 0x003020, "TSI, Inc.." },
        { 0x003021, "HSING TECH. ENTERPRISE CO.,LTD" },
        { 0x003022, "Fong Kai Industrial Co., Ltd." },
        { 0x003023, "COGENT COMPUTER SYSTEMS, INC." },
        { 0x003024, "Cisco Systems, Inc" },
        { 0x003025, "CHECKOUT COMPUTER SYSTEMS, LTD" },
        { 0x003026, "HeiTel Digital Video GmbH" },
        { 0x003027, "KERBANGO, INC." },
        { 0x003028, "FASE Saldatura srl" },
        { 0x003029, "OPICOM" },
        { 0x00302A, "SOUTHERN INFORMATION" },
        { 0x00302B, "INALP NETWORKS, INC." },
        { 0x00302C, "SYLANTRO SYSTEMS CORPORATION" },
        { 0x00302D, "QUANTUM BRIDGE COMMUNICATIONS" },
        { 0x00302E, "Hoft & Wessel AG" },
        { 0x00302F, "GE Aviation System" },
        { 0x003030, "HARMONIX CORPORATION" },
        { 0x003031, "LIGHTWAVE COMMUNICATIONS, INC." },
        { 0x003032, "MagicRam, Inc." },
        { 0x003033, "ORIENT TELECOM CO., LTD." },
        { 0x003034, "SET ENGINEERING" },
        { 0x003035, "Corning Incorporated" },
        { 0x003036, "RMP ELEKTRONIKSYSTEME GMBH" },
        { 0x003037, "Packard Bell Nec Services" },
        { 0x003038, "XCP, INC." },
        { 0x003039, "SOFTBOOK PRESS" },
        { 0x00303A, "MAATEL" },
        { 0x00303B, "PowerCom Technology" },
        { 0x00303C, "ONNTO CORP." },
        { 0x00303D, "IVA CORPORATION" },
        { 0x00303E, "Radcom Ltd." },
        { 0x00303F, "TurboComm Tech Inc." },
        { 0x003040, "Cisco Systems, Inc" },
        { 0x003041, "SAEJIN T & M CO., LTD." },
        { 0x003042, "DeTeWe-Deutsche Telephonwerke" },
        { 0x003043, "IDREAM TECHNOLOGIES, PTE. LTD." },
        { 0x003044, "CradlePoint, Inc" },
        { 0x003045, "Village Networks, Inc. (VNI)" },
        { 0x003046, "Controlled Electronic Manageme" },
        { 0x003047, "NISSEI ELECTRIC CO., LTD." },
        { 0x003048, "Super Micro Computer, Inc." },
        { 0x003049, "BRYANT TECHNOLOGY, LTD." },
        { 0x00304A, "Fraunhofer IPMS" },
        { 0x00304B, "ORBACOM SYSTEMS, INC." },
        { 0x00304C, "APPIAN COMMUNICATIONS, INC." },
        { 0x00304D, "ESI" },
        { 0x00304E, "BUSTEC PRODUCTION LTD." },
        { 0x00304F, "PLANET Technology Corporation" },
        { 0x003050, "Versa Technology" },
        { 0x003051, "ORBIT AVIONIC & COMMUNICATION" },
        { 0x003052, "ELASTIC NETWORKS" },
        { 0x003053, "Basler AG" },
        { 0x003054, "Castlenet Technology Inc." },
        { 0x003055, "Renesas Technology America, Inc." },
        { 0x003056, "HMS Industrial Networks" },
        { 0x003057, "QTelNet, Inc." },
        { 0x003058, "API MOTION" },
        { 0x003059, "KONTRON COMPACT COMPUTERS AG" },
        { 0x00305A, "TELGEN CORPORATION" },
        { 0x00305B, "Toko Inc." },
        { 0x00305C, "SMAR Laboratories Corp." },
        { 0x00305D, "DIGITRA SYSTEMS, INC." },
        { 0x00305E, "Abelko Innovation" },
        { 0x00305F, "Hasselblad" },
        { 0x003060, "Powerfile, Inc." },
        { 0x003061, "MobyTEL" },
        { 0x003062, "IP Video Networks Inc" },
        { 0x003063, "SANTERA SYSTEMS, INC." },
        { 0x003064, "ADLINK TECHNOLOGY, INC." },
        { 0x003065, "Apple, Inc." },
        { 0x003066, "RFM" },
        { 0x003067, "BIOSTAR Microtech Int'l Corp." },
        { 0x003068, "CYBERNETICS TECH. CO., LTD." },
        { 0x003069, "IMPACCT TECHNOLOGY CORP." },
        { 0x00306A, "PENTA MEDIA CO., LTD." },
        { 0x00306B, "CMOS SYSTEMS, INC." },
        { 0x00306C, "Hitex Holding GmbH" },
        { 0x00306D, "LUCENT TECHNOLOGIES" },
        { 0x00306E, "Hewlett Packard" },
        { 0x00306F, "SEYEON TECH. CO., LTD." },
        { 0x003070, "1Net Corporation" },
        { 0x003071, "Cisco Systems, Inc" },
        { 0x003072, "Intellibyte Inc." },
        { 0x003073, "International Microsystems, In" },
        { 0x003074, "EQUIINET LTD." },
        { 0x003075, "ADTECH" },
        { 0x003076, "Akamba Corporation" },
        { 0x003077, "ONPREM NETWORKS" },
        { 0x003078, "Cisco Systems, Inc" },
        { 0x003079, "CQOS, INC." },
        { 0x00307A, "Advanced Technology & Systems" },
        { 0x00307B, "Cisco Systems, Inc" },
        { 0x00307C, "ADID SA" },
        { 0x00307D, "GRE AMERICA, INC." },
        { 0x00307E, "Redflex Communication Systems" },
        { 0x00307F, "IRLAN LTD." },
        { 0x003080, "Cisco Systems, Inc" },
        { 0x003081, "ALTOS C&C" },
        { 0x003082, "TAIHAN ELECTRIC WIRE CO., LTD." },
        { 0x003083, "Ivron Systems" },
        { 0x003084, "ALLIED TELESYN INTERNAIONAL" },
        { 0x003085, "Cisco Systems, Inc" },
        { 0x003086, "Transistor Devices, Inc." },
        { 0x003087, "VEGA GRIESHABER KG" },
        { 0x003088, "Ericsson" },
        { 0x003089, "Spectrapoint Wireless, LLC" },
        { 0x00308A, "NICOTRA SISTEMI S.P.A" },
        { 0x00308B, "Brix Networks" },
        { 0x00308C, "Quantum Corporation" },
        { 0x00308D, "Pinnacle Systems, Inc." },
        { 0x00308E, "CROSS MATCH TECHNOLOGIES, INC." },
        { 0x00308F, "MICRILOR, Inc." },
        { 0x003090, "CYRA TECHNOLOGIES, INC." },
        { 0x003091, "TAIWAN FIRST LINE ELEC. CORP." },
        { 0x003092, "Kontron Electronics AG" },
        { 0x003093, "Sonnet Technologies, Inc" },
        { 0x003094, "Cisco Systems, Inc" },
        { 0x003095, "Procomp Informatics, Ltd." },
        { 0x003096, "Cisco Systems, Inc" },
        { 0x003097, "AB Regin" },
        { 0x003098, "Global Converging Technologies" },
        { 0x003099, "BOENIG UND KALLENBACH OHG" },
        { 0x00309A, "ASTRO TERRA CORP." },
        { 0x00309B, "Smartware" },
        { 0x00309C, "Timing Applications, Inc." },
        { 0x00309D, "Nimble Microsystems, Inc." },
        { 0x00309E, "WORKBIT CORPORATION." },
        { 0x00309F, "AMBER NETWORKS" },
        { 0x0030A0, "TYCO SUBMARINE SYSTEMS, LTD." },
        { 0x0030A1, "WEBGATE Inc." },
        { 0x0030A2, "Lightner Engineering" },
        { 0x0030A3, "Cisco Systems, Inc" },
        { 0x0030A4, "Woodwind Communications System" },
        { 0x0030A5, "ACTIVE POWER" },
        { 0x0030A6, "VIANET TECHNOLOGIES, LTD." },
        { 0x0030A7, "SCHWEITZER ENGINEERING" },
        { 0x0030A8, "OL'E COMMUNICATIONS, INC." },
        { 0x0030A9, "Netiverse, Inc." },
        { 0x0030AA, "AXUS MICROSYSTEMS, INC." },
        { 0x0030AB, "DELTA NETWORKS, INC." },
        { 0x0030AC, "Systeme Lauer GmbH & Co., Ltd." },
        { 0x0030AD, "SHANGHAI COMMUNICATION" },
        { 0x0030AE, "Times N System, Inc." },
        { 0x0030AF, "Honeywell GmbH" },
        { 0x0030B0, "Convergenet Technologies" },
        { 0x0030B1, "TrunkNet" },
        { 0x0030B2, "L-3 Sonoma EO" },
        { 0x0030B3, "San Valley Systems, Inc." },
        { 0x0030B4, "INTERSIL CORP." },
        { 0x0030B5, "Tadiran Microwave Networks" },
        { 0x0030B6, "Cisco Systems, Inc" },
        { 0x0030B7, "Teletrol Systems, Inc." },
        { 0x0030B8, "RiverDelta Networks" },
        { 0x0030B9, "ECTEL" },
        { 0x0030BA, "AC&T SYSTEM CO., LTD." },
        { 0x0030BB, "CacheFlow, Inc." },
        { 0x0030BC, "Optronic AG" },
        { 0x0030BD, "BELKIN COMPONENTS" },
        { 0x0030BE, "City-Net Technology, Inc." },
        { 0x0030BF, "MULTIDATA GMBH" },
        { 0x0030C0, "Lara Technology, Inc." },
        { 0x0030C1, "Hewlett Packard" },
        { 0x0030C2, "COMONE" },
        { 0x0030C3, "FLUECKIGER ELEKTRONIK AG" },
        { 0x0030C4, "Canon Imaging Systems Inc." },
        { 0x0030C5, "CADENCE DESIGN SYSTEMS, INC." },
        { 0x0030C6, "CONTROL SOLUTIONS, INC." },
        { 0x0030C7, "Macromate Corp." },
        { 0x0030C8, "GAD LINE, LTD." },
        { 0x0030C9, "LuxN, N" },
        { 0x0030CA, "Discovery Com" },
        { 0x0030CB, "OMNI FLOW COMPUTERS, INC." },
        { 0x0030CC, "Tenor Networks, Inc." },
        { 0x0030CD, "CONEXANT SYSTEMS, INC." },
        { 0x0030CE, "Zaffire" },
        { 0x0030CF, "TWO TECHNOLOGIES, INC." },
        { 0x0030D0, "Tellabs" },
        { 0x0030D1, "INOVA CORPORATION" },
        { 0x0030D2, "WIN TECHNOLOGIES, CO., LTD." },
        { 0x0030D3, "Agilent Technologies, Inc." },
        { 0x0030D4, "AAE Systems, Inc." },
        { 0x0030D5, "DResearch GmbH" },
        { 0x0030D6, "MSC VERTRIEBS GMBH" },
        { 0x0030D7, "Innovative Systems, L.L.C." },
        { 0x0030D8, "SITEK" },
        { 0x0030D9, "DATACORE SOFTWARE CORP." },
        { 0x0030DA, "Comtrend Corporation" },
        { 0x0030DB, "Mindready Solutions, Inc." },
        { 0x0030DC, "RIGHTECH CORPORATION" },
        { 0x0030DD, "INDIGITA CORPORATION" },
        { 0x0030DE, "WAGO Kontakttechnik GmbH" },
        { 0x0030DF, "KB/TEL TELECOMUNICACIONES" },
        { 0x0030E0, "OXFORD SEMICONDUCTOR LTD." },
        { 0x0030E1, "Network Equipment Technologies, Inc." },
        { 0x0030E2, "GARNET SYSTEMS CO., LTD." },
        { 0x0030E3, "SEDONA NETWORKS CORP." },
        { 0x0030E4, "CHIYODA SYSTEM RIKEN" },
        { 0x0030E5, "Amper Datos S.A." },
        { 0x0030E6, "Draeger Medical Systems, Inc." },
        { 0x0030E7, "CNF MOBILE SOLUTIONS, INC." },
        { 0x0030E8, "ENSIM CORP." },
        { 0x0030E9, "GMA COMMUNICATION MANUFACT'G" },
        { 0x0030EA, "TeraForce Technology Corporation" },
        { 0x0030EB, "TURBONET COMMUNICATIONS, INC." },
        { 0x0030EC, "BORGARDT" },
        { 0x0030ED, "Expert Magnetics Corp." },
        { 0x0030EE, "DSG Technology, Inc." },
        { 0x0030EF, "NEON TECHNOLOGY, INC." },
        { 0x0030F0, "Uniform Industrial Corp." },
        { 0x0030F1, "Accton Technology Corp" },
        { 0x0030F2, "Cisco Systems, Inc" },
        { 0x0030F3, "At Work Computers" },
        { 0x0030F4, "STARDOT TECHNOLOGIES" },
        { 0x0030F5, "Wild Lab. Ltd." },
        { 0x0030F6, "SECURELOGIX CORPORATION" },
        { 0x0030F7, "RAMIX INC." },
        { 0x0030F8, "Dynapro Systems, Inc." },
        { 0x0030F9, "Sollae Systems Co., Ltd." },
        { 0x0030FA, "TELICA, INC." },
        { 0x0030FB, "AZS Technology AG" },
        { 0x0030FC, "Terawave Communications, Inc." },
        { 0x0030FD, "INTEGRATED SYSTEMS DESIGN" },
        { 0x0030FE, "DSA GmbH" },
        { 0x0030FF, "DataFab Systems Inc." },
        { 0x003146, "Juniper Networks" },
        { 0x003192, "TP-Link Corporation Limited" },
        { 0x003217, "Cisco Systems, Inc" },
        { 0x00323A, "so-logic" },
        { 0x00336C, "SynapSense Corporation" },
        { 0x0034A1, "RF-LAMBDA USA INC." },
        { 0x0034DA, "LG Electronics (Mobile Communications)" },
        { 0x0034F1, "Radicom Research, Inc." },
        { 0x0034FE, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x00351A, "Cisco Systems, Inc" },
        { 0x003532, "Electro-Metrics Corporation" },
        { 0x003560, "Rosen Aviation" },
        { 0x0035FF, "Texas Instruments" },
        { 0x003676, "ARRIS Group, Inc." },
        { 0x0036F8, "Conti Temic microelectronic GmbH" },
        { 0x0036FE, "SuperVision" },
        { 0x00376D, "Murata Manufacturing Co., Ltd." },
        { 0x0037B7, "Sagemcom Broadband SAS" },
        { 0x0038DF, "Cisco Systems, Inc" },
        { 0x003A7D, "Cisco Systems, Inc" },
        { 0x003A98, "Cisco Systems, Inc" },
        { 0x003A99, "Cisco Systems, Inc" },
        { 0x003A9A, "Cisco Systems, Inc" },
        { 0x003A9B, "Cisco Systems, Inc" },
        { 0x003A9C, "Cisco Systems, Inc" },
        { 0x003A9D, "NEC Platforms, Ltd." },
        { 0x003AAF, "BlueBit Ltd." },
        { 0x003C10, "Cisco Systems, Inc" },
        { 0x003CC5, "WONWOO Engineering Co., Ltd" },
        { 0x003D41, "Hatteland Computer AS" },
        { 0x003DE8, "LG Electronics (Mobile Communications)" },
        { 0x003EE1, "Apple, Inc." },
        { 0x004000, "PCI COMPONENTES DA AMZONIA LTD" },
        { 0x004001, "Zero One Technology Co. Ltd." },
        { 0x004002, "PERLE SYSTEMS LIMITED" },
        { 0x004003, "Emerson Process Management Power & Water Solutions, Inc." },
        { 0x004004, "ICM CO. LTD." },
        { 0x004005, "ANI COMMUNICATIONS INC." },
        { 0x004006, "SAMPO TECHNOLOGY CORPORATION" },
        { 0x004007, "TELMAT INFORMATIQUE" },
        { 0x004008, "A PLUS INFO CORPORATION" },
        { 0x004009, "TACHIBANA TECTRON CO., LTD." },
        { 0x00400A, "PIVOTAL TECHNOLOGIES, INC." },
        { 0x00400B, "Cisco Systems, Inc" },
        { 0x00400C, "GENERAL MICRO SYSTEMS, INC." },
        { 0x00400D, "LANNET DATA COMMUNICATIONS,LTD" },
        { 0x00400E, "MEMOTEC, INC." },
        { 0x00400F, "DATACOM TECHNOLOGIES" },
        { 0x004010, "SONIC SYSTEMS, INC." },
        { 0x004011, "ANDOVER CONTROLS CORPORATION" },
        { 0x004012, "WINDATA, INC." },
        { 0x004013, "NTT DATA COMM. SYSTEMS CORP." },
        { 0x004014, "COMSOFT GMBH" },
        { 0x004015, "ASCOM INFRASYS AG" },
        { 0x004016, "ADC - Global Connectivity Solutions Division" },
        { 0x004017, "Silex Technology America" },
        { 0x004018, "ADOBE SYSTEMS, INC." },
        { 0x004019, "AEON SYSTEMS, INC." },
        { 0x00401A, "FUJI ELECTRIC CO., LTD." },
        { 0x00401B, "PRINTER SYSTEMS CORP." },
        { 0x00401C, "AST RESEARCH, INC." },
        { 0x00401D, "INVISIBLE SOFTWARE, INC." },
        { 0x00401E, "ICC" },
        { 0x00401F, "COLORGRAPH LTD" },
        { 0x004020, "CommScope Inc" },
        { 0x004021, "RASTER GRAPHICS" },
        { 0x004022, "KLEVER COMPUTERS, INC." },
        { 0x004023, "LOGIC CORPORATION" },
        { 0x004024, "COMPAC INC." },
        { 0x004025, "MOLECULAR DYNAMICS" },
        { 0x004026, "BUFFALO.INC" },
        { 0x004027, "SMC MASSACHUSETTS, INC." },
        { 0x004028, "NETCOMM LIMITED" },
        { 0x004029, "Compex" },
        { 0x00402A, "Canoga Perkins Corporation" },
        { 0x00402B, "TRIGEM COMPUTER, INC." },
        { 0x00402C, "ISIS DISTRIBUTED SYSTEMS, INC." },
        { 0x00402D, "HARRIS ADACOM CORPORATION" },
        { 0x00402E, "PRECISION SOFTWARE, INC." },
        { 0x00402F, "XLNT DESIGNS INC." },
        { 0x004030, "GK COMPUTER" },
        { 0x004031, "KOKUSAI ELECTRIC CO., LTD" },
        { 0x004032, "DIGITAL COMMUNICATIONS" },
        { 0x004033, "ADDTRON TECHNOLOGY CO., LTD." },
        { 0x004034, "BUSTEK CORPORATION" },
        { 0x004035, "OPCOM" },
        { 0x004036, "Zoom Telephonics, Inc" },
        { 0x004037, "SEA-ILAN, INC." },
        { 0x004038, "TALENT ELECTRIC INCORPORATED" },
        { 0x004039, "OPTEC DAIICHI DENKO CO., LTD." },
        { 0x00403A, "IMPACT TECHNOLOGIES" },
        { 0x00403B, "SYNERJET INTERNATIONAL CORP." },
        { 0x00403C, "FORKS, INC." },
        { 0x00403D, "Teradata Corporation" },
        { 0x00403E, "RASTER OPS CORPORATION" },
        { 0x00403F, "SSANGYONG COMPUTER SYSTEMS" },
        { 0x004040, "RING ACCESS, INC." },
        { 0x004041, "FUJIKURA LTD." },
        { 0x004042, "N.A.T. GMBH" },
        { 0x004043, "Nokia Siemens Networks GmbH & Co. KG." },
        { 0x004044, "QNIX COMPUTER CO., LTD." },
        { 0x004045, "TWINHEAD CORPORATION" },
        { 0x004046, "UDC RESEARCH LIMITED" },
        { 0x004047, "WIND RIVER SYSTEMS" },
        { 0x004048, "SMD INFORMATICA S.A." },
        { 0x004049, "Roche Diagnostics International Ltd." },
        { 0x00404A, "WEST AUSTRALIAN DEPARTMENT" },
        { 0x00404B, "MAPLE COMPUTER SYSTEMS" },
        { 0x00404C, "HYPERTEC PTY LTD." },
        { 0x00404D, "TELECOMMUNICATIONS TECHNIQUES" },
        { 0x00404E, "FLUENT, INC." },
        { 0x00404F, "SPACE & NAVAL WARFARE SYSTEMS" },
        { 0x004050, "IRONICS, INCORPORATED" },
        { 0x004051, "Garbee and Garbee" },
        { 0x004052, "STAR TECHNOLOGIES, INC." },
        { 0x004053, "AMPRO COMPUTERS" },
        { 0x004054, "CONNECTION MACHINES SERVICES" },
        { 0x004055, "METRONIX GMBH" },
        { 0x004056, "MCM JAPAN LTD." },
        { 0x004057, "LOCKHEED - SANDERS" },
        { 0x004058, "KRONOS, INC." },
        { 0x004059, "YOSHIDA KOGYO K. K." },
        { 0x00405A, "GOLDSTAR INFORMATION & COMM." },
        { 0x00405B, "FUNASSET LIMITED" },
        { 0x00405C, "FUTURE SYSTEMS, INC." },
        { 0x00405D, "STAR-TEK, INC." },
        { 0x00405E, "NORTH HILLS ISRAEL" },
        { 0x00405F, "AFE COMPUTERS LTD." },
        { 0x004060, "COMENDEC LTD" },
        { 0x004061, "DATATECH ENTERPRISES CO., LTD." },
        { 0x004062, "E-SYSTEMS, INC./GARLAND DIV." },
        { 0x004063, "VIA TECHNOLOGIES, INC." },
        { 0x004064, "KLA INSTRUMENTS CORPORATION" },
        { 0x004065, "GTE SPACENET" },
        { 0x004066, "APRESIA Systems Ltd" },
        { 0x004067, "OMNIBYTE CORPORATION" },
        { 0x004068, "EXTENDED SYSTEMS" },
        { 0x004069, "LEMCOM SYSTEMS, INC." },
        { 0x00406A, "KENTEK INFORMATION SYSTEMS,INC" },
        { 0x00406B, "SYSGEN" },
        { 0x00406C, "COPERNIQUE" },
        { 0x00406D, "LANCO, INC." },
        { 0x00406E, "COROLLARY, INC." },
        { 0x00406F, "SYNC RESEARCH INC." },
        { 0x004070, "INTERWARE CO., LTD." },
        { 0x004071, "ATM COMPUTER GMBH" },
        { 0x004072, "Applied Innovation Inc." },
        { 0x004073, "BASS ASSOCIATES" },
        { 0x004074, "CABLE AND WIRELESS" },
        { 0x004075, "Tattile SRL" },
        { 0x004076, "Sun Conversion Technologies" },
        { 0x004077, "MAXTON TECHNOLOGY CORPORATION" },
        { 0x004078, "WEARNES AUTOMATION PTE LTD" },
        { 0x004079, "JUKO MANUFACTURE COMPANY, LTD." },
        { 0x00407A, "SOCIETE D'EXPLOITATION DU CNIT" },
        { 0x00407B, "SCIENTIFIC ATLANTA" },
        { 0x00407C, "QUME CORPORATION" },
        { 0x00407D, "EXTENSION TECHNOLOGY CORP." },
        { 0x00407E, "EVERGREEN SYSTEMS, INC." },
        { 0x00407F, "FLIR Systems" },
        { 0x004080, "ATHENIX CORPORATION" },
        { 0x004081, "MANNESMANN SCANGRAPHIC GMBH" },
        { 0x004082, "LABORATORY EQUIPMENT CORP." },
        { 0x004083, "TDA INDUSTRIA DE PRODUTOS" },
        { 0x004084, "Honeywell International HPS" },
        { 0x004085, "SAAB INSTRUMENTS AB" },
        { 0x004086, "MICHELS & KLEBERHOFF COMPUTER" },
        { 0x004087, "UBITREX CORPORATION" },
        { 0x004088, "MOBIUS TECHNOLOGIES, INC." },
        { 0x004089, "MEIDENSHA CORPORATION" },
        { 0x00408A, "TPS TELEPROCESSING SYS. GMBH" },
        { 0x00408B, "RAYLAN CORPORATION" },
        { 0x00408C, "AXIS COMMUNICATIONS AB" },
        { 0x00408D, "THE GOODYEAR TIRE & RUBBER CO." },
        { 0x00408E, "Tattile SRL" },
        { 0x00408F, "WM-DATA MINFO AB" },
        { 0x004090, "ANSEL COMMUNICATIONS" },
        { 0x004091, "PROCOMP INDUSTRIA ELETRONICA" },
        { 0x004092, "ASP COMPUTER PRODUCTS, INC." },
        { 0x004093, "PAXDATA NETWORKS LTD." },
        { 0x004094, "SHOGRAPHICS, INC." },
        { 0x004095, "R.P.T. INTERGROUPS INT'L LTD." },
        { 0x004096, "Cisco Systems, Inc" },
        { 0x004097, "DATEX DIVISION OF" },
        { 0x004098, "DRESSLER GMBH & CO." },
        { 0x004099, "NEWGEN SYSTEMS CORP." },
        { 0x00409A, "NETWORK EXPRESS, INC." },
        { 0x00409B, "HAL COMPUTER SYSTEMS INC." },
        { 0x00409C, "TRANSWARE" },
        { 0x00409D, "DigiBoard" },
        { 0x00409E, "CONCURRENT TECHNOLOGIES LTD." },
        { 0x00409F, "Telco Systems, Inc." },
        { 0x0040A0, "GOLDSTAR CO., LTD." },
        { 0x0040A1, "ERGO COMPUTING" },
        { 0x0040A2, "KINGSTAR TECHNOLOGY INC." },
        { 0x0040A3, "MICROUNITY SYSTEMS ENGINEERING" },
        { 0x0040A4, "ROSE ELECTRONICS" },
        { 0x0040A5, "CLINICOMP INTL." },
        { 0x0040A6, "Cray, Inc." },
        { 0x0040A7, "ITAUTEC PHILCO S.A." },
        { 0x0040A8, "IMF INTERNATIONAL LTD." },
        { 0x0040A9, "DATACOM INC." },
        { 0x0040AA, "Valmet Automation" },
        { 0x0040AB, "ROLAND DG CORPORATION" },
        { 0x0040AC, "SUPER WORKSTATION, INC." },
        { 0x0040AD, "SMA REGELSYSTEME GMBH" },
        { 0x0040AE, "DELTA CONTROLS, INC." },
        { 0x0040AF, "DIGITAL PRODUCTS, INC." },
        { 0x0040B0, "BYTEX CORPORATION, ENGINEERING" },
        { 0x0040B1, "CODONICS INC." },
        { 0x0040B2, "SYSTEMFORSCHUNG" },
        { 0x0040B3, "ParTech Inc." },
        { 0x0040B4, "NEXTCOM K.K." },
        { 0x0040B5, "VIDEO TECHNOLOGY COMPUTERS LTD" },
        { 0x0040B6, "COMPUTERM CORPORATION" },
        { 0x0040B7, "STEALTH COMPUTER SYSTEMS" },
        { 0x0040B8, "IDEA ASSOCIATES" },
        { 0x0040B9, "MACQ ELECTRONIQUE SA" },
        { 0x0040BA, "ALLIANT COMPUTER SYSTEMS CORP." },
        { 0x0040BB, "GOLDSTAR CABLE CO., LTD." },
        { 0x0040BC, "ALGORITHMICS LTD." },
        { 0x0040BD, "STARLIGHT NETWORKS, INC." },
        { 0x0040BE, "BOEING DEFENSE & SPACE" },
        { 0x0040BF, "CHANNEL SYSTEMS INTERN'L INC." },
        { 0x0040C0, "VISTA CONTROLS CORPORATION" },
        { 0x0040C1, "BIZERBA-WERKE WILHEIM KRAUT" },
        { 0x0040C2, "APPLIED COMPUTING DEVICES" },
        { 0x0040C3, "FISCHER AND PORTER CO." },
        { 0x0040C4, "KINKEI SYSTEM CORPORATION" },
        { 0x0040C5, "MICOM COMMUNICATIONS INC." },
        { 0x0040C6, "FIBERNET RESEARCH, INC." },
        { 0x0040C7, "RUBY TECH CORPORATION" },
        { 0x0040C8, "MILAN TECHNOLOGY CORPORATION" },
        { 0x0040C9, "NCUBE" },
        { 0x0040CA, "FIRST INTERNAT'L COMPUTER, INC" },
        { 0x0040CB, "LANWAN TECHNOLOGIES" },
        { 0x0040CC, "SILCOM MANUF'G TECHNOLOGY INC." },
        { 0x0040CD, "TERA MICROSYSTEMS, INC." },
        { 0x0040CE, "NET-SOURCE, INC." },
        { 0x0040CF, "STRAWBERRY TREE, INC." },
        { 0x0040D0, "MITAC INTERNATIONAL CORP." },
        { 0x0040D1, "FUKUDA DENSHI CO., LTD." },
        { 0x0040D2, "PAGINE CORPORATION" },
        { 0x0040D3, "KIMPSION INTERNATIONAL CORP." },
        { 0x0040D4, "GAGE TALKER CORP." },
        { 0x0040D5, "Sartorius Mechatronics T&H GmbH" },
        { 0x0040D6, "LOCAMATION B.V." },
        { 0x0040D7, "STUDIO GEN INC." },
        { 0x0040D8, "OCEAN OFFICE AUTOMATION LTD." },
        { 0x0040D9, "AMERICAN MEGATRENDS INC." },
        { 0x0040DA, "TELSPEC LTD" },
        { 0x0040DB, "ADVANCED TECHNICAL SOLUTIONS" },
        { 0x0040DC, "TRITEC ELECTRONIC GMBH" },
        { 0x0040DD, "HONG TECHNOLOGIES" },
        { 0x0040DE, "Elsag Datamat spa" },
        { 0x0040DF, "DIGALOG SYSTEMS, INC." },
        { 0x0040E0, "ATOMWIDE LTD." },
        { 0x0040E1, "MARNER INTERNATIONAL, INC." },
        { 0x0040E2, "MESA RIDGE TECHNOLOGIES, INC." },
        { 0x0040E3, "QUIN SYSTEMS LTD" },
        { 0x0040E4, "E-M TECHNOLOGY, INC." },
        { 0x0040E5, "SYBUS CORPORATION" },
        { 0x0040E6, "C.A.E.N." },
        { 0x0040E7, "ARNOS INSTRUMENTS & COMPUTER" },
        { 0x0040E8, "CHARLES RIVER DATA SYSTEMS,INC" },
        { 0x0040E9, "ACCORD SYSTEMS, INC." },
        { 0x0040EA, "PLAIN TREE SYSTEMS INC" },
        { 0x0040EB, "MARTIN MARIETTA CORPORATION" },
        { 0x0040EC, "MIKASA SYSTEM ENGINEERING" },
        { 0x0040ED, "NETWORK CONTROLS INT'NATL INC." },
        { 0x0040EE, "OPTIMEM" },
        { 0x0040EF, "HYPERCOM, INC." },
        { 0x0040F0, "MicroBrain,Inc." },
        { 0x0040F1, "CHUO ELECTRONICS CO., LTD." },
        { 0x0040F2, "JANICH & KLASS COMPUTERTECHNIK" },
        { 0x0040F3, "NETCOR" },
        { 0x0040F4, "CAMEO COMMUNICATIONS, INC." },
        { 0x0040F5, "OEM ENGINES" },
        { 0x0040F6, "KATRON COMPUTERS INC." },
        { 0x0040F7, "Polaroid Corporation" },
        { 0x0040F8, "SYSTEMHAUS DISCOM" },
        { 0x0040F9, "COMBINET" },
        { 0x0040FA, "MICROBOARDS, INC." },
        { 0x0040FB, "CASCADE COMMUNICATIONS" },
        { 0x0040FC, "IBR COMPUTER TECHNIK GMBH" },
        { 0x0040FD, "LXE" },
        { 0x0040FE, "SYMPLEX COMMUNICATIONS" },
        { 0x0040FF, "TELEBIT CORPORATION" },
        { 0x0041B4, "Wuxi Zhongxing Optoelectronics Technology Co.,Ltd." },
        { 0x0041D2, "Cisco Systems, Inc" },
        { 0x004238, "Intel Corporate" },
        { 0x004252, "RLX Technologies" },
        { 0x00425A, "Cisco Systems, Inc" },
        { 0x004268, "Cisco Systems, Inc" },
        { 0x004279, "Sunitec Enterprise Co.,Ltd" },
        { 0x0043FF, "KETRON S.R.L." },
        { 0x004501, "Midmark RTLS" },
        { 0x00451D, "Cisco Systems, Inc" },
        { 0x0045E2, "CyberTAN Technology Inc." },
        { 0x00464B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x004A77, "zte corporation" },
        { 0x004BF3, "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x004D32, "Andon Health Co.,Ltd." },
        { 0x004E01, "Dell Inc." },
        { 0x004E35, "Hewlett Packard Enterprise" },
        { 0x005000, "NEXO COMMUNICATIONS, INC." },
        { 0x005001, "YAMASHITA SYSTEMS CORP." },
        { 0x005002, "OMNISEC AG" },
        { 0x005003, "Xrite Inc" },
        { 0x005004, "3COM" },
        { 0x005006, "TAC AB" },
        { 0x005007, "SIEMENS TELECOMMUNICATION SYSTEMS LIMITED" },
        { 0x005008, "TIVA MICROCOMPUTER CORP. (TMC)" },
        { 0x005009, "PHILIPS BROADBAND NETWORKS" },
        { 0x00500A, "IRIS TECHNOLOGIES, INC." },
        { 0x00500B, "Cisco Systems, Inc" },
        { 0x00500C, "e-Tek Labs, Inc." },
        { 0x00500D, "SATORI ELECTORIC CO., LTD." },
        { 0x00500E, "CHROMATIS NETWORKS, INC." },
        { 0x00500F, "Cisco Systems, Inc" },
        { 0x005010, "NovaNET Learning, Inc." },
        { 0x005012, "CBL - GMBH" },
        { 0x005013, "Seagate Cloud Systems Inc" },
        { 0x005014, "Cisco Systems, Inc" },
        { 0x005015, "BRIGHT STAR ENGINEERING" },
        { 0x005016, "Molex Canada Ltd" },
        { 0x005017, "RSR S.R.L." },
        { 0x005018, "AMIT, Inc." },
        { 0x005019, "SPRING TIDE NETWORKS, INC." },
        { 0x00501A, "IQinVision" },
        { 0x00501B, "ABL CANADA, INC." },
        { 0x00501C, "JATOM SYSTEMS, INC." },
        { 0x00501E, "Grass Valley, A Belden Brand" },
        { 0x00501F, "MRG SYSTEMS, LTD." },
        { 0x005020, "MEDIASTAR CO., LTD." },
        { 0x005021, "EIS INTERNATIONAL, INC." },
        { 0x005022, "ZONET TECHNOLOGY, INC." },
        { 0x005023, "PG DESIGN ELECTRONICS, INC." },
        { 0x005024, "NAVIC SYSTEMS, INC." },
        { 0x005026, "COSYSTEMS, INC." },
        { 0x005027, "GENICOM CORPORATION" },
        { 0x005028, "AVAL COMMUNICATIONS" },
        { 0x005029, "1394 PRINTER WORKING GROUP" },
        { 0x00502A, "Cisco Systems, Inc" },
        { 0x00502B, "GENRAD LTD." },
        { 0x00502C, "SOYO COMPUTER, INC." },
        { 0x00502D, "ACCEL, INC." },
        { 0x00502E, "CAMBEX CORPORATION" },
        { 0x00502F, "TollBridge Technologies, Inc." },
        { 0x005030, "FUTURE PLUS SYSTEMS" },
        { 0x005031, "AEROFLEX LABORATORIES, INC." },
        { 0x005032, "PICAZO COMMUNICATIONS, INC." },
        { 0x005033, "MAYAN NETWORKS" },
        { 0x005036, "NETCAM, LTD." },
        { 0x005037, "KOGA ELECTRONICS CO." },
        { 0x005038, "DAIN TELECOM CO., LTD." },
        { 0x005039, "MARINER NETWORKS" },
        { 0x00503A, "DATONG ELECTRONICS LTD." },
        { 0x00503B, "MEDIAFIRE CORPORATION" },
        { 0x00503C, "TSINGHUA NOVEL ELECTRONICS" },
        { 0x00503E, "Cisco Systems, Inc" },
        { 0x00503F, "ANCHOR GAMES" },
        { 0x005040, "Panasonic Electric Works Co., Ltd." },
        { 0x005041, "Coretronic Corporation" },
        { 0x005042, "SCI MANUFACTURING SINGAPORE PTE, LTD." },
        { 0x005043, "MARVELL SEMICONDUCTOR, INC." },
        { 0x005044, "ASACA CORPORATION" },
        { 0x005045, "RIOWORKS SOLUTIONS, INC." },
        { 0x005046, "MENICX INTERNATIONAL CO., LTD." },
        { 0x005047, "Private" },
        { 0x005048, "INFOLIBRIA" },
        { 0x005049, "Arbor Networks Inc" },
        { 0x00504A, "ELTECO A.S." },
        { 0x00504B, "BARCONET N.V." },
        { 0x00504C, "Galil Motion Control" },
        { 0x00504D, "Tokyo Electron Device Limited" },
        { 0x00504E, "SIERRA MONITOR CORP." },
        { 0x00504F, "OLENCOM ELECTRONICS" },
        { 0x005050, "Cisco Systems, Inc" },
        { 0x005051, "IWATSU ELECTRIC CO., LTD." },
        { 0x005052, "TIARA NETWORKS, INC." },
        { 0x005053, "Cisco Systems, Inc" },
        { 0x005054, "Cisco Systems, Inc" },
        { 0x005055, "DOMS A/S" },
        { 0x005056, "VMware, Inc." },
        { 0x005057, "BROADBAND ACCESS SYSTEMS" },
        { 0x005058, "Sangoma Technologies" },
        { 0x005059, "iBAHN" },
        { 0x00505A, "NETWORK ALCHEMY, INC." },
        { 0x00505B, "KAWASAKI LSI U.S.A., INC." },
        { 0x00505C, "TUNDO CORPORATION" },
        { 0x00505E, "DIGITEK MICROLOGIC S.A." },
        { 0x00505F, "BRAND INNOVATORS" },
        { 0x005060, "TANDBERG TELECOM AS" },
        { 0x005062, "KOUWELL ELECTRONICS CORP. **" },
        { 0x005063, "OY COMSEL SYSTEM AB" },
        { 0x005064, "CAE ELECTRONICS" },
        { 0x005065, "TDK-Lambda Corporation" },
        { 0x005066, "AtecoM GmbH advanced telecomunication modules" },
        { 0x005067, "AEROCOMM, INC." },
        { 0x005068, "ELECTRONIC INDUSTRIES ASSOCIATION" },
        { 0x005069, "PixStream Incorporated" },
        { 0x00506A, "EDEVA, INC." },
        { 0x00506B, "SPX-ATEG" },
        { 0x00506C, "Beijer Electronics Products AB" },
        { 0x00506D, "VIDEOJET SYSTEMS" },
        { 0x00506E, "CORDER ENGINEERING CORPORATION" },
        { 0x00506F, "G-CONNECT" },
        { 0x005070, "CHAINTECH COMPUTER CO., LTD." },
        { 0x005071, "AIWA CO., LTD." },
        { 0x005072, "CORVIS CORPORATION" },
        { 0x005073, "Cisco Systems, Inc" },
        { 0x005074, "ADVANCED HI-TECH CORP." },
        { 0x005075, "KESTREL SOLUTIONS" },
        { 0x005076, "IBM Corp" },
        { 0x005077, "PROLIFIC TECHNOLOGY, INC." },
        { 0x005078, "MEGATON HOUSE, LTD." },
        { 0x005079, "Private" },
        { 0x00507A, "XPEED, INC." },
        { 0x00507B, "MERLOT COMMUNICATIONS" },
        { 0x00507C, "VIDEOCON AG" },
        { 0x00507D, "IFP" },
        { 0x00507E, "NEWER TECHNOLOGY" },
        { 0x00507F, "DrayTek Corp." },
        { 0x005080, "Cisco Systems, Inc" },
        { 0x005081, "MURATA MACHINERY, LTD." },
        { 0x005082, "FORESSON CORPORATION" },
        { 0x005083, "GILBARCO, INC." },
        { 0x005084, "Quantum Corp." },
        { 0x005086, "TELKOM SA, LTD." },
        { 0x005087, "TERASAKI ELECTRIC CO., LTD." },
        { 0x005088, "AMANO CORPORATION" },
        { 0x005089, "SAFETY MANAGEMENT SYSTEMS" },
        { 0x00508B, "Hewlett Packard" },
        { 0x00508C, "RSI SYSTEMS" },
        { 0x00508D, "ABIT COMPUTER CORPORATION" },
        { 0x00508E, "OPTIMATION, INC." },
        { 0x00508F, "ASITA TECHNOLOGIES INT'L LTD." },
        { 0x005090, "DCTRI" },
        { 0x005091, "NETACCESS, INC." },
        { 0x005092, "Rigaku Corporation Osaka Plant" },
        { 0x005093, "BOEING" },
        { 0x005094, "ARRIS Group, Inc." },
        { 0x005095, "PERACOM NETWORKS" },
        { 0x005096, "SALIX TECHNOLOGIES, INC." },
        { 0x005097, "MMC-EMBEDDED COMPUTERTECHNIK GmbH" },
        { 0x005098, "GLOBALOOP, LTD." },
        { 0x005099, "3COM EUROPE LTD" },
        { 0x00509A, "TAG ELECTRONIC SYSTEMS" },
        { 0x00509B, "SWITCHCORE AB" },
        { 0x00509C, "BETA RESEARCH" },
        { 0x00509D, "THE INDUSTREE B.V." },
        { 0x00509E, "Les Technologies SoftAcoustik Inc." },
        { 0x00509F, "HORIZON COMPUTER" },
        { 0x0050A0, "DELTA COMPUTER SYSTEMS, INC." },
        { 0x0050A1, "CARLO GAVAZZI, INC." },
        { 0x0050A2, "Cisco Systems, Inc" },
        { 0x0050A3, "TransMedia Communications, Inc." },
        { 0x0050A4, "IO TECH, INC." },
        { 0x0050A5, "CAPITOL BUSINESS SYSTEMS, LTD." },
        { 0x0050A6, "OPTRONICS" },
        { 0x0050A7, "Cisco Systems, Inc" },
        { 0x0050A8, "OpenCon Systems, Inc." },
        { 0x0050A9, "MOLDAT WIRELESS TECHNOLGIES" },
        { 0x0050AA, "KONICA MINOLTA HOLDINGS, INC." },
        { 0x0050AB, "NALTEC, Inc." },
        { 0x0050AC, "MAPLE COMPUTER CORPORATION" },
        { 0x0050AD, "CommUnique Wireless Corp." },
        { 0x0050AE, "FDK Co., Ltd" },
        { 0x0050AF, "INTERGON, INC." },
        { 0x0050B0, "TECHNOLOGY ATLANTA CORPORATION" },
        { 0x0050B1, "GIDDINGS & LEWIS" },
        { 0x0050B2, "BRODEL GmbH" },
        { 0x0050B3, "VOICEBOARD CORPORATION" },
        { 0x0050B4, "SATCHWELL CONTROL SYSTEMS, LTD" },
        { 0x0050B5, "FICHET SECURITE ELECTRONIQUE" },
        { 0x0050B6, "GOOD WAY IND. CO., LTD." },
        { 0x0050B7, "BOSER TECHNOLOGY CO., LTD." },
        { 0x0050B8, "INOVA COMPUTERS GMBH & CO. KG" },
        { 0x0050B9, "XITRON TECHNOLOGIES, INC." },
        { 0x0050BA, "D-Link Corporation" },
        { 0x0050BB, "CMS TECHNOLOGIES" },
        { 0x0050BC, "HAMMER STORAGE SOLUTIONS" },
        { 0x0050BD, "Cisco Systems, Inc" },
        { 0x0050BE, "FAST MULTIMEDIA AG" },
        { 0x0050BF, "Metalligence Technology Corp." },
        { 0x0050C0, "GATAN, INC." },
        { 0x0050C1, "GEMFLEX NETWORKS, LTD." },
        { 0x0050C2, "IEEE Registration Authority" },
        { 0x0050C4, "IMD" },
        { 0x0050C5, "ADS Technologies, Inc" },
        { 0x0050C6, "LOOP TELECOMMUNICATION INTERNATIONAL, INC." },
        { 0x0050C7, "Private" },
        { 0x0050C8, "Addonics Technologies, Inc." },
        { 0x0050C9, "MASPRO DENKOH CORP." },
        { 0x0050CA, "NET TO NET TECHNOLOGIES" },
        { 0x0050CB, "JETTER" },
        { 0x0050CC, "Seagate Cloud Systems Inc" },
        { 0x0050CD, "DIGIANSWER A/S" },
        { 0x0050CE, "LG INTERNATIONAL CORP." },
        { 0x0050CF, "VANLINK COMMUNICATION TECHNOLOGY RESEARCH INSTITUTE" },
        { 0x0050D0, "MINERVA SYSTEMS" },
        { 0x0050D1, "Cisco Systems, Inc" },
        { 0x0050D2, "CMC Electronics Inc" },
        { 0x0050D3, "DIGITAL AUDIO PROCESSING PTY. LTD." },
        { 0x0050D4, "JOOHONG INFORMATION &" },
        { 0x0050D5, "AD SYSTEMS CORP." },
        { 0x0050D6, "ATLAS COPCO TOOLS AB" },
        { 0x0050D7, "TELSTRAT" },
        { 0x0050D8, "UNICORN COMPUTER CORP." },
        { 0x0050D9, "ENGETRON-ENGENHARIA ELETRONICA IND. e COM. LTDA" },
        { 0x0050DA, "3COM" },
        { 0x0050DB, "CONTEMPORARY CONTROL" },
        { 0x0050DC, "TAS TELEFONBAU A. SCHWABE GMBH & CO. KG" },
        { 0x0050DD, "SERRA SOLDADURA, S.A." },
        { 0x0050DE, "SIGNUM SYSTEMS CORP." },
        { 0x0050DF, "AirFiber, Inc." },
        { 0x0050E1, "NS TECH ELECTRONICS SDN BHD" },
        { 0x0050E2, "Cisco Systems, Inc" },
        { 0x0050E3, "ARRIS Group, Inc." },
        { 0x0050E4, "Apple, Inc." },
        { 0x0050E6, "HAKUSAN CORPORATION" },
        { 0x0050E7, "PARADISE INNOVATIONS (ASIA)" },
        { 0x0050E8, "NOMADIX INC." },
        { 0x0050EA, "XEL COMMUNICATIONS, INC." },
        { 0x0050EB, "ALPHA-TOP CORPORATION" },
        { 0x0050EC, "OLICOM A/S" },
        { 0x0050ED, "ANDA NETWORKS" },
        { 0x0050EE, "TEK DIGITEL CORPORATION" },
        { 0x0050EF, "SPE Systemhaus GmbH" },
        { 0x0050F0, "Cisco Systems, Inc" },
        { 0x0050F1, "Maxlinear, Inc" },
        { 0x0050F2, "MICROSOFT CORP." },
        { 0x0050F3, "GLOBAL NET INFORMATION CO., Ltd." },
        { 0x0050F4, "SIGMATEK GMBH & CO. KG" },
        { 0x0050F6, "PAN-INTERNATIONAL INDUSTRIAL CORP." },
        { 0x0050F7, "VENTURE MANUFACTURING (SINGAPORE) LTD." },
        { 0x0050F8, "ENTREGA TECHNOLOGIES, INC." },
        { 0x0050F9, "Sensormatic Electronics LLC" },
        { 0x0050FA, "OXTEL, LTD." },
        { 0x0050FB, "VSK ELECTRONICS" },
        { 0x0050FC, "Edimax Technology Co. Ltd." },
        { 0x0050FD, "VISIONCOMM CO., LTD." },
        { 0x0050FE, "PCTVnet ASA" },
        { 0x0050FF, "HAKKO ELECTRONICS CO., LTD." },
        { 0x0051ED, "LG Innotek" },
        { 0x005218, "Wuxi Keboda Electron Co.Ltd" },
        { 0x0052C2, "peiker acustic GmbH" },
        { 0x00549F, "Avaya Inc" },
        { 0x0054AF, "Continental Automotive Systems Inc." },
        { 0x0054BD, "Swelaser AB" },
        { 0x0055B1, "Shanghai Baud Data Communication Co.,Ltd." },
        { 0x0055DA, "IEEE Registration Authority" },
        { 0x00562B, "Cisco Systems, Inc" },
        { 0x0056CD, "Apple, Inc." },
        { 0x0057C1, "LG Electronics (Mobile Communications)" },
        { 0x0057D2, "Cisco Systems, Inc" },
        { 0x00583F, "PC Aquarius" },
        { 0x005907, "LenovoEMC Products USA, LLC" },
        { 0x005979, "Networked Energy Services" },
        { 0x0059AC, "KPN. B.V." },
        { 0x0059DC, "Cisco Systems, Inc" },
        { 0x005A13, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x005A39, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x005B94, "Apple, Inc." },
        { 0x005BA1, "shanghai huayuan chuangxin software CO., LTD." },
        { 0x005C86, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x005CB1, "Gospell DIGITAL TECHNOLOGY CO., LTD" },
        { 0x005D03, "Xilinx, Inc" },
        { 0x005D73, "Cisco Systems, Inc" },
        { 0x005E0C, "HMD Global Oy" },
        { 0x005F86, "Cisco Systems, Inc" },
        { 0x006000, "XYCOM INC." },
        { 0x006001, "InnoSys, Inc." },
        { 0x006002, "SCREEN SUBTITLING SYSTEMS, LTD" },
        { 0x006003, "TERAOKA WEIGH SYSTEM PTE, LTD." },
        { 0x006004, "COMPUTADORES MODULARES SA" },
        { 0x006005, "FEEDBACK DATA LTD." },
        { 0x006006, "SOTEC CO., LTD" },
        { 0x006007, "ACRES GAMING, INC." },
        { 0x006008, "3COM" },
        { 0x006009, "Cisco Systems, Inc" },
        { 0x00600A, "SORD COMPUTER CORPORATION" },
        { 0x00600B, "LOGWARE GmbH" },
        { 0x00600C, "Eurotech Inc." },
        { 0x00600D, "Digital Logic GmbH" },
        { 0x00600E, "WAVENET INTERNATIONAL, INC." },
        { 0x00600F, "Westell Technologies Inc." },
        { 0x006010, "NETWORK MACHINES, INC." },
        { 0x006011, "CRYSTAL SEMICONDUCTOR CORP." },
        { 0x006012, "POWER COMPUTING CORPORATION" },
        { 0x006013, "NETSTAL MASCHINEN AG" },
        { 0x006014, "EDEC CO., LTD." },
        { 0x006015, "NET2NET CORPORATION" },
        { 0x006016, "CLARIION" },
        { 0x006017, "TOKIMEC INC." },
        { 0x006018, "STELLAR ONE CORPORATION" },
        { 0x006019, "Roche Diagnostics" },
        { 0x00601A, "KEITHLEY INSTRUMENTS" },
        { 0x00601B, "MESA ELECTRONICS" },
        { 0x00601C, "TELXON CORPORATION" },
        { 0x00601D, "LUCENT TECHNOLOGIES" },
        { 0x00601E, "SOFTLAB, INC." },
        { 0x00601F, "STALLION TECHNOLOGIES" },
        { 0x006020, "PIVOTAL NETWORKING, INC." },
        { 0x006021, "DSC CORPORATION" },
        { 0x006022, "VICOM SYSTEMS, INC." },
        { 0x006023, "PERICOM SEMICONDUCTOR CORP." },
        { 0x006024, "GRADIENT TECHNOLOGIES, INC." },
        { 0x006025, "ACTIVE IMAGING PLC" },
        { 0x006026, "VIKING Modular Solutions" },
        { 0x006027, "Superior Modular Products" },
        { 0x006028, "MACROVISION CORPORATION" },
        { 0x006029, "CARY PERIPHERALS INC." },
        { 0x00602A, "SYMICRON COMPUTER COMMUNICATIONS, LTD." },
        { 0x00602B, "PEAK AUDIO" },
        { 0x00602C, "LINX Data Terminals, Inc." },
        { 0x00602D, "ALERTON TECHNOLOGIES, INC." },
        { 0x00602E, "CYCLADES CORPORATION" },
        { 0x00602F, "Cisco Systems, Inc" },
        { 0x006030, "VILLAGE TRONIC ENTWICKLUNG" },
        { 0x006031, "HRK SYSTEMS" },
        { 0x006032, "I-CUBE, INC." },
        { 0x006033, "ACUITY IMAGING, INC." },
        { 0x006034, "ROBERT BOSCH GmbH" },
        { 0x006035, "DALLAS SEMICONDUCTOR, INC." },
        { 0x006036, "AIT Austrian Institute of Technology GmbH" },
        { 0x006037, "NXP Semiconductors" },
        { 0x006038, "Nortel Networks" },
        { 0x006039, "SanCom Technology, Inc." },
        { 0x00603A, "QUICK CONTROLS LTD." },
        { 0x00603B, "AMTEC spa" },
        { 0x00603C, "HAGIWARA SYS-COM CO., LTD." },
        { 0x00603D, "3CX" },
        { 0x00603E, "Cisco Systems, Inc" },
        { 0x00603F, "PATAPSCO DESIGNS" },
        { 0x006040, "NETRO CORP." },
        { 0x006041, "Yokogawa Digital Computer Corporation" },
        { 0x006042, "TKS (USA), INC." },
        { 0x006043, "iDirect, INC." },
        { 0x006044, "LITTON/POLY-SCIENTIFIC" },
        { 0x006045, "PATHLIGHT TECHNOLOGIES" },
        { 0x006046, "VMETRO, INC." },
        { 0x006047, "Cisco Systems, Inc" },
        { 0x006048, "Dell EMC" },
        { 0x006049, "VINA TECHNOLOGIES" },
        { 0x00604A, "SAIC IDEAS GROUP" },
        { 0x00604B, "Safe-com GmbH & Co. KG" },
        { 0x00604C, "Sagemcom Broadband SAS" },
        { 0x00604D, "MMC NETWORKS, INC." },
        { 0x00604E, "CYCLE COMPUTER CORPORATION, INC." },
        { 0x00604F, "Tattile SRL" },
        { 0x006050, "INTERNIX INC." },
        { 0x006051, "QUALITY SEMICONDUCTOR" },
        { 0x006052, "PERIPHERALS ENTERPRISE CO., Ltd." },
        { 0x006053, "TOYODA MACHINE WORKS, LTD." },
        { 0x006054, "CONTROLWARE GMBH" },
        { 0x006055, "CORNELL UNIVERSITY" },
        { 0x006056, "NETWORK TOOLS, INC." },
        { 0x006057, "Murata Manufacturing Co., Ltd." },
        { 0x006058, "COPPER MOUNTAIN COMMUNICATIONS, INC." },
        { 0x006059, "TECHNICAL COMMUNICATIONS CORP." },
        { 0x00605A, "CELCORE, INC." },
        { 0x00605B, "IntraServer Technology, Inc." },
        { 0x00605C, "Cisco Systems, Inc" },
        { 0x00605D, "SCANIVALVE CORP." },
        { 0x00605E, "LIBERTY TECHNOLOGY NETWORKING" },
        { 0x00605F, "NIPPON UNISOFT CORPORATION" },
        { 0x006060, "Data Innovations North America" },
        { 0x006061, "WHISTLE COMMUNICATIONS CORP." },
        { 0x006062, "TELESYNC, INC." },
        { 0x006063, "PSION DACOM PLC." },
        { 0x006064, "NETCOMM LIMITED" },
        { 0x006065, "B&R Industrial Automation GmbH" },
        { 0x006066, "LACROIX Trafic" },
        { 0x006067, "ACER NETXUS INC." },
        { 0x006068, "Dialogic Corporation" },
        { 0x006069, "Brocade Communications Systems LLC" },
        { 0x00606A, "MITSUBISHI WIRELESS COMMUNICATIONS. INC." },
        { 0x00606B, "Synclayer Inc." },
        { 0x00606C, "ARESCOM" },
        { 0x00606D, "DIGITAL EQUIPMENT CORP." },
        { 0x00606E, "DAVICOM SEMICONDUCTOR, INC." },
        { 0x00606F, "CLARION CORPORATION OF AMERICA" },
        { 0x006070, "Cisco Systems, Inc" },
        { 0x006071, "MIDAS LAB, INC." },
        { 0x006072, "VXL INSTRUMENTS, LIMITED" },
        { 0x006073, "REDCREEK COMMUNICATIONS, INC." },
        { 0x006074, "QSC LLC" },
        { 0x006075, "PENTEK, INC." },
        { 0x006076, "SCHLUMBERGER TECHNOLOGIES RETAIL PETROLEUM SYSTEMS" },
        { 0x006077, "PRISA NETWORKS" },
        { 0x006078, "POWER MEASUREMENT LTD." },
        { 0x006079, "Mainstream Data, Inc." },
        { 0x00607A, "DVS GMBH" },
        { 0x00607B, "FORE SYSTEMS, INC." },
        { 0x00607C, "WaveAccess, Ltd." },
        { 0x00607D, "SENTIENT NETWORKS INC." },
        { 0x00607E, "GIGALABS, INC." },
        { 0x00607F, "AURORA TECHNOLOGIES, INC." },
        { 0x006080, "MICROTRONIX DATACOM LTD." },
        { 0x006081, "TV/COM INTERNATIONAL" },
        { 0x006082, "NOVALINK TECHNOLOGIES, INC." },
        { 0x006083, "Cisco Systems, Inc" },
        { 0x006084, "DIGITAL VIDEO" },
        { 0x006085, "Storage Concepts" },
        { 0x006086, "LOGIC REPLACEMENT TECH. LTD." },
        { 0x006087, "KANSAI ELECTRIC CO., LTD." },
        { 0x006088, "Analog Devices, Inc." },
        { 0x006089, "XATA" },
        { 0x00608A, "CITADEL COMPUTER" },
        { 0x00608B, "ConferTech International" },
        { 0x00608C, "3COM" },
        { 0x00608D, "UNIPULSE CORP." },
        { 0x00608E, "HE ELECTRONICS, TECHNOLOGIE & SYSTEMTECHNIK GmbH" },
        { 0x00608F, "TEKRAM TECHNOLOGY CO., LTD." },
        { 0x006090, "Artiza Networks Inc" },
        { 0x006091, "FIRST PACIFIC NETWORKS, INC." },
        { 0x006092, "MICRO/SYS, INC." },
        { 0x006093, "VARIAN" },
        { 0x006094, "IBM Corp" },
        { 0x006095, "ACCU-TIME SYSTEMS, INC." },
        { 0x006096, "T.S. MICROTECH INC." },
        { 0x006097, "3COM" },
        { 0x006098, "HT COMMUNICATIONS" },
        { 0x006099, "SBE, Inc." },
        { 0x00609A, "NJK TECHNO CO." },
        { 0x00609B, "AstroNova, Inc" },
        { 0x00609C, "Perkin-Elmer Incorporated" },
        { 0x00609D, "PMI FOOD EQUIPMENT GROUP" },
        { 0x00609E, "ASC X3 - INFORMATION TECHNOLOGY STANDARDS SECRETARIATS" },
        { 0x00609F, "PHAST CORPORATION" },
        { 0x0060A0, "SWITCHED NETWORK TECHNOLOGIES, INC." },
        { 0x0060A1, "VPNet, Inc." },
        { 0x0060A2, "NIHON UNISYS LIMITED CO." },
        { 0x0060A3, "CONTINUUM TECHNOLOGY CORP." },
        { 0x0060A4, "GEW Technologies (PTY)Ltd" },
        { 0x0060A5, "PERFORMANCE TELECOM CORP." },
        { 0x0060A6, "PARTICLE MEASURING SYSTEMS" },
        { 0x0060A7, "MICROSENS GmbH & CO. KG" },
        { 0x0060A8, "TIDOMAT AB" },
        { 0x0060A9, "GESYTEC MBH" },
        { 0x0060AA, "INTELLIGENT DEVICES INC. (IDI)" },
        { 0x0060AB, "LARSCOM INCORPORATED" },
        { 0x0060AC, "RESILIENCE CORPORATION" },
        { 0x0060AD, "MegaChips Corporation" },
        { 0x0060AE, "TRIO INFORMATION SYSTEMS AB" },
        { 0x0060AF, "PACIFIC MICRO DATA, INC." },
        { 0x0060B0, "Hewlett Packard" },
        { 0x0060B1, "Input/Output, Inc." },
        { 0x0060B2, "PROCESS CONTROL CORP." },
        { 0x0060B3, "Z-COM, INC." },
        { 0x0060B4, "GLENAYRE R&D INC." },
        { 0x0060B5, "KEBA GmbH" },
        { 0x0060B6, "LAND COMPUTER CO., LTD." },
        { 0x0060B7, "CHANNELMATIC, INC." },
        { 0x0060B8, "CORELIS Inc." },
        { 0x0060B9, "NEC Platforms, Ltd" },
        { 0x0060BA, "SAHARA NETWORKS, INC." },
        { 0x0060BB, "Cabletron Systems, Inc." },
        { 0x0060BC, "KeunYoung Electronics & Communication Co., Ltd." },
        { 0x0060BD, "Enginuity Communications" },
        { 0x0060BE, "WEBTRONICS" },
        { 0x0060BF, "MACRAIGOR SYSTEMS, INC." },
        { 0x0060C0, "Nera Networks AS" },
        { 0x0060C1, "WaveSpan Corporation" },
        { 0x0060C2, "MPL AG" },
        { 0x0060C3, "NETVISION CORPORATION" },
        { 0x0060C4, "SOLITON SYSTEMS K.K." },
        { 0x0060C5, "ANCOT CORP." },
        { 0x0060C6, "DCS AG" },
        { 0x0060C7, "AMATI COMMUNICATIONS CORP." },
        { 0x0060C8, "KUKA WELDING SYSTEMS & ROBOTS" },
        { 0x0060C9, "ControlNet, Inc." },
        { 0x0060CA, "HARMONIC SYSTEMS INCORPORATED" },
        { 0x0060CB, "HITACHI ZOSEN CORPORATION" },
        { 0x0060CC, "EMTRAK, INCORPORATED" },
        { 0x0060CD, "VideoServer, Inc." },
        { 0x0060CE, "ACCLAIM COMMUNICATIONS" },
        { 0x0060CF, "ALTEON NETWORKS, INC." },
        { 0x0060D0, "SNMP RESEARCH INCORPORATED" },
        { 0x0060D1, "CASCADE COMMUNICATIONS" },
        { 0x0060D2, "LUCENT TECHNOLOGIES TAIWAN TELECOMMUNICATIONS CO., LTD." },
        { 0x0060D3, "AT&T" },
        { 0x0060D4, "ELDAT COMMUNICATION LTD." },
        { 0x0060D5, "AMADA MIYACHI Co., Ltd" },
        { 0x0060D6, "NovAtel Inc." },
        { 0x0060D7, "ECOLE POLYTECHNIQUE FEDERALE DE LAUSANNE (EPFL)" },
        { 0x0060D8, "ELMIC SYSTEMS, INC." },
        { 0x0060D9, "TRANSYS NETWORKS INC." },
        { 0x0060DA, "Red Lion Controls, LP" },
        { 0x0060DB, "NTP ELEKTRONIK A/S" },
        { 0x0060DC, "NEC Magnus Communications,Ltd." },
        { 0x0060DD, "MYRICOM, INC." },
        { 0x0060DE, "Kayser-Threde GmbH" },
        { 0x0060DF, "Brocade Communications Systems LLC" },
        { 0x0060E0, "AXIOM TECHNOLOGY CO., LTD." },
        { 0x0060E1, "ORCKIT COMMUNICATIONS LTD." },
        { 0x0060E2, "QUEST ENGINEERING & DEVELOPMENT" },
        { 0x0060E3, "ARBIN INSTRUMENTS" },
        { 0x0060E4, "COMPUSERVE, INC." },
        { 0x0060E5, "FUJI AUTOMATION CO., LTD." },
        { 0x0060E6, "SHOMITI SYSTEMS INCORPORATED" },
        { 0x0060E7, "RANDATA" },
        { 0x0060E8, "HITACHI COMPUTER PRODUCTS (AMERICA), INC." },
        { 0x0060E9, "ATOP TECHNOLOGIES, INC." },
        { 0x0060EA, "StreamLogic" },
        { 0x0060EB, "FOURTHTRACK SYSTEMS" },
        { 0x0060EC, "HERMARY OPTO ELECTRONICS INC." },
        { 0x0060ED, "RICARDO TEST AUTOMATION LTD." },
        { 0x0060EE, "APOLLO" },
        { 0x0060EF, "FLYTECH TECHNOLOGY CO., LTD." },
        { 0x0060F0, "JOHNSON & JOHNSON MEDICAL, INC" },
        { 0x0060F1, "EXP COMPUTER, INC." },
        { 0x0060F2, "LASERGRAPHICS, INC." },
        { 0x0060F3, "Performance Analysis Broadband, Spirent plc" },
        { 0x0060F4, "ADVANCED COMPUTER SOLUTIONS, Inc." },
        { 0x0060F5, "ICON WEST, INC." },
        { 0x0060F6, "NEXTEST COMMUNICATIONS PRODUCTS, INC." },
        { 0x0060F7, "DATAFUSION SYSTEMS" },
        { 0x0060F8, "Loran International Technologies Inc." },
        { 0x0060F9, "DIAMOND LANE COMMUNICATIONS" },
        { 0x0060FA, "EDUCATIONAL TECHNOLOGY RESOURCES, INC." },
        { 0x0060FB, "PACKETEER, INC." },
        { 0x0060FC, "CONSERVATION THROUGH INNOVATION LTD." },
        { 0x0060FD, "NetICs, Inc." },
        { 0x0060FE, "LYNX SYSTEM DEVELOPERS, INC." },
        { 0x0060FF, "QuVis, Inc." },
        { 0x006151, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x006171, "Apple, Inc." },
        { 0x0062EC, "Cisco Systems, Inc" },
        { 0x0063DE, "CLOUDWALK TECHNOLOGY CO.,LTD" },
        { 0x006440, "Cisco Systems, Inc" },
        { 0x0064A6, "Maquet CardioVascular" },
        { 0x006619, "Huawei Device Co., Ltd." },
        { 0x00664B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x006762, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x0068EB, "HP Inc." },
        { 0x00692D, "Sunnovo International Limited" },
        { 0x006967, "IEEE Registration Authority" },
        { 0x006B8E, "Shanghai Feixun Communication Co.,Ltd." },
        { 0x006B9E, "Vizio, Inc" },
        { 0x006BA0, "SHENZHEN UNIVERSAL INTELLISYS PTE LTD" },
        { 0x006BF1, "Cisco Systems, Inc" },
        { 0x006CBC, "Cisco Systems, Inc" },
        { 0x006CFD, "Sichuan Changhong Electric Ltd." },
        { 0x006D52, "Apple, Inc." },
        { 0x006D61, "Guangzhou V-SOLUTION Electronic Technology Co., Ltd." },
        { 0x006DFB, "Vutrix Technologies Ltd" },
        { 0x006E02, "Xovis AG" },
        { 0x006F64, "Samsung Electronics Co.,Ltd" },
        { 0x006FF2, "MITSUMI ELECTRIC CO.,LTD." },
        { 0x0070B0, "M/A-COM INC. COMPANIES" },
        { 0x0070B3, "DATA RECALL LTD." },
        { 0x007147, "Amazon Technologies Inc." },
        { 0x0071C2, "PEGATRON CORPORATION" },
        { 0x0071CC, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x007204, "Samsung Electronics Co., Ltd. ARTIK" },
        { 0x007263, "Netcore Technology Inc." },
        { 0x007278, "Cisco Systems, Inc" },
        { 0x00738D, "Shenzhen TINNO Mobile Technology Corp." },
        { 0x0073E0, "Samsung Electronics Co.,Ltd" },
        { 0x00749C, "Ruijie Networks Co.,LTD" },
        { 0x007532, "INID BV" },
        { 0x0075E1, "Ampt, LLC" },
        { 0x00763D, "Veea" },
        { 0x007686, "Cisco Systems, Inc" },
        { 0x0076B1, "Somfy-Protect By Myfox SAS" },
        { 0x00778D, "Cisco Systems, Inc" },
        { 0x0077E4, "Nokia" },
        { 0x007888, "Cisco Systems, Inc" },
        { 0x00789E, "Sagemcom Broadband SAS" },
        { 0x0078CD, "Ignition Design Labs" },
        { 0x007B18, "SENTRY Co., LTD." },
        { 0x007C2D, "Samsung Electronics Co.,Ltd" },
        { 0x007D60, "Apple, Inc." },
        { 0x007DFA, "Volkswagen Group of America" },
        { 0x007E56, "China Dragon Technology Limited" },
        { 0x007E95, "Cisco Systems, Inc" },
        { 0x007F28, "Actiontec Electronics, Inc" },
        { 0x008000, "MULTITECH SYSTEMS, INC." },
        { 0x008001, "PERIPHONICS CORPORATION" },
        { 0x008002, "SATELCOM (UK) LTD" },
        { 0x008003, "HYTEC ELECTRONICS LTD." },
        { 0x008004, "ANTLOW COMMUNICATIONS, LTD." },
        { 0x008005, "CACTUS COMPUTER INC." },
        { 0x008006, "COMPUADD CORPORATION" },
        { 0x008007, "DLOG NC-SYSTEME" },
        { 0x008008, "DYNATECH COMPUTER SYSTEMS" },
        { 0x008009, "JUPITER SYSTEMS, INC." },
        { 0x00800A, "JAPAN COMPUTER CORP." },
        { 0x00800B, "CSK CORPORATION" },
        { 0x00800C, "VIDECOM LIMITED" },
        { 0x00800D, "VOSSWINKEL F.U." },
        { 0x00800E, "ATLANTIX CORPORATION" },
        { 0x00800F, "STANDARD MICROSYSTEMS" },
        { 0x008010, "COMMODORE INTERNATIONAL" },
        { 0x008011, "DIGITAL SYSTEMS INT'L. INC." },
        { 0x008012, "INTEGRATED MEASUREMENT SYSTEMS" },
        { 0x008013, "THOMAS-CONRAD CORPORATION" },
        { 0x008014, "ESPRIT SYSTEMS" },
        { 0x008015, "SEIKO SYSTEMS, INC." },
        { 0x008016, "WANDEL AND GOLTERMANN" },
        { 0x008017, "PFU LIMITED" },
        { 0x008018, "KOBE STEEL, LTD." },
        { 0x008019, "DAYNA COMMUNICATIONS, INC." },
        { 0x00801A, "BELL ATLANTIC" },
        { 0x00801B, "KODIAK TECHNOLOGY" },
        { 0x00801C, "NEWPORT SYSTEMS SOLUTIONS" },
        { 0x00801D, "INTEGRATED INFERENCE MACHINES" },
        { 0x00801E, "XINETRON, INC." },
        { 0x00801F, "KRUPP ATLAS ELECTRONIK GMBH" },
        { 0x008020, "NETWORK PRODUCTS" },
        { 0x008021, "Alcatel Canada Inc." },
        { 0x008022, "SCAN-OPTICS" },
        { 0x008023, "INTEGRATED BUSINESS NETWORKS" },
        { 0x008024, "KALPANA, INC." },
        { 0x008025, "Telit Wireless Solutions GmbH" },
        { 0x008026, "NETWORK PRODUCTS CORPORATION" },
        { 0x008027, "ADAPTIVE SYSTEMS, INC." },
        { 0x008028, "TRADPOST (HK) LTD" },
        { 0x008029, "EAGLE TECHNOLOGY, INC." },
        { 0x00802A, "TEST SYSTEMS & SIMULATIONS INC" },
        { 0x00802B, "INTEGRATED MARKETING CO" },
        { 0x00802C, "THE SAGE GROUP PLC" },
        { 0x00802D, "XYLOGICS INC" },
        { 0x00802E, "CASTLE ROCK COMPUTING" },
        { 0x00802F, "NATIONAL INSTRUMENTS CORP." },
        { 0x008030, "NEXUS ELECTRONICS" },
        { 0x008031, "BASYS, CORP." },
        { 0x008032, "ACCESS CO., LTD." },
        { 0x008033, "EMS Aviation, Inc." },
        { 0x008034, "SMT GOUPIL" },
        { 0x008035, "TECHNOLOGY WORKS, INC." },
        { 0x008036, "REFLEX MANUFACTURING SYSTEMS" },
        { 0x008037, "Ericsson Group" },
        { 0x008038, "DATA RESEARCH & APPLICATIONS" },
        { 0x008039, "ALCATEL STC AUSTRALIA" },
        { 0x00803A, "VARITYPER, INC." },
        { 0x00803B, "APT COMMUNICATIONS, INC." },
        { 0x00803C, "TVS ELECTRONICS LTD" },
        { 0x00803D, "SURIGIKEN CO., LTD." },
        { 0x00803E, "SYNERNETICS" },
        { 0x00803F, "TATUNG COMPANY" },
        { 0x008040, "JOHN FLUKE MANUFACTURING CO." },
        { 0x008041, "VEB KOMBINAT ROBOTRON" },
        { 0x008042, "Artesyn Embedded Technologies" },
        { 0x008043, "NETWORLD, INC." },
        { 0x008044, "SYSTECH COMPUTER CORP." },
        { 0x008045, "MATSUSHITA ELECTRIC IND. CO" },
        { 0x008046, "Tattile SRL" },
        { 0x008047, "IN-NET CORP." },
        { 0x008048, "COMPEX INCORPORATED" },
        { 0x008049, "NISSIN ELECTRIC CO., LTD." },
        { 0x00804A, "PRO-LOG" },
        { 0x00804B, "EAGLE TECHNOLOGIES PTY.LTD." },
        { 0x00804C, "CONTEC CO., LTD." },
        { 0x00804D, "CYCLONE MICROSYSTEMS, INC." },
        { 0x00804E, "APEX COMPUTER COMPANY" },
        { 0x00804F, "DAIKIN INDUSTRIES, LTD." },
        { 0x008050, "ZIATECH CORPORATION" },
        { 0x008051, "FIBERMUX" },
        { 0x008052, "TECHNICALLY ELITE CONCEPTS" },
        { 0x008053, "INTELLICOM, INC." },
        { 0x008054, "FRONTIER TECHNOLOGIES CORP." },
        { 0x008055, "FERMILAB" },
        { 0x008056, "SPHINX Electronics GmbH & Co KG" },
        { 0x008057, "ADSOFT, LTD." },
        { 0x008058, "PRINTER SYSTEMS CORP." },
        { 0x008059, "STANLEY ELECTRIC CO., LTD" },
        { 0x00805A, "TULIP COMPUTERS INTERNAT'L B.V" },
        { 0x00805B, "CONDOR SYSTEMS, INC." },
        { 0x00805C, "AGILIS CORPORATION" },
        { 0x00805D, "CANSTAR" },
        { 0x00805E, "LSI LOGIC CORPORATION" },
        { 0x00805F, "Hewlett Packard" },
        { 0x008060, "NETWORK INTERFACE CORPORATION" },
        { 0x008061, "LITTON SYSTEMS, INC." },
        { 0x008062, "INTERFACE CO." },
        { 0x008063, "Hirschmann Automation and Control GmbH" },
        { 0x008064, "WYSE TECHNOLOGY LLC" },
        { 0x008065, "CYBERGRAPHIC SYSTEMS PTY LTD." },
        { 0x008066, "ARCOM CONTROL SYSTEMS, LTD." },
        { 0x008067, "SQUARE D COMPANY" },
        { 0x008068, "YAMATECH SCIENTIFIC LTD." },
        { 0x008069, "COMPUTONE SYSTEMS" },
        { 0x00806A, "ERI (EMPAC RESEARCH INC.)" },
        { 0x00806B, "SCHMID TELECOMMUNICATION" },
        { 0x00806C, "Secure Systems & Services" },
        { 0x00806D, "CENTURY SYSTEMS CORP." },
        { 0x00806E, "NIPPON STEEL CORPORATION" },
        { 0x00806F, "ONELAN LTD." },
        { 0x008070, "COMPUTADORAS MICRON" },
        { 0x008071, "SAI TECHNOLOGY" },
        { 0x008072, "MICROPLEX SYSTEMS LTD." },
        { 0x008073, "DWB ASSOCIATES" },
        { 0x008074, "FISHER CONTROLS" },
        { 0x008075, "PARSYTEC GMBH" },
        { 0x008076, "MCNC" },
        { 0x008077, "Brother industries, LTD." },
        { 0x008078, "PRACTICAL PERIPHERALS, INC." },
        { 0x008079, "MICROBUS DESIGNS LTD." },
        { 0x00807A, "AITECH SYSTEMS LTD." },
        { 0x00807B, "ARTEL COMMUNICATIONS CORP." },
        { 0x00807C, "FIBERCOM, INC." },
        { 0x00807D, "EQUINOX SYSTEMS INC." },
        { 0x00807E, "SOUTHERN PACIFIC LTD." },
        { 0x00807F, "DY-4 INCORPORATED" },
        { 0x008080, "DATAMEDIA CORPORATION" },
        { 0x008081, "KENDALL SQUARE RESEARCH CORP." },
        { 0x008082, "PEP MODULAR COMPUTERS GMBH" },
        { 0x008083, "AMDAHL" },
        { 0x008084, "THE CLOUD INC." },
        { 0x008085, "H-THREE SYSTEMS CORPORATION" },
        { 0x008086, "COMPUTER GENERATION INC." },
        { 0x008087, "OKI ELECTRIC INDUSTRY CO., LTD" },
        { 0x008088, "VICTOR COMPANY OF JAPAN, LTD." },
        { 0x008089, "TECNETICS (PTY) LTD." },
        { 0x00808A, "SUMMIT MICROSYSTEMS CORP." },
        { 0x00808B, "DACOLL LIMITED" },
        { 0x00808C, "NetAlly" },
        { 0x00808D, "WESTCOAST TECHNOLOGY B.V." },
        { 0x00808E, "RADSTONE TECHNOLOGY" },
        { 0x00808F, "C. ITOH ELECTRONICS, INC." },
        { 0x008090, "MICROTEK INTERNATIONAL, INC." },
        { 0x008091, "TOKYO ELECTRIC CO.,LTD" },
        { 0x008092, "Silex Technology, Inc." },
        { 0x008093, "XYRON CORPORATION" },
        { 0x008094, "ALFA LAVAL AUTOMATION AB" },
        { 0x008095, "BASIC MERTON HANDELSGES.M.B.H." },
        { 0x008096, "HUMAN DESIGNED SYSTEMS, INC." },
        { 0x008097, "CENTRALP AUTOMATISMES" },
        { 0x008098, "TDK CORPORATION" },
        { 0x008099, "Eaton Industries GmbH" },
        { 0x00809A, "NOVUS NETWORKS LTD" },
        { 0x00809B, "JUSTSYSTEM CORPORATION" },
        { 0x00809C, "LUXCOM, INC." },
        { 0x00809D, "Commscraft Ltd." },
        { 0x00809E, "DATUS GMBH" },
        { 0x00809F, "ALE International" },
        { 0x0080A0, "Hewlett Packard" },
        { 0x0080A1, "MICROTEST, INC." },
        { 0x0080A2, "CREATIVE ELECTRONIC SYSTEMS" },
        { 0x0080A3, "Lantronix" },
        { 0x0080A4, "LIBERTY ELECTRONICS" },
        { 0x0080A5, "SPEED INTERNATIONAL" },
        { 0x0080A6, "REPUBLIC TECHNOLOGY, INC." },
        { 0x0080A7, "Honeywell International Inc" },
        { 0x0080A8, "VITACOM CORPORATION" },
        { 0x0080A9, "CLEARPOINT RESEARCH" },
        { 0x0080AA, "MAXPEED" },
        { 0x0080AB, "DUKANE NETWORK INTEGRATION" },
        { 0x0080AC, "IMLOGIX, DIVISION OF GENESYS" },
        { 0x0080AD, "CNET TECHNOLOGY, INC." },
        { 0x0080AE, "HUGHES NETWORK SYSTEMS" },
        { 0x0080AF, "ALLUMER CO., LTD." },
        { 0x0080B0, "ADVANCED INFORMATION" },
        { 0x0080B1, "SOFTCOM A/S" },
        { 0x0080B2, "NETWORK EQUIPMENT TECHNOLOGIES" },
        { 0x0080B3, "AVAL DATA CORPORATION" },
        { 0x0080B4, "SOPHIA SYSTEMS" },
        { 0x0080B5, "UNITED NETWORKS INC." },
        { 0x0080B6, "Mercury Systems – Trusted Mission Solutions, Inc." },
        { 0x0080B7, "STELLAR COMPUTER" },
        { 0x0080B8, "DMG MORI B.U.G. CO., LTD." },
        { 0x0080B9, "ARCHE TECHNOLIGIES INC." },
        { 0x0080BA, "SPECIALIX (ASIA) PTE, LTD" },
        { 0x0080BB, "HUGHES LAN SYSTEMS" },
        { 0x0080BC, "HITACHI ENGINEERING CO., LTD" },
        { 0x0080BD, "THE FURUKAWA ELECTRIC CO., LTD" },
        { 0x0080BE, "ARIES RESEARCH" },
        { 0x0080BF, "TAKAOKA ELECTRIC MFG. CO. LTD." },
        { 0x0080C0, "PENRIL DATACOMM" },
        { 0x0080C1, "LANEX CORPORATION" },
        { 0x0080C2, "IEEE 802.1 Working Group" },
        { 0x0080C3, "BICC INFORMATION SYSTEMS & SVC" },
        { 0x0080C4, "DOCUMENT TECHNOLOGIES, INC." },
        { 0x0080C5, "NOVELLCO DE MEXICO" },
        { 0x0080C6, "NATIONAL DATACOMM CORPORATION" },
        { 0x0080C7, "XIRCOM" },
        { 0x0080C8, "D-LINK SYSTEMS, INC." },
        { 0x0080C9, "ALBERTA MICROELECTRONIC CENTRE" },
        { 0x0080CA, "NETCOM RESEARCH INCORPORATED" },
        { 0x0080CB, "FALCO DATA PRODUCTS" },
        { 0x0080CC, "MICROWAVE BYPASS SYSTEMS" },
        { 0x0080CD, "MICRONICS COMPUTER, INC." },
        { 0x0080CE, "BROADCAST TELEVISION SYSTEMS" },
        { 0x0080CF, "EMBEDDED PERFORMANCE INC." },
        { 0x0080D0, "COMPUTER PERIPHERALS, INC." },
        { 0x0080D1, "KIMTRON CORPORATION" },
        { 0x0080D2, "SHINNIHONDENKO CO., LTD." },
        { 0x0080D3, "SHIVA CORP." },
        { 0x0080D4, "CHASE RESEARCH LTD." },
        { 0x0080D5, "CADRE TECHNOLOGIES" },
        { 0x0080D6, "NUVOTECH, INC." },
        { 0x0080D7, "Fantum Engineering" },
        { 0x0080D8, "NETWORK PERIPHERALS INC." },
        { 0x0080D9, "EMK Elektronik GmbH & Co. KG" },
        { 0x0080DA, "Bruel & Kjaer Sound & Vibration Measurement A/S" },
        { 0x0080DB, "GRAPHON CORPORATION" },
        { 0x0080DC, "PICKER INTERNATIONAL" },
        { 0x0080DD, "GMX INC/GIMIX" },
        { 0x0080DE, "GIPSI S.A." },
        { 0x0080DF, "ADC CODENOLL TECHNOLOGY CORP." },
        { 0x0080E0, "XTP SYSTEMS, INC." },
        { 0x0080E1, "STMicroelectronics SRL" },
        { 0x0080E2, "T.D.I. CO., LTD." },
        { 0x0080E3, "CORAL NETWORK CORPORATION" },
        { 0x0080E4, "NORTHWEST DIGITAL SYSTEMS, INC" },
        { 0x0080E5, "NetApp" },
        { 0x0080E6, "PEER NETWORKS, INC." },
        { 0x0080E7, "Leonardo Tactical Systems." },
        { 0x0080E8, "CUMULUS CORPORATIION" },
        { 0x0080E9, "Madge Ltd." },
        { 0x0080EA, "ADVA Optical Networking Ltd." },
        { 0x0080EB, "COMPCONTROL B.V." },
        { 0x0080EC, "SUPERCOMPUTING SOLUTIONS, INC." },
        { 0x0080ED, "IQ TECHNOLOGIES, INC." },
        { 0x0080EE, "THOMSON CSF" },
        { 0x0080EF, "RATIONAL" },
        { 0x0080F0, "Panasonic Communications Co., Ltd." },
        { 0x0080F1, "OPUS SYSTEMS" },
        { 0x0080F2, "RAYCOM SYSTEMS INC" },
        { 0x0080F3, "SUN ELECTRONICS CORP." },
        { 0x0080F4, "TELEMECANIQUE ELECTRIQUE" },
        { 0x0080F5, "Quantel Ltd" },
        { 0x0080F6, "SYNERGY MICROSYSTEMS" },
        { 0x0080F7, "Zenith Electronics Corporation" },
        { 0x0080F8, "MIZAR, INC." },
        { 0x0080F9, "HEURIKON CORPORATION" },
        { 0x0080FA, "RWT GMBH" },
        { 0x0080FB, "BVM LIMITED" },
        { 0x0080FC, "AVATAR CORPORATION" },
        { 0x0080FD, "EXSCEED CORPRATION" },
        { 0x0080FE, "AZURE TECHNOLOGIES, INC." },
        { 0x0080FF, "SOC. DE TELEINFORMATIQUE RTC" },
        { 0x0081C4, "Cisco Systems, Inc" },
        { 0x0081F9, "Texas Instruments" },
        { 0x0084ED, "Private" },
        { 0x00869C, "Palo Alto Networks" },
        { 0x0086A0, "Private" },
        { 0x008701, "Samsung Electronics Co.,Ltd" },
        { 0x008731, "Cisco Systems, Inc" },
        { 0x008764, "Cisco Systems, Inc" },
        { 0x008865, "Apple, Inc." },
        { 0x0088BA, "NC&C" },
        { 0x008A55, "Huawei Device Co., Ltd." },
        { 0x008A96, "Cisco Systems, Inc" },
        { 0x008B43, "RFTECH" },
        { 0x008BFC, "mixi,Inc." },
        { 0x008C10, "Black Box Corp." },
        { 0x008C54, "ADB Broadband Italia" },
        { 0x008CFA, "INVENTEC CORPORATION" },
        { 0x008D4E, "CJSC NII STT" },
        { 0x008DDA, "Link One Co., Ltd." },
        { 0x008E73, "Cisco Systems, Inc" },
        { 0x008EF2, "NETGEAR" },
        { 0x009000, "DIAMOND MULTIMEDIA" },
        { 0x009001, "NISHIMU ELECTRONICS INDUSTRIES CO., LTD." },
        { 0x009002, "ALLGON AB" },
        { 0x009003, "APLIO" },
        { 0x009004, "3COM EUROPE LTD" },
        { 0x009005, "PROTECH SYSTEMS CO., LTD." },
        { 0x009006, "Hamamatsu Photonics K.K." },
        { 0x009007, "DOMEX TECHNOLOGY CORP." },
        { 0x009008, "HanA Systems Inc." },
        { 0x009009, "I Controls, Inc." },
        { 0x00900A, "PROTON ELECTRONIC INDUSTRIAL CO., LTD." },
        { 0x00900B, "LANNER ELECTRONICS, INC." },
        { 0x00900C, "Cisco Systems, Inc" },
        { 0x00900D, "Overland Storage Inc." },
        { 0x00900E, "HANDLINK TECHNOLOGIES, INC." },
        { 0x00900F, "KAWASAKI HEAVY INDUSTRIES, LTD" },
        { 0x009010, "SIMULATION LABORATORIES, INC." },
        { 0x009011, "WAVTrace, Inc." },
        { 0x009012, "GLOBESPAN SEMICONDUCTOR, INC." },
        { 0x009013, "SAMSAN CORP." },
        { 0x009014, "ROTORK INSTRUMENTS, LTD." },
        { 0x009015, "CENTIGRAM COMMUNICATIONS CORP." },
        { 0x009016, "ZAC" },
        { 0x009017, "Zypcom, Inc" },
        { 0x009018, "ITO ELECTRIC INDUSTRY CO, LTD." },
        { 0x009019, "HERMES ELECTRONICS CO., LTD." },
        { 0x00901A, "UNISPHERE SOLUTIONS" },
        { 0x00901B, "DIGITAL CONTROLS" },
        { 0x00901C, "mps Software Gmbh" },
        { 0x00901D, "PEC (NZ) LTD." },
        { 0x00901E, "Selesta Ingegneria S.p.A." },
        { 0x00901F, "ADTEC PRODUCTIONS, INC." },
        { 0x009020, "PHILIPS ANALYTICAL X-RAY B.V." },
        { 0x009021, "Cisco Systems, Inc" },
        { 0x009022, "IVEX" },
        { 0x009023, "ZILOG INC." },
        { 0x009024, "PIPELINKS, INC." },
        { 0x009025, "BAE Systems Australia (Electronic Systems) Pty Ltd" },
        { 0x009026, "ADVANCED SWITCHING COMMUNICATIONS, INC." },
        { 0x009027, "Intel Corporation" },
        { 0x009028, "NIPPON SIGNAL CO., LTD." },
        { 0x009029, "CRYPTO AG" },
        { 0x00902A, "COMMUNICATION DEVICES, INC." },
        { 0x00902B, "Cisco Systems, Inc" },
        { 0x00902C, "DATA & CONTROL EQUIPMENT LTD." },
        { 0x00902D, "DATA ELECTRONICS (AUST.) PTY, LTD." },
        { 0x00902E, "NAMCO LIMITED" },
        { 0x00902F, "NETCORE SYSTEMS, INC." },
        { 0x009030, "HONEYWELL-DATING" },
        { 0x009031, "MYSTICOM, LTD." },
        { 0x009032, "PELCOMBE GROUP LTD." },
        { 0x009033, "INNOVAPHONE AG" },
        { 0x009034, "IMAGIC, INC." },
        { 0x009035, "ALPHA TELECOM, INC." },
        { 0x009036, "ens, inc." },
        { 0x009037, "ACUCOMM, INC." },
        { 0x009038, "FOUNTAIN TECHNOLOGIES, INC." },
        { 0x009039, "SHASTA NETWORKS" },
        { 0x00903A, "NIHON MEDIA TOOL INC." },
        { 0x00903B, "TriEMS Research Lab, Inc." },
        { 0x00903C, "ATLANTIC NETWORK SYSTEMS" },
        { 0x00903D, "BIOPAC SYSTEMS, INC." },
        { 0x00903E, "N.V. PHILIPS INDUSTRIAL ACTIVITIES" },
        { 0x00903F, "AZTEC RADIOMEDIA" },
        { 0x009040, "Siemens Network Convergence LLC" },
        { 0x009041, "APPLIED DIGITAL ACCESS" },
        { 0x009042, "ECCS, Inc." },
        { 0x009043, "Tattile SRL" },
        { 0x009044, "ASSURED DIGITAL, INC." },
        { 0x009045, "Marconi Communications" },
        { 0x009046, "DEXDYNE, LTD." },
        { 0x009047, "GIGA FAST E. LTD." },
        { 0x009048, "ZEAL CORPORATION" },
        { 0x009049, "ENTRIDIA CORPORATION" },
        { 0x00904A, "CONCUR SYSTEM TECHNOLOGIES" },
        { 0x00904B, "Gemtek Technology Co., Ltd." },
        { 0x00904C, "Epigram, Inc." },
        { 0x00904D, "SPEC S.A." },
        { 0x00904E, "DELEM BV" },
        { 0x00904F, "ABB POWER T&D COMPANY, INC." },
        { 0x009050, "Teleste Corporation" },
        { 0x009051, "ULTIMATE TECHNOLOGY CORP." },
        { 0x009052, "SELCOM ELETTRONICA S.R.L." },
        { 0x009053, "DAEWOO ELECTRONICS CO., LTD." },
        { 0x009054, "INNOVATIVE SEMICONDUCTORS, INC" },
        { 0x009055, "PARKER HANNIFIN CORPORATION COMPUMOTOR DIVISION" },
        { 0x009056, "TELESTREAM, INC." },
        { 0x009057, "AANetcom, Inc." },
        { 0x009058, "Ultra Electronics Command & Control Systems" },
        { 0x009059, "TELECOM DEVICE K.K." },
        { 0x00905A, "DEARBORN GROUP, INC." },
        { 0x00905B, "RAYMOND AND LAE ENGINEERING" },
        { 0x00905C, "EDMI" },
        { 0x00905D, "NETCOM SICHERHEITSTECHNIK GMBH" },
        { 0x00905E, "RAULAND-BORG CORPORATION" },
        { 0x00905F, "Cisco Systems, Inc" },
        { 0x009060, "SYSTEM CREATE CORP." },
        { 0x009061, "PACIFIC RESEARCH & ENGINEERING CORPORATION" },
        { 0x009062, "ICP VORTEX COMPUTERSYSTEME GmbH" },
        { 0x009063, "COHERENT COMMUNICATIONS SYSTEMS CORPORATION" },
        { 0x009064, "Thomson Inc." },
        { 0x009065, "FINISAR CORPORATION" },
        { 0x009066, "Troika Networks, Inc." },
        { 0x009067, "WalkAbout Computers, Inc." },
        { 0x009068, "DVT CORP." },
        { 0x009069, "Juniper Networks" },
        { 0x00906A, "TURNSTONE SYSTEMS, INC." },
        { 0x00906B, "APPLIED RESOURCES, INC." },
        { 0x00906C, "Sartorius Hamburg GmbH" },
        { 0x00906D, "Cisco Systems, Inc" },
        { 0x00906E, "PRAXON, INC." },
        { 0x00906F, "Cisco Systems, Inc" },
        { 0x009070, "NEO NETWORKS, INC." },
        { 0x009071, "Applied Innovation Inc." },
        { 0x009072, "SIMRAD AS" },
        { 0x009073, "GAIO TECHNOLOGY" },
        { 0x009074, "ARGON NETWORKS, INC." },
        { 0x009075, "NEC DO BRASIL S.A." },
        { 0x009076, "FMT AIRCRAFT GATE SUPPORT SYSTEMS AB" },
        { 0x009077, "ADVANCED FIBRE COMMUNICATIONS" },
        { 0x009078, "MER TELEMANAGEMENT SOLUTIONS, LTD." },
        { 0x009079, "ClearOne, Inc." },
        { 0x00907A, "Spectralink, Inc" },
        { 0x00907B, "E-TECH, INC." },
        { 0x00907C, "DIGITALCAST, INC." },
        { 0x00907D, "Lake Communications" },
        { 0x00907E, "VETRONIX CORP." },
        { 0x00907F, "WatchGuard Technologies, Inc." },
        { 0x009080, "NOT LIMITED, INC." },
        { 0x009081, "ALOHA NETWORKS, INC." },
        { 0x009082, "FORCE INSTITUTE" },
        { 0x009083, "TURBO COMMUNICATION, INC." },
        { 0x009084, "ATECH SYSTEM" },
        { 0x009085, "GOLDEN ENTERPRISES, INC." },
        { 0x009086, "Cisco Systems, Inc" },
        { 0x009087, "ITIS" },
        { 0x009088, "BAXALL SECURITY LTD." },
        { 0x009089, "SOFTCOM MICROSYSTEMS, INC." },
        { 0x00908A, "BAYLY COMMUNICATIONS, INC." },
        { 0x00908B, "Tattile SRL" },
        { 0x00908C, "ETREND ELECTRONICS, INC." },
        { 0x00908D, "VICKERS ELECTRONICS SYSTEMS" },
        { 0x00908E, "Nortel Networks Broadband Access" },
        { 0x00908F, "AUDIO CODES LTD." },
        { 0x009090, "I-BUS" },
        { 0x009091, "DigitalScape, Inc." },
        { 0x009092, "Cisco Systems, Inc" },
        { 0x009093, "EIZO Corporation" },
        { 0x009094, "OSPREY TECHNOLOGIES, INC." },
        { 0x009095, "UNIVERSAL AVIONICS" },
        { 0x009096, "ASKEY COMPUTER CORP" },
        { 0x009097, "Sycamore Networks" },
        { 0x009098, "SBC DESIGNS, INC." },
        { 0x009099, "ALLIED TELESIS, K.K." },
        { 0x00909A, "ONE WORLD SYSTEMS, INC." },
        { 0x00909B, "MARKEM-IMAJE" },
        { 0x00909C, "ARRIS Group, Inc." },
        { 0x00909D, "NovaTech Process Solutions, LLC" },
        { 0x00909E, "Critical IO, LLC" },
        { 0x00909F, "DIGI-DATA CORPORATION" },
        { 0x0090A0, "8X8 INC." },
        { 0x0090A1, "Flying Pig Systems/High End Systems Inc." },
        { 0x0090A2, "CyberTAN Technology Inc." },
        { 0x0090A3, "Corecess Inc." },
        { 0x0090A4, "ALTIGA NETWORKS" },
        { 0x0090A5, "SPECTRA LOGIC" },
        { 0x0090A6, "Cisco Systems, Inc" },
        { 0x0090A7, "CLIENTEC CORPORATION" },
        { 0x0090A8, "NineTiles Networks, Ltd." },
        { 0x0090A9, "WESTERN DIGITAL" },
        { 0x0090AA, "INDIGO ACTIVE VISION SYSTEMS LIMITED" },
        { 0x0090AB, "Cisco Systems, Inc" },
        { 0x0090AC, "OPTIVISION, INC." },
        { 0x0090AD, "ASPECT ELECTRONICS, INC." },
        { 0x0090AE, "ITALTEL S.p.A/RF-UP-I" },
        { 0x0090AF, "J. MORITA MFG. CORP." },
        { 0x0090B0, "VADEM" },
        { 0x0090B1, "Cisco Systems, Inc" },
        { 0x0090B2, "AVICI SYSTEMS INC." },
        { 0x0090B3, "AGRANAT SYSTEMS" },
        { 0x0090B4, "WILLOWBROOK TECHNOLOGIES" },
        { 0x0090B5, "NIKON CORPORATION" },
        { 0x0090B6, "FIBEX SYSTEMS" },
        { 0x0090B7, "DIGITAL LIGHTWAVE, INC." },
        { 0x0090B8, "ROHDE & SCHWARZ GMBH & CO. KG" },
        { 0x0090B9, "BERAN INSTRUMENTS LTD." },
        { 0x0090BA, "VALID NETWORKS, INC." },
        { 0x0090BB, "TAINET COMMUNICATION SYSTEM Corp." },
        { 0x0090BC, "TELEMANN CO., LTD." },
        { 0x0090BD, "OMNIA COMMUNICATIONS, INC." },
        { 0x0090BE, "IBC/INTEGRATED BUSINESS COMPUTERS" },
        { 0x0090BF, "Cisco Systems, Inc" },
        { 0x0090C0, "K.J. LAW ENGINEERS, INC." },
        { 0x0090C1, "Peco II, Inc." },
        { 0x0090C2, "JK microsystems, Inc." },
        { 0x0090C3, "TOPIC SEMICONDUCTOR CORP." },
        { 0x0090C4, "JAVELIN SYSTEMS, INC." },
        { 0x0090C5, "INTERNET MAGIC, INC." },
        { 0x0090C6, "OPTIM SYSTEMS, INC." },
        { 0x0090C7, "ICOM INC." },
        { 0x0090C8, "WAVERIDER COMMUNICATIONS (CANADA) INC." },
        { 0x0090C9, "DPAC Technologies" },
        { 0x0090CA, "ACCORD VIDEO TELECOMMUNICATIONS, LTD." },
        { 0x0090CB, "Wireless OnLine, Inc." },
        { 0x0090CC, "PLANEX COMMUNICATIONS INC." },
        { 0x0090CD, "ENT-EMPRESA NACIONAL DE TELECOMMUNICACOES, S.A." },
        { 0x0090CE, "avateramedical Mechatronics GmbH" },
        { 0x0090CF, "NORTEL" },
        { 0x0090D0, "Thomson Telecom Belgium" },
        { 0x0090D1, "LEICHU ENTERPRISE CO., LTD." },
        { 0x0090D2, "Artel Video Systems" },
        { 0x0090D3, "GIESECKE & DEVRIENT GmbH" },
        { 0x0090D4, "BindView Development Corp." },
        { 0x0090D5, "EUPHONIX, INC." },
        { 0x0090D6, "Crystal Group, Inc." },
        { 0x0090D7, "NetBoost Corp." },
        { 0x0090D8, "WHITECROSS SYSTEMS" },
        { 0x0090D9, "Cisco Systems, Inc" },
        { 0x0090DA, "DYNARC, INC." },
        { 0x0090DB, "NEXT LEVEL COMMUNICATIONS" },
        { 0x0090DC, "TECO INFORMATION SYSTEMS" },
        { 0x0090DD, "MIHARU COMMUNICATIONS Inc" },
        { 0x0090DE, "CARDKEY SYSTEMS, INC." },
        { 0x0090DF, "MITSUBISHI CHEMICAL AMERICA, INC." },
        { 0x0090E0, "SYSTRAN CORP." },
        { 0x0090E1, "TELENA S.P.A." },
        { 0x0090E2, "DISTRIBUTED PROCESSING TECHNOLOGY" },
        { 0x0090E3, "AVEX ELECTRONICS INC." },
        { 0x0090E4, "NEC AMERICA, INC." },
        { 0x0090E5, "TEKNEMA, INC." },
        { 0x0090E6, "ALi Corporation" },
        { 0x0090E7, "HORSCH ELEKTRONIK AG" },
        { 0x0090E8, "MOXA TECHNOLOGIES CORP., LTD." },
        { 0x0090E9, "JANZ COMPUTER AG" },
        { 0x0090EA, "ALPHA TECHNOLOGIES, INC." },
        { 0x0090EB, "SENTRY TELECOM SYSTEMS" },
        { 0x0090EC, "PYRESCOM" },
        { 0x0090ED, "CENTRAL SYSTEM RESEARCH CO., LTD." },
        { 0x0090EE, "PERSONAL COMMUNICATIONS TECHNOLOGIES" },
        { 0x0090EF, "INTEGRIX, INC." },
        { 0x0090F0, "Harmonic Video Systems Ltd." },
        { 0x0090F1, "Seagate Cloud Systems Inc" },
        { 0x0090F2, "Cisco Systems, Inc" },
        { 0x0090F3, "ASPECT COMMUNICATIONS" },
        { 0x0090F4, "LIGHTNING INSTRUMENTATION" },
        { 0x0090F5, "CLEVO CO." },
        { 0x0090F6, "ESCALATE NETWORKS, INC." },
        { 0x0090F7, "NBASE COMMUNICATIONS LTD." },
        { 0x0090F8, "MEDIATRIX TELECOM" },
        { 0x0090F9, "Imagine Communications" },
        { 0x0090FA, "Emulex Corporation" },
        { 0x0090FB, "PORTWELL, INC." },
        { 0x0090FC, "NETWORK COMPUTING DEVICES" },
        { 0x0090FD, "CopperCom, Inc." },
        { 0x0090FE, "ELECOM CO., LTD. (LANEED DIV.)" },
        { 0x0090FF, "TELLUS TECHNOLOGY INC." },
        { 0x0091D6, "Crystal Group, Inc." },
        { 0x0091FA, "Synapse Product Development" },
        { 0x00927D, "Ficosa Internationa(Taicang) C0.,Ltd." },
        { 0x0092FA, "SHENZHEN WISKY TECHNOLOGY CO.,LTD" },
        { 0x009363, "Uni-Link Technology Co., Ltd." },
        { 0x0094A1, "F5 Networks, Inc." },
        { 0x0094EC, "Huawei Device Co., Ltd." },
        { 0x009569, "LSD Science and Technology Co.,Ltd." },
        { 0x0097FF, "Heimann Sensor GmbH" },
        { 0x009ACD, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x009AD2, "Cisco Systems, Inc" },
        { 0x009C02, "Hewlett Packard" },
        { 0x009D6B, "Murata Manufacturing Co., Ltd." },
        { 0x009D8E, "CARDIAC RECORDERS, INC." },
        { 0x009E1E, "Cisco Systems, Inc" },
        { 0x009EC8, "Xiaomi Communications Co Ltd" },
        { 0x009EEE, "Positivo Tecnologia S.A." },
        { 0x00A000, "CENTILLION NETWORKS, INC." },
        { 0x00A001, "DRS Signal Solutions" },
        { 0x00A002, "LEEDS & NORTHRUP AUSTRALIA PTY LTD" },
        { 0x00A003, "Siemens Switzerland Ltd., I B T HVP" },
        { 0x00A004, "NETPOWER, INC." },
        { 0x00A005, "DANIEL INSTRUMENTS, LTD." },
        { 0x00A006, "IMAGE DATA PROCESSING SYSTEM GROUP" },
        { 0x00A007, "APEXX TECHNOLOGY, INC." },
        { 0x00A008, "NETCORP" },
        { 0x00A009, "WHITETREE NETWORK" },
        { 0x00A00A, "Airspan" },
        { 0x00A00B, "COMPUTEX CO., LTD." },
        { 0x00A00C, "KINGMAX TECHNOLOGY, INC." },
        { 0x00A00D, "THE PANDA PROJECT" },
        { 0x00A00E, "NetAlly" },
        { 0x00A00F, "Broadband Technologies" },
        { 0x00A010, "SYSLOGIC DATENTECHNIK AG" },
        { 0x00A011, "MUTOH INDUSTRIES LTD." },
        { 0x00A012, "Telco Systems, Inc." },
        { 0x00A013, "TELTREND LTD." },
        { 0x00A014, "CSIR" },
        { 0x00A015, "WYLE" },
        { 0x00A016, "MICROPOLIS CORP." },
        { 0x00A017, "J B M CORPORATION" },
        { 0x00A018, "CREATIVE CONTROLLERS, INC." },
        { 0x00A019, "NEBULA CONSULTANTS, INC." },
        { 0x00A01A, "BINAR ELEKTRONIK AB" },
        { 0x00A01B, "PREMISYS COMMUNICATIONS, INC." },
        { 0x00A01C, "NASCENT NETWORKS CORPORATION" },
        { 0x00A01D, "Red Lion Controls, LP" },
        { 0x00A01E, "EST CORPORATION" },
        { 0x00A01F, "TRICORD SYSTEMS, INC." },
        { 0x00A020, "CITICORP/TTI" },
        { 0x00A021, "General Dynamics Mission Systems" },
        { 0x00A022, "CENTRE FOR DEVELOPMENT OF ADVANCED COMPUTING" },
        { 0x00A023, "APPLIED CREATIVE TECHNOLOGY, INC." },
        { 0x00A024, "3COM" },
        { 0x00A025, "REDCOM LABS INC." },
        { 0x00A026, "TELDAT, S.A." },
        { 0x00A027, "FIREPOWER SYSTEMS, INC." },
        { 0x00A028, "CONNER PERIPHERALS" },
        { 0x00A029, "COULTER CORPORATION" },
        { 0x00A02A, "TRANCELL SYSTEMS" },
        { 0x00A02B, "TRANSITIONS RESEARCH CORP." },
        { 0x00A02C, "interWAVE Communications" },
        { 0x00A02D, "1394 Trade Association" },
        { 0x00A02E, "BRAND COMMUNICATIONS, LTD." },
        { 0x00A02F, "ADB Broadband Italia" },
        { 0x00A030, "CAPTOR NV/SA" },
        { 0x00A031, "HAZELTINE CORPORATION, MS 1-17" },
        { 0x00A032, "GES SINGAPORE PTE. LTD." },
        { 0x00A033, "imc MeBsysteme GmbH" },
        { 0x00A034, "AXEL" },
        { 0x00A035, "CYLINK CORPORATION" },
        { 0x00A036, "APPLIED NETWORK TECHNOLOGY" },
        { 0x00A037, "Mindray DS USA, Inc." },
        { 0x00A038, "EMAIL ELECTRONICS" },
        { 0x00A039, "ROSS TECHNOLOGY, INC." },
        { 0x00A03A, "KUBOTEK CORPORATION" },
        { 0x00A03B, "TOSHIN ELECTRIC CO., LTD." },
        { 0x00A03C, "EG&G NUCLEAR INSTRUMENTS" },
        { 0x00A03D, "OPTO-22" },
        { 0x00A03E, "ATM FORUM" },
        { 0x00A03F, "COMPUTER SOCIETY MICROPROCESSOR & MICROPROCESSOR STANDARDS C" },
        { 0x00A040, "Apple, Inc." },
        { 0x00A041, "INFICON" },
        { 0x00A042, "SPUR PRODUCTS CORP." },
        { 0x00A043, "AMERICAN TECHNOLOGY LABS, INC." },
        { 0x00A044, "NTT IT CO., LTD." },
        { 0x00A045, "PHOENIX CONTACT Electronics GmbH" },
        { 0x00A046, "SCITEX CORP. LTD." },
        { 0x00A047, "INTEGRATED FITNESS CORP." },
        { 0x00A048, "QUESTECH, LTD." },
        { 0x00A049, "DIGITECH INDUSTRIES, INC." },
        { 0x00A04A, "NISSHIN ELECTRIC CO., LTD." },
        { 0x00A04B, "TFL LAN INC." },
        { 0x00A04C, "INNOVATIVE SYSTEMS & TECHNOLOGIES, INC." },
        { 0x00A04D, "EDA INSTRUMENTS, INC." },
        { 0x00A04E, "VOELKER TECHNOLOGIES, INC." },
        { 0x00A04F, "AMERITEC CORP." },
        { 0x00A050, "CYPRESS SEMICONDUCTOR" },
        { 0x00A051, "ANGIA COMMUNICATIONS. INC." },
        { 0x00A052, "STANILITE ELECTRONICS PTY. LTD" },
        { 0x00A053, "COMPACT DEVICES, INC." },
        { 0x00A054, "Private" },
        { 0x00A055, "Data Device Corporation" },
        { 0x00A056, "MICROPROSS" },
        { 0x00A057, "LANCOM Systems GmbH" },
        { 0x00A058, "GLORY, LTD." },
        { 0x00A059, "HAMILTON HALLMARK" },
        { 0x00A05A, "KOFAX IMAGE PRODUCTS" },
        { 0x00A05B, "MARQUIP, INC." },
        { 0x00A05C, "INVENTORY CONVERSION, INC./" },
        { 0x00A05D, "CS COMPUTER SYSTEME GmbH" },
        { 0x00A05E, "MYRIAD LOGIC INC." },
        { 0x00A05F, "BTG Electronics Design BV" },
        { 0x00A060, "ACER PERIPHERALS, INC." },
        { 0x00A061, "PURITAN BENNETT" },
        { 0x00A062, "AES PRODATA" },
        { 0x00A063, "JRL SYSTEMS, INC." },
        { 0x00A064, "KVB/ANALECT" },
        { 0x00A065, "Symantec Corporation" },
        { 0x00A066, "ISA CO., LTD." },
        { 0x00A067, "NETWORK SERVICES GROUP" },
        { 0x00A068, "BHP LIMITED" },
        { 0x00A069, "Symmetricom, Inc." },
        { 0x00A06A, "Verilink Corporation" },
        { 0x00A06B, "DMS DORSCH MIKROSYSTEM GMBH" },
        { 0x00A06C, "SHINDENGEN ELECTRIC MFG. CO., LTD." },
        { 0x00A06D, "MANNESMANN TALLY CORPORATION" },
        { 0x00A06E, "AUSTRON, INC." },
        { 0x00A06F, "Color Sentinel Systems, LLC" },
        { 0x00A070, "COASTCOM" },
        { 0x00A071, "VIDEO LOTTERY TECHNOLOGIES,INC" },
        { 0x00A072, "OVATION SYSTEMS LTD." },
        { 0x00A073, "COM21, INC." },
        { 0x00A074, "PERCEPTION TECHNOLOGY" },
        { 0x00A075, "MICRON TECHNOLOGY, INC." },
        { 0x00A076, "CARDWARE LAB, INC." },
        { 0x00A077, "FUJITSU NEXION, INC." },
        { 0x00A078, "Marconi Communications" },
        { 0x00A079, "ALPS ELECTRIC (USA), INC." },
        { 0x00A07A, "ADVANCED PERIPHERALS TECHNOLOGIES, INC." },
        { 0x00A07B, "DAWN COMPUTER INCORPORATION" },
        { 0x00A07C, "TONYANG NYLON CO., LTD." },
        { 0x00A07D, "SEEQ TECHNOLOGY, INC." },
        { 0x00A07E, "AVID TECHNOLOGY, INC." },
        { 0x00A07F, "GSM-SYNTEL, LTD." },
        { 0x00A080, "Tattile SRL" },
        { 0x00A081, "ALCATEL DATA NETWORKS" },
        { 0x00A082, "NKT ELEKTRONIK A/S" },
        { 0x00A083, "ASIMMPHONY TURKEY" },
        { 0x00A084, "Dataplex Pty Ltd" },
        { 0x00A085, "Private" },
        { 0x00A086, "AMBER WAVE SYSTEMS, INC." },
        { 0x00A087, "Microsemi Corporation" },
        { 0x00A088, "ESSENTIAL COMMUNICATIONS" },
        { 0x00A089, "XPOINT TECHNOLOGIES, INC." },
        { 0x00A08A, "BROOKTROUT TECHNOLOGY, INC." },
        { 0x00A08B, "ASTON ELECTRONIC DESIGNS LTD." },
        { 0x00A08C, "MultiMedia LANs, Inc." },
        { 0x00A08D, "JACOMO CORPORATION" },
        { 0x00A08E, "Check Point Software Technologies" },
        { 0x00A08F, "DESKNET SYSTEMS, INC." },
        { 0x00A090, "TimeStep Corporation" },
        { 0x00A091, "APPLICOM INTERNATIONAL" },
        { 0x00A092, "H. BOLLMANN MANUFACTURERS, LTD" },
        { 0x00A093, "B/E AEROSPACE, Inc." },
        { 0x00A094, "COMSAT CORPORATION" },
        { 0x00A095, "ACACIA NETWORKS, INC." },
        { 0x00A096, "MITSUMI ELECTRIC CO.,LTD." },
        { 0x00A097, "JC INFORMATION SYSTEMS" },
        { 0x00A098, "NetApp" },
        { 0x00A099, "K-NET LTD." },
        { 0x00A09A, "NIHON KOHDEN AMERICA" },
        { 0x00A09B, "QPSX COMMUNICATIONS, LTD." },
        { 0x00A09C, "Xyplex, Inc." },
        { 0x00A09D, "JOHNATHON FREEMAN TECHNOLOGIES" },
        { 0x00A09E, "ICTV" },
        { 0x00A09F, "COMMVISION CORP." },
        { 0x00A0A0, "COMPACT DATA, LTD." },
        { 0x00A0A1, "EPIC DATA INC." },
        { 0x00A0A2, "DIGICOM S.P.A." },
        { 0x00A0A3, "RELIABLE POWER METERS" },
        { 0x00A0A4, "Oracle Corporation" },
        { 0x00A0A5, "TEKNOR MICROSYSTEME, INC." },
        { 0x00A0A6, "M.I. SYSTEMS, K.K." },
        { 0x00A0A7, "VORAX CORPORATION" },
        { 0x00A0A8, "RENEX CORPORATION" },
        { 0x00A0A9, "NAVTEL COMMUNICATIONS INC." },
        { 0x00A0AA, "SPACELABS MEDICAL" },
        { 0x00A0AB, "NETCS INFORMATIONSTECHNIK GMBH" },
        { 0x00A0AC, "GILAT SATELLITE NETWORKS, LTD." },
        { 0x00A0AD, "MARCONI SPA" },
        { 0x00A0AE, "NUCOM SYSTEMS, INC." },
        { 0x00A0AF, "WMS INDUSTRIES" },
        { 0x00A0B0, "I-O DATA DEVICE,INC." },
        { 0x00A0B1, "FIRST VIRTUAL CORPORATION" },
        { 0x00A0B2, "SHIMA SEIKI" },
        { 0x00A0B3, "ZYKRONIX" },
        { 0x00A0B4, "TEXAS MICROSYSTEMS, INC." },
        { 0x00A0B5, "3H TECHNOLOGY" },
        { 0x00A0B6, "SANRITZ AUTOMATION CO., LTD." },
        { 0x00A0B7, "CORDANT, INC." },
        { 0x00A0B8, "NetApp" },
        { 0x00A0B9, "EAGLE TECHNOLOGY, INC." },
        { 0x00A0BA, "PATTON ELECTRONICS CO." },
        { 0x00A0BB, "HILAN GMBH" },
        { 0x00A0BC, "VIASAT, INCORPORATED" },
        { 0x00A0BD, "I-TECH CORP." },
        { 0x00A0BE, "INTEGRATED CIRCUIT SYSTEMS, INC. COMMUNICATIONS GROUP" },
        { 0x00A0BF, "WIRELESS DATA GROUP MOTOROLA" },
        { 0x00A0C0, "DIGITAL LINK CORP." },
        { 0x00A0C1, "ORTIVUS MEDICAL AB" },
        { 0x00A0C2, "R.A. SYSTEMS CO., LTD." },
        { 0x00A0C3, "UNICOMPUTER GMBH" },
        { 0x00A0C4, "CRISTIE ELECTRONICS LTD." },
        { 0x00A0C5, "Zyxel Communications Corporation" },
        { 0x00A0C6, "Qualcomm Inc." },
        { 0x00A0C7, "TADIRAN TELECOMMUNICATIONS" },
        { 0x00A0C8, "Adtran Inc" },
        { 0x00A0C9, "Intel Corporation" },
        { 0x00A0CA, "FUJITSU DENSO LTD." },
        { 0x00A0CB, "ARK TELECOMMUNICATIONS, INC." },
        { 0x00A0CC, "LITE-ON COMMUNICATIONS, INC." },
        { 0x00A0CD, "DR. JOHANNES HEIDENHAIN GmbH" },
        { 0x00A0CE, "Ecessa" },
        { 0x00A0CF, "SOTAS, INC." },
        { 0x00A0D0, "TEN X TECHNOLOGY, INC." },
        { 0x00A0D1, "INVENTEC CORPORATION" },
        { 0x00A0D2, "ALLIED TELESIS INTERNATIONAL CORPORATION" },
        { 0x00A0D3, "INSTEM COMPUTER SYSTEMS, LTD." },
        { 0x00A0D4, "RADIOLAN, INC." },
        { 0x00A0D5, "Sierra Wireless" },
        { 0x00A0D6, "SBE, Inc." },
        { 0x00A0D7, "KASTEN CHASE APPLIED RESEARCH" },
        { 0x00A0D8, "SPECTRA - TEK" },
        { 0x00A0D9, "CONVEX COMPUTER CORPORATION" },
        { 0x00A0DA, "INTEGRATED SYSTEMS Technology, Inc." },
        { 0x00A0DB, "FISHER & PAYKEL PRODUCTION" },
        { 0x00A0DC, "O.N. ELECTRONIC CO., LTD." },
        { 0x00A0DD, "AZONIX CORPORATION" },
        { 0x00A0DE, "YAMAHA CORPORATION" },
        { 0x00A0DF, "STS TECHNOLOGIES, INC." },
        { 0x00A0E0, "TENNYSON TECHNOLOGIES PTY LTD" },
        { 0x00A0E1, "WESTPORT RESEARCH ASSOCIATES, INC." },
        { 0x00A0E2, "Keisokugiken Corporation" },
        { 0x00A0E3, "XKL SYSTEMS CORP." },
        { 0x00A0E4, "OPTIQUEST" },
        { 0x00A0E5, "NHC COMMUNICATIONS" },
        { 0x00A0E6, "DIALOGIC CORPORATION" },
        { 0x00A0E7, "CENTRAL DATA CORPORATION" },
        { 0x00A0E8, "REUTERS HOLDINGS PLC" },
        { 0x00A0E9, "ELECTRONIC RETAILING SYSTEMS INTERNATIONAL" },
        { 0x00A0EA, "ETHERCOM CORP." },
        { 0x00A0EB, "Encore Networks, Inc." },
        { 0x00A0EC, "TRANSMITTON LTD." },
        { 0x00A0ED, "Brooks Automation, Inc." },
        { 0x00A0EE, "NASHOBA NETWORKS" },
        { 0x00A0EF, "LUCIDATA LTD." },
        { 0x00A0F0, "TORONTO MICROELECTRONICS INC." },
        { 0x00A0F1, "MTI" },
        { 0x00A0F2, "INFOTEK COMMUNICATIONS, INC." },
        { 0x00A0F3, "STAUBLI" },
        { 0x00A0F4, "GE" },
        { 0x00A0F5, "RADGUARD LTD." },
        { 0x00A0F6, "AutoGas Systems Inc." },
        { 0x00A0F7, "V.I COMPUTER CORP." },
        { 0x00A0F8, "Zebra Technologies Inc" },
        { 0x00A0F9, "BINTEC COMMUNICATIONS GMBH" },
        { 0x00A0FA, "Marconi Communication GmbH" },
        { 0x00A0FB, "TORAY ENGINEERING CO., LTD." },
        { 0x00A0FC, "IMAGE SCIENCES, INC." },
        { 0x00A0FD, "SCITEX DIGITAL PRINTING, INC." },
        { 0x00A0FE, "BOSTON TECHNOLOGY, INC." },
        { 0x00A0FF, "TELLABS OPERATIONS, INC." },
        { 0x00A1DE, "ShenZhen ShiHua Technology CO.,LTD" },
        { 0x00A289, "Cisco Systems, Inc" },
        { 0x00A2DA, "INAT GmbH" },
        { 0x00A2EE, "Cisco Systems, Inc" },
        { 0x00A2F5, "Guangzhou Yuanyun Network Technology Co.,Ltd" },
        { 0x00A2FF, "abatec group AG" },
        { 0x00A38E, "Cisco Systems, Inc" },
        { 0x00A3D1, "Cisco Systems, Inc" },
        { 0x00A509, "WigWag Inc." },
        { 0x00A5BF, "Cisco Systems, Inc" },
        { 0x00A6CA, "Cisco Systems, Inc" },
        { 0x00A742, "Cisco Systems, Inc" },
        { 0x00A784, "ITX security" },
        { 0x00AA00, "Intel Corporation" },
        { 0x00AA01, "Intel Corporation" },
        { 0x00AA02, "Intel Corporation" },
        { 0x00AA3C, "OLIVETTI TELECOM SPA (OLTECO)" },
        { 0x00AA6E, "Cisco Systems, Inc" },
        { 0x00AA70, "LG Electronics (Mobile Communications)" },
        { 0x00AB48, "eero inc." },
        { 0x00ACE0, "ARRIS Group, Inc." },
        { 0x00AD24, "D-Link International" },
        { 0x00AD63, "Dedicated Micros Malta LTD" },
        { 0x00ADD5, "Huawei Device Co., Ltd." },
        { 0x00AECD, "Pensando Systems" },
        { 0x00AEFA, "Murata Manufacturing Co., Ltd." },
        { 0x00AF1F, "Cisco Systems, Inc" },
        { 0x00B009, "Grass Valley, A Belden Brand" },
        { 0x00B017, "InfoGear Technology Corp." },
        { 0x00B019, "UTC CCS" },
        { 0x00B01C, "Westport Technologies" },
        { 0x00B01E, "Rantic Labs, Inc." },
        { 0x00B02A, "ORSYS GmbH" },
        { 0x00B02D, "ViaGate Technologies, Inc." },
        { 0x00B033, "OAO Izhevskiy radiozavod" },
        { 0x00B03B, "HiQ Networks" },
        { 0x00B048, "Marconi Communications Inc." },
        { 0x00B04A, "Cisco Systems, Inc" },
        { 0x00B052, "Atheros Communications" },
        { 0x00B064, "Cisco Systems, Inc" },
        { 0x00B069, "Honewell Oy" },
        { 0x00B06D, "Jones Futurex Inc." },
        { 0x00B080, "Mannesmann Ipulsys B.V." },
        { 0x00B086, "LocSoft Limited" },
        { 0x00B08E, "Cisco Systems, Inc" },
        { 0x00B091, "Transmeta Corp." },
        { 0x00B094, "Alaris, Inc." },
        { 0x00B09A, "Morrow Technologies Corp." },
        { 0x00B09D, "Point Grey Research Inc." },
        { 0x00B0AC, "SIAE-Microelettronica S.p.A." },
        { 0x00B0AE, "Symmetricom" },
        { 0x00B0B3, "XSTREAMIS PLC" },
        { 0x00B0C2, "Cisco Systems, Inc" },
        { 0x00B0C7, "Tellabs Operations, Inc." },
        { 0x00B0CE, "Viveris Technologies" },
        { 0x00B0D0, "Dell Inc." },
        { 0x00B0DB, "Nextcell, Inc." },
        { 0x00B0DF, "Starboard Storage Systems" },
        { 0x00B0E1, "Cisco Systems, Inc" },
        { 0x00B0E7, "British Federal Ltd." },
        { 0x00B0EC, "EACEM" },
        { 0x00B0EE, "Ajile Systems, Inc." },
        { 0x00B0F0, "CALY NETWORKS" },
        { 0x00B0F5, "NetWorth Technologies, Inc." },
        { 0x00B1E3, "Cisco Systems, Inc" },
        { 0x00B338, "Kontron Asia Pacific Design Sdn. Bhd" },
        { 0x00B342, "MacroSAN Technologies Co., Ltd." },
        { 0x00B362, "Apple, Inc." },
        { 0x00B4F5, "DongGuan Siyoto Electronics Co., Ltd" },
        { 0x00B56D, "David Electronics Co., LTD." },
        { 0x00B5D0, "Samsung Electronics Co.,Ltd" },
        { 0x00B5D6, "Omnibit Inc." },
        { 0x00B600, "VOIM Co., Ltd." },
        { 0x00B670, "Cisco Systems, Inc" },
        { 0x00B69F, "Latch" },
        { 0x00B771, "Cisco Systems, Inc" },
        { 0x00B78D, "Nanjing Shining Electric Automation Co., Ltd" },
        { 0x00B7A8, "Heinzinger electronic GmbH" },
        { 0x00B810, "Yichip Microelectronics (Hangzhou) Co.,Ltd" },
        { 0x00B881, "New platforms LLC" },
        { 0x00B8B3, "Cisco Systems, Inc" },
        { 0x00B8B6, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x00B8C2, "Heights Telecom T ltd" },
        { 0x00B9F6, "Shenzhen Super Rich Electronics Co.,Ltd" },
        { 0x00BAC0, "Biometric Access Company" },
        { 0x00BB01, "OCTOTHORPE CORP." },
        { 0x00BB1C, "Huawei Device Co., Ltd." },
        { 0x00BB3A, "Amazon Technologies Inc." },
        { 0x00BB60, "Intel Corporate" },
        { 0x00BB8E, "HME Co., Ltd." },
        { 0x00BBC1, "CANON INC." },
        { 0x00BBF0, "UNGERMANN-BASS INC." },
        { 0x00BC60, "Cisco Systems, Inc" },
        { 0x00BD27, "Exar Corp." },
        { 0x00BD3A, "Nokia Corporation" },
        { 0x00BD82, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x00BE3B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x00BE75, "Cisco Systems, Inc" },
        { 0x00BE9E, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x00BED5, "New H3C Technologies Co., Ltd" },
        { 0x00BF15, "Genetec Inc." },
        { 0x00BF61, "Samsung Electronics Co.,Ltd" },
        { 0x00BF77, "Cisco Systems, Inc" },
        { 0x00C000, "LANOPTICS, LTD." },
        { 0x00C001, "DIATEK PATIENT MANAGMENT" },
        { 0x00C002, "Sercomm Corporation." },
        { 0x00C003, "GLOBALNET COMMUNICATIONS" },
        { 0x00C004, "JAPAN BUSINESS COMPUTER CO.LTD" },
        { 0x00C005, "LIVINGSTON ENTERPRISES, INC." },
        { 0x00C006, "NIPPON AVIONICS CO., LTD." },
        { 0x00C007, "PINNACLE DATA SYSTEMS, INC." },
        { 0x00C008, "SECO SRL" },
        { 0x00C009, "KT TECHNOLOGY (S) PTE LTD" },
        { 0x00C00A, "MICRO CRAFT" },
        { 0x00C00B, "NORCONTROL A.S." },
        { 0x00C00C, "RELIA TECHNOLGIES" },
        { 0x00C00D, "ADVANCED LOGIC RESEARCH, INC." },
        { 0x00C00E, "PSITECH, INC." },
        { 0x00C00F, "QUANTUM SOFTWARE SYSTEMS LTD." },
        { 0x00C010, "HIRAKAWA HEWTECH CORP." },
        { 0x00C011, "INTERACTIVE COMPUTING DEVICES" },
        { 0x00C012, "NETSPAN CORPORATION" },
        { 0x00C013, "NETRIX" },
        { 0x00C014, "TELEMATICS CALABASAS INT'L,INC" },
        { 0x00C015, "NEW MEDIA CORPORATION" },
        { 0x00C016, "ELECTRONIC THEATRE CONTROLS" },
        { 0x00C017, "NetAlly" },
        { 0x00C018, "LANART CORPORATION" },
        { 0x00C019, "LEAP TECHNOLOGY, INC." },
        { 0x00C01A, "COROMETRICS MEDICAL SYSTEMS" },
        { 0x00C01B, "SOCKET COMMUNICATIONS, INC." },
        { 0x00C01C, "INTERLINK COMMUNICATIONS LTD." },
        { 0x00C01D, "GRAND JUNCTION NETWORKS, INC." },
        { 0x00C01E, "LA FRANCAISE DES JEUX" },
        { 0x00C01F, "S.E.R.C.E.L." },
        { 0x00C020, "ARCO ELECTRONIC, CONTROL LTD." },
        { 0x00C021, "NETEXPRESS" },
        { 0x00C022, "LASERMASTER TECHNOLOGIES, INC." },
        { 0x00C023, "TUTANKHAMON ELECTRONICS" },
        { 0x00C024, "EDEN SISTEMAS DE COMPUTACAO SA" },
        { 0x00C025, "DATAPRODUCTS CORPORATION" },
        { 0x00C026, "LANS TECHNOLOGY CO., LTD." },
        { 0x00C027, "CIPHER SYSTEMS, INC." },
        { 0x00C028, "JASCO CORPORATION" },
        { 0x00C029, "Nexans Deutschland GmbH - ANS" },
        { 0x00C02A, "OHKURA ELECTRIC CO., LTD." },
        { 0x00C02B, "GERLOFF GESELLSCHAFT FUR" },
        { 0x00C02C, "CENTRUM COMMUNICATIONS, INC." },
        { 0x00C02D, "FUJI PHOTO FILM CO., LTD." },
        { 0x00C02E, "NETWIZ" },
        { 0x00C02F, "OKUMA CORPORATION" },
        { 0x00C030, "INTEGRATED ENGINEERING B. V." },
        { 0x00C031, "DESIGN RESEARCH SYSTEMS, INC." },
        { 0x00C032, "I-CUBED LIMITED" },
        { 0x00C033, "TELEBIT COMMUNICATIONS APS" },
        { 0x00C034, "TRANSACTION NETWORK" },
        { 0x00C035, "QUINTAR COMPANY" },
        { 0x00C036, "RAYTECH ELECTRONIC CORP." },
        { 0x00C037, "DYNATEM" },
        { 0x00C038, "RASTER IMAGE PROCESSING SYSTEM" },
        { 0x00C039, "Teridian Semiconductor Corporation" },
        { 0x00C03A, "MEN-MIKRO ELEKTRONIK GMBH" },
        { 0x00C03B, "MULTIACCESS COMPUTING CORP." },
        { 0x00C03C, "TOWER TECH S.R.L." },
        { 0x00C03D, "WIESEMANN & THEIS GMBH" },
        { 0x00C03E, "FA. GEBR. HELLER GMBH" },
        { 0x00C03F, "STORES AUTOMATED SYSTEMS, INC." },
        { 0x00C040, "ECCI" },
        { 0x00C041, "DIGITAL TRANSMISSION SYSTEMS" },
        { 0x00C042, "DATALUX CORP." },
        { 0x00C043, "STRATACOM" },
        { 0x00C044, "EMCOM CORPORATION" },
        { 0x00C045, "ISOLATION SYSTEMS, LTD." },
        { 0x00C046, "Blue Chip Technology Ltd" },
        { 0x00C047, "UNIMICRO SYSTEMS, INC." },
        { 0x00C048, "BAY TECHNICAL ASSOCIATES" },
        { 0x00C049, "U.S. ROBOTICS, INC." },
        { 0x00C04A, "GROUP 2000 AG" },
        { 0x00C04B, "CREATIVE MICROSYSTEMS" },
        { 0x00C04C, "DEPARTMENT OF FOREIGN AFFAIRS" },
        { 0x00C04D, "MITEC, INC." },
        { 0x00C04E, "COMTROL CORPORATION" },
        { 0x00C04F, "Dell Inc." },
        { 0x00C050, "TOYO DENKI SEIZO K.K." },
        { 0x00C051, "ADVANCED INTEGRATION RESEARCH" },
        { 0x00C052, "BURR-BROWN" },
        { 0x00C053, "Aspect Software Inc." },
        { 0x00C054, "NETWORK PERIPHERALS, LTD." },
        { 0x00C055, "MODULAR COMPUTING TECHNOLOGIES" },
        { 0x00C056, "SOMELEC" },
        { 0x00C057, "MYCO ELECTRONICS" },
        { 0x00C058, "DATAEXPERT CORP." },
        { 0x00C059, "DENSO CORPORATION" },
        { 0x00C05A, "SEMAPHORE COMMUNICATIONS CORP." },
        { 0x00C05B, "NETWORKS NORTHWEST, INC." },
        { 0x00C05C, "ELONEX PLC" },
        { 0x00C05D, "L&N TECHNOLOGIES" },
        { 0x00C05E, "VARI-LITE, INC." },
        { 0x00C05F, "FINE-PAL COMPANY LIMITED" },
        { 0x00C060, "ID SCANDINAVIA AS" },
        { 0x00C061, "SOLECTEK CORPORATION" },
        { 0x00C062, "IMPULSE TECHNOLOGY" },
        { 0x00C063, "MORNING STAR TECHNOLOGIES, INC" },
        { 0x00C064, "General Datacomm LLC" },
        { 0x00C065, "SCOPE COMMUNICATIONS, INC." },
        { 0x00C066, "DOCUPOINT, INC." },
        { 0x00C067, "UNITED BARCODE INDUSTRIES" },
        { 0x00C068, "HME Clear-Com LTD." },
        { 0x00C069, "Axxcelera Broadband Wireless" },
        { 0x00C06A, "ZAHNER-ELEKTRIK GMBH & CO. KG" },
        { 0x00C06B, "OSI PLUS CORPORATION" },
        { 0x00C06C, "SVEC COMPUTER CORP." },
        { 0x00C06D, "BOCA RESEARCH, INC." },
        { 0x00C06E, "HAFT TECHNOLOGY, INC." },
        { 0x00C06F, "KOMATSU LTD." },
        { 0x00C070, "SECTRA SECURE-TRANSMISSION AB" },
        { 0x00C071, "AREANEX COMMUNICATIONS, INC." },
        { 0x00C072, "KNX LTD." },
        { 0x00C073, "XEDIA CORPORATION" },
        { 0x00C074, "TOYODA AUTOMATIC LOOM" },
        { 0x00C075, "XANTE CORPORATION" },
        { 0x00C076, "I-DATA INTERNATIONAL A-S" },
        { 0x00C077, "DAEWOO TELECOM LTD." },
        { 0x00C078, "COMPUTER SYSTEMS ENGINEERING" },
        { 0x00C079, "FONSYS CO.,LTD." },
        { 0x00C07A, "PRIVA B.V." },
        { 0x00C07B, "ASCEND COMMUNICATIONS, INC." },
        { 0x00C07C, "HIGHTECH INFORMATION" },
        { 0x00C07D, "RISC DEVELOPMENTS LTD." },
        { 0x00C07E, "KUBOTA CORPORATION ELECTRONIC" },
        { 0x00C07F, "NUPON COMPUTING CORP." },
        { 0x00C080, "NETSTAR, INC." },
        { 0x00C081, "METRODATA LTD." },
        { 0x00C082, "MOORE PRODUCTS CO." },
        { 0x00C083, "TRACE MOUNTAIN PRODUCTS, INC." },
        { 0x00C084, "DATA LINK CORP. LTD." },
        { 0x00C085, "ELECTRONICS FOR IMAGING, INC." },
        { 0x00C086, "THE LYNK CORPORATION" },
        { 0x00C087, "UUNET TECHNOLOGIES, INC." },
        { 0x00C088, "EKF ELEKTRONIK GMBH" },
        { 0x00C089, "TELINDUS DISTRIBUTION" },
        { 0x00C08A, "Lauterbach GmbH" },
        { 0x00C08B, "RISQ MODULAR SYSTEMS, INC." },
        { 0x00C08C, "PERFORMANCE TECHNOLOGIES, INC." },
        { 0x00C08D, "TRONIX PRODUCT DEVELOPMENT" },
        { 0x00C08E, "NETWORK INFORMATION TECHNOLOGY" },
        { 0x00C08F, "Panasonic Electric Works Co., Ltd." },
        { 0x00C090, "PRAIM S.R.L." },
        { 0x00C091, "JABIL CIRCUIT, INC." },
        { 0x00C092, "MENNEN MEDICAL INC." },
        { 0x00C093, "ALTA RESEARCH CORP." },
        { 0x00C094, "VMX INC." },
        { 0x00C095, "ZNYX Networks, Inc." },
        { 0x00C096, "TAMURA CORPORATION" },
        { 0x00C097, "ARCHIPEL SA" },
        { 0x00C098, "CHUNTEX ELECTRONIC CO., LTD." },
        { 0x00C099, "YOSHIKI INDUSTRIAL CO.,LTD." },
        { 0x00C09A, "PHOTONICS CORPORATION" },
        { 0x00C09B, "RELIANCE COMM/TEC, R-TEC" },
        { 0x00C09C, "HIOKI E.E. CORPORATION" },
        { 0x00C09D, "DISTRIBUTED SYSTEMS INT'L, INC" },
        { 0x00C09E, "CACHE COMPUTERS, INC." },
        { 0x00C09F, "Quanta Computer Inc." },
        { 0x00C0A0, "ADVANCE MICRO RESEARCH, INC." },
        { 0x00C0A1, "TOKYO DENSHI SEKEI CO." },
        { 0x00C0A2, "INTERMEDIUM A/S" },
        { 0x00C0A3, "DUAL ENTERPRISES CORPORATION" },
        { 0x00C0A4, "UNIGRAF OY" },
        { 0x00C0A5, "DICKENS DATA SYSTEMS" },
        { 0x00C0A6, "EXICOM AUSTRALIA PTY. LTD" },
        { 0x00C0A7, "SEEL LTD." },
        { 0x00C0A8, "GVC CORPORATION" },
        { 0x00C0A9, "BARRON MCCANN LTD." },
        { 0x00C0AA, "SILICON VALLEY COMPUTER" },
        { 0x00C0AB, "Telco Systems, Inc." },
        { 0x00C0AC, "GAMBIT COMPUTER COMMUNICATIONS" },
        { 0x00C0AD, "MARBEN COMMUNICATION SYSTEMS" },
        { 0x00C0AE, "TOWERCOM CO. INC. DBA PC HOUSE" },
        { 0x00C0AF, "TEKLOGIX INC." },
        { 0x00C0B0, "GCC TECHNOLOGIES,INC." },
        { 0x00C0B1, "GENIUS NET CO." },
        { 0x00C0B2, "NORAND CORPORATION" },
        { 0x00C0B3, "COMSTAT DATACOMM CORPORATION" },
        { 0x00C0B4, "MYSON TECHNOLOGY, INC." },
        { 0x00C0B5, "CORPORATE NETWORK SYSTEMS,INC." },
        { 0x00C0B6, "HVE, Inc." },
        { 0x00C0B7, "AMERICAN POWER CONVERSION CORP" },
        { 0x00C0B8, "FRASER'S HILL LTD." },
        { 0x00C0B9, "FUNK SOFTWARE, INC." },
        { 0x00C0BA, "NETVANTAGE" },
        { 0x00C0BB, "FORVAL CREATIVE, INC." },
        { 0x00C0BC, "TELECOM AUSTRALIA/CSSC" },
        { 0x00C0BD, "INEX TECHNOLOGIES, INC." },
        { 0x00C0BE, "ALCATEL - SEL" },
        { 0x00C0BF, "TECHNOLOGY CONCEPTS, LTD." },
        { 0x00C0C0, "SHORE MICROSYSTEMS, INC." },
        { 0x00C0C1, "QUAD/GRAPHICS, INC." },
        { 0x00C0C2, "INFINITE NETWORKS LTD." },
        { 0x00C0C3, "ACUSON COMPUTED SONOGRAPHY" },
        { 0x00C0C4, "COMPUTER OPERATIONAL" },
        { 0x00C0C5, "SID INFORMATICA" },
        { 0x00C0C6, "PERSONAL MEDIA CORP." },
        { 0x00C0C7, "SPARKTRUM MICROSYSTEMS, INC." },
        { 0x00C0C8, "MICRO BYTE PTY. LTD." },
        { 0x00C0C9, "ELSAG BAILEY PROCESS" },
        { 0x00C0CA, "ALFA, INC." },
        { 0x00C0CB, "CONTROL TECHNOLOGY CORPORATION" },
        { 0x00C0CC, "TELESCIENCES CO SYSTEMS, INC." },
        { 0x00C0CD, "COMELTA, S.A." },
        { 0x00C0CE, "CEI SYSTEMS & ENGINEERING PTE" },
        { 0x00C0CF, "IMATRAN VOIMA OY" },
        { 0x00C0D0, "RATOC SYSTEM INC." },
        { 0x00C0D1, "COMTREE TECHNOLOGY CORPORATION" },
        { 0x00C0D2, "SYNTELLECT, INC." },
        { 0x00C0D3, "OLYMPUS IMAGE SYSTEMS, INC." },
        { 0x00C0D4, "AXON NETWORKS, INC." },
        { 0x00C0D5, "Werbeagentur Jürgen Siebert" },
        { 0x00C0D6, "J1 SYSTEMS, INC." },
        { 0x00C0D7, "TAIWAN TRADING CENTER DBA" },
        { 0x00C0D8, "UNIVERSAL DATA SYSTEMS" },
        { 0x00C0D9, "QUINTE NETWORK CONFIDENTIALITY" },
        { 0x00C0DA, "NICE SYSTEMS LTD." },
        { 0x00C0DB, "IPC CORPORATION (PTE) LTD." },
        { 0x00C0DC, "EOS TECHNOLOGIES, INC." },
        { 0x00C0DD, "QLogic Corporation" },
        { 0x00C0DE, "ZCOMM, INC." },
        { 0x00C0DF, "KYE Systems Corp." },
        { 0x00C0E0, "DSC COMMUNICATION CORP." },
        { 0x00C0E1, "SONIC SOLUTIONS" },
        { 0x00C0E2, "CALCOMP, INC." },
        { 0x00C0E3, "OSITECH COMMUNICATIONS, INC." },
        { 0x00C0E4, "SIEMENS BUILDING" },
        { 0x00C0E5, "GESPAC, S.A." },
        { 0x00C0E6, "Verilink Corporation" },
        { 0x00C0E7, "FIBERDATA AB" },
        { 0x00C0E8, "PLEXCOM, INC." },
        { 0x00C0E9, "OAK SOLUTIONS, LTD." },
        { 0x00C0EA, "ARRAY TECHNOLOGY LTD." },
        { 0x00C0EB, "SEH COMPUTERTECHNIK GMBH" },
        { 0x00C0EC, "DAUPHIN TECHNOLOGY" },
        { 0x00C0ED, "US ARMY ELECTRONIC" },
        { 0x00C0EE, "KYOCERA Display Corporation" },
        { 0x00C0EF, "ABIT CORPORATION" },
        { 0x00C0F0, "Kingston Technology Company, Inc." },
        { 0x00C0F1, "SHINKO ELECTRIC CO., LTD." },
        { 0x00C0F2, "TRANSITION NETWORKS" },
        { 0x00C0F3, "NETWORK COMMUNICATIONS CORP." },
        { 0x00C0F4, "INTERLINK SYSTEM CO., LTD." },
        { 0x00C0F5, "METACOMP, INC." },
        { 0x00C0F6, "CELAN TECHNOLOGY INC." },
        { 0x00C0F7, "ENGAGE COMMUNICATION, INC." },
        { 0x00C0F8, "ABOUT COMPUTING INC." },
        { 0x00C0F9, "Artesyn Embedded Technologies" },
        { 0x00C0FA, "CANARY COMMUNICATIONS, INC." },
        { 0x00C0FB, "ADVANCED TECHNOLOGY LABS" },
        { 0x00C0FC, "ELASTIC REALITY, INC." },
        { 0x00C0FD, "PROSUM" },
        { 0x00C0FE, "APTEC COMPUTER SYSTEMS, INC." },
        { 0x00C0FF, "Seagate Cloud Systems Inc" },
        { 0x00C14F, "DDL Co,.ltd." },
        { 0x00C164, "Cisco Systems, Inc" },
        { 0x00C1B1, "Cisco Systems, Inc" },
        { 0x00C2C6, "Intel Corporate" },
        { 0x00C343, "E-T-A Circuit Breakers Ltd" },
        { 0x00C3F4, "Samsung Electronics Co.,Ltd" },
        { 0x00C52C, "Juniper Networks" },
        { 0x00C5DB, "Datatech Sistemas Digitales Avanzados SL" },
        { 0x00C610, "Apple, Inc." },
        { 0x00C88B, "Cisco Systems, Inc" },
        { 0x00CAE5, "Cisco Systems, Inc" },
        { 0x00CB00, "Private" },
        { 0x00CB51, "Sagemcom Broadband SAS" },
        { 0x00CBB4, "SHENZHEN ATEKO PHOTOELECTRICITY CO.,LTD" },
        { 0x00CBBD, "Cambridge Broadband Networks Group" },
        { 0x00CC3F, "Universal Electronics, Inc." },
        { 0x00CCFC, "Cisco Systems, Inc" },
        { 0x00CD90, "MAS Elektronik AG" },
        { 0x00CDFE, "Apple, Inc." },
        { 0x00CF1C, "Communication Machinery Corporation" },
        { 0x00CFC0, "China Mobile Group Device Co.,Ltd." },
        { 0x00D000, "FERRAN SCIENTIFIC, INC." },
        { 0x00D001, "VST TECHNOLOGIES, INC." },
        { 0x00D002, "DITECH CORPORATION" },
        { 0x00D003, "COMDA ENTERPRISES CORP." },
        { 0x00D004, "PENTACOM LTD." },
        { 0x00D005, "ZHS ZEITMANAGEMENTSYSTEME" },
        { 0x00D006, "Cisco Systems, Inc" },
        { 0x00D007, "MIC ASSOCIATES, INC." },
        { 0x00D008, "MACTELL CORPORATION" },
        { 0x00D009, "HSING TECH. ENTERPRISE CO. LTD" },
        { 0x00D00A, "LANACCESS TELECOM S.A." },
        { 0x00D00B, "RHK TECHNOLOGY, INC." },
        { 0x00D00C, "SNIJDER MICRO SYSTEMS" },
        { 0x00D00D, "MICROMERITICS INSTRUMENT" },
        { 0x00D00E, "PLURIS, INC." },
        { 0x00D00F, "SPEECH DESIGN GMBH" },
        { 0x00D010, "CONVERGENT NETWORKS, INC." },
        { 0x00D011, "PRISM VIDEO, INC." },
        { 0x00D012, "GATEWORKS CORP." },
        { 0x00D013, "PRIMEX AEROSPACE COMPANY" },
        { 0x00D014, "ROOT, INC." },
        { 0x00D015, "UNIVEX MICROTECHNOLOGY CORP." },
        { 0x00D016, "SCM MICROSYSTEMS, INC." },
        { 0x00D017, "SYNTECH INFORMATION CO., LTD." },
        { 0x00D018, "QWES. COM, INC." },
        { 0x00D019, "DAINIPPON SCREEN CORPORATE" },
        { 0x00D01A, "URMET TLC S.P.A." },
        { 0x00D01B, "MIMAKI ENGINEERING CO., LTD." },
        { 0x00D01C, "SBS TECHNOLOGIES," },
        { 0x00D01D, "FURUNO ELECTRIC CO., LTD." },
        { 0x00D01E, "PINGTEL CORP." },
        { 0x00D01F, "Senetas Corporation Ltd" },
        { 0x00D020, "AIM SYSTEM, INC." },
        { 0x00D021, "REGENT ELECTRONICS CORP." },
        { 0x00D022, "INCREDIBLE TECHNOLOGIES, INC." },
        { 0x00D023, "INFORTREND TECHNOLOGY, INC." },
        { 0x00D024, "Cognex Corporation" },
        { 0x00D025, "XROSSTECH, INC." },
        { 0x00D026, "HIRSCHMANN AUSTRIA GMBH" },
        { 0x00D027, "APPLIED AUTOMATION, INC." },
        { 0x00D028, "Harmonic, Inc" },
        { 0x00D029, "WAKEFERN FOOD CORPORATION" },
        { 0x00D02A, "Voxent Systems Ltd." },
        { 0x00D02B, "JETCELL, INC." },
        { 0x00D02C, "CAMPBELL SCIENTIFIC, INC." },
        { 0x00D02D, "Resideo" },
        { 0x00D02E, "COMMUNICATION AUTOMATION CORP." },
        { 0x00D02F, "VLSI TECHNOLOGY INC." },
        { 0x00D030, "Safetran Systems Corp" },
        { 0x00D031, "INDUSTRIAL LOGIC CORPORATION" },
        { 0x00D032, "YANO ELECTRIC CO., LTD." },
        { 0x00D033, "DALIAN DAXIAN NETWORK" },
        { 0x00D034, "ORMEC SYSTEMS CORP." },
        { 0x00D035, "BEHAVIOR TECH. COMPUTER CORP." },
        { 0x00D036, "TECHNOLOGY ATLANTA CORP." },
        { 0x00D037, "ARRIS Group, Inc." },
        { 0x00D038, "FIVEMERE, LTD." },
        { 0x00D039, "UTILICOM, INC." },
        { 0x00D03A, "ZONEWORX, INC." },
        { 0x00D03B, "VISION PRODUCTS PTY. LTD." },
        { 0x00D03C, "Vieo, Inc." },
        { 0x00D03D, "GALILEO TECHNOLOGY, LTD." },
        { 0x00D03E, "ROCKETCHIPS, INC." },
        { 0x00D03F, "AMERICAN COMMUNICATION" },
        { 0x00D040, "SYSMATE CO., LTD." },
        { 0x00D041, "AMIGO TECHNOLOGY CO., LTD." },
        { 0x00D042, "MAHLO GMBH & CO. UG" },
        { 0x00D043, "ZONAL RETAIL DATA SYSTEMS" },
        { 0x00D044, "ALIDIAN NETWORKS, INC." },
        { 0x00D045, "KVASER AB" },
        { 0x00D046, "DOLBY LABORATORIES, INC." },
        { 0x00D047, "XN TECHNOLOGIES" },
        { 0x00D048, "ECTON, INC." },
        { 0x00D049, "IMPRESSTEK CO., LTD." },
        { 0x00D04A, "PRESENCE TECHNOLOGY GMBH" },
        { 0x00D04B, "LA CIE GROUP S.A." },
        { 0x00D04C, "EUROTEL TELECOM LTD." },
        { 0x00D04D, "DIV OF RESEARCH & STATISTICS" },
        { 0x00D04E, "LOGIBAG" },
        { 0x00D04F, "BITRONICS, INC." },
        { 0x00D050, "Iskratel d.o.o." },
        { 0x00D051, "O2 MICRO, INC." },
        { 0x00D052, "ASCEND COMMUNICATIONS, INC." },
        { 0x00D053, "CONNECTED SYSTEMS" },
        { 0x00D054, "SAS INSTITUTE INC." },
        { 0x00D055, "KATHREIN-WERKE KG" },
        { 0x00D056, "SOMAT CORPORATION" },
        { 0x00D057, "ULTRAK, INC." },
        { 0x00D058, "Cisco Systems, Inc" },
        { 0x00D059, "AMBIT MICROSYSTEMS CORP." },
        { 0x00D05A, "SYMBIONICS, LTD." },
        { 0x00D05B, "ACROLOOP MOTION CONTROL" },
        { 0x00D05C, "KATHREIN TechnoTrend GmbH" },
        { 0x00D05D, "INTELLIWORXX, INC." },
        { 0x00D05E, "STRATABEAM TECHNOLOGY, INC." },
        { 0x00D05F, "VALCOM, INC." },
        { 0x00D060, "Panasonic Europe Ltd." },
        { 0x00D061, "TREMON ENTERPRISES CO., LTD." },
        { 0x00D062, "DIGIGRAM" },
        { 0x00D063, "Cisco Systems, Inc" },
        { 0x00D064, "MULTITEL" },
        { 0x00D065, "TOKO ELECTRIC" },
        { 0x00D066, "WINTRISS ENGINEERING CORP." },
        { 0x00D067, "CAMPIO COMMUNICATIONS" },
        { 0x00D068, "IWILL CORPORATION" },
        { 0x00D069, "TECHNOLOGIC SYSTEMS" },
        { 0x00D06A, "LINKUP SYSTEMS CORPORATION" },
        { 0x00D06B, "SR TELECOM INC." },
        { 0x00D06C, "SHAREWAVE, INC." },
        { 0x00D06D, "ACRISON, INC." },
        { 0x00D06E, "TRENDVIEW RECORDERS LTD." },
        { 0x00D06F, "KMC CONTROLS" },
        { 0x00D070, "LONG WELL ELECTRONICS CORP." },
        { 0x00D071, "ECHELON CORP." },
        { 0x00D072, "BROADLOGIC" },
        { 0x00D073, "ACN ADVANCED COMMUNICATIONS" },
        { 0x00D074, "TAQUA SYSTEMS, INC." },
        { 0x00D075, "ALARIS MEDICAL SYSTEMS, INC." },
        { 0x00D076, "Bank of America" },
        { 0x00D077, "LUCENT TECHNOLOGIES" },
        { 0x00D078, "Eltex of Sweden AB" },
        { 0x00D079, "Cisco Systems, Inc" },
        { 0x00D07A, "AMAQUEST COMPUTER CORP." },
        { 0x00D07B, "COMCAM INTERNATIONAL INC" },
        { 0x00D07C, "KOYO ELECTRONICS INC. CO.,LTD." },
        { 0x00D07D, "COSINE COMMUNICATIONS" },
        { 0x00D07E, "KEYCORP LTD." },
        { 0x00D07F, "STRATEGY & TECHNOLOGY, LIMITED" },
        { 0x00D080, "EXABYTE CORPORATION" },
        { 0x00D081, "RTD Embedded Technologies, Inc." },
        { 0x00D082, "IOWAVE INC." },
        { 0x00D083, "INVERTEX, INC." },
        { 0x00D084, "NEXCOMM SYSTEMS, INC." },
        { 0x00D085, "OTIS ELEVATOR COMPANY" },
        { 0x00D086, "FOVEON, INC." },
        { 0x00D087, "MICROFIRST INC." },
        { 0x00D088, "ARRIS Group, Inc." },
        { 0x00D089, "DYNACOLOR, INC." },
        { 0x00D08A, "PHOTRON USA" },
        { 0x00D08B, "ADVA Optical Networking Ltd." },
        { 0x00D08C, "GENOA TECHNOLOGY, INC." },
        { 0x00D08D, "PHOENIX GROUP, INC." },
        { 0x00D08E, "Grass Valley, A Belden Brand" },
        { 0x00D08F, "ARDENT TECHNOLOGIES, INC." },
        { 0x00D090, "Cisco Systems, Inc" },
        { 0x00D091, "SMARTSAN SYSTEMS, INC." },
        { 0x00D092, "GLENAYRE WESTERN MULTIPLEX" },
        { 0x00D093, "TQ - COMPONENTS GMBH" },
        { 0x00D094, "Seeion Control LLC" },
        { 0x00D095, "Alcatel-Lucent Enterprise" },
        { 0x00D096, "3COM EUROPE LTD" },
        { 0x00D097, "Cisco Systems, Inc" },
        { 0x00D098, "Photon Dynamics Canada Inc." },
        { 0x00D099, "Elcard Wireless Systems Oy" },
        { 0x00D09A, "FILANET CORPORATION" },
        { 0x00D09B, "SPECTEL LTD." },
        { 0x00D09C, "KAPADIA COMMUNICATIONS" },
        { 0x00D09D, "VERIS INDUSTRIES" },
        { 0x00D09E, "2Wire Inc" },
        { 0x00D09F, "NOVTEK TEST SYSTEMS" },
        { 0x00D0A0, "MIPS DENMARK" },
        { 0x00D0A1, "OSKAR VIERLING GMBH + CO. KG" },
        { 0x00D0A2, "INTEGRATED DEVICE" },
        { 0x00D0A3, "VOCAL DATA, INC." },
        { 0x00D0A4, "ALANTRO COMMUNICATIONS" },
        { 0x00D0A5, "AMERICAN ARIUM" },
        { 0x00D0A6, "LANBIRD TECHNOLOGY CO., LTD." },
        { 0x00D0A7, "TOKYO SOKKI KENKYUJO CO., LTD." },
        { 0x00D0A8, "NETWORK ENGINES, INC." },
        { 0x00D0A9, "SHINANO KENSHI CO., LTD." },
        { 0x00D0AA, "CHASE COMMUNICATIONS" },
        { 0x00D0AB, "DELTAKABEL TELECOM CV" },
        { 0x00D0AC, "Commscope, Inc" },
        { 0x00D0AD, "TL INDUSTRIES" },
        { 0x00D0AE, "ORESIS COMMUNICATIONS, INC." },
        { 0x00D0AF, "CUTLER-HAMMER, INC." },
        { 0x00D0B0, "BITSWITCH LTD." },
        { 0x00D0B1, "OMEGA ELECTRONICS SA" },
        { 0x00D0B2, "Xiotech Corporation" },
        { 0x00D0B3, "DRS Technologies Canada Ltd" },
        { 0x00D0B4, "KATSUJIMA CO., LTD." },
        { 0x00D0B5, "IPricot formerly DotCom" },
        { 0x00D0B6, "CRESCENT NETWORKS, INC." },
        { 0x00D0B7, "Intel Corporation" },
        { 0x00D0B8, "Iomega Corporation" },
        { 0x00D0B9, "MICROTEK INTERNATIONAL, INC." },
        { 0x00D0BA, "Cisco Systems, Inc" },
        { 0x00D0BB, "Cisco Systems, Inc" },
        { 0x00D0BC, "Cisco Systems, Inc" },
        { 0x00D0BD, "Lattice Semiconductor Corp. (LPA)" },
        { 0x00D0BE, "EMUTEC INC." },
        { 0x00D0BF, "PIVOTAL TECHNOLOGIES" },
        { 0x00D0C0, "Cisco Systems, Inc" },
        { 0x00D0C1, "HARMONIC DATA SYSTEMS, LTD." },
        { 0x00D0C2, "BALTHAZAR TECHNOLOGY AB" },
        { 0x00D0C3, "VIVID TECHNOLOGY PTE, LTD." },
        { 0x00D0C4, "TERATECH CORPORATION" },
        { 0x00D0C5, "COMPUTATIONAL SYSTEMS, INC." },
        { 0x00D0C6, "THOMAS & BETTS CORP." },
        { 0x00D0C7, "PATHWAY, INC." },
        { 0x00D0C8, "Prevas A/S" },
        { 0x00D0C9, "ADVANTECH CO., LTD." },
        { 0x00D0CA, "Intrinsyc Software International Inc." },
        { 0x00D0CB, "DASAN CO., LTD." },
        { 0x00D0CC, "TECHNOLOGIES LYRE INC." },
        { 0x00D0CD, "ATAN TECHNOLOGY INC." },
        { 0x00D0CE, "iSystem Labs" },
        { 0x00D0CF, "MORETON BAY" },
        { 0x00D0D0, "ZHONGXING TELECOM LTD." },
        { 0x00D0D1, "Sycamore Networks" },
        { 0x00D0D2, "EPILOG CORPORATION" },
        { 0x00D0D3, "Cisco Systems, Inc" },
        { 0x00D0D4, "V-BITS, INC." },
        { 0x00D0D5, "GRUNDIG AG" },
        { 0x00D0D6, "AETHRA TELECOMUNICAZIONI" },
        { 0x00D0D7, "B2C2, INC." },
        { 0x00D0D8, "3COM" },
        { 0x00D0D9, "DEDICATED MICROCOMPUTERS" },
        { 0x00D0DA, "TAICOM DATA SYSTEMS CO., LTD." },
        { 0x00D0DB, "MCQUAY INTERNATIONAL" },
        { 0x00D0DC, "MODULAR MINING SYSTEMS, INC." },
        { 0x00D0DD, "SUNRISE TELECOM, INC." },
        { 0x00D0DE, "PHILIPS MULTIMEDIA NETWORK" },
        { 0x00D0DF, "KUZUMI ELECTRONICS, INC." },
        { 0x00D0E0, "DOOIN ELECTRONICS CO." },
        { 0x00D0E1, "AVIONITEK ISRAEL INC." },
        { 0x00D0E2, "MRT MICRO, INC." },
        { 0x00D0E3, "ELE-CHEM ENGINEERING CO., LTD." },
        { 0x00D0E4, "Cisco Systems, Inc" },
        { 0x00D0E5, "SOLIDUM SYSTEMS CORP." },
        { 0x00D0E6, "IBOND INC." },
        { 0x00D0E7, "VCON TELECOMMUNICATION LTD." },
        { 0x00D0E8, "MAC SYSTEM CO., LTD." },
        { 0x00D0E9, "Advantage Century Telecommunication Corp." },
        { 0x00D0EA, "NEXTONE COMMUNICATIONS, INC." },
        { 0x00D0EB, "LIGHTERA NETWORKS, INC." },
        { 0x00D0EC, "NAKAYO Inc" },
        { 0x00D0ED, "XIOX" },
        { 0x00D0EE, "DICTAPHONE CORPORATION" },
        { 0x00D0EF, "IGT" },
        { 0x00D0F0, "CONVISION TECHNOLOGY GMBH" },
        { 0x00D0F1, "SEGA ENTERPRISES, LTD." },
        { 0x00D0F2, "MONTEREY NETWORKS" },
        { 0x00D0F3, "SOLARI DI UDINE SPA" },
        { 0x00D0F4, "CARINTHIAN TECH INSTITUTE" },
        { 0x00D0F5, "ORANGE MICRO, INC." },
        { 0x00D0F6, "Nokia" },
        { 0x00D0F7, "NEXT NETS CORPORATION" },
        { 0x00D0F8, "FUJIAN STAR TERMINAL" },
        { 0x00D0F9, "ACUTE COMMUNICATIONS CORP." },
        { 0x00D0FA, "Thales e-Security Ltd." },
        { 0x00D0FB, "TEK MICROSYSTEMS, INCORPORATED" },
        { 0x00D0FC, "GRANITE MICROSYSTEMS" },
        { 0x00D0FD, "OPTIMA TELE.COM, INC." },
        { 0x00D0FE, "ASTRAL POINT" },
        { 0x00D0FF, "Cisco Systems, Inc" },
        { 0x00D11C, "ACETEL" },
        { 0x00D279, "VINGROUP JOINT STOCK COMPANY" },
        { 0x00D2B1, "TPV Display Technology (Xiamen) Co.,Ltd." },
        { 0x00D318, "SPG Controls" },
        { 0x00D38D, "Hotel Technology Next Generation" },
        { 0x00D632, "GE Energy" },
        { 0x00D6FE, "Cisco Systems, Inc" },
        { 0x00D78F, "Cisco Systems, Inc" },
        { 0x00D861, "Micro-Star INTL CO., LTD." },
        { 0x00D9D1, "Sony Interactive Entertainment Inc." },
        { 0x00DA55, "Cisco Systems, Inc" },
        { 0x00DB1E, "Albedo Telecom SL" },
        { 0x00DB45, "THAMWAY CO.,LTD." },
        { 0x00DB70, "Apple, Inc." },
        { 0x00DBDF, "Intel Corporate" },
        { 0x00DD00, "UNGERMANN-BASS INC." },
        { 0x00DD01, "UNGERMANN-BASS INC." },
        { 0x00DD02, "UNGERMANN-BASS INC." },
        { 0x00DD03, "UNGERMANN-BASS INC." },
        { 0x00DD04, "UNGERMANN-BASS INC." },
        { 0x00DD05, "UNGERMANN-BASS INC." },
        { 0x00DD06, "UNGERMANN-BASS INC." },
        { 0x00DD07, "UNGERMANN-BASS INC." },
        { 0x00DD08, "UNGERMANN-BASS INC." },
        { 0x00DD09, "UNGERMANN-BASS INC." },
        { 0x00DD0A, "UNGERMANN-BASS INC." },
        { 0x00DD0B, "UNGERMANN-BASS INC." },
        { 0x00DD0C, "UNGERMANN-BASS INC." },
        { 0x00DD0D, "UNGERMANN-BASS INC." },
        { 0x00DD0E, "UNGERMANN-BASS INC." },
        { 0x00DD0F, "UNGERMANN-BASS INC." },
        { 0x00DD25, "Shenzhen hechengdong Technology Co., Ltd" },
        { 0x00DEFB, "Cisco Systems, Inc" },
        { 0x00E000, "FUJITSU LIMITED" },
        { 0x00E001, "STRAND LIGHTING LIMITED" },
        { 0x00E002, "CROSSROADS SYSTEMS, INC." },
        { 0x00E003, "NOKIA WIRELESS BUSINESS COMMUN" },
        { 0x00E004, "PMC-SIERRA, INC." },
        { 0x00E005, "TECHNICAL CORP." },
        { 0x00E006, "SILICON INTEGRATED SYS. CORP." },
        { 0x00E007, "Avaya ECS Ltd" },
        { 0x00E008, "AMAZING CONTROLS! INC." },
        { 0x00E009, "Stratus Technologies" },
        { 0x00E00A, "DIBA, INC." },
        { 0x00E00B, "ROOFTOP COMMUNICATIONS CORP." },
        { 0x00E00C, "MOTOROLA" },
        { 0x00E00D, "RADIANT SYSTEMS" },
        { 0x00E00E, "AVALON IMAGING SYSTEMS, INC." },
        { 0x00E00F, "Shanghai Baud Data Communication Co.,Ltd." },
        { 0x00E010, "HESS SB-AUTOMATENBAU GmbH" },
        { 0x00E011, "UNIDEN CORPORATION" },
        { 0x00E012, "PLUTO TECHNOLOGIES INTERNATIONAL INC." },
        { 0x00E013, "EASTERN ELECTRONIC CO., LTD." },
        { 0x00E014, "Cisco Systems, Inc" },
        { 0x00E015, "HEIWA CORPORATION" },
        { 0x00E016, "RAPID CITY COMMUNICATIONS" },
        { 0x00E017, "EXXACT GmbH" },
        { 0x00E018, "ASUSTek COMPUTER INC." },
        { 0x00E019, "ING. GIORDANO ELETTRONICA" },
        { 0x00E01A, "COMTEC SYSTEMS. CO., LTD." },
        { 0x00E01B, "SPHERE COMMUNICATIONS, INC." },
        { 0x00E01C, "Cradlepoint, Inc" },
        { 0x00E01D, "WebTV NETWORKS, INC." },
        { 0x00E01E, "Cisco Systems, Inc" },
        { 0x00E01F, "AVIDIA Systems, Inc." },
        { 0x00E020, "TECNOMEN OY" },
        { 0x00E021, "FREEGATE CORP." },
        { 0x00E022, "Analog Devices, Inc." },
        { 0x00E023, "TELRAD" },
        { 0x00E024, "GADZOOX NETWORKS" },
        { 0x00E025, "dit Co., Ltd." },
        { 0x00E026, "Redlake MASD LLC" },
        { 0x00E027, "DUX, INC." },
        { 0x00E028, "APTIX CORPORATION" },
        { 0x00E029, "STANDARD MICROSYSTEMS CORP." },
        { 0x00E02A, "TANDBERG TELEVISION AS" },
        { 0x00E02B, "Extreme Networks, Inc." },
        { 0x00E02C, "AST COMPUTER" },
        { 0x00E02D, "InnoMediaLogic, Inc." },
        { 0x00E02E, "SPC ELECTRONICS CORPORATION" },
        { 0x00E02F, "MCNS HOLDINGS, L.P." },
        { 0x00E030, "MELITA INTERNATIONAL CORP." },
        { 0x00E031, "HAGIWARA ELECTRIC CO., LTD." },
        { 0x00E032, "MISYS FINANCIAL SYSTEMS, LTD." },
        { 0x00E033, "E.E.P.D. GmbH" },
        { 0x00E034, "Cisco Systems, Inc" },
        { 0x00E035, "Artesyn Embedded Technologies" },
        { 0x00E036, "PIONEER CORPORATION" },
        { 0x00E037, "CENTURY CORPORATION" },
        { 0x00E038, "PROXIMA CORPORATION" },
        { 0x00E039, "PARADYNE CORP." },
        { 0x00E03A, "Cabletron Systems, Inc." },
        { 0x00E03B, "PROMINET CORPORATION" },
        { 0x00E03C, "AdvanSys" },
        { 0x00E03D, "FOCON ELECTRONIC SYSTEMS A/S" },
        { 0x00E03E, "ALFATECH, INC." },
        { 0x00E03F, "JATON CORPORATION" },
        { 0x00E040, "DeskStation Technology, Inc." },
        { 0x00E041, "CSPI" },
        { 0x00E042, "Pacom Systems Ltd." },
        { 0x00E043, "VitalCom" },
        { 0x00E044, "LSICS CORPORATION" },
        { 0x00E045, "TOUCHWAVE, INC." },
        { 0x00E046, "BENTLY NEVADA CORP." },
        { 0x00E047, "InFocus Corporation" },
        { 0x00E048, "SDL COMMUNICATIONS, INC." },
        { 0x00E049, "MICROWI ELECTRONIC GmbH" },
        { 0x00E04A, "ZX Technologies, Inc" },
        { 0x00E04B, "JUMP INDUSTRIELLE COMPUTERTECHNIK GmbH" },
        { 0x00E04C, "REALTEK SEMICONDUCTOR CORP." },
        { 0x00E04D, "INTERNET INITIATIVE JAPAN, INC" },
        { 0x00E04E, "SANYO DENKI CO., LTD." },
        { 0x00E04F, "Cisco Systems, Inc" },
        { 0x00E050, "EXECUTONE INFORMATION SYSTEMS, INC." },
        { 0x00E051, "TALX CORPORATION" },
        { 0x00E052, "Brocade Communications Systems LLC" },
        { 0x00E053, "CELLPORT LABS, INC." },
        { 0x00E054, "KODAI HITEC CO., LTD." },
        { 0x00E055, "INGENIERIA ELECTRONICA COMERCIAL INELCOM S.A." },
        { 0x00E056, "HOLONTECH CORPORATION" },
        { 0x00E057, "HAN MICROTELECOM. CO., LTD." },
        { 0x00E058, "PHASE ONE DENMARK A/S" },
        { 0x00E059, "CONTROLLED ENVIRONMENTS, LTD." },
        { 0x00E05A, "GALEA NETWORK SECURITY" },
        { 0x00E05B, "WEST END SYSTEMS CORP." },
        { 0x00E05C, "PHC Corporation" },
        { 0x00E05D, "UNITEC CO., LTD." },
        { 0x00E05E, "JAPAN AVIATION ELECTRONICS INDUSTRY, LTD." },
        { 0x00E05F, "e-Net, Inc." },
        { 0x00E060, "SHERWOOD" },
        { 0x00E061, "EdgePoint Networks, Inc." },
        { 0x00E062, "HOST ENGINEERING" },
        { 0x00E063, "Cabletron Systems, Inc." },
        { 0x00E064, "SAMSUNG ELECTRONICS" },
        { 0x00E065, "OPTICAL ACCESS INTERNATIONAL" },
        { 0x00E066, "ProMax Systems, Inc." },
        { 0x00E067, "eac AUTOMATION-CONSULTING GmbH" },
        { 0x00E068, "MERRIMAC SYSTEMS INC." },
        { 0x00E069, "JAYCOR" },
        { 0x00E06A, "KAPSCH AG" },
        { 0x00E06B, "W&G SPECIAL PRODUCTS" },
        { 0x00E06C, "Ultra Electronics Command & Control Systems" },
        { 0x00E06D, "COMPUWARE CORPORATION" },
        { 0x00E06E, "FAR SYSTEMS S.p.A." },
        { 0x00E06F, "ARRIS Group, Inc." },
        { 0x00E070, "DH TECHNOLOGY" },
        { 0x00E071, "EPIS MICROCOMPUTER" },
        { 0x00E072, "LYNK" },
        { 0x00E073, "NATIONAL AMUSEMENT NETWORK, INC." },
        { 0x00E074, "TIERNAN COMMUNICATIONS, INC." },
        { 0x00E075, "Verilink Corporation" },
        { 0x00E076, "DEVELOPMENT CONCEPTS, INC." },
        { 0x00E077, "WEBGEAR, INC." },
        { 0x00E078, "BERKELEY NETWORKS" },
        { 0x00E079, "A.T.N.R." },
        { 0x00E07A, "MIKRODIDAKT AB" },
        { 0x00E07B, "BAY NETWORKS" },
        { 0x00E07C, "METTLER-TOLEDO, INC." },
        { 0x00E07D, "NETRONIX, INC." },
        { 0x00E07E, "WALT DISNEY IMAGINEERING" },
        { 0x00E07F, "LOGISTISTEM s.r.l." },
        { 0x00E080, "CONTROL RESOURCES CORPORATION" },
        { 0x00E081, "TYAN COMPUTER CORP." },
        { 0x00E082, "ANERMA" },
        { 0x00E083, "JATO TECHNOLOGIES, INC." },
        { 0x00E084, "COMPULITE R&D" },
        { 0x00E085, "GLOBAL MAINTECH, INC." },
        { 0x00E086, "Emerson Network Power, Avocent Division" },
        { 0x00E087, "LeCroy - Networking Productions Division" },
        { 0x00E088, "LTX-Credence CORPORATION" },
        { 0x00E089, "ION Networks, Inc." },
        { 0x00E08A, "GEC AVERY, LTD." },
        { 0x00E08B, "QLogic Corporation" },
        { 0x00E08C, "NEOPARADIGM LABS, INC." },
        { 0x00E08D, "PRESSURE SYSTEMS, INC." },
        { 0x00E08E, "UTSTARCOM" },
        { 0x00E08F, "Cisco Systems, Inc" },
        { 0x00E090, "BECKMAN LAB. AUTOMATION DIV." },
        { 0x00E091, "LG Electronics" },
        { 0x00E092, "ADMTEK INCORPORATED" },
        { 0x00E093, "ACKFIN NETWORKS" },
        { 0x00E094, "OSAI SRL" },
        { 0x00E095, "ADVANCED-VISION TECHNOLGIES CORP." },
        { 0x00E096, "SHIMADZU CORPORATION" },
        { 0x00E097, "CARRIER ACCESS CORPORATION" },
        { 0x00E098, "AboCom" },
        { 0x00E099, "SAMSON AG" },
        { 0x00E09A, "Positron Inc." },
        { 0x00E09B, "ENGAGE NETWORKS, INC." },
        { 0x00E09C, "MII" },
        { 0x00E09D, "SARNOFF CORPORATION" },
        { 0x00E09E, "Quantum Corporation" },
        { 0x00E09F, "PIXEL VISION" },
        { 0x00E0A0, "WILTRON CO." },
        { 0x00E0A1, "HIMA PAUL HILDEBRANDT GmbH Co. KG" },
        { 0x00E0A2, "MICROSLATE INC." },
        { 0x00E0A3, "Cisco Systems, Inc" },
        { 0x00E0A4, "ESAOTE S.p.A." },
        { 0x00E0A5, "ComCore Semiconductor, Inc." },
        { 0x00E0A6, "TELOGY NETWORKS, INC." },
        { 0x00E0A7, "IPC INFORMATION SYSTEMS, INC." },
        { 0x00E0A8, "SAT GmbH & Co." },
        { 0x00E0A9, "FUNAI ELECTRIC CO., LTD." },
        { 0x00E0AA, "ELECTROSONIC LTD." },
        { 0x00E0AB, "DIMAT S.A." },
        { 0x00E0AC, "MIDSCO, INC." },
        { 0x00E0AD, "EES TECHNOLOGY, LTD." },
        { 0x00E0AE, "XAQTI CORPORATION" },
        { 0x00E0AF, "GENERAL DYNAMICS INFORMATION SYSTEMS" },
        { 0x00E0B0, "Cisco Systems, Inc" },
        { 0x00E0B1, "Alcatel-Lucent Enterprise" },
        { 0x00E0B2, "TELMAX COMMUNICATIONS CORP." },
        { 0x00E0B3, "EtherWAN Systems, Inc." },
        { 0x00E0B4, "TECHNO SCOPE CO., LTD." },
        { 0x00E0B5, "ARDENT COMMUNICATIONS CORP." },
        { 0x00E0B6, "Entrada Networks" },
        { 0x00E0B7, "Cosworth Electronics Ltd" },
        { 0x00E0B8, "GATEWAY 2000" },
        { 0x00E0B9, "BYAS SYSTEMS" },
        { 0x00E0BA, "BERGHOF AUTOMATIONSTECHNIK GmbH" },
        { 0x00E0BB, "NBX CORPORATION" },
        { 0x00E0BC, "SYMON COMMUNICATIONS, INC." },
        { 0x00E0BD, "INTERFACE SYSTEMS, INC." },
        { 0x00E0BE, "GENROCO INTERNATIONAL, INC." },
        { 0x00E0BF, "TORRENT NETWORKING TECHNOLOGIES CORP." },
        { 0x00E0C0, "SEIWA ELECTRIC MFG. CO., LTD." },
        { 0x00E0C1, "MEMOREX TELEX JAPAN, LTD." },
        { 0x00E0C2, "NECSY S.p.A." },
        { 0x00E0C3, "SAKAI SYSTEM DEVELOPMENT CORP." },
        { 0x00E0C4, "HORNER ELECTRIC, INC." },
        { 0x00E0C5, "BCOM ELECTRONICS INC." },
        { 0x00E0C6, "LINK2IT, L.L.C." },
        { 0x00E0C7, "EUROTECH SRL" },
        { 0x00E0C8, "VIRTUAL ACCESS, LTD." },
        { 0x00E0C9, "AutomatedLogic Corporation" },
        { 0x00E0CA, "BEST DATA PRODUCTS" },
        { 0x00E0CB, "RESON, INC." },
        { 0x00E0CC, "HERO SYSTEMS, LTD." },
        { 0x00E0CD, "SAAB SENSIS CORPORATION" },
        { 0x00E0CE, "ARN" },
        { 0x00E0CF, "INTEGRATED DEVICE" },
        { 0x00E0D0, "NETSPEED, INC." },
        { 0x00E0D1, "TELSIS LIMITED" },
        { 0x00E0D2, "VERSANET COMMUNICATIONS, INC." },
        { 0x00E0D3, "DATENTECHNIK GmbH" },
        { 0x00E0D4, "EXCELLENT COMPUTER" },
        { 0x00E0D5, "Emulex Corporation" },
        { 0x00E0D6, "COMPUTER & COMMUNICATION RESEARCH LAB." },
        { 0x00E0D7, "SUNSHINE ELECTRONICS, INC." },
        { 0x00E0D8, "LANBit Computer, Inc." },
        { 0x00E0D9, "TAZMO CO., LTD." },
        { 0x00E0DA, "Alcatel-Lucent Enterprise" },
        { 0x00E0DB, "ViaVideo Communications, Inc." },
        { 0x00E0DC, "NEXWARE CORP." },
        { 0x00E0DD, "Zenith Electronics Corporation" },
        { 0x00E0DE, "DATAX NV" },
        { 0x00E0DF, "KEYMILE GmbH" },
        { 0x00E0E0, "SI ELECTRONICS, LTD." },
        { 0x00E0E1, "G2 NETWORKS, INC." },
        { 0x00E0E2, "INNOVA CORP." },
        { 0x00E0E3, "SK-ELEKTRONIK GMBH" },
        { 0x00E0E4, "FANUC ROBOTICS NORTH AMERICA, Inc." },
        { 0x00E0E5, "CINCO NETWORKS, INC." },
        { 0x00E0E6, "INCAA Computers" },
        { 0x00E0E7, "RAYTHEON E-SYSTEMS, INC." },
        { 0x00E0E8, "GRETACODER Data Systems AG" },
        { 0x00E0E9, "DATA LABS, INC." },
        { 0x00E0EA, "INNOVAT COMMUNICATIONS, INC." },
        { 0x00E0EB, "DIGICOM SYSTEMS, INCORPORATED" },
        { 0x00E0EC, "CELESTICA INC." },
        { 0x00E0ED, "SILICOM, LTD." },
        { 0x00E0EE, "MAREL HF" },
        { 0x00E0EF, "DIONEX" },
        { 0x00E0F0, "ABLER TECHNOLOGY, INC." },
        { 0x00E0F1, "THAT CORPORATION" },
        { 0x00E0F2, "ARLOTTO COMNET, INC." },
        { 0x00E0F3, "WebSprint Communications, Inc." },
        { 0x00E0F4, "INSIDE Technology A/S" },
        { 0x00E0F5, "TELES AG" },
        { 0x00E0F6, "DECISION EUROPE" },
        { 0x00E0F7, "Cisco Systems, Inc" },
        { 0x00E0F8, "DICNA CONTROL AB" },
        { 0x00E0F9, "Cisco Systems, Inc" },
        { 0x00E0FA, "TRL TECHNOLOGY, LTD." },
        { 0x00E0FB, "LEIGHTRONIX, INC." },
        { 0x00E0FC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x00E0FD, "A-TREND TECHNOLOGY CO., LTD." },
        { 0x00E0FE, "Cisco Systems, Inc" },
        { 0x00E0FF, "SECURITY DYNAMICS TECHNOLOGIES, Inc." },
        { 0x00E16D, "Cisco Systems, Inc" },
        { 0x00E175, "AK-Systems Ltd" },
        { 0x00E18C, "Intel Corporate" },
        { 0x00E22C, "China Mobile Group Device Co.,Ltd." },
        { 0x00E3B2, "Samsung Electronics Co.,Ltd" },
        { 0x00E400, "Sichuan Changhong Electric Ltd." },
        { 0x00E406, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x00E5E4, "Sichuan Tianyi Comheart Telecom Co., Ltd." },
        { 0x00E666, "ARIMA Communications Corp." },
        { 0x00E6D3, "NIXDORF COMPUTER CORP." },
        { 0x00E6E8, "Netzin Technology Corporation,.Ltd." },
        { 0x00E8AB, "Meggitt Training Systems, Inc." },
        { 0x00E93A, "AzureWave Technology Inc." },
        { 0x00EABD, "Cisco Systems, Inc" },
        { 0x00EB2D, "Sony Mobile Communications Inc" },
        { 0x00EBD5, "Cisco Systems, Inc" },
        { 0x00EC0A, "Xiaomi Communications Co Ltd" },
        { 0x00EDB8, "KYOCERA Corporation" },
        { 0x00EEAB, "Cisco Systems, Inc" },
        { 0x00EEBD, "HTC Corporation" },
        { 0x00F051, "KWB Gmbh" },
        { 0x00F22C, "Shanghai B-star Technology Co.,Ltd." },
        { 0x00F28B, "Cisco Systems, Inc" },
        { 0x00F3DB, "WOO Sports" },
        { 0x00F403, "Orbis Systems Oy" },
        { 0x00F46F, "Samsung Electronics Co.,Ltd" },
        { 0x00F48D, "Liteon Technology Corporation" },
        { 0x00F4B9, "Apple, Inc." },
        { 0x00F620, "Google, Inc." },
        { 0x00F663, "Cisco Systems, Inc" },
        { 0x00F76F, "Apple, Inc." },
        { 0x00F81C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x00F82C, "Cisco Systems, Inc" },
        { 0x00F860, "PT. Panggung Electric Citrabuana" },
        { 0x00F871, "DGS Denmark A/S" },
        { 0x00FA21, "Samsung Electronics Co.,Ltd" },
        { 0x00FA3B, "CLOOS ELECTRONIC GMBH" },
        { 0x00FC58, "WebSilicon Ltd." },
        { 0x00FC70, "Intrepid Control Systems, Inc." },
        { 0x00FC8B, "Amazon Technologies Inc." },
        { 0x00FC8D, "Hitron Technologies. Inc" },
        { 0x00FCBA, "Cisco Systems, Inc" },
        { 0x00FD22, "Cisco Systems, Inc" },
        { 0x00FD45, "Hewlett Packard Enterprise" },
        { 0x00FD4C, "NEVATEC" },
        { 0x00FEC8, "Cisco Systems, Inc" },
        { 0x020701, "RACAL-DATACOM" },
        { 0x021C7C, "PERQ SYSTEMS CORPORATION" },
        { 0x026086, "LOGIC REPLACEMENT TECH. LTD." },
        { 0x02608C, "3COM" },
        { 0x027001, "RACAL-DATACOM" },
        { 0x0270B0, "M/A-COM INC. COMPANIES" },
        { 0x0270B3, "DATA RECALL LTD." },
        { 0x029D8E, "CARDIAC RECORDERS, INC." },
        { 0x02AA3C, "OLIVETTI TELECOMM SPA (OLTECO)" },
        { 0x02BB01, "OCTOTHORPE CORP." },
        { 0x02C08C, "3COM" },
        { 0x02CF1C, "Communication Machinery Corporation" },
        { 0x02E6D3, "NIXDORF COMPUTER CORP." },
        { 0x04021F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0402CA, "Shenzhen Vtsonic Co.,ltd" },
        { 0x0403D6, "Nintendo Co.,Ltd" },
        { 0x0404EA, "Valens Semiconductor Ltd." },
        { 0x0405DD, "Shenzhen Cultraview Digital Technology Co., Ltd" },
        { 0x04072E, "VTech Electronics Ltd." },
        { 0x040973, "Hewlett Packard Enterprise" },
        { 0x0409A5, "HFR, Inc." },
        { 0x040A83, "Alcatel-Lucent" },
        { 0x040AE0, "XMIT AG COMPUTER NETWORKS" },
        { 0x040CCE, "Apple, Inc." },
        { 0x040E3C, "HP Inc." },
        { 0x040EC2, "ViewSonic Mobile China Limited" },
        { 0x041552, "Apple, Inc." },
        { 0x0415D9, "Viwone" },
        { 0x04180F, "Samsung Electronics Co.,Ltd" },
        { 0x0418B6, "Private" },
        { 0x0418D6, "Ubiquiti Networks Inc." },
        { 0x04197F, "Grasphere Japan" },
        { 0x041A04, "WaveIP" },
        { 0x041B6D, "LG Electronics (Mobile Communications)" },
        { 0x041B94, "Host Mobility AB" },
        { 0x041BBA, "Samsung Electronics Co.,Ltd" },
        { 0x041D10, "Dream Ware Inc." },
        { 0x041DC7, "zte corporation" },
        { 0x041E64, "Apple, Inc." },
        { 0x041E7A, "DSPWorks" },
        { 0x041EFA, "BISSELL Homecare, Inc." },
        { 0x04209A, "Panasonic Corporation AVC Networks Company" },
        { 0x042144, "Sunitec Enterprise Co.,Ltd" },
        { 0x04214C, "Insight Energy Ventures LLC" },
        { 0x042234, "Wireless Standard Extensions" },
        { 0x0425C5, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x042605, "GFR Gesellschaft für Regelungstechnik und Energieeinsparung mbH" },
        { 0x042665, "Apple, Inc." },
        { 0x042758, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x042AE2, "Cisco Systems, Inc" },
        { 0x042BBB, "PicoCELA, Inc." },
        { 0x042DB4, "First Property (Beijing) Co., Ltd Modern MOMA Branch" },
        { 0x042F56, "ATOCS (Shenzhen) LTD" },
        { 0x043110, "Inspur Group Co., Ltd." },
        { 0x0432F4, "Partron" },
        { 0x043385, "Nanchang BlackShark Co.,Ltd." },
        { 0x043389, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0433C2, "Intel Corporate" },
        { 0x043604, "Gyeyoung I&T" },
        { 0x043A0D, "SM Optics S.r.l." },
        { 0x043D98, "ChongQing QingJia Electronics CO.,LTD" },
        { 0x043F72, "Mellanox Technologies, Inc." },
        { 0x0440A9, "New H3C Technologies Co., Ltd" },
        { 0x044169, "GoPro" },
        { 0x0444A1, "TELECON GALICIA,S.A." },
        { 0x044562, "ANDRA Sp. z o. o." },
        { 0x0445A1, "NIRIT- Xinwei Telecom Technology Co., Ltd." },
        { 0x044665, "Murata Manufacturing Co., Ltd." },
        { 0x0446CF, "Beijing Venustech Cybervision Co.,Ltd." },
        { 0x04489A, "Apple, Inc." },
        { 0x044A50, "Ramaxel Technology (Shenzhen) limited company" },
        { 0x044A6C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x044AC6, "Aipon Electronics Co., Ltd" },
        { 0x044BED, "Apple, Inc." },
        { 0x044BFF, "GuangZhou Hedy Digital Technology Co., Ltd" },
        { 0x044CEF, "Fujian Sanao Technology Co.,Ltd" },
        { 0x044E06, "Ericsson AB" },
        { 0x044E5A, "ARRIS Group, Inc." },
        { 0x044EAF, "LG Innotek" },
        { 0x044F17, "HUMAX Co., Ltd." },
        { 0x044F4C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x044F8B, "Adapteva, Inc." },
        { 0x044FAA, "Ruckus Wireless" },
        { 0x0450DA, "Qiku Internet Network Scientific (Shenzhen) Co., Ltd" },
        { 0x0452C7, "Bose Corporation" },
        { 0x0452F3, "Apple, Inc." },
        { 0x0453D5, "Sysorex Global Holdings" },
        { 0x045453, "Apple, Inc." },
        { 0x0455CA, "BriView (Xiamen) Corp." },
        { 0x045604, "Gionee Communication Equipment Co.,Ltd." },
        { 0x04572F, "Sertel Electronics UK Ltd" },
        { 0x04586F, "Sichuan Whayer information industry Co.,LTD" },
        { 0x045A95, "Nokia Corporation" },
        { 0x045C06, "Zmodo Technology Corporation" },
        { 0x045C6C, "Juniper Networks" },
        { 0x045C8E, "gosund GROUP CO.,LTD" },
        { 0x045D4B, "Sony Corporation" },
        { 0x045D56, "camtron industrial inc." },
        { 0x045EA4, "SHENZHEN NETIS TECHNOLOGY CO.,LTD" },
        { 0x045FA7, "Shenzhen Yichen Technology Development Co.,LTD" },
        { 0x045FB9, "Cisco Systems, Inc" },
        { 0x046169, "MEDIA GLOBAL LINKS CO., LTD." },
        { 0x046273, "Cisco Systems, Inc" },
        { 0x0462D7, "ALSTOM HYDRO FRANCE" },
        { 0x0463E0, "Nome Oy" },
        { 0x046565, "Testop" },
        { 0x046785, "scemtec Hard- und Software fuer Mess- und Steuerungstechnik GmbH" },
        { 0x0469F8, "Apple, Inc." },
        { 0x046B1B, "SYSDINE Co., Ltd." },
        { 0x046B25, "SICHUAN TIANYI COMHEART TELECOM CO.,LTD" },
        { 0x046C59, "Intel Corporate" },
        { 0x046C9D, "Cisco Systems, Inc" },
        { 0x046D42, "Bryston Ltd." },
        { 0x046E02, "OpenRTLS Group" },
        { 0x046E49, "TaiYear Electronic Technology (Suzhou) Co., Ltd" },
        { 0x0470BC, "Globalstar Inc." },
        { 0x04714B, "IEEE Registration Authority" },
        { 0x047295, "Apple, Inc." },
        { 0x0474A1, "Aligera Equipamentos Digitais Ltda" },
        { 0x047503, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0475F5, "CSST" },
        { 0x04766E, "ALPS ELECTRIC CO., LTD." },
        { 0x0476B0, "Cisco Systems, Inc" },
        { 0x047863, "Shanghai MXCHIP Information Technology Co., Ltd." },
        { 0x047970, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0479B7, "Texas Instruments" },
        { 0x047D50, "Shenzhen Kang Ying Technology Co.Ltd." },
        { 0x047D7B, "Quanta Computer Inc." },
        { 0x047E23, "China Mobile IOT Company Limited" },
        { 0x047E4A, "moobox CO., Ltd." },
        { 0x047F0E, "Barrot Technology Limited" },
        { 0x04819B, "BSkyB Ltd" },
        { 0x0481AE, "Clack Corporation" },
        { 0x04848A, "7INOVA TECHNOLOGY LIMITED" },
        { 0x04885F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04888C, "Eifelwerk Butler Systeme GmbH" },
        { 0x0488E2, "Beats Electronics LLC" },
        { 0x048A15, "Avaya Inc" },
        { 0x048AE1, "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.,LTD." },
        { 0x048B42, "Skspruce Technologies" },
        { 0x048C03, "ThinPAD Technology (Shenzhen)CO.,LTD" },
        { 0x048C16, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x048C9A, "Huawei Device Co., Ltd." },
        { 0x048D38, "Netcore Technology Inc." },
        { 0x049162, "Microchip Technology Inc." },
        { 0x049226, "ASUSTek COMPUTER INC." },
        { 0x0492EE, "iway AG" },
        { 0x04946B, "TECNO MOBILE LIMITED" },
        { 0x0494A1, "CATCH THE WIND INC" },
        { 0x049573, "zte corporation" },
        { 0x0495E6, "Tenda Technology Co.,Ltd.Dongguan branch" },
        { 0x049645, "WUXI SKY CHIP INTERCONNECTION TECHNOLOGY CO.,LTD." },
        { 0x049790, "Lartech telecom LLC" },
        { 0x0498F3, "ALPS ELECTRIC CO., LTD." },
        { 0x0499E6, "Shenzhen Yoostar Technology Co., Ltd" },
        { 0x049B9C, "Eadingcore Intelligent Technology Co., Ltd." },
        { 0x049C62, "BMT Medical Technology s.r.o." },
        { 0x049DFE, "Hivesystem" },
        { 0x049F06, "Smobile Co., Ltd." },
        { 0x049F81, "NetAlly" },
        { 0x049FCA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04A151, "NETGEAR" },
        { 0x04A222, "Arcadyan Corporation" },
        { 0x04A2F3, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x04A316, "Texas Instruments" },
        { 0x04A3F3, "Emicon" },
        { 0x04A82A, "Nokia Corporation" },
        { 0x04AAE1, "BEIJING MICROVISION TECHNOLOGY CO.,LTD" },
        { 0x04AB18, "ELECOM CO.,LTD." },
        { 0x04AB6A, "Chun-il Co.,Ltd." },
        { 0x04AC44, "Holtek Semiconductor Inc." },
        { 0x04B0E7, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04B167, "Xiaomi Communications Co Ltd" },
        { 0x04B1A1, "Samsung Electronics Co.,Ltd" },
        { 0x04B3B6, "Seamap (UK) Ltd" },
        { 0x04B429, "Samsung Electronics Co.,Ltd" },
        { 0x04B466, "BSP Co., Ltd." },
        { 0x04B648, "ZENNER" },
        { 0x04BA36, "Li Seng Technology Ltd" },
        { 0x04BA8D, "Samsung Electronics Co.,Ltd" },
        { 0x04BBF9, "Pavilion Data Systems Inc" },
        { 0x04BC87, "Shenzhen JustLink Technology Co., LTD" },
        { 0x04BD70, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04BD88, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x04BDBF, "Samsung Electronics Co.,Ltd" },
        { 0x04BF6D, "Zyxel Communications Corporation" },
        { 0x04BFA8, "ISB Corporation" },
        { 0x04C05B, "Tigo Energy" },
        { 0x04C06F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04C09C, "Tellabs Inc." },
        { 0x04C103, "Clover Network, Inc." },
        { 0x04C1B9, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x04C1D8, "Huawei Device Co., Ltd." },
        { 0x04C23E, "HTC Corporation" },
        { 0x04C241, "Nokia" },
        { 0x04C3E6, "IEEE Registration Authority" },
        { 0x04C5A4, "Cisco Systems, Inc" },
        { 0x04C807, "Xiaomi Communications Co Ltd" },
        { 0x04C880, "Samtec Inc" },
        { 0x04C991, "Phistek INC." },
        { 0x04C9D9, "Dish Technologies Corp" },
        { 0x04CB1D, "Traka plc" },
        { 0x04CB88, "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd" },
        { 0x04CE14, "Wilocity LTD." },
        { 0x04CE7E, "NXP France Semiconductors France" },
        { 0x04CF25, "MANYCOLORS, INC." },
        { 0x04CF8C, "XIAOMI Electronics,CO.,LTD" },
        { 0x04D13A, "Xiaomi Communications Co Ltd" },
        { 0x04D16E, "IEEE Registration Authority" },
        { 0x04D395, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x04D3B0, "Intel Corporate" },
        { 0x04D3B5, "Huawei Device Co., Ltd." },
        { 0x04D3CF, "Apple, Inc." },
        { 0x04D437, "ZNV" },
        { 0x04D4C4, "ASUSTek COMPUTER INC." },
        { 0x04D590, "Fortinet, Inc." },
        { 0x04D6AA, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x04D783, "Y&H E&C Co.,LTD." },
        { 0x04D7A5, "New H3C Technologies Co., Ltd" },
        { 0x04D9F5, "ASUSTek COMPUTER INC." },
        { 0x04DAD2, "Cisco Systems, Inc" },
        { 0x04DB56, "Apple, Inc." },
        { 0x04DB8A, "Suntech International Ltd." },
        { 0x04DD4C, "Velocytech" },
        { 0x04DEDB, "Rockport Networks Inc" },
        { 0x04DEF2, "Shenzhen ECOM Technology Co. Ltd" },
        { 0x04DF69, "Car Connectivity Consortium" },
        { 0x04E0B0, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x04E0C4, "TRIUMPH-ADLER AG" },
        { 0x04E1C8, "IMS Soluções em Energia Ltda." },
        { 0x04E229, "Qingdao Haier Technology Co.,Ltd" },
        { 0x04E2F8, "AEP Ticketing solutions srl" },
        { 0x04E451, "Texas Instruments" },
        { 0x04E536, "Apple, Inc." },
        { 0x04E548, "Cohda Wireless Pty Ltd" },
        { 0x04E56E, "THUB Co., ltd." },
        { 0x04E598, "Xiaomi Communications Co Ltd" },
        { 0x04E662, "Acroname Inc." },
        { 0x04E676, "AMPAK Technology, Inc." },
        { 0x04E77E, "We Corporation Inc." },
        { 0x04E795, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04E9E5, "PJRC.COM, LLC" },
        { 0x04EA56, "Intel Corporate" },
        { 0x04EB40, "Cisco Systems, Inc" },
        { 0x04ECBB, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x04ED33, "Intel Corporate" },
        { 0x04EE03, "Texas Instruments" },
        { 0x04EE91, "x-fabric GmbH" },
        { 0x04F021, "Compex Systems Pte Ltd" },
        { 0x04F128, "HMD Global Oy" },
        { 0x04F13E, "Apple, Inc." },
        { 0x04F169, "Huawei Device Co., Ltd." },
        { 0x04F17D, "Tarana Wireless" },
        { 0x04F352, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04F4BC, "Xena Networks" },
        { 0x04F5F4, "Proxim Wireless" },
        { 0x04F7E4, "Apple, Inc." },
        { 0x04F8C2, "Flaircomm Microelectronics, Inc." },
        { 0x04F8F8, "Edgecore Networks Corporation" },
        { 0x04F938, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04F9D9, "Speaker Electronic(Jiashan) Co.,Ltd" },
        { 0x04FA3F, "Opticore Inc." },
        { 0x04FA83, "Qingdao Haier Technology Co.,Ltd" },
        { 0x04FE31, "Samsung Electronics Co.,Ltd" },
        { 0x04FE7F, "Cisco Systems, Inc" },
        { 0x04FE8D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x04FEA1, "Fihonest communication co.,Ltd" },
        { 0x04FF51, "NOVAMEDIA INNOVISION SP. Z O.O." },
        { 0x080001, "COMPUTERVISION CORPORATION" },
        { 0x080002, "BRIDGE COMMUNICATIONS INC." },
        { 0x080003, "ADVANCED COMPUTER COMM." },
        { 0x080004, "CROMEMCO INCORPORATED" },
        { 0x080005, "SYMBOLICS INC." },
        { 0x080006, "SIEMENS AG" },
        { 0x080007, "Apple, Inc." },
        { 0x080008, "BOLT BERANEK AND NEWMAN INC." },
        { 0x080009, "Hewlett Packard" },
        { 0x08000A, "NESTAR SYSTEMS INCORPORATED" },
        { 0x08000B, "UNISYS CORPORATION" },
        { 0x08000C, "MIKLYN DEVELOPMENT CO." },
        { 0x08000D, "International Computers, Ltd" },
        { 0x08000E, "NCR CORPORATION" },
        { 0x08000F, "MITEL CORPORATION" },
        { 0x080011, "TEKTRONIX INC." },
        { 0x080012, "BELL ATLANTIC INTEGRATED SYST." },
        { 0x080013, "Exxon" },
        { 0x080014, "EXCELAN" },
        { 0x080015, "STC BUSINESS SYSTEMS" },
        { 0x080016, "BARRISTER INFO SYS CORP" },
        { 0x080017, "NATIONAL SEMICONDUCTOR" },
        { 0x080018, "PIRELLI FOCOM NETWORKS" },
        { 0x080019, "GENERAL ELECTRIC CORPORATION" },
        { 0x08001A, "TIARA/ 10NET" },
        { 0x08001B, "Dell EMC" },
        { 0x08001C, "KDD-KOKUSAI DEBNSIN DENWA CO." },
        { 0x08001D, "ABLE COMMUNICATIONS INC." },
        { 0x08001E, "APOLLO COMPUTER INC." },
        { 0x08001F, "SHARP CORPORATION" },
        { 0x080020, "Oracle Corporation" },
        { 0x080021, "3M COMPANY" },
        { 0x080022, "NBI INC." },
        { 0x080023, "Panasonic Communications Co., Ltd." },
        { 0x080024, "10NET COMMUNICATIONS/DCA" },
        { 0x080025, "CONTROL DATA" },
        { 0x080026, "NORSK DATA A.S." },
        { 0x080027, "PCS Systemtechnik GmbH" },
        { 0x080028, "Texas Instruments" },
        { 0x080029, "Megatek Corporation" },
        { 0x08002A, "MOSAIC TECHNOLOGIES INC." },
        { 0x08002B, "DIGITAL EQUIPMENT CORPORATION" },
        { 0x08002C, "BRITTON LEE INC." },
        { 0x08002D, "LAN-TEC INC." },
        { 0x08002E, "METAPHOR COMPUTER SYSTEMS" },
        { 0x08002F, "PRIME COMPUTER INC." },
        { 0x080030, "CERN" },
        { 0x080030, "NETWORK RESEARCH CORPORATION" },
        { 0x080030, "ROYAL MELBOURNE INST OF TECH" },
        { 0x080031, "LITTLE MACHINES INC." },
        { 0x080032, "TIGAN INCORPORATED" },
        { 0x080033, "BAUSCH & LOMB" },
        { 0x080034, "FILENET CORPORATION" },
        { 0x080035, "MICROFIVE CORPORATION" },
        { 0x080036, "INTERGRAPH CORPORATION" },
        { 0x080037, "FUJI-XEROX CO. LTD." },
        { 0x080038, "BULL S.A.S." },
        { 0x080039, "SPIDER SYSTEMS LIMITED" },
        { 0x08003A, "ORCATECH INC." },
        { 0x08003B, "TORUS SYSTEMS LIMITED" },
        { 0x08003C, "SCHLUMBERGER WELL SERVICES" },
        { 0x08003D, "CADNETIX CORPORATIONS" },
        { 0x08003E, "CODEX CORPORATION" },
        { 0x08003F, "FRED KOSCHARA ENTERPRISES" },
        { 0x080040, "FERRANTI COMPUTER SYS. LIMITED" },
        { 0x080041, "RACAL-MILGO INFORMATION SYS.." },
        { 0x080042, "JAPAN MACNICS CORP." },
        { 0x080043, "PIXEL COMPUTER INC." },
        { 0x080044, "DAVID SYSTEMS INC." },
        { 0x080045, "CONCURRENT COMPUTER CORP." },
        { 0x080046, "Sony Corporation" },
        { 0x080047, "SEQUENT COMPUTER SYSTEMS INC." },
        { 0x080048, "EUROTHERM GAUGING SYSTEMS" },
        { 0x080049, "UNIVATION" },
        { 0x08004A, "BANYAN SYSTEMS INC." },
        { 0x08004B, "Planning Research Corp." },
        { 0x08004C, "HYDRA COMPUTER SYSTEMS INC." },
        { 0x08004D, "CORVUS SYSTEMS INC." },
        { 0x08004E, "3COM EUROPE LTD" },
        { 0x08004F, "CYGNET SYSTEMS" },
        { 0x080050, "DAISY SYSTEMS CORP." },
        { 0x080051, "ExperData" },
        { 0x080052, "INSYSTEC" },
        { 0x080053, "MIDDLE EAST TECH. UNIVERSITY" },
        { 0x080055, "STANFORD TELECOMM. INC." },
        { 0x080056, "STANFORD LINEAR ACCEL. CENTER" },
        { 0x080057, "Evans & Sutherland" },
        { 0x080058, "SYSTEMS CONCEPTS" },
        { 0x080059, "A/S MYCRON" },
        { 0x08005A, "IBM Corp" },
        { 0x08005B, "VTA TECHNOLOGIES INC." },
        { 0x08005C, "FOUR PHASE SYSTEMS" },
        { 0x08005D, "GOULD INC." },
        { 0x08005E, "COUNTERPOINT COMPUTER INC." },
        { 0x08005F, "SABER TECHNOLOGY CORP." },
        { 0x080060, "INDUSTRIAL NETWORKING INC." },
        { 0x080061, "JAROGATE LTD." },
        { 0x080062, "General Dynamics" },
        { 0x080063, "PLESSEY" },
        { 0x080064, "Sitasys AG" },
        { 0x080065, "GENRAD INC." },
        { 0x080066, "AGFA CORPORATION" },
        { 0x080067, "ComDesign" },
        { 0x080068, "RIDGE COMPUTERS" },
        { 0x080069, "Silicon Graphics" },
        { 0x08006A, "AT&T" },
        { 0x08006B, "ACCEL TECHNOLOGIES INC." },
        { 0x08006C, "SUNTEK TECHNOLOGY INT'L" },
        { 0x08006D, "WHITECHAPEL COMPUTER WORKS" },
        { 0x08006E, "MASSCOMP" },
        { 0x08006F, "PHILIPS APELDOORN B.V." },
        { 0x080070, "Mitsubishi Precision Co.,LTd." },
        { 0x080071, "MATRA (DSIE)" },
        { 0x080072, "XEROX CORP UNIV GRANT PROGRAM" },
        { 0x080073, "TECMAR INC." },
        { 0x080074, "CASIO COMPUTER CO. LTD." },
        { 0x080075, "DANSK DATA ELECTRONIK" },
        { 0x080076, "PC LAN TECHNOLOGIES" },
        { 0x080077, "TSL COMMUNICATIONS LTD." },
        { 0x080078, "ACCELL CORPORATION" },
        { 0x080079, "THE DROID WORKS" },
        { 0x08007A, "INDATA" },
        { 0x08007B, "SANYO ELECTRIC CO. LTD." },
        { 0x08007C, "VITALINK COMMUNICATIONS CORP." },
        { 0x08007E, "AMALGAMATED WIRELESS(AUS) LTD" },
        { 0x08007F, "CARNEGIE-MELLON UNIVERSITY" },
        { 0x080080, "AES DATA INC." },
        { 0x080081, "ASTECH INC." },
        { 0x080082, "VERITAS SOFTWARE" },
        { 0x080083, "Seiko Instruments Inc." },
        { 0x080084, "TOMEN ELECTRONICS CORP." },
        { 0x080085, "ELXSI" },
        { 0x080086, "KONICA MINOLTA HOLDINGS, INC." },
        { 0x080087, "Xyplex, Inc." },
        { 0x080088, "Brocade Communications Systems LLC" },
        { 0x080089, "Kinetics" },
        { 0x08008A, "PerfTech, Inc." },
        { 0x08008B, "PYRAMID TECHNOLOGY CORP." },
        { 0x08008C, "NETWORK RESEARCH CORPORATION" },
        { 0x08008D, "XYVISION INC." },
        { 0x08008E, "Tandem Computers" },
        { 0x08008F, "CHIPCOM CORPORATION" },
        { 0x080090, "SONOMA SYSTEMS" },
        { 0x08010F, "SICHUAN TIANYI COMHEART TELECOMCO.,LTD" },
        { 0x08028E, "NETGEAR" },
        { 0x080342, "Palo Alto Networks" },
        { 0x080371, "KRG CORPORATE" },
        { 0x080581, "Roku, Inc." },
        { 0x0805CD, "DongGuang EnMai Electronic Product Co.Ltd." },
        { 0x0808C2, "Samsung Electronics Co.,Ltd" },
        { 0x0808EA, "AMSC" },
        { 0x0809B6, "Masimo Corp" },
        { 0x0809C7, "Zhuhai Unitech Power Technology Co., Ltd." },
        { 0x080A4E, "Planet Bingo® — 3rd Rock Gaming®" },
        { 0x080C0B, "SysMik GmbH Dresden" },
        { 0x080CC9, "Mission Technology Group, dba Magma" },
        { 0x080D84, "GECO, Inc." },
        { 0x080EA8, "Velex s.r.l." },
        { 0x080FFA, "KSP INC." },
        { 0x08115E, "Bitel Co., Ltd." },
        { 0x081196, "Intel Corporate" },
        { 0x0812A5, "Amazon Technologies Inc." },
        { 0x081443, "UNIBRAIN S.A." },
        { 0x08152F, "Samsung Electronics Co., Ltd. ARTIK" },
        { 0x081651, "SHENZHEN SEA STAR TECHNOLOGY CO.,LTD" },
        { 0x081735, "Cisco Systems, Inc" },
        { 0x0817F4, "IBM Corp" },
        { 0x08181A, "zte corporation" },
        { 0x08184C, "A. S. Thomas, Inc." },
        { 0x0819A6, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x081DC4, "Thermo Fisher Scientific Messtechnik GmbH" },
        { 0x081DFB, "Shanghai Mexon Communication Technology Co.,Ltd" },
        { 0x081F3F, "WondaLink Inc." },
        { 0x081F71, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x081FEB, "BinCube" },
        { 0x081FF3, "Cisco Systems, Inc" },
        { 0x0821EF, "Samsung Electronics Co.,Ltd" },
        { 0x0823B2, "vivo Mobile Communication Co., Ltd." },
        { 0x082522, "ADVANSEE" },
        { 0x082525, "Xiaomi Communications Co Ltd" },
        { 0x082697, "Zyxel Communications Corporation" },
        { 0x082719, "APS systems/electronic AG" },
        { 0x0827CE, "NAGANO KEIKI CO., LTD." },
        { 0x082AD0, "SRD Innovations Inc." },
        { 0x082CB0, "Network Instruments" },
        { 0x082CB6, "Apple, Inc." },
        { 0x082E5F, "Hewlett Packard" },
        { 0x08306B, "Palo Alto Networks" },
        { 0x08318B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0831A4, "Huawei Device Co., Ltd." },
        { 0x08351B, "Shenzhen Jialihua Electronic Technology Co., Ltd" },
        { 0x083571, "CASwell INC." },
        { 0x0835B2, "CoreEdge Networks Co., Ltd" },
        { 0x0836C9, "NETGEAR" },
        { 0x08373D, "Samsung Electronics Co.,Ltd" },
        { 0x08379C, "Topaz Co. LTD." },
        { 0x083869, "Hong Kong AMobile Intelligent Corp. Limited Taiwan Branch" },
        { 0x0838A5, "Funkwerk plettac electronic GmbH" },
        { 0x0838E6, "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
        { 0x083A2F, "Guangzhou Juan Intelligent Tech Joint Stock Co.,Ltd" },
        { 0x083A5C, "Junilab, Inc." },
        { 0x083A88, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x083AB8, "Shinoda Plasma Co., Ltd." },
        { 0x083AF2, "Espressif Inc." },
        { 0x083D88, "Samsung Electronics Co.,Ltd" },
        { 0x083E0C, "ARRIS Group, Inc." },
        { 0x083E5D, "Sagemcom Broadband SAS" },
        { 0x083E8E, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x083F3E, "WSH GmbH" },
        { 0x083F76, "Intellian Technologies, Inc." },
        { 0x083FBC, "zte corporation" },
        { 0x084027, "Gridstore Inc." },
        { 0x0840F3, "Tenda Technology Co.,Ltd.Dongguan branch" },
        { 0x084296, "Mobile Technology Solutions LLC" },
        { 0x084656, "VEO-LABS" },
        { 0x0847D0, "Nokia Shanghai Bell Co., Ltd." },
        { 0x08482C, "Raycore Taiwan Co., LTD." },
        { 0x084ACF, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x084E1C, "H2A Systems, LLC" },
        { 0x084EBF, "Sumitomo Electric Industries, Ltd" },
        { 0x084F0A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x084FA9, "Cisco Systems, Inc" },
        { 0x084FF9, "Cisco Systems, Inc" },
        { 0x085114, "QINGDAO TOPSCOMM COMMUNICATION CO., LTD" },
        { 0x08512E, "Orion Diagnostica Oy" },
        { 0x085240, "EbV Elektronikbau- und Vertriebs GmbH" },
        { 0x0854BB, "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD" },
        { 0x085531, "Routerboard.com" },
        { 0x085700, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x0858A5, "Beijing Vrv Software Corpoaration Limited." },
        { 0x085AE0, "Recovision Technology Co., Ltd." },
        { 0x085B0E, "Fortinet, Inc." },
        { 0x085BD6, "Intel Corporate" },
        { 0x085BDA, "CliniCare LTD" },
        { 0x085DDD, "MERCURY CORPORATION" },
        { 0x08606E, "ASUSTek COMPUTER INC." },
        { 0x086083, "zte corporation" },
        { 0x086195, "Rockwell Automation" },
        { 0x086266, "ASUSTek COMPUTER INC." },
        { 0x086361, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0865F0, "JM Zengge Co., Ltd" },
        { 0x08661F, "Palo Alto Networks" },
        { 0x086698, "Apple, Inc." },
        { 0x08674E, "Hisense broadband multimedia technology Co.,Ltd" },
        { 0x08688D, "New H3C Technologies Co., Ltd" },
        { 0x0868D0, "Japan System Design" },
        { 0x0868EA, "EITO ELECTRONICS CO., LTD." },
        { 0x086A0A, "ASKEY COMPUTER CORP" },
        { 0x086BD1, "Shenzhen SuperElectron Technology Co.,Ltd." },
        { 0x086BD7, "Silicon Laboratories" },
        { 0x086D41, "Apple, Inc." },
        { 0x086DF2, "Shenzhen MIMOWAVE Technology Co.,Ltd" },
        { 0x087045, "Apple, Inc." },
        { 0x087190, "Intel Corporate" },
        { 0x087402, "Apple, Inc." },
        { 0x0874F6, "Winterhalter Gastronom GmbH" },
        { 0x087572, "Obelux Oy" },
        { 0x087618, "ViE Technologies Sdn. Bhd." },
        { 0x087695, "Auto Industrial Co., Ltd." },
        { 0x0876FF, "Thomson Telecom Belgium" },
        { 0x087808, "Samsung Electronics Co.,Ltd" },
        { 0x087999, "AIM GmbH" },
        { 0x087A4C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x087BAA, "SVYAZKOMPLEKTSERVICE, LLC" },
        { 0x087C39, "Amazon Technologies Inc." },
        { 0x087CBE, "Quintic Corp." },
        { 0x087D21, "Altasec technology corporation" },
        { 0x087E64, "Technicolor CH USA Inc." },
        { 0x087F98, "vivo Mobile Communication Co., Ltd." },
        { 0x088039, "Cisco SPVTG" },
        { 0x0881BC, "HongKong Ipro Technology Co., Limited" },
        { 0x0881F4, "Juniper Networks" },
        { 0x088466, "Novartis Pharma AG" },
        { 0x08849D, "Amazon Technologies Inc." },
        { 0x088620, "TECNO MOBILE LIMITED" },
        { 0x08863B, "Belkin International Inc." },
        { 0x0887C6, "INGRAM MICRO SERVICES" },
        { 0x088C2C, "Samsung Electronics Co.,Ltd" },
        { 0x088DC8, "Ryowa Electronics Co.,Ltd" },
        { 0x088E4F, "SF Software Solutions" },
        { 0x088F2C, "Amber Technology Ltd." },
        { 0x0890BA, "Danlaw Inc" },
        { 0x089356, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0894EF, "Wistron Infocomm (Zhongshan) Corporation" },
        { 0x08952A, "Technicolor CH USA Inc." },
        { 0x0896AD, "Cisco Systems, Inc" },
        { 0x0896D7, "AVM GmbH" },
        { 0x089734, "Hewlett Packard Enterprise" },
        { 0x089758, "Shenzhen Strong Rising Electronics Co.,Ltd DongGuan Subsidiary" },
        { 0x089798, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x089B4B, "iKuai Networks" },
        { 0x089BB9, "Nokia" },
        { 0x089C86, "Nokia Shanghai Bell Co., Ltd." },
        { 0x089E01, "Quanta Computer Inc." },
        { 0x089E08, "Google, Inc." },
        { 0x089F97, "LEROY AUTOMATION" },
        { 0x08A12B, "ShenZhen EZL Technology Co., Ltd" },
        { 0x08A5C8, "Sunnovo International Limited" },
        { 0x08A6BC, "Amazon Technologies Inc." },
        { 0x08A8A1, "Cyclotronics Power Concepts, Inc" },
        { 0x08A95A, "AzureWave Technology Inc." },
        { 0x08AA55, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x08ACA5, "Benu Video, Inc." },
        { 0x08ACC4, "FMTech" },
        { 0x08AED6, "Samsung Electronics Co.,Ltd" },
        { 0x08AF78, "Totus Solutions, Inc." },
        { 0x08B055, "ASKEY COMPUTER CORP" },
        { 0x08B0A7, "Truebeyond Co., Ltd" },
        { 0x08B258, "Juniper Networks" },
        { 0x08B2A3, "Cynny Italia S.r.L." },
        { 0x08B3AF, "vivo Mobile Communication Co., Ltd." },
        { 0x08B4CF, "Abicom International" },
        { 0x08B738, "Lite-On Technogy Corp." },
        { 0x08B7EC, "Wireless Seismic" },
        { 0x08BA22, "Swaive Corporation" },
        { 0x08BA5F, "Qingdao Hisense Electronics Co.,Ltd." },
        { 0x08BBCC, "AK-NORD EDV VERTRIEBSGES. mbH" },
        { 0x08BC20, "Hangzhou Royal Cloud Technology Co., Ltd" },
        { 0x08BD43, "NETGEAR" },
        { 0x08BE09, "Astrol Electronic AG" },
        { 0x08BE77, "Green Electronics" },
        { 0x08BEAC, "Edimax Technology Co. Ltd." },
        { 0x08BFA0, "Samsung Electronics Co.,Ltd" },
        { 0x08C021, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x08C0EB, "Mellanox Technologies, Inc." },
        { 0x08C5E1, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x08C6B3, "QTECH LLC" },
        { 0x08CA45, "Toyou Feiji Electronics Co., Ltd." },
        { 0x08CBE5, "R3 - Reliable Realtime Radio Communications GmbH" },
        { 0x08CC27, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x08CC68, "Cisco Systems, Inc" },
        { 0x08CCA7, "Cisco Systems, Inc" },
        { 0x08CD9B, "samtec automotive electronics & software GmbH" },
        { 0x08D09F, "Cisco Systems, Inc" },
        { 0x08D0B7, "Qingdao Hisense Communications Co.,Ltd." },
        { 0x08D23E, "Intel Corporate" },
        { 0x08D29A, "Proformatique" },
        { 0x08D34B, "Techman Electronics (Changshu) Co., Ltd." },
        { 0x08D40C, "Intel Corporate" },
        { 0x08D42B, "Samsung Electronics Co.,Ltd" },
        { 0x08D46A, "LG Electronics (Mobile Communications)" },
        { 0x08D59D, "Sagemcom Broadband SAS" },
        { 0x08D5C0, "Seers Technology Co., Ltd" },
        { 0x08D833, "Shenzhen RF Technology Co., Ltd" },
        { 0x08DF1F, "Bose Corporation" },
        { 0x08DFCB, "Systrome Networks" },
        { 0x08E5DA, "NANJING FUJITSU COMPUTER PRODUCTS CO.,LTD." },
        { 0x08E672, "JEBSEE ELECTRONICS CO.,LTD." },
        { 0x08E689, "Apple, Inc." },
        { 0x08E84F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x08E9F6, "AMPAK Technology,Inc." },
        { 0x08EA40, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x08EA44, "Extreme Networks, Inc." },
        { 0x08EB29, "Jiangsu Huitong Group Co.,Ltd." },
        { 0x08EB74, "HUMAX Co., Ltd." },
        { 0x08EBED, "World Elite Technology Co.,LTD" },
        { 0x08ECA9, "Samsung Electronics Co.,Ltd" },
        { 0x08ECF5, "Cisco Systems, Inc" },
        { 0x08ED02, "IEEE Registration Authority" },
        { 0x08ED9D, "TECNO MOBILE LIMITED" },
        { 0x08EDB9, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x08EDED, "Zhejiang Dahua Technology Co., Ltd." },
        { 0x08EE8B, "Samsung Electronics Co.,Ltd" },
        { 0x08EF3B, "MCS Logic Inc." },
        { 0x08EFAB, "SAYME WIRELESS SENSOR NETWORK" },
        { 0x08F1B7, "Towerstream Corpration" },
        { 0x08F1EA, "Hewlett Packard Enterprise" },
        { 0x08F2F4, "Net One Partners Co.,Ltd." },
        { 0x08F458, "Huawei Device Co., Ltd." },
        { 0x08F4AB, "Apple, Inc." },
        { 0x08F69C, "Apple, Inc." },
        { 0x08F6F8, "GET Engineering" },
        { 0x08F728, "GLOBO Multimedia Sp. z o.o. Sp.k." },
        { 0x08F7E9, "HRCP Research and Development Partnership" },
        { 0x08F8BC, "Apple, Inc." },
        { 0x08FA79, "vivo Mobile Communication Co., Ltd." },
        { 0x08FAE0, "Fohhn Audio AG" },
        { 0x08FBEA, "AMPAK Technology,Inc." },
        { 0x08FC52, "OpenXS BV" },
        { 0x08FC88, "Samsung Electronics Co.,Ltd" },
        { 0x08FD0E, "Samsung Electronics Co.,Ltd" },
        { 0x0C01DB, "Infinix mobility limited" },
        { 0x0C0227, "Technicolor CH USA Inc." },
        { 0x0C0400, "Jantar d.o.o." },
        { 0x0C0535, "Juniper Systems" },
        { 0x0C08B4, "HUMAX Co., Ltd." },
        { 0x0C1105, "AKUVOX (XIAMEN) NETWORKS CO., LTD" },
        { 0x0C1167, "Cisco Systems, Inc" },
        { 0x0C1262, "zte corporation" },
        { 0x0C130B, "Uniqoteq Ltd." },
        { 0x0C1420, "Samsung Electronics Co.,Ltd" },
        { 0x0C14D2, "China Mobile Group Device Co.,Ltd." },
        { 0x0C1539, "Apple, Inc." },
        { 0x0C15C5, "SDTEC Co., Ltd." },
        { 0x0C1773, "Huawei Device Co., Ltd." },
        { 0x0C17F1, "TELECSYS" },
        { 0x0C191F, "Inform Electronik" },
        { 0x0C1A10, "Acoustic Stream" },
        { 0x0C1C19, "LONGCONN ELECTRONICS(SHENZHEN) CO.,LTD" },
        { 0x0C1C20, "Kakao Corp" },
        { 0x0C1C57, "Texas Instruments" },
        { 0x0C1DAF, "Xiaomi Communications Co Ltd" },
        { 0x0C1DC2, "SeAH Networks" },
        { 0x0C2026, "noax Technologies AG" },
        { 0x0C20D3, "vivo Mobile Communication Co., Ltd." },
        { 0x0C2138, "Hengstler GmbH" },
        { 0x0C2369, "Honeywell SPS" },
        { 0x0C2576, "LONGCHEER TELECOMMUNICATION LIMITED" },
        { 0x0C2724, "Cisco Systems, Inc" },
        { 0x0C2755, "Valuable Techologies Limited" },
        { 0x0C29EF, "Dell Inc." },
        { 0x0C2A69, "electric imp, incorporated" },
        { 0x0C2A86, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x0C2AE7, "Beijing General Research Institute of Mining and Metallurgy" },
        { 0x0C2C54, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0C2D89, "QiiQ Communications Inc." },
        { 0x0C2FB0, "Samsung Electronics Co.,Ltd" },
        { 0x0C3021, "Apple, Inc." },
        { 0x0C31DC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0C354F, "Nokia" },
        { 0x0C35FE, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x0C3747, "zte corporation" },
        { 0x0C3796, "BIZLINK TECHNOLOGY, INC." },
        { 0x0C37DC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0C383E, "Fanvil Technology Co., Ltd." },
        { 0x0C3956, "Observator instruments" },
        { 0x0C3AFA, "New H3C Technologies Co., Ltd" },
        { 0x0C3B50, "Apple, Inc." },
        { 0x0C3C65, "Dome Imaging Inc" },
        { 0x0C3CCD, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x0C3E9F, "Apple, Inc." },
        { 0x0C4101, "Ruichi Auto Technology (Guangzhou) Co., Ltd." },
        { 0x0C413E, "Microsoft Corporation" },
        { 0x0C41E9, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0C42A1, "Mellanox Technologies, Inc." },
        { 0x0C45BA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0C469D, "MS Sedco" },
        { 0x0C473D, "Hitron Technologies. Inc" },
        { 0x0C47C9, "Amazon Technologies Inc." },
        { 0x0C4885, "LG Electronics (Mobile Communications)" },
        { 0x0C48C6, "CELESTICA INC." },
        { 0x0C4933, "Sichuan Jiuzhou Electronic Technology Co., Ltd." },
        { 0x0C4B54, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x0C4C39, "MitraStar Technology Corp." },
        { 0x0C4DE9, "Apple, Inc." },
        { 0x0C4F5A, "ASA-RT s.r.l." },
        { 0x0C5101, "Apple, Inc." },
        { 0x0C51F7, "CHAUVIN ARNOUX" },
        { 0x0C5203, "AGM GROUP LIMITED" },
        { 0x0C5331, "ETH Zurich" },
        { 0x0C5415, "Intel Corporate" },
        { 0x0C54A5, "PEGATRON CORPORATION" },
        { 0x0C54B9, "Nokia" },
        { 0x0C5521, "Axiros GmbH" },
        { 0x0C565C, "HyBroad Vision (Hong Kong) Technology Co Ltd" },
        { 0x0C57EB, "Mueller Systems" },
        { 0x0C5842, "DME Micro" },
        { 0x0C599C, "Juniper Networks" },
        { 0x0C5A19, "Axtion Sdn Bhd" },
        { 0x0C5A9E, "Wi-SUN Alliance" },
        { 0x0C5CD8, "DOLI Elektronik GmbH" },
        { 0x0C5F35, "Niagara Video Corporation" },
        { 0x0C6076, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x0C6111, "Anda Technologies SAC" },
        { 0x0C6127, "Actiontec Electronics, Inc" },
        { 0x0C61CF, "Texas Instruments" },
        { 0x0C62A6, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x0C63FC, "Nanjing Signway Technology Co., Ltd" },
        { 0x0C6803, "Cisco Systems, Inc" },
        { 0x0C6ABC, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x0C6AE6, "Stanley Security Solutions" },
        { 0x0C6E4F, "PrimeVOLT Co., Ltd." },
        { 0x0C6F9C, "Shaw Communications Inc." },
        { 0x0C704A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0C715D, "Samsung Electronics Co.,Ltd" },
        { 0x0C722C, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x0C72D9, "zte corporation" },
        { 0x0C73BE, "Dongguan Haimai Electronie Technology Co.,Ltd" },
        { 0x0C73EB, "IEEE Registration Authority" },
        { 0x0C74C2, "Apple, Inc." },
        { 0x0C7512, "Shenzhen Kunlun TongTai Technology Co.,Ltd." },
        { 0x0C7523, "BEIJING GEHUA CATV NETWORK CO.,LTD" },
        { 0x0C756C, "Anaren Microwave, Inc." },
        { 0x0C75BD, "Cisco Systems, Inc" },
        { 0x0C771A, "Apple, Inc." },
        { 0x0C7A15, "Intel Corporate" },
        { 0x0C7C28, "Nokia" },
        { 0x0C7D7C, "Kexiang Information Technology Co, Ltd." },
        { 0x0C8063, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x0C8112, "Private" },
        { 0x0C8126, "Juniper Networks" },
        { 0x0C817D, "EEP Elektro-Elektronik Pranjic GmbH" },
        { 0x0C8230, "SHENZHEN MAGNUS TECHNOLOGIES CO.,LTD" },
        { 0x0C8268, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x0C826A, "Wuhan Huagong Genuine Optics Technology Co., Ltd" },
        { 0x0C839A, "Huawei Device Co., Ltd." },
        { 0x0C8411, "A.O. Smith Water Products" },
        { 0x0C8447, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x0C8484, "Zenovia Electronics Inc." },
        { 0x0C84DC, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x0C8525, "Cisco Systems, Inc" },
        { 0x0C8610, "Juniper Networks" },
        { 0x0C8910, "Samsung Electronics Co.,Ltd" },
        { 0x0C8A87, "AgLogica Holdings, Inc" },
        { 0x0C8B7D, "Vizio, Inc" },
        { 0x0C8BD3, "ITEL MOBILE LIMITED" },
        { 0x0C8BFD, "Intel Corporate" },
        { 0x0C8C24, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x0C8C8F, "Kamo Technology Limited" },
        { 0x0C8CDC, "Suunto Oy" },
        { 0x0C8D98, "TOP EIGHT IND CORP" },
        { 0x0C8DDB, "Cisco Meraki" },
        { 0x0C8E29, "Arcadyan Corporation" },
        { 0x0C8FFF, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0C9160, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x0C924E, "Rice Lake Weighing Systems" },
        { 0x0C9301, "PT. Prasimax Inovasi Teknologi" },
        { 0x0C93FB, "BNS Solutions" },
        { 0x0C9541, "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP." },
        { 0x0C96BF, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0C96E6, "Cloud Network Technology (Samoa) Limited" },
        { 0x0C9838, "Xiaomi Communications Co Ltd" },
        { 0x0C9A42, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x0C9B13, "Shanghai Magic Mobile Telecommunication Co.Ltd." },
        { 0x0C9D56, "Consort Controls Ltd" },
        { 0x0C9D92, "ASUSTek COMPUTER INC." },
        { 0x0C9E91, "Sankosha Corporation" },
        { 0x0CA06C, "Industrial Cyber Sensing Inc." },
        { 0x0CA138, "Blinq Wireless Inc." },
        { 0x0CA2F4, "Chameleon Technology (UK) Limited" },
        { 0x0CA402, "Alcatel-Lucent IPD" },
        { 0x0CA42A, "OB Telecom Electronic Technology Co., Ltd" },
        { 0x0CA694, "Sunitec Enterprise Co.,Ltd" },
        { 0x0CA8A7, "Samsung Electronics Co.,Ltd" },
        { 0x0CAC05, "Unitend Technologies Inc." },
        { 0x0CAE7D, "Texas Instruments" },
        { 0x0CAF5A, "GENUS POWER INFRASTRUCTURES LIMITED" },
        { 0x0CB2B7, "Texas Instruments" },
        { 0x0CB319, "Samsung Electronics Co.,Ltd" },
        { 0x0CB34F, "Shenzhen Xiaoqi Intelligent Technology Co., Ltd." },
        { 0x0CB459, "Marketech International Corp." },
        { 0x0CB4A4, "Xintai Automobile Intelligent Network Technology" },
        { 0x0CB4EF, "Digience Co.,Ltd." },
        { 0x0CB527, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0CB5DE, "Alcatel Lucent" },
        { 0x0CB6D2, "D-Link International" },
        { 0x0CB771, "ARRIS Group, Inc." },
        { 0x0CB789, "Honor Device Co., Ltd." },
        { 0x0CB912, "JM-DATA GmbH" },
        { 0x0CB937, "Ubee Interactive Co., Limited" },
        { 0x0CBC9F, "Apple, Inc." },
        { 0x0CBD51, "TCT mobile ltd" },
        { 0x0CBF15, "Genetec Inc." },
        { 0x0CBF3F, "Shenzhen Lencotion Technology Co.,Ltd" },
        { 0x0CBF74, "Morse Micro" },
        { 0x0CC0C0, "MAGNETI MARELLI SISTEMAS ELECTRONICOS MEXICO" },
        { 0x0CC3A7, "Meritec" },
        { 0x0CC47A, "Super Micro Computer, Inc." },
        { 0x0CC47E, "EUCAST Co., Ltd." },
        { 0x0CC655, "Wuxi YSTen Technology Co.,Ltd." },
        { 0x0CC66A, "Nokia Corporation" },
        { 0x0CC6AC, "DAGS" },
        { 0x0CC6CC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0CC731, "Currant, Inc." },
        { 0x0CC81F, "Summer Infant, Inc." },
        { 0x0CC844, "Cambridge Mobile Telematics, Inc." },
        { 0x0CC9C6, "Samwin Hong Kong Limited" },
        { 0x0CCB85, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x0CCB8D, "ASCO Numatics GmbH" },
        { 0x0CCC26, "Airenetworks" },
        { 0x0CCDD3, "EASTRIVER TECHNOLOGY CO., LTD." },
        { 0x0CCDFB, "EDIC Systems Inc." },
        { 0x0CCEF6, "Guizhou Fortuneship Technology Co., Ltd" },
        { 0x0CCFD1, "SPRINGWAVE Co., Ltd" },
        { 0x0CD0F8, "Cisco Systems, Inc" },
        { 0x0CD292, "Intel Corporate" },
        { 0x0CD2B5, "Binatone Telecommunication Pvt. Ltd" },
        { 0x0CD502, "Westell Technologies Inc." },
        { 0x0CD696, "Amimon Ltd" },
        { 0x0CD6BD, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x0CD746, "Apple, Inc." },
        { 0x0CD7C2, "Axium Technologies, Inc." },
        { 0x0CD86C, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x0CD996, "Cisco Systems, Inc" },
        { 0x0CD9C1, "Visteon Corporation" },
        { 0x0CDA41, "Hangzhou H3C Technologies Co., Limited" },
        { 0x0CDC7E, "Espressif Inc." },
        { 0x0CDCCC, "Inala Technologies" },
        { 0x0CDD24, "Intel Corporate" },
        { 0x0CDDEF, "Nokia Corporation" },
        { 0x0CDFA4, "Samsung Electronics Co.,Ltd" },
        { 0x0CE041, "iDruide" },
        { 0x0CE0DC, "Samsung Electronics Co.,Ltd" },
        { 0x0CE0E4, "PLANTRONICS, INC." },
        { 0x0CE4A0, "Huawei Device Co., Ltd." },
        { 0x0CE5D3, "DH electronics GmbH" },
        { 0x0CE709, "Fox Crypto B.V." },
        { 0x0CE725, "Microsoft Corporation" },
        { 0x0CE82F, "Bonfiglioli Vectron GmbH" },
        { 0x0CE936, "ELIMOS srl" },
        { 0x0CE99A, "ATLS ALTEC" },
        { 0x0CEAC9, "ARRIS Group, Inc." },
        { 0x0CEC80, "Texas Instruments" },
        { 0x0CEC84, "Shenzhen TINNO Mobile Technology Corp." },
        { 0x0CEC8D, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x0CEE99, "Amazon Technologies Inc." },
        { 0x0CEEE6, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x0CEF7C, "AnaCom Inc" },
        { 0x0CEFAF, "IEEE Registration Authority" },
        { 0x0CF019, "Malgn Technology Co., Ltd." },
        { 0x0CF0B4, "Globalsat International Technology Ltd" },
        { 0x0CF346, "Xiaomi Communications Co Ltd" },
        { 0x0CF361, "Java Information" },
        { 0x0CF3EE, "EM Microelectronic" },
        { 0x0CF405, "Beijing Signalway Technologies Co.,Ltd" },
        { 0x0CF475, "Zliide Technologies ApS" },
        { 0x0CF4D5, "Ruckus Wireless" },
        { 0x0CF5A4, "Cisco Systems, Inc" },
        { 0x0CF893, "ARRIS Group, Inc." },
        { 0x0CF9C0, "BSkyB Ltd" },
        { 0x0CFC83, "Airoha Technology Corp.," },
        { 0x0CFD37, "SUSE Linux GmbH" },
        { 0x0CFE45, "Sony Interactive Entertainment Inc." },
        { 0x0CFE5D, "IEEE Registration Authority" },
        { 0x100000, "Private" },
        { 0x10005A, "IBM Corp" },
        { 0x1000E8, "NATIONAL SEMICONDUCTOR" },
        { 0x1000FD, "LaonPeople" },
        { 0x100177, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1001CA, "Ashley Butterworth" },
        { 0x1002B5, "Intel Corporate" },
        { 0x100501, "PEGATRON CORPORATION" },
        { 0x1005B1, "ARRIS Group, Inc." },
        { 0x1005CA, "Cisco Systems, Inc" },
        { 0x1005E1, "Nokia" },
        { 0x100645, "Sagemcom Broadband SAS" },
        { 0x100723, "IEEE Registration Authority" },
        { 0x1007B6, "Samsung Electronics Co.,Ltd" },
        { 0x10082C, "Texas Instruments" },
        { 0x1008B1, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x10090C, "Janome Sewing Machine Co., Ltd." },
        { 0x100BA9, "Intel Corporate" },
        { 0x100C24, "pomdevices, LLC" },
        { 0x100C6B, "NETGEAR" },
        { 0x100D2F, "Online Security Pty. Ltd." },
        { 0x100D32, "Embedian, Inc." },
        { 0x100D7F, "NETGEAR" },
        { 0x100E2B, "NEC CASIO Mobile Communications" },
        { 0x100E7E, "Juniper Networks" },
        { 0x100F18, "Fu Gang Electronic(KunShan)CO.,LTD" },
        { 0x1010B6, "McCain Inc" },
        { 0x101212, "Vivo International Corporation Pty Ltd" },
        { 0x101218, "Korins Inc." },
        { 0x101248, "ITG, Inc." },
        { 0x101250, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x1012B4, "SICHUAN TIANYI COMHEART TELECOM CO.,LTD" },
        { 0x1012FB, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x101331, "Technicolor" },
        { 0x1013EE, "Justec International Technology INC." },
        { 0x10189E, "Elmo Motion Control" },
        { 0x101965, "New H3C Technologies Co., Ltd" },
        { 0x101B54, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x101C0C, "Apple, Inc." },
        { 0x101D51, "8Mesh Networks Limited" },
        { 0x101DC0, "Samsung Electronics Co.,Ltd" },
        { 0x101F74, "Hewlett Packard" },
        { 0x102279, "ZeroDesktop, Inc." },
        { 0x102779, "Sadel S.p.A." },
        { 0x1027BE, "TVIP" },
        { 0x102831, "Morion Inc." },
        { 0x102959, "Apple, Inc." },
        { 0x1029AB, "Samsung Electronics Co.,Ltd" },
        { 0x102AB3, "Xiaomi Communications Co Ltd" },
        { 0x102C6B, "AMPAK Technology, Inc." },
        { 0x102C83, "XIMEA" },
        { 0x102D31, "Shenzhen Americas Trading Company LLC" },
        { 0x102D96, "Looxcie Inc." },
        { 0x102EAF, "Texas Instruments" },
        { 0x102F6B, "Microsoft Corporation" },
        { 0x102FA3, "Shenzhen Uvision-tech Technology Co.Ltd" },
        { 0x103025, "Apple, Inc." },
        { 0x103034, "Cara Systems" },
        { 0x103047, "Samsung Electronics Co.,Ltd" },
        { 0x10327E, "Huawei Device Co., Ltd." },
        { 0x103378, "FLECTRON Co., LTD" },
        { 0x1033BF, "Technicolor CH USA Inc." },
        { 0x10341B, "Spacelink" },
        { 0x10364A, "Boston Dynamics" },
        { 0x103711, "Simlink AS" },
        { 0x103917, "Samsung Electronics Co.,Ltd" },
        { 0x1039E9, "Juniper Networks" },
        { 0x103B59, "Samsung Electronics Co.,Ltd" },
        { 0x103D0A, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x103D3E, "China Mobile Group Device Co.,Ltd." },
        { 0x103DEA, "HFC Technology (Beijing) Ltd. Co." },
        { 0x103F44, "Xiaomi Communications Co Ltd" },
        { 0x1040F3, "Apple, Inc." },
        { 0x10417F, "Apple, Inc." },
        { 0x104369, "Soundmax Electronic Limited" },
        { 0x104400, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x10445A, "Shaanxi Hitech Electronic Co., LTD" },
        { 0x1045BE, "Norphonic AS" },
        { 0x1045F8, "LNT-Automation GmbH" },
        { 0x1046B4, "FormericaOE" },
        { 0x104780, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1048B1, "Beijing Duokan Technology Limited" },
        { 0x104963, "HARTING K.K." },
        { 0x104A7D, "Intel Corporate" },
        { 0x104B46, "Mitsubishi Electric Corporation" },
        { 0x104D77, "Innovative Computer Engineering" },
        { 0x104E07, "Shanghai Genvision Industries Co.,Ltd" },
        { 0x104E89, "Garmin International" },
        { 0x104F58, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x104FA8, "Sony Corporation" },
        { 0x105072, "Sercomm Corporation." },
        { 0x105172, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x10521C, "Espressif Inc." },
        { 0x105611, "ARRIS Group, Inc." },
        { 0x1056CA, "Peplink International Ltd." },
        { 0x105887, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x105917, "Tonal" },
        { 0x105932, "Roku, Inc" },
        { 0x105AF7, "ADB Italia" },
        { 0x105BAD, "Mega Well Limited" },
        { 0x105C3B, "Perma-Pipe, Inc." },
        { 0x105CBF, "DuroByte Inc" },
        { 0x105DDC, "Huawei Device Co., Ltd." },
        { 0x105F06, "Actiontec Electronics, Inc" },
        { 0x105F49, "Cisco SPVTG" },
        { 0x105FD4, "Tendyron Corporation" },
        { 0x10604B, "Hewlett Packard" },
        { 0x1062C9, "Adatis GmbH & Co. KG" },
        { 0x1062D0, "Technicolor CH USA Inc." },
        { 0x1062E5, "Hewlett Packard" },
        { 0x1062EB, "D-Link International" },
        { 0x1063C8, "Liteon Technology Corporation" },
        { 0x1064E2, "ADFweb.com s.r.l." },
        { 0x106530, "Dell Inc." },
        { 0x1065A3, "Panamax LLC" },
        { 0x1065CF, "IQSIM" },
        { 0x106682, "NEC Platforms, Ltd." },
        { 0x10683F, "LG Electronics (Mobile Communications)" },
        { 0x106F3F, "BUFFALO.INC" },
        { 0x106FEF, "Ad-Sol Nissin Corp" },
        { 0x1070FD, "Mellanox Technologies, Inc." },
        { 0x107100, "Huawei Device Co., Ltd." },
        { 0x1071F9, "Cloud Telecomputers, LLC" },
        { 0x107223, "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO" },
        { 0x10746F, "MOTOROLA SOLUTIONS MALAYSIA SDN. BHD." },
        { 0x10768A, "EoCell" },
        { 0x107717, "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD" },
        { 0x1077B0, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x1077B1, "Samsung Electronics Co.,Ltd" },
        { 0x10785B, "Actiontec Electronics, Inc" },
        { 0x107873, "Shenzhen Jinkeyi Communication Co., Ltd." },
        { 0x1078CE, "Hanvit SI, Inc." },
        { 0x1078D2, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x107A86, "U&U ENGINEERING INC." },
        { 0x107B44, "ASUSTek COMPUTER INC." },
        { 0x107BA4, "Olive & Dove Co.,Ltd." },
        { 0x107BEF, "Zyxel Communications Corporation" },
        { 0x107D1A, "Dell Inc." },
        { 0x1081B4, "Hunan Greatwall Galaxy Science and Technology Co.,Ltd." },
        { 0x108286, "Luxshare Precision Industry Co.,Ltd" },
        { 0x1083D2, "Microseven Systems, LLC" },
        { 0x10868C, "ARRIS Group, Inc." },
        { 0x10880F, "Daruma Telecomunicações e Informática S.A." },
        { 0x1088CE, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x1089FB, "Samsung Electronics Co.,Ltd" },
        { 0x108A1B, "RAONIX Inc." },
        { 0x108B6A, "Antailiye Technology Co.,Ltd" },
        { 0x108CCF, "Cisco Systems, Inc" },
        { 0x108EBA, "Molekule" },
        { 0x108EE0, "Samsung Electronics Co.,Ltd" },
        { 0x109266, "Samsung Electronics Co.,Ltd" },
        { 0x109397, "ARRIS Group, Inc." },
        { 0x1093E9, "Apple, Inc." },
        { 0x1094BB, "Apple, Inc." },
        { 0x10954B, "Megabyte Ltd." },
        { 0x109693, "Amazon Technologies Inc." },
        { 0x109836, "Dell Inc." },
        { 0x1098C3, "Murata Manufacturing Co., Ltd." },
        { 0x109AB9, "Tosibox Oy" },
        { 0x109ADD, "Apple, Inc." },
        { 0x109C70, "Prusa Research s.r.o." },
        { 0x109D7A, "Huawei Device Co., Ltd." },
        { 0x109E3A, "Zhejiang Tmall Technology Co., Ltd." },
        { 0x109FA9, "Actiontec Electronics, Inc" },
        { 0x10A13B, "FUJIKURA RUBBER LTD." },
        { 0x10A24E, "GOLD3LINK ELECTRONICS CO., LTD" },
        { 0x10A3B8, "Iskratel d.o.o." },
        { 0x10A4B9, "Baidu Online Network Technology (Beijing) Co., Ltd" },
        { 0x10A4BE, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x10A5D0, "Murata Manufacturing Co., Ltd." },
        { 0x10A659, "Mobile Create Co.,Ltd." },
        { 0x10A743, "SK Mtek Limited" },
        { 0x10A932, "Beijing Cyber Cloud Technology Co. ,Ltd." },
        { 0x10AE60, "Private" },
        { 0x10AF78, "Shenzhen ATUE Technology Co., Ltd" },
        { 0x10B1F8, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x10B26B, "base Co.,Ltd." },
        { 0x10B36F, "Bowei Technology Company Limited" },
        { 0x10B3C6, "Cisco Systems, Inc" },
        { 0x10B3D5, "Cisco Systems, Inc" },
        { 0x10B3D6, "Cisco Systems, Inc" },
        { 0x10B713, "Private" },
        { 0x10B7F6, "Plastoform Industries Ltd." },
        { 0x10B9F7, "Niko-Servodan" },
        { 0x10B9FE, "Lika srl" },
        { 0x10BAA5, "GANA I&C CO., LTD" },
        { 0x10BC97, "vivo Mobile Communication Co., Ltd." },
        { 0x10BD18, "Cisco Systems, Inc" },
        { 0x10BD55, "Q-Lab Corporation" },
        { 0x10BEF5, "D-Link International" },
        { 0x10BF48, "ASUSTek COMPUTER INC." },
        { 0x10C07C, "Blu-ray Disc Association" },
        { 0x10C172, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x10C22F, "China Entropy Co., Ltd." },
        { 0x10C25A, "Technicolor CH USA Inc." },
        { 0x10C2BA, "UTT Co., Ltd." },
        { 0x10C37B, "ASUSTek COMPUTER INC." },
        { 0x10C3AB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x10C586, "BIO SOUND LAB CO., LTD." },
        { 0x10C595, "Lenovo" },
        { 0x10C60C, "Domino UK Ltd" },
        { 0x10C61F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x10C65E, "Adapt-IP" },
        { 0x10C67E, "SHENZHEN JUCHIN TECHNOLOGY CO., LTD" },
        { 0x10C6FC, "Garmin International" },
        { 0x10C73F, "Midas Klark Teknik Ltd" },
        { 0x10C753, "Qingdao Intelligent&Precise Electronics Co.,Ltd." },
        { 0x10CA81, "PRECIA" },
        { 0x10CC1B, "Liverock technologies,INC" },
        { 0x10CCDB, "AXIMUM PRODUITS ELECTRONIQUES" },
        { 0x10CD6E, "FISYS" },
        { 0x10CDAE, "Avaya Inc" },
        { 0x10CDB6, "Essential Products, Inc." },
        { 0x10CE45, "Miromico AG" },
        { 0x10CEA9, "Texas Instruments" },
        { 0x10D07A, "AMPAK Technology, Inc." },
        { 0x10D0AB, "zte corporation" },
        { 0x10D1DC, "INSTAR Deutschland GmbH" },
        { 0x10D38A, "Samsung Electronics Co.,Ltd" },
        { 0x10D542, "Samsung Electronics Co.,Ltd" },
        { 0x10D7B0, "Sagemcom Broadband SAS" },
        { 0x10DA43, "NETGEAR" },
        { 0x10DC4A, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x10DCB6, "IEEE Registration Authority" },
        { 0x10DDB1, "Apple, Inc." },
        { 0x10DDF4, "Maxway Electronics CO.,LTD" },
        { 0x10DEE4, "automationNEXT GmbH" },
        { 0x10DF8B, "Shenzhen CareDear Communication Technology Co.,Ltd" },
        { 0x10DFFC, "Siemens AG" },
        { 0x10E2D5, "Qi Hardware Inc." },
        { 0x10E3C7, "Seohwa Telecom" },
        { 0x10E4AF, "APR, LLC" },
        { 0x10E68F, "KWANGSUNG ELECTRONICS KOREA CO.,LTD." },
        { 0x10E6AE, "Source Technologies, LLC" },
        { 0x10E77A, "STMicrolectronics International NV" },
        { 0x10E7C6, "Hewlett Packard" },
        { 0x10E878, "Nokia" },
        { 0x10E8EE, "PhaseSpace" },
        { 0x10E953, "Huawei Device Co., Ltd." },
        { 0x10EA59, "Cisco SPVTG" },
        { 0x10EED9, "Canoga Perkins Corporation" },
        { 0x10F005, "Intel Corporate" },
        { 0x10F163, "TNK CO.,LTD" },
        { 0x10F1F2, "LG Electronics (Mobile Communications)" },
        { 0x10F311, "Cisco Systems, Inc" },
        { 0x10F3DB, "Gridco Systems, Inc." },
        { 0x10F49A, "T3 Innovation" },
        { 0x10F681, "vivo Mobile Communication Co., Ltd." },
        { 0x10F920, "Cisco Systems, Inc" },
        { 0x10F96F, "LG Electronics (Mobile Communications)" },
        { 0x10F9EB, "Industria Fueguina de Relojería Electrónica s.a." },
        { 0x10F9EE, "Nokia Corporation" },
        { 0x10FACE, "Reacheng Communication Technology Co.,Ltd" },
        { 0x10FBF0, "KangSheng LTD." },
        { 0x10FC54, "Shany Electronic Co., Ltd." },
        { 0x10FCB6, "mirusystems CO.,LTD" },
        { 0x10FEED, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x1100AA, "Private" },
        { 0x111111, "Private" },
        { 0x14007D, "zte corporation" },
        { 0x140152, "Samsung Electronics Co.,Ltd" },
        { 0x1402EC, "Hewlett Packard Enterprise" },
        { 0x140467, "SNK Technologies Co.,Ltd." },
        { 0x140708, "Private" },
        { 0x1407E0, "Abrantix AG" },
        { 0x1409DC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x140AC5, "Amazon Technologies Inc." },
        { 0x140C5B, "PLNetworks" },
        { 0x140C76, "FREEBOX SAS" },
        { 0x140D4F, "Flextronics International" },
        { 0x140F42, "Nokia" },
        { 0x14109F, "Apple, Inc." },
        { 0x141114, "TECNO MOBILE LIMITED" },
        { 0x14115D, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x141330, "Anakreon UK LLP" },
        { 0x141333, "AzureWave Technology Inc." },
        { 0x141346, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x141357, "ATP Electronics, Inc." },
        { 0x1413FB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x14144B, "Ruijie Networks Co.,LTD" },
        { 0x141459, "Vodafone Italia S.p.A." },
        { 0x1414E6, "Ningbo Sanhe Digital Co.,Ltd" },
        { 0x14157C, "TOKYO COSMOS ELECTRIC CO.,LTD." },
        { 0x14169D, "Cisco Systems, Inc" },
        { 0x14169E, "Wingtech Group (HongKong）Limited" },
        { 0x141877, "Dell Inc." },
        { 0x141A51, "Treetech Sistemas Digitais" },
        { 0x141AA3, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x141B30, "Shenzhen Yipingfang Network Technology Co., Ltd." },
        { 0x141BBD, "Volex Inc." },
        { 0x141BF0, "Intellimedia Systems Ltd" },
        { 0x141F78, "Samsung Electronics Co.,Ltd" },
        { 0x141FBA, "IEEE Registration Authority" },
        { 0x14205E, "Apple, Inc." },
        { 0x142233, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x1422DB, "eero inc." },
        { 0x1423D7, "EUTRONIX CO., LTD." },
        { 0x142475, "4DReplay, Inc" },
        { 0x142882, "MIDICOM ELECTRONICS CO.LTD" },
        { 0x142971, "NEMOA ELECTRONICS (HK) CO. LTD" },
        { 0x142A14, "ShenZhen Selenview Digital Technology Co.,Ltd" },
        { 0x142BD2, "Armtel Ltd." },
        { 0x142BD6, "Guangdong Appscomm Co.,Ltd" },
        { 0x142C78, "GooWi Wireless Technology Co., Limited" },
        { 0x142D27, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x142D8B, "Incipio Technologies, Inc" },
        { 0x142DF5, "Amphitech" },
        { 0x142E5E, "Sercomm Corporation." },
        { 0x142FFD, "LT SECURITY INC" },
        { 0x143004, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x14307A, "Avermetrics" },
        { 0x1430C6, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x1432D1, "Samsung Electronics Co.,Ltd" },
        { 0x143365, "TEM Mobile Limited" },
        { 0x14358B, "Mediabridge Products, LLC." },
        { 0x1435B3, "Future Designs, Inc." },
        { 0x143605, "Nokia Corporation" },
        { 0x1436C6, "Lenovo Mobile Communication Technology Ltd." },
        { 0x143719, "PT Prakarsa Visi Valutama" },
        { 0x14373B, "PROCOM Systems" },
        { 0x143AEA, "Dynapower Company LLC" },
        { 0x143CC3, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x143DF2, "Beijing Shidai Hongyuan Network Communication Co.,Ltd" },
        { 0x143E60, "Nokia" },
        { 0x143EBF, "zte corporation" },
        { 0x143F27, "Noccela Oy" },
        { 0x143FC3, "SnapAV" },
        { 0x144146, "Honeywell (China) Co., LTD" },
        { 0x1441E2, "Monaco Enterprises, Inc." },
        { 0x1442FC, "Texas Instruments" },
        { 0x144319, "Creative&Link Technology Limited" },
        { 0x14444A, "Apollo Seiko Ltd." },
        { 0x1446E4, "AVISTEL" },
        { 0x14472D, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x144802, "THE YEOLRIM Co.,Ltd." },
        { 0x14488B, "Shenzhen Doov Technology Co.,Ltd" },
        { 0x144978, "Digital Control Incorporated" },
        { 0x1449BC, "DrayTek Corp." },
        { 0x1449E0, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x144C1A, "Max Communication GmbH" },
        { 0x144D67, "Zioncom Electronics (Shenzhen) Ltd." },
        { 0x144E2A, "Ciena Corporation" },
        { 0x144E34, "Remote Solution" },
        { 0x144F8A, "Intel Corporate" },
        { 0x144FD7, "IEEE Registration Authority" },
        { 0x145120, "Huawei Device Co., Ltd." },
        { 0x145290, "KNS Group LLC (YADRO Company)" },
        { 0x145412, "Entis Co., Ltd." },
        { 0x14563A, "Huawei Device Co., Ltd." },
        { 0x145645, "Savitech Corp." },
        { 0x14568E, "Samsung Electronics Co.,Ltd" },
        { 0x14579F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1458D0, "Hewlett Packard" },
        { 0x1459C0, "NETGEAR" },
        { 0x1459C3, "Creative Chips GmbH" },
        { 0x145A05, "Apple, Inc." },
        { 0x145A83, "Logi-D inc" },
        { 0x145BD1, "ARRIS Group, Inc." },
        { 0x145BE1, "nyantec GmbH" },
        { 0x145E45, "Bamboo Systems Group" },
        { 0x145F94, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x146080, "zte corporation" },
        { 0x1460CB, "Apple, Inc." },
        { 0x146102, "Alpine Electronics, Inc." },
        { 0x14612F, "Avaya Inc" },
        { 0x146308, "JABIL CIRCUIT (SHANGHAI) LTD." },
        { 0x1469A2, "SICHUAN TIANYI COMHEART TELECOM CO.,LTD" },
        { 0x146A0B, "Cypress Electronics Limited" },
        { 0x146B72, "Shenzhen Fortune Ship Technology Co., Ltd." },
        { 0x146B9A, "zte corporation" },
        { 0x146B9C, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x146E0A, "Private" },
        { 0x147373, "TUBITAK UEKAE" },
        { 0x147411, "RIM" },
        { 0x147590, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x147740, "Huawei Device Co., Ltd." },
        { 0x14780B, "Varex Imaging Deutschland AG" },
        { 0x1479F3, "China Mobile Group Device Co.,Ltd." },
        { 0x147BAC, "Nokia" },
        { 0x147DB3, "JOA TELECOM.CO.,LTD" },
        { 0x147DC5, "Murata Manufacturing Co., Ltd." },
        { 0x147DDA, "Apple, Inc." },
        { 0x14825B, "Hefei Radio Communication Technology Co., Ltd" },
        { 0x148430, "MITAC COMPUTING TECHNOLOGY CORPORATION" },
        { 0x148692, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x14876A, "Apple, Inc." },
        { 0x1488E6, "Apple, Inc." },
        { 0x14893E, "VIXTEL TECHNOLOGIES LIMTED" },
        { 0x1489FD, "Samsung Electronics Co.,Ltd" },
        { 0x148A70, "ADS GmbH" },
        { 0x148F21, "Garmin International" },
        { 0x148FC6, "Apple, Inc." },
        { 0x149090, "KongTop industrial(shen zhen)CO.,LTD" },
        { 0x149138, "Amazon Technologies Inc." },
        { 0x149182, "Belkin International Inc." },
        { 0x149346, "PNI sensor corporation" },
        { 0x14942F, "USYS CO.,LTD." },
        { 0x149448, "BLU CASTLE S.A." },
        { 0x1495CE, "Apple, Inc." },
        { 0x1496E5, "Samsung Electronics Co.,Ltd" },
        { 0x14987D, "Technicolor CH USA Inc." },
        { 0x1499E2, "Apple, Inc." },
        { 0x149A10, "Microsoft Corporation" },
        { 0x149B2F, "JiangSu ZhongXie Intelligent Technology co., LTD" },
        { 0x149D09, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x149D99, "Apple, Inc." },
        { 0x149ECF, "Dell Inc." },
        { 0x149F3C, "Samsung Electronics Co.,Ltd" },
        { 0x149FB6, "GUANGDONG GENIUS TECHNOLOGY CO., LTD." },
        { 0x149FE8, "Lenovo Mobile Communication Technology Ltd." },
        { 0x14A0F8, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x14A1BF, "ASSA ABLOY Korea Co., Ltd Unilock" },
        { 0x14A2A0, "Cisco Systems, Inc" },
        { 0x14A32F, "Huawei Device Co., Ltd." },
        { 0x14A364, "Samsung Electronics Co.,Ltd" },
        { 0x14A51A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x14A62C, "S.M. Dezac S.A." },
        { 0x14A72B, "currentoptronics Pvt.Ltd" },
        { 0x14A78B, "Zhejiang Dahua Technology Co., Ltd." },
        { 0x14A86B, "ShenZhen Telacom Science&Technology Co., Ltd" },
        { 0x14A9D0, "F5 Networks, Inc." },
        { 0x14A9E3, "MST CORPORATION" },
        { 0x14AB02, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x14AB56, "WUXI FUNIDE DIGITAL CO.,LTD" },
        { 0x14ABC5, "Intel Corporate" },
        { 0x14ABF0, "ARRIS Group, Inc." },
        { 0x14ADCA, "China Mobile Iot Limited company" },
        { 0x14AE85, "IEEE Registration Authority" },
        { 0x14AEDB, "VTech Telecommunications Ltd." },
        { 0x14B126, "Industrial Software Co" },
        { 0x14B1C8, "InfiniWing, Inc." },
        { 0x14B31F, "Dell Inc." },
        { 0x14B370, "Gigaset Digital Technology (Shenzhen) Co., Ltd." },
        { 0x14B457, "Silicon Laboratories" },
        { 0x14B484, "Samsung Electronics Co.,Ltd" },
        { 0x14B73D, "ARCHEAN Technologies" },
        { 0x14B7F8, "Technicolor CH USA Inc." },
        { 0x14B837, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x14B968, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x14BB6E, "Samsung Electronics Co.,Ltd" },
        { 0x14BD61, "Apple, Inc." },
        { 0x14C03E, "ARRIS Group, Inc." },
        { 0x14C089, "DUNE HD LTD" },
        { 0x14C126, "Nokia Corporation" },
        { 0x14C14E, "Google, Inc." },
        { 0x14C1FF, "ShenZhen QianHai Comlan communication Co.,LTD" },
        { 0x14C213, "Apple, Inc." },
        { 0x14C21D, "Sabtech Industries" },
        { 0x14C3C2, "K.A. Schmersal GmbH & Co. KG" },
        { 0x14C697, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x14C88B, "Apple, Inc." },
        { 0x14C913, "LG Electronics" },
        { 0x14CAA0, "Hu&Co" },
        { 0x14CC20, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x14CCB3, "AO GK NATEKS" },
        { 0x14CF8D, "OHSUNG" },
        { 0x14CF92, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x14CFE2, "ARRIS Group, Inc." },
        { 0x14D00D, "Apple, Inc." },
        { 0x14D11F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x14D169, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x14D4FE, "ARRIS Group, Inc." },
        { 0x14D64D, "D-Link International" },
        { 0x14D76E, "CONCH ELECTRONIC Co.,Ltd" },
        { 0x14DAE9, "ASUSTek COMPUTER INC." },
        { 0x14DB85, "S NET MEDIA" },
        { 0x14DDA9, "ASUSTek COMPUTER INC." },
        { 0x14DDE5, "MPMKVVCL" },
        { 0x14DE39, "Huawei Device Co., Ltd." },
        { 0x14E4EC, "mLogic LLC" },
        { 0x14E6E4, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x14E7C8, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x14E9B2, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x14EB33, "BSMediasoft Co., Ltd." },
        { 0x14EDA5, "Wächter GmbH Sicherheitssysteme" },
        { 0x14EDBB, "2Wire Inc" },
        { 0x14EDE4, "Kaiam Corporation" },
        { 0x14EE9D, "AirNav Systems LLC" },
        { 0x14EFCF, "SCHREDER" },
        { 0x14F0C5, "Xtremio Ltd." },
        { 0x14F28E, "ShenYang ZhongKe-Allwin Technology Co.LTD" },
        { 0x14F42A, "Samsung Electronics Co.,Ltd" },
        { 0x14F65A, "Xiaomi Communications Co Ltd" },
        { 0x14F6D8, "Intel Corporate" },
        { 0x14F893, "Wuhan FiberHome Digital Technology Co.,Ltd." },
        { 0x14FEAF, "SAGITTAR LIMITED" },
        { 0x14FEB5, "Dell Inc." },
        { 0x18002D, "Sony Mobile Communications Inc" },
        { 0x1800DB, "Fitbit Inc." },
        { 0x18017D, "Harbin Arteor technology co., LTD" },
        { 0x1801E3, "Bittium Wireless Ltd" },
        { 0x1801F1, "Xiaomi Communications Co Ltd" },
        { 0x18022D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1802AE, "vivo Mobile Communication Co., Ltd." },
        { 0x180373, "Dell Inc." },
        { 0x1803FA, "IBT Interfaces" },
        { 0x1804ED, "Texas Instruments" },
        { 0x180675, "Dilax Intelcom GmbH" },
        { 0x1806F5, "RAD Data Communications, Ltd." },
        { 0x1806FF, "Acer Computer(Shanghai) Limited." },
        { 0x180B52, "Nanotron Technologies GmbH" },
        { 0x180C14, "iSonea Limited" },
        { 0x180C77, "Westinghouse Electric Company, LLC" },
        { 0x180CAC, "CANON INC." },
        { 0x180D2C, "Intelbras" },
        { 0x180F76, "D-Link International" },
        { 0x18104E, "CEDINT-UPM" },
        { 0x181171, "Guangzhou Doctorpai Education & Technology Co.,Ltd" },
        { 0x181212, "Cepton Technologies" },
        { 0x18132D, "zte corporation" },
        { 0x181420, "TEB SAS" },
        { 0x181456, "Nokia Corporation" },
        { 0x1816C9, "Samsung Electronics Co.,Ltd" },
        { 0x181714, "DAEWOOIS" },
        { 0x181725, "Cameo Communications, Inc." },
        { 0x18193F, "Tamtron Oy" },
        { 0x1819D6, "Samsung Electronics Co.,Ltd" },
        { 0x181BEB, "Actiontec Electronics, Inc" },
        { 0x181DEA, "Intel Corporate" },
        { 0x181E78, "Sagemcom Broadband SAS" },
        { 0x181E95, "AuVerte" },
        { 0x181EB0, "Samsung Electronics Co.,Ltd" },
        { 0x182012, "Aztech Associates Inc." },
        { 0x182032, "Apple, Inc." },
        { 0x18204C, "Kummler+Matter AG" },
        { 0x1820A6, "Sage Co., Ltd." },
        { 0x1820D5, "ARRIS Group, Inc." },
        { 0x182195, "Samsung Electronics Co.,Ltd" },
        { 0x18227E, "Samsung Electronics Co.,Ltd" },
        { 0x182649, "Intel Corporate" },
        { 0x182666, "Samsung Electronics Co.,Ltd" },
        { 0x182861, "AirTies Wireless Networks" },
        { 0x182A44, "HIROSE ELECTRONIC SYSTEM" },
        { 0x182A7B, "Nintendo Co., Ltd." },
        { 0x182AD3, "Juniper Networks" },
        { 0x182B05, "8D Technologies" },
        { 0x182C91, "Concept Development, Inc." },
        { 0x182CB4, "Nectarsoft Co., Ltd." },
        { 0x182D98, "Jinwoo Industrial system" },
        { 0x183009, "Woojin Industrial Systems Co., Ltd." },
        { 0x18300C, "Hisense Electric Co.,Ltd" },
        { 0x1831BF, "ASUSTek COMPUTER INC." },
        { 0x1832A2, "LAON TECHNOLOGY CO., LTD." },
        { 0x18339D, "Cisco Systems, Inc" },
        { 0x183451, "Apple, Inc." },
        { 0x1835D1, "ARRIS Group, Inc." },
        { 0x183672, "Shaoxing ShunChuang Technology CO.,LTD" },
        { 0x1836FC, "Elecsys International Corporation" },
        { 0x183825, "Wuhan Lingjiu High-tech Co.,Ltd." },
        { 0x183864, "CAP-TECH INTERNATIONAL CO., LTD." },
        { 0x1838AE, "CONSPIN SOLUTION" },
        { 0x183919, "Unicoi Systems" },
        { 0x18396E, "SUNSEA TELECOMMUNICATIONS CO.,LTD." },
        { 0x18399C, "Skorpios Technologies" },
        { 0x183A2D, "Samsung Electronics Co.,Ltd" },
        { 0x183A48, "VostroNet" },
        { 0x183BD2, "BYD Precision Manufacture Company Ltd." },
        { 0x183CB7, "Huawei Device Co., Ltd." },
        { 0x183D5E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x183DA2, "Intel Corporate" },
        { 0x183EEF, "Apple, Inc." },
        { 0x183F47, "Samsung Electronics Co.,Ltd" },
        { 0x1840A4, "Shenzhen Trylong Smart Science and Technology Co., Ltd." },
        { 0x1841FE, "Digital 14" },
        { 0x18421D, "Private" },
        { 0x18422F, "Alcatel Lucent" },
        { 0x184462, "Riava Networks, Inc." },
        { 0x1844E6, "zte corporation" },
        { 0x184516, "Texas Instruments" },
        { 0x184593, "Taicang T&W Electronics" },
        { 0x184617, "Samsung Electronics Co.,Ltd" },
        { 0x184644, "Home Control Singapore Pte Ltd" },
        { 0x18473D, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x1848CA, "Murata Manufacturing Co., Ltd." },
        { 0x1848D8, "Fastback Networks" },
        { 0x184A6F, "Alcatel-Lucent Shanghai Bell Co., Ltd" },
        { 0x184B0D, "Ruckus Wireless" },
        { 0x184BDF, "Caavo Inc" },
        { 0x184C08, "Rockwell Automation" },
        { 0x184E16, "Samsung Electronics Co.,Ltd" },
        { 0x184E94, "MESSOA TECHNOLOGIES INC." },
        { 0x184ECB, "Samsung Electronics Co.,Ltd" },
        { 0x184F32, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x184F5D, "JRC Mobility Inc." },
        { 0x18502A, "SOARNEX" },
        { 0x185207, "SICHUAN TIANYI COMHEART TELECOMCO., LTD" },
        { 0x185253, "Pixord Corporation" },
        { 0x185282, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x1853E0, "Hanyang Digitech Co.Ltd" },
        { 0x1854CF, "Samsung Electronics Co.,Ltd" },
        { 0x18550F, "Cisco SPVTG" },
        { 0x1855E3, "Apple, Inc." },
        { 0x185644, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x185680, "Intel Corporate" },
        { 0x185869, "Sailer Electronic Co., Ltd" },
        { 0x185933, "Cisco SPVTG" },
        { 0x185936, "Xiaomi Communications Co Ltd" },
        { 0x185A58, "Dell Inc." },
        { 0x185AE8, "Zenotech.Co.,Ltd" },
        { 0x185BB3, "Samsung Electronics Co.,Ltd" },
        { 0x185D9A, "BobjGear LLC" },
        { 0x185E0F, "Intel Corporate" },
        { 0x186024, "Hewlett Packard" },
        { 0x1861C7, "lemonbeat GmbH" },
        { 0x18622C, "Sagemcom Broadband SAS" },
        { 0x1862E4, "Texas Instruments" },
        { 0x186472, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x186571, "Top Victory Electronics (Taiwan) Co., Ltd." },
        { 0x186590, "Apple, Inc." },
        { 0x1866C7, "Shenzhen Libre Technology Co., Ltd" },
        { 0x1866DA, "Dell Inc." },
        { 0x1866E3, "Veros Systems, Inc." },
        { 0x18673F, "Hanover Displays Limited" },
        { 0x186751, "KOMEG Industrielle Messtechnik GmbH" },
        { 0x1867B0, "Samsung Electronics Co.,Ltd" },
        { 0x18686A, "zte corporation" },
        { 0x186882, "Beward R&D Co., Ltd." },
        { 0x1868CB, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x1869D8, "HANGZHOU AIXIANGJI TECHNOLOGY CO., LTD" },
        { 0x1869DA, "China Mobile Group Device Co.,Ltd." },
        { 0x186D99, "Adanis Inc." },
        { 0x186F2D, "Shenzhen Sundray Technologies Company Limited" },
        { 0x18703B, "Huawei Device Co., Ltd." },
        { 0x187117, "eta plus electronic gmbh" },
        { 0x1871D5, "Hazens Automotive Electronics(SZ)Co.,Ltd." },
        { 0x18742E, "Amazon Technologies Inc." },
        { 0x187532, "SICHUAN TIANYI COMHEART TELECOMCO., LTD" },
        { 0x1878D4, "Verizon" },
        { 0x1879A2, "GMJ ELECTRIC LIMITED" },
        { 0x187A93, "AMICCOM Electronics Corporation" },
        { 0x187C0B, "Ruckus Wireless" },
        { 0x187C81, "Valeo Vision Systems" },
        { 0x187EB9, "Apple, Inc." },
        { 0x187ED5, "shenzhen kaism technology Co. Ltd" },
        { 0x188090, "Cisco Systems, Inc" },
        { 0x1880CE, "Barberry Solutions Ltd" },
        { 0x1880F5, "Alcatel-Lucent Shanghai Bell Co., Ltd" },
        { 0x18810E, "Apple, Inc." },
        { 0x188219, "Alibaba Cloud Computing Ltd." },
        { 0x18828C, "Arcadyan Corporation" },
        { 0x188331, "Samsung Electronics Co.,Ltd" },
        { 0x1883BF, "Arcadyan Technology Corporation" },
        { 0x188410, "CoreTrust Inc." },
        { 0x18863A, "DIGITAL ART SYSTEM" },
        { 0x1886AC, "Nokia Danmark A/S" },
        { 0x188740, "Xiaomi Communications Co Ltd" },
        { 0x188796, "HTC Corporation" },
        { 0x188857, "Beijing Jinhong Xi-Dian Information Technology Corp." },
        { 0x18895B, "Samsung Electronics Co.,Ltd" },
        { 0x1889A0, "Wuhan Funshion Online Technologies Co.,Ltd" },
        { 0x1889DF, "CerebrEX Inc." },
        { 0x188A6A, "AVPro Global Hldgs" },
        { 0x188B15, "ShenZhen ZhongRuiJing Technology co.,LTD" },
        { 0x188B45, "Cisco Systems, Inc" },
        { 0x188B9D, "Cisco Systems, Inc" },
        { 0x188ED5, "TP Vision Belgium N.V. - innovation site Brugge" },
        { 0x188EF9, "G2C Co. Ltd." },
        { 0x189088, "eero inc." },
        { 0x1890D8, "Sagemcom Broadband SAS" },
        { 0x18922C, "Virtual Instruments" },
        { 0x1892A4, "Ciena Corporation" },
        { 0x18937F, "AMPAK Technology, Inc." },
        { 0x1893D7, "Texas Instruments" },
        { 0x1894C6, "ShenZhen Chenyee Technology Co., Ltd." },
        { 0x189552, "1MORE" },
        { 0x1897FF, "TechFaith Wireless Technology Limited" },
        { 0x1899F5, "Sichuan Changhong Electric Ltd." },
        { 0x189A67, "CSE-Servelec Limited" },
        { 0x189BA5, "IEEE Registration Authority" },
        { 0x189C27, "ARRIS Group, Inc." },
        { 0x189C5D, "Cisco Systems, Inc" },
        { 0x189E2C, "Huawei Device Co., Ltd." },
        { 0x189EFC, "Apple, Inc." },
        { 0x18A28A, "Essel-T Co., Ltd" },
        { 0x18A3E8, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x18A4A9, "Vanu Inc." },
        { 0x18A6F7, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x18A7F1, "Qingdao Haier Technology Co.,Ltd" },
        { 0x18A905, "Hewlett Packard" },
        { 0x18A958, "PROVISION THAI CO., LTD." },
        { 0x18A99B, "Dell Inc." },
        { 0x18AA0F, "Huawei Device Co., Ltd." },
        { 0x18AA45, "Fon Technology" },
        { 0x18AACA, "Sichuan tianyi kanghe communications co., LTD" },
        { 0x18AB1D, "Samsung Electronics Co.,Ltd" },
        { 0x18ABF5, "Ultra Electronics Electrics" },
        { 0x18AC9E, "ITEL MOBILE LIMITED" },
        { 0x18AD4D, "Polostar Technology Corporation" },
        { 0x18AEBB, "Siemens Convergence Creators GmbH&Co.KG" },
        { 0x18AF61, "Apple, Inc." },
        { 0x18AF8F, "Apple, Inc." },
        { 0x18AF9F, "DIGITRONIC Automationsanlagen GmbH" },
        { 0x18B169, "Sonicwall" },
        { 0x18B209, "Torrey Pines Logic, Inc" },
        { 0x18B3BA, "Netlogic AB" },
        { 0x18B430, "Nest Labs Inc." },
        { 0x18B591, "I-Storm" },
        { 0x18B6CC, "We Corporation Inc." },
        { 0x18B6F7, "NEW POS TECHNOLOGY LIMITED" },
        { 0x18B79E, "Invoxia" },
        { 0x18B81F, "ARRIS Group, Inc." },
        { 0x18B905, "Hong Kong Bouffalo Lab Limited" },
        { 0x18BB26, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x18BC5A, "Zhejiang Tmall Technology Co., Ltd." },
        { 0x18BDAD, "L-TECH CORPORATION" },
        { 0x18BE92, "Delta Networks, Inc." },
        { 0x18BF1C, "Jiangsu Huitong Group Co.,Ltd." },
        { 0x18C04D, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x18C086, "Broadcom" },
        { 0x18C19D, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x18C2BF, "BUFFALO.INC" },
        { 0x18C451, "Tucson Embedded Systems" },
        { 0x18C501, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x18C58A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x18C8E7, "Shenzhen Hualistone Technology Co.,Ltd" },
        { 0x18CC18, "Intel Corporate" },
        { 0x18CC23, "Philio Technology Corporation" },
        { 0x18CC88, "Hitachi Johnson Controls Air" },
        { 0x18CF24, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x18CF5E, "Liteon Technology Corporation" },
        { 0x18D071, "DASAN CO., LTD." },
        { 0x18D0C5, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x18D225, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x18D276, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x18D5B6, "SMG Holdings LLC" },
        { 0x18D61C, "Shenzhen TINNO Mobile Technology Corp." },
        { 0x18D66A, "Inmarsat" },
        { 0x18D6C7, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x18D6CF, "Kurth Electronic GmbH" },
        { 0x18D717, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x18D949, "Qvis Labs, LLC" },
        { 0x18D98F, "Huawei Device Co., Ltd." },
        { 0x18D9EF, "Shuttle Inc." },
        { 0x18DBF2, "Dell Inc." },
        { 0x18DC56, "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd" },
        { 0x18DED7, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x18DFB4, "BOSUNG POWERTEC CO.,LTD." },
        { 0x18DFC1, "Aetheros" },
        { 0x18E1CA, "wanze" },
        { 0x18E288, "STT Condigi" },
        { 0x18E29F, "vivo Mobile Communication Co., Ltd." },
        { 0x18E2C2, "Samsung Electronics Co.,Ltd" },
        { 0x18E3BC, "TCT mobile ltd" },
        { 0x18E728, "Cisco Systems, Inc" },
        { 0x18E777, "vivo Mobile Communication Co., Ltd." },
        { 0x18E7F4, "Apple, Inc." },
        { 0x18E80F, "Viking Electronics Inc." },
        { 0x18E829, "Ubiquiti Networks Inc." },
        { 0x18E8DD, "MODULETEK" },
        { 0x18ECE7, "BUFFALO.INC" },
        { 0x18EE69, "Apple, Inc." },
        { 0x18EE86, "Novatel Wireless Solutions, Inc." },
        { 0x18EF63, "Cisco Systems, Inc" },
        { 0x18F0E4, "Xiaomi Communications Co Ltd" },
        { 0x18F145, "NetComm Wireless Limited" },
        { 0x18F18E, "ChipER Technology co. ltd" },
        { 0x18F1D8, "Apple, Inc." },
        { 0x18F292, "Shannon Systems" },
        { 0x18F46A, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x18F643, "Apple, Inc." },
        { 0x18F650, "Multimedia Pacific Limited" },
        { 0x18F76B, "Zhejiang Winsight Technology CO.,LTD" },
        { 0x18F87A, "i3 International Inc." },
        { 0x18F9C4, "BAE Systems" },
        { 0x18FA6F, "ISC applied systems corp" },
        { 0x18FB7B, "Dell Inc." },
        { 0x18FC9F, "Changhe Electronics Co., Ltd." },
        { 0x18FDCB, "IEEE Registration Authority" },
        { 0x18FE34, "Espressif Inc." },
        { 0x18FF0F, "Intel Corporate" },
        { 0x18FF2E, "Shenzhen Rui Ying Da Technology Co., Ltd" },
        { 0x1C0042, "NARI Technology Co., Ltd." },
        { 0x1C012D, "Ficer Technology" },
        { 0x1C0219, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x1C05B7, "Chongqing Trantor Technology Co., Ltd." },
        { 0x1C0656, "IDY Corporation" },
        { 0x1C08C1, "LG Innotek" },
        { 0x1C0B52, "EPICOM S.A" },
        { 0x1C0FAF, "Lucid Vision Labs" },
        { 0x1C0FCF, "Sypro Optics GmbH" },
        { 0x1C1161, "Ciena Corporation" },
        { 0x1C11E1, "Wartsila Finland Oy" },
        { 0x1C129D, "IEEE PES PSRC/SUB" },
        { 0x1C12B0, "Amazon Technologies Inc." },
        { 0x1C1338, "Kimball Electronics Group, LLC" },
        { 0x1C1386, "Huawei Device Co., Ltd." },
        { 0x1C1448, "ARRIS Group, Inc." },
        { 0x1C14B3, "Airwire Technologies" },
        { 0x1C151F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C17D3, "Cisco Systems, Inc" },
        { 0x1C184A, "ShenZhen RicherLink Technologies Co.,LTD" },
        { 0x1C19DE, "eyevis GmbH" },
        { 0x1C1AC0, "Apple, Inc." },
        { 0x1C1ADF, "Microsoft Corporation" },
        { 0x1C1B0D, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x1C1B68, "ARRIS Group, Inc." },
        { 0x1C1BB5, "Intel Corporate" },
        { 0x1C1CFD, "Dalian Hi-Think Computer Technology, Corp" },
        { 0x1C1D67, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C1D86, "Cisco Systems, Inc" },
        { 0x1C1E38, "PCCW Global, Inc." },
        { 0x1C1EE3, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x1C1FD4, "LifeBEAM Technologies LTD" },
        { 0x1C1FF1, "Huawei Device Co., Ltd." },
        { 0x1C20DB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C21D1, "IEEE Registration Authority" },
        { 0x1C232C, "Samsung Electronics Co.,Ltd" },
        { 0x1C234F, "EDMI Europe Ltd" },
        { 0x1C24CD, "Askey Computer Corp." },
        { 0x1C24EB, "Burlywood" },
        { 0x1C25E1, "China Mobile IOT Company Limited" },
        { 0x1C2704, "zte corporation" },
        { 0x1C27DD, "Datang Gohighsec(zhejiang)Information Technology Co.,Ltd." },
        { 0x1C28AF, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x1C2AA3, "Shenzhen HongRui Optical Technology Co., Ltd." },
        { 0x1C2E1B, "Suzhou Tremenet Communication Technology Co., Ltd." },
        { 0x1C3008, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x1C330E, "PernixData" },
        { 0x1C334D, "ITS Telecom" },
        { 0x1C3477, "Innovation Wireless" },
        { 0x1C34DA, "Mellanox Technologies, Inc." },
        { 0x1C35F1, "NEW Lift Neue Elektronische Wege Steuerungsbau GmbH" },
        { 0x1C36BB, "Apple, Inc." },
        { 0x1C37BF, "Cloudium Systems Ltd." },
        { 0x1C3947, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x1C398A, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x1C3A4F, "AccuSpec Electronics, LLC" },
        { 0x1C3A60, "Ruckus Wireless" },
        { 0x1C3ADE, "Samsung Electronics Co.,Ltd" },
        { 0x1C3B8F, "Selve GmbH & Co. KG" },
        { 0x1C3BF3, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x1C3D2F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C3DE7, "Sigma Koki Co.,Ltd." },
        { 0x1C3E84, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x1C4024, "Dell Inc." },
        { 0x1C40E8, "SHENZHEN PROGRESS&WIN TECHNOLOGY CO.,LTD" },
        { 0x1C4158, "Gemalto M2M GmbH" },
        { 0x1C4176, "China Mobile Group Device Co.,Ltd." },
        { 0x1C427D, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x1C4363, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C43EC, "JAPAN CIRCUIT CO.,LTD" },
        { 0x1C4419, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x1C4455, "Sieb & Meyer AG" },
        { 0x1C4593, "Texas Instruments" },
        { 0x1C45C2, "Huizhou City Sunsin lntelligent Technology Co.,Ltd" },
        { 0x1C4840, "IMS Messsysteme GmbH" },
        { 0x1C48CE, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x1C48F9, "GN Netcom A/S" },
        { 0x1C497B, "Gemtek Technology Co., Ltd." },
        { 0x1C4AF7, "AMON INC" },
        { 0x1C4BB9, "SMG ENTERPRISE, LLC" },
        { 0x1C4BD6, "AzureWave Technology Inc." },
        { 0x1C4C48, "ITEL MOBILE LIMITED" },
        { 0x1C4D66, "Amazon Technologies Inc." },
        { 0x1C4D70, "Intel Corporate" },
        { 0x1C501E, "Sunplus Technology Co., Ltd." },
        { 0x1C51B5, "Techaya LTD" },
        { 0x1C5216, "DONGGUAN HELE ELECTRONICS CO., LTD" },
        { 0x1C52D6, "FLAT DISPLAY TECHNOLOGY CORPORATION" },
        { 0x1C549E, "Universal Electronics, Inc." },
        { 0x1C553A, "QianGua Corp." },
        { 0x1C56FE, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x1C57D8, "Kraftway Corporation PLC" },
        { 0x1C599B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C5A0B, "Tegile Systems" },
        { 0x1C5A3E, "Samsung Electronics Co.,Ltd" },
        { 0x1C5A6B, "Philips Electronics Nederland BV" },
        { 0x1C5C55, "PRIMA Cinema, Inc" },
        { 0x1C5C60, "Shenzhen Belzon Technology Co.,LTD." },
        { 0x1C5CF2, "Apple, Inc." },
        { 0x1C5D80, "Mitubishi Hitachi Power Systems Industries Co., Ltd." },
        { 0x1C5F2B, "D-Link International" },
        { 0x1C5FFF, "Beijing Ereneben Information Technology Co.,Ltd Shenzhen Branch" },
        { 0x1C60D2, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x1C60DE, "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x1C62B8, "Samsung Electronics Co.,Ltd" },
        { 0x1C63B7, "OpenProducts 237 AB" },
        { 0x1C63BF, "SHENZHEN BROADTEL TELECOM CO.,LTD" },
        { 0x1C6499, "Comtrend Corporation" },
        { 0x1C659D, "Liteon Technology Corporation" },
        { 0x1C666D, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x1C66AA, "Samsung Electronics Co.,Ltd" },
        { 0x1C6758, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C687E, "Shenzhen Qihu Intelligent Technology Company Limited" },
        { 0x1C697A, "EliteGroup Computer Systems Co., LTD" },
        { 0x1C69A5, "BlackBerry RTS" },
        { 0x1C6A7A, "Cisco Systems, Inc" },
        { 0x1C6BCA, "Mitsunami Co., Ltd." },
        { 0x1C6E4C, "Logistic Service & Engineering Co.,Ltd" },
        { 0x1C6E76, "Quarion Technology Inc" },
        { 0x1C6F65, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x1C7022, "Murata Manufacturing Co., Ltd." },
        { 0x1C721D, "Dell Inc." },
        { 0x1C7328, "Connected Home" },
        { 0x1C7370, "Neotech" },
        { 0x1C740D, "Zyxel Communications Corporation" },
        { 0x1C7508, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x1C76CA, "Terasic Technologies Inc." },
        { 0x1C77F6, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x1C7839, "Shenzhen Tencent Computer System Co., Ltd." },
        { 0x1C784E, "China Mobile Iot Limited company" },
        { 0x1C7B21, "Sony Mobile Communications Inc" },
        { 0x1C7B23, "Qingdao Hisense Communications Co.,Ltd." },
        { 0x1C7C11, "EID" },
        { 0x1C7C45, "Vitek Industrial Video Products, Inc." },
        { 0x1C7CC7, "Coriant GmbH" },
        { 0x1C7D22, "Fuji Xerox Co., Ltd." },
        { 0x1C7E51, "3bumen.com" },
        { 0x1C7EE5, "D-Link International" },
        { 0x1C7F2C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C8259, "IEEE Registration Authority" },
        { 0x1C8341, "Hefei Bitland Information Technology Co.Ltd" },
        { 0x1C83B0, "Linked IP GmbH" },
        { 0x1C8464, "FORMOSA WIRELESS COMMUNICATION CORP." },
        { 0x1C86AD, "MCT CO., LTD." },
        { 0x1C872C, "ASUSTek COMPUTER INC." },
        { 0x1C8E5C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1C8E8E, "DB Communication & Systems Co., ltd." },
        { 0x1C8F8A, "Phase Motion Control SpA" },
        { 0x1C90BE, "Ericsson AB" },
        { 0x1C9148, "Apple, Inc." },
        { 0x1C9179, "Integrated System Technologies Ltd" },
        { 0x1C919D, "Dongguan Liesheng Electronic Co., Ltd." },
        { 0x1C9492, "RUAG Schweiz AG" },
        { 0x1C955D, "I-LAX ELECTRONICS INC." },
        { 0x1C959F, "Veethree Electronics And Marine LLC" },
        { 0x1C965A, "WEIFANG GOERTEK ELECTRONICS CO.,LTD" },
        { 0x1C973D, "PRICOM Design" },
        { 0x1C97C5, "Ynomia Pty Ltd" },
        { 0x1C98C1, "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD." },
        { 0x1C98EC, "Hewlett Packard Enterprise" },
        { 0x1C994C, "Murata Manufacturing Co., Ltd." },
        { 0x1C9C26, "Zoovel Technologies" },
        { 0x1C9C8C, "Juniper Networks" },
        { 0x1C9D3E, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x1C9E46, "Apple, Inc." },
        { 0x1C9ECB, "Beijing Nari Smartchip Microelectronics Company Limited" },
        { 0x1C9F4E, "COOSEA GROUP (HK) COMPANY LIMITED" },
        { 0x1CA0B8, "Hon Hai Precision Ind. Co., Ltd." },
        { 0x1CA0D3, "IEEE Registration Authority" },
        { 0x1CA2B1, "ruwido austria gmbh" },
        { 0x1CA532, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x1CA770, "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD" },
        { 0x1CA852, "SENSAIO PTE LTD" },
        { 0x1CAA07, "Cisco Systems, Inc" },
        { 0x1CAB01, "Innovolt" },
        { 0x1CAB34, "New H3C Technologies Co., Ltd" },
        { 0x1CABA7, "Apple, Inc." },
        { 0x1CABC0, "Hitron Technologies. Inc" },
        { 0x1CADD1, "Bosung Electronics Co., Ltd." },
        { 0x1CAECB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1CAF05, "Samsung Electronics Co.,Ltd" },
        { 0x1CAFF7, "D-Link International" },
        { 0x1CB044, "ASKEY COMPUTER CORP" },
        { 0x1CB094, "HTC Corporation" },
        { 0x1CB17F, "NEC Platforms, Ltd." },
        { 0x1CB243, "TDC A/S" },
        { 0x1CB3E9, "Shenzhen Zhongke United Communication Technology" },
        { 0x1CB72C, "ASUSTek COMPUTER INC." },
        { 0x1CB796, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x1CB857, "Becon Technologies Co,.Ltd." },
        { 0x1CB9C4, "Ruckus Wireless" },
        { 0x1CBA8C, "Texas Instruments" },
        { 0x1CBBA8, "OJSC Ufimskiy Zavod Promsvyaz" },
        { 0x1CBD0E, "Amplified Engineering Pty Ltd" },
        { 0x1CBDB9, "D-Link International" },
        { 0x1CBFC0, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x1CBFCE, "Shenzhen Century Xinyang Technology Co., Ltd" },
        { 0x1CC035, "PLANEX COMMUNICATIONS INC." },
        { 0x1CC0E1, "IEEE Registration Authority" },
        { 0x1CC11A, "Wavetronix" },
        { 0x1CC1BC, "Yichip Microelectronics (Hangzhou) Co.,Ltd" },
        { 0x1CC1DE, "Hewlett Packard" },
        { 0x1CC316, "MileSight Technology Co., Ltd." },
        { 0x1CC3EB, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x1CC586, "Absolute Acoustics" },
        { 0x1CC63C, "Arcadyan Technology Corporation" },
        { 0x1CC72D, "Shenzhen Huapu Digital CO.,Ltd" },
        { 0x1CCAE3, "IEEE Registration Authority" },
        { 0x1CCB99, "TCT mobile ltd" },
        { 0x1CCCD6, "Xiaomi Communications Co Ltd" },
        { 0x1CCDE5, "Shanghai Wind Technologies Co.,Ltd" },
        { 0x1CD40C, "Kriwan Industrie-Elektronik GmbH" },
        { 0x1CD5E2, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x1CD6BD, "LEEDARSON LIGHTING CO., LTD." },
        { 0x1CD6BE, "Wistron Neweb Corporation" },
        { 0x1CDA27, "vivo Mobile Communication Co., Ltd." },
        { 0x1CDDEA, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x1CDE57, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x1CDEA7, "Cisco Systems, Inc" },
        { 0x1CDF0F, "Cisco Systems, Inc" },
        { 0x1CDF52, "Texas Instruments" },
        { 0x1CE165, "Marshal Corporation" },
        { 0x1CE192, "Qisda Corporation" },
        { 0x1CE2CC, "Texas Instruments" },
        { 0x1CE57F, "Samsung Electronics Co.,Ltd" },
        { 0x1CE61D, "Samsung Electronics Co.,Ltd" },
        { 0x1CE62B, "Apple, Inc." },
        { 0x1CE6C7, "Cisco Systems, Inc" },
        { 0x1CE85D, "Cisco Systems, Inc" },
        { 0x1CEA0B, "Edgecore Networks Corporation" },
        { 0x1CEA1B, "Nokia" },
        { 0x1CEC72, "Allradio Co., Ltd" },
        { 0x1CEEC9, "Elo touch solutions" },
        { 0x1CEEE8, "Ilshin Elecom" },
        { 0x1CEFCE, "bebro electronic GmbH" },
        { 0x1CF03E, "Wearhaus Inc." },
        { 0x1CF061, "SCAPS GmbH" },
        { 0x1CF29A, "Google, Inc." },
        { 0x1CF4CA, "Private" },
        { 0x1CF5E7, "Turtle Industry Co., Ltd." },
        { 0x1CFA68, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x1CFCBB, "Realfiction ApS" },
        { 0x1CFD08, "IEEE Registration Authority" },
        { 0x1CFE2B, "Amazon Technologies Inc." },
        { 0x1CFEA7, "IDentytech Solutins Ltd." },
        { 0x1CFF59, "Sichuan Tianyi Comheart Telecom Co., Ltd." },
        { 0x20014F, "Linea Research Ltd" },
        { 0x2002AF, "Murata Manufacturing Co., Ltd." },
        { 0x20040F, "Dell Inc." },
        { 0x200505, "RADMAX COMMUNICATION PRIVATE LIMITED" },
        { 0x2005E8, "OOO InProMedia" },
        { 0x2008ED, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x200A0D, "IEEE Registration Authority" },
        { 0x200A5E, "Xiangshan Giant Eagle Technology Developing Co., Ltd." },
        { 0x200BC7, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x200CC8, "NETGEAR" },
        { 0x200DB0, "Shenzhen Four Seas Global Link Network Technology Co., Ltd." },
        { 0x200E95, "IEC – TC9 WG43" },
        { 0x200F70, "FOXTECH" },
        { 0x20107A, "Gemtek Technology Co., Ltd." },
        { 0x20114E, "MeteRSit S.R.L." },
        { 0x201257, "Most Lucky Trading Ltd" },
        { 0x2012D5, "Scientech Materials Corporation" },
        { 0x2013E0, "Samsung Electronics Co.,Ltd" },
        { 0x20163D, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x2016B9, "Intel Corporate" },
        { 0x2016D8, "Liteon Technology Corporation" },
        { 0x201742, "LG Electronics" },
        { 0x20180E, "Shenzhen Sunchip Technology Co., Ltd" },
        { 0x201A06, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x201B88, "Dongguan Liesheng Electronic Co., Ltd." },
        { 0x201BC9, "Juniper Networks" },
        { 0x201D03, "Elatec GmbH" },
        { 0x201F31, "Inteno Broadband Technology AB" },
        { 0x2021A5, "LG Electronics (Mobile Communications)" },
        { 0x202564, "PEGATRON CORPORATION" },
        { 0x202598, "Teleview" },
        { 0x202681, "TECNO MOBILE LIMITED" },
        { 0x20283E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2028BC, "Visionscape Co,. Ltd." },
        { 0x202AC5, "Petite-En" },
        { 0x202BC1, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x202CB7, "Kong Yue Electronics & Information Industry (Xinhui) Ltd." },
        { 0x202D07, "Samsung Electronics Co.,Ltd" },
        { 0x202D23, "Collinear Networks Inc." },
        { 0x202DF8, "Digital Media Cartridge Ltd." },
        { 0x20311C, "vivo Mobile Communication Co., Ltd." },
        { 0x2031EB, "HDSN" },
        { 0x203233, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x20326C, "Samsung Electronics Co.,Ltd" },
        { 0x2034FB, "Xiaomi Communications Co Ltd" },
        { 0x20365B, "Megafone Limited" },
        { 0x2036D7, "Shanghai Reacheng Communication Technology Co.,Ltd" },
        { 0x203706, "Cisco Systems, Inc" },
        { 0x2037BC, "Kuipers Electronic Engineering BV" },
        { 0x203956, "HMD Global Oy" },
        { 0x203A07, "Cisco Systems, Inc" },
        { 0x203AEF, "Sivantos GmbH" },
        { 0x203CAE, "Apple, Inc." },
        { 0x203D66, "ARRIS Group, Inc." },
        { 0x203DB2, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x203DBD, "LG Innotek" },
        { 0x204005, "feno GmbH" },
        { 0x20415A, "Smarteh d.o.o." },
        { 0x20443A, "Schneider Electric Asia Pacific Ltd" },
        { 0x204441, "Remote Solution" },
        { 0x2046A1, "VECOW Co., Ltd" },
        { 0x2046F9, "Advanced Network Devices (dba:AND)" },
        { 0x204747, "Dell Inc." },
        { 0x2047DA, "Xiaomi Communications Co Ltd" },
        { 0x2047ED, "BSkyB Ltd" },
        { 0x204AAA, "Hanscan Spain S.A." },
        { 0x204C03, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x204C6D, "Hugo Brennenstuhl Gmbh & Co. KG." },
        { 0x204C9E, "Cisco Systems, Inc" },
        { 0x204E6B, "Axxana(israel) ltd" },
        { 0x204E71, "Juniper Networks" },
        { 0x204E7F, "NETGEAR" },
        { 0x204EF6, "AzureWave Technology Inc." },
        { 0x2050E7, "AMPAK Technology,Inc." },
        { 0x2053CA, "Risk Technology Ltd" },
        { 0x205476, "Sony Mobile Communications Inc" },
        { 0x2054FA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x205531, "Samsung Electronics Co.,Ltd" },
        { 0x205532, "Gotech International Technology Limited" },
        { 0x205721, "Salix Technology CO., Ltd." },
        { 0x2057AF, "Shenzhen FH-NET OPTOELECTRONICS CO.,LTD" },
        { 0x205869, "Ruckus Wireless" },
        { 0x2059A0, "Paragon Technologies Inc." },
        { 0x205A00, "Coval" },
        { 0x205B2A, "Private" },
        { 0x205B5E, "Shenzhen Wonhe Technology Co., Ltd" },
        { 0x205CFA, "Yangzhou ChangLian Network Technology Co,ltd." },
        { 0x205D47, "vivo Mobile Communication Co., Ltd." },
        { 0x205EF7, "Samsung Electronics Co.,Ltd" },
        { 0x205F3D, "Cambridge Communication Systems Ltd" },
        { 0x206274, "Microsoft Corporation" },
        { 0x20635F, "Abeeway" },
        { 0x206432, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x2064CB, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x20658E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x20677C, "Hewlett Packard Enterprise" },
        { 0x2067B1, "Pluto inc." },
        { 0x20689D, "Liteon Technology Corporation" },
        { 0x206980, "Apple, Inc." },
        { 0x206A8A, "Wistron Infocomm (Zhongshan) Corporation" },
        { 0x206AFF, "Atlas Elektronik UK Limited" },
        { 0x206BE7, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x206C8A, "Extreme Networks, Inc." },
        { 0x206D31, "FIREWALLA INC" },
        { 0x206E9C, "Samsung Electronics Co.,Ltd" },
        { 0x206FEC, "Braemac CA LLC" },
        { 0x20719E, "SF Technology Co.,Ltd" },
        { 0x207355, "ARRIS Group, Inc." },
        { 0x207454, "vivo Mobile Communication Co., Ltd." },
        { 0x2074CF, "Shenzhen Voxtech Co.,Ltd" },
        { 0x207600, "Actiontec Electronics, Inc" },
        { 0x20768F, "Apple, Inc." },
        { 0x207693, "Lenovo (Beijing) Limited." },
        { 0x207759, "OPTICAL NETWORK VIDEO TECHNOLOGIES (SHENZHEN) CO., LTD." },
        { 0x20780B, "Delta Faucet Company" },
        { 0x207852, "Nokia" },
        { 0x2078F0, "Apple, Inc." },
        { 0x207918, "Intel Corporate" },
        { 0x207C8F, "Quanta Microsystems,Inc." },
        { 0x207D74, "Apple, Inc." },
        { 0x208058, "Ciena Corporation" },
        { 0x20826A, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x2082C0, "Xiaomi Communications Co Ltd" },
        { 0x2083F8, "Advanced Digital Broadcast SA" },
        { 0x20858C, "Assa" },
        { 0x208593, "IEEE Registration Authority" },
        { 0x208756, "SIEMENS AG" },
        { 0x2087AC, "AES motomation" },
        { 0x20896F, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x208984, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x208986, "zte corporation" },
        { 0x208B37, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x20906F, "Shenzhen Tencent Computer System Co., Ltd." },
        { 0x209148, "Texas Instruments" },
        { 0x20918A, "PROFALUX" },
        { 0x2091D9, "I'M SPA" },
        { 0x20934D, "FUJIAN STAR-NET COMMUNICATION CO.,LTD" },
        { 0x20968A, "China Mobile (Hangzhou) Information Technology Co., Ltd." },
        { 0x2098D8, "Shenzhen Yingdakang Technology CO., LTD" },
        { 0x209A7D, "Sagemcom Broadband SAS" },
        { 0x209AE9, "Volacomm Co., Ltd" },
        { 0x209BA5, "JIAXING GLEAD Electronics Co.,Ltd" },
        { 0x209BCD, "Apple, Inc." },
        { 0x209E79, "Universal Electronics, Inc." },
        { 0x209EF7, "Extreme Networks, Inc." },
        { 0x20A171, "Amazon Technologies Inc." },
        { 0x20A2E4, "Apple, Inc." },
        { 0x20A2E7, "Lee-Dickens Ltd" },
        { 0x20A60C, "Xiaomi Communications Co Ltd" },
        { 0x20A680, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x20A6CD, "Hewlett Packard Enterprise" },
        { 0x20A783, "miControl GmbH" },
        { 0x20A787, "Bointec Taiwan Corporation Limited" },
        { 0x20A8B9, "SIEMENS AG" },
        { 0x20A90E, "TCT mobile ltd" },
        { 0x20A99B, "Microsoft Corporation" },
        { 0x20AA25, "IP-NET LLC" },
        { 0x20AA4B, "Cisco-Linksys, LLC" },
        { 0x20AB37, "Apple, Inc." },
        { 0x20AB48, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x20AC9C, "China Telecom Corporation Limited" },
        { 0x20AD56, "Continental Automotive Systems Inc." },
        { 0x20B001, "Technicolor" },
        { 0x20B0F7, "Enclustra GmbH" },
        { 0x20B399, "Enterasys" },
        { 0x20B5C6, "Mimosa Networks" },
        { 0x20B780, "Toshiba Visual Solutions Corporation Co.,Ltd" },
        { 0x20B7C0, "OMICRON electronics GmbH" },
        { 0x20BB76, "COL GIOVANNI PAOLO SpA" },
        { 0x20BBC0, "Cisco Systems, Inc" },
        { 0x20BBC6, "Jabil Circuit Hungary Ltd." },
        { 0x20BFDB, "DVL" },
        { 0x20C047, "Verizon" },
        { 0x20C06D, "SHENZHEN SPACETEK TECHNOLOGY CO.,LTD" },
        { 0x20C1AF, "i Wit Digital Co., Limited" },
        { 0x20C38F, "Texas Instruments" },
        { 0x20C3A4, "RetailNext" },
        { 0x20C60D, "Shanghai annijie Information technology Co.,LTD" },
        { 0x20C6EB, "Panasonic Corporation AVC Networks Company" },
        { 0x20C8B3, "SHENZHEN BUL-TECH CO.,LTD." },
        { 0x20C9D0, "Apple, Inc." },
        { 0x20CD39, "Texas Instruments" },
        { 0x20CD6E, "Realme Chongqing Mobile Telecommunications Corp.,Ltd." },
        { 0x20CEC4, "Peraso Technologies" },
        { 0x20CF30, "ASUSTek COMPUTER INC." },
        { 0x20D160, "Private" },
        { 0x20D21F, "Wincal Technology Corp." },
        { 0x20D25F, "SmartCap Technologies" },
        { 0x20D390, "Samsung Electronics Co.,Ltd" },
        { 0x20D5AB, "Korea Infocom Co.,Ltd." },
        { 0x20D5BF, "Samsung Electronics Co.,Ltd" },
        { 0x20D607, "Nokia Corporation" },
        { 0x20D75A, "Posh Mobile Limited" },
        { 0x20D80B, "Juniper Networks" },
        { 0x20D906, "Iota, Inc." },
        { 0x20DA22, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x20DBAB, "Samsung Electronics Co., Ltd." },
        { 0x20DC93, "Cheetah Hi-Tech, Inc." },
        { 0x20DCE6, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x20DCFD, "Huawei Device Co., Ltd." },
        { 0x20DE88, "IC Realtime LLC" },
        { 0x20DF3F, "Nanjing SAC Power Grid Automation Co., Ltd." },
        { 0x20DFB9, "Google, Inc." },
        { 0x20E09C, "Nokia" },
        { 0x20E2A8, "Apple, Inc." },
        { 0x20E407, "Spark srl" },
        { 0x20E52A, "NETGEAR" },
        { 0x20E564, "ARRIS Group, Inc." },
        { 0x20E791, "Siemens Healthcare Diagnostics, Inc" },
        { 0x20E874, "Apple, Inc." },
        { 0x20E882, "zte corporation" },
        { 0x20EAC7, "SHENZHEN RIOPINE ELECTRONICS CO., LTD" },
        { 0x20ED74, "Ability enterprise co.,Ltd." },
        { 0x20EE28, "Apple, Inc." },
        { 0x20EEC6, "Elefirst Science & Tech Co ., ltd" },
        { 0x20F002, "MTData Developments Pty. Ltd." },
        { 0x20F17C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x20F19E, "ARRIS Group, Inc." },
        { 0x20F375, "ARRIS Group, Inc." },
        { 0x20F3A3, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x20F41B, "Shenzhen Bilian electronic CO.,LTD" },
        { 0x20F44F, "Nokia" },
        { 0x20F452, "Shanghai IUV Software Development Co. Ltd" },
        { 0x20F478, "Xiaomi Communications Co Ltd" },
        { 0x20F510, "Codex Digital Limited" },
        { 0x20F543, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x20F77C, "vivo Mobile Communication Co., Ltd." },
        { 0x20F85E, "Delta Electronics" },
        { 0x20FABB, "Cambridge Executive Limited" },
        { 0x20FDF1, "3COM EUROPE LTD" },
        { 0x20FECD, "System In Frontier Inc." },
        { 0x20FEDB, "M2M Solution S.A.S." },
        { 0x2400BA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2400FA, "China Mobile (Hangzhou) Information Technology Co., Ltd" },
        { 0x24016F, "Huawei Device Co., Ltd." },
        { 0x2401C7, "Cisco Systems, Inc" },
        { 0x24050F, "MTN Electronic Co. Ltd" },
        { 0x240588, "Google, Inc." },
        { 0x2405F5, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x2406AA, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x240917, "Devlin Electronics Limited" },
        { 0x240995, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x240A11, "TCT mobile ltd" },
        { 0x240A63, "ARRIS Group, Inc." },
        { 0x240A64, "AzureWave Technology Inc." },
        { 0x240AC4, "Espressif Inc." },
        { 0x240B0A, "Palo Alto Networks" },
        { 0x240B2A, "Viettel Group" },
        { 0x240BB1, "KOSTAL Industrie Elektrik GmbH" },
        { 0x240D65, "Shenzhen Vsun Communication Technology Co., Ltd." },
        { 0x240D6C, "SMND" },
        { 0x240DC2, "TCT mobile ltd" },
        { 0x241064, "Shenzhen Ecsino Tecnical Co. Ltd" },
        { 0x241125, "Hutek Co., Ltd." },
        { 0x241145, "Xiaomi Communications Co Ltd" },
        { 0x241148, "Entropix, LLC" },
        { 0x2411D0, "Chongqing Ehs Science and Technology Development Co.,Ltd." },
        { 0x241407, "Xiamen Sigmastar Technology Ltd." },
        { 0x241510, "IEEE Registration Authority" },
        { 0x24166D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x24169D, "Cisco Systems, Inc" },
        { 0x24181D, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x241A8C, "Squarehead Technology AS" },
        { 0x241AE6, "Huawei Device Co., Ltd." },
        { 0x241B13, "Shanghai Nutshell Electronic Co., Ltd." },
        { 0x241B44, "Hangzhou Tuners Electronics Co., Ltd" },
        { 0x241B7A, "Apple, Inc." },
        { 0x241C04, "SHENZHEN JEHE TECHNOLOGY DEVELOPMENT CO., LTD." },
        { 0x241EEB, "Apple, Inc." },
        { 0x241F2C, "Calsys, Inc." },
        { 0x241FA0, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2420C7, "Sagemcom Broadband SAS" },
        { 0x242124, "Nokia" },
        { 0x2421AB, "Sony Mobile Communications Inc" },
        { 0x24240E, "Apple, Inc." },
        { 0x242642, "SHARP Corporation." },
        { 0x2429FE, "KYOCERA Corporation" },
        { 0x242E02, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x242E90, "PALIT MICROSYSTEMS, LTD" },
        { 0x242FFA, "Toshiba Global Commerce Solutions" },
        { 0x2430F8, "Huawei Device Co., Ltd." },
        { 0x243154, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x243184, "SHARP Corporation" },
        { 0x24336C, "Private" },
        { 0x2435CC, "Zhongshan Scinan Internet of Things Co.,Ltd." },
        { 0x24374C, "Cisco SPVTG" },
        { 0x2437EF, "EMC Electronic Media Communication SA" },
        { 0x243A82, "IRTS" },
        { 0x243C20, "Dynamode Group" },
        { 0x243F30, "Oxygen Broadband s.a." },
        { 0x2440AE, "NIIC Technology Co., Ltd." },
        { 0x24418C, "Intel Corporate" },
        { 0x2442BC, "Alinco,incorporated" },
        { 0x2443E2, "DASAN Network Solutions" },
        { 0x244427, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x244597, "GEMUE Gebr. Mueller Apparatebau" },
        { 0x2446C8, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x24470E, "PentronicAB" },
        { 0x24497B, "Innovative Converged Devices Inc" },
        { 0x244B03, "Samsung Electronics Co.,Ltd" },
        { 0x244B81, "Samsung Electronics Co.,Ltd" },
        { 0x244BFE, "ASUSTek COMPUTER INC." },
        { 0x244C07, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x244CE3, "Amazon Technologies Inc." },
        { 0x244E7B, "IEEE Registration Authority" },
        { 0x244F1D, "iRule LLC" },
        { 0x24526A, "Zhejiang Dahua Technology Co., Ltd." },
        { 0x2453BF, "Enernet" },
        { 0x24586E, "zte corporation" },
        { 0x245880, "VIZEO" },
        { 0x24590B, "White Sky Inc. Limited" },
        { 0x245A4C, "Ubiquiti Networks Inc." },
        { 0x245AB5, "Samsung Electronics Co.,Ltd" },
        { 0x245BA7, "Apple, Inc." },
        { 0x245BF0, "Liteon, Inc." },
        { 0x245CBF, "NCSE" },
        { 0x245CCB, "AXIe Consortium, Inc." },
        { 0x245EBE, "QNAP Systems, Inc." },
        { 0x245F9F, "Huawei Device Co., Ltd." },
        { 0x245FDF, "KYOCERA CORPORATION" },
        { 0x246081, "razberi technologies" },
        { 0x24615A, "China Mobile Group Device Co.,Ltd." },
        { 0x246278, "sysmocom - systems for mobile communications GmbH" },
        { 0x2462AB, "Espressif Inc." },
        { 0x2462CE, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x24649F, "Huawei Device Co., Ltd." },
        { 0x2464EF, "CYG SUNRI CO.,LTD." },
        { 0x246511, "AVM GmbH" },
        { 0x246880, "Braveridge.co.,ltd." },
        { 0x2468B0, "Samsung Electronics Co.,Ltd" },
        { 0x24693E, "innodisk Corporation" },
        { 0x24694A, "Jasmine Systems Inc." },
        { 0x246968, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x2469A5, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x246AAB, "IT-IS International" },
        { 0x246C8A, "YUKAI Engineering" },
        { 0x246E96, "Dell Inc." },
        { 0x246F28, "Espressif Inc." },
        { 0x246F8C, "Huawei Device Co., Ltd." },
        { 0x247152, "Dell Inc." },
        { 0x247189, "Texas Instruments" },
        { 0x247260, "IOTTECH Corp" },
        { 0x2474F7, "GoPro" },
        { 0x247625, "Texas Instruments" },
        { 0x247656, "Shanghai Net Miles Fiber Optics Technology Co., LTD." },
        { 0x24767D, "Cisco SPVTG" },
        { 0x247703, "Intel Corporate" },
        { 0x24792A, "Ruckus Wireless" },
        { 0x2479EF, "Greenpacket Berhad, Taiwan" },
        { 0x2479F3, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x2479F8, "KUPSON spol. s r.o." },
        { 0x247C4C, "Herman Miller" },
        { 0x247D4D, "Texas Instruments" },
        { 0x247E12, "Cisco Systems, Inc" },
        { 0x247E51, "zte corporation" },
        { 0x247F20, "Sagemcom Broadband SAS" },
        { 0x247F3C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x248000, "Westcontrol AS" },
        { 0x2481AA, "KSH International Co., Ltd." },
        { 0x2481C7, "Huawei Device Co., Ltd." },
        { 0x24828A, "Prowave Technologies Ltd." },
        { 0x248498, "Beijing Jiaoda Microunion Tech.Co.,Ltd." },
        { 0x2486F4, "Ctek, Inc." },
        { 0x248707, "SEnergy Corporation" },
        { 0x248894, "shenzhen lensun Communication Technology LTD" },
        { 0x248A07, "Mellanox Technologies, Inc." },
        { 0x248BE0, "SICHUAN TIANYI COMHEART TELECOMCO., LTD" },
        { 0x2491BB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x24920E, "Samsung Electronics Co.,Ltd" },
        { 0x2493CA, "Voxtronic Austria" },
        { 0x249442, "OPEN ROAD SOLUTIONS , INC." },
        { 0x249493, "FibRSol Global Network Limited" },
        { 0x249494, "Hong Kong Bouffalo Lab Limited" },
        { 0x2494CB, "ARRIS Group, Inc." },
        { 0x249504, "SFR" },
        { 0x2497ED, "Techvision Intelligent Technology Limited" },
        { 0x249EAB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x249F89, "Texas Instruments" },
        { 0x24A074, "Apple, Inc." },
        { 0x24A160, "Espressif Inc." },
        { 0x24A2E1, "Apple, Inc." },
        { 0x24A42C, "KOUKAAM a.s." },
        { 0x24A43C, "Ubiquiti Networks Inc." },
        { 0x24A487, "Huawei Device Co., Ltd." },
        { 0x24A495, "Thales Canada Inc." },
        { 0x24A52C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x24A534, "SynTrust Tech International Ltd." },
        { 0x24A7DC, "BSkyB Ltd" },
        { 0x24A87D, "Panasonic Automotive Systems Asia Pacific(Thailand)Co.,Ltd." },
        { 0x24A937, "PURE Storage" },
        { 0x24AB81, "Apple, Inc." },
        { 0x24AF4A, "Alcatel-Lucent IPD" },
        { 0x24AF54, "NEXGEN Mediatech Inc." },
        { 0x24B0A9, "Shanghai Mobiletek Communication Ltd." },
        { 0x24B105, "Prama Hikvision India Private Limited" },
        { 0x24B209, "Avaya Inc" },
        { 0x24B2DE, "Espressif Inc." },
        { 0x24B657, "Cisco Systems, Inc" },
        { 0x24B6B8, "FRIEM SPA" },
        { 0x24B6FD, "Dell Inc." },
        { 0x24B88C, "Crenus Co.,Ltd." },
        { 0x24B8D2, "Opzoon Technology Co.,Ltd." },
        { 0x24BA13, "RISO KAGAKU CORPORATION" },
        { 0x24BA30, "Technical Consumer Products, Inc." },
        { 0x24BBC1, "Absolute Analysis" },
        { 0x24BC82, "Dali Wireless, Inc." },
        { 0x24BCF8, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x24BE05, "Hewlett Packard" },
        { 0x24BE18, "DADOUTEK COMPANY LIMITED" },
        { 0x24BF74, "Private" },
        { 0x24C0B3, "RSF" },
        { 0x24C17A, "BEIJING IACTIVE NETWORK CO.,LTD" },
        { 0x24C1BD, "CRRC DALIAN R&D CO.,LTD." },
        { 0x24C3F9, "Securitas Direct AB" },
        { 0x24C42F, "Philips Lifeline" },
        { 0x24C44A, "zte corporation" },
        { 0x24C696, "Samsung Electronics Co.,Ltd" },
        { 0x24C848, "mywerk Portal GmbH" },
        { 0x24C86E, "Chaney Instrument Co." },
        { 0x24C8D3, "McWane India Pvt Ltd" },
        { 0x24C9A1, "Ruckus Wireless" },
        { 0x24C9DE, "Genoray" },
        { 0x24CACB, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x24CBE7, "MYK, Inc." },
        { 0x24CF21, "Shenzhen State Micro Technology Co., Ltd" },
        { 0x24D0DF, "Apple, Inc." },
        { 0x24D13F, "MEXUS CO.,LTD" },
        { 0x24D2CC, "SmartDrive Systems Inc." },
        { 0x24D3F2, "zte corporation" },
        { 0x24D51C, "Zhongtian broadband technology co., LTD" },
        { 0x24D76B, "Syntronic AB" },
        { 0x24D921, "Avaya Inc" },
        { 0x24DA11, "NO NDA Inc" },
        { 0x24DA33, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x24DA9B, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x24DAB6, "Sistemas de Gestión Energética S.A. de C.V" },
        { 0x24DBAC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x24DBAD, "ShopperTrak RCT Corporation" },
        { 0x24DBED, "Samsung Electronics Co.,Ltd" },
        { 0x24DEC6, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x24DF6A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x24DFA7, "Hangzhou BroadLink Technology Co.,Ltd" },
        { 0x24E124, "Xiamen Ursalink Technology Co., Ltd." },
        { 0x24E271, "Qingdao Hisense Communications Co.,Ltd." },
        { 0x24E314, "Apple, Inc." },
        { 0x24E43F, "Wenzhou Kunmei Communication Technology Co.,Ltd." },
        { 0x24E5AA, "Philips Oral Healthcare, Inc." },
        { 0x24E6BA, "JSC Zavod im. Kozitsky" },
        { 0x24E9B3, "Cisco Systems, Inc" },
        { 0x24E9CA, "Huawei Device Co., Ltd." },
        { 0x24EA40, "Helmholz GmbH & Co. KG" },
        { 0x24EB65, "SAET I.S. S.r.l." },
        { 0x24EC51, "ADF Technologies Sdn Bhd" },
        { 0x24EC99, "ASKEY COMPUTER CORP" },
        { 0x24ECD6, "CSG Science & Technology Co.,Ltd.Hefei" },
        { 0x24EE3A, "Chengdu Yingji Electronic Hi-tech Co Ltd" },
        { 0x24EE9A, "Intel Corporate" },
        { 0x24F094, "Apple, Inc." },
        { 0x24F0FF, "GHT Co., Ltd." },
        { 0x24F128, "Telstra" },
        { 0x24F150, "Guangzhou Qi'an Technology Co., Ltd." },
        { 0x24F27F, "Hewlett Packard Enterprise" },
        { 0x24F2DD, "Radiant Zemax LLC" },
        { 0x24F57E, "HWH CO., LTD." },
        { 0x24F5A2, "Belkin International Inc." },
        { 0x24F5AA, "Samsung Electronics Co.,Ltd" },
        { 0x24F677, "Apple, Inc." },
        { 0x24FAF3, "Shanghai Flexem Technology Co.,Ltd." },
        { 0x24FB65, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x24FCE5, "Samsung Electronics Co.,Ltd" },
        { 0x24FD0D, "Intelbras" },
        { 0x24FD52, "Liteon Technology Corporation" },
        { 0x24FD5B, "SmartThings, Inc." },
        { 0x280245, "Konze System Technology Co.,Ltd." },
        { 0x2802D8, "Samsung Electronics Co.,Ltd" },
        { 0x2804E0, "FERMAX ELECTRONICA S.A.U." },
        { 0x28061E, "NINGBO GLOBAL USEFUL ELECTRIC CO.,LTD" },
        { 0x28068D, "ITL, LLC" },
        { 0x28070D, "GUANGZHOU WINSOUND INFORMATION TECHNOLOGY CO.,LTD." },
        { 0x280B5C, "Apple, Inc." },
        { 0x280C28, "Unigen DataStorage Corporation" },
        { 0x280CB8, "Mikrosay Yazilim ve Elektronik A.S." },
        { 0x280DFC, "Sony Interactive Entertainment Inc." },
        { 0x280E8B, "Beijing Spirit Technology Development Co., Ltd." },
        { 0x280FC5, "Beijing Leadsec Technology Co., Ltd." },
        { 0x28101B, "MagnaCom" },
        { 0x28107B, "D-Link International" },
        { 0x2811A5, "Bose Corporation" },
        { 0x2811EC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x281471, "Lantis co., LTD." },
        { 0x28162E, "2Wire Inc" },
        { 0x28167F, "Xiaomi Communications Co Ltd" },
        { 0x2816A8, "Microsoft Corporation" },
        { 0x2816AD, "Intel Corporate" },
        { 0x2817CE, "Omnisense Ltd" },
        { 0x281878, "Microsoft Corporation" },
        { 0x2818FD, "Aditya Infotech Ltd." },
        { 0x282246, "Beijing Sinoix Communication Co., LTD" },
        { 0x282373, "Digita" },
        { 0x2823F5, "China Mobile (Hangzhou) Information Technology Co., Ltd." },
        { 0x2824FF, "Wistron Neweb Corporation" },
        { 0x282536, "SHENZHEN HOLATEK CO.,LTD" },
        { 0x2826A6, "PBR electronics GmbH" },
        { 0x2827BF, "Samsung Electronics Co.,Ltd" },
        { 0x28285D, "Zyxel Communications Corporation" },
        { 0x282986, "APC by Schneider Electric" },
        { 0x2829CC, "Corsa Technology Incorporated" },
        { 0x2829D9, "GlobalBeiMing technology (Beijing)Co. Ltd" },
        { 0x282C02, "IEEE Registration Authority" },
        { 0x282CB2, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x282FC2, "Automotive Data Solutions" },
        { 0x2830AC, "Frontiir Co. Ltd." },
        { 0x283152, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x283166, "vivo Mobile Communication Co., Ltd." },
        { 0x28317E, "Hongkong Nano IC Technologies Co., Ltd" },
        { 0x2832C5, "HUMAX Co., Ltd." },
        { 0x283334, "Huawei Device Co., Ltd." },
        { 0x283410, "Enigma Diagnostics Limited" },
        { 0x2834A2, "Cisco Systems, Inc" },
        { 0x283545, "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD" },
        { 0x283638, "IEEE Registration Authority" },
        { 0x283713, "Shenzhen 3Nod Digital Technology Co., Ltd." },
        { 0x283737, "Apple, Inc." },
        { 0x28385C, "FLEXTRONICS" },
        { 0x2838CF, "Gen2wave" },
        { 0x283926, "CyberTAN Technology Inc." },
        { 0x28395E, "Samsung Electronics Co.,Ltd" },
        { 0x2839E7, "Preceno Technology Pte.Ltd." },
        { 0x283A4D, "Cloud Network Technology (Samoa) Limited" },
        { 0x283B82, "D-Link International" },
        { 0x283B96, "Cool Control LTD" },
        { 0x283CE4, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x283E76, "Common Networks" },
        { 0x283F69, "Sony Mobile Communications Inc" },
        { 0x28401A, "C8 MediSensors, Inc." },
        { 0x284121, "OptiSense Network, LLC" },
        { 0x2841C6, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x284430, "GenesisTechnical Systems (UK) Ltd" },
        { 0x2847AA, "Nokia Corporation" },
        { 0x284846, "GridCentric Inc." },
        { 0x2848E7, "Huawei Device Co., Ltd." },
        { 0x284C53, "Intune Networks" },
        { 0x284D92, "Luminator" },
        { 0x284ED7, "OutSmart Power Systems, Inc." },
        { 0x284FCE, "Liaoning Wontel Science and Technology Development Co.,Ltd." },
        { 0x285132, "Shenzhen Prayfly Technology Co.,Ltd" },
        { 0x285261, "Cisco Systems, Inc" },
        { 0x2852E0, "Layon international Electronic & Telecom Co.,Ltd" },
        { 0x2852F9, "Zhongxin Intelligent Times (Shenzhen) Co., Ltd." },
        { 0x285471, "Huawei Device Co., Ltd." },
        { 0x28565A, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x2856C1, "Harman/Becker Automotive Systems GmbH" },
        { 0x285767, "Dish Technologies Corp" },
        { 0x2857BE, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x285AEB, "Apple, Inc." },
        { 0x285F2F, "RNware Co.,Ltd." },
        { 0x285FDB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x286046, "Lantech Communications Global, Inc." },
        { 0x286094, "CAPELEC" },
        { 0x286336, "Siemens AG" },
        { 0x2863BD, "APTIV SERVICES US, LLC" },
        { 0x2864B0, "Huawei Device Co., Ltd." },
        { 0x28656B, "Keystone Microtech Corporation" },
        { 0x2866E3, "AzureWave Technology Inc." },
        { 0x2868D2, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x286AB8, "Apple, Inc." },
        { 0x286ABA, "Apple, Inc." },
        { 0x286C07, "XIAOMI Electronics,CO.,LTD" },
        { 0x286D97, "SAMJIN Co., Ltd." },
        { 0x286DCD, "Beijing Winner Microelectronics Co.,Ltd." },
        { 0x286ED4, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x286F7F, "Cisco Systems, Inc" },
        { 0x287184, "Spire Payments" },
        { 0x2872C5, "Smartmatic Corp" },
        { 0x2872F0, "ATHENA" },
        { 0x2875D8, "FUJIAN STAR-NET COMMUNICATION CO.,LTD" },
        { 0x287610, "IgniteNet" },
        { 0x2876CD, "Funshion Online Technologies Co.,Ltd" },
        { 0x2877F1, "Apple, Inc." },
        { 0x287994, "Realplay Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x287AEE, "ARRIS Group, Inc." },
        { 0x287B09, "zte corporation" },
        { 0x287CDB, "Hefei Toycloud Technology Co.,ltd" },
        { 0x287FCF, "Intel Corporate" },
        { 0x288023, "Hewlett Packard" },
        { 0x288088, "NETGEAR" },
        { 0x2880A2, "Novatel Wireless Solutions, Inc." },
        { 0x288335, "Samsung Electronics Co.,Ltd" },
        { 0x28840E, "silicon valley immigration service" },
        { 0x2884FA, "SHARP Corporation" },
        { 0x28852D, "Touch Networks" },
        { 0x288915, "CashGuard Sverige AB" },
        { 0x288A1C, "Juniper Networks" },
        { 0x288CB8, "zte corporation" },
        { 0x2891D0, "Stage Tec Entwicklungsgesellschaft für professionelle Audiotechnik mbH" },
        { 0x28924A, "Hewlett Packard" },
        { 0x2893FE, "Cisco Systems, Inc" },
        { 0x28940F, "Cisco Systems, Inc" },
        { 0x2894AF, "Samhwa Telecom" },
        { 0x28987B, "Samsung Electronics Co.,Ltd" },
        { 0x28993A, "Arista Networks" },
        { 0x2899C7, "LINDSAY BROADBAND INC" },
        { 0x289A4B, "SteelSeries ApS" },
        { 0x289AF7, "ADVA Optical Networking Ltd." },
        { 0x289AFA, "TCT mobile ltd" },
        { 0x289E97, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x289EDF, "Danfoss Turbocor Compressors, Inc" },
        { 0x289EFC, "Sagemcom Broadband SAS" },
        { 0x28A02B, "Apple, Inc." },
        { 0x28A183, "ALPS ELECTRIC CO., LTD." },
        { 0x28A186, "enblink" },
        { 0x28A192, "GERP Solution" },
        { 0x28A1EB, "ETEK TECHNOLOGY (SHENZHEN) CO.,LTD" },
        { 0x28A241, "exlar corp" },
        { 0x28A24B, "Juniper Networks" },
        { 0x28A574, "Miller Electric Mfg. Co." },
        { 0x28A5EE, "Shenzhen SDGI CATV Co., Ltd" },
        { 0x28A6AC, "seca gmbh & co. kg" },
        { 0x28A6DB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x28AC67, "Mach Power, Rappresentanze Internazionali s.r.l." },
        { 0x28AC9E, "Cisco Systems, Inc" },
        { 0x28AD18, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x28AD3E, "Shenzhen TONG BO WEI Technology CO.,LTD" },
        { 0x28AF0A, "Sirius XM Radio Inc" },
        { 0x28B0CC, "Xenya d.o.o." },
        { 0x28B2BD, "Intel Corporate" },
        { 0x28B371, "Ruckus Wireless" },
        { 0x28B3AB, "Genmark Automation" },
        { 0x28B448, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x28B4FB, "Sprocomm Technologies CO.,LTD." },
        { 0x28B77C, "IEEE Registration Authority" },
        { 0x28B9D9, "Radisys Corporation" },
        { 0x28BA18, "NextNav, LLC" },
        { 0x28BAB5, "Samsung Electronics Co.,Ltd" },
        { 0x28BB59, "RNET Technologies, Inc." },
        { 0x28BC18, "SourcingOverseas Co. Ltd" },
        { 0x28BC56, "EMAC, Inc." },
        { 0x28BD89, "Google, Inc." },
        { 0x28BE03, "TCT mobile ltd" },
        { 0x28BE9B, "Technicolor CH USA Inc." },
        { 0x28BF89, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x28C0DA, "Juniper Networks" },
        { 0x28C13C, "Hon Hai Precision Ind. Co., Ltd." },
        { 0x28C21F, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x28C2DD, "AzureWave Technology Inc." },
        { 0x28C63F, "Intel Corporate" },
        { 0x28C671, "Yota Devices OY" },
        { 0x28C68E, "NETGEAR" },
        { 0x28C718, "Altierre" },
        { 0x28C7CE, "Cisco Systems, Inc" },
        { 0x28C825, "DellKing Industrial Co., Ltd" },
        { 0x28C87A, "ARRIS Group, Inc." },
        { 0x28C914, "Taimag Corporation" },
        { 0x28CA09, "ThyssenKrupp Elevators (Shanghai) Co.,Ltd" },
        { 0x28CBEB, "One" },
        { 0x28CC01, "Samsung Electronics Co.,Ltd" },
        { 0x28CCFF, "Corporacion Empresarial Altra SL" },
        { 0x28CD1C, "Espotel Oy" },
        { 0x28CD4C, "Individual Computers GmbH" },
        { 0x28CD9C, "Shenzhen Dynamax Software Development Co.,Ltd." },
        { 0x28CDC4, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x28CF08, "ESSYS" },
        { 0x28CFDA, "Apple, Inc." },
        { 0x28CFE9, "Apple, Inc." },
        { 0x28D044, "Shenzhen Xinyin technology company" },
        { 0x28D0CB, "Cambridge Communication Systems Ltd" },
        { 0x28D127, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x28D1AF, "Nokia Corporation" },
        { 0x28D1B7, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x28D244, "LCFC(HeFei) Electronics Technology Co., Ltd." },
        { 0x28D436, "Jiangsu dewosi electric co., LTD" },
        { 0x28D576, "Premier Wireless, Inc." },
        { 0x28D93E, "Telecor Inc." },
        { 0x28D98A, "Hangzhou Konke Technology Co.,Ltd." },
        { 0x28D997, "Yuduan Mobile Co., Ltd." },
        { 0x28DB81, "Shanghai Guao Electronic Technology Co., Ltd" },
        { 0x28DE65, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x28DEE5, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x28DEF6, "bioMerieux Inc." },
        { 0x28E02C, "Apple, Inc." },
        { 0x28E14C, "Apple, Inc." },
        { 0x28E297, "Shanghai InfoTM Microelectronics Co.,Ltd." },
        { 0x28E31F, "Xiaomi Communications Co Ltd" },
        { 0x28E347, "Liteon Technology Corporation" },
        { 0x28E34E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x28E476, "Pi-Coral" },
        { 0x28E5B0, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x28E608, "Tokheim" },
        { 0x28E6E9, "SIS Sat Internet Services GmbH" },
        { 0x28E794, "Microtime Computer Inc." },
        { 0x28E7CF, "Apple, Inc." },
        { 0x28E98E, "Mitsubishi Electric Corporation" },
        { 0x28EC95, "Apple, Inc." },
        { 0x28EC9A, "Texas Instruments" },
        { 0x28ED58, "JAG Jakob AG" },
        { 0x28ED6A, "Apple, Inc." },
        { 0x28EDE0, "AMPAK Technology, Inc." },
        { 0x28EE2C, "Frontline Test Equipment" },
        { 0x28EE52, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x28EED3, "Shenzhen Super D Technology Co., Ltd" },
        { 0x28EF01, "Private" },
        { 0x28F033, "Apple, Inc." },
        { 0x28F076, "Apple, Inc." },
        { 0x28F10E, "Dell Inc." },
        { 0x28F358, "2C - Trifonov & Co" },
        { 0x28F366, "Shenzhen Bilian electronic CO.,LTD" },
        { 0x28F532, "ADD-Engineering BV" },
        { 0x28F537, "IEEE Registration Authority" },
        { 0x28F606, "Syes srl" },
        { 0x28FA7A, "Zhejiang Tmall Technology Co., Ltd." },
        { 0x28FAA0, "vivo Mobile Communication Co., Ltd." },
        { 0x28FBD3, "Ragentek Technology Group" },
        { 0x28FC51, "The Electric Controller and Manufacturing Co., LLC" },
        { 0x28FCF6, "Shenzhen Xin KingBrand enterprises Co.,Ltd" },
        { 0x28FD80, "IEEE Registration Authority" },
        { 0x28FE65, "DongGuan Siyoto Electronics Co., Ltd" },
        { 0x28FECD, "Lemobile Information Technology (Beijing) Co., Ltd." },
        { 0x28FEDE, "COMESTA, Inc." },
        { 0x28FF3C, "Apple, Inc." },
        { 0x28FF3E, "zte corporation" },
        { 0x28FFB2, "Toshiba Corp." },
        { 0x2C002C, "UNOWHY" },
        { 0x2C0033, "EControls, LLC" },
        { 0x2C00F7, "XOS" },
        { 0x2C010B, "NASCENT Technology, LLC - RemKon" },
        { 0x2C01B5, "Cisco Systems, Inc" },
        { 0x2C029F, "3ALogics" },
        { 0x2C0623, "Win Leader Inc." },
        { 0x2C073C, "DEVLINE LIMITED" },
        { 0x2C0786, "Huawei Device Co., Ltd." },
        { 0x2C081C, "OVH" },
        { 0x2C088C, "HUMAX Co., Ltd." },
        { 0x2C094D, "Raptor Engineering, LLC" },
        { 0x2C09CB, "COBS AB" },
        { 0x2C0BE9, "Cisco Systems, Inc" },
        { 0x2C0E3D, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x2C10C1, "Nintendo Co., Ltd." },
        { 0x2C15E1, "Phicomm (Shanghai) Co., Ltd." },
        { 0x2C16BD, "IEEE Registration Authority" },
        { 0x2C1875, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x2C18AE, "Trend Electronics Co., Ltd." },
        { 0x2C1984, "IDN Telecom, Inc." },
        { 0x2C1A01, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2C1A31, "Electronics Company Limited" },
        { 0x2C1BC8, "Hunan Topview Network System CO.,LTD" },
        { 0x2C1CF6, "Alien Green LLC" },
        { 0x2C1DB8, "ARRIS Group, Inc." },
        { 0x2C1E4F, "Chengdu Qianli Network Technology Co., Ltd." },
        { 0x2C1EEA, "AERODEV" },
        { 0x2C1F23, "Apple, Inc." },
        { 0x2C200B, "Apple, Inc." },
        { 0x2C2131, "Juniper Networks" },
        { 0x2C2172, "Juniper Networks" },
        { 0x2C21D7, "IMAX Corporation" },
        { 0x2C228B, "CTR SRL" },
        { 0x2C233A, "Hewlett Packard" },
        { 0x2C245F, "Babolat VS" },
        { 0x2C2617, "Oculus VR, LLC" },
        { 0x2C265F, "IEEE Registration Authority" },
        { 0x2C26C5, "zte corporation" },
        { 0x2C279E, "IEEE Registration Authority" },
        { 0x2C27D7, "Hewlett Packard" },
        { 0x2C282D, "BBK EDUCATIONAL ELECTRONICS CORP.,LTD." },
        { 0x2C28B7, "Hangzhou Ruiying technology co., LTD" },
        { 0x2C2997, "Microsoft Corporation" },
        { 0x2C2BF9, "LG Innotek" },
        { 0x2C2D48, "bct electronic GesmbH" },
        { 0x2C3033, "NETGEAR" },
        { 0x2C3068, "Pantech Co.,Ltd" },
        { 0x2C3124, "Cisco Systems, Inc" },
        { 0x2C3311, "Cisco Systems, Inc" },
        { 0x2C3361, "Apple, Inc." },
        { 0x2C337A, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x2C3427, "ERCO & GENER" },
        { 0x2C3557, "ELLIY Power CO..Ltd" },
        { 0x2C36A0, "Capisco Limited" },
        { 0x2C36F8, "Cisco Systems, Inc" },
        { 0x2C3731, "SHENZHEN YIFANG DIGITAL TECHNOLOGY CO.,LTD." },
        { 0x2C3796, "CYBO CO.,LTD." },
        { 0x2C37C5, "Qingdao Haier Intelligent Home Appliance Technology Co.,Ltd" },
        { 0x2C3996, "Sagemcom Broadband SAS" },
        { 0x2C39C1, "Ciena Corporation" },
        { 0x2C3A28, "Fagor Electrónica" },
        { 0x2C3AE8, "Espressif Inc." },
        { 0x2C3AFD, "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
        { 0x2C3BFD, "Netstor Technology Co., Ltd." },
        { 0x2C3ECF, "Cisco Systems, Inc" },
        { 0x2C3F0B, "Cisco Meraki" },
        { 0x2C3F38, "Cisco Systems, Inc" },
        { 0x2C3F3E, "Alge-Timing GmbH" },
        { 0x2C402B, "Smart iBlue Technology Limited" },
        { 0x2C4053, "Samsung Electronics Co.,Ltd" },
        { 0x2C4138, "Hewlett Packard" },
        { 0x2C41A1, "Bose Corporation" },
        { 0x2C4205, "Lytx" },
        { 0x2C431A, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x2C4401, "Samsung Electronics Co.,Ltd" },
        { 0x2C441B, "Spectrum Medical Limited" },
        { 0x2C44FD, "Hewlett Packard" },
        { 0x2C4759, "Beijing MEGA preponderance Science & Technology Co. Ltd" },
        { 0x2C4835, "IEEE Registration Authority" },
        { 0x2C4A11, "Ciena Corporation" },
        { 0x2C4CC6, "Murata Manufacturing Co., Ltd." },
        { 0x2C4D54, "ASUSTek COMPUTER INC." },
        { 0x2C4D79, "WEIFANG GOERTEK ELECTRONICS CO.,LTD" },
        { 0x2C4E7D, "Chunghua Intelligent Network Equipment Inc." },
        { 0x2C4F52, "Cisco Systems, Inc" },
        { 0x2C5089, "Shenzhen Kaixuan Visual Technology Co.,Limited" },
        { 0x2C534A, "Shenzhen Winyao Electronic Limited" },
        { 0x2C542D, "Cisco Systems, Inc" },
        { 0x2C5491, "Microsoft Corporation" },
        { 0x2C54CF, "LG Electronics (Mobile Communications)" },
        { 0x2C553C, "Gainspeed, Inc." },
        { 0x2C557C, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x2C55D3, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2C56DC, "ASUSTek COMPUTER INC." },
        { 0x2C5731, "Wingtech Group (HongKong）Limited" },
        { 0x2C5741, "Cisco Systems, Inc" },
        { 0x2C584F, "ARRIS Group, Inc." },
        { 0x2C58E8, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2C598A, "LG Electronics (Mobile Communications)" },
        { 0x2C59E5, "Hewlett Packard" },
        { 0x2C5A05, "Nokia Corporation" },
        { 0x2C5A0F, "Cisco Systems, Inc" },
        { 0x2C5A8D, "SYSTRONIK Elektronik u. Systemtechnik GmbH" },
        { 0x2C5AA3, "PROMATE ELECTRONIC CO.LTD" },
        { 0x2C5BB8, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x2C5BE1, "Centripetal Networks, Inc" },
        { 0x2C5D34, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x2C5D93, "Ruckus Wireless" },
        { 0x2C5FF3, "Pertronic Industries" },
        { 0x2C600C, "Quanta Computer Inc." },
        { 0x2C6104, "SHENZHEN FENGLIAN TECHNOLOGY CO., LTD." },
        { 0x2C61F6, "Apple, Inc." },
        { 0x2C625A, "Finest Security Systems Co., Ltd" },
        { 0x2C6289, "Regenersis (Glenrothes) Ltd" },
        { 0x2C6373, "SICHUAN TIANYI COMHEART TELECOMCO., LTD" },
        { 0x2C641F, "Vizio, Inc" },
        { 0x2C6798, "InTalTech Ltd." },
        { 0x2C67FB, "ShenZhen Zhengjili Electronics Co., LTD" },
        { 0x2C69BA, "RF Controls, LLC" },
        { 0x2C6A6F, "IEEE Registration Authority" },
        { 0x2C6B7D, "Texas Instruments" },
        { 0x2C6BF5, "Juniper Networks" },
        { 0x2C6E85, "Intel Corporate" },
        { 0x2C6F51, "Herospeed Digital Technology Limited" },
        { 0x2C6FC9, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x2C7155, "HiveMotion" },
        { 0x2C72C3, "Soundmatters" },
        { 0x2C7360, "Earda Technologies co Ltd" },
        { 0x2C73A0, "Cisco Systems, Inc" },
        { 0x2C750F, "Shanghai Dongzhou-Lawton Communication Technology Co. Ltd." },
        { 0x2C768A, "Hewlett Packard" },
        { 0x2C780E, "Huawei Device Co., Ltd." },
        { 0x2C79D7, "Sagemcom Broadband SAS" },
        { 0x2C7B5A, "Milper Ltd" },
        { 0x2C7B84, "OOO Petr Telegin" },
        { 0x2C7CE4, "Wuhan Tianyu Information Industry Co., Ltd." },
        { 0x2C7E81, "ARRIS Group, Inc." },
        { 0x2C7ECF, "Onzo Ltd" },
        { 0x2C8065, "HARTING Inc. of North America" },
        { 0x2C8158, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x2C86D2, "Cisco Systems, Inc" },
        { 0x2C8A72, "HTC Corporation" },
        { 0x2C8BF2, "Hitachi Metals America Ltd" },
        { 0x2C9127, "Eintechno Corporation" },
        { 0x2C91AB, "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
        { 0x2C922C, "Kishu Giken Kogyou Company Ltd,." },
        { 0x2C9464, "Cincoze Co., Ltd." },
        { 0x2C9569, "ARRIS Group, Inc." },
        { 0x2C957F, "zte corporation" },
        { 0x2C9662, "Invenit BV" },
        { 0x2C9717, "I.C.Y. B.V." },
        { 0x2C97B1, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2C97ED, "Sony Imaging Products & Solutions Inc." },
        { 0x2C9924, "ARRIS Group, Inc." },
        { 0x2C9AA4, "Eolo SpA" },
        { 0x2C9D1E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2C9E5F, "ARRIS Group, Inc." },
        { 0x2C9EEC, "Jabil Circuit Penang" },
        { 0x2C9EFC, "CANON INC." },
        { 0x2C9FFB, "Wistron Neweb Corporation" },
        { 0x2CA02F, "Veroguard Systems Pty Ltd" },
        { 0x2CA042, "Huawei Device Co., Ltd." },
        { 0x2CA157, "acromate, Inc." },
        { 0x2CA17D, "ARRIS Group, Inc." },
        { 0x2CA2B4, "Fortify Technologies, LLC" },
        { 0x2CA30E, "POWER DRAGON DEVELOPMENT LIMITED" },
        { 0x2CA539, "Parallel Wireless, Inc" },
        { 0x2CA780, "True Technologies Inc." },
        { 0x2CA835, "RIM" },
        { 0x2CA89C, "Creatz inc." },
        { 0x2CA9F0, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x2CAA8E, "Wyze Labs Inc" },
        { 0x2CAB00, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2CAB25, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x2CAB33, "Texas Instruments" },
        { 0x2CABA4, "Cisco SPVTG" },
        { 0x2CABEB, "Cisco Systems, Inc" },
        { 0x2CAC44, "CONEXTOP" },
        { 0x2CAD13, "SHENZHEN ZHILU TECHNOLOGY CO.,LTD" },
        { 0x2CAE2B, "Samsung Electronics Co.,Ltd" },
        { 0x2CB05D, "NETGEAR" },
        { 0x2CB0DF, "Soliton Technologies Pvt Ltd" },
        { 0x2CB115, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x2CB21A, "Phicomm (Shanghai) Co., Ltd." },
        { 0x2CB43A, "Apple, Inc." },
        { 0x2CB693, "Radware" },
        { 0x2CB69D, "RED Digital Cinema" },
        { 0x2CB8ED, "SonicWall" },
        { 0x2CBABA, "Samsung Electronics Co.,Ltd" },
        { 0x2CBE08, "Apple, Inc." },
        { 0x2CBE97, "Ingenieurbuero Bickele und Buehler GmbH" },
        { 0x2CC260, "Oracle Corporation" },
        { 0x2CC407, "machineQ" },
        { 0x2CC546, "Huawei Device Co., Ltd." },
        { 0x2CC548, "IAdea Corporation" },
        { 0x2CC5D3, "Ruckus Wireless" },
        { 0x2CCA0C, "WITHUS PLANET" },
        { 0x2CCC15, "Nokia Corporation" },
        { 0x2CCC44, "Sony Interactive Entertainment Inc." },
        { 0x2CCCE6, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x2CCD27, "Precor Inc" },
        { 0x2CCD43, "Summit Technology Group" },
        { 0x2CCD69, "Aqavi.com" },
        { 0x2CCF58, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x2CD02D, "Cisco Systems, Inc" },
        { 0x2CD05A, "Liteon Technology Corporation" },
        { 0x2CD066, "Xiaomi Communications Co Ltd" },
        { 0x2CD141, "IEEE Registration Authority" },
        { 0x2CD1DA, "Sanjole, Inc." },
        { 0x2CD2E3, "Guangzhou Aoshi Electronic Co.,Ltd" },
        { 0x2CD2E7, "Nokia Corporation" },
        { 0x2CD444, "FUJITSU LIMITED" },
        { 0x2CD974, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x2CDB07, "Intel Corporate" },
        { 0x2CDCAD, "Wistron Neweb Corporation" },
        { 0x2CDCD7, "AzureWave Technology Inc." },
        { 0x2CDD0C, "Discovergy GmbH" },
        { 0x2CDD95, "Taicang T&W Electronics" },
        { 0x2CDDA3, "Point Grey Research Inc." },
        { 0x2CE2A8, "DeviceDesign" },
        { 0x2CE310, "Stratacache" },
        { 0x2CE412, "Sagemcom Broadband SAS" },
        { 0x2CE6CC, "Ruckus Wireless" },
        { 0x2CE871, "Alert Metalguard ApS" },
        { 0x2CEA7F, "Dell Inc." },
        { 0x2CEDEB, "Alpheus Digital Company Limited" },
        { 0x2CEE26, "Petroleum Geo-Services" },
        { 0x2CF05D, "Micro-Star INTL CO., LTD." },
        { 0x2CF0A2, "Apple, Inc." },
        { 0x2CF0EE, "Apple, Inc." },
        { 0x2CF203, "EMKO ELEKTRONIK SAN VE TIC AS" },
        { 0x2CF432, "Espressif Inc." },
        { 0x2CF4C5, "Avaya Inc" },
        { 0x2CF7F1, "Seeed Technology Inc." },
        { 0x2CF89B, "Cisco Systems, Inc" },
        { 0x2CFAA2, "Alcatel-Lucent Enterprise" },
        { 0x2CFCE4, "CTEK Sweden AB" },
        { 0x2CFD37, "Blue Calypso, Inc." },
        { 0x2CFDA1, "ASUSTek COMPUTER INC." },
        { 0x2CFDAB, "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
        { 0x2CFF65, "Oki Electric Industry Co., Ltd." },
        { 0x2CFFEE, "vivo Mobile Communication Co., Ltd." },
        { 0x30053F, "JTI Co.,Ltd." },
        { 0x30055C, "Brother industries, LTD." },
        { 0x30074D, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x3009F9, "IEEE Registration Authority" },
        { 0x300A60, "IEEE Registration Authority" },
        { 0x300AC5, "Ruio telecommunication technologies Co., Limited" },
        { 0x300B9C, "Delta Mobile Systems, Inc." },
        { 0x300C23, "zte corporation" },
        { 0x300D2A, "Zhejiang Wellcom Technology Co.,Ltd." },
        { 0x300D43, "Microsoft Mobile Oy" },
        { 0x300D9E, "Ruijie Networks Co.,LTD" },
        { 0x300ED5, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x300EE3, "Aquantia Corporation" },
        { 0x3010B3, "Liteon Technology Corporation" },
        { 0x3010E4, "Apple, Inc." },
        { 0x301389, "Siemens AG, Automations & Drives," },
        { 0x30142D, "Piciorgros GmbH" },
        { 0x30144A, "Wistron Neweb Corporation" },
        { 0x301518, "Ubiquitous Communication Co. ltd." },
        { 0x30168D, "ProLon" },
        { 0x3017C8, "Sony Mobile Communications Inc" },
        { 0x3018CF, "DEOS control systems GmbH" },
        { 0x301966, "Samsung Electronics Co.,Ltd" },
        { 0x301A28, "Mako Networks Ltd" },
        { 0x301B97, "Lierda Science & Technology Group Co.,Ltd" },
        { 0x301F9A, "IEEE Registration Authority" },
        { 0x30215B, "Shenzhen Ostar Display Electronic Co.,Ltd" },
        { 0x302303, "Belkin International Inc." },
        { 0x302432, "Intel Corporate" },
        { 0x302478, "Sagemcom Broadband SAS" },
        { 0x3024A9, "HP Inc." },
        { 0x3027CF, "Private" },
        { 0x302952, "Hillstone Networks Inc" },
        { 0x3029BE, "Shanghai MRDcom Co.,Ltd" },
        { 0x302DE8, "JDA, LLC (JDA Systems)" },
        { 0x30317D, "Hosiden Corporation" },
        { 0x303235, "Qingdao Intelligent&Precise Electronics Co.,Ltd." },
        { 0x303294, "W-IE-NE-R Plein & Baus GmbH" },
        { 0x3032D4, "Hanilstm Co., Ltd." },
        { 0x303335, "Boosty" },
        { 0x3034D2, "Availink, Inc." },
        { 0x3035AD, "Apple, Inc." },
        { 0x3037A6, "Cisco Systems, Inc" },
        { 0x303855, "Nokia Corporation" },
        { 0x303926, "Sony Mobile Communications Inc" },
        { 0x303955, "Shenzhen Jinhengjia Electronic Co., Ltd." },
        { 0x3039F2, "ADB Broadband Italia" },
        { 0x303A64, "Intel Corporate" },
        { 0x303ABA, "Guangzhou BaoLun Electronics Co., Ltd" },
        { 0x303D08, "GLINTT TES S.A." },
        { 0x303EAD, "Sonavox Canada Inc" },
        { 0x304174, "ALTEC LANSING LLC" },
        { 0x304225, "BURG-WÄCHTER KG" },
        { 0x304240, "zte corporation" },
        { 0x3042A1, "ilumisys Inc. DBA Toggled" },
        { 0x304449, "PLATH GmbH" },
        { 0x304487, "Hefei Radio Communication Technology Co., Ltd" },
        { 0x3044A1, "Shanghai Nanchao Information Technology" },
        { 0x304511, "Texas Instruments" },
        { 0x304596, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x30469A, "NETGEAR" },
        { 0x30493B, "Nanjing Z-Com Wireless Co.,Ltd" },
        { 0x304950, "IEEE Registration Authority" },
        { 0x304A26, "Shenzhen Trolink Technology CO, LTD" },
        { 0x304B07, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x304C7E, "Panasonic Electric Works Automation Controls Techno Co.,Ltd." },
        { 0x304EC3, "Tianjin Techua Technology Co., Ltd." },
        { 0x304F75, "DASAN Network Solutions" },
        { 0x305075, "GN Audio A/S" },
        { 0x3050FD, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x3051F8, "BYK-Gardner GmbH" },
        { 0x30525A, "NST Co., LTD" },
        { 0x3052CB, "Liteon Technology Corporation" },
        { 0x3055ED, "Trex Network LLC" },
        { 0x305684, "SHENZHEN YUNJI INTELLIGENT TECHNOLOGY CO.,LTD" },
        { 0x305714, "Apple, Inc." },
        { 0x30578E, "eero inc." },
        { 0x3057AC, "IRLAB LTD." },
        { 0x305890, "Frontier Silicon Ltd" },
        { 0x30595B, "streamnow AG" },
        { 0x3059B7, "Microsoft" },
        { 0x305A3A, "ASUSTek COMPUTER INC." },
        { 0x305D38, "Beissbarth" },
        { 0x305DA6, "ADVALY SYSTEM Inc." },
        { 0x306023, "ARRIS Group, Inc." },
        { 0x306112, "PAV GmbH" },
        { 0x306118, "Paradom Inc." },
        { 0x30636B, "Apple, Inc." },
        { 0x3065EC, "Wistron (ChongQing)" },
        { 0x3066D0, "Huawei Device Co., Ltd." },
        { 0x30688C, "Reach Technology Inc." },
        { 0x30694B, "RIM" },
        { 0x306A85, "Samsung Electronics Co.,Ltd" },
        { 0x306CBE, "Skymotion Technology (HK) Limited" },
        { 0x306E5C, "Validus Technologies" },
        { 0x306F07, "Nations Technologies Inc." },
        { 0x3071B2, "Hangzhou Prevail Optoelectronic Equipment Co.,LTD." },
        { 0x307350, "Inpeco SA" },
        { 0x307496, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x307512, "Sony Mobile Communications Inc" },
        { 0x30766F, "LG Electronics (Mobile Communications)" },
        { 0x3077CB, "Maike Industry(Shenzhen)CO.,LTD" },
        { 0x30785C, "Partow Tamas Novin (Parman)" },
        { 0x30786B, "TIANJIN Golden Pentagon Electronics Co., Ltd." },
        { 0x3078C2, "Innowireless / QUCELL Networks" },
        { 0x307BAC, "New H3C Technologies Co., Ltd" },
        { 0x307C30, "RIM" },
        { 0x307C5E, "Juniper Networks" },
        { 0x307CB2, "ANOV FRANCE" },
        { 0x307ECB, "SFR" },
        { 0x30809B, "New H3C Technologies Co., Ltd" },
        { 0x308454, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x3085A9, "ASUSTek COMPUTER INC." },
        { 0x30862D, "Arista Network, Inc." },
        { 0x308730, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3087D9, "Ruckus Wireless" },
        { 0x308841, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x308944, "DEVA Broadcast Ltd." },
        { 0x308976, "DALIAN LAMBA TECHNOLOGY CO.,LTD" },
        { 0x308999, "Guangdong East Power Co.," },
        { 0x3089D3, "HONGKONG UCLOUDLINK NETWORK TECHNOLOGY LIMITED" },
        { 0x308AF7, "Huawei Device Co., Ltd." },
        { 0x308BB2, "Cisco Systems, Inc" },
        { 0x308CFB, "Dropcam" },
        { 0x308D99, "Hewlett Packard" },
        { 0x309048, "Apple, Inc." },
        { 0x3090AB, "Apple, Inc." },
        { 0x309176, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x30918F, "Technicolor" },
        { 0x3092F6, "SHANGHAI SUNMON COMMUNICATION TECHNOGY CO.,LTD" },
        { 0x3093BC, "Sagemcom Broadband SAS" },
        { 0x309435, "vivo Mobile Communication Co., Ltd." },
        { 0x3095E3, "SHANGHAI SIMCOM LIMITED" },
        { 0x309610, "Huawei Device Co., Ltd." },
        { 0x3096FB, "Samsung Electronics Co.,Ltd" },
        { 0x309935, "zte corporation" },
        { 0x309BAD, "BBK EDUCATIONAL ELECTRONICS CORP.,LTD." },
        { 0x309C23, "Micro-Star INTL CO., LTD." },
        { 0x309E1D, "OHSUNG" },
        { 0x309FFB, "Ardomus Networks Corporation" },
        { 0x30A023, "ROCK PATH S.R.L" },
        { 0x30A1FA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x30A220, "ARG Telecom" },
        { 0x30A243, "Shenzhen Prifox Innovation Technology Co., Ltd." },
        { 0x30A2C2, "Huawei Device Co., Ltd." },
        { 0x30A452, "Arrival Elements BV" },
        { 0x30A889, "DECIMATOR DESIGN" },
        { 0x30A8DB, "Sony Mobile Communications Inc" },
        { 0x30A998, "Huawei Device Co., Ltd." },
        { 0x30A9DE, "LG Innotek" },
        { 0x30AABD, "Shanghai Reallytek Information Technology Co.,Ltd" },
        { 0x30AAE4, "Huawei Device Co., Ltd." },
        { 0x30AB6A, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x30AE7B, "Deqing Dusun Electron CO., LTD" },
        { 0x30AEA4, "Espressif Inc." },
        { 0x30AEF6, "Radio Mobile Access" },
        { 0x30AFCE, "vivo Mobile Communication Co., Ltd." },
        { 0x30B164, "Power Electronics International Inc." },
        { 0x30B216, "Hitachi ABB Power Grids – Grid Automation" },
        { 0x30B237, "GD Midea Air-Conditioning Equipment Co.,Ltd." },
        { 0x30B3A2, "Shenzhen Heguang Measurement & Control Technology Co.,Ltd" },
        { 0x30B49E, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x30B4B8, "LG Electronics" },
        { 0x30B5C2, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x30B5F1, "Aitexin Technology Co., Ltd" },
        { 0x30B62D, "Mojo Networks, Inc." },
        { 0x30B64F, "Juniper Networks" },
        { 0x30B7D4, "Hitron Technologies. Inc" },
        { 0x30B9B0, "Intracom Asia Co., Ltd" },
        { 0x30BE3B, "Mitsubishi Electric Corporation" },
        { 0x30C01B, "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd" },
        { 0x30C3D9, "ALPS ELECTRIC CO., LTD." },
        { 0x30C507, "ECI Telecom Ltd." },
        { 0x30C50F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x30C750, "MIC Technology Group" },
        { 0x30C7AE, "Samsung Electronics Co.,Ltd" },
        { 0x30C82A, "WI-BIZ srl" },
        { 0x30C9AB, "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD." },
        { 0x30CBF8, "Samsung Electronics Co.,Ltd" },
        { 0x30CC21, "zte corporation" },
        { 0x30CDA7, "Samsung Electronics Co.,Ltd" },
        { 0x30D042, "Dell Inc." },
        { 0x30D16B, "Liteon Technology Corporation" },
        { 0x30D17E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x30D32D, "devolo AG" },
        { 0x30D357, "Logosol, Inc." },
        { 0x30D386, "zte corporation" },
        { 0x30D46A, "Autosales Incorporated" },
        { 0x30D587, "Samsung Electronics Co.,Ltd" },
        { 0x30D659, "Merging Technologies SA" },
        { 0x30D6C9, "Samsung Electronics Co.,Ltd" },
        { 0x30D941, "Raydium Semiconductor Corp." },
        { 0x30D9D9, "Apple, Inc." },
        { 0x30DE86, "Cedac Software S.r.l." },
        { 0x30DF8D, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x30E090, "Linctronix Ltd," },
        { 0x30E171, "Hewlett Packard" },
        { 0x30E283, "Texas Instruments" },
        { 0x30E37A, "Intel Corporate" },
        { 0x30E3D6, "Spotify USA Inc." },
        { 0x30E48E, "Vodafone UK" },
        { 0x30E4DB, "Cisco Systems, Inc" },
        { 0x30E98E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x30EA26, "Sycada BV" },
        { 0x30EB1F, "Skylab M&C Technology Co.,Ltd" },
        { 0x30EB25, "INTEK DIGITAL" },
        { 0x30EB5A, "LANDIS + GYR" },
        { 0x30EFD1, "Alstom Strongwish (Shenzhen) Co., Ltd." },
        { 0x30F31D, "zte corporation" },
        { 0x30F335, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x30F33A, "+plugg srl" },
        { 0x30F42F, "ESP" },
        { 0x30F6B9, "Ecocentric Energy" },
        { 0x30F70D, "Cisco Systems, Inc" },
        { 0x30F772, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x30F77F, "S Mobile Devices Limited" },
        { 0x30F7C5, "Apple, Inc." },
        { 0x30F7D7, "Thread Technology Co., Ltd" },
        { 0x30F9ED, "Sony Corporation" },
        { 0x30FAB7, "Tunai Creative" },
        { 0x30FB94, "Shanghai Fangzhiwei Information Technology CO.,Ltd." },
        { 0x30FBB8, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x30FC68, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x30FCEB, "LG Electronics (Mobile Communications)" },
        { 0x30FD11, "MACROTECH (USA) INC." },
        { 0x30FD38, "Google, Inc." },
        { 0x30FD65, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x30FE31, "Nokia" },
        { 0x30FFF6, "HangZhou KuoHeng Technology Co.,ltd" },
        { 0x34008A, "IEEE Registration Authority" },
        { 0x3400A3, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x340286, "Intel Corporate" },
        { 0x34029B, "Plexonics Technologies LImited" },
        { 0x3403DE, "Texas Instruments" },
        { 0x34049E, "IEEE Registration Authority" },
        { 0x34074F, "AccelStor, Inc." },
        { 0x3407FB, "Ericsson AB" },
        { 0x340804, "D-Link Corporation" },
        { 0x3408BC, "Apple, Inc." },
        { 0x340A22, "TOP-ACCESS ELECTRONICS CO LTD" },
        { 0x340A33, "D-Link International" },
        { 0x340A98, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x340AFF, "Qingdao Hisense Communications Co.,Ltd." },
        { 0x340B40, "MIOS ELETTRONICA SRL" },
        { 0x340CED, "Moduel AB" },
        { 0x340F66, "Web Sensing LLC" },
        { 0x341290, "Treeview Co.,Ltd." },
        { 0x341298, "Apple, Inc." },
        { 0x3412F9, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3413A8, "Mediplan Limited" },
        { 0x3413E8, "Intel Corporate" },
        { 0x34145F, "Samsung Electronics Co.,Ltd" },
        { 0x3414B5, "Texas Instruments" },
        { 0x341513, "Texas Instruments" },
        { 0x34159E, "Apple, Inc." },
        { 0x3417EB, "Dell Inc." },
        { 0x341A35, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x341A4C, "SHENZHEN WEIBU ELECTRONICS CO.,LTD." },
        { 0x341B22, "Grandbeing Technology Co., Ltd" },
        { 0x341CF0, "Xiaomi Communications Co Ltd" },
        { 0x341E6B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x341FE4, "ARRIS Group, Inc." },
        { 0x342003, "Shenzhen Feitengyun Technology Co.,LTD" },
        { 0x3420E3, "Ruckus Wireless" },
        { 0x342109, "Jensen Scandinavia AS" },
        { 0x342387, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x3423BA, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x34255D, "Shenzhen Loadcom Technology Co.,Ltd" },
        { 0x342606, "CarePredict, Inc." },
        { 0x342792, "FREEBOX SAS" },
        { 0x3428F0, "ATN International Limited" },
        { 0x342912, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x34298F, "IEEE Registration Authority" },
        { 0x3429EA, "MCD ELECTRONICS SP. Z O.O." },
        { 0x342AF1, "Texas Instruments" },
        { 0x342B70, "Arris" },
        { 0x342CC4, "Compal Broadband Networks, Inc." },
        { 0x342D0D, "Samsung Electronics Co.,Ltd" },
        { 0x342EB6, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x342EB7, "Intel Corporate" },
        { 0x342F6E, "Anywire corporation" },
        { 0x342FBD, "Nintendo Co.,Ltd" },
        { 0x343111, "Samsung Electronics Co.,Ltd" },
        { 0x3431C4, "AVM GmbH" },
        { 0x3432E6, "Panasonic Industrial Devices Europe GmbH" },
        { 0x34363B, "Apple, Inc." },
        { 0x343654, "zte corporation" },
        { 0x343759, "zte corporation" },
        { 0x343794, "Hamee Corp." },
        { 0x3438AF, "Inlab Software GmbH" },
        { 0x3438B7, "HUMAX Co., Ltd." },
        { 0x343D98, "JinQianMao Technology Co.,Ltd." },
        { 0x343DC4, "BUFFALO.INC" },
        { 0x343EA4, "Ring LLC" },
        { 0x3440B5, "IBM" },
        { 0x34415D, "Intel Corporate" },
        { 0x3441A8, "ER-Telecom" },
        { 0x344262, "Apple, Inc." },
        { 0x34466F, "HiTEM Engineering" },
        { 0x3446EC, "Huawei Device Co., Ltd." },
        { 0x3448ED, "Dell Inc." },
        { 0x34495B, "Sagemcom Broadband SAS" },
        { 0x344B3D, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x344B50, "zte corporation" },
        { 0x344CA4, "amazipoint technology Ltd." },
        { 0x344CC8, "Echodyne Corp" },
        { 0x344DEA, "zte corporation" },
        { 0x344DF7, "LG Electronics (Mobile Communications)" },
        { 0x344F3F, "IO-Power Technology Co., Ltd." },
        { 0x344F5C, "R&amp;M AG" },
        { 0x344F69, "EKINOPS SAS" },
        { 0x345180, "TCL King Electrical Appliances (Huizhou) Co., Ltd" },
        { 0x3451AA, "JID GLOBAL" },
        { 0x3451C9, "Apple, Inc." },
        { 0x34543C, "TAKAOKA TOKO CO.,LTD." },
        { 0x345594, "FUJIAN STAR-NET COMMUNICATION CO.,LTD" },
        { 0x3456FE, "Cisco Meraki" },
        { 0x345760, "MitraStar Technology Corp." },
        { 0x345840, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x345A06, "SHARP Corporation" },
        { 0x345ABA, "tcloud intelligence" },
        { 0x345B11, "EVI HEAT AB" },
        { 0x345BBB, "GD Midea Air-Conditioning Equipment Co.,Ltd." },
        { 0x345C40, "Cargt Holdings LLC" },
        { 0x345D10, "Wytek" },
        { 0x346178, "The Boeing Company" },
        { 0x346288, "Cisco Systems, Inc" },
        { 0x3463D4, "BIONIX SUPPLYCHAIN TECHNOLOGIES SLU" },
        { 0x3464A9, "Hewlett Packard" },
        { 0x3466EA, "VERTU INTERNATIONAL CORPORATION LIMITED" },
        { 0x34684A, "Teraworks Co., Ltd." },
        { 0x346895, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x346987, "zte corporation" },
        { 0x346AC2, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x346B46, "Sagemcom Broadband SAS" },
        { 0x346B5B, "New H3C Technologies Co., Ltd" },
        { 0x346BD3, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x346C0F, "Pramod Telecom Pvt. Ltd" },
        { 0x346D9C, "Carrier Corporation" },
        { 0x346E8A, "Ecosense" },
        { 0x346E9D, "Ericsson AB" },
        { 0x346F90, "Cisco Systems, Inc" },
        { 0x346F92, "White Rodgers Division" },
        { 0x346FED, "Enovation Controls" },
        { 0x347146, "Huawei Device Co., Ltd." },
        { 0x347563, "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD." },
        { 0x3475C7, "Avaya Inc" },
        { 0x3476C5, "I-O DATA DEVICE,INC." },
        { 0x347839, "zte corporation" },
        { 0x347877, "O-Net Communications (Shenzhen) Limited" },
        { 0x3478D7, "Gionee Communication Equipment Co.,Ltd." },
        { 0x347916, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x347A60, "ARRIS Group, Inc." },
        { 0x347C25, "Apple, Inc." },
        { 0x347DF6, "Intel Corporate" },
        { 0x347E00, "Huawei Device Co., Ltd." },
        { 0x347E39, "Nokia Danmark A/S" },
        { 0x347E5C, "Sonos, Inc." },
        { 0x347ECA, "NEXTWILL" },
        { 0x34800D, "Cavium Inc" },
        { 0x3480B3, "Xiaomi Communications Co Ltd" },
        { 0x348137, "UNICARD SA" },
        { 0x3481C4, "AVM GmbH" },
        { 0x3481F4, "SST Taiwan Ltd." },
        { 0x3482C5, "Samsung Electronics Co.,Ltd" },
        { 0x3482DE, "Kiio Inc" },
        { 0x348302, "iFORCOM Co., Ltd" },
        { 0x348446, "Ericsson AB" },
        { 0x348584, "Extreme Networks, Inc." },
        { 0x34862A, "Heinz Lackmann GmbH & Co KG" },
        { 0x34873D, "Quectel Wireless Solutions Co., Ltd." },
        { 0x34885D, "Logitech Far East" },
        { 0x348A7B, "Samsung Electronics Co.,Ltd" },
        { 0x348AAE, "Sagemcom Broadband SAS" },
        { 0x348B75, "LAVA INTERNATIONAL(H.K) LIMITED" },
        { 0x348F27, "Ruckus Wireless" },
        { 0x34916F, "UserGate Ltd." },
        { 0x349342, "TTE Corporation" },
        { 0x3495DB, "Logitec Corporation" },
        { 0x349672, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x3497F6, "ASUSTek COMPUTER INC." },
        { 0x3497FB, "ADVANCED RF TECHNOLOGIES INC" },
        { 0x34996F, "VPI Engineering" },
        { 0x349971, "Quanta Storage Inc." },
        { 0x3499D7, "Universal Flow Monitors, Inc." },
        { 0x349A0D, "ZBD Displays Ltd" },
        { 0x349B5B, "Maquet GmbH" },
        { 0x349D90, "Heinzmann GmbH & CO. KG" },
        { 0x349E34, "Evervictory Electronic Co.Ltd" },
        { 0x349F7B, "CANON INC." },
        { 0x34A183, "AWare, Inc" },
        { 0x34A2A2, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x34A395, "Apple, Inc." },
        { 0x34A3BF, "Terewave. Inc." },
        { 0x34A55D, "TECHNOSOFT INTERNATIONAL SRL" },
        { 0x34A5E1, "Sensorist ApS" },
        { 0x34A68C, "Shine Profit Development Limited" },
        { 0x34A709, "Trevil srl" },
        { 0x34A7BA, "Fischer International Systems Corporation" },
        { 0x34A843, "KYOCERA Display Corporation" },
        { 0x34A84E, "Cisco Systems, Inc" },
        { 0x34A8EB, "Apple, Inc." },
        { 0x34AA8B, "Samsung Electronics Co.,Ltd" },
        { 0x34AA99, "Nokia" },
        { 0x34AAEE, "Mikrovisatos Servisas UAB" },
        { 0x34AB37, "Apple, Inc." },
        { 0x34ADE4, "Shanghai Chint Power Systems Co., Ltd." },
        { 0x34AF2C, "Nintendo Co., Ltd." },
        { 0x34B1F7, "Texas Instruments" },
        { 0x34B20A, "Huawei Device Co., Ltd." },
        { 0x34B354, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x34B571, "PLDS" },
        { 0x34B5A3, "CIG SHANGHAI CO LTD" },
        { 0x34B7FD, "Guangzhou Younghead Electronic Technology Co.,Ltd" },
        { 0x34BA38, "PAL MOHAN ELECTRONICS PVT LTD" },
        { 0x34BA51, "Se-Kure Controls, Inc." },
        { 0x34BA75, "Everest Networks, Inc" },
        { 0x34BA9A, "Asiatelco Technologies Co." },
        { 0x34BB1F, "BlackBerry RTS" },
        { 0x34BB26, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x34BCA6, "Beijing Ding Qing Technology, Ltd." },
        { 0x34BDC8, "Cisco Systems, Inc" },
        { 0x34BDF9, "Shanghai WDK Industrial Co.,Ltd." },
        { 0x34BDFA, "Cisco SPVTG" },
        { 0x34BE00, "Samsung Electronics Co.,Ltd" },
        { 0x34BF90, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x34C059, "Apple, Inc." },
        { 0x34C0F9, "Rockwell Automation" },
        { 0x34C3AC, "Samsung Electronics Co.,Ltd" },
        { 0x34C3D2, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x34C5D0, "Hagleitner Hygiene International GmbH" },
        { 0x34C69A, "Enecsys Ltd" },
        { 0x34C731, "ALPS ELECTRIC CO., LTD." },
        { 0x34C803, "Nokia Corporation" },
        { 0x34C99D, "EIDOLON COMMUNICATIONS TECHNOLOGY CO. LTD." },
        { 0x34C9F0, "LM Technologies Ltd" },
        { 0x34CB1A, "Procter & Gamble Company" },
        { 0x34CC28, "Nexpring Co. LTD.," },
        { 0x34CD6D, "CommSky Technologies" },
        { 0x34CDBE, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x34CE00, "XIAOMI Electronics,CO.,LTD" },
        { 0x34CE94, "Parsec (Pty) Ltd" },
        { 0x34CFF6, "Intel Corporate" },
        { 0x34D09B, "MobilMAX Technology Inc." },
        { 0x34D0B8, "IEEE Registration Authority" },
        { 0x34D262, "SZ DJI TECHNOLOGY CO.,LTD" },
        { 0x34D270, "Amazon Technologies Inc." },
        { 0x34D2C4, "RENA GmbH Print Systeme" },
        { 0x34D693, "Huawei Device Co., Ltd." },
        { 0x34D712, "Smartisan Digital Co., Ltd" },
        { 0x34D772, "Xiamen Yudian Automation Technology Co., Ltd" },
        { 0x34D7B4, "Tributary Systems, Inc." },
        { 0x34D954, "WiBotic Inc." },
        { 0x34DAB7, "zte corporation" },
        { 0x34DAC1, "SAE Technologies Development(Dongguan) Co., Ltd." },
        { 0x34DB9C, "Sagemcom Broadband SAS" },
        { 0x34DBFD, "Cisco Systems, Inc" },
        { 0x34DD7E, "Umeox Innovations Co.,Ltd" },
        { 0x34DE1A, "Intel Corporate" },
        { 0x34DE34, "zte corporation" },
        { 0x34DF2A, "Fujikon Industrial Co.,Limited" },
        { 0x34E0CF, "zte corporation" },
        { 0x34E0D7, "DONGGUAN QISHENG ELECTRONICS INDUSTRIAL CO., LTD" },
        { 0x34E12D, "Intel Corporate" },
        { 0x34E1D1, "IEEE Registration Authority" },
        { 0x34E2FD, "Apple, Inc." },
        { 0x34E380, "Genexis B.V." },
        { 0x34E3DA, "Hoval Aktiengesellschaft" },
        { 0x34E42A, "Automatic Bar Controls Inc." },
        { 0x34E5EC, "Palo Alto Networks" },
        { 0x34E6AD, "Intel Corporate" },
        { 0x34E6D7, "Dell Inc." },
        { 0x34E70B, "HAN Networks Co., Ltd" },
        { 0x34E71C, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x34E894, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x34E911, "vivo Mobile Communication Co., Ltd." },
        { 0x34EA34, "HangZhou Gubei Electronics Technology Co.,Ltd" },
        { 0x34EAE7, "Shanghai High-Flying Electronics Technology Co., Ltd" },
        { 0x34ED0B, "Shanghai XZ-COM.CO.,Ltd." },
        { 0x34ED1B, "Cisco Systems, Inc" },
        { 0x34EF44, "2Wire Inc" },
        { 0x34EF8B, "NTT Communications Corporation" },
        { 0x34EFB6, "Edgecore Networks Corporation" },
        { 0x34F0CA, "Shenzhen Linghangyuan Digital Technology Co.,Ltd." },
        { 0x34F150, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x34F39A, "Intel Corporate" },
        { 0x34F39B, "WizLAN Ltd." },
        { 0x34F62D, "SHARP Corporation" },
        { 0x34F64B, "Intel Corporate" },
        { 0x34F6D2, "Panasonic Taiwan Co.,Ltd." },
        { 0x34F8E7, "Cisco Systems, Inc" },
        { 0x34F968, "ATEK Products, LLC" },
        { 0x34FA40, "Guangzhou Robustel Technologies Co., Limited" },
        { 0x34FA9F, "Ruckus Wireless" },
        { 0x34FC6F, "ALCEA" },
        { 0x34FCB9, "Hewlett Packard Enterprise" },
        { 0x34FCEF, "LG Electronics (Mobile Communications)" },
        { 0x34FD6A, "Apple, Inc." },
        { 0x380025, "Intel Corporate" },
        { 0x380118, "ULVAC,Inc." },
        { 0x380146, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x380195, "Samsung Electronics Co.,Ltd" },
        { 0x380197, "TSST Global,Inc" },
        { 0x38019F, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x380546, "Foctek Photonics, Inc." },
        { 0x3805AC, "Piller Group GmbH" },
        { 0x3806B4, "A.D.C. GmbH" },
        { 0x3807D4, "Zeppelin Systems GmbH" },
        { 0x3808FD, "Silca Spa" },
        { 0x3809A4, "Firefly Integrations" },
        { 0x380A0A, "Sky-City Communication and Electronics Limited Company" },
        { 0x380A94, "Samsung Electronics Co.,Ltd" },
        { 0x380AAB, "Formlabs" },
        { 0x380B3C, "Texas Instruments" },
        { 0x380B40, "Samsung Electronics Co.,Ltd" },
        { 0x380DD4, "Primax Electronics Ltd." },
        { 0x380E4D, "Cisco Systems, Inc" },
        { 0x380E7B, "V.P.S. Thai Co., Ltd" },
        { 0x380F4A, "Apple, Inc." },
        { 0x380FE4, "Dedicated Network Partners Oy" },
        { 0x3810D5, "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
        { 0x38144E, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x3816D1, "Samsung Electronics Co.,Ltd" },
        { 0x381730, "Ulrich Lippert GmbH & Co KG" },
        { 0x381766, "PROMZAKAZ LTD." },
        { 0x3817C3, "Hewlett Packard Enterprise" },
        { 0x3817E1, "Technicolor CH USA Inc." },
        { 0x38184C, "Sony Home Entertainment&Sound Products Inc" },
        { 0x38192F, "Nokia Corporation" },
        { 0x381A52, "Seiko Epson Corporation" },
        { 0x381C1A, "Cisco Systems, Inc" },
        { 0x381C23, "Hilan Technology CO.,LTD" },
        { 0x381C4A, "SIMCom Wireless Solutions Co.,Ltd." },
        { 0x381D14, "Skydio Inc." },
        { 0x381DD9, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x382056, "Cisco Systems, Inc" },
        { 0x3820A8, "ColorTokens, Inc." },
        { 0x382187, "Midea Group Co., Ltd." },
        { 0x3821C7, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x38229D, "ADB Broadband Italia" },
        { 0x3822D6, "Hangzhou H3C Technologies Co., Limited" },
        { 0x3822E2, "HP Inc." },
        { 0x38256B, "Microsoft Mobile Oy" },
        { 0x38262B, "UTran Technology" },
        { 0x3826CD, "ANDTEK" },
        { 0x3828EA, "Fujian Netcom Technology Co., LTD" },
        { 0x38295A, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x3829DD, "ONvocal Inc" },
        { 0x382A19, "Technica Engineering GmbH" },
        { 0x382B78, "ECO PLUGS ENTERPRISE CO., LTD" },
        { 0x382C4A, "ASUSTek COMPUTER INC." },
        { 0x382DD1, "Samsung Electronics Co.,Ltd" },
        { 0x382DE8, "Samsung Electronics Co.,Ltd" },
        { 0x3830F9, "LG Electronics (Mobile Communications)" },
        { 0x3831AC, "WEG" },
        { 0x3835FB, "Sagemcom Broadband SAS" },
        { 0x38378B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x383A21, "IEEE Registration Authority" },
        { 0x383B26, "Jiangsu Qinheng Co., Ltd." },
        { 0x383BC8, "2Wire Inc" },
        { 0x383C9C, "Fujian Newland Payment Technology Co.,Ltd." },
        { 0x383F10, "DBL Technology Ltd." },
        { 0x383FB3, "Technicolor CH USA Inc." },
        { 0x384233, "Wildeboer Bauteile GmbH" },
        { 0x3842A6, "Ingenieurbuero Stahlkopf" },
        { 0x384369, "Patrol Products Consortium LLC" },
        { 0x38437D, "Compal Broadband Networks, Inc." },
        { 0x3843E5, "Grotech Inc" },
        { 0x38454C, "Light Labs, Inc." },
        { 0x38458C, "MyCloud Technology corporation" },
        { 0x384608, "zte corporation" },
        { 0x3847BC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x38484C, "Apple, Inc." },
        { 0x384B5B, "ZTRON TECHNOLOGY LIMITED" },
        { 0x384B76, "AIRTAME ApS" },
        { 0x384C4F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x384C90, "ARRIS Group, Inc." },
        { 0x384F49, "Juniper Networks" },
        { 0x384FF0, "AzureWave Technology Inc." },
        { 0x38521A, "Nokia" },
        { 0x38539C, "Apple, Inc." },
        { 0x38549B, "zte corporation" },
        { 0x385610, "CANDY HOUSE, Inc." },
        { 0x3856B5, "Peerbridge Health Inc" },
        { 0x38580C, "Panaccess Systems GmbH" },
        { 0x3859F8, "MindMade Sp. z o.o." },
        { 0x3859F9, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x385AA8, "Beijing Zhongdun Security Technology Development Co." },
        { 0x385F66, "Cisco SPVTG" },
        { 0x385FC3, "Yu Jeong System, Co.Ltd" },
        { 0x386077, "PEGATRON CORPORATION" },
        { 0x3863BB, "Hewlett Packard" },
        { 0x3863F6, "3NOD MULTIMEDIA(SHENZHEN)CO.,LTD" },
        { 0x386645, "OOSIC Technology CO.,Ltd" },
        { 0x3866F0, "Apple, Inc." },
        { 0x386793, "Asia Optical Co., Inc." },
        { 0x386893, "Intel Corporate" },
        { 0x3868A4, "Samsung Electronics Co.,LTD" },
        { 0x3868DD, "INVENTEC CORPORATION" },
        { 0x386A77, "Samsung Electronics Co.,Ltd" },
        { 0x386B1C, "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x386BBB, "ARRIS Group, Inc." },
        { 0x386C9B, "Ivy Biomedical" },
        { 0x386E21, "Wasion Group Ltd." },
        { 0x386E88, "zte corporation" },
        { 0x386EA2, "vivo Mobile Communication Co., Ltd." },
        { 0x38700C, "ARRIS Group, Inc." },
        { 0x3871DE, "Apple, Inc." },
        { 0x3872C0, "Comtrend Corporation" },
        { 0x3873EA, "IEEE Registration Authority" },
        { 0x3876CA, "Shenzhen Smart Intelligent Technology Co.Ltd" },
        { 0x3876D1, "Euronda SpA" },
        { 0x387862, "Sony Mobile Communications Inc" },
        { 0x387A3C, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x387B47, "AKELA, Inc." },
        { 0x3880DF, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x3881D7, "Texas Instruments" },
        { 0x388345, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x38839A, "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD." },
        { 0x388479, "Cisco Meraki" },
        { 0x388602, "Flexoptix GmbH" },
        { 0x38881E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x38892C, "Apple, Inc." },
        { 0x3889DC, "Opticon Sensors Europe B.V." },
        { 0x388AB7, "ITC Networks" },
        { 0x388ABE, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x388B59, "Google, Inc." },
        { 0x388C50, "LG Electronics" },
        { 0x388E7A, "AUTOIT" },
        { 0x388EE7, "Fanhattan LLC" },
        { 0x3890A5, "Cisco Systems, Inc" },
        { 0x3891D5, "Hangzhou H3C Technologies Co., Limited" },
        { 0x3891FB, "Xenox Holding BV" },
        { 0x389496, "Samsung Electronics Co.,Ltd" },
        { 0x3894E0, "Syrotech Networks. Ltd." },
        { 0x3894ED, "NETGEAR" },
        { 0x389592, "Beijing Tendyron Corporation" },
        { 0x3897A4, "ELECOM CO.,LTD." },
        { 0x3897D6, "Hangzhou H3C Technologies Co., Limited" },
        { 0x3898D8, "MERITECH CO.,LTD" },
        { 0x3898E9, "Huawei Device Co., Ltd." },
        { 0x389AF6, "Samsung Electronics Co.,Ltd" },
        { 0x389D92, "Seiko Epson Corporation" },
        { 0x389F5A, "C-Kur TV Inc." },
        { 0x389F83, "OTN Systems N.V." },
        { 0x38A28C, "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD." },
        { 0x38A4ED, "Xiaomi Communications Co Ltd" },
        { 0x38A53C, "COMECER Netherlands" },
        { 0x38A5B6, "SHENZHEN MEGMEET ELECTRICAL CO.,LTD" },
        { 0x38A6CE, "BSkyB Ltd" },
        { 0x38A851, "Moog, Ing" },
        { 0x38A86B, "Orga BV" },
        { 0x38A95F, "Actifio Inc" },
        { 0x38AA3C, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x38AC3D, "Nephos Inc" },
        { 0x38AD8E, "New H3C Technologies Co., Ltd" },
        { 0x38ADBE, "New H3C Technologies Co., Ltd" },
        { 0x38AF29, "Zhejiang Dahua Technology Co., Ltd." },
        { 0x38AFD0, "Private" },
        { 0x38AFD7, "FUJITSU LIMITED" },
        { 0x38B12D, "Sonotronic Nagel GmbH" },
        { 0x38B19E, "IEEE Registration Authority" },
        { 0x38B1DB, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x38B4D3, "BSH Hausgeraete GmbH" },
        { 0x38B54D, "Apple, Inc." },
        { 0x38B5BD, "E.G.O. Elektro-Ger" },
        { 0x38B725, "Wistron Infocomm (Zhongshan) Corporation" },
        { 0x38B74D, "Fijowave Limited" },
        { 0x38B8EB, "IEEE Registration Authority" },
        { 0x38BAB0, "Broadcom" },
        { 0x38BAF8, "Intel Corporate" },
        { 0x38BB23, "OzVision America LLC" },
        { 0x38BB3C, "Avaya Inc" },
        { 0x38BC01, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x38BC1A, "MEIZU Technology Co., Ltd." },
        { 0x38BF2F, "Espec Corp." },
        { 0x38BF33, "NEC CASIO Mobile Communications" },
        { 0x38C096, "ALPS ELECTRIC CO., LTD." },
        { 0x38C2BA, "CCTV NEOTECH" },
        { 0x38C4E8, "NSS Sp. z o.o." },
        { 0x38C70A, "WiFiSong" },
        { 0x38C7BA, "CS Services Co.,Ltd." },
        { 0x38C85C, "Cisco SPVTG" },
        { 0x38C986, "Apple, Inc." },
        { 0x38C9A9, "SMART High Reliability Solutions, Inc." },
        { 0x38CA73, "Shenzhen MiaoMing Intelligent Technology Co.,Ltd" },
        { 0x38CA97, "Contour Design LLC" },
        { 0x38CADA, "Apple, Inc." },
        { 0x38CD07, "Beijing FaceCam Technology Co., Ltd." },
        { 0x38D135, "EasyIO Corporation Sdn. Bhd." },
        { 0x38D269, "Texas Instruments" },
        { 0x38D2CA, "Zhejiang Tmall Technology Co., Ltd." },
        { 0x38D40B, "Samsung Electronics Co.,Ltd" },
        { 0x38D547, "ASUSTek COMPUTER INC." },
        { 0x38D620, "Limidea Concept Pte. Ltd." },
        { 0x38D7CA, "7HUGS LABS" },
        { 0x38D82F, "zte corporation" },
        { 0x38D9A5, "Mikotek Information Inc." },
        { 0x38DBBB, "Sunbow Telecom Co., Ltd." },
        { 0x38DE60, "Mohlenhoff GmbH" },
        { 0x38DEAD, "Intel Corporate" },
        { 0x38E08E, "Mitsubishi Electric Corporation" },
        { 0x38E1AA, "zte corporation" },
        { 0x38E26E, "ShenZhen Sweet Rain Electronics Co.,Ltd." },
        { 0x38E2DD, "zte corporation" },
        { 0x38E3C5, "Taicang T&W Electronics" },
        { 0x38E595, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x38E60A, "Xiaomi Communications Co Ltd" },
        { 0x38E7D8, "HTC Corporation" },
        { 0x38E8DF, "b gmbh medien + datenbanken" },
        { 0x38E8EE, "Nanjing Youkuo Electric Technology Co., Ltd" },
        { 0x38E98C, "Reco S.p.A." },
        { 0x38EAA7, "Hewlett Packard" },
        { 0x38EB47, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x38EC0D, "Apple, Inc." },
        { 0x38EC11, "Novatek Microelectronics Corp." },
        { 0x38ECE4, "Samsung Electronics Co.,Ltd" },
        { 0x38ED18, "Cisco Systems, Inc" },
        { 0x38EE9D, "Anedo Ltd." },
        { 0x38EFE3, "INGENICO TERMINALS SAS" },
        { 0x38F098, "Vapor Stone Rail Systems" },
        { 0x38F0C8, "Mevo Inc." },
        { 0x38F135, "SensorTec-Canada" },
        { 0x38F23E, "Microsoft Mobile Oy" },
        { 0x38F32E, "Skullcandy" },
        { 0x38F33F, "TATSUNO CORPORATION" },
        { 0x38F554, "HISENSE ELECTRIC CO.,LTD" },
        { 0x38F557, "JOLATA, INC." },
        { 0x38F597, "home2net GmbH" },
        { 0x38F601, "Solid State Storage Technology Corporation" },
        { 0x38F708, "National Resource Management, Inc." },
        { 0x38F73D, "Amazon Technologies Inc." },
        { 0x38F7B2, "SEOJUN ELECTRIC" },
        { 0x38F7CD, "IEEE Registration Authority" },
        { 0x38F85E, "HUMAX Co., Ltd." },
        { 0x38F889, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x38F8B7, "V2COM PARTICIPACOES S.A." },
        { 0x38F8CA, "OWIN Inc." },
        { 0x38F9D3, "Apple, Inc." },
        { 0x38FACA, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x38FB14, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x38FC98, "Intel Corporate" },
        { 0x38FDFE, "IEEE Registration Authority" },
        { 0x38FEC5, "Ellips B.V." },
        { 0x38FF36, "Ruckus Wireless" },
        { 0x3C01EF, "Sony Mobile Communications Inc" },
        { 0x3C02B1, "Creation Technologies LP" },
        { 0x3C0461, "ARRIS Group, Inc." },
        { 0x3C04BF, "PRAVIS SYSTEMS Co.Ltd.," },
        { 0x3C0518, "Samsung Electronics Co.,Ltd" },
        { 0x3C05AB, "Product Creation Studio" },
        { 0x3C0754, "Apple, Inc." },
        { 0x3C0771, "Sony Corporation" },
        { 0x3C081E, "Beijing Yupont Electric Power Technology Co.,Ltd" },
        { 0x3C08F6, "Cisco Systems, Inc" },
        { 0x3C096D, "Powerhouse Dynamics" },
        { 0x3C0C48, "Servergy, Inc." },
        { 0x3C0C7D, "Tiny Mesh AS" },
        { 0x3C0CDB, "UNIONMAN TECHNOLOGY CO.,LTD" },
        { 0x3C0E23, "Cisco Systems, Inc" },
        { 0x3C0FC1, "KBC Networks" },
        { 0x3C1040, "daesung network" },
        { 0x3C106F, "ALBAHITH TECHNOLOGIES" },
        { 0x3C10E6, "PHAZR Inc." },
        { 0x3C11B2, "Fraunhofer FIT" },
        { 0x3C13CC, "Cisco Systems, Inc" },
        { 0x3C15C2, "Apple, Inc." },
        { 0x3C15EA, "TESCOM CO., LTD." },
        { 0x3C15FB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3C1710, "Sagemcom Broadband SAS" },
        { 0x3C189F, "Nokia Corporation" },
        { 0x3C18A0, "Luxshare Precision Industry Company Limited" },
        { 0x3C1915, "GFI Chrono Time" },
        { 0x3C197D, "Ericsson AB" },
        { 0x3C1A0F, "ClearSky Data" },
        { 0x3C1A57, "Cardiopulmonary Corp" },
        { 0x3C1A79, "Huayuan Technology CO.,LTD" },
        { 0x3C1A9E, "VitalThings AS" },
        { 0x3C1CBE, "JADAK LLC" },
        { 0x3C1E04, "D-Link International" },
        { 0x3C1E13, "HANGZHOU SUNRISE TECHNOLOGY CO., LTD" },
        { 0x3C20F6, "Samsung Electronics Co.,Ltd" },
        { 0x3C22FB, "Apple, Inc." },
        { 0x3C24F0, "IEEE Registration Authority" },
        { 0x3C25D7, "Nokia Corporation" },
        { 0x3C26D5, "Sotera Wireless" },
        { 0x3C2763, "SLE quality engineering GmbH & Co. KG" },
        { 0x3C286D, "Google, Inc." },
        { 0x3C28A6, "Alcatel-Lucent Enterprise (China)" },
        { 0x3C2AF4, "Brother Industries, LTD." },
        { 0x3C2C30, "Dell Inc." },
        { 0x3C2C94, "杭州德澜科技有限公司（HangZhou Delan Technology Co.,Ltd）" },
        { 0x3C2C99, "Edgecore Networks Corporation" },
        { 0x3C2DB7, "Texas Instruments" },
        { 0x3C2EF9, "Apple, Inc." },
        { 0x3C2EFF, "Apple, Inc." },
        { 0x3C2F3A, "SFORZATO Corp." },
        { 0x3C300C, "Dewar Electronics Pty Ltd" },
        { 0x3C306F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3C3178, "Qolsys Inc." },
        { 0x3C3300, "Shenzhen Bilian electronic CO.,LTD" },
        { 0x3C3556, "Cognitec Systems GmbH" },
        { 0x3C363D, "Nokia Corporation" },
        { 0x3C36E4, "ARRIS Group, Inc." },
        { 0x3C3786, "NETGEAR" },
        { 0x3C3888, "ConnectQuest, llc" },
        { 0x3C39C3, "JW Electronics Co., Ltd." },
        { 0x3C39E7, "IEEE Registration Authority" },
        { 0x3C3A73, "Avaya Inc" },
        { 0x3C3F51, "2CRSI" },
        { 0x3C404F, "GUANGDONG PISEN ELECTRONICS CO.,LTD" },
        { 0x3C410E, "Cisco Systems, Inc" },
        { 0x3C427E, "IEEE Registration Authority" },
        { 0x3C438E, "ARRIS Group, Inc." },
        { 0x3C46D8, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x3C4711, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3C479B, "Theissen Training Systems, Inc." },
        { 0x3C4937, "ASSMANN Electronic GmbH" },
        { 0x3C4A92, "Hewlett Packard" },
        { 0x3C4C69, "Infinity System S.L." },
        { 0x3C4CD0, "CERAGON NETWORKS" },
        { 0x3C4DBE, "Apple, Inc." },
        { 0x3C4E47, "Etronic A/S" },
        { 0x3C510E, "Cisco Systems, Inc" },
        { 0x3C5282, "Hewlett Packard" },
        { 0x3C53D7, "CEDES AG" },
        { 0x3C5731, "Cisco Systems, Inc" },
        { 0x3C574F, "China Mobile Group Device Co.,Ltd." },
        { 0x3C576C, "Samsung Electronics Co.,Ltd" },
        { 0x3C57BD, "Kessler Crane Inc." },
        { 0x3C57D5, "FiveCo" },
        { 0x3C58C2, "Intel Corporate" },
        { 0x3C591E, "TCL King Electrical Appliances (Huizhou) Co., Ltd" },
        { 0x3C5A37, "Samsung Electronics Co.,Ltd" },
        { 0x3C5AB4, "Google, Inc." },
        { 0x3C5CC3, "Shenzhen First Blue Chip Technology Ltd" },
        { 0x3C5CC4, "Amazon Technologies Inc." },
        { 0x3C5CF1, "eero inc." },
        { 0x3C5EC3, "Cisco Systems, Inc" },
        { 0x3C5F01, "Synerchip Co., Ltd." },
        { 0x3C6104, "Juniper Networks" },
        { 0x3C6105, "Espressif Inc." },
        { 0x3C6200, "Samsung Electronics Co.,Ltd" },
        { 0x3C6278, "SHENZHEN JETNET TECHNOLOGY CO.,LTD." },
        { 0x3C6716, "Lily Robotics" },
        { 0x3C672C, "Sciovid Inc." },
        { 0x3C678C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3C6816, "VXi Corporation" },
        { 0x3C6A2C, "IEEE Registration Authority" },
        { 0x3C6A7D, "Niigata Power Systems Co., Ltd." },
        { 0x3C6A9D, "Dexatek Technology LTD." },
        { 0x3C6AA7, "Intel Corporate" },
        { 0x3C6E63, "Mitron OY" },
        { 0x3C6F45, "Fiberpro Inc." },
        { 0x3C6FEA, "Panasonic India Pvt. Ltd." },
        { 0x3C6FF7, "EnTek Systems, Inc." },
        { 0x3C7059, "MakerBot Industries" },
        { 0x3C71BF, "Espressif Inc." },
        { 0x3C7437, "RIM" },
        { 0x3C754A, "ARRIS Group, Inc." },
        { 0x3C77E6, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x3C7843, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3C7873, "Airsonics" },
        { 0x3C7A8A, "ARRIS Group, Inc." },
        { 0x3C7C3F, "ASUSTek COMPUTER INC." },
        { 0x3C7D0A, "Apple, Inc." },
        { 0x3C7DB1, "Texas Instruments" },
        { 0x3C7F6F, "Telechips, Inc." },
        { 0x3C806B, "Hunan Voc Acoustics Technology Co., Ltd." },
        { 0x3C80AA, "Ransnet Singapore Pte Ltd" },
        { 0x3C81D8, "Sagemcom Broadband SAS" },
        { 0x3C831E, "CKD Corporation" },
        { 0x3C8375, "Microsoft Corporation" },
        { 0x3C83B5, "Advance Vision Electronics Co. Ltd." },
        { 0x3C846A, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x3C86A8, "Sangshin elecom .co,, LTD" },
        { 0x3C86D1, "vivo Mobile Communication Co., Ltd." },
        { 0x3C894D, "Dr. Ing. h.c. F. Porsche AG" },
        { 0x3C8970, "Neosfar" },
        { 0x3C8994, "BSkyB Ltd" },
        { 0x3C89A6, "KAPELSE" },
        { 0x3C8AB0, "Juniper Networks" },
        { 0x3C8AE5, "Tensun Information Technology(Hangzhou) Co.,LTD" },
        { 0x3C8BCD, "Alcatel-Lucent Shanghai Bell Co., Ltd" },
        { 0x3C8BFE, "Samsung Electronics Co.,Ltd" },
        { 0x3C8C40, "Hangzhou H3C Technologies Co., Limited" },
        { 0x3C8C93, "Juniper Networks" },
        { 0x3C8CF8, "TRENDnet, Inc." },
        { 0x3C8D20, "Google, Inc." },
        { 0x3C8F06, "Shenzhen Libtor Technology Co.,Ltd" },
        { 0x3C9066, "SmartRG, Inc." },
        { 0x3C912B, "Vexata Inc" },
        { 0x3C9157, "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd" },
        { 0x3C9174, "ALONG COMMUNICATION TECHNOLOGY" },
        { 0x3C9180, "Liteon Technology Corporation" },
        { 0x3C92DC, "Octopod Technology Co. Ltd." },
        { 0x3C94D5, "Juniper Networks" },
        { 0x3C9509, "Liteon Technology Corporation" },
        { 0x3C970E, "Wistron InfoComm(Kunshan)Co.,Ltd." },
        { 0x3C977E, "IPS Technology Limited" },
        { 0x3C9872, "Sercomm Corporation." },
        { 0x3C98BF, "Quest Controls, Inc." },
        { 0x3C99F7, "Lansentechnology AB" },
        { 0x3C9A77, "Technicolor CH USA Inc." },
        { 0x3C9BD6, "Vizio, Inc" },
        { 0x3C9C0F, "Intel Corporate" },
        { 0x3C9D56, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3C9F81, "Shenzhen CATIC Bit Communications Technology Co.,Ltd" },
        { 0x3CA067, "Liteon Technology Corporation" },
        { 0x3CA10D, "Samsung Electronics Co.,Ltd" },
        { 0x3CA308, "Texas Instruments" },
        { 0x3CA315, "Bless Information & Communications Co., Ltd" },
        { 0x3CA31A, "Oilfind International LLC" },
        { 0x3CA348, "vivo Mobile Communication Co., Ltd." },
        { 0x3CA37E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3CA581, "vivo Mobile Communication Co., Ltd." },
        { 0x3CA616, "vivo Mobile Communication Co., Ltd." },
        { 0x3CA62F, "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
        { 0x3CA72B, "MRV Communications (Networks) LTD" },
        { 0x3CA82A, "Hewlett Packard" },
        { 0x3CA9F4, "Intel Corporate" },
        { 0x3CAA3F, "iKey, Ltd." },
        { 0x3CAB8E, "Apple, Inc." },
        { 0x3CAE69, "ESA Elektroschaltanlagen Grimma GmbH" },
        { 0x3CB15B, "Avaya Inc" },
        { 0x3CB17F, "Wattwatchers Pty Ld" },
        { 0x3CB233, "Huawei Device Co., Ltd." },
        { 0x3CB53D, "HUNAN GOKE MICROELECTRONICS CO.,LTD" },
        { 0x3CB6B7, "vivo Mobile Communication Co., Ltd." },
        { 0x3CB72B, "PLUMgrid Inc" },
        { 0x3CB74B, "Technicolor CH USA Inc." },
        { 0x3CB792, "Hitachi Maxell, Ltd., Optronics Division" },
        { 0x3CB87A, "Private" },
        { 0x3CB9A6, "Belden Deutschland GmbH" },
        { 0x3CBB73, "Shenzhen Xinguodu Technology Co., Ltd." },
        { 0x3CBBFD, "Samsung Electronics Co.,Ltd" },
        { 0x3CBD3E, "Beijing Xiaomi Electronics Co., Ltd." },
        { 0x3CBDC5, "Arcadyan Corporation" },
        { 0x3CBDD8, "LG ELECTRONICS INC" },
        { 0x3CBEE1, "NIKON CORPORATION" },
        { 0x3CBF60, "Apple, Inc." },
        { 0x3CC079, "Shenzhen One-Nine Intelligent Electronic Science and Technology Co., Ltd" },
        { 0x3CC0C6, "d&b audiotechnik GmbH" },
        { 0x3CC12C, "AES Corporation" },
        { 0x3CC1F6, "Melange Systems Pvt. Ltd." },
        { 0x3CC243, "Nokia Corporation" },
        { 0x3CC2E1, "XINHUA CONTROL ENGINEERING CO.,LTD" },
        { 0x3CC99E, "Huiyang Technology Co., Ltd" },
        { 0x3CCA87, "Iders Incorporated" },
        { 0x3CCB7C, "TCT mobile ltd" },
        { 0x3CCD36, "Apple, Inc." },
        { 0x3CCD5A, "Technische Alternative GmbH" },
        { 0x3CCD5D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3CCD93, "LG ELECTRONICS INC" },
        { 0x3CCE15, "Mercedes-Benz USA, LLC" },
        { 0x3CCE73, "Cisco Systems, Inc" },
        { 0x3CCF5B, "ICOMM HK LIMITED" },
        { 0x3CD0F8, "Apple, Inc." },
        { 0x3CD16E, "Telepower Communication Co., Ltd" },
        { 0x3CD2E5, "New H3C Technologies Co., Ltd" },
        { 0x3CD4D6, "WirelessWERX, Inc" },
        { 0x3CD7DA, "SK Mtek microelectronics(shenzhen)limited" },
        { 0x3CD92B, "Hewlett Packard" },
        { 0x3CD9CE, "Eclipse WiFi" },
        { 0x3CDA2A, "zte corporation" },
        { 0x3CDA6D, "Tiandy Technologies CO.,LTD" },
        { 0x3CDCBC, "Samsung Electronics Co.,Ltd" },
        { 0x3CDD89, "SOMO HOLDINGS & TECH. CO.,LTD." },
        { 0x3CDF1E, "Cisco Systems, Inc" },
        { 0x3CDFA9, "ARRIS Group, Inc." },
        { 0x3CDFBD, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3CE038, "Plumeria Networks, Inc." },
        { 0x3CE072, "Apple, Inc." },
        { 0x3CE1A1, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x3CE3E7, "China Mobile Group Device Co.,Ltd." },
        { 0x3CE5A6, "Hangzhou H3C Technologies Co., Limited" },
        { 0x3CE5B4, "KIDASEN INDUSTRIA E COMERCIO DE ANTENAS LTDA" },
        { 0x3CE624, "LG Display" },
        { 0x3CE824, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3CEA4F, "2Wire Inc" },
        { 0x3CEAF9, "JUBIXCOLTD" },
        { 0x3CEAFB, "NSE AG" },
        { 0x3CECEF, "Super Micro Computer, Inc." },
        { 0x3CEF8C, "Zhejiang Dahua Technology Co., Ltd." },
        { 0x3CF011, "Intel Corporate" },
        { 0x3CF392, "Virtualtek. Co. Ltd" },
        { 0x3CF4F9, "Moda-InnoChips" },
        { 0x3CF52C, "DSPECIALISTS GmbH" },
        { 0x3CF591, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x3CF5CC, "New H3C Technologies Co., Ltd" },
        { 0x3CF652, "zte corporation" },
        { 0x3CF72A, "Nokia Corporation" },
        { 0x3CF748, "Shenzhen Linsn Technology Development Co.,Ltd" },
        { 0x3CF7A4, "Samsung Electronics Co.,Ltd" },
        { 0x3CF808, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3CF862, "Intel Corporate" },
        { 0x3CFA43, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x3CFAD3, "IEEE Registration Authority" },
        { 0x3CFB5C, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x3CFB96, "Emcraft Systems LLC" },
        { 0x3CFDFE, "Intel Corporate" },
        { 0x4000E0, "Derek(Shaoguan)Limited" },
        { 0x400107, "Arista Corp" },
        { 0x40017A, "Cisco Systems, Inc" },
        { 0x4001C6, "3COM EUROPE LTD" },
        { 0x40040C, "A&T" },
        { 0x400589, "T-Mobile, USA" },
        { 0x400634, "Huawei Device Co., Ltd." },
        { 0x4006A0, "Texas Instruments" },
        { 0x4007C0, "Railtec Systems GmbH" },
        { 0x400D10, "ARRIS Group, Inc." },
        { 0x400E67, "Tremol Ltd." },
        { 0x400E85, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x401175, "IEEE Registration Authority" },
        { 0x4011DC, "Sonance" },
        { 0x4012E4, "Compass-EOS" },
        { 0x4013D9, "Global ES" },
        { 0x4014AD, "Huawei Device Co., Ltd." },
        { 0x401597, "Protect America, Inc." },
        { 0x40163B, "Samsung Electronics Co.,Ltd" },
        { 0x40167E, "ASUSTek COMPUTER INC." },
        { 0x40169F, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x4016FA, "EKM Metering" },
        { 0x4017E2, "INTAI TECHNOLOGY CORP." },
        { 0x4018B1, "Extreme Networks, Inc." },
        { 0x4018D7, "Smartronix, Inc." },
        { 0x401920, "Movon Corporation" },
        { 0x401B5F, "WEIFANG GOERTEK ELECTRONICS CO.,LTD" },
        { 0x401C83, "Intel Corporate" },
        { 0x401D59, "Biometric Associates, LP" },
        { 0x4022ED, "Digital Projection Ltd" },
        { 0x402343, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x4025C2, "Intel Corporate" },
        { 0x402619, "Apple, Inc." },
        { 0x40270B, "Mobileeco Co., Ltd" },
        { 0x402814, "RFI Engineering" },
        { 0x402B50, "ARRIS Group, Inc." },
        { 0x402B69, "Kumho Electric Inc." },
        { 0x402BA1, "Sony Mobile Communications Inc" },
        { 0x402C76, "IEEE Registration Authority" },
        { 0x402CF4, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x402E28, "MiXTelematics" },
        { 0x402E71, "Texas Instruments" },
        { 0x402F86, "LG Innotek" },
        { 0x403004, "Apple, Inc." },
        { 0x403067, "Conlog (Pty) Ltd" },
        { 0x40313C, "XIAOMI Electronics,CO.,LTD" },
        { 0x40331A, "Apple, Inc." },
        { 0x40336C, "Godrej & Boyce Mfg. co. ltd" },
        { 0x4037AD, "Macro Image Technology, Inc." },
        { 0x403CFC, "Apple, Inc." },
        { 0x403DEC, "HUMAX Co., Ltd." },
        { 0x403F8C, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x404022, "ZIV" },
        { 0x404028, "ZIV" },
        { 0x40406B, "Icomera" },
        { 0x4040A7, "Sony Mobile Communications Inc" },
        { 0x404229, "Layer3TV, Inc" },
        { 0x4045DA, "Spreadtrum Communications (Shanghai) Co., Ltd." },
        { 0x40476A, "Astro Gaming" },
        { 0x4048FD, "IEEE Registration Authority" },
        { 0x40490F, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x40498A, "Synapticon GmbH" },
        { 0x404A03, "Zyxel Communications Corporation" },
        { 0x404A18, "Addrek Smart Solutions" },
        { 0x404AD4, "Widex A/S" },
        { 0x404C77, "ARRIS Group, Inc." },
        { 0x404D7F, "Apple, Inc." },
        { 0x404D8E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x404E36, "HTC Corporation" },
        { 0x404EEB, "Higher Way Electronic Co., Ltd." },
        { 0x4050B5, "Shenzhen New Species Technology Co., Ltd." },
        { 0x4050E0, "Milton Security Group LLC" },
        { 0x40516C, "Grandex International Corporation" },
        { 0x40520D, "Pico Technology" },
        { 0x4054E4, "Wearsafe Labs Inc" },
        { 0x405539, "Cisco Systems, Inc" },
        { 0x405582, "Nokia" },
        { 0x40560C, "In Home Displays Ltd" },
        { 0x40562D, "Smartron India Pvt ltd" },
        { 0x405662, "GuoTengShengHua Electronics LTD." },
        { 0x405A9B, "ANOVO" },
        { 0x405BD8, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x405CFD, "Dell Inc." },
        { 0x405D82, "NETGEAR" },
        { 0x405EE1, "Shenzhen H&T Intelligent Control Co.,Ltd." },
        { 0x405FBE, "RIM" },
        { 0x405FC2, "Texas Instruments" },
        { 0x40605A, "Hawkeye Tech Co. Ltd" },
        { 0x406186, "MICRO-STAR INT'L CO.,LTD" },
        { 0x40618E, "Stella-Green Co" },
        { 0x406231, "GIFA" },
        { 0x406234, "Telink Semiconductor (Shanghai) Co., Ltd." },
        { 0x4062B6, "Tele system communication" },
        { 0x4062EA, "China Mobile Group Device Co.,Ltd." },
        { 0x4064A4, "THE FURUKAWA ELECTRIC CO., LTD" },
        { 0x4065A3, "Sagemcom Broadband SAS" },
        { 0x40667A, "mediola - connected living AG" },
        { 0x406826, "Thales UK Limited" },
        { 0x406A8E, "Hangzhou Puwell OE Tech Ltd." },
        { 0x406AAB, "RIM" },
        { 0x406C8F, "Apple, Inc." },
        { 0x406F2A, "BlackBerry RTS" },
        { 0x407009, "ARRIS Group, Inc." },
        { 0x40704A, "Power Idea Technology Limited" },
        { 0x407074, "Life Technology (China) Co., Ltd" },
        { 0x4070F5, "Apple, Inc." },
        { 0x407183, "Juniper Networks" },
        { 0x407496, "aFUN TECHNOLOGY INC." },
        { 0x4074E0, "Intel Corporate" },
        { 0x4077A9, "New H3C Technologies Co., Ltd" },
        { 0x40786A, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x407875, "IMBEL - Industria de Material Belico do Brasil" },
        { 0x407A80, "Nokia Corporation" },
        { 0x407B1B, "Mettle Networks Inc." },
        { 0x407C7D, "Nokia" },
        { 0x407D0F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x407FE0, "Glory Star Technics (ShenZhen) Limited" },
        { 0x408256, "Continental Automotive GmbH" },
        { 0x40831D, "Apple, Inc." },
        { 0x4083DE, "Zebra Technologies Inc" },
        { 0x408493, "Clavister AB" },
        { 0x40862E, "JDM MOBILE INTERNET SOLUTION CO., LTD." },
        { 0x408805, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x40882F, "Extreme Networks, Inc." },
        { 0x4088E0, "Beijing Ereneben Information Technology Limited Shenzhen Branch" },
        { 0x408A9A, "TITENG CO., Ltd." },
        { 0x408B07, "Actiontec Electronics, Inc" },
        { 0x408BF6, "Shenzhen TCL New Technology Co., Ltd" },
        { 0x408C4C, "Shenzhen MiaoMing Intelligent Technology Co.,Ltd" },
        { 0x408D5C, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x409505, "ACOINFO TECHNOLOGY CO.,LTD" },
        { 0x409558, "Aisino Corporation" },
        { 0x4095BD, "NTmore.Co.,Ltd" },
        { 0x4097D1, "BK Electronics cc" },
        { 0x40984C, "Casacom Solutions AG" },
        { 0x40984E, "Texas Instruments" },
        { 0x40987B, "Aisino Corporation" },
        { 0x4098AD, "Apple, Inc." },
        { 0x409922, "AzureWave Technology Inc." },
        { 0x409B0D, "Shenzhen Yourf Kwan Industrial Co., Ltd" },
        { 0x409BCD, "D-Link International" },
        { 0x409C28, "Apple, Inc." },
        { 0x409F38, "AzureWave Technology Inc." },
        { 0x409F87, "Jide Technology (Hong Kong) Limited" },
        { 0x409FC7, "BAEKCHUN I&C Co., Ltd." },
        { 0x40A108, "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
        { 0x40A2DB, "Amazon Technologies Inc." },
        { 0x40A3CC, "Intel Corporate" },
        { 0x40A5EF, "Shenzhen Four Seas Global Link Network Technology Co., Ltd." },
        { 0x40A677, "Juniper Networks" },
        { 0x40A6A4, "PassivSystems Ltd" },
        { 0x40A6B7, "Intel Corporate" },
        { 0x40A6D9, "Apple, Inc." },
        { 0x40A6E8, "Cisco Systems, Inc" },
        { 0x40A8F0, "Hewlett Packard" },
        { 0x40A93F, "Pivotal Commware, Inc." },
        { 0x40A9CF, "Amazon Technologies Inc." },
        { 0x40AA56, "China Dragon Technology Limited" },
        { 0x40AC8D, "Data Management, Inc." },
        { 0x40B034, "Hewlett Packard" },
        { 0x40B076, "ASUSTek COMPUTER INC." },
        { 0x40B0FA, "LG Electronics (Mobile Communications)" },
        { 0x40B2C8, "Nortel Networks" },
        { 0x40B30E, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x40B31E, "Universal Electronics, Inc." },
        { 0x40B395, "Apple, Inc." },
        { 0x40B3CD, "Chiyoda Electronics Co.,Ltd." },
        { 0x40B3FC, "Logital Co. Limited" },
        { 0x40B4CD, "Amazon Technologies Inc." },
        { 0x40B4F0, "Juniper Networks" },
        { 0x40B5C1, "Cisco Systems, Inc" },
        { 0x40B688, "LEGIC Identsystems AG" },
        { 0x40B6B1, "SUNGSAM CO,.Ltd" },
        { 0x40B6E7, "Huawei Device Co., Ltd." },
        { 0x40B7F3, "ARRIS Group, Inc." },
        { 0x40B837, "Sony Mobile Communications Inc" },
        { 0x40B89A, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x40B93C, "Hewlett Packard Enterprise" },
        { 0x40BA61, "ARIMA Communications Corp." },
        { 0x40BC60, "Apple, Inc." },
        { 0x40BC68, "Wuhan Funshion Online Technologies Co.,Ltd" },
        { 0x40BC73, "Cronoplast S.L." },
        { 0x40BC8B, "itelio GmbH" },
        { 0x40BD32, "Texas Instruments" },
        { 0x40BD9E, "Physio-Control, Inc" },
        { 0x40BF17, "Digistar Telecom. SA" },
        { 0x40C245, "Shenzhen Hexicom Technology Co., Ltd." },
        { 0x40C3C6, "SnapRoute" },
        { 0x40C4D6, "ChongQing Camyu Technology Development Co.,Ltd." },
        { 0x40C62A, "Shanghai Jing Ren Electronic Technology Co., Ltd." },
        { 0x40C729, "Sagemcom Broadband SAS" },
        { 0x40C7C9, "Naviit Inc." },
        { 0x40C81F, "Shenzhen Xinguodu Technology Co., Ltd." },
        { 0x40C8CB, "AM Telecom co., Ltd." },
        { 0x40CBA8, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x40CBC0, "Apple, Inc." },
        { 0x40CD3A, "Z3 Technology" },
        { 0x40CD7A, "Qingdao Hisense Communications Co.,Ltd." },
        { 0x40CE24, "Cisco Systems, Inc" },
        { 0x40D25F, "ITEL MOBILE LIMITED" },
        { 0x40D28A, "Nintendo Co., Ltd." },
        { 0x40D32D, "Apple, Inc." },
        { 0x40D357, "Ison Technology Co., Ltd." },
        { 0x40D3AE, "Samsung Electronics Co.,Ltd" },
        { 0x40D40E, "Biodata Ltd" },
        { 0x40D4BD, "SK Networks Service CO., LTD." },
        { 0x40D559, "MICRO S.E.R.I." },
        { 0x40D63C, "Equitech Industrial(DongGuan)Co.,Ltd" },
        { 0x40D855, "IEEE Registration Authority" },
        { 0x40DC9D, "HAJEN" },
        { 0x40DCA5, "Huawei Device Co., Ltd." },
        { 0x40DDD1, "Beautiful Card Corporation" },
        { 0x40DEAD, "Juniper Networks" },
        { 0x40DF02, "LINE BIZ Plus" },
        { 0x40E230, "AzureWave Technology Inc." },
        { 0x40E3D6, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x40E730, "DEY Storage Systems, Inc." },
        { 0x40E793, "Shenzhen Siviton Technology Co.,Ltd" },
        { 0x40EACE, "FOUNDER BROADBAND NETWORK SERVICE CO.,LTD" },
        { 0x40EC99, "Intel Corporate" },
        { 0x40ECF8, "Siemens AG" },
        { 0x40ED98, "IEEE Registration Authority" },
        { 0x40EEDD, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x40EF4C, "Fihonest communication co.,Ltd" },
        { 0x40F02F, "Liteon Technology Corporation" },
        { 0x40F04E, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x40F078, "Cisco Systems, Inc" },
        { 0x40F14C, "ISE Europe SPRL" },
        { 0x40F201, "Sagemcom Broadband SAS" },
        { 0x40F21C, "DASAN Zhone Solutions" },
        { 0x40F2E9, "IBM" },
        { 0x40F308, "Murata Manufacturing Co., Ltd." },
        { 0x40F385, "IEEE Registration Authority" },
        { 0x40F407, "Nintendo Co., Ltd." },
        { 0x40F413, "Rubezh" },
        { 0x40F420, "SICHUAN TIANYI COMHEART TELECOMCO.,LTD" },
        { 0x40F4EC, "Cisco Systems, Inc" },
        { 0x40F520, "Espressif Inc." },
        { 0x40F52E, "Leica Microsystems (Schweiz) AG" },
        { 0x40F946, "Apple, Inc." },
        { 0x40F9D5, "Tecore Networks" },
        { 0x40FA7F, "Preh Car Connect GmbH" },
        { 0x40FC89, "ARRIS Group, Inc." },
        { 0x40FE0D, "MAXIO" },
        { 0x440010, "Apple, Inc." },
        { 0x440049, "Amazon Technologies Inc." },
        { 0x44004D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4401BB, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x44032C, "Intel Corporate" },
        { 0x440377, "IEEE Registration Authority" },
        { 0x4403A7, "Cisco Systems, Inc" },
        { 0x440444, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x44070B, "Google, Inc." },
        { 0x4409B8, "Salcomp (Shenzhen) CO., LTD." },
        { 0x440CFD, "NetMan Co., Ltd." },
        { 0x4410FE, "Huizhou Foryou General Electronics Co., Ltd." },
        { 0x441102, "EDMI Europe Ltd" },
        { 0x4411C2, "Telegartner Karl Gartner GmbH" },
        { 0x441319, "WKK TECHNOLOGY LTD." },
        { 0x4413D0, "zte corporation" },
        { 0x441441, "AudioControl Inc." },
        { 0x441622, "Microsoft Corporation" },
        { 0x441847, "HUNAN SCROWN ELECTRONIC INFORMATION TECH.CO.,LTD" },
        { 0x44184F, "Fitview" },
        { 0x4418FD, "Apple, Inc." },
        { 0x4419B6, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x441AFA, "New H3C Technologies Co., Ltd" },
        { 0x441C12, "Technicolor CH USA Inc." },
        { 0x441C7F, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x441CA8, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x441E91, "ARVIDA Intelligent Electronics Technology Co.,Ltd." },
        { 0x441E98, "Ruckus Wireless" },
        { 0x441EA1, "Hewlett Packard" },
        { 0x44227C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x442295, "China Mobile Iot Limited company" },
        { 0x4422F1, "S.FAC, INC" },
        { 0x44237C, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x4423AA, "Farmage Co., Ltd." },
        { 0x4425BB, "Bamboo Entertainment Corporation" },
        { 0x4427F3, "70mai Co.,Ltd." },
        { 0x4428A3, "Jiangsu fulian Communication Technology Co., Ltd." },
        { 0x442938, "NietZsche enterprise Co.Ltd." },
        { 0x442A60, "Apple, Inc." },
        { 0x442AFF, "E3 Technology, Inc." },
        { 0x442B03, "Cisco Systems, Inc" },
        { 0x442C05, "AMPAK Technology, Inc." },
        { 0x443192, "Hewlett Packard" },
        { 0x44322A, "Avaya Inc" },
        { 0x4432C8, "Technicolor CH USA Inc." },
        { 0x44334C, "Shenzhen Bilian electronic CO.,LTD" },
        { 0x44348F, "MXT INDUSTRIAL LTDA" },
        { 0x4434A7, "ARRIS Group, Inc." },
        { 0x44356F, "Neterix" },
        { 0x443583, "Apple, Inc." },
        { 0x443708, "MRV Comunications" },
        { 0x443719, "2 Save Energy Ltd" },
        { 0x44376F, "Young Electric Sign Co" },
        { 0x4437E6, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x443839, "Cumulus Networks, inc" },
        { 0x4439C4, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x443B32, "Intelbras" },
        { 0x443C88, "FICOSA MAROC INTERNATIONAL" },
        { 0x443C9C, "Pintsch Tiefenbach GmbH" },
        { 0x443D21, "Nuvolt" },
        { 0x443E07, "Electrolux" },
        { 0x443EB2, "DEOTRON Co., LTD." },
        { 0x44422F, "TESTOP CO.,LTD." },
        { 0x444450, "OttoQ" },
        { 0x444687, "Realme Chongqing MobileTelecommunications Corp Ltd" },
        { 0x4447CC, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x444891, "HDMI Licensing, LLC" },
        { 0x4448C1, "Hewlett Packard Enterprise" },
        { 0x444A65, "Silverflare Ltd." },
        { 0x444AB0, "Zhejiang Moorgen Intelligence Technology Co., Ltd" },
        { 0x444ADB, "Apple, Inc." },
        { 0x444B5D, "GE Healthcare" },
        { 0x444B7E, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x444C0C, "Apple, Inc." },
        { 0x444CA8, "Arista Networks" },
        { 0x444E1A, "Samsung Electronics Co.,Ltd" },
        { 0x444E6D, "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
        { 0x444F5E, "Pan Studios Co.,Ltd." },
        { 0x4451DB, "Raytheon BBN Technologies" },
        { 0x4454C0, "Thompson Aerospace" },
        { 0x4455B1, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4455C4, "Huawei Device Co., Ltd." },
        { 0x44568D, "PNC Technologies Co., Ltd." },
        { 0x4456B7, "Spawn Labs, Inc" },
        { 0x4456E2, "Sichuan Tianyi Comheart Telecom Co., Ltd." },
        { 0x445829, "Cisco SPVTG" },
        { 0x445943, "zte corporation" },
        { 0x44599F, "Criticare Systems, Inc" },
        { 0x4459E3, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x445CE9, "Samsung Electronics Co.,Ltd" },
        { 0x445D5E, "SHENZHEN Coolkit Technology CO.,LTD" },
        { 0x445ECD, "Razer Inc" },
        { 0x445EF3, "Tonalite Holding B.V." },
        { 0x445F7A, "Shihlin Electric & Engineering Corp." },
        { 0x445F8C, "Intercel Group Limited" },
        { 0x446132, "ecobee inc" },
        { 0x44619C, "FONsystem co. ltd." },
        { 0x446246, "Comat AG" },
        { 0x44650D, "Amazon Technologies Inc." },
        { 0x44656A, "Mega Video Electronic(HK) Industry Co., Ltd" },
        { 0x44657F, "Calix Inc." },
        { 0x44666E, "IP-LINE" },
        { 0x4466FC, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x446747, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x446755, "Orbit Irrigation" },
        { 0x44680C, "Wacom Co.,Ltd." },
        { 0x4468AB, "JUIN COMPANY, LIMITED" },
        { 0x446A2E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x446AB7, "ARRIS Group, Inc." },
        { 0x446C24, "Reallin Electronic Co.,Ltd" },
        { 0x446D57, "Liteon Technology Corporation" },
        { 0x446D6C, "Samsung Electronics Co.,Ltd" },
        { 0x446EE5, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x44700B, "IFFU" },
        { 0x447098, "MING HONG TECHNOLOGY (SHEN ZHEN) LIMITED" },
        { 0x4473D6, "Logitech" },
        { 0x44746C, "Sony Mobile Communications Inc" },
        { 0x447654, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x44783E, "Samsung Electronics Co.,Ltd" },
        { 0x447BBB, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x447BC4, "DualShine Technology(SZ)Co.,Ltd" },
        { 0x447C7F, "Innolight Technology Corporation" },
        { 0x447DA5, "VTION INFORMATION TECHNOLOGY (FUJIAN) CO.,LTD" },
        { 0x447E76, "Trek Technology (S) Pte Ltd" },
        { 0x447E95, "Alpha and Omega, Inc" },
        { 0x447F77, "Connected Home" },
        { 0x4480EB, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x4482E5, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x448312, "Star-Net" },
        { 0x448500, "Intel Corporate" },
        { 0x4486C1, "Siemens Low Voltage & Products" },
        { 0x448723, "HOYA SERVICE CORPORATION" },
        { 0x4487DB, "Tymphany Acoustic Technology (Huizhou) Co., Ltd." },
        { 0x4487FC, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x4488CB, "Camco Technologies NV" },
        { 0x448A5B, "Micro-Star INT'L CO., LTD." },
        { 0x448C52, "KTIS CO., Ltd" },
        { 0x448DBF, "Rhino Mobility LLC" },
        { 0x448E12, "DT Research, Inc." },
        { 0x448E81, "VIG" },
        { 0x448F17, "Samsung Electronics Co., Ltd. ARTIK" },
        { 0x4490BB, "Apple, Inc." },
        { 0x449160, "Murata Manufacturing Co., Ltd." },
        { 0x44917C, "HMD Global Oy" },
        { 0x4491DB, "Shanghai Huaqin Telecom Technology Co.,Ltd" },
        { 0x4494FC, "NETGEAR" },
        { 0x4495FA, "Qingdao Santong Digital Technology Co.Ltd" },
        { 0x44962B, "Aidon Oy" },
        { 0x44975A, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x449B78, "The Now Factory" },
        { 0x449CB5, "Alcomp, Inc" },
        { 0x449EF9, "vivo Mobile Communication Co., Ltd." },
        { 0x449F7F, "DataCore Software Corporation" },
        { 0x44A191, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x44A42D, "TCT mobile ltd" },
        { 0x44A466, "GROUPE LDLC" },
        { 0x44A54E, "Qorvo International Pte. Ltd." },
        { 0x44A56E, "NETGEAR" },
        { 0x44A61E, "INGRAM MICRO SERVICES" },
        { 0x44A689, "PROMAX ELECTRONICA SA" },
        { 0x44A6E5, "THINKING TECHNOLOGY CO.,LTD" },
        { 0x44A7CF, "Murata Manufacturing Co., Ltd." },
        { 0x44A842, "Dell Inc." },
        { 0x44A8C2, "SEWOO TECH CO., LTD" },
        { 0x44A8FC, "Apple, Inc." },
        { 0x44AA27, "udworks Co., Ltd." },
        { 0x44AA50, "Juniper Networks" },
        { 0x44AAE8, "Nanotec Electronic GmbH & Co. KG" },
        { 0x44AAF5, "ARRIS Group, Inc." },
        { 0x44AD19, "XINGFEI （H.K）LIMITED" },
        { 0x44ADB1, "Sagemcom Broadband SAS" },
        { 0x44ADD9, "Cisco Systems, Inc" },
        { 0x44AEAB, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x44AF28, "Intel Corporate" },
        { 0x44B295, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x44B32D, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x44B382, "Kuang-chi Institute of Advanced Technology" },
        { 0x44B412, "SIUS AG" },
        { 0x44B433, "tide.co.,ltd" },
        { 0x44B462, "Flextronics Tech.(Ind) Pvt Ltd" },
        { 0x44B994, "Douglas Lighting Controls" },
        { 0x44BA46, "SICHUAN TIANYI COMHEART TELECOMCO.,LTD" },
        { 0x44BB3B, "Google, Inc." },
        { 0x44BFE3, "Shenzhen Longtech Electronics Co.,Ltd" },
        { 0x44C15C, "Texas Instruments" },
        { 0x44C233, "Guangzhou Comet Technology Development Co.Ltd" },
        { 0x44C306, "SIFROM Inc." },
        { 0x44C346, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x44C39B, "OOO RUBEZH NPO" },
        { 0x44C4A9, "Opticom Communication, LLC" },
        { 0x44C56F, "NGN Easy Satfinder (Tianjin) Electronic Co., Ltd" },
        { 0x44C65D, "Apple, Inc." },
        { 0x44C69B, "Wuhan Feng Tian Information Network CO.,LTD" },
        { 0x44C7FC, "Huawei Device Co., Ltd." },
        { 0x44C874, "China Mobile Group Device Co.,Ltd." },
        { 0x44C9A2, "Greenwald Industries" },
        { 0x44CB8B, "LG Innotek" },
        { 0x44CD0E, "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.,LTD." },
        { 0x44CE3A, "Jiangsu Huacun Electronic Technology Co., Ltd." },
        { 0x44CE7D, "SFR" },
        { 0x44D15E, "Shanghai Kingto Information Technology Ltd" },
        { 0x44D1FA, "Shenzhen Yunlink Technology Co., Ltd" },
        { 0x44D244, "Seiko Epson Corporation" },
        { 0x44D2CA, "Anvia TV Oy" },
        { 0x44D3AD, "Shenzhen TINNO Mobile Technology Corp." },
        { 0x44D3CA, "Cisco Systems, Inc" },
        { 0x44D437, "Inteno Broadband Technology AB" },
        { 0x44D4E0, "Sony Mobile Communications Inc" },
        { 0x44D5A5, "AddOn Computer" },
        { 0x44D5F2, "IEEE Registration Authority" },
        { 0x44D63D, "Talari Networks" },
        { 0x44D6E1, "Snuza International Pty. Ltd." },
        { 0x44D791, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x44D832, "AzureWave Technology Inc." },
        { 0x44D878, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x44D884, "Apple, Inc." },
        { 0x44D9E7, "Ubiquiti Networks Inc." },
        { 0x44DC4E, "ITEL MOBILE LIMITED" },
        { 0x44DC91, "PLANEX COMMUNICATIONS INC." },
        { 0x44DCCB, "SEMINDIA SYSTEMS PVT LTD" },
        { 0x44E08E, "Cisco SPVTG" },
        { 0x44E137, "ARRIS Group, Inc." },
        { 0x44E49A, "OMNITRONICS PTY LTD" },
        { 0x44E4D9, "Cisco Systems, Inc" },
        { 0x44E4EE, "Wistron Neweb Corporation" },
        { 0x44E66E, "Apple, Inc." },
        { 0x44E6B0, "China Mobile IOT Company Limited" },
        { 0x44E8A5, "Myreka Technologies Sdn. Bhd." },
        { 0x44E968, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x44E9DD, "Sagemcom Broadband SAS" },
        { 0x44EA4B, "Actlas Inc." },
        { 0x44EAD8, "Texas Instruments" },
        { 0x44ECCE, "Juniper Networks" },
        { 0x44ED57, "Longicorn, inc." },
        { 0x44EE02, "MTI Ltd." },
        { 0x44EE30, "Budelmann Elektronik GmbH" },
        { 0x44EFBF, "China Dragon Technology Limited" },
        { 0x44EFCF, "UGENE SOLUTION inc." },
        { 0x44F034, "Kaonmedia CO., LTD." },
        { 0x44F21B, "Apple, Inc." },
        { 0x44F436, "zte corporation" },
        { 0x44F459, "Samsung Electronics Co.,Ltd" },
        { 0x44F477, "Juniper Networks" },
        { 0x44F4E7, "Cohesity Inc" },
        { 0x44F849, "Union Pacific Railroad" },
        { 0x44F971, "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x44FB42, "Apple, Inc." },
        { 0x44FB5A, "zte corporation" },
        { 0x44FDA3, "Everysight LTD." },
        { 0x44FE3B, "Arcadyan Corporation" },
        { 0x44FFBA, "zte corporation" },
        { 0x480031, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x480033, "Technicolor CH USA Inc." },
        { 0x4801C5, "OnePlus Technology (Shenzhen) Co., Ltd" },
        { 0x48022A, "B-Link Electronic Limited" },
        { 0x480362, "DESAY ELECTRONICS(HUIZHOU)CO.,LTD" },
        { 0x48049F, "ELECOM CO., LTD" },
        { 0x4805E2, "Huawei Device Co., Ltd." },
        { 0x48066A, "Tempered Networks, Inc." },
        { 0x480BB2, "IEEE Registration Authority" },
        { 0x480C49, "NAKAYO Inc" },
        { 0x480EEC, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x480FCF, "Hewlett Packard" },
        { 0x481063, "NTT Innovation Institute, Inc." },
        { 0x481249, "Luxcom Technologies Inc." },
        { 0x48137E, "Samsung Electronics Co.,Ltd" },
        { 0x4813F3, "BBK EDUCATIONAL ELECTRONICS CORP.,LTD." },
        { 0x481693, "Lear Corporation GmbH" },
        { 0x48174C, "MicroPower technologies" },
        { 0x481842, "Shanghai Winaas Co. Equipment Co. Ltd." },
        { 0x4818FA, "Nocsys" },
        { 0x481A84, "Pointer Telocation Ltd" },
        { 0x481BD2, "Intron Scientific co., ltd." },
        { 0x481D70, "Cisco SPVTG" },
        { 0x48210B, "PEGATRON CORPORATION" },
        { 0x48216C, "China Mobile IOT Company Limited" },
        { 0x482335, "Dialog Semiconductor Hellas SA" },
        { 0x482567, "Poly" },
        { 0x48262C, "Apple, Inc." },
        { 0x4826E8, "Tek-Air Systems, Inc." },
        { 0x482759, "Levven Electronics Ltd." },
        { 0x4827EA, "Samsung Electronics Co.,Ltd" },
        { 0x48282F, "zte corporation" },
        { 0x482AE3, "Wistron InfoComm(Kunshan)Co.,Ltd." },
        { 0x482CA0, "Xiaomi Communications Co Ltd" },
        { 0x482CD0, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x482CEA, "Motorola Inc Business Light Radios" },
        { 0x4833DD, "ZENNIO AVANCE Y TECNOLOGIA, S.L." },
        { 0x48343D, "IEP GmbH" },
        { 0x48352E, "Shenzhen Wolck Network Product Co.,LTD" },
        { 0x48365F, "Wintecronics Ltd." },
        { 0x483974, "Proware Technologies Co., Ltd." },
        { 0x483B38, "Apple, Inc." },
        { 0x483C0C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x483D32, "Syscor Controls &amp; Automation" },
        { 0x483FDA, "Espressif Inc." },
        { 0x483FE9, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x48435A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x48437C, "Apple, Inc." },
        { 0x4843DD, "Amazon Technologies Inc." },
        { 0x484487, "Cisco SPVTG" },
        { 0x4844F7, "Samsung Electronics Co.,Ltd" },
        { 0x484520, "Intel Corporate" },
        { 0x4846C1, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x4846F1, "Uros Oy" },
        { 0x4846FB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4849C7, "Samsung Electronics Co.,Ltd" },
        { 0x484A30, "George Robotics Limited" },
        { 0x484AE9, "Hewlett Packard Enterprise" },
        { 0x484BAA, "Apple, Inc." },
        { 0x484BD4, "Technicolor CH USA Inc." },
        { 0x484C86, "Huawei Device Co., Ltd." },
        { 0x484D7E, "Dell Inc." },
        { 0x484EFC, "ARRIS Group, Inc." },
        { 0x485073, "Microsoft Corporation" },
        { 0x485169, "Samsung Electronics Co.,Ltd" },
        { 0x4851B7, "Intel Corporate" },
        { 0x485261, "SOREEL" },
        { 0x485415, "NET RULES TECNOLOGIA EIRELI" },
        { 0x48555C, "Wu Qi Technologies,Inc." },
        { 0x48555F, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x485702, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4857DD, "Facebook Inc" },
        { 0x485929, "LG Electronics (Mobile Communications)" },
        { 0x4859A4, "zte corporation" },
        { 0x485A3F, "WISOL" },
        { 0x485AB6, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x485B39, "ASUSTek COMPUTER INC." },
        { 0x485D36, "Verizon" },
        { 0x485D60, "AzureWave Technology Inc." },
        { 0x485DEB, "Just Add Power" },
        { 0x485F99, "Cloud Network Technology (Samoa) Limited" },
        { 0x48605F, "LG Electronics (Mobile Communications)" },
        { 0x4860BC, "Apple, Inc." },
        { 0x4861A3, "Concern Axion JSC" },
        { 0x486276, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4865EE, "IEEE Registration Authority" },
        { 0x486834, "Silicon Motion, Inc." },
        { 0x486B2C, "BBK EDUCATIONAL ELECTRONICS CORP.,LTD." },
        { 0x486B91, "Fleetwood Group Inc." },
        { 0x486DBB, "Vestel Elektronik San ve Tic. A.Ş." },
        { 0x486E70, "Zhejiang Tmall Technology Co., Ltd." },
        { 0x486E73, "Pica8, Inc." },
        { 0x486EFB, "Davit System Technology Co., Ltd." },
        { 0x486FD2, "StorSimple Inc" },
        { 0x48701E, "Texas Instruments" },
        { 0x487119, "SGB GROUP LTD." },
        { 0x48746E, "Apple, Inc." },
        { 0x487583, "Intellion AG" },
        { 0x487604, "Private" },
        { 0x487746, "Calix Inc." },
        { 0x48794D, "Samsung Electronics Co.,Ltd" },
        { 0x487A55, "ALE International" },
        { 0x487ADA, "Hangzhou H3C Technologies Co., Limited" },
        { 0x487AF6, "NCS ELECTRICAL SDN BHD" },
        { 0x487AFF, "ESSYS" },
        { 0x487B5E, "SMT TELECOMM HK" },
        { 0x487B6B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x487D2E, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x488244, "Life Fitness / Div. of Brunswick" },
        { 0x4882F2, "Appel Elektronik GmbH" },
        { 0x4883B4, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x4883C7, "Sagemcom Broadband SAS" },
        { 0x4886E8, "Microsoft Corporation" },
        { 0x48872D, "SHEN ZHEN DA XIA LONG QUE TECHNOLOGY CO.,LTD" },
        { 0x488764, "vivo Mobile Communication Co., Ltd." },
        { 0x488803, "ManTechnology Inc." },
        { 0x48881E, "EthoSwitch LLC" },
        { 0x4888CA, "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
        { 0x4889E7, "Intel Corporate" },
        { 0x488AD2, "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x488B0A, "Cisco Systems, Inc" },
        { 0x488D36, "Arcadyan Corporation" },
        { 0x488E42, "DIGALOG GmbH" },
        { 0x488EEF, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x488F5A, "Routerboard.com" },
        { 0x48902F, "LG Electronics (Mobile Communications)" },
        { 0x489153, "Weinmann Geräte für Medizin GmbH + Co. KG" },
        { 0x4891F6, "Shenzhen Reach software technology CO.,LTD" },
        { 0x489507, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x4898CA, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x489A42, "Technomate Ltd" },
        { 0x489BD5, "Extreme Networks, Inc." },
        { 0x489BE2, "SCI Innovations Ltd" },
        { 0x489D18, "Flashbay Limited" },
        { 0x489D24, "BlackBerry RTS" },
        { 0x489DD1, "Samsung Electronics Co.,Ltd" },
        { 0x48A0F8, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x48A195, "Apple, Inc." },
        { 0x48A22D, "Shenzhen Huaxuchang Telecom Technology Co.,Ltd" },
        { 0x48A2B7, "Kodofon JSC" },
        { 0x48A2B8, "Chengdu Vision-Zenith Tech.Co,.Ltd" },
        { 0x48A2E6, "Resideo" },
        { 0x48A380, "Gionee Communication Equipment Co.,Ltd." },
        { 0x48A472, "Intel Corporate" },
        { 0x48A493, "TAIYO YUDEN CO.,LTD" },
        { 0x48A516, "Huawei Device Co., Ltd." },
        { 0x48A5E7, "Nintendo Co.,Ltd" },
        { 0x48A6B8, "Sonos, Inc." },
        { 0x48A6D2, "GJsun Optical Science and Tech Co.,Ltd." },
        { 0x48A73C, "Sichuan tianyi kanghe communications co., LTD" },
        { 0x48A74E, "zte corporation" },
        { 0x48A91C, "Apple, Inc." },
        { 0x48A9D2, "Wistron Neweb Corporation" },
        { 0x48AA5D, "Store Electronic Systems" },
        { 0x48AD08, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x48B02D, "NVIDIA Corporation" },
        { 0x48B253, "Marketaxess Corporation" },
        { 0x48B5A7, "Glory Horse Industries Ltd." },
        { 0x48B620, "ROLI Ltd." },
        { 0x48B8A3, "Apple, Inc." },
        { 0x48B8DE, "HOMEWINS TECHNOLOGY CO.,LTD." },
        { 0x48B977, "PulseOn Oy" },
        { 0x48B9C2, "Teletics Inc." },
        { 0x48BA4E, "Hewlett Packard" },
        { 0x48BCA6, "​ASUNG TECHNO CO.,Ltd" },
        { 0x48BD0E, "Quanta Storage Inc." },
        { 0x48BD3D, "New H3C Technologies Co., Ltd" },
        { 0x48BE2D, "Symanitron" },
        { 0x48BF6B, "Apple, Inc." },
        { 0x48BF74, "Baicells Technologies Co.,LTD" },
        { 0x48C049, "Broad Telecom SA" },
        { 0x48C093, "Xirrus, Inc." },
        { 0x48C1AC, "PLANTRONICS, INC." },
        { 0x48C3B0, "Pharos Co.Ltd" },
        { 0x48C58D, "Lear Corporation GmbH" },
        { 0x48C663, "GTO Access Systems LLC" },
        { 0x48C796, "Samsung Electronics Co.,Ltd" },
        { 0x48C862, "Simo Wireless,Inc." },
        { 0x48C8B6, "SysTec GmbH" },
        { 0x48CB6E, "Cello Electronics (UK) Ltd" },
        { 0x48D0CF, "Universal Electronics, Inc." },
        { 0x48D18E, "Metis Communication Co.,Ltd" },
        { 0x48D224, "Liteon Technology Corporation" },
        { 0x48D24F, "Sagemcom Broadband SAS" },
        { 0x48D343, "ARRIS Group, Inc." },
        { 0x48D35D, "Private" },
        { 0x48D539, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x48D54C, "Jeda Networks" },
        { 0x48D6D5, "Google, Inc." },
        { 0x48D705, "Apple, Inc." },
        { 0x48D7FF, "BLANKOM Antennentechnik GmbH" },
        { 0x48D845, "Shenzhen Mainuoke Electronics Co., Ltd" },
        { 0x48D855, "Telvent" },
        { 0x48D875, "China TransInfo Technology Co., Ltd" },
        { 0x48D890, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x48D8FE, "ClarIDy Solutions, Inc." },
        { 0x48DA96, "Eddy Smart Home Solutions Inc." },
        { 0x48DB50, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x48DC2D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x48DCFB, "Nokia Corporation" },
        { 0x48DD0C, "eero inc." },
        { 0x48DD9D, "ITEL MOBILE LIMITED" },
        { 0x48DF1C, "Wuhan NEC Fibre Optic Communications industry Co. Ltd" },
        { 0x48DF37, "Hewlett Packard Enterprise" },
        { 0x48E1AF, "Vity" },
        { 0x48E1E9, "Chengdu Meross Technology Co., Ltd." },
        { 0x48E244, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x48E3C3, "JENOPTIK Advanced Systems GmbH" },
        { 0x48E695, "Insigma Inc" },
        { 0x48E6C0, "SIMCom Wireless Solutions Co.,Ltd." },
        { 0x48E9F1, "Apple, Inc." },
        { 0x48EA63, "Zhejiang Uniview Technologies Co., Ltd." },
        { 0x48EB30, "ETERNA TECHNOLOGY, INC." },
        { 0x48EB62, "Murata Manufacturing Co., Ltd." },
        { 0x48EC5B, "Nokia" },
        { 0x48ED80, "daesung eltec" },
        { 0x48EE07, "Silver Palm Technologies LLC" },
        { 0x48EE0C, "D-Link International" },
        { 0x48EE86, "UTStarcom (China) Co.,Ltd" },
        { 0x48EF61, "Huawei Device Co., Ltd." },
        { 0x48F027, "Chengdu newifi Co.,Ltd" },
        { 0x48F07B, "ALPS ELECTRIC CO., LTD." },
        { 0x48F17F, "Intel Corporate" },
        { 0x48F230, "Ubizcore Co.,LTD" },
        { 0x48F317, "Private" },
        { 0x48F47D, "TechVision Holding Internation Limited" },
        { 0x48F7C0, "Technicolor CH USA Inc." },
        { 0x48F7F1, "Nokia" },
        { 0x48F8B3, "Cisco-Linksys, LLC" },
        { 0x48F8DB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x48F8E1, "Nokia" },
        { 0x48F925, "Maestronic" },
        { 0x48F97C, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x48FCB6, "LAVA INTERNATIONAL(H.K) LIMITED" },
        { 0x48FCB8, "Woodstream Corporation" },
        { 0x48FD8E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x48FDA3, "Xiaomi Communications Co Ltd" },
        { 0x48FEEA, "HOMA B.V." },
        { 0x4C0082, "Cisco Systems, Inc" },
        { 0x4C0143, "eero inc." },
        { 0x4C0220, "Xiaomi Communications Co Ltd" },
        { 0x4C022E, "CMR KOREA CO., LTD" },
        { 0x4C0289, "LEX COMPUTECH CO., LTD" },
        { 0x4C068A, "Basler Electric Company" },
        { 0x4C07C9, "COMPUTER OFFICE Co.,Ltd." },
        { 0x4C09B4, "zte corporation" },
        { 0x4C09D4, "Arcadyan Technology Corporation" },
        { 0x4C0A3D, "ADNACOM INC." },
        { 0x4C0B3A, "TCT mobile ltd" },
        { 0x4C0BBE, "Microsoft" },
        { 0x4C0DEE, "JABIL CIRCUIT (SHANGHAI) LTD." },
        { 0x4C0F6E, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x4C0FC7, "Earda Technologies co Ltd" },
        { 0x4C1159, "Vision Information & Communications" },
        { 0x4C11AE, "Espressif Inc." },
        { 0x4C11BF, "Zhejiang Dahua Technology Co., Ltd." },
        { 0x4C1265, "ARRIS Group, Inc." },
        { 0x4C1365, "Emplus Technologies" },
        { 0x4C1480, "NOREGON SYSTEMS, INC" },
        { 0x4C14A3, "TCL Technoly Electronics (Huizhou) Co., Ltd." },
        { 0x4C1694, "shenzhen sibituo Technology Co., Ltd" },
        { 0x4C16F1, "zte corporation" },
        { 0x4C16FC, "Juniper Networks" },
        { 0x4C1744, "Amazon Technologies Inc." },
        { 0x4C17EB, "Sagemcom Broadband SAS" },
        { 0x4C189A, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x4C1A3A, "PRIMA Research And Production Enterprise Ltd." },
        { 0x4C1A3D, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x4C1A95, "Novakon Co., Ltd." },
        { 0x4C1B86, "Arcadyan Corporation" },
        { 0x4C1D96, "Intel Corporate" },
        { 0x4C1FCC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4C20B8, "Apple, Inc." },
        { 0x4C2113, "Nokia Shanghai Bell Co., Ltd." },
        { 0x4C218C, "Panasonic India Private limited" },
        { 0x4C21D0, "Sony Mobile Communications Inc" },
        { 0x4C2219, "YUANFUDAO HK LIMTED" },
        { 0x4C2258, "cozybit, Inc." },
        { 0x4C2498, "Texas Instruments" },
        { 0x4C2578, "Nokia Corporation" },
        { 0x4C26E7, "Welgate Co., Ltd." },
        { 0x4C2C80, "Beijing Skyway Technologies Co.,Ltd" },
        { 0x4C2C83, "Zhejiang KaNong Network Technology Co.,Ltd." },
        { 0x4C2EFE, "Shenzhen Comnect Technology Co.,LTD" },
        { 0x4C2F9D, "ICM Controls" },
        { 0x4C3089, "Thales Transportation Systems GmbH" },
        { 0x4C322D, "TELEDATA NETWORKS" },
        { 0x4C3275, "Apple, Inc." },
        { 0x4C32D9, "M Rutty Holdings Pty. Ltd." },
        { 0x4C3329, "Sweroam" },
        { 0x4C334E, "HIGHTECH" },
        { 0x4C3488, "Intel Corporate" },
        { 0x4C364E, "Panasonic Corporation Connected Solutions Company" },
        { 0x4C38D5, "MITAC COMPUTING TECHNOLOGY CORPORATION" },
        { 0x4C38D8, "ARRIS Group, Inc." },
        { 0x4C3909, "HPL Electric & Power Private Limited" },
        { 0x4C3910, "Newtek Electronics co., Ltd." },
        { 0x4C3B74, "VOGTEC(H.K.) Co., Ltd" },
        { 0x4C3BDF, "Microsoft Corporation" },
        { 0x4C3C16, "Samsung Electronics Co.,Ltd" },
        { 0x4C3FD3, "Texas Instruments" },
        { 0x4C4088, "SANSHIN ELECTRONICS CO.,LTD." },
        { 0x4C4576, "China Mobile(Hangzhou) Information Technology Co.,Ltd." },
        { 0x4C48DA, "Beijing Autelan Technology Co.,Ltd" },
        { 0x4C494F, "zte corporation" },
        { 0x4C49E3, "Xiaomi Communications Co Ltd" },
        { 0x4C4B68, "Mobile Device, Inc." },
        { 0x4C4BF9, "IEEE Registration Authority" },
        { 0x4C4D66, "Nanjing Jiahao Technology Co., Ltd." },
        { 0x4C4E03, "TCT mobile ltd" },
        { 0x4C4E35, "Cisco Systems, Inc" },
        { 0x4C4FEE, "OnePlus Technology (Shenzhen) Co., Ltd" },
        { 0x4C5077, "Huawei Device Co., Ltd." },
        { 0x4C5262, "Fujitsu Technology Solutions GmbH" },
        { 0x4C52EC, "SOLARWATT GmbH" },
        { 0x4C5427, "Linepro Sp. z o.o." },
        { 0x4C5499, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4C5585, "Hamilton Systems" },
        { 0x4C55B8, "Turkcell Teknoloji" },
        { 0x4C55CC, "Zentri Pty Ltd" },
        { 0x4C569D, "Apple, Inc." },
        { 0x4C56DF, "Targus US LLC" },
        { 0x4C57CA, "Apple, Inc." },
        { 0x4C5DCD, "Oy Finnish Electric Vehicle Technologies Ltd" },
        { 0x4C5E0C, "Routerboard.com" },
        { 0x4C5FD2, "Alcatel-Lucent" },
        { 0x4C60D5, "airPointe of New Hampshire" },
        { 0x4C60DE, "NETGEAR" },
        { 0x4C6255, "SANMINA-SCI SYSTEM DE MEXICO S.A. DE C.V." },
        { 0x4C6371, "Xiaomi Communications Co Ltd" },
        { 0x4C63EB, "Application Solutions (Electronics and Vision) Ltd" },
        { 0x4C64D9, "Guangdong Leawin Group Co., Ltd" },
        { 0x4C65A8, "IEEE Registration Authority" },
        { 0x4C6641, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x4C6AF6, "HMD Global Oy" },
        { 0x4C6BE8, "Apple, Inc." },
        { 0x4C6C13, "IoT Company Solucoes Tecnologicas Ltda" },
        { 0x4C6D58, "Juniper Networks" },
        { 0x4C6E6E, "Comnect Technology CO.,LTD" },
        { 0x4C6F9C, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x4C710C, "Cisco Systems, Inc" },
        { 0x4C710D, "Cisco Systems, Inc" },
        { 0x4C72B9, "PEGATRON CORPORATION" },
        { 0x4C7367, "Genius Bytes Software Solutions GmbH" },
        { 0x4C73A5, "KOVE" },
        { 0x4C7403, "BQ" },
        { 0x4C7487, "Leader Phone Communication Technology Co., Ltd." },
        { 0x4C74BF, "Apple, Inc." },
        { 0x4C7625, "Dell Inc." },
        { 0x4C774F, "Embedded Wireless Labs" },
        { 0x4C776D, "Cisco Systems, Inc" },
        { 0x4C7872, "Cav. Uff. Giacomo Cimberio S.p.A." },
        { 0x4C7897, "Arrowhead Alarm Products Ltd" },
        { 0x4C79BA, "Intel Corporate" },
        { 0x4C7A48, "Nippon Seiki (Europe) B.V." },
        { 0x4C7C5F, "Apple, Inc." },
        { 0x4C7CD9, "Apple, Inc." },
        { 0x4C7F62, "Nokia Corporation" },
        { 0x4C804F, "Armstrong Monitoring Corp" },
        { 0x4C8093, "Intel Corporate" },
        { 0x4C80BA, "Wuhan Tianyu Information Industry Co., Ltd." },
        { 0x4C8120, "Taicang T&W Electronics" },
        { 0x4C82CF, "Dish Technologies Corp" },
        { 0x4C83DE, "Cisco SPVTG" },
        { 0x4C875D, "Bose Corporation" },
        { 0x4C8B30, "Actiontec Electronics, Inc" },
        { 0x4C8B55, "Grupo Digicon" },
        { 0x4C8BEF, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4C8D79, "Apple, Inc." },
        { 0x4C8ECC, "SILKAN SA" },
        { 0x4C8FA5, "Jastec" },
        { 0x4C90DB, "JL Audio" },
        { 0x4C910C, "Lanix Internacional, S.A. de C.V." },
        { 0x4C9157, "Fujian LANDI Commercial Equipment Co.,Ltd" },
        { 0x4C917A, "IEEE Registration Authority" },
        { 0x4C93A6, "IEEE Registration Authority" },
        { 0x4C9614, "Juniper Networks" },
        { 0x4C962D, "Fresh AB" },
        { 0x4C98EF, "Zeo" },
        { 0x4C9E80, "KYOKKO ELECTRIC Co., Ltd." },
        { 0x4C9EE4, "Hanyang Navicom Co.,Ltd." },
        { 0x4C9EFF, "Zyxel Communications Corporation" },
        { 0x4CA003, "VITEC" },
        { 0x4CA161, "Rain Bird Corporation" },
        { 0x4CA515, "Baikal Electronics JSC" },
        { 0x4CA56D, "Samsung Electronics Co.,Ltd" },
        { 0x4CA64D, "Cisco Systems, Inc" },
        { 0x4CA74B, "Alcatel Lucent" },
        { 0x4CA928, "Insensi" },
        { 0x4CAA16, "AzureWave Technologies (Shanghai) Inc." },
        { 0x4CAB33, "KST technology" },
        { 0x4CABFC, "zte corporation" },
        { 0x4CAC0A, "zte corporation" },
        { 0x4CADA8, "PANOPTICS CORP." },
        { 0x4CAE13, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4CAE1C, "SaiNXT Technologies LLP" },
        { 0x4CAE31, "ShengHai Electronics (Shenzhen) Ltd" },
        { 0x4CAEA3, "Hewlett Packard Enterprise" },
        { 0x4CAEEC, "Guangzhou limee technology co.,LTD" },
        { 0x4CB008, "Shenzhen Gwelltimes Technology Co.,Ltd" },
        { 0x4CB0E8, "Beijing RongZhi xinghua technology co., LTD" },
        { 0x4CB16C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4CB199, "Apple, Inc." },
        { 0x4CB1CD, "Ruckus Wireless" },
        { 0x4CB21C, "Maxphotonics Co.,Ltd" },
        { 0x4CB44A, "NANOWAVE Technologies Inc." },
        { 0x4CB4EA, "HRD (S) PTE., LTD." },
        { 0x4CB76D, "Novi Security" },
        { 0x4CB81C, "SAM Electronics GmbH" },
        { 0x4CB82C, "Cambridge Mobile Telematics, Inc." },
        { 0x4CB8B5, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x4CB911, "Raisecom Technology CO.,LTD" },
        { 0x4CB99B, "WEIFANG GOERTEK ELECTRONICS CO.,LTD" },
        { 0x4CB9C8, "CONET CO., LTD." },
        { 0x4CBAA3, "Bison Electronics Inc." },
        { 0x4CBB58, "Chicony Electronics Co., Ltd." },
        { 0x4CBC42, "Shenzhen Hangsheng Electronics Co.,Ltd." },
        { 0x4CBC48, "Cisco Systems, Inc" },
        { 0x4CBC72, "Primex Wireless" },
        { 0x4CBC98, "IEEE Registration Authority" },
        { 0x4CBCA5, "Samsung Electronics Co.,Ltd" },
        { 0x4CBCB4, "ABB SpA - DIN Rail" },
        { 0x4CBD8F, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x4CC00A, "vivo Mobile Communication Co., Ltd." },
        { 0x4CC206, "Somfy" },
        { 0x4CC452, "Shang Hai Tyd. Electon Technology Ltd." },
        { 0x4CC53E, "Zyxel Communications Corporation" },
        { 0x4CC602, "Radios, Inc." },
        { 0x4CC681, "Shenzhen Aisat Electronic Co., Ltd." },
        { 0x4CC7D6, "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.,LTD." },
        { 0x4CC8A1, "Cisco Meraki" },
        { 0x4CC94F, "Nokia" },
        { 0x4CC95E, "Samsung Electronics Co.,Ltd" },
        { 0x4CCA53, "Skyera, Inc." },
        { 0x4CCBF5, "zte corporation" },
        { 0x4CCC34, "Motorola Solutions Inc." },
        { 0x4CCC6A, "Micro-Star INTL CO., LTD." },
        { 0x4CCE2D, "Danlaw Inc" },
        { 0x4CD08A, "HUMAX Co., Ltd." },
        { 0x4CD0CB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4CD1A1, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4CD637, "Qsono Electronics Co., Ltd" },
        { 0x4CD7B6, "Helmer Scientific" },
        { 0x4CD98F, "Dell Inc." },
        { 0x4CD9C4, "Magneti Marelli Automotive Electronics (Guangzhou) Co. Ltd" },
        { 0x4CDC0D, "Coral Telecom Limited" },
        { 0x4CDD31, "Samsung Electronics Co.,Ltd" },
        { 0x4CDD7D, "LHP Telematics LLC" },
        { 0x4CDF3D, "TEAM ENGINEERS ADVANCE TECHNOLOGIES INDIA PVT LTD" },
        { 0x4CE173, "IEEE Registration Authority" },
        { 0x4CE175, "Cisco Systems, Inc" },
        { 0x4CE176, "Cisco Systems, Inc" },
        { 0x4CE19E, "TECNO MOBILE LIMITED" },
        { 0x4CE1BB, "Zhuhai HiFocus Technology Co., Ltd." },
        { 0x4CE2F1, "sclak srl" },
        { 0x4CE5AE, "Tianjin Beebox Intelligent Technology Co.,Ltd." },
        { 0x4CE676, "BUFFALO.INC" },
        { 0x4CE933, "RailComm, LLC" },
        { 0x4CE9E4, "New H3C Technologies Co., Ltd" },
        { 0x4CEB42, "Intel Corporate" },
        { 0x4CEBBD, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x4CECEF, "Soraa, Inc." },
        { 0x4CEDDE, "ASKEY COMPUTER CORP" },
        { 0x4CEDFB, "ASUSTek COMPUTER INC." },
        { 0x4CEEB0, "SHC Netzwerktechnik GmbH" },
        { 0x4CEF56, "Shenzhen Sundray Technologies Company Limited" },
        { 0x4CEFC0, "Amazon Technologies Inc." },
        { 0x4CF02E, "Vifa Denmark A/S" },
        { 0x4CF19E, "Groupe Atlantic" },
        { 0x4CF2BF, "Cambridge Industries(Group) Co.,Ltd." },
        { 0x4CF45B, "Blue Clover Devices" },
        { 0x4CF55B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4CF5A0, "Scalable Network Technologies Inc" },
        { 0x4CF737, "SamJi Electronics Co., Ltd" },
        { 0x4CF95D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4CFACA, "Cambridge Industries(Group) Co.,Ltd." },
        { 0x4CFB45, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x4CFBF4, "Optimal Audio Ltd" },
        { 0x4CFBFE, "Sercomm Japan Corporation" },
        { 0x4CFCAA, "Tesla,Inc." },
        { 0x4CFF12, "Fuze Entertainment Co., ltd" },
        { 0x500084, "Siemens Canada" },
        { 0x50008C, "Hong Kong Telecommunications (HKT) Limited" },
        { 0x50016B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5001BB, "Samsung Electronics Co.,Ltd" },
        { 0x5001D9, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x500291, "Espressif Inc." },
        { 0x5004B8, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x50053D, "CyWee Group Ltd" },
        { 0x500604, "Cisco Systems, Inc" },
        { 0x5006AB, "Cisco Systems, Inc" },
        { 0x500959, "Technicolor CH USA Inc." },
        { 0x500B32, "Foxda Technology Industrial(ShenZhen)Co.,LTD" },
        { 0x500B91, "IEEE Registration Authority" },
        { 0x500E6D, "TrafficCast International" },
        { 0x500F80, "Cisco Systems, Inc" },
        { 0x500FF5, "Tenda Technology Co.,Ltd.Dongguan branch" },
        { 0x5011EB, "SilverNet Ltd" },
        { 0x501395, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x501408, "AiNET" },
        { 0x501479, "iRobot Corporation" },
        { 0x5014B5, "Richfit Information Technology Co., Ltd" },
        { 0x5017FF, "Cisco Systems, Inc" },
        { 0x50184C, "Platina Systems Inc." },
        { 0x501AA5, "GN Netcom A/S" },
        { 0x501AC5, "Microsoft" },
        { 0x501B32, "Taicang T&W Electronics" },
        { 0x501CB0, "Cisco Systems, Inc" },
        { 0x501CBF, "Cisco Systems, Inc" },
        { 0x501D93, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x501E2D, "StreamUnlimited Engineering GmbH" },
        { 0x50206B, "Emerson Climate Technologies Transportation Solutions" },
        { 0x5021EC, "Huawei Device Co., Ltd." },
        { 0x502267, "PixeLINK" },
        { 0x50252B, "Nethra Imaging Incorporated" },
        { 0x502690, "FUJITSU LIMITED" },
        { 0x5027C7, "TECHNART Co.,Ltd" },
        { 0x502873, "Huawei Device Co., Ltd." },
        { 0x50294D, "NANJING IOT SENSOR TECHNOLOGY CO,LTD" },
        { 0x5029F5, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x502A7E, "Smart electronic GmbH" },
        { 0x502A8B, "Telekom Research and Development Sdn Bhd" },
        { 0x502B73, "Tenda Technology Co.,Ltd.Dongguan branch" },
        { 0x502B98, "Es-tech International" },
        { 0x502CC6, "GREE ELECTRIC APPLIANCES, INC. OF ZHUHAI" },
        { 0x502D1D, "Nokia Corporation" },
        { 0x502DA2, "Intel Corporate" },
        { 0x502DBB, "GD Midea Air-Conditioning Equipment Co.,Ltd." },
        { 0x502DF4, "Phytec Messtechnik GmbH" },
        { 0x502E5C, "HTC Corporation" },
        { 0x502ECE, "Asahi Electronics Co.,Ltd" },
        { 0x502F9B, "Intel Corporate" },
        { 0x502FA8, "Cisco Systems, Inc" },
        { 0x5031AD, "ABB Global Industries and Services Private Limited" },
        { 0x503237, "Apple, Inc." },
        { 0x503275, "Samsung Electronics Co.,Ltd" },
        { 0x50338B, "Texas Instruments" },
        { 0x5033F0, "YICHEN (SHENZHEN) TECHNOLOGY CO.LTD" },
        { 0x50382F, "ASE Group Chung-Li" },
        { 0x503955, "Cisco SPVTG" },
        { 0x503A7D, "AlphaTech PLC Int’l Co., Ltd." },
        { 0x503AA0, "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x503CC4, "Lenovo Mobile Communication Technology Ltd." },
        { 0x503CEA, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x503DA1, "Samsung Electronics Co.,Ltd" },
        { 0x503DE5, "Cisco Systems, Inc" },
        { 0x503E7C, "LeiShen Intelligent System Co.Ltd" },
        { 0x503EAA, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x503F56, "Syncmold Enterprise Corp" },
        { 0x503F98, "CMITECH" },
        { 0x504061, "Nokia" },
        { 0x5041B9, "I-O DATA DEVICE,INC." },
        { 0x5043B9, "OktoInform RUS" },
        { 0x5045F7, "Liuhe Intelligence Technology Ltd." },
        { 0x50464A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x50465D, "ASUSTek COMPUTER INC." },
        { 0x5048EB, "BEIJING HAIHEJINSHENG NETWORK TECHNOLOGY CO. LTD." },
        { 0x504A5E, "Masimo Corporation" },
        { 0x504A6E, "NETGEAR" },
        { 0x504B5B, "CONTROLtronic GmbH" },
        { 0x504C7E, "THE 41ST INSTITUTE OF CETC" },
        { 0x504EDC, "Ping Communication" },
        { 0x504F94, "Loxone Electronics GmbH" },
        { 0x50502A, "Egardia" },
        { 0x505065, "TAKT Corporation" },
        { 0x5050A4, "Samsung Electronics Co.,Ltd" },
        { 0x5050CE, "Hangzhou Dianyixia Communication Technology Co. Ltd." },
        { 0x5051A9, "Texas Instruments" },
        { 0x5052D2, "Hangzhou Telin Technologies Co., Limited" },
        { 0x505527, "LG Electronics (Mobile Communications)" },
        { 0x505663, "Texas Instruments" },
        { 0x5056A8, "Jolla Ltd" },
        { 0x5056BF, "Samsung Electronics Co.,Ltd" },
        { 0x50579C, "Seiko Epson Corporation" },
        { 0x5057A8, "Cisco Systems, Inc" },
        { 0x505800, "WyTec International, Inc." },
        { 0x50584F, "waytotec,Inc." },
        { 0x505967, "Intent Solutions Inc" },
        { 0x505AC6, "GUANGDONG SUPER TELECOM CO.,LTD." },
        { 0x505BC2, "Liteon Technology Corporation" },
        { 0x505DAC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x505FB5, "Askey Computer Corp." },
        { 0x506028, "Xirrus Inc." },
        { 0x506184, "Avaya Inc" },
        { 0x5061BF, "Cisco Systems, Inc" },
        { 0x5061D6, "Indu-Sol GmbH" },
        { 0x5061F6, "Universal Electronics, Inc." },
        { 0x506255, "IEEE Registration Authority" },
        { 0x506313, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x50642B, "XIAOMI Electronics,CO.,LTD" },
        { 0x506441, "Greenlee" },
        { 0x506583, "Texas Instruments" },
        { 0x5065F3, "Hewlett Packard" },
        { 0x506787, "Planet Networks" },
        { 0x5067AE, "Cisco Systems, Inc" },
        { 0x5067F0, "Zyxel Communications Corporation" },
        { 0x50680A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x506A03, "NETGEAR" },
        { 0x506B4B, "Mellanox Technologies, Inc." },
        { 0x506B8D, "Nutanix" },
        { 0x506CBE, "InnosiliconTechnology Ltd" },
        { 0x506E92, "Innocent Technology Co., Ltd." },
        { 0x506F77, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x506F98, "Sehaj Synergy Technologies Private Limited" },
        { 0x506F9A, "Wi-Fi Alliance" },
        { 0x507043, "BSkyB Ltd" },
        { 0x5070E5, "He Shan World Fair Electronics Technology Limited" },
        { 0x507224, "Texas Instruments" },
        { 0x50724D, "BEG Brueck Electronic GmbH" },
        { 0x5075F1, "ARRIS Group, Inc." },
        { 0x507691, "Tekpea, Inc." },
        { 0x5076A6, "Ecil Informatica Ind. Com. Ltda" },
        { 0x5076AF, "Intel Corporate" },
        { 0x507705, "Samsung Electronics Co.,Ltd" },
        { 0x5078B3, "zte corporation" },
        { 0x50795B, "Interexport Telecomunicaciones S.A." },
        { 0x507A55, "Apple, Inc." },
        { 0x507AC5, "Apple, Inc." },
        { 0x507B9D, "LCFC(HeFei) Electronics Technology co., ltd" },
        { 0x507D02, "BIODIT" },
        { 0x507E5D, "Arcadyan Technology Corporation" },
        { 0x50804A, "Quectel Wireless Solutions Co., Ltd." },
        { 0x5082D5, "Apple, Inc." },
        { 0x508569, "Samsung Electronics Co.,Ltd" },
        { 0x508789, "Cisco Systems, Inc" },
        { 0x5087B8, "Nuvyyo Inc" },
        { 0x508965, "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x508A0F, "SHENZHEN FISE TECHNOLOGY HOLDING CO.,LTD." },
        { 0x508A42, "Uptmate Technology Co., LTD" },
        { 0x508ACB, "SHENZHEN MAXMADE TECHNOLOGY CO., LTD." },
        { 0x508C77, "DIRMEIER Schanktechnik GmbH &Co KG" },
        { 0x508CB1, "Texas Instruments" },
        { 0x508CF5, "China Mobile Group Device Co.,Ltd." },
        { 0x508D6F, "CHAHOO Limited" },
        { 0x508E49, "Xiaomi Communications Co Ltd" },
        { 0x508F4C, "Xiaomi Communications Co Ltd" },
        { 0x5092B9, "Samsung Electronics Co.,Ltd" },
        { 0x50934F, "Gradual Tecnologia Ltda." },
        { 0x509551, "ARRIS Group, Inc." },
        { 0x509744, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x509772, "Westinghouse Digital" },
        { 0x509871, "Inventum Technologies Private Limited" },
        { 0x5098B8, "New H3C Technologies Co., Ltd" },
        { 0x5098F3, "Rheem Australia Pty Ltd" },
        { 0x509A4C, "Dell Inc." },
        { 0x509EA7, "Samsung Electronics Co.,Ltd" },
        { 0x509F27, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x509F3B, "OI ELECTRIC CO.,LTD" },
        { 0x50A009, "Xiaomi Communications Co Ltd" },
        { 0x50A054, "Actineon" },
        { 0x50A0A4, "Nokia" },
        { 0x50A0BF, "Alba Fiber Systems Inc." },
        { 0x50A132, "Shenzhen MiaoMing Intelligent Technology Co.,Ltd" },
        { 0x50A4C8, "Samsung Electronics Co.,Ltd" },
        { 0x50A4D0, "IEEE Registration Authority" },
        { 0x50A5DC, "ARRIS Group, Inc." },
        { 0x50A67F, "Apple, Inc." },
        { 0x50A6E3, "David Clark Company" },
        { 0x50A715, "Aboundi, Inc." },
        { 0x50A72B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x50A733, "Ruckus Wireless" },
        { 0x50A83A, "S Mobile Devices Limited" },
        { 0x50A9DE, "Smartcom - Bulgaria AD" },
        { 0x50AB3E, "Qibixx AG" },
        { 0x50ABBF, "Hoseo Telecom" },
        { 0x50AD71, "Tessolve Semiconductor Private Limited" },
        { 0x50AD92, "NX Technologies" },
        { 0x50ADD5, "Dynalec Corporation" },
        { 0x50AF4D, "zte corporation" },
        { 0x50AF73, "Shenzhen Bitland Information Technology Co., Ltd." },
        { 0x50B363, "Digitron da Amazonia S/A" },
        { 0x50B695, "Micropoint Biotechnologies,Inc." },
        { 0x50B7C3, "Samsung Electronics Co.,Ltd" },
        { 0x50B888, "wi2be Tecnologia S/A" },
        { 0x50B8A2, "ImTech Technologies LLC," },
        { 0x50BC96, "Apple, Inc." },
        { 0x50BD5F, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x50C006, "Carmanah Signs" },
        { 0x50C271, "SECURETECH INC" },
        { 0x50C4DD, "BUFFALO.INC" },
        { 0x50C58D, "Juniper Networks" },
        { 0x50C68E, "Biwin Semiconductor (HK) Company Limted" },
        { 0x50C6AD, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x50C709, "Juniper Networks" },
        { 0x50C7BF, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x50C8E5, "Samsung Electronics Co.,Ltd" },
        { 0x50C971, "GN Netcom A/S" },
        { 0x50C9A0, "SKIPPER AS" },
        { 0x50CCF8, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x50CD22, "Avaya Inc" },
        { 0x50CD32, "NanJing Chaoran Science & Technology Co.,Ltd." },
        { 0x50CE75, "Measy Electronics Co., Ltd." },
        { 0x50CEE3, "Gigafirm.co.LTD" },
        { 0x50D213, "CviLux Corporation" },
        { 0x50D274, "Steffes Corporation" },
        { 0x50D2F5, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x50D37F, "Yu Fly Mikly Way Science and Technology Co., Ltd." },
        { 0x50D4F7, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x50D59C, "Thai Habel Industrial Co., Ltd." },
        { 0x50D6D7, "Takahata Precision" },
        { 0x50D753, "CONELCOM GmbH" },
        { 0x50DA00, "Hangzhou H3C Technologies Co., Limited" },
        { 0x50DB3F, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x50DCE7, "Amazon Technologies Inc." },
        { 0x50DCFC, "ECOCOM" },
        { 0x50DD4F, "Automation Components, Inc" },
        { 0x50DE06, "Apple, Inc." },
        { 0x50DF95, "Lytx" },
        { 0x50E039, "Zyxel Communications Corporation" },
        { 0x50E085, "Intel Corporate" },
        { 0x50E0C7, "TurControlSystme AG" },
        { 0x50E0EF, "Nokia" },
        { 0x50E14A, "Private" },
        { 0x50E549, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x50E666, "Shenzhen Techtion Electronics Co., Ltd." },
        { 0x50E971, "Jibo, Inc." },
        { 0x50EAD6, "Apple, Inc." },
        { 0x50EB1A, "Brocade Communications Systems LLC" },
        { 0x50EB71, "Intel Corporate" },
        { 0x50EC50, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x50ED78, "Changzhou Yongse Infotech Co.,Ltd" },
        { 0x50ED94, "EGATEL SL" },
        { 0x50F003, "Open Stack, Inc." },
        { 0x50F0D3, "Samsung Electronics Co.,Ltd" },
        { 0x50F14A, "Texas Instruments" },
        { 0x50F43C, "Leeo Inc" },
        { 0x50F520, "Samsung Electronics Co.,Ltd" },
        { 0x50F5DA, "Amazon Technologies Inc." },
        { 0x50F61A, "Kunshan JADE Technologies co., Ltd." },
        { 0x50F722, "Cisco Systems, Inc" },
        { 0x50F7ED, "Huawei Device Co., Ltd." },
        { 0x50F8A5, "eWBM Co., Ltd." },
        { 0x50F958, "Huawei Device Co., Ltd." },
        { 0x50FA84, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x50FAAB, "L-tek d.o.o." },
        { 0x50FB19, "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP." },
        { 0x50FC30, "Treehouse Labs" },
        { 0x50FC9F, "Samsung Electronics Co.,Ltd" },
        { 0x50FEF2, "Sify Technologies Ltd" },
        { 0x50FF20, "Keenetic Limited" },
        { 0x50FF99, "IEEE Registration Authority" },
        { 0x540237, "Teltronic AG" },
        { 0x540384, "Hongkong Nano IC Technologies Co., Ltd" },
        { 0x5403F5, "EBN Technology Corp." },
        { 0x540496, "Gigawave LTD" },
        { 0x5404A6, "ASUSTek COMPUTER INC." },
        { 0x540536, "Vivago Oy" },
        { 0x54055F, "Alcatel Lucent" },
        { 0x540593, "WOORI ELEC Co.,Ltd" },
        { 0x5405DB, "LCFC(HeFei) Electronics Technology co., ltd" },
        { 0x54068B, "Ningbo Deli Kebei Technology Co.LTD" },
        { 0x540955, "zte corporation" },
        { 0x54098D, "deister electronic GmbH" },
        { 0x540DF9, "Huawei Device Co., Ltd." },
        { 0x540E2D, "vivo Mobile Communication Co., Ltd." },
        { 0x541031, "SMARTO" },
        { 0x5410EC, "Microchip Technology Inc." },
        { 0x54112F, "Sulzer Pump Solutions Finland Oy" },
        { 0x54115F, "Atamo Pty Ltd" },
        { 0x541310, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x541379, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x541473, "Wingtech Group (HongKong）Limited" },
        { 0x5414FD, "Orbbec 3D Technology International" },
        { 0x541589, "MCS Logic Inc." },
        { 0x5419C8, "vivo Mobile Communication Co., Ltd." },
        { 0x541B5D, "Techno-Innov" },
        { 0x541DFB, "Freestyle Energy Ltd" },
        { 0x541E56, "Juniper Networks" },
        { 0x541FD5, "Advantage Electronics" },
        { 0x542018, "Tely Labs" },
        { 0x542160, "Alula" },
        { 0x54219D, "Samsung Electronics Co.,Ltd" },
        { 0x5422F8, "zte corporation" },
        { 0x5425EA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x542696, "Apple, Inc." },
        { 0x54271E, "AzureWave Technology Inc." },
        { 0x542758, "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
        { 0x54276C, "Jiangsu Houge Technology Corp." },
        { 0x54278D, "NXP (China) Management Ltd." },
        { 0x542A1B, "Sonos, Inc." },
        { 0x542A9C, "LSY Defense, LLC." },
        { 0x542AA2, "Alpha Networks Inc." },
        { 0x542B57, "Night Owl SP" },
        { 0x542B8D, "Apple, Inc." },
        { 0x542BDE, "New H3C Technologies Co., Ltd" },
        { 0x542CEA, "PROTECTRON" },
        { 0x542F89, "Euclid Laboratories, Inc." },
        { 0x542F8A, "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO" },
        { 0x543131, "Raster Vision Ltd" },
        { 0x5433CB, "Apple, Inc." },
        { 0x5434EF, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x543530, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x5435DF, "Symeo GmbH" },
        { 0x54369B, "1Verge Internet Technology (Beijing) Co., Ltd." },
        { 0x543968, "Edgewater Networks Inc" },
        { 0x5439DF, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x543B30, "duagon AG" },
        { 0x543D37, "Ruckus Wireless" },
        { 0x543E64, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x5440AD, "Samsung Electronics Co.,Ltd" },
        { 0x544249, "Sony Corporation" },
        { 0x544408, "Nokia Corporation" },
        { 0x54466B, "Shenzhen CZTIC Electronic Technology Co., Ltd" },
        { 0x544741, "XCHENG HOLDING" },
        { 0x5447D3, "TSAT AS" },
        { 0x544810, "Dell Inc." },
        { 0x54489C, "CDOUBLES ELECTRONICS CO. LTD." },
        { 0x5448E6, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x544A00, "Cisco Systems, Inc" },
        { 0x544A05, "wenglor sensoric gmbh" },
        { 0x544A16, "Texas Instruments" },
        { 0x544B8C, "Juniper Networks" },
        { 0x544E45, "Private" },
        { 0x544E90, "Apple, Inc." },
        { 0x54511B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x545146, "AMG Systems Ltd." },
        { 0x5453ED, "Sony Corporation" },
        { 0x545414, "Digital RF Corea, Inc" },
        { 0x5454CF, "PROBEDIGITAL CO.,LTD" },
        { 0x5455D5, "Huawei Device Co., Ltd." },
        { 0x545AA6, "Espressif Inc." },
        { 0x545EBD, "NL Technologies" },
        { 0x545FA9, "Teracom Limited" },
        { 0x546009, "Google, Inc." },
        { 0x546172, "ZODIAC AEROSPACE SAS" },
        { 0x5461EA, "Zaplox AB" },
        { 0x5462E2, "Apple, Inc." },
        { 0x5464D9, "Sagemcom Broadband SAS" },
        { 0x546503, "Quectel Wireless Solutions Co., Ltd." },
        { 0x5465DE, "ARRIS Group, Inc." },
        { 0x54666C, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x546751, "Compal Broadband Networks, Inc." },
        { 0x546AD8, "Elster Water Metering" },
        { 0x546C0E, "Texas Instruments" },
        { 0x546D52, "TOPVIEW OPTRONICS CORP." },
        { 0x5471DD, "Huawei Device Co., Ltd." },
        { 0x54724F, "Apple, Inc." },
        { 0x547398, "Toyo Electronics Corporation" },
        { 0x5474E6, "Webtech Wireless" },
        { 0x547595, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x5475D0, "Cisco Systems, Inc" },
        { 0x54778A, "Hewlett Packard Enterprise" },
        { 0x54781A, "Cisco Systems, Inc" },
        { 0x547975, "Nokia Corporation" },
        { 0x547A52, "CTE International srl" },
        { 0x547C69, "Cisco Systems, Inc" },
        { 0x547DCD, "Texas Instruments" },
        { 0x547F54, "INGENICO" },
        { 0x547FA8, "TELCO systems, s.r.o." },
        { 0x547FBC, "iodyne" },
        { 0x547FEE, "Cisco Systems, Inc" },
        { 0x548028, "Hewlett Packard Enterprise" },
        { 0x54812D, "PAX Computer Technology(Shenzhen) Ltd." },
        { 0x5481AD, "Eagle Research Corporation" },
        { 0x54833A, "Zyxel Communications Corporation" },
        { 0x54847B, "Digital Devices GmbH" },
        { 0x5484DC, "zte corporation" },
        { 0x5486BC, "Cisco Systems, Inc" },
        { 0x54880E, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x5488DE, "Cisco Systems, Inc" },
        { 0x548922, "Zelfy Inc" },
        { 0x548998, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x548ABA, "Cisco Systems, Inc" },
        { 0x548CA0, "Liteon Technology Corporation" },
        { 0x548D5A, "Intel Corporate" },
        { 0x549209, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5492BE, "Samsung Electronics Co.,Ltd" },
        { 0x549359, "SHENZHEN TWOWING TECHNOLOGIES CO.,LTD." },
        { 0x549478, "Silvershore Technology Partners" },
        { 0x549963, "Apple, Inc." },
        { 0x549A11, "IEEE Registration Authority" },
        { 0x549A16, "Uzushio Electric Co.,Ltd." },
        { 0x549A4C, "GUANGDONG HOMECARE TECHNOLOGY CO.,LTD." },
        { 0x549B12, "Samsung Electronics Co.,Ltd" },
        { 0x549B72, "Ericsson AB" },
        { 0x549C27, "Plasma Cloud Limited" },
        { 0x549D85, "EnerAccess inc" },
        { 0x549F13, "Apple, Inc." },
        { 0x549F35, "Dell Inc." },
        { 0x549FAE, "iBASE Gaming Inc" },
        { 0x549FC6, "Cisco Systems, Inc" },
        { 0x54A04F, "t-mac Technologies Ltd" },
        { 0x54A050, "ASUSTek COMPUTER INC." },
        { 0x54A274, "Cisco Systems, Inc" },
        { 0x54A31B, "Shenzhen Linkworld Technology Co,.LTD" },
        { 0x54A3FA, "BQT Solutions (Australia)Pty Ltd" },
        { 0x54A493, "IEEE Registration Authority" },
        { 0x54A51B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x54A54B, "NSC Communications Siberia Ltd" },
        { 0x54A619, "Alcatel-Lucent Shanghai Bell Co., Ltd" },
        { 0x54A65C, "Technicolor CH USA Inc." },
        { 0x54A703, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x54A9D4, "Minibar Systems" },
        { 0x54AB3A, "Quanta Computer Inc." },
        { 0x54AE27, "Apple, Inc." },
        { 0x54AED0, "DASAN Networks, Inc." },
        { 0x54B121, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x54B203, "PEGATRON CORPORATION" },
        { 0x54B56C, "Xi'an NovaStar Tech Co., Ltd" },
        { 0x54B620, "SUHDOL E&C Co.Ltd." },
        { 0x54B753, "Hunan Fenghui Yinjia Science And Technology Co.,Ltd" },
        { 0x54B7E5, "Rayson Technology Co., Ltd." },
        { 0x54B802, "Samsung Electronics Co.,Ltd" },
        { 0x54B80A, "D-Link International" },
        { 0x54BAD6, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x54BD79, "Samsung Electronics Co.,Ltd" },
        { 0x54BE53, "zte corporation" },
        { 0x54BEF7, "PEGATRON CORPORATION" },
        { 0x54BF64, "Dell Inc." },
        { 0x54C33E, "Ciena Corporation" },
        { 0x54C415, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x54C57A, "Sunnovo International Limited" },
        { 0x54C80F, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x54C9DF, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x54CD10, "Panasonic Mobile Communications Co.,Ltd." },
        { 0x54CDA7, "Fujian Shenzhou Electronic Co.,Ltd" },
        { 0x54CDEE, "ShenZhen Apexis Electronic Co.,Ltd" },
        { 0x54CE69, "Hikari Trading Co.,Ltd." },
        { 0x54D0B4, "Xiamen Four-Faith Communication Technology Co.,Ltd" },
        { 0x54D0ED, "AXIM Communications" },
        { 0x54D163, "MAX-TECH,INC" },
        { 0x54D1B0, "Universal Laser Systems, Inc" },
        { 0x54D272, "Nuki Home Solutions GmbH" },
        { 0x54D46F, "Cisco SPVTG" },
        { 0x54D751, "Proximus" },
        { 0x54D9C6, "Huawei Device Co., Ltd." },
        { 0x54D9E4, "BRILLIANTTS CO., LTD" },
        { 0x54DC1D, "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd" },
        { 0x54DED0, "Sevio Srl" },
        { 0x54DF00, "Ulterius Technologies, LLC" },
        { 0x54DF24, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x54DF63, "Intrakey technologies GmbH" },
        { 0x54E019, "Ring LLC" },
        { 0x54E032, "Juniper Networks" },
        { 0x54E061, "SICHUAN TIANYI COMHEART TELECOMCO., LTD" },
        { 0x54E140, "INGENICO" },
        { 0x54E1AD, "LCFC(HeFei) Electronics Technology co., ltd" },
        { 0x54E2C8, "Dongguan Aoyuan Electronics Technology Co., Ltd" },
        { 0x54E2E0, "ARRIS Group, Inc." },
        { 0x54E3B0, "JVL Industri Elektronik" },
        { 0x54E3F6, "Alcatel-Lucent" },
        { 0x54E43A, "Apple, Inc." },
        { 0x54E4A9, "BHR Tech GmbH" },
        { 0x54E4BD, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x54E63F, "ShenZhen LingKeWeiEr Technology Co., Ltd." },
        { 0x54E6FC, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x54E7D5, "Sun Cupid Technology (HK) LTD" },
        { 0x54EAA8, "Apple, Inc." },
        { 0x54EC2F, "Ruckus Wireless" },
        { 0x54EDA3, "Navdy, Inc." },
        { 0x54EE75, "Wistron InfoComm(Kunshan)Co.,Ltd." },
        { 0x54EF44, "Lumi United Technology Co., Ltd" },
        { 0x54EF92, "Shenzhen Elink Technology Co., LTD" },
        { 0x54EFFE, "Fullpower Technologies, Inc." },
        { 0x54F15F, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x54F201, "Samsung Electronics Co.,Ltd" },
        { 0x54F294, "Huawei Device Co., Ltd." },
        { 0x54F5B6, "ORIENTAL PACIFIC INTERNATIONAL LIMITED" },
        { 0x54F666, "Berthold Technologies GmbH and Co.KG" },
        { 0x54F6C5, "FUJIAN STAR-NET COMMUNICATION CO.,LTD" },
        { 0x54F876, "ABB AG" },
        { 0x54FA3E, "Samsung Electronics Co.,Ltd" },
        { 0x54FA96, "Nokia" },
        { 0x54FB58, "WISEWARE, Lda" },
        { 0x54FCF0, "Samsung Electronics Co.,Ltd" },
        { 0x54FDBF, "Scheidt & Bachmann GmbH" },
        { 0x54FF82, "Davit Solution co." },
        { 0x54FFCF, "Mopria Alliance" },
        { 0x5800BB, "Juniper Networks" },
        { 0x5800E3, "Liteon Technology Corporation" },
        { 0x5803FB, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x580454, "ICOMM HK LIMITED" },
        { 0x5804CB, "Tianjin Huisun Technology Co.,Ltd." },
        { 0x580528, "LABRIS NETWORKS" },
        { 0x580556, "Elettronica GF S.r.L." },
        { 0x5808FA, "Fiber Optic & telecommunication INC." },
        { 0x580943, "Private" },
        { 0x5809E5, "Kivic Inc." },
        { 0x580A20, "Cisco Systems, Inc" },
        { 0x58108C, "Intelbras" },
        { 0x581243, "AcSiP Technology Corp." },
        { 0x581626, "Avaya Inc" },
        { 0x5816D7, "ALPS ELECTRIC CO., LTD." },
        { 0x58170C, "Sony Mobile Communications Inc" },
        { 0x5819F8, "ARRIS Group, Inc." },
        { 0x581CBD, "Affinegy" },
        { 0x581D91, "Advanced Mobile Telecom co.,ltd." },
        { 0x581F28, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x581F67, "Open-m technology limited" },
        { 0x581FAA, "Apple, Inc." },
        { 0x581FEF, "Tuttnaer LTD" },
        { 0x582059, "Xiaomi Communications Co Ltd" },
        { 0x58208A, "IEEE Registration Authority" },
        { 0x5820B1, "Hewlett Packard" },
        { 0x582136, "KMB systems, s.r.o." },
        { 0x5821E9, "TWPI" },
        { 0x58238C, "Technicolor CH USA Inc." },
        { 0x582429, "Google, Inc." },
        { 0x582575, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x58278C, "BUFFALO.INC" },
        { 0x582AF7, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x582BDB, "Pax AB" },
        { 0x582D34, "Qingping Electronics (Suzhou) Co., Ltd" },
        { 0x582EFE, "Lighting Science Group" },
        { 0x582F40, "Nintendo Co.,Ltd" },
        { 0x582F42, "Universal Electric Corporation" },
        { 0x583112, "DRUST" },
        { 0x583277, "Reliance Communications LLC" },
        { 0x58343B, "Glovast Technology Ltd." },
        { 0x583526, "DEEPLET TECHNOLOGY CORP" },
        { 0x5835D9, "Cisco Systems, Inc" },
        { 0x583879, "RICOH COMPANY, LTD." },
        { 0x583BD9, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x583CC6, "Omneality Ltd." },
        { 0x583F54, "LG Electronics (Mobile Communications)" },
        { 0x58404E, "Apple, Inc." },
        { 0x5842E4, "Baxter International Inc" },
        { 0x584498, "Xiaomi Communications Co Ltd" },
        { 0x58468F, "Koncar Electronics and Informatics" },
        { 0x5846E1, "Baxter International Inc" },
        { 0x584704, "Shenzhen Webridge Technology Co.,Ltd" },
        { 0x584822, "Sony Mobile Communications Inc" },
        { 0x5848C0, "COFLEC" },
        { 0x584925, "E3 Enterprise" },
        { 0x58493B, "Palo Alto Networks" },
        { 0x5849BA, "Chitai Electronic Corp." },
        { 0x584C19, "Chongqing Guohong Technology Development Company Limited" },
        { 0x584CEE, "Digital One Technologies, Limited" },
        { 0x585076, "Linear Equipamentos Eletronicos SA" },
        { 0x5850AB, "TLS Corporation" },
        { 0x5850E6, "Best Buy Corporation" },
        { 0x5850ED, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x58528A, "Mitsubishi Electric Corporation" },
        { 0x5853C0, "Beijing Guang Runtong Technology Development Company co.,Ltd" },
        { 0x5855CA, "Apple, Inc." },
        { 0x5856E8, "ARRIS Group, Inc." },
        { 0x58570D, "Danfoss Solar Inverters" },
        { 0x5859C2, "Extreme Networks, Inc." },
        { 0x585FF6, "zte corporation" },
        { 0x58605F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5860D8, "ARRIS Group, Inc." },
        { 0x586163, "Quantum Networks (SG) Pte. Ltd." },
        { 0x586356, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x58639A, "TPL SYSTEMES" },
        { 0x5865E6, "infomark" },
        { 0x5866BA, "Hangzhou H3C Technologies Co., Limited" },
        { 0x58671A, "Barnes&Noble" },
        { 0x58677F, "Clare Controls Inc." },
        { 0x58685D, "Tempo Australia Pty Ltd" },
        { 0x58696C, "Ruijie Networks Co.,LTD" },
        { 0x5869F9, "Fusion Transactive Ltd." },
        { 0x586AB1, "Hangzhou H3C Technologies Co., Limited" },
        { 0x586B14, "Apple, Inc." },
        { 0x586D8F, "Cisco-Linksys, LLC" },
        { 0x586ED6, "Private" },
        { 0x5870C6, "Shanghai Xiaoyi Technology Co., Ltd." },
        { 0x587521, "CJSC RTSoft" },
        { 0x587675, "Beijing ECHO Technologies Co.,Ltd" },
        { 0x5876C5, "DIGI I'S LTD" },
        { 0x587A4D, "Stonesoft Corporation" },
        { 0x587A62, "Texas Instruments" },
        { 0x587A6A, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x587BE9, "AirPro Technology India Pvt. Ltd" },
        { 0x587E61, "Qingdao Hisense Communications Co.,Ltd." },
        { 0x587F57, "Apple, Inc." },
        { 0x587F66, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x587FB7, "SONAR INDUSTRIAL CO., LTD." },
        { 0x587FC8, "S2M" },
        { 0x58821D, "H. Schomäcker GmbH" },
        { 0x5882A8, "Microsoft" },
        { 0x5884E4, "IP500 Alliance e.V." },
        { 0x58856E, "QSC AG" },
        { 0x5885A2, "Realme Chongqing MobileTelecommunications Corp Ltd" },
        { 0x5885E9, "Realme Chongqing MobileTelecommunications Corp Ltd" },
        { 0x588694, "EFM Networks" },
        { 0x58874C, "LITE-ON CLEAN ENERGY TECHNOLOGY CORP." },
        { 0x5887E2, "Shenzhen Coship Electronics Co., Ltd." },
        { 0x588A5A, "Dell Inc." },
        { 0x588BF3, "Zyxel Communications Corporation" },
        { 0x588D09, "Cisco Systems, Inc" },
        { 0x588D64, "Xi'an Clevbee Technology Co.,Ltd" },
        { 0x588E81, "Silicon Laboratories" },
        { 0x589043, "Sagemcom Broadband SAS" },
        { 0x5891CF, "Intel Corporate" },
        { 0x58920D, "Kinetic Avionics Limited" },
        { 0x589396, "Ruckus Wireless" },
        { 0x5893D8, "Texas Instruments" },
        { 0x58946B, "Intel Corporate" },
        { 0x5894A2, "KETEK GmbH" },
        { 0x5894B2, "BrainCo" },
        { 0x5894CF, "Vertex Standard LMR, Inc." },
        { 0x5895D8, "IEEE Registration Authority" },
        { 0x58961D, "Intel Corporate" },
        { 0x589630, "Technicolor CH USA Inc." },
        { 0x58971E, "Cisco Systems, Inc" },
        { 0x5897BD, "Cisco Systems, Inc" },
        { 0x589835, "Technicolor" },
        { 0x58986F, "Revolution Display" },
        { 0x589B0B, "Shineway Technologies, Inc." },
        { 0x589CFC, "FreeBSD Foundation" },
        { 0x589EC6, "Gigaset Communications GmbH" },
        { 0x58A023, "Intel Corporate" },
        { 0x58A0CB, "TrackNet, Inc" },
        { 0x58A2B5, "LG Electronics (Mobile Communications)" },
        { 0x58A48E, "PixArt Imaging Inc." },
        { 0x58A76F, "iD corporation" },
        { 0x58A839, "Intel Corporate" },
        { 0x58A87B, "Fitbit, Inc." },
        { 0x58AC78, "Cisco Systems, Inc" },
        { 0x58B035, "Apple, Inc." },
        { 0x58B0D4, "ZuniData Systems Inc." },
        { 0x58B10F, "Samsung Electronics Co.,Ltd" },
        { 0x58B3FC, "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD." },
        { 0x58B42D, "YSTen Technology Co.,Ltd" },
        { 0x58B568, "SECURITAS DIRECT ESPAÑA, SAU" },
        { 0x58B623, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x58B633, "Ruckus Wireless" },
        { 0x58B961, "SOLEM Electronique" },
        { 0x58B9E1, "Crystalfontz America, Inc." },
        { 0x58BAD4, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x58BC27, "Cisco Systems, Inc" },
        { 0x58BC8F, "Cognitive Systems Corp." },
        { 0x58BDA3, "Nintendo Co., Ltd." },
        { 0x58BDF9, "Sigrand" },
        { 0x58BFEA, "Cisco Systems, Inc" },
        { 0x58C17A, "Cambium Networks Limited" },
        { 0x58C232, "NEC Corporation" },
        { 0x58C38B, "Samsung Electronics Co.,Ltd" },
        { 0x58C583, "ITEL MOBILE LIMITED" },
        { 0x58C5CB, "Samsung Electronics Co.,Ltd" },
        { 0x58C6F0, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x58C876, "China Mobile (Hangzhou) Information Technology Co., Ltd." },
        { 0x58C935, "Chiun Mai Communication Systems, Inc" },
        { 0x58CB52, "Google, Inc." },
        { 0x58CF4B, "Lufkin Industries" },
        { 0x58D061, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x58D071, "BW Broadcast" },
        { 0x58D08F, "IEEE 1904.1 Working Group" },
        { 0x58D349, "Apple, Inc." },
        { 0x58D50A, "Murata Manufacturing Co., Ltd." },
        { 0x58D56E, "D-Link International" },
        { 0x58D67A, "TCPlink" },
        { 0x58D6D3, "Dairy Cheq Inc" },
        { 0x58D759, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x58D9C3, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x58D9D5, "Tenda Technology Co.,Ltd.Dongguan branch" },
        { 0x58DB15, "TECNO MOBILE LIMITED" },
        { 0x58DB8D, "Fast Co., Ltd." },
        { 0x58DC6D, "Exceptional Innovation, Inc." },
        { 0x58E02C, "Micro Technic A/S" },
        { 0x58E16C, "Ying Hua Information Technology (Shanghai)Co., LTD" },
        { 0x58E28F, "Apple, Inc." },
        { 0x58E326, "Compass Technologies Inc." },
        { 0x58E476, "CENTRON COMMUNICATIONS TECHNOLOGIES FUJIAN CO.,LTD" },
        { 0x58E636, "EVRsafe Technologies" },
        { 0x58E6BA, "Apple, Inc." },
        { 0x58E747, "Deltanet AG" },
        { 0x58E808, "AUTONICS CORPORATION" },
        { 0x58E873, "HANGZHOU DANGBEI NETWORK TECH.Co.,Ltd" },
        { 0x58E876, "IEEE Registration Authority" },
        { 0x58EAFC, "ELL-IoT Inc" },
        { 0x58EB14, "Proteus Digital Health" },
        { 0x58ECE1, "Newport Corporation" },
        { 0x58ECED, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x58EECE, "Icon Time Systems" },
        { 0x58EF68, "Belkin International Inc." },
        { 0x58F102, "BLU Products Inc." },
        { 0x58F2FC, "Huawei Device Co., Ltd." },
        { 0x58F387, "HCCP" },
        { 0x58F39C, "Cisco Systems, Inc" },
        { 0x58F496, "Source Chain" },
        { 0x58F67B, "Xia Men UnionCore Technology LTD." },
        { 0x58F6BF, "Kyoto University" },
        { 0x58F987, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x58F98E, "SECUDOS GmbH" },
        { 0x58FB84, "Intel Corporate" },
        { 0x58FC73, "Arria Live Media, Inc." },
        { 0x58FCDB, "IEEE Registration Authority" },
        { 0x58FD20, "Bravida Sakerhet AB" },
        { 0x58FDB1, "LG Electronics" },
        { 0x58FDBE, "Shenzhen Taikaida Technology Co., Ltd" },
        { 0x5C0038, "Viasat Group S.p.A." },
        { 0x5C026A, "Applied Vision Corporation" },
        { 0x5C0272, "Silicon Laboratories" },
        { 0x5C0339, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5C076F, "Thought Creator" },
        { 0x5C0947, "Apple, Inc." },
        { 0x5C0979, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5C0A5B, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x5C0BCA, "Tunstall Nordic AB" },
        { 0x5C0C0E, "Guizhou Huaxintong Semiconductor Technology Co Ltd" },
        { 0x5C0CBB, "CELIZION Inc." },
        { 0x5C0E8B, "Extreme Networks, Inc." },
        { 0x5C0FFB, "Amino Communications Ltd" },
        { 0x5C10C5, "Samsung Electronics Co.,Ltd" },
        { 0x5C1193, "Seal One AG" },
        { 0x5C1437, "Thyssenkrupp Aufzugswerke GmbH" },
        { 0x5C1515, "ADVAN" },
        { 0x5C15E1, "AIDC TECHNOLOGY (S) PTE LTD" },
        { 0x5C16C7, "Big Switch Networks" },
        { 0x5C1737, "I-View Now, LLC." },
        { 0x5C17CF, "OnePlus Technology (Shenzhen) Co., Ltd" },
        { 0x5C17D3, "LGE" },
        { 0x5C18B5, "Talon Communications" },
        { 0x5C1A6F, "Cambridge Industries(Group) Co.,Ltd." },
        { 0x5C1CB9, "vivo Mobile Communication Co., Ltd." },
        { 0x5C1DD9, "Apple, Inc." },
        { 0x5C20D0, "Asoni Communication Co., Ltd." },
        { 0x5C22C4, "DAE EUN ELETRONICS CO., LTD" },
        { 0x5C2316, "Squirrels Research Labs LLC" },
        { 0x5C2443, "O-Sung Telecom Co., Ltd." },
        { 0x5C2479, "Baltech AG" },
        { 0x5C254C, "Avire Global Pte Ltd" },
        { 0x5C260A, "Dell Inc." },
        { 0x5C2623, "WaveLynx Technologies Corporation" },
        { 0x5C27D4, "Shenzhen Qihu Intelligent Technology Company Limited" },
        { 0x5C2AEF, "r2p Asia-Pacific Pty Ltd" },
        { 0x5C2BF5, "Vivint Wireless Inc." },
        { 0x5C2E59, "Samsung Electronics Co.,Ltd" },
        { 0x5C2ED2, "ABC(XiSheng) Electronics Co.,Ltd" },
        { 0x5C313E, "Texas Instruments" },
        { 0x5C32C5, "Teracom Ltd." },
        { 0x5C3327, "Spazio Italia srl" },
        { 0x5C335C, "Swissphone Telecom AG" },
        { 0x5C338E, "Alpha Networks Inc." },
        { 0x5C3400, "Hisense Electric Co.,Ltd" },
        { 0x5C353B, "Compal Broadband Networks, Inc." },
        { 0x5C35DA, "There Corporation Oy" },
        { 0x5C36B8, "TCL King Electrical Appliances (Huizhou) Co., Ltd" },
        { 0x5C38E0, "Shanghai Super Electronics Technology Co.,LTD" },
        { 0x5C3A3D, "zte corporation" },
        { 0x5C3A45, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x5C3B35, "Gehirn Inc." },
        { 0x5C3C27, "Samsung Electronics Co.,Ltd" },
        { 0x5C4058, "Jefferson Audio Video Systems, Inc." },
        { 0x5C415A, "Amazon.com, LLC" },
        { 0x5C41E7, "Wiatec International Ltd." },
        { 0x5C43D2, "HAZEMEYER" },
        { 0x5C443E, "Skullcandy" },
        { 0x5C4527, "Juniper Networks" },
        { 0x5C4979, "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
        { 0x5C497D, "Samsung Electronics Co.,Ltd" },
        { 0x5C4A1F, "SICHUAN TIANYI COMHEART TELECOMCO., LTD" },
        { 0x5C4A26, "Enguity Technology Corp" },
        { 0x5C4CA9, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5C5015, "Cisco Systems, Inc" },
        { 0x5C514F, "Intel Corporate" },
        { 0x5C5181, "Samsung Electronics Co.,Ltd" },
        { 0x5C5188, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x5C521E, "Nintendo Co.,Ltd" },
        { 0x5C546D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5C5578, "iryx corp" },
        { 0x5C56ED, "3pleplay Electronics Private Limited" },
        { 0x5C571A, "ARRIS Group, Inc." },
        { 0x5C57C8, "Nokia Corporation" },
        { 0x5C5819, "Jingsheng Technology Co., Ltd." },
        { 0x5C5948, "Apple, Inc." },
        { 0x5C5AC7, "Cisco Systems, Inc" },
        { 0x5C5AEA, "FORD" },
        { 0x5C5B35, "Mist Systems, Inc." },
        { 0x5C5BC2, "YIK Corporation" },
        { 0x5C5EAB, "Juniper Networks" },
        { 0x5C5F67, "Intel Corporate" },
        { 0x5C6199, "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD." },
        { 0x5C63BF, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x5C63C9, "Intellithings Ltd." },
        { 0x5C647A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5C666C, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x5C6776, "IDS Imaging Development Systems GmbH" },
        { 0x5C68D0, "Aurora Innovation Inc." },
        { 0x5C6984, "NUVICO" },
        { 0x5C6A7D, "KENTKART EGE ELEKTRONIK SAN. VE TIC. LTD. STI." },
        { 0x5C6A80, "Zyxel Communications Corporation" },
        { 0x5C6B32, "Texas Instruments" },
        { 0x5C6B4F, "Hello Inc." },
        { 0x5C6BD7, "Foshan VIOMI Electric Appliance Technology Co. Ltd." },
        { 0x5C6D20, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x5C6F4F, "S.A. SISTEL" },
        { 0x5C70A3, "LG Electronics (Mobile Communications)" },
        { 0x5C710D, "Cisco Systems, Inc" },
        { 0x5C75AF, "Fitbit, Inc." },
        { 0x5C7695, "Technicolor CH USA Inc." },
        { 0x5C7757, "Haivision Network Video" },
        { 0x5C7776, "TCT mobile ltd" },
        { 0x5C78F8, "Huawei Device Co., Ltd." },
        { 0x5C7D5E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5C7D7D, "Technicolor CH USA Inc." },
        { 0x5C80B6, "Intel Corporate" },
        { 0x5C81A7, "Network Devices Pty Ltd" },
        { 0x5C838F, "Cisco Systems, Inc" },
        { 0x5C8486, "Brightsource Industries Israel LTD" },
        { 0x5C857E, "IEEE Registration Authority" },
        { 0x5C8613, "Beijing Zhoenet Technology Co., Ltd" },
        { 0x5C864A, "Secret Labs LLC" },
        { 0x5C865C, "Samsung Electronics Co.,Ltd" },
        { 0x5C86C1, "DONGGUAN SOLUM ELECTRONICS CO.,LTD" },
        { 0x5C8730, "Apple, Inc." },
        { 0x5C8778, "Cybertelbridge co.,ltd" },
        { 0x5C879C, "Intel Corporate" },
        { 0x5C8816, "Rockwell Automation" },
        { 0x5C899A, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x5C89D4, "Beijing Banner Electric Co.,Ltd" },
        { 0x5C8A38, "Hewlett Packard" },
        { 0x5C8D2D, "Shanghai Wellpay Information Technology Co., Ltd" },
        { 0x5C8D4E, "Apple, Inc." },
        { 0x5C8FE0, "ARRIS Group, Inc." },
        { 0x5C9012, "Owl Cyber Defense Solutions, LLC" },
        { 0x5C9157, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5C91FD, "Jaewoncnc" },
        { 0x5C925E, "Zioncom Electronics (Shenzhen) Ltd." },
        { 0x5C93A2, "Liteon Technology Corporation" },
        { 0x5C95AE, "Apple, Inc." },
        { 0x5C9656, "AzureWave Technology Inc." },
        { 0x5C966A, "RTNET" },
        { 0x5C969D, "Apple, Inc." },
        { 0x5C97F3, "Apple, Inc." },
        { 0x5C9960, "Samsung Electronics Co.,Ltd" },
        { 0x5C9AD8, "FUJITSU LIMITED" },
        { 0x5CA176, "SICHUAN TIANYI COMHEART TELECOMCO., LTD" },
        { 0x5CA178, "TableTop Media (dba Ziosk)" },
        { 0x5CA1E0, "EmbedWay Technologies" },
        { 0x5CA39D, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x5CA3EB, "Lokel s.r.o." },
        { 0x5CA48A, "Cisco Systems, Inc" },
        { 0x5CA5BC, "eero inc." },
        { 0x5CA62D, "Cisco Systems, Inc" },
        { 0x5CA86A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5CA933, "Luma Home" },
        { 0x5CAAFD, "Sonos, Inc." },
        { 0x5CAC4C, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x5CAD76, "Shenzhen TCL New Technology Co., Ltd" },
        { 0x5CADCF, "Apple, Inc." },
        { 0x5CAF06, "LG Electronics (Mobile Communications)" },
        { 0x5CB066, "ARRIS Group, Inc." },
        { 0x5CB13E, "Sagemcom Broadband SAS" },
        { 0x5CB15F, "Oceanblue Cloud Technology Limited" },
        { 0x5CB29E, "ASCO Power Technologies" },
        { 0x5CB395, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5CB3F6, "Human, Incorporated" },
        { 0x5CB43E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5CB4E2, "Inspur Software Group Ltd." },
        { 0x5CB524, "Sony Mobile Communications Inc" },
        { 0x5CB559, "CNEX Labs" },
        { 0x5CB6CC, "NovaComm Technologies Inc." },
        { 0x5CB8CB, "Allis Communications" },
        { 0x5CB901, "Hewlett Packard" },
        { 0x5CBA2C, "Hewlett Packard Enterprise" },
        { 0x5CBA37, "Microsoft Corporation" },
        { 0x5CBAEF, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x5CBD9E, "HONGKONG MIRACLE EAGLE TECHNOLOGY(GROUP) LIMITED" },
        { 0x5CC0A0, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5CC1D7, "Samsung Electronics Co.,Ltd" },
        { 0x5CC213, "Fr. Sauter AG" },
        { 0x5CC307, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5CC5D4, "Intel Corporate" },
        { 0x5CC6D0, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x5CC6E9, "Edifier International" },
        { 0x5CC7D7, "AZROAD TECHNOLOGY COMPANY LIMITED" },
        { 0x5CC999, "New H3C Technologies Co., Ltd" },
        { 0x5CC9D3, "PALLADIUM ENERGY ELETRONICA DA AMAZONIA LTDA" },
        { 0x5CCA1A, "Microsoft Mobile Oy" },
        { 0x5CCA32, "Theben AG" },
        { 0x5CCAD3, "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP." },
        { 0x5CCB99, "Samsung Electronics Co.,Ltd" },
        { 0x5CCBCA, "FUJIAN STAR-NET COMMUNICATION CO.,LTD" },
        { 0x5CCCA0, "Gridwiz Inc." },
        { 0x5CCCFF, "Techroutes Network Pvt Ltd" },
        { 0x5CCD5B, "Intel Corporate" },
        { 0x5CCD7C, "MEIZU Technology Co.,Ltd." },
        { 0x5CCEAD, "CDYNE Corporation" },
        { 0x5CCF7F, "Espressif Inc." },
        { 0x5CD135, "Xtreme Power Systems" },
        { 0x5CD20B, "Yytek Co., Ltd." },
        { 0x5CD2E4, "Intel Corporate" },
        { 0x5CD41B, "UCZOON Technology Co., LTD" },
        { 0x5CD4AB, "Zektor" },
        { 0x5CD5B5, "Shenzhen WiSiYiLink Technology Co.,Ltd" },
        { 0x5CD61F, "Qardio, Inc" },
        { 0x5CD89E, "Huawei Device Co., Ltd." },
        { 0x5CD998, "D-Link Corporation" },
        { 0x5CDAD4, "Murata Manufacturing Co., Ltd." },
        { 0x5CDC96, "Arcadyan Technology Corporation" },
        { 0x5CDD70, "Hangzhou H3C Technologies Co., Limited" },
        { 0x5CE0C5, "Intel Corporate" },
        { 0x5CE0CA, "FeiTian United (Beijing) System Technology Co., Ltd." },
        { 0x5CE0F6, "NIC.br- Nucleo de Informacao e Coordenacao do Ponto BR" },
        { 0x5CE176, "Cisco Systems, Inc" },
        { 0x5CE223, "Delphin Technology AG" },
        { 0x5CE286, "Nortel Networks" },
        { 0x5CE28C, "Zyxel Communications Corporation" },
        { 0x5CE2F4, "AcSiP Technology Corp." },
        { 0x5CE30E, "ARRIS Group, Inc." },
        { 0x5CE3B6, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x5CE50C, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x5CE7A0, "Nokia" },
        { 0x5CE7BF, "New Singularity International Technical Development Co.,Ltd" },
        { 0x5CE883, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5CE8B7, "Oraimo Technology Limited" },
        { 0x5CE8EB, "Samsung Electronics Co.,Ltd" },
        { 0x5CEA1D, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x5CEB4E, "R. STAHL HMI Systems GmbH" },
        { 0x5CEB68, "Cheerstar Technology Co., Ltd" },
        { 0x5CED8C, "Hewlett Packard Enterprise" },
        { 0x5CEE79, "Global Digitech Co LTD" },
        { 0x5CF207, "Speco Technologies" },
        { 0x5CF286, "IEEE Registration Authority" },
        { 0x5CF370, "CC&C Technologies, Inc" },
        { 0x5CF3FC, "IBM Corp" },
        { 0x5CF4AB, "Zyxel Communications Corporation" },
        { 0x5CF50D, "Institute of microelectronic applications" },
        { 0x5CF5DA, "Apple, Inc." },
        { 0x5CF6DC, "Samsung Electronics Co.,Ltd" },
        { 0x5CF7C3, "SYNTECH (HK) TECHNOLOGY LIMITED" },
        { 0x5CF7E6, "Apple, Inc." },
        { 0x5CF821, "Texas Instruments" },
        { 0x5CF8A1, "Murata Manufacturing Co., Ltd." },
        { 0x5CF938, "Apple, Inc." },
        { 0x5CF96A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x5CF9DD, "Dell Inc." },
        { 0x5CF9F0, "Atomos Engineering P/L" },
        { 0x5CF9FD, "Taicang T&W Electronics" },
        { 0x5CFAFB, "Acubit" },
        { 0x5CFB3A, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x5CFB7C, "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd" },
        { 0x5CFC66, "Cisco Systems, Inc" },
        { 0x5CFE9E, "Wiwynn Corporation Tainan Branch" },
        { 0x5CFF35, "Wistron Corporation" },
        { 0x5CFFFF, "Shenzhen Kezhonglong Optoelectronic Technology Co., Ltd" },
        { 0x600194, "Espressif Inc." },
        { 0x600292, "PEGATRON CORPORATION" },
        { 0x6002B4, "Wistron Neweb Corporation" },
        { 0x600308, "Apple, Inc." },
        { 0x600347, "Billion Electric Co. Ltd." },
        { 0x6003A6, "Inteno Broadband Technology AB" },
        { 0x600417, "POSBANK CO.,LTD" },
        { 0x60058A, "Hitachi Metals, Ltd." },
        { 0x60077C, "Jala Group" },
        { 0x600810, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x600837, "ivvi Scientific(Nanchang)Co.Ltd" },
        { 0x6009C3, "u-blox AG" },
        { 0x600B03, "Hangzhou H3C Technologies Co., Limited" },
        { 0x600F77, "SilverPlus, Inc" },
        { 0x6010A2, "Crompton Instruments" },
        { 0x601199, "Siama Systems Inc" },
        { 0x60123C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x601283, "TSB REAL TIME LOCATION SYSTEMS S.L." },
        { 0x60128B, "CANON INC." },
        { 0x601466, "zte corporation" },
        { 0x6014B3, "CyberTAN Technology Inc." },
        { 0x6015C7, "IdaTech" },
        { 0x601803, "Daikin Air-conditioning (Shanghai) Co., Ltd." },
        { 0x60182E, "ShenZhen Protruly Electronic Ltd co." },
        { 0x601888, "zte corporation" },
        { 0x60190C, "RRAMAC" },
        { 0x601929, "VOLTRONIC POWER TECHNOLOGY(SHENZHEN) CORP." },
        { 0x601970, "HUIZHOU QIAOXING ELECTRONICS TECHNOLOGY CO., LTD." },
        { 0x601971, "ARRIS Group, Inc." },
        { 0x601D0F, "Midnite Solar" },
        { 0x601D91, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x601D9D, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x601E02, "EltexAlatau" },
        { 0x602101, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x602103, "I4VINE, INC" },
        { 0x6021C0, "Murata Manufacturing Co., Ltd." },
        { 0x6023A4, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x6024C1, "Jiangsu Zhongxun Electronic Technology Co., Ltd" },
        { 0x60271C, "VIDEOR E. Hartig GmbH" },
        { 0x6029D5, "DAVOLINK Inc." },
        { 0x602A54, "CardioTek B.V." },
        { 0x602AD0, "Cisco SPVTG" },
        { 0x602E20, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x6030D4, "Apple, Inc." },
        { 0x60313B, "Sunnovo International Limited" },
        { 0x603197, "Zyxel Communications Corporation" },
        { 0x6032B1, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x6032F0, "Mplus technology" },
        { 0x60334B, "Apple, Inc." },
        { 0x603553, "Buwon Technology" },
        { 0x603573, "Earda Technologies co Ltd" },
        { 0x6035C0, "SFR" },
        { 0x603696, "The Sapling Company" },
        { 0x6036DD, "Intel Corporate" },
        { 0x60380E, "ALPS ELECTRIC CO., LTD." },
        { 0x6038E0, "Belkin International Inc." },
        { 0x60391F, "ABB Ltd" },
        { 0x603A7C, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x603CEE, "LG Electronics (Mobile Communications)" },
        { 0x603D26, "Technicolor CH USA Inc." },
        { 0x603E7B, "Gafachi, Inc." },
        { 0x603ECA, "Cambridge Medical Robotics Ltd" },
        { 0x603FC5, "COX CO., LTD" },
        { 0x60427F, "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD" },
        { 0x60447A, "Water-i.d. GmbH" },
        { 0x6044F5, "Easy Digital Ltd." },
        { 0x60455E, "Liptel s.r.o." },
        { 0x6045BD, "Microsoft" },
        { 0x6045CB, "ASUSTek COMPUTER INC." },
        { 0x604616, "XIAMEN VANN INTELLIGENT CO., LTD" },
        { 0x604762, "Beijing Sensoro Technology Co.,Ltd." },
        { 0x6047D4, "FORICS Electronic Technology Co., Ltd." },
        { 0x604826, "Newbridge Technologies Int. Ltd." },
        { 0x6049C1, "Avaya Inc" },
        { 0x604A1C, "SUYIN Corporation" },
        { 0x604BAA, "Magic Leap, Inc." },
        { 0x6050C1, "Kinetek Sports" },
        { 0x60512C, "TCT mobile ltd" },
        { 0x6052D0, "FACTS Engineering" },
        { 0x605317, "Sandstone Technologies" },
        { 0x605464, "Eyedro Green Solutions Inc." },
        { 0x605661, "IXECLOUD Tech" },
        { 0x605718, "Intel Corporate" },
        { 0x605BB4, "AzureWave Technology Inc." },
        { 0x605F8D, "eero inc." },
        { 0x60601F, "SZ DJI TECHNOLOGY CO.,LTD" },
        { 0x6061DF, "Z-meta Research LLC" },
        { 0x60634C, "D-Link International" },
        { 0x6063F9, "Ciholas, Inc." },
        { 0x6063FD, "Transcend Communication Beijing Co.,Ltd." },
        { 0x606405, "Texas Instruments" },
        { 0x606453, "AOD Co.,Ltd." },
        { 0x6064A1, "RADiflow Ltd." },
        { 0x606720, "Intel Corporate" },
        { 0x60684E, "Samsung Electronics Co.,Ltd" },
        { 0x606944, "Apple, Inc." },
        { 0x60699B, "isepos GmbH" },
        { 0x606BBD, "Samsung Electronics Co.,Ltd" },
        { 0x606BFF, "Nintendo Co.,Ltd" },
        { 0x606C66, "Intel Corporate" },
        { 0x606D3C, "Luxshare Precision Industry Company Limited" },
        { 0x606DC7, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x606ED0, "SEAL AG" },
        { 0x607072, "SHENZHEN HONGDE SMART LINK TECHNOLOGY CO., LTD" },
        { 0x6070C0, "Apple, Inc." },
        { 0x60720B, "BLU Products Inc" },
        { 0x60735C, "Cisco Systems, Inc" },
        { 0x6073BC, "zte corporation" },
        { 0x60748D, "Atmaca Elektronik" },
        { 0x607688, "Velodyne" },
        { 0x607771, "Texas Instruments" },
        { 0x6077E2, "Samsung Electronics Co.,Ltd" },
        { 0x607EA4, "Shanghai Imilab Technology Co.Ltd" },
        { 0x607EC9, "Apple, Inc." },
        { 0x607ECD, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x607EDD, "Microsoft Mobile Oy" },
        { 0x60812B, "Astronics Custom Control Concepts" },
        { 0x6081F9, "Helium Systems, Inc" },
        { 0x608334, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x608373, "Apple, Inc." },
        { 0x6083B2, "GkWare e.K." },
        { 0x60843B, "Soladigm, Inc." },
        { 0x6084BD, "BUFFALO.INC" },
        { 0x608645, "Avery Weigh-Tronix, LLC" },
        { 0x60893C, "Thermo Fisher Scientific P.O.A." },
        { 0x6089B1, "Key Digital Systems" },
        { 0x6089B7, "KAEL MÜHENDİSLİK ELEKTRONİK TİCARET SANAYİ LİMİTED ŞİRKETİ" },
        { 0x608B0E, "Apple, Inc." },
        { 0x608C2B, "Hanson Technology" },
        { 0x608C4A, "Apple, Inc." },
        { 0x608CDF, "Private" },
        { 0x608CE6, "ARRIS Group, Inc." },
        { 0x608D17, "Sentrus Government Systems Division, Inc" },
        { 0x608E08, "Samsung Electronics Co.,Ltd" },
        { 0x608F5C, "Samsung Electronics Co.,Ltd" },
        { 0x609084, "DSSD Inc" },
        { 0x6091F3, "vivo Mobile Communication Co., Ltd." },
        { 0x609217, "Apple, Inc." },
        { 0x6092F5, "ARRIS Group, Inc." },
        { 0x6095CE, "IEEE Registration Authority" },
        { 0x609620, "Private" },
        { 0x6097DD, "MicroSys Electronics GmbH" },
        { 0x609813, "Shanghai Visking Digital Technology Co. LTD" },
        { 0x609866, "Texas Instruments" },
        { 0x6099D1, "Vuzix / Lenovo" },
        { 0x609AA4, "GVI SECURITY INC." },
        { 0x609AC1, "Apple, Inc." },
        { 0x609B2D, "JMACS Japan Co., Ltd." },
        { 0x609BC8, "Hipad Intelligent Technology Co., Ltd." },
        { 0x609C9F, "Brocade Communications Systems LLC" },
        { 0x609E64, "Vivonic GmbH" },
        { 0x609F9D, "CloudSwitch" },
        { 0x60A10A, "Samsung Electronics Co.,Ltd" },
        { 0x60A11E, "Wuhan Maxsine Electric Co.,Ltd." },
        { 0x60A37D, "Apple, Inc." },
        { 0x60A423, "Silicon Laboratories" },
        { 0x60A44C, "ASUSTek COMPUTER INC." },
        { 0x60A4D0, "Samsung Electronics Co.,Ltd" },
        { 0x60A730, "Shenzhen Yipinfang Internet Technology Co.,Ltd" },
        { 0x60A8FE, "Nokia" },
        { 0x60A9B0, "Merchandising Technologies, Inc" },
        { 0x60AAEF, "Huawei Device Co., Ltd." },
        { 0x60AB14, "LG Innotek" },
        { 0x60AB67, "Xiaomi Communications Co Ltd" },
        { 0x60ABD2, "Bose Corporation" },
        { 0x60ACC8, "KunTeng Inc." },
        { 0x60AF6D, "Samsung Electronics Co.,Ltd" },
        { 0x60B185, "ATH system" },
        { 0x60B387, "Synergics Technologies GmbH" },
        { 0x60B3C4, "Elber Srl" },
        { 0x60B4F7, "Plume Design Inc" },
        { 0x60B606, "Phorus" },
        { 0x60B617, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x60B76E, "Google, Inc." },
        { 0x60B933, "Deutron Electronics Corp." },
        { 0x60B982, "RO.VE.R. Laboratories S.p.A." },
        { 0x60BA18, "nextLAP GmbH" },
        { 0x60BB0C, "Beijing HuaqinWorld Technology Co,Ltd" },
        { 0x60BC4C, "EWM Hightec Welding GmbH" },
        { 0x60BD91, "Move Innovation" },
        { 0x60BEB5, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x60BEC4, "Apple, Inc." },
        { 0x60C0BF, "ON Semiconductor" },
        { 0x60C1CB, "Fujian Great Power PLC Equipment Co.,Ltd" },
        { 0x60C397, "2Wire Inc" },
        { 0x60C547, "Apple, Inc." },
        { 0x60C5A8, "Beijing LT Honway Technology Co.,Ltd" },
        { 0x60C5AD, "Samsung Electronics Co.,Ltd" },
        { 0x60C658, "PHYTRONIX Co.,Ltd." },
        { 0x60C798, "Verifone" },
        { 0x60C980, "Trymus" },
        { 0x60CBFB, "AirScape Inc." },
        { 0x60CDA9, "Abloomy" },
        { 0x60CDC5, "Taiwan Carol Electronics., Ltd" },
        { 0x60CE86, "Sercomm Corporation." },
        { 0x60CE92, "The Refined Industry Company Limited" },
        { 0x60D02C, "Ruckus Wireless" },
        { 0x60D0A9, "Samsung Electronics Co.,Ltd" },
        { 0x60D1AA, "Vishal Telecommunications Pvt Ltd" },
        { 0x60D21C, "Sunnovo International Limited" },
        { 0x60D248, "ARRIS Group, Inc." },
        { 0x60D262, "Tzukuri Pty Ltd" },
        { 0x60D2B9, "REALAND BIO CO., LTD." },
        { 0x60D2DD, "Shenzhen Baitong Putian Technology Co.,Ltd." },
        { 0x60D30A, "Quatius Limited" },
        { 0x60D4E9, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x60D755, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x60D7E3, "IEEE Registration Authority" },
        { 0x60D819, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x60D89C, "HMD Global Oy" },
        { 0x60D9A0, "Lenovo Mobile Communication Technology Ltd." },
        { 0x60D9C7, "Apple, Inc." },
        { 0x60DA23, "Estech Co.,Ltd" },
        { 0x60DA83, "Hangzhou H3C Technologies Co., Limited" },
        { 0x60DB2A, "HNS" },
        { 0x60DB98, "Calix Inc." },
        { 0x60DE35, "GITSN, Inc." },
        { 0x60DE44, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x60DEF3, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x60E00E, "SHINSEI ELECTRONICS CO LTD" },
        { 0x60E327, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x60E3AC, "LG Electronics (Mobile Communications)" },
        { 0x60E6BC, "Sino-Telecom Technology Co.,Ltd." },
        { 0x60E701, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x60E78A, "UNISEM" },
        { 0x60E956, "Ayla Networks, Inc" },
        { 0x60EB5A, "Asterfusion Data Technologies Co.,Ltd" },
        { 0x60EB69, "Quanta Computer Inc." },
        { 0x60EE5C, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x60EFC6, "Shenzhen Chima Technologies Co Limited" },
        { 0x60F13D, "JABLOCOM s.r.o." },
        { 0x60F189, "Murata Manufacturing Co., Ltd." },
        { 0x60F18A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x60F262, "Intel Corporate" },
        { 0x60F281, "TRANWO TECHNOLOGY CO., LTD." },
        { 0x60F2EF, "VisionVera International Co., Ltd." },
        { 0x60F3DA, "Logic Way GmbH" },
        { 0x60F43A, "Edifier International" },
        { 0x60F445, "Apple, Inc." },
        { 0x60F494, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x60F59C, "CRU-Dataport" },
        { 0x60F673, "TERUMO CORPORATION" },
        { 0x60F677, "Intel Corporate" },
        { 0x60F81D, "Apple, Inc." },
        { 0x60FA9D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x60FACD, "Apple, Inc." },
        { 0x60FB42, "Apple, Inc." },
        { 0x60FD56, "WOORISYSTEMS CO., Ltd" },
        { 0x60FE1E, "China Palms Telecom.Ltd" },
        { 0x60FE20, "2Wire Inc" },
        { 0x60FEC5, "Apple, Inc." },
        { 0x60FEF9, "Thomas & Betts" },
        { 0x60FFDD, "C.E. ELECTRONICS, INC" },
        { 0x64002D, "Powerlinq Co., LTD" },
        { 0x64006A, "Dell Inc." },
        { 0x6400F1, "Cisco Systems, Inc" },
        { 0x6402CB, "ARRIS Group, Inc." },
        { 0x64037F, "Samsung Electronics Co.,Ltd" },
        { 0x6405BE, "NEW LIGHT LED" },
        { 0x6405E9, "Shenzhen WayOS Technology Crop., Ltd." },
        { 0x64094C, "Beijing Superbee Wireless Technology Co.,Ltd" },
        { 0x640980, "Xiaomi Communications Co Ltd" },
        { 0x6409AC, "TCT mobile ltd" },
        { 0x640B4A, "Digital Telecom Technology Limited" },
        { 0x640BD7, "Apple, Inc." },
        { 0x640DCE, "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x640DE6, "Petra Systems" },
        { 0x640E36, "TAZTAG" },
        { 0x640E94, "Pluribus Networks, Inc." },
        { 0x640F28, "2Wire Inc" },
        { 0x641084, "HEXIUM Technical Development Co., Ltd." },
        { 0x641225, "Cisco Systems, Inc" },
        { 0x641236, "Technicolor CH USA Inc." },
        { 0x641269, "ARRIS Group, Inc." },
        { 0x641331, "Bosch Car Multimedia (Wuhu) Co. Ltd." },
        { 0x64136C, "zte corporation" },
        { 0x641666, "Nest Labs Inc." },
        { 0x64167F, "Polycom" },
        { 0x64168D, "Cisco Systems, Inc" },
        { 0x6416F0, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x641A22, "Heliospectra AB" },
        { 0x641C67, "DIGIBRAS INDUSTRIA DO BRASILS/A" },
        { 0x641CAE, "Samsung Electronics Co.,Ltd" },
        { 0x641CB0, "Samsung Electronics Co.,Ltd" },
        { 0x641E81, "Dowslake Microsystems" },
        { 0x64200C, "Apple, Inc." },
        { 0x64209F, "Tilgin AB" },
        { 0x6420E0, "T3 Technology Co., Ltd." },
        { 0x642184, "Nippon Denki Kagaku Co.,LTD" },
        { 0x642216, "Shandong Taixin Electronic co.,Ltd" },
        { 0x642315, "Huawei Device Co., Ltd." },
        { 0x642400, "Xorcom Ltd." },
        { 0x64255E, "Observint Technologies, Inc." },
        { 0x642737, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x6429ED, "AO PKK Milandr" },
        { 0x642B8A, "ALL BEST Industrial Co., Ltd." },
        { 0x642C0F, "vivo Mobile Communication Co., Ltd." },
        { 0x642CAC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x642DB7, "SEUNGIL ELECTRONICS" },
        { 0x643139, "IEEE Registration Authority" },
        { 0x643150, "Hewlett Packard" },
        { 0x64317E, "Dexin Corporation" },
        { 0x6432A8, "Intel Corporate" },
        { 0x6433DB, "Texas Instruments" },
        { 0x643409, "BITwave Pte Ltd" },
        { 0x64351C, "e-CON SYSTEMS INDIA PVT LTD" },
        { 0x643AB1, "SICHUAN TIANYI COMHEART TELECOMCO.,LTD" },
        { 0x643AEA, "Cisco Systems, Inc" },
        { 0x643E8C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x643F5F, "Exablaze" },
        { 0x644214, "Swisscom Energy Solutions AG" },
        { 0x644346, "GuangDong Quick Network Computer CO.,LTD" },
        { 0x6447E0, "Feitian Technologies Co., Ltd" },
        { 0x644BC3, "Shanghai WOASiS Telecommunications Ltd., Co." },
        { 0x644BF0, "CalDigit, Inc" },
        { 0x644C36, "Intel Corporate" },
        { 0x644D70, "dSPACE GmbH" },
        { 0x644F42, "JETTER CO., Ltd." },
        { 0x644F74, "LENUS Co., Ltd." },
        { 0x644FB0, "Hyunjin.com" },
        { 0x645106, "Hewlett Packard" },
        { 0x64517E, "LONG BEN (DONGGUAN) ELECTRONIC TECHNOLOGY CO.,LTD." },
        { 0x645299, "The Chamberlain Group, Inc" },
        { 0x64535D, "Frauscher Sensortechnik" },
        { 0x645422, "Equinox Payments" },
        { 0x645563, "Intelight Inc." },
        { 0x64557F, "NSFOCUS Information Technology Co., Ltd." },
        { 0x6455B1, "ARRIS Group, Inc." },
        { 0x645601, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x6458AD, "China Mobile IOT Company Limited" },
        { 0x6459F8, "Vodafone Omnitel B.V." },
        { 0x645A04, "Chicony Electronics Co., Ltd." },
        { 0x645AED, "Apple, Inc." },
        { 0x645CF3, "ParanTek Inc." },
        { 0x645D86, "Intel Corporate" },
        { 0x645D92, "SICHUAN TIANYI COMHEART TELECOMCO.,LTD" },
        { 0x645DD7, "Shenzhen Lifesense Medical Electronics Co., Ltd." },
        { 0x645E10, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x645E2C, "IRay Technology Co., Ltd." },
        { 0x645EBE, "Yahoo! JAPAN" },
        { 0x645FFF, "Nicolet Neuro" },
        { 0x646038, "Hirschmann Automation and Control GmbH" },
        { 0x646184, "VELUX" },
        { 0x646223, "Cellient Co., Ltd." },
        { 0x646266, "IEEE Registration Authority" },
        { 0x64628A, "evon GmbH" },
        { 0x64649B, "Juniper Networks" },
        { 0x6465C0, "Nuvon, Inc" },
        { 0x646624, "Sagemcom Broadband SAS" },
        { 0x6466B3, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x646707, "Beijing Omnific Technology, Ltd." },
        { 0x64680C, "Comtrend Corporation" },
        { 0x64694E, "Texas Instruments" },
        { 0x6469BC, "Hytera Communications Co .,ltd" },
        { 0x646A52, "Avaya Inc" },
        { 0x646A74, "AUTH-SERVERS, LLC" },
        { 0x646C80, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x646CB2, "Samsung Electronics Co.,Ltd" },
        { 0x646D6C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x646E69, "Liteon Technology Corporation" },
        { 0x646E6C, "Radio Datacom LLC" },
        { 0x646E97, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x646EEA, "Iskratel d.o.o." },
        { 0x647002, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x647033, "Apple, Inc." },
        { 0x6472D8, "GooWi Technology Co.,Limited" },
        { 0x647366, "Shenzhen Siera Technology Ltd" },
        { 0x6473E2, "Arbiter Systems, Inc." },
        { 0x6474F6, "Shooter Detection Systems" },
        { 0x647657, "Innovative Security Designs" },
        { 0x6476BA, "Apple, Inc." },
        { 0x64777D, "Hitron Technologies. Inc" },
        { 0x647791, "Samsung Electronics Co.,Ltd" },
        { 0x647924, "Huawei Device Co., Ltd." },
        { 0x6479A7, "Phison Electronics Corp." },
        { 0x647BCE, "Samsung Electronics Co.,Ltd" },
        { 0x647BD4, "Texas Instruments" },
        { 0x647C34, "Ubee Interactive Co., Limited" },
        { 0x647D81, "YOKOTA INDUSTRIAL CO,.LTD" },
        { 0x647FDA, "TEKTELIC Communications Inc." },
        { 0x64808B, "VG Controls, Inc." },
        { 0x648099, "Intel Corporate" },
        { 0x648125, "Alphatron Marine BV" },
        { 0x648788, "Juniper Networks" },
        { 0x6487D7, "ADB Broadband Italia" },
        { 0x6488FF, "Sichuan Changhong Electric Ltd." },
        { 0x64899A, "LG Electronics (Mobile Communications)" },
        { 0x6489F1, "Samsung Electronics Co.,Ltd" },
        { 0x648D9E, "IVT Electronic Co.,Ltd" },
        { 0x6490C1, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x64956C, "LG Electronics" },
        { 0x649829, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x64995D, "LGE" },
        { 0x649968, "Elentec" },
        { 0x6499A0, "AG Elektronik AB" },
        { 0x649A08, "Shenzhen SuperElectron Technology Co.,LTD" },
        { 0x649A12, "P2 Mobile Technologies Limited" },
        { 0x649ABE, "Apple, Inc." },
        { 0x649B24, "V Technology Co., Ltd." },
        { 0x649C81, "Qualcomm Inc." },
        { 0x649C8E, "Texas Instruments" },
        { 0x649D99, "FS COM INC" },
        { 0x649EF3, "Cisco Systems, Inc" },
        { 0x649FF7, "Kone OYj" },
        { 0x64A0E7, "Cisco Systems, Inc" },
        { 0x64A200, "Xiaomi Communications Co Ltd" },
        { 0x64A232, "OOO Samlight" },
        { 0x64A28A, "Huawei Device Co., Ltd." },
        { 0x64A2F9, "OnePlus Technology (Shenzhen) Co., Ltd" },
        { 0x64A341, "Wonderlan (Beijing) Technology Co., Ltd." },
        { 0x64A3CB, "Apple, Inc." },
        { 0x64A5C3, "Apple, Inc." },
        { 0x64A651, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x64A68F, "Zhongshan Readboy Electronics Co.,Ltd" },
        { 0x64A769, "HTC Corporation" },
        { 0x64A7DD, "Avaya Inc" },
        { 0x64A837, "Juni Korea Co., Ltd" },
        { 0x64A965, "Linkflow Co., Ltd." },
        { 0x64AE0C, "Cisco Systems, Inc" },
        { 0x64AE88, "Polytec GmbH" },
        { 0x64AEF1, "Qingdao Hisense Electronics Co.,Ltd." },
        { 0x64B0A6, "Apple, Inc." },
        { 0x64B0E8, "Huawei Device Co., Ltd." },
        { 0x64B21D, "Chengdu Phycom Tech Co., Ltd." },
        { 0x64B310, "Samsung Electronics Co.,Ltd" },
        { 0x64B370, "PowerComm Solutions LLC" },
        { 0x64B473, "Xiaomi Communications Co Ltd" },
        { 0x64B5C6, "Nintendo Co.,Ltd" },
        { 0x64B623, "CCS Care Communication Solutions GmbH" },
        { 0x64B64A, "ViVOtech, Inc." },
        { 0x64B853, "Samsung Electronics Co.,Ltd" },
        { 0x64B9E8, "Apple, Inc." },
        { 0x64BABD, "SDJ Technologies, Inc." },
        { 0x64BC0C, "LG Electronics (Mobile Communications)" },
        { 0x64BC11, "CombiQ AB" },
        { 0x64BC58, "Intel Corporate" },
        { 0x64C2DE, "LG Electronics (Mobile Communications)" },
        { 0x64C354, "Avaya Inc" },
        { 0x64C3D6, "Juniper Networks" },
        { 0x64C5AA, "South African Broadcasting Corporation" },
        { 0x64C667, "Barnes&Noble" },
        { 0x64C6AF, "AXERRA Networks Ltd" },
        { 0x64C753, "Apple, Inc." },
        { 0x64C901, "INVENTEC Corporation" },
        { 0x64C944, "LARK Technologies, Inc" },
        { 0x64CB5D, "SIA TeleSet" },
        { 0x64CB9F, "TECNO MOBILE LIMITED" },
        { 0x64CBA3, "Pointmobile" },
        { 0x64CC22, "Arcadyan Corporation" },
        { 0x64CC2E, "Xiaomi Communications Co Ltd" },
        { 0x64CE6E, "Sierra Wireless" },
        { 0x64CFD9, "Texas Instruments" },
        { 0x64D02D, "Next Generation Integration (NGI)" },
        { 0x64D154, "Routerboard.com" },
        { 0x64D1A3, "Sitecom Europe BV" },
        { 0x64D241, "Keith & Koep GmbH" },
        { 0x64D2C4, "Apple, Inc." },
        { 0x64D4BD, "ALPS ELECTRIC CO., LTD." },
        { 0x64D4DA, "Intel Corporate" },
        { 0x64D814, "Cisco Systems, Inc" },
        { 0x64D912, "Solidica, Inc." },
        { 0x64D954, "Taicang T&W Electronics" },
        { 0x64D989, "Cisco Systems, Inc" },
        { 0x64DAA0, "Robert Bosch Smart Home GmbH" },
        { 0x64DB18, "OpenPattern" },
        { 0x64DB43, "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
        { 0x64DB81, "Syszone Co., Ltd." },
        { 0x64DB8B, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x64DBA0, "Select Comfort" },
        { 0x64DC01, "Static Systems Group PLC" },
        { 0x64DDE9, "Xiaomi Communications Co Ltd" },
        { 0x64DE1C, "Kingnetic Pte Ltd" },
        { 0x64DF10, "JingLue Semiconductor(SH) Ltd." },
        { 0x64DFE9, "ATEME" },
        { 0x64E161, "DEP Corp." },
        { 0x64E172, "Shenzhen Qihoo Intelligent Technology Co.,Ltd" },
        { 0x64E599, "EFM Networks" },
        { 0x64E625, "Woxu Wireless Co., Ltd" },
        { 0x64E682, "Apple, Inc." },
        { 0x64E7D8, "Samsung Electronics Co.,Ltd" },
        { 0x64E84F, "Serialway Communication Technology Co. Ltd" },
        { 0x64E881, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x64E892, "Morio Denki Co., Ltd." },
        { 0x64E8E6, "global moisture management system" },
        { 0x64E950, "Cisco Systems, Inc" },
        { 0x64EAC5, "SiboTech Automation Co., Ltd." },
        { 0x64EB8C, "Seiko Epson Corporation" },
        { 0x64ED57, "ARRIS Group, Inc." },
        { 0x64ED62, "WOORI SYSTEMS Co., Ltd" },
        { 0x64EEB7, "Netcore Technology Inc" },
        { 0x64F242, "Gerdes Aktiengesellschaft" },
        { 0x64F2FB, "Hangzhou Ezviz Software Co.,Ltd." },
        { 0x64F50E, "Kinion Technology Company Limited" },
        { 0x64F54E, "EM Microelectronic" },
        { 0x64F69D, "Cisco Systems, Inc" },
        { 0x64F6BB, "Fibocom Wireless Inc." },
        { 0x64F6F7, "Anhui Dynamic Power Co., Ltd." },
        { 0x64F81C, "Huawei Technologies Co., Ltd." },
        { 0x64F88A, "China Mobile IOT Company Limited" },
        { 0x64F947, "Senscomm Semiconductor Co., Ltd." },
        { 0x64F970, "Kenade Electronics Technology Co.,LTD." },
        { 0x64F987, "Avvasi Inc." },
        { 0x64F9C0, "ANALOG DEVICES" },
        { 0x64FB50, "RoomReady/Zdi, Inc." },
        { 0x64FB81, "IEEE Registration Authority" },
        { 0x64FB92, "PPC Broadband Inc." },
        { 0x64FC8C, "Zonar Systems" },
        { 0x64FF0A, "Wistron Neweb Corporation" },
        { 0x680235, "Konten Networks Inc." },
        { 0x6802B8, "Compal Broadband Networks, Inc." },
        { 0x680571, "Samsung Electronics Co.,Ltd" },
        { 0x6805CA, "Intel Corporate" },
        { 0x68070A, "TPVision Europe B.V" },
        { 0x680715, "Intel Corporate" },
        { 0x680927, "Apple, Inc." },
        { 0x680AD7, "Yancheng Kecheng Optoelectronic Technology Co., Ltd" },
        { 0x680AE2, "Silicon Laboratories" },
        { 0x68122D, "Special Instrument Development Co., Ltd." },
        { 0x681295, "Lupine Lighting Systems GmbH" },
        { 0x681324, "Huawei Device Co., Ltd." },
        { 0x681401, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x681590, "Sagemcom Broadband SAS" },
        { 0x6815D3, "Zaklady Elektroniki i Mechaniki Precyzyjnej R&G S.A." },
        { 0x681605, "Systems And Electronic Development FZCO" },
        { 0x681729, "Intel Corporate" },
        { 0x68193F, "Digital Airways" },
        { 0x6819AC, "Guangzhou Xianyou Intelligent Technogoly CO., LTD" },
        { 0x681AB2, "zte corporation" },
        { 0x681CA2, "Rosewill Inc." },
        { 0x681D64, "Sunwave Communications Co., Ltd" },
        { 0x681DEF, "Shenzhen CYX Technology Co., Ltd." },
        { 0x681E8B, "InfoSight Corporation" },
        { 0x681F40, "Blu Wireless Technology Ltd" },
        { 0x681FD8, "Siemens Industry, Inc." },
        { 0x68215F, "Edgecore Networks Corporation" },
        { 0x68234B, "Nihon Dengyo Kousaku" },
        { 0x68262A, "SICHUAN TIANYI COMHEART TELECOMCO., LTD" },
        { 0x682719, "Microchip Technology Inc." },
        { 0x682737, "Samsung Electronics Co.,Ltd" },
        { 0x6828BA, "Dejai" },
        { 0x6828F6, "Vubiq Networks, Inc." },
        { 0x6829DC, "Ficosa Electronics S.L.U." },
        { 0x682C7B, "Cisco Systems, Inc" },
        { 0x682DDC, "Wuhan Changjiang Electro-Communication Equipment CO.,LTD" },
        { 0x6831FE, "Teladin Co.,Ltd." },
        { 0x68332C, "KENSTEL NETWORKS LIMITED" },
        { 0x683489, "LEA Professional" },
        { 0x683563, "SHENZHEN LIOWN ELECTRONICS CO.,LTD." },
        { 0x6836B5, "DriveScale, Inc." },
        { 0x6837E9, "Amazon Technologies Inc." },
        { 0x683943, "ittim" },
        { 0x683A1E, "Cisco Meraki" },
        { 0x683B1E, "Countwise LTD" },
        { 0x683B78, "Cisco Systems, Inc" },
        { 0x683C7D, "Magic Intelligence Technology Limited" },
        { 0x683E02, "SIEMENS AG, Digital Factory, Motion Control System" },
        { 0x683E26, "Intel Corporate" },
        { 0x683E34, "MEIZU Technology Co., Ltd." },
        { 0x683EEC, "ERECA" },
        { 0x683F1E, "EFFECT Photonics B.V." },
        { 0x684352, "Bhuu Limited" },
        { 0x6843D7, "Agilecom Photonics Solutions Guangdong Limited" },
        { 0x684571, "Huawei Device Co., Ltd." },
        { 0x6845F1, "TOSHIBA CLIENT SOLUTIONS CO., LTD." },
        { 0x684749, "Texas Instruments" },
        { 0x684898, "Samsung Electronics Co.,Ltd" },
        { 0x6849B2, "CARLO GAVAZZI LTD" },
        { 0x684A76, "eero inc." },
        { 0x684AAE, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x684B88, "Galtronics Telemetry Inc." },
        { 0x684CA8, "Shenzhen Herotel Tech. Co., Ltd." },
        { 0x684F64, "Dell Inc." },
        { 0x6851B7, "PowerCloud Systems, Inc." },
        { 0x6852D6, "UGame Technology Co.,Ltd" },
        { 0x68536C, "SPnS Co.,Ltd" },
        { 0x685388, "P&S Technology" },
        { 0x68545A, "Intel Corporate" },
        { 0x6854C1, "ColorTokens, Inc." },
        { 0x6854ED, "Alcatel-Lucent" },
        { 0x6854F5, "enLighted Inc" },
        { 0x6854FD, "Amazon Technologies Inc." },
        { 0x68572D, "HANGZHOU AIXIANGJI TECHNOLOGY CO., LTD" },
        { 0x6858C5, "ZF TRW Automotive" },
        { 0x68597F, "Alcatel Lucent" },
        { 0x685ACF, "Samsung Electronics Co.,Ltd" },
        { 0x685B35, "Apple, Inc." },
        { 0x685B36, "POWERTECH INDUSTRIAL CO., LTD." },
        { 0x685D43, "Intel Corporate" },
        { 0x685E6B, "PowerRay Co., Ltd." },
        { 0x686350, "Hella India Automotive Pvt Ltd" },
        { 0x686359, "Advanced Digital Broadcast SA" },
        { 0x68644B, "Apple, Inc." },
        { 0x68692E, "Zycoo Co.,Ltd" },
        { 0x686975, "Angler Labs Inc" },
        { 0x6869CA, "Hitachi, Ltd." },
        { 0x6869F2, "ComAp s.r.o." },
        { 0x686DBC, "Hangzhou Hikvision Digital Technology Co.,Ltd." },
        { 0x686E23, "Wi3 Inc." },
        { 0x686E48, "Prophet Electronic Technology Corp.,Ltd" },
        { 0x687251, "Ubiquiti Networks Inc." },
        { 0x6872C3, "Samsung Electronics Co.,Ltd" },
        { 0x6872DC, "CETORY.TV Company Limited" },
        { 0x68764F, "Sony Mobile Communications Inc" },
        { 0x687848, "Westunitis Co., Ltd." },
        { 0x68784C, "Nortel Networks" },
        { 0x687912, "IEEE Registration Authority" },
        { 0x687924, "ELS-GmbH & Co. KG" },
        { 0x6879ED, "SHARP Corporation" },
        { 0x687CC8, "Measurement Systems S. de R.L." },
        { 0x687CD5, "Y Soft Corporation, a.s." },
        { 0x687D6B, "Samsung Electronics Co.,Ltd" },
        { 0x687DB4, "Cisco Systems, Inc" },
        { 0x687F74, "Cisco-Linksys, LLC" },
        { 0x6882F2, "grandcentrix GmbH" },
        { 0x68831A, "Pandora Mobility Corporation" },
        { 0x688470, "eSSys Co.,Ltd" },
        { 0x68847E, "FUJITSU LIMITED" },
        { 0x688540, "IGI Mobile, Inc." },
        { 0x68856A, "OuterLink Corporation" },
        { 0x6886A7, "Cisco Systems, Inc" },
        { 0x6886E7, "Orbotix, Inc." },
        { 0x68876B, "INQ Mobile Limited" },
        { 0x6888A1, "Universal Electronics, Inc." },
        { 0x688975, "nuoxc" },
        { 0x6889C1, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x688AB5, "EDP Servicos" },
        { 0x688AF0, "zte corporation" },
        { 0x688B0F, "China Mobile IOT Company Limited" },
        { 0x688DB6, "AETEK INC." },
        { 0x688F2E, "Hitron Technologies. Inc" },
        { 0x688F84, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x688FC9, "Zhuolian (Shenzhen) Communication Co., Ltd" },
        { 0x6891D0, "IEEE Registration Authority" },
        { 0x689234, "Ruckus Wireless" },
        { 0x689320, "New H3C Technologies Co., Ltd" },
        { 0x689361, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x689423, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x68967B, "Apple, Inc." },
        { 0x68974B, "Shenzhen Costar Electronics Co. Ltd." },
        { 0x6897E8, "Society of Motion Picture &amp; Television Engineers" },
        { 0x689861, "Beacon Inc" },
        { 0x6899CD, "Cisco Systems, Inc" },
        { 0x689A87, "Amazon Technologies Inc." },
        { 0x689AB7, "Atelier Vision Corporation" },
        { 0x689C5E, "AcSiP Technology Corp." },
        { 0x689C70, "Apple, Inc." },
        { 0x689CE2, "Cisco Systems, Inc" },
        { 0x689E0B, "Cisco Systems, Inc" },
        { 0x689E19, "Texas Instruments" },
        { 0x689FF0, "zte corporation" },
        { 0x68A03E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x68A0F6, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x68A1B7, "Honghao Mingchuan Technology (Beijing) CO.,Ltd." },
        { 0x68A378, "FREEBOX SAS" },
        { 0x68A3C4, "Liteon Technology Corporation" },
        { 0x68A40E, "BSH Hausgeräte GmbH" },
        { 0x68A47D, "Sun Cupid Technology (HK) LTD" },
        { 0x68A682, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x68A828, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x68A86D, "Apple, Inc." },
        { 0x68A8E1, "Wacom Co.,Ltd." },
        { 0x68AAD2, "DATECS LTD.," },
        { 0x68AB09, "Nokia" },
        { 0x68AB1E, "Apple, Inc." },
        { 0x68AB8A, "RF IDeas" },
        { 0x68AE20, "Apple, Inc." },
        { 0x68AF13, "Futura Mobility" },
        { 0x68AFFF, "Shanghai Cambricon Information Technology Co., Ltd." },
        { 0x68B094, "INESA ELECTRON CO.,LTD" },
        { 0x68B35E, "Shenzhen Neostra Technology Co.Ltd" },
        { 0x68B43A, "WaterFurnace International, Inc." },
        { 0x68B599, "Hewlett Packard" },
        { 0x68B6FC, "Hitron Technologies. Inc" },
        { 0x68B8D9, "Act KDE, Inc." },
        { 0x68B983, "b-plus GmbH" },
        { 0x68B9D3, "Shenzhen Trolink Technology CO, LTD" },
        { 0x68BC0C, "Cisco Systems, Inc" },
        { 0x68BDAB, "Cisco Systems, Inc" },
        { 0x68BFC4, "Samsung Electronics Co.,Ltd" },
        { 0x68C44D, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x68C63A, "Espressif Inc." },
        { 0x68C90B, "Texas Instruments" },
        { 0x68CA00, "Octopus Systems Limited" },
        { 0x68CAE4, "Cisco Systems, Inc" },
        { 0x68CC6E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x68CC9C, "Mine Site Technologies" },
        { 0x68CD0F, "U Tek Company Limited" },
        { 0x68CE4E, "L-3 Communications Infrared Products" },
        { 0x68D1BA, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x68D1FD, "Shenzhen Trimax Technology Co.,Ltd" },
        { 0x68D247, "Portalis LC" },
        { 0x68D482, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x68D48B, "Hailo Technologies Ltd." },
        { 0x68D6ED, "GooWi Wireless Technology Co., Limited" },
        { 0x68D79A, "Ubiquiti Networks Inc." },
        { 0x68D925, "ProSys Development Services" },
        { 0x68D93C, "Apple, Inc." },
        { 0x68DB54, "Phicomm (Shanghai) Co., Ltd." },
        { 0x68DB67, "Nantong Coship Electronics Co., Ltd." },
        { 0x68DB96, "OPWILL Technologies CO .,LTD" },
        { 0x68DBCA, "Apple, Inc." },
        { 0x68DBF5, "Amazon Technologies Inc." },
        { 0x68DCE8, "PacketStorm Communications" },
        { 0x68DD26, "Shanghai Focus Vision Security Technology Co.,Ltd" },
        { 0x68DFDD, "Xiaomi Communications Co Ltd" },
        { 0x68E166, "Private" },
        { 0x68E209, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x68E41F, "Unglaube Identech GmbH" },
        { 0x68E7C2, "Samsung Electronics Co.,Ltd" },
        { 0x68E8EB, "Linktel Technologies Co.,Ltd" },
        { 0x68EBAE, "Samsung Electronics Co.,Ltd" },
        { 0x68EBC5, "Angstrem Telecom" },
        { 0x68EC62, "YODO Technology Corp. Ltd." },
        { 0x68ECC5, "Intel Corporate" },
        { 0x68ED43, "BlackBerry RTS" },
        { 0x68EDA4, "Shenzhen Seavo Technology Co.,Ltd" },
        { 0x68EE96, "Cisco SPVTG" },
        { 0x68EF43, "Apple, Inc." },
        { 0x68EFBD, "Cisco Systems, Inc" },
        { 0x68F06D, "ALONG INDUSTRIAL CO., LIMITED" },
        { 0x68F0BC, "Shenzhen LiWiFi Technology Co., Ltd" },
        { 0x68F125, "Data Controls Inc." },
        { 0x68F728, "LCFC(HeFei) Electronics Technology co., ltd" },
        { 0x68F895, "Redflow Limited" },
        { 0x68F956, "Objetivos y Servicio de Valor Añadido" },
        { 0x68FB7E, "Apple, Inc." },
        { 0x68FB95, "Generalplus Technology Inc." },
        { 0x68FCB3, "Next Level Security Systems, Inc." },
        { 0x68FEDA, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x68FEF7, "Apple, Inc." },
        { 0x68FF7B, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x6C006B, "Samsung Electronics Co.,Ltd" },
        { 0x6C0273, "Shenzhen Jin Yun Video Equipment Co., Ltd." },
        { 0x6C0460, "RBH Access Technologies Inc." },
        { 0x6C05D5, "Ethertronics Inc" },
        { 0x6C06D6, "Huawei Device Co., Ltd." },
        { 0x6C090A, "GEMATICA SRL" },
        { 0x6C09BF, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x6C09D6, "Digiquest Electronics LTD" },
        { 0x6C0B84, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x6C0D34, "Nokia" },
        { 0x6C0DC4, "Beijing Xiaomi Electronics Co., Ltd." },
        { 0x6C0E0D, "Sony Mobile Communications Inc" },
        { 0x6C0EE6, "Chengdu Xiyida Electronic Technology Co,.Ltd" },
        { 0x6C0F6A, "JDC Tech Co., Ltd." },
        { 0x6C1414, "BUJEON ELECTRONICS Co,.Ltd" },
        { 0x6C146E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x6C14F7, "Erhardt+Leimer GmbH" },
        { 0x6C15F9, "Nautronix Limited" },
        { 0x6C160E, "ShotTracker" },
        { 0x6C1632, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x6C1811, "Decatur Electronics" },
        { 0x6C198F, "D-Link International" },
        { 0x6C19C0, "Apple, Inc." },
        { 0x6C1A75, "Huawei Device Co., Ltd." },
        { 0x6C1C71, "Zhejiang Dahua Technology Co., Ltd." },
        { 0x6C1DEB, "u-blox AG" },
        { 0x6C1E70, "Guangzhou YBDS IT Co.,Ltd" },
        { 0x6C1E90, "Hansol Technics Co., Ltd." },
        { 0x6C1ED7, "vivo Mobile Communication Co., Ltd." },
        { 0x6C2056, "Cisco Systems, Inc" },
        { 0x6C21A2, "AMPAK Technology, Inc." },
        { 0x6C22AB, "Ainsworth Game Technology" },
        { 0x6C23B9, "Sony Mobile Communications Inc" },
        { 0x6C23CB, "Wattty Corporation" },
        { 0x6C2483, "Microsoft Mobile Oy" },
        { 0x6C24A6, "vivo Mobile Communication Co., Ltd." },
        { 0x6C25B9, "BBK EDUCATIONAL ELECTRONICS CORP.,LTD." },
        { 0x6C2779, "Microsoft Mobile Oy" },
        { 0x6C2990, "WiZ Connected Lighting Company Limited" },
        { 0x6C2995, "Intel Corporate" },
        { 0x6C2ACB, "Paxton Access Ltd" },
        { 0x6C2B59, "Dell Inc." },
        { 0x6C2C06, "OOO NPP Systemotechnika-NN" },
        { 0x6C2CDC, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x6C2D24, "Zhen Shi Information Technology (Shanghai) Co., Ltd." },
        { 0x6C2E33, "Accelink Technologies Co.,Ltd." },
        { 0x6C2E72, "B&B EXPORTING LIMITED" },
        { 0x6C2E85, "Sagemcom Broadband SAS" },
        { 0x6C2F2C, "Samsung Electronics Co.,Ltd" },
        { 0x6C2F8A, "Samsung Electronics Co.,Ltd" },
        { 0x6C310E, "Cisco Systems, Inc" },
        { 0x6C32DE, "Indieon Technologies Pvt. Ltd." },
        { 0x6C33A9, "Magicjack LP" },
        { 0x6C3838, "Marking System Technology Co., Ltd." },
        { 0x6C3845, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x6C38A1, "Ubee Interactive Co., Limited" },
        { 0x6C391D, "Beijing ZhongHuaHun Network Information center" },
        { 0x6C3A84, "Shenzhen Aero-Startech. Co.Ltd" },
        { 0x6C3B6B, "Routerboard.com" },
        { 0x6C3BE5, "Hewlett Packard" },
        { 0x6C3C53, "SoundHawk Corp" },
        { 0x6C3E6D, "Apple, Inc." },
        { 0x6C3E9C, "KE Knestel Elektronik GmbH" },
        { 0x6C4008, "Apple, Inc." },
        { 0x6C40C6, "Nimbus Data, Inc." },
        { 0x6C410E, "Cisco Systems, Inc" },
        { 0x6C416A, "Cisco Systems, Inc" },
        { 0x6C42AB, "Subscriber Networks, Inc." },
        { 0x6C4418, "Zappware" },
        { 0x6C442A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x6C4598, "Antex Electronic Corp." },
        { 0x6C49C1, "o2ones Co., Ltd." },
        { 0x6C4A39, "BITA" },
        { 0x6C4A85, "Apple, Inc." },
        { 0x6C4B7F, "Vossloh-Schwabe Deutschland GmbH" },
        { 0x6C4B90, "LiteON" },
        { 0x6C4D51, "Shenzhen Ceres Technology Co., Ltd." },
        { 0x6C4D73, "Apple, Inc." },
        { 0x6C4E86, "Third Millennium Systems Ltd." },
        { 0x6C504D, "Cisco Systems, Inc" },
        { 0x6C54CD, "LAMPEX ELECTRONICS LIMITED" },
        { 0x6C55E8, "Technicolor CH USA Inc." },
        { 0x6C5697, "Amazon Technologies Inc." },
        { 0x6C5779, "Aclima, Inc." },
        { 0x6C5940, "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD." },
        { 0x6C5976, "Shanghai Tricheer Technology Co.,Ltd." },
        { 0x6C5A34, "Shenzhen Haitianxiong Electronic Co., Ltd." },
        { 0x6C5AB5, "TCL Technoly Electronics (Huizhou) Co., Ltd." },
        { 0x6C5C14, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x6C5C3D, "IEEE Registration Authority" },
        { 0x6C5CDE, "SunReports, Inc." },
        { 0x6C5D3A, "Microsoft Corporation" },
        { 0x6C5D63, "ShenZhen Rapoo Technology Co., Ltd." },
        { 0x6C5E3B, "Cisco Systems, Inc" },
        { 0x6C5E7A, "Ubiquitous Internet Telecom Co., Ltd" },
        { 0x6C5F1C, "Lenovo Mobile Communication Technology Ltd." },
        { 0x6C60EB, "ZHI YUAN ELECTRONICS CO., LIMITED" },
        { 0x6C6126, "Rinicom Holdings" },
        { 0x6C61F4, "SFR" },
        { 0x6C626D, "Micro-Star INT'L CO., LTD" },
        { 0x6C639C, "ARRIS Group, Inc." },
        { 0x6C641A, "Penguin Computing" },
        { 0x6C6A77, "Intel Corporate" },
        { 0x6C6CD3, "Cisco Systems, Inc" },
        { 0x6C6D09, "Kyowa Electronics Co.,Ltd." },
        { 0x6C6EFE, "Core Logic Inc." },
        { 0x6C6F18, "Stereotaxis, Inc." },
        { 0x6C7039, "Novar GmbH" },
        { 0x6C709F, "Apple, Inc." },
        { 0x6C710D, "Cisco Systems, Inc" },
        { 0x6C71BD, "EZELINK TELECOM" },
        { 0x6C71D9, "AzureWave Technology Inc." },
        { 0x6C7220, "D-Link International" },
        { 0x6C72E7, "Apple, Inc." },
        { 0x6C750D, "WiFiSONG" },
        { 0x6C7637, "Huawei Device Co., Ltd." },
        { 0x6C7660, "KYOCERA CORPORATION" },
        { 0x6C81FE, "Mitsuba Corporation" },
        { 0x6C8336, "Samsung Electronics Co.,Ltd" },
        { 0x6C8366, "Nanjing SAC Power Grid Automation Co., Ltd." },
        { 0x6C8686, "Technonia" },
        { 0x6C8814, "Intel Corporate" },
        { 0x6C8AEC, "Nantong Coship Electronics Co., Ltd." },
        { 0x6C8B2F, "zte corporation" },
        { 0x6C8BD3, "Cisco Systems, Inc" },
        { 0x6C8CDB, "Otus Technologies Ltd" },
        { 0x6C8D65, "Wireless Glue Networks, Inc." },
        { 0x6C8DC1, "Apple, Inc." },
        { 0x6C8FB5, "Microsoft Mobile Oy" },
        { 0x6C90B1, "SanLogic Inc" },
        { 0x6C92BF, "Inspur Electronic Information Industry Co.,Ltd." },
        { 0x6C9354, "Yaojin Technology (Shenzhen) Co., LTD." },
        { 0x6C94F8, "Apple, Inc." },
        { 0x6C9522, "Scalys" },
        { 0x6C96CF, "Apple, Inc." },
        { 0x6C98EB, "Riverbed Technology, Inc." },
        { 0x6C9961, "Sagemcom Broadband SAS" },
        { 0x6C9989, "Cisco Systems, Inc" },
        { 0x6C9AC9, "Valentine Research, Inc." },
        { 0x6C9B02, "Nokia Corporation" },
        { 0x6C9BC0, "Chemoptics Inc." },
        { 0x6C9CE9, "Nimble Storage" },
        { 0x6C9CED, "Cisco Systems, Inc" },
        { 0x6C9E7C, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x6CA0B4, "BSkyB Ltd" },
        { 0x6CA100, "Intel Corporate" },
        { 0x6CA4D1, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x6CA604, "ARRIS Group, Inc." },
        { 0x6CA682, "EDAM information & communications" },
        { 0x6CA75F, "zte corporation" },
        { 0x6CA780, "Nokia Corporation" },
        { 0x6CA7FA, "YOUNGBO ENGINEERING INC." },
        { 0x6CA849, "Avaya Inc" },
        { 0x6CA858, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x6CA906, "Telefield Ltd" },
        { 0x6CA928, "HMD Global Oy" },
        { 0x6CA936, "DisplayLink (UK) Ltd" },
        { 0x6CA96F, "TransPacket AS" },
        { 0x6CAAB3, "Ruckus Wireless" },
        { 0x6CAB05, "Cisco Systems, Inc" },
        { 0x6CAB31, "Apple, Inc." },
        { 0x6CAB4D, "Digital Payment Technologies" },
        { 0x6CAC60, "Venetex Corp" },
        { 0x6CAD3F, "Hubbell Building Automation, Inc." },
        { 0x6CADAD, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x6CADEF, "KZ Broadband Technologies, Ltd." },
        { 0x6CADF8, "AzureWave Technology Inc." },
        { 0x6CAE8B, "IBM Corporation" },
        { 0x6CAEF6, "eero inc." },
        { 0x6CAF15, "Webasto SE" },
        { 0x6CB0CE, "NETGEAR" },
        { 0x6CB227, "Sony Video & Sound Products Inc." },
        { 0x6CB2AE, "Cisco Systems, Inc" },
        { 0x6CB311, "Shenzhen Lianrui Electronics Co.,Ltd" },
        { 0x6CB350, "Anhui comhigher tech co.,ltd" },
        { 0x6CB4A7, "Landauer, Inc." },
        { 0x6CB56B, "HUMAX Co., Ltd." },
        { 0x6CB6CA, "DIVUS GmbH" },
        { 0x6CB749, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x6CB7F4, "Samsung Electronics Co.,Ltd" },
        { 0x6CB881, "zte corporation" },
        { 0x6CB9C5, "Delta Networks, Inc." },
        { 0x6CBAB8, "Sagemcom Broadband SAS" },
        { 0x6CBEE9, "Alcatel-Lucent IPD" },
        { 0x6CBFB5, "Noon Technology Co., Ltd" },
        { 0x6CC147, "Xiamen Hanin Electronic Technology Co., Ltd" },
        { 0x6CC1D2, "ARRIS Group, Inc." },
        { 0x6CC217, "Hewlett Packard" },
        { 0x6CC26B, "Apple, Inc." },
        { 0x6CC374, "Texas Instruments" },
        { 0x6CC4D5, "HMD Global Oy" },
        { 0x6CC63B, "Taicang T&W Electronics" },
        { 0x6CC7EC, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x6CCA08, "ARRIS Group, Inc." },
        { 0x6CCE44, "1MORE" },
        { 0x6CD032, "LG Electronics" },
        { 0x6CD146, "FRAMOS GmbH" },
        { 0x6CD1B0, "WING SING ELECTRONICS HONG KONG LIMITED" },
        { 0x6CD2BA, "zte corporation" },
        { 0x6CD68A, "LG Electronics (Mobile Communications)" },
        { 0x6CD71F, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x6CD94C, "vivo Mobile Communication Co., Ltd." },
        { 0x6CDC6A, "Promethean Limited" },
        { 0x6CDD30, "Cisco Systems, Inc" },
        { 0x6CDDBC, "Samsung Electronics Co.,Ltd" },
        { 0x6CDEA9, "Cisco Meraki" },
        { 0x6CDFFB, "IEEE Registration Authority" },
        { 0x6CE01E, "Modcam AB" },
        { 0x6CE0B0, "SOUND4" },
        { 0x6CE3B6, "Nera Telecommunications Ltd." },
        { 0x6CE4CE, "Villiger Security Solutions AG" },
        { 0x6CE4DA, "NEC Platforms, Ltd." },
        { 0x6CE5F7, "New H3C Technologies Co., Ltd" },
        { 0x6CE85C, "Apple, Inc." },
        { 0x6CE873, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x6CE874, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x6CE8C6, "Earda Technologies co Ltd" },
        { 0x6CE907, "Nokia Corporation" },
        { 0x6CE983, "Gastron Co., LTD." },
        { 0x6CEBB2, "Dongguan Sen DongLv Electronics Co.,Ltd" },
        { 0x6CEBB6, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x6CEC5A, "Hon Hai Precision Ind. CO.,Ltd." },
        { 0x6CECA1, "SHENZHEN CLOU ELECTRONICS CO. LTD." },
        { 0x6CECEB, "Texas Instruments" },
        { 0x6CED51, "NEXCONTROL Co.,Ltd" },
        { 0x6CEFC6, "SHENZHEN TWOWING TECHNOLOGIES CO.,LTD." },
        { 0x6CF049, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x6CF17E, "Zhejiang Uniview Technologies Co.,Ltd." },
        { 0x6CF373, "Samsung Electronics Co.,Ltd" },
        { 0x6CF37F, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x6CF5E8, "Mooredoll Inc." },
        { 0x6CF712, "Nokia" },
        { 0x6CF97C, "Nanoptix Inc." },
        { 0x6CF9D2, "CHENGDU POVODO ELECTRONIC TECHNOLOGY CO., LTD" },
        { 0x6CFA58, "Avaya Inc" },
        { 0x6CFA89, "Cisco Systems, Inc" },
        { 0x6CFAA7, "AMPAK Technology, Inc." },
        { 0x6CFDB9, "Proware Technologies Co Ltd." },
        { 0x6CFFBE, "MPB Communications Inc." },
        { 0x700136, "FATEK Automation Corporation" },
        { 0x7001B5, "Cisco Systems, Inc" },
        { 0x700258, "01DB-METRAVIB" },
        { 0x70037E, "Technicolor CH USA Inc." },
        { 0x70039F, "Espressif Inc." },
        { 0x700433, "California Things Inc." },
        { 0x700514, "LG Electronics (Mobile Communications)" },
        { 0x7006AC, "Eastcompeace Technology Co., Ltd" },
        { 0x700B01, "Sagemcom Broadband SAS" },
        { 0x700B4F, "Cisco Systems, Inc" },
        { 0x700BC0, "Dewav Technology Company" },
        { 0x700F6A, "Cisco Systems, Inc" },
        { 0x700FC7, "SHENZHEN IKINLOOP TECHNOLOGY CO.,LTD." },
        { 0x700FEC, "Poindus Systems Corp." },
        { 0x70105C, "Cisco Systems, Inc" },
        { 0x70106F, "Hewlett Packard Enterprise" },
        { 0x701124, "Apple, Inc." },
        { 0x7011AE, "Music Life LTD" },
        { 0x701404, "Limited Liability Company" },
        { 0x7014A6, "Apple, Inc." },
        { 0x70169F, "EtherCAT Technology Group" },
        { 0x70188B, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x7018A7, "Cisco Systems, Inc" },
        { 0x70192F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x701A04, "Liteon Technology Corporation" },
        { 0x701AED, "ADVAS CO., LTD." },
        { 0x701BFB, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x701CE7, "Intel Corporate" },
        { 0x701D08, "99IOT Shenzhen co.,ltd" },
        { 0x701D7F, "Comtech Technology Co., Ltd." },
        { 0x701DC4, "NorthStar Battery Company, LLC" },
        { 0x701E68, "Hanna Instruments, Inc." },
        { 0x701F3C, "Samsung Electronics Co.,Ltd" },
        { 0x701F53, "Cisco Systems, Inc" },
        { 0x702084, "Hon Hai Precision Ind. Co., Ltd." },
        { 0x702393, "fos4X GmbH" },
        { 0x702526, "Nokia" },
        { 0x702559, "CyberTAN Technology Inc." },
        { 0x702605, "SONY Visual Products Inc." },
        { 0x70288B, "Samsung Electronics Co.,Ltd" },
        { 0x702900, "Shenzhen ChipTrip Technology Co,Ltd" },
        { 0x702A7D, "EpSpot AB" },
        { 0x702AD5, "Samsung Electronics Co.,Ltd" },
        { 0x702B1D, "E-Domus International Limited" },
        { 0x702C09, "Nintendo Co.,Ltd" },
        { 0x702C1F, "Wisol" },
        { 0x702D84, "i4C Innovations" },
        { 0x702DD1, "Newings Communication CO., LTD." },
        { 0x702E22, "zte corporation" },
        { 0x702E80, "DIEHL Connectivity Solutions" },
        { 0x702ED9, "Guangzhou Shiyuan Electronics Co., Ltd." },
        { 0x702F35, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x702F4B, "Steelcase Inc." },
        { 0x702F97, "Aava Mobile Oy" },
        { 0x703018, "Avaya Inc" },
        { 0x70305D, "Ubiquoss Inc" },
        { 0x70305E, "Nanjing Zhongke Menglian Information Technology Co.,LTD" },
        { 0x703187, "ACX GmbH" },
        { 0x7032D5, "Athena Wireless Communications Inc" },
        { 0x703509, "Cisco Systems, Inc" },
        { 0x703811, "Siemens Mobility Limited" },
        { 0x7038B4, "Low Tech Solutions" },
        { 0x7038EE, "Avaya Inc" },
        { 0x703A0E, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x703A2D, "Shenzhen V-Link Technology CO., LTD." },
        { 0x703A51, "Xiaomi Communications Co Ltd" },
        { 0x703A73, "Shenzhen Sundray Technologies Company Limited" },
        { 0x703AA6, "New H3C Technologies Co., Ltd" },
        { 0x703ACB, "Google, Inc." },
        { 0x703AD8, "Shenzhen Afoundry Electronic Co., Ltd" },
        { 0x703C03, "RadiAnt Co.,Ltd" },
        { 0x703C39, "SEAWING Kft" },
        { 0x703C69, "Apple, Inc." },
        { 0x703D15, "Hangzhou H3C Technologies Co., Limited" },
        { 0x703EAC, "Apple, Inc." },
        { 0x7040FF, "Huawei Device Co., Ltd." },
        { 0x7041B7, "Edwards Lifesciences LLC" },
        { 0x70441C, "SHENZHEN KAIFA TECHNOLOGY CO.,LTD." },
        { 0x704642, "CHYNG HONG ELECTRONIC CO., LTD." },
        { 0x7047E9, "vivo Mobile Communication Co., Ltd." },
        { 0x70480F, "Apple, Inc." },
        { 0x7048F7, "Nintendo Co.,Ltd" },
        { 0x704A0E, "AMPAK Technology,Inc." },
        { 0x704AAE, "Xstream Flow (Pty) Ltd" },
        { 0x704AE4, "Rinstrum Pty Ltd" },
        { 0x704CA5, "Fortinet, Inc." },
        { 0x704CED, "TMRG, Inc." },
        { 0x704D7B, "ASUSTek COMPUTER INC." },
        { 0x704E01, "KWANGWON TECH CO., LTD." },
        { 0x704E66, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x704F08, "Shenzhen Huisheng Information Technology Co., Ltd." },
        { 0x704F57, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x704FB8, "ARRIS Group, Inc." },
        { 0x7050AF, "BSkyB Ltd" },
        { 0x7052C5, "Avaya Inc" },
        { 0x70533F, "Alfa Instrumentos Eletronicos Ltda." },
        { 0x705425, "ARRIS Group, Inc." },
        { 0x7054B4, "Vestel Elektronik San ve Tic. A.Ş." },
        { 0x7054D2, "PEGATRON CORPORATION" },
        { 0x7054F5, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7055F8, "Cerebras Systems Inc" },
        { 0x705681, "Apple, Inc." },
        { 0x7057BF, "New H3C Technologies Co., Ltd" },
        { 0x705812, "Panasonic Corporation AVC Networks Company" },
        { 0x705896, "InShow Technology" },
        { 0x705957, "Medallion Instrumentation Systems" },
        { 0x705986, "OOO TTV" },
        { 0x705A0F, "Hewlett Packard" },
        { 0x705A9E, "Technicolor CH USA Inc." },
        { 0x705AAC, "Samsung Electronics Co.,Ltd" },
        { 0x705AB6, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x705B2E, "M2Communication Inc." },
        { 0x705CAD, "Konami Gaming Inc" },
        { 0x705DCC, "EFM Networks" },
        { 0x705E55, "Realme Chongqing MobileTelecommunications Corp Ltd" },
        { 0x705EAA, "Action Target, Inc." },
        { 0x7060DE, "LaVision GmbH" },
        { 0x706173, "Calantec GmbH" },
        { 0x70617B, "Cisco Systems, Inc" },
        { 0x7061EE, "Sunwoda Electronic Co.,Ltd" },
        { 0x7062B8, "D-Link International" },
        { 0x706417, "ORBIS TECNOLOGIA ELECTRICA S.A." },
        { 0x706582, "Suzhou Hanming Technologies Co., Ltd." },
        { 0x7065A3, "Kandao lightforge Co., Ltd." },
        { 0x70661B, "Sonova AG" },
        { 0x706655, "AzureWave Technology Inc." },
        { 0x706879, "Saijo Denki International Co., Ltd." },
        { 0x70695A, "Cisco Systems, Inc" },
        { 0x706979, "IEEE Registration Authority" },
        { 0x706BB9, "Cisco Systems, Inc" },
        { 0x706D15, "Cisco Systems, Inc" },
        { 0x706DEC, "Wifi-soft LLC" },
        { 0x706E6D, "Cisco Systems, Inc" },
        { 0x706F81, "Private" },
        { 0x70700D, "Apple, Inc." },
        { 0x70704C, "Purple Communications, Inc" },
        { 0x70708B, "Cisco Systems, Inc" },
        { 0x7071B3, "Brain Corporation" },
        { 0x7071BC, "PEGATRON CORPORATION" },
        { 0x70720D, "Lenovo Mobile Communication Technology Ltd." },
        { 0x70723C, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7072CF, "EdgeCore Networks" },
        { 0x7073CB, "Apple, Inc." },
        { 0x707414, "Murata Manufacturing Co., Ltd." },
        { 0x707630, "ARRIS Group, Inc." },
        { 0x7076DD, "OxyGuard Internation A/S" },
        { 0x7076F0, "LevelOne Communications (India) Private Limited" },
        { 0x7076FF, "KERLINK" },
        { 0x707781, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x70788B, "vivo Mobile Communication Co., Ltd." },
        { 0x707938, "Wuxi Zhanrui Electronic Technology Co.,LTD" },
        { 0x707990, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7079B3, "Cisco Systems, Inc" },
        { 0x707BE8, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x707C18, "ADATA Technology Co., Ltd" },
        { 0x707C69, "Avaya Inc" },
        { 0x707D95, "Shenzhen City LinwlanTechnology Co. Ltd." },
        { 0x707DB9, "Cisco Systems, Inc" },
        { 0x707E43, "ARRIS Group, Inc." },
        { 0x707EDE, "NASTEC LTD." },
        { 0x708105, "Cisco Systems, Inc" },
        { 0x7081EB, "Apple, Inc." },
        { 0x70820E, "as electronics GmbH" },
        { 0x70828E, "OleumTech Corporation" },
        { 0x708540, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x7085C2, "ASRock Incorporation" },
        { 0x7085C6, "ARRIS Group, Inc." },
        { 0x7086C1, "Texas Instruments" },
        { 0x70879E, "Beken Corporation" },
        { 0x70884D, "JAPAN RADIO CO., LTD." },
        { 0x7089CC, "China Mobile Group Device Co.,Ltd." },
        { 0x708A09, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x708B78, "citygrow technology co., ltd" },
        { 0x708BCD, "ASUSTek COMPUTER INC." },
        { 0x708CB6, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x708CBB, "MIMODISPLAYKOREA" },
        { 0x708D09, "Nokia Corporation" },
        { 0x708F47, "vivo Mobile Communication Co., Ltd." },
        { 0x7090B7, "Huawei Device Co., Ltd." },
        { 0x70918F, "Weber-Stephen Products LLC" },
        { 0x7091F3, "Universal Electronics, Inc." },
        { 0x709383, "Intelligent Optical Network High Tech CO.,LTD." },
        { 0x7093F8, "Space Monkey, Inc." },
        { 0x709756, "Happyelectronics Co.,Ltd" },
        { 0x70991C, "Shenzhen Honesty Electronics Co.,Ltd" },
        { 0x709A0B, "Italian Institute of Technology" },
        { 0x709BA5, "Shenzhen Y&D Electronics Co.,LTD." },
        { 0x709BFC, "Bryton Inc." },
        { 0x709C8F, "Nero AG" },
        { 0x709CD1, "Intel Corporate" },
        { 0x709E29, "Sony Interactive Entertainment Inc." },
        { 0x709E86, "X6D Limited" },
        { 0x709F2D, "zte corporation" },
        { 0x709FA9, "TECNO MOBILE LIMITED" },
        { 0x70A191, "Trendsetter Medical, LLC" },
        { 0x70A2B3, "Apple, Inc." },
        { 0x70A41C, "Advanced Wireless Dynamics S.L." },
        { 0x70A66A, "Prox Dynamics AS" },
        { 0x70A84C, "MONAD., Inc." },
        { 0x70A8E3, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x70AAB2, "BlackBerry RTS" },
        { 0x70ACD7, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x70AD54, "Malvern Instruments Ltd" },
        { 0x70AF24, "TP Vision Belgium NV" },
        { 0x70AF25, "Nishiyama Industry Co.,LTD." },
        { 0x70AF6A, "SHENZHEN FENGLIAN TECHNOLOGY CO., LTD." },
        { 0x70B035, "Shenzhen Zowee Technology Co., Ltd" },
        { 0x70B08C, "Shenou Communication Equipment Co.,Ltd" },
        { 0x70B13D, "Samsung Electronics Co.,Ltd" },
        { 0x70B14E, "ARRIS Group, Inc." },
        { 0x70B265, "Hiltron s.r.l." },
        { 0x70B317, "Cisco Systems, Inc" },
        { 0x70B3D5, "IEEE Registration Authority" },
        { 0x70B599, "Embedded Technologies s.r.o." },
        { 0x70B5E8, "Dell Inc." },
        { 0x70B7AA, "vivo Mobile Communication Co., Ltd." },
        { 0x70B7E2, "Jiangsu Miter Technology Co.,Ltd." },
        { 0x70B921, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x70BAEF, "Hangzhou H3C Technologies Co., Limited" },
        { 0x70BBE9, "Xiaomi Communications Co Ltd" },
        { 0x70BC10, "Microsoft Corporation" },
        { 0x70BF3E, "Charles River Laboratories" },
        { 0x70BF92, "GN Audio A/S" },
        { 0x70C6AC, "Bosch Automotive Aftermarket" },
        { 0x70C76F, "INNO S" },
        { 0x70C7F2, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x70C833, "Wirepas Oy" },
        { 0x70C94E, "Liteon Technology Corporation" },
        { 0x70C9C6, "Cisco Systems, Inc" },
        { 0x70CA4D, "Shenzhen lnovance Technology Co.,Ltd." },
        { 0x70CA97, "Ruckus Wireless" },
        { 0x70CA9B, "Cisco Systems, Inc" },
        { 0x70CD60, "Apple, Inc." },
        { 0x70CD91, "TERACOM TELEMATICA S.A" },
        { 0x70CE8C, "Samsung Electronics Co.,Ltd" },
        { 0x70D081, "Beijing Netpower Technologies Inc." },
        { 0x70D313, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x70D379, "Cisco Systems, Inc" },
        { 0x70D4F2, "RIM" },
        { 0x70D57E, "Scalar Corporation" },
        { 0x70D5E7, "Wellcore Corporation" },
        { 0x70D6B6, "Metrum Technologies" },
        { 0x70D880, "Upos System sp. z o.o." },
        { 0x70D923, "vivo Mobile Communication Co., Ltd." },
        { 0x70D931, "Cambridge Industries(Group) Co.,Ltd." },
        { 0x70DA9C, "TECSEN" },
        { 0x70DB98, "Cisco Systems, Inc" },
        { 0x70DDA1, "Tellabs" },
        { 0x70DDA8, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x70DEE2, "Apple, Inc." },
        { 0x70DEF9, "FAI WAH INTERNATIONAL (HONG KONG) LIMITED" },
        { 0x70DF2F, "Cisco Systems, Inc" },
        { 0x70E027, "HONGYU COMMUNICATION TECHNOLOGY LIMITED" },
        { 0x70E139, "3view Ltd" },
        { 0x70E1FD, "FLEXTRONICS" },
        { 0x70E24C, "SAE IT-systems GmbH & Co. KG" },
        { 0x70E284, "Wistron Infocomm (Zhongshan) Corporation" },
        { 0x70E422, "Cisco Systems, Inc" },
        { 0x70E56E, "Texas Instruments" },
        { 0x70E72C, "Apple, Inc." },
        { 0x70E843, "Beijing C&W Optical Communication Technology Co.,Ltd." },
        { 0x70EA1A, "Cisco Systems, Inc" },
        { 0x70EA5A, "Apple, Inc." },
        { 0x70ECE4, "Apple, Inc." },
        { 0x70EE50, "Netatmo" },
        { 0x70EEA3, "Eoptolink Technology Inc. Ltd," },
        { 0x70EF00, "Apple, Inc." },
        { 0x70F087, "Apple, Inc." },
        { 0x70F096, "Cisco Systems, Inc" },
        { 0x70F11C, "Shenzhen Ogemray Technology Co.,Ltd" },
        { 0x70F176, "Data Modul AG" },
        { 0x70F196, "Actiontec Electronics, Inc" },
        { 0x70F1A1, "Liteon Technology Corporation" },
        { 0x70F1E5, "Xetawave LLC" },
        { 0x70F220, "Actiontec Electronics, Inc" },
        { 0x70F35A, "Cisco Systems, Inc" },
        { 0x70F395, "Universal Global Scientific Industrial Co., Ltd." },
        { 0x70F754, "AMPAK Technology,Inc." },
        { 0x70F82B, "DWnet Technologies(Suzhou) Corporation" },
        { 0x70F8E7, "IEEE Registration Authority" },
        { 0x70F927, "Samsung Electronics Co.,Ltd" },
        { 0x70F96D, "Hangzhou H3C Technologies Co., Limited" },
        { 0x70FC8C, "OneAccess SA" },
        { 0x70FC8F, "FREEBOX SAS" },
        { 0x70FD45, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x70FD46, "Samsung Electronics Co.,Ltd" },
        { 0x70FF5C, "Cheerzing Communication(Xiamen)Technology Co.,Ltd" },
        { 0x70FF76, "Texas Instruments" },
        { 0x7403BD, "BUFFALO.INC" },
        { 0x74042B, "Lenovo Mobile Communication (Wuhan) Company Limited" },
        { 0x7405A5, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x740ABC, "LightwaveRF Technology Ltd" },
        { 0x740AE1, "Huawei Device Co., Ltd." },
        { 0x740EDB, "Optowiz Co., Ltd" },
        { 0x7412B3, "CHONGQING FUGUI ELECTRONICS CO.,LTD." },
        { 0x7412BB, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x741489, "SRT Wireless" },
        { 0x7415E2, "Tri-Sen Systems Corporation" },
        { 0x741865, "Shanghai DareGlobal Technologies Co.,Ltd" },
        { 0x7419F8, "IEEE Registration Authority" },
        { 0x741AE0, "IEEE Registration Authority" },
        { 0x741BB2, "Apple, Inc." },
        { 0x741C27, "ITEL MOBILE LIMITED" },
        { 0x741E93, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x741F4A, "Hangzhou H3C Technologies Co., Limited" },
        { 0x741F79, "YOUNGKOOK ELECTRONICS CO.,LTD" },
        { 0x7422BB, "Huawei Device Co., Ltd." },
        { 0x742344, "Xiaomi Communications Co Ltd" },
        { 0x74258A, "Hangzhou H3C Technologies Co., Limited" },
        { 0x7426AC, "Cisco Systems, Inc" },
        { 0x74273C, "ChangYang Technology (Nanjing) Co., LTD" },
        { 0x7427EA, "Elitegroup Computer Systems Co.,Ltd." },
        { 0x742857, "Mayfield Robotics" },
        { 0x7429AF, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x742B0F, "Infinidat Ltd." },
        { 0x742B62, "FUJITSU LIMITED" },
        { 0x742D0A, "Norfolk Elektronik AG" },
        { 0x742EDB, "Perinet GmbH" },
        { 0x742EFC, "DirectPacket Research, Inc," },
        { 0x742F68, "AzureWave Technology Inc." },
        { 0x743170, "Arcadyan Technology Corporation" },
        { 0x743256, "NT-ware Systemprg GmbH" },
        { 0x743400, "MTG Co., Ltd." },
        { 0x7434AE, "this is engineering Inc." },
        { 0x74366D, "Vodafone Italia S.p.A." },
        { 0x74372F, "Tongfang Shenzhen Cloudcomputing Technology Co.,Ltd" },
        { 0x74373B, "UNINET Co.,Ltd." },
        { 0x743889, "ANNAX Anzeigesysteme GmbH" },
        { 0x7438B7, "CANON INC." },
        { 0x743A20, "New H3C Technologies Co., Ltd" },
        { 0x743A65, "NEC Corporation" },
        { 0x743AEF, "Kaonmedia CO., LTD." },
        { 0x743C18, "Taicang T&W Electronics" },
        { 0x743E2B, "Ruckus Wireless" },
        { 0x743ECB, "Gentrice tech" },
        { 0x7440BB, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x7440BE, "LG Innotek" },
        { 0x74427F, "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
        { 0x74428B, "Apple, Inc." },
        { 0x744401, "NETGEAR" },
        { 0x74452D, "Huawei Device Co., Ltd." },
        { 0x74458A, "Samsung Electronics Co.,Ltd" },
        { 0x7445CE, "CRESYN" },
        { 0x7446A0, "Hewlett Packard" },
        { 0x744AA4, "zte corporation" },
        { 0x744BE9, "EXPLORER HYPERTECH CO.,LTD" },
        { 0x744D28, "Routerboard.com" },
        { 0x744D79, "Arrive Systems Inc." },
        { 0x7451BA, "Xiaomi Communications Co Ltd" },
        { 0x745327, "COMMSEN CO., LIMITED" },
        { 0x745427, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x74547D, "Cisco SPVTG" },
        { 0x745612, "ARRIS Group, Inc." },
        { 0x745798, "TRUMPF Laser GmbH + Co. KG" },
        { 0x7458F3, "Amazon Technologies Inc." },
        { 0x745909, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x745933, "Danal Entertainment" },
        { 0x745AAA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x745BC5, "IEEE Registration Authority" },
        { 0x745C4B, "GN Audio A/S" },
        { 0x745C9F, "TCT mobile ltd" },
        { 0x745E1C, "PIONEER CORPORATION" },
        { 0x745F00, "Samsung Semiconductor Inc." },
        { 0x745F90, "LAM Technologies" },
        { 0x745FAE, "TSL PPL" },
        { 0x7460FA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x74614B, "Chongqing Huijiatong Information Technology Co., Ltd." },
        { 0x7463DF, "VTS GmbH" },
        { 0x74650C, "Apple, Inc." },
        { 0x7465D1, "Atlinks" },
        { 0x746630, "T:mi Ytti" },
        { 0x7467F7, "Extreme Networks, Inc." },
        { 0x746A3A, "Aperi Corporation" },
        { 0x746A89, "Rezolt Corporation" },
        { 0x746A8F, "VS Vision Systems GmbH" },
        { 0x746B82, "MOVEK" },
        { 0x746BAB, "GUANGDONG ENOK COMMUNICATION CO., LTD" },
        { 0x746EE4, "Asia Vital Components Co.,Ltd." },
        { 0x746F19, "ICARVISIONS (SHENZHEN) TECHNOLOGY CO., LTD." },
        { 0x746F3D, "Contec GmbH" },
        { 0x746FF7, "Wistron Neweb Corporation" },
        { 0x7470FD, "Intel Corporate" },
        { 0x74721E, "Edison Labs Inc." },
        { 0x7472B0, "Guangzhou Shiyuan Electronics Co., Ltd." },
        { 0x7472F2, "Chipsip Technology Co., Ltd." },
        { 0x74731D, "ifm electronic gmbh" },
        { 0x747336, "MICRODIGTAL Inc" },
        { 0x747548, "Amazon Technologies Inc." },
        { 0x747818, "Jurumani Solutions" },
        { 0x747827, "Dell Inc." },
        { 0x747A90, "Murata Manufacturing Co., Ltd." },
        { 0x747B7A, "ETH Inc." },
        { 0x747D24, "Phicomm (Shanghai) Co., Ltd." },
        { 0x747DB6, "Aliwei Communications, Inc" },
        { 0x747E1A, "Red Embedded Design Limited" },
        { 0x747E2D, "Beijing Thomson CITIC Digital Technology Co. LTD." },
        { 0x748114, "Apple, Inc." },
        { 0x74819A, "PT. Hartono Istana Teknologi" },
        { 0x7483C2, "Ubiquiti Networks Inc." },
        { 0x7483EF, "Arista Networks" },
        { 0x7484E1, "Dongguan Haoyuan Electronics Co.,Ltd" },
        { 0x74852A, "PEGATRON CORPORATION" },
        { 0x7485C4, "New H3C Technologies Co., Ltd" },
        { 0x74860B, "Cisco Systems, Inc" },
        { 0x74867A, "Dell Inc." },
        { 0x7487A9, "OCT Technology Co., Ltd." },
        { 0x7487BB, "Ciena Corporation" },
        { 0x74882A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x74888B, "ADB Broadband Italia" },
        { 0x7488BB, "Cisco Systems, Inc" },
        { 0x748A0D, "ARRIS Group, Inc." },
        { 0x748A28, "HMD Global Oy" },
        { 0x748A69, "Korea Image Technology Co., Ltd" },
        { 0x748B34, "Shanghai Smart System Technology Co., Ltd" },
        { 0x748D08, "Apple, Inc." },
        { 0x748E08, "Bestek Corp." },
        { 0x748EF8, "Brocade Communications Systems LLC" },
        { 0x748F1B, "MasterImage 3D" },
        { 0x748F3C, "Apple, Inc." },
        { 0x748F4D, "MEN Mikro Elektronik GmbH" },
        { 0x74901F, "Ragile Networks Inc." },
        { 0x749050, "Renesas Electronics Corporation" },
        { 0x74911A, "Ruckus Wireless" },
        { 0x7491BD, "Four systems Co.,Ltd." },
        { 0x7493A4, "Zebra Technologies Corp." },
        { 0x74943D, "AgJunction" },
        { 0x7495EC, "ALPS ELECTRIC CO., LTD." },
        { 0x749637, "Todaair Electronic Co., Ltd" },
        { 0x749781, "zte corporation" },
        { 0x749975, "IBM Corporation" },
        { 0x749BE8, "Hitron Technologies. Inc" },
        { 0x749C52, "Huizhou Desay SV Automotive Co., Ltd." },
        { 0x749CE3, "KodaCloud Canada, Inc" },
        { 0x749D79, "Sercomm Corporation." },
        { 0x749D8F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x749DDC, "2Wire Inc" },
        { 0x749EA5, "OHSUNG" },
        { 0x749EAF, "Apple, Inc." },
        { 0x749EF5, "Samsung Electronics Co.,Ltd" },
        { 0x74A02F, "Cisco Systems, Inc" },
        { 0x74A063, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x74A2E6, "Cisco Systems, Inc" },
        { 0x74A34A, "ZIMI CORPORATION" },
        { 0x74A4A7, "QRS Music Technologies, Inc." },
        { 0x74A4B5, "Powerleader Science and Technology Co. Ltd." },
        { 0x74A528, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x74A722, "LG Electronics (Mobile Communications)" },
        { 0x74A78E, "zte corporation" },
        { 0x74A7EA, "Amazon Technologies Inc." },
        { 0x74AB93, "Blink by Amazon" },
        { 0x74AC5F, "Qiku Internet Network Scientific (Shenzhen) Co., Ltd." },
        { 0x74ACB9, "Ubiquiti Networks Inc." },
        { 0x74ADB7, "China Mobile Group Device Co.,Ltd." },
        { 0x74AE76, "iNovo Broadband, Inc." },
        { 0x74B00C, "Network Video Technologies, Inc" },
        { 0x74B472, "CIESSE" },
        { 0x74B57E, "zte corporation" },
        { 0x74B587, "Apple, Inc." },
        { 0x74B6B6, "eero inc." },
        { 0x74B7B3, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x74B91E, "Nanjing Bestway Automation System Co., Ltd" },
        { 0x74B9EB, "JinQianMao Technology Co.,Ltd." },
        { 0x74BADB, "Longconn Electornics(shenzhen)Co.,Ltd" },
        { 0x74BBD3, "Shenzhen xeme Communication Co., Ltd." },
        { 0x74BE08, "ATEK Products, LLC" },
        { 0x74BFA1, "HYUNTECK" },
        { 0x74BFB7, "Nusoft Corporation" },
        { 0x74BFC0, "CANON INC." },
        { 0x74C14F, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x74C17D, "Infinix mobility limited" },
        { 0x74C246, "Amazon Technologies Inc." },
        { 0x74C330, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x74C621, "Zhejiang Hite Renewable Energy Co.,LTD" },
        { 0x74C63B, "AzureWave Technology Inc." },
        { 0x74C929, "Zhejiang Dahua Technology Co., Ltd." },
        { 0x74C99A, "Ericsson AB" },
        { 0x74C9A3, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x74CA25, "Calxeda, Inc." },
        { 0x74CBF3, "Lava international limited" },
        { 0x74CC39, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x74CD0C, "Smith Myers Communications Ltd." },
        { 0x74CE56, "Packet Force Technology Limited Company" },
        { 0x74D02B, "ASUSTek COMPUTER INC." },
        { 0x74D0DC, "Ericsson AB" },
        { 0x74D21D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x74D435, "GIGA-BYTE TECHNOLOGY CO.,LTD." },
        { 0x74D637, "Amazon Technologies Inc." },
        { 0x74D654, "GINT" },
        { 0x74D675, "WYMA Tecnologia" },
        { 0x74D6CB, "New H3C Technologies Co., Ltd" },
        { 0x74D6EA, "Texas Instruments" },
        { 0x74D7CA, "Panasonic Corporation Automotive" },
        { 0x74D83E, "Intel Corporate" },
        { 0x74D850, "Evrisko Systems" },
        { 0x74DA38, "Edimax Technology Co. Ltd." },
        { 0x74DA88, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x74DADA, "D-Link International" },
        { 0x74DAEA, "Texas Instruments" },
        { 0x74DBD1, "Ebay Inc" },
        { 0x74DE2B, "Liteon Technology Corporation" },
        { 0x74DFBF, "Liteon Technology Corporation" },
        { 0x74E06E, "Ergophone GmbH" },
        { 0x74E14A, "IEEE Registration Authority" },
        { 0x74E182, "Texas Instruments" },
        { 0x74E19A, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x74E1B6, "Apple, Inc." },
        { 0x74E277, "Vizmonet Pte Ltd" },
        { 0x74E28C, "Microsoft Corporation" },
        { 0x74E2F5, "Apple, Inc." },
        { 0x74E424, "APISTE CORPORATION" },
        { 0x74E50B, "Intel Corporate" },
        { 0x74E537, "RADSPIN" },
        { 0x74E543, "Liteon Technology Corporation" },
        { 0x74E5F9, "Intel Corporate" },
        { 0x74E60F, "TECNO MOBILE LIMITED" },
        { 0x74E6E2, "Dell Inc." },
        { 0x74E7C6, "ARRIS Group, Inc." },
        { 0x74EA3A, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x74EAC8, "New H3C Technologies Co., Ltd" },
        { 0x74EACB, "New H3C Technologies Co., Ltd" },
        { 0x74EAE8, "ARRIS Group, Inc." },
        { 0x74EB80, "Samsung Electronics Co.,Ltd" },
        { 0x74EC42, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x74ECB2, "Amazon Technologies Inc." },
        { 0x74ECF1, "Acumen" },
        { 0x74EE2A, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x74F06D, "AzureWave Technology Inc." },
        { 0x74F07D, "BnCOM Co.,Ltd" },
        { 0x74F102, "Beijing HCHCOM Technology Co., Ltd" },
        { 0x74F413, "Maxwell Forest" },
        { 0x74F612, "ARRIS Group, Inc." },
        { 0x74F61C, "HTC Corporation" },
        { 0x74F661, "Schneider Electric Fire & Security Oy" },
        { 0x74F726, "Neuron Robotics" },
        { 0x74F737, "KCE" },
        { 0x74F7F6, "Shanghai Sunmi Technology Co.,Ltd." },
        { 0x74F85D, "Berkeley Nucleonics Corp" },
        { 0x74F8DB, "IEEE Registration Authority" },
        { 0x74F91A, "Onface" },
        { 0x74F9CA, "Nintendo Co.,Ltd" },
        { 0x74FDA0, "Compupal (Group) Corporation" },
        { 0x74FE48, "ADVANTECH CO., LTD." },
        { 0x74FF4C, "Skyworth Digital Technology(Shenzhen) Co.,Ltd" },
        { 0x74FF7D, "Wren Sound Systems, LLC" },
        { 0x78009E, "Samsung Electronics Co.,Ltd" },
        { 0x78028F, "Adaptive Spectrum and Signal Alignment (ASSIA), Inc." },
        { 0x7802B1, "Cisco Systems, Inc" },
        { 0x7802B7, "ShenZhen Ultra Easy Technology CO.,LTD" },
        { 0x7802F8, "Xiaomi Communications Co Ltd" },
        { 0x780473, "Texas Instruments" },
        { 0x7804E3, "Huawei Device Co., Ltd." },
        { 0x780541, "Queclink Wireless Solutions Co., Ltd" },
        { 0x78055F, "Shenzhen WYC Technology Co., Ltd." },
        { 0x78058C, "mMax Communications, Inc." },
        { 0x780738, "Z.U.K. Elzab S.A." },
        { 0x780AC7, "Baofeng TV Co., Ltd." },
        { 0x780CB8, "Intel Corporate" },
        { 0x780CF0, "Cisco Systems, Inc" },
        { 0x780ED1, "TRUMPF Werkzeugmaschinen GmbH+Co.KG" },
        { 0x780F77, "HangZhou Gubei Electronics Technology Co.,Ltd" },
        { 0x781100, "Quantumsolution" },
        { 0x781185, "NBS Payment Solutions Inc." },
        { 0x7811DC, "XIAOMI Electronics,CO.,LTD" },
        { 0x7812B8, "ORANTEK LIMITED" },
        { 0x781735, "Nokia Shanghai Bell Co., Ltd." },
        { 0x7817BE, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x781881, "AzureWave Technology Inc." },
        { 0x78192E, "NASCENT Technology" },
        { 0x7819F7, "Juniper Networks" },
        { 0x781C5A, "SHARP Corporation" },
        { 0x781D4A, "zte corporation" },
        { 0x781DBA, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x781DFD, "Jabil Inc" },
        { 0x781F11, "RAB Lighting" },
        { 0x781FDB, "Samsung Electronics Co.,Ltd" },
        { 0x782079, "ID Tech" },
        { 0x78223D, "Affirmed Networks" },
        { 0x782327, "Samsung Electronics Co.,Ltd" },
        { 0x7823AE, "ARRIS Group, Inc." },
        { 0x7824AF, "ASUSTek COMPUTER INC." },
        { 0x782544, "Omnima Limited" },
        { 0x78257A, "LEO Innovation Lab" },
        { 0x7825AD, "Samsung Electronics Co.,Ltd" },
        { 0x7828CA, "Sonos, Inc." },
        { 0x7829ED, "ASKEY COMPUTER CORP" },
        { 0x782A79, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x782B46, "Intel Corporate" },
        { 0x782B64, "Bose Corporation" },
        { 0x782BCB, "Dell Inc." },
        { 0x782C29, "New H3C Technologies Co., Ltd" },
        { 0x782D7E, "TRENDnet, Inc." },
        { 0x782E56, "China Mobile Group Device Co.,Ltd." },
        { 0x782EEF, "Nokia Corporation" },
        { 0x782F17, "Xlab Co.,Ltd" },
        { 0x78303B, "Stephen Technologies Co.,Limited" },
        { 0x7830E1, "UltraClenz, LLC" },
        { 0x78312B, "zte corporation" },
        { 0x7831C1, "Apple, Inc." },
        { 0x78321B, "D-Link International" },
        { 0x78324F, "Millennium Group, Inc." },
        { 0x7835A0, "Zurn Industries LLC" },
        { 0x783607, "Cermate Technologies Inc." },
        { 0x783690, "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd" },
        { 0x7836CC, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x783A6C, "TECNO MOBILE LIMITED" },
        { 0x783A84, "Apple, Inc." },
        { 0x783CE3, "Kai-EE" },
        { 0x783D5B, "TELNET Redes Inteligentes S.A." },
        { 0x783E53, "BSkyB Ltd" },
        { 0x783F15, "EasySYNC Ltd." },
        { 0x7840E4, "Samsung Electronics Co.,Ltd" },
        { 0x784405, "FUJITU(HONG KONG) ELECTRONIC Co.,LTD." },
        { 0x784476, "Zioncom Electronics (Shenzhen) Ltd." },
        { 0x7844FD, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x784501, "Biamp Systems" },
        { 0x784558, "Ubiquiti Networks Inc." },
        { 0x784561, "CyberTAN Technology Inc." },
        { 0x7845B3, "Huawei Device Co., Ltd." },
        { 0x7845C4, "Dell Inc." },
        { 0x7846C4, "DAEHAP HYPER-TECH" },
        { 0x7846D4, "Samsung Electronics Co.,Ltd" },
        { 0x78471D, "Samsung Electronics Co.,Ltd" },
        { 0x7847E3, "SICHUAN TIANYI COMHEART TELECOM CO.,LTD" },
        { 0x784859, "Hewlett Packard" },
        { 0x78491D, "The Will-Burt Company" },
        { 0x784B08, "f.robotics acquisitions ltd" },
        { 0x784B87, "Murata Manufacturing Co., Ltd." },
        { 0x784F43, "Apple, Inc." },
        { 0x784F9B, "Juniper Networks" },
        { 0x78507C, "Juniper Networks" },
        { 0x78510C, "LiveU Ltd." },
        { 0x78521A, "Samsung Electronics Co.,Ltd" },
        { 0x78524A, "Ensenso GmbH" },
        { 0x785262, "Shenzhen Hojy Software Co., Ltd." },
        { 0x78530D, "Shenzhen Skyworth Digital Technology CO., Ltd" },
        { 0x785364, "SHIFT GmbH" },
        { 0x7853F2, "Roxton Systems Ltd." },
        { 0x78542E, "D-Link International" },
        { 0x785517, "SankyuElectronics" },
        { 0x785712, "Mobile Integration Workgroup" },
        { 0x785773, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x785860, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7858F3, "Vachen Co.,Ltd" },
        { 0x78593E, "RAFI GmbH & Co.KG" },
        { 0x78595E, "Samsung Electronics Co.,Ltd" },
        { 0x785968, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x785C28, "Prime Motion Inc." },
        { 0x785C72, "Hioso Technology Co., Ltd." },
        { 0x785DC8, "LG Electronics" },
        { 0x785F4C, "Argox Information Co., Ltd." },
        { 0x78617C, "MITSUMI ELECTRIC CO.,LTD." },
        { 0x786256, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7864E6, "Green Motive Technology Limited" },
        { 0x786559, "Sagemcom Broadband SAS" },
        { 0x7866AE, "ZTEC Instruments, Inc." },
        { 0x7867D7, "Apple, Inc." },
        { 0x7868F7, "YSTen Technology Co.,Ltd" },
        { 0x7869D4, "Shenyang Vibrotech Instruments Inc." },
        { 0x786A1F, "ARRIS Group, Inc." },
        { 0x786A89, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x786C1C, "Apple, Inc." },
        { 0x786D94, "Palo Alto Networks" },
        { 0x786DEB, "GE Lighting" },
        { 0x787052, "Welotec GmbH" },
        { 0x78719C, "ARRIS Group, Inc." },
        { 0x78725D, "Cisco Systems, Inc" },
        { 0x787B8A, "Apple, Inc." },
        { 0x787D48, "ITEL MOBILE LIMITED" },
        { 0x787D53, "Extreme Networks, Inc." },
        { 0x787DF3, "Sterlite Technologies Limited" },
        { 0x787E61, "Apple, Inc." },
        { 0x787F62, "GiK mbH" },
        { 0x788038, "FUNAI ELECTRIC CO., LTD." },
        { 0x788102, "Sercomm Corporation." },
        { 0x78818F, "Server Racks Australia Pty Ltd" },
        { 0x7881CE, "China Mobile Iot Limited company" },
        { 0x78843C, "Sony Corporation" },
        { 0x7884EE, "INDRA ESPACIO S.A." },
        { 0x7885F4, "Huawei Device Co., Ltd." },
        { 0x78870D, "Unifiedgateways India Private Limited" },
        { 0x78886D, "Apple, Inc." },
        { 0x78888A, "CDR Sp. z o.o. Sp. k." },
        { 0x788973, "CMC" },
        { 0x788A20, "Ubiquiti Networks Inc." },
        { 0x788B2A, "Zhen Shi Information Technology (Shanghai) Co., Ltd." },
        { 0x788B77, "Standar Telecom" },
        { 0x788C4D, "Indyme Solutions, LLC" },
        { 0x788C54, "Ping Communication" },
        { 0x788C77, "LEXMARK INTERNATIONAL, INC." },
        { 0x788DF7, "Hitron Technologies. Inc" },
        { 0x788E33, "Jiangsu SEUIC Technology Co.,Ltd" },
        { 0x7891E9, "Raisecom Technology CO.,LTD" },
        { 0x78923E, "Nokia Corporation" },
        { 0x78929C, "Intel Corporate" },
        { 0x7894B4, "Sercomm Corporation." },
        { 0x7894E8, "Radio Bridge" },
        { 0x7895EB, "ITEL MOBILE LIMITED" },
        { 0x789682, "zte corporation" },
        { 0x789684, "ARRIS Group, Inc." },
        { 0x7897C3, "DINGXIN INFORMATION TECHNOLOGY CO.,LTD" },
        { 0x7898E8, "D-Link International" },
        { 0x7898FD, "Q9 Networks Inc." },
        { 0x78995C, "Nationz Technologies Inc" },
        { 0x789966, "Musilab Electronics (DongGuan)Co.,Ltd." },
        { 0x78998F, "MEDILINE ITALIA SRL" },
        { 0x789C85, "August Home, Inc." },
        { 0x789CE7, "Shenzhen Aikede Technology Co., Ltd" },
        { 0x789ED0, "Samsung Electronics Co.,Ltd" },
        { 0x789F4C, "HOERBIGER Elektronik GmbH" },
        { 0x789F70, "Apple, Inc." },
        { 0x789F87, "Siemens AG I IA PP PRM" },
        { 0x78A051, "iiNet Labs Pty Ltd" },
        { 0x78A106, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x78A183, "Advidia" },
        { 0x78A2A0, "Nintendo Co., Ltd." },
        { 0x78A351, "SHENZHEN ZHIBOTONG ELECTRONICS CO.,LTD" },
        { 0x78A3E4, "Apple, Inc." },
        { 0x78A504, "Texas Instruments" },
        { 0x78A5DD, "Shenzhen Smarteye Digital Electronics Co., Ltd" },
        { 0x78A683, "Precidata" },
        { 0x78A6BD, "DAEYEON Control&Instrument Co,.Ltd" },
        { 0x78A6E1, "Brocade Communications Systems LLC" },
        { 0x78A714, "Amphenol" },
        { 0x78A7EB, "1MORE" },
        { 0x78A873, "Samsung Electronics Co.,Ltd" },
        { 0x78AA82, "New H3C Technologies Co., Ltd" },
        { 0x78AB60, "ABB Australia" },
        { 0x78ABBB, "Samsung Electronics Co.,Ltd" },
        { 0x78AC44, "Dell Inc." },
        { 0x78ACBF, "Igneous Systems" },
        { 0x78ACC0, "Hewlett Packard" },
        { 0x78AE0C, "Far South Networks" },
        { 0x78AF58, "GIMASI SA" },
        { 0x78AFE4, "Comau S.p.A" },
        { 0x78B213, "DWnet Technologies(Suzhou) Corporation" },
        { 0x78B28D, "Beijing Tengling Technology CO.Ltd" },
        { 0x78B3B9, "ShangHai sunup lighting CO.,LTD" },
        { 0x78B3CE, "Elo touch solutions" },
        { 0x78B46A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x78B5D2, "Ever Treasure Industrial Limited" },
        { 0x78B6C1, "AOBO Telecom Co.,Ltd" },
        { 0x78B6EC, "Scuf Gaming International LLC" },
        { 0x78B81A, "INTER SALES A/S" },
        { 0x78B84B, "SICHUAN TIANYI COMHEART TELECOMCO.,LTD" },
        { 0x78B8D6, "Zebra Technologies Inc." },
        { 0x78BAD0, "Shinybow Technology Co. Ltd." },
        { 0x78BAF9, "Cisco Systems, Inc" },
        { 0x78BC1A, "Cisco Systems, Inc" },
        { 0x78BDBC, "Samsung Electronics Co.,Ltd" },
        { 0x78BEB6, "Enhanced Vision" },
        { 0x78BEBD, "STULZ GmbH" },
        { 0x78C1A7, "zte corporation" },
        { 0x78C2C0, "IEEE Registration Authority" },
        { 0x78C313, "China Mobile Group Device Co.,Ltd." },
        { 0x78C3E9, "Samsung Electronics Co.,Ltd" },
        { 0x78C40E, "H&D Wireless" },
        { 0x78C4AB, "Shenzhen Runsil Technology Co.,Ltd" },
        { 0x78C5E5, "Texas Instruments" },
        { 0x78C5F8, "Huawei Device Co., Ltd." },
        { 0x78C6BB, "Innovasic, Inc." },
        { 0x78C881, "Sony Interactive Entertainment Inc." },
        { 0x78C95E, "Midmark RTLS" },
        { 0x78CA04, "Nokia Corporation" },
        { 0x78CA39, "Apple, Inc." },
        { 0x78CA5E, "ELNO" },
        { 0x78CA83, "IEEE Registration Authority" },
        { 0x78CB2C, "Join Digital, Inc." },
        { 0x78CB33, "DHC Software Co.,Ltd" },
        { 0x78CB68, "DAEHAP HYPER-TECH" },
        { 0x78CC2B, "SINEWY TECHNOLOGY CO., LTD" },
        { 0x78CD8E, "SMC Networks Inc" },
        { 0x78D004, "Neousys Technology Inc." },
        { 0x78D129, "Vicos" },
        { 0x78D162, "Apple, Inc." },
        { 0x78D294, "NETGEAR" },
        { 0x78D347, "Ericsson AB" },
        { 0x78D34F, "Pace-O-Matic, Inc." },
        { 0x78D38D, "HONGKONG YUNLINK TECHNOLOGY LIMITED" },
        { 0x78D5B5, "NAVIELEKTRO KY" },
        { 0x78D66F, "Aristocrat Technologies Australia Pty. Ltd." },
        { 0x78D6B2, "Toshiba" },
        { 0x78D6F0, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x78D71A, "Ciena Corporation" },
        { 0x78D752, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x78D75F, "Apple, Inc." },
        { 0x78D800, "IEEE Registration Authority" },
        { 0x78D99F, "NuCom HK Ltd." },
        { 0x78DA07, "Zhejiang Tmall Technology Co., Ltd." },
        { 0x78DA6E, "Cisco Systems, Inc" },
        { 0x78DAA2, "Cynosure Technologies Co.,Ltd" },
        { 0x78DAB3, "GBO Technology" },
        { 0x78DB2F, "Texas Instruments" },
        { 0x78DD08, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x78DD12, "Arcadyan Corporation" },
        { 0x78DDD6, "c-scape" },
        { 0x78DDD9, "Guangzhou Shiyuan Electronics Co., Ltd." },
        { 0x78DEE4, "Texas Instruments" },
        { 0x78E103, "Amazon Technologies Inc." },
        { 0x78E2BD, "Vodafone Automotive S.p.A." },
        { 0x78E3B5, "Hewlett Packard" },
        { 0x78E3DE, "Apple, Inc." },
        { 0x78E400, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x78E7D1, "Hewlett Packard" },
        { 0x78E8B6, "zte corporation" },
        { 0x78E980, "RainUs Co.,Ltd" },
        { 0x78EB14, "SHENZHEN FAST TECHNOLOGIES CO.,LTD" },
        { 0x78EB39, "Instituto Nacional de Tecnología Industrial" },
        { 0x78EC22, "Shanghai Qihui Telecom Technology Co., LTD" },
        { 0x78EC74, "Kyland-USA" },
        { 0x78EF4C, "Unetconvergence Co., Ltd." },
        { 0x78F09B, "Huawei Device Co., Ltd." },
        { 0x78F29E, "PEGATRON CORPORATION" },
        { 0x78F557, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x78F5E5, "BEGA Gantenbrink-Leuchten KG" },
        { 0x78F5FD, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x78F7BE, "Samsung Electronics Co.,Ltd" },
        { 0x78F7D0, "Silverbrook Research" },
        { 0x78F882, "LG Electronics (Mobile Communications)" },
        { 0x78F8B8, "Rako Controls Ltd" },
        { 0x78F944, "Private" },
        { 0x78F9B4, "Nokia" },
        { 0x78FC14, "Family Zone Cyber Safety Ltd" },
        { 0x78FD94, "Apple, Inc." },
        { 0x78FE3D, "Juniper Networks" },
        { 0x78FE41, "Socus networks" },
        { 0x78FEE2, "Shanghai Diveo Technology Co., Ltd" },
        { 0x78FF57, "Intel Corporate" },
        { 0x78FFCA, "TECNO MOBILE LIMITED" },
        { 0x7C010A, "Texas Instruments" },
        { 0x7C0187, "Curtis Instruments, Inc." },
        { 0x7C0191, "Apple, Inc." },
        { 0x7C02BC, "Hansung Electronics Co. LTD" },
        { 0x7C034C, "Sagemcom Broadband SAS" },
        { 0x7C035E, "Xiaomi Communications Co Ltd" },
        { 0x7C03AB, "Xiaomi Communications Co Ltd" },
        { 0x7C03C9, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x7C03D8, "Sagemcom Broadband SAS" },
        { 0x7C04D0, "Apple, Inc." },
        { 0x7C0507, "PEGATRON CORPORATION" },
        { 0x7C051E, "RAFAEL LTD." },
        { 0x7C0623, "Ultra Electronics Sonar System Division" },
        { 0x7C08D9, "Shanghai B-Star Technology Co" },
        { 0x7C092B, "Bekey A/S" },
        { 0x7C0A50, "J-MEX Inc." },
        { 0x7C0BC6, "Samsung Electronics Co.,Ltd" },
        { 0x7C0CF6, "Guangdong Huiwei High-tech Co., Ltd." },
        { 0x7C0ECE, "Cisco Systems, Inc" },
        { 0x7C1015, "Brilliant Home Technology, Inc." },
        { 0x7C11BE, "Apple, Inc." },
        { 0x7C11CB, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7C11CD, "QianTang Technology" },
        { 0x7C1476, "Damall Technologies SAS" },
        { 0x7C160D, "Saia-Burgess Controls AG" },
        { 0x7C18CD, "E-TRON Co.,Ltd." },
        { 0x7C1A03, "8Locations Co., Ltd." },
        { 0x7C1AFC, "Dalian Co-Edifice Video Technology Co., Ltd" },
        { 0x7C1C4E, "LG Innotek" },
        { 0x7C1C68, "Samsung Electronics Co.,Ltd" },
        { 0x7C1CF1, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7C1DD9, "Xiaomi Communications Co Ltd" },
        { 0x7C1E06, "New H3C Technologies Co., Ltd" },
        { 0x7C1E52, "Microsoft" },
        { 0x7C1EB3, "2N TELEKOMUNIKACE a.s." },
        { 0x7C2048, "KoamTac" },
        { 0x7C2064, "Alcatel-Lucent IPD" },
        { 0x7C210D, "Cisco Systems, Inc" },
        { 0x7C210E, "Cisco Systems, Inc" },
        { 0x7C21D8, "Shenzhen Think Will Communication Technology co., LTD." },
        { 0x7C2302, "Samsung Electronics Co.,Ltd" },
        { 0x7C240C, "Telechips, Inc." },
        { 0x7C2586, "Juniper Networks" },
        { 0x7C2587, "chaowifi.com" },
        { 0x7C25DA, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x7C2634, "ARRIS Group, Inc." },
        { 0x7C2664, "Sagemcom Broadband SAS" },
        { 0x7C2A31, "Intel Corporate" },
        { 0x7C2ADB, "Xiaomi Communications Co Ltd" },
        { 0x7C2BE1, "Shenzhen Ferex Electrical Co.,Ltd" },
        { 0x7C2CF3, "Secure Electrans Ltd" },
        { 0x7C2E0D, "Blackmagic Design" },
        { 0x7C2EBD, "Google, Inc." },
        { 0x7C2EDD, "Samsung Electronics Co.,Ltd" },
        { 0x7C2F80, "Gigaset Communications GmbH" },
        { 0x7C310E, "Cisco Systems, Inc" },
        { 0x7C336E, "MEG Electronics Inc." },
        { 0x7C3548, "Transcend Information" },
        { 0x7C3866, "Texas Instruments" },
        { 0x7C386C, "Real Time Logic" },
        { 0x7C38AD, "Samsung Electronics Co.,Ltd" },
        { 0x7C3920, "SSOMA SECURITY" },
        { 0x7C3953, "zte corporation" },
        { 0x7C3BD5, "Imago Group" },
        { 0x7C3CB6, "Shenzhen Homecare Technology Co.,Ltd." },
        { 0x7C3E9D, "PATECH" },
        { 0x7C41A2, "Nokia" },
        { 0x7C438F, "E-Band Communications Corp." },
        { 0x7C444C, "Entertainment Solutions, S.L." },
        { 0x7C4685, "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd." },
        { 0x7C477C, "IEEE Registration Authority" },
        { 0x7C48B2, "Vida Resources Lte Ltd" },
        { 0x7C49B9, "Plexus Manufacturing Sdn Bhd" },
        { 0x7C49EB, "XIAOMI Electronics,CO.,LTD" },
        { 0x7C4A82, "Portsmith LLC" },
        { 0x7C4AA8, "MindTree Wireless PVT Ltd" },
        { 0x7C4B78, "Red Sun Synthesis Pte Ltd" },
        { 0x7C4C58, "Scale Computing, Inc." },
        { 0x7C4CA5, "BSkyB Ltd" },
        { 0x7C4E09, "Shenzhen Skyworth Wireless Technology Co.,Ltd" },
        { 0x7C4F7D, "Sawwave" },
        { 0x7C4FB5, "Arcadyan Technology Corporation" },
        { 0x7C5049, "Apple, Inc." },
        { 0x7C50DA, "Private" },
        { 0x7C5189, "SG Wireless Limited" },
        { 0x7C5259, "Sichuan Jiuzhou Electronic Technology Co., Ltd." },
        { 0x7C534A, "Metamako" },
        { 0x7C55E7, "YSI, Inc." },
        { 0x7C573C, "Aruba, a Hewlett Packard Enterprise Company" },
        { 0x7C574E, "COBI GmbH" },
        { 0x7C5A1C, "Sophos Ltd" },
        { 0x7C5A67, "JNC Systems, Inc." },
        { 0x7C5CF8, "Intel Corporate" },
        { 0x7C604A, "Avelon" },
        { 0x7C6097, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7C6166, "Amazon Technologies Inc." },
        { 0x7C6193, "HTC Corporation" },
        { 0x7C6456, "Samsung Electronics Co.,Ltd" },
        { 0x7C669D, "Texas Instruments" },
        { 0x7C67A2, "Intel Corporate" },
        { 0x7C696B, "Atmosic Technologies" },
        { 0x7C69F6, "Cisco Systems, Inc" },
        { 0x7C6AB3, "IBC TECHNOLOGIES INC." },
        { 0x7C6AC3, "GatesAir, Inc" },
        { 0x7C6ADB, "SafeTone Technology Co.,Ltd" },
        { 0x7C6AF3, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x7C6B33, "Tenyu Tech Co. Ltd." },
        { 0x7C6B52, "Tigaro Wireless" },
        { 0x7C6B9C, "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD" },
        { 0x7C6BF7, "NTI co., ltd." },
        { 0x7C6C39, "PIXSYS SRL" },
        { 0x7C6C8F, "AMS NEVE LTD" },
        { 0x7C6D62, "Apple, Inc." },
        { 0x7C6DA6, "Superwave Group LLC" },
        { 0x7C6DF8, "Apple, Inc." },
        { 0x7C6F06, "Caterpillar Trimble Control Technologies" },
        { 0x7C6FF8, "ShenZhen ACTO Digital Video Technology Co.,Ltd." },
        { 0x7C70BC, "IEEE Registration Authority" },
        { 0x7C7176, "Wuxi iData Technology Company Ltd." },
        { 0x7C72E4, "Unikey Technologies" },
        { 0x7C738B, "Cocoon Alarm Ltd" },
        { 0x7C73EB, "Huawei Device Co., Ltd." },
        { 0x7C7630, "Shenzhen YOUHUA Technology Co., Ltd" },
        { 0x7C7635, "Intel Corporate" },
        { 0x7C7668, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7C7673, "ENMAS GmbH" },
        { 0x7C787E, "Samsung Electronics Co.,Ltd" },
        { 0x7C78B2, "Wyze Labs Inc" },
        { 0x7C79E8, "PayRange Inc." },
        { 0x7C7A53, "Phytrex Technology Corp." },
        { 0x7C7A91, "Intel Corporate" },
        { 0x7C7B8B, "Control Concepts, Inc." },
        { 0x7C7BE4, "Z'SEDAI KENKYUSHO CORPORATION" },
        { 0x7C7D3D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7C7D41, "Jinmuyu Electronics Co., Ltd." },
        { 0x7C822D, "Nortec" },
        { 0x7C8274, "Shenzhen Hikeen Technology CO.,LTD" },
        { 0x7C8306, "Glen Dimplex Nordic as" },
        { 0x7C8956, "Samsung Electronics Co.,Ltd" },
        { 0x7C89C1, "Palo Alto Networks" },
        { 0x7C8AE1, "COMPAL INFORMATION (KUNSHAN) CO., LTD." },
        { 0x7C8BB5, "Samsung Electronics Co.,Ltd" },
        { 0x7C8BCA, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x7C8D91, "Shanghai Hongzhuo Information Technology co.,LTD" },
        { 0x7C8EE4, "Texas Instruments" },
        { 0x7C8FDE, "DWnet Technologies(Suzhou) Corporation" },
        { 0x7C9122, "Samsung Electronics Co.,Ltd" },
        { 0x7C942A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7C94B2, "Philips Healthcare PCCI" },
        { 0x7C95B1, "Extreme Networks, Inc." },
        { 0x7C95F3, "Cisco Systems, Inc" },
        { 0x7C96D2, "Fihonest communication co.,Ltd" },
        { 0x7C9763, "Openmatics s.r.o." },
        { 0x7C9A1D, "Apple, Inc." },
        { 0x7C9A54, "Technicolor CH USA Inc." },
        { 0x7C9A9B, "VSE valencia smart energy" },
        { 0x7C9EBD, "Espressif Inc." },
        { 0x7CA15D, "GN ReSound A/S" },
        { 0x7CA177, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7CA1AE, "Apple, Inc." },
        { 0x7CA237, "King Slide Technology CO., LTD." },
        { 0x7CA23E, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7CA29B, "D.SignT GmbH & Co. KG" },
        { 0x7CA61D, "MHL, LLC" },
        { 0x7CA7B0, "SHENZHEN BILIAN ELECTRONIC CO.，LTD" },
        { 0x7CA96B, "Syrotech Networks. Ltd." },
        { 0x7CA97D, "Objenious" },
        { 0x7CAB25, "MESMO TECHNOLOGY INC." },
        { 0x7CAB60, "Apple, Inc." },
        { 0x7CACB2, "Bosch Software Innovations GmbH" },
        { 0x7CAD4F, "Cisco Systems, Inc" },
        { 0x7CAD74, "Cisco Systems, Inc" },
        { 0x7CB03E, "OSRAM GmbH" },
        { 0x7CB0C2, "Intel Corporate" },
        { 0x7CB15D, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7CB177, "Satelco AG" },
        { 0x7CB21B, "Cisco SPVTG" },
        { 0x7CB232, "Hui Zhou Gaoshengda Technology Co.,LTD" },
        { 0x7CB25C, "Acacia Communications" },
        { 0x7CB27D, "Intel Corporate" },
        { 0x7CB37B, "Qingdao Intelligent&Precise Electronics Co.,Ltd." },
        { 0x7CB542, "ACES Technology" },
        { 0x7CB59B, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x7CB733, "ASKEY COMPUTER CORP" },
        { 0x7CB77B, "Paradigm Electronics Inc" },
        { 0x7CB960, "Shanghai X-Cheng telecom LTD" },
        { 0x7CBACC, "IEEE Registration Authority" },
        { 0x7CBB6F, "Cosco Electronics Co., Ltd." },
        { 0x7CBB8A, "Nintendo Co., Ltd." },
        { 0x7CBC84, "IEEE Registration Authority" },
        { 0x7CBD06, "AE REFUsol" },
        { 0x7CBF88, "Mobilicom LTD" },
        { 0x7CBFB1, "ARRIS Group, Inc." },
        { 0x7CC294, "Beijing Xiaomi Mobile Software Co., Ltd" },
        { 0x7CC385, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7CC3A1, "Apple, Inc." },
        { 0x7CC4EF, "Devialet" },
        { 0x7CC537, "Apple, Inc." },
        { 0x7CC6C4, "Kolff Computer Supplies b.v." },
        { 0x7CC709, "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD." },
        { 0x7CC77E, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x7CC8AB, "Acro Associates, Inc." },
        { 0x7CC8D0, "TIANJIN YAAN TECHNOLOGY CO., LTD." },
        { 0x7CC8D7, "Damalisk" },
        { 0x7CC926, "Wuhan GreeNet Information Service Co.,Ltd." },
        { 0x7CC95A, "Dell EMC" },
        { 0x7CCB0D, "Antaira Technologies, LLC" },
        { 0x7CCBE2, "IEEE Registration Authority" },
        { 0x7CCC1F, "SICHUAN TIANYI COMHEART TELECOMCO.,LTD" },
        { 0x7CCCB8, "Intel Corporate" },
        { 0x7CCD11, "MS-Magnet" },
        { 0x7CCD3C, "Guangzhou Juzing Technology Co., Ltd" },
        { 0x7CCFCF, "Shanghai SEARI Intelligent System Co., Ltd" },
        { 0x7CD1C3, "Apple, Inc." },
        { 0x7CD30A, "INVENTEC CORPORATION" },
        { 0x7CD566, "Amazon Technologies Inc." },
        { 0x7CD661, "Xiaomi Communications Co Ltd" },
        { 0x7CD762, "Freestyle Technology Pty Ltd" },
        { 0x7CD844, "Enmotus Inc" },
        { 0x7CD95C, "Google, Inc." },
        { 0x7CD9A0, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x7CD9FE, "New Cosmos Electric Co., Ltd." },
        { 0x7CDA84, "Dongnian Networks Inc." },
        { 0x7CDB98, "ASKEY COMPUTER CORP" },
        { 0x7CDD11, "Chongqing MAS SCI&TECH.Co.,Ltd" },
        { 0x7CDD20, "IOXOS Technologies S.A." },
        { 0x7CDD76, "Suzhou Hanming Technologies Co., Ltd." },
        { 0x7CDD90, "Shenzhen Ogemray Technology Co., Ltd." },
        { 0x7CDDE9, "ATOM tech Inc." },
        { 0x7CDFA1, "Espressif Inc." },
        { 0x7CE044, "NEON Inc" },
        { 0x7CE1FF, "Computer Performance, Inc. DBA Digital Loggers, Inc." },
        { 0x7CE2CA, "Juniper Networks" },
        { 0x7CE4AA, "Private" },
        { 0x7CE524, "Quirky, Inc." },
        { 0x7CE56B, "ESEN Optoelectronics Technology Co.,Ltd." },
        { 0x7CE97C, "ITEL MOBILE LIMITED" },
        { 0x7CE9D3, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x7CEB7F, "Dmet Products Corp." },
        { 0x7CEBAE, "Ridgeline Instruments" },
        { 0x7CEBEA, "ASCT" },
        { 0x7CEC79, "Texas Instruments" },
        { 0x7CEC9B, "Fuzhou Teraway Information Technology Co.,Ltd" },
        { 0x7CED8D, "Microsoft" },
        { 0x7CEF18, "Creative Product Design Pty. Ltd." },
        { 0x7CEF61, "STR Elektronik Josef Schlechtinger GmbH" },
        { 0x7CEF8A, "Inhon International Ltd." },
        { 0x7CF05F, "Apple, Inc." },
        { 0x7CF098, "Bee Beans Technologies, Inc." },
        { 0x7CF0BA, "Linkwell Telesystems Pvt Ltd" },
        { 0x7CF2DD, "Vence Corp" },
        { 0x7CF31B, "LG Electronics (Mobile Communications)" },
        { 0x7CF429, "NUUO Inc." },
        { 0x7CF854, "Samsung Electronics Co.,Ltd" },
        { 0x7CF90E, "Samsung Electronics Co.,Ltd" },
        { 0x7CF95C, "U.I. Lapp GmbH" },
        { 0x7CF9A0, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x7CFADF, "Apple, Inc." },
        { 0x7CFC3C, "Visteon Corporation" },
        { 0x7CFD6B, "Xiaomi Communications Co Ltd" },
        { 0x7CFD82, "GUANGDONG GENIUS TECHNOLOGY CO., LTD." },
        { 0x7CFE28, "Salutron Inc." },
        { 0x7CFE4E, "Shenzhen Safe vision Technology Co.,LTD" },
        { 0x7CFE90, "Mellanox Technologies, Inc." },
        { 0x7CFF4D, "AVM Audiovisuelles Marketing und Computersysteme GmbH" },
        { 0x7CFF62, "Huizhou Super Electron Technology Co.,Ltd." },
        { 0x80000B, "Intel Corporate" },
        { 0x800010, "AT&T" },
        { 0x80006E, "Apple, Inc." },
        { 0x800184, "HTC Corporation" },
        { 0x80029C, "Gemtek Technology Co., Ltd." },
        { 0x8002DF, "ORA Inc." },
        { 0x800384, "Ruckus Wireless" },
        { 0x800588, "Ruijie Networks Co.,LTD" },
        { 0x8005DF, "Montage Technology Group Limited" },
        { 0x8007A2, "Esson Technology Inc." },
        { 0x800902, "Keysight Technologies, Inc." },
        { 0x800A06, "COMTEC co.,ltd" },
        { 0x800A80, "IEEE Registration Authority" },
        { 0x800B51, "Chengdu XGimi Technology Co.,Ltd" },
        { 0x800C67, "Apple, Inc." },
        { 0x800DD7, "Latticework, Inc" },
        { 0x800E24, "ForgetBox" },
        { 0x8012DF, "Shenzhen SuperElectron Technology Co.,Ltd." },
        { 0x801382, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x801440, "Sunlit System Technology Corp" },
        { 0x8014A8, "Guangzhou V-SOLUTION Electronic Technology Co., Ltd." },
        { 0x801605, "Vodafone Italia S.p.A." },
        { 0x801609, "Sleep Number" },
        { 0x8016B7, "Brunel University" },
        { 0x80177D, "Nortel Networks" },
        { 0x801844, "Dell Inc." },
        { 0x8018A7, "Samsung Electronics Co.,Ltd" },
        { 0x801934, "Intel Corporate" },
        { 0x801967, "Shanghai Reallytek Information Technology Co.,Ltd" },
        { 0x8019FE, "JianLing Technology CO., LTD" },
        { 0x801DAA, "Avaya Inc" },
        { 0x801F02, "Edimax Technology Co. Ltd." },
        { 0x801F12, "Microchip Technology Inc." },
        { 0x8020AF, "Trade FIDES, a.s." },
        { 0x8020DA, "Sagemcom Broadband SAS" },
        { 0x8020E1, "BVBA DPTechnics" },
        { 0x8020FD, "Samsung Electronics Co.,Ltd" },
        { 0x802275, "Beijing Beny Wave Technology Co Ltd" },
        { 0x8022A7, "NEC Platforms, Ltd." },
        { 0x802689, "D-Link International" },
        { 0x802994, "Technicolor CH USA Inc." },
        { 0x802AA8, "Ubiquiti Networks Inc." },
        { 0x802AFA, "Germaneers GmbH" },
        { 0x802BF9, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x802DBF, "Cisco Systems, Inc" },
        { 0x802DE1, "Solarbridge Technologies" },
        { 0x802E14, "azeti Networks AG" },
        { 0x802FDE, "Zurich Instruments AG" },
        { 0x803049, "Liteon Technology Corporation" },
        { 0x8030DC, "Texas Instruments" },
        { 0x8030E0, "Hewlett Packard Enterprise" },
        { 0x8031F0, "Samsung Electronics Co.,Ltd" },
        { 0x803253, "Intel Corporate" },
        { 0x803457, "OT Systems Limited" },
        { 0x8035C1, "Xiaomi Communications Co Ltd" },
        { 0x803773, "NETGEAR" },
        { 0x803896, "SHARP Corporation" },
        { 0x8038BC, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x8038FD, "LeapFrog Enterprises, Inc." },
        { 0x8039E5, "PATLITE CORPORATION" },
        { 0x803A0A, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x803A59, "AT&T" },
        { 0x803AF4, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x803B2A, "ABB Xiamen Low Voltage Equipment Co.,Ltd." },
        { 0x803B9A, "ghe-ces electronic ag" },
        { 0x803BF6, "LOOK EASY INTERNATIONAL LIMITED" },
        { 0x803E48, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x803F5D, "Winstars Technology Ltd" },
        { 0x803FD6, "bytes at work AG" },
        { 0x804126, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x80414E, "BBK EDUCATIONAL ELECTRONICS CORP.,LTD." },
        { 0x80427C, "Adolf Tedsen GmbH & Co. KG" },
        { 0x804731, "Packet Design, Inc." },
        { 0x8048A5, "SICHUAN TIANYI COMHEART TELECOMCO.,LTD" },
        { 0x804971, "Apple, Inc." },
        { 0x804A14, "Apple, Inc." },
        { 0x804B20, "Ventilation Control" },
        { 0x804E70, "Samsung Electronics Co.,Ltd" },
        { 0x804E81, "Samsung Electronics Co.,Ltd" },
        { 0x804F58, "ThinkEco, Inc." },
        { 0x80501B, "Nokia Corporation" },
        { 0x805067, "W & D TECHNOLOGY CORPORATION" },
        { 0x8050F6, "ITEL MOBILE LIMITED" },
        { 0x80546A, "SHENZHEN GONGJIN ELECTRONICS CO.,LT" },
        { 0x8056F2, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x805719, "Samsung Electronics Co.,Ltd" },
        { 0x8058C5, "NovaTec Kommunikationstechnik GmbH" },
        { 0x8058F8, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x8059FD, "Noviga" },
        { 0x805A04, "LG Electronics (Mobile Communications)" },
        { 0x805E0C, "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.,LTD." },
        { 0x805E4F, "FN-LINK TECHNOLOGY LIMITED" },
        { 0x805EC0, "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.,LTD." },
        { 0x805FC5, "Apple, Inc." },
        { 0x806007, "RIM" },
        { 0x8060B7, "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD." },
        { 0x80615F, "Beijing Sinead Technology Co., Ltd." },
        { 0x80618F, "Shenzhen sangfei consumer communications co.,ltd" },
        { 0x806459, "Nimbus Inc." },
        { 0x80647A, "Ola Sense Inc" },
        { 0x80656D, "Samsung Electronics Co.,Ltd" },
        { 0x8065E9, "BenQ Corporation" },
        { 0x806629, "Prescope Technologies CO.,LTD." },
        { 0x806933, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x806940, "LEXAR CO.,LIMITED" },
        { 0x806AB0, "Shenzhen TINNO Mobile Technology Corp." },
        { 0x806C1B, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x806C8B, "KAESER KOMPRESSOREN AG" },
        { 0x806CBC, "NET New Electronic Technology GmbH" },
        { 0x806D97, "Private" },
        { 0x806FB0, "Texas Instruments" },
        { 0x80711F, "Juniper Networks" },
        { 0x80717A, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x807215, "BSkyB Ltd" },
        { 0x80739F, "KYOCERA CORPORATION" },
        { 0x807459, "K's Co.,Ltd." },
        { 0x807484, "ALL Winner (Hong Kong) Limited" },
        { 0x80751F, "BSkyB Ltd" },
        { 0x807693, "Newag SA" },
        { 0x807871, "ASKEY COMPUTER CORP" },
        { 0x80795D, "Infinix mobility limited" },
        { 0x8079AE, "ShanDong Tecsunrise Co.,Ltd" },
        { 0x807A7F, "ABB Genway Xiamen Electrical Equipment CO., LTD" },
        { 0x807ABF, "HTC Corporation" },
        { 0x807B1E, "Corsair Memory, Inc." },
        { 0x807B3E, "Samsung Electronics Co.,Ltd" },
        { 0x807B85, "IEEE Registration Authority" },
        { 0x807D14, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x807D1B, "Neosystem Co. Ltd." },
        { 0x807D3A, "Espressif Inc." },
        { 0x807DE3, "Chongqing Sichuan Instrument Microcircuit Co.LTD." },
        { 0x807FF8, "Juniper Networks" },
        { 0x8081A5, "TONGQING COMMUNICATION EQUIPMENT (SHENZHEN) Co.,Ltd" },
        { 0x808223, "Apple, Inc." },
        { 0x808287, "ATCOM Technology Co.Ltd." },
        { 0x8084A9, "oshkosh Corporation" },
        { 0x808698, "Netronics Technologies Inc." },
        { 0x8086D9, "Samsung Electronics Co.,Ltd" },
        { 0x8086F2, "Intel Corporate" },
        { 0x808917, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x808A8B, "vivo Mobile Communication Co., Ltd." },
        { 0x808B5C, "Shenzhen Runhuicheng Technology Co., Ltd" },
        { 0x808C97, "Kaonmedia CO., LTD." },
        { 0x808DB7, "Hewlett Packard Enterprise" },
        { 0x808F1D, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x808FE8, "Intelbras" },
        { 0x80912A, "Lih Rong electronic Enterprise Co., Ltd." },
        { 0x809133, "AzureWave Technology Inc." },
        { 0x8091C0, "AgileMesh, Inc." },
        { 0x80929F, "Apple, Inc." },
        { 0x809393, "Xapt GmbH" },
        { 0x80946C, "TOKYO RADAR CORPORATION" },
        { 0x809621, "Lenovo" },
        { 0x8096B1, "ARRIS Group, Inc." },
        { 0x8096CA, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x80971B, "Altenergy Power System,Inc." },
        { 0x809B20, "Intel Corporate" },
        { 0x809F9B, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x809FAB, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x809FF5, "Samsung Electronics Co.,Ltd" },
        { 0x80A036, "Shanghai MXCHIP Information Technology Co., Ltd." },
        { 0x80A1AB, "Intellisis" },
        { 0x80A1D7, "Shanghai DareGlobal Technologies Co.,Ltd" },
        { 0x80A235, "Edgecore Networks Corporation" },
        { 0x80A589, "AzureWave Technology Inc." },
        { 0x80A796, "Neurotek LLC" },
        { 0x80A85D, "Osterhout Design Group" },
        { 0x80AAA4, "USAG" },
        { 0x80AC7C, "Sichuan AI-Link Technology Co., Ltd." },
        { 0x80ACAC, "Juniper Networks" },
        { 0x80AD16, "Xiaomi Communications Co Ltd" },
        { 0x80AD67, "Kasda Networks Inc" },
        { 0x80B03D, "Apple, Inc." },
        { 0x80B07B, "zte corporation" },
        { 0x80B219, "ELEKTRON TECHNOLOGY UK LIMITED" },
        { 0x80B234, "Technicolor CH USA Inc." },
        { 0x80B289, "Forworld Electronics Ltd." },
        { 0x80B32A, "UK Grid Solutions Ltd" },
        { 0x80B575, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x80B624, "IVS" },
        { 0x80B686, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x80B708, "Blue Danube Systems, Inc" },
        { 0x80B709, "Viptela, Inc" },
        { 0x80B95C, "ELFTECH Co., Ltd." },
        { 0x80BAAC, "TeleAdapt Ltd" },
        { 0x80BAE6, "Neets" },
        { 0x80BBEB, "Satmap Systems Ltd" },
        { 0x80BE05, "Apple, Inc." },
        { 0x80C16E, "Hewlett Packard" },
        { 0x80C548, "Shenzhen Zowee Technology Co.,Ltd" },
        { 0x80C5E6, "Microsoft Corporation" },
        { 0x80C5F2, "AzureWave Technology Inc." },
        { 0x80C63F, "Remec Broadband Wireless , LLC" },
        { 0x80C6AB, "Technicolor CH USA Inc." },
        { 0x80C6CA, "Endian s.r.l." },
        { 0x80C755, "Panasonic Appliances Company" },
        { 0x80C7C5, "Fiberhome Telecommunication Technologies Co.,LTD" },
        { 0x80C862, "Openpeak, Inc" },
        { 0x80C955, "Redpine Signals, Inc." },
        { 0x80CA4B, "SHENZHEN GONGJIN ELECTRONICS CO.,LTD" },
        { 0x80CC12, "Huawei Device Co., Ltd." },
        { 0x80CE62, "Hewlett Packard" },
        { 0x80CEB1, "Theissen Training Systems GmbH" },
        { 0x80CEB9, "Samsung Electronics Co.,Ltd" },
        { 0x80CF41, "Lenovo Mobile Communication Technology Ltd." },
        { 0x80CFA2, "Huawei Device Co., Ltd." },
        { 0x80D019, "Embed, Inc" },
        { 0x80D04A, "Technicolor CH USA Inc." },
        { 0x80D065, "CKS Corporation" },
        { 0x80D09B, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x80D160, "Integrated Device Technology (Malaysia) Sdn. Bhd." },
        { 0x80D18B, "Hangzhou I'converge Technology Co.,Ltd" },
        { 0x80D21D, "AzureWave Technology Inc." },
        { 0x80D336, "CERN" },
        { 0x80D433, "LzLabs GmbH" },
        { 0x80D4A5, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x80D605, "Apple, Inc." },
        { 0x80D733, "QSR Automations, Inc." },
        { 0x80DA13, "eero inc." },
        { 0x80DABC, "Megafone Limited" },
        { 0x80DB31, "Power Quotient International Co., Ltd." },
        { 0x80E01D, "Cisco Systems, Inc" },
        { 0x80E1BF, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x80E455, "New H3C Technologies Co., Ltd" },
        { 0x80E4DA, "IEEE Registration Authority" },
        { 0x80E540, "ARRIS Group, Inc." },
        { 0x80E650, "Apple, Inc." },
        { 0x80E82C, "Hewlett Packard" },
        { 0x80E86F, "Cisco Systems, Inc" },
        { 0x80EA07, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x80EA23, "Wistron Neweb Corporation" },
        { 0x80EA96, "Apple, Inc." },
        { 0x80EACA, "Dialog Semiconductor Hellas SA" },
        { 0x80EB77, "Wistron Corporation" },
        { 0x80ED2C, "Apple, Inc." },
        { 0x80EE25, "Shenzhen Skyworth Digital Technology CO., Ltd" },
        { 0x80EE73, "Shuttle Inc." },
        { 0x80F1F1, "Tech4home, Lda" },
        { 0x80F25E, "Kyynel" },
        { 0x80F503, "ARRIS Group, Inc." },
        { 0x80F593, "IRCO Sistemas de Telecomunicación S.A." },
        { 0x80F5B5, "Texas Instruments" },
        { 0x80F62E, "Hangzhou H3C Technologies Co., Limited" },
        { 0x80F8EB, "RayTight" },
        { 0x80FA5B, "CLEVO CO." },
        { 0x80FB06, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x80FBF0, "Quectel Wireless Solutions Co., Ltd." },
        { 0x80FD7A, "BLU Products Inc" },
        { 0x80FFA8, "UNIDIS" },
        { 0x84002D, "PEGATRON CORPORATION" },
        { 0x8400D2, "Sony Mobile Communications Inc" },
        { 0x8401A7, "Greyware Automation Products, Inc" },
        { 0x840283, "HUMAX Co., Ltd." },
        { 0x840328, "Juniper Networks" },
        { 0x8404D2, "Kirale Technologies SL" },
        { 0x840B2D, "SAMSUNG ELECTRO MECHANICS CO., LTD." },
        { 0x840B7C, "Hitron Technologies. Inc" },
        { 0x840D8E, "Espressif Inc." },
        { 0x840F45, "Shanghai GMT Digital Technologies Co., Ltd" },
        { 0x84100D, "Motorola Mobility LLC, a Lenovo Company" },
        { 0x84119E, "Samsung Electronics Co.,Ltd" },
        { 0x8411C2, "IEEE Registration Authority" },
        { 0x84139F, "zte corporation" },
        { 0x8416F9, "TP-LINK TECHNOLOGIES CO.,LTD." },
        { 0x841715, "GP Electronics (HK) Ltd." },
        { 0x841766, "WEIFANG GOERTEK ELECTRONICS CO.,LTD" },
        { 0x8417EF, "Technicolor CH USA Inc." },
        { 0x841826, "Osram GmbH" },
        { 0x84183A, "Ruckus Wireless" },
        { 0x841888, "Juniper Networks" },
        { 0x841B38, "Shenzhen Excelsecu Data Technology Co.,Ltd" },
        { 0x841B5E, "NETGEAR" },
        { 0x841B77, "Intel Corporate" },
        { 0x841C70, "zte corporation" },
        { 0x841E26, "KERNEL-I Co.,LTD" },
        { 0x842096, "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD." },
        { 0x842141, "Shenzhen Ginwave Technologies Ltd." },
        { 0x8421F1, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x84225E, "SHENZHEN TECHNEWCHIP TECHNOLOGY CO.,LTD." },
        { 0x84248D, "Zebra Technologies Inc" },
        { 0x842519, "Samsung Electronics" },
        { 0x84253F, "silex technology, Inc." },
        { 0x8425A4, "Tariox Limited" },
        { 0x8425DB, "Samsung Electronics Co.,Ltd" },
        { 0x842615, "ADB Broadband Italia" },
        { 0x84262B, "Nokia" },
        { 0x842690, "BEIJING THOUGHT SCIENCE CO.,LTD." },
        { 0x8427CE, "Corporation of the Presiding Bishop of The Church of Jesus Christ of Latter-day Saints" },
        { 0x84285A, "Saffron Solutions Inc" },
        { 0x842914, "EMPORIA TELECOM Produktions- und VertriebsgesmbH & Co KG" },
        { 0x842999, "Apple, Inc." },
        { 0x842AFD, "HP Inc." },
        { 0x842B2B, "Dell Inc." },
        { 0x842B50, "Huria Co.,Ltd." },
        { 0x842BBC, "Modelleisenbahn GmbH" },
        { 0x842C80, "Sichuan Changhong Electric Ltd." },
        { 0x842E14, "Silicon Laboratories" },
        { 0x842E27, "Samsung Electronics Co.,Ltd" },
        { 0x842F75, "Innokas Group" },
        { 0x843095, "Hon Hai Precision IND.CO.,LTD" },
        { 0x8430E5, "SkyHawke Technologies, LLC" },
        { 0x84326F, "GUANGZHOU AVA ELECTRONICS TECHNOLOGY CO.,LTD" },
        { 0x8432EA, "ANHUI WANZTEN P&T CO., LTD" },
        { 0x843497, "Hewlett Packard" },
        { 0x843611, "hyungseul publishing networks" },
        { 0x8437D5, "Samsung Electronics Co.,Ltd" },
        { 0x843835, "Apple, Inc." },
        { 0x843838, "SAMSUNG ELECTRO-MECHANICS(THAILAND)" },
        { 0x843A4B, "Intel Corporate" },
        { 0x843DC6, "Cisco Systems, Inc" },
        { 0x843E79, "Shenzhen Belon Technology CO.,LTD" },
        { 0x843E92, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x843F4E, "Tri-Tech Manufacturing, Inc." },
        { 0x844076, "Drivenets" },
        { 0x844167, "Apple, Inc." },
        { 0x844464, "ServerU Inc" },
        { 0x8446FE, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x844765, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x844823, "WOXTER TECHNOLOGY Co. Ltd" },
        { 0x844915, "vArmour Networks, Inc." },
        { 0x844BB7, "Beijing Sankuai Online Technology Co.,Ltd" },
        { 0x844BF5, "Hon Hai Precision Ind. Co.,Ltd." },
        { 0x844F03, "Ablelink Electronics Ltd" },
        { 0x84509A, "Easy Soft TV Co., Ltd" },
        { 0x845181, "Samsung Electronics Co.,Ltd" },
        { 0x8454DF, "Huawei Device Co., Ltd." },
        { 0x8455A5, "Samsung Electronics Co.,Ltd" },
        { 0x84569C, "Coho Data, Inc.," },
        { 0x845733, "Microsoft Corporation" },
        { 0x845787, "DVR C&C Co., Ltd." },
        { 0x845A81, "ffly4u" },
        { 0x845B12, "HUAWEI TECHNOLOGIES CO.,LTD" },
        { 0x845C93, "Chabrier Services" },
        { 0x845DD7, "Shenzhen Netcom Electronics Co.,Ltd" },
        { 0x846082, "Private" },
        { 0x8461A0, "ARRIS Group, Inc." },
        { 0x846223, "Shenzhen Coship Electronics Co., Ltd." },
        { 0x8462A6, "EuroCB (Phils), Inc." },
        { 0x8463D6, "Microsoft Corp