// oid.h
//
// this file autogenerated by ./oidc at May  8 2025 20:12:09
// you should edit the source file(s) instead of this file
//

#ifndef OID_H
#define OID_H

#include "../datum.h"
#include "../bytestring.h"
#include <unordered_map>
#include <string>
#include <stdint.h>

class oid {
public:

enum type : uint32_t {
	unknown = 0,
	ETSI_EV_CPS = 1,
	ETSI_EV_CPS_1_ = 2,
	user_id = 3,
	domain_component = 4,
	ISO = 5,
	A_Trust_EV_CPS = 6,
	China = 7,
	OSCCA = 8,
	GM_Standard_Committee = 9,
	Cryptographic_Algorithm = 10,
	Block_Cipher = 11,
	SM1_Block_Cipher = 12,
	SSF33_Block_Cipher = 13,
	SM4_Block_Cipher = 14,
	Stream_Cipher = 15,
	ZUC_Stream_Cipher = 16,
	Public_Key_Cryptography = 17,
	SM2_Elliptic_Curve_Cryptography = 18,
	SM2_1_Digital_Siganture_Algorithm = 19,
	SM2_2_Key_Exchange_Protocol = 20,
	SM2_3_Public_Key_Encryption = 21,
	SM9_Identity_Based_Cryptography = 22,
	SM9_1_Digital_Signature_Algorithm = 23,
	SM9_2_Key_Exchange_Protocol = 24,
	SM9_3_Public_Key_Encryptio = 25,
	Hash_Algorithm = 26,
	SM3_Hash_Algorithm = 27,
	SM3_Hash_Without_Key = 28,
	SM3_Hash_With_Key = 29,
	Digest_Signing = 30,
	SM2_Signing_with_SM3 = 31,
	RSA_Signing_with_SM3 = 32,
	Certificate_Authority = 33,
	Standard_Class = 34,
	Fundatation_Class = 35,
	Algorithm_Class = 36,
	ZUC_Standard = 37,
	SM4_Standard = 38,
	SM2_Standard = 39,
	SM3_Standard = 40,
	ID_Class = 41,
	Crypto_ID = 42,
	Operation_Modes = 43,
	Security_Mechanism = 44,
	SM2_Specificate = 45,
	SM2_Cryptographic_Message_Syntax = 46,
	Device_Class = 47,
	Service_Class = 48,
	Infrastructure = 49,
	Testing_Class = 50,
	Random_Testing_Class = 51,
	Management_Class = 52,
	SHECA_EV_CPS = 53,
	SECOM_Trust_Systems_EV_CPS = 54,
	id_tc26_gost3410_12_256 = 55,
	id_tc26_gost3410_12_512 = 56,
	id_tc26_digest_gost3411_12_256 = 57,
	id_tc26_digest_gost3411_12_512 = 58,
	id_tc26_signwithdigest_gost3410_12_256 = 59,
	id_tc26_signwithdigest_gost3410_12_512 = 60,
	ecdsa_with_SHA256_1_ = 61,
	id_dsa = 62,
	id_dsa_with_sha1 = 63,
	ansi_X9_62 = 64,
	id_fieldType = 65,
	prime_field = 66,
	characteristic_two_field = 67,
	id_characteristic_two_basis = 68,
	gnBasis = 69,
	tpBasis = 70,
	ppBasis = 71,
	id_publicKeyType = 72,
	id_ecPublicKey = 73,
	ellipticCurve = 74,
	c_TwoCurve = 75,
	c2pnb163v1 = 76,
	c2pnb163v2 = 77,
	c2pnb163v3 = 78,
	c2pnb176w1 = 79,
	c2tnb191v1 = 80,
	c2tnb191v2 = 81,
	c2tnb191v3 = 82,
	c2onb191v4 = 83,
	c2onb191v5 = 84,
	c2pnb208w1 = 85,
	c2tnb239v1 = 86,
	c2tnb239v2 = 87,
	c2tnb239v3 = 88,
	c2onb239v4 = 89,
	c2onb239v5 = 90,
	c2pnb272w1 = 91,
	c2pnb304w1 = 92,
	c2tnb359v1 = 93,
	c2pnb368w1 = 94,
	c2tnb431r1 = 95,
	primeCurve = 96,
	prime192v1 = 97,
	prime192v2 = 98,
	prime192v3 = 99,
	prime239v1 = 100,
	prime239v2 = 101,
	prime239v3 = 102,
	prime256v1 = 103,
	brainpoolP256t1 = 104,
	brainpoolP320r1 = 105,
	brainpoolP320t1 = 106,
	brainpoolP384r1 = 107,
	brainpoolP384t1 = 108,
	brainpoolP512r1 = 109,
	brainpoolP512t1 = 110,
	sect163r1 = 111,
	sect239k1 = 112,
	secp256k1 = 113,
	sect163r2_1_ = 114,
	sect283k1_1_ = 115,
	sect283r1_1_ = 116,
	sect233k1_1_ = 117,
	sect233r1_1_ = 118,
	secp192k1 = 119,
	secp224k1 = 120,
	secp224r1_1_ = 121,
	secp384r1_1_ = 122,
	secp521r1_1_ = 123,
	sect409k1_1_ = 124,
	sect409r1_1_ = 125,
	sect571k1_1_ = 126,
	sect571r1_1_ = 127,
	id_ecSigType = 128,
	ecdsa_with_SHA1 = 129,
	ecdsa_with_SHA224 = 130,
	ecdsa_with_SHA256 = 131,
	ecdsa_with_SHA384 = 132,
	ecdsa_with_SHA512 = 133,
	dhpublicnumber = 134,
	email_address = 135,
	rsaEncryption = 136,
	md2WithRSAEncryption = 137,
	md5WithRSAEncryption = 138,
	sha1WithRSAEncryption = 139,
	id_RSAES_OAEP = 140,
	id_mgf1 = 141,
	id_pSpecified = 142,
	id_RSASSA_PSS = 143,
	sha256WithRSAEncryption = 144,
	sha384WithRSAEncryption = 145,
	sha512WithRSAEncryption = 146,
	sha224WithRSAEncryption = 147,
	sha512_224WithRSAEncryption = 148,
	sha512_256WithRSAEncryption = 149,
	pkcs_9 = 150,
	pkcs_9_mo = 151,
	emailAddress = 152,
	pkcs_9_at_unstructuredName = 153,
	pkcs_9_at_contentType = 154,
	pkcs_9_at_messageDigest = 155,
	pkcs_9_at_signingTime = 156,
	pkcs_9_at_counterSignature = 157,
	pkcs_9_at_challengePassword = 158,
	pkcs_9_at_unstructuredAddress = 159,
	pkcs_9_at_extendedCertificateAttributes = 160,
	pkcs_9_at_signingDescription = 161,
	pkcs_9_at_extensionRequest = 162,
	pkcs_9_at_smimeCapabilities = 163,
	smime = 164,
	id_aa = 165,
	id_aa_cmc_unsignedData = 166,
	pkcs_9_at_friendlyName = 167,
	pkcs_9_at_localKeyId = 168,
	certTypes = 169,
	crlTypes = 170,
	pkcs_9_oc = 171,
	pkcs_9_oc_pkcsEntity = 172,
	pkcs_9_oc_naturalPerson = 173,
	pkcs_9_at = 174,
	pkcs_9_at_pkcs15Token = 175,
	pkcs_9_at_encryptedPrivateKeyInfo = 176,
	pkcs_9_at_randomNonce = 177,
	pkcs_9_at_sequenceNumber = 178,
	pkcs_9_at_pkcs7PDU = 179,
	pkcs_9_sx = 180,
	pkcs_9_sx_pkcs9String = 181,
	pkcs_9_sx_signingTime = 182,
	pkcs_9_mr = 183,
	pkcs_9_mr_caseIgnoreMatch = 184,
	pkcs_9_mr_signingTimeMatch = 185,
	md2 = 186,
	md5 = 187,
	id_md5 = 188,
	Cisco_ACT2_SUDI = 189,
	SPC_INDIRECT_DATA_OBJID = 190,
	SPC_SP_AGENCY_INFO_OBJID = 191,
	SPC_STATEMENT_TYPE_OBJID = 192,
	SPC_SP_OPUS_INFO_OBJID = 193,
	SPC_CERT_EXTENSIONS_OBJID = 194,
	SPC_PE_IMAGE_DATA_OBJID = 195,
	SPC_RAW_FILE_DATA_OBJID = 196,
	SPC_STRUCTURED_STORAGE_DATA_OBJID = 197,
	SPC_JAVA_CLASS_DATA_OBJID = 198,
	SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID = 199,
	SPC_COMMERCIAL_SP_KEY_PURPOSE_OBJID = 200,
	SPC_CAB_DATA_OBJID = 201,
	SPC_MINIMAL_CRITERIA_OBJID = 202,
	SPC_FINANCIAL_CRITERIA_OBJID = 203,
	SPC_LINK_OBJID = 204,
	SPC_HASH_INFO_OBJID = 205,
	SPC_SIPINFO_OBJID = 206,
	szOID_TRUSTED_CODESIGNING_CA_LIST = 207,
	szOID_TRUSTED_CLIENT_AUTH_CA_LIST = 208,
	szOID_TRUSTED_SERVER_AUTH_CA_LIST = 209,
	SPC_TIME_STAMP_REQUEST_OBJID = 210,
	OID_CTL = 211,
	szOID_SORTED_CTL = 212,
	szOID_NEXT_UPDATE_LOCATION = 213,
	szOID_KP_CTL_USAGE_SIGNING = 214,
	szOID_KP_TIME_STAMP_SIGNING = 215,
	szOID_SERVER_GATED_CRYPTO = 216,
	szOID_SERIALIZED = 217,
	szOID_EFS_CRYPTO = 218,
	szOID_EFS_RECOVERY = 219,
	szOID_WHQL_CRYPTO = 220,
	szOID_NT5_CRYPTO = 221,
	szOID_OEM_WHQL_CRYPTO = 222,
	szOID_EMBEDDED_NT_CRYPTO = 223,
	OID_ROOT_LIST_SIGNER = 224,
	szOID_KP_QUALIFIED_SUBORDINATION = 225,
	szOID_KP_KEY_RECOVERY = 226,
	szOID_KP_DOCUMENT_SIGNING = 227,
	szOID_KP_LIFETIME_SIGNING = 228,
	szOID_KP_MOBILE_DEVICE_SOFTWARE = 229,
	szOID_YESNO_TRUST_ATTR = 230,
	szOID_DRM = 231,
	szOID_DRM_INDIVIDUALIZATION = 232,
	szOID_LICENSES = 233,
	szOID_LICENSE_SERVER = 234,
	szOID_MICROSOFT_RDN_PREFIX = 235,
	szOID_KEYID_RDN = 236,
	szOID_REMOVE_CERTIFICATE = 237,
	szOID_CROSS_CERT_DIST_POINTS = 238,
	szOID_CMC_ADD_ATTRIBUTES = 239,
	szOID_CERT_PROP_ID_PREFIX = 240,
	OID_CERT_PROP_ID_METAEKUS = 241,
	CERT_FRIENDLY_NAME_PROP_ID = 242,
	OID_CERT_KEY_IDENTIFIER_PROP_ID = 243,
	OID_CERT_SUBJECT_NAME_MD5_HASH_PROP_ID = 244,
	CERT_ROOT_PROGRAM_CERT_POLICIES_PROP_ID = 245,
	OID_CERT_PROP_ID_PREFIX_98 = 246,
	OID_CERT_PROP_ID_PREFIX_105 = 247,
	szOID_ANY_APPLICATION_POLICY = 248,
	szOID_CATALOG_LIST = 249,
	szOID_CATALOG_LIST_MEMBER = 250,
	CAT_NAMEVALUE_OBJID = 251,
	CAT_MEMBERINFO_OBJID = 252,
	szOID_RENEWAL_CERTIFICATE = 253,
	szOID_ENROLLMENT_NAME_VALUE_PAIR = 254,
	szOID_ENROLLMENT_CSP_PROVIDER = 255,
	szOID_OS_VERSION = 256,
	szOID_MICROSOFT_Encryption_Key_Preference = 257,
	szOID_LOCAL_MACHINE_KEYSET = 258,
	szOID_PKIX_LICENSE_INFO = 259,
	szOID_PKIX_MANUFACTURER = 260,
	szOID_PKIX_MANUFACTURER_MS_SPECIFIC = 261,
	szOID_PKIX_HYDRA_CERT_VERSION = 262,
	szOID_PKIX_LICENSED_PRODUCT_INFO = 263,
	szOID_PKIX_MS_LICENSE_SERVER_INFO = 264,
	szOID_PKIS_PRODUCT_SPECIFIC_OID = 265,
	szOID_PKIS_TLSERVER_SPK_OID = 266,
	szOID_AUTO_ENROLL_CTL_USAGE = 267,
	szOID_ENROLL_CERTTYPE_EXTENSION = 268,
	szOID_ENROLLMENT_AGENT = 269,
	szOID_KP_SMARTCARD_LOGON = 270,
	szOID_NT_PRINCIPAL_NAME = 271,
	szOID_CERT_MANIFOLD = 272,
	szOID_CERTSRV_CA_VERSION = 273,
	szOID_CERTSRV_PREVIOUS_CERT_HASH = 274,
	szOID_CRL_VIRTUAL_BASE = 275,
	szOID_CRL_NEXT_PUBLISH = 276,
	szOID_KP_CA_EXCHANGE = 277,
	szOID_KP_KEY_RECOVERY_AGENT = 278,
	szOID_CERTIFICATE_TEMPLATE = 279,
	szOID_ENTERPRISE_OID_ROOT = 280,
	szOID_RDN_DUMMY_SIGNER = 281,
	szOID_APPLICATION_CERT_POLICIES = 282,
	szOID_APPLICATION_POLICY_MAPPINGS = 283,
	szOID_APPLICATION_POLICY_CONSTRAINTS = 284,
	szOID_ARCHIVED_KEY_ATTR = 285,
	szOID_CRL_SELF_CDP = 286,
	szOID_REQUIRE_CERT_CHAIN_POLICY = 287,
	szOID_ARCHIVED_KEY_CERT_HASH = 288,
	szOID_ISSUED_CERT_HASH = 289,
	szOID_DS_EMAIL_REPLICATION = 290,
	szOID_REQUEST_CLIENT_INFO = 291,
	szOID_ENCRYPTED_KEY_HASH = 292,
	szOID_CERTSRV_CROSSCA_VERSION = 293,
	szOID_NTDS_REPLICATION = 294,
	szOID_IIS_VIRTUAL_SERVER = 295,
	szOID_PRODUCT_UPDATE = 296,
	szOID_PEERNET_CERT_TYPE = 297,
	szOID_PEERNET_PEERNAME = 298,
	szOID_PEERNET_CLASSIFIER = 299,
	szOID_PEERNET_CERT_VERSION = 300,
	szOID_PEERNET_PNRP = 301,
	szOID_PEERNET_PNRP_ADDRESS = 302,
	szOID_PEERNET_PNRP_FLAGS = 303,
	szOID_PEERNET_PNRP_PAYLOAD = 304,
	szOID_PEERNET_PNRP_ID = 305,
	szOID_PEERNET_IDENTITY = 306,
	szOID_PEERNET_IDENTITY_FLAGS = 307,
	szOID_PEERNET_GROUPING = 308,
	szOID_PEERNET_GROUPING_PEERNAME = 309,
	szOID_PEERNET_GROUPING_FLAGS = 310,
	szOID_PEERNET_GROUPING_ROLES = 311,
	szOID_PEERNET_GROUPING_CLASSIFIERS = 312,
	OID_ROOT_PROGRAM_FLAGS_BITSTRING = 313,
	jurisdiction_of_incorporation_locality_name = 314,
	jurisdiction_of_incorporation_state_or_province_name = 315,
	jurisdiction_of_incorporation_country_name = 316,
	driveEncryption = 317,
	szOID_CAPICOM = 318,
	szOID_CAPICOM_VERSION = 319,
	szOID_CAPICOM_ATTRIBUTE = 320,
	szOID_CAPICOM_DOCUMENT_NAME = 321,
	szOID_CAPICOM_DOCUMENT_DESCRIPTION = 322,
	szOID_CAPICOM_ENCRYPTED_DATA = 323,
	szOID_CAPICOM_ENCRYPTED_CONTENT = 324,
	Network_Solutions__EV_CPS = 325,
	GlobalSign_EV_CPS = 326,
	D_TRUST_EV_CPS = 327,
	Verizon_Business_EV_CPS = 328,
	Comodo_Group_EV_CPS = 329,
	T_Systems_EV_CPS = 330,
	QuoVadis_EV_CPS = 331,
	id_ce_SignedCertificateTimestampList = 332,
	id_ad_ocsp_SignedCertificateTimestampList = 333,
	Firmaprofesional_EV_CPS = 334,
	GeoTrust_EV_CPS = 335,
	Izenpe_EV_CPS = 336,
	Camerfirma_EV_CPS_1_ = 337,
	Camerfirma_EV_CPS = 338,
	OpenTrust_DocuSign_France_EV_CPS = 339,
	StartCom_Certification_Authority_EV_CPS_1_ = 340,
	StartCom_Certification_Authority_EV_CPS = 341,
	AffirmTrust_EV_CPS = 342,
	AffirmTrust_EV_CPS_1_ = 343,
	AffirmTrust_EV_CPS_2_ = 344,
	AffirmTrust_EV_CPS_3_ = 345,
	WoSign_EV_CPS = 346,
	id_pkix = 347,
	id_pe = 348,
	id_pe_authorityInfoAccess = 349,
	id_pe_biometricInfo = 350,
	id_pe_qcStatements = 351,
	id_pe_subjectInfoAccess = 352,
	id_pe_logotype = 353,
	id_qt = 354,
	id_qt_cps = 355,
	id_qt_unotice = 356,
	id_kp = 357,
	id_kp_serverAuth = 358,
	id_kp_clientAuth = 359,
	id_kp_codeSigning = 360,
	id_kp_emailProtection = 361,
	id_kp_ipsecEndSystem = 362,
	id_kp_ipsecTunnel = 363,
	id_kp_ipsecUser = 364,
	id_kp_timeStamping = 365,
	id_kp_OCSPSigning = 366,
	id_kp_cmcCA = 367,
	id_kp_cmcRA = 368,
	id_alg_noSignature = 369,
	id_RSASSA_PSS_SHAKE128 = 370,
	id_RSASSA_PSS_SHAKE256 = 371,
	id_ecdsa_with_shake128 = 372,
	id_ecdsa_with_shake256 = 373,
	id_cmc = 374,
	id_cmc_statusInfo = 375,
	id_cmc_identification = 376,
	id_cmc_identityProof = 377,
	id_cmc_dataReturn = 378,
	id_cmc_transactionId = 379,
	id_cmc_senderNonce = 380,
	id_cmc_recipientNonce = 381,
	id_cmc_addExtensions = 382,
	id_cmc_encryptedPOP = 383,
	id_cmc_decryptedPOP = 384,
	id_cmc_lraPOPWitness = 385,
	id_cmc_getCert = 386,
	id_cmc_getCRL = 387,
	id_cmc_revokeRequest = 388,
	id_cmc_regInfo = 389,
	id_cmc_responseInfo = 390,
	id_cmc_queryPending = 391,
	id_cmc_popLinkRandom = 392,
	id_cmc_popLinkWitness = 393,
	id_cmc_confirmCertAcceptance = 394,
	id_cmc_statusInfoV2 = 395,
	id_cmc_trustedAnchors = 396,
	id_cmc_authData = 397,
	id_cmc_batchRequests = 398,
	id_cmc_batchResponses = 399,
	id_cmc_publishCert = 400,
	id_cmc_modCertTemplate = 401,
	id_cmc_controlProcessed = 402,
	id_cmc_popLinkWitnessV2 = 403,
	id_cmc_identityProofV2 = 404,
	id_cmc_raIdentityWitness = 405,
	id_cmc_changeSubjectName = 406,
	id_cmc_responseBody = 407,
	id_on = 408,
	id_on_SmtpUTF8Mailbox = 409,
	ietf_at = 410,
	pkcs_9_at_dateOfBirth = 411,
	pkcs_9_at_placeOfBirth = 412,
	pkcs_9_at_gender = 413,
	pkcs_9_at_countryOfCitizenship = 414,
	pkcs_9_at_countryOfResidence = 415,
	id_qcs = 416,
	id_qcs_pkixQCSyntax_v1 = 417,
	id_qcs_pkixQCSyntax_v2 = 418,
	id_cct = 419,
	id_cct_PKIData = 420,
	id_cct_PKIResponse = 421,
	id_logo = 422,
	id_logo_loyalty = 423,
	id_logo_background = 424,
	id_ad = 425,
	id_ad_ocsp = 426,
	id_pkix_ocsp_basic = 427,
	id_pkix_ocsp_nonce = 428,
	id_pkix_ocsp_crl = 429,
	id_pkix_ocsp_response = 430,
	id_pkix_ocsp_nocheck = 431,
	id_pkix_ocsp_archive_cutoff = 432,
	id_pkix_ocsp_service_locator = 433,
	id_pkix_ocsp_pref_sig_algs = 434,
	id_pkix_ocsp_extended_revoke = 435,
	id_ad_caIssuers = 436,
	id_ad_timeStamping = 437,
	id_ad_caRepository = 438,
	id_ad_cmc = 439,
	id_sha_with_rsa_signature = 440,
	id_sha1 = 441,
	sha_1WithRSAEncryption = 442,
	ecStdCurvesAndGeneration = 443,
	ellipticCurve_1_ = 444,
	id_edwards_curve_algs = 445,
	id_X25519 = 446,
	id_X448 = 447,
	id_Ed25519 = 448,
	id_Ed448 = 449,
	certicom_arc = 450,
	ellipticCurve_2_ = 451,
	sect163k1 = 452,
	sect163r2 = 453,
	sect283k1 = 454,
	sect283r1 = 455,
	sect233k1 = 456,
	sect233r1 = 457,
	secp224r1 = 458,
	secp384r1 = 459,
	secp521r1 = 460,
	sect409k1 = 461,
	sect409r1 = 462,
	sect571k1 = 463,
	sect571r1 = 464,
	id_ecDH = 465,
	id_ecMQV = 466,
	Actalis_EV_CPS = 467,
	holdInstruction = 468,
	id_holdinstruction_none = 469,
	id_holdinstruction_callissuer = 470,
	id_holdinstruction_reject = 471,
	id_at = 472,
	common_name = 473,
	surname = 474,
	serial_number = 475,
	country_name = 476,
	locality_name = 477,
	state_or_province_name = 478,
	street = 479,
	organization_name = 480,
	organizational_unit_name = 481,
	title = 482,
	description = 483,
	search_guide = 484,
	business_category = 485,
	postal_address = 486,
	postal_code = 487,
	post_office_box = 488,
	physical_delivery_office_name = 489,
	telephone_number = 490,
	telex_number = 491,
	teletex_terminal_identifier = 492,
	facsimile_telephone_number = 493,
	x121_address = 494,
	international_isdn_number = 495,
	registered_address = 496,
	destination_indicator = 497,
	preferred_delivery_method = 498,
	member = 499,
	owner = 500,
	role_occupant = 501,
	see_also = 502,
	user_password = 503,
	name = 504,
	given_name = 505,
	initials = 506,
	generation_qualifier = 507,
	x500_unique_identifier = 508,
	dn_qualifier = 509,
	enhanced_search_guide = 510,
	distinguished_name = 511,
	unique_member = 512,
	house_identifier = 513,
	pseudonym = 514,
	id_ce = 515,
	DeprecatedAuthorityKeyIdentifier = 516,
	DeprecatedSubjectAltName = 517,
	id_ce_subjectDirectoryAttributes = 518,
	id_ce_subjectKeyIdentifier = 519,
	key_usage = 520,
	id_ce_privateKeyUsagePeriod = 521,
	subject_alt_name = 522,
	id_ce_issuerAltName = 523,
	id_ce_basicConstraints = 524,
	id_ce_cRLNumber = 525,
	id_ce_reasonCode = 526,
	id_ce_instructionCode = 527,
	id_ce_invalidityDate = 528,
	id_ce_deltaCRLIndicator = 529,
	id_ce_issuingDistributionPoint = 530,
	id_ce_certificateIssuer = 531,
	id_ce_nameConstraints = 532,
	id_ce_cRLDistributionPoints = 533,
	id_ce_certificatePolicies = 534,
	anyPolicy = 535,
	id_ce_policyMappings = 536,
	DeprecatedpolicyConstraints = 537,
	id_ce_authorityKeyIdentifier = 538,
	id_ce_policyConstraints = 539,
	ext_key_usage = 540,
	anyExtendedKeyUsage = 541,
	id_ce_freshestCRL = 542,
	id_ce_inhibitAnyPolicy = 543,
	DigiNotar_EV_CPS = 544,
	Logius_PKIoverheid_EV_CPS = 545,
	Buypass_EV_CPS = 546,
	Swisscom_EV_CPS = 547,
	SwissSign_EV_CPS = 548,
	Kamu_Sertifikasyon_Merkezi_EV_CPS = 549,
	E_Tugra_EV_CPS = 550,
	id_keyExchangeAlgorithm = 551,
	hashAlgs = 552,
	id_sha256 = 553,
	id_sha384 = 554,
	id_sha512 = 555,
	id_sha224 = 556,
	id_shake128 = 557,
	id_shake256 = 558,
	id_hmacWithSHA3_224 = 559,
	id_hmacWithSHA3_256 = 560,
	id_hmacWithSHA3_384 = 561,
	id_hmacWithSHA3_512 = 562,
	id_KmacWithSHAKE128 = 563,
	id_KmacWithSHAKE256 = 564,
	sigAlgs = 565,
	id_dsa_with_sha224 = 566,
	id_dsa_with_sha256 = 567,
	id_ecdsa_with_sha3_224 = 568,
	id_ecdsa_with_sha3_256 = 569,
	id_ecdsa_with_sha3_384 = 570,
	id_ecdsa_with_sha3_512 = 571,
	id_rsassa_pkcs1_v1_5_with_sha3_224 = 572,
	id_rsassa_pkcs1_v1_5_with_sha3_256 = 573,
	id_rsassa_pkcs1_v1_5_with_sha3_384 = 574,
	id_rsassa_pkcs1_v1_5_with_sha3_512 = 575,
	NetscapeCertificateExtension = 576,
	NetscapeCertType = 577,
	RevocationURL = 578,
	CaRevocationURL = 579,
	SSLServerName = 580,
	NetscapeCertificateComment = 581,
	pkcs_9_at_userPKCS12 = 582,
	Symantec_EV_CPS = 583,
	Thawte_EV_CPS = 584,
	Entrust_EV_CPS = 585,
	Wells_Fargo_EV_CPS = 586,
	Trustwave_EV_CPS = 587,
	DigiCert_EV_CPS_1_ = 588,
	DigiCert_EV_CPS = 589,
	Go_Daddy_EV_CPS = 590,
	Starfield_Technologies_EV_CPS = 591,
};

static std::unordered_map<std::basic_string<uint8_t>, std::string> &get_oid_dict();

static std::unordered_map<std::basic_string<uint8_t>, uint32_t> &get_oid_to_enum();

static constexpr char oid_empty_string[] = { '\0' };

// datum_get_oid_string() returns a null-terminated printable string
// associated with the OID represented by its argument, or NULL if the
// OID is unknown
//
static const char *get_string(const struct datum *p) {
    std::basic_string<uint8_t> s = p->get_bytestring();
    static std::unordered_map<std::basic_string<uint8_t>, std::string> &oid_dict = get_oid_dict();
    auto pair = oid_dict.find(s);
    if (pair == oid_dict.end()) {
        return oid_empty_string;
    }
    return pair->second.c_str();
}

// datum_get_oid_enum() returns an enumeration associated with the OID
// represented by its argument; if there is no known OID that matches
// the argument, then oid::unknown is returned
//
static enum type get_enum(const struct datum *p) {
    std::basic_string<uint8_t> s = p->get_bytestring();
    static std::unordered_map<std::basic_string<uint8_t>, uint32_t> &oid_to_enum = get_oid_to_enum();
    auto pair = oid_to_enum.find(s);
    if (pair == oid_to_enum.end()) {
        return type::unknown;
    }
    return static_cast<type>(pair->second);
}
};

#endif // #ifndef OID.h
