import urllib2
import re
import datetime
import md5

from Malcom.model.datatypes import Ip, Hostname
from Malcom.feeds.core import Feed
import Malcom.auxiliary.toolbox as toolbox


class MalwareTrafficAnalysis(Feed):
    """
    This is a feed that will fetch data from a URL and process it
    """
    def __init__(self):
        super(MalwareTrafficAnalysis, self).__init__(run_every="12h")

        self.source = "http://www.malware-traffic-analysis.net/suspicious-ip-addresses-and-domains.txt"
        self.description = "Collects results from malware-traffic-analysis.net"

    def update(self):
        feed = urllib2.urlopen(self.source).read().split('\n')
        for line in feed:
            self.analyze(line)

    def analyze(self, line):
        if line.startswith("#") or line.startswith("IP address"):
            return
        try:
            ip, port, domains, traffic_info, description, date_string = line.split(',')
        except ValueError:
            # Malformed line, skipping
            return

        evil = {}
        evil['ip'] = ip
        port = re.search('[\d]+', port)
        if port:
            evil['port'] = port.group()
        evil['domains'] = domains
        evil['description'] = "{}".format(description)
        if traffic_info:
            evil['description'] += " ({})".format(traffic_info)

        evil['date_added'] = datetime.datetime.strptime(date_string, "%Y-%m-%d")

        evil['id'] = md5.new(evil['description']+evil['ip']+date_string).hexdigest()
        evil['source'] = self.name

        ip = Ip(ip=ip)
        domains = [d.strip() for d in domains.split('/') if toolbox.is_hostname(d.strip())]

        ip.seen(first=evil['date_added'])
        ip.add_evil(evil)
        i = self.commit_to_db(ip)

        for d in domains:
            h = Hostname(hostname=d)
            h.seen(first=evil['date_added'])
            h.add_evil(evil)
            h = self.commit_to_db(h)
            self.model.connect(h, i)
