/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class WindowPosition {
    private boolean isFullScreen;
    private int windowWidth;
    private int windowHeight;
    private int windowX;
    private int windowY;

    public void readPositionFromWindow(JFrame window) {
        boolean bl = this.isFullScreen = window.getExtendedState() == 6;
        if (!this.isFullScreen) {
            this.readPositionFromComponent(window);
        }
    }

    public void readPositionFromDialog(JDialog dialog) {
        this.readPositionFromComponent(dialog);
    }

    private void readPositionFromComponent(Component component) {
        this.isFullScreen = false;
        this.windowWidth = component.getWidth();
        this.windowHeight = component.getHeight();
        this.windowX = component.getX();
        this.windowY = component.getY();
    }

    public boolean isSavedWindowPositionValid() {
        if (this.isFullScreen) {
            return true;
        }
        if (this.windowWidth < 100 || this.windowHeight < 100) {
            return false;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.windowWidth > screenSize.width + 50 || this.windowHeight > screenSize.height + 50) {
            return false;
        }
        return this.windowY >= -20 && this.windowY <= screenSize.height - 50 && this.windowX >= 50 - this.windowWidth && this.windowX <= screenSize.width - 50;
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public void setFullScreen(boolean isFullScreen) {
        this.isFullScreen = isFullScreen;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    public int getWindowX() {
        return this.windowX;
    }

    public void setWindowX(int windowX) {
        this.windowX = windowX;
    }

    public int getWindowY() {
        return this.windowY;
    }

    public void setWindowY(int windowY) {
        this.windowY = windowY;
    }
}

