/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.PlainTextOutput;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import us.deathmarine.luyten.LinkProvider;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.Selection;

public class DecompilerLinkProvider
implements LinkProvider {
    private Map<String, Selection> definitionToSelectionMap = new HashMap<String, Selection>();
    private Map<String, Set<Selection>> referenceToSelectionsMap = new HashMap<String, Set<Selection>>();
    private boolean isSelectionMapsPopulated = false;
    private MetadataSystem metadataSystem;
    private DecompilerSettings settings;
    private DecompilationOptions decompilationOptions;
    private TypeDefinition type;
    private String currentTypeQualifiedName;
    private String textContent = "";

    @Override
    public void generateContent() {
        this.definitionToSelectionMap = new HashMap<String, Selection>();
        this.referenceToSelectionsMap = new HashMap<String, Set<Selection>>();
        this.currentTypeQualifiedName = this.type.getPackageName() + "." + this.type.getName();
        final StringWriter stringwriter = new StringWriter();
        PlainTextOutput plainTextOutput = new PlainTextOutput(stringwriter){

            @Override
            public void writeDefinition(String text, Object definition, boolean isLocal) {
                super.writeDefinition(text, definition, isLocal);
                try {
                    String uniqueStr;
                    if (text != null && definition != null && (uniqueStr = DecompilerLinkProvider.this.createUniqueStrForReference(definition)) != null) {
                        text = text.replaceAll("[^\\.]*\\.", "");
                        int from = stringwriter.getBuffer().length() - text.length();
                        int to = stringwriter.getBuffer().length();
                        DecompilerLinkProvider.this.definitionToSelectionMap.put(uniqueStr, new Selection(from, to));
                    }
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }

            @Override
            public void writeReference(String text, Object reference, boolean isLocal) {
                super.writeReference(text, reference, isLocal);
                try {
                    String uniqueStr;
                    if (text != null && reference != null && (uniqueStr = DecompilerLinkProvider.this.createUniqueStrForReference(reference)) != null) {
                        text = text.replaceAll("[^\\.]*\\.", "");
                        int from = stringwriter.getBuffer().length() - text.length();
                        int to = stringwriter.getBuffer().length();
                        if (reference instanceof FieldReference && ((FieldReference)reference).isDefinition()) {
                            DecompilerLinkProvider.this.definitionToSelectionMap.put(uniqueStr, new Selection(from, to));
                            return;
                        }
                        if (DecompilerLinkProvider.this.referenceToSelectionsMap.containsKey(uniqueStr)) {
                            Set selectionsSet = (Set)DecompilerLinkProvider.this.referenceToSelectionsMap.get(uniqueStr);
                            if (selectionsSet != null) {
                                selectionsSet.add(new Selection(from, to));
                            }
                        } else {
                            HashSet<Selection> selectionsSet = new HashSet<Selection>();
                            selectionsSet.add(new Selection(from, to));
                            DecompilerLinkProvider.this.referenceToSelectionsMap.put(uniqueStr, selectionsSet);
                        }
                    }
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }
        };
        plainTextOutput.setUnicodeOutputEnabled(this.decompilationOptions.getSettings().isUnicodeOutputEnabled());
        this.settings.getLanguage().decompileType(this.type, plainTextOutput, this.decompilationOptions);
        this.textContent = stringwriter.toString();
        this.isSelectionMapsPopulated = true;
    }

    private String createUniqueStrForReference(Object reference) {
        FieldReference field;
        String pathAndTypeStr;
        String uniqueStr = null;
        if (reference instanceof TypeReference) {
            TypeReference type = (TypeReference)reference;
            String pathAndTypeStr2 = this.getPathAndTypeStr(type);
            if (pathAndTypeStr2 != null) {
                uniqueStr = "type|" + pathAndTypeStr2;
            }
        } else if (reference instanceof MethodReference) {
            MethodReference method = (MethodReference)reference;
            String pathAndTypeStr3 = this.getPathAndTypeStr(method.getDeclaringType());
            if (pathAndTypeStr3 != null) {
                uniqueStr = "method|" + pathAndTypeStr3 + "|" + method.getName() + "|" + method.getErasedSignature();
            }
        } else if (reference instanceof FieldReference && (pathAndTypeStr = this.getPathAndTypeStr((field = (FieldReference)reference).getDeclaringType())) != null) {
            uniqueStr = "field|" + pathAndTypeStr + "|" + field.getName();
        }
        return uniqueStr;
    }

    private String getPathAndTypeStr(TypeReference typeRef) {
        String name = typeRef.getName();
        String packageStr = typeRef.getPackageName();
        TypeReference mostOuterTypeRef = this.getMostOuterTypeRef(typeRef);
        String mostOuterTypeName = mostOuterTypeRef.getName();
        if (name != null && packageStr != null && mostOuterTypeName != null && name.trim().length() > 0 && mostOuterTypeName.trim().length() > 0) {
            String pathStr = packageStr.replaceAll("\\.", "/") + "/" + mostOuterTypeName;
            String typeStr = packageStr + "." + name.replace(".", "$");
            return pathStr + "|" + typeStr;
        }
        return null;
    }

    private TypeReference getMostOuterTypeRef(TypeReference typeRef) {
        TypeReference declaringTypeRef;
        int maxDecraringDepth = typeRef.getFullName().split("(\\.|\\$)").length;
        for (int i = 0; i < maxDecraringDepth && (declaringTypeRef = typeRef.getDeclaringType()) != null; ++i) {
            typeRef = declaringTypeRef;
        }
        if (typeRef.getName().contains("$")) {
            return this.getMostOuterTypeRefBySlowLookuping(typeRef);
        }
        return typeRef;
    }

    private TypeReference getMostOuterTypeRefBySlowLookuping(TypeReference typeRef) {
        String name = typeRef.getName();
        if (name == null) {
            return typeRef;
        }
        String packageName = typeRef.getPackageName();
        if (packageName == null) {
            return typeRef;
        }
        String[] nameParts = name.split("\\$");
        String newName = "";
        String sep = "";
        for (int i = 0; i < nameParts.length - 1; ++i) {
            TypeDefinition newTypeDef;
            newName = newName + sep + nameParts[i];
            sep = "$";
            String newInternalName = packageName.replaceAll("\\.", "/") + "/" + newName;
            TypeReference newTypeRef = this.metadataSystem.lookupType(newInternalName);
            if (newTypeRef == null || (newTypeDef = newTypeRef.resolve()) == null) continue;
            return newTypeRef;
        }
        return typeRef;
    }

    @Override
    public String getTextContent() {
        return this.textContent;
    }

    @Override
    public void processLinks() {
    }

    @Override
    public Map<String, Selection> getDefinitionToSelectionMap() {
        return this.definitionToSelectionMap;
    }

    @Override
    public Map<String, Set<Selection>> getReferenceToSelectionsMap() {
        return this.referenceToSelectionsMap;
    }

    @Override
    public boolean isLinkNavigable(String uniqueStr) {
        if (this.isSelectionMapsPopulated && this.definitionToSelectionMap.containsKey(uniqueStr)) {
            return true;
        }
        if (uniqueStr == null) {
            return false;
        }
        String[] linkParts = uniqueStr.split("\\|");
        if (linkParts.length < 3) {
            return false;
        }
        String typeStr = linkParts[2];
        if (typeStr.trim().length() <= 0) {
            return false;
        }
        TypeReference typeRef = this.metadataSystem.lookupType(typeStr.replaceAll("\\.", "/"));
        if (typeRef == null) {
            return false;
        }
        TypeDefinition typeDef = typeRef.resolve();
        if (typeDef == null) {
            return false;
        }
        if (typeDef.isSynthetic()) {
            return false;
        }
        if (this.isSelectionMapsPopulated) {
            if (this.currentTypeQualifiedName == null || this.currentTypeQualifiedName.trim().length() <= 0) {
                return false;
            }
            if (typeStr.equals(this.currentTypeQualifiedName) || typeStr.startsWith(this.currentTypeQualifiedName + ".") || typeStr.startsWith(this.currentTypeQualifiedName + "$")) {
                return false;
            }
        }
        return !(uniqueStr.startsWith("method") ? this.findMethodInType(typeDef, uniqueStr) == null : uniqueStr.startsWith("field") && this.findFieldInType(typeDef, uniqueStr) == null);
    }

    private MethodDefinition findMethodInType(TypeDefinition typeDef, String uniqueStr) {
        String[] linkParts = uniqueStr.split("\\|");
        if (linkParts.length != 5) {
            return null;
        }
        String methodName = linkParts[3];
        String methodErasedSignature = linkParts[4];
        if (methodName.trim().length() <= 0 || methodErasedSignature.trim().length() <= 0) {
            return null;
        }
        List<MethodDefinition> declaredMethods = typeDef.getDeclaredMethods();
        if (declaredMethods == null) {
            return null;
        }
        boolean isFound = false;
        for (MethodDefinition declaredMethod : declaredMethods) {
            isFound = declaredMethod != null && methodName.equals(declaredMethod.getName());
            if (!(isFound = isFound && methodErasedSignature.equals(declaredMethod.getErasedSignature()))) continue;
            if (declaredMethod.isSynthetic() && !this.settings.getShowSyntheticMembers()) {
                return null;
            }
            return declaredMethod;
        }
        return null;
    }

    private FieldDefinition findFieldInType(TypeDefinition typeDef, String uniqueStr) {
        String[] linkParts = uniqueStr.split("\\|");
        if (linkParts.length != 4) {
            return null;
        }
        String fieldName = linkParts[3];
        if (fieldName.trim().length() <= 0) {
            return null;
        }
        List<FieldDefinition> declaredFields = typeDef.getDeclaredFields();
        if (declaredFields == null) {
            return null;
        }
        boolean isFound = false;
        for (FieldDefinition declaredField : declaredFields) {
            isFound = declaredField != null && fieldName.equals(declaredField.getName());
            if (!isFound) continue;
            if (declaredField.isSynthetic()) {
                return null;
            }
            return declaredField;
        }
        return null;
    }

    @Override
    public String getLinkDescription(String uniqueStr) {
        String readableLink = null;
        try {
            if (uniqueStr == null) {
                return null;
            }
            String[] linkParts = uniqueStr.split("\\|");
            if (linkParts.length < 3) {
                return null;
            }
            String typeStr = linkParts[2];
            TypeReference typeRef = this.metadataSystem.lookupType(typeStr.replaceAll("\\.", "/"));
            if (typeRef == null) {
                return null;
            }
            TypeDefinition typeDef = typeRef.resolve();
            if (typeDef == null) {
                return null;
            }
            String declaredSuffix = "";
            String mostOuterTypeStr = linkParts[1].replaceAll("/", ".");
            boolean isOwnFile = mostOuterTypeStr.equals(this.currentTypeQualifiedName);
            if (!isOwnFile) {
                declaredSuffix = " - Declared: " + mostOuterTypeStr;
            }
            if (uniqueStr.startsWith("type")) {
                String desc = typeDef.getBriefDescription();
                if (desc != null && desc.trim().length() > 0) {
                    readableLink = desc;
                }
            } else if (uniqueStr.startsWith("method")) {
                MethodDefinition methodDef = this.findMethodInType(typeDef, uniqueStr);
                if (methodDef == null) {
                    return null;
                }
                String desc = methodDef.getBriefDescription();
                if (desc != null && desc.trim().length() > 0) {
                    if (desc.contains("void <init>")) {
                        String declaringTypeName;
                        TypeDefinition declaringTypeDef;
                        String constructorName = typeDef.getName();
                        TypeReference declaringTypeRef = typeRef.getDeclaringType();
                        if (declaringTypeRef != null && (declaringTypeDef = declaringTypeRef.resolve()) != null && (declaringTypeName = declaringTypeDef.getName()) != null) {
                            constructorName = StringUtilities.removeLeft(constructorName, declaringTypeName);
                            constructorName = constructorName.replaceAll("^(\\.|\\$)", "");
                        }
                        desc = desc.replace("void <init>", constructorName);
                        readableLink = "Constructor: " + this.erasePackageInfoFromDesc(desc) + declaredSuffix;
                    } else {
                        readableLink = this.erasePackageInfoFromDesc(desc) + declaredSuffix;
                    }
                }
            } else if (uniqueStr.startsWith("field")) {
                FieldDefinition fieldDef = this.findFieldInType(typeDef, uniqueStr);
                if (fieldDef == null) {
                    return null;
                }
                String desc = fieldDef.getBriefDescription();
                if (desc != null && desc.trim().length() > 0) {
                    readableLink = this.erasePackageInfoFromDesc(desc) + declaredSuffix;
                }
            }
            if (readableLink != null) {
                readableLink = readableLink.replace("$", ".");
            }
        }
        catch (Exception e) {
            readableLink = null;
            Luyten.showExceptionDialog("Exception!", e);
        }
        return readableLink;
    }

    private String erasePackageInfoFromDesc(String desc) {
        String limiters = "\\(\\)\\<\\>\\[\\]\\?\\s,";
        desc = desc.replaceAll("(?<=[^" + limiters + "]*)([^" + limiters + "]*)\\.", "");
        return desc;
    }

    public void setDecompilerReferences(MetadataSystem metadataSystem, DecompilerSettings settings, DecompilationOptions decompilationOptions) {
        this.metadataSystem = metadataSystem;
        this.settings = settings;
        this.decompilationOptions = decompilationOptions;
    }

    public void setType(TypeDefinition type) {
        this.type = type;
    }
}

