/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.languages.Language;
import com.strobel.decompiler.languages.Languages;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.prefs.Preferences;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;
import us.deathmarine.luyten.WindowPosition;

public class ConfigSaver {
    private static final String FLATTEN_SWITCH_BLOCKS_ID = "flattenSwitchBlocks";
    private static final String FORCE_EXPLICIT_IMPORTS_ID = "forceExplicitImports";
    private static final String SHOW_SYNTHETIC_MEMBERS_ID = "showSyntheticMembers";
    private static final String EXCLUDE_NESTED_TYPES_ID = "excludeNestedTypes";
    private static final String FORCE_EXPLICIT_TYPE_ARGUMENTS_ID = "forceExplicitTypeArguments";
    private static final String RETAIN_REDUNDANT_CASTS_ID = "retainRedundantCasts";
    private static final String INCLUDE_ERROR_DIAGNOSTICS_ID = "includeErrorDiagnostics";
    private static final String UNICODE_REPLACE_ENABLED_ID = "unicodeReplaceEnabled";
    private static final String LANGUAGE_NAME_ID = "languageName";
    private static final String MAIN_WINDOW_ID_PREFIX = "main";
    private static final String FIND_WINDOW_ID_PREFIX = "find";
    private static final String WINDOW_IS_FULL_SCREEN_ID = "WindowIsFullScreen";
    private static final String WINDOW_WIDTH_ID = "WindowWidth";
    private static final String WINDOW_HEIGHT_ID = "WindowHeight";
    private static final String WINDOW_X_ID = "WindowX";
    private static final String WINDOW_Y_ID = "WindowY";
    private DecompilerSettings decompilerSettings;
    private WindowPosition mainWindowPosition;
    private WindowPosition findWindowPosition;
    private LuytenPreferences luytenPreferences;
    private static ConfigSaver theLoadedInstance;

    private ConfigSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigSaver getLoadedInstance() {
        if (theLoadedInstance != null) return theLoadedInstance;
        Class<ConfigSaver> clazz = ConfigSaver.class;
        synchronized (ConfigSaver.class) {
            if (theLoadedInstance != null) return theLoadedInstance;
            theLoadedInstance = new ConfigSaver();
            theLoadedInstance.loadConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theLoadedInstance;
        }
    }

    private void loadConfig() {
        this.decompilerSettings = new DecompilerSettings();
        if (this.decompilerSettings.getJavaFormattingOptions() == null) {
            this.decompilerSettings.setJavaFormattingOptions(JavaFormattingOptions.createDefault());
        }
        this.luytenPreferences = new LuytenPreferences();
        this.mainWindowPosition = new WindowPosition();
        this.findWindowPosition = new WindowPosition();
        try {
            Preferences prefs = Preferences.userNodeForPackage(ConfigSaver.class);
            if (!prefs.get(LANGUAGE_NAME_ID, this.decompilerSettings.getLanguage().getName()).equals(this.decompilerSettings.getLanguage().getName())) {
                prefs.put(LANGUAGE_NAME_ID, this.decompilerSettings.getLanguage().getName());
            }
            this.decompilerSettings.setFlattenSwitchBlocks(prefs.getBoolean(FLATTEN_SWITCH_BLOCKS_ID, this.decompilerSettings.getFlattenSwitchBlocks()));
            this.decompilerSettings.setForceExplicitImports(prefs.getBoolean(FORCE_EXPLICIT_IMPORTS_ID, this.decompilerSettings.getForceExplicitImports()));
            this.decompilerSettings.setShowSyntheticMembers(prefs.getBoolean(SHOW_SYNTHETIC_MEMBERS_ID, this.decompilerSettings.getShowSyntheticMembers()));
            this.decompilerSettings.setExcludeNestedTypes(prefs.getBoolean(EXCLUDE_NESTED_TYPES_ID, this.decompilerSettings.getExcludeNestedTypes()));
            this.decompilerSettings.setForceExplicitTypeArguments(prefs.getBoolean(FORCE_EXPLICIT_TYPE_ARGUMENTS_ID, this.decompilerSettings.getForceExplicitTypeArguments()));
            this.decompilerSettings.setRetainRedundantCasts(prefs.getBoolean(RETAIN_REDUNDANT_CASTS_ID, this.decompilerSettings.getRetainRedundantCasts()));
            this.decompilerSettings.setIncludeErrorDiagnostics(prefs.getBoolean(INCLUDE_ERROR_DIAGNOSTICS_ID, this.decompilerSettings.getIncludeErrorDiagnostics()));
            this.decompilerSettings.setLanguage(this.findLanguageByName(prefs.get(LANGUAGE_NAME_ID, this.decompilerSettings.getLanguage().getName())));
            this.decompilerSettings.setUnicodeOutputEnabled(prefs.getBoolean(UNICODE_REPLACE_ENABLED_ID, false));
            this.mainWindowPosition = this.loadWindowPosition(prefs, MAIN_WINDOW_ID_PREFIX);
            this.findWindowPosition = this.loadWindowPosition(prefs, FIND_WINDOW_ID_PREFIX);
            this.luytenPreferences = this.loadLuytenPreferences(prefs);
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    private WindowPosition loadWindowPosition(Preferences prefs, String windowIdPrefix) {
        WindowPosition windowPosition = new WindowPosition();
        windowPosition.setFullScreen(prefs.getBoolean(windowIdPrefix + WINDOW_IS_FULL_SCREEN_ID, false));
        windowPosition.setWindowWidth(prefs.getInt(windowIdPrefix + WINDOW_WIDTH_ID, 0));
        windowPosition.setWindowHeight(prefs.getInt(windowIdPrefix + WINDOW_HEIGHT_ID, 0));
        windowPosition.setWindowX(prefs.getInt(windowIdPrefix + WINDOW_X_ID, 0));
        windowPosition.setWindowY(prefs.getInt(windowIdPrefix + WINDOW_Y_ID, 0));
        return windowPosition;
    }

    private LuytenPreferences loadLuytenPreferences(Preferences prefs) throws Exception {
        LuytenPreferences newLuytenPrefs = new LuytenPreferences();
        for (Field field : LuytenPreferences.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            String prefId = field.getName();
            Object defaultVal = field.get(newLuytenPrefs);
            if (field.getType() == String.class) {
                String defaultStr = (String)(defaultVal == null ? "" : defaultVal);
                field.set(newLuytenPrefs, prefs.get(prefId, defaultStr));
                continue;
            }
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                Boolean defaultBool = (Boolean)(defaultVal == null ? new Boolean(false) : defaultVal);
                field.setBoolean(newLuytenPrefs, prefs.getBoolean(prefId, defaultBool));
                continue;
            }
            if (field.getType() != Integer.class && field.getType() != Integer.TYPE) continue;
            Integer defaultInt = (Integer)(defaultVal == null ? new Integer(0) : defaultVal);
            field.setInt(newLuytenPrefs, prefs.getInt(prefId, defaultInt));
        }
        return newLuytenPrefs;
    }

    public void saveConfig() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(ConfigSaver.class);
            prefs.putBoolean(FLATTEN_SWITCH_BLOCKS_ID, this.decompilerSettings.getFlattenSwitchBlocks());
            prefs.putBoolean(FORCE_EXPLICIT_IMPORTS_ID, this.decompilerSettings.getForceExplicitImports());
            prefs.putBoolean(SHOW_SYNTHETIC_MEMBERS_ID, this.decompilerSettings.getShowSyntheticMembers());
            prefs.putBoolean(EXCLUDE_NESTED_TYPES_ID, this.decompilerSettings.getExcludeNestedTypes());
            prefs.putBoolean(FORCE_EXPLICIT_TYPE_ARGUMENTS_ID, this.decompilerSettings.getForceExplicitTypeArguments());
            prefs.putBoolean(RETAIN_REDUNDANT_CASTS_ID, this.decompilerSettings.getRetainRedundantCasts());
            prefs.putBoolean(INCLUDE_ERROR_DIAGNOSTICS_ID, this.decompilerSettings.getIncludeErrorDiagnostics());
            prefs.putBoolean(UNICODE_REPLACE_ENABLED_ID, this.decompilerSettings.isUnicodeOutputEnabled());
            prefs.put(LANGUAGE_NAME_ID, this.decompilerSettings.getLanguage().getName());
            this.saveWindowPosition(prefs, MAIN_WINDOW_ID_PREFIX, this.mainWindowPosition);
            this.saveWindowPosition(prefs, FIND_WINDOW_ID_PREFIX, this.findWindowPosition);
            this.saveLuytenPreferences(prefs);
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    private void saveWindowPosition(Preferences prefs, String windowIdPrefix, WindowPosition windowPosition) {
        prefs.putBoolean(windowIdPrefix + WINDOW_IS_FULL_SCREEN_ID, windowPosition.isFullScreen());
        prefs.putInt(windowIdPrefix + WINDOW_WIDTH_ID, windowPosition.getWindowWidth());
        prefs.putInt(windowIdPrefix + WINDOW_HEIGHT_ID, windowPosition.getWindowHeight());
        prefs.putInt(windowIdPrefix + WINDOW_X_ID, windowPosition.getWindowX());
        prefs.putInt(windowIdPrefix + WINDOW_Y_ID, windowPosition.getWindowY());
    }

    private void saveLuytenPreferences(Preferences prefs) throws Exception {
        for (Field field : LuytenPreferences.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            String prefId = field.getName();
            Object value = field.get(this.luytenPreferences);
            if (field.getType() == String.class) {
                prefs.put(prefId, (String)(value == null ? "" : value));
                continue;
            }
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                prefs.putBoolean(prefId, (Boolean)(value == null ? new Boolean(false) : value));
                continue;
            }
            if (field.getType() != Integer.class && field.getType() != Integer.TYPE) continue;
            prefs.putInt(prefId, (Integer)(value == null ? new Integer(0) : value));
        }
    }

    private Language findLanguageByName(String languageName) {
        if (languageName != null) {
            if (languageName.equals(Languages.java().getName())) {
                return Languages.java();
            }
            if (languageName.equals(Languages.bytecode().getName())) {
                return Languages.bytecode();
            }
            if (languageName.equals(Languages.bytecodeAst().getName())) {
                return Languages.bytecodeAst();
            }
            for (Language language : Languages.debug()) {
                if (!languageName.equals(language.getName())) continue;
                return language;
            }
        }
        return Languages.java();
    }

    public DecompilerSettings getDecompilerSettings() {
        return this.decompilerSettings;
    }

    public WindowPosition getMainWindowPosition() {
        return this.mainWindowPosition;
    }

    public WindowPosition getFindWindowPosition() {
        return this.findWindowPosition;
    }

    public LuytenPreferences getLuytenPreferences() {
        return this.luytenPreferences;
    }
}

