/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.reflection.MethodKey;
import com.strobel.reflection.RawMember;
import com.strobel.reflection.Type;
import java.lang.reflect.Constructor;

final class RawConstructor
extends RawMember {
    private final Constructor<?> _constructor;
    private final int _hashCode;

    public RawConstructor(Type context, Constructor<?> constructor) {
        super(context);
        this._constructor = constructor;
        this._hashCode = this._constructor == null ? 0 : this._constructor.hashCode();
    }

    public MethodKey createKey() {
        String name = "<init>";
        Class<?>[] argTypes = this._constructor.getParameterTypes();
        return new MethodKey("<init>", argTypes);
    }

    @Override
    public Constructor<?> getRawMember() {
        return this._constructor;
    }

    @Override
    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        RawConstructor other = (RawConstructor)o;
        return other._constructor == this._constructor;
    }
}

