/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.ArrayUtilities;
import com.strobel.core.ReadOnlyList;
import com.strobel.core.VerifyArgument;
import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.SwitchCase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.SwitchOptions;
import java.util.ArrayList;
import java.util.HashMap;

public final class SwitchExpression
extends Expression {
    private final Type _type;
    private final Expression _switchValue;
    private final ReadOnlyList<SwitchCase> _cases;
    private final Expression _defaultBody;
    private final MethodInfo _comparison;
    private final SwitchOptions _options;

    public SwitchExpression(Type type, Expression switchValue, Expression defaultBody, MethodInfo comparison, ReadOnlyList<SwitchCase> cases, SwitchOptions options) {
        this._type = VerifyArgument.notNull(type, "type");
        this._switchValue = VerifyArgument.notNull(switchValue, "switchValue");
        this._defaultBody = defaultBody;
        this._comparison = comparison;
        this._cases = VerifyArgument.notEmpty(cases, "cases");
        this._options = options != null ? options : SwitchOptions.Default;
    }

    public final Expression getSwitchValue() {
        return this._switchValue;
    }

    public final ReadOnlyList<SwitchCase> getCases() {
        return this._cases;
    }

    public final Expression getDefaultBody() {
        return this._defaultBody;
    }

    public final MethodInfo getComparison() {
        return this._comparison;
    }

    public final SwitchOptions getOptions() {
        return this._options;
    }

    @Override
    public final Type<?> getType() {
        return this._type;
    }

    @Override
    public final ExpressionType getNodeType() {
        return ExpressionType.Switch;
    }

    @Override
    protected final Expression accept(ExpressionVisitor visitor) {
        return visitor.visitSwitch(this);
    }

    public final SwitchExpression update(Expression switchValue, ReadOnlyList<SwitchCase> cases, Expression defaultBody, SwitchOptions options) {
        if (switchValue == this._switchValue && options == this._options && cases == this._cases && defaultBody == this._defaultBody) {
            return this;
        }
        return Expression.makeSwitch(this._type, switchValue, this._options, defaultBody, this._comparison, cases);
    }

    @Override
    public boolean canReduce() {
        Type<?> switchValueType = this._switchValue.getType();
        return switchValueType == Types.String && this._options != SwitchOptions.PreferTrie || switchValueType.isEnum();
    }

    @Override
    public Expression reduce() {
        Type<?> switchValueType = this._switchValue.getType();
        if (switchValueType == Types.String && this._options != SwitchOptions.PreferTrie) {
            return this.rewriteStringSwitch();
        }
        if (switchValueType.isEnum()) {
            return this.rewriteEnumSwitch();
        }
        return this;
    }

    private Expression rewriteStringSwitch() {
        ArrayList<Integer> hashList = new ArrayList<Integer>();
        HashMap<Integer, String[]> reverseHashMap = new HashMap<Integer, String[]>();
        HashMap<String, Integer> caseIndexMap = new HashMap<String, Integer>();
        int n = this._cases.size();
        for (int i = 0; i < n; ++i) {
            SwitchCase switchCase = this._cases.get(i);
            for (Expression expression : switchCase.getTestValues()) {
                String value = (String)((ConstantExpression)expression).getValue();
                int hash = value.hashCode();
                String[] oldValue = reverseHashMap.put(hash, ArrayUtilities.append((Object[])reverseHashMap.get(hash), value));
                if (oldValue == null) {
                    hashList.add(hash);
                }
                caseIndexMap.put(value, i);
            }
        }
        ParameterExpression caseIndex = SwitchExpression.variable(PrimitiveTypes.Integer);
        ParameterExpression switchValue = SwitchExpression.variable(this._switchValue.getType());
        SwitchCase[] hashCases = new SwitchCase[hashList.size()];
        int n2 = hashList.size();
        for (int i = 0; i < n2; ++i) {
            Integer hash = (Integer)hashList.get(i);
            String[] matchingStrings = (String[])reverseHashMap.get(hash);
            Expression[] caseBranches = new Expression[matchingStrings.length];
            for (int j = 0; j < matchingStrings.length; ++j) {
                String matchingString = matchingStrings[j];
                caseBranches[j] = SwitchExpression.ifThen(SwitchExpression.call((Expression)switchValue, "equals", SwitchExpression.constant(matchingString)), SwitchExpression.assign(caseIndex, SwitchExpression.constant(caseIndexMap.get(matchingString))));
            }
            Expression caseBody = caseBranches.length == 1 ? caseBranches[0] : SwitchExpression.block(caseBranches);
            hashCases[i] = SwitchExpression.switchCase((Expression)SwitchExpression.block(caseBody), SwitchExpression.constant(hash));
        }
        SwitchExpression hashSwitch = SwitchExpression.makeSwitch((Expression)SwitchExpression.call((Expression)switchValue, "hashCode", new Expression[0]), this._options, hashCases);
        SwitchCase[] switchCaseArray = new SwitchCase[this._cases.size()];
        int n3 = this._cases.size();
        for (int i = 0; i < n3; ++i) {
            switchCaseArray[i] = SwitchExpression.switchCase(this._cases.get(i).getBody(), SwitchExpression.constant(i));
        }
        SwitchExpression resultSwitch = SwitchExpression.makeSwitch(this._type, (Expression)caseIndex, SwitchOptions.PreferTable, this._defaultBody, null, switchCaseArray);
        return SwitchExpression.block(this._type, new ParameterExpression[]{switchValue, caseIndex}, new Expression[]{SwitchExpression.assign(switchValue, this._switchValue), SwitchExpression.assign(caseIndex, SwitchExpression.constant(-1)), hashSwitch, resultSwitch});
    }

    private Expression rewriteEnumSwitch() {
        SwitchCase[] cases = this._cases.toArray((U[])new SwitchCase[this._cases.size()]);
        int n = this._cases.size();
        for (int i = 0; i < n; ++i) {
            SwitchCase oldCase = this._cases.get(i);
            ExpressionList<? extends Expression> oldTestValues = oldCase.getTestValues();
            Expression[] testValues = new Expression[oldTestValues.size()];
            int m = oldTestValues.size();
            for (int j = 0; j < m; ++j) {
                Enum enumValue = (Enum)((ConstantExpression)oldTestValues.get(j)).getValue();
                testValues[j] = SwitchExpression.constant(enumValue.ordinal());
            }
            cases[i] = SwitchExpression.switchCase(oldCase.getBody(), testValues);
        }
        return SwitchExpression.makeSwitch(this._type, (Expression)SwitchExpression.call(this._switchValue, "ordinal", new Expression[0]), this._options, this._defaultBody, this._comparison, cases);
    }
}

