/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.LabelTarget;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;

public final class LoopExpression
extends Expression {
    private final Expression _body;
    private final LabelTarget _breakTarget;
    private final LabelTarget _continueTarget;

    LoopExpression(Expression body, LabelTarget breakTarget, LabelTarget continueTarget) {
        this._body = body;
        this._breakTarget = breakTarget;
        this._continueTarget = continueTarget;
    }

    public final Expression getBody() {
        return this._body;
    }

    public final LabelTarget getBreakTarget() {
        return this._breakTarget;
    }

    public final LabelTarget getContinueTarget() {
        return this._continueTarget;
    }

    @Override
    public final ExpressionType getNodeType() {
        return ExpressionType.Loop;
    }

    @Override
    public final Type<?> getType() {
        return this._breakTarget == null ? PrimitiveTypes.Void : this._breakTarget.getType();
    }

    @Override
    protected final Expression accept(ExpressionVisitor visitor) {
        return visitor.visitLoop(this);
    }

    public final LoopExpression update(LabelTarget breakLabel, LabelTarget continueLabel, Expression body) {
        if (breakLabel == this._breakTarget && continueLabel == this._continueTarget && body == this._body) {
            return this;
        }
        return LoopExpression.loop(body, breakLabel, continueLabel);
    }
}

