/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.compilerservices.Closure;
import com.strobel.compilerservices.DebugInfoGenerator;
import com.strobel.core.KeyedQueue;
import com.strobel.core.Pair;
import com.strobel.core.ReadOnlyList;
import com.strobel.core.StringUtilities;
import com.strobel.expressions.AnalyzeTypeIsResult;
import com.strobel.expressions.AnalyzedTree;
import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.BlockExpression;
import com.strobel.expressions.BoundConstants;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.CompilerScope;
import com.strobel.expressions.ConditionalExpression;
import com.strobel.expressions.ConstantCheck;
import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.DefaultValueExpression;
import com.strobel.expressions.Delegate;
import com.strobel.expressions.Error;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.FinallyInfo;
import com.strobel.expressions.GotoExpression;
import com.strobel.expressions.GotoExpressionKind;
import com.strobel.expressions.IArgumentProvider;
import com.strobel.expressions.InvocationExpression;
import com.strobel.expressions.LabelExpression;
import com.strobel.expressions.LabelInfo;
import com.strobel.expressions.LabelScopeInfo;
import com.strobel.expressions.LabelScopeKind;
import com.strobel.expressions.LabelTarget;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.LoopExpression;
import com.strobel.expressions.MemberExpression;
import com.strobel.expressions.MethodCallExpression;
import com.strobel.expressions.NewArrayExpression;
import com.strobel.expressions.NewExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.expressions.RuntimeVariablesExpression;
import com.strobel.expressions.SelfExpression;
import com.strobel.expressions.StackSpiller;
import com.strobel.expressions.SuperExpression;
import com.strobel.expressions.SwitchCase;
import com.strobel.expressions.SwitchExpression;
import com.strobel.expressions.TryExpression;
import com.strobel.expressions.TypeBinaryExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.expressions.VariableBinder;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.DynamicMethod;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberList;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.reflection.emit.ConstructorBuilder;
import com.strobel.reflection.emit.FieldBuilder;
import com.strobel.reflection.emit.Label;
import com.strobel.reflection.emit.LocalBuilder;
import com.strobel.reflection.emit.MethodBuilder;
import com.strobel.reflection.emit.OpCode;
import com.strobel.reflection.emit.StringSwitchCallback;
import com.strobel.reflection.emit.SwitchCallback;
import com.strobel.reflection.emit.SwitchOptions;
import com.strobel.reflection.emit.TypeBuilder;
import com.strobel.util.ContractUtils;
import com.strobel.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class LambdaCompiler {
    static final AtomicInteger nextId = new AtomicInteger();
    static final Type<Closure> closureType = Type.of(Closure.class);
    final LambdaExpression<?> lambda;
    final TypeBuilder typeBuilder;
    final MethodBuilder methodBuilder;
    final CodeGenerator generator;
    private final AnalyzedTree _tree;
    private final KeyedQueue<Type<?>, LocalBuilder> _freeLocals;
    private final BoundConstants _boundConstants;
    private final Map<LabelTarget, LabelInfo> _labelInfo = new HashMap<LabelTarget, LabelInfo>();
    private ConstructorBuilder _constructorBuilder;
    private boolean _hasClosureArgument;
    private FieldBuilder _closureField;
    private CompilerScope _scope;
    private LabelScopeInfo _labelBlock = new LabelScopeInfo(null, LabelScopeKind.Lambda);
    private FinallyInfo _finallyInfo = new FinallyInfo(null, null);

    LambdaCompiler(AnalyzedTree tree, LambdaExpression<?> lambda) {
        this.lambda = lambda;
        this.typeBuilder = new TypeBuilder(LambdaCompiler.getUniqueLambdaName(lambda.getName(), lambda.getCreationContext()), 17, Types.Object, Type.list(lambda.getType()));
        MethodInfo interfaceMethod = Expression.getInvokeMethod(lambda.getType(), true);
        this.methodBuilder = this.typeBuilder.defineMethod(interfaceMethod.getName(), 17, interfaceMethod.getReturnType(), interfaceMethod.getParameters().getParameterTypes(), interfaceMethod.getThrownTypes());
        ParameterExpressionList lambdaParameters = lambda.getParameters();
        int n = lambdaParameters.size();
        for (int i = 0; i < n; ++i) {
            this.methodBuilder.defineParameter(i, ((ParameterExpression)lambdaParameters.get(i)).getName());
        }
        this.typeBuilder.defineMethodOverride(this.methodBuilder, interfaceMethod);
        this.generator = this.methodBuilder.getCodeGenerator();
        this._tree = tree;
        this._scope = tree.scopes.get(lambda);
        this._boundConstants = tree.constants.get(lambda);
        this._freeLocals = new KeyedQueue();
        if (this._scope.needsClosure || this._boundConstants.count() > 0) {
            this.ensureClosure();
        }
        this.initializeMethod();
    }

    LambdaCompiler(AnalyzedTree tree, LambdaExpression<?> lambda, MethodBuilder method, ConstructorBuilder constructor) {
        this.lambda = lambda;
        TypeList parameterTypes = this.getParameterTypes(lambda);
        method.setReturnType(lambda.getReturnType());
        method.setParameters(parameterTypes);
        ParameterExpressionList lambdaParameters = lambda.getParameters();
        int n = lambdaParameters.size();
        for (int i = 0; i < n; ++i) {
            method.defineParameter(i, ((ParameterExpression)lambdaParameters.get(i)).getName());
        }
        this.typeBuilder = method.getDeclaringType();
        this.methodBuilder = method;
        this._hasClosureArgument = false;
        this._closureField = null;
        this._constructorBuilder = constructor;
        this.generator = this.methodBuilder.getCodeGenerator();
        this._freeLocals = new KeyedQueue();
        this._tree = tree;
        this._scope = tree.scopes.get(lambda);
        this._boundConstants = tree.constants.get(lambda);
        this.initializeMethod();
    }

    private LambdaCompiler(LambdaCompiler parent, LambdaExpression lambda) {
        this._tree = parent._tree;
        this._freeLocals = parent._freeLocals;
        this.lambda = lambda;
        this.methodBuilder = parent.methodBuilder;
        this.generator = parent.generator;
        this.typeBuilder = parent.typeBuilder;
        this._hasClosureArgument = parent._hasClosureArgument;
        this._closureField = parent._closureField;
        this._constructorBuilder = parent._constructorBuilder;
        this._scope = this._tree.scopes.get(lambda);
        this._boundConstants = parent._boundConstants;
    }

    private TypeList getParameterTypes(LambdaExpression<?> lambda) {
        ParameterExpressionList parameters = lambda.getParameters();
        if (parameters.isEmpty()) {
            return TypeList.empty();
        }
        Type[] types = new Type[parameters.size()];
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterExpression parameter = (ParameterExpression)parameters.get(i);
            types[i] = parameter.getType();
        }
        return Type.list(types);
    }

    ParameterExpressionList getParameters() {
        return this.lambda.getParameters();
    }

    boolean canEmitBoundConstants() {
        return this._hasClosureArgument;
    }

    boolean emitDebugSymbols() {
        return this._tree.getDebugInfoGenerator() != null;
    }

    void emitClosureArgument() {
        assert (this._hasClosureArgument) : "must have a Closure argument";
        this.generator.emitThis();
        this.generator.getField(this._closureField);
    }

    void emitLambdaArgument(int index) {
        this.generator.emitLoadArgument(this.getLambdaArgument(index));
    }

    private FieldBuilder createStaticField(String name, Type type) {
        return this.typeBuilder.defineField("<ExpressionCompilerImplementationDetails>{" + nextId.getAndIncrement() + "}" + name, type, 10);
    }

    void initializeMethod() {
        this.addReturnLabel(this.lambda);
        this._boundConstants.emitCacheConstants(this);
    }

    private void addReturnLabel(LambdaExpression lambda) {
        Expression expression = lambda.getBody();
        block4: while (true) {
            switch (expression.getNodeType()) {
                default: {
                    return;
                }
                case Label: {
                    LabelTarget label = ((LabelExpression)expression).getTarget();
                    this._labelInfo.put(label, new LabelInfo(this.generator, label, TypeUtils.hasIdentityPrimitiveOrBoxingConversion(lambda.getReturnType(), label.getType())));
                    return;
                }
                case Block: 
            }
            BlockExpression body = (BlockExpression)expression;
            int i = body.getExpressionCount() - 1;
            while (true) {
                if (i < 0 || LambdaCompiler.significant(expression = body.getExpression(i))) continue block4;
                --i;
            }
            break;
        }
    }

    private static boolean notEmpty(Expression node) {
        return !(node instanceof DefaultValueExpression) || node.getType() != PrimitiveTypes.Void;
    }

    private static boolean significant(Expression node) {
        if (node instanceof BlockExpression) {
            BlockExpression block = (BlockExpression)node;
            for (int i = 0; i < block.getExpressionCount(); ++i) {
                if (!LambdaCompiler.significant(block.getExpression(i))) continue;
                return true;
            }
            return false;
        }
        return LambdaCompiler.notEmpty(node);
    }

    static <T> Delegate<T> compile(LambdaExpression<T> lambda, DebugInfoGenerator debugInfoGenerator) {
        Pair<AnalyzedTree, LambdaExpression<T>> result = LambdaCompiler.analyzeLambda(lambda);
        AnalyzedTree tree = result.getFirst();
        LambdaExpression<T> analyzedLambda = result.getSecond();
        tree.setDebugInfoGenerator(debugInfoGenerator);
        LambdaCompiler c = new LambdaCompiler(tree, analyzedLambda);
        c.emitLambdaBody();
        Type generatedType = c.typeBuilder.createType();
        Class generatedClass = generatedType.getErasedClass();
        return c.createDelegate(generatedClass);
    }

    private <T> Delegate<T> createDelegate(Class<T> generatedClass) {
        try {
            T instance;
            if (this._hasClosureArgument) {
                Constructor<T> constructor = generatedClass.getConstructor(Closure.class);
                Closure closure = new Closure(this._boundConstants.toArray(), null);
                instance = constructor.newInstance(closure);
            } else {
                instance = generatedClass.newInstance();
            }
            MemberList<MemberInfo> method = Type.of(generatedClass).findMembers(MemberType.methodsOnly(), BindingFlags.PublicInstanceDeclared, Type.FilterMethodOverride, Expression.getInvokeMethod(this.lambda.getType(), true));
            return new Delegate<T>(instance, (MethodInfo)method.get(0));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw Error.couldNotCreateDelegate(e);
        }
    }

    static <T> void compile(LambdaExpression<T> lambda, MethodBuilder methodBuilder, DebugInfoGenerator debugInfoGenerator) {
        Pair<AnalyzedTree, LambdaExpression<T>> result = LambdaCompiler.analyzeLambda(lambda);
        AnalyzedTree tree = result.getFirst();
        LambdaExpression<T> analyzedLambda = result.getSecond();
        tree.setDebugInfoGenerator(debugInfoGenerator);
        LambdaCompiler c = new LambdaCompiler(tree, analyzedLambda, methodBuilder, null);
        c.emitLambdaBody();
    }

    private static <T> Pair<AnalyzedTree, LambdaExpression<T>> analyzeLambda(LambdaExpression<T> lambda) {
        LambdaExpression<T> analyzedLambda = StackSpiller.analyzeLambda(lambda);
        return Pair.create(VariableBinder.bind(analyzedLambda), analyzedLambda);
    }

    LocalBuilder getNamedLocal(Type type, ParameterExpression variable) {
        assert (type != null && variable != null) : "type != null && variable != null";
        LocalBuilder lb = this.generator.declareLocal(variable.getName(), type);
        if (this.emitDebugSymbols() && variable.getName() != null) {
            this._tree.getDebugInfoGenerator().setLocalName(lb, variable.getName());
        }
        return lb;
    }

    int getLambdaArgument(int index) {
        return index;
    }

    LocalBuilder getLocal(Type<?> type) {
        assert (type != null) : "type != null";
        LocalBuilder local = this._freeLocals.poll(type);
        if (local != null) {
            assert (type.equals(local.getLocalType())) : "type.equals(local.getLocalType())";
            return local;
        }
        return this.generator.declareLocal(type);
    }

    void freeLocal(LocalBuilder local) {
        if (local != null) {
            this._freeLocals.offer(local.getLocalType(), local);
        }
    }

    private static int updateEmitAsTailCallFlag(int flags, int newValue) {
        assert (newValue == 256 || newValue == 512 || newValue == 1024);
        int oldValue = flags & 0xF00;
        return flags ^ oldValue | newValue;
    }

    private static int updateEmitExpressionStartFlag(int flags, int newValue) {
        assert (newValue == 1 || newValue == 2);
        int oldValue = flags & 0xF;
        return flags ^ oldValue | newValue;
    }

    private static int updateEmitAsTypeFlag(int flags, int newValue) {
        assert (newValue == 16 || newValue == 32);
        int oldValue = flags & 0xF0;
        return flags ^ oldValue | newValue;
    }

    void emitExpression(Expression node) {
        this.emitExpression(node, 1025);
    }

    private int emitExpressionStart(Expression node) {
        if (this.tryPushLabelBlock(node)) {
            return 1;
        }
        return 2;
    }

    private void emitExpressionEnd(int flags) {
        if ((flags & 0xF) == 1) {
            this.popLabelBlock(this._labelBlock.kind);
        }
    }

    private void emitExpression(Expression node, int flags) {
        assert (node != null);
        boolean emitStart = (flags & 0xF) == 1;
        int startEmitted = emitStart ? this.emitExpressionStart(node) : 2;
        int compilationFlags = flags & 0xF00;
        switch (node.getNodeType()) {
            case Add: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case And: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case AndAlso: {
                this.emitAndAlsoBinaryExpression(node, compilationFlags);
                break;
            }
            case ArrayLength: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case ArrayIndex: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case Call: {
                this.emitMethodCallExpression(node, compilationFlags);
                break;
            }
            case Coalesce: {
                this.emitCoalesceBinaryExpression(node);
                break;
            }
            case Conditional: {
                this.emitConditionalExpression(node, compilationFlags);
                break;
            }
            case Constant: {
                this.emitConstantExpression(node);
                break;
            }
            case Convert: {
                this.emitConvertUnaryExpression(node, compilationFlags);
                break;
            }
            case ConvertChecked: {
                this.emitConvertUnaryExpression(node, compilationFlags);
                break;
            }
            case Divide: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case Equal: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case ExclusiveOr: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case GreaterThan: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case GreaterThanOrEqual: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case Invoke: {
                this.emitInvocationExpression(node, compilationFlags);
                break;
            }
            case Lambda: {
                this.emitLambdaExpression(node);
                break;
            }
            case LeftShift: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case LessThan: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case LessThanOrEqual: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case MemberAccess: {
                this.emitMemberExpression(node);
                break;
            }
            case Modulo: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case Multiply: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case Negate: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case UnaryPlus: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case New: {
                this.emitNewExpression(node);
                break;
            }
            case NewArrayInit: {
                this.emitNewArrayExpression(node);
                break;
            }
            case NewArrayBounds: {
                this.emitNewArrayExpression(node);
                break;
            }
            case Not: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case NotEqual: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case Or: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case OrElse: {
                this.emitOrElseBinaryExpression(node, compilationFlags);
                break;
            }
            case Parameter: {
                this.emitParameterExpression(node);
                break;
            }
            case RightShift: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case UnsignedRightShift: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case Subtract: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case InstanceOf: {
                this.emitTypeBinaryExpression(node);
                break;
            }
            case Assign: {
                this.emitAssignBinaryExpression(node);
                break;
            }
            case Block: {
                this.emitBlockExpression(node, compilationFlags);
                break;
            }
            case Decrement: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case DefaultValue: {
                this.emitDefaultValueExpression(node);
                break;
            }
            case Extension: {
                this.emitExtensionExpression(node);
                break;
            }
            case Goto: {
                this.emitGotoExpression(node, compilationFlags);
                break;
            }
            case Increment: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case Label: {
                this.emitLabelExpression(node, compilationFlags);
                break;
            }
            case RuntimeVariables: {
                this.emitRuntimeVariablesExpression(node);
                break;
            }
            case Loop: {
                this.emitLoopExpression(node);
                break;
            }
            case Switch: {
                this.emitSwitchExpression(node, compilationFlags);
                break;
            }
            case Throw: {
                this.emitThrowUnaryExpression(node);
                break;
            }
            case Try: {
                this.emitTryExpression(node);
                break;
            }
            case Unbox: {
                this.emitUnboxUnaryExpression(node);
                break;
            }
            case TypeEqual: {
                this.emitTypeBinaryExpression(node);
                break;
            }
            case OnesComplement: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case IsTrue: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case IsFalse: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case IsNull: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case IsNotNull: {
                this.emitUnaryExpression(node, compilationFlags);
                break;
            }
            case ReferenceEqual: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            case ReferenceNotEqual: {
                this.emitBinaryExpression(node, compilationFlags);
                break;
            }
            default: {
                throw ContractUtils.unreachable();
            }
        }
        if (emitStart) {
            this.emitExpressionEnd(startEmitted);
        }
    }

    private void emitExtensionExpression(Expression node) {
        throw Error.extensionNotReduced();
    }

    private void emitExpressionAsVoid(Expression node) {
        this.emitExpressionAsVoid(node, 1024);
    }

    private void emitExpressionAsVoid(Expression node, int flags) {
        assert (node != null);
        int startEmitted = this.emitExpressionStart(node);
        switch (node.getNodeType()) {
            case Assign: {
                this.emitAssign((BinaryExpression)node, 32);
                break;
            }
            case Block: {
                this.emit((BlockExpression)node, LambdaCompiler.updateEmitAsTypeFlag(flags, 32));
                break;
            }
            case Throw: {
                this.emitThrow((UnaryExpression)node, 32);
                break;
            }
            case Goto: {
                this.emitGotoExpression(node, LambdaCompiler.updateEmitAsTypeFlag(flags, 32));
                break;
            }
            case Constant: 
            case Parameter: 
            case DefaultValue: {
                break;
            }
            default: {
                if (node.getType() == PrimitiveTypes.Void) {
                    this.emitExpression(node, LambdaCompiler.updateEmitExpressionStartFlag(flags, 2));
                    break;
                }
                this.emitExpression(node, 1026);
                this.generator.pop(node.getType());
            }
        }
        this.emitExpressionEnd(startEmitted);
    }

    private void emitExpressionAsType(Expression node, Type type, int flags) {
        if (type == PrimitiveTypes.Void) {
            this.emitExpressionAsVoid(node, flags);
        } else if (!TypeUtils.areEquivalent(node.getType(), type)) {
            this.emitExpression(node);
            assert (TypeUtils.hasIdentityPrimitiveOrBoxingConversion(type, node.getType()) | TypeUtils.areReferenceAssignable(type, node.getType()));
            this.generator.emitConversion(node.getType(), type);
        } else {
            this.emitExpression(node, LambdaCompiler.updateEmitExpressionStartFlag(flags, 1));
        }
    }

    private void emitAssignBinaryExpression(Expression expr) {
        this.emitAssign((BinaryExpression)expr, 16);
    }

    private void emitAssign(BinaryExpression node, int emitAs) {
        switch (node.getLeft().getNodeType()) {
            case ArrayIndex: {
                this.emitIndexAssignment(node, emitAs);
                return;
            }
            case MemberAccess: {
                this.emitMemberAssignment(node, emitAs);
                return;
            }
            case Parameter: {
                this.emitVariableAssignment(node, emitAs);
                return;
            }
        }
        throw Error.invalidLValue(node.getLeft().getNodeType());
    }

    private void emitMemberAssignment(BinaryExpression node, int flags) {
        MemberExpression lValue = (MemberExpression)node.getLeft();
        Expression rValue = node.getRight();
        MemberInfo member = lValue.getMember();
        if (lValue.getTarget() != null) {
            this.emitExpression(lValue.getTarget());
        }
        this.emitExpression(rValue);
        if (!TypeUtils.hasReferenceConversion(rValue.getType(), lValue.getType())) {
            this.generator.emitConversion(rValue.getType(), lValue.getType());
        }
        LocalBuilder temp = null;
        int emitAs = flags & 0xF0;
        if (emitAs != 32) {
            this.generator.dup(node.getType());
            temp = this.getLocal(node.getType());
            this.generator.emitStore(temp);
        }
        switch (member.getMemberType()) {
            case Field: {
                this.generator.putField((FieldInfo)member);
                break;
            }
            default: {
                throw Error.invalidMemberType(member.getMemberType());
            }
        }
        if (emitAs != 32) {
            this.generator.emitLoad(temp);
            this.freeLocal(temp);
        }
    }

    private void emitVariableAssignment(BinaryExpression node, int flags) {
        LocalBuilder local;
        ParameterExpression variable = (ParameterExpression)node.getLeft();
        int emitAs = flags & 0xF0;
        Expression right = node.getRight();
        ExpressionType rightNodeType = right.getNodeType();
        if ((rightNodeType == ExpressionType.Increment || rightNodeType == ExpressionType.Decrement) && right.getType() == PrimitiveTypes.Integer && (local = this._scope.getLocalForVariable(variable)) != null) {
            this.generator.increment(local, rightNodeType == ExpressionType.Increment ? 1 : -1);
            if (emitAs != 32) {
                this.emitParameterExpression(variable);
            }
            return;
        }
        this.emitExpression(right);
        if (!TypeUtils.hasReferenceConversion(right.getType(), variable.getType())) {
            this.generator.emitConversion(right.getType(), variable.getType());
        }
        if (emitAs != 32) {
            this.generator.dup(variable.getType());
        }
        this._scope.emitSet(variable);
    }

    private void emitIndexAssignment(BinaryExpression node, int flags) {
        Expression left = node.getLeft();
        Expression right = node.getRight();
        BinaryExpression index = (BinaryExpression)left;
        int emitAs = flags & 0xF0;
        this.emitExpression(left);
        this.emitExpression(index.getRight());
        this.emitExpression(right);
        if (!TypeUtils.hasReferenceConversion(right.getType(), left.getType())) {
            this.generator.emitConversion(right.getType(), left.getType());
        }
        LocalBuilder temp = null;
        if (emitAs != 32) {
            this.generator.dup(node.getType());
            temp = this.getLocal(node.getType());
            this.generator.emitStore(temp);
        }
        this.emitSetIndexCall(index);
        if (emitAs != 32) {
            this.generator.emitLoad(temp);
            this.freeLocal(temp);
        }
    }

    private void emitSetIndexCall(BinaryExpression index) {
        this.generator.emitStoreElement(index.getType());
    }

    private static boolean hasVariables(Object node) {
        if (node instanceof BlockExpression) {
            return ((BlockExpression)node).getVariables().size() > 0;
        }
        return ((CatchBlock)node).getVariable() != null;
    }

    private void enterTry(TryExpression tryExpression) {
        Expression finallyBlock = tryExpression.getFinallyBlock();
        if (finallyBlock != null) {
            this._finallyInfo = new FinallyInfo(this._finallyInfo, tryExpression);
        }
    }

    private void exitTry(TryExpression tryExpression) {
        if (tryExpression != null && this._finallyInfo.tryExpression == tryExpression) {
            this._finallyInfo = this._finallyInfo.parent;
        }
    }

    private void enterScope(Object node) {
        if (LambdaCompiler.hasVariables(node) && (this._scope.mergedScopes == null || !this._scope.mergedScopes.contains(node))) {
            CompilerScope scope = this._tree.scopes.get(node);
            if (scope == null) {
                scope = new CompilerScope(node, false);
                scope.needsClosure = this._scope.needsClosure;
            }
            this._scope = scope.enter(this, this._scope);
            assert (this._scope.node == node);
        }
    }

    private void exitScope(Object node) {
        if (this._scope.node == node) {
            this._scope = this._scope.exit();
        }
    }

    private void emitBlockExpression(Expression expr, int flags) {
        this.emit((BlockExpression)expr, LambdaCompiler.updateEmitAsTypeFlag(flags, 16));
    }

    private void emit(BlockExpression node, int flags) {
        this.enterScope(node);
        int emitAs = flags & 0xF0;
        int count = node.getExpressionCount();
        int tailCall = flags & 0xF00;
        int middleTailCall = tailCall == 1024 ? 1024 : 512;
        for (int index = 0; index < count - 1; ++index) {
            LabelInfo labelInfo;
            GotoExpression g;
            Expression e = node.getExpression(index);
            Expression next = node.getExpression(index + 1);
            int tailCallFlag = middleTailCall;
            if (next instanceof GotoExpression && ((g = (GotoExpression)next).getValue() == null || !LambdaCompiler.significant(g.getValue())) && (labelInfo = this.referenceLabel(g.getTarget())).canReturn()) {
                tailCallFlag = 256;
            }
            int updatedFlags = LambdaCompiler.updateEmitAsTailCallFlag(flags, tailCallFlag);
            this.emitExpressionAsVoid(e, updatedFlags);
        }
        if (emitAs == 32 || node.getType() == PrimitiveTypes.Void) {
            this.emitExpressionAsVoid(node.getExpression(count - 1), tailCall);
        } else {
            this.emitExpressionAsType(node.getExpression(count - 1), node.getType(), tailCall);
        }
        this.exitScope(node);
    }

    private void emitAndAlsoBinaryExpression(Expression expr, int flags) {
        BinaryExpression b = (BinaryExpression)expr;
        if (b.getMethod() != null) {
            throw Error.andAlsoCannotProvideMethod();
        }
        if (b.getLeft().getType() == Types.Boolean) {
            this.emitUnboxingAndAlso(b);
        } else {
            this.emitPrimitiveAndAlso(b);
        }
    }

    private void emitPrimitiveAndAlso(BinaryExpression b) {
        Expression left = b.getLeft();
        Expression right = b.getRight();
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        Label returnFalse = this.generator.defineLabel();
        Label exit = this.generator.defineLabel();
        this.emitExpression(left);
        this.generator.emit(OpCode.IFEQ, returnFalse);
        this.emitExpression(right);
        this.generator.emit(OpCode.IFEQ, returnFalse);
        this.generator.emitBoolean(true);
        this.generator.emitGoto(exit);
        this.generator.markLabel(returnFalse);
        this.generator.emitBoolean(false);
        this.generator.markLabel(exit);
    }

    private void emitUnboxingAndAlso(BinaryExpression b) {
        Expression left = b.getLeft();
        Expression right = b.getRight();
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        Label returnFalse = this.generator.defineLabel();
        Label exit = this.generator.defineLabel();
        this.emitExpression(left);
        if (leftType != PrimitiveTypes.Boolean) {
            this.generator.emitConversion(leftType, PrimitiveTypes.Boolean);
        }
        this.generator.emit(OpCode.IFEQ, returnFalse);
        this.emitExpression(right);
        if (rightType != PrimitiveTypes.Boolean) {
            this.generator.emitConversion(rightType, PrimitiveTypes.Boolean);
        }
        this.generator.emit(OpCode.IFEQ, returnFalse);
        this.generator.emitBoolean(true);
        this.generator.emitGoto(exit);
        this.generator.markLabel(returnFalse);
        this.generator.emitBoolean(false);
        this.generator.markLabel(exit);
    }

    private void emitOrElseBinaryExpression(Expression expr, int flags) {
        BinaryExpression b = (BinaryExpression)expr;
        if (b.getMethod() != null) {
            throw Error.orElseCannotProvideMethod();
        }
        if (b.getLeft().getType() == Types.Boolean) {
            this.emitUnboxingOrElse(b);
        } else {
            this.emitPrimitiveOrElse(b);
        }
    }

    private void emitPrimitiveOrElse(BinaryExpression b) {
        Expression left = b.getLeft();
        Expression right = b.getRight();
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        Label returnTrue = this.generator.defineLabel();
        Label exit = this.generator.defineLabel();
        this.emitExpression(left);
        this.generator.emit(OpCode.IFNE, returnTrue);
        this.emitExpression(right);
        this.generator.emit(OpCode.IFNE, returnTrue);
        this.generator.emitBoolean(false);
        this.generator.emitGoto(exit);
        this.generator.markLabel(returnTrue);
        this.generator.emitBoolean(true);
        this.generator.markLabel(exit);
    }

    private void emitUnboxingOrElse(BinaryExpression b) {
        Expression left = b.getLeft();
        Expression right = b.getRight();
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        Label returnTrue = this.generator.defineLabel();
        Label exit = this.generator.defineLabel();
        this.emitExpression(left);
        if (leftType != PrimitiveTypes.Boolean) {
            this.generator.emitConversion(leftType, PrimitiveTypes.Boolean);
        }
        this.generator.emit(OpCode.IFNE, returnTrue);
        this.emitExpression(right);
        if (rightType != PrimitiveTypes.Boolean) {
            this.generator.emitConversion(rightType, PrimitiveTypes.Boolean);
        }
        this.generator.emit(OpCode.IFNE, returnTrue);
        this.generator.emitBoolean(false);
        this.generator.emitGoto(exit);
        this.generator.markLabel(returnTrue);
        this.generator.emitBoolean(true);
        this.generator.markLabel(exit);
    }

    private void emitCoalesceBinaryExpression(Expression expr) {
        BinaryExpression b = (BinaryExpression)expr;
        assert (b.getMethod() == null);
        if (b.getLeft().getType().isPrimitive()) {
            throw Error.coalesceUsedOnNonNullableType();
        }
        if (b.getConversion() != null) {
            this.emitLambdaReferenceCoalesce(b);
        } else {
            this.emitReferenceCoalesceWithoutConversion(b);
        }
    }

    private void emitReferenceCoalesceWithoutConversion(BinaryExpression b) {
        Label end = this.generator.defineLabel();
        boolean needConvertLeft = !TypeUtils.areEquivalent(b.getLeft().getType(), b.getType());
        boolean needConvertRight = !TypeUtils.areEquivalent(b.getRight().getType(), b.getType());
        Label convertLeft = needConvertLeft ? this.generator.defineLabel() : null;
        this.emitExpression(b.getLeft());
        this.generator.dup();
        this.generator.emit(OpCode.IFNONNULL, needConvertLeft ? convertLeft : end);
        this.generator.pop();
        this.emitExpression(b.getRight());
        if (needConvertRight) {
            this.generator.emitConversion(b.getRight().getType(), b.getType());
        }
        if (needConvertLeft) {
            this.generator.emitGoto(end);
            this.generator.markLabel(convertLeft);
            this.generator.emitConversion(b.getLeft().getType(), b.getType());
        }
        this.generator.markLabel(end);
    }

    private void emitLambdaReferenceCoalesce(BinaryExpression b) {
        LocalBuilder operandStorage = this.getLocal(b.getLeft().getType());
        Label end = this.generator.defineLabel();
        Label notNull = this.generator.defineLabel();
        this.emitExpression(b.getLeft());
        this.generator.dup();
        this.generator.emitStore(operandStorage);
        this.generator.emit(OpCode.IFNONNULL, notNull);
        this.emitExpression(b.getRight());
        this.generator.emitGoto(end);
        this.generator.markLabel(notNull);
        LambdaExpression<?> lambda = b.getConversion();
        ParameterExpressionList conversionParameters = lambda.getParameters();
        assert (conversionParameters.size() == 1);
        this.emitLambdaExpression(lambda);
        this.generator.emitLoad(operandStorage);
        this.freeLocal(operandStorage);
        MethodInfo method = Expression.getInvokeMethod(lambda);
        this.generator.call(method);
        this.generator.markLabel(end);
    }

    private void emitConditionalExpression(Expression expr, int flags) {
        ConditionalExpression node = (ConditionalExpression)expr;
        assert (node.getTest().getType() == PrimitiveTypes.Boolean);
        Label ifFalse = this.generator.defineLabel();
        this.emitExpressionAndBranch(false, node.getTest(), ifFalse);
        this.emitExpressionAsType(node.getIfTrue(), node.getType(), flags);
        if (LambdaCompiler.notEmpty(node.getIfFalse())) {
            Label end = this.generator.defineLabel();
            this.generator.emitGoto(end);
            this.generator.markLabel(ifFalse);
            this.emitExpressionAsType(node.getIfFalse(), node.getType(), flags);
            this.generator.markLabel(end);
        } else {
            this.generator.markLabel(ifFalse);
        }
    }

    private void emitBinaryExpression(Expression expr) {
        this.emitBinaryExpression(expr, 1024);
    }

    private void emitBinaryExpression(Expression expr, int flags) {
        BinaryExpression b = (BinaryExpression)expr;
        ExpressionType nodeType = b.getNodeType();
        assert (nodeType != ExpressionType.AndAlso && nodeType != ExpressionType.OrElse && nodeType != ExpressionType.Coalesce);
        if (b.getMethod() != null) {
            this.emitBinaryMethod(b, flags);
            return;
        }
        Expression left = b.getLeft();
        Expression right = b.getRight();
        Type<?> leftType = left.getType();
        Type<?> rightType = right.getType();
        if (nodeType.isEqualityOperator() && (b.getType() == PrimitiveTypes.Boolean || b.getType() == Types.Boolean)) {
            this.emitExpression(this.getEqualityOperand(left));
            this.emitExpression(this.getEqualityOperand(right));
        } else {
            this.emitExpression(left);
            this.emitExpression(right);
        }
        this.emitBinaryOperator(nodeType, leftType, rightType, b.getType());
    }

    private Expression getEqualityOperand(Expression expression) {
        UnaryExpression convert;
        if (expression.getNodeType() == ExpressionType.Convert && TypeUtils.areReferenceAssignable((convert = (UnaryExpression)expression).getType(), convert.getOperand().getType())) {
            return convert.getOperand();
        }
        return expression;
    }

    private void emitBinaryMethod(BinaryExpression b, int flags) {
        MethodInfo method = b.getMethod();
        Expression left = b.getLeft();
        Expression right = b.getRight();
        if (method.isStatic()) {
            this.emitMethodCallExpression(Expression.call(null, method, left, right), flags);
        } else if (TypeUtils.isSameOrSubType(method.getDeclaringType(), left.getType())) {
            this.emitMethodCallExpression(Expression.call(left, method, right), flags);
        } else {
            this.emitMethodCallExpression(Expression.call(right, method, left), flags);
        }
    }

    private void emitBinaryOperator(ExpressionType op, Type<?> leftType, Type<?> rightType, Type resultType) {
        boolean leftIsNullable = TypeUtils.isAutoUnboxed(leftType);
        boolean rightIsNullable = TypeUtils.isAutoUnboxed(rightType);
        switch (op) {
            case ArrayIndex: {
                if (rightType != PrimitiveTypes.Integer && rightType != Types.Integer) {
                    throw ContractUtils.unreachable();
                }
                this.generator.emitLoadElement(leftType.getElementType());
                return;
            }
            case Coalesce: {
                throw Error.unexpectedCoalesceOperator();
            }
            case ReferenceEqual: 
            case ReferenceNotEqual: {
                this.emitObjectBinaryOp(op);
                return;
            }
        }
        if (leftIsNullable && TypeUtils.isArithmetic(rightType) || rightIsNullable && TypeUtils.isArithmetic(leftType)) {
            this.emitUnboxingBinaryOp(op, leftType, rightType, resultType);
        } else {
            Type<?> opResultType = this.emitPrimitiveBinaryOp(op, leftType, rightType);
            this.emitConvertArithmeticResult(op, opResultType, resultType);
        }
    }

    private void emitConvertArithmeticResult(ExpressionType op, Type sourceType, Type resultType) {
        this.generator.emitConversion(sourceType, resultType);
    }

    private Type<?> emitPrimitiveBinaryOp(ExpressionType op, Type leftType, Type rightType) {
        Type<Integer> rightOperandType;
        Type<?> operandType = TypeUtils.isArithmetic(leftType) ? (TypeUtils.isArithmetic(rightType) ? Expression.performBinaryNumericPromotion(leftType, rightType) : leftType) : leftType;
        if (leftType != operandType) {
            LocalBuilder rightStorage = this.getLocal(rightType);
            this.generator.emitStore(rightStorage);
            this.generator.emitConversion(leftType, operandType);
            this.generator.emitLoad(rightStorage);
            this.freeLocal(rightStorage);
        }
        switch (op) {
            case LeftShift: 
            case RightShift: 
            case UnsignedRightShift: {
                rightOperandType = PrimitiveTypes.Integer;
                break;
            }
            default: {
                rightOperandType = operandType;
            }
        }
        if (rightType != rightOperandType) {
            this.generator.emitConversion(rightType, rightOperandType);
        }
        switch (op) {
            case Equal: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case LessThan: 
            case LessThanOrEqual: 
            case NotEqual: 
            case ReferenceEqual: 
            case ReferenceNotEqual: {
                Label ifFalse = this.generator.defineLabel();
                Label exit = this.generator.defineLabel();
                this.emitRelationalBranchOp(op, operandType, false, ifFalse);
                this.generator.emitBoolean(true);
                this.generator.emitGoto(exit);
                this.generator.markLabel(ifFalse);
                this.generator.emitBoolean(false);
                this.generator.emitGoto(exit);
                this.generator.markLabel(exit);
                return PrimitiveTypes.Boolean;
            }
        }
        this.emitArithmeticBinaryOp(op, operandType);
        return operandType;
    }

    private void emitUnboxingBinaryOp(ExpressionType op, Type leftType, Type rightType, Type resultType) {
        assert (TypeUtils.isAutoUnboxed(leftType) || TypeUtils.isAutoUnboxed(rightType));
        switch (op) {
            case And: {
                if (leftType == Types.Boolean) {
                    this.emitLiftedBooleanAnd(leftType, rightType);
                    break;
                }
                this.emitUnboxingBinaryArithmetic(op, leftType, rightType, resultType);
                break;
            }
            case Or: {
                if (leftType == Types.Boolean) {
                    this.emitLiftedBooleanOr(leftType, rightType);
                    break;
                }
                this.emitUnboxingBinaryArithmetic(op, leftType, rightType, resultType);
                break;
            }
            case Add: 
            case Divide: 
            case ExclusiveOr: 
            case LeftShift: 
            case Modulo: 
            case Multiply: 
            case RightShift: 
            case Subtract: {
                this.emitUnboxingBinaryArithmetic(op, leftType, rightType, resultType);
                break;
            }
            case Equal: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case LessThan: 
            case LessThanOrEqual: 
            case NotEqual: {
                this.emitLiftedRelational(op, leftType, rightType, resultType);
                break;
            }
            default: {
                throw ContractUtils.unreachable();
            }
        }
    }

    private void emitUnboxingBinaryArithmetic(ExpressionType op, Type leftType, Type rightType, Type resultType) {
        boolean leftIsBoxed = TypeUtils.isAutoUnboxed(leftType);
        boolean rightIsBoxed = TypeUtils.isAutoUnboxed(rightType);
        Type finalLeftType = leftType;
        Type finalRightType = rightType;
        if (leftIsBoxed) {
            finalLeftType = this.unboxLeftBinaryOperand(leftType, rightType);
        }
        if (rightIsBoxed) {
            finalRightType = this.unboxRightBinaryOperand(rightType);
        }
        this.emitBinaryOperator(op, finalLeftType, finalRightType, TypeUtils.getUnderlyingPrimitiveOrSelf(resultType));
    }

    private void emitLiftedRelational(ExpressionType op, Type leftType, Type rightType, Type resultType) {
        boolean leftIsBoxed = TypeUtils.isAutoUnboxed(leftType);
        boolean rightIsBoxed = TypeUtils.isAutoUnboxed(rightType);
        Type finalLeftType = leftType;
        Type finalRightType = rightType;
        if (leftIsBoxed) {
            finalLeftType = this.unboxLeftBinaryOperand(leftType, rightType);
        }
        if (rightIsBoxed) {
            finalRightType = this.unboxRightBinaryOperand(rightType);
        }
        this.emitBinaryOperator(op, finalLeftType, finalRightType, TypeUtils.getUnderlyingPrimitiveOrSelf(resultType));
    }

    private Type unboxRightBinaryOperand(Type rightType) {
        Type<?> finalRightType = TypeUtils.getUnderlyingPrimitive(rightType);
        this.generator.emitUnbox(finalRightType);
        return finalRightType;
    }

    private Type unboxLeftBinaryOperand(Type leftType, Type rightType) {
        Type<?> finalLeftType = TypeUtils.getUnderlyingPrimitive(leftType);
        LocalBuilder rightStorage = this.getLocal(rightType);
        this.generator.emitStore(rightStorage);
        this.generator.emitUnbox(finalLeftType);
        this.generator.emitLoad(rightStorage);
        this.freeLocal(rightStorage);
        return finalLeftType;
    }

    private void emitLiftedBooleanAnd(Type leftType, Type rightType) {
        Type<Boolean> type = PrimitiveTypes.Boolean;
        Label returnFalse = this.generator.defineLabel();
        Label exit = this.generator.defineLabel();
        LocalBuilder rightStorage = this.getLocal(type);
        this.generator.emitStore(rightStorage);
        this.generator.emitConversion(leftType, PrimitiveTypes.Boolean);
        this.generator.emit(OpCode.IFEQ, returnFalse);
        this.generator.emitLoad(rightStorage);
        this.generator.emitConversion(rightType, PrimitiveTypes.Boolean);
        this.generator.emit(OpCode.IFEQ, returnFalse);
        this.generator.emitBoolean(true);
        this.generator.emitGoto(exit);
        this.generator.markLabel(returnFalse);
        this.generator.emitBoolean(false);
        this.generator.emitGoto(exit);
        this.generator.markLabel(exit);
        this.freeLocal(rightStorage);
    }

    private void emitLiftedBooleanOr(Type leftType, Type rightType) {
        Type<Boolean> type = PrimitiveTypes.Boolean;
        Label returnTrue = this.generator.defineLabel();
        Label exit = this.generator.defineLabel();
        LocalBuilder rightStorage = this.getLocal(type);
        this.generator.emitStore(rightStorage);
        this.generator.emitConversion(leftType, PrimitiveTypes.Boolean);
        this.generator.emit(OpCode.IFNE, returnTrue);
        this.generator.emitLoad(rightStorage);
        this.generator.emitConversion(rightType, PrimitiveTypes.Boolean);
        this.generator.emit(OpCode.IFNE, returnTrue);
        this.generator.emitBoolean(false);
        this.generator.emitGoto(exit);
        this.generator.markLabel(returnTrue);
        this.generator.emitBoolean(true);
        this.generator.emitGoto(exit);
        this.generator.markLabel(exit);
        this.freeLocal(rightStorage);
    }

    private void emitObjectBinaryOp(ExpressionType op) {
        switch (op) {
            case Equal: 
            case ReferenceEqual: {
                Label ifNotEqual = this.generator.defineLabel();
                Label exit = this.generator.defineLabel();
                this.generator.emit(OpCode.IF_ACMPNE, ifNotEqual);
                this.generator.emitBoolean(true);
                this.generator.emitGoto(exit);
                this.generator.markLabel(ifNotEqual);
                this.generator.emitBoolean(false);
                this.generator.emitGoto(exit);
                this.generator.markLabel(exit);
                break;
            }
            case NotEqual: 
            case ReferenceNotEqual: {
                Label ifEqual = this.generator.defineLabel();
                Label exit = this.generator.defineLabel();
                this.generator.emit(OpCode.IF_ACMPEQ, ifEqual);
                this.generator.emitBoolean(true);
                this.generator.emitGoto(exit);
                this.generator.markLabel(ifEqual);
                this.generator.emitBoolean(false);
                this.generator.emitGoto(exit);
                this.generator.markLabel(exit);
                break;
            }
            default: {
                throw ContractUtils.unreachable();
            }
        }
    }

    private void emitArithmeticBinaryOp(ExpressionType op, Type<?> operandType) {
        switch (op) {
            case Add: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.IADD);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LADD);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.IADD);
                        return;
                    }
                    case FLOAT: {
                        this.generator.emit(OpCode.FADD);
                        return;
                    }
                    case DOUBLE: {
                        this.generator.emit(OpCode.DADD);
                        return;
                    }
                }
                break;
            }
            case And: 
            case AndAlso: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.IAND);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LAND);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.IAND);
                        return;
                    }
                }
                break;
            }
            case Divide: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.IDIV);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LDIV);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.IDIV);
                        return;
                    }
                    case FLOAT: {
                        this.generator.emit(OpCode.FDIV);
                        return;
                    }
                    case DOUBLE: {
                        this.generator.emit(OpCode.DDIV);
                        return;
                    }
                }
                break;
            }
            case ExclusiveOr: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.IXOR);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LXOR);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.IXOR);
                        return;
                    }
                }
                break;
            }
            case LeftShift: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.ISHL);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LSHL);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.ISHL);
                        return;
                    }
                }
                break;
            }
            case Modulo: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.IREM);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LREM);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.IREM);
                        return;
                    }
                    case FLOAT: {
                        this.generator.emit(OpCode.FREM);
                        return;
                    }
                    case DOUBLE: {
                        this.generator.emit(OpCode.DREM);
                        return;
                    }
                }
                break;
            }
            case Multiply: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.IMUL);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LMUL);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.IMUL);
                        return;
                    }
                    case FLOAT: {
                        this.generator.emit(OpCode.FMUL);
                        return;
                    }
                    case DOUBLE: {
                        this.generator.emit(OpCode.DMUL);
                        return;
                    }
                }
                break;
            }
            case Or: 
            case OrElse: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.IOR);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LOR);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.IOR);
                        return;
                    }
                }
                break;
            }
            case RightShift: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.ISHR);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LSHR);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.ISHR);
                        return;
                    }
                }
                break;
            }
            case UnsignedRightShift: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.IUSHR);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LUSHR);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.IUSHR);
                        return;
                    }
                }
                break;
            }
            case Subtract: {
                switch (operandType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.ISUB);
                        return;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LSUB);
                        return;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.ISUB);
                        return;
                    }
                    case FLOAT: {
                        this.generator.emit(OpCode.FSUB);
                        return;
                    }
                    case DOUBLE: {
                        this.generator.emit(OpCode.DSUB);
                        return;
                    }
                }
            }
        }
        throw ContractUtils.unreachable();
    }

    private void emitConstantExpression(Expression expr) {
        ConstantExpression node = (ConstantExpression)expr;
        this.emitConstant(node.getValue(), node.getType());
    }

    private void emitConstant(Object value, Type<?> type) {
        if (CodeGenerator.canEmitConstant(value, type)) {
            this.generator.emitConstant(value, type);
            return;
        }
        this._boundConstants.emitConstant(this, value, type);
    }

    private void emitDefaultValueExpression(Expression node) {
        this.generator.emitDefaultValue(node.getType());
    }

    private void emitGotoExpression(Expression expr, int flags) {
        GotoExpression node = (GotoExpression)expr;
        LabelInfo labelInfo = this.referenceLabel(node.getTarget());
        int finalFlags = flags;
        if (node.getValue() != null) {
            Type targetType = node.getTarget().getType();
            if (targetType == PrimitiveTypes.Void) {
                this.emitExpressionAsVoid(node.getValue(), flags);
            } else {
                Type<?> valueType = node.getValue().getType();
                finalFlags = LambdaCompiler.updateEmitExpressionStartFlag(flags, 1);
                this.emitExpression(node.getValue(), finalFlags);
                if (!TypeUtils.hasReferenceConversion(valueType, targetType)) {
                    this.generator.emitConversion(valueType, targetType);
                }
            }
        }
        if (node.getKind() == GotoExpressionKind.Return) {
            FinallyInfo finallyInfo = this._finallyInfo;
            while (finallyInfo != null && finallyInfo.tryExpression != null) {
                this.emitExpression(finallyInfo.tryExpression.getFinallyBlock());
                finallyInfo = finallyInfo.parent;
            }
        }
        labelInfo.emitJump();
        this.emitUnreachable(node, finalFlags);
    }

    private void emitUnreachable(Expression node, int flags) {
        if (node.getType() != PrimitiveTypes.Void && (flags & 0x20) == 0) {
            this.generator.emitDefaultValue(node.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitExpressionAndBranch(boolean branchValue, Expression node, Label label) {
        int startEmitted = this.emitExpressionStart(node);
        try {
            if (node.getType() == PrimitiveTypes.Boolean) {
                switch (node.getNodeType()) {
                    case Not: 
                    case IsFalse: {
                        this.emitBranchNot(branchValue, (UnaryExpression)node, label);
                        return;
                    }
                    case AndAlso: 
                    case OrElse: {
                        this.emitBranchLogical(branchValue, (BinaryExpression)node, label);
                        return;
                    }
                    case Block: {
                        this.emitBranchBlock(branchValue, (BlockExpression)node, label);
                        return;
                    }
                    case Equal: 
                    case GreaterThan: 
                    case GreaterThanOrEqual: 
                    case LessThan: 
                    case LessThanOrEqual: 
                    case NotEqual: 
                    case ReferenceEqual: 
                    case ReferenceNotEqual: {
                        this.emitBranchRelation(branchValue, (BinaryExpression)node, label);
                        return;
                    }
                    case IsNull: 
                    case IsNotNull: {
                        this.emitBranchNullCheck(branchValue, (UnaryExpression)node, label);
                        return;
                    }
                }
            }
            this.emitExpression(node, 1026);
            this.emitBranchOp(branchValue, label);
        }
        finally {
            this.emitExpressionEnd(startEmitted);
        }
    }

    private void emitBranchNot(boolean branch, UnaryExpression node, Label label) {
        if (node.getMethod() != null) {
            this.emitExpression(node, 1026);
            this.emitBranchOp(branch, label);
            return;
        }
        this.emitExpressionAndBranch(!branch, node.getOperand(), label);
    }

    private void emitBranchNullCheck(boolean branch, UnaryExpression node, Label label) {
        this.emitExpression(node.getOperand());
        this.emitRelationalBranchOp(node.getNodeType(), node.getOperand().getType(), branch, label);
    }

    private void emitBranchRelation(boolean branch, BinaryExpression node, Label label) {
        ExpressionType op = node.getNodeType();
        assert (op == ExpressionType.Equal || op == ExpressionType.NotEqual || op == ExpressionType.LessThan || op == ExpressionType.LessThanOrEqual || op == ExpressionType.GreaterThan || op == ExpressionType.GreaterThanOrEqual || op == ExpressionType.ReferenceEqual || op == ExpressionType.ReferenceNotEqual);
        if (node.getMethod() != null) {
            this.emitBinaryMethod(node, 1024);
            this.emitBranchOp(branch, label);
            return;
        }
        if (op == ExpressionType.ReferenceEqual || op == ExpressionType.ReferenceNotEqual) {
            if (ConstantCheck.isNull(node.getLeft())) {
                if (ConstantCheck.isNull(node.getRight())) {
                    this.generator.emitBoolean(op == ExpressionType.ReferenceEqual);
                    this.emitBranchOp(branch, label);
                    return;
                }
                this.emitExpression(this.getEqualityOperand(node.getRight()));
                this.generator.emit(branch ? (op == ExpressionType.ReferenceEqual ? OpCode.IFNULL : OpCode.IFNONNULL) : (op == ExpressionType.ReferenceEqual ? OpCode.IFNONNULL : OpCode.IFNULL), label);
                return;
            }
            if (ConstantCheck.isNull(node.getRight())) {
                this.emitExpression(this.getEqualityOperand(node.getLeft()));
                this.generator.emit(branch ? (op == ExpressionType.ReferenceEqual ? OpCode.IFNULL : OpCode.IFNONNULL) : (op == ExpressionType.ReferenceEqual ? OpCode.IFNONNULL : OpCode.IFNULL), label);
                return;
            }
        } else if (op == ExpressionType.Equal || op == ExpressionType.NotEqual) {
            if (ConstantCheck.isTrue(node.getLeft())) {
                if (ConstantCheck.isTrue(node.getRight())) {
                    if (branch == (op == ExpressionType.Equal)) {
                        this.generator.emitGoto(label);
                    }
                    return;
                }
                if (ConstantCheck.isFalse(node.getRight())) {
                    if (branch == (op == ExpressionType.NotEqual)) {
                        this.generator.emitGoto(label);
                    }
                    return;
                }
                this.emitExpression(this.getEqualityOperand(node.getRight()));
                this.emitBranchOp(branch == (op == ExpressionType.Equal), label);
                return;
            }
            if (ConstantCheck.isTrue(node.getRight())) {
                this.emitExpression(this.getEqualityOperand(node.getLeft()));
                this.emitBranchOp(branch == (op == ExpressionType.Equal), label);
                return;
            }
        }
        if (TypeUtils.isAutoUnboxed(node.getLeft().getType()) || TypeUtils.isAutoUnboxed(node.getRight().getType())) {
            this.emitBinaryExpression(node);
            this.emitBranchOp(branch, label);
            return;
        }
        Expression equalityOperand = this.getEqualityOperand(node.getLeft());
        this.emitExpression(equalityOperand);
        this.emitExpression(this.getEqualityOperand(node.getRight()));
        Type<?> compareType = TypeUtils.isArithmetic(equalityOperand.getType()) ? TypeUtils.getUnderlyingPrimitiveOrSelf(equalityOperand.getType()) : equalityOperand.getType();
        this.emitRelationalBranchOp(op, compareType, branch, label);
    }

    private void emitRelationalBranchOp(ExpressionType op, Type<?> operandType, boolean branch, Label label) {
        block0 : switch (operandType.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: 
            case BOOLEAN: {
                switch (op) {
                    case Equal: {
                        boolean reallyBranch = branch == (op == ExpressionType.Equal);
                        this.generator.emit(reallyBranch ? OpCode.IF_ICMPEQ : OpCode.IF_ICMPNE, label);
                        break;
                    }
                    case GreaterThan: {
                        boolean reallyBranch = branch == (op == ExpressionType.GreaterThan);
                        this.generator.emit(reallyBranch ? OpCode.IF_ICMPGT : OpCode.IF_ICMPLE, label);
                        break;
                    }
                    case GreaterThanOrEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.GreaterThanOrEqual);
                        this.generator.emit(reallyBranch ? OpCode.IF_ICMPGE : OpCode.IF_ICMPLT, label);
                        break;
                    }
                    case LessThan: {
                        boolean reallyBranch = branch == (op == ExpressionType.LessThan);
                        this.generator.emit(reallyBranch ? OpCode.IF_ICMPLT : OpCode.IF_ICMPGE, label);
                        break;
                    }
                    case LessThanOrEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.LessThanOrEqual);
                        this.generator.emit(reallyBranch ? OpCode.IF_ICMPLE : OpCode.IF_ICMPGT, label);
                        break;
                    }
                    case NotEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.NotEqual);
                        this.generator.emit(reallyBranch ? OpCode.IF_ICMPNE : OpCode.IF_ICMPEQ, label);
                    }
                }
                break;
            }
            case LONG: {
                this.generator.emit(OpCode.LCMP);
                switch (op) {
                    case Equal: {
                        boolean reallyBranch = branch == (op == ExpressionType.Equal);
                        this.generator.emit(reallyBranch ? OpCode.IFEQ : OpCode.IFNE, label);
                        break;
                    }
                    case GreaterThan: {
                        boolean reallyBranch = branch == (op == ExpressionType.GreaterThan);
                        this.generator.emit(reallyBranch ? OpCode.IFGT : OpCode.IFLE, label);
                        break;
                    }
                    case GreaterThanOrEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.GreaterThanOrEqual);
                        this.generator.emit(reallyBranch ? OpCode.IFGE : OpCode.IFLT, label);
                        break;
                    }
                    case LessThan: {
                        boolean reallyBranch = branch == (op == ExpressionType.LessThan);
                        this.generator.emit(reallyBranch ? OpCode.IFLT : OpCode.IFGE, label);
                        break;
                    }
                    case LessThanOrEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.LessThanOrEqual);
                        this.generator.emit(reallyBranch ? OpCode.IFLE : OpCode.IFGT, label);
                        break;
                    }
                    case NotEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.NotEqual);
                        this.generator.emit(reallyBranch ? OpCode.IFNE : OpCode.IFEQ, label);
                    }
                }
                break;
            }
            case FLOAT: {
                switch (op) {
                    case Equal: {
                        boolean reallyBranch = branch == (op == ExpressionType.Equal);
                        this.generator.emit(OpCode.FCMPL);
                        this.generator.emit(reallyBranch ? OpCode.IFEQ : OpCode.IFNE, label);
                        break;
                    }
                    case GreaterThan: {
                        boolean reallyBranch = branch == (op == ExpressionType.GreaterThan);
                        this.generator.emit(reallyBranch ? OpCode.FCMPG : OpCode.FCMPL);
                        this.generator.emit(reallyBranch ? OpCode.IFGT : OpCode.IFLE, label);
                        break;
                    }
                    case GreaterThanOrEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.GreaterThanOrEqual);
                        this.generator.emit(reallyBranch ? OpCode.FCMPG : OpCode.FCMPL);
                        this.generator.emit(reallyBranch ? OpCode.IFGE : OpCode.IFLT, label);
                        break;
                    }
                    case LessThan: {
                        boolean reallyBranch = branch == (op == ExpressionType.LessThan);
                        this.generator.emit(reallyBranch ? OpCode.FCMPL : OpCode.FCMPG);
                        this.generator.emit(reallyBranch ? OpCode.IFLT : OpCode.IFGE, label);
                        break;
                    }
                    case LessThanOrEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.LessThanOrEqual);
                        this.generator.emit(reallyBranch ? OpCode.FCMPL : OpCode.FCMPG);
                        this.generator.emit(reallyBranch ? OpCode.IFLE : OpCode.IFGT, label);
                        break;
                    }
                    case NotEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.NotEqual);
                        this.generator.emit(OpCode.FCMPL);
                        this.generator.emit(reallyBranch ? OpCode.IFNE : OpCode.IFEQ, label);
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (op) {
                    case Equal: {
                        boolean reallyBranch = branch == (op == ExpressionType.Equal);
                        this.generator.emit(OpCode.DCMPL);
                        this.generator.emit(reallyBranch ? OpCode.IFEQ : OpCode.IFNE, label);
                        break;
                    }
                    case GreaterThan: {
                        boolean reallyBranch = branch == (op == ExpressionType.GreaterThan);
                        this.generator.emit(reallyBranch ? OpCode.DCMPG : OpCode.DCMPL);
                        this.generator.emit(reallyBranch ? OpCode.IFGT : OpCode.IFLE, label);
                        break;
                    }
                    case GreaterThanOrEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.GreaterThanOrEqual);
                        this.generator.emit(reallyBranch ? OpCode.DCMPG : OpCode.DCMPL);
                        this.generator.emit(reallyBranch ? OpCode.IFGE : OpCode.IFLT, label);
                        break;
                    }
                    case LessThan: {
                        boolean reallyBranch = branch == (op == ExpressionType.LessThan);
                        this.generator.emit(reallyBranch ? OpCode.DCMPL : OpCode.DCMPG);
                        this.generator.emit(reallyBranch ? OpCode.IFLT : OpCode.IFGE, label);
                        break;
                    }
                    case LessThanOrEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.LessThanOrEqual);
                        this.generator.emit(reallyBranch ? OpCode.DCMPL : OpCode.DCMPG);
                        this.generator.emit(reallyBranch ? OpCode.IFLE : OpCode.IFGT, label);
                        break;
                    }
                    case NotEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.NotEqual);
                        this.generator.emit(OpCode.DCMPL);
                        this.generator.emit(reallyBranch ? OpCode.IFNE : OpCode.IFEQ, label);
                    }
                }
                break;
            }
            default: {
                switch (op) {
                    case Equal: 
                    case ReferenceEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.Equal || op == ExpressionType.ReferenceEqual);
                        this.generator.emit(reallyBranch ? OpCode.IF_ACMPEQ : OpCode.IF_ACMPNE, label);
                        break block0;
                    }
                    case NotEqual: 
                    case ReferenceNotEqual: {
                        boolean reallyBranch = branch == (op == ExpressionType.NotEqual || op == ExpressionType.ReferenceNotEqual);
                        this.generator.emit(reallyBranch ? OpCode.IF_ACMPNE : OpCode.IF_ACMPEQ, label);
                        break block0;
                    }
                    case IsNull: {
                        boolean reallyBranch = branch == (op == ExpressionType.IsNull);
                        this.generator.emit(reallyBranch ? OpCode.IFNULL : OpCode.IFNONNULL, label);
                        break block0;
                    }
                    case IsNotNull: {
                        boolean reallyBranch = branch == (op == ExpressionType.IsNotNull);
                        this.generator.emit(reallyBranch ? OpCode.IFNONNULL : OpCode.IFNULL, label);
                    }
                }
            }
        }
    }

    private void emitBranchOp(boolean branch, Label label) {
        this.generator.emit(branch ? OpCode.IFNE : OpCode.IFEQ, label);
    }

    private void emitBranchLogical(boolean branch, BinaryExpression node, Label label) {
        boolean isAnd;
        assert (node.getNodeType() == ExpressionType.AndAlso || node.getNodeType() == ExpressionType.OrElse);
        if (node.getMethod() != null) {
            this.emitExpression(node);
            this.emitBranchOp(branch, label);
            return;
        }
        boolean bl = isAnd = node.getNodeType() == ExpressionType.AndAlso;
        if (branch == isAnd) {
            this.emitBranchAnd(branch, node, label);
        } else {
            this.emitBranchOr(branch, node, label);
        }
    }

    private void emitBranchAnd(boolean branch, BinaryExpression node, Label label) {
        Label endIf = this.generator.defineLabel();
        this.emitExpressionAndBranch(!branch, node.getLeft(), endIf);
        this.emitExpressionAndBranch(branch, node.getRight(), label);
        this.generator.markLabel(endIf);
    }

    private void emitBranchOr(boolean branch, BinaryExpression node, Label label) {
        this.emitExpressionAndBranch(branch, node.getLeft(), label);
        this.emitExpressionAndBranch(branch, node.getRight(), label);
    }

    private void emitBranchBlock(boolean branch, BlockExpression node, Label label) {
        this.enterScope(node);
        int count = node.getExpressionCount();
        for (int i = 0; i < count - 1; ++i) {
            this.emitExpressionAsVoid(node.getExpression(i));
        }
        this.emitExpressionAndBranch(branch, node.getExpression(count - 1), label);
        this.exitScope(node);
    }

    private void emitInvocationExpression(Expression expr, int flags) {
        InvocationExpression node = (InvocationExpression)expr;
        LambdaExpression<?> lambdaOperand = node.getLambdaOperand();
        if (lambdaOperand != null) {
            this.emitInlinedInvoke(node, flags);
            return;
        }
        Expression e = node.getExpression();
        if (Type.of(LambdaExpression.class).isAssignableFrom(e.getType())) {
            e = Expression.call(e, e.getType().getMethod("compile", new Type[0]), new Expression[0]);
        }
        e = Expression.call(e, Expression.getInvokeMethod(e), node.getArguments());
        this.emitExpression(e);
    }

    private void emitInlinedInvoke(InvocationExpression invoke, int flags) {
        LambdaExpression<?> lambda = invoke.getLambdaOperand();
        this.emitArguments(Expression.getInvokeMethod(lambda), invoke);
        LambdaCompiler inner = new LambdaCompiler(this, lambda);
        inner.emitLambdaBody(this._scope, true, flags);
    }

    private void emitLabelExpression(Expression expr, int flags) {
        LabelExpression node = (LabelExpression)expr;
        assert (node.getTarget() != null);
        LabelInfo label = null;
        if (this._labelBlock.kind == LabelScopeKind.Block) {
            label = this._labelBlock.tryGetLabelInfo(node.getTarget());
            if (label == null && this._labelBlock.parent.kind == LabelScopeKind.Switch) {
                label = this._labelBlock.parent.tryGetLabelInfo(node.getTarget());
            }
            assert (label != null);
        }
        if (label == null) {
            label = this.defineLabel(node.getTarget());
        }
        if (node.getDefaultValue() != null) {
            if (node.getTarget().getType() == PrimitiveTypes.Void) {
                this.emitExpressionAsVoid(node.getDefaultValue(), flags);
            } else {
                flags = LambdaCompiler.updateEmitExpressionStartFlag(flags, 1);
                this.emitExpression(node.getDefaultValue(), flags);
            }
        }
        label.mark();
    }

    private void pushLabelBlock(LabelScopeKind type) {
        this._labelBlock = new LabelScopeInfo(this._labelBlock, type);
    }

    private boolean tryPushLabelBlock(Expression node) {
        ExpressionType nodeType = node.getNodeType();
        block7: while (true) {
            switch (nodeType) {
                default: {
                    if (this._labelBlock.kind != LabelScopeKind.Expression) {
                        this.pushLabelBlock(LabelScopeKind.Expression);
                        return true;
                    }
                    return false;
                }
                case Label: {
                    if (this._labelBlock.kind == LabelScopeKind.Block) {
                        LabelTarget label = ((LabelExpression)node).getTarget();
                        if (this._labelBlock.containsTarget(label)) {
                            return false;
                        }
                        if (this._labelBlock.parent.kind == LabelScopeKind.Switch && this._labelBlock.parent.containsTarget(label)) {
                            return false;
                        }
                    }
                    this.pushLabelBlock(LabelScopeKind.Statement);
                    return true;
                }
                case Block: {
                    if (node instanceof StackSpiller.SpilledExpressionBlock) {
                        nodeType = ExpressionType.Extension;
                        continue block7;
                    }
                    this.pushLabelBlock(LabelScopeKind.Block);
                    if (this._labelBlock.parent.kind != LabelScopeKind.Switch) {
                        this.defineBlockLabels(node);
                    }
                    return true;
                }
                case Switch: {
                    this.pushLabelBlock(LabelScopeKind.Switch);
                    SwitchExpression s = (SwitchExpression)node;
                    for (SwitchCase c : s.getCases()) {
                        this.defineBlockLabels(c.getBody());
                    }
                    this.defineBlockLabels(s.getDefaultBody());
                    return true;
                }
                case Convert: {
                    if (node.getType() != PrimitiveTypes.Void) {
                        nodeType = ExpressionType.Extension;
                        continue block7;
                    }
                    this.pushLabelBlock(LabelScopeKind.Statement);
                    return true;
                }
                case Conditional: 
                case Goto: 
                case Loop: 
            }
            break;
        }
        this.pushLabelBlock(LabelScopeKind.Statement);
        return true;
    }

    private void popLabelBlock(LabelScopeKind kind) {
        assert (this._labelBlock != null && this._labelBlock.kind == kind);
        this._labelBlock = this._labelBlock.parent;
    }

    private void defineBlockLabels(Expression node) {
        if (!(node instanceof BlockExpression)) {
            return;
        }
        if (node instanceof StackSpiller.SpilledExpressionBlock) {
            return;
        }
        BlockExpression block = (BlockExpression)node;
        int n = block.getExpressionCount();
        for (int i = 0; i < n; ++i) {
            Expression e = block.getExpression(i);
            if (!(e instanceof LabelExpression)) continue;
            this.defineLabel(((LabelExpression)e).getTarget());
        }
    }

    private LabelInfo ensureLabel(LabelTarget node) {
        LabelInfo result = this._labelInfo.get(node);
        if (result == null) {
            result = new LabelInfo(this.generator, node, false);
            this._labelInfo.put(node, result);
        }
        return result;
    }

    private LabelInfo referenceLabel(LabelTarget node) {
        LabelInfo result = this.ensureLabel(node);
        result.reference(this._labelBlock);
        return result;
    }

    private LabelInfo defineLabel(LabelTarget node) {
        if (node == null) {
            return new LabelInfo(this.generator, null, false);
        }
        LabelInfo result = this.ensureLabel(node);
        result.define(this._labelBlock);
        return result;
    }

    private void emitLambdaExpression(Expression expr) {
        LambdaExpression node = (LambdaExpression)expr;
        this.emitDelegateConstruction(node);
    }

    private void emitDelegateConstruction(LambdaExpression lambda) {
        String name = StringUtilities.isNullOrEmpty(lambda.getName()) ? LambdaCompiler.getUniqueMethodName() : lambda.getName();
        LambdaCompiler compiler = new LambdaCompiler(this._tree, lambda);
        compiler.emitLambdaBody(this._scope, false, 1024);
        if (this._scope.needsClosure || this._boundConstants.count() != 0) {
            compiler.ensureClosure();
        }
        this.emitDelegateConstruction(compiler);
        compiler.typeBuilder.createType();
    }

    static String getUniqueMethodName() {
        return String.format("lambda_method_%d", nextId.getAndIncrement());
    }

    static String getUniqueLambdaName(String name, Class<?> creationContext) {
        Package p;
        if (creationContext != null) {
            p = creationContext.getPackage();
            if (p == null) {
                p = LambdaCompiler.class.getPackage();
            }
        } else {
            p = LambdaCompiler.class.getPackage();
        }
        if (name != null) {
            return String.format("%s.%s$0x%3$04x", p.getName(), name, nextId.getAndIncrement());
        }
        return String.format("%s.f__Lambda$0x%2$04x", p.getName(), nextId.getAndIncrement());
    }

    private void emitLambdaBody() {
        int tailCallFlag = this.lambda.isTailCall() ? 256 : 1024;
        this.emitLambdaBody(null, false, tailCallFlag);
    }

    private void emitLambdaBody(CompilerScope parent, boolean inlined, int flags) {
        this._scope.enter(this, parent);
        if (inlined) {
            ParameterExpressionList parameters = this.lambda.getParameters();
            for (int i = parameters.size() - 1; i >= 0; --i) {
                this._scope.emitSet((ParameterExpression)parameters.get(i));
            }
        }
        flags = LambdaCompiler.updateEmitExpressionStartFlag(flags, 1);
        Expression body = this.lambda.getBody();
        Type<?> bodyType = body.getType();
        Type returnType = this.lambda.getReturnType();
        if (returnType == PrimitiveTypes.Void) {
            this.emitExpressionAsVoid(body, flags);
        } else {
            this.emitExpression(body, flags);
            if (!TypeUtils.hasReferenceConversion(bodyType, returnType)) {
                this.generator.emitConversion(bodyType, returnType);
            }
        }
        if (!inlined) {
            this.generator.emitReturn(returnType);
        }
        this._scope.exit();
        assert (this._labelBlock.parent == null && this._labelBlock.kind == LabelScopeKind.Lambda);
        for (LabelInfo label : this._labelInfo.values()) {
            label.validateFinish();
        }
    }

    private void emitDelegateConstruction(LambdaCompiler inner) {
        this.generator.emit(OpCode.NEW, inner.typeBuilder);
        this.generator.dup();
        this.emitClosureCreation(inner);
        inner.ensureConstructor();
        this.generator.call(inner._constructorBuilder);
    }

    private void emitClosureCreation(LambdaCompiler inner) {
        boolean boundConstants;
        boolean closure = inner._scope.needsClosure;
        boolean bl = boundConstants = inner._boundConstants.count() > 0;
        if (!closure && !boundConstants) {
            return;
        }
        inner.ensureClosure();
        if (boundConstants) {
            this.ensureClosure();
        }
        Type<Object[]> objectArrayType = Type.of(Object[].class);
        this.generator.emit(OpCode.NEW, closureType);
        this.generator.dup();
        if (boundConstants) {
            this._boundConstants.emitConstant(this, inner._boundConstants.toArray(), objectArrayType);
        } else {
            this.generator.emitNull();
        }
        if (closure) {
            this._scope.emitGet(this._scope.getNearestHoistedLocals().selfVariable);
        } else {
            this.generator.emitNull();
        }
        this.generator.call(closureType.getConstructor(objectArrayType, objectArrayType));
    }

    private void ensureConstructor() {
        if (this._constructorBuilder == null) {
            this._constructorBuilder = this.typeBuilder.defineDefaultConstructor();
        }
    }

    private void ensureClosure() {
        if (this._hasClosureArgument) {
            return;
        }
        this._hasClosureArgument = true;
        this._closureField = this.typeBuilder.defineField("$__closure", Type.of(Closure.class), 18);
        this._constructorBuilder = this.typeBuilder.defineConstructor(1, Type.list(closureType));
        CodeGenerator ctor = this._constructorBuilder.getCodeGenerator();
        ctor.emitThis();
        ctor.call((ConstructorInfo)Types.Object.getConstructors().get(0));
        ctor.emitThis();
        ctor.emitLoadArgument(0);
        ctor.putField(this._closureField);
        ctor.emitReturn();
    }

    final void emitConstantArray(Object array) {
        if (this.typeBuilder != null) {
            FieldBuilder fb = this.createStaticField("ConstantArray", Type.getType(array));
            Label l = this.generator.defineLabel();
            this.generator.getField(fb);
            this.generator.emit(OpCode.IFNONNULL, l);
            this.generator.emitConstantArray(array);
            this.generator.putField(fb);
            this.generator.markLabel(l);
            this.generator.getField(fb);
        } else {
            this.generator.emitConstantArray(array);
        }
    }

    private void emitLoopExpression(Expression expr) {
        LoopExpression node = (LoopExpression)expr;
        this.pushLabelBlock(LabelScopeKind.Statement);
        LabelInfo breakTarget = this.defineLabel(node.getBreakTarget());
        LabelInfo continueTarget = this.defineLabel(node.getContinueTarget());
        continueTarget.markWithEmptyStack();
        this.emitExpressionAsVoid(node.getBody());
        this.generator.emitGoto(continueTarget.getLabel());
        this.popLabelBlock(LabelScopeKind.Statement);
        breakTarget.markWithEmptyStack();
    }

    private void emitMemberExpression(Expression expr) {
        MemberExpression node = (MemberExpression)expr;
        if (node.getTarget() != null) {
            this.emitExpression(node.getTarget());
        }
        this.emitMemberGet(node.getMember());
    }

    private void emitMemberGet(MemberInfo member) {
        switch (member.getMemberType()) {
            case Field: {
                FieldInfo field = (FieldInfo)member;
                Type<?> fieldType = field.getFieldType();
                try {
                    boolean isConstant;
                    Object constantValue;
                    if (field instanceof FieldBuilder) {
                        FieldBuilder fb = (FieldBuilder)field;
                        constantValue = fb.getConstantValue();
                        isConstant = constantValue != null && field.isFinal();
                    } else {
                        isConstant = field.isStatic() && field.isFinal() && (fieldType.isPrimitive() || fieldType.isEnum() || Types.String.isEquivalentTo(fieldType));
                        Object object = constantValue = isConstant ? field.getRawField().get(null) : null;
                    }
                    if (isConstant) {
                        this.emitConstant(constantValue, fieldType);
                        break;
                    }
                }
                catch (IllegalAccessException ignored) {
                    // empty catch block
                }
                this.generator.getField(field);
                break;
            }
            default: {
                throw ContractUtils.unreachable();
            }
        }
    }

    private void emitMethodCallExpression(Expression expr) {
        this.emitMethodCallExpression(expr, 1024);
    }

    private void emitMethodCallExpression(Expression expr, int flags) {
        MethodCallExpression node = (MethodCallExpression)expr;
        this.emitMethodCall(node.getTarget(), node.getMethod(), node, flags);
    }

    private void emitMethodCall(Expression target, MethodInfo method, IArgumentProvider methodCallExpr) {
        this.emitMethodCall(target, method, methodCallExpr, 1024);
    }

    private void emitMethodCall(Expression target, MethodInfo method, IArgumentProvider expr, int flags) {
        Type<?> targetType = null;
        if (!method.isStatic()) {
            targetType = target.getType();
            this.emitExpression(target);
        }
        this.emitMethodCall(method, expr, targetType, flags);
    }

    private void emitMethodCall(Expression target, MethodInfo method, MethodCallExpression expr, int flags) {
        Type<?> targetType = null;
        if (!method.isStatic()) {
            targetType = target.getType();
            this.emitExpression(target);
        }
        this.emitMethodCall(method, expr, targetType, target instanceof SuperExpression ? flags | 0x1000 : flags);
    }

    private void emitMethodCall(MethodInfo method, IArgumentProvider args, Type<?> objectType, int flags) {
        MethodInfo erasedDefinition;
        this.emitArguments(method, args);
        if ((flags & 0x1000) != 0) {
            MethodInfo superMethod = objectType.getMethod(method.getName(), BindingFlags.AllInstance, (Type[])method.getParameters().getParameterTypes().toArray());
            this.generator.call(OpCode.INVOKESPECIAL, superMethod);
        } else {
            this.generator.call(method);
        }
        Type<?> returnType = method.getReturnType();
        if (returnType != PrimitiveTypes.Void && (method.isGenericMethod() || method.getDeclaringType().isGenericType()) && (erasedDefinition = method.getErasedMethodDefinition()) != null) {
            this.generator.emitConversion(erasedDefinition.getReturnType(), returnType);
        }
    }

    private void emitArguments(MethodBase method, IArgumentProvider args) {
        this.emitArguments(method, args, 0);
    }

    private void emitArguments(MethodBase method, IArgumentProvider args, int skipParameters) {
        TypeList parameters = method instanceof MethodBuilder ? ((MethodBuilder)method).getParameterTypes() : (method instanceof ConstructorBuilder ? ((ConstructorBuilder)method).getMethodBuilder().getParameterTypes() : method.getParameters().getParameterTypes());
        assert (args.getArgumentCount() + skipParameters == parameters.size());
        int n = parameters.size();
        for (int i = skipParameters; i < n; ++i) {
            Type parameterType = (Type)parameters.get(i);
            Expression argument = args.getArgument(i - skipParameters);
            this.emitExpression(argument);
            Type<?> argumentType = argument.getType();
            if (method instanceof DynamicMethod) {
                if (argumentType == parameterType) continue;
                this.generator.emitConversion(argumentType, parameterType);
                continue;
            }
            if (TypeUtils.hasReferenceConversion(argumentType, parameterType)) continue;
            this.generator.emitConversion(argumentType, parameterType);
        }
    }

    private void emitNewExpression(Expression expr) {
        NewExpression node = (NewExpression)expr;
        ConstructorInfo constructor = node.getConstructor();
        if (constructor == null) {
            assert (node.getArguments().size() == 0) : "Node with arguments must have a constructor.";
            assert (node.getType().isPrimitive()) : "Only primitive type may have no constructor set.";
            this.generator.emitDefaultValue(node.getType());
            return;
        }
        this.generator.emitNew(constructor.getDeclaringType());
        this.generator.dup();
        this.emitArguments(constructor, node);
        this.generator.call(constructor);
    }

    private void emitNewArrayExpression(Expression expr) {
        NewArrayExpression node = (NewArrayExpression)expr;
        final ExpressionList<? extends Expression> expressions = node.getExpressions();
        final Type<?> elementType = node.getType().getElementType();
        if (node.getNodeType() == ExpressionType.NewArrayInit) {
            this.generator.emitArray(node.getType().getElementType(), node.getExpressions().size(), new CodeGenerator.EmitArrayElementCallback(){

                @Override
                public void emit(int index) {
                    Object element = expressions.get(index);
                    LambdaCompiler.this.emitExpression((Expression)element);
                    LambdaCompiler.this.generator.emitConversion(((Expression)element).getType(), elementType);
                }
            });
        } else {
            int n = expressions.size();
            for (int i = 0; i < n; ++i) {
                Expression x = expressions.get(i);
                this.emitExpression(x);
                this.generator.emitConversion(x.getType(), PrimitiveTypes.Integer);
            }
            this.generator.emitNewArray(node.getType());
        }
    }

    private void emitParameterExpression(Expression expr) {
        ParameterExpression node = (ParameterExpression)expr;
        if (node instanceof SelfExpression || node instanceof SuperExpression) {
            if (this.methodBuilder.isStatic()) {
                throw Error.cannotAccessThisFromStaticMember();
            }
            if (node instanceof SelfExpression) {
                if (node.getType() != this.typeBuilder) {
                    throw Error.incorrectlyTypedSelfExpression(this.typeBuilder, node.getType());
                }
            } else if (node.getType() != this.typeBuilder.getBaseType()) {
                throw Error.incorrectlyTypedSuperExpression(this.typeBuilder, node.getType());
            }
            this.generator.emitThis();
            return;
        }
        this._scope.emitGet(node);
    }

    private void emitRuntimeVariablesExpression(Expression expr) {
        RuntimeVariablesExpression node = (RuntimeVariablesExpression)expr;
        this._scope.emitVariableAccess(this, node.getVariables());
    }

    private void emitTypeBinaryExpression(Expression expr) {
        TypeBinaryExpression node = (TypeBinaryExpression)expr;
        if (node.getNodeType() == ExpressionType.TypeEqual) {
            this.emitExpression(node.reduceTypeEqual());
            return;
        }
        Type type = node.getTypeOperand();
        AnalyzeTypeIsResult result = ConstantCheck.analyzeInstanceOf(node);
        if (result == AnalyzeTypeIsResult.KnownTrue || result == AnalyzeTypeIsResult.KnownFalse) {
            this.emitExpressionAsVoid(node.getOperand());
            this.generator.emitBoolean(result == AnalyzeTypeIsResult.KnownTrue);
            return;
        }
        if (result == AnalyzeTypeIsResult.KnownAssignable) {
            assert (!type.isPrimitive());
            Label ifNull = this.generator.defineLabel();
            Label exit = this.generator.defineLabel();
            this.emitExpression(node.getOperand());
            this.generator.emit(OpCode.IFNULL, ifNull);
            this.generator.emitBoolean(true);
            this.generator.emitGoto(exit);
            this.generator.markLabel(ifNull);
            this.generator.emitBoolean(false);
            this.generator.markLabel(exit);
            return;
        }
        assert (result == AnalyzeTypeIsResult.Unknown);
        this.emitExpression(node.getOperand());
        this.generator.emit(OpCode.INSTANCEOF, type);
    }

    private void emitUnaryExpression(Expression expr, int flags) {
        this.emitUnary((UnaryExpression)expr, flags);
    }

    private void emitUnary(UnaryExpression node, int flags) {
        if (node.getMethod() != null) {
            this.emitUnaryMethod(node, flags);
        } else {
            this.emitExpression(node.getOperand());
            this.emitUnaryOperator(node.getNodeType(), node.getOperand().getType(), node.getType());
        }
    }

    private void emitUnaryOperator(ExpressionType op, Type operandType, Type resultType) {
        boolean operandIsBoxed = TypeUtils.isAutoUnboxed(operandType);
        switch (op) {
            case ArrayLength: {
                this.generator.emit(OpCode.ARRAYLENGTH);
                return;
            }
            case IsNull: {
                Label ifNonNull = this.generator.defineLabel();
                Label exit = this.generator.defineLabel();
                this.generator.emit(OpCode.IFNONNULL, ifNonNull);
                this.generator.emitBoolean(true);
                this.generator.emitGoto(exit);
                this.generator.markLabel(ifNonNull);
                this.generator.emitBoolean(false);
                this.generator.markLabel(exit);
                return;
            }
            case IsNotNull: {
                Label ifNull = this.generator.defineLabel();
                Label exit = this.generator.defineLabel();
                this.generator.emit(OpCode.IFNULL, ifNull);
                this.generator.emitBoolean(true);
                this.generator.emitGoto(exit);
                this.generator.markLabel(ifNull);
                this.generator.emitBoolean(false);
                this.generator.markLabel(exit);
                return;
            }
        }
        Type<?> unboxedType = TypeUtils.getUnderlyingPrimitiveOrSelf(operandType);
        if (operandIsBoxed) {
            this.generator.emitUnbox(operandType);
        }
        block5 : switch (op) {
            case Not: 
            case OnesComplement: {
                switch (unboxedType.getKind()) {
                    case BOOLEAN: {
                        Label ifTrue = this.generator.defineLabel();
                        Label exit = this.generator.defineLabel();
                        this.generator.emitBoolean(false);
                        this.generator.emit(OpCode.IF_ICMPNE, ifTrue);
                        this.generator.emitBoolean(true);
                        this.generator.emitGoto(exit);
                        this.generator.markLabel(ifTrue);
                        this.generator.emitBoolean(false);
                        this.generator.markLabel(exit);
                        break block5;
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emitInteger(-1);
                        this.generator.emit(OpCode.IXOR);
                        break block5;
                    }
                    case LONG: {
                        this.generator.emitLong(-1L);
                        this.generator.emit(OpCode.LXOR);
                        break block5;
                    }
                    case CHAR: {
                        this.generator.emitInteger(-1);
                        this.generator.emit(OpCode.IXOR);
                        break block5;
                    }
                }
                throw Error.unaryOperatorNotDefined(op, unboxedType);
            }
            case IsFalse: {
                Label ifTrue = this.generator.defineLabel();
                Label exit = this.generator.defineLabel();
                this.generator.emitBoolean(false);
                this.generator.emit(OpCode.IF_ICMPNE, ifTrue);
                this.generator.emitBoolean(true);
                this.generator.emitGoto(exit);
                this.generator.markLabel(ifTrue);
                this.generator.emitBoolean(false);
                this.generator.markLabel(exit);
                return;
            }
            case IsTrue: {
                Label ifFalse = this.generator.defineLabel();
                Label exit = this.generator.defineLabel();
                this.generator.emitBoolean(false);
                this.generator.emit(OpCode.IF_ICMPEQ, ifFalse);
                this.generator.emitBoolean(true);
                this.generator.emitGoto(exit);
                this.generator.markLabel(ifFalse);
                this.generator.emitBoolean(false);
                this.generator.markLabel(exit);
                return;
            }
            case UnaryPlus: {
                this.generator.emit(OpCode.NOP);
                break;
            }
            case Negate: {
                switch (unboxedType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emit(OpCode.INEG);
                        break block5;
                    }
                    case LONG: {
                        this.generator.emit(OpCode.LNEG);
                        break block5;
                    }
                    case CHAR: {
                        this.generator.emit(OpCode.INEG);
                        break block5;
                    }
                    case FLOAT: {
                        this.generator.emit(OpCode.FNEG);
                        break block5;
                    }
                    case DOUBLE: {
                        this.generator.emit(OpCode.DNEG);
                        break block5;
                    }
                }
                throw Error.unaryOperatorNotDefined(op, unboxedType);
            }
            case Increment: {
                switch (unboxedType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emitInteger(1);
                        this.generator.emit(OpCode.IADD);
                        break block5;
                    }
                    case LONG: {
                        this.generator.emitLong(1L);
                        this.generator.emit(OpCode.LADD);
                        break block5;
                    }
                    case CHAR: {
                        this.generator.emitInteger(1);
                        this.generator.emit(OpCode.IADD);
                        break block5;
                    }
                    case FLOAT: {
                        this.generator.emitFloat(1.0f);
                        this.generator.emit(OpCode.FADD);
                        break block5;
                    }
                    case DOUBLE: {
                        this.generator.emitDouble(1.0);
                        this.generator.emit(OpCode.DADD);
                        break block5;
                    }
                }
                throw Error.unaryOperatorNotDefined(op, unboxedType);
            }
            case Decrement: {
                switch (unboxedType.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.generator.emitInteger(1);
                        this.generator.emit(OpCode.ISUB);
                        break block5;
                    }
                    case LONG: {
                        this.generator.emitLong(1L);
                        this.generator.emit(OpCode.LSUB);
                        break block5;
                    }
                    case CHAR: {
                        this.generator.emitInteger(1);
                        this.generator.emit(OpCode.ISUB);
                        break block5;
                    }
                    case FLOAT: {
                        this.generator.emitFloat(1.0f);
                        this.generator.emit(OpCode.FSUB);
                        break block5;
                    }
                    case DOUBLE: {
                        this.generator.emitDouble(1.0);
                        this.generator.emit(OpCode.DSUB);
                        break block5;
                    }
                }
                throw Error.unaryOperatorNotDefined(op, unboxedType);
            }
            default: {
                throw Error.unhandledUnary(op);
            }
        }
        this.emitConvertArithmeticResult(op, unboxedType, resultType);
    }

    private void emitUnaryMethod(UnaryExpression node, int flags) {
        MethodInfo method = node.getMethod();
        if (method.isStatic()) {
            this.emitMethodCallExpression(Expression.call(method, node.getOperand()), flags);
        } else {
            this.emitMethodCallExpression(Expression.call(node.getOperand(), method, new Expression[0]), flags);
        }
    }

    private void emitConvertUnaryExpression(Expression expr, int flags) {
        this.emitConvert((UnaryExpression)expr, flags);
    }

    private void emitConvert(UnaryExpression node, int flags) {
        if (node.getMethod() != null) {
            this.emitUnaryMethod(node, flags);
        } else if (node.getType() == PrimitiveTypes.Void) {
            this.emitExpressionAsVoid(node.getOperand(), flags);
        } else if (TypeUtils.areEquivalent(node.getOperand().getType(), node.getType())) {
            this.emitExpression(node.getOperand(), flags);
        } else {
            this.emitExpression(node.getOperand());
            this.generator.emitConversion(node.getOperand().getType(), node.getType());
        }
    }

    private void emitUnboxUnaryExpression(Expression expr) {
        UnaryExpression node = (UnaryExpression)expr;
        assert (node.getType().isPrimitive());
        this.emitExpression(node.getOperand());
        this.generator.emitUnbox(node.getType());
    }

    private void emitThrowUnaryExpression(Expression expr) {
        this.emitThrow((UnaryExpression)expr, 16);
    }

    private void emitThrow(UnaryExpression expr, int flags) {
        this.emitExpression(expr.getOperand());
        this.generator.emit(OpCode.ATHROW);
        this.emitUnreachable(expr, flags);
    }

    private void emitTryExpression(Expression expr) {
        LocalBuilder value;
        TryExpression node = (TryExpression)expr;
        this.checkTry();
        this.pushLabelBlock(LabelScopeKind.Try);
        this.generator.beginExceptionBlock();
        this.enterTry(node);
        this.emitExpression(node.getBody());
        this.exitTry(node);
        this.generator.endTryBlock();
        Expression finallyBlock = node.getFinallyBlock();
        Type<?> tryType = expr.getType();
        if (tryType != PrimitiveTypes.Void) {
            value = this.getLocal(tryType);
            this.generator.emitStore(value);
        } else {
            value = null;
        }
        if (finallyBlock != null) {
            this.emitExpression(finallyBlock);
        }
        for (CatchBlock cb : node.getHandlers()) {
            this.pushLabelBlock(LabelScopeKind.Catch);
            if (cb.getFilter() != null) {
                throw new UnsupportedOperationException("Filter blocks are not yet supported");
            }
            this.generator.beginCatchBlock(cb.getTest());
            this.enterScope(cb);
            this.emitCatchStart(cb);
            this.emitExpression(cb.getBody());
            if (tryType != PrimitiveTypes.Void) {
                this.generator.emitStore(value);
            }
            if (finallyBlock != null) {
                this.emitExpression(finallyBlock);
            }
            this.exitScope(cb);
            this.popLabelBlock(LabelScopeKind.Catch);
        }
        if (finallyBlock != null) {
            this.pushLabelBlock(LabelScopeKind.Finally);
            this.generator.beginFinallyBlock();
            LocalBuilder exceptionTemp = this.getLocal(Types.Throwable);
            this.generator.emitStore(exceptionTemp);
            this.emitExpression(finallyBlock);
            this.generator.emitLoad(exceptionTemp);
            this.generator.emit(OpCode.ATHROW);
            this.generator.endExceptionBlock();
            this.popLabelBlock(LabelScopeKind.Finally);
        } else {
            this.generator.endExceptionBlock();
        }
        if (tryType != PrimitiveTypes.Void) {
            this.generator.emitLoad(value);
            this.freeLocal(value);
        }
        this.popLabelBlock(LabelScopeKind.Try);
    }

    private void emitCatchStart(CatchBlock cb) {
        if (cb.getFilter() == null) {
            this.emitSaveExceptionOrPop(cb);
            return;
        }
        Label endFilter = this.generator.defineLabel();
        Label rightType = this.generator.defineLabel();
        this.generator.emit(OpCode.INSTANCEOF, cb.getTest());
        this.generator.dup();
        this.generator.emit(OpCode.IFNE, rightType);
        this.generator.pop();
        this.generator.emitBoolean(false);
        this.generator.emitGoto(endFilter);
        this.generator.markLabel(rightType);
        this.emitSaveExceptionOrPop(cb);
        this.pushLabelBlock(LabelScopeKind.Filter);
        this.emitExpression(cb.getFilter());
        this.popLabelBlock(LabelScopeKind.Filter);
        this.generator.markLabel(endFilter);
        this.generator.beginCatchBlock(null);
        this.generator.pop();
    }

    private void checkTry() {
        LabelScopeInfo j = this._labelBlock;
        while (j != null) {
            if (j.kind == LabelScopeKind.Filter) {
                throw Error.tryNotAllowedInFilter();
            }
            j = j.parent;
        }
    }

    private void emitSaveExceptionOrPop(CatchBlock cb) {
        if (cb.getVariable() != null) {
            this._scope.emitSet(cb.getVariable());
        } else {
            this.generator.pop();
        }
    }

    private void emitSwitchExpression(Expression expr, int flags) {
        SwitchExpression node = (SwitchExpression)expr;
        if (this.tryEmitLookupSwitch(node, flags)) {
            return;
        }
        if (this.tryEmitStringSwitch(node, flags)) {
            return;
        }
        throw ContractUtils.unsupported();
    }

    private boolean tryEmitStringSwitch(final SwitchExpression node, final int flags) {
        Type<?> type = node.getSwitchValue().getType();
        if (!TypeUtils.areEquivalent(type, Types.String)) {
            return false;
        }
        MethodInfo comparison = node.getComparison();
        MethodInfo comparerEquals = Types.Comparer.getMethod("equals", BindingFlags.PublicStatic, Types.Object, Types.Object);
        if (comparison.getRawMethod() != comparerEquals.getRawMethod()) {
            return false;
        }
        int tests = 0;
        for (SwitchCase c : node.getCases()) {
            for (Expression expression : c.getTestValues()) {
                if (expression instanceof ConstantExpression) {
                    ++tests;
                    continue;
                }
                return false;
            }
        }
        String[] keys = new String[tests];
        final HashMap<String, Expression> caseBodies = new HashMap<String, Expression>();
        int i = 0;
        for (SwitchCase c : node.getCases()) {
            ExpressionList<? extends Expression> testValues = c.getTestValues();
            int n = testValues.size();
            for (int j = 0; j < n; ++j) {
                String s = (String)((ConstantExpression)testValues.get(j)).getValue();
                keys[i++] = s;
                caseBodies.put(s, c.getBody());
            }
        }
        SwitchOptions switchOptions = node.getOptions();
        this.emitExpression(node.getSwitchValue());
        this.generator.emitSwitch(keys, new StringSwitchCallback(){

            @Override
            public void emitCase(String key, Label breakTarget) throws Exception {
                Expression body = (Expression)caseBodies.get(key);
                if (body == null) {
                    return;
                }
                Type<?> nodeType = node.getType();
                if (nodeType == PrimitiveTypes.Void) {
                    LambdaCompiler.this.emitExpressionAsVoid(body, flags);
                } else {
                    LambdaCompiler.this.emitExpressionAsType(body, nodeType, flags);
                }
                LambdaCompiler.this.generator.emitGoto(breakTarget);
            }

            @Override
            public void emitDefault(Label breakTarget) throws Exception {
                Expression defaultBody = node.getDefaultBody();
                if (defaultBody == null) {
                    return;
                }
                Type<?> nodeType = node.getType();
                if (nodeType == PrimitiveTypes.Void) {
                    LambdaCompiler.this.emitExpressionAsVoid(defaultBody, flags);
                } else {
                    LambdaCompiler.this.emitExpressionAsType(defaultBody, nodeType, flags);
                }
            }
        }, switchOptions);
        return true;
    }

    private boolean tryEmitLookupSwitch(final SwitchExpression node, final int flags) {
        if (node.getComparison() != null) {
            return false;
        }
        Type<?> type = node.getSwitchValue().getType();
        ReadOnlyList<SwitchCase> cases = node.getCases();
        if (!LambdaCompiler.canOptimizeSwitchType(type) || !TypeUtils.areEquivalent(type, cases.get(0).getTestValues().get(0).getType())) {
            return false;
        }
        int tests = 0;
        for (SwitchCase c : node.getCases()) {
            for (Expression expression : c.getTestValues()) {
                if (expression instanceof ConstantExpression) {
                    ++tests;
                    continue;
                }
                return false;
            }
        }
        boolean isEnum = type.isEnum();
        int[] keys = new int[tests];
        final HashMap<Integer, Expression> caseBodies = new HashMap<Integer, Expression>();
        boolean bl = false;
        int n = cases.size();
        for (int j = 0; j < n; ++j) {
            SwitchCase switchCase = cases.get(j);
            ExpressionList<? extends Expression> testValues = switchCase.getTestValues();
            int m = testValues.size();
            for (int k = 0; k < m; ++k) {
                ConstantExpression test = (ConstantExpression)testValues.get(k);
                int key = isEnum ? ((Enum)test.getValue()).ordinal() : ((Number)test.getValue()).intValue();
                keys[++var9_12] = key;
                if (k != m - 1) continue;
                caseBodies.put(key, switchCase.getBody());
            }
        }
        Arrays.sort(keys);
        this.emitExpression(node.getSwitchValue());
        if (isEnum) {
            this.generator.call(type.getMethod("ordinal", new Type[0]));
        }
        this.generator.emitSwitch(keys, new SwitchCallback(){

            @Override
            public void emitCase(int key, Label breakTarget) throws Exception {
                Expression body = (Expression)caseBodies.get(key);
                if (body == null) {
                    return;
                }
                Type<?> nodeType = node.getType();
                if (nodeType == PrimitiveTypes.Void) {
                    LambdaCompiler.this.emitExpressionAsVoid(body, flags);
                } else {
                    LambdaCompiler.this.emitExpressionAsType(body, nodeType, flags);
                }
                LambdaCompiler.this.generator.emitGoto(breakTarget);
            }

            @Override
            public void emitDefault(Label breakTarget) throws Exception {
                Expression defaultBody = node.getDefaultBody();
                if (defaultBody == null) {
                    return;
                }
                Type<?> nodeType = node.getType();
                if (nodeType == PrimitiveTypes.Void) {
                    LambdaCompiler.this.emitExpressionAsVoid(defaultBody, flags);
                } else {
                    LambdaCompiler.this.emitExpressionAsType(defaultBody, nodeType, flags);
                }
            }
        }, node.getOptions());
        return true;
    }

    private static boolean canOptimizeSwitchType(Type<?> valueType) {
        Type<?> actualValueType = TypeUtils.getUnderlyingPrimitiveOrSelf(valueType);
        switch (actualValueType.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case CHAR: {
                return true;
            }
        }
        return actualValueType.isEnum();
    }

    private static final class CompilationFlags {
        private static final int EmitExpressionStart = 1;
        private static final int EmitNoExpressionStart = 2;
        private static final int EmitAsDefaultType = 16;
        private static final int EmitAsVoidType = 32;
        private static final int EmitAsTail = 256;
        private static final int EmitAsMiddle = 512;
        private static final int EmitAsNoTail = 1024;
        private static final int EmitExpressionStartMask = 15;
        private static final int EmitAsTypeMask = 240;
        private static final int EmitAsTailCallMask = 3840;
        private static final int EmitAsSuperCall = 4096;

        private CompilationFlags() {
        }
    }
}

