/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.IArgumentProvider;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.reflection.Type;

public final class InvocationExpression
extends Expression
implements IArgumentProvider {
    private final ExpressionList<? extends Expression> _arguments;
    private final Expression _lambda;
    private final Type _returnType;

    InvocationExpression(Expression lambda, ExpressionList<? extends Expression> arguments, Type returnType) {
        this._lambda = lambda;
        this._arguments = arguments;
        this._returnType = returnType;
    }

    @Override
    public final Type<?> getType() {
        return this._returnType;
    }

    @Override
    public final ExpressionType getNodeType() {
        return ExpressionType.Invoke;
    }

    public Expression getExpression() {
        return this._lambda;
    }

    public ExpressionList<? extends Expression> getArguments() {
        return this._arguments;
    }

    @Override
    public int getArgumentCount() {
        return this._arguments.size();
    }

    @Override
    public Expression getArgument(int index) {
        return this._arguments.get(index);
    }

    public InvocationExpression update(LambdaExpression lambda, ExpressionList<? extends Expression> arguments) {
        if (lambda == this._lambda && arguments == this._arguments) {
            return this;
        }
        return InvocationExpression.invoke((Expression)lambda, arguments);
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitInvocation(this);
    }

    InvocationExpression rewrite(LambdaExpression lambda, ExpressionList<? extends Expression> arguments) {
        assert (lambda != null);
        assert (arguments == null || arguments.size() == this._arguments.size());
        return Expression.invoke((Expression)lambda, arguments != null ? arguments : this._arguments);
    }

    LambdaExpression<?> getLambdaOperand() {
        return this._lambda.getNodeType() == ExpressionType.Quote ? (LambdaExpression)((UnaryExpression)this._lambda).getOperand() : (this._lambda instanceof LambdaExpression ? (LambdaExpression)this._lambda : null);
    }
}

