/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.expressions.Error;
import com.strobel.expressions.Expression;
import com.strobel.util.EmptyArrayCache;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.RandomAccess;

public class ExpressionList<T extends Expression>
implements Iterable<T>,
RandomAccess {
    private static final ExpressionList EMPTY = new ExpressionList(EmptyArrayCache.fromElementType(Expression.class));
    private final T[] _expressions;

    public static <T extends Expression> ExpressionList<T> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public ExpressionList(T ... expressions) {
        this._expressions = (Expression[])Arrays.copyOf(VerifyArgument.noNullElements(expressions, "expressions"), expressions.length);
    }

    protected ExpressionList<T> newInstance(T[] expressions) {
        return new ExpressionList(expressions);
    }

    public int size() {
        return this._expressions.length;
    }

    public boolean isEmpty() {
        return this._expressions.length == 0;
    }

    public boolean contains(T expression) {
        return this.indexOf(expression) != -1;
    }

    @Override
    public ListIterator<T> iterator() {
        return new ExpressionListIterator();
    }

    public ListIterator<T> iterator(int index) {
        VerifyArgument.inRange(0, this._expressions.length, index, "index");
        return new ExpressionListIterator(index);
    }

    public T[] toArray() {
        int size = this.size();
        if (size == 0) {
            return (Expression[])EmptyArrayCache.fromArrayType(this._expressions.getClass());
        }
        Expression[] array = (Expression[])Array.newInstance(this._expressions.getClass().getComponentType(), size);
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] array = a != null && a.length >= size ? a : (Object[])Array.newInstance(this._expressions.getClass().getComponentType(), size);
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public ExpressionList<T> add(T expression) {
        return this.newInstance((Expression[])ArrayUtilities.append(this._expressions, expression));
    }

    public ExpressionList<T> remove(T expression) {
        if (this._expressions.length == 1 && this._expressions[0].equals(expression)) {
            return ExpressionList.empty();
        }
        return this.newInstance((Expression[])ArrayUtilities.removeFirst(this._expressions, expression));
    }

    @SafeVarargs
    public final ExpressionList<T> addAll(int index, T ... expressions) {
        VerifyArgument.inRange(0, this._expressions.length, index, "index");
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.newInstance((Expression[])ArrayUtilities.insert(this._expressions, index, expressions));
    }

    public ExpressionList<T> addAll(int index, ExpressionList<T> c) {
        VerifyArgument.inRange(0, this._expressions.length, index, "index");
        if (c == null || c.size() == 0) {
            return this;
        }
        return this.newInstance((Expression[])ArrayUtilities.insert(this._expressions, index, c._expressions));
    }

    @SafeVarargs
    public final ExpressionList<T> addAll(T ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.newInstance((Expression[])ArrayUtilities.insert(this._expressions, this.size(), expressions));
    }

    public ExpressionList<T> addAll(ExpressionList<T> c) {
        if (c == null || c.size() == 0) {
            return this;
        }
        return this.newInstance((Expression[])ArrayUtilities.insert(this._expressions, this.size(), c._expressions));
    }

    @SafeVarargs
    public final ExpressionList<T> removeAll(T ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.newInstance((Expression[])ArrayUtilities.removeAll(this._expressions, expressions));
    }

    public ExpressionList<T> removeAll(ExpressionList<? extends T> c) {
        if (c == null || c.size() == 0) {
            return this;
        }
        return this.newInstance((Expression[])ArrayUtilities.removeAll(this._expressions, c._expressions));
    }

    @SafeVarargs
    public final ExpressionList<T> retainAll(T ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.newInstance((Expression[])ArrayUtilities.removeAll(this._expressions, expressions));
    }

    public ExpressionList<T> retainAll(ExpressionList<? extends T> c) {
        if (c == null || c.size() == 0) {
            return this;
        }
        return this.newInstance((Expression[])ArrayUtilities.removeAll(this._expressions, c._expressions));
    }

    public T get(int index) {
        VerifyArgument.inRange(0, this._expressions.length, index, "index");
        return this._expressions[index];
    }

    public ExpressionList<T> replace(int index, T expression) {
        VerifyArgument.inRange(0, this._expressions.length, index, "index");
        Expression[] expressions = (Expression[])Arrays.copyOf(this._expressions, this._expressions.length);
        expressions[index] = expression;
        return this.newInstance(expressions);
    }

    public ExpressionList<T> add(int index, T expression) {
        VerifyArgument.inRange(0, this._expressions.length, index, "index");
        return this.newInstance((Expression[])ArrayUtilities.insert(this._expressions, index, expression));
    }

    public ExpressionList<T> remove(int index) {
        VerifyArgument.inRange(0, this._expressions.length, index, "index");
        return this.newInstance((Expression[])ArrayUtilities.remove(this._expressions, index));
    }

    public int indexOf(T expression) {
        return ArrayUtilities.indexOf(this._expressions, expression);
    }

    public int lastIndexOf(T expression) {
        return ArrayUtilities.lastIndexOf(this._expressions, expression);
    }

    public ExpressionList<T> getRange(int fromIndex, int toIndex) {
        VerifyArgument.validElementRange(this._expressions.length, fromIndex, toIndex);
        return this.newInstance((Expression[])Arrays.copyOfRange(this._expressions, fromIndex, toIndex));
    }

    private final class ExpressionListIterator
    implements ListIterator<T> {
        private int _position = -1;

        ExpressionListIterator() {
        }

        ExpressionListIterator(int startPosition) {
            if (startPosition < -1 || startPosition >= ExpressionList.this.size()) {
                throw new IllegalArgumentException();
            }
            this._position = startPosition;
        }

        @Override
        public boolean hasNext() {
            return this._position + 1 < ExpressionList.this.size();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            return ExpressionList.this.get(++this._position);
        }

        @Override
        public boolean hasPrevious() {
            return this._position > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new IllegalStateException();
            }
            return ExpressionList.this.get(--this._position);
        }

        @Override
        public int nextIndex() {
            return this._position + 1;
        }

        @Override
        public int previousIndex() {
            return this._position + 1;
        }

        @Override
        public void remove() {
            throw Error.unmodifiableCollection();
        }

        @Override
        public void set(T expression) {
            throw Error.unmodifiableCollection();
        }

        @Override
        public void add(T expression) {
            throw Error.unmodifiableCollection();
        }
    }
}

