/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.StringUtilities;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class BreakStatement
extends Statement {
    public static final TokenRole BREAK_KEYWORD_ROLE = new TokenRole("break", 1);

    public BreakStatement(int offset) {
        super(offset);
    }

    public BreakStatement(int offset, String label) {
        super(offset);
        this.setLabel(label);
    }

    public final JavaTokenNode getBreakToken() {
        return this.getChildByRole(BREAK_KEYWORD_ROLE);
    }

    public final JavaTokenNode getSemicolonToken() {
        return this.getChildByRole(Roles.SEMICOLON);
    }

    public final String getLabel() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setLabel(String value) {
        if (StringUtilities.isNullOrEmpty(value)) {
            this.setChildByRole(Roles.IDENTIFIER, Identifier.create(null));
        } else {
            this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
        }
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitBreakStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof BreakStatement && BreakStatement.matchString(this.getLabel(), ((BreakStatement)other).getLabel());
    }
}

