# Leo colorizer control file for ocaml mode.
# This file is in the public domain.

# Properties for ocaml mode.
properties = {
    "commentEnd": "*)",
    "commentStart": "(*",
    "indentNextLines": "\\s*((while|for).+do|begin|try)\\s*$",
    "wordBreakChars": "&*+,/:<=^gt;?^",
}

# Attributes dict for ocaml_main ruleset.
ocaml_main_attributes_dict = {
    "default": "null",
    "digit_re": "0([Bb][01][01_]*|[Oo][0-7][0-7_]*|[Xx][[:xdigit:]][[:xdigit:]_]*)|[[:digit:]][[:digit:]_]*(\\.[[:digit]_]*)?([Ee][-+]?[[:digit:]][[:digit:]_]*)?",
    "escape": "\\",
    "highlight_digits": "true",
    "ignore_case": "false",
    "no_word_sep": "'_",
}

# Dictionary of attributes dictionaries for ocaml mode.
attributesDictDict = {
    "ocaml_main": ocaml_main_attributes_dict,
}

# Keywords dict for ocaml_main ruleset.
ocaml_main_keywords_dict = {
    "Arg": "keyword3",
    "Arith_status": "keyword3",
    "Array": "keyword3",
    "Array1": "keyword3",
    "Array2": "keyword3",
    "Array3": "keyword3",
    "Assert_failure": "label",
    "Bad": "label",
    "Big_int": "keyword3",
    "Bigarray": "keyword3",
    "Break": "label",
    "Buffer": "keyword3",
    "Callback": "keyword3",
    "Char": "keyword3",
    "Complex": "keyword3",
    "Condition": "keyword3",
    "Dbm": "keyword3",
    "Dbm_error": "label",
    "Digest": "keyword3",
    "Division_by_zero": "label",
    "Dynlink": "keyword3",
    "Empty": "label",
    "End_of_file": "label",
    "Error": "label",
    "Event": "keyword3",
    "Exit": "label",
    "FP_infinite": "label",
    "FP_nan": "label",
    "FP_normal": "label",
    "FP_subnormal": "label",
    "FP_zero": "label",
    "Failure": "label",
    "Filename": "keyword3",
    "Format": "keyword3",
    "Gc": "keyword3",
    "Genarray": "keyword3",
    "Genlex": "keyword3",
    "Graphic_failure": "label",
    "Graphics": "keyword3",
    "HashedType": "keyword3",
    "Hashtbl": "keyword3",
    "Help": "label",
    "Int32": "keyword3",
    "Int64": "keyword3",
    "Invalid_argument": "label",
    "LargeFile": "keyword3",
    "Lazy": "keyword3",
    "Lexing": "keyword3",
    "List": "keyword3",
    "Make": "keyword3",
    "Map": "keyword3",
    "Marshal": "keyword3",
    "Match_failure": "label",
    "Mutex": "keyword3",
    "Nativeint": "keyword3",
    "None": "label",
    "Not_found": "label",
    "Num": "keyword3",
    "Oo": "keyword3",
    "Open_append": "label",
    "Open_binary": "label",
    "Open_creat": "label",
    "Open_excl": "label",
    "Open_nonblock": "label",
    "Open_rdonly": "label",
    "Open_text": "label",
    "Open_trunc": "label",
    "Open_wronly": "label",
    "OrderedType": "keyword3",
    "Out_of_memory": "label",
    "Parse_error": "label",
    "Parsing": "keyword3",
    "Pervasives": "keyword3",
    "Printexc": "keyword3",
    "Printf": "keyword3",
    "Queue": "keyword3",
    "Random": "keyword3",
    "Scan_failure": "label",
    "Scanf": "keyword3",
    "Scanning": "keyword3",
    "Set": "keyword3",
    "Some": "label",
    "Sort": "keyword3",
    "Stack": "keyword3",
    "Stack_overflow": "label",
    "State": "keyword3",
    "StdLabels": "keyword3",
    "Str": "keyword3",
    "Stream": "keyword3",
    "String": "keyword3",
    "Sys": "keyword3",
    "Sys_blocked_io": "label",
    "Sys_error": "label",
    "Thread": "keyword3",
    "ThreadUnix": "keyword3",
    "Tk": "keyword3",
    "Undefined": "label",
    "Undefined_recursive_module": "label",
    "Unix": "keyword3",
    "UnixLabels": "keyword3",
    "Unix_error": "label",
    "Weak": "keyword3",
    "abs": "function",
    "abs_big_int": "function",
    "abs_float": "function",
    "abs_num": "function",
    "accept": "function",
    "access": "function",
    "access_permission": "function",
    "acos": "function",
    "add": "function",
    "add_available_units": "function",
    "add_big_int": "function",
    "add_buffer": "function",
    "add_channel": "function",
    "add_char": "function",
    "add_int_big_int": "function",
    "add_interfaces": "function",
    "add_num": "function",
    "add_string": "function",
    "add_substitute": "function",
    "add_substring": "function",
    "addr_info": "function",
    "alarm": "function",
    "align": "function",
    "allocated_bytes": "function",
    "allow_only": "function",
    "allow_unsafe_modules": "function",
    "always": "function",
    "anchor": "function",
    "and": "keyword1",
    "anon_fun": "function",
    "append": "function",
    "appname_get": "function",
    "appname_set": "function",
    "approx_num_exp": "function",
    "approx_num_fix": "function",
    "arg": "function",
    "argv": "function",
    "arith_status": "function",
    "array": "keyword2",
    "array1_of_genarray": "function",
    "array2_of_genarray": "function",
    "array3_of_genarray": "function",
    "as": "keyword1",
    "asin": "function",
    "asr": "keyword1",
    "assert": "keyword1",
    "assoc": "function",
    "assq": "function",
    "at_exit": "function",
    "atan": "function",
    "atan2": "function",
    "auto_synchronize": "function",
    "background": "function",
    "basename": "function",
    "begin": "keyword1",
    "beginning_of_input": "function",
    "big_int": "function",
    "big_int_of_int": "function",
    "big_int_of_num": "function",
    "big_int_of_string": "function",
    "bind": "function",
    "bind_class": "function",
    "bind_tag": "function",
    "bits": "function",
    "bits_of_float": "function",
    "black": "function",
    "blit": "function",
    "blit_image": "function",
    "blue": "function",
    "bool": "keyword2",
    "bool_of_string": "function",
    "borderMode": "function",
    "bounded_full_split": "function",
    "bounded_split": "function",
    "bounded_split_delim": "function",
    "bprintf": "function",
    "break": "function",
    "broadcast": "function",
    "bscanf": "function",
    "button_down": "function",
    "c_layout": "function",
    "capitalize": "function",
    "cardinal": "function",
    "catch": "function",
    "catch_break": "function",
    "ceil": "function",
    "ceiling_num": "function",
    "channel": "function",
    "char": "keyword2",
    "char_of_int": "function",
    "chdir": "function",
    "check": "function",
    "check_suffix": "function",
    "chmod": "function",
    "choose": "function",
    "chop_extension": "function",
    "chop_suffix": "function",
    "chown": "function",
    "chr": "function",
    "chroot": "function",
    "class": "keyword1",
    "classify_float": "function",
    "clear": "function",
    "clear_available_units": "function",
    "clear_close_on_exec": "function",
    "clear_graph": "function",
    "clear_nonblock": "function",
    "clear_parser": "function",
    "close": "function",
    "closeTk": "function",
    "close_box": "function",
    "close_graph": "function",
    "close_in": "function",
    "close_in_noerr": "function",
    "close_out": "function",
    "close_out_noerr": "function",
    "close_process": "function",
    "close_process_full": "function",
    "close_process_in": "function",
    "close_process_out": "function",
    "close_tag": "function",
    "close_tbox": "function",
    "closedir": "function",
    "code": "function",
    "color": "function",
    "combine": "function",
    "command": "function",
    "compact": "function",
    "compare": "function",
    "compare_big_int": "function",
    "compare_num": "function",
    "complex32": "function",
    "complex32_elt": "function",
    "complex64": "function",
    "complex64_elt": "function",
    "concat": "function",
    "conj": "function",
    "connect": "function",
    "constraint": "keyword1",
    "contains": "function",
    "contains_from": "function",
    "contents": "function",
    "control": "function",
    "copy": "function",
    "cos": "function",
    "cosh": "function",
    "count": "function",
    "counters": "function",
    "create": "function",
    "create_alarm": "function",
    "create_image": "function",
    "create_matrix": "function",
    "create_process": "function",
    "create_process_env": "function",
    "current": "function",
    "current_dir_name": "function",
    "current_point": "function",
    "current_x": "function",
    "current_y": "function",
    "curveto": "function",
    "cyan": "function",
    "data": "function",
    "data_size": "function",
    "decr": "function",
    "decr_num": "function",
    "default_available_units": "function",
    "delay": "function",
    "delete_alarm": "function",
    "descr_of_in_channel": "function",
    "descr_of_out_channel": "function",
    "destroy": "function",
    "diff": "function",
    "dim": "function",
    "dim1": "function",
    "dim2": "function",
    "dim3": "function",
    "dims": "function",
    "dir_handle": "function",
    "dirname": "function",
    "display_mode": "function",
    "div": "function",
    "div_big_int": "function",
    "div_num": "function",
    "do": "keyword1",
    "doc": "function",
    "domain_of_sockaddr": "function",
    "done": "keyword1",
    "downto": "keyword1",
    "draw_arc": "function",
    "draw_char": "function",
    "draw_circle": "function",
    "draw_ellipse": "function",
    "draw_image": "function",
    "draw_poly": "function",
    "draw_poly_line": "function",
    "draw_rect": "function",
    "draw_segments": "function",
    "draw_string": "function",
    "dummy_pos": "function",
    "dump_image": "function",
    "dup": "function",
    "dup2": "function",
    "elements": "function",
    "else": "keyword1",
    "elt": "function",
    "empty": "function",
    "end": "keyword1",
    "end_of_input": "function",
    "environment": "function",
    "eprintf": "function",
    "epsilon_float": "function",
    "eq_big_int": "function",
    "eq_num": "function",
    "equal": "function",
    "err_formatter": "function",
    "error": "function",
    "error_message": "function",
    "escaped": "function",
    "establish_server": "function",
    "event": "function",
    "eventField": "function",
    "eventInfo": "function",
    "exception": "keyword1",
    "executable_name": "function",
    "execv": "function",
    "execve": "function",
    "execvp": "function",
    "execvpe": "function",
    "exists": "function",
    "exists2": "function",
    "exit": "function",
    "exn": "keyword2",
    "exp": "function",
    "extern_flags": "function",
    "external": "keyword1",
    "failwith": "function",
    "false": "keyword1",
    "fast_sort": "function",
    "fchmod": "function",
    "fchown": "function",
    "file": "function",
    "file_descr": "function",
    "file_exists": "function",
    "file_kind": "function",
    "file_perm": "function",
    "fill": "function",
    "fillMode": "function",
    "fill_arc": "function",
    "fill_circle": "function",
    "fill_ellipse": "function",
    "fill_poly": "function",
    "fill_rect": "function",
    "filter": "function",
    "finalise": "function",
    "finalise_release": "function",
    "find": "function",
    "find_all": "function",
    "first_chars": "function",
    "firstkey": "function",
    "flatten": "function",
    "float": "keyword2",
    "float32": "function",
    "float32_elt": "function",
    "float64": "function",
    "float64_elt": "function",
    "float_of_big_int": "function",
    "float_of_bits": "function",
    "float_of_int": "function",
    "float_of_num": "function",
    "float_of_string": "function",
    "floor": "function",
    "floor_num": "function",
    "flow_action": "function",
    "flush": "function",
    "flush_all": "function",
    "flush_input": "function",
    "flush_queue": "function",
    "flush_str_formatter": "function",
    "fold": "function",
    "fold_left": "function",
    "fold_left2": "function",
    "fold_right": "function",
    "fold_right2": "function",
    "for": "keyword1",
    "for_all": "function",
    "for_all2": "function",
    "force": "function",
    "force_newline": "function",
    "force_val": "function",
    "foreground": "function",
    "fork": "function",
    "format": "keyword2",
    "format4": "keyword2",
    "format_of_string": "function",
    "formatter": "function",
    "formatter_of_buffer": "function",
    "formatter_of_out_channel": "function",
    "formatter_tag_functions": "function",
    "fortran_layout": "function",
    "fpclass": "function",
    "fprintf": "function",
    "frexp": "function",
    "from": "function",
    "from_channel": "function",
    "from_file": "function",
    "from_file_bin": "function",
    "from_function": "function",
    "from_string": "function",
    "fscanf": "function",
    "fst": "function",
    "fstat": "function",
    "ftruncate": "function",
    "full_init": "function",
    "full_major": "function",
    "full_split": "function",
    "fun": "keyword1",
    "function": "keyword1",
    "functor": "keyword1",
    "gcd_big_int": "function",
    "ge_big_int": "function",
    "ge_num": "function",
    "genarray_of_array1": "function",
    "genarray_of_array2": "function",
    "genarray_of_array3": "function",
    "get": "function",
    "get_all_formatter_output_functions": "function",
    "get_approx_printing": "function",
    "get_copy": "function",
    "get_ellipsis_text": "function",
    "get_error_when_null_denominator": "function",
    "get_floating_precision": "function",
    "get_formatter_output_functions": "function",
    "get_formatter_tag_functions": "function",
    "get_image": "function",
    "get_margin": "function",
    "get_mark_tags": "function",
    "get_max_boxes": "function",
    "get_max_indent": "function",
    "get_normalize_ratio": "function",
    "get_normalize_ratio_when_printing": "function",
    "get_print_tags": "function",
    "get_state": "function",
    "getaddrinfo": "function",
    "getaddrinfo_option": "function",
    "getcwd": "function",
    "getegid": "function",
    "getenv": "function",
    "geteuid": "function",
    "getgid": "function",
    "getgrgid": "function",
    "getgrnam": "function",
    "getgroups": "function",
    "gethostbyaddr": "function",
    "gethostbyname": "function",
    "gethostname": "function",
    "getitimer": "function",
    "getlogin": "function",
    "getnameinfo": "function",
    "getnameinfo_option": "function",
    "getpeername": "function",
    "getpid": "function",
    "getppid": "function",
    "getprotobyname": "function",
    "getprotobynumber": "function",
    "getpwnam": "function",
    "getpwuid": "function",
    "getservbyname": "function",
    "getservbyport": "function",
    "getsockname": "function",
    "getsockopt": "function",
    "getsockopt_float": "function",
    "getsockopt_int": "function",
    "getsockopt_optint": "function",
    "gettimeofday": "function",
    "getuid": "function",
    "global_replace": "function",
    "global_substitute": "function",
    "gmtime": "function",
    "green": "function",
    "grid": "function",
    "group_beginning": "function",
    "group_end": "function",
    "group_entry": "function",
    "gt_big_int": "function",
    "gt_num": "function",
    "guard": "function",
    "handle_unix_error": "function",
    "hash": "function",
    "hash_param": "function",
    "hd": "function",
    "header_size": "function",
    "host_entry": "function",
    "if": "keyword1",
    "ignore": "function",
    "image": "function",
    "in": "keyword1",
    "in_channel": "function",
    "in_channel_length": "function",
    "in_channel_of_descr": "function",
    "include": "keyword1",
    "incr": "function",
    "incr_num": "function",
    "index": "function",
    "index_from": "function",
    "inet6_addr_any": "function",
    "inet6_addr_loopback": "function",
    "inet_addr": "function",
    "inet_addr_any": "function",
    "inet_addr_loopback": "function",
    "inet_addr_of_string": "function",
    "infinity": "function",
    "inherit": "keyword1",
    "init": "function",
    "initializer": "keyword1",
    "input": "function",
    "input_binary_int": "function",
    "input_byte": "function",
    "input_char": "function",
    "input_line": "function",
    "input_value": "function",
    "int": "keyword2",
    "int16_signed": "function",
    "int16_signed_elt": "function",
    "int16_unsigned": "function",
    "int16_unsigned_elt": "function",
    "int32": "keyword2",
    "int32_elt": "function",
    "int64": "keyword2",
    "int64_elt": "function",
    "int8_signed": "function",
    "int8_signed_elt": "function",
    "int8_unsigned": "function",
    "int8_unsigned_elt": "function",
    "int_elt": "function",
    "int_of_big_int": "function",
    "int_of_char": "function",
    "int_of_float": "function",
    "int_of_num": "function",
    "int_of_string": "function",
    "integer_num": "function",
    "inter": "function",
    "interactive": "function",
    "interval_timer": "function",
    "interval_timer_status": "function",
    "inv": "function",
    "invalid_arg": "function",
    "is_empty": "function",
    "is_implicit": "function",
    "is_int_big_int": "function",
    "is_integer_num": "function",
    "is_relative": "function",
    "iter": "function",
    "iter2": "function",
    "iteri": "function",
    "join": "function",
    "junk": "function",
    "key": "function",
    "key_pressed": "function",
    "kfprintf": "function",
    "kill": "function",
    "kind": "function",
    "kprintf": "function",
    "kscanf": "function",
    "ksprintf": "function",
    "land": "keyword1",
    "last_chars": "function",
    "layout": "function",
    "lazy": "keyword1",
    "lazy_from_fun": "function",
    "lazy_from_val": "function",
    "lazy_is_val": "function",
    "lazy_t": "function",
    "ldexp": "function",
    "le_big_int": "function",
    "le_num": "function",
    "length": "function",
    "let": "keyword1",
    "lexbuf": "function",
    "lexeme": "function",
    "lexeme_char": "function",
    "lexeme_end": "function",
    "lexeme_end_p": "function",
    "lexeme_start": "function",
    "lexeme_start_p": "function",
    "lineto": "function",
    "link": "function",
    "linking_error": "function",
    "list": "keyword2",
    "listen": "function",
    "lnot": "function",
    "loadfile": "function",
    "loadfile_private": "function",
    "localtime": "function",
    "lock": "function",
    "lock_command": "function",
    "lockf": "function",
    "log": "function",
    "log10": "function",
    "logand": "function",
    "lognot": "function",
    "logor": "function",
    "logxor": "function",
    "lor": "keyword1",
    "lower_window": "function",
    "lowercase": "function",
    "lseek": "function",
    "lsl": "keyword1",
    "lsr": "keyword1",
    "lstat": "function",
    "lt_big_int": "function",
    "lt_num": "function",
    "lxor": "keyword1",
    "magenta": "function",
    "mainLoop": "function",
    "major": "function",
    "major_slice": "function",
    "make": "function",
    "make_formatter": "function",
    "make_image": "function",
    "make_lexer": "function",
    "make_matrix": "function",
    "make_self_init": "function",
    "map": "function",
    "map2": "function",
    "map_file": "function",
    "mapi": "function",
    "match": "keyword1",
    "match_beginning": "function",
    "match_end": "function",
    "matched_group": "function",
    "matched_string": "function",
    "max": "function",
    "max_array_length": "function",
    "max_big_int": "function",
    "max_elt": "function",
    "max_float": "function",
    "max_int": "function",
    "max_num": "function",
    "max_string_length": "function",
    "mem": "function",
    "mem_assoc": "function",
    "mem_assq": "function",
    "memq": "function",
    "merge": "function",
    "method": "keyword1",
    "min": "function",
    "min_big_int": "function",
    "min_elt": "function",
    "min_float": "function",
    "min_int": "function",
    "min_num": "function",
    "minor": "function",
    "minus_big_int": "function",
    "minus_num": "function",
    "minus_one": "function",
    "mkdir": "function",
    "mkfifo": "function",
    "mktime": "function",
    "mod": "keyword1",
    "mod_big_int": "function",
    "mod_float": "function",
    "mod_num": "function",
    "modf": "function",
    "modifier": "function",
    "module": "keyword1",
    "mouse_pos": "function",
    "moveto": "function",
    "msg_flag": "function",
    "mul": "function",
    "mult_big_int": "function",
    "mult_int_big_int": "function",
    "mult_num": "function",
    "mutable": "keyword1",
    "name_info": "function",
    "nan": "function",
    "nat_of_num": "function",
    "nativeint": "keyword2",
    "nativeint_elt": "function",
    "neg": "function",
    "neg_infinity": "function",
    "new": "keyword1",
    "new_channel": "function",
    "next": "function",
    "nextkey": "function",
    "nice": "function",
    "norm": "function",
    "norm2": "function",
    "not": "function",
    "npeek": "function",
    "nth": "function",
    "nth_dim": "function",
    "num": "function",
    "num_digits_big_int": "function",
    "num_dims": "function",
    "num_of_big_int": "function",
    "num_of_int": "function",
    "num_of_nat": "function",
    "num_of_ratio": "function",
    "num_of_string": "function",
    "object": "keyword1",
    "ocaml_version": "function",
    "of": "keyword1",
    "of_array": "function",
    "of_channel": "function",
    "of_float": "function",
    "of_int": "function",
    "of_int32": "function",
    "of_list": "function",
    "of_nativeint": "function",
    "of_string": "function",
    "one": "function",
    "open": "keyword1",
    "openTk": "function",
    "open_box": "function",
    "open_connection": "function",
    "open_flag": "function",
    "open_graph": "function",
    "open_hbox": "function",
    "open_hovbox": "function",
    "open_hvbox": "function",
    "open_in": "function",
    "open_in_bin": "function",
    "open_in_gen": "function",
    "open_out": "function",
    "open_out_bin": "function",
    "open_out_gen": "function",
    "open_process": "function",
    "open_process_full": "function",
    "open_process_in": "function",
    "open_process_out": "function",
    "open_tag": "function",
    "open_tbox": "function",
    "open_temp_file": "function",
    "open_vbox": "function",
    "opendbm": "function",
    "opendir": "function",
    "openfile": "function",
    "option": "keyword2",
    "or": "keyword1",
    "os_type": "function",
    "out_channel": "function",
    "out_channel_length": "function",
    "out_channel_of_descr": "function",
    "output": "function",
    "output_binary_int": "function",
    "output_buffer": "function",
    "output_byte": "function",
    "output_char": "function",
    "output_string": "function",
    "output_value": "function",
    "over_max_boxes": "function",
    "pack": "function",
    "parent_dir_name": "function",
    "parse": "function",
    "parse_argv": "function",
    "parser": "keyword1",
    "partition": "function",
    "passwd_entry": "function",
    "pause": "function",
    "peek": "function",
    "pipe": "function",
    "pixels": "function",
    "place": "function",
    "plot": "function",
    "plots": "function",
    "point_color": "function",
    "polar": "function",
    "poll": "function",
    "pop": "function",
    "pos_in": "function",
    "pos_out": "function",
    "position": "function",
    "pow": "function",
    "power_big_int_positive_big_int": "function",
    "power_big_int_positive_int": "function",
    "power_int_positive_big_int": "function",
    "power_int_positive_int": "function",
    "power_num": "function",
    "pp_close_box": "function",
    "pp_close_tag": "function",
    "pp_close_tbox": "function",
    "pp_force_newline": "function",
    "pp_get_all_formatter_output_functions": "function",
    "pp_get_ellipsis_text": "function",
    "pp_get_formatter_output_functions": "function",
    "pp_get_formatter_tag_functions": "function",
    "pp_get_margin": "function",
    "pp_get_mark_tags": "function",
    "pp_get_max_boxes": "function",
    "pp_get_max_indent": "function",
    "pp_get_print_tags": "function",
    "pp_open_box": "function",
    "pp_open_hbox": "function",
    "pp_open_hovbox": "function",
    "pp_open_hvbox": "function",
    "pp_open_tag": "function",
    "pp_open_tbox": "function",
    "pp_open_vbox": "function",
    "pp_over_max_boxes": "function",
    "pp_print_as": "function",
    "pp_print_bool": "function",
    "pp_print_break": "function",
    "pp_print_char": "function",
    "pp_print_cut": "function",
    "pp_print_float": "function",
    "pp_print_flush": "function",
    "pp_print_if_newline": "function",
    "pp_print_int": "function",
    "pp_print_newline": "function",
    "pp_print_space": "function",
    "pp_print_string": "function",
    "pp_print_tab": "function",
    "pp_print_tbreak": "function",
    "pp_set_all_formatter_output_functions": "function",
    "pp_set_ellipsis_text": "function",
    "pp_set_formatter_out_channel": "function",
    "pp_set_formatter_output_functions": "function",
    "pp_set_formatter_tag_functions": "function",
    "pp_set_margin": "function",
    "pp_set_mark_tags": "function",
    "pp_set_max_boxes": "function",
    "pp_set_max_indent": "function",
    "pp_set_print_tags": "function",
    "pp_set_tab": "function",
    "pp_set_tags": "function",
    "pred": "function",
    "pred_big_int": "function",
    "pred_num": "function",
    "prerr_char": "function",
    "prerr_endline": "function",
    "prerr_float": "function",
    "prerr_int": "function",
    "prerr_newline": "function",
    "prerr_string": "function",
    "print": "function",
    "print_as": "function",
    "print_bool": "function",
    "print_break": "function",
    "print_char": "function",
    "print_cut": "function",
    "print_endline": "function",
    "print_float": "function",
    "print_flush": "function",
    "print_if_newline": "function",
    "print_int": "function",
    "print_newline": "function",
    "print_space": "function",
    "print_stat": "function",
    "print_string": "function",
    "print_tab": "function",
    "print_tbreak": "function",
    "printf": "function",
    "private": "keyword1",
    "process_status": "function",
    "process_times": "function",
    "prohibit": "function",
    "protocol_entry": "function",
    "push": "function",
    "putenv": "function",
    "quick_stat": "function",
    "quo_num": "function",
    "quomod_big_int": "function",
    "quote": "function",
    "raise": "function",
    "raise_window": "function",
    "ratio_of_num": "function",
    "rcontains_from": "function",
    "read": "function",
    "read_float": "function",
    "read_int": "function",
    "read_key": "function",
    "read_line": "function",
    "readdir": "function",
    "readlink": "function",
    "really_input": "function",
    "rec": "keyword1",
    "receive": "function",
    "recv": "function",
    "recvfrom": "function",
    "red": "function",
    "ref": "keyword2",
    "regexp": "function",
    "regexp_case_fold": "function",
    "regexp_string": "function",
    "regexp_string_case_fold": "function",
    "register": "function",
    "register_exception": "function",
    "rem": "function",
    "remember_mode": "function",
    "remove": "function",
    "remove_assoc": "function",
    "remove_assq": "function",
    "rename": "function",
    "replace": "function",
    "replace_first": "function",
    "replace_matched": "function",
    "reset": "function",
    "reshape": "function",
    "reshape_1": "function",
    "reshape_2": "function",
    "reshape_3": "function",
    "rev": "function",
    "rev_append": "function",
    "rev_map": "function",
    "rev_map2": "function",
    "rewinddir": "function",
    "rgb": "function",
    "rhs_end": "function",
    "rhs_end_pos": "function",
    "rhs_start": "function",
    "rhs_start_pos": "function",
    "rindex": "function",
    "rindex_from": "function",
    "rlineto": "function",
    "rmdir": "function",
    "rmoveto": "function",
    "round_num": "function",
    "scanbuf": "function",
    "scanf": "function",
    "search_backward": "function",
    "search_forward": "function",
    "seek_command": "function",
    "seek_in": "function",
    "seek_out": "function",
    "select": "function",
    "self": "function",
    "self_init": "function",
    "send": "function",
    "sendto": "function",
    "service_entry": "function",
    "set": "function",
    "set_all_formatter_output_functions": "function",
    "set_approx_printing": "function",
    "set_binary_mode_in": "function",
    "set_binary_mode_out": "function",
    "set_close_on_exec": "function",
    "set_color": "function",
    "set_ellipsis_text": "function",
    "set_error_when_null_denominator": "function",
    "set_floating_precision": "function",
    "set_font": "function",
    "set_formatter_out_channel": "function",
    "set_formatter_output_functions": "function",
    "set_formatter_tag_functions": "function",
    "set_line_width": "function",
    "set_margin": "function",
    "set_mark_tags": "function",
    "set_max_boxes": "function",
    "set_max_indent": "function",
    "set_nonblock": "function",
    "set_normalize_ratio": "function",
    "set_normalize_ratio_when_printing": "function",
    "set_print_tags": "function",
    "set_signal": "function",
    "set_state": "function",
    "set_tab": "function",
    "set_tags": "function",
    "set_text_size": "function",
    "set_window_title": "function",
    "setattr_when": "function",
    "setgid": "function",
    "setitimer": "function",
    "setsid": "function",
    "setsockopt": "function",
    "setsockopt_float": "function",
    "setsockopt_int": "function",
    "setsockopt_optint": "function",
    "setuid": "function",
    "shift_left": "function",
    "shift_right": "function",
    "shift_right_logical": "function",
    "shutdown": "function",
    "shutdown_command": "function",
    "shutdown_connection": "function",
    "side": "function",
    "sig": "keyword1",
    "sigabrt": "function",
    "sigalrm": "function",
    "sigchld": "function",
    "sigcont": "function",
    "sigfpe": "function",
    "sighup": "function",
    "sigill": "function",
    "sigint": "function",
    "sigkill": "function",
    "sign_big_int": "function",
    "sign_num": "function",
    "signal": "function",
    "signal_behavior": "function",
    "sigpending": "function",
    "sigpipe": "function",
    "sigprocmask": "function",
    "sigprocmask_command": "function",
    "sigprof": "function",
    "sigquit": "function",
    "sigsegv": "function",
    "sigstop": "function",
    "sigsuspend": "function",
    "sigterm": "function",
    "sigtstp": "function",
    "sigttin": "function",
    "sigttou": "function",
    "sigusr1": "function",
    "sigusr2": "function",
    "sigvtalrm": "function",
    "sin": "function",
    "single_write": "function",
    "singleton": "function",
    "sinh": "function",
    "size": "function",
    "size_x": "function",
    "size_y": "function",
    "sleep": "function",
    "slice_left": "function",
    "slice_left_1": "function",
    "slice_left_2": "function",
    "slice_right": "function",
    "slice_right_1": "function",
    "slice_right_2": "function",
    "snd": "function",
    "sockaddr": "function",
    "socket": "function",
    "socket_bool_option": "function",
    "socket_domain": "function",
    "socket_float_option": "function",
    "socket_int_option": "function",
    "socket_optint_option": "function",
    "socket_type": "function",
    "socketpair": "function",
    "sort": "function",
    "sound": "function",
    "spec": "function",
    "split": "function",
    "split_delim": "function",
    "split_result": "function",
    "sprintf": "function",
    "sqrt": "function",
    "sqrt_big_int": "function",
    "square_big_int": "function",
    "square_num": "function",
    "sscanf": "function",
    "stable_sort": "function",
    "stat": "function",
    "stats": "function",
    "status": "function",
    "std_formatter": "function",
    "stdbuf": "function",
    "stderr": "function",
    "stdib": "function",
    "stdin": "function",
    "stdout": "function",
    "str_formatter": "function",
    "string": "keyword2",
    "string_after": "function",
    "string_before": "function",
    "string_match": "function",
    "string_of_big_int": "function",
    "string_of_bool": "function",
    "string_of_float": "function",
    "string_of_format": "function",
    "string_of_inet_addr": "function",
    "string_of_int": "function",
    "string_of_num": "function",
    "string_partial_match": "function",
    "struct": "keyword1",
    "sub": "function",
    "sub_big_int": "function",
    "sub_left": "function",
    "sub_num": "function",
    "sub_right": "function",
    "subset": "function",
    "substitute_first": "function",
    "substring": "function",
    "succ": "function",
    "succ_big_int": "function",
    "succ_num": "function",
    "symbol_end": "function",
    "symbol_end_pos": "function",
    "symbol_start": "function",
    "symbol_start_pos": "function",
    "symlink": "function",
    "sync": "function",
    "synchronize": "function",
    "system": "function",
    "tag": "function",
    "take": "function",
    "tan": "function",
    "tanh": "function",
    "tcdrain": "function",
    "tcflow": "function",
    "tcflush": "function",
    "tcgetattr": "function",
    "tcsendbreak": "function",
    "tcsetattr": "function",
    "temp_file": "function",
    "terminal_io": "function",
    "text_size": "function",
    "then": "keyword1",
    "time": "function",
    "timed_read": "function",
    "timed_write": "function",
    "times": "function",
    "tl": "function",
    "tm": "function",
    "to": "keyword1",
    "to_buffer": "function",
    "to_channel": "function",
    "to_float": "function",
    "to_hex": "function",
    "to_int": "function",
    "to_int32": "function",
    "to_list": "function",
    "to_nativeint": "function",
    "to_string": "function",
    "token": "function",
    "top": "function",
    "total_size": "function",
    "transfer": "function",
    "transp": "function",
    "true": "keyword1",
    "truncate": "function",
    "try": "keyword1",
    "try_lock": "function",
    "type": "keyword1",
    "umask": "function",
    "uncapitalize": "function",
    "union": "function",
    "unit": "keyword2",
    "unit_big_int": "function",
    "units": "function",
    "unlink": "function",
    "unlock": "function",
    "unsafe_blit": "function",
    "unsafe_fill": "function",
    "unsafe_get": "function",
    "unsafe_set": "function",
    "update": "function",
    "uppercase": "function",
    "usage": "function",
    "usage_msg": "function",
    "utimes": "function",
    "val": "keyword1",
    "virtual": "keyword1",
    "wait": "function",
    "wait_flag": "function",
    "wait_next_event": "function",
    "wait_pid": "function",
    "wait_read": "function",
    "wait_signal": "function",
    "wait_timed_read": "function",
    "wait_timed_write": "function",
    "wait_write": "function",
    "waitpid": "function",
    "when": "keyword1",
    "while": "keyword1",
    "white": "function",
    "with": "keyword1",
    "word_size": "function",
    "wrap": "function",
    "wrap_abort": "function",
    "write": "function",
    "yellow": "function",
    "yield": "function",
    "zero": "function",
    "zero_big_int": "function",
}

# Dictionary of keywords dictionaries for ocaml mode.
keywordsDictDict = {
    "ocaml_main": ocaml_main_keywords_dict,
}

# Rules for ocaml_main ruleset.

def ocaml_rule0(colorer, s, i):
    return colorer.match_span(s, i, kind="comment4", begin="(**", end="*)",
          no_escape=True)

def ocaml_rule1(colorer, s, i):
    return colorer.match_span(s, i, kind="comment3", begin="(*", end="*)",
          no_escape=True)

def ocaml_rule2(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="literal1", regexp="'([^']|\\\\(['\"bntr\\\\]|[[:digit:]]{3}|x[[:xdigit:]]{2}))'")

def ocaml_rule3(colorer, s, i):
    return colorer.match_span(s, i, kind="literal2", begin="\"", end="\"")

def ocaml_rule4(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="label", pattern="#",
          at_line_start=True)

def ocaml_rule5(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="label", pattern="%",
          at_line_start=True)

def ocaml_rule6(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="literal3", pattern="'")

def ocaml_rule7(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="literal4", pattern="`")

def ocaml_rule8(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="}")

def ocaml_rule9(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="|]")

def ocaml_rule10(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="||")

def ocaml_rule11(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="|")

def ocaml_rule12(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="{<")

def ocaml_rule13(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="{")

def ocaml_rule14(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="literal4", seq="_")

def ocaml_rule15(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="]")

def ocaml_rule16(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="keyword2", seq="[]")

def ocaml_rule17(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="[|")

def ocaml_rule18(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="[>")

def ocaml_rule19(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="[<")

def ocaml_rule20(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="[")

def ocaml_rule21(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=">}")

def ocaml_rule22(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=">]")

def ocaml_rule23(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="<-")

def ocaml_rule24(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=";;")

def ocaml_rule25(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=";")

def ocaml_rule26(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=":>")

def ocaml_rule27(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq=":=")

def ocaml_rule28(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="keyword2", seq="::")

def ocaml_rule29(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=":")

def ocaml_rule30(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="..")

def ocaml_rule31(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="->")

def ocaml_rule32(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=",")

def ocaml_rule33(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=")")

def ocaml_rule34(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="keyword2", seq="()")

def ocaml_rule35(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="(")

def ocaml_rule36(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="=[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule37(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="<[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule38(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp=">[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule39(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="@[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule40(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="\\^[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule41(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="\\|[-!$%&*+./:<=>?@^|~]+")

def ocaml_rule42(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="&[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule43(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="\\+[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule44(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="-[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule45(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="\\*[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule46(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="/[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule47(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="\\$[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule48(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="%[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule49(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="![-!$%&*+./:<=>?@^|~]*")

def ocaml_rule50(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="\\?[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule51(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="operator", regexp="~[-!$%&*+./:<=>?@^|~]*")

def ocaml_rule52(colorer, s, i):
    return colorer.match_keywords(s, i)

# Rules dict for ocaml_main ruleset.
rulesDict1 = {
    "!": [ocaml_rule49,],
    "\"": [ocaml_rule3,],
    "#": [ocaml_rule4,],
    "$": [ocaml_rule47,],
    "%": [ocaml_rule5, ocaml_rule48,],
    "&": [ocaml_rule42,],
    "'": [ocaml_rule2, ocaml_rule6,],
    "(": [ocaml_rule0, ocaml_rule1, ocaml_rule34, ocaml_rule35,],
    ")": [ocaml_rule33,],
    "*": [ocaml_rule45,],
    "+": [ocaml_rule43,],
    ",": [ocaml_rule32,],
    "-": [ocaml_rule31, ocaml_rule44,],
    ".": [ocaml_rule30,],
    "/": [ocaml_rule46,],
    "0": [ocaml_rule52,],
    "1": [ocaml_rule52,],
    "2": [ocaml_rule52,],
    "3": [ocaml_rule52,],
    "4": [ocaml_rule52,],
    "5": [ocaml_rule52,],
    "6": [ocaml_rule52,],
    "7": [ocaml_rule52,],
    "8": [ocaml_rule52,],
    "9": [ocaml_rule52,],
    ":": [ocaml_rule26, ocaml_rule27, ocaml_rule28, ocaml_rule29,],
    ";": [ocaml_rule24, ocaml_rule25,],
    "<": [ocaml_rule23, ocaml_rule37,],
    "=": [ocaml_rule36,],
    ">": [ocaml_rule21, ocaml_rule22, ocaml_rule38,],
    "?": [ocaml_rule50,],
    "@": [ocaml_rule39, ocaml_rule52,],
    "A": [ocaml_rule52,],
    "B": [ocaml_rule52,],
    "C": [ocaml_rule52,],
    "D": [ocaml_rule52,],
    "E": [ocaml_rule52,],
    "F": [ocaml_rule52,],
    "G": [ocaml_rule52,],
    "H": [ocaml_rule52,],
    "I": [ocaml_rule52,],
    "J": [ocaml_rule52,],
    "K": [ocaml_rule52,],
    "L": [ocaml_rule52,],
    "M": [ocaml_rule52,],
    "N": [ocaml_rule52,],
    "O": [ocaml_rule52,],
    "P": [ocaml_rule52,],
    "Q": [ocaml_rule52,],
    "R": [ocaml_rule52,],
    "S": [ocaml_rule52,],
    "T": [ocaml_rule52,],
    "U": [ocaml_rule52,],
    "V": [ocaml_rule52,],
    "W": [ocaml_rule52,],
    "X": [ocaml_rule52,],
    "Y": [ocaml_rule52,],
    "Z": [ocaml_rule52,],
    "[": [ocaml_rule16, ocaml_rule17, ocaml_rule18, ocaml_rule19, ocaml_rule20,],
    "]": [ocaml_rule15,],
    "^": [ocaml_rule40,],
    "_": [ocaml_rule14, ocaml_rule52,],
    "`": [ocaml_rule7,],
    "a": [ocaml_rule52,],
    "b": [ocaml_rule52,],
    "c": [ocaml_rule52,],
    "d": [ocaml_rule52,],
    "e": [ocaml_rule52,],
    "f": [ocaml_rule52,],
    "g": [ocaml_rule52,],
    "h": [ocaml_rule52,],
    "i": [ocaml_rule52,],
    "j": [ocaml_rule52,],
    "k": [ocaml_rule52,],
    "l": [ocaml_rule52,],
    "m": [ocaml_rule52,],
    "n": [ocaml_rule52,],
    "o": [ocaml_rule52,],
    "p": [ocaml_rule52,],
    "q": [ocaml_rule52,],
    "r": [ocaml_rule52,],
    "s": [ocaml_rule52,],
    "t": [ocaml_rule52,],
    "u": [ocaml_rule52,],
    "v": [ocaml_rule52,],
    "w": [ocaml_rule52,],
    "x": [ocaml_rule52,],
    "y": [ocaml_rule52,],
    "z": [ocaml_rule52,],
    "{": [ocaml_rule12, ocaml_rule13,],
    "|": [ocaml_rule9, ocaml_rule10, ocaml_rule11, ocaml_rule41,],
    "}": [ocaml_rule8,],
    "~": [ocaml_rule51,],
}

# x.rulesDictDict for ocaml mode.
rulesDictDict = {
    "ocaml_main": rulesDict1,
}

# Import dict for ocaml mode.
importDict = {}
