"use strict";
var escodegen = require('escodegen');
var estraverse = require('estraverse');
var CoverageStatement = (function () {
    function CoverageStatement(key, start, end, functionAST) {
        this.key = key;
        this.start = start;
        this.end = end;
        try {
            this.setStatementeValue(functionAST);
        }
        catch (e) {
            throw e;
        }
    }
    CoverageStatement.prototype.setStatementeValue = function (functionAST) {
        var that = this;
        this.instruction = null;
        this.type = undefined;
        estraverse.traverse(functionAST, {
            enter: function (node) {
                var loc = node.loc;
                var isThisLoc;
                isThisLoc = loc.start.line === that.start.line
                    && loc.start.column === that.start.column
                    && loc.end.line === that.end.line
                    && loc.end.column === that.end.column;
                if (isThisLoc) {
                    that.instruction = escodegen.generate(node);
                    that.type = node.type || null;
                    this.break();
                }
            }
        });
        if (this.instruction === null || this.type === null) {
            throw new Error('Unable to get instruction of statement ' + this.key);
        }
    };
    CoverageStatement.prototype.initializeValues = function (statement) {
        this.nExecutions = statement[this.key];
        this.totalExecutions = statement[this.key];
    };
    CoverageStatement.prototype.updateValues = function (statement) {
        this.nExecutions = statement[this.key] - this.totalExecutions;
        this.totalExecutions = statement[this.key];
    };
    return CoverageStatement;
}());
module.exports = CoverageStatement;
