/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.io.IOException;
import org.doubletype.ossa.truetype.FontFormatWriter;
import org.doubletype.ossa.truetype.GlyfWriter;
import org.doubletype.ossa.truetype.HheaWriter;
import org.doubletype.ossa.truetype.TTGlyph;

public class HmtxWriter
extends FontFormatWriter {
    HheaWriter m_hhea;
    GlyfWriter m_glyf;

    public HmtxWriter(GlyfWriter a_glyf, HheaWriter a_hhea) {
        this.m_hhea = a_hhea;
        this.m_glyf = a_glyf;
    }

    @Override
    public void write() throws IOException {
        TTGlyph glyphZero = this.m_glyf.getGlyph(0);
        int maxWidth = glyphZero.getAdvanceWidth();
        int minRightSideBearing = glyphZero.getRightSideBearing();
        for (int i = 0; i < this.m_glyf.numOfGlyph(); ++i) {
            TTGlyph glyph = this.m_glyf.getGlyph(i);
            if (glyph.getAdvanceWidth() > maxWidth) {
                maxWidth = glyph.getAdvanceWidth();
            }
            if (glyph.getRightSideBearing() < minRightSideBearing) {
                minRightSideBearing = glyph.getRightSideBearing();
            }
            this.writeUFWord(glyph.getAdvanceWidth());
            this.writeFWord(glyph.getLeftSideBearing());
        }
        this.writeFWord(0);
        this.m_hhea.setMaxAdvanceWidth(maxWidth);
        this.m_hhea.setMinRightSideBearing(minRightSideBearing);
        this.pad();
    }

    @Override
    protected String getTag() {
        return "hmtx";
    }
}

