/*
 * Decompiled with CFR 0.152.
 */
package com.jpacker;

import com.jpacker.JPackerEncoding;
import com.jpacker.JPackerExecuter;
import com.jpacker.exceptions.EmptyFileException;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class JPacker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws FileNotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option baseOpt = parser.addIntegerOption('b', "base");
        CmdLineParser.Option columnsOpt = parser.addIntegerOption('c', "column");
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option minifyOpt = parser.addBooleanOption('m', "minify");
        CmdLineParser.Option outputFilenameOpt = parser.addStringOption('o', "output");
        CmdLineParser.Option quietOpt = parser.addBooleanOption('q', "quiet");
        CmdLineParser.Option shrinkVariablesOpt = parser.addBooleanOption('s', "shrink-variables");
        Writer out = null;
        BufferedReader in = null;
        try {
            if (args.length == 0) {
                throw new RuntimeException("No input file");
            }
            parser.parse(args);
            Boolean help = (Boolean)parser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                JPacker.printUsage();
                System.exit(0);
            }
            boolean minify = parser.getOptionValue(minifyOpt) != null;
            boolean shrinkVariables = parser.getOptionValue(shrinkVariablesOpt) != null;
            boolean quiet = parser.getOptionValue(quietOpt) != null;
            Integer base = (Integer)parser.getOptionValue(baseOpt);
            Integer columns = (Integer)parser.getOptionValue(columnsOpt);
            if (parser.getRemainingArgs().length == 0) {
                throw new FileNotFoundException("No input file was provided");
            }
            String inputFilename = parser.getRemainingArgs()[0];
            String outputFilename = (String)parser.getOptionValue(outputFilenameOpt);
            JPackerExecuter executer = base == null ? new JPackerExecuter(JPackerEncoding.NONE) : new JPackerExecuter(JPacker.getEncoding(baseOpt, base));
            in = new BufferedReader(new FileReader(new File(inputFilename)));
            String unpacked = JPacker.buildStringFromTextFile(in);
            if (unpacked.isEmpty()) {
                throw new EmptyFileException("The file is empty");
            }
            String packed = executer.pack(unpacked, minify, shrinkVariables);
            out = outputFilename == null ? new OutputStreamWriter(System.out) : new OutputStreamWriter(new FileOutputStream(outputFilename));
            if (columns != null) {
                packed = JPacker.wrapLines(packed, columns);
            }
            out.write(packed.replace("\n", System.getProperty("line.separator")));
            out.close();
            if (!quiet) {
                long endTime = System.currentTimeMillis();
                System.out.printf("Reduced to %.2f%% of its original size in %.4f seconds.\n", (double)packed.length() / (double)unpacked.length() * 100.0, (double)(endTime - startTime) / 1000.0);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + e.getLocalizedMessage());
            System.exit(1);
        }
        catch (CmdLineParser.IllegalOptionValueException e) {
            System.out.println("Illegal option: " + e.getValue() + " - " + e.getOption());
            System.exit(1);
        }
        catch (CmdLineParser.UnknownOptionException e) {
            JPacker.printUsage();
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            System.exit(1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.out.println(e.getLocalizedMessage());
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.out.println(e.getLocalizedMessage());
                }
            }
        }
    }

    private static void printUsage() {
        System.out.println("\nUsage: java -jar jpacker-x.y.z.jar [options] [input file]\n\nOptions\n  -b, --base                      Encoding base. Options are: 10, 36, 52, 62 \n                                  and 95. Ignored if --minify option is set.\n  -c, --column <column>           Insert a line break after the specified column \n                                  number.\n  -h, --help                      Displays this information.\n  -m, --minify                    Minify only, do not obfuscate.\n                                  --minify and --base values will be ignored.\n  -o <file>, --output <file>      Place the output into <file>.\n                                  Defaults to stdout.\n  -q, --quiet                     Quiet mode, no message.\n  -s, --shrink-variables          Shrink variables. Ignored if --minify option \n                                  is set.\n");
    }

    private static String wrapLines(String packedScript, Integer columns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < packedScript.length(); ++i) {
            int end = i + columns > packedScript.length() ? packedScript.length() : i + columns;
            sb.append(packedScript.substring(i, end)).append(System.getProperty("line.separator"));
            i = end + 1;
        }
        return sb.toString();
    }

    private static String buildStringFromTextFile(BufferedReader reader) throws FileNotFoundException, IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        while ((s = reader.readLine()) != null) {
            sb.append(s).append(System.getProperty("line.separator"));
        }
        reader.close();
        return sb.toString();
    }

    private static JPackerEncoding getEncoding(CmdLineParser.Option option, Integer base) throws CmdLineParser.IllegalOptionValueException {
        switch (base) {
            case 10: {
                return JPackerEncoding.NUMERIC;
            }
            case 36: {
                return JPackerEncoding.MID;
            }
            case 52: {
                return JPackerEncoding.BASIC;
            }
            case 62: {
                return JPackerEncoding.NORMAL;
            }
            case 95: {
                return JPackerEncoding.HIGH_ASCII;
            }
        }
        throw new CmdLineParser.IllegalOptionValueException(option, "Encoding base option not valid");
    }
}

