/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.tools.subsetter.GlyphRenumberer;
import com.google.typography.font.tools.subsetter.Subsetter;
import com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GlyphTableSubsetter
extends TableSubsetterImpl {
    private static final boolean DEBUG = false;

    protected GlyphTableSubsetter() {
        super(Tag.glyf, Tag.loca, Tag.maxp);
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder builder) throws IOException {
        List<Integer> list = subsetter.glyphMappingTable();
        if (list == null) {
            return false;
        }
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        if (glyphTable == null || locaTable == null) {
            throw new RuntimeException("Font to subset is not valid.");
        }
        GlyphTable.Builder builder2 = (GlyphTable.Builder)builder.newTableBuilder(Tag.glyf);
        LocaTable.Builder builder3 = (LocaTable.Builder)builder.newTableBuilder(Tag.loca);
        if (builder2 == null || builder3 == null) {
            throw new RuntimeException("Builder for subset is not valid.");
        }
        Map<Integer, Integer> map = subsetter.getInverseMapping();
        List<Glyph.Builder<? extends Glyph>> list2 = builder2.glyphBuilders();
        Object object = list.iterator();
        while (object.hasNext()) {
            int n = object.next();
            int n2 = locaTable.glyphOffset(n);
            int n3 = locaTable.glyphLength(n);
            Glyph glyph = glyphTable.glyph(n2, n3);
            ReadableFontData readableFontData = glyph.readFontData();
            ReadableFontData readableFontData2 = GlyphRenumberer.renumberGlyph(readableFontData, map);
            Glyph.Builder<? extends Glyph> builder4 = builder2.glyphBuilder(readableFontData2);
            list2.add(builder4);
        }
        object = builder2.generateLocaList();
        builder3.setLocaList((List<Integer>)object);
        MaximumProfileTable.Builder builder5 = (MaximumProfileTable.Builder)builder.getTableBuilder(Tag.maxp);
        builder5.setNumGlyphs(builder3.numGlyphs());
        return true;
    }
}

