/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.truetype;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import java.util.LinkedList;
import java.util.List;

public final class CompositeGlyph
extends Glyph {
    public static final int FLAG_ARG_1_AND_2_ARE_WORDS = 1;
    public static final int FLAG_ARGS_ARE_XY_VALUES = 2;
    public static final int FLAG_ROUND_XY_TO_GRID = 4;
    public static final int FLAG_WE_HAVE_A_SCALE = 8;
    public static final int FLAG_RESERVED = 16;
    public static final int FLAG_MORE_COMPONENTS = 32;
    public static final int FLAG_WE_HAVE_AN_X_AND_Y_SCALE = 64;
    public static final int FLAG_WE_HAVE_A_TWO_BY_TWO = 128;
    public static final int FLAG_WE_HAVE_INSTRUCTIONS = 256;
    public static final int FLAG_USE_MY_METRICS = 512;
    public static final int FLAG_OVERLAP_COMPOUND = 1024;
    public static final int FLAG_SCALED_COMPONENT_OFFSET = 2048;
    public static final int FLAG_UNSCALED_COMPONENT_OFFSET = 4096;
    private final List<Integer> contourIndex = new LinkedList<Integer>();
    private int instructionsOffset;
    private int instructionSize;

    protected CompositeGlyph(ReadableFontData readableFontData, int n, int n2) {
        super(readableFontData, n, n2, Glyph.GlyphType.Composite);
        this.initialize();
    }

    protected CompositeGlyph(ReadableFontData readableFontData) {
        super(readableFontData, Glyph.GlyphType.Composite);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        if (this.initialized) {
            return;
        }
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            int n = 5 * FontData.DataSize.USHORT.size();
            int n2 = 32;
            while ((n2 & 0x20) == 32) {
                this.contourIndex.add(n);
                n2 = this.data.readUShort(n);
                n += 2 * FontData.DataSize.USHORT.size();
                n = (n2 & 1) == 1 ? (n += 2 * FontData.DataSize.SHORT.size()) : (n += 2 * FontData.DataSize.BYTE.size());
                if ((n2 & 8) == 8) {
                    n += FontData.DataSize.F2DOT14.size();
                    continue;
                }
                if ((n2 & 0x40) == 64) {
                    n += 2 * FontData.DataSize.F2DOT14.size();
                    continue;
                }
                if ((n2 & 0x80) != 128) continue;
                n += 4 * FontData.DataSize.F2DOT14.size();
            }
            int n3 = n;
            if ((n2 & 0x100) == 256) {
                this.instructionSize = this.data.readUShort(n);
                this.instructionsOffset = n += FontData.DataSize.USHORT.size();
                n3 = n + this.instructionSize * FontData.DataSize.BYTE.size();
            }
            this.setPadding(this.dataLength() - n3);
        }
    }

    public int flags(int n) {
        return this.data.readUShort(this.contourIndex.get(n));
    }

    public int numGlyphs() {
        return this.contourIndex.size();
    }

    public int glyphIndex(int n) {
        return this.data.readUShort(FontData.DataSize.USHORT.size() + this.contourIndex.get(n));
    }

    public int argument1(int n) {
        int n2 = 2 * FontData.DataSize.USHORT.size() + this.contourIndex.get(n);
        int n3 = this.flags(n);
        if ((n3 & 1) == 1) {
            return this.data.readUShort(n2);
        }
        return this.data.readByte(n2);
    }

    public int argument2(int n) {
        int n2 = 2 * FontData.DataSize.USHORT.size() + this.contourIndex.get(n);
        int n3 = this.flags(n);
        if ((n3 & 1) == 1) {
            return this.data.readUShort(n2 + FontData.DataSize.USHORT.size());
        }
        return this.data.readByte(n2 + FontData.DataSize.BYTE.size());
    }

    public int transformationSize(int n) {
        int n2 = this.flags(n);
        if ((n2 & 8) == 8) {
            return FontData.DataSize.F2DOT14.size();
        }
        if ((n2 & 0x40) == 64) {
            return 2 * FontData.DataSize.F2DOT14.size();
        }
        if ((n2 & 0x80) == 128) {
            return 4 * FontData.DataSize.F2DOT14.size();
        }
        return 0;
    }

    public byte[] transformation(int n) {
        int n2 = this.flags(n);
        int n3 = this.contourIndex.get(n) + 2 * FontData.DataSize.USHORT.size();
        n3 = (n2 & 1) == 1 ? (n3 += 2 * FontData.DataSize.SHORT.size()) : (n3 += 2 * FontData.DataSize.BYTE.size());
        int n4 = this.transformationSize(n);
        byte[] byArray = new byte[n4];
        this.data.readBytes(n3, byArray, 0, n4);
        return byArray;
    }

    @Override
    public int instructionSize() {
        return this.instructionSize;
    }

    @Override
    public ReadableFontData instructions() {
        return this.data.slice(this.instructionsOffset, this.instructionSize());
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("\ncontourOffset.length = ");
        stringBuilder.append(this.contourIndex.size());
        stringBuilder.append("\ninstructionSize = ");
        stringBuilder.append(this.instructionSize);
        stringBuilder.append("\n\tcontour index = [");
        for (n = 0; n < this.contourIndex.size(); ++n) {
            if (n != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.contourIndex.get(n));
        }
        stringBuilder.append("]\n");
        for (n = 0; n < this.contourIndex.size(); ++n) {
            stringBuilder.append("\t" + n + " = [gid = " + this.glyphIndex(n) + ", arg1 = " + this.argument1(n) + ", arg2 = " + this.argument2(n) + "]\n");
        }
        return stringBuilder.toString();
    }

    public static class CompositeGlyphBuilder
    extends Glyph.Builder<CompositeGlyph> {
        protected CompositeGlyphBuilder(WritableFontData writableFontData, int n, int n2) {
            super(writableFontData.slice(n, n2));
        }

        protected CompositeGlyphBuilder(ReadableFontData readableFontData, int n, int n2) {
            super(readableFontData.slice(n, n2));
        }

        @Override
        protected CompositeGlyph subBuildTable(ReadableFontData readableFontData) {
            return new CompositeGlyph(readableFontData);
        }
    }
}

