/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;

public final class MaximumProfileTable
extends Table {
    private MaximumProfileTable(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
    }

    public int tableVersion() {
        return this.data.readFixed(Offset.version.offset);
    }

    public int numGlyphs() {
        return this.data.readUShort(Offset.numGlyphs.offset);
    }

    public int maxPoints() {
        return this.data.readUShort(Offset.maxPoints.offset);
    }

    public int maxContours() {
        return this.data.readUShort(Offset.maxContours.offset);
    }

    public int maxCompositePoints() {
        return this.data.readUShort(Offset.maxCompositePoints.offset);
    }

    public int maxCompositeContours() {
        return this.data.readUShort(Offset.maxCompositeContours.offset);
    }

    public int maxZones() {
        return this.data.readUShort(Offset.maxZones.offset);
    }

    public int maxTwilightPoints() {
        return this.data.readUShort(Offset.maxTwilightPoints.offset);
    }

    public int maxStorage() {
        return this.data.readUShort(Offset.maxStorage.offset);
    }

    public int maxFunctionDefs() {
        return this.data.readUShort(Offset.maxFunctionDefs.offset);
    }

    public int maxStackElements() {
        return this.data.readUShort(Offset.maxStackElements.offset);
    }

    public int maxSizeOfInstructions() {
        return this.data.readUShort(Offset.maxSizeOfInstructions.offset);
    }

    public int maxComponentElements() {
        return this.data.readUShort(Offset.maxComponentElements.offset);
    }

    public int maxComponentDepth() {
        return this.data.readUShort(Offset.maxComponentDepth.offset);
    }

    public static class Builder
    extends TableBasedTableBuilder<MaximumProfileTable> {
        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        @Override
        protected MaximumProfileTable subBuildTable(ReadableFontData readableFontData) {
            return new MaximumProfileTable(this.header(), readableFontData);
        }

        public int tableVersion() {
            return this.internalReadData().readUShort(Offset.version.offset);
        }

        public void setTableVersion(int n) {
            this.internalWriteData().writeUShort(Offset.version.offset, n);
        }

        public int numGlyphs() {
            return this.internalReadData().readUShort(Offset.numGlyphs.offset);
        }

        public void setNumGlyphs(int n) {
            this.internalWriteData().writeUShort(Offset.numGlyphs.offset, n);
        }

        public int maxPoints() {
            return this.internalReadData().readUShort(Offset.maxPoints.offset);
        }

        public void maxPoints(int n) {
            this.internalWriteData().writeUShort(Offset.maxPoints.offset, n);
        }

        public int maxContours() {
            return this.internalReadData().readUShort(Offset.maxContours.offset);
        }

        public void setMaxContours(int n) {
            this.internalWriteData().writeUShort(Offset.maxContours.offset, n);
        }

        public int maxCompositePoints() {
            return this.internalReadData().readUShort(Offset.maxCompositePoints.offset);
        }

        public void setMaxCompositePoints(int n) {
            this.internalWriteData().writeUShort(Offset.maxCompositePoints.offset, n);
        }

        public int maxCompositeContours() {
            return this.internalReadData().readUShort(Offset.maxCompositeContours.offset);
        }

        public void setMaxCompositeContours(int n) {
            this.internalWriteData().writeUShort(Offset.maxCompositeContours.offset, n);
        }

        public int maxZones() {
            return this.internalReadData().readUShort(Offset.maxZones.offset);
        }

        public void setMaxZones(int n) {
            this.internalWriteData().writeUShort(Offset.maxZones.offset, n);
        }

        public int maxTwilightPoints() {
            return this.internalReadData().readUShort(Offset.maxTwilightPoints.offset);
        }

        public void setMaxTwilightPoints(int n) {
            this.internalWriteData().writeUShort(Offset.maxTwilightPoints.offset, n);
        }

        public int maxStorage() {
            return this.internalReadData().readUShort(Offset.maxStorage.offset);
        }

        public void setMaxStorage(int n) {
            this.internalWriteData().writeUShort(Offset.maxStorage.offset, n);
        }

        public int maxFunctionDefs() {
            return this.internalReadData().readUShort(Offset.maxFunctionDefs.offset);
        }

        public void setMaxFunctionDefs(int n) {
            this.internalWriteData().writeUShort(Offset.maxFunctionDefs.offset, n);
        }

        public int maxStackElements() {
            return this.internalReadData().readUShort(Offset.maxStackElements.offset);
        }

        public void setMaxStackElements(int n) {
            this.internalWriteData().writeUShort(Offset.maxStackElements.offset, n);
        }

        public int maxSizeOfInstructions() {
            return this.internalReadData().readUShort(Offset.maxSizeOfInstructions.offset);
        }

        public void setMaxSizeOfInstructions(int n) {
            this.internalWriteData().writeUShort(Offset.maxSizeOfInstructions.offset, n);
        }

        public int maxComponentElements() {
            return this.internalReadData().readUShort(Offset.maxComponentElements.offset);
        }

        public void setMaxComponentElements(int n) {
            this.internalWriteData().writeUShort(Offset.maxComponentElements.offset, n);
        }

        public int maxComponentDepth() {
            return this.internalReadData().readUShort(Offset.maxComponentDepth.offset);
        }

        public void setMaxComponentDepth(int n) {
            this.internalWriteData().writeUShort(Offset.maxComponentDepth.offset, n);
        }
    }

    private static enum Offset {
        version(0),
        numGlyphs(4),
        maxPoints(6),
        maxContours(8),
        maxCompositePoints(10),
        maxCompositeContours(12),
        maxZones(14),
        maxTwilightPoints(16),
        maxStorage(18),
        maxFunctionDefs(20),
        maxInstructionDefs(22),
        maxStackElements(24),
        maxSizeOfInstructions(26),
        maxComponentElements(28),
        maxComponentDepth(30);

        private final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

