/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import java.io.IOException;
import java.io.OutputStream;

public abstract class FontDataTable {
    protected ReadableFontData data;

    FontDataTable(ReadableFontData readableFontData) {
        this.data = readableFontData;
    }

    public ReadableFontData readFontData() {
        return this.data;
    }

    public String toString() {
        return this.data.toString();
    }

    public final int dataLength() {
        return this.data.length();
    }

    public int serialize(OutputStream outputStream) throws IOException {
        return this.data.copyTo(outputStream);
    }

    protected int serialize(WritableFontData writableFontData) {
        return this.data.copyTo(writableFontData);
    }

    public static abstract class Builder<T extends FontDataTable> {
        private WritableFontData wData;
        private ReadableFontData rData;
        private boolean modelChanged;
        private boolean containedModelChanged;
        private boolean dataChanged;

        protected Builder(int n) {
            this.wData = WritableFontData.createWritableFontData(n);
        }

        protected Builder(WritableFontData writableFontData) {
            this.wData = writableFontData;
        }

        protected Builder(ReadableFontData readableFontData) {
            this.rData = readableFontData;
        }

        public WritableFontData data() {
            WritableFontData writableFontData;
            if (this.modelChanged) {
                if (!this.subReadyToSerialize()) {
                    throw new RuntimeException("Table not ready to build.");
                }
                int n = this.subDataSizeToSerialize();
                writableFontData = WritableFontData.createWritableFontData(n);
                this.subSerialize(writableFontData);
            } else {
                ReadableFontData readableFontData = this.internalReadData();
                writableFontData = WritableFontData.createWritableFontData(readableFontData != null ? readableFontData.length() : 0);
                if (readableFontData != null) {
                    readableFontData.copyTo(writableFontData);
                }
            }
            return writableFontData;
        }

        public void setData(WritableFontData writableFontData) {
            this.internalSetData(writableFontData, true);
        }

        public void setData(ReadableFontData readableFontData) {
            this.internalSetData(readableFontData, true);
        }

        private void internalSetData(WritableFontData writableFontData, boolean bl) {
            this.wData = writableFontData;
            this.rData = null;
            if (bl) {
                this.dataChanged = true;
                this.subDataSet();
            }
        }

        private void internalSetData(ReadableFontData readableFontData, boolean bl) {
            this.rData = readableFontData;
            this.wData = null;
            if (bl) {
                this.dataChanged = true;
                this.subDataSet();
            }
        }

        public T build() {
            T t = null;
            ReadableFontData readableFontData = this.internalReadData();
            if (this.modelChanged) {
                if (!this.subReadyToSerialize()) {
                    return null;
                }
                int n = this.subDataSizeToSerialize();
                WritableFontData writableFontData = WritableFontData.createWritableFontData(n);
                this.subSerialize(writableFontData);
                readableFontData = writableFontData;
            }
            if (readableFontData != null) {
                t = this.subBuildTable(readableFontData);
                this.notifyPostTableBuild(t);
            }
            this.rData = null;
            this.wData = null;
            return t;
        }

        public boolean readyToBuild() {
            return true;
        }

        protected ReadableFontData internalReadData() {
            if (this.rData != null) {
                return this.rData;
            }
            return this.wData;
        }

        protected WritableFontData internalWriteData() {
            if (this.wData == null) {
                WritableFontData writableFontData = WritableFontData.createWritableFontData(this.rData == null ? 0 : this.rData.length());
                if (this.rData != null) {
                    this.rData.copyTo(writableFontData);
                }
                this.internalSetData(writableFontData, false);
            }
            return this.wData;
        }

        public boolean changed() {
            return this.dataChanged() || this.modelChanged();
        }

        protected boolean dataChanged() {
            return this.dataChanged;
        }

        protected boolean modelChanged() {
            return this.currentModelChanged() || this.containedModelChanged();
        }

        protected boolean currentModelChanged() {
            return this.modelChanged;
        }

        protected boolean containedModelChanged() {
            return this.containedModelChanged;
        }

        protected boolean setModelChanged() {
            return this.setModelChanged(true);
        }

        protected boolean setModelChanged(boolean bl) {
            boolean bl2 = this.modelChanged;
            this.modelChanged = bl;
            return bl2;
        }

        protected void notifyPostTableBuild(T t) {
        }

        protected abstract int subSerialize(WritableFontData var1);

        protected abstract boolean subReadyToSerialize();

        protected abstract int subDataSizeToSerialize();

        protected abstract void subDataSet();

        protected abstract T subBuildTable(ReadableFontData var1);
    }
}

