/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.abc.ClassesListTreeModel;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedAction;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedEvent;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeRoot;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeSwfInfo;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.AS3Package;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.FrameScript;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.FolderItem;
import com.jpexs.decompiler.flash.treeitems.HeaderItem;
import com.jpexs.decompiler.flash.treeitems.SWFList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TagTreeModel
implements TreeModel {
    public static final String FOLDER_SHAPES = "shapes";
    public static final String FOLDER_MORPHSHAPES = "morphshapes";
    public static final String FOLDER_SPRITES = "sprites";
    public static final String FOLDER_TEXTS = "texts";
    public static final String FOLDER_IMAGES = "images";
    public static final String FOLDER_MOVIES = "movies";
    public static final String FOLDER_SOUNDS = "sounds";
    public static final String FOLDER_BUTTONS = "buttons";
    public static final String FOLDER_FONTS = "fonts";
    public static final String FOLDER_BINARY_DATA = "binaryData";
    public static final String FOLDER_FRAMES = "frames";
    public static final String FOLDER_OTHERS = "others";
    public static final String FOLDER_SCRIPTS = "scripts";
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private final TagTreeRoot root = new TagTreeRoot();
    private final List<SWFList> swfs;
    private final Map<SWF, TagTreeSwfInfo> swfInfos = new HashMap<SWF, TagTreeSwfInfo>();
    private final boolean addAllFolders;

    public TagTreeModel(List<SWFList> swfs, boolean addAllFolders) {
        this.swfs = swfs;
        this.addAllFolders = addAllFolders;
    }

    private String translate(String key) {
        return AppStrings.translate(key);
    }

    public void updateSwfs(CollectionChangedEvent e) {
        if (e.getAction() != CollectionChangedAction.ADD) {
            ArrayList<SWF> toRemove = new ArrayList<SWF>();
            for (SWF swf : this.swfInfos.keySet()) {
                SWF swf2 = swf.getRootSwf();
                if (swf2 == null || this.swfs.contains(swf2.swfList)) continue;
                toRemove.add(swf);
            }
            for (SWF swf : toRemove) {
                this.swfInfos.remove(swf);
            }
        }
        switch (e.getAction()) {
            case ADD: {
                TreePath rootPath = new TreePath(new Object[]{this.root});
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, rootPath, new int[]{e.getNewIndex()}, new Object[]{e.getNewItem()}));
                break;
            }
            case REMOVE: {
                TreePath rootPath = new TreePath(new Object[]{this.root});
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, rootPath, new int[]{e.getOldIndex()}, new Object[]{e.getOldItem()}));
                break;
            }
            default: {
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath((Object)this.root)));
            }
        }
    }

    public void updateSwf(SWF swf) {
        this.swfInfos.clear();
        TreePath changedPath = this.getTreePath((TreeItem)(swf == null ? this.root : swf));
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, changedPath));
    }

    public void updateNode(TreeItem treeItem) {
        TreePath changedPath = this.getTreePath(treeItem);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, changedPath));
    }

    public void updateNode(TreePath changedPath) {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, changedPath.getParentPath()));
    }

    private void fireTreeNodesRemoved(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(e);
        }
    }

    private void fireTreeNodesInserted(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(e);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(e);
        }
    }

    private List<SoundStreamHeadTypeTag> getSoundStreams(DefineSpriteTag sprite) {
        ArrayList<SoundStreamHeadTypeTag> ret = new ArrayList<SoundStreamHeadTypeTag>();
        for (Tag t : sprite.getTags()) {
            if (!(t instanceof SoundStreamHeadTypeTag)) continue;
            ret.add((SoundStreamHeadTypeTag)t);
        }
        return ret;
    }

    private void createTagList(SWF swf) {
        int i;
        ArrayList<TreeItem> nodeList = new ArrayList<TreeItem>();
        ArrayList<TreeItem> frames = new ArrayList<TreeItem>();
        ArrayList<TreeItem> shapes = new ArrayList<TreeItem>();
        ArrayList<TreeItem> morphShapes = new ArrayList<TreeItem>();
        ArrayList<TreeItem> sprites = new ArrayList<TreeItem>();
        ArrayList<TreeItem> buttons = new ArrayList<TreeItem>();
        ArrayList<TreeItem> images = new ArrayList<TreeItem>();
        ArrayList<TreeItem> fonts = new ArrayList<TreeItem>();
        ArrayList<TreeItem> texts = new ArrayList<TreeItem>();
        ArrayList<TreeItem> movies = new ArrayList<TreeItem>();
        ArrayList<TreeItem> sounds = new ArrayList<TreeItem>();
        ArrayList<TreeItem> binaryData = new ArrayList<TreeItem>();
        ArrayList<TreeItem> others = new ArrayList<TreeItem>();
        ArrayList<FolderItem> emptyFolders = new ArrayList<FolderItem>();
        HashMap<Integer, List<TreeItem>> mappedTags = new HashMap<Integer, List<TreeItem>>();
        block13: for (Tag t : swf.getTags()) {
            CharacterIdTag chit;
            TreeNodeType ttype = TagTree.getTreeNodeType((TreeItem)t);
            switch (ttype) {
                case SHAPE: {
                    shapes.add((TreeItem)t);
                    continue block13;
                }
                case MORPH_SHAPE: {
                    morphShapes.add((TreeItem)t);
                    continue block13;
                }
                case SPRITE: {
                    sprites.add((TreeItem)t);
                    sounds.addAll(this.getSoundStreams((DefineSpriteTag)t));
                    continue block13;
                }
                case BUTTON: {
                    buttons.add((TreeItem)t);
                    continue block13;
                }
                case IMAGE: {
                    images.add((TreeItem)t);
                    continue block13;
                }
                case FONT: {
                    fonts.add((TreeItem)t);
                    continue block13;
                }
                case TEXT: {
                    texts.add((TreeItem)t);
                    continue block13;
                }
                case MOVIE: {
                    movies.add((TreeItem)t);
                    continue block13;
                }
                case SOUND: {
                    sounds.add((TreeItem)t);
                    continue block13;
                }
                case BINARY_DATA: {
                    binaryData.add((TreeItem)t);
                    continue block13;
                }
                case AS: 
                case AS_FRAME: {
                    continue block13;
                }
            }
            if (t.getId() == 1 || ShowFrameTag.isNestedTagType((int)t.getId())) continue;
            boolean parentFound = false;
            if (t instanceof CharacterIdTag && !(t instanceof CharacterTag) && swf.getCharacter((chit = (CharacterIdTag)t).getCharacterId()) != null) {
                parentFound = true;
                if (!mappedTags.containsKey(chit.getCharacterId())) {
                    mappedTags.put(chit.getCharacterId(), new ArrayList());
                }
                ((List)mappedTags.get(chit.getCharacterId())).add(t);
            }
            if (parentFound) continue;
            others.add((TreeItem)t);
        }
        Timeline timeline = swf.getTimeline();
        int frameCount = timeline.getFrameCount();
        for (i = 0; i < frameCount; ++i) {
            frames.add((TreeItem)timeline.getFrame(i));
        }
        for (i = sounds.size() - 1; i >= 0; --i) {
            List blocks;
            TreeItem sound = (TreeItem)sounds.get(i);
            if (!(sound instanceof SoundStreamHeadTypeTag) || !(blocks = ((SoundStreamHeadTypeTag)sound).getBlocks()).isEmpty()) continue;
            sounds.remove(i);
        }
        nodeList.add((TreeItem)new HeaderItem(swf, this.translate("node.header")));
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.shapes"), FOLDER_SHAPES, swf, shapes);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.morphshapes"), FOLDER_MORPHSHAPES, swf, morphShapes);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.sprites"), FOLDER_SPRITES, swf, sprites);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.texts"), FOLDER_TEXTS, swf, texts);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.images"), FOLDER_IMAGES, swf, images);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.movies"), FOLDER_MOVIES, swf, movies);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.sounds"), FOLDER_SOUNDS, swf, sounds);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.buttons"), FOLDER_BUTTONS, swf, buttons);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.fonts"), FOLDER_FONTS, swf, fonts);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.binaryData"), FOLDER_BINARY_DATA, swf, binaryData);
        this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.frames"), FOLDER_FRAMES, swf, frames);
        this.addFolderItem(nodeList, emptyFolders, true, this.translate("node.others"), FOLDER_OTHERS, swf, others);
        HashMap<Tag, TagScript> currentTagScriptCache = new HashMap<Tag, TagScript>();
        if (swf.isAS3()) {
            if (!swf.getAbcList().isEmpty()) {
                nodeList.add((TreeItem)new ClassesListTreeModel(swf));
            }
        } else {
            List subNodes = swf.getFirstLevelASMNodes(currentTagScriptCache);
            if (subNodes.size() > 0) {
                FolderItem actionScriptNode = new FolderItem(this.translate("node.scripts"), FOLDER_SCRIPTS, swf, subNodes);
                nodeList.add((TreeItem)actionScriptNode);
            }
        }
        TagTreeSwfInfo swfInfo = new TagTreeSwfInfo();
        swfInfo.folders = nodeList;
        swfInfo.emptyFolders = emptyFolders;
        swfInfo.mappedTags = mappedTags;
        swfInfo.tagScriptCache = currentTagScriptCache;
        this.swfInfos.put(swf, swfInfo);
    }

    private void addFolderItem(List<TreeItem> nodeList, List<FolderItem> emptyList, boolean addAllFolders, String title, String folderName, SWF swf, List<TreeItem> items) {
        FolderItem node = new FolderItem(title, folderName, swf, items);
        if (addAllFolders || !items.isEmpty()) {
            nodeList.add((TreeItem)node);
        }
        if (items.isEmpty()) {
            emptyList.add(node);
        }
    }

    public TreeItem getScriptsNode(SWF swf) {
        int childCount = this.getChildCount(swf);
        for (int i = 0; i < childCount; ++i) {
            FolderItem folder;
            TreeItem child = this.getChild(swf, i);
            if (child instanceof ClassesListTreeModel) {
                return child;
            }
            if (!(child instanceof FolderItem) || !(folder = (FolderItem)child).getName().equals(FOLDER_SCRIPTS)) continue;
            return folder;
        }
        return null;
    }

    public TreeItem getFolderNode(SWF swf, String folderType) {
        int childCount = this.getChildCount(swf);
        for (int i = 0; i < childCount; ++i) {
            FolderItem folder;
            TreeItem child = this.getChild(swf, i);
            if (!(child instanceof FolderItem) || !(folder = (FolderItem)child).getName().equals(folderType)) continue;
            return folder;
        }
        return null;
    }

    private Frame searchForFrame(Object parent, SWF swf, Timelined t, int frame) {
        int childCount = this.getChildCount(parent);
        Frame lastVisibleFrame = null;
        for (int i = 0; i < childCount; ++i) {
            Frame si;
            Frame si2;
            TreeItem child = this.getChild(parent, i);
            if (child instanceof DefineSpriteTag && child == t && (si2 = this.searchForFrame(child, swf, t, frame)) != null) {
                return si2;
            }
            if (child instanceof Frame) {
                Frame f = (Frame)child;
                if (f.frame <= frame) {
                    lastVisibleFrame = f;
                }
            }
            if (!(child instanceof FolderItem)) continue;
            FolderItem folder = (FolderItem)child;
            if (folder.getName().equals(FOLDER_FRAMES) && t == swf && (si = this.searchForFrame(folder, swf, t, frame)) != null) {
                return si;
            }
            if (!folder.getName().equals(FOLDER_SPRITES) || (si = this.searchForFrame(folder, swf, t, frame)) == null) continue;
            return si;
        }
        return lastVisibleFrame;
    }

    public Frame getFrame(SWF swf, Timelined t, int frame) {
        return this.searchForFrame(swf, swf, t, frame);
    }

    private List<TreeItem> searchTreeItem(TreeItem obj, TreeItem parent, List<TreeItem> path) {
        List<TreeItem> ret = null;
        for (TreeItem treeItem : this.getAllChildren(parent)) {
            AS3ClassTreeItem te;
            ArrayList<TreeItem> newPath = new ArrayList<TreeItem>();
            newPath.addAll(path);
            newPath.add(treeItem);
            if (treeItem instanceof AS3ClassTreeItem && obj.equals(te = (AS3ClassTreeItem)treeItem)) {
                return newPath;
            }
            if (obj instanceof FolderItem && treeItem instanceof FolderItem) {
                FolderItem nds = (FolderItem)treeItem;
                FolderItem objs = (FolderItem)obj;
                if (objs.getName().equals(nds.getName()) && objs.swf.equals(nds.swf)) {
                    return newPath;
                }
            } else {
                if (obj.equals(treeItem)) {
                    return newPath;
                }
                if (treeItem instanceof TagScript && obj.equals(((TagScript)treeItem).getTag())) {
                    return newPath;
                }
            }
            if ((ret = this.searchTreeItem(obj, treeItem, newPath)) == null) continue;
            return ret;
        }
        return ret;
    }

    public TreePath getTreePath(TreeItem obj) {
        List<TreeItem> path = new ArrayList<TreeItem>();
        path.add((TreeItem)this.root);
        if (obj != this.root) {
            path = this.searchTreeItem(obj, (TreeItem)this.root, path);
        }
        if (path == null) {
            return null;
        }
        TreePath tp = new TreePath(path.toArray(new Object[path.size()]));
        return tp;
    }

    public TreeItem getRoot() {
        return this.root;
    }

    private TagTreeSwfInfo getSwfInfo(SWF swf) {
        TagTreeSwfInfo swfInfo = this.swfInfos.get(swf);
        if (swfInfo == null) {
            this.createTagList(swf);
            swfInfo = this.swfInfos.get(swf);
        }
        return swfInfo;
    }

    public List<FolderItem> getEmptyFolders(SWF swf) {
        TagTreeSwfInfo swfInfo = this.getSwfInfo(swf);
        return swfInfo.emptyFolders;
    }

    private List<TreeItem> getSwfFolders(SWF swf) {
        TagTreeSwfInfo swfInfo = this.getSwfInfo(swf);
        return swfInfo.folders;
    }

    private List<TreeItem> getMappedCharacters(SWF swf, CharacterTag tag) {
        TagTreeSwfInfo swfInfo = this.getSwfInfo(swf);
        List<TreeItem> mapped = swfInfo.mappedTags.get(tag.getCharacterId());
        if (mapped == null) {
            mapped = new ArrayList<TreeItem>();
        }
        return mapped;
    }

    private Map<Tag, TagScript> getTagScriptCache(SWF swf) {
        TagTreeSwfInfo swfInfo = this.getSwfInfo(swf);
        return swfInfo.tagScriptCache;
    }

    public List<? extends TreeItem> getAllChildren(Object parent) {
        TreeItem parentNode = (TreeItem)parent;
        if (parentNode == this.root) {
            ArrayList<Object> result = new ArrayList<Object>(this.swfs.size());
            for (SWFList swfList : this.swfs) {
                if (!swfList.isBundle()) {
                    result.add(swfList.get(0));
                }
                result.add(swfList);
            }
            return result;
        }
        if (parentNode instanceof SWFList) {
            return ((SWFList)parentNode).swfs;
        }
        if (parentNode instanceof SWF) {
            return this.getSwfFolders((SWF)parentNode);
        }
        if (parentNode instanceof FolderItem) {
            return ((FolderItem)parentNode).subItems;
        }
        if (parentNode instanceof Frame) {
            return ((Frame)parentNode).innerTags;
        }
        if (parentNode instanceof DefineSpriteTag) {
            return ((DefineSpriteTag)parentNode).getTimeline().getFrames();
        }
        if (parentNode instanceof DefineBinaryDataTag) {
            DefineBinaryDataTag binaryDataTag = (DefineBinaryDataTag)parentNode;
            if (binaryDataTag.innerSwf != null) {
                ArrayList<SWF> result = new ArrayList<SWF>(1);
                result.add(((DefineBinaryDataTag)parentNode).innerSwf);
                return result;
            }
            return new ArrayList(0);
        }
        if (parentNode instanceof AS2Package) {
            return ((AS2Package)parentNode).getAllChildren();
        }
        if (parentNode instanceof FrameScript) {
            Frame parentFrame = ((FrameScript)parentNode).getFrame();
            ArrayList<TagScript> result = new ArrayList<TagScript>();
            result.addAll(parentFrame.actionContainers);
            result.addAll(parentFrame.actions);
            for (int i = 0; i < result.size(); ++i) {
                TreeItem item = (TreeItem)result.get(i);
                if (!(item instanceof Tag)) continue;
                Tag resultTag = (Tag)item;
                Map<Tag, TagScript> currentTagScriptCache = this.getTagScriptCache(item.getSwf());
                TagScript tagScript = currentTagScriptCache.get(resultTag);
                if (tagScript == null) {
                    ArrayList<ASMSource> subNodes = new ArrayList<ASMSource>();
                    if (item instanceof ASMSourceContainer) {
                        for (ASMSource item2 : ((ASMSourceContainer)item).getSubItems()) {
                            subNodes.add(item2);
                        }
                    }
                    tagScript = new TagScript(item.getSwf(), resultTag, subNodes);
                    currentTagScriptCache.put(resultTag, tagScript);
                }
                result.set(i, tagScript);
            }
            return result;
        }
        if (parentNode instanceof TagScript) {
            return ((TagScript)parentNode).getFrames();
        }
        if (parentNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clt = (ClassesListTreeModel)parentNode;
            return clt.getAllChildren(clt.getRoot());
        }
        if (parentNode instanceof AS3ClassTreeItem) {
            if (parentNode instanceof AS3Package) {
                return ((AS3Package)parentNode).getAllChildren();
            }
            return new ArrayList();
        }
        if (parentNode instanceof CharacterTag) {
            return this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode);
        }
        return new ArrayList();
    }

    public TreeItem getChild(Object parent, int index) {
        if (this.getChildCount(parent) == 0) {
            return null;
        }
        TreeItem parentNode = (TreeItem)parent;
        if (parentNode instanceof CharacterTag) {
            List<TreeItem> mapped = this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode);
            if (index < mapped.size()) {
                return mapped.get(index);
            }
            index -= mapped.size();
        }
        if (parentNode == this.root) {
            SWFList swfList = this.swfs.get(index);
            if (!swfList.isBundle()) {
                return swfList.get(0);
            }
            return swfList;
        }
        if (parentNode instanceof SWFList) {
            return (TreeItem)((SWFList)parentNode).swfs.get(index);
        }
        if (parentNode instanceof SWF) {
            return this.getSwfFolders((SWF)parentNode).get(index);
        }
        if (parentNode instanceof FolderItem) {
            return (TreeItem)((FolderItem)parentNode).subItems.get(index);
        }
        if (parentNode instanceof Frame) {
            return (TreeItem)((Frame)parentNode).innerTags.get(index);
        }
        if (parentNode instanceof DefineSpriteTag) {
            return ((DefineSpriteTag)parentNode).getTimeline().getFrame(index);
        }
        if (parentNode instanceof DefineBinaryDataTag) {
            return ((DefineBinaryDataTag)parentNode).innerSwf;
        }
        if (parentNode instanceof AS2Package) {
            return ((AS2Package)parentNode).getChild(index);
        }
        if (parentNode instanceof FrameScript) {
            Frame parentFrame = ((FrameScript)parentNode).getFrame();
            TreeItem result = index < parentFrame.actionContainers.size() ? (TreeItem)parentFrame.actionContainers.get(index) : (TreeItem)parentFrame.actions.get(index -= parentFrame.actionContainers.size());
            if (result instanceof Tag) {
                Tag resultTag = (Tag)result;
                Map<Tag, TagScript> currentTagScriptCache = this.getTagScriptCache(result.getSwf());
                TagScript tagScript = currentTagScriptCache.get(resultTag);
                if (tagScript == null) {
                    ArrayList<ASMSource> subNodes = new ArrayList<ASMSource>();
                    if (result instanceof ASMSourceContainer) {
                        for (ASMSource item : ((ASMSourceContainer)result).getSubItems()) {
                            subNodes.add(item);
                        }
                    }
                    tagScript = new TagScript(result.getSwf(), resultTag, subNodes);
                    currentTagScriptCache.put(resultTag, tagScript);
                }
                result = tagScript;
            }
            return result;
        }
        if (parentNode instanceof TagScript) {
            return (TreeItem)((TagScript)parentNode).getFrames().get(index);
        }
        if (parentNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clt = (ClassesListTreeModel)parentNode;
            return clt.getChild(clt.getRoot(), index);
        }
        if (parentNode instanceof AS3ClassTreeItem) {
            return ((AS3Package)parentNode).getChild(index);
        }
        throw new Error("Unsupported parent type: " + parentNode.getClass().getName());
    }

    @Override
    public int getChildCount(Object parent) {
        TreeItem parentNode = (TreeItem)parent;
        int mappedSize = 0;
        if (parentNode instanceof CharacterTag) {
            mappedSize = this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode).size();
        }
        if (parentNode == this.root) {
            return mappedSize + this.swfs.size();
        }
        if (parentNode instanceof SWFList) {
            return mappedSize + ((SWFList)parentNode).swfs.size();
        }
        if (parentNode instanceof SWF) {
            return mappedSize + this.getSwfFolders((SWF)parentNode).size();
        }
        if (parentNode instanceof HeaderItem) {
            return mappedSize + 0;
        }
        if (parentNode instanceof FolderItem) {
            return mappedSize + ((FolderItem)parentNode).subItems.size();
        }
        if (parentNode instanceof Frame) {
            return mappedSize + ((Frame)parentNode).innerTags.size();
        }
        if (parentNode instanceof DefineSpriteTag) {
            return mappedSize + ((DefineSpriteTag)parentNode).getTimeline().getFrameCount();
        }
        if (parentNode instanceof DefineBinaryDataTag) {
            return mappedSize + (((DefineBinaryDataTag)parentNode).innerSwf == null ? 0 : 1);
        }
        if (parentNode instanceof AS2Package) {
            return mappedSize + ((AS2Package)parentNode).getChildCount();
        }
        if (parentNode instanceof FrameScript) {
            Frame parentFrame = ((FrameScript)parentNode).getFrame();
            return mappedSize + parentFrame.actionContainers.size() + parentFrame.actions.size();
        }
        if (parentNode instanceof TagScript) {
            return mappedSize + ((TagScript)parentNode).getFrames().size();
        }
        if (parentNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clt = (ClassesListTreeModel)parentNode;
            return mappedSize + clt.getChildCount(clt.getRoot());
        }
        if (parentNode instanceof AS3Package) {
            return mappedSize + ((AS3Package)parentNode).getChildCount();
        }
        if (parentNode instanceof CharacterTag) {
            return mappedSize;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private int indexOfAdd(int prevSize, int index) {
        if (index == -1) {
            return -1;
        }
        return prevSize + index;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeItem parentNode = (TreeItem)parent;
        TreeItem childNode = (TreeItem)child;
        int baseIndex = 0;
        if (parentNode instanceof CharacterTag) {
            List<TreeItem> mapped = this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode);
            int mindex = mapped.indexOf(child);
            if (mindex > -1) {
                return mindex;
            }
            baseIndex = mapped.size();
        }
        if (parentNode == this.root) {
            SWFList swfList = child instanceof SWFList ? (SWFList)child : ((SWF)child).swfList;
            return this.indexOfAdd(baseIndex, this.swfs.indexOf(swfList));
        }
        if (parentNode instanceof SWFList) {
            return this.indexOfAdd(baseIndex, ((SWFList)parentNode).swfs.indexOf(childNode));
        }
        if (parentNode instanceof SWF) {
            return this.indexOfAdd(baseIndex, this.getSwfFolders((SWF)parentNode).indexOf(childNode));
        }
        if (parentNode instanceof FolderItem) {
            return this.indexOfAdd(baseIndex, ((FolderItem)parentNode).subItems.indexOf(childNode));
        }
        if (parentNode instanceof Frame) {
            return this.indexOfAdd(baseIndex, ((Frame)parentNode).innerTags.indexOf(childNode));
        }
        if (parentNode instanceof DefineSpriteTag) {
            return this.indexOfAdd(baseIndex, ((Frame)childNode).frame);
        }
        if (parentNode instanceof DefineBinaryDataTag) {
            return this.indexOfAdd(baseIndex, 0);
        }
        if (parentNode instanceof AS2Package) {
            return this.indexOfAdd(baseIndex, ((AS2Package)parentNode).getIndexOfChild(childNode));
        }
        if (parentNode instanceof FrameScript) {
            Frame parentFrame = ((FrameScript)parentNode).getFrame();
            if (childNode instanceof TagScript) {
                childNode = ((TagScript)childNode).getTag();
            }
            if (childNode instanceof ASMSourceContainer) {
                return this.indexOfAdd(baseIndex, parentFrame.actionContainers.indexOf(childNode));
            }
            return this.indexOfAdd(baseIndex, parentFrame.actionContainers.size() + parentFrame.actions.indexOf(childNode));
        }
        if (parentNode instanceof TagScript) {
            return this.indexOfAdd(baseIndex, ((TagScript)parentNode).getFrames().indexOf(childNode));
        }
        if (parentNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clt = (ClassesListTreeModel)parentNode;
            return this.indexOfAdd(baseIndex, clt.getIndexOfChild(clt.getRoot(), childNode));
        }
        if (parentNode instanceof AS3ClassTreeItem) {
            return this.indexOfAdd(baseIndex, ((AS3Package)parentNode).getIndexOfChild((AS3ClassTreeItem)childNode));
        }
        if (parentNode instanceof CharacterTag) {
            return this.indexOfAdd(baseIndex, this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode).indexOf(childNode));
        }
        throw new Error("Unsupported parent type: " + parentNode.getClass().getName());
    }

    public boolean treePathExists(TreePath treePath) {
        TreeItem current = null;
        for (Object o : treePath.getPath()) {
            TreeItem item = (TreeItem)o;
            if (current == null) {
                if (item != this.getRoot()) {
                    return false;
                }
                current = item;
                continue;
            }
            int idx = this.getIndexOfChild(current, item);
            if (idx == -1) {
                return false;
            }
            current = item;
        }
        return true;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }
}

