/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ActionScript3Parser;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.script.ActionScript2Parser;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.ReplaceCharacterDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.abc.AddClassDialog;
import com.jpexs.decompiler.flash.gui.abc.ClassesListTreeModel;
import com.jpexs.decompiler.flash.gui.action.AddScriptDialog;
import com.jpexs.decompiler.flash.gui.tagtree.TagIdClassMap;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeModel;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DoABC2Tag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject3Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject4Tag;
import com.jpexs.decompiler.flash.tags.PlaceObjectTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.UnknownTag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.AS3Package;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.FrameScript;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.FolderItem;
import com.jpexs.decompiler.flash.treeitems.SWFList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TagTreeContextMenu
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(TagTreeContextMenu.class.getName());
    private final MainPanel mainPanel;
    private final TagTree tagTree;
    private JMenuItem expandRecursiveMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem removeWithDependenciesMenuItem;
    private JMenuItem undoTagMenuItem;
    private JMenuItem exportSelectionMenuItem;
    private JMenuItem replaceMenuItem;
    private JMenuItem replaceNoFillMenuItem;
    private JMenuItem replaceWithTagMenuItem;
    private JMenuItem rawEditMenuItem;
    private JMenuItem jumpToCharacterMenuItem;
    private JMenuItem exportJavaSourceMenuItem;
    private JMenuItem exportSwfXmlMenuItem;
    private JMenuItem importSwfXmlMenuItem;
    private JMenuItem closeMenuItem;
    private JMenu addTagMenu;
    private JMenu moveTagMenu;
    private JMenu copyTagMenu;
    private JMenu copyTagWithDependenciesMenu;
    private JMenuItem openSWFInsideTagMenuItem;
    private JMenuItem addAs12ScriptMenuItem;
    private JMenuItem addAs3ClassMenuItem;
    private JMenuItem textSearchMenuItem;

    public TagTreeContextMenu(final TagTree tagTree, MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.tagTree = tagTree;
        this.expandRecursiveMenuItem = new JMenuItem(mainPanel.translate("contextmenu.expandAll"));
        this.expandRecursiveMenuItem.addActionListener(this::expandRecursiveActionPerformed);
        this.add(this.expandRecursiveMenuItem);
        this.removeMenuItem = new JMenuItem(mainPanel.translate("contextmenu.remove"));
        this.removeMenuItem.addActionListener(e -> this.removeItemActionPerformed(e, false));
        this.add(this.removeMenuItem);
        this.removeWithDependenciesMenuItem = new JMenuItem(mainPanel.translate("contextmenu.removeWithDependencies"));
        this.removeWithDependenciesMenuItem.addActionListener(e -> this.removeItemActionPerformed(e, true));
        this.add(this.removeWithDependenciesMenuItem);
        this.undoTagMenuItem = new JMenuItem(mainPanel.translate("contextmenu.undo"));
        this.undoTagMenuItem.addActionListener(this::undoTagActionPerformed);
        this.add(this.undoTagMenuItem);
        this.exportSelectionMenuItem = new JMenuItem(mainPanel.translate("menu.file.export.selection"));
        this.exportSelectionMenuItem.addActionListener(mainPanel::exportSelectionActionPerformed);
        this.add(this.exportSelectionMenuItem);
        this.replaceMenuItem = new JMenuItem(mainPanel.translate("button.replace"));
        this.replaceMenuItem.addActionListener(mainPanel::replaceButtonActionPerformed);
        this.add(this.replaceMenuItem);
        this.replaceNoFillMenuItem = new JMenuItem(mainPanel.translate("button.replaceNoFill"));
        this.replaceNoFillMenuItem.addActionListener(mainPanel::replaceNoFillButtonActionPerformed);
        this.add(this.replaceNoFillMenuItem);
        this.replaceWithTagMenuItem = new JMenuItem(mainPanel.translate("button.replaceWithTag"));
        this.replaceWithTagMenuItem.addActionListener(this::replaceWithTagActionPerformed);
        this.add(this.replaceWithTagMenuItem);
        this.rawEditMenuItem = new JMenuItem(mainPanel.translate("contextmenu.rawEdit"));
        this.rawEditMenuItem.addActionListener(this::rawEditActionPerformed);
        this.add(this.rawEditMenuItem);
        this.jumpToCharacterMenuItem = new JMenuItem(mainPanel.translate("contextmenu.jumpToCharacter"));
        this.jumpToCharacterMenuItem.addActionListener(this::jumpToCharacterActionPerformed);
        this.add(this.jumpToCharacterMenuItem);
        this.exportJavaSourceMenuItem = new JMenuItem(mainPanel.translate("contextmenu.exportJavaSource"));
        this.exportJavaSourceMenuItem.addActionListener(mainPanel::exportJavaSourceActionPerformed);
        this.add(this.exportJavaSourceMenuItem);
        this.exportSwfXmlMenuItem = new JMenuItem(mainPanel.translate("contextmenu.exportSwfXml"));
        this.exportSwfXmlMenuItem.addActionListener(mainPanel::exportSwfXmlActionPerformed);
        this.add(this.exportSwfXmlMenuItem);
        this.importSwfXmlMenuItem = new JMenuItem(mainPanel.translate("contextmenu.importSwfXml"));
        this.importSwfXmlMenuItem.addActionListener(mainPanel::importSwfXmlActionPerformed);
        this.add(this.importSwfXmlMenuItem);
        this.addTagMenu = new JMenu(mainPanel.translate("contextmenu.addTag"));
        this.add(this.addTagMenu);
        this.moveTagMenu = new JMenu(mainPanel.translate("contextmenu.moveTag"));
        this.add(this.moveTagMenu);
        this.copyTagMenu = new JMenu(mainPanel.translate("contextmenu.copyTag"));
        this.add(this.copyTagMenu);
        this.copyTagWithDependenciesMenu = new JMenu(mainPanel.translate("contextmenu.copyTagWithDependencies"));
        this.add(this.copyTagWithDependenciesMenu);
        this.openSWFInsideTagMenuItem = new JMenuItem(mainPanel.translate("contextmenu.openswfinside"));
        this.add(this.openSWFInsideTagMenuItem);
        this.openSWFInsideTagMenuItem.addActionListener(this::openSwfInsideActionPerformed);
        this.addAs12ScriptMenuItem = new JMenuItem(mainPanel.translate("contextmenu.addScript"));
        this.addAs12ScriptMenuItem.addActionListener(this::addAs12ScriptActionPerformed);
        this.add(this.addAs12ScriptMenuItem);
        this.addAs3ClassMenuItem = new JMenuItem(mainPanel.translate("contextmenu.addClass"));
        this.addAs3ClassMenuItem.addActionListener(this::addAs3ClassActionPerformed);
        this.add(this.addAs3ClassMenuItem);
        this.textSearchMenuItem = new JMenuItem(mainPanel.translate("menu.tools.search"));
        this.textSearchMenuItem.addActionListener(this::textSearchActionPerformed);
        this.add(this.textSearchMenuItem);
        this.closeMenuItem = new JMenuItem(mainPanel.translate("contextmenu.closeSwf"));
        this.closeMenuItem.addActionListener(this::closeSwfActionPerformed);
        this.add(this.closeMenuItem);
        tagTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    TreePath[] paths;
                    int row = tagTree.getClosestRowForLocation(e.getX(), e.getY());
                    int[] selectionRows = tagTree.getSelectionRows();
                    if (!Helper.contains((int[])selectionRows, (int)row)) {
                        tagTree.setSelectionRow(row);
                    }
                    if ((paths = tagTree.getSelectionPaths()) == null || paths.length == 0) {
                        return;
                    }
                    ArrayList<TreeItem> li = new ArrayList<TreeItem>();
                    for (TreePath treePath : paths) {
                        TreeItem item = (TreeItem)treePath.getLastPathComponent();
                        li.add(item);
                    }
                    TagTreeContextMenu.this.update(li);
                    TagTreeContextMenu.this.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void update(List<TreeItem> items) {
        void var10_29;
        boolean bl;
        boolean bl2;
        if (items.isEmpty()) {
            return;
        }
        List<SWFList> swfs = this.mainPanel.getSwfs();
        boolean canRemove = true;
        boolean allDoNotHaveDependencies = true;
        for (TreeItem item : items) {
            if (!(item instanceof Tag) && !(item instanceof Frame)) {
                if (item instanceof TagScript) {
                    Tag tag = ((TagScript)item).getTag();
                    if (!(tag instanceof DoActionTag) && !(tag instanceof DoInitActionTag)) continue;
                    allDoNotHaveDependencies = false;
                    continue;
                }
                if (item instanceof AS2Package) {
                    allDoNotHaveDependencies = false;
                    continue;
                }
                if (item instanceof CLIPACTIONRECORD || item instanceof BUTTONCONDACTION || item instanceof ScriptPack || item instanceof AS3Package || item instanceof FrameScript) continue;
                canRemove = false;
                break;
            }
            allDoNotHaveDependencies = false;
        }
        boolean hasScripts = false;
        boolean hasTexts = false;
        for (TreeItem treeItem : items) {
            if (treeItem instanceof SWF) {
                hasScripts = true;
                hasTexts = true;
                break;
            }
            if (treeItem instanceof ASMSource) {
                hasScripts = true;
            }
            if (treeItem instanceof TagScript) {
                hasScripts = true;
            }
            if (treeItem instanceof FrameScript) {
                hasScripts = true;
            }
            if (treeItem instanceof AS2Package) {
                hasScripts = true;
            }
            if (treeItem instanceof ScriptPack) {
                hasScripts = true;
            }
            if (treeItem instanceof AS3Package) {
                hasScripts = true;
            }
            if (treeItem instanceof TextTag) {
                hasTexts = true;
            }
            if (!(treeItem instanceof FolderItem)) continue;
            FolderItem folderItem = (FolderItem)treeItem;
            if (folderItem.getName().equals("scripts")) {
                hasScripts = true;
            }
            if (!folderItem.getName().equals("texts")) continue;
            hasTexts = true;
        }
        boolean allSelectedIsTag = true;
        for (TreeItem treeItem : items) {
            Tag tag;
            if (treeItem instanceof Tag || treeItem instanceof TagScript && ((tag = ((TagScript)treeItem).getTag()) instanceof DoActionTag || tag instanceof DoInitActionTag)) continue;
            allSelectedIsTag = false;
            break;
        }
        boolean bl3 = true;
        for (TreeItem treeItem : items) {
            if (treeItem instanceof DefineBinaryDataTag) continue;
            bl2 = false;
            break;
        }
        boolean bl4 = true;
        for (TreeItem item : items) {
            if (!(item instanceof SWF) && !(item instanceof SWFList)) {
                bl = false;
                break;
            }
            if (!(item instanceof SWF)) continue;
            SWF swf = (SWF)item;
            if (swf.swfList == null || !swf.swfList.isBundle()) continue;
            boolean bl5 = false;
        }
        boolean bl6 = true;
        SWF singleSwf = null;
        for (TreeItem treeItem : items) {
            if (treeItem instanceof SWFList) {
                boolean bl7 = false;
                break;
            }
            if (singleSwf == null) {
                singleSwf = treeItem.getSwf();
                continue;
            }
            if (singleSwf == treeItem.getSwf()) continue;
            boolean bl8 = false;
            break;
        }
        this.expandRecursiveMenuItem.setVisible(false);
        this.removeMenuItem.setVisible(canRemove);
        this.removeWithDependenciesMenuItem.setVisible(canRemove && !allDoNotHaveDependencies);
        this.undoTagMenuItem.setVisible(allSelectedIsTag);
        this.exportSelectionMenuItem.setEnabled(this.tagTree.hasExportableNodes());
        this.replaceMenuItem.setVisible(false);
        this.replaceNoFillMenuItem.setVisible(false);
        this.replaceWithTagMenuItem.setVisible(false);
        this.rawEditMenuItem.setVisible(false);
        this.jumpToCharacterMenuItem.setVisible(false);
        this.exportJavaSourceMenuItem.setVisible(bl);
        this.exportSwfXmlMenuItem.setVisible(bl);
        this.importSwfXmlMenuItem.setVisible(bl);
        this.closeMenuItem.setVisible(bl);
        this.addTagMenu.setVisible(false);
        this.moveTagMenu.setVisible(false);
        this.copyTagMenu.setVisible(false);
        this.copyTagWithDependenciesMenu.setVisible(false);
        this.openSWFInsideTagMenuItem.setVisible(false);
        this.addAs12ScriptMenuItem.setVisible(false);
        this.addAs3ClassMenuItem.setVisible(false);
        this.textSearchMenuItem.setVisible(hasScripts || hasTexts);
        if (allSelectedIsTag) {
            boolean canUndo = false;
            for (TreeItem item : items) {
                Tag tag;
                if (!(item instanceof Tag) || !(tag = (Tag)item).canUndo()) continue;
                canUndo = true;
                break;
            }
            this.undoTagMenuItem.setEnabled(canUndo);
        }
        boolean singleSelect = items.size() == 1;
        Predicate<Predicate> predicate = p -> {
            for (TreeItem ti : items) {
                if (p.test(ti)) continue;
                return false;
            }
            return true;
        };
        if (predicate.test(it -> it instanceof ImageTag && ((ImageTag)it).importSupported())) {
            this.replaceMenuItem.setVisible(true);
        }
        if (predicate.test(it -> it instanceof ShapeTag)) {
            this.replaceMenuItem.setVisible(true);
            this.replaceNoFillMenuItem.setVisible(true);
        }
        if (predicate.test(it -> it instanceof DefineBinaryDataTag)) {
            this.replaceMenuItem.setVisible(true);
        }
        if (predicate.test(it -> it instanceof DefineSoundTag)) {
            this.replaceMenuItem.setVisible(true);
        }
        if (predicate.test(it -> it instanceof UnknownTag)) {
            this.replaceMenuItem.setVisible(true);
        }
        if (singleSelect) {
            List<Integer> allowedTagTypes;
            TreeItem firstItem = items.get(0);
            if (firstItem instanceof FolderItem && ((FolderItem)firstItem).getName().equals("scripts")) {
                this.addAs12ScriptMenuItem.setVisible(true);
            }
            if (firstItem instanceof ClassesListTreeModel) {
                this.addAs3ClassMenuItem.setVisible(true);
            }
            if (firstItem instanceof AS3Package) {
                this.addAs3ClassMenuItem.setVisible(true);
            }
            if (firstItem instanceof CharacterTag) {
                this.replaceWithTagMenuItem.setVisible(true);
            }
            this.addTagMenu.removeAll();
            if (firstItem instanceof FolderItem) {
                FolderItem folderItem = (FolderItem)firstItem;
                SWF swf = firstItem.getSwf();
                if (folderItem.getName().equals("others")) {
                    TagTreeModel ttm = this.tagTree.getModel();
                    for (FolderItem emptyFolder : ttm.getEmptyFolders(swf)) {
                        JMenu subMenu = new JMenu(emptyFolder.toString());
                        allowedTagTypes = this.tagTree.getSwfFolderItemNestedTagIds(emptyFolder.getName(), swf.gfx);
                        this.addAddTagMenuItems(allowedTagTypes, subMenu, firstItem);
                        if (subMenu.getItemCount() <= 0) continue;
                        this.addTagMenu.add(subMenu);
                    }
                }
                allowedTagTypes = this.tagTree.getSwfFolderItemNestedTagIds(folderItem.getName(), swf.gfx);
                this.addAddTagMenuItems(allowedTagTypes, this.addTagMenu, firstItem);
            } else if (firstItem instanceof Tag) {
                allowedTagTypes = this.tagTree.getNestedTagIds((Tag)firstItem);
                this.addAddTagMenuItems(allowedTagTypes, this.addTagMenu, firstItem);
            } else if (firstItem instanceof Frame) {
                allowedTagTypes = this.tagTree.getFrameNestedTagIds();
                this.addAddTagMenuItems(allowedTagTypes, this.addTagMenu, firstItem);
            }
            this.addTagMenu.setVisible(this.addTagMenu.getItemCount() > 0);
            if (this.tagTree.getModel().getChildCount(firstItem) > 0) {
                this.expandRecursiveMenuItem.setVisible(true);
            }
            if (firstItem instanceof CharacterIdTag && !(firstItem instanceof CharacterTag)) {
                this.jumpToCharacterMenuItem.setVisible(true);
            }
            if (firstItem instanceof Tag) {
                this.rawEditMenuItem.setVisible(true);
            }
        }
        if (var10_29 != false && allSelectedIsTag && swfs.size() > 1) {
            this.moveTagMenu.removeAll();
            this.copyTagMenu.removeAll();
            this.copyTagWithDependenciesMenu.removeAll();
            for (SWFList targetSwfList : swfs) {
                for (SWF targetSwf : targetSwfList) {
                    if (targetSwf == singleSwf) continue;
                    JMenuItem swfItem = new JMenuItem(targetSwf.getShortFileName());
                    swfItem.addActionListener(ae -> this.moveTagActionPerformed(ae, items, targetSwf));
                    this.moveTagMenu.add(swfItem);
                    swfItem = new JMenuItem(targetSwf.getShortFileName());
                    swfItem.addActionListener(ae -> this.copyTagActionPerformed(ae, items, targetSwf));
                    this.copyTagMenu.add(swfItem);
                    swfItem = new JMenuItem(targetSwf.getShortFileName());
                    swfItem.addActionListener(ae -> this.copyTagWithDependenciesActionPerformed(ae, items, targetSwf));
                    this.copyTagWithDependenciesMenu.add(swfItem);
                }
            }
            this.moveTagMenu.setVisible(true);
            this.copyTagMenu.setVisible(true);
            this.copyTagWithDependenciesMenu.setVisible(true);
        }
        if (bl2) {
            boolean anyInnerSwf = false;
            for (TreeItem item : items) {
                DefineBinaryDataTag binary = (DefineBinaryDataTag)item;
                if (binary.innerSwf != null || !binary.isSwfData()) continue;
                anyInnerSwf = true;
            }
            this.openSWFInsideTagMenuItem.setVisible(anyInnerSwf);
        }
        for (TreeItem item : items) {
            if (!(item instanceof Tag) || !((Tag)item).isReadOnly()) continue;
            this.removeMenuItem.setVisible(false);
            this.removeWithDependenciesMenuItem.setVisible(false);
            this.undoTagMenuItem.setVisible(false);
            this.replaceMenuItem.setVisible(false);
            this.replaceNoFillMenuItem.setVisible(false);
            this.replaceWithTagMenuItem.setVisible(false);
            this.rawEditMenuItem.setVisible(false);
            this.jumpToCharacterMenuItem.setVisible(false);
            this.importSwfXmlMenuItem.setVisible(false);
            this.addTagMenu.setVisible(false);
            this.moveTagMenu.setVisible(false);
            this.openSWFInsideTagMenuItem.setVisible(false);
        }
    }

    private void addAddTagMenuItems(List<Integer> allowedTagTypes, JMenu addTagMenu, TreeItem item) {
        if (allowedTagTypes == null) {
            return;
        }
        for (Integer tagId : allowedTagTypes) {
            Class<?> cl = TagIdClassMap.getClassByTagId(tagId);
            JMenuItem tagItem = new JMenuItem(cl.getSimpleName());
            tagItem.addActionListener(ae -> this.addTagActionPerformed(ae, item, cl));
            addTagMenu.add(tagItem);
        }
    }

    private void addTagActionPerformed(ActionEvent evt, TreeItem firstItem, Class<?> cl) {
        try {
            SWF swf = firstItem.getSwf();
            Tag t = (Tag)cl.getDeclaredConstructor(SWF.class).newInstance(swf);
            swf.addTag(t, firstItem);
            swf.updateCharacters();
            this.mainPanel.refreshTree(swf);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private int chechUniqueCharacterId(Tag tag) {
        if (tag instanceof CharacterTag) {
            CharacterTag characterTag = (CharacterTag)tag;
            int characterId = characterTag.getCharacterId();
            SWF swf = tag.getSwf();
            if (swf.getCharacter(characterId) != null) {
                int newCharacterId = swf.getNextCharacterId();
                characterTag.setCharacterId(newCharacterId);
                logger.log(Level.WARNING, "Target SWF already contained chatacter tag with id = {0} => id changed to {1}", new Object[]{characterId, newCharacterId});
                return newCharacterId;
            }
            return characterId;
        }
        return -1;
    }

    private void moveTagActionPerformed(ActionEvent evt, List<TreeItem> items, SWF targetSwf) {
        SWF sourceSwf = items.get(0).getSwf();
        for (TreeItem item : items) {
            Tag tag = (Tag)item;
            sourceSwf.removeTag(tag);
            tag.setSwf(targetSwf, true);
            targetSwf.addTag(tag);
            this.chechUniqueCharacterId(tag);
            targetSwf.updateCharacters();
            tag.setModified(true);
        }
        sourceSwf.assignExportNamesToSymbols();
        targetSwf.assignExportNamesToSymbols();
        sourceSwf.assignClassesToSymbols();
        targetSwf.assignClassesToSymbols();
        sourceSwf.clearImageCache();
        targetSwf.clearImageCache();
        sourceSwf.updateCharacters();
        targetSwf.updateCharacters();
        sourceSwf.resetTimelines((Timelined)sourceSwf);
        targetSwf.resetTimelines((Timelined)targetSwf);
        this.mainPanel.refreshTree(new SWF[]{sourceSwf, targetSwf});
    }

    private void copyTagActionPerformed(ActionEvent evt, List<TreeItem> items, SWF targetSwf) {
        try {
            for (TreeItem item : items) {
                Tag tag = (Tag)item;
                Tag copyTag = tag.cloneTag();
                copyTag.setSwf(targetSwf, true);
                targetSwf.addTag(copyTag);
                this.chechUniqueCharacterId(copyTag);
                targetSwf.updateCharacters();
                copyTag.setModified(true);
            }
            targetSwf.assignExportNamesToSymbols();
            targetSwf.assignClassesToSymbols();
            targetSwf.clearImageCache();
            targetSwf.updateCharacters();
            this.mainPanel.refreshTree(targetSwf);
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void copyTagWithDependenciesActionPerformed(ActionEvent evt, List<TreeItem> items, SWF targetSwf) {
        try {
            SWF sourceSwf = items.get(0).getSwf();
            for (TreeItem item : items) {
                Tag copyTag;
                HashSet<Object> copiedTags = new HashSet<Object>();
                HashSet<Tag> newTags = new HashSet<Tag>();
                LinkedHashSet needed = new LinkedHashSet();
                HashMap<Integer, Integer> changedCharacterIds = new HashMap<Integer, Integer>();
                Tag tag = (Tag)item;
                tag.getNeededCharactersDeep(needed);
                ArrayList<Integer> neededList = new ArrayList<Integer>();
                for (Integer characterId : needed) {
                    neededList.add(characterId);
                }
                for (int i = neededList.size() - 1; i >= 0; --i) {
                    int characterId = (Integer)neededList.get(i);
                    CharacterTag neededTag = sourceSwf.getCharacter(characterId);
                    if (copiedTags.contains(neededTag)) continue;
                    copyTag = neededTag.cloneTag();
                    copyTag.setSwf(targetSwf, true);
                    targetSwf.addTag(copyTag);
                    int oldCharacterId = neededTag.getCharacterId();
                    int newCharacterId = this.chechUniqueCharacterId(copyTag);
                    changedCharacterIds.put(oldCharacterId, newCharacterId);
                    targetSwf.updateCharacters();
                    targetSwf.getCharacters();
                    copyTag.setModified(true);
                    copiedTags.add(neededTag);
                    newTags.add(copyTag);
                }
                copyTag = tag.cloneTag();
                copyTag.setSwf(targetSwf, true);
                targetSwf.addTag(copyTag);
                if (tag instanceof CharacterTag) {
                    CharacterTag characterTag = (CharacterTag)copyTag;
                    int oldCharacterId = characterTag.getCharacterId();
                    int newCharacterId = this.chechUniqueCharacterId(copyTag);
                    changedCharacterIds.put(oldCharacterId, newCharacterId);
                }
                targetSwf.updateCharacters();
                targetSwf.getCharacters();
                copyTag.setModified(true);
                copiedTags.add(tag);
                newTags.add(copyTag);
                Iterator<Object> iterator = changedCharacterIds.keySet().iterator();
                while (iterator.hasNext()) {
                    int oldCharacterId = (Integer)iterator.next();
                    int newCharacterId = (Integer)changedCharacterIds.get(oldCharacterId);
                    for (Tag newTag : newTags) {
                        newTag.replaceCharacter(oldCharacterId, newCharacterId);
                    }
                }
            }
            targetSwf.assignExportNamesToSymbols();
            targetSwf.assignClassesToSymbols();
            targetSwf.clearImageCache();
            targetSwf.updateCharacters();
            this.mainPanel.refreshTree(targetSwf);
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void openSwfInsideActionPerformed(ActionEvent evt) {
        List<TreeItem> sel = this.tagTree.getSelected();
        ArrayList<DefineBinaryDataTag> binaryDatas = new ArrayList<DefineBinaryDataTag>();
        for (TreeItem item : sel) {
            DefineBinaryDataTag binaryData = (DefineBinaryDataTag)item;
            if (!binaryData.isSwfData()) continue;
            binaryDatas.add((DefineBinaryDataTag)item);
        }
        this.mainPanel.loadFromBinaryTag(binaryDatas);
    }

    private void replaceWithTagActionPerformed(ActionEvent evt) {
        TreeItem itemr = this.tagTree.getCurrentTreeItem();
        if (itemr == null) {
            return;
        }
        SWF swf = itemr.getSwf();
        CharacterTag characterTag = (CharacterTag)itemr;
        int characterId = characterTag.getCharacterId();
        ReplaceCharacterDialog replaceCharacterDialog = new ReplaceCharacterDialog(Main.getDefaultDialogsOwner());
        if (replaceCharacterDialog.showDialog(swf, characterId) == 0) {
            int newCharacterId = replaceCharacterDialog.getCharacterId();
            swf.replaceCharacterTags(characterTag, newCharacterId);
            this.mainPanel.refreshTree(swf);
        }
    }

    private void rawEditActionPerformed(ActionEvent evt) {
        TreeItem itemr = this.tagTree.getCurrentTreeItem();
        if (itemr == null) {
            return;
        }
        this.mainPanel.showGenericTag((Tag)itemr);
    }

    private void jumpToCharacterActionPerformed(ActionEvent evt) {
        TreeItem itemj = this.tagTree.getCurrentTreeItem();
        if (itemj == null || !(itemj instanceof CharacterIdTag)) {
            return;
        }
        CharacterIdTag characterIdTag = (CharacterIdTag)itemj;
        this.mainPanel.setTagTreeSelectedNode((TreeItem)itemj.getSwf().getCharacter(characterIdTag.getCharacterId()));
    }

    private void expandRecursiveActionPerformed(ActionEvent evt) {
        TreePath path = this.tagTree.getSelectionPath();
        if (path == null) {
            return;
        }
        View.expandTreeNodes(this.tagTree, path, true);
    }

    private void textSearchActionPerformed(ActionEvent evt) {
        Main.getMainFrame().getPanel().searchInActionScriptOrText(null, Main.getMainFrame().getPanel().getCurrentSwf(), true);
    }

    private void addAs3ClassActionPerformed(ActionEvent evt) {
        List<TreeItem> sel = this.tagTree.getSelected();
        if (!sel.isEmpty()) {
            String[] stringArray;
            SWF swf = null;
            String preselected = "";
            if (sel.get(0) instanceof ClassesListTreeModel) {
                ClassesListTreeModel cl = (ClassesListTreeModel)sel.get(0);
                swf = cl.getSwf();
            }
            if (sel.get(0) instanceof AS3Package) {
                AS3Package pkg = (AS3Package)sel.get(0);
                swf = pkg.getSwf();
                TreePath tp = this.tagTree.getSelectionPaths()[0];
                Object[] path = tp.getPath();
                for (int p = path.length - 1; p >= 0 && !(path[p] instanceof ClassesListTreeModel); --p) {
                    preselected = ((AS3Package)path[p]).packageName + "." + preselected;
                }
            }
            TreePath scriptsPath = this.tagTree.getSelectionPaths()[0];
            while (!(scriptsPath.getLastPathComponent() instanceof ClassesListTreeModel)) {
                scriptsPath = scriptsPath.getParentPath();
            }
            AddClassDialog acd = new AddClassDialog(Main.getDefaultDialogsOwner());
            String className = acd.showDialog(preselected);
            if (className == null) {
                return;
            }
            if (className.contains(".")) {
                stringArray = className.split("\\.");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = className;
            }
            String[] parts = stringArray;
            DoABC2Tag doAbc = new DoABC2Tag(swf);
            doAbc.setTimelined((Timelined)swf);
            doAbc.name = className;
            ArrayList<ABC> abcs = new ArrayList<ABC>();
            for (ABCContainerTag ct : swf.getAbcList()) {
                abcs.add(ct.getABC());
            }
            ReadOnlyTagList tags = swf.getTags();
            int insertPos = -1;
            for (int i = 0; i < tags.size(); ++i) {
                if (!(tags.get(i) instanceof ShowFrameTag)) continue;
                insertPos = i;
                break;
            }
            if (insertPos == -1) {
                insertPos = tags.size();
            }
            swf.addTag(insertPos, (Tag)doAbc);
            String pkg = className.contains(".") ? className.substring(0, className.lastIndexOf(".")) : "";
            String classSimpleName = className.contains(".") ? className.substring(className.lastIndexOf(".") + 1) : className;
            String fileName = className.replace(".", "/");
            String[] pkgParts = new String[]{};
            if (!pkg.isEmpty()) {
                pkgParts = pkg.contains(".") ? pkg.split("\\.") : new String[]{pkg};
            }
            try {
                ActionScript3Parser parser = new ActionScript3Parser(doAbc.getABC(), abcs);
                DottedChain dc = new DottedChain(pkgParts, "");
                String script = "package " + dc.toPrintableString(true) + " {public class " + IdentifiersDeobfuscation.printIdentifier((boolean)true, (String)classSimpleName, (String[])new String[0]) + " { }}";
                parser.addScript(script, fileName, 0, 0);
            }
            catch (AVM2ParseException | CompilationException | IOException | InterruptedException ex) {
                Logger.getLogger(TagTreeContextMenu.class.getName()).log(Level.SEVERE, "Error during script compilation", ex);
            }
            doAbc.setModified(true);
            swf.clearAllCache();
            swf.setModified(true);
            this.mainPanel.refreshTree(swf);
            TreeItem item = this.mainPanel.tagTree.getModel().getScriptsNode(swf);
            TreePath classPath = scriptsPath;
            block6: for (int i = 0; i < parts.length; ++i) {
                for (TreeItem treeItem : this.tagTree.getModel().getAllChildren(item)) {
                    AS3ClassTreeItem cti;
                    if (!(treeItem instanceof AS3ClassTreeItem) || !parts[i].equals((cti = (AS3ClassTreeItem)treeItem).getNameWithNamespaceSuffix())) continue;
                    classPath = classPath.pathByAddingChild(treeItem);
                    item = treeItem;
                    continue block6;
                }
            }
            this.mainPanel.tagTree.setSelectionPath(classPath);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addAs12ScriptActionPerformed(ActionEvent evt) {
        block55: {
            List<TreeItem> sel = this.tagTree.getSelected();
            if (!sel.isEmpty() && sel.get(0) instanceof FolderItem) {
                FolderItem folder = (FolderItem)sel.get(0);
                SWF swf = folder.getSwf();
                AddScriptDialog addScriptDialog = new AddScriptDialog(Main.getDefaultDialogsOwner(), swf);
                if (addScriptDialog.showDialog() == 0) {
                    if (addScriptDialog.getScriptType() == 0 || addScriptDialog.getScriptType() == 1) {
                        SWF tim = swf;
                        if (addScriptDialog.getScriptType() == 1) {
                            tim = addScriptDialog.getSprite();
                        }
                        int targetFrame = addScriptDialog.getFrame();
                        DoActionTag doAction = new DoActionTag(swf);
                        doAction.setTimelined((Timelined)tim);
                        ReadOnlyTagList tagList = tim.getTags();
                        int frame = 1;
                        boolean frameFound = false;
                        for (int i = 0; i < tagList.size(); ++i) {
                            Tag t = tagList.get(i);
                            if (!(t instanceof ShowFrameTag)) continue;
                            if (frame == targetFrame) {
                                tim.addTag(i, (Tag)doAction);
                                frameFound = true;
                                break;
                            }
                            ++frame;
                        }
                        if (!frameFound) {
                            while (frame < targetFrame) {
                                tim.addTag((Tag)new ShowFrameTag(swf));
                                ++frame;
                            }
                            tim.addTag((Tag)doAction);
                            tim.addTag((Tag)new ShowFrameTag(swf));
                            if (tim instanceof DefineSpriteTag) {
                                ((DefineSpriteTag)tim).frameCount = targetFrame;
                            } else {
                                swf.frameCount = targetFrame;
                            }
                        }
                        TreePath selection = this.mainPanel.tagTree.getSelectionPath();
                        TreePath swfPath = selection.getParentPath();
                        tim.resetTimeline();
                        this.mainPanel.refreshTree(swf);
                        FolderItem scriptsNode = (FolderItem)this.mainPanel.tagTree.getModel().getScriptsNode(swf);
                        TreePath scriptsPath = swfPath.pathByAddingChild(scriptsNode);
                        if (addScriptDialog.getScriptType() == 0) {
                            for (TreeItem subItem : scriptsNode.subItems) {
                                if (!(subItem instanceof FrameScript) || ((FrameScript)subItem).getFrame().frame + 1 != targetFrame) continue;
                                TreePath framePath = scriptsPath.pathByAddingChild(subItem);
                                TreeItem doActionTag = this.mainPanel.tagTree.getModel().getChild(subItem, 0);
                                TreePath doActionPath = framePath.pathByAddingChild(doActionTag);
                                this.mainPanel.tagTree.setSelectionPath(doActionPath);
                                break;
                            }
                        } else {
                            for (TreeItem subItem : scriptsNode.subItems) {
                                if (!(subItem instanceof TagScript) || ((TagScript)subItem).getTag() != tim) continue;
                                TreePath spritePath = scriptsPath.pathByAddingChild(subItem);
                                TagScript ts = (TagScript)subItem;
                                for (TreeItem f : ts.getFrames()) {
                                    if (!(f instanceof FrameScript)) continue;
                                    FrameScript fs = (FrameScript)f;
                                    if (fs.getFrame().frame + 1 != targetFrame) continue;
                                    TreePath framePath = spritePath.pathByAddingChild(fs);
                                    TreeItem doActionTag = this.mainPanel.tagTree.getModel().getChild(fs, 0);
                                    TreePath doActionPath = framePath.pathByAddingChild(doActionTag);
                                    this.mainPanel.tagTree.setSelectionPath(doActionPath);
                                    break block55;
                                }
                                break;
                            }
                        }
                    } else if (addScriptDialog.getScriptType() == 3) {
                        DefineButton2Tag button = addScriptDialog.getButton();
                        BUTTONCONDACTION bca = new BUTTONCONDACTION(swf, (Tag)button);
                        bca.condOverUpToOverDown = true;
                        if (!button.actions.isEmpty()) {
                            ((BUTTONCONDACTION)button.actions.get((int)(button.actions.size() - 1))).isLast = false;
                        }
                        bca.isLast = true;
                        button.actions.add(bca);
                        button.setModified(true);
                        button.resetTimeline();
                        this.mainPanel.refreshTree(swf);
                        FolderItem scriptsNode = (FolderItem)this.mainPanel.tagTree.getModel().getScriptsNode(swf);
                        TreePath selection = this.mainPanel.tagTree.getSelectionPath();
                        TreePath swfPath = selection.getParentPath();
                        TreePath scriptsPath = swfPath.pathByAddingChild(scriptsNode);
                        for (TreeItem subItem : scriptsNode.subItems) {
                            if (!(subItem instanceof TagScript) || ((TagScript)subItem).getTag() != button) continue;
                            TreePath buttonPath = scriptsPath.pathByAddingChild(subItem);
                            TreePath buttonCondPath = buttonPath.pathByAddingChild(bca);
                            this.mainPanel.tagTree.setSelectionPath(buttonCondPath);
                            break;
                        }
                    } else if (addScriptDialog.getScriptType() == 4) {
                        DefineSpriteTag sprite = addScriptDialog.getSprite();
                        int frame = addScriptDialog.getFrame();
                        PlaceObjectTypeTag placeType = addScriptDialog.getPlaceObject();
                        CLIPACTIONS clipActions = null;
                        SWF tim = swf;
                        if (sprite != null) {
                            tim = sprite;
                        }
                        if (placeType instanceof PlaceObjectTag) {
                            ReadOnlyTagList tags = tim.getTags();
                            PlaceObjectTag place = (PlaceObjectTag)placeType;
                            clipActions = new CLIPACTIONS();
                            for (int i = 0; i < tags.size(); ++i) {
                                if (tags.get(i) != placeType) continue;
                                PlaceObject2Tag place2 = new PlaceObject2Tag(swf, false, place.depth, place.characterId, place.matrix, new CXFORMWITHALPHA(place.colorTransform), -1, null, -1, clipActions);
                                place2.setTimelined((Timelined)tim);
                                tim.replaceTag(i, (Tag)place2);
                                placeType = place2;
                                break;
                            }
                        }
                        if (placeType instanceof PlaceObject2Tag) {
                            PlaceObject2Tag place2 = (PlaceObject2Tag)placeType;
                            if (!place2.placeFlagHasClipActions) {
                                clipActions = place2.clipActions = new CLIPACTIONS();
                                place2.placeFlagHasClipActions = true;
                            }
                        }
                        if (placeType instanceof PlaceObject3Tag) {
                            PlaceObject3Tag place3 = (PlaceObject3Tag)placeType;
                            if (!place3.placeFlagHasClipActions) {
                                clipActions = place3.clipActions = new CLIPACTIONS();
                                place3.placeFlagHasClipActions = true;
                            }
                        }
                        if (placeType instanceof PlaceObject4Tag) {
                            PlaceObject4Tag place4 = (PlaceObject4Tag)placeType;
                            if (!place4.placeFlagHasClipActions) {
                                clipActions = place4.clipActions = new CLIPACTIONS();
                                place4.placeFlagHasClipActions = true;
                            }
                        }
                        CLIPACTIONRECORD clipActionRecord = new CLIPACTIONRECORD(swf, (Tag)placeType);
                        clipActionRecord.setParentClipActions(clipActions);
                        clipActionRecord.eventFlags.clipEventPress = true;
                        clipActions.clipActionRecords.add(clipActionRecord);
                        clipActions.calculateAllEventFlags();
                        placeType.setModified(true);
                        TreePath selection = this.mainPanel.tagTree.getSelectionPath();
                        TreePath swfPath = selection.getParentPath();
                        tim.resetTimeline();
                        this.mainPanel.refreshTree(swf);
                        FolderItem scriptsNode = (FolderItem)this.mainPanel.tagTree.getModel().getScriptsNode(swf);
                        TreePath scriptsPath = swfPath.pathByAddingChild(scriptsNode);
                        block9: for (TreeItem subItem : scriptsNode.subItems) {
                            Object f22;
                            if (sprite != null) {
                                if (!(subItem instanceof TagScript) || ((TagScript)subItem).getTag() != sprite) continue;
                                TreePath spritePaths = scriptsPath.pathByAddingChild(subItem);
                                List frames = ((TagScript)subItem).getFrames();
                                for (Object f22 : frames) {
                                    if (!(f22 instanceof FrameScript)) continue;
                                    FrameScript fs = (FrameScript)f22;
                                    if (fs.getFrame().frame + 1 != frame) continue;
                                    TreePath framePath = spritePaths.pathByAddingChild(f22);
                                    List<? extends TreeItem> subs = this.mainPanel.tagTree.getModel().getAllChildren(fs);
                                    for (TreeItem treeItem : subs) {
                                        if (!(treeItem instanceof TagScript) || ((TagScript)treeItem).getTag() != placeType) continue;
                                        TreePath placePath = framePath.pathByAddingChild(treeItem);
                                        TreePath clipActionRecordPath = placePath.pathByAddingChild(clipActionRecord);
                                        this.mainPanel.tagTree.setSelectionPath(clipActionRecordPath);
                                        continue block9;
                                    }
                                }
                                continue;
                            }
                            if (!(subItem instanceof FrameScript)) continue;
                            FrameScript fs = (FrameScript)subItem;
                            if (fs.getFrame().frame + 1 != frame) continue;
                            TreePath framePath = scriptsPath.pathByAddingChild(fs);
                            List<? extends TreeItem> subs = this.mainPanel.tagTree.getModel().getAllChildren(fs);
                            f22 = subs.iterator();
                            while (f22.hasNext()) {
                                TreeItem t = (TreeItem)f22.next();
                                if (!(t instanceof TagScript) || ((TagScript)t).getTag() != placeType) continue;
                                TreePath placePath = framePath.pathByAddingChild(t);
                                TreePath clipActionRecordPath = placePath.pathByAddingChild(clipActionRecord);
                                this.mainPanel.tagTree.setSelectionPath(clipActionRecordPath);
                                continue block9;
                            }
                        }
                    } else if (addScriptDialog.getScriptType() == 5) {
                        int i;
                        String className = addScriptDialog.getClassName();
                        ReadOnlyTagList tags = swf.getTags();
                        ArrayList exportedIds = new ArrayList();
                        for (int i2 = 0; i2 < tags.size(); ++i2) {
                            if (!(tags.get(i2) instanceof ExportAssetsTag)) continue;
                            ExportAssetsTag ea = (ExportAssetsTag)tags.get(i2);
                            exportedIds.addAll(ea.tags);
                        }
                        int insertPos = -1;
                        for (i = 0; i < tags.size(); ++i) {
                            if (!(tags.get(i) instanceof DoInitActionTag)) continue;
                            DoInitActionTag doinit = (DoInitActionTag)tags.get(i);
                            if (exportedIds.contains(doinit.spriteId)) continue;
                            insertPos = i;
                            break;
                        }
                        if (insertPos == -1) {
                            for (i = 0; i < tags.size(); ++i) {
                                if (!(tags.get(i) instanceof ShowFrameTag)) continue;
                                insertPos = i;
                                break;
                            }
                        }
                        if (insertPos > -1) {
                            String[] stringArray;
                            String[] stringArray2;
                            int characterId = swf.getNextCharacterId();
                            DefineSpriteTag sprite = new DefineSpriteTag(swf);
                            sprite.spriteId = characterId;
                            sprite.hasEndTag = true;
                            sprite.setTimelined((Timelined)swf);
                            String exportName = "__Packages." + className;
                            ExportAssetsTag exportAssets = new ExportAssetsTag(swf);
                            exportAssets.names = new ArrayList();
                            exportAssets.names.add(exportName);
                            exportAssets.tags = new ArrayList();
                            exportAssets.tags.add(characterId);
                            exportAssets.setTimelined((Timelined)swf);
                            DoInitActionTag doInit = new DoInitActionTag(swf);
                            doInit.spriteId = characterId;
                            doInit.setTimelined((Timelined)swf);
                            ActionScript2Parser parser = new ActionScript2Parser(swf, (ASMSource)doInit);
                            if (className.contains(".")) {
                                stringArray2 = className.split("\\.");
                            } else {
                                String[] stringArray3 = new String[1];
                                stringArray2 = stringArray3;
                                stringArray3[0] = className;
                            }
                            String[] parts = stringArray2;
                            DottedChain dc = new DottedChain(parts, "");
                            try {
                                List actions = parser.actionsFromString("class " + dc.toPrintableString(false) + "{}");
                                doInit.setActions(actions);
                            }
                            catch (ActionParseException | CompilationException | IOException | InterruptedException actions) {
                                // empty catch block
                            }
                            sprite.setExportName(exportName);
                            swf.addTag(insertPos, (Tag)sprite);
                            swf.addTag(insertPos + 1, (Tag)exportAssets);
                            swf.addTag(insertPos + 2, (Tag)doInit);
                            swf.clearAllCache();
                            swf.setModified(true);
                            this.mainPanel.refreshTree(swf);
                            TreePath selection = this.mainPanel.tagTree.getSelectionPath();
                            TreePath swfPath = selection.getParentPath();
                            FolderItem scriptsNode = (FolderItem)this.mainPanel.tagTree.getModel().getScriptsNode(swf);
                            TreePath scriptsPath = swfPath.pathByAddingChild(scriptsNode);
                            if (className.contains(".")) {
                                stringArray = className.split("\\.");
                            } else {
                                String[] stringArray4 = new String[1];
                                stringArray = stringArray4;
                                stringArray4[0] = className;
                            }
                            String[] classParts = stringArray;
                            for (TreeItem subItem : scriptsNode.subItems) {
                                void var26_98;
                                AS2Package pkg;
                                if (!(subItem instanceof AS2Package) || !(pkg = (AS2Package)subItem).getName().equals("__Packages")) continue;
                                TreePath treePath = scriptsPath.pathByAddingChild(pkg);
                                block17: for (int i3 = 0; i3 < classParts.length - 1; ++i3) {
                                    List subs = pkg.getAllChildren();
                                    for (TreeItem s : subs) {
                                        if (!(s instanceof AS2Package) || !((AS2Package)s).getName().equals(classParts[i3])) continue;
                                        pkg = (AS2Package)s;
                                        TreePath treePath2 = var26_98.pathByAddingChild(pkg);
                                        continue block17;
                                    }
                                }
                                TreePath treePath3 = var26_98.pathByAddingChild(doInit);
                                this.mainPanel.tagTree.setSelectionPath(treePath3);
                                break;
                            }
                        }
                    } else if (addScriptDialog.getScriptType() == 2) {
                        DefineSpriteTag sprite = addScriptDialog.getSprite();
                        DoInitActionTag doinit = new DoInitActionTag(swf);
                        doinit.setTimelined((Timelined)swf);
                        doinit.spriteId = sprite.spriteId;
                        ReadOnlyTagList tags = swf.getTags();
                        int addPos = -1;
                        for (int i = 0; i < tags.size(); ++i) {
                            int placeCharacterId;
                            Tag t = tags.get(i);
                            if (!(t instanceof PlaceObjectTypeTag) || !this.usesCharacter(swf, placeCharacterId = ((PlaceObjectTypeTag)t).getCharacterId(), sprite.spriteId)) continue;
                            addPos = i;
                            break;
                        }
                        if (addPos == -1) {
                            addPos = tags.size();
                        }
                        swf.addTag(addPos, (Tag)doinit);
                        swf.clearAllCache();
                        swf.setModified(true);
                        this.mainPanel.refreshTree(swf);
                        TreePath selection = this.mainPanel.tagTree.getSelectionPath();
                        TreePath swfPath = selection.getParentPath();
                        FolderItem scriptsNode = (FolderItem)this.mainPanel.tagTree.getModel().getScriptsNode(swf);
                        TreePath scriptsPath = swfPath.pathByAddingChild(scriptsNode);
                        TreePath doinitPath = scriptsPath.pathByAddingChild(doinit);
                        this.mainPanel.tagTree.setSelectionPath(doinitPath);
                    }
                }
            }
        }
    }

    private boolean usesCharacter(SWF swf, int characterId, int searchedCharacterId) {
        if (characterId == searchedCharacterId) {
            return true;
        }
        CharacterTag character = swf.getCharacter(characterId);
        if (character instanceof DefineSpriteTag) {
            DefineSpriteTag sprite = (DefineSpriteTag)character;
            for (Tag t : sprite.getTags()) {
                int placeCharacterId;
                if (!(t instanceof PlaceObjectTypeTag) || !this.usesCharacter(swf, placeCharacterId = ((PlaceObjectTypeTag)t).getCharacterId(), searchedCharacterId)) continue;
                return true;
            }
        }
        return false;
    }

    private void getAllAS3PackageScriptPacks(AS3Package pkg, List<ScriptPack> out) {
        out.addAll(pkg.getScriptPacks());
        for (AS3Package sub : pkg.getSubPackages()) {
            this.getAllAS3PackageScriptPacks(sub, out);
        }
    }

    private void populateScriptSubs(TreePath path, TreeItem item, List<TreePath> out) {
        List<? extends TreeItem> subs = this.tagTree.getModel().getAllChildren(item);
        for (TreeItem treeItem : subs) {
            TreePath tPath = path.pathByAddingChild(treeItem);
            if (treeItem instanceof TagScript && ((TagScript)treeItem).getTag() instanceof ASMSource) {
                out.add(tPath);
                continue;
            }
            if (treeItem instanceof ASMSource) {
                out.add(tPath);
                continue;
            }
            this.populateScriptSubs(tPath, treeItem, out);
        }
    }

    private void getAllAS2PackageScriptPacks(AS2Package pkg, List<ASMSource> out) {
        out.addAll(pkg.scripts.values());
        for (AS2Package sub : pkg.subPackages.values()) {
            this.getAllAS2PackageScriptPacks(sub, out);
        }
    }

    private void removeItemActionPerformed(ActionEvent evt, final boolean removeDependencies) {
        ArrayList<TreePath> tps;
        if (this.mainPanel.folderPreviewPanel.selectedItems.isEmpty()) {
            TreePath[] tpsArr = this.tagTree.getSelectionModel().getSelectionPaths();
            if (tpsArr == null) {
                return;
            }
            tps = new ArrayList<TreePath>(Arrays.asList(tpsArr));
        } else {
            ArrayList<TreeItem> sel = new ArrayList<TreeItem>();
            for (TreeItem treeItem : this.mainPanel.folderPreviewPanel.selectedItems.values()) {
                sel.add(treeItem);
                this.tagTree.getAllSubs(treeItem, sel);
            }
            tps = new ArrayList();
            for (TreeItem treeItem : sel) {
                tps.add(new TreePath(treeItem));
            }
            if (tps.isEmpty()) {
                return;
            }
        }
        final ArrayList<Object> tagsToRemove = new ArrayList<Object>();
        final ArrayList<TreeItem> itemsToRemove = new ArrayList<TreeItem>();
        final ArrayList<Object> itemsToRemoveParents = new ArrayList<Object>();
        final ArrayList<Object> itemsToRemoveSprites = new ArrayList<Object>();
        TreeItem itemLast = null;
        int itemCountFix = 0;
        for (int i = 0; i < tps.size(); ++i) {
            TreeItem item = (TreeItem)((TreePath)tps.get(i)).getLastPathComponent();
            if (!(item instanceof FrameScript) && !(item instanceof TagScript)) continue;
            ArrayList<TreePath> subs = new ArrayList<TreePath>();
            this.populateScriptSubs((TreePath)tps.get(i), item, subs);
            int cnt = 0;
            for (TreePath tp : subs) {
                if (tps.contains(tp)) continue;
                if (cnt > 0) {
                    --itemCountFix;
                }
                ++cnt;
                tps.add(tp);
                itemLast = item;
            }
        }
        for (TreePath path : tps) {
            TreeItem item = (TreeItem)path.getLastPathComponent();
            if (item instanceof AS3Package) {
                itemsToRemove.add(item);
                itemsToRemoveParents.add(new Object());
                itemsToRemoveSprites.add(new Object());
                continue;
            }
            if (item instanceof AS2Package) {
                itemsToRemove.add(item);
                itemsToRemoveParents.add(new Object());
                itemsToRemoveSprites.add(new Object());
                continue;
            }
            if (item instanceof Tag) {
                tagsToRemove.add((Tag)item);
                continue;
            }
            if (item instanceof TagScript && ((TagScript)item).getTag() instanceof ASMSource) {
                tagsToRemove.add(((TagScript)item).getTag());
                continue;
            }
            if (item instanceof Frame) {
                Frame frameNode = (Frame)item;
                Frame frame = frameNode.timeline.getFrame(frameNode.frame);
                if (frame.showFrameTag != null) {
                    tagsToRemove.add(frame.showFrameTag);
                    continue;
                }
                tagsToRemove.addAll(frame.innerTags);
                continue;
            }
            if (item instanceof BUTTONCONDACTION) {
                itemsToRemove.add(item);
                itemsToRemoveParents.add(((TagScript)path.getParentPath().getLastPathComponent()).getTag());
                itemsToRemoveSprites.add(new Object());
                continue;
            }
            if (item instanceof CLIPACTIONRECORD) {
                itemsToRemove.add(item);
                Object sprite = path.getParentPath().getParentPath().getParentPath().getLastPathComponent();
                if (sprite instanceof TagScript) {
                    sprite = ((TagScript)sprite).getTag();
                }
                itemsToRemoveParents.add(((TagScript)path.getParentPath().getLastPathComponent()).getTag());
                itemsToRemoveSprites.add(sprite);
                continue;
            }
            if (!(item instanceof ScriptPack) || itemsToRemove.contains(item)) continue;
            itemsToRemove.add(item);
            itemsToRemoveParents.add(new Object());
            itemsToRemoveSprites.add(new Object());
        }
        if (tagsToRemove.size() > 0 || itemsToRemove.size() > 0) {
            String confirmationMessage;
            if (tagsToRemove.size() + itemsToRemove.size() == 1) {
                Object toRemove = tagsToRemove.size() == 1 ? tagsToRemove.get(0) : itemsToRemove.get(0);
                if (itemLast != null) {
                    toRemove = itemLast;
                }
                confirmationMessage = this.mainPanel.translate("message.confirm.remove" + (removeDependencies ? "" : ".nodep")).replace("%item%", toRemove.toString());
            } else {
                confirmationMessage = this.mainPanel.translate("message.confirm.removemultiple" + (removeDependencies ? "" : ".nodep")).replace("%count%", Integer.toString(tagsToRemove.size() + itemsToRemove.size() + itemCountFix));
            }
            if (ViewMessages.showConfirmDialog(this.mainPanel, confirmationMessage, this.mainPanel.translate("message.confirm"), 0, 3) == 0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        HashMap tagsToRemoveBySwf = new HashMap();
                        HashSet<SWF> swfsToClearCache = new HashSet<SWF>();
                        for (int i = 0; i < itemsToRemove.size(); ++i) {
                            Object item = itemsToRemove.get(i);
                            if (item instanceof AS3Package) {
                                ArrayList subScriptPacks = new ArrayList();
                                TagTreeContextMenu.this.getAllAS3PackageScriptPacks((AS3Package)item, subScriptPacks);
                                for (ScriptPack pack : subScriptPacks) {
                                    if (itemsToRemove.contains(pack)) continue;
                                    itemsToRemove.add(pack);
                                    itemsToRemoveParents.add(new Object());
                                    itemsToRemoveSprites.add(new Object());
                                }
                            }
                            if (!(item instanceof AS2Package)) continue;
                            ArrayList subAsmSources = new ArrayList();
                            TagTreeContextMenu.this.getAllAS2PackageScriptPacks((AS2Package)item, subAsmSources);
                            for (ASMSource asmSource : subAsmSources) {
                                if (itemsToRemove.contains(asmSource)) continue;
                                tagsToRemove.add((Tag)asmSource);
                            }
                        }
                        ArrayList<ABC> abcsToPack = new ArrayList<ABC>();
                        block3: for (int i = 0; i < itemsToRemove.size(); ++i) {
                            Object item = itemsToRemove.get(i);
                            Object parent = itemsToRemoveParents.get(i);
                            if (item instanceof BUTTONCONDACTION) {
                                DefineButton2Tag button = (DefineButton2Tag)parent;
                                BUTTONCONDACTION buttonCondAction = (BUTTONCONDACTION)item;
                                button.actions.remove(buttonCondAction);
                                if (buttonCondAction.isLast && !button.actions.isEmpty()) {
                                    ((BUTTONCONDACTION)button.actions.get((int)(button.actions.size() - 1))).isLast = true;
                                }
                                button.setModified(true);
                            }
                            if (item instanceof CLIPACTIONRECORD) {
                                PlaceObjectTypeTag place = (PlaceObjectTypeTag)parent;
                                Object tim = itemsToRemoveSprites.get(i) instanceof DefineSpriteTag ? (DefineSpriteTag)itemsToRemoveSprites.get(i) : place.getSwf();
                                CLIPACTIONRECORD clipActionRecord = (CLIPACTIONRECORD)item;
                                CLIPACTIONS clipActions = place.getClipActions();
                                clipActions.clipActionRecords.remove(clipActionRecord);
                                if (clipActions.clipActionRecords.isEmpty()) {
                                    place.setPlaceFlagHasClipActions(false);
                                    place.setClipActions(null);
                                }
                                clipActions.calculateAllEventFlags();
                                place.setModified(true);
                                tim.resetTimeline();
                            }
                            if (!(item instanceof ScriptPack)) continue;
                            ScriptPack sp = (ScriptPack)item;
                            sp.delete(sp.abc, true);
                            abcsToPack.add(sp.abc);
                            swfsToClearCache.add(sp.getSwf());
                            for (ABCContainerTag ct : sp.getSwf().getAbcList()) {
                                if (ct.getABC() != sp.abc) continue;
                                ((Tag)ct).setModified(true);
                                continue block3;
                            }
                        }
                        for (ABC abc : abcsToPack) {
                            abc.pack();
                            ABCContainerTag container = null;
                            for (ABCContainerTag ct : abc.getSwf().getAbcList()) {
                                if (ct.getABC() != abc) continue;
                                container = ct;
                                break;
                            }
                            if (abc.script_info.isEmpty()) {
                                abc.getSwf().removeTag((Tag)container);
                                abc.getSwf().setModified(true);
                                continue;
                            }
                            ((Tag)container).setModified(true);
                        }
                        for (Tag tag : tagsToRemove) {
                            SWF swf = tag.getSwf();
                            if (!tagsToRemoveBySwf.containsKey(swf)) {
                                tagsToRemoveBySwf.put(swf, new ArrayList());
                            }
                            ((List)tagsToRemoveBySwf.get(swf)).add(tag);
                        }
                        for (SWF swf : tagsToRemoveBySwf.keySet()) {
                            swf.removeTags((Collection)tagsToRemoveBySwf.get(swf), removeDependencies);
                        }
                        for (SWF swf : swfsToClearCache) {
                            swf.clearAllCache();
                        }
                    }
                };
                if (this.mainPanel.folderPreviewPanel.selectedItems.isEmpty()) {
                    this.mainPanel.treeOperation(r);
                } else {
                    r.run();
                    this.mainPanel.refreshTree();
                }
            }
        }
    }

    private void undoTagActionPerformed(ActionEvent evt) {
        List<TreeItem> sel = this.tagTree.getSelected();
        for (TreeItem item : sel) {
            if (!(item instanceof Tag)) continue;
            try {
                Tag tag = (Tag)item;
                tag.undo();
                tag.getSwf().clearAllCache();
                this.tagTree.getModel().updateNode(item);
            }
            catch (IOException | InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        this.mainPanel.repaintTree();
    }

    private void closeSwfActionPerformed(ActionEvent evt) {
        List<TreeItem> sel = this.tagTree.getSelected();
        for (TreeItem item : sel) {
            if (item instanceof SWF) {
                SWF swf = (SWF)item;
                if (swf.binaryData != null) {
                    swf.binaryData.innerSwf = null;
                    swf.clearTagSwfs();
                    this.mainPanel.refreshTree();
                    continue;
                }
                Main.closeFile(swf.swfList);
                continue;
            }
            if (!(item instanceof SWFList)) continue;
            Main.closeFile((SWFList)item);
        }
    }
}

