/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.pipes;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.OutputStream;

public class PipeOutputStream
extends OutputStream {
    protected WinNT.HANDLE pipe;
    private boolean closed = false;

    public PipeOutputStream(String pipeName, boolean newPipe) throws IOException {
        if (!Platform.isWindows()) {
            throw new IOException("Cannot create Pipe on nonWindows OS");
        }
        String fullPipePath = "\\\\.\\pipe\\" + pipeName;
        if (newPipe) {
            this.pipe = Kernel32.INSTANCE.CreateNamedPipe(fullPipePath, 2, 0, 1, 4096, 4096, 0, null);
            if (this.pipe == null || !Kernel32.INSTANCE.ConnectNamedPipe(this.pipe, null)) {
                throw new IOException("Cannot connect to the pipe. Error " + Kernel32.INSTANCE.GetLastError());
            }
        } else {
            this.pipe = Kernel32.INSTANCE.CreateFile(fullPipePath, 0x40000000, 2, null, 3, 128, null);
            if (this.pipe == null) {
                throw new IOException("Cannot connect to the pipe. Error " + Kernel32.INSTANCE.GetLastError());
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    PipeOutputStream.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            Kernel32.INSTANCE.CloseHandle(this.pipe);
            this.closed = true;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)b};
        IntByReference ibr = new IntByReference();
        boolean result = Kernel32.INSTANCE.WriteFile(this.pipe, data, data.length, ibr, null);
        if (!result) {
            throw new IOException("Cannot write to the pipe. Error " + Kernel32.INSTANCE.GetLastError());
        }
        if (ibr.getValue() != data.length) {
            throw new IOException("Cannot write to the pipe. Error " + Kernel32.INSTANCE.GetLastError());
        }
    }
}

