/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.graph;

import com.jpexs.decompiler.flash.exporters.script.PcodeGraphVizExporter;
import com.jpexs.decompiler.flash.gui.graph.AbstractGraphPanel;
import com.jpexs.decompiler.flash.gui.graph.GraphVizDotCommands;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.StringBuilderTextWriter;
import com.jpexs.decompiler.graph.Graph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class GraphVizGraphPanel
extends AbstractGraphPanel {
    private static final Logger logger = Logger.getLogger(GraphVizGraphPanel.class.getName());
    private BufferedImage image;
    private JPanel imagePanel;

    public GraphVizGraphPanel(Graph graph) throws InterruptedException {
        super(graph);
        PcodeGraphVizExporter ex = new PcodeGraphVizExporter();
        StringBuilder sb = new StringBuilder();
        StringBuilderTextWriter sbWriter = new StringBuilderTextWriter(null, sb);
        ex.export(graph, (GraphTextWriter)sbWriter);
        String original = sb.toString();
        try {
            this.image = new GraphVizDotCommands().dotToImage(original);
        }
        catch (IOException ex1) {
            logger.log(Level.SEVERE, "Exporting image failed", ex1);
            this.image = new BufferedImage(1, 1, 2);
        }
        this.setLayout(new BorderLayout());
        this.imagePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                g.drawImage(GraphVizGraphPanel.this.image, 0, 0, null);
            }
        };
        Dimension dim = new Dimension(this.image.getWidth(), this.image.getHeight());
        this.imagePanel.setPreferredSize(dim);
        this.imagePanel.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.imagePanel, new GridBagConstraints());
        this.setBackground(Color.white);
    }

    public static boolean isAvailable() {
        return GraphVizDotCommands.graphVizAvailable();
    }
}

