/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.editor;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.editor.LinkHandler;
import com.jpexs.decompiler.flash.gui.editor.MyMarkers;
import com.jpexs.decompiler.flash.gui.editor.UndoFixedEditorPane;
import com.jpexs.helpers.Reference;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;

public class LineMarkedEditorPane
extends UndoFixedEditorPane
implements LinkHandler {
    private static final int truncateLimit = 0x200000;
    public static final Color BG_SELECTED_LINE = new Color(233, 239, 248);
    public static final Color BG_ERROR_LINE = new Color(255, 200, 200);
    private int lastLine = -1;
    private boolean error = false;
    private Token lastUnderlined = null;
    private static final Highlighter.HighlightPainter underLinePainter = new UnderLinePainter(new Color(0, 0, 255));
    private LinkHandler linkHandler = this;
    private Map<Integer, SortedSet<LineMarker>> lineMarkers = Collections.synchronizedMap(new HashMap());

    public void setLineMarkers(Map<Integer, SortedSet<LineMarker>> colorMarkers) {
        this.lineMarkers = colorMarkers;
    }

    public void clearLineColors() {
        this.lineMarkers.clear();
        this.repaint();
    }

    public boolean hasColorMarker(int line, LineMarker lm) {
        if (this.lineMarkers.containsKey(line -= this.firstLineOffset())) {
            return this.lineMarkers.get(line).contains(lm);
        }
        return false;
    }

    public void removeColorMarker(int line, LineMarker lm) {
        if (this.lineMarkers.containsKey(line -= this.firstLineOffset())) {
            this.lineMarkers.get(line).remove(lm);
        }
        this.getParent().repaint();
    }

    public void removeColorMarkerOnAllLines(LineMarker lm) {
        for (int line : this.lineMarkers.keySet()) {
            this.removeColorMarker(line += this.firstLineOffset(), lm);
        }
    }

    public int firstLineOffset() {
        return 0;
    }

    public void toggleColorMarker(int line, LineMarker lm) {
        if (!this.lineMarkers.containsKey(line - this.firstLineOffset())) {
            this.addColorMarker(line, lm);
        } else if (this.lineMarkers.get(line - this.firstLineOffset()).contains(lm)) {
            this.removeColorMarker(line, lm);
        } else {
            this.addColorMarker(line, lm);
        }
        this.getParent().repaint();
    }

    public void addColorMarker(int line, LineMarker lm) {
        if (!this.lineMarkers.containsKey(line -= this.firstLineOffset())) {
            this.lineMarkers.put(line, Collections.synchronizedSortedSet(new TreeSet()));
        }
        this.lineMarkers.get(line).add(lm);
        this.getParent().repaint();
    }

    public int getLine() {
        int caretPosition = this.getCaretPosition();
        Element root = this.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        return currentLine;
    }

    public void markError() {
        this.error = true;
    }

    public void gotoLine(int line) {
        int pos = ActionUtils.getDocumentPosition((JTextComponent)this, (int)line, (int)0);
        if (pos != -1) {
            this.setCaretPosition(pos);
        }
    }

    public void gotoLineCol(int line, int column) {
        int pos = ActionUtils.getDocumentPosition((JTextComponent)this, (int)line, (int)column);
        if (pos != -1) {
            this.setCaretPosition(pos);
        }
    }

    public Point getLineLocation(int line) {
        int pos = ActionUtils.getDocumentPosition((JTextComponent)this, (int)(line + 1), (int)0);
        if (pos < 0) {
            return null;
        }
        try {
            Rectangle r = this.modelToView(pos);
            return new Point(r.x, r.y);
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    private void getLineBounds(int line, Reference<Integer> lineStart, Reference<Integer> lineEnd) {
        Document d = this.getDocument();
        String text = "";
        try {
            text = d.getText(0, d.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int lineCnt = 0;
        int lineStartVal = 0;
        int lineEndVal = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            if (++lineCnt == line) {
                lineStartVal = i + 1;
            }
            if (lineCnt != line + 1) continue;
            lineEndVal = i;
        }
        if (lineCnt == 0) {
            lineEndVal = text.length() - 1;
            if (line > 0) {
                lineStartVal = text.length() - 1;
            }
        }
        lineEnd.setVal((Object)lineEndVal);
        lineStart.setVal((Object)lineStartVal);
    }

    public void selectLine(int line) {
        Reference lineStart = new Reference((Object)0);
        Reference lineEnd = new Reference((Object)0);
        this.getLineBounds(line, (Reference<Integer>)lineStart, (Reference<Integer>)lineEnd);
        this.select((Integer)lineStart.getVal(), (Integer)lineEnd.getVal());
        this.requestFocus();
    }

    public String getCurrentLineText() {
        return this.getLineText(this.getLine());
    }

    public String getLineText(int line) {
        Reference lineStart = new Reference((Object)0);
        Reference lineEnd = new Reference((Object)0);
        this.getLineBounds(line, (Reference<Integer>)lineStart, (Reference<Integer>)lineEnd);
        try {
            return this.getDocument().getText((Integer)lineStart.getVal(), (Integer)lineEnd.getVal() - (Integer)lineStart.getVal());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public LineMarkedEditorPane() {
        this.setOpaque(false);
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int caretPosition = LineMarkedEditorPane.this.getCaretPosition();
                Element root = LineMarkedEditorPane.this.getDocument().getDefaultRootElement();
                int currentLine = root.getElementIndex(caretPosition);
                if (currentLine != LineMarkedEditorPane.this.lastLine) {
                    LineMarkedEditorPane.this.lastLine = currentLine;
                    LineMarkedEditorPane.this.error = false;
                    LineMarkedEditorPane.this.repaint();
                }
            }
        });
        final LinkAdapter la = new LinkAdapter();
        this.addMouseMotionListener(la);
        this.addMouseListener(la);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                if (e.getID() == 401) {
                    la.keyPressed(e);
                }
                if (e.getID() == 402) {
                    la.keyReleased(e);
                }
                if (e.getID() == 400) {
                    la.keyTyped(e);
                }
                return false;
            }
        });
    }

    public Token tokenAtPos(Point lastPos) {
        Document d = this.getDocument();
        if (d instanceof SyntaxDocument) {
            Token tprev;
            SyntaxDocument sd = (SyntaxDocument)d;
            int pos = this.viewToModel(lastPos);
            try {
                Rectangle r = this.modelToView(pos);
                if (r != null && lastPos.x < r.x) {
                    --pos;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            Token t = sd.getTokenAt(pos);
            if (pos > 0 && pos < d.getLength() - 1 && t != null && t.length == 1 && (tprev = sd.getTokenAt(pos - 1)) == t) {
                t = sd.getTokenAt(pos + 1);
            }
            return t;
        }
        return null;
    }

    public void setLinkHandler(LinkHandler linkHandler) {
        if (linkHandler == null) {
            linkHandler = this;
        }
        this.linkHandler = linkHandler;
    }

    public LinkHandler getLinkHandler() {
        return this.linkHandler;
    }

    @Override
    public Highlighter.HighlightPainter linkPainter() {
        return underLinePainter;
    }

    @Override
    public boolean isLink(Token token) {
        return false;
    }

    @Override
    public void handleLink(Token token) {
    }

    @Override
    public void setText(String t) {
        this.lineMarkers = new HashMap<Integer, SortedSet<LineMarker>>();
        this.lastLine = -1;
        this.error = false;
        if (((Boolean)Configuration._debugMode.get()).booleanValue() && t != null && t.length() > 0x200000) {
            t = t.substring(0, 0x200000) + "\r\n" + AppStrings.translate("editorTruncateWarning").replace("%chars%", Integer.toString(0x200000));
        }
        super.setText(t);
        this.setCaretPosition(0);
    }

    private int cut(double val) {
        int ival = (int)Math.round(val);
        if (ival < 0) {
            return 0;
        }
        if (ival > 255) {
            ival = 255;
        }
        return ival;
    }

    @Override
    public void paint(Graphics g) {
        SortedSet<LineMarker> cs;
        Color selColor;
        Color c;
        if (View.isOceanic()) {
            c = Color.white;
            g.setColor(c);
            selColor = BG_SELECTED_LINE;
        } else {
            c = UIManager.getColor("EditorPane.background");
            g.setColor(c);
            int light = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
            selColor = light > 128 ? new Color(this.cut((double)c.getRed() * 0.9), this.cut((double)c.getGreen() * 0.9), this.cut((double)c.getBlue() * 0.9)) : new Color(this.cut((double)c.getRed() * 1.1), this.cut((double)c.getGreen() * 1.1), this.cut((double)c.getBlue() * 1.1));
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        FontMetrics fontMetrics = g.getFontMetrics();
        int lh = fontMetrics.getHeight();
        int d = fontMetrics.getDescent();
        if (this.lastLine > -1) {
            if (this.error) {
                g.setColor(BG_ERROR_LINE);
            } else {
                g.setColor(selColor);
            }
            g.fillRect(0, d + lh * this.lastLine - 1, this.getWidth(), lh);
        }
        for (int line : this.lineMarkers.keySet()) {
            LineMarker lastMarker;
            cs = this.lineMarkers.get(line);
            if (cs.isEmpty() || (lastMarker = cs.first()).getBgColor() == null) continue;
            g.setColor(lastMarker.getBgColor());
            g.fillRect(0, d + lh * ((line += this.firstLineOffset()) - 1), this.getWidth(), lh);
        }
        try {
            super.paint(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int line : this.lineMarkers.keySet()) {
            cs = this.lineMarkers.get(line);
            if (cs.isEmpty()) continue;
            Reference lineStart = new Reference((Object)0);
            Reference lineEnd = new Reference((Object)0);
            this.getLineBounds(line += this.firstLineOffset(), (Reference<Integer>)lineStart, (Reference<Integer>)lineEnd);
            FgPainter fgp = cs.first().getForegroundPainter();
            if (fgp == null) continue;
            fgp.paint(g, (Integer)lineStart.getVal(), (Integer)lineEnd.getVal(), null, this);
        }
    }

    public static class UnderLinePainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public UnderLinePainter(Color color) {
            super(color);
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            try {
                TextUI mapper = c.getUI();
                Color col = this.getColor();
                if (col == null) {
                    col = Color.black;
                }
                g.setColor(col);
                for (int i = offs0; i < offs1; ++i) {
                    Rectangle r = mapper.modelToView(c, i, Position.Bias.Forward);
                    Rectangle r1 = mapper.modelToView(c, i + 1, Position.Bias.Forward);
                    if (r1.y != r.y) continue;
                    g.drawLine(r.x, r.y + r.height - 3, r1.x, r.y + r.height - 3);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, javax.swing.text.View view) {
            Rectangle r;
            g.setColor(c.getSelectionColor());
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                r = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException e) {
                    r = null;
                }
            }
            if (r != null) {
                r.width = Math.max(r.width, 1);
                this.paint(g, offs0, offs1, r, c);
            }
            return r;
        }
    }

    public static class FgPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private final SyntaxStyle fgStyle;

        public FgPainter(Color color, Color bgColor) {
            super(bgColor);
            this.fgStyle = new SyntaxStyle(color, false, false);
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            try {
                TextUI mapper = c.getUI();
                Segment seg = new Segment();
                ((SyntaxDocument)c.getDocument()).getText(offs0, offs1 - offs0, seg);
                Rectangle r = mapper.modelToView(c, offs0, Position.Bias.Forward);
                FontMetrics fm = g.getFontMetrics();
                this.fgStyle.drawText(seg, r.x, r.y + fm.getAscent(), g, null, offs0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, javax.swing.text.View view) {
            Rectangle r;
            g.setColor(c.getSelectionColor());
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                r = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException e) {
                    r = null;
                }
            }
            if (r != null) {
                r.width = Math.max(r.width, 1);
                this.paint(g, offs0, offs1, r, c);
            }
            return r;
        }
    }

    private class LinkAdapter
    extends MouseAdapter
    implements KeyListener {
        private Point lastPos = new Point(0, 0);
        private boolean ctrlDown = false;

        private LinkAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                this.ctrlDown = true;
                this.update();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                this.ctrlDown = false;
                this.update();
            }
        }

        private void update() {
            if (this.ctrlDown) {
                Token t = LineMarkedEditorPane.this.tokenAtPos(this.lastPos);
                if (t != LineMarkedEditorPane.this.lastUnderlined) {
                    if (t == null || LineMarkedEditorPane.this.lastUnderlined == null || !t.equals((Object)LineMarkedEditorPane.this.lastUnderlined)) {
                        MyMarkers.removeMarkers(LineMarkedEditorPane.this, underLinePainter);
                        if (t != null && LineMarkedEditorPane.this.linkHandler.isLink(t)) {
                            LineMarkedEditorPane.this.lastUnderlined = t;
                            LineMarkedEditorPane.this.setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            LineMarkedEditorPane.this.lastUnderlined = null;
                        }
                    } else {
                        LineMarkedEditorPane.this.lastUnderlined = null;
                    }
                }
                if (LineMarkedEditorPane.this.lastUnderlined != null) {
                    MyMarkers.markToken(LineMarkedEditorPane.this, LineMarkedEditorPane.this.lastUnderlined, underLinePainter);
                } else {
                    LineMarkedEditorPane.this.setCursor(Cursor.getDefaultCursor());
                }
                LineMarkedEditorPane.this.repaint();
            } else {
                LineMarkedEditorPane.this.lastUnderlined = null;
                MyMarkers.removeMarkers(LineMarkedEditorPane.this, underLinePainter);
                LineMarkedEditorPane.this.setCursor(Cursor.getDefaultCursor());
                LineMarkedEditorPane.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Token t;
            if (this.ctrlDown && (t = LineMarkedEditorPane.this.tokenAtPos(this.lastPos)) != null && LineMarkedEditorPane.this.linkHandler.isLink(t)) {
                LineMarkedEditorPane.this.linkHandler.handleLink(t);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.ctrlDown = (e.getModifiersEx() & 0x80) != 0;
            this.lastPos = e.getPoint();
            this.update();
        }
    }

    public static class LineMarker
    implements Comparable<LineMarker> {
        private final Color bgColor;
        private final Color color;
        private FgPainter fgPainter;
        private final int priority;

        public FgPainter getForegroundPainter() {
            return this.fgPainter;
        }

        public String toString() {
            return this.bgColor.toString() + " priority:" + this.priority;
        }

        public LineMarker(Color color, Color bgColor, int priority) {
            this.bgColor = bgColor;
            this.color = color;
            this.priority = priority;
            if (color != null) {
                this.fgPainter = new FgPainter(color, bgColor);
            }
        }

        public int hashCode() {
            int hash = 5;
            hash = 17 * hash + Objects.hashCode(this.bgColor);
            hash = 17 * hash + Objects.hashCode(this.color);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineMarker other = (LineMarker)obj;
            if (!Objects.equals(this.bgColor, other.bgColor)) {
                return false;
            }
            return Objects.equals(this.color, other.color);
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int compareTo(LineMarker o) {
            return this.priority - o.priority;
        }
    }
}

