/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.dumpview;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ABCInputStream;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionListReader;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecial;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSwfNode;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.dumpview.DumpTreeModel;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class DumpTree
extends JTree {
    private static final Logger logger = Logger.getLogger(DumpTree.class.getName());
    private final MainPanel mainPanel;

    public DumpTree(DumpTreeModel treeModel, MainPanel mainPanel) {
        super(treeModel);
        this.mainPanel = mainPanel;
        this.setCellRenderer(new DumpTreeCellRenderer());
        this.setRootVisible(false);
        if (View.isOceanic()) {
            this.setBackground(Color.white);
            this.setUI(new BasicTreeUI(){
                {
                    this.setHashColor(Color.gray);
                }
            });
        }
    }

    public void createContextMenu() {
        final JPopupMenu contextPopupMenu = new JPopupMenu();
        final JMenuItem expandRecursiveMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.expandAll"));
        expandRecursiveMenuItem.addActionListener(this::expandRecursiveButtonActionPerformed);
        contextPopupMenu.add(expandRecursiveMenuItem);
        final JMenuItem saveToFileMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.saveToFile"));
        saveToFileMenuItem.addActionListener(this::saveToFileButtonActionPerformed);
        contextPopupMenu.add(saveToFileMenuItem);
        final JMenuItem saveUncompressedToFileMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.saveUncompressedToFile"));
        saveUncompressedToFileMenuItem.addActionListener(this::saveUncompressedToFileButtonActionPerformed);
        contextPopupMenu.add(saveUncompressedToFileMenuItem);
        final JMenuItem closeSelectionMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.closeSwf"));
        closeSelectionMenuItem.addActionListener(this::closeSwfButtonActionPerformed);
        contextPopupMenu.add(closeSelectionMenuItem);
        final JMenuItem parseActionsMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.parseActions"));
        parseActionsMenuItem.addActionListener(this::parseActionsButtonActionPerformed);
        contextPopupMenu.add(parseActionsMenuItem);
        final JMenuItem parseAbcMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.parseABC"));
        parseAbcMenuItem.addActionListener(this::parseAbcButtonActionPerformed);
        contextPopupMenu.add(parseAbcMenuItem);
        final JMenuItem parseInstructionsMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.parseInstructions"));
        parseInstructionsMenuItem.addActionListener(this::parseInstructionsButtonActionPerformed);
        contextPopupMenu.add(parseInstructionsMenuItem);
        final JMenuItem gotoTagMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.showInResources"));
        gotoTagMenuItem.addActionListener(this::gotoTagButtonActionPerformed);
        contextPopupMenu.add(gotoTagMenuItem);
        final JMenuItem gotoActionListMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.showInResources"));
        gotoActionListMenuItem.addActionListener(this::gotoActionListButtonActionPerformed);
        contextPopupMenu.add(gotoActionListMenuItem);
        final JMenuItem gotoMethodMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.showInResources"));
        gotoMethodMenuItem.addActionListener(this::gotoMethodButtonActionPerformed);
        contextPopupMenu.add(gotoMethodMenuItem);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    TreePath[] paths;
                    int row = DumpTree.this.getClosestRowForLocation(e.getX(), e.getY());
                    int[] selectionRows = DumpTree.this.getSelectionRows();
                    if (!Helper.contains((int[])selectionRows, (int)row)) {
                        DumpTree.this.setSelectionRow(row);
                    }
                    if ((paths = DumpTree.this.getSelectionPaths()) == null || paths.length == 0) {
                        return;
                    }
                    closeSelectionMenuItem.setVisible(false);
                    expandRecursiveMenuItem.setVisible(false);
                    saveToFileMenuItem.setVisible(false);
                    saveUncompressedToFileMenuItem.setVisible(false);
                    parseActionsMenuItem.setVisible(false);
                    parseAbcMenuItem.setVisible(false);
                    parseInstructionsMenuItem.setVisible(false);
                    gotoTagMenuItem.setVisible(false);
                    gotoActionListMenuItem.setVisible(false);
                    gotoMethodMenuItem.setVisible(false);
                    if (paths.length == 1) {
                        boolean noChild;
                        DumpInfo treeNode = (DumpInfo)paths[0].getLastPathComponent();
                        DumpInfoSpecialType specialType = DumpTree.this.getSpecialType(treeNode);
                        if (treeNode instanceof DumpInfoSwfNode) {
                            closeSelectionMenuItem.setVisible(true);
                        }
                        if (treeNode.getEndByte() - treeNode.startByte > 3L) {
                            saveToFileMenuItem.setVisible(true);
                            if (specialType == DumpInfoSpecialType.ZLIB_DATA) {
                                saveUncompressedToFileMenuItem.setVisible(true);
                            }
                        }
                        boolean bl = noChild = treeNode.getChildCount() == 0;
                        if (noChild) {
                            switch (specialType) {
                                case ACTION_BYTES: {
                                    parseActionsMenuItem.setVisible(true);
                                    break;
                                }
                                case ABC_BYTES: {
                                    parseAbcMenuItem.setVisible(true);
                                    break;
                                }
                                case ABC_CODE: {
                                    parseInstructionsMenuItem.setVisible(true);
                                }
                            }
                        }
                        switch (specialType) {
                            case TAG: {
                                gotoTagMenuItem.setVisible(true);
                                break;
                            }
                            case ACTION_BYTES: {
                                gotoActionListMenuItem.setVisible(true);
                                break;
                            }
                            case ABC_CODE: 
                            case ABC_METHOD_BODY: {
                                gotoMethodMenuItem.setVisible(true);
                            }
                        }
                        DumpTreeModel model = DumpTree.this.getModel();
                        expandRecursiveMenuItem.setVisible(model.getChildCount(treeNode) > 0);
                    }
                    contextPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private DumpInfoSpecialType getSpecialType(DumpInfo dumpInfo) {
        DumpInfoSpecialType specialType = dumpInfo instanceof DumpInfoSpecial ? ((DumpInfoSpecial)dumpInfo).specialType : DumpInfoSpecialType.NONE;
        return specialType;
    }

    private void expandRecursiveButtonActionPerformed(ActionEvent evt) {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        View.expandTreeNodes(this, path, true);
    }

    private void saveToFileButtonActionPerformed(ActionEvent evt) {
        this.saveToFileButtonActionPerformed(false);
    }

    private void saveUncompressedToFileButtonActionPerformed(ActionEvent evt) {
        this.saveToFileButtonActionPerformed(true);
    }

    private void saveToFileButtonActionPerformed(boolean decompress) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfo dumpInfo = (DumpInfo)paths[0].getLastPathComponent();
        JFileChooser fc = new JFileChooser();
        String selDir = (String)Configuration.lastOpenDir.get();
        fc.setCurrentDirectory(new File(selDir));
        if (fc.showSaveDialog(this) == 0) {
            File sf = Helper.fixDialogFile((File)fc.getSelectedFile());
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(sf));){
                byte[] data = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf().originalUncompressedData;
                if (decompress) {
                    ((OutputStream)fos).write(SWFInputStream.uncompressByteArray((byte[])data, (int)((int)dumpInfo.startByte), (int)((int)(dumpInfo.getEndByte() - dumpInfo.startByte + 1L))));
                } else {
                    ((OutputStream)fos).write(data, (int)dumpInfo.startByte, (int)(dumpInfo.getEndByte() - dumpInfo.startByte + 1L));
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void parseActionsButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfo dumpInfo = (DumpInfo)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        byte[] data = swf.originalUncompressedData;
        int prevLength = (int)dumpInfo.startByte;
        try {
            SWFInputStream rri = new SWFInputStream(swf, data);
            if (prevLength != 0) {
                rri.seek((long)prevLength);
            }
            List actions = ActionListReader.getOriginalActions((SWFInputStream)rri, (int)prevLength, (int)((int)dumpInfo.getEndByte()));
            for (Action action : actions) {
                DumpInfo di = new DumpInfo(action.toString(), "Action", null, action.getAddress(), (long)action.getTotalActionLength());
                di.parent = dumpInfo;
                rri.dumpInfo = di;
                rri.seek(action.getAddress());
                rri.readAction();
                dumpInfo.getChildInfos().add(di);
            }
            this.repaint();
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void parseAbcButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfo dumpInfo = (DumpInfo)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        byte[] data = swf.originalUncompressedData;
        int prevLength = (int)dumpInfo.startByte;
        try {
            ABCInputStream ais = new ABCInputStream(new MemoryInputStream(data, 0, prevLength + (int)dumpInfo.lengthBytes));
            ais.seek((long)prevLength);
            ais.dumpInfo = dumpInfo;
            new ABC(ais, swf, null);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.repaint();
    }

    private void parseInstructionsButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfo dumpInfo = (DumpInfo)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        byte[] data = swf.originalUncompressedData;
        int prevLength = (int)dumpInfo.startByte;
        try {
            ABCInputStream ais = new ABCInputStream(new MemoryInputStream(data, 0, prevLength + (int)dumpInfo.lengthBytes));
            ais.seek((long)prevLength);
            ais.dumpInfo = dumpInfo;
            new AVM2Code(ais, null);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.repaint();
    }

    private void gotoTagButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfoSpecial dumpInfo = (DumpInfoSpecial)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        long address = (Long)dumpInfo.specialValue;
        Tag foundTag = null;
        for (Tag tag : swf.getTags()) {
            if ((long)tag.getOriginalRange().getPos() != address) continue;
            foundTag = tag;
            break;
        }
        if (foundTag != null) {
            this.mainPanel.getMainFrame().getMenu().showResourcesView();
            this.mainPanel.setTagTreeSelectedNode((TreeItem)foundTag);
        }
    }

    private void gotoActionListButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfoSpecial dumpInfo = (DumpInfoSpecial)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        long address = (Long)dumpInfo.specialValue;
        this.mainPanel.getMainFrame().getMenu().showResourcesView();
    }

    private void gotoMethodButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfoSpecial dumpInfo = (DumpInfoSpecial)paths[0].getLastPathComponent();
        if (dumpInfo.specialType == DumpInfoSpecialType.ABC_CODE) {
            dumpInfo = (DumpInfoSpecial)dumpInfo.parent;
        }
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        int method_info = (Integer)dumpInfo.specialValue;
    }

    private void closeSwfButtonActionPerformed(ActionEvent evt) {
        Main.closeFile(this.mainPanel.getCurrentSwfList());
    }

    @Override
    public DumpTreeModel getModel() {
        return (DumpTreeModel)super.getModel();
    }

    public void expandRoot() {
        DumpTreeModel dtm = this.getModel();
        DumpInfo root = dtm.getRoot();
        this.expandPath(new TreePath(new Object[]{root}));
    }

    public void expandFirstLevelNodes() {
        DumpTreeModel dtm = this.getModel();
        DumpInfo root = dtm.getRoot();
        int childCount = dtm.getChildCount(root);
        this.expandPath(new TreePath(new Object[]{root}));
        for (int i = 0; i < childCount; ++i) {
            this.expandPath(new TreePath(new Object[]{root, dtm.getChild(root, i)}));
        }
    }

    public class DumpTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public DumpTreeCellRenderer() {
            if (View.isOceanic()) {
                this.setUI(new BasicLabelUI());
                this.setOpaque(false);
                this.setBackgroundNonSelectionColor(Color.white);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component ret = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (ret instanceof JLabel) {
                JLabel lab = (JLabel)ret;
                if (value instanceof DumpInfo) {
                    DumpInfo di = (DumpInfo)value;
                    TreeNodeType nodeType = null;
                    if ("".equals(di.type)) {
                        nodeType = TreeNodeType.FLASH;
                    } else if ("TAG".equals(di.type)) {
                        String name = di.name;
                        if (name.contains(" ")) {
                            name = name.substring(0, name.indexOf(32)).trim();
                        }
                        switch (name) {
                            case "DefineFont": 
                            case "DefineFont2": 
                            case "DefineFont3": 
                            case "DefineFont4": 
                            case "DefineCompactedFont": {
                                nodeType = TreeNodeType.FONT;
                                break;
                            }
                            case "DefineText": 
                            case "DefineText2": 
                            case "DefineEditText": {
                                nodeType = TreeNodeType.TEXT;
                                break;
                            }
                            case "DefineBits": 
                            case "DefineBitsJPEG2": 
                            case "DefineBitsJPEG3": 
                            case "DefineBitsJPEG4": 
                            case "DefineBitsLossless": 
                            case "DefineBitsLossless2": {
                                nodeType = TreeNodeType.IMAGE;
                                break;
                            }
                            case "DefineShape": 
                            case "DefineShape2": 
                            case "DefineShape3": 
                            case "DefineShape4": {
                                nodeType = TreeNodeType.SHAPE;
                                break;
                            }
                            case "DefineMorphShape": 
                            case "DefineMorphShape2": {
                                nodeType = TreeNodeType.MORPH_SHAPE;
                                break;
                            }
                            case "DefineSprite": {
                                nodeType = TreeNodeType.SPRITE;
                                break;
                            }
                            case "DefineButton": 
                            case "DefineButton2": {
                                nodeType = TreeNodeType.BUTTON;
                                break;
                            }
                            case "DefineVideoStream": {
                                nodeType = TreeNodeType.MOVIE;
                                break;
                            }
                            case "DefineSound": 
                            case "SoundStreamHead": 
                            case "SoundStreamHead2": {
                                nodeType = TreeNodeType.SOUND;
                                break;
                            }
                            case "DefineBinaryData": {
                                nodeType = TreeNodeType.BINARY_DATA;
                                break;
                            }
                            case "DoAction": 
                            case "DoInitAction": 
                            case "DoABC": 
                            case "DoABC2": {
                                nodeType = TreeNodeType.AS;
                                break;
                            }
                            case "ShowFrame": {
                                nodeType = TreeNodeType.FRAME;
                                break;
                            }
                            case "SetBackgroundColor": {
                                nodeType = TreeNodeType.SET_BACKGROUNDCOLOR;
                                break;
                            }
                            case "FileAttributes": {
                                nodeType = TreeNodeType.FILE_ATTRIBUTES;
                                break;
                            }
                            case "Metadata": {
                                nodeType = TreeNodeType.METADATA;
                                break;
                            }
                            case "PlaceObject": 
                            case "PlaceObject2": 
                            case "PlaceObject3": 
                            case "PlaceObject4": {
                                nodeType = TreeNodeType.PLACE_OBJECT;
                                break;
                            }
                            case "RemoveObject": 
                            case "RemoveObject2": {
                                nodeType = TreeNodeType.REMOVE_OBJECT;
                                break;
                            }
                            default: {
                                nodeType = TreeNodeType.OTHER_TAG;
                            }
                        }
                    }
                    if (nodeType != null) {
                        lab.setIcon(TagTree.getIconForType(nodeType));
                    }
                }
            }
            return ret;
        }
    }
}

