/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DocsPanel;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ASMSourceEditorPane;
import com.jpexs.decompiler.flash.gui.abc.DecompiledEditorPane;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.controls.NoneSelectedButtonGroup;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class MethodCodePanel
extends JPanel {
    private final ASMSourceEditorPane sourceTextArea;
    public JPanel buttonsPanel;
    private final JToggleButton hexButton;
    private final JToggleButton hexOnlyButton;
    private final DocsPanel docsPanel;

    public void refreshMarkers() {
        this.sourceTextArea.refreshMarkers();
    }

    public void clearDebuggerColors() {
        this.sourceTextArea.removeColorMarkerOnAllLines(DecompiledEditorPane.IP_MARKER);
    }

    public void gotoInstrLine(int line) {
        this.sourceTextArea.gotoInstrLine(line);
    }

    public void focusEditor() {
        this.sourceTextArea.requestFocusInWindow();
    }

    public int getScriptIndex() {
        return this.sourceTextArea.getScriptIndex();
    }

    public String getTraitName() {
        return this.sourceTextArea.getName();
    }

    public void setIgnoreCarret(boolean ignoreCarret) {
        this.sourceTextArea.setIgnoreCarret(ignoreCarret);
    }

    public void hilighOffset(long offset) {
        this.sourceTextArea.hilighOffset(offset);
    }

    public void hilighSpecial(HighlightSpecialType type, String specialValue) {
        this.sourceTextArea.hilighSpecial(type, specialValue);
    }

    public void setBodyIndex(String scriptPathName, int bodyIndex, ABC abc, Trait trait, int scriptIndex) {
        this.sourceTextArea.setBodyIndex(scriptPathName, bodyIndex, abc, this.sourceTextArea.getName(), trait, scriptIndex);
    }

    public void setBodyIndex(String scriptPathName, int bodyIndex, ABC abc, String name, Trait trait, int scriptIndex) {
        this.sourceTextArea.setBodyIndex(scriptPathName, bodyIndex, abc, name, trait, scriptIndex);
    }

    public int getBodyIndex() {
        return this.sourceTextArea.bodyIndex;
    }

    public void clear() {
        this.sourceTextArea.clear();
    }

    public boolean save() {
        return this.sourceTextArea.save();
    }

    public MethodCodePanel(DecompiledEditorPane decompiledEditor) {
        this.sourceTextArea = new ASMSourceEditorPane(decompiledEditor);
        this.setLayout(new BorderLayout());
        this.docsPanel = new DocsPanel();
        this.sourceTextArea.addDocsListener(this.docsPanel);
        if (((Boolean)Configuration.displayAs3PCodeDocsPanel.get()).booleanValue()) {
            this.add(new JPersistentSplitPane(0, new FasterScrollPane(this.sourceTextArea), (Component)new FasterScrollPane(this.docsPanel), (ConfigurationItem<Double>)Configuration.guiAvm2DocsSplitPaneDividerLocationPercent));
        } else {
            this.add(new FasterScrollPane(this.sourceTextArea));
        }
        this.sourceTextArea.changeContentType("text/flasm3");
        this.sourceTextArea.setFont(Configuration.getSourceFont());
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        JButton graphButton = new JButton(View.getIcon("graph16"));
        graphButton.addActionListener(this::graphButtonActionPerformed);
        graphButton.setToolTipText(AppStrings.translate("button.viewgraph"));
        graphButton.setMargin(new Insets(3, 3, 3, 3));
        this.hexButton = new JToggleButton(View.getIcon("hexas16"));
        this.hexButton.addActionListener(this::hexButtonActionPerformed);
        this.hexButton.setToolTipText(AppStrings.translate("button.viewhexpcode"));
        this.hexButton.setMargin(new Insets(3, 3, 3, 3));
        this.hexOnlyButton = new JToggleButton(View.getIcon("hex16"));
        this.hexOnlyButton.addActionListener(this::hexOnlyButtonActionPerformed);
        this.hexOnlyButton.setToolTipText(AppStrings.translate("button.viewhex"));
        this.hexOnlyButton.setMargin(new Insets(3, 3, 3, 3));
        NoneSelectedButtonGroup exportModeButtonGroup = new NoneSelectedButtonGroup();
        exportModeButtonGroup.add(this.hexButton);
        exportModeButtonGroup.add(this.hexOnlyButton);
        this.buttonsPanel.add(graphButton);
        this.buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.buttonsPanel.add(this.hexButton);
        this.buttonsPanel.add(this.hexOnlyButton);
        this.buttonsPanel.add(new JPanel());
        this.add((Component)this.buttonsPanel, "North");
    }

    private void graphButtonActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.sourceTextArea.graph();
    }

    private void hexButtonActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.sourceTextArea.setHex(this.getExportMode(), false);
    }

    private void hexOnlyButtonActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.sourceTextArea.setHex(this.getExportMode(), false);
    }

    public ASMSourceEditorPane getSourceTextArea() {
        return this.sourceTextArea;
    }

    private ScriptExportMode getExportMode() {
        ScriptExportMode exportMode = this.hexOnlyButton.isSelected() ? ScriptExportMode.HEX : (this.hexButton.isSelected() ? ScriptExportMode.PCODE_HEX : ScriptExportMode.PCODE);
        return exportMode;
    }

    public void setEditMode(boolean val) {
        ScriptExportMode exportMode = this.getExportMode();
        if (val) {
            this.sourceTextArea.setHex(exportMode == ScriptExportMode.HEX ? ScriptExportMode.HEX : ScriptExportMode.PCODE, false);
        } else if (exportMode != ScriptExportMode.PCODE) {
            this.sourceTextArea.setHex(exportMode, false);
        }
        this.sourceTextArea.setEditable(val);
        this.sourceTextArea.getCaret().setVisible(true);
        this.buttonsPanel.setVisible(!val);
    }
}

