/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallSuperVoidIns;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.action.deobfuscation.BrokenScriptDetector;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ABCPanel;
import com.jpexs.decompiler.flash.gui.abc.MethodCodePanel;
import com.jpexs.decompiler.flash.gui.editor.DebuggableEditorPane;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Reference;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

public class DecompiledEditorPane
extends DebuggableEditorPane
implements CaretListener {
    private static final Logger logger = Logger.getLogger(DecompiledEditorPane.class.getName());
    private HighlightedText highlightedText = HighlightedText.EMPTY;
    private Highlighting currentMethodHighlight;
    private Highlighting currentTraitHighlight;
    private ScriptPack script;
    public int lastTraitIndex = -4;
    public boolean ignoreCarret = false;
    private boolean reset = false;
    private final ABCPanel abcPanel;
    private int classIndex = -1;
    private boolean isStatic = false;
    private CancellableWorker setSourceWorker;
    private final List<Runnable> scriptListeners = new ArrayList<Runnable>();

    public void addScriptListener(Runnable l) {
        this.scriptListeners.add(l);
    }

    public ABCPanel getAbcPanel() {
        return this.abcPanel;
    }

    public void removeScriptListener(Runnable l) {
        this.scriptListeners.remove(l);
    }

    public void fireScript() {
        Runnable[] listeners;
        for (Runnable scriptListener : listeners = this.scriptListeners.toArray(new Runnable[this.scriptListeners.size()])) {
            scriptListener.run();
        }
    }

    public Trait getCurrentTrait() {
        if (this.lastTraitIndex < 0) {
            return null;
        }
        if (this.classIndex == -1) {
            return (Trait)((ScriptInfo)this.script.abc.script_info.get((int)this.script.scriptIndex)).traits.traits.get(this.lastTraitIndex);
        }
        return this.script.abc.findTraitByTraitId(this.classIndex, this.lastTraitIndex);
    }

    public ScriptPack getScriptLeaf() {
        return this.script;
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public void setNoTrait() {
        this.abcPanel.detailPanel.showCard("abc.detail.unsupported", null, 0);
    }

    public void hilightSpecial(HighlightSpecialType type, long index) {
        int endPos;
        int startPos;
        if (this.currentMethodHighlight == null) {
            if (this.currentTraitHighlight == null) {
                return;
            }
            startPos = this.currentTraitHighlight.startPos;
            endPos = this.currentTraitHighlight.startPos + this.currentTraitHighlight.len;
        } else {
            startPos = this.currentMethodHighlight.startPos;
            endPos = this.currentMethodHighlight.startPos + this.currentMethodHighlight.len;
        }
        ArrayList<Highlighting> allh = new ArrayList<Highlighting>();
        for (Highlighting h : this.highlightedText.getTraitHighlights()) {
            if (h.getProperties().index != (long)this.lastTraitIndex) continue;
            for (Highlighting sh : this.highlightedText.getSpecialHighlights()) {
                if (sh.startPos < h.startPos || sh.startPos + sh.len >= h.startPos + h.len) continue;
                allh.add(sh);
            }
        }
        if (this.currentMethodHighlight != null) {
            for (Highlighting h : this.highlightedText.getSpecialHighlights()) {
                if (h.startPos < startPos || h.startPos + h.len >= endPos) continue;
                allh.add(h);
            }
        }
        for (Highlighting h : allh) {
            if (!h.getProperties().subtype.equals((Object)type) || h.getProperties().index != index) continue;
            this.ignoreCarret = true;
            if (h.startPos <= this.getDocument().getLength()) {
                this.setCaretPosition(h.startPos);
            }
            this.getCaret().setVisible(true);
            this.ignoreCarret = false;
            break;
        }
    }

    public void hilightOffset(long offset) {
        if (this.currentMethodHighlight == null) {
            return;
        }
        Highlighting h2 = Highlighting.searchOffset((List)this.highlightedText.getInstructionHighlights(), (long)offset, (long)this.currentMethodHighlight.startPos, (long)(this.currentMethodHighlight.startPos + this.currentMethodHighlight.len));
        if (h2 != null) {
            this.ignoreCarret = true;
            if (h2.startPos <= this.getDocument().getLength()) {
                this.setCaretPosition(h2.startPos);
            }
            this.getCaret().setVisible(true);
            this.ignoreCarret = false;
        }
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    private boolean displayMethod(int pos, int methodIndex, String name, Trait trait, int traitIndex, boolean isStatic) {
        Highlighting sh;
        ABC abc = this.getABC();
        if (abc == null) {
            return false;
        }
        int bi = abc.findBodyIndex(methodIndex);
        if (bi == -1) {
            return false;
        }
        if (trait instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter tm = (TraitMethodGetterSetter)trait;
            if (tm.method_info != methodIndex) {
                trait = null;
            }
        }
        if (trait instanceof TraitFunction) {
            TraitFunction tf = (TraitFunction)trait;
            if (tf.method_info != methodIndex) {
                trait = null;
            }
        }
        this.abcPanel.detailPanel.showCard("abc.detail.methodtrait", trait, traitIndex);
        MethodCodePanel methodCodePanel = this.abcPanel.detailPanel.methodTraitPanel.methodCodePanel;
        if (this.reset || methodCodePanel.getBodyIndex() != bi) {
            methodCodePanel.setBodyIndex(this.scriptName, bi, abc, name, trait, this.script.scriptIndex);
            this.abcPanel.detailPanel.setEditMode(false);
            this.isStatic = isStatic;
        }
        boolean success = false;
        Highlighting h = Highlighting.searchPos((List)this.highlightedText.getInstructionHighlights(), (long)pos);
        if (h != null) {
            methodCodePanel.hilighOffset(h.getProperties().offset);
            success = true;
        }
        if ((sh = Highlighting.searchPos((List)this.highlightedText.getSpecialHighlights(), (long)pos)) != null) {
            methodCodePanel.hilighSpecial(sh.getProperties().subtype, sh.getProperties().specialValue);
            success = true;
        }
        return success;
    }

    public void displayClass(int classIndex, int scriptIndex) {
        if (this.abcPanel.navigator.getClassIndex() != classIndex) {
            this.abcPanel.navigator.setClassIndex(classIndex, scriptIndex);
        }
    }

    public void resetEditing() {
        this.reset = true;
        this.caretUpdate(null);
        this.reset = false;
    }

    public int getMultinameUnderMouseCursor(Point pt, Reference<ABC> abcUsed) {
        return this.getMultinameAtPos(this.viewToModel(pt), abcUsed);
    }

    public int getMultinameUnderCaret(Reference<ABC> abcUsed) {
        return this.getMultinameAtPos(this.getCaretPosition(), abcUsed);
    }

    public int getLocalDeclarationOfPos(int pos, Reference<DottedChain> type) {
        Highlighting sh = Highlighting.searchPos((List)this.highlightedText.getSpecialHighlights(), (long)pos);
        Highlighting h = Highlighting.searchPos((List)this.highlightedText.getInstructionHighlights(), (long)pos);
        if (h == null) {
            return -1;
        }
        List tms = Highlighting.searchAllPos((List)this.highlightedText.getMethodHighlights(), (long)pos);
        if (tms.isEmpty()) {
            return -1;
        }
        for (Highlighting tm : tms) {
            List tm_tms = Highlighting.searchAllIndexes((List)this.highlightedText.getMethodHighlights(), (long)tm.getProperties().index);
            if (h.getProperties().declaration || sh != null && sh.getProperties().declaration) {
                return -1;
            }
            String lname = h.getProperties().localName;
            if ("this".equals(lname)) {
                Highlighting ch = Highlighting.searchPos((List)this.highlightedText.getClassHighlights(), (long)pos);
                int cindex = (int)ch.getProperties().index;
                ABC abc = this.getABC();
                type.setVal((Object)((InstanceInfo)abc.instance_info.get(cindex)).getName(abc.constants).getNameWithNamespace(abc.constants, true));
                return ch.startPos;
            }
            HighlightData hData = h.getProperties();
            HighlightData search = new HighlightData();
            search.declaration = hData.declaration;
            search.declaredType = hData.declaredType;
            search.localName = hData.localName;
            search.specialValue = hData.specialValue;
            if (search.isEmpty()) {
                return -1;
            }
            search.declaration = true;
            for (Highlighting tm1 : tm_tms) {
                Highlighting rh = Highlighting.search((List)this.highlightedText.getInstructionHighlights(), (HighlightData)search, (long)tm1.startPos, (long)(tm1.startPos + tm1.len));
                if (rh == null) {
                    rh = Highlighting.search((List)this.highlightedText.getSpecialHighlights(), (HighlightData)search, (long)tm1.startPos, (long)(tm1.startPos + tm1.len));
                }
                if (rh == null) continue;
                type.setVal((Object)rh.getProperties().declaredType);
                return rh.startPos;
            }
        }
        return -1;
    }

    public boolean getPropertyTypeAtPos(int pos, Reference<Integer> abcIndex, Reference<Integer> classIndex, Reference<Integer> traitIndex, Reference<Boolean> classTrait, Reference<Integer> multinameIndex, Reference<ABC> abcUsed) {
        Token prev;
        Token t;
        int m = this.getMultinameAtPos(pos, true, abcUsed);
        if (m <= 0) {
            return false;
        }
        SyntaxDocument sd = (SyntaxDocument)this.getDocument();
        Token lastToken = t = sd.getTokenAt(pos + 1);
        while ((t.type == TokenType.IDENTIFIER || t.type == TokenType.KEYWORD || t.type == TokenType.REGEX) && (prev = sd.getPrevToken(t)) != null && ".".equals(prev.getString((Document)sd))) {
            t = sd.getPrevToken(prev);
        }
        if (t.type != TokenType.IDENTIFIER && t.type != TokenType.KEYWORD && t.type != TokenType.REGEX) {
            return false;
        }
        Reference locTypeRef = new Reference((Object)DottedChain.EMPTY);
        this.getLocalDeclarationOfPos(t.start, (Reference<DottedChain>)locTypeRef);
        DottedChain currentType = (DottedChain)locTypeRef.getVal();
        if (currentType.equals((Object)DottedChain.ALL)) {
            return false;
        }
        while (!currentType.equals((Object)DottedChain.ALL)) {
            String ident = t.getString((Document)sd);
            boolean found = false;
            List abcList = ((ABC)abcUsed.getVal()).getSwf().getAbcList();
            block2: for (int i = 0; i < abcList.size(); ++i) {
                ABC a = ((ABCContainerTag)abcList.get(i)).getABC();
                int cindex = a.findClassByName(currentType);
                if (cindex <= -1) continue;
                InstanceInfo ii = (InstanceInfo)a.instance_info.get(cindex);
                for (int j = 0; j < ii.instance_traits.traits.size(); ++j) {
                    Trait tr = (Trait)ii.instance_traits.traits.get(j);
                    if (!ident.equals(tr.getName(a).getName(a.constants, null, false, true))) continue;
                    classIndex.setVal((Object)cindex);
                    abcIndex.setVal((Object)i);
                    traitIndex.setVal((Object)j);
                    classTrait.setVal((Object)false);
                    multinameIndex.setVal((Object)tr.name_index);
                    currentType = ii.getName(a.constants).getNameWithNamespace(a.constants, true);
                    found = true;
                    break block2;
                }
                ClassInfo ci = (ClassInfo)a.class_info.get(cindex);
                for (int j = 0; j < ci.static_traits.traits.size(); ++j) {
                    Trait tr = (Trait)ci.static_traits.traits.get(j);
                    if (!ident.equals(tr.getName(a).getName(a.constants, null, false, true))) continue;
                    classIndex.setVal((Object)cindex);
                    abcIndex.setVal((Object)i);
                    traitIndex.setVal((Object)j);
                    classTrait.setVal((Object)true);
                    multinameIndex.setVal((Object)tr.name_index);
                    currentType = ii.getName(a.constants).getNameWithNamespace(a.constants, true);
                    found = true;
                    break block2;
                }
            }
            if (!found) {
                return false;
            }
            if (t == lastToken || !".".equals((t = sd.getNextToken(t)).getString((Document)sd))) break;
            t = sd.getNextToken(t);
        }
        return true;
    }

    public int getMultinameAtPos(int pos, Reference<ABC> abcUsed) {
        return this.getMultinameAtPos(pos, false, abcUsed);
    }

    private int getMultinameAtPos(int pos, boolean codeOnly, Reference<ABC> abcUsed) {
        int multinameIndex = this._getMultinameAtPos(pos, codeOnly, abcUsed);
        if (multinameIndex > -1) {
            ABC abc = (ABC)abcUsed.getVal();
            multinameIndex = abc.constants.convertToQname(abc.constants, multinameIndex);
        }
        return multinameIndex;
    }

    public int _getMultinameAtPos(int pos, boolean codeOnly, Reference<ABC> abcUsed) {
        Highlighting sh;
        Highlighting th;
        Highlighting tm = Highlighting.searchPos((List)this.highlightedText.getMethodHighlights(), (long)pos);
        Trait currentTrait = null;
        int currentMethod = -1;
        ABC abc = this.getABC();
        abcUsed.setVal((Object)abc);
        if (abc == null) {
            return -1;
        }
        if (tm != null) {
            int mi;
            currentMethod = mi = (int)tm.getProperties().index;
            int bi = abc.findBodyIndex(mi);
            Highlighting h = Highlighting.searchPos((List)this.highlightedText.getInstructionHighlights(), (long)pos);
            if (h != null) {
                long highlightOffset = h.getProperties().offset;
                List list = ((MethodBody)abc.bodies.get((int)bi)).getCode().code;
                AVM2Instruction lastIns = null;
                AVM2Instruction selIns = null;
                for (AVM2Instruction ins : list) {
                    if (highlightOffset == ins.getAddress()) {
                        selIns = ins;
                        break;
                    }
                    if (ins.getAddress() > highlightOffset) {
                        selIns = lastIns;
                        break;
                    }
                    lastIns = ins;
                }
                if (selIns != null) {
                    if (!codeOnly && (selIns.definition instanceof ConstructSuperIns || selIns.definition instanceof CallSuperIns || selIns.definition instanceof CallSuperVoidIns)) {
                        int cindex;
                        Highlighting tc = Highlighting.searchPos((List)this.highlightedText.getClassHighlights(), (long)pos);
                        if (tc != null && (cindex = (int)tc.getProperties().index) > -1) {
                            return ((InstanceInfo)abc.instance_info.get((int)cindex)).super_index;
                        }
                    } else {
                        for (int i = 0; i < selIns.definition.operands.length; ++i) {
                            if (selIns.definition.operands[i] != 257) continue;
                            return selIns.operands[i];
                        }
                    }
                }
            }
        }
        if (codeOnly) {
            return -1;
        }
        Highlighting ch = Highlighting.searchPos((List)this.highlightedText.getClassHighlights(), (long)pos);
        if (ch != null && (th = Highlighting.searchPos((List)this.highlightedText.getTraitHighlights(), (long)pos)) != null) {
            currentTrait = abc.findTraitByTraitId((int)ch.getProperties().index, (int)th.getProperties().index);
        }
        if (currentTrait instanceof TraitMethodGetterSetter) {
            currentMethod = ((TraitMethodGetterSetter)currentTrait).method_info;
        }
        if ((sh = Highlighting.searchPos((List)this.highlightedText.getSpecialHighlights(), (long)pos)) != null) {
            switch (sh.getProperties().subtype) {
                case TYPE_NAME: {
                    String typeName = sh.getProperties().specialValue;
                    for (int i = 1; i < abc.constants.getMultinameCount(); ++i) {
                        Multiname m = abc.constants.getMultiname(i);
                        if (m == null || !typeName.equals(m.getNameWithNamespace(abc.constants, true).toRawString())) continue;
                        return i;
                    }
                }
                case TRAIT_TYPE_NAME: {
                    if (!(currentTrait instanceof TraitSlotConst)) break;
                    TraitSlotConst ts = (TraitSlotConst)currentTrait;
                    return ts.type_index;
                }
                case TRAIT_NAME: {
                    if (currentTrait == null) break;
                    break;
                }
                case RETURNS: {
                    if (currentMethod <= -1) break;
                    return ((MethodInfo)abc.method_info.get((int)currentMethod)).ret_type;
                }
                case PARAM: {
                    if (currentMethod <= -1) break;
                    return ((MethodInfo)abc.method_info.get((int)currentMethod)).param_types[(int)sh.getProperties().index];
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent e) {
        ABC abc = this.getABC();
        if (abc == null) {
            return;
        }
        if (this.ignoreCarret) {
            return;
        }
        this.getCaret().setVisible(true);
        int pos = this.getCaretPosition();
        this.abcPanel.detailPanel.methodTraitPanel.methodCodePanel.setIgnoreCarret(true);
        this.lastTraitIndex = -4;
        try {
            this.classIndex = -1;
            Highlighting cm = Highlighting.searchPos((List)this.highlightedText.getClassHighlights(), (long)pos);
            if (cm != null) {
                this.classIndex = (int)cm.getProperties().index;
            }
            this.displayClass(this.classIndex, this.script.scriptIndex);
            Highlighting tm = Highlighting.searchPos((List)this.highlightedText.getMethodHighlights(), (long)pos);
            if (tm != null) {
                String name = "";
                if (this.classIndex > -1) {
                    name = ((InstanceInfo)abc.instance_info.get(this.classIndex)).getName(abc.constants).getNameWithNamespace(abc.constants, true).toPrintableString(true);
                }
                Trait currentTrait = null;
                this.currentTraitHighlight = Highlighting.searchPos((List)this.highlightedText.getTraitHighlights(), (long)pos);
                if (this.currentTraitHighlight != null) {
                    this.lastTraitIndex = (int)this.currentTraitHighlight.getProperties().index;
                    currentTrait = this.getCurrentTrait();
                    this.isStatic = abc.isStaticTraitId(this.classIndex, this.lastTraitIndex);
                    if (currentTrait != null) {
                        name = name + ":" + currentTrait.getName(abc).getName(abc.constants, null, false, true);
                    }
                }
                this.displayMethod(pos, (int)tm.getProperties().index, name, currentTrait, this.lastTraitIndex, this.isStatic);
                this.currentMethodHighlight = tm;
                return;
            }
            if (this.classIndex == -1) {
                this.abcPanel.navigator.setClassIndex(-1, this.script.scriptIndex);
            }
            this.currentTraitHighlight = Highlighting.searchPos((List)this.highlightedText.getTraitHighlights(), (long)pos);
            if (this.currentTraitHighlight != null) {
                this.lastTraitIndex = (int)this.currentTraitHighlight.getProperties().index;
                Trait currentTrait = this.getCurrentTrait();
                if (currentTrait != null && currentTrait instanceof TraitSlotConst) {
                    this.abcPanel.detailPanel.slotConstTraitPanel.load((TraitSlotConst)currentTrait, abc, abc.isStaticTraitId(this.classIndex, this.lastTraitIndex));
                    Trait ftrait = currentTrait;
                    int ftraitIndex = this.lastTraitIndex;
                    View.execInEventDispatch(() -> this.abcPanel.detailPanel.showCard("abc.detail.slotconsttrait", ftrait, ftraitIndex));
                    this.abcPanel.detailPanel.setEditMode(false);
                    this.currentMethodHighlight = null;
                    Highlighting spec = Highlighting.searchPos((List)this.highlightedText.getSpecialHighlights(), (long)pos, (long)this.currentTraitHighlight.startPos, (long)(this.currentTraitHighlight.startPos + this.currentTraitHighlight.len));
                    if (spec != null) {
                        this.abcPanel.detailPanel.slotConstTraitPanel.hilightSpecial(spec);
                    }
                    return;
                }
                this.currentMethodHighlight = null;
                String name = this.classIndex == -1 ? "" : ((InstanceInfo)abc.instance_info.get(this.classIndex)).getName(abc.constants).getNameWithNamespace(abc.constants, true).toPrintableString(true);
                currentTrait = this.getCurrentTrait();
                this.isStatic = abc.isStaticTraitId(this.classIndex, this.lastTraitIndex);
                if (currentTrait != null) {
                    if (!name.isEmpty()) {
                        name = name + ":";
                    }
                    name = name + currentTrait.getName(abc).getName(abc.constants, null, false, true);
                }
                int methodId = this.classIndex > -1 ? abc.findMethodIdByTraitId(this.classIndex, this.lastTraitIndex) : ((TraitMethodGetterSetter)((ScriptInfo)abc.script_info.get((int)this.script.scriptIndex)).traits.traits.get((int)this.lastTraitIndex)).method_info;
                this.displayMethod(pos, methodId, name, currentTrait, this.lastTraitIndex, this.isStatic);
                return;
            }
            this.setNoTrait();
        }
        finally {
            this.abcPanel.detailPanel.methodTraitPanel.methodCodePanel.setIgnoreCarret(false);
        }
    }

    public void gotoLastTrait() {
        this.gotoTrait(this.lastTraitIndex);
    }

    public void gotoLastMethod() {
        if (this.currentMethodHighlight != null) {
            final int fpos = this.currentMethodHighlight.startPos;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (fpos <= DecompiledEditorPane.this.getDocument().getLength()) {
                        DecompiledEditorPane.this.setCaretPosition(fpos);
                    }
                }
            }, 100L);
        }
    }

    public void gotoTrait(int traitId) {
        boolean isScriptInit = traitId == -3;
        Highlighting tc = Highlighting.searchIndex((List)this.highlightedText.getClassHighlights(), (long)this.classIndex);
        if (tc != null || isScriptInit) {
            Highlighting th = Highlighting.searchIndex((List)this.highlightedText.getTraitHighlights(), (long)traitId, (long)(isScriptInit ? 0L : (long)tc.startPos), (long)(isScriptInit ? -1L : (long)(tc.startPos + tc.len)));
            int pos = 0;
            if (th != null) {
                if (th.len > 1) {
                    this.ignoreCarret = true;
                    int startPos = th.startPos + th.len - 1;
                    if (startPos <= this.getDocument().getLength()) {
                        this.setCaretPosition(startPos);
                    }
                    this.ignoreCarret = false;
                }
                pos = th.startPos;
            } else if (tc != null) {
                pos = tc.startPos;
            }
            final int fpos = pos;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (fpos <= DecompiledEditorPane.this.getDocument().getLength()) {
                        DecompiledEditorPane.this.setCaretPosition(fpos);
                    }
                }
            }, 100L);
        }
    }

    public DecompiledEditorPane(ABCPanel abcPanel) {
        this.setEditable(false);
        this.getCaret().setVisible(true);
        this.addCaretListener(this);
        this.abcPanel = abcPanel;
    }

    public void clearScript() {
        this.script = null;
    }

    public void setScript(final ScriptPack scriptLeaf, boolean force) {
        boolean decompileNeeded;
        View.checkAccess();
        if (this.setSourceWorker != null) {
            this.setSourceWorker.cancel(true);
            this.setSourceWorker = null;
        }
        if (!force && this.script == scriptLeaf) {
            this.fireScript();
            return;
        }
        String sn = scriptLeaf.getClassPath().toString();
        this.setScriptName(sn);
        this.abcPanel.scriptNameLabel.setText(sn);
        int scriptIndex = scriptLeaf.scriptIndex;
        ScriptInfo nscript = null;
        ABC abc = scriptLeaf.abc;
        if (scriptIndex > -1) {
            nscript = (ScriptInfo)abc.script_info.get(scriptIndex);
        }
        if (nscript == null) {
            this.highlightedText = HighlightedText.EMPTY;
            return;
        }
        HighlightedText decompiledText = SWF.getFromCache((ScriptPack)scriptLeaf);
        boolean bl = decompileNeeded = decompiledText == null;
        if (decompileNeeded) {
            CancellableWorker worker = new CancellableWorker(){

                protected Void doInBackground() throws Exception {
                    if (decompileNeeded) {
                        View.execInEventDispatch(() -> DecompiledEditorPane.this.setText("// " + AppStrings.translate("work.decompiling") + "..."));
                        HighlightedText htext = SWF.getCached((ScriptPack)scriptLeaf);
                        View.execInEventDispatch(() -> DecompiledEditorPane.this.setSourceCompleted(scriptLeaf, htext));
                    }
                    return null;
                }

                protected void done() {
                    View.execInEventDispatch(() -> {
                        DecompiledEditorPane.this.setSourceWorker = null;
                        if (!Main.isDebugging()) {
                            Main.stopWork();
                        }
                        try {
                            this.get();
                        }
                        catch (CancellationException ex) {
                            DecompiledEditorPane.this.setText("// " + AppStrings.translate("work.canceled"));
                        }
                        catch (Exception ex) {
                            Throwable cause = ex;
                            if (ex instanceof ExecutionException) {
                                cause = ex.getCause();
                            }
                            if (cause instanceof CancellationException) {
                                DecompiledEditorPane.this.setText("// " + AppStrings.translate("work.canceled"));
                            }
                            logger.log(Level.SEVERE, "Error", cause);
                            DecompiledEditorPane.this.setText("// " + AppStrings.translate("decompilationError") + ": " + cause);
                        }
                    });
                }
            };
            worker.execute();
            this.setSourceWorker = worker;
            if (!Main.isDebugging()) {
                Main.startWork(AppStrings.translate("work.decompiling") + "...", worker);
            }
        } else {
            this.setSourceCompleted(scriptLeaf, decompiledText);
        }
    }

    private void setSourceCompleted(ScriptPack scriptLeaf, HighlightedText decompiledText) {
        View.checkAccess();
        if (decompiledText == null) {
            decompiledText = HighlightedText.EMPTY;
        }
        this.script = scriptLeaf;
        this.highlightedText = decompiledText;
        if (decompiledText != null) {
            BrokenScriptDetector det = new BrokenScriptDetector();
            String hilightedCode = decompiledText.text;
            if (det.codeIsBroken(hilightedCode)) {
                this.abcPanel.brokenHintPanel.setVisible(true);
            } else {
                this.abcPanel.brokenHintPanel.setVisible(false);
            }
            this.setText(hilightedCode);
            if (this.highlightedText.getClassHighlights().size() > 0) {
                try {
                    this.setCaretPosition(((Highlighting)this.highlightedText.getClassHighlights().get((int)0)).startPos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.fireScript();
    }

    public void reloadClass() {
        View.checkAccess();
        int ci = this.classIndex;
        SWF.uncache((ScriptPack)this.script);
        if (this.script != null && this.getABC() != null) {
            this.setScript(this.script, true);
        }
        this.setNoTrait();
        this.setClassIndex(ci);
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    private ABC getABC() {
        return this.script == null ? null : this.script.abc;
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.setCaretPosition(0);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.abcPanel.getDebugPanel().localsTable == null) {
            return super.getToolTipText();
        }
        Point point = new Point(e.getX(), e.getY());
        int pos = this.abcPanel.decompiledTextArea.viewToModel(point);
        String identifier = this.abcPanel.getMainPanel().getActionPanel().getStringUnderPosition(pos, this.abcPanel.decompiledTextArea);
        if (identifier != null && !identifier.isEmpty()) {
            String tooltipText = this.abcPanel.getDebugPanel().localsTable.tryGetDebugHoverToolTipText(identifier);
            return tooltipText == null ? super.getToolTipText() : tooltipText;
        }
        return super.getToolTipText();
    }
}

