/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2ExecutionException;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2Graph;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.ASM3Parser;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.Flasm3Lexer;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.MissingSymbolHandler;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.ParsedSymbol;
import com.jpexs.decompiler.flash.abc.types.Decimal;
import com.jpexs.decompiler.flash.abc.types.Float4;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.docs.As3PCodeDocs;
import com.jpexs.decompiler.flash.docs.As3PCodeOtherDocs;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.gui.GraphDialog;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.abc.ABCPanel;
import com.jpexs.decompiler.flash.gui.abc.DecompiledEditorPane;
import com.jpexs.decompiler.flash.gui.abc.DocsListener;
import com.jpexs.decompiler.flash.gui.editor.DebuggableEditorPane;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.helpers.Helper;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ASMSourceEditorPane
extends DebuggableEditorPane
implements CaretListener {
    public ABC abc;
    public int bodyIndex = -1;
    private int scriptIndex = -1;
    private HighlightedText highlightedText = HighlightedText.EMPTY;
    private final List<DocsListener> docsListeners = new ArrayList<DocsListener>();
    private final DecompiledEditorPane decompiledEditor;
    private boolean ignoreCarret = false;
    private String name;
    private HighlightedText textWithHex;
    private HighlightedText textNoHex;
    private HighlightedText textHexOnly;
    private ScriptExportMode exportMode = ScriptExportMode.PCODE;
    private Trait trait;
    private int firstInstrLine = -1;
    private final Map<String, InstructionDefinition> insNameToDef = new HashMap<String, InstructionDefinition>();

    public int getScriptIndex() {
        return this.scriptIndex;
    }

    public void addDocsListener(DocsListener l) {
        this.docsListeners.add(l);
    }

    public void removeDocsListener(DocsListener l) {
        this.docsListeners.remove(l);
    }

    public ABCPanel getAbcPanel() {
        return this.decompiledEditor.getAbcPanel();
    }

    public ScriptExportMode getExportMode() {
        return this.exportMode;
    }

    private HighlightedText getHighlightedText(ScriptExportMode exportMode) {
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        if (this.trait != null && exportMode != ScriptExportMode.AS && exportMode != ScriptExportMode.AS_METHOD_STUBS) {
            this.trait.convertTraitHeader(this.abc, (GraphTextWriter)writer);
        }
        MethodBody body = (MethodBody)this.abc.bodies.get(this.bodyIndex);
        ((MethodBody)this.abc.bodies.get(this.bodyIndex)).getCode().toASMSource(this.abc, this.abc.constants, (MethodInfo)this.abc.method_info.get(body.method_info), body, exportMode, (GraphTextWriter)writer);
        if (this.trait != null && exportMode != ScriptExportMode.AS && exportMode != ScriptExportMode.AS_METHOD_STUBS) {
            if (((Boolean)Configuration.indentAs3PCode.get()).booleanValue()) {
                writer.unindent();
            }
            writer.appendNoHilight("end ; trait").newLine();
        }
        return new HighlightedText(writer);
    }

    public void setHex(ScriptExportMode exportMode, boolean force) {
        if (this.exportMode == exportMode && !force) {
            return;
        }
        this.exportMode = exportMode;
        long oldOffset = this.getSelectedOffset();
        if (exportMode == ScriptExportMode.PCODE) {
            this.changeContentType("text/flasm3");
            if (this.textNoHex == null) {
                this.textNoHex = this.getHighlightedText(exportMode);
            }
            this.setText(this.textNoHex);
        } else if (exportMode == ScriptExportMode.PCODE_HEX) {
            this.changeContentType("text/flasm3");
            if (this.textWithHex == null) {
                this.textWithHex = this.getHighlightedText(exportMode);
            }
            this.setText(this.textWithHex);
        } else {
            this.changeContentType("text/plain");
            if (this.textHexOnly == null) {
                HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
                Helper.byteArrayToHexWithHeader((GraphTextWriter)writer, (byte[])((MethodBody)this.abc.bodies.get(this.bodyIndex)).getCodeBytes());
                this.textHexOnly = new HighlightedText(writer);
            }
            this.setText(this.textHexOnly);
        }
        this.hilighOffset(oldOffset);
    }

    public void setIgnoreCarret(boolean ignoreCarret) {
        this.ignoreCarret = ignoreCarret;
    }

    public ASMSourceEditorPane(DecompiledEditorPane decompiledEditor) {
        this.decompiledEditor = decompiledEditor;
        this.addCaretListener(this);
        for (InstructionDefinition def : AVM2Code.allInstructionSet) {
            if (def == null) continue;
            this.insNameToDef.put(def.instructionName, def);
        }
    }

    public void hilighSpecial(HighlightSpecialType type, String specialValue) {
        Highlighting h2 = null;
        for (Highlighting sh : this.highlightedText.getSpecialHighlights()) {
            if (!type.equals((Object)sh.getProperties().subtype) || !sh.getProperties().specialValue.equals(specialValue)) continue;
            h2 = sh;
            break;
        }
        if (h2 != null) {
            this.ignoreCarret = true;
            if (h2.startPos <= this.getDocument().getLength()) {
                this.setCaretPosition(h2.startPos);
            }
            this.getCaret().setVisible(true);
            this.ignoreCarret = false;
        }
    }

    public void hilighOffset(long offset) {
        if (this.isEditable()) {
            return;
        }
        Highlighting h2 = Highlighting.searchOffset((List)this.highlightedText.getInstructionHighlights(), (long)offset);
        if (h2 != null) {
            this.ignoreCarret = true;
            if (h2.startPos <= this.getDocument().getLength()) {
                this.setCaretPosition(h2.startPos);
            }
            this.getCaret().setVisible(true);
            this.ignoreCarret = false;
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public void setBodyIndex(String scriptPathName, int bodyIndex, ABC abc, String name, Trait trait, int scriptIndex) {
        this.bodyIndex = bodyIndex;
        this.abc = abc;
        this.name = name;
        this.trait = trait;
        this.scriptIndex = scriptIndex;
        if (bodyIndex == -1) {
            return;
        }
        this.textWithHex = null;
        this.textNoHex = null;
        this.textHexOnly = null;
        List cs = abc.getAbcTags();
        int abcIndex = -1;
        for (int i = 0; i < cs.size(); ++i) {
            if (((ABCContainerTag)cs.get(i)).getABC() != abc) continue;
            abcIndex = i;
            break;
        }
        String aname = "#PCODE abc:" + abcIndex + ",body:" + bodyIndex + ";" + scriptPathName;
        this.setScriptName(aname);
        this.setHex(this.exportMode, true);
    }

    public void graph() {
        try {
            AVM2Graph gr = new AVM2Graph(((MethodBody)this.abc.bodies.get(this.bodyIndex)).getCode(), this.abc, (MethodBody)this.abc.bodies.get(this.bodyIndex), false, -1, -1, new HashMap(), new ScopeStack(), new HashMap(), new ArrayList(), new HashMap(), ((MethodBody)this.abc.bodies.get(this.bodyIndex)).getCode().visitCode((MethodBody)this.abc.bodies.get(this.bodyIndex)));
            new GraphDialog(this.getAbcPanel().getMainPanel().getMainFrame().getWindow(), (Graph)gr, this.name).setVisible(true);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ASMSourceEditorPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exec() {
        HashMap<Integer, Object> args = new HashMap<Integer, Object>();
        args.put(0, new Object());
        args.put(1, 466561L);
        try {
            Object o = ((MethodBody)this.abc.bodies.get(this.bodyIndex)).getCode().execute(args, this.abc.constants);
            ViewMessages.showMessageDialog(this, "Returned object:" + o.toString());
        }
        catch (AVM2ExecutionException ex) {
            Logger.getLogger(ASMSourceEditorPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean save() {
        try {
            String text = this.getText();
            if (text.trim().startsWith(Helper.hexData)) {
                byte[] data = Helper.getBytesFromHexaText((String)text);
                MethodBody mb = (MethodBody)this.abc.bodies.get(this.bodyIndex);
                mb.setCodeBytes(data);
            } else {
                AVM2Code acode = ASM3Parser.parse((ABC)this.abc, (Reader)new StringReader(text), (Trait)this.trait, (MissingSymbolHandler)new MissingSymbolHandler(){

                    public boolean missingString(String value) {
                        return true;
                    }

                    public boolean missingInt(long value) {
                        return true;
                    }

                    public boolean missingUInt(long value) {
                        return true;
                    }

                    public boolean missingDouble(double value) {
                        return true;
                    }

                    public boolean missingDecimal(Decimal value) {
                        return true;
                    }

                    public boolean missingFloat(float value) {
                        return true;
                    }

                    public boolean missingFloat4(Float4 value) {
                        return true;
                    }
                }, (MethodBody)((MethodBody)this.abc.bodies.get(this.bodyIndex)), (MethodInfo)((MethodInfo)this.abc.method_info.get(((MethodBody)this.abc.bodies.get((int)this.bodyIndex)).method_info)));
                ((MethodBody)this.abc.bodies.get(this.bodyIndex)).setCode(acode);
            }
            ((Tag)this.abc.parentTag).setModified(true);
            ((ScriptInfo)this.abc.script_info.get(this.scriptIndex)).setModified(true);
            this.textWithHex = null;
            this.textNoHex = null;
            this.textHexOnly = null;
            this.setHex(this.exportMode, true);
        }
        catch (IOException text) {
        }
        catch (InterruptedException text) {
        }
        catch (AVM2ParseException ex) {
            this.gotoLine((int)ex.line);
            this.markError();
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), ex.text + " on line " + ex.line, Main.getMainFrame().translate("error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void setText(String t) {
        this.setText(new HighlightedText(t));
    }

    public void setText(HighlightedText highlightedText) {
        this.highlightedText = highlightedText;
        if (!highlightedText.getInstructionHighlights().isEmpty()) {
            int firstPos = ((Highlighting)highlightedText.getInstructionHighlights().get((int)0)).startPos;
            String txt = highlightedText.text;
            txt = txt.replace("\r", "");
            int line = 0;
            for (int i = 0; i < firstPos; ++i) {
                if (txt.charAt(i) != '\n') continue;
                ++line;
            }
            this.firstInstrLine = line;
        }
        super.setText(highlightedText.text);
        this.setCaretPosition(0);
    }

    @Override
    public int firstLineOffset() {
        return this.firstInstrLine;
    }

    public void gotoInstrLine(int line) {
        super.gotoLine(this.firstInstrLine + line);
    }

    public void clear() {
        this.setText("");
        this.bodyIndex = -1;
        this.setCaretPosition(0);
    }

    public void selectInstruction(int pos) {
        String text = this.getText();
        int lineCnt = 1;
        int lineStart = 0;
        int instrCount = 0;
        int dot = -2;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++lineCnt;
            int lineEnd = i;
            String ins = text.substring(lineStart, lineEnd).trim();
            if (!(i > 0 && text.charAt(i - 1) == ':' || ins.startsWith("exception "))) {
                ++instrCount;
            }
            if (instrCount == pos + 1) break;
            lineStart = i + 1;
        }
        this.setCaretPosition(lineStart);
    }

    public Highlighting getSelectedSpecial() {
        return Highlighting.searchPos((List)this.highlightedText.getSpecialHighlights(), (long)this.getCaretPosition());
    }

    public long getSelectedOffset() {
        int pos = this.getCaretPosition();
        Highlighting lastH = null;
        for (Highlighting h : this.highlightedText.getInstructionHighlights()) {
            if (pos < h.startPos) break;
            lastH = h;
        }
        return lastH == null ? 0L : lastH.getProperties().offset;
    }

    private void fireDocs(String identifier, String value, Point screenLocation) {
        for (DocsListener l : this.docsListeners) {
            l.docs(identifier, value, screenLocation);
        }
    }

    private void fireNoDocs() {
        for (DocsListener l : this.docsListeners) {
            l.noDocs();
        }
    }

    private String getLevel() {
        ParsedSymbol symb;
        int currentLine = this.getLine();
        int caretPos = this.getCaretPosition();
        Flasm3Lexer lexer = new Flasm3Lexer((Reader)new StringReader(this.getText().replace("\r\n", "\n")));
        Integer[] singleUse = new Integer[]{83, 85, 84, 52, 51, 50, 53, 49, 48, 47};
        Integer[] openingBlocks = new Integer[]{75, 63, 58, 72, 86};
        Integer[] singleLine = new Integer[]{87, 44, 45, 54, 55, 56, 57, 59, 60, 61, 62, 39, 80, 81, 43, 82};
        Integer[] parameters = new Integer[]{40, 41, 42, 44, 43, 73, 74, 76, 77};
        List<Integer> openingBlocksList = Arrays.asList(openingBlocks);
        List<Integer> singleLineList = Arrays.asList(singleLine);
        List<Integer> parameterList = Arrays.asList(parameters);
        List<Integer> singleUseList = Arrays.asList(singleUse);
        boolean TYPE_IGNORED = false;
        boolean TYPE_OPENING_BLOCK = true;
        int TYPE_LINE_BLOCK = 2;
        int TYPE_PARAMETER = 3;
        int TYPE_SINGLE_USE = 4;
        int TYPE_CLOSING_BLOCK = 5;
        Stack<String> levels = new Stack<String>();
        Stack<Integer> types = new Stack<Integer>();
        Stack<Integer> lines = new Stack<Integer>();
        int prev = -1;
        int lastLine = 0;
        do {
            try {
                symb = lexer.lex();
            }
            catch (AVM2ParseException | IOException ex) {
                break;
            }
            int line = lexer.yyline();
            String lastLevel = null;
            if (!levels.isEmpty()) {
                lastLevel = (String)levels.peek();
            }
            if (line != lastLine && !levels.isEmpty()) {
                while ((Integer)types.peek() == 2 || (Integer)types.peek() == 3) {
                    levels.pop();
                    types.pop();
                    lines.pop();
                }
            }
            int type = 0;
            if (symb.type == 75 && "trait".equals(lastLevel)) {
                type = 3;
            } else if (symb.type == 44 && "try".equals(lastLevel)) {
                type = 3;
            } else if (openingBlocksList.contains(symb.type)) {
                type = 1;
            } else if (singleLineList.contains(symb.type)) {
                type = 2;
            } else if (parameterList.contains(symb.type)) {
                type = 3;
            } else if (singleUseList.contains(symb.type)) {
                type = 4;
            } else if (symb.type == 88) {
                if (levels.isEmpty()) break;
                levels.pop();
                types.pop();
                lines.pop();
                type = 5;
            }
            boolean aboutToBreak = false;
            if (caretPos < lexer.yychar() + lexer.yylength()) {
                aboutToBreak = true;
            }
            if (type != 0) {
                if (!levels.isEmpty() && (Integer)types.peek() == 3) {
                    levels.pop();
                    types.pop();
                    lines.pop();
                }
                if (type != 5) {
                    levels.push((String)symb.value);
                    types.push(type);
                    lines.push(lexer.yyline());
                }
            }
            if (aboutToBreak) break;
            if (type == 4 && !levels.isEmpty()) {
                levels.pop();
                types.pop();
                lines.pop();
            }
            prev = symb.type;
            if (type == 63) break;
            lastLine = line;
        } while (symb.type != 7);
        String ret = String.join((CharSequence)".", levels);
        return ret;
    }

    public void updateDocs() {
        String pathDocs;
        String path = this.getLevel();
        Color c = UIManager.getColor("EditorPane.background");
        int light = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
        boolean nightMode = light <= 128;
        String pathNoTrait = path;
        if (path.startsWith("trait.method")) {
            pathNoTrait = path.substring("trait.".length());
        }
        if (pathNoTrait.startsWith("method.body.code")) {
            Point loc;
            String insName;
            String curLine = this.getCurrentLineText();
            if (curLine == null) {
                return;
            }
            if ((curLine = curLine.trim()).matches("\\p{L}[\\p{L}0-9]*:.*")) {
                curLine = curLine.substring(curLine.indexOf(58) + 1).trim();
            }
            if (curLine.contains(" ")) {
                curLine = curLine.substring(0, curLine.indexOf(32));
            }
            if (curLine.contains(";")) {
                curLine = curLine.substring(0, curLine.indexOf(59));
            }
            if (AVM2Code.instructionAliases.containsKey(insName = curLine.toLowerCase())) {
                insName = (String)AVM2Code.instructionAliases.get(insName);
            }
            if ((loc = this.getLineLocation(this.getLine() + 1)) != null) {
                SwingUtilities.convertPointToScreen(loc, this);
            }
            if (this.insNameToDef.containsKey(insName)) {
                this.fireDocs("instruction." + insName, As3PCodeDocs.getDocsForIns((String)insName, (boolean)false, (boolean)true, (boolean)true, (boolean)nightMode), loc);
                return;
            }
        }
        if ((pathDocs = As3PCodeOtherDocs.getDocsForPath((String)pathNoTrait, (boolean)nightMode)) == null) {
            this.fireNoDocs();
        } else {
            Point loc = this.getLineLocation(this.getLine() + 1);
            if (loc != null) {
                SwingUtilities.convertPointToScreen(loc, this);
            }
            this.fireDocs(pathNoTrait, pathDocs, loc);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.updateDocs();
        if (this.ignoreCarret) {
            return;
        }
        if (this.isEditable()) {
            return;
        }
        this.getCaret().setVisible(true);
        this.decompiledEditor.hilightOffset(this.getSelectedOffset());
        Highlighting spec = this.getSelectedSpecial();
        if (spec != null) {
            this.decompiledEditor.hilightSpecial(spec.getProperties().subtype, spec.getProperties().index);
        }
    }
}

