/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.search.ABCSearchResult;
import com.jpexs.decompiler.flash.search.ActionSearchResult;
import com.jpexs.decompiler.flash.search.ScriptNotFoundException;
import com.jpexs.decompiler.flash.search.ScriptSearchResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchResultsStorage {
    public static final String SEARCH_RESULTS_FILE = "searchresults.bin";
    private static final int SERIAL_VERSION_MAJOR = 2;
    private static final int SERIAL_VERSION_MINOR = 0;
    private static final int DATA_ABC = 1;
    private static final int DATA_ACTION = 2;
    List<String> swfIds = new ArrayList<String>();
    List<String> searchedValues = new ArrayList<String>();
    List<Boolean> isRegExp = new ArrayList<Boolean>();
    List<Boolean> isIgnoreCase = new ArrayList<Boolean>();
    List<byte[]> data = new ArrayList<byte[]>();
    List<List<ScriptSearchResult>> unpackedData = new ArrayList<List<ScriptSearchResult>>();
    List<Integer> groups = new ArrayList<Integer>();
    private int currentGroupId = 0;

    private static String getConfigFile() throws IOException {
        return Configuration.getFFDecHome() + SEARCH_RESULTS_FILE;
    }

    public void finishGroup() {
        ++this.currentGroupId;
    }

    public static String getSwfId(SWF swf) {
        SWF s = swf;
        String binaryDataSuffix = "";
        while (s.binaryData != null) {
            binaryDataSuffix = binaryDataSuffix + "|binaryData[" + s.binaryData.getCharacterId() + "]";
            s = s.binaryData.getSwf();
        }
        if (s.swfList != null) {
            String fileInsideTitle;
            String string = fileInsideTitle = s.getFile() == null ? s.getFileTitle() : "";
            if (fileInsideTitle != null && !"".equals(fileInsideTitle)) {
                fileInsideTitle = "|" + fileInsideTitle;
            }
            return s.swfList.sourceInfo.getFile() + fileInsideTitle + binaryDataSuffix;
        }
        return "**NONE**";
    }

    public int getCount() {
        return this.swfIds.size();
    }

    public String getSearchedValueAt(int index) {
        for (int j = 0; j < this.data.size(); ++j) {
            if (this.groups.get(j) != index) continue;
            return this.searchedValues.get(j);
        }
        return null;
    }

    public boolean isIgnoreCaseAt(int index) {
        for (int j = 0; j < this.data.size(); ++j) {
            if (this.groups.get(j) != index) continue;
            return this.isIgnoreCase.get(j);
        }
        return false;
    }

    public boolean isRegExpAt(int index) {
        for (int j = 0; j < this.data.size(); ++j) {
            if (this.groups.get(j) != index) continue;
            return this.isRegExp.get(j);
        }
        return false;
    }

    public List<Integer> getIndicesForSwf(SWF swf) {
        String swfId = SearchResultsStorage.getSwfId(swf);
        ArrayList res = new ArrayList();
        LinkedHashSet<Integer> foundGroups = new LinkedHashSet<Integer>();
        for (int i = 0; i < this.swfIds.size(); ++i) {
            if (!this.swfIds.get(i).equals(swfId)) continue;
            foundGroups.add(this.groups.get(i));
        }
        return new ArrayList<Integer>(foundGroups);
    }

    public List<ScriptSearchResult> getSearchResultsAt(Set<SWF> allSwfs, int index) {
        ArrayList<ScriptSearchResult> result = new ArrayList<ScriptSearchResult>();
        HashMap<String, SWF> swfIdToSwf = new HashMap<String, SWF>();
        for (SWF s : allSwfs) {
            swfIdToSwf.put(SearchResultsStorage.getSwfId(s), s);
        }
        for (int j = 0; j < this.data.size(); ++j) {
            if (this.groups.get(j) != index || !swfIdToSwf.containsKey(this.swfIds.get(j))) continue;
            if (this.unpackedData.get(j) != null) {
                List<ScriptSearchResult> unpacked = this.unpackedData.get(j);
                for (ScriptSearchResult sr : unpacked) {
                    if (!allSwfs.contains(sr.getSWF())) continue;
                    result.add(sr);
                }
                continue;
            }
            SWF swf = (SWF)swfIdToSwf.get(this.swfIds.get(j));
            byte[] itemData = this.data.get(j);
            ArrayList<Object> currentResults = new ArrayList<Object>();
            try {
                ByteArrayInputStream bais1 = new ByteArrayInputStream(itemData);
                int kind = bais1.read();
                ObjectInputStream ois = new ObjectInputStream(bais1);
                List<byte[]> resultData = SearchResultsStorage.readByteList(ois);
                for (int i = 0; i < resultData.size(); ++i) {
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(resultData.get(i));
                        if (kind == 1) {
                            currentResults.add(new ABCSearchResult(swf, (InputStream)bais));
                        }
                        if (kind != 2) continue;
                        currentResults.add(new ActionSearchResult(swf, (InputStream)bais));
                        continue;
                    }
                    catch (ScriptNotFoundException | IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SearchResultsStorage.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.unpackedData.set(j, currentResults);
            result.addAll(currentResults);
        }
        return result;
    }

    public void load() throws IOException {
        String configFile = SearchResultsStorage.getConfigFile();
        if (new File(configFile).exists()) {
            try (FileInputStream fis = new FileInputStream(configFile);
                 ObjectInputStream ois = new ObjectInputStream(fis);){
                int major = ois.read();
                ois.read();
                if (major != 2) {
                    return;
                }
                this.swfIds = (List)ois.readObject();
                this.searchedValues = (List)ois.readObject();
                this.isIgnoreCase = (List)ois.readObject();
                this.isRegExp = (List)ois.readObject();
                this.groups = (List)ois.readObject();
                this.data = SearchResultsStorage.readByteList(ois);
                int maxgroup = -1;
                for (int g : this.groups) {
                    if (g <= maxgroup) continue;
                    maxgroup = g;
                }
                this.currentGroupId = maxgroup + 1;
                this.unpackedData = new ArrayList<List<ScriptSearchResult>>();
                for (int i = 0; i < this.data.size(); ++i) {
                    this.unpackedData.add(null);
                }
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(SearchResultsStorage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void save() throws IOException {
        String configFile = SearchResultsStorage.getConfigFile();
        try (FileOutputStream fos = new FileOutputStream(configFile);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.write(2);
            oos.write(0);
            oos.writeObject(this.swfIds);
            oos.writeObject(this.searchedValues);
            oos.writeObject(this.isIgnoreCase);
            oos.writeObject(this.isRegExp);
            oos.writeObject(this.groups);
            SearchResultsStorage.writeByteList(oos, this.data);
        }
    }

    public void addABCResults(SWF swf, String searchedString, boolean ignoreCase, boolean regExp, List<ABCSearchResult> results) {
        this.swfIds.add(SearchResultsStorage.getSwfId(swf));
        this.searchedValues.add(searchedString);
        this.isIgnoreCase.add(ignoreCase);
        this.isRegExp.add(regExp);
        this.groups.add(this.currentGroupId);
        this.unpackedData.add(new ArrayList<ABCSearchResult>(results));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            ArrayList<byte[]> resultData = new ArrayList<byte[]>();
            for (ABCSearchResult res : results) {
                ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
                res.save((OutputStream)resultBaos);
                resultData.add(resultBaos.toByteArray());
            }
            SearchResultsStorage.writeByteList(oos, resultData);
            oos.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(SearchResultsStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.data.add(baos.toByteArray());
    }

    public void addActionResults(SWF swf, String searchedString, boolean ignoreCase, boolean regExp, List<ActionSearchResult> results) {
        this.swfIds.add(SearchResultsStorage.getSwfId(swf));
        this.searchedValues.add(searchedString);
        this.isIgnoreCase.add(ignoreCase);
        this.isRegExp.add(regExp);
        this.groups.add(this.currentGroupId);
        this.unpackedData.add(new ArrayList<ActionSearchResult>(results));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(2);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            ArrayList<byte[]> resultData = new ArrayList<byte[]>();
            for (ActionSearchResult res : results) {
                ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
                res.save((OutputStream)resultBaos);
                resultData.add(resultBaos.toByteArray());
            }
            SearchResultsStorage.writeByteList(oos, resultData);
            oos.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(SearchResultsStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.data.add(baos.toByteArray());
    }

    public void clear() {
        this.swfIds.clear();
        this.searchedValues.clear();
        this.isIgnoreCase.clear();
        this.isRegExp.clear();
        this.groups.clear();
        this.data.clear();
        this.unpackedData.clear();
    }

    public void clearForSwf(SWF swf) {
        String swfId = SearchResultsStorage.getSwfId(swf);
        for (int i = 0; i < this.swfIds.size(); ++i) {
            if (!this.swfIds.get(i).equals(swfId)) continue;
            this.swfIds.remove(i);
            this.searchedValues.remove(i);
            this.isIgnoreCase.remove(i);
            this.isRegExp.remove(i);
            this.groups.remove(i);
            this.data.remove(i);
            this.unpackedData.remove(i);
            --i;
        }
    }

    private static void writeByteList(ObjectOutputStream os, List<byte[]> data) throws IOException {
        os.writeInt(data.size());
        for (byte[] d : data) {
            os.writeInt(d.length);
            os.write(d);
        }
    }

    private static List<byte[]> readByteList(ObjectInputStream ois) throws IOException {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        int cnt = ois.readInt();
        for (int i = 0; i < cnt; ++i) {
            int len = ois.readInt();
            byte[] buf = new byte[len];
            ois.readFully(buf);
            ret.add(buf);
        }
        return ret;
    }

    public void destroySwf(SWF swf) {
        String swfId = SearchResultsStorage.getSwfId(swf);
        for (int i = 0; i < this.swfIds.size(); ++i) {
            if (!this.swfIds.get(i).equals(swfId)) continue;
            this.unpackedData.set(i, null);
        }
    }
}

