/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.ComboBoxItem;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ReplaceCharacterDialog
extends AppDialog {
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JComboBox<ComboBoxItem<Integer>> charactersComboBox = new JComboBox();
    private int result = -1;

    public ReplaceCharacterDialog(Window owner) {
        super(owner);
        this.setSize(400, 150);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(this.translate("replace.width")), "North");
        this.charactersComboBox.setPreferredSize(new Dimension(400, this.charactersComboBox.getPreferredSize().height));
        this.add(this.charactersComboBox, "Center");
        JPanel panButtons = new JPanel(new FlowLayout());
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        panButtons.add(this.okButton);
        panButtons.add(this.cancelButton);
        this.add((Component)panButtons, "South");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        View.setWindowIcon(this);
        this.setTitle(this.translate("dialog.title"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        View.centerScreen(this);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public Integer getCharacterId() {
        if (this.result == -1) {
            return null;
        }
        ComboBoxItem item = (ComboBoxItem)this.charactersComboBox.getSelectedItem();
        return (Integer)item.getValue();
    }

    public int showDialog(SWF swf, int selectedCharacterId) {
        Map characters = swf.getCharacters();
        for (Integer key : characters.keySet()) {
            CharacterTag character = (CharacterTag)characters.get(key);
            int characterId = character.getCharacterId();
            if (characterId == selectedCharacterId) continue;
            this.charactersComboBox.addItem(new ComboBoxItem<Integer>(character.getName(), characterId));
        }
        this.setVisible(true);
        return this.result;
    }
}

